from awsdeployer.status import Common, Standard, Extended


__dict = {
    201: Common.Created,
    202: Common.Accepted,
    204: Common.NoContent,
    400: Common.BadRequest,
    401: Common.Unauthorized,
    403: Common.Forbidden,
    404: Common.NotFound,
    406: Common.NotAcceptable,
    409: Common.Conflict,
    500: Common.InternalServerError,
    203: Standard.NonAuthoritativeInformation,
    205: Standard.ResetContent,
    206: Standard.PartialContent,
    207: Standard.MultiStatus,
    208: Standard.AlreadyReported,
    226: Standard.IMUsed,
    300: Standard.MultipleChoices,
    301: Standard.MovedPermanently,
    302: Standard.Found,
    303: Standard.SeeOther,
    304: Standard.NotModified,
    305: Standard.UseProxy,
    306: Standard.SwitchProxy,
    307: Standard.TemporaryRedirect,
    308: Standard.PermanentRedirect,
    402: Standard.PaymentRequired,
    405: Standard.MethodNotAllowed,
    407: Standard.ProxyAuthenticationRequired,
    408: Standard.RequestTimeout,
    410: Standard.Gone,
    411: Standard.LengthRequired,
    412: Standard.PreconditionFailed,
    413: Standard.PayloadTooLarge,
    414: Standard.URITooLong,
    415: Standard.UnsupportedMediaType,
    416: Standard.RangeNotSatisfiable,
    417: Standard.ExpectationFailed,
    418: Standard.ImATeapot,
    421: Standard.MisdirectedRequest,
    422: Standard.UnprocessableEntity,
    423: Standard.Locked,
    424: Standard.FailedDependency,
    425: Standard.TooEarly,
    426: Standard.UpgradeRequired,
    428: Standard.PreconditionRequired,
    429: Standard.TooManyRequests,
    431: Standard.RequestHeaderFieldsTooLarge,
    451: Standard.UnavailableForLegalReasons,
    501: Standard.NotImplemented,
    503: Standard.ServiceUnavailable,
    504: Standard.GatewayTimeout,
    505: Standard.HTTPVersionNotSupported,
    506: Standard.VariantAlsoNegotiates,
    507: Standard.InsufficientStorage,
    508: Standard.LoopDetected,
    510: Standard.NotExtended,
    511: Standard.NetworkAuthenticationRequired,
    218: Extended.ThisIsFine,
    419: Extended.PageExpired,
    420: Extended.EnhanceYourCalm,
    430: Extended.ShopifyRequestHeaderFieldsTooLarge,
    450: Extended.BlockedbyWindowsParentalControls,
    509: Extended.BandwidthLimitExceeded,
    526: Extended.InvalidSSLCertificate,
    529: Extended.SiteIsoverloaded,
    598: Extended.Networkreadtimeouterror,
    440: Extended.IISLoginTimeOut,
    449: Extended.IISRetryWith,
    444: Extended.NginxNoResponse,
    494: Extended.NginxRequestheadertoolarge,
    495: Extended.NginxSSLCertificateError,
    496: Extended.NginxSSLCertificateRequired,
    497: Extended.NginxHTTPRequestSenttoHTTPSPort,
    499: Extended.NginxClientClosedRequest,
    520: Extended.CloudflareWebServerReturnedanUnknownError,
    521: Extended.CloudflareWebServerIsDown,
    522: Extended.CloudflareConnectionTimedOut,
    523: Extended.CloudflareOriginIsUnreachable,
    524: Extended.CloudflareATimeoutOccurred,
    525: Extended.CloudflareSSLHandshakeFailed,
    527: Extended.CloudflareRailgunError,
    530: Extended.CloudflareThousandError,
    460: Extended.AWSClientClosed,
    463: Extended.AWSTooManyIps,

    'Created': Common.Created,
    'Accepted': Common.Accepted,
    'NoContent': Common.NoContent,
    'BadRequest': Common.BadRequest,
    'Unauthorized': Common.Unauthorized,
    'Forbidden': Common.Forbidden,
    'NotFound': Common.NotFound,
    'NotAcceptable': Common.NotAcceptable,
    'Conflict': Common.Conflict,
    'InternalServerError': Common.InternalServerError,
    'NonAuthoritativeInformation': Standard.NonAuthoritativeInformation,
    'ResetContent': Standard.ResetContent,
    'PartialContent': Standard.PartialContent,
    'MultiStatus': Standard.MultiStatus,
    'AlreadyReported': Standard.AlreadyReported,
    'IMUsed': Standard.IMUsed,
    'MultipleChoices': Standard.MultipleChoices,
    'MovedPermanently': Standard.MovedPermanently,
    'Found': Standard.Found,
    'SeeOther': Standard.SeeOther,
    'NotModified': Standard.NotModified,
    'UseProxy': Standard.UseProxy,
    'SwitchProxy': Standard.SwitchProxy,
    'TemporaryRedirect': Standard.TemporaryRedirect,
    'PermanentRedirect': Standard.PermanentRedirect,
    'PaymentRequired': Standard.PaymentRequired,
    'MethodNotAllowed': Standard.MethodNotAllowed,
    'ProxyAuthenticationRequired': Standard.ProxyAuthenticationRequired,
    'RequestTimeout': Standard.RequestTimeout,
    'Gone': Standard.Gone,
    'LengthRequired': Standard.LengthRequired,
    'PreconditionFailed': Standard.PreconditionFailed,
    'PayloadTooLarge': Standard.PayloadTooLarge,
    'URITooLong': Standard.URITooLong,
    'UnsupportedMediaType': Standard.UnsupportedMediaType,
    'RangeNotSatisfiable': Standard.RangeNotSatisfiable,
    'ExpectationFailed': Standard.ExpectationFailed,
    'ImATeapot': Standard.ImATeapot,
    'MisdirectedRequest': Standard.MisdirectedRequest,
    'UnprocessableEntity': Standard.UnprocessableEntity,
    'Locked': Standard.Locked,
    'FailedDependency': Standard.FailedDependency,
    'TooEarly': Standard.TooEarly,
    'UpgradeRequired': Standard.UpgradeRequired,
    'PreconditionRequired': Standard.PreconditionRequired,
    'TooManyRequests': Standard.TooManyRequests,
    'RequestHeaderFieldsTooLarge': Standard.RequestHeaderFieldsTooLarge,
    'UnavailableForLegalReasons': Standard.UnavailableForLegalReasons,
    'NotImplemented': Standard.NotImplemented,
    'ServiceUnavailable': Standard.ServiceUnavailable,
    'GatewayTimeout': Standard.GatewayTimeout,
    'HTTPVersionNotSupported': Standard.HTTPVersionNotSupported,
    'VariantAlsoNegotiates': Standard.VariantAlsoNegotiates,
    'InsufficientStorage': Standard.InsufficientStorage,
    'LoopDetected': Standard.LoopDetected,
    'NotExtended': Standard.NotExtended,
    'NetworkAuthenticationRequired': Standard.NetworkAuthenticationRequired,
    'ThisIsFine': Extended.ThisIsFine,
    'PageExpired': Extended.PageExpired,
    'EnhanceYourCalm': Extended.EnhanceYourCalm,
    'ShopifyRequestHeaderFieldsTooLarge': Extended.ShopifyRequestHeaderFieldsTooLarge,
    'BlockedbyWindowsParentalControls': Extended.BlockedbyWindowsParentalControls,
    'BandwidthLimitExceeded': Extended.BandwidthLimitExceeded,
    'InvalidSSLCertificate': Extended.InvalidSSLCertificate,
    'SiteIsoverloaded': Extended.SiteIsoverloaded,
    'Networkreadtimeouterror': Extended.Networkreadtimeouterror,
    'IISLoginTimeOut': Extended.IISLoginTimeOut,
    'IISRetryWith': Extended.IISRetryWith,
    'NginxNoResponse': Extended.NginxNoResponse,
    'NginxRequestheadertoolarge': Extended.NginxRequestheadertoolarge,
    'NginxSSLCertificateError': Extended.NginxSSLCertificateError,
    'NginxSSLCertificateRequired': Extended.NginxSSLCertificateRequired,
    'NginxHTTPRequestSenttoHTTPSPort': Extended.NginxHTTPRequestSenttoHTTPSPort,
    'NginxClientClosedRequest': Extended.NginxClientClosedRequest,
    'CloudflareWebServerReturnedanUnknownError': Extended.CloudflareWebServerReturnedanUnknownError,
    'CloudflareWebServerIsDown': Extended.CloudflareWebServerIsDown,
    'CloudflareConnectionTimedOut': Extended.CloudflareConnectionTimedOut,
    'CloudflareOriginIsUnreachable': Extended.CloudflareOriginIsUnreachable,
    'CloudflareATimeoutOccurred': Extended.CloudflareATimeoutOccurred,
    'CloudflareSSLHandshakeFailed': Extended.CloudflareSSLHandshakeFailed,
    'CloudflareRailgunError': Extended.CloudflareRailgunError,
    'CloudflareThousandError': Extended.CloudflareThousandError,
    'AWSClientClosed': Extended.AWSClientClosed,
    'AWSTooManyIps': Extended.AWSTooManyIps
}


def code(status_code):
    return __dict.get(status_code)
