# coding: utf-8

"""
    Hydrogen Admin API

    The Hydrogen Admin API  # noqa: E501

    OpenAPI spec version: 1.0.2
    Contact: info@hydrogenplatform.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from admin_api.api_client import ApiClient
from admin_api.auth_api import AuthApi


class ClientApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None, auth_api=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client
        if auth_api is None:
            auth_api = AuthApi(self.api_client)
        self.auth_api = auth_api
    def create_client_using_post(self, client_request, appTokenConfig, **kwargs):  # noqa: E501
        """Create a client  # noqa: E501

        Create a new client, or register a new user, with your firm.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_client_using_post(client_request, appTokenConfig, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Client client_request: clientRequest (required)
        :return: Client
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_client_using_post_with_http_info(client_request, appTokenConfig, **kwargs)  # noqa: E501
        else:
            (data) = self.create_client_using_post_with_http_info(client_request, appTokenConfig,  **kwargs)  # noqa: E501
            return data

    def create_client_using_post_with_http_info(self, client_request, appTokenConfig, **kwargs):  # noqa: E501
        """Create a client  # noqa: E501

        Create a new client, or register a new user, with your firm.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_client_using_post_with_http_info(client_request, appTokenConfig, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Client client_request: clientRequest (required)
        :return: Client
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['client_request']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        if appTokenConfig['basePath'] is None:
            raise TypeError("Missing the required parameter 'basePath'")
        self.api_client.configuration.host = appTokenConfig['basePath']
        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_client_using_post" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'client_request' is set
        if self.api_client.client_side_validation and ('client_request' not in params or
                                                       params['client_request'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `client_request` when calling `create_client_using_post`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'client_request' in params:
            body_params = params['client_request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501
        authType = appTokenConfig['authType']
        if(authType is not None and authType.lower() == "client_credentials"):
            auth_api_cc_response = self.auth_api.create_using_post_client_credentials(appTokenConfig['clientId'], appTokenConfig['clientSecret'])
            self.api_client.configuration.access_token = auth_api_cc_response.access_token
        elif (authType is not None and authType.lower() == "password_credentials"):
            auth_api_cc_response = self.auth_api.create_using_post_password_credentials(appTokenConfig['clientId'], appTokenConfig['clientSecret'], appTokenConfig['username'], appTokenConfig['password'])
            self.api_client.configuration.access_token = auth_api_cc_response.access_token
        elif (authType is not None and authType.lower() == "client_token_credentials"):
            auth_api_cc_response = self.auth_api.create_client_token_credentials(appTokenConfig['clientId'], appTokenConfig['clientSecret'], appTokenConfig['clientToken'])
            self.api_client.configuration.access_token = auth_api_cc_response.access_token
        return self.api_client.call_api(
            '/nucleus/v1/client', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Client',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_client_all_using_get(self, appTokenConfig, **kwargs):  # noqa: E501
        """List all clients  # noqa: E501

        Get details for all clients registered with your firm.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_client_all_using_get(appTokenConfig, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param bool ascending: ascending
        :param str filter: filter
        :param str order_by: order_by
        :param int page: page
        :param int size: size
        :return: PageClient
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_client_all_using_get_with_http_info(appTokenConfig, **kwargs)  # noqa: E501
        else:
            (data) = self.get_client_all_using_get_with_http_info(appTokenConfig, **kwargs)  # noqa: E501
            return data

    def get_client_all_using_get_with_http_info(self, appTokenConfig, **kwargs):  # noqa: E501
        """List all clients  # noqa: E501

        Get details for all clients registered with your firm.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_client_all_using_get_with_http_info(appTokenConfig, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param bool ascending: ascending
        :param str filter: filter
        :param str order_by: order_by
        :param int page: page
        :param int size: size
        :return: PageClient
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['ascending', 'filter', 'order_by', 'page', 'size']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        if appTokenConfig['basePath'] is None:
            raise TypeError("Missing the required parameter 'basePath'")
        self.api_client.configuration.host = appTokenConfig['basePath']
        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_client_all_using_get" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'ascending' in params:
            query_params.append(('ascending', params['ascending']))  # noqa: E501
        if 'filter' in params:
            query_params.append(('filter', params['filter']))  # noqa: E501
        if 'order_by' in params:
            query_params.append(('order_by', params['order_by']))  # noqa: E501
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501
        if 'size' in params:
            query_params.append(('size', params['size']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501
        authType = appTokenConfig['authType']
        if(authType is not None and authType.lower() == "client_credentials"):
            auth_api_cc_response = self.auth_api.create_using_post_client_credentials(appTokenConfig['clientId'], appTokenConfig['clientSecret'])
            self.api_client.configuration.access_token = auth_api_cc_response.access_token
        elif (authType is not None and authType.lower() == "password_credentials"):
            auth_api_cc_response = self.auth_api.create_using_post_password_credentials(appTokenConfig['clientId'], appTokenConfig['clientSecret'], appTokenConfig['username'], appTokenConfig['password'])
            self.api_client.configuration.access_token = auth_api_cc_response.access_token
        elif (authType is not None and authType.lower() == "client_token_credentials"):
            auth_api_cc_response = self.auth_api.create_client_token_credentials(appTokenConfig['clientId'], appTokenConfig['clientSecret'], appTokenConfig['clientToken'])
            self.api_client.configuration.access_token = auth_api_cc_response.access_token
        return self.api_client.call_api(
            '/nucleus/v1/client', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PageClient',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_client_using_get(self, client_id, appTokenConfig, **kwargs):  # noqa: E501
        """Retrieve a client  # noqa: E501

        Retrieve the information for a client registered with your firm.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_client_using_get(client_id, appTokenConfig, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str client_id: UUID client_id (required)
        :return: Client
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_client_using_get_with_http_info(client_id, appTokenConfig, **kwargs)  # noqa: E501
        else:
            (data) = self.get_client_using_get_with_http_info(client_id, appTokenConfig, **kwargs)  # noqa: E501
            return data

    def get_client_using_get_with_http_info(self, client_id, appTokenConfig, **kwargs):  # noqa: E501
        """Retrieve a client  # noqa: E501

        Retrieve the information for a client registered with your firm.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_client_using_get_with_http_info(client_id, appTokenConfig, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str client_id: UUID client_id (required)
        :return: Client
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['client_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        if appTokenConfig['basePath'] is None:
            raise TypeError("Missing the required parameter 'basePath'")
        self.api_client.configuration.host = appTokenConfig['basePath']

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_client_using_get" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'client_id' is set
        if self.api_client.client_side_validation and ('client_id' not in params or
                                                       params['client_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `client_id` when calling `get_client_using_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'client_id' in params:
            path_params['client_id'] = params['client_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501
        authType = appTokenConfig['authType']
        if(authType is not None and authType.lower() == "client_credentials"):
            auth_api_cc_response = self.auth_api.create_using_post_client_credentials(appTokenConfig['clientId'], appTokenConfig['clientSecret'])
            self.api_client.configuration.access_token = auth_api_cc_response.access_token
        elif (authType is not None and authType.lower() == "password_credentials"):
            auth_api_cc_response = self.auth_api.create_using_post_password_credentials(appTokenConfig['clientId'], appTokenConfig['clientSecret'], appTokenConfig['username'], appTokenConfig['password'])
            self.api_client.configuration.access_token = auth_api_cc_response.access_token
        elif (authType is not None and authType.lower() == "client_token_credentials"):
            auth_api_cc_response = self.auth_api.create_client_token_credentials(appTokenConfig['clientId'], appTokenConfig['clientSecret'], appTokenConfig['clientToken'])
            self.api_client.configuration.access_token = auth_api_cc_response.access_token
        return self.api_client.call_api(
            '/nucleus/v1/client/{client_id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Client',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_client_using_put(self, client, client_id, appTokenConfig, **kwargs):  # noqa: E501
        """Update a client  # noqa: E501

        Update the information for a client registered with your firm.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_client_using_put(client, client_id, appTokenConfig, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param object client: client (required)
        :param str client_id: UUID client_id (required)
        :return: Client
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_client_using_put_with_http_info(client, client_id, appTokenConfig, **kwargs)  # noqa: E501
        else:
            (data) = self.update_client_using_put_with_http_info(client, client_id, appTokenConfig, **kwargs)  # noqa: E501
            return data

    def update_client_using_put_with_http_info(self, client, client_id, appTokenConfig, **kwargs):  # noqa: E501
        """Update a client  # noqa: E501

        Update the information for a client registered with your firm.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_client_using_put_with_http_info(client, client_id, appTokenConfig, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param object client: client (required)
        :param str client_id: UUID client_id (required)
        :return: Client
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['client', 'client_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        if appTokenConfig['basePath'] is None:
            raise TypeError("Missing the required parameter 'basePath'")
        self.api_client.configuration.host = appTokenConfig['basePath']
        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_client_using_put" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'client' is set
        if self.api_client.client_side_validation and ('client' not in params or
                                                       params['client'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `client` when calling `update_client_using_put`")  # noqa: E501
        # verify the required parameter 'client_id' is set
        if self.api_client.client_side_validation and ('client_id' not in params or
                                                       params['client_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `client_id` when calling `update_client_using_put`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'client_id' in params:
            path_params['client_id'] = params['client_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'client' in params:
            body_params = params['client']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501
        authType = appTokenConfig['authType']
        if(authType is not None and authType.lower() == "client_credentials"):
            auth_api_cc_response = self.auth_api.create_using_post_client_credentials(appTokenConfig['clientId'], appTokenConfig['clientSecret'])
            self.api_client.configuration.access_token = auth_api_cc_response.access_token
        elif (authType is not None and authType.lower() == "password_credentials"):
            auth_api_cc_response = self.auth_api.create_using_post_password_credentials(appTokenConfig['clientId'], appTokenConfig['clientSecret'], appTokenConfig['username'], appTokenConfig['password'])
            self.api_client.configuration.access_token = auth_api_cc_response.access_token
        elif (authType is not None and authType.lower() == "client_token_credentials"):
            auth_api_cc_response = self.auth_api.create_client_token_credentials(appTokenConfig['clientId'], appTokenConfig['clientSecret'], appTokenConfig['clientToken'])
            self.api_client.configuration.access_token = auth_api_cc_response.access_token
        return self.api_client.call_api(
            '/nucleus/v1/client/{client_id}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Client',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
