# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['amqp_client_python',
 'amqp_client_python.domain.models',
 'amqp_client_python.event',
 'amqp_client_python.exceptions',
 'amqp_client_python.rabbitmq']

package_data = \
{'': ['*']}

install_requires = \
['pika>=1.3.0,<2.0.0']

setup_kwargs = {
    'name': 'amqp-client-python',
    'version': '0.1.8',
    'description': 'Python AMQP Client Library',
    'long_description': '# AMQP Client Python\n\n[![License][license-image]][license-url]\n<a href="https://pypi.org/project/amqp-client-python" target="_blank">\n    <img src="https://img.shields.io/pypi/v/amqp-client-python?color=%2334D058&label=pypi%20package" alt="Package version">\n</a><a href="https://pypi.org/project/amqp-client-python" target="_blank">\n    <img src="https://img.shields.io/pypi/pyversions/amqp-client-python.svg?color=%2334D058" alt="Supported Python versions">\n</a>\n[![Downloads](https://static.pepy.tech/personalized-badge/amqp-client-python?period=month&units=international_system&left_color=black&right_color=orange&left_text=PyPI%20downloads%20per%20month)](https://pepy.tech/project/amqp-client-python)\n[![Vulnerabilities][known-vulnerabilities-image]][known-vulnerabilities-url]  [![Releases][releases-image]][releases-url] \n\n\n\n\n--------\nClient with high level of abstraction for manipulation of messages in the event bus RabbitMQ.\n\n### Features:\n- Automatic creation and management of queues, exchanges and channels;\n- Connection persistence and auto reconnect;\n- Support for **direct**, **topic** and **fanout** exchanges;\n- Publish;\n- Subscribe;\n- Support for a Remote procedure call _(RPC)_.\n\n\n[//]: # (These are reference links used in the body of this note.)\n[license-image]: https://img.shields.io/badge/license-Apache%202-blue.svg\n[license-url]: https://github.com/nutes-uepb/amqp-client-python/blob/master/LICENSE\n[npm-image]: https://img.shields.io/npm/v/amqp-client-python.svg?color=red&logo=npm\n[npm-url]: https://npmjs.org/package/amqp-client-python\n[downloads-image]: https://img.shields.io/npm/dt/amqp-client-python.svg?logo=npm\n[travis-url]: https://travis-ci.org/nutes-uepb/amqp-client-python\n[coverage-image]: https://coveralls.io/repos/github/nutes-uepb/amqp-client-python/badge.svg\n[coverage-url]: https://coveralls.io/github/nutes-uepb/amqp-client-python?branch=master\n[known-vulnerabilities-image]: https://snyk.io/test/github/nutes-uepb/amqp-client-python/badge.svg?targetFile=requirements.txt\n[known-vulnerabilities-url]: https://snyk.io/test/github/nutes-uepb/amqp-client-python?targetFile=requirements.txt\n[releases-image]: https://img.shields.io/github/release-date/nutes-uepb/amqp-client-python.svg\n[releases-url]: https://github.com/nutes-uepb/amqp-client-python/releases\n\n### Examples:\n#### you can use [sync](https://github.com/nutes-uepb/amqp-client-python/blob/develop/amqp_client_python/rabbitmq/eventbus_rabbitmq.py) , [async eventbus](https://github.com/nutes-uepb/amqp-client-python/blob/develop/amqp_client_python/rabbitmq/async_eventbus_rabbitmq.py) and [sync wrapper](https://github.com/nutes-uepb/amqp-client-python/blob/develop/amqp_client_python/rabbitmq/eventbus_wrapper_rabbitmq.py) of async eventbus\n<details><summary>async usage </summary>\n\n<br>\n\n```Python\n# basic configuration\nfrom amqp_client_python import (\n    AsyncEventbusRabbitMQ,\n    Config, Options\n)\nfrom amqp_client_python.event import IntegrationEvent, IntegrationEventHandler\nconfig = Config(Options("queue", "rpc_queue", "rpc_exchange"))\neventbus = AsyncEventbusRabbitMQ(config)\n# publish\nclass ExampleEvent(IntegrationEvent):\n    EVENT_NAME: str = "ExampleEvent"\n    def __init__(self, event_type: str, message = []) -> None:\n        super().__init__(self.EVENT_NAME, event_type)\n        self.message = message\n\npublish_event = ExampleEvent(rpc_exchange, ["message"])\neventbus.publish(publish_event, rpc_routing_key, "direct")\n# subscribe\nclass ExampleEventHandler(IntegrationEventHandler):\n    def handle(self, body) -> None:\n        print(body) # handle messages\nawait eventbus.subscribe(subscribe_event, subscribe_event_handle, rpc_routing_key)\n# rpc_publish\nresponse = await eventbus.rpc_client(rpc_exchange, "user.find", ["content_message"])\n# provider\nasync def handle2(*body) -> bytes:\n    print(f"body: {body}")\n    return b"content"\nawait eventbus.provide_resource("user.find", handle)\n```\n</details>\n\n<details><summary>sync usage</summary>\n\n```Python\nfrom amqp_client_python import (\n    EventbusRabbitMQ,\n    Config, Options\n)\nfrom amqp_client_python.event import IntegrationEvent, IntegrationEventHandler\nfrom examples.default import queue, rpc_queue, rpc_exchange, rpc_routing_key\n\n\nclass ExampleEvent(IntegrationEvent):\n    EVENT_NAME: str = "ExampleEvent"\n    ROUTING_KEY: str = rpc_routing_key\n\n    def __init__(self, event_type: str, message = []) -> None:\n        super().__init__(self.EVENT_NAME, event_type)\n        self.message = message\n        self.routing_key = self.ROUTING_KEY\n\n\nclass ExampleEventHandler(IntegrationEventHandler):\n    def handle(self, body) -> None:\n        print(body,"subscribe")\n\n\nconfig = Config(Options(queue, rpc_queue, rpc_exchange))\neventbus = EventbusRabbitMQ(config=config)\n\nclass ExampleEvent(IntegrationEvent):\n    EVENT_NAME: str = "ExampleEvent"\n    def __init__(self, event_type: str, message = []) -> None:\n        super().__init__(self.EVENT_NAME, event_type)\n        self.message = message\n\nfrom time import sleep\nfrom random import randint\ndef handle(*body):\n    print(body[0], "rpc_provider")\n    return f"{body[0]}".encode("utf-8")\n\nsubscribe_event = ExampleEvent(rpc_exchange)\npublish_event = ExampleEvent(rpc_exchange, ["message"])\nsubscribe_event_handle = ExampleEventHandler()\neventbus.subscribe(subscribe_event, subscribe_event_handle, rpc_routing_key)\neventbus.provide_resource(rpc_routing_key+"2", handle)\ncount = 0\nrunning = True\nfrom concurrent.futures import TimeoutError\nwhile running:\n    try:\n        count += 1\n        if str(count) != eventbus.rpc_client(rpc_exchange, rpc_routing_key+"2", [f"{count}"]).decode("utf-8"):\n            running = False\n        #eventbus.publish(publish_event, rpc_routing_key, "direct")\n        #running = False\n    except TimeoutError as err:\n        print("timeout!!!: ", str(err))\n    except KeyboardInterrupt:\n        running=False\n    except BaseException as err:\n        print("Err:", err)\n```\n</details>\n\n<details><summary>sync wrapper usage</summary>\n\n```Python\nfrom amqp_client_python import EventbusWrapperRabbitMQ, Config, Options\nfrom amqp_client_python.event import IntegrationEvent, IntegrationEventHandler\n\nconfig = Config(Options(queue, rpc_queue, rpc_exchange))\neventbus = EventbusWrapperRabbitMQ(config=config)\n\nclass ExampleEvent(IntegrationEvent):\n    EVENT_NAME: str = "ExampleEvent"\n    def __init__(self, event_type: str, message = []) -> None:\n        super().__init__(self.EVENT_NAME, event_type)\n        self.message = message\nclass ExampleEventHandler(IntegrationEventHandler):\n    async def handle(self, body) -> None:\n        print(body,"subscribe")\n\nasync def handle(*body):\n    print(body[0], "rpc_provider")\n    return f"{body[0]}".encode("utf-8")\n\nsubscribe_event = ExampleEvent(rpc_exchange)\npublish_event = ExampleEvent(rpc_exchange, ["message"])\nsubscribe_event_handle = ExampleEventHandler()\n# rpc_provider\neventbus.provide_resource(rpc_routing_key+"2", handle).result()\n# subscribe\neventbus.subscribe(subscribe_event, subscribe_event_handle, rpc_routing_key).result()\ncount = 0\nrunning = True\nwhile running:\n    try:\n        count += 1\n        # rpc_client call\n        eventbus.rpc_client(rpc_exchange, rpc_routing_key+"2", [f"{count}"]).result().decode("utf-8")\n        # publish\n        eventbus.publish(publish_event, rpc_routing_key, "direct").result()\n        #running = False\n    except KeyboardInterrupt:\n        running=False\n    except BaseException as err:\n        print("Err:", err)\n```\n</details>\n<br />\n\n### Know Limitations:\n#### sync eventbus\n```sh\nCannot use rpc call when inside of rpc provider and subscribe handlers\n#/obs: works on sync eventbus wrapper\n```',
    'author': 'NUTES UEPB',
    'author_email': 'dev.seniorsaudemovel@gmail.com',
    'maintainer': 'None',
    'maintainer_email': 'None',
    'url': 'None',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.7,<4.0',
}


setup(**setup_kwargs)
