/*
 * Decompiled with CFR 0.152.
 */
package it.unibo.tuprolog.solve.stdlib.primitive;

import it.unibo.tuprolog.core.Atom;
import it.unibo.tuprolog.core.Integer;
import it.unibo.tuprolog.core.Numeric;
import it.unibo.tuprolog.core.Struct;
import it.unibo.tuprolog.core.Substitution;
import it.unibo.tuprolog.core.Term;
import it.unibo.tuprolog.core.Var;
import it.unibo.tuprolog.solve.ExecutionContext;
import it.unibo.tuprolog.solve.exception.error.InstantiationError;
import it.unibo.tuprolog.solve.exception.error.TypeError;
import it.unibo.tuprolog.solve.primitive.PrimitiveWrapper;
import it.unibo.tuprolog.solve.primitive.Solve;
import it.unibo.tuprolog.solve.primitive.TernaryRelation;
import it.unibo.tuprolog.unify.Unificator;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.Intrinsics;
import org.gciatto.kt.math.BigInteger;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J*\u0010\u0004\u001a\u00020\u0005*\b\u0012\u0004\u0012\u00020\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\bH\u0014\u00a8\u0006\u000b"}, d2={"Lit/unibo/tuprolog/solve/stdlib/primitive/Functor;", "Lit/unibo/tuprolog/solve/primitive/TernaryRelation$Functional;", "Lit/unibo/tuprolog/solve/ExecutionContext;", "()V", "computeOneSubstitution", "Lit/unibo/tuprolog/core/Substitution;", "Lit/unibo/tuprolog/solve/primitive/Solve$Request;", "first", "Lit/unibo/tuprolog/core/Term;", "second", "third", "solve"})
public final class Functor
extends TernaryRelation.Functional<ExecutionContext> {
    @NotNull
    public static final Functor INSTANCE = new Functor();

    private Functor() {
        super("functor");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    @NotNull
    protected Substitution computeOneSubstitution(@NotNull Solve.Request<? extends ExecutionContext> $this$computeOneSubstitution, @NotNull Term first, @NotNull Term second, @NotNull Term third) {
        Substitution substitution;
        Intrinsics.checkNotNullParameter($this$computeOneSubstitution, "<this>");
        Intrinsics.checkNotNullParameter(first, "first");
        Intrinsics.checkNotNullParameter(second, "second");
        Intrinsics.checkNotNullParameter(third, "third");
        Term term = first;
        if (term instanceof Struct) {
            if (!(third instanceof Var)) {
                PrimitiveWrapper.Companion.ensuringArgumentIsArity($this$computeOneSubstitution, 2);
            }
            substitution = Unificator.Companion.mguWith(second, Atom.Companion.of(((Struct)first).getFunctor())).plus(Unificator.Companion.mguWith(third, Integer.Companion.of(((Struct)first).getArity())));
            return substitution;
        } else if (term instanceof Numeric) {
            if (!(third instanceof Var)) {
                PrimitiveWrapper.Companion.ensuringArgumentIsArity($this$computeOneSubstitution, 2);
            }
            substitution = Unificator.Companion.mguWith(first, second).plus(Unificator.Companion.mguWith(third, Integer.Companion.of(0)));
            return substitution;
        } else {
            if (!(term instanceof Var)) throw TypeError.Companion.forArgument($this$computeOneSubstitution.getContext(), $this$computeOneSubstitution.getSignature(), TypeError.Expected.CALLABLE, first, 0);
            Term term2 = second;
            if (term2 instanceof Atom) {
                PrimitiveWrapper.Companion.ensuringArgumentIsInstantiated($this$computeOneSubstitution, 2);
                PrimitiveWrapper.Companion.ensuringArgumentIsArity($this$computeOneSubstitution, 2);
                substitution = Substitution.Companion.of(TuplesKt.to(first, Struct.Companion.template(((Atom)second).getValue(), ((Integer)third).getIntValue().toInt())), new Pair[0]);
                return substitution;
            } else if (term2 instanceof Numeric) {
                PrimitiveWrapper.Companion.ensuringArgumentIsInstantiated($this$computeOneSubstitution, 2);
                PrimitiveWrapper.Companion.ensuringArgumentIsArity($this$computeOneSubstitution, 2);
                Integer arity = (Integer)third;
                if (!Intrinsics.areEqual(arity.getIntValue(), BigInteger.Companion.getZERO())) throw TypeError.Companion.forArgument($this$computeOneSubstitution.getContext(), $this$computeOneSubstitution.getSignature(), TypeError.Expected.ATOM, second, 1);
                substitution = Substitution.Companion.of(TuplesKt.to(first, second), new Pair[0]).plus(Unificator.Companion.mguWith(third, Integer.Companion.of(0)));
                return substitution;
            } else {
                if (!(term2 instanceof Var)) throw TypeError.Companion.forArgument($this$computeOneSubstitution.getContext(), $this$computeOneSubstitution.getSignature(), TypeError.Expected.ATOMIC, second, 1);
                throw InstantiationError.Companion.forArgument($this$computeOneSubstitution.getContext(), $this$computeOneSubstitution.getSignature(), (Var)second, 1);
            }
        }
    }
}

