/*
 * Decompiled with CFR 0.152.
 */
package it.unibo.tuprolog.core.operators;

import it.unibo.tuprolog.core.Atom;
import it.unibo.tuprolog.core.Conversions;
import it.unibo.tuprolog.core.Integer;
import it.unibo.tuprolog.core.Struct;
import it.unibo.tuprolog.core.Term;
import it.unibo.tuprolog.core.TermConvertible;
import it.unibo.tuprolog.core.Var;
import it.unibo.tuprolog.core.operators.Specifier;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00192\b\u0012\u0004\u0012\u00020\u00000\u00012\u00020\u0002:\u0001\u0019B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0011\u0010\u0010\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u0000H\u0096\u0002J\u0013\u0010\u0012\u001a\u00020\u00132\b\u0010\u0011\u001a\u0004\u0018\u00010\u0014H\u0096\u0002J\b\u0010\u0015\u001a\u00020\bH\u0016J\b\u0010\u0016\u001a\u00020\u0004H\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001a"}, d2={"Lit/unibo/tuprolog/core/operators/Operator;", "", "Lit/unibo/tuprolog/core/TermConvertible;", "functor", "", "specifier", "Lit/unibo/tuprolog/core/operators/Specifier;", "priority", "", "(Ljava/lang/String;Lit/unibo/tuprolog/core/operators/Specifier;I)V", "getFunctor", "()Ljava/lang/String;", "getPriority", "()I", "getSpecifier", "()Lit/unibo/tuprolog/core/operators/Specifier;", "compareTo", "other", "equals", "", "", "hashCode", "toString", "toTerm", "Lit/unibo/tuprolog/core/Struct;", "Companion", "core"})
public final class Operator
implements Comparable<Operator>,
TermConvertible {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String functor;
    @NotNull
    private final Specifier specifier;
    private final int priority;
    @NotNull
    public static final String FUNCTOR = "op";
    @JvmField
    @NotNull
    public static final Struct TEMPLATE;

    public Operator(@NotNull String functor, @NotNull Specifier specifier, int priority) {
        Intrinsics.checkNotNullParameter(functor, "functor");
        Intrinsics.checkNotNullParameter(specifier, "specifier");
        this.functor = functor;
        this.specifier = specifier;
        this.priority = priority;
    }

    @NotNull
    public final String getFunctor() {
        return this.functor;
    }

    @NotNull
    public final Specifier getSpecifier() {
        return this.specifier;
    }

    public final int getPriority() {
        return this.priority;
    }

    @Override
    public int compareTo(@NotNull Operator other) {
        int n;
        Intrinsics.checkNotNullParameter(other, "other");
        if (this.priority > other.priority) {
            n = 1;
        } else if (this.priority < other.priority) {
            n = -1;
        } else {
            int n2 = this.specifier.compareTo((Enum)other.specifier);
            boolean bl = false;
            boolean bl2 = false;
            int specifierCompareTo = n2;
            boolean bl3 = false;
            int n3 = specifierCompareTo;
            n = n3 == 0 ? this.getFunctor().compareTo(other.getFunctor()) : specifierCompareTo;
        }
        return n;
    }

    @Override
    @NotNull
    public Struct toTerm() {
        Term[] termArray = new Term[]{Conversions.toTerm(this.priority), this.specifier.toTerm(), Conversions.toAtom(this.functor)};
        return Struct.Companion.of(FUNCTOR, termArray);
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || !Intrinsics.areEqual(Reflection.getOrCreateKotlinClass(this.getClass()), Reflection.getOrCreateKotlinClass(other.getClass()))) {
            return false;
        }
        Operator cfr_ignored_0 = (Operator)other;
        if (!Intrinsics.areEqual(this.functor, ((Operator)other).functor)) {
            return false;
        }
        return this.specifier == ((Operator)other).specifier;
    }

    public int hashCode() {
        int result2 = this.functor.hashCode();
        result2 = 31 * result2 + this.specifier.hashCode();
        return result2;
    }

    @NotNull
    public String toString() {
        return "Operator(" + this.priority + ", " + this.specifier + ", '" + this.functor + "')";
    }

    @JvmStatic
    @Nullable
    public static final Operator fromTerms(@NotNull Integer priority, @NotNull Atom specifier, @NotNull Atom functor) {
        return Companion.fromTerms(priority, specifier, functor);
    }

    @JvmStatic
    @Nullable
    public static final Operator fromTerm(@NotNull Struct struct) {
        return Companion.fromTerm(struct);
    }

    static {
        Term[] termArray = new Term[]{Var.Companion.of("P"), Var.Companion.of("A"), Var.Companion.of("F")};
        TEMPLATE = Struct.Companion.of(FUNCTOR, termArray);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\u0006H\u0007J\"\u0010\n\u001a\u0004\u0018\u00010\b2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u00020\u00068\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lit/unibo/tuprolog/core/operators/Operator$Companion;", "", "()V", "FUNCTOR", "", "TEMPLATE", "Lit/unibo/tuprolog/core/Struct;", "fromTerm", "Lit/unibo/tuprolog/core/operators/Operator;", "struct", "fromTerms", "priority", "Lit/unibo/tuprolog/core/Integer;", "specifier", "Lit/unibo/tuprolog/core/Atom;", "functor", "core"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @Nullable
        public final Operator fromTerms(@NotNull Integer priority, @NotNull Atom specifier, @NotNull Atom functor) {
            Intrinsics.checkNotNullParameter(priority, "priority");
            Intrinsics.checkNotNullParameter(specifier, "specifier");
            Intrinsics.checkNotNullParameter(functor, "functor");
            Term[] termArray = new Term[]{priority, specifier, functor};
            return this.fromTerm(Struct.Companion.of(Operator.FUNCTOR, termArray));
        }

        @JvmStatic
        @Nullable
        public final Operator fromTerm(@NotNull Struct struct) {
            Operator operator;
            Intrinsics.checkNotNullParameter(struct, "struct");
            boolean bl = false;
            boolean bl2 = false;
            Struct $this$fromTerm_u24lambda_u2d0 = struct;
            boolean bl3 = false;
            if (Intrinsics.areEqual($this$fromTerm_u24lambda_u2d0.getFunctor(), Operator.FUNCTOR) && $this$fromTerm_u24lambda_u2d0.getArity() == 3 && $this$fromTerm_u24lambda_u2d0.getArgAt(0).isInteger() && $this$fromTerm_u24lambda_u2d0.getArgAt(1).isAtom() && $this$fromTerm_u24lambda_u2d0.getArgAt(2).isAtom()) {
                Operator operator2;
                try {
                    operator2 = new Operator($this$fromTerm_u24lambda_u2d0.getArgAt(2).castToAtom().getValue(), Specifier.Companion.fromTerm($this$fromTerm_u24lambda_u2d0.getArgAt(1)), $this$fromTerm_u24lambda_u2d0.getArgAt(0).castToNumeric().getIntValue().toInt());
                }
                catch (IllegalArgumentException ex) {
                    operator2 = null;
                }
                catch (IllegalStateException ex) {
                    operator2 = null;
                }
                operator = operator2;
            } else {
                operator = null;
            }
            return operator;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

