/*
 * Decompiled with CFR 0.152.
 */
package it.unibo.tuprolog.core;

import it.unibo.tuprolog.core.Atom;
import it.unibo.tuprolog.core.ComparisonUtilsKt;
import it.unibo.tuprolog.core.Integer;
import it.unibo.tuprolog.core.Real;
import it.unibo.tuprolog.core.Struct;
import it.unibo.tuprolog.core.Term;
import it.unibo.tuprolog.core.Var;
import java.util.Comparator;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\bf\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u0012\u0012\u0004\u0012\u0002H\u00010\u0003j\b\u0012\u0004\u0012\u0002H\u0001`\u0004:\u0006\u0005\u0006\u0007\b\t\n\u00a8\u0006\u000b"}, d2={"Lit/unibo/tuprolog/core/TermComparator;", "T", "Lit/unibo/tuprolog/core/Term;", "Ljava/util/Comparator;", "Lkotlin/Comparator;", "AtomComparator", "DefaultComparator", "IntegerComparator", "RealComparator", "StructComparator", "VarComparator", "core"})
public interface TermComparator<T extends Term>
extends Comparator<T> {

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u0002H\u0016\u00a8\u0006\b"}, d2={"Lit/unibo/tuprolog/core/TermComparator$AtomComparator;", "Lit/unibo/tuprolog/core/TermComparator;", "Lit/unibo/tuprolog/core/Atom;", "()V", "compare", "", "a", "b", "core"})
    public static final class AtomComparator
    implements TermComparator<Atom> {
        @NotNull
        public static final AtomComparator INSTANCE = new AtomComparator();

        private AtomComparator() {
        }

        @Override
        public int compare(@NotNull Atom a, @NotNull Atom b) {
            Intrinsics.checkNotNullParameter(a, "a");
            Intrinsics.checkNotNullParameter(b, "b");
            return ComparisonUtilsKt.compareStringsLocaleIndependently(a.getValue(), b.getValue());
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u0002H\u0016\u00a8\u0006\b"}, d2={"Lit/unibo/tuprolog/core/TermComparator$VarComparator;", "Lit/unibo/tuprolog/core/TermComparator;", "Lit/unibo/tuprolog/core/Var;", "()V", "compare", "", "a", "b", "core"})
    public static final class VarComparator
    implements TermComparator<Var> {
        @NotNull
        public static final VarComparator INSTANCE = new VarComparator();

        private VarComparator() {
        }

        @Override
        public int compare(@NotNull Var a, @NotNull Var b) {
            Intrinsics.checkNotNullParameter(a, "a");
            Intrinsics.checkNotNullParameter(b, "b");
            return ComparisonUtilsKt.compareStringsLocaleIndependently(a.getCompleteName(), b.getCompleteName());
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u0002H\u0016\u00a8\u0006\b"}, d2={"Lit/unibo/tuprolog/core/TermComparator$RealComparator;", "Lit/unibo/tuprolog/core/TermComparator;", "Lit/unibo/tuprolog/core/Real;", "()V", "compare", "", "a", "b", "core"})
    public static final class RealComparator
    implements TermComparator<Real> {
        @NotNull
        public static final RealComparator INSTANCE = new RealComparator();

        private RealComparator() {
        }

        @Override
        public int compare(@NotNull Real a, @NotNull Real b) {
            Intrinsics.checkNotNullParameter(a, "a");
            Intrinsics.checkNotNullParameter(b, "b");
            return a.getDecimalValue().compareTo(b.getDecimalValue());
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u0002H\u0016\u00a8\u0006\b"}, d2={"Lit/unibo/tuprolog/core/TermComparator$IntegerComparator;", "Lit/unibo/tuprolog/core/TermComparator;", "Lit/unibo/tuprolog/core/Integer;", "()V", "compare", "", "a", "b", "core"})
    public static final class IntegerComparator
    implements TermComparator<Integer> {
        @NotNull
        public static final IntegerComparator INSTANCE = new IntegerComparator();

        private IntegerComparator() {
        }

        @Override
        public int compare(@NotNull Integer a, @NotNull Integer b) {
            Intrinsics.checkNotNullParameter(a, "a");
            Intrinsics.checkNotNullParameter(b, "b");
            return a.getIntValue().compareTo(b.getIntValue());
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u0002H\u0016J\u0018\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\t2\u0006\u0010\u0007\u001a\u00020\u0002H\u0002J\u0018\u0010\n\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u000b2\u0006\u0010\u0007\u001a\u00020\u0002H\u0002J\u0018\u0010\f\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\r2\u0006\u0010\u0007\u001a\u00020\u0002H\u0002J\u0018\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u000f2\u0006\u0010\u0007\u001a\u00020\u0002H\u0002J\u0018\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00112\u0006\u0010\u0007\u001a\u00020\u0002H\u0002\u00a8\u0006\u0012"}, d2={"Lit/unibo/tuprolog/core/TermComparator$DefaultComparator;", "Lit/unibo/tuprolog/core/TermComparator;", "Lit/unibo/tuprolog/core/Term;", "()V", "compare", "", "a", "b", "compareAtomAndTerm", "Lit/unibo/tuprolog/core/Atom;", "compareIntegerAndTerm", "Lit/unibo/tuprolog/core/Integer;", "compareRealAndTerm", "Lit/unibo/tuprolog/core/Real;", "compareStructAndTerm", "Lit/unibo/tuprolog/core/Struct;", "compareVarAndTerm", "Lit/unibo/tuprolog/core/Var;", "core"})
    public static final class DefaultComparator
    implements TermComparator<Term> {
        @NotNull
        public static final DefaultComparator INSTANCE = new DefaultComparator();

        private DefaultComparator() {
        }

        private final int compareVarAndTerm(Var a, Term b) {
            return b.isVar() ? VarComparator.INSTANCE.compare(a, b.castToVar()) : -1;
        }

        private final int compareRealAndTerm(Real a, Term b) {
            return b.isReal() ? RealComparator.INSTANCE.compare(a, b.castToReal()) : (b.isVar() ? 1 : -1);
        }

        private final int compareIntegerAndTerm(Integer a, Term b) {
            return b.isInteger() ? IntegerComparator.INSTANCE.compare(a, b.castToInteger()) : (b.isVar() || b.isReal() ? 1 : -1);
        }

        private final int compareAtomAndTerm(Atom a, Term b) {
            return b.isAtom() ? AtomComparator.INSTANCE.compare(a, b.castToAtom()) : (b.isStruct() ? -1 : 1);
        }

        private final int compareStructAndTerm(Struct a, Term b) {
            return b.isStruct() ? StructComparator.INSTANCE.compare(a, b.castToStruct()) : 1;
        }

        @Override
        public int compare(@NotNull Term a, @NotNull Term b) {
            int n;
            Intrinsics.checkNotNullParameter(a, "a");
            Intrinsics.checkNotNullParameter(b, "b");
            if (a.isVar()) {
                n = this.compareVarAndTerm(a.castToVar(), b);
            } else if (a.isReal()) {
                n = this.compareRealAndTerm(a.castToReal(), b);
            } else if (a.isInteger()) {
                n = this.compareIntegerAndTerm(a.castToInteger(), b);
            } else if (a.isAtom()) {
                n = this.compareAtomAndTerm(a.castToAtom(), b);
            } else if (a.isStruct()) {
                n = this.compareStructAndTerm(a.castToStruct(), b);
            } else {
                throw new IllegalStateException("Cannot compare " + Reflection.getOrCreateKotlinClass(a.getClass()) + " with " + Reflection.getOrCreateKotlinClass(b.getClass()) + ". This is a bug.");
            }
            return n;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u0002H\u0016\u00a8\u0006\b"}, d2={"Lit/unibo/tuprolog/core/TermComparator$StructComparator;", "Lit/unibo/tuprolog/core/TermComparator;", "Lit/unibo/tuprolog/core/Struct;", "()V", "compare", "", "a", "b", "core"})
    public static final class StructComparator
    implements TermComparator<Struct> {
        @NotNull
        public static final StructComparator INSTANCE = new StructComparator();

        private StructComparator() {
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public int compare(@NotNull Struct a, @NotNull Struct b) {
            int n;
            Intrinsics.checkNotNullParameter(a, "a");
            Intrinsics.checkNotNullParameter(b, "b");
            int arityDelta = a.getArity() - b.getArity();
            if (arityDelta == 0) {
                int functorComparison = a.getFunctor().compareTo(b.getFunctor());
                if (functorComparison == 0) {
                    int n2 = 0;
                    int n3 = a.getArity();
                    if (n2 < n3) {
                        do {
                            int i;
                            int ithArgComparison;
                            if ((ithArgComparison = DefaultComparator.INSTANCE.compare(a.get(i = n2++), b.get(i))) == 0) continue;
                            return ithArgComparison;
                        } while (n2 < n3);
                    }
                    return 0;
                }
                n = functorComparison;
            } else {
                void var3_3;
                n = var3_3;
            }
            return n;
        }
    }
}

