import * as kinesis from '@aws-cdk/aws-kinesis';
import * as logs from '@aws-cdk/aws-logs';
import { Construct } from '@aws-cdk/core';
/**
 * Use a Kinesis stream as the destination for a log subscription.
 *
 * @stability stable
 */
export declare class KinesisDestination implements logs.ILogSubscriptionDestination {
    private readonly stream;
    /**
     * @stability stable
     */
    constructor(stream: kinesis.IStream);
    /**
     * Return the properties required to send subscription events to this destination.
     *
     * If necessary, the destination can use the properties of the SubscriptionFilter
     * object itself to configure its permissions to allow the subscription to write
     * to it.
     *
     * The destination may reconfigure its own permissions in response to this
     * function call.
     *
     * @stability stable
     */
    bind(scope: Construct, _sourceLogGroup: logs.ILogGroup): logs.LogSubscriptionDestinationConfig;
}
