"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Endpoint = void 0;
const core_1 = require("@aws-cdk/core");
/**
 * (experimental) Connection endpoint of a redshift cluster.
 *
 * Consists of a combination of hostname and port.
 *
 * @experimental
 */
class Endpoint {
    /**
     * @experimental
     */
    constructor(address, port) {
        this.hostname = address;
        this.port = port;
        const portDesc = core_1.Token.isUnresolved(port) ? core_1.Token.asString(port) : port;
        this.socketAddress = `${address}:${portDesc}`;
    }
}
exports.Endpoint = Endpoint;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiZW5kcG9pbnQuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyJlbmRwb2ludC50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7QUFBQSx3Q0FBc0M7Ozs7Ozs7O0FBT3RDLE1BQWEsUUFBUTs7OztJQWdCbkIsWUFBWSxPQUFlLEVBQUUsSUFBWTtRQUN2QyxJQUFJLENBQUMsUUFBUSxHQUFHLE9BQU8sQ0FBQztRQUN4QixJQUFJLENBQUMsSUFBSSxHQUFHLElBQUksQ0FBQztRQUVqQixNQUFNLFFBQVEsR0FBRyxZQUFLLENBQUMsWUFBWSxDQUFDLElBQUksQ0FBQyxDQUFDLENBQUMsQ0FBQyxZQUFLLENBQUMsUUFBUSxDQUFDLElBQUksQ0FBQyxDQUFDLENBQUMsQ0FBQyxJQUFJLENBQUM7UUFDeEUsSUFBSSxDQUFDLGFBQWEsR0FBRyxHQUFHLE9BQU8sSUFBSSxRQUFRLEVBQUUsQ0FBQztJQUNoRCxDQUFDO0NBQ0Y7QUF2QkQsNEJBdUJDIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IHsgVG9rZW4gfSBmcm9tICdAYXdzLWNkay9jb3JlJztcblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuZXhwb3J0IGNsYXNzIEVuZHBvaW50IHtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICBwdWJsaWMgcmVhZG9ubHkgaG9zdG5hbWU6IHN0cmluZztcblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcHVibGljIHJlYWRvbmx5IHBvcnQ6IG51bWJlcjtcblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHB1YmxpYyByZWFkb25seSBzb2NrZXRBZGRyZXNzOiBzdHJpbmc7XG5cbiAgY29uc3RydWN0b3IoYWRkcmVzczogc3RyaW5nLCBwb3J0OiBudW1iZXIpIHtcbiAgICB0aGlzLmhvc3RuYW1lID0gYWRkcmVzcztcbiAgICB0aGlzLnBvcnQgPSBwb3J0O1xuXG4gICAgY29uc3QgcG9ydERlc2MgPSBUb2tlbi5pc1VucmVzb2x2ZWQocG9ydCkgPyBUb2tlbi5hc1N0cmluZyhwb3J0KSA6IHBvcnQ7XG4gICAgdGhpcy5zb2NrZXRBZGRyZXNzID0gYCR7YWRkcmVzc306JHtwb3J0RGVzY31gO1xuICB9XG59Il19