/*********************************************************************************************************************
 Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.

 Licensed under the Apache License, Version 2.0 (the "License").
 You may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 ******************************************************************************************************************** */
/**
 * Normalize string value to standard identifier form.
 *
 * Removes extraneous prefixes (Amazon, AWS), replaces all non-alphanumerics with underscore (_),
 * and converts to lower-case.
 * @param value - Value to normalize
 * @returns Returns normalized identifier string.
 */
export declare function normalizeIdentifier(value: string): string;
/**
 * Normalizes string value for consistent comparison with variants between systems.
 * @param value - The value to normalize for comparison
 */
export declare function normalizeComparisonString(value: string): string;
/**
 * RegEx pattern for https://aws.amazon.com based urls.
 */
export declare const AWS_URL_PATTERN: RegExp;
/**
 * Parsed Aws Url based on {@link AWS_URL_PATTERN}
 */
export interface ParsedAwsUrl {
    readonly domain: string;
    readonly service: string;
    readonly resource?: string;
    readonly dataType?: string;
    /**
     * @virtual
     */
    readonly code: string;
}
/** Parses https://aws.amazon.com based url into common definition. */
export declare function parseAwsUrl(url: string): ParsedAwsUrl;
