"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.LightTheme = exports.LightPalette = void 0;
/*********************************************************************************************************************
 Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.

 Licensed under the Apache License, Version 2.0 (the "License").
 You may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 ******************************************************************************************************************** */
const types_1 = require("./types");
/** Light theme color palette */
var LightPalette;
(function (LightPalette) {
    LightPalette["WHITE"] = "#FFFFFF";
    LightPalette["BLACK"] = "#000000";
    LightPalette["BLUE"] = "#4472C4";
    LightPalette["LIGHT_BLUE"] = "#5B9BD5";
    LightPalette["ORGANGE"] = "#ED7D31";
    LightPalette["LIGHT_GRAY"] = "#A5A5A5";
    LightPalette["GREEN"] = "#70AD47";
    LightPalette["YELLOW"] = "#FFC000";
    LightPalette["PUBLIC"] = "#E9F3E6";
    LightPalette["PRIVATE"] = "#E6F2F8";
    LightPalette["GENERIC"] = "#EFF0F3";
    LightPalette["PRIMARY"] = "#232F3D";
    LightPalette["SECONDARY"] = "#5A6B86";
})(LightPalette = exports.LightPalette || (exports.LightPalette = {}));
/** Light theme definition */
exports.LightTheme = {
    id: types_1.ThemesEnum.LIGHT,
    backgrounds: {
        base: LightPalette.WHITE,
        private: LightPalette.PRIVATE,
        public: LightPalette.PUBLIC,
        generic: LightPalette.GENERIC,
    },
    text: {
        default: LightPalette.BLACK,
        primary: LightPalette.PRIMARY,
        secondary: LightPalette.SECONDARY,
    },
    groups: {
        cloud: {
            color: "#242F3E",
            bgcolor: false,
            borderColor: "#242F3E",
            borderStyle: "solid",
            iconPng: "theme/light/groups/AWSCloud.png",
        },
        cloudAlt: {
            color: "#242F3E",
            bgcolor: false,
            borderColor: "#242F3E",
            borderStyle: "solid",
            iconPng: "theme/light/groups/Cloud.png",
        },
        region: {
            color: "#127EBA",
            bgcolor: false,
            borderColor: "#127EBA",
            borderStyle: "dotted",
            iconPng: "theme/light/groups/Region.png",
        },
        availabilityZone: {
            color: "#127EBA",
            bgcolor: false,
            borderColor: "#127EBA",
            borderStyle: "dashed",
        },
        securityGroup: {
            color: "#DF3312",
            bgcolor: false,
            borderColor: "#DF3312",
            borderStyle: "solid",
        },
        autoScalingGroup: {
            color: "#D86613",
            bgcolor: false,
            borderColor: "#D86613",
            borderStyle: "dashed",
            iconPng: "theme/light/groups/AutoScalingGroup.png",
        },
        vpc: {
            color: "#3F8624",
            bgcolor: false,
            borderColor: "#3F8624",
            borderStyle: "solid",
            iconPng: "theme/light/groups/VPC.png",
        },
        privateSubnet: {
            color: "#127EBA",
            bgcolor: "#E6F2F8",
            borderColor: "#127EBA",
            borderStyle: "none",
            iconPng: "theme/light/groups/PrivateSubnet.png",
        },
        publicSubnet: {
            color: "#3F8624",
            bgcolor: "#E9F3E6",
            borderColor: "#3F8624",
            borderStyle: "none",
            iconPng: "theme/light/groups/PublicSubnet.png",
        },
        serverContents: {
            color: "#596B85",
            bgcolor: false,
            borderColor: "#596B85",
            borderStyle: "solid",
            iconPng: "theme/light/groups/ServerContents.png",
        },
        corporateDataCenter: {
            color: "#596B85",
            bgcolor: false,
            borderColor: "#596B85",
            borderStyle: "solid",
            iconPng: "theme/light/groups/CorporateDataCenter.png",
        },
        ec2InstanceContents: {
            color: "#D86613",
            bgcolor: false,
            borderColor: "#D86613",
            borderStyle: "solid",
            iconPng: "theme/light/groups/EC2InstanceContents.png",
        },
        spotFleet: {
            color: "#D86613",
            bgcolor: false,
            borderColor: "#D86613",
            borderStyle: "solid",
            iconPng: "theme/light/groups/SpotFleet.png",
        },
        awsAccount: {
            color: "#B0084D",
            bgcolor: false,
            borderColor: "#B0084D",
            borderStyle: "solid",
            iconPng: "theme/light/groups/AWSAccount.png",
        },
        awsIoTGreengrassDeployment: {
            color: "#3F8624",
            bgcolor: false,
            borderColor: "#3F8624",
            borderStyle: "solid",
            iconPng: "theme/light/groups/AWSIoTGreengrassDeployment.png",
        },
        awsIoTGreengrass: {
            color: "#3F8624",
            bgcolor: false,
            borderColor: "#3F8624",
            borderStyle: "solid",
            iconPng: "theme/light/groups/AWSIoTGreengrass.png",
        },
        elasticBeanstalkContainer: {
            color: "#D86613",
            bgcolor: false,
            borderColor: "#D86613",
            borderStyle: "solid",
            iconPng: "theme/light/groups/ElasticBeanstalkContainer.png",
        },
        awsStepFunctionsWorkflow: {
            color: "#CD2264",
            bgcolor: false,
            borderColor: "#CD2264",
            borderStyle: "solid",
            iconPng: "theme/light/groups/AWSStepFunctionsWorkflow.png",
        },
        generic: {
            color: "#5A6B86",
            bgcolor: false,
            borderColor: "#5A6B86",
            borderStyle: "dashed",
        },
        genericAlt: {
            color: "#000000",
            bgcolor: "#EFF0F3",
            borderColor: false,
            borderStyle: "none",
        },
    },
    arrows: {
        default: {
            color: LightPalette.LIGHT_GRAY,
            head: "none",
            tail: "normal",
            width: 0.75,
            style: "solid",
        },
        child: {
            color: LightPalette.LIGHT_GRAY,
            tail: "none",
            head: "normal",
            width: 1,
            style: "solid",
        },
        reference: {
            color: LightPalette.ORGANGE,
            tail: "inv",
            head: "dot",
            width: 0.75,
            style: "solid",
        },
        dependency: {
            color: LightPalette.BLUE,
            tail: "invodot",
            head: "odot",
            width: 0.75,
            style: "dotted",
        },
    },
};
//# sourceMappingURL=data:application/json;base64,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