"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.NORMALIZED_SERVICE_VARIANTS = void 0;
/** Mapping of service variants to asset key service name */
exports.NORMALIZED_SERVICE_VARIANTS = {
    alexa_for_business: ["ask"],
    api_gateway: ["apigateway", "apigatewayv2"],
    application_discovery_service: ["appintegrations", "servicediscovery"],
    aps: ["managed_service_for_prometheus"],
    certificate_manager: ["acmpca"],
    cloudwatch: ["applicationinsights", "evidently", "logs", "rum", "synthetics"],
    console_mobile_application: ["mobile_hub"],
    connect: ["customerprofiles", "voiceid", "wisdom"],
    cost_and_usage_report: ["cur"],
    cost_explorer: ["ce"],
    data_exchange: ["dax"],
    database_migration_service: ["dms"],
    documentdb: ["docdb"],
    ec2: ["imagebuilder"],
    efs: ["elastic_file_system"],
    ebs: ["elastic_block_store", "dlm"],
    ecr: ["elastic_container_registry"],
    ecs: ["elastic_container_service", "ecs_service"],
    eks: ["elastic_kubernetes_service"],
    eventbridge: ["eventschemas", "events"],
    express_workflows: ["express_workflow"],
    fault_injection_simulator: ["fis"],
    firewall_manager: ["fms"],
    glue_databrew: ["databrew", "gluedatabrewinteractivesessions"],
    iam_identity_center: ["sso", "single_sign_on"],
    iam: [
        "identity_and_access_management",
        "identity_access_management",
        "rolesanywhere",
        "accessanalyzer",
    ],
    inspector: ["inspectorv2"],
    interactive_video_service: ["ivs"],
    iot_core: ["iot", "iotwireless"],
    iot_device_management: ["iotfleethub"],
    iot_greengrass: ["greengrass", "greengrassv2"],
    key_management_service: ["kms"],
    keyspaces: ["cassandra", "managed_apache_cassandra_service"],
    kinesis_data_analytics: ["kinesisanalytics", "kinesisanalyticsv2"],
    kinesis_data_streams: ["kinesis"],
    kinesis_firehose: ["firehose"],
    kinesis_video_streams: ["kinesisvideo"],
    location_service: ["location"],
    mainframe_modernization: ["m2"],
    managed_blockchain: ["qldb"],
    managed_grafana: ["managed_service_for_grafana"],
    memorydb_for_redis: ["memorydb"],
    migration_hub: ["refactorspaces"],
    msk: [
        "managed_streaming_for_apache_kafka",
        "managed_streaming_for_kafka",
        "kafkaconnect",
        "kafka",
    ],
    mwaa: [
        "managed_workflows_for_apache_airflow",
        "managed_workflows_for_airflow",
        "airflow",
    ],
    opensearch: [
        "opensearch_service",
        "opensearch",
        "elasticsearch",
        "elasticsearch_service",
    ],
    outposts_rack: ["outposts_1u_and_2u_servers"],
    quantum_ledger_database: ["qldb"],
    pinpoint: ["pinpointemail"],
    resource_access_manager: ["ram"],
    s3_glacier: ["simple_storage_service_glacier", "glacier"],
    s3: ["simple_storage_service"],
    serverless_application_repository: ["serverless", "serverlessdiscovery"],
    ses: ["simple_email_service"],
    sns: ["simple_notification_service"],
    sqs: ["simple_queue_service"],
    ssm: ["systems_manager", "resourcegroups"],
    transfer_family: ["transfer"],
    vpc: ["virtual_private_cloud", "networkmanager"],
    well_architected_tool: ["well_architect_tool"],
    network_firewall: ["fms", "networkfirewall"],
};
//# sourceMappingURL=data:application/json;base64,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