/*********************************************************************************************************************
 Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.

 Licensed under the Apache License, Version 2.0 (the "License").
 You may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 ******************************************************************************************************************** */
import { AwsAsset } from "../../generated/assets";
/** @internal */
export declare function resolveServiceName(value: string): AwsAsset.Service;
/**
 * Extracted service name definition
 * @internal
 */
export interface ExtractedServiceName {
    readonly serviceName: AwsAsset.Service;
    readonly match: string;
    readonly rest?: string;
    readonly resolvedValue: string;
}
/**
 * Extract service name parts from value that is or contains a service name or variant of service name.
 * @internal
 */
export declare function extractResolvedServiceName(value: string): ExtractedServiceName | undefined;
