"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.resolveResourceName = void 0;
/*********************************************************************************************************************
 Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.

 Licensed under the Apache License, Version 2.0 (the "License").
 You may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 ******************************************************************************************************************** */
const assets_1 = require("../../generated/assets");
const utils_1 = require("../../utils");
const variants_1 = require("./variants");
/** @internal */
const RESOURCE_LOOKUP = Object.fromEntries([
    ...Object.keys(assets_1.AwsAsset.Resources).flatMap((key) => {
        return [
            // constant self lookup
            [key, key],
            // constant comparable
            [utils_1.normalizeComparisonString(key), key],
        ];
    }),
    ...Object.entries(variants_1.NORMALIZED_RESOURCE_VARIANTS).flatMap(([key, variants]) => {
        if (variants == null)
            return [];
        return variants.map((variant) => [utils_1.normalizeComparisonString(variant), key]);
    }),
]);
/**
 * Resolve resource name value to asset based service key.
 * @internal
 */
function resolveResourceName(value, service) {
    // constant lookup first for perf
    const comparableValue = utils_1.normalizeComparisonString(value);
    if (comparableValue in RESOURCE_LOOKUP) {
        return RESOURCE_LOOKUP[comparableValue];
    }
    if (service) {
        const servicePrefixed = `${utils_1.normalizeComparisonString(service)}${comparableValue}`;
        if (servicePrefixed in RESOURCE_LOOKUP) {
            const resourceName = RESOURCE_LOOKUP[servicePrefixed];
            RESOURCE_LOOKUP[comparableValue] = resourceName;
            return resourceName;
        }
    }
    throw new Error(`Failed to resolve resourceName ${value} [${service}] (${comparableValue})`);
}
exports.resolveResourceName = resolveResourceName;
//# sourceMappingURL=data:application/json;base64,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