"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.PricingManifest = void 0;
/*********************************************************************************************************************
 Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.

 Licensed under the Apache License, Version 2.0 (the "License").
 You may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 ******************************************************************************************************************** */
const pricing_manifest_1 = require("../../generated/pricing-manifest");
const utils_1 = require("../../utils");
/** Service pricing manifest namespace */
var PricingManifest;
(function (PricingManifest) {
    /** Set of service slugs */
    PricingManifest.Slugs = new Set(pricing_manifest_1.PRICING_SLUGS);
    /** Record of all services defined in pricing manifest */
    PricingManifest.Services = pricing_manifest_1.PRICING_MANIFEST;
    const _ComparableTermCache = new Map(Object.values(PricingManifest.Services).flatMap((service) => {
        return service.comparableTerms.map((term) => [term, service]);
    }));
    /**
     * Find pricing service definition associated with a given term.
     */
    function findService(term) {
        // check if term is serviceCode
        if (term in PricingManifest.Services) {
            return PricingManifest.Services[term];
        }
        term = utils_1.normalizeComparisonString(term);
        if (_ComparableTermCache.has(term)) {
            return _ComparableTermCache.get(term);
        }
        return;
    }
    PricingManifest.findService = findService;
})(PricingManifest = exports.PricingManifest || (exports.PricingManifest = {}));
//# sourceMappingURL=data:application/json;base64,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