/*********************************************************************************************************************
 Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.

 Licensed under the Apache License, Version 2.0 (the "License").
 You may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 ******************************************************************************************************************** */
import { AwsAsset } from "../../generated/assets";
import { CfnSpec } from "../../generated/cfnspec";
/** Parsed CloudFormation resource type string parts */
export interface CfnResourceTypeParts {
    provider: string;
    serviceName: CfnSpec.ServiceName;
    resourceName: string;
}
/** Parse CloudFormation resource type string into parts */
export declare function parseCfnType(cfnType: CfnSpec.ResourceType): CfnResourceTypeParts;
/** Definitaion of asset mappings to CloudFormation type */
interface CfnTypeAssets {
    readonly serviceName?: AwsAsset.Service;
    readonly resourceName?: AwsAsset.Resource;
    readonly generalIcon?: AwsAsset.GeneralIcon;
}
/** Find asset type details for given CloudFormation type */
export declare function findCfnTypeAssets(cfnType: CfnSpec.ResourceType): CfnTypeAssets;
export {};
