"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.GENERAL_CATEGORY_ID = exports.findAwsCategoryDefinition = exports.AwsCategoryDefinitions = exports.CATEGORY_DEFAULT_FONT_COLOR = void 0;
/*********************************************************************************************************************
 Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.

 Licensed under the Apache License, Version 2.0 (the "License").
 You may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 ******************************************************************************************************************** */
const utils_1 = require("../../utils");
/** Default font color for categories */
exports.CATEGORY_DEFAULT_FONT_COLOR = "#232F3E";
/** Record of all category definitions keyed by id */
exports.AwsCategoryDefinitions = {
    analytics: {
        id: "analytics",
        name: "Analytics",
        fillColor: "#5A30B5",
        gradientColor: "#945DF2",
    },
    application_integration: {
        id: "application_integration",
        name: "Application Integration",
        fillColor: "#BC1356",
        gradientColor: "#F34482",
        variants: ["app_integration"],
    },
    blockchain: {
        id: "blockchain",
        name: "Blockchain",
        fillColor: "#D05C17",
        gradientColor: "#F78E04",
    },
    business_applications: {
        id: "business_applications",
        name: "Business Applications",
        fillColor: "#C7131F",
        gradientColor: "#F54749",
        variants: ["business_application"],
    },
    cloud_financial_management: {
        id: "cloud_financial_management",
        name: "Cloud Financial Management",
        fillColor: "#277116",
        gradientColor: "#60A337",
        variants: ["cost_management"],
    },
    compute: {
        id: "compute",
        name: "Compute",
        fillColor: "#D05C17",
        gradientColor: "#F78E04",
    },
    containers: {
        id: "containers",
        name: "Containers",
        fillColor: "#D05C17",
        gradientColor: "#F78E04",
    },
    customer_enablement: {
        id: "customer_enablement",
        name: "Customer Enablement",
        fillColor: "#3334B9",
        gradientColor: "#4D72F3",
        variants: ["customer_engagement"],
    },
    database: {
        id: "database",
        name: "Database",
        fillColor: "#3334B9",
        gradientColor: "#4D72F3",
    },
    developer_tools: {
        id: "developer_tools",
        name: "Developer Tools",
        fillColor: "#3334B9",
        gradientColor: "#4D72F3",
    },
    end_user_computing: {
        id: "end_user_computing",
        name: "End User Computing",
        fillColor: "#116D5B",
        gradientColor: "#4AB29A",
        variants: ["desktop_and_app_streaming"],
    },
    front_end_web_mobile: {
        id: "front_end_web_mobile",
        name: "Front-End Web & Mobile",
        fillColor: "#C7131F",
        gradientColor: "#F54749",
        variants: ["mobile"],
    },
    game_tech: {
        id: "game_tech",
        name: "Game Tech",
        fillColor: "#5A30B5",
        gradientColor: "#945DF2",
    },
    general: {
        id: "general",
        name: "General",
        fillColor: "#1E262E",
        gradientColor: "#505863",
        variants: ["general_resources", "general_icons", "illustrations"],
    },
    internet_of_things: {
        id: "internet_of_things",
        name: "Internet of Things",
        fillColor: "#277116",
        gradientColor: "#60A337",
        variants: ["iot", "lot"],
    },
    machine_learning: {
        id: "machine_learning",
        name: "Machine Learning",
        fillColor: "#116D5B",
        gradientColor: "#4AB29A",
        variants: ["ml"],
    },
    management_governance: {
        id: "management_governance",
        name: "Management & Governance",
        fillColor: "#BC1356",
        gradientColor: "#F34482",
        variants: ["management_and_governance"],
    },
    media_services: {
        id: "media_services",
        name: "Media_services",
        fillColor: "#D05C17",
        gradientColor: "#F78E04",
    },
    migration_transfer: {
        id: "migration_transfer",
        name: "Migration & Transfer",
        fillColor: "#116D5B",
        gradientColor: "#4AB29A",
        variants: ["migration_and_transfer"],
    },
    networking_content_delivery: {
        id: "networking_content_delivery",
        name: "Networking & Content Delivery",
        fillColor: "#5A30B5",
        gradientColor: "#945DF2",
        variants: ["networking_and_content_delivery"],
    },
    quantum_technologies: {
        id: "quantum_technologies",
        name: "Quantum Technologies",
        fillColor: "#D05C17",
        gradientColor: "#F78E04",
    },
    robotics: {
        id: "robotics",
        name: "Robotics",
        fillColor: "#BE0917",
        gradientColor: "#FE5151",
    },
    satellite: {
        id: "satellite",
        name: "Satellite",
        fillColor: "#2F29AF",
        gradientColor: "#517DFD",
    },
    security_identity_compliance: {
        id: "security_identity_compliance",
        name: "Security, Identity, & Compliance",
        fillColor: "#C7131F",
        gradientColor: "#F54749",
        variants: ["security_identity_and_compliance"],
    },
    serverless: {
        id: "serverless",
        name: "Serverless",
        fillColor: "#5A30B5",
        gradientColor: "#945DF2",
    },
    storage: {
        id: "storage",
        name: "Storage",
        fillColor: "#277116",
        gradientColor: "#60A337",
    },
    vr_ar: {
        id: "vr_ar",
        name: "VR & AR",
        fillColor: "#BC1356",
        gradientColor: "#F34482",
        variants: ["ar_vr", "xr"],
    },
};
/** Find category definition for given value */
function findAwsCategoryDefinition(value) {
    value = utils_1.normalizeIdentifier(value);
    if (value in exports.AwsCategoryDefinitions) {
        return exports.AwsCategoryDefinitions[value];
    }
    const category = Object.values(exports.AwsCategoryDefinitions).find((_category) => {
        return _category.variants?.includes(value);
    });
    if (category == null) {
        throw new Error(`AwsCategorgies does not have match for ${value}`);
    }
    return category;
}
exports.findAwsCategoryDefinition = findAwsCategoryDefinition;
exports.GENERAL_CATEGORY_ID = exports.AwsCategoryDefinitions.general.id;
//# sourceMappingURL=data:application/json;base64,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