"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.PRICING_SLUGS = exports.PRICING_MANIFEST = void 0;
// AUTO-GENERATED - DO NOT EDIT
/* eslint-disable */
exports.PRICING_MANIFEST = {
    "awsApplicationMigrationSvc": {
        "name": " AWS Application Migration Service",
        "serviceCode": "awsApplicationMigrationSvc",
        "description": "AWS Application Migration Service minimizes time-intensive, error-prone manual processes by automatically converting your source servers from physical, virtual, and cloud infrastructure to run natively on AWS. It further simplifies your migration by allowing you to use the same automated process for a wide range of applications.",
        "searchKeywords": [
            "Application Migration Service",
            "migrating applications",
            "migration",
            "SAP",
            "Oracle",
            "SQL Server",
            "CloudEndure Migration"
        ],
        "type": "AWSService",
        "regions": [
            "af-south-1",
            "ap-east-1",
            "ap-northeast-1",
            "ap-northeast-2",
            "ap-northeast-3",
            "ap-south-1",
            "ap-southeast-1",
            "ap-southeast-2",
            "ca-central-1",
            "eu-central-1",
            "eu-north-1",
            "eu-south-1",
            "eu-west-1",
            "eu-west-2",
            "eu-west-3",
            "me-south-1",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/application-migration-service/",
        "isActive": "true",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/awsApplicationMigrationSvc/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/awsApplicationMigrationSvc/en_US.json",
        "slug": "appmigrationsvc",
        "mvpSupport": false,
        "comparableTerms": [
            "applicationmigration",
            "applicationmigrationservice",
            "applicationmigrationsvc",
            "appmigration",
            "appmigrationsvc"
        ]
    },
    "activeCustomBatchTranslation": {
        "name": "Active Custom Batch Translation",
        "serviceCode": "activeCustomBatchTranslation",
        "description": "Amazon Translate is a neural machine translation service that delivers fast, high-quality, and affordable language translation. Neural machine translation is a form of language translation automation that uses deep learning models to deliver more accurate and more natural sounding translation than traditional statistical and rule-based translation algorithms.",
        "searchKeywords": [
            "NLP",
            "Natural language processing",
            "language transalation",
            "Text analytics",
            "Language translation",
            "Amazon translate",
            "Translate"
        ],
        "type": "AWSService",
        "regions": [
            "us-east-1",
            "eu-west-1",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/translate/",
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/activeCustomBatchTranslation/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/activeCustomBatchTranslation/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "activecustombatchtranslation"
        ],
        "parentServiceCode": "amazonTranslate"
    },
    "amazonApiGateway": {
        "name": "Amazon API Gateway",
        "serviceCode": "amazonApiGateway",
        "description": "Amazon API Gateway is a fully managed service that makes it easy for developers to create, publish, maintain, monitor, and secure APIs at any scale. APIs act as the front door for applications to access data, business logic, or functionality from your backend services.",
        "searchKeywords": [
            "API",
            "api",
            "Rest",
            "websocket",
            "messages"
        ],
        "type": "AWSService",
        "regions": [
            "us-gov-west-1",
            "us-gov-east-1",
            "af-south-1",
            "ap-east-1",
            "ap-south-1",
            "ap-northeast-2",
            "ap-northeast-3",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-southeast-3",
            "ap-northeast-1",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "eu-south-1",
            "eu-west-3",
            "eu-north-1",
            "me-south-1",
            "me-central-1",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/api-gateway/",
        "isActive": "true",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonApiGateway/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "slug": "APIGateway",
        "mvpSupport": false,
        "comparableTerms": [
            "apigateway"
        ]
    },
    "amazonAppFlow": {
        "name": "Amazon AppFlow",
        "serviceCode": "amazonAppFlow",
        "description": "Amazon AppFlow offers significant cost-savings advantage compared to building connectors in-house or using other application integration services. There are no upfront charges or fees to use AppFlow, and customers only pay for the number of flows they run and the volume of data processed.",
        "searchKeywords": [
            "appflow",
            "Amazon AppFlow",
            "App Flow",
            "AWS appflow"
        ],
        "type": "AWSService",
        "regions": [
            "ap-south-1",
            "af-south-1",
            "ap-northeast-2",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-northeast-1",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "eu-west-3",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/appflow/",
        "isActive": "true",
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonAppFlow/en_US.json",
        "c2e": false,
        "slug": "Appflow",
        "mvpSupport": false,
        "comparableTerms": [
            "appflow"
        ]
    },
    "amazonAppStream": {
        "name": "Amazon AppStream 2.0",
        "serviceCode": "amazonAppStream",
        "description": "Amazon AppStream 2.0 is a fully managed service that provides secure, reliable, and scalable access to applications and non-persistent desktops from any location.",
        "searchKeywords": [
            "streaming",
            "app"
        ],
        "type": "AWSService",
        "regions": [
            "us-east-1",
            "us-east-2",
            "ap-south-1",
            "us-west-2",
            "us-gov-west-1",
            "ap-southeast-2",
            "eu-west-1",
            "ap-northeast-2",
            "eu-central-1",
            "ap-northeast-1",
            "eu-west-2",
            "ap-southeast-1",
            "ca-central-1"
        ],
        "linkUrl": "https://aws.amazon.com/appstream2/",
        "isActive": "true",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonAppStream/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "bulkImportEnabled": false,
        "serviceDefinitionUrlPath": "/data/amazonAppStream/en_US.json",
        "slug": "AppStream",
        "mvpSupport": false,
        "comparableTerms": [
            "appstream",
            "appstream2",
            "appstream20"
        ]
    },
    "amazonAthena": {
        "name": "Amazon Athena",
        "serviceCode": "amazonAthena",
        "description": "Amazon Athena is an interactive query service that makes it easy to analyze data in Amazon S3 using standard SQL. Athena is serverless, so there is no infrastructure to manage, and you pay only for the queries that you run.",
        "searchKeywords": [
            "Analytics",
            "SQL",
            "query",
            "S3",
            "big data",
            "Presto",
            "serverless",
            "ad-hoc analysis",
            "log processing",
            "bigquery",
            "big query",
            "query S3 data"
        ],
        "type": "AWSService",
        "regions": [
            "af-south-1",
            "ap-east-1",
            "ap-south-1",
            "ap-northeast-2",
            "ap-northeast-3",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-northeast-1",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "eu-west-3",
            "eu-north-1",
            "eu-south-1",
            "me-south-1",
            "us-gov-west-1",
            "us-gov-east-1",
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2",
            "sa-east-1"
        ],
        "linkUrl": "https://aws.amazon.com/athena/",
        "isActive": "true",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonAthena/en_US.json",
        "c2e": false,
        "slug": "Athena",
        "mvpSupport": false,
        "comparableTerms": [
            "athena"
        ]
    },
    "amazonAuroraMySQLCompatible": {
        "name": "Amazon Aurora MySQL-Compatible",
        "serviceCode": "amazonAuroraMySQLCompatible",
        "description": "Amazon Aurora MySQL Compatible relational database is built for the cloud, that combines  performance and availability of traditional enterprise databases with the simplicity and cost-effectiveness of open source databases.",
        "searchKeywords": [
            "Database",
            "Aurora",
            "MySQL",
            "MariaDB",
            "Postgres",
            "Oracle",
            "SQL Server",
            "Database",
            "PostgreSQL",
            "Microsoft SQL Server",
            "Relational Database Service",
            "Database",
            "database hosting",
            "hosted database",
            "Managed database"
        ],
        "type": "AWSService",
        "regions": [
            "af-south-1",
            "ap-east-1",
            "ap-northeast-1",
            "ap-northeast-2",
            "ap-northeast-3",
            "ap-south-1",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-southeast-3",
            "ca-central-1",
            "eu-central-1",
            "eu-north-1",
            "eu-south-1",
            "eu-west-1",
            "eu-west-2",
            "eu-west-3",
            "me-south-1",
            "me-central-1",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2",
            "us-gov-east-1",
            "us-gov-west-1"
        ],
        "linkUrl": "https://aws.amazon.com/rds/aurora/",
        "isActive": "true",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonAuroraMySQLCompatible/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "bulkImportEnabled": false,
        "serviceDefinitionUrlPath": "/data/amazonAuroraMySQLCompatible/en_US.json",
        "slug": "AuroraMySQL",
        "mvpSupport": false,
        "comparableTerms": [
            "auroramysql",
            "auroramysqlcompatible",
            "rdsaurora"
        ]
    },
    "amazonRDSAuroraPostgreSQLCompatibleDB": {
        "name": "Amazon Aurora PostgreSQL-Compatible DB",
        "serviceCode": "amazonRDSAuroraPostgreSQLCompatibleDB",
        "description": "Amazon Aurora is a MySQL and PostgreSQL-compatible relational database built for the cloud, that combines the performance and availability of traditional enterprise databases with the simplicity and cost-effectiveness of open source databases.",
        "searchKeywords": [
            "Database",
            "PostgreSQL",
            "Aurora",
            "database hosting",
            "hosted database",
            "Managed database"
        ],
        "type": "AWSService",
        "regions": [
            "af-south-1",
            "ap-east-1",
            "ap-northeast-1",
            "ap-northeast-2",
            "ap-northeast-3",
            "ap-south-1",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-southeast-3",
            "ca-central-1",
            "eu-central-1",
            "eu-north-1",
            "eu-south-1",
            "eu-west-1",
            "eu-west-2",
            "eu-west-3",
            "me-south-1",
            "me-central-1",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2",
            "us-gov-east-1",
            "us-gov-west-1"
        ],
        "linkUrl": "https://aws.amazon.com/aurora/",
        "isActive": "true",
        "hasDataTransfer": false,
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonRDSAuroraPostgreSQLCompatibleDB/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "bulkImportEnabled": false,
        "serviceDefinitionUrlPath": "/data/amazonRDSAuroraPostgreSQLCompatibleDB/en_US.json",
        "slug": "AuroraPostgreSQL",
        "mvpSupport": false,
        "comparableTerms": [
            "aurora",
            "aurorapostgresql",
            "aurorapostgresqlcompatibledb",
            "rdsaurorapostgresqlcompatibledb"
        ]
    },
    "amazonBraket": {
        "name": "Amazon Braket",
        "serviceCode": "amazonBraket",
        "description": "Amazon Braket is a fully managed quantum computing service that helps researchers and developers get started with the technology to accelerate research and discovery. Amazon Braket provides a development environment for you to explore and build quantum algorithms, test them on quantum circuit simulators, and run them on different quantum hardware technologies.",
        "searchKeywords": [
            "quantum",
            "compute",
            "computing",
            "simulators",
            "algorithms",
            "Sagemaker",
            "notebooks"
        ],
        "type": "AWSService",
        "regions": [
            "us-east-1",
            "us-west-1",
            "us-west-2",
            "eu-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/braket/",
        "isActive": "true",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonBraket/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "bulkImportEnabled": false,
        "serviceDefinitionUrlPath": "/data/amazonBraket/en_US.json",
        "slug": "Braket",
        "mvpSupport": false,
        "comparableTerms": [
            "braket"
        ]
    },
    "amazonCarrierIp": {
        "name": "Amazon Carrier IP",
        "serviceCode": "amazonCarrierIp",
        "description": "A Carrier IP address is the address that you assign to a network interface, which resides in a subnet in a Wavelength Zone (for example an EC2 instance)",
        "searchKeywords": [
            "Compute",
            "Carrier",
            "Elastic Compute Cloud",
            "spot instance",
            "load balancing",
            "elb",
            "elastic load balancer",
            "auto scaling",
            "auto scaling groups",
            "application load balancer",
            "ALB",
            "spot requests",
            "reserved instances",
            "scheduled instances",
            "dedicated hosts",
            "AMIs",
            "CIPs",
            "Bundle tasks",
            "Volumes",
            "Snapshots",
            "Images",
            "Elastic Block Store",
            "block storage",
            "Security groups",
            "Elastic IP",
            "placement groups",
            "key pairs",
            "network interfaces",
            "load balancers",
            "target groups",
            "auto scaler",
            "launch configurations",
            "EBS",
            "ASG",
            "commands",
            "command history",
            "managed instances",
            "activations"
        ],
        "type": "AWSService",
        "regions": [
            "ap-northeast-1-wl1-kix1",
            "ap-northeast-1-wl1-nrt1",
            "ap-northeast-2-wl1-cjj1",
            "ap-northeast-2-wl1-sel1",
            "ca-central-1-wl1-yto1",
            "eu-west-2-wl1-lon1",
            "eu-central-1-wl1-ber1",
            "eu-central-1-wl1-dtm1",
            "eu-central-1-wl1-muc1",
            "us-east-1-wl1",
            "us-east-1-wl1-atl1",
            "us-east-1-wl1-clt1",
            "us-east-1-wl1-chi1",
            "us-east-1-wl1-dfw1",
            "us-east-1-wl1-dtw1",
            "us-east-1-wl1-iah1",
            "us-east-1-wl1-mia1",
            "us-east-1-wl1-msp1",
            "us-east-1-wl1-bna1",
            "us-east-1-wl1-nyc1",
            "us-east-1-wl1-tpa1",
            "us-east-1-wl1-was1",
            "us-west-2-wl1-den1",
            "us-west-2-wl1-las1",
            "us-west-2-wl1-lax1",
            "us-west-2-wl1-phx1",
            "us-west-2-wl1-sea1",
            "us-west-2-wl1"
        ],
        "linkUrl": "https://aws.amazon.com/ec2/pricing/on-demand/",
        "isActive": "true",
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonCarrierIp/en_US.json",
        "c2e": false,
        "slug": "CarrierIP",
        "mvpSupport": false,
        "comparableTerms": [
            "carrierip"
        ]
    },
    "amazonChime": {
        "name": "Amazon Chime",
        "serviceCode": "amazonChime",
        "description": "Amazon Chime is a communications service that lets you meet, chat, and place business calls inside and outside your organization, all using a single application.",
        "searchKeywords": [
            "Chime",
            "Business Calling"
        ],
        "type": "AWSService",
        "regions": [],
        "linkUrl": "https://aws.amazon.com/chime/",
        "isActive": "true",
        "subType": "subServiceSelector",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonChime/en_US.json",
        "c2e": false,
        "templates": [
            "chimeCostAnalysis",
            "chimeBusinessCallingAnalysis"
        ],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/amazonChime/en_US.json",
        "slug": "Chime",
        "mvpSupport": false,
        "comparableTerms": [
            "chime"
        ]
    },
    "chimeBusinessCallingAnalysis": {
        "name": "Amazon Chime Business Calling analysis",
        "serviceCode": "chimeBusinessCallingAnalysis",
        "description": "Amazon Chime lets you meet, chat, and collaborate with the security of AWS. You can work seamlessly on your devices, and meet from your desk or on the go - ensuring you always stay connected.",
        "searchKeywords": [],
        "type": "AWSService",
        "regions": [
            "us-east-1"
        ],
        "linkUrl": "https://aws.amazon.com/chime/",
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/chimeBusinessCallingAnalysis/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/chimeBusinessCallingAnalysis/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "chimebusinesscallinganalysis"
        ],
        "parentServiceCode": "amazonChime"
    },
    "amazonChimeTCO": {
        "name": "Amazon Chime cost comparison tool",
        "serviceCode": "amazonChimeTCO",
        "description": "Amazon Chime lets you meet, chat, and collaborate with the security of AWS. You can work seamlessly on your devices, and meet from your desk or on the go - ensuring you always stay connected.",
        "searchKeywords": [],
        "type": "AWSService",
        "regions": [
            "us-east-1"
        ],
        "linkUrl": "https://aws.amazon.com/chime/",
        "isActive": "true",
        "subType": "TCOCalculator",
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonChimeTCO/en_US.json",
        "c2e": false,
        "comparableTerms": [
            "chime",
            "chimecostcomparisontool",
            "chimetco"
        ]
    },
    "chimeCostAnalysis": {
        "name": "Amazon Chime Meetings App",
        "serviceCode": "chimeCostAnalysis",
        "description": "Amazon Chime lets you meet, chat, and collaborate with the security of AWS. You can work seamlessly on your devices, and meet from your desk or on the go - ensuring you always stay connected.",
        "searchKeywords": [],
        "type": "AWSService",
        "regions": [
            "us-east-1"
        ],
        "linkUrl": "https://aws.amazon.com/chime/",
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/chimeCostAnalysis/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/chimeCostAnalysis/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "chimecostanalysis",
            "chimemeetingsapp"
        ],
        "parentServiceCode": "amazonChime"
    },
    "amazonChimeSdk": {
        "name": "Amazon Chime SDK",
        "serviceCode": "amazonChimeSdk",
        "description": "With the Amazon Chime SDK, builders can easily add real-time voice, video, and messaging powered by machine learning into their applications.",
        "searchKeywords": [
            "Chimesdk",
            "messaging",
            "SIP trunking",
            "webrtc media",
            "proxy phone session"
        ],
        "type": "AWSService",
        "regions": [],
        "linkUrl": "https://aws.amazon.com/chime/chime-sdk/",
        "isActive": "true",
        "subType": "subServiceSelector",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonChimeSdk/en_US.json",
        "c2e": false,
        "templates": [
            "webRtcMedia",
            "ptsnAudio",
            "sipTrunking",
            "chimeSdkMessaging",
            "proxyPhoneSession"
        ],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/amazonChimeSdk/en_US.json",
        "slug": "ChimeSDK",
        "mvpSupport": false,
        "comparableTerms": [
            "chimechimesdk",
            "chimesdk"
        ]
    },
    "amazonCloudFront": {
        "name": "Amazon CloudFront",
        "serviceCode": "amazonCloudFront",
        "description": "Amazon CloudFront is a fast content delivery network (CDN) service that securely delivers data, videos, applications, and APIs to customers globally with low latency, high transfer speeds, all within a developer-friendly environment.",
        "searchKeywords": [
            "cloudfront",
            "CDN"
        ],
        "type": "AWSService",
        "regions": [
            "ap-east-1",
            "ap-northeast-1",
            "ap-northeast-2",
            "ap-south-1",
            "ap-southeast-1",
            "ap-southeast-2",
            "ca-central-1",
            "eu-central-1",
            "eu-north-1",
            "eu-west-1",
            "eu-west-2",
            "eu-west-3",
            "me-south-1",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-gov-east-1",
            "us-gov-west-1",
            "us-west-1",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/cloudfront/",
        "isActive": "true",
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonCloudFront/en_US.json",
        "c2e": false,
        "slug": "CloudFront",
        "mvpSupport": false,
        "comparableTerms": [
            "cloudfront"
        ]
    },
    "amazonCloudWatch": {
        "name": "Amazon CloudWatch",
        "serviceCode": "amazonCloudWatch",
        "description": "Amazon CloudWatch is a monitoring and management service that provides data and actionable insights for AWS, hybrid, and on-premises applications and infrastructure resources.",
        "searchKeywords": [
            "Management Tools",
            "CW",
            "monitoring",
            "metrics",
            "graphs",
            "logs",
            "dashboard",
            "events",
            "alarms",
            "monitoring scripts",
            "management tools",
            "monitoring service",
            "network monitoring"
        ],
        "type": "AWSService",
        "regions": [
            "af-south-1",
            "ap-east-1",
            "ap-south-1",
            "ap-northeast-3",
            "ap-northeast-2",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-southeast-3",
            "ap-northeast-1",
            "us-gov-west-1",
            "us-gov-east-1",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "eu-west-3",
            "eu-north-1",
            "eu-south-1",
            "me-south-1",
            "me-central-1",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/cloudwatch/",
        "isActive": "true",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonCloudWatch/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "slug": "CloudWatch",
        "mvpSupport": false,
        "comparableTerms": [
            "cloudwatch"
        ]
    },
    "amazonCodeGuru": {
        "name": "Amazon CodeGuru Reviewer",
        "serviceCode": "amazonCodeGuru",
        "description": "Amazon CodeGuru Reviewer is a service that uses program analysis and machine learning to detect potential defects that are difficult for developers to find and recommends fixes in your Java code.",
        "searchKeywords": [
            "CodeGuru",
            "Reviewer",
            "code reviews",
            "package scan",
            "pull request",
            "code analysis",
            "code quality"
        ],
        "type": "AWSService",
        "regions": [
            "ap-northeast-1",
            "ap-southeast-1",
            "ap-southeast-2",
            "eu-central-1",
            "eu-north-1",
            "eu-west-1",
            "eu-west-2",
            "us-east-1",
            "us-east-2",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/codeguru/",
        "isActive": "true",
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonCodeGuru/en_US.json",
        "c2e": false,
        "slug": "CodeGuruReviewer",
        "comparableTerms": [
            "codeguru",
            "codegurureviewer"
        ]
    },
    "codeGuruReviewer": {
        "name": "Amazon CodeGuru Reviewer Test",
        "serviceCode": "codeGuruReviewer",
        "description": "Amazon CodeGuru Reviewer is a service that uses program analysis and machine learning to detect potential defects that are difficult for developers to find and recommends fixes in your Java code.",
        "searchKeywords": [
            "CodeGuru",
            "Reviewer",
            "code reviews",
            "package scan",
            "pull request",
            "code analysis",
            "code quality"
        ],
        "type": "AWSService",
        "regions": [
            "us-east-1",
            "us-east-2",
            "us-west-2",
            "eu-west-1",
            "ap-southeast-2"
        ],
        "linkUrl": "https://docs.aws.amazon.com/codeguru/index.html",
        "isActive": "false",
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/codeGuruReviewer/en_US.json",
        "c2e": false,
        "slug": "CodeGuruReviewerv2",
        "comparableTerms": [
            "codeguru",
            "codegurureviewer",
            "codegurureviewertest"
        ]
    },
    "amazonCognito": {
        "name": "Amazon Cognito",
        "serviceCode": "amazonCognito",
        "description": "Amazon Cognito lets you add user sign-up, sign-in, and access control to your web and mobile apps quickly and easily. Amazon Cognito scales to millions of users and supports sign-in with social identity providers, such as Facebook, Google, and Amazon, and enterprise identity providers via SAML 2.0.",
        "searchKeywords": [
            "apps",
            "security",
            "access",
            "control",
            "cognito",
            "MAU",
            "SMAL",
            "OIDC"
        ],
        "type": "AWSService",
        "regions": [
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2",
            "ap-south-1",
            "ap-northeast-2",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-northeast-1",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "eu-west-3",
            "me-south-1",
            "eu-north-1",
            "sa-east-1",
            "us-gov-west-1"
        ],
        "linkUrl": "https://aws.amazon.com/cognito/",
        "isActive": "true",
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonCognito/en_US.json",
        "c2e": false,
        "slug": "Cognito",
        "mvpSupport": false,
        "comparableTerms": [
            "cognito"
        ]
    },
    "amazonComprehend": {
        "name": "Amazon Comprehend",
        "serviceCode": "amazonComprehend",
        "description": "With Amazon Comprehend, you only pay for what you use. You are charged based on the amount of text processed on a monthly basis. Amazon Comprehend provides natural language processing, topic modeling, and Custom Classification capabilities, enabling a broad range of applications that can analyze text.",
        "searchKeywords": [
            "Comprehend",
            "NLP",
            "Natural language processing",
            "Sentiment analysis",
            "Text analytics",
            "Entity extraction",
            "Named entity recognition",
            "NER",
            "Key phrase extraction",
            "Topic modeling",
            "Unsupervised clustering",
            "Supervised machine learning",
            "Custom entity recognition",
            "Custom classification",
            "Document classifier",
            "Personally identifiable information",
            "PII",
            "Redaction",
            "Language detection",
            "Free form text analytics"
        ],
        "type": "AWSService",
        "regions": [],
        "linkUrl": "https://aws.amazon.com/comprehend",
        "isActive": "true",
        "subType": "subServiceSelector",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonComprehend/en_US.json",
        "c2e": false,
        "templates": [
            "piiDetection",
            "containsPii",
            "entityRecognition",
            "sentimentAnalysis",
            "targetedSentiment",
            "comprehendCustomClassification",
            "comprehendCustomEntities",
            "keyPhraseExtraction",
            "languageDetection",
            "syntaxAnalysis",
            "comprehendTopicModeling",
            "eventDetectionPerEventType"
        ],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/amazonComprehend/en_US.json",
        "slug": "Comprehend",
        "mvpSupport": false,
        "comparableTerms": [
            "comprehend"
        ]
    },
    "amazonComprehendMedical": {
        "name": "Amazon Comprehend Medical",
        "serviceCode": "amazonComprehendMedical",
        "description": "Amazon Comprehend Medical is a HIPAA-eligible natural language processing (NLP) service that uses machine learning to extract health data from medical text–no machine learning experience is required.",
        "searchKeywords": [
            "Comprehend Medical",
            "NLP",
            "Natural language processing"
        ],
        "type": "AWSService",
        "regions": [],
        "linkUrl": "https://aws.amazon.com/comprehend/medical/",
        "isActive": "true",
        "subType": "subServiceSelector",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonComprehendMedical/en_US.json",
        "c2e": false,
        "templates": [
            "medicalNamedEntityAndRelationshipExtractionNeReApi",
            "medicalProtectedHealthInformationDataExtractionAndIdentificationPhIdApi",
            "medicalIcd10CmOntologyLinkingApi",
            "medicalSystematizedNomenclatureOfMedicineClinicalTermsSnomedCtApi",
            "medicalRxNormOntologyLinkingApi"
        ],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/amazonComprehendMedical/en_US.json",
        "slug": "ComprehendMedical",
        "mvpSupport": false,
        "comparableTerms": [
            "comprehendmedical"
        ]
    },
    "amazonDetective": {
        "name": "Amazon Detective",
        "serviceCode": "amazonDetective",
        "description": "Amazon Detective makes it easy to analyze, investigate, and quickly identify the root cause of potential security issues or suspicious activities. Amazon Detective automatically collects log data from your AWS resources and uses machine learning, statistical analysis, and graph theory to build a linked set of data that enables you to easily conduct faster and more efficient security investigations.",
        "searchKeywords": [
            "detective",
            "amazon Detective"
        ],
        "type": "AWSService",
        "regions": [
            "af-south-1",
            "ap-east-1",
            "ap-northeast-1",
            "ap-northeast-2",
            "ap-south-1",
            "ap-southeast-1",
            "ap-southeast-2",
            "ca-central-1",
            "eu-central-1",
            "eu-north-1",
            "eu-south-1",
            "eu-west-1",
            "eu-west-2",
            "eu-west-3",
            "me-south-1",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-gov-east-1",
            "us-gov-west-1",
            "us-west-1",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/detective/",
        "isActive": "true",
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonDetective/en_US.json",
        "c2e": false,
        "slug": "detective",
        "mvpSupport": false,
        "comparableTerms": [
            "detective"
        ]
    },
    "amazonDevOpsGuru": {
        "name": "Amazon DevOps Guru",
        "serviceCode": "amazonDevOpsGuru",
        "description": "Amazon DevOps Guru is a Machine Learning (ML) powered service that makes it easy to improve an application’s operational performance and availability. DevOps Guru detects behaviors that deviate from normal operating patterns so you can identify operational issues long before they impact your customers.",
        "searchKeywords": [
            "devops",
            "guru",
            "devopsguru"
        ],
        "type": "AWSService",
        "regions": [
            "us-east-1"
        ],
        "linkUrl": "https://aws.amazon.com/devops-guru/",
        "isActive": "true",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonDevOpsGuru/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": true,
        "serviceDefinitionUrlPath": "/data/amazonDevOpsGuru/en_US.json",
        "slug": "DevOpsGuru",
        "mvpSupport": false,
        "comparableTerms": [
            "devopsguru"
        ]
    },
    "amazonDocumentDB": {
        "name": "Amazon DocumentDB (with MongoDB compatibility)",
        "serviceCode": "amazonDocumentDB",
        "description": "Amazon DocumentDB (with MongoDB compatibility) is a fast, scalable, highly available, and fully managed document database service that supports MongoDB workloads.",
        "searchKeywords": [
            "docdb",
            "MongoDB",
            "mongodb",
            "document database",
            "DocumentDB"
        ],
        "type": "AWSService",
        "regions": [
            "ap-south-1",
            "ap-northeast-2",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-northeast-1",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "eu-west-3",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-west-2",
            "us-gov-west-1"
        ],
        "linkUrl": "https://aws.amazon.com/documentdb/",
        "isActive": "true",
        "hasDataTransfer": true,
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonDocumentDB/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "bulkImportEnabled": false,
        "serviceDefinitionUrlPath": "/data/amazonDocumentDB/en_US.json",
        "slug": "DocumentDB",
        "mvpSupport": false,
        "comparableTerms": [
            "documentdb",
            "documentdbwithmongodbcompatibility",
            "withmongodbcompatibility"
        ]
    },
    "amazonDynamoDb": {
        "name": "Amazon DynamoDB",
        "serviceCode": "amazonDynamoDb",
        "description": "Amazon DynamoDB is a key-value and document database that delivers single-digit millisecond performance at any scale. It's a fully managed, multiregion, multimaster, durable database with built-in security, backup and restore, and in-memory caching for internet-scale applications.",
        "searchKeywords": [
            "DynamoDB",
            "Serverless",
            "key-value",
            "Database",
            "DDB",
            "NoSQL",
            "SQL",
            "Table",
            "nosql databases",
            "database schema",
            "database software",
            "cloud database",
            "document database",
            "key value store",
            "database as a service",
            "database scheme",
            "nosql hosting",
            "hosted nosql",
            "data store",
            "unstructured database",
            "Accelerator",
            "DAX"
        ],
        "type": "AWSService",
        "regions": [],
        "linkUrl": "https://aws.amazon.com/dynamodb/",
        "isActive": "true",
        "subType": "subServiceSelector",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonDynamoDb/en_US.json",
        "c2e": false,
        "templates": [
            "dynamoDbOnDemand",
            "amazonDynamoDbProvisionedThroughputCapacity",
            "amazonDynamoDbDaxClusters",
            "amazonDynamoDbStreams",
            "dynamoDbBackup",
            "dynamoDbChangeDateCapture",
            "dynamoDbDataExportToAmazonS3",
            "dynamoDbDataImportFromAmazonS3"
        ],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/amazonDynamoDb/en_US.json",
        "slug": "DynamoDB",
        "mvpSupport": false,
        "comparableTerms": [
            "dynamodb"
        ]
    },
    "eC2Next": {
        "name": "Amazon EC2",
        "serviceCode": "eC2Next",
        "description": "Amazon EC2 offers the broadest and deepest compute platform with choice of processor, storage, networking, operating system, and purchase model.",
        "searchKeywords": [],
        "type": "AWSService",
        "regions": [
            "af-south-1",
            "ap-east-1",
            "ap-northeast-1",
            "ap-northeast-1-wl1-nrt1",
            "ap-northeast-2",
            "ap-northeast-2-wl1-cjj1",
            "ap-northeast-2-wl1-sel1",
            "ap-northeast-3",
            "ap-south-1",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-southeast-3",
            "eu-central-1-wl1-dtm1",
            "eu-central-1-wl1-ber1",
            "eu-central-1-wl1-muc1",
            "ca-central-1",
            "ca-central-1-wl1-yto1",
            "eu-central-1",
            "eu-north-1",
            "eu-south-1",
            "eu-west-1",
            "eu-west-2",
            "eu-west-2-wl1-lon1",
            "eu-west-3",
            "me-south-1",
            "me-central-1",
            "sa-east-1",
            "us-east-1",
            "us-east-1-atl-1",
            "us-east-1-bos-1",
            "us-east-1-chi-1",
            "us-east-1-dfw-1",
            "us-west-2-den-1",
            "us-east-1-iah-1",
            "us-east-1-mci-1",
            "us-east-1-mia-1",
            "us-east-1-msp-1",
            "us-east-1-nyc-1",
            "us-east-1-phl-1",
            "us-east-2",
            "us-gov-east-1",
            "us-gov-west-1",
            "us-west-1",
            "us-west-2",
            "us-west-2-las-1",
            "us-west-2-lax-1",
            "us-west-2-phx-1",
            "us-west-2-pdx-1",
            "us-west-2-sea-1",
            "us-east-1-wl1",
            "us-east-1-wl1-was1",
            "us-west-2-wl1",
            "us-west-2-wl1-las1",
            "us-west-2-wl1-lax1",
            "us-east-1-wl1-atl1",
            "us-east-1-wl1-chi1",
            "us-east-1-wl1-dfw1",
            "us-east-1-wl1-iah1",
            "us-east-1-wl1-mia1",
            "us-east-1-wl1-nyc1",
            "us-east-1-wl1-clt1",
            "us-east-1-wl1-dtw1",
            "us-east-1-wl1-msp1",
            "us-east-1-wl1-bna1",
            "us-east-1-wl1-tpa1",
            "us-west-2-wl1-den1",
            "us-west-2-wl1-phx1",
            "us-west-2-wl1-sea1"
        ],
        "linkUrl": "https://aws.amazon.com/ec2/",
        "isActive": "true",
        "hasDataTransfer": true,
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/eC2Next/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "slug": "EC2",
        "mvpSupport": false,
        "comparableTerms": [
            "ec2",
            "ec2next"
        ]
    },
    "amazonEc2DedicatedHosts": {
        "name": "Amazon EC2 Dedicated Hosts",
        "serviceCode": "amazonEc2DedicatedHosts",
        "description": "Amazon EC2 Dedicated Hosts allow you to use your eligible software licenses on Amazon EC2, so that you get the flexibility and cost effectiveness of using your own licenses, but with the resiliency, simplicity and elasticity of AWS. Includes support for EC2 High Memory and EC2 Mac instances.",
        "searchKeywords": [
            "Mac",
            "High memory"
        ],
        "type": "AWSService",
        "regions": [
            "us-west-2",
            "us-west-2-lax-1",
            "us-west-1",
            "us-east-1",
            "us-east-2",
            "sa-east-1",
            "me-south-1",
            "me-central-1",
            "af-south-1",
            "eu-north-1",
            "eu-west-1",
            "eu-west-2",
            "eu-west-3",
            "eu-south-1",
            "eu-central-1",
            "ca-central-1",
            "us-gov-east-1",
            "us-gov-west-1",
            "ap-northeast-1",
            "ap-northeast-2",
            "ap-northeast-3",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-southeast-3",
            "ap-south-1",
            "ap-east-1"
        ],
        "linkUrl": "https://aws.amazon.com/ec2/dedicated-hosts",
        "isActive": "true",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonEc2DedicatedHosts/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "slug": "EC2DedicatedHosts",
        "mvpSupport": false,
        "comparableTerms": [
            "ec2dedicatedhosts"
        ]
    },
    "awsEks": {
        "name": "Amazon EKS",
        "serviceCode": "awsEks",
        "description": "Amazon Elastic Kubernetes Service (Amazon EKS) is a fully managed Kubernetes service. Customers such as Intel, Snap, Intuit, GoDaddy, and Autodesk trust EKS to run their most sensitive and mission critical applications because of its security, reliability, and scalability..",
        "searchKeywords": [
            "eks",
            "elastic",
            "kubernetes"
        ],
        "type": "AWSService",
        "regions": [
            "us-gov-west-1",
            "us-gov-east-1",
            "af-south-1",
            "ap-east-1",
            "ap-south-1",
            "ap-northeast-2",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-southeast-3",
            "ap-northeast-1",
            "ap-northeast-3",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "eu-south-1",
            "eu-west-3",
            "eu-north-1",
            "me-south-1",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/eks/",
        "isActive": "true",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/awsEks/en_US.json",
        "c2e": false,
        "slug": "EKS",
        "mvpSupport": false,
        "comparableTerms": [
            "eks"
        ]
    },
    "amazonElasticBlockStore": {
        "name": "Amazon Elastic Block Store (EBS)",
        "serviceCode": "amazonElasticBlockStore",
        "description": "Amazon Elastic Block Storage (EBS) allows you to create persistent block storage volumes and attach them to Amazon EC2 instances.",
        "searchKeywords": [],
        "type": "AWSService",
        "regions": [
            "af-south-1",
            "ap-east-1",
            "ap-northeast-1",
            "ap-northeast-1-wl1-nrt1",
            "ap-northeast-2",
            "ap-northeast-2-wl1-cjj1",
            "ap-northeast-2-wl1-sel1",
            "ap-northeast-3",
            "ap-south-1",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-southeast-3",
            "ca-central-1",
            "ca-central-1-wl1-yto1",
            "eu-central-1",
            "eu-north-1",
            "eu-south-1",
            "eu-west-1",
            "eu-west-2",
            "eu-west-2-wl1-lon1",
            "eu-central-1-wl1-dtm1",
            "eu-central-1-wl1-ber1",
            "eu-central-1-wl1-muc1",
            "eu-west-3",
            "me-south-1",
            "me-central-1",
            "sa-east-1",
            "us-east-1",
            "us-east-1-atl-1",
            "us-east-1-bos-1",
            "us-east-1-chi-1",
            "us-east-1-dfw-1",
            "us-west-2-den-1",
            "us-east-1-iah-1",
            "us-east-1-mci-1",
            "us-east-1-mia-1",
            "us-east-1-msp-1",
            "us-east-1-nyc-1",
            "us-east-1-phl-1",
            "us-east-2",
            "us-gov-east-1",
            "us-gov-west-1",
            "us-west-1",
            "us-west-2",
            "us-west-2-las-1",
            "us-west-2-lax-1",
            "us-west-2-phx-1",
            "us-west-2-pdx-1",
            "us-west-2-sea-1",
            "us-east-1-wl1",
            "us-east-1-wl1-atl1",
            "us-east-1-wl1-chi1",
            "us-east-1-wl1-dfw1",
            "us-east-1-wl1-iah1",
            "us-east-1-wl1-mia1",
            "us-east-1-wl1-nyc1",
            "us-east-1-wl1-clt1",
            "us-east-1-wl1-dtw1",
            "us-east-1-wl1-msp1",
            "us-east-1-wl1-was1",
            "us-east-1-wl1-tpa1",
            "us-east-1-wl1-bna1",
            "us-west-2-wl1",
            "us-west-2-wl1-den1",
            "us-west-2-wl1-las1",
            "us-west-2-wl1-lax1",
            "us-west-2-wl1-phx1",
            "us-west-2-wl1-sea1"
        ],
        "linkUrl": "https://aws.amazon.com/ebs/",
        "isActive": "true",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonElasticBlockStore/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "bulkImportEnabled": false,
        "serviceDefinitionUrlPath": "/data/amazonElasticBlockStore/en_US.json",
        "slug": "EBS",
        "mvpSupport": false,
        "comparableTerms": [
            "ebs",
            "elasticblockstore",
            "elasticblockstoreebs"
        ]
    },
    "amazonElasticContainerRegistry": {
        "name": "Amazon Elastic Container Registry",
        "serviceCode": "amazonElasticContainerRegistry",
        "description": "Amazon Elastic Container Registry (ECR) is a fully-managed Docker container registry that makes it easy for developers to store, manage, and deploy Docker container images. Amazon ECR eliminates the need to operate your own container repositories or worry about scaling the underlying infrastructure. With Amazon ECR, there are no upfront fees or commitments. You pay only for the amount of data you store in your repositories and data transferred to the Internet.",
        "searchKeywords": [
            "ECR",
            "ecr",
            "Elastic Container Registry",
            "Amazon ECR",
            "container registry",
            "container",
            "registry"
        ],
        "type": "AWSService",
        "regions": [
            "us-gov-west-1",
            "us-gov-east-1",
            "af-south-1",
            "ap-east-1",
            "ap-south-1",
            "ap-northeast-2",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-southeast-3",
            "ap-northeast-1",
            "ap-northeast-3",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "eu-south-1",
            "eu-west-3",
            "eu-north-1",
            "me-south-1",
            "me-central-1",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/ecr/",
        "isActive": "true",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonElasticContainerRegistry/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "slug": "ECR",
        "mvpSupport": false,
        "comparableTerms": [
            "ecr",
            "elasticcontainerregistry"
        ]
    },
    "amazonEFS": {
        "name": "Amazon Elastic File System (EFS)",
        "serviceCode": "amazonEFS",
        "description": "Amazon Elastic File System (EFS) provides a simple, serverless, set-and-forget elastic file system for use with AWS Cloud services and on-premises resources.",
        "searchKeywords": [
            "Storage",
            "Elastic file system",
            "elastic file service",
            "cloud file system",
            "cloud based file",
            "system",
            "file system",
            "NFS",
            "network file system",
            "fully managed file system",
            "NAS",
            "managed file system",
            "network attached storage",
            "network storage",
            "SAN",
            "storage area network",
            "cloud storage",
            "shared",
            "shared file system",
            "RAID",
            "cloud file storage",
            "file system storage",
            "file management"
        ],
        "type": "AWSService",
        "regions": [
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2",
            "af-south-1",
            "ap-east-1",
            "ap-south-1",
            "ap-northeast-2",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-southeast-3",
            "ap-northeast-1",
            "ap-northeast-3",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "eu-west-3",
            "eu-north-1",
            "eu-south-1",
            "me-south-1",
            "sa-east-1",
            "us-gov-west-1",
            "us-gov-east-1"
        ],
        "linkUrl": "https://aws.amazon.com/efs/",
        "isActive": "true",
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonEFS/en_US.json",
        "c2e": false,
        "slug": "EFS",
        "mvpSupport": false,
        "comparableTerms": [
            "efs",
            "elasticfilesystemefs"
        ]
    },
    "amazonElasticGraphics": {
        "name": "Amazon Elastic Graphics",
        "serviceCode": "amazonElasticGraphics",
        "description": "Amazon Elastic Graphics allows you to easily attach low-cost graphics acceleration to a wide range of EC2 instances over the network.",
        "searchKeywords": [
            "Compute",
            "Elastic Compute Cloud",
            "spot instance",
            "load balancing",
            "elb",
            "elastic load balancer",
            "auto scaling",
            "auto scaling groups",
            "application load balancer",
            "ALB",
            "spot requests",
            "reserved instances",
            "scheduled instances",
            "dedicated hosts",
            "AMIs",
            "Bundle tasks",
            "Volumes",
            "Snapshots",
            "Images",
            "Elastic Block Store",
            "block storage",
            "Security groups",
            "Elastic IP",
            "placement groups",
            "key pairs",
            "network interfaces",
            "load balancers",
            "target groups",
            "auto scaler",
            "launch configurations",
            "EBS",
            "ASG",
            "commands",
            "Elastic Graphics",
            "command history",
            "managed instances",
            "activations"
        ],
        "type": "AWSService",
        "regions": [
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-northeast-1",
            "eu-central-1",
            "eu-west-1",
            "us-east-1",
            "us-east-2",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/ec2/elastic-graphics/",
        "isActive": "true",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonElasticGraphics/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "slug": "ElasticGraphics",
        "mvpSupport": false,
        "comparableTerms": [
            "ec2elasticgraphics",
            "elasticgraphics"
        ]
    },
    "amazonElasticIP": {
        "name": "Amazon Elastic IP",
        "serviceCode": "amazonElasticIP",
        "description": "An Elastic IP address is a static IPv4 address designed for dynamic cloud computing. An Elastic IP address is associated with your AWS account. With an Elastic IP address, you can mask the failure of an instance or software by rapidly remapping the address to another instance in your account.",
        "searchKeywords": [
            "Compute",
            "Elastic Compute Cloud",
            "spot instance",
            "load balancing",
            "elb",
            "elastic load balancer",
            "auto scaling",
            "auto scaling groups",
            "application load balancer",
            "ALB",
            "spot requests",
            "reserved instances",
            "scheduled instances",
            "dedicated hosts",
            "AMIs",
            "Bundle tasks",
            "Volumes",
            "Snapshots",
            "Images",
            "Elastic Block Store",
            "block storage",
            "Security groups",
            "Elastic IP",
            "placement groups",
            "key pairs",
            "network interfaces",
            "load balancers",
            "target groups",
            "auto scaler",
            "launch configurations",
            "EBS",
            "ASG",
            "commands",
            "command history",
            "managed instances",
            "activations"
        ],
        "type": "AWSService",
        "regions": [
            "ap-east-1",
            "ap-south-1",
            "ap-northeast-2",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-northeast-1",
            "us-gov-west-1",
            "us-gov-east-1",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "eu-west-3",
            "eu-north-1",
            "me-south-1",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/ec2/pricing/on-demand/",
        "isActive": "true",
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonElasticIP/en_US.json",
        "c2e": false,
        "slug": "ElasticIP",
        "comparableTerms": [
            "elasticip"
        ]
    },
    "amazonElasticTranscoder": {
        "name": "Amazon Elastic Transcoder",
        "serviceCode": "amazonElasticTranscoder",
        "description": "Amazon Elastic Transcoder is media transcoding in the cloud. It is designed to be a highly scalable, easy to use and a cost effective way for developers and businesses to convert (or “transcode”) media files from their source format into versions that will playback on devices like smartphones, tablets and PCs.",
        "searchKeywords": [],
        "type": "AWSService",
        "regions": [
            "ap-northeast-1",
            "ap-south-1",
            "ap-southeast-1",
            "ap-southeast-2",
            "eu-west-1",
            "us-east-1",
            "us-west-1",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/elastictranscoder/",
        "isActive": "true",
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonElasticTranscoder/en_US.json",
        "c2e": false,
        "slug": "ElasticTranscoder",
        "comparableTerms": [
            "elastictranscoder"
        ]
    },
    "amazonElastiCache": {
        "name": "Amazon ElastiCache",
        "serviceCode": "amazonElastiCache",
        "description": "Amazon ElastiCache offers fully managed Redis and Memcached. Seamlessly deploy, run, and scale popular open source compatible in-memory data stores. Build data-intensive apps or improve the performance of your existing apps by retrieving data from high throughput and low latency in-memory data stores.",
        "searchKeywords": [
            "Database",
            "Database",
            "Cache",
            "Memcached",
            "Redis",
            "Caching",
            "in memory data store",
            "in memory caching",
            "auto discovery",
            "elasticache cluster",
            "replication",
            "adtech",
            "gaming",
            "media sharing",
            "Q&A",
            "social networking"
        ],
        "type": "AWSService",
        "regions": [
            "af-south-1",
            "ap-east-1",
            "ap-south-1",
            "ap-northeast-3",
            "ap-northeast-2",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-southeast-3",
            "ap-northeast-1",
            "us-gov-west-1",
            "us-gov-east-1",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "eu-west-3",
            "eu-north-1",
            "eu-south-1",
            "me-south-1",
            "me-central-1",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/elasticache/",
        "isActive": "true",
        "hasDataTransfer": true,
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonElastiCache/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "slug": "ElastiCache",
        "mvpSupport": false,
        "comparableTerms": [
            "elasticache"
        ]
    },
    "amazonEMR": {
        "name": "Amazon EMR",
        "serviceCode": "amazonEMR",
        "description": "Amazon EMR is the industry-leading cloud big data platform for processing vast amounts of data using open source tools such as Apache Spark, Apache Hive, Apache HBase, Apache Flink, Apache Hudi, and Presto. Amazon EMR makes it easy to set up, operate, and scale your big data environments by automating time-consuming tasks like provisioning capacity and tuning clusters. With EMR you can run petabyte-scale analysis at less than half of the cost of traditional on-premises solutions and over 3x faster than standard Apache Spark. You can run workloads on Amazon EC2 instances, on Amazon Elastic Kubernetes Service (EKS) clusters, or on-premises using EMR on AWS Outposts.",
        "searchKeywords": [
            "EMR",
            "elastic map reduce",
            "map reduce",
            "spark",
            "hadoop",
            "hbase",
            "hive",
            "hudi",
            "presto",
            "notebooks",
            "flink",
            "hue"
        ],
        "type": "AWSService",
        "regions": [],
        "linkUrl": "https://aws.amazon.com/emr/",
        "isActive": "true",
        "subType": "subServiceSelector",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonEMR/en_US.json",
        "c2e": false,
        "templates": [
            "amazonEmrMasterNode",
            "amazonEmrCoreNode",
            "amazonEmrTaskNode",
            "amazonEmrOnEks",
            "amazonEmrServerless"
        ],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/amazonEMR/en_US.json",
        "slug": "EMR",
        "mvpSupport": false,
        "comparableTerms": [
            "emr"
        ]
    },
    "amazonEmrCoreNode": {
        "name": "Amazon EMR core node on EC2",
        "serviceCode": "amazonEmrCoreNode",
        "description": "",
        "searchKeywords": [],
        "type": "AWSService",
        "regions": [
            "af-south-1",
            "ap-east-1",
            "ap-south-1",
            "ap-northeast-3",
            "ap-northeast-2",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-southeast-3",
            "ap-northeast-1",
            "us-gov-east-1",
            "us-gov-west-1",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "eu-west-3",
            "eu-south-1",
            "eu-north-1",
            "me-south-1",
            "me-central-1",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2",
            "us-west-2-lax-1"
        ],
        "linkUrl": "https://aws.amazon.com/emr/",
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonEmrCoreNode/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/amazonEmrCoreNode/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "emrcorenode",
            "emrcorenodeec2"
        ],
        "parentServiceCode": "amazonEMR"
    },
    "amazonEmrMasterNode": {
        "name": "Amazon EMR master node on EC2",
        "serviceCode": "amazonEmrMasterNode",
        "description": "",
        "searchKeywords": [],
        "type": "AWSService",
        "regions": [
            "af-south-1",
            "ap-east-1",
            "ap-south-1",
            "ap-northeast-3",
            "ap-northeast-2",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-southeast-3",
            "ap-northeast-1",
            "us-gov-east-1",
            "us-gov-west-1",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "eu-west-3",
            "eu-south-1",
            "eu-north-1",
            "me-south-1",
            "me-central-1",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2",
            "us-west-2-lax-1"
        ],
        "linkUrl": "https://aws.amazon.com/emr/",
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonEmrMasterNode/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/amazonEmrMasterNode/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "emrmasternode",
            "emrmasternodeec2"
        ],
        "parentServiceCode": "amazonEMR"
    },
    "amazonEmrOnEks": {
        "name": "Amazon EMR on EKS",
        "serviceCode": "amazonEmrOnEks",
        "description": "",
        "searchKeywords": [],
        "type": "AWSService",
        "regions": [
            "ap-south-1",
            "ap-northeast-2",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-northeast-1",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "eu-west-3",
            "eu-north-1",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/emr/",
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonEmrOnEks/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/amazonEmrOnEks/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "emreks",
            "emroneks"
        ],
        "parentServiceCode": "amazonEMR"
    },
    "amazonEmrServerless": {
        "name": "Amazon EMR Serverless",
        "serviceCode": "amazonEmrServerless",
        "description": "",
        "searchKeywords": [],
        "type": "AWSService",
        "regions": [
            "ap-northeast-1",
            "eu-west-1",
            "us-east-1",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/emr/",
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonEmrServerless/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/amazonEmrServerless/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "emrserverless"
        ],
        "parentServiceCode": "amazonEMR"
    },
    "amazonEmrTaskNode": {
        "name": "Amazon EMR task node on EC2",
        "serviceCode": "amazonEmrTaskNode",
        "description": "",
        "searchKeywords": [],
        "type": "AWSService",
        "regions": [
            "af-south-1",
            "ap-east-1",
            "ap-south-1",
            "ap-northeast-3",
            "ap-northeast-2",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-southeast-3",
            "ap-northeast-1",
            "us-gov-east-1",
            "us-gov-west-1",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "eu-west-3",
            "eu-south-1",
            "eu-north-1",
            "me-south-1",
            "me-central-1",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2",
            "us-west-2-lax-1"
        ],
        "linkUrl": "https://aws.amazon.com/emr/",
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonEmrTaskNode/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/amazonEmrTaskNode/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "emrtasknode",
            "emrtasknodeec2"
        ],
        "parentServiceCode": "amazonEMR"
    },
    "amazonEventBridge": {
        "name": "Amazon EventBridge",
        "serviceCode": "amazonEventBridge",
        "description": "Amazon EventBridge is a serverless event bus that makes it easier to build event-driven applications at scale using events generated from your applications, integrated Software-as-a-Service (SaaS) applications, and AWS services.",
        "searchKeywords": [
            "amazon event bridge",
            "events",
            "Schema Registry",
            "SaaS"
        ],
        "type": "AWSService",
        "regions": [
            "af-south-1",
            "ap-east-1",
            "ap-northeast-1",
            "ap-northeast-2",
            "ap-northeast-3",
            "ap-south-1",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-southeast-3",
            "ca-central-1",
            "eu-central-1",
            "eu-north-1",
            "eu-south-1",
            "eu-west-1",
            "eu-west-2",
            "eu-west-3",
            "me-south-1",
            "me-central-1",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-gov-east-1",
            "us-gov-west-1",
            "us-west-1",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/eventbridge/",
        "isActive": "true",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonEventBridge/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "slug": "eventbridge",
        "mvpSupport": false,
        "comparableTerms": [
            "eventbridge"
        ]
    },
    "amazonFileCache": {
        "name": "Amazon File Cache",
        "serviceCode": "amazonFileCache",
        "description": "Amazon File Cache provides a high-speed cache on AWS that makes it easier to process file data, regardless of where the data is stored.",
        "searchKeywords": [
            "file cache",
            "amazon file cache"
        ],
        "type": "AWSService",
        "regions": [
            " "
        ],
        "linkUrl": "https://aws.amazon.com/filecache/",
        "isActive": "true",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonFileCache/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/amazonFileCache/en_US.json",
        "slug": "filecache",
        "mvpSupport": false,
        "comparableTerms": [
            "filecache"
        ]
    },
    "awsFinSpace": {
        "name": "Amazon FinSpace",
        "serviceCode": "awsFinSpace",
        "description": "Amazon FinSpace is a data management and analytics service for financial services industry (FSI) customers such as hedge funds, asset management firms, insurance companies, and investment banks to store, catalog, prepare, and analyze data at petabyte scale. Using the FinSpace web application and APIs, customers can set up users, add data, and create data views that are optimized for querying. Amazon FinSpace provides scalable clusters to prepare and analyze the data.",
        "searchKeywords": [
            "data management",
            "analytics",
            "clusters",
            "users",
            "data",
            "storage",
            "financial"
        ],
        "type": "AWSService",
        "regions": [
            "us-east-1",
            "us-east-2",
            "us-west-2",
            "ca-central-1",
            "eu-west-1"
        ],
        "linkUrl": "https://aws.amazon.com/finspace/",
        "isActive": "true",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/awsFinSpace/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "slug": "FinSpace",
        "mvpSupport": false,
        "comparableTerms": [
            "finspace"
        ]
    },
    "amazonForecast": {
        "name": "Amazon Forecast",
        "serviceCode": "amazonForecast",
        "description": "Amazon Forecast uses machine learning (ML) to generate more accurate demand forecasts with just a few clicks, without requiring any prior ML experience. Amazon Forecast includes algorithms that are based on over twenty years of forecasting experience and developed expertise used by Amazon.com bringing the same technology used at Amazon to developers as a fully managed service, removing the need to manage resources. Amazon Forecast uses ML to learn not only the best algorithm for each item, but the best ensemble of algorithms for each item, automatically creating the best model for your data.",
        "searchKeywords": [
            "forecast",
            "amazon Forecast"
        ],
        "type": "AWSService",
        "regions": [
            "ap-northeast-1",
            "ap-northeast-2",
            "ap-south-1",
            "ap-southeast-1",
            "ap-southeast-2",
            "eu-central-1",
            "eu-west-1",
            "us-east-1",
            "us-east-2",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/forecast/",
        "isActive": "true",
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonForecast/en_US.json",
        "c2e": false,
        "slug": "forecast",
        "mvpSupport": false,
        "comparableTerms": [
            "forecast"
        ]
    },
    "amazonFraudDetector": {
        "name": "Amazon Fraud Detector",
        "serviceCode": "amazonFraudDetector",
        "description": "Amazon Fraud Detector, a fully managed service built on over 20 years of insights from Amazon, helps customers identify potentially fraudulent activities and catch more online fraud faster. With Amazon Fraud Detector, you pay only for what you use, and there are no minimum fees or upfront commitments. You are charged based on the compute hours used to train and host your models, the amount of storage you use, and the quantity of fraud predictions you make.",
        "searchKeywords": [
            "fraud",
            "fraud detector",
            "detector"
        ],
        "type": "AWSService",
        "regions": [
            "ap-southeast-1",
            "ap-southeast-2",
            "eu-west-1",
            "us-east-1",
            "us-east-2",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/fraud-detector/",
        "isActive": "true",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonFraudDetector/en_US.json",
        "c2e": false,
        "slug": "frauddetector",
        "mvpSupport": false,
        "comparableTerms": [
            "frauddetector"
        ]
    },
    "amazonFSxForLustre": {
        "name": "Amazon FSx for Lustre",
        "serviceCode": "amazonFSxForLustre",
        "description": "Amazon FSx for Lustre provides a simple, high-performance file system integrated with S3 for fast processing of workloads such as machine learning, high performance computing (HPC), video processing, financial modeling, and electronic design automation (EDA).",
        "searchKeywords": [
            "storage",
            "file storage",
            "windows",
            "lustre",
            "hpc",
            "enterprise applications",
            "file shares",
            "file system",
            "cloud storage",
            "smb",
            "ntfs",
            "posix",
            "managed storage"
        ],
        "type": "AWSService",
        "regions": [
            "ap-east-1",
            "ap-south-1",
            "ap-northeast-1",
            "ap-northeast-2",
            "ap-southeast-1",
            "ca-central-1",
            "ap-southeast-2",
            "af-south-1",
            "eu-central-1",
            "eu-north-1",
            "eu-west-1",
            "eu-west-2",
            "eu-west-3",
            "me-south-1",
            "eu-south-1",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-gov-east-1",
            "us-gov-west-1",
            "us-west-1",
            "us-west-2",
            "us-west-2-lax-1"
        ],
        "linkUrl": "https://aws.amazon.com/fsx/lustre/",
        "isActive": "true",
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonFSxForLustre/en_US.json",
        "c2e": false,
        "slug": "FSxForLustre",
        "mvpSupport": false,
        "comparableTerms": [
            "fsxforlustre",
            "fsxlustre"
        ]
    },
    "amazonFSxForNetAppOntap": {
        "name": "Amazon FSx for NetApp ONTAP",
        "serviceCode": "amazonFSxForNetAppOntap",
        "description": "Amazon FSx for NetApp ONTAP provides fully managed shared storage in the AWS Cloud with the popular data access and management capabilities of ONTAP.",
        "searchKeywords": [
            "storage",
            "file storage",
            "windows",
            "lustre",
            "hpc",
            "enterprise applications",
            "file shares",
            "file system",
            "cloud storage",
            "smb",
            "ntfs",
            "posix",
            "managed storage",
            "microsoft",
            "file",
            "msft",
            "shared storage",
            "shared",
            "win",
            "ontap"
        ],
        "type": "AWSService",
        "regions": [
            "af-south-1",
            "ap-east-1",
            "ap-south-1",
            "ap-northeast-2",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-northeast-1",
            "us-gov-east-1",
            "us-gov-west-1",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "eu-south-1",
            "eu-west-3",
            "eu-north-1",
            "me-south-1",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/fsx/netapp-ontap/",
        "isActive": "true",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonFSxForNetAppOntap/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "bulkImportEnabled": false,
        "serviceDefinitionUrlPath": "/data/amazonFSxForNetAppOntap/en_US.json",
        "slug": "FSxForNetAppOntap",
        "mvpSupport": false,
        "comparableTerms": [
            "fsxfornetappontap",
            "fsxnetappontap"
        ]
    },
    "amazonFSxForOpenZfs": {
        "name": "Amazon FSx for OpenZFS",
        "serviceCode": "amazonFSxForOpenZfs",
        "description": "Amazon FSx for OpenZFS provides fully managed shared file storage built on the OpenZFS file system, powered by the AWS Graviton family of processors, and accessible via the NFS protocol (v3, v4, v4.1, v4.2).",
        "searchKeywords": [
            "storage",
            "file storage",
            "windows",
            "openzfs",
            "hpc",
            "enterprise applications",
            "file shares",
            "file system",
            "cloud storage",
            "smb",
            "ntfs",
            "posix",
            "managed storage"
        ],
        "type": "AWSService",
        "regions": [
            "us-east-2",
            "ap-northeast-1",
            "ap-southeast-1",
            "ap-southeast-2",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "us-east-1",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/fsx/openzfs/",
        "isActive": "true",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonFSxForOpenZfs/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "bulkImportEnabled": false,
        "serviceDefinitionUrlPath": "/data/amazonFSxForOpenZfs/en_US.json",
        "slug": "FSxForOpenZFS",
        "mvpSupport": false,
        "comparableTerms": [
            "fsxforopenzfs",
            "fsxopenzfs"
        ]
    },
    "amazonFSx": {
        "name": "Amazon FSx for Windows File Server",
        "serviceCode": "amazonFSx",
        "description": "Amazon FSx for Windows provides a simple, fully managed native Microsoft Windows file system so you can easily move your Windows based applications that require file storage to AWS.",
        "searchKeywords": [
            "storage",
            "file storage",
            "windows",
            "lustre",
            "hpc",
            "enterprise applications",
            "file shares",
            "file system",
            "cloud storage",
            "smb",
            "ntfs",
            "posix",
            "managed storage",
            "microsoft",
            "file",
            "msft",
            "shared storage",
            "shared",
            "win"
        ],
        "type": "AWSService",
        "regions": [
            "af-south-1",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-northeast-1",
            "ap-northeast-2",
            "ap-northeast-3",
            "eu-central-1",
            "ap-east-1",
            "ap-south-1",
            "ca-central-1",
            "eu-north-1",
            "eu-west-1",
            "eu-west-2",
            "eu-west-3",
            "eu-south-1",
            "me-south-1",
            "us-east-1",
            "us-east-2",
            "us-gov-east-1",
            "us-gov-west-1",
            "us-west-1",
            "us-west-2-lax-1",
            "us-west-2",
            "sa-east-1"
        ],
        "linkUrl": "https://aws.amazon.com/fsx/windows/",
        "isActive": "true",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonFSx/en_US.json",
        "c2e": false,
        "slug": "FSx",
        "mvpSupport": false,
        "comparableTerms": [
            "fsx",
            "fsxwindows",
            "fsxwindowsfileserver"
        ]
    },
    "amazonGameLift": {
        "name": "Amazon GameLift",
        "serviceCode": "amazonGameLift",
        "description": "Amazon GameLift is a dedicated game server hosting solution that deploys, operates, and scales cloud servers for multiplayer games. Whether you’re looking for a fully managed solution, or just the feature you need, GameLift leverages the power of AWS to deliver the best latency possible, low player wait times, and maximum cost savings.",
        "searchKeywords": [
            "gamelift",
            "gamelift instances",
            "gamelift flexmatch",
            "flexmatch"
        ],
        "type": "AWSService",
        "regions": [
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2",
            "af-south-1",
            "ap-northeast-1",
            "ap-northeast-2",
            "ap-northeast-3",
            "ap-east-1",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-south-1",
            "ca-central-1",
            "eu-north-1",
            "eu-central-1",
            "eu-south-1",
            "eu-west-1",
            "eu-west-2",
            "eu-west-3",
            "me-south-1",
            "sa-east-1",
            "us-east-1-atl-1",
            "us-east-1-chi-1",
            "us-east-1-dfw-1",
            "us-west-2-den-1",
            "us-east-1-iah-1",
            "us-east-1-mci-1",
            "us-west-2-lax-1",
            "us-west-2-phx-1"
        ],
        "linkUrl": "https://aws.amazon.com/gamelift/",
        "isActive": "true",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonGameLift/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "slug": "GameLift",
        "mvpSupport": false,
        "comparableTerms": [
            "gamelift"
        ]
    },
    "amazonGuardDuty": {
        "name": "Amazon GuardDuty",
        "serviceCode": "amazonGuardDuty",
        "description": "Amazon GuardDuty is a threat detection service that continuously monitors for malicious activity and unauthorized behavior to protect your AWS accounts, workloads, and data stored in Amazon S3.",
        "searchKeywords": [
            "guard duty",
            "amazon GuardDuty"
        ],
        "type": "AWSService",
        "regions": [
            "af-south-1",
            "ap-east-1",
            "ap-northeast-1",
            "ap-northeast-2",
            "ap-south-1",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-southeast-3",
            "ap-northeast-3",
            "ca-central-1",
            "eu-central-1",
            "eu-north-1",
            "eu-south-1",
            "eu-west-1",
            "eu-west-2",
            "eu-west-3",
            "me-south-1",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-gov-east-1",
            "us-gov-west-1",
            "us-west-1",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/guardduty/",
        "isActive": "true",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonGuardDuty/en_US.json",
        "c2e": false,
        "slug": "guardduty",
        "mvpSupport": false,
        "comparableTerms": [
            "guardduty"
        ]
    },
    "amazonHealthlake": {
        "name": "Amazon Healthlake",
        "serviceCode": "amazonHealthlake",
        "description": "Amazon HealthLake is a HIPAA-eligible service offering healthcare and life sciences companies a complete view of individual or patient population health data for query and analytics at scale.",
        "searchKeywords": [
            "FHIR",
            "HIPAA",
            "NLP"
        ],
        "type": "AWSService",
        "regions": [
            "us-east-1",
            "us-east-2",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/healthlake/",
        "isActive": "true",
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonHealthlake/en_US.json",
        "c2e": false,
        "slug": "HealthLake",
        "mvpSupport": false,
        "comparableTerms": [
            "healthlake"
        ]
    },
    "amazonInspector": {
        "name": "Amazon Inspector",
        "serviceCode": "amazonInspector",
        "description": "Amazon Inspector is an automated and continual vulnerability scanning service that assesses Amazon Elastic Compute Cloud (EC2) instances and container images to improve the security and compliance of infrastructure workloads.",
        "searchKeywords": [
            "Analytics",
            "SQL",
            "query",
            "S3",
            "big data",
            "Presto",
            "serverless",
            "ad-hoc analysis",
            "log processing",
            "bigquery",
            "big query",
            "query S3 data"
        ],
        "type": "AWSService",
        "regions": [
            "ap-east-1",
            "ap-south-1",
            "ap-northeast-1",
            "ap-northeast-2",
            "ap-northeast-3",
            "ap-southeast-1",
            "ap-southeast-2",
            "us-gov-west-1",
            "us-gov-east-1",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "eu-west-3",
            "eu-north-1",
            "eu-south-1",
            "me-south-1",
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2",
            "af-south-1",
            "sa-east-1"
        ],
        "linkUrl": "https://aws.amazon.com/inspector/",
        "isActive": "true",
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonInspector/en_US.json",
        "c2e": false,
        "slug": "Inspector",
        "mvpSupport": false,
        "comparableTerms": [
            "inspector"
        ]
    },
    "amazonKendra": {
        "name": "Amazon Kendra",
        "serviceCode": "amazonKendra",
        "description": "Amazon Kendra is an intelligent search service powered by machine learning. Kendra reimagines enterprise search for your websites and applications so your employees and customers can easily find the content they are looking for, even when it’s scattered across multiple locations and content repositories within your organization.",
        "searchKeywords": [
            "kendra"
        ],
        "type": "AWSService",
        "regions": [
            "us-east-1",
            "us-west-2",
            "eu-west-1",
            "ap-southeast-2"
        ],
        "linkUrl": "https://aws.amazon.com/kendra",
        "isActive": "true",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonKendra/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "bulkImportEnabled": false,
        "serviceDefinitionUrlPath": "/data/amazonKendra/en_US.json",
        "slug": "Kendra",
        "mvpSupport": false,
        "comparableTerms": [
            "kendra"
        ]
    },
    "amazonKinesisDataAnalytics": {
        "name": "Amazon Kinesis Data Analytics",
        "serviceCode": "amazonKinesisDataAnalytics",
        "description": "Amazon Kinesis Data Analytics is the easiest way to analyze streaming data, gain actionable insights, and respond to your business and customer needs in real time.",
        "searchKeywords": [
            "Kinesis",
            "streaming",
            "insights"
        ],
        "type": "AWSService",
        "regions": [
            "us-gov-west-1",
            "us-gov-east-1",
            "ap-east-1",
            "ap-south-1",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-northeast-1",
            "ap-northeast-2",
            "ap-northeast-3",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "eu-west-3",
            "eu-north-1",
            "eu-south-1",
            "me-south-1",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2",
            "af-south-1"
        ],
        "linkUrl": "https://aws.amazon.com/kinesis/data-analytics/",
        "isActive": "true",
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonKinesisDataAnalytics/en_US.json",
        "c2e": false,
        "slug": "KinesisDataAnalytics",
        "mvpSupport": false,
        "comparableTerms": [
            "kinesisdataanalytics"
        ]
    },
    "amazonKinesisFirehose": {
        "name": "Amazon Kinesis Data Firehose",
        "serviceCode": "amazonKinesisFirehose",
        "description": "With Amazon Kinesis Data Firehose, you pay for the volume of data you ingest into the service. There are no set up fees or upfront commitments. You are billed for the volume of data ingested into Kinesis Data Firehose, and if applicable, for data format conversion to Apache Parquet or ORC.",
        "searchKeywords": [
            "Analytics",
            "kinesis analytics",
            "kinesis streams",
            "kinesis firehose",
            "firehose",
            "VPC",
            "data format conversion",
            "streaming",
            "data streaming",
            "real-time",
            "analysis",
            "kafka",
            "spark",
            "put records",
            "kcl",
            "kpl",
            "sql",
            "ORC",
            "stream processing",
            "sql on streams",
            "stream ingestion",
            "IoT analytics",
            "real-time bidding",
            "RTB",
            "log analytics",
            "clickstream analytics",
            "real time alerts",
            "real time dashboards",
            "real time monitoring",
            "dynamic partitioning"
        ],
        "type": "AWSService",
        "regions": [
            "us-gov-west-1",
            "us-gov-east-1",
            "af-south-1",
            "ap-east-1",
            "ap-south-1",
            "ap-northeast-2",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-southeast-3",
            "ap-northeast-1",
            "ap-northeast-2",
            "ap-northeast-3",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "eu-south-1",
            "eu-west-3",
            "eu-north-1",
            "me-south-1",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/kinesis/data-firehose/",
        "isActive": "true",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonKinesisFirehose/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/amazonKinesisFirehose/en_US.json",
        "slug": "KinesisDataFirehose",
        "mvpSupport": false,
        "comparableTerms": [
            "kinesisdatafirehose",
            "kinesisfirehose"
        ]
    },
    "amazonKinesisDataStreams": {
        "name": "Amazon Kinesis Data Streams",
        "serviceCode": "amazonKinesisDataStreams",
        "description": "Amazon Kinesis Data Streams (KDS) is a massively scalable and durable real-time data streaming service.",
        "searchKeywords": [
            "Analytics",
            "kinesis analytics",
            "kinesis streams",
            "kinesis firehose",
            "streaming",
            "data streaming",
            "real-time",
            "analysis",
            "kafka",
            "spark",
            "put records",
            "kcl",
            "kpl",
            "sql",
            "stream processing",
            "sql on streams",
            "stream ingestion",
            "IoT analytics",
            "real-time bidding",
            "RTB",
            "log analytics",
            "clickstream analytics",
            "real time alerts",
            "real time dashboards",
            "real time monitoring"
        ],
        "type": "AWSService",
        "regions": [
            "af-south-1",
            "ap-east-1",
            "ap-northeast-1",
            "ap-northeast-2",
            "ap-northeast-3",
            "ap-south-1",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-southeast-3",
            "ca-central-1",
            "eu-central-1",
            "eu-north-1",
            "eu-south-1",
            "eu-west-1",
            "eu-west-2",
            "eu-west-3",
            "me-south-1",
            "me-central-1",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-gov-east-1",
            "us-gov-west-1",
            "us-west-1",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/kinesis/data-streams/",
        "isActive": "true",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonKinesisDataStreams/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "slug": "KinesisDataStreams",
        "mvpSupport": false,
        "comparableTerms": [
            "kinesisdatastreams"
        ]
    },
    "amazonKinesisVideoStreams": {
        "name": "Amazon Kinesis Video Streams",
        "serviceCode": "amazonKinesisVideoStreams",
        "description": "Amazon Kinesis Video Streams makes it easy to securely stream video from connected devices to AWS for analytics, machine learning (ML), playback, and other processing. Kinesis Video Streams automatically provisions and elastically scales all the infrastructure needed to ingest streaming video data from millions of devices.",
        "searchKeywords": [
            "video stream",
            "signaling channel",
            "turn streaming",
            "webRTC",
            "video analytics",
            "HTTP live streaming",
            "HLS",
            "KVS"
        ],
        "type": "AWSService",
        "regions": [
            "us-east-1",
            "us-east-2",
            "us-west-2",
            "ap-east-1",
            "ap-south-1",
            "ap-northeast-2",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-northeast-1",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "eu-west-3",
            "sa-east-1"
        ],
        "linkUrl": "https://aws.amazon.com/kinesis/video-streams",
        "isActive": "true",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonKinesisVideoStreams/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "slug": "KinesisVideoStreams",
        "mvpSupport": false,
        "comparableTerms": [
            "kinesisvideostreams"
        ]
    },
    "amazonLex": {
        "name": "Amazon Lex",
        "serviceCode": "amazonLex",
        "description": "Amazon Lex is a service for building conversational interfaces into any application using voice and text. With Amazon Lex, you pay only for what you use.",
        "searchKeywords": [
            "bot",
            "chat",
            "chatbot",
            "conversation",
            "conversational interfaces",
            "response",
            "speech",
            "streaming conversation",
            "text",
            "transcripts",
            "virtual agent",
            "voice chat"
        ],
        "type": "AWSService",
        "regions": [
            "us-east-1",
            "us-west-2",
            "af-south-1",
            "ap-northeast-2",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-northeast-1",
            "eu-west-2",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "us-gov-west-1"
        ],
        "linkUrl": "https://aws.amazon.com/lex",
        "isActive": "true",
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonLex/en_US.json",
        "c2e": false,
        "slug": "lex",
        "mvpSupport": false,
        "comparableTerms": [
            "lex"
        ]
    },
    "amazonLightsail": {
        "name": "Amazon Lightsail",
        "serviceCode": "amazonLightsail",
        "description": "Lightsail is an easy-to-use virtual private server (VPS) that offers you everything needed to build an application or website, plus a cost-effective, monthly plan. Lightsail is ideal for simpler workloads, quick deployments, and getting started on AWS. It’s designed to help you start small, and then scale as you grow.",
        "searchKeywords": [
            "virtual servers",
            "databases",
            "containers",
            "load balancer",
            "content delivery network",
            "CDN",
            "block storage",
            "snapshots",
            "vps",
            "virtual private server"
        ],
        "type": "AWSService",
        "regions": [],
        "linkUrl": "https://aws.amazon.com/lightsail/",
        "isActive": "true",
        "hasDataTransfer": true,
        "subType": "subServiceSelector",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonLightsail/en_US.json",
        "c2e": false,
        "templates": [
            "lightsailVirtualServers",
            "lightsailManagedDatabases",
            "lightsailContainers",
            "lightsailObjectStorage",
            "lightsailCdn",
            "lightsailLoadBalancer",
            "lightsailBlockStorage",
            "lightsailDataTransfer"
        ],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/amazonLightsail/en_US.json",
        "slug": "Lightsail",
        "mvpSupport": false,
        "comparableTerms": [
            "lightsail"
        ]
    },
    "amazonLookoutForMetrics": {
        "name": "Amazon Lookout for Metrics",
        "serviceCode": "amazonLookoutForMetrics",
        "description": "Amazon Lookout for Metrics uses machine learning (ML) to automatically detect and diagnose anomalies (i.e. outliers from the norm) in business and operational data, such as a sudden dip in sales revenue or customer acquisition rates. In a couple of clicks, you can connect Amazon Lookout for Metrics to popular data stores like Amazon S3, Amazon Redshift, and Amazon Relational Database Service (RDS), as well as third-party SaaS applications, such as Salesforce, Servicenow, Zendesk, and Marketo, and start monitoring metrics that are important to your business. Amazon Lookout for Metrics automatically inspects and prepares the data from these sources to detect anomalies with greater speed and accuracy than traditional methods used for anomaly detection. You can also provide feedback on detected anomalies to tune the results and improve accuracy over time. Amazon Lookout for Metrics makes it easy to diagnose detected anomalies by grouping together anomalies that are related to the same event and sending an alert that includes a summary of the potential root cause. It also ranks anomalies in order of severity so that you can prioritize your attention to what matters the most to your business.",
        "searchKeywords": [
            "lookout for metrics",
            "metrics",
            "anomalies",
            "anomaly detection",
            "machine learning",
            "ML-powered anomaly detection",
            "Anomaly Grouping and Ranking",
            "Tunable results",
            "automated alerts",
            "anomaly detection model",
            "detector",
            "outlier",
            "outlier detection"
        ],
        "type": "AWSService",
        "regions": [
            "us-east-2",
            "ap-southeast-2",
            "eu-north-1",
            "ap-southeast-1",
            "eu-west-1",
            "us-west-2",
            "us-east-1",
            "ap-northeast-1",
            "eu-central-1"
        ],
        "linkUrl": "https://aws.amazon.com/lookout-for-metrics/",
        "isActive": "true",
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonLookoutForMetrics/en_US.json",
        "c2e": false,
        "slug": "LookoutForMetrics",
        "mvpSupport": false,
        "comparableTerms": [
            "lookoutformetrics",
            "lookoutmetrics"
        ]
    },
    "amazonLookoutForVision": {
        "name": "Amazon Lookout for Vision",
        "serviceCode": "amazonLookoutForVision",
        "description": "Amazon Lookout for Vision is a machine learning (ML) service that spots defects and anomalies in visual representations using computer vision (CV). With Amazon Lookout for Vision, manufacturing companies can increase quality and reduce operational costs by quickly identifying differences in images of objects at scale.",
        "searchKeywords": [
            "lookout",
            "vision"
        ],
        "type": "AWSService",
        "regions": [
            "ap-northeast-2",
            "ap-northeast-1",
            "eu-central-1",
            "eu-west-1",
            "us-east-1",
            "us-east-2",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/lookout-for-vision/",
        "isActive": "true",
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonLookoutForVision/en_US.json",
        "c2e": false,
        "slug": "LookoutVision",
        "comparableTerms": [
            "lookoutforvision",
            "lookoutvision"
        ]
    },
    "amazonMacie": {
        "name": "Amazon Macie",
        "serviceCode": "amazonMacie",
        "description": "Amazon Macie is a fully managed data security and data privacy service that uses machine learning and pattern matching to discover and protect your sensitive data in AWS. With Amazon Macie, you are charged based on the number of Amazon S3 buckets evaluated for bucket-level security and access controls and the quantity of data processed for sensitive data discovery.",
        "searchKeywords": [
            "data security",
            "data privacy",
            "machine learning",
            "pattern matching",
            "sensitive data protection",
            "S3 buckets",
            "PII",
            "HIPAA",
            "GDPR"
        ],
        "type": "AWSService",
        "regions": [
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2",
            "af-south-1",
            "ap-east-1",
            "ap-south-1",
            "ap-northeast-3",
            "ap-northeast-2",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-northeast-1",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "eu-south-1",
            "eu-west-3",
            "eu-north-1",
            "me-south-1",
            "sa-east-1"
        ],
        "linkUrl": "https://aws.amazon.com/macie/",
        "isActive": "true",
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonMacie/en_US.json",
        "c2e": false,
        "slug": "Macie",
        "mvpSupport": false,
        "comparableTerms": [
            "macie"
        ]
    },
    "amazonManagedBlockchain": {
        "name": "Amazon Managed Blockchain",
        "serviceCode": "amazonManagedBlockchain",
        "description": "Amazon Managed Blockchain is a fully managed service that makes it easy to join public networks or create and manage scalable private networks using the popular open-source frameworks Hyperledger Fabric and Ethereum.",
        "searchKeywords": [
            "hyperledger Fabric",
            "ethereum",
            "blockchain",
            "managed blockchain"
        ],
        "type": "AWSService",
        "regions": [
            "us-east-1",
            "ap-northeast-1",
            "ap-northeast-2",
            "ap-southeast-1",
            "eu-west-1",
            "eu-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/managed-blockchain/",
        "isActive": "true",
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonManagedBlockchain/en_US.json",
        "c2e": false,
        "slug": "ManagedBlockchain",
        "mvpSupport": false,
        "comparableTerms": [
            "managedblockchain"
        ]
    },
    "amazonManagedServiceForPrometheus": {
        "name": "Amazon Managed Service for Prometheus",
        "serviceCode": "amazonManagedServiceForPrometheus",
        "description": "Amazon Managed Service for Prometheus is a Prometheus-compatible monitoring service that makes it easy to monitor containerized applications at scale. The Cloud Native Computing Foundation’s Prometheus project is a popular open source monitoring and alerting solution optimized for container environments. With Amazon Managed Service for Prometheus, you can use the open source Prometheus query language (PromQL) to monitor the performance of containerized workloads, without having to manage the underlying infrastructure.",
        "searchKeywords": [
            "MSP",
            "Prometheus",
            "Managed Service for Prometheus"
        ],
        "type": "AWSService",
        "regions": [
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-northeast-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "eu-north-1",
            "us-east-1",
            "us-east-2",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/prometheus/",
        "isActive": "true",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonManagedServiceForPrometheus/en_US.json",
        "c2e": false,
        "slug": "Prometheus",
        "mvpSupport": false,
        "comparableTerms": [
            "managedserviceforprometheus",
            "managedserviceprometheus",
            "prometheus"
        ]
    },
    "amazonManagedStreamingForApacheKafkaMsk": {
        "name": "Amazon Managed Streaming for Apache Kafka (MSK)",
        "serviceCode": "amazonManagedStreamingForApacheKafkaMsk",
        "description": "Amazon MSK is a fully managed service that makes it easy for you to build and run applications that use Apache Kafka to process streaming data. With Amazon MSK, you can use native Apache Kafka APIs to populate data lakes, stream changes to and from databases, and power machine learning and analytics applications.",
        "searchKeywords": [
            "MSK",
            "Apache Kafka"
        ],
        "type": "AWSService",
        "regions": [
            "af-south-1",
            "ap-east-1",
            "ap-south-1",
            "ap-northeast-2",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-northeast-1",
            "ap-northeast-3",
            "us-gov-east-1",
            "us-gov-west-1",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "eu-south-1",
            "eu-west-3",
            "eu-north-1",
            "me-south-1",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2"
        ],
        "isActive": "true",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonManagedStreamingForApacheKafkaMsk/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "slug": "MSK",
        "mvpSupport": false,
        "comparableTerms": [
            "managedstreamingapachekafkamsk",
            "managedstreamingforapachekafkamsk",
            "msk"
        ]
    },
    "amazonManagedWorkflowsForApacheAirflow": {
        "name": "Amazon Managed Workflows for Apache Airflow",
        "serviceCode": "amazonManagedWorkflowsForApacheAirflow",
        "description": "Amazon Managed Workflows for Apache Airflow (MWAA) is a managed orchestration service for Apache Airflow1 that makes it easier to set up and operate end-to-end data pipelines in the cloud at scale. Apache Airflow is an open-source tool used to programmatically author, schedule, and monitor sequences of processes and tasks referred to as “workflows.” With Managed Workflows, you can use Airflow and Python to create workflows without having to manage the underlying infrastructure for scalability, availability, and security.",
        "searchKeywords": [
            "MWAA",
            "Workflows",
            "Apache Airflow",
            "Managed Workflows for Apache Airflow"
        ],
        "type": "AWSService",
        "regions": [
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2",
            "ap-south-1",
            "ap-northeast-2",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-northeast-1",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "eu-west-3",
            "eu-north-1",
            "sa-east-1"
        ],
        "linkUrl": "https://aws.amazon.com/managed-workflows-for-apache-airflow/",
        "isActive": "true",
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonManagedWorkflowsForApacheAirflow/en_US.json",
        "c2e": false,
        "slug": "MWAA",
        "mvpSupport": false,
        "comparableTerms": [
            "managedworkflowsapacheairflow",
            "managedworkflowsforapacheairflow",
            "mwaa"
        ]
    },
    "amazonMemoryDbForRedis": {
        "name": "Amazon MemoryDB for Redis",
        "serviceCode": "amazonMemoryDbForRedis",
        "description": "Amazon MemoryDB for Redis is a Redis-compatible, durable, in-memory database that delivers ultra-fast performance and Multi-AZ durability.",
        "searchKeywords": [
            "memorydb",
            "Amazon MemoryDB for Redis"
        ],
        "type": "AWSService",
        "regions": [
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2",
            "ap-east-1",
            "ap-south-1",
            "ap-northeast-2",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-northeast-1",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "eu-west-3",
            "eu-north-1",
            "eu-south-1",
            "sa-east-1"
        ],
        "linkUrl": "https://aws.amazon.com/memorydb/",
        "isActive": "true",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonMemoryDbForRedis/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "bulkImportEnabled": false,
        "serviceDefinitionUrlPath": "/data/amazonMemoryDbForRedis/en_US.json",
        "slug": "memorydb",
        "mvpSupport": false,
        "comparableTerms": [
            "memorydb",
            "memorydbforredis",
            "memorydbredis"
        ]
    },
    "amazonMQ": {
        "name": "Amazon MQ",
        "serviceCode": "amazonMQ",
        "description": "Amazon MQ is a managed message broker service for Apache ActiveMQ that makes it easy to set up and operate message brokers in the cloud.",
        "searchKeywords": [
            "MQ",
            "rabbit",
            "broker",
            "Apache ActiveMQ"
        ],
        "type": "AWSService",
        "regions": [
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2",
            "af-south-1",
            "ap-east-1",
            "ap-northeast-1",
            "ap-northeast-2",
            "ap-northeast-3",
            "ap-south-1",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-southeast-3",
            "ca-central-1",
            "eu-central-1",
            "eu-north-1",
            "eu-south-1",
            "eu-west-1",
            "eu-west-2",
            "eu-west-3",
            "sa-east-1",
            "me-south-1",
            "us-gov-west-1",
            "us-gov-east-1"
        ],
        "linkUrl": "https://aws.amazon.com/amazon-mq/",
        "isActive": "true",
        "hasDataTransfer": true,
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonMQ/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/amazonMQ/en_US.json",
        "slug": "MQ",
        "mvpSupport": false,
        "comparableTerms": [
            "mq"
        ]
    },
    "amazonNeptune": {
        "name": "Amazon Neptune",
        "serviceCode": "amazonNeptune",
        "description": "Amazon Neptune is a fast, reliable, fully managed graph database service that makes it easy to build and run applications that work with highly connected datasets.",
        "searchKeywords": [
            "Neptune",
            "Graph database"
        ],
        "type": "AWSService",
        "regions": [
            "af-south-1",
            "ap-east-1",
            "ap-northeast-1",
            "ap-northeast-2",
            "ap-south-1",
            "ap-southeast-1",
            "ap-southeast-2",
            "ca-central-1",
            "eu-central-1",
            "eu-north-1",
            "eu-west-1",
            "eu-west-2",
            "eu-west-3",
            "me-south-1",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-gov-west-1",
            "us-gov-east-1",
            "us-west-1",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/neptune/",
        "isActive": "true",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonNeptune/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "slug": "neptune",
        "mvpSupport": false,
        "comparableTerms": [
            "neptune"
        ]
    },
    "amazonElasticsearchService": {
        "name": "Amazon OpenSearch Service",
        "serviceCode": "amazonElasticsearchService",
        "description": "Amazon OpenSearch Service is a fully managed service that makes it easy for you to deploy, secure, and operate OpenSearch clusters at scale.",
        "searchKeywords": [
            "Analytics",
            "ES",
            "Kibana",
            "Logstash",
            "Search",
            "Text search",
            "Time series",
            "Log analytics",
            "Analytics",
            "Real time analytics",
            "Streaming data analytics",
            "CloudSearch",
            "search",
            "ultraWarm",
            "ultrawarm",
            "opensearch",
            "open search"
        ],
        "type": "AWSService",
        "regions": [
            "af-south-1",
            "ap-east-1",
            "ap-south-1",
            "ap-northeast-2",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-southeast-3",
            "ap-northeast-1",
            "ap-northeast-3",
            "us-gov-east-1",
            "us-gov-west-1",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "eu-west-3",
            "eu-north-1",
            "eu-south-1",
            "me-south-1",
            "me-central-1",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/opensearch-service/",
        "isActive": "true",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonElasticsearchService/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "bulkImportEnabled": false,
        "serviceDefinitionUrlPath": "/data/amazonElasticsearchService/en_US.json",
        "slug": "OpenSearchService",
        "mvpSupport": false,
        "comparableTerms": [
            "elasticsearch",
            "elasticsearchservice",
            "opensearch",
            "opensearchservice"
        ]
    },
    "amazonPersonalize": {
        "name": "Amazon Personalize",
        "serviceCode": "amazonPersonalize",
        "description": "Amazon Personalize enables developers to build applications with the same machine learning (ML) technology used by Amazon.com for real-time personalized recommendations – no ML expertise required.",
        "searchKeywords": [
            "personalize",
            "Amazon personalize"
        ],
        "type": "AWSService",
        "regions": [
            "ap-northeast-1",
            "ap-northeast-2",
            "ap-south-1",
            "ap-southeast-1",
            "ap-southeast-2",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "us-east-1",
            "us-east-2",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/personalize/",
        "isActive": "true",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonPersonalize/en_US.json",
        "c2e": false,
        "slug": "personalize",
        "mvpSupport": false,
        "comparableTerms": [
            "personalize"
        ]
    },
    "amazonPinpoint": {
        "name": "Amazon Pinpoint",
        "serviceCode": "amazonPinpoint",
        "description": "Amazon Pinpoint is a flexible and scalable outbound and inbound marketing communications service. You can connect with customers over channels like email, SMS, push, or voice. Amazon Pinpoint is easy to set up, easy to use, and is flexible for all marketing communication scenarios. ",
        "searchKeywords": [
            "marketing",
            "communications",
            "email",
            "SMS",
            "messages",
            "campaign"
        ],
        "type": "AWSService",
        "regions": [
            "us-west-2",
            "us-east-1",
            "ap-northeast-2",
            "ap-south-1",
            "ap-southeast-2",
            "ap-northeast-1",
            "ap-southeast-1",
            "eu-west-2",
            "eu-west-1",
            "eu-central-1",
            "ca-central-1",
            "us-gov-west-1"
        ],
        "linkUrl": "https://aws.amazon.com/pinpoint/",
        "isActive": "true",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonPinpoint/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/amazonPinpoint/en_US.json",
        "slug": "Pinpoint",
        "mvpSupport": false,
        "comparableTerms": [
            "pinpoint"
        ]
    },
    "amazonPolly": {
        "name": "Amazon Polly",
        "serviceCode": "amazonPolly",
        "description": "Amazon Polly is a service that turns text into lifelike speech, allowing you to create applications that talk, and build entirely new categories of speech-enabled products.",
        "searchKeywords": [
            "polly",
            "NLP",
            "speech",
            "text to speech"
        ],
        "type": "AWSService",
        "regions": [],
        "linkUrl": "https://aws.amazon.com/polly/",
        "isActive": "true",
        "subType": "subServiceSelector",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonPolly/en_US.json",
        "c2e": false,
        "templates": [
            "neuralTextToSpeech",
            "standardTextToSpeechTts"
        ],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/amazonPolly/en_US.json",
        "slug": "polly",
        "mvpSupport": false,
        "comparableTerms": [
            "polly"
        ]
    },
    "amazonQuickSight": {
        "name": "Amazon QuickSight",
        "serviceCode": "amazonQuickSight",
        "description": "Amazon QuickSight is a fast, cloud-powered business intelligence service that makes it easy to deliver insights to everyone in your organization. QuickSight dashboards can be embedded in applications, require no infrastructure setup or management, and can automatically scale to tens of thousands of users.",
        "searchKeywords": [
            "QuickSight",
            "Serverless",
            "Embedding",
            "BI",
            "Business intelligence",
            "Data visualization",
            "Insights",
            "Embedded Analytics"
        ],
        "type": "AWSService",
        "regions": [],
        "linkUrl": "https://aws.amazon.com/quicksight/",
        "isActive": "true",
        "subType": "subServiceSelector",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonQuickSight/en_US.json",
        "c2e": false,
        "templates": [
            "amazonQuickSightReadersAuthorsSpice",
            "amazonQuickSightAnomalyDetection"
        ],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/amazonQuickSight/en_US.json",
        "slug": "QuickSight",
        "mvpSupport": false,
        "comparableTerms": [
            "quicksight"
        ]
    },
    "amazonQuickSightAnomalyDetection": {
        "name": "Amazon QuickSight Alerts & Anomaly Detection",
        "serviceCode": "amazonQuickSightAnomalyDetection",
        "description": "",
        "searchKeywords": [],
        "type": "AWSService",
        "regions": [
            "us-east-1",
            "us-east-2",
            "us-west-2",
            "ap-south-1",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-northeast-1",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "eu-north-1",
            "sa-east-1",
            "us-gov-west-1"
        ],
        "isActive": "true",
        "subType": "subService",
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonQuickSightAnomalyDetection/en_US.json",
        "c2e": false,
        "mvpSupport": false,
        "comparableTerms": [
            "quicksightalertsanomalydetection",
            "quicksightanomalydetection"
        ],
        "parentServiceCode": "amazonQuickSight"
    },
    "amazonQuickSightReadersAuthorsSpice": {
        "name": "Amazon QuickSight Readers, Authors, SPICE",
        "serviceCode": "amazonQuickSightReadersAuthorsSpice",
        "description": "Amazon QuickSight is a fast, cloud-powered business intelligence service that makes it easy to deliver insights to everyone in your organization. QuickSight dashboards can be embedded in applications, require no infrastructure setup or management, and can automatically scale to tens of thousands of users.",
        "searchKeywords": [
            "QuickSight",
            "Serverless",
            "Embedding",
            "BI",
            "Business intelligence",
            "Data visualization",
            "Insights",
            "Embedded Analytics"
        ],
        "type": "AWSService",
        "regions": [
            "us-east-1",
            "us-east-2",
            "us-west-2",
            "ap-south-1",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-northeast-1",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "eu-north-1",
            "sa-east-1",
            "us-gov-west-1"
        ],
        "linkUrl": "https://aws.amazon.com/quicksight/",
        "isActive": "true",
        "subType": "subService",
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonQuickSightReadersAuthorsSpice/en_US.json",
        "c2e": false,
        "comparableTerms": [
            "quicksightreadersauthorsspice"
        ],
        "parentServiceCode": "amazonQuickSight"
    },
    "amazonRdsCustomForOracle": {
        "name": "Amazon RDS Custom for Oracle",
        "serviceCode": "amazonRdsCustomForOracle",
        "description": "Amazon Relational Database Service (Amazon RDS) Custom is a managed database service for legacy, custom, and packaged applications that require access to the underlying OS and DB environment. Amazon RDS Custom automates setup, operation, and scaling of databases in the cloud while granting access to the database and underlying operating system to configure settings, install patches, and enable native features to meet the dependent application's requirements.",
        "searchKeywords": [],
        "type": "AWSService",
        "regions": [
            "ap-northeast-1",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-south-1",
            "eu-central-1",
            "eu-north-1",
            "eu-west-1",
            "eu-west-2",
            "us-east-1",
            "us-east-2",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/rds/custom",
        "isActive": "true",
        "hasDataTransfer": false,
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonRdsCustomForOracle/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "slug": "RDSCustomForOracle",
        "mvpSupport": false,
        "comparableTerms": [
            "rdscustom",
            "rdscustomfororacle",
            "rdscustomoracle"
        ]
    },
    "amazonRdsCustomForSqlServer": {
        "name": "Amazon RDS Custom for SQL Server",
        "serviceCode": "amazonRdsCustomForSqlServer",
        "description": "Amazon Relational Database Service (Amazon RDS) Custom is a managed database service for legacy, custom, and packaged applications that require access to the underlying OS and DB environment. Amazon RDS Custom automates setup, operation, and scaling of databases in the cloud while granting access to the database and underlying operating system to configure settings, install patches, and enable native features to meet the dependent application's requirements.",
        "searchKeywords": [],
        "type": "AWSService",
        "regions": [
            "ap-northeast-1",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-south-1",
            "eu-central-1",
            "eu-north-1",
            "eu-west-1",
            "eu-west-2",
            "us-east-1",
            "us-east-2",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/rds/custom",
        "isActive": "true",
        "hasDataTransfer": false,
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonRdsCustomForSqlServer/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "slug": "RDSCustomForSQLServer",
        "mvpSupport": false,
        "comparableTerms": [
            "rdscustom",
            "rdscustomforsqlserver",
            "rdscustomsqlserver"
        ]
    },
    "amazonRDSMariaDB": {
        "name": "Amazon RDS for MariaDB",
        "serviceCode": "amazonRDSMariaDB",
        "description": "Amazon RDS makes it easy to set up, operate, and scale MariaDB database deployments in the cloud.",
        "searchKeywords": [
            "Database",
            "MariaDB",
            "database hosting",
            "hosted database",
            "Managed database"
        ],
        "type": "AWSService",
        "regions": [
            "af-south-1",
            "ap-northeast-1",
            "ap-northeast-2",
            "ap-northeast-3",
            "ap-south-1",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-southeast-3",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "eu-west-3",
            "eu-north-1",
            "eu-south-1",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-gov-west-1",
            "us-west-1",
            "us-west-2",
            "us-gov-east-1",
            "ap-east-1",
            "me-south-1",
            "me-central-1"
        ],
        "linkUrl": "https://aws.amazon.com/rds/mariadb",
        "isActive": "true",
        "hasDataTransfer": true,
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonRDSMariaDB/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "bulkImportEnabled": false,
        "serviceDefinitionUrlPath": "/data/amazonRDSMariaDB/en_US.json",
        "slug": "RDSMariaDB",
        "mvpSupport": false,
        "comparableTerms": [
            "rdsmariadb"
        ]
    },
    "amazonRDSMySQLDB": {
        "name": "Amazon RDS for MySQL",
        "serviceCode": "amazonRDSMySQLDB",
        "description": "MySQL is the world's most popular open source relational database. Amazon RDS makes it easy to set up, operate, and scale MySQL deployments in the cloud.",
        "searchKeywords": [],
        "type": "AWSService",
        "regions": [
            "af-south-1",
            "ap-northeast-1",
            "ap-northeast-2",
            "ap-northeast-3",
            "ap-south-1",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-southeast-3",
            "ca-central-1",
            "eu-central-1",
            "eu-south-1",
            "eu-west-1",
            "eu-west-2",
            "eu-west-3",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-gov-west-1",
            "us-west-1",
            "us-west-2",
            "us-gov-east-1",
            "eu-north-1",
            "ap-east-1",
            "me-south-1",
            "me-central-1"
        ],
        "linkUrl": "https://aws.amazon.com/rds/mysql",
        "isActive": "true",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonRDSMySQLDB/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "bulkImportEnabled": false,
        "serviceDefinitionUrlPath": "/data/amazonRDSMySQLDB/en_US.json",
        "slug": "RDSMySQL",
        "mvpSupport": false,
        "comparableTerms": [
            "rdsmysql",
            "rdsmysqldb"
        ]
    },
    "amazonRdsForOracle": {
        "name": "Amazon RDS for Oracle",
        "serviceCode": "amazonRdsForOracle",
        "description": "Oracle® Database is a relational database management system developed by Oracle. Amazon RDS makes it easy to set up, operate, and scale Oracle Database deployments in the cloud. With Amazon RDS, you can deploy multiple editions of Oracle Database in minutes with cost-efficient and re-sizable hardware capacity.",
        "searchKeywords": [],
        "type": "AWSService",
        "regions": [
            "us-west-2",
            "us-west-1",
            "us-east-2",
            "us-east-1",
            "sa-east-1",
            "me-south-1",
            "me-central-1",
            "af-south-1",
            "eu-north-1",
            "eu-west-3",
            "eu-west-2",
            "eu-west-1",
            "eu-south-1",
            "eu-central-1",
            "ca-central-1",
            "us-gov-east-1",
            "us-gov-west-1",
            "ap-northeast-1",
            "ap-southeast-2",
            "ap-southeast-1",
            "ap-northeast-2",
            "ap-northeast-3",
            "ap-southeast-3",
            "ap-south-1",
            "ap-east-1"
        ],
        "linkUrl": "https://aws.amazon.com/rds/oracle",
        "isActive": "true",
        "hasDataTransfer": false,
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonRdsForOracle/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "slug": "amazonRDSOracle",
        "mvpSupport": false,
        "comparableTerms": [
            "rdsfororacle",
            "rdsoracle"
        ]
    },
    "amazonRDSPostgreSQLDB": {
        "name": "Amazon RDS for PostgreSQL",
        "serviceCode": "amazonRDSPostgreSQLDB",
        "description": "Amazon RDS makes it easy to set up, operate, and scale PostgreSQL deployments in the cloud. With Amazon RDS, you can deploy scalable PostgreSQL deployments in minutes with cost-efficient and resizable hardware capacity. ",
        "searchKeywords": [
            "Database",
            "PostgreSQL",
            "postgresql",
            "database hosting",
            "hosted database",
            "Managed database"
        ],
        "type": "AWSService",
        "regions": [
            "af-south-1",
            "ap-northeast-1",
            "ap-northeast-2",
            "ap-northeast-3",
            "ap-south-1",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-southeast-3",
            "ca-central-1",
            "eu-central-1",
            "eu-north-1",
            "eu-south-1",
            "eu-west-1",
            "eu-west-2",
            "eu-west-3",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-gov-west-1",
            "us-west-1",
            "us-west-2",
            "us-gov-east-1",
            "ap-east-1",
            "me-south-1",
            "me-central-1"
        ],
        "linkUrl": "https://aws.amazon.com/rds/postgresql",
        "isActive": "true",
        "hasDataTransfer": true,
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonRDSPostgreSQLDB/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "bulkImportEnabled": false,
        "serviceDefinitionUrlPath": "/data/amazonRDSPostgreSQLDB/en_US.json",
        "slug": "RDSPostgreSQL",
        "mvpSupport": false,
        "comparableTerms": [
            "rdspostgresql",
            "rdspostgresqldb"
        ]
    },
    "amazonRDSForSQLServer": {
        "name": "Amazon RDS for SQL server",
        "serviceCode": "amazonRDSForSQLServer",
        "description": "SQL Server is a relational database management system developed by Microsoft. Amazon RDS for SQL Server makes it easy to set up, operate, and scale SQL Server deployments in the cloud.",
        "searchKeywords": [
            "Database",
            "Aurora",
            "MySQL",
            "MariaDB",
            "Postgres",
            "Oracle",
            "SQL Server",
            "Database",
            "PostgreSQL",
            "Microsoft SQL Server",
            "Relational Database Service",
            "Database",
            "database hosting",
            "hosted database",
            "Managed database",
            "microsoft",
            "sql",
            "msft",
            "Managed Service",
            "MS",
            "Managed",
            "win"
        ],
        "type": "AWSService",
        "regions": [
            "af-south-1",
            "us-west-2",
            "us-west-1",
            "us-east-2",
            "us-east-1",
            "sa-east-1",
            "me-south-1",
            "me-central-1",
            "eu-north-1",
            "eu-west-3",
            "eu-west-2",
            "eu-west-1",
            "eu-south-1",
            "eu-central-1",
            "ca-central-1",
            "us-gov-east-1",
            "us-gov-west-1",
            "ap-northeast-1",
            "ap-southeast-3",
            "ap-southeast-2",
            "ap-southeast-1",
            "ap-northeast-2",
            "ap-northeast-3",
            "ap-south-1",
            "ap-east-1"
        ],
        "linkUrl": "https://aws.amazon.com/rds/",
        "isActive": "true",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonRDSForSQLServer/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "slug": "RDSSQLServer",
        "mvpSupport": false,
        "comparableTerms": [
            "rds",
            "rdsforsqlserver",
            "rdssqlserver"
        ]
    },
    "amazonRdsForOutposts": {
        "name": "Amazon RDS on AWS Outposts",
        "serviceCode": "amazonRdsForOutposts",
        "description": "Amazon Relational Database Service (Amazon RDS) on AWS Outposts allows you to deploy fully managed database instances in your on-premises environments. AWS Outposts is a fully managed service that extends AWS infrastructure, AWS services, APIs, and tools to virtually any datacenter, co-location space, or on-premises facility for a truly consistent hybrid experience. You can deploy Amazon RDS on Outposts to set up, operate, and scale Microsoft SQL Server, MySQL and PostgreSQL relational databases on premises, just as you would in the cloud. Amazon RDS on Outposts provides cost-efficient and resizable capacity for on-premises databases, while automating time-consuming administration tasks including infrastructure provisioning, database setup, patching, and backups, freeing you to focus on your applications.",
        "searchKeywords": [],
        "type": "AWSService",
        "regions": [
            "af-south-1",
            "ap-east-1",
            "ap-east-1",
            "ap-northeast-1",
            "ap-northeast-2",
            "ap-south-1",
            "ap-southeast-1",
            "ap-southeast-2",
            "ca-central-1",
            "eu-central-1",
            "eu-north-1",
            "eu-south-1",
            "eu-west-1",
            "eu-west-2",
            "eu-west-3",
            "me-south-1",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/rds/outposts",
        "isActive": "true",
        "hasDataTransfer": false,
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonRdsForOutposts/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "slug": "RDSOutposts",
        "mvpSupport": false,
        "comparableTerms": [
            "rdsforoutposts",
            "rdsonoutposts",
            "rdsoutposts"
        ]
    },
    "amazonRedshift": {
        "name": "Amazon Redshift",
        "serviceCode": "amazonRedshift",
        "description": "Amazon Redshift is a fully managed, petabyte-scale data warehouse service in the cloud. Amazon Redshift also extends data warehouse queries to your data lake, with no loading required. You can run analytic queries against petabytes of data stored locally in Redshift, and directly against exabytes of data stored in Amazon S3.",
        "searchKeywords": [
            "Database",
            "data warehouse",
            "data warehouse solution",
            "MySQL",
            "SQL",
            "data analysis",
            "business intelligence",
            "dw",
            "datawarehouse"
        ],
        "type": "AWSService",
        "regions": [
            "af-south-1",
            "ap-east-1",
            "ap-south-1",
            "ap-northeast-3",
            "ap-northeast-2",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-southeast-3",
            "ap-northeast-1",
            "us-gov-west-1",
            "us-gov-east-1",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "eu-west-3",
            "eu-north-1",
            "eu-south-1",
            "me-south-1",
            "me-central-1",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/redshift/",
        "isActive": "true",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonRedshift/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "slug": "Redshift",
        "mvpSupport": false,
        "comparableTerms": [
            "redshift"
        ]
    },
    "amazonRekognition": {
        "name": "Amazon Rekognition",
        "serviceCode": "amazonRekognition",
        "description": "Amazon Rekognition makes it easy to add image and video analysis to your applications using proven, highly scalable, deep learning technology that requires no machine learning expertise to use. With Amazon Rekognition, you can identify objects, people, text, scenes, and activities in images and videos, as well as detect any inappropriate content.",
        "searchKeywords": [
            "Rekognition",
            "image",
            "custom labels",
            "video"
        ],
        "type": "AWSService",
        "regions": [],
        "linkUrl": "https://aws.amazon.com/rekognition/",
        "isActive": "true",
        "subType": "subServiceSelector",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonRekognition/en_US.json",
        "c2e": false,
        "templates": [
            "rekognitionImage",
            "rekognitionVideo",
            "rekognitionStreamingVideoEvents",
            "rekognitionCustomLabels"
        ],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/amazonRekognition/en_US.json",
        "slug": "Rekognition",
        "mvpSupport": false,
        "comparableTerms": [
            "rekognition"
        ]
    },
    "amazonRoute53": {
        "name": "Amazon Route 53",
        "serviceCode": "amazonRoute53",
        "description": "Amazon Route 53 is a cloud Domain Name System (DNS) web service.",
        "searchKeywords": [],
        "type": "AWSService",
        "regions": [
            "ap-northeast-1",
            "ap-northeast-2",
            "ap-south-1",
            "ap-southeast-1",
            "ap-southeast-2",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "eu-west-3",
            "me-south-1",
            "me-central-1",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-gov-west-1",
            "us-west-1",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/route53/",
        "isActive": "true",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonRoute53/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "slug": "Route53",
        "mvpSupport": false,
        "comparableTerms": [
            "route53"
        ]
    },
    "amazonS3": {
        "name": "Amazon S3",
        "serviceCode": "amazonS3",
        "description": "Amazon Simple Storage Service (Amazon S3) is the largest and most performant, secure, and feature-rich object storage service. With Amazon S3, organizations of all sizes and industries can store any amount of data for any use case, including applications, IoT, data lakes, analytics, backup and restore, archive, and disaster recovery.",
        "type": "AWSService",
        "regions": [
            "us-east-1",
            "us-east-2",
            "us-west-2",
            "eu-west-1",
            "eu-west-2",
            "eu-central-1",
            "ap-northeast-1",
            "ap-northeast-2",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-south-1"
        ],
        "linkUrl": "https://aws.amazon.com/s3",
        "isActive": "false",
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonS3/en_US.json",
        "comparableTerms": [
            "s3"
        ]
    },
    "amazonGlacier": {
        "name": "Amazon S3 Glacier (Glacier API only)",
        "serviceCode": "amazonGlacier",
        "description": "S3 Glacier is a secure, durable, and low-cost storage class for data archiving. You can reliably store any amount of data at costs that are competitive with or cheaper than on-premises solutions. To keep costs low yet suitable for varying needs, S3 Glacier provides three retrieval options that range from a few minutes to hours.",
        "searchKeywords": [],
        "type": "AWSService",
        "regions": [
            "af-south-1",
            "ap-east-1",
            "ap-northeast-1",
            "ap-northeast-2",
            "ap-northeast-3",
            "ap-south-1",
            "ap-southeast-1",
            "ap-southeast-2",
            "ca-central-1",
            "eu-central-1",
            "eu-north-1",
            "eu-south-1",
            "eu-west-1",
            "eu-west-2",
            "eu-west-3",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-gov-east-1",
            "us-gov-west-1",
            "us-west-1",
            "us-west-2",
            "me-south-1",
            "me-central-1"
        ],
        "linkUrl": "https://aws.amazon.com/glacier/",
        "isActive": "true",
        "hasDataTransfer": true,
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonGlacier/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/amazonGlacier/en_US.json",
        "slug": "S3Glacier",
        "mvpSupport": false,
        "comparableTerms": [
            "glacier",
            "glacierapionly",
            "s3glacier",
            "s3glacierglacierapionly"
        ]
    },
    "amazonSageMaker": {
        "name": "Amazon SageMaker",
        "serviceCode": "amazonSageMaker",
        "description": "With Amazon SageMaker, you pay only for what you use. Building, training, and deploying ML models is billed by the second, with no minimum fees and no upfront commitments. Pricing within Amazon SageMaker is broken down by on-demand ML instances, ML storage, and fees for data processing in hosting instances.",
        "searchKeywords": [
            "Sagemaker",
            "Model",
            "ML",
            "Machine Learning",
            "EI",
            "data scientist",
            "Data Wrangler",
            "Feature Store",
            "Sagemaker Edge"
        ],
        "type": "AWSService",
        "regions": [],
        "linkUrl": "https://aws.amazon.com/sagemaker/",
        "isActive": "true",
        "subType": "subServiceSelector",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonSageMaker/en_US.json",
        "c2e": false,
        "templates": [
            "sageMakerStudioNotebooks",
            "sageMakerRStudioOnSageMaker",
            "sageMakerOnDemandNotebookInstances",
            "sageMakerProcessing",
            "sageMakerDataWrangler",
            "sageMakerFeatureStore",
            "sageMakerTraining",
            "sageMakerRealTimeInference",
            "sageMakerAsynchronousInference",
            "sageMakerBatchTransform",
            "amazonSageMakerEdgeManager",
            "sageMakerServerlessInference"
        ],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/amazonSageMaker/en_US.json",
        "slug": "SageMaker",
        "mvpSupport": false,
        "comparableTerms": [
            "sagemaker"
        ]
    },
    "amazonSageMakerGroundTruth": {
        "name": "Amazon SageMaker Ground Truth",
        "serviceCode": "amazonSageMakerGroundTruth",
        "description": "Amazon SageMaker Ground Truth helps you build training datasets for machine learning. Ground Truth will label your content (images, audio, text, etc) by guiding a human labeler step-by-step in a process called a workflow.",
        "searchKeywords": [
            "Sagemaker",
            "ground truth",
            "computer vision",
            "3d point clouds",
            "image labeling",
            "labeler",
            "Model",
            "ML",
            "Machine Learning",
            "EI",
            "data scientist"
        ],
        "type": "AWSService",
        "regions": [
            "us-east-1",
            "eu-west-1",
            "ap-southeast-1",
            "ap-northeast-1",
            "us-west-2",
            "ap-southeast-2",
            "eu-central-1",
            "ap-northeast-2",
            "ap-south-1",
            "us-east-2",
            "ca-central-1",
            "eu-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/sagemaker/groundtruth/",
        "isActive": "true",
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonSageMakerGroundTruth/en_US.json",
        "c2e": false,
        "slug": "SageMakerGroundTruth",
        "mvpSupport": false,
        "comparableTerms": [
            "sagemakergroundtruth"
        ]
    },
    "amazonSimpleEmailService": {
        "name": "Amazon Simple Email Service (SES)",
        "serviceCode": "amazonSimpleEmailService",
        "description": "Amazon Simple Email Service (Amazon SES) is a cloud-based email sending service designed to help digital marketers and application developers send marketing, notification, and transactional emails.",
        "searchKeywords": [
            "SES",
            "Email",
            "Amazon Simple Email Service",
            "Simple Email Service"
        ],
        "type": "AWSService",
        "regions": [
            "af-south-1",
            "ap-south-1",
            "ap-northeast-2",
            "ap-northeast-3",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-northeast-1",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "eu-west-3",
            "eu-north-1",
            "eu-south-1",
            "me-south-1",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2",
            "us-west-2-wl1",
            "us-gov-west-1"
        ],
        "linkUrl": "https://aws.amazon.com/ses/",
        "isActive": "true",
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonSimpleEmailService/en_US.json",
        "c2e": false,
        "slug": "SES",
        "mvpSupport": false,
        "comparableTerms": [
            "ses",
            "simpleemail",
            "simpleemailservice",
            "simpleemailserviceses"
        ]
    },
    "amazonSimpleNotificationService": {
        "name": "Amazon Simple Notification Service (SNS)",
        "serviceCode": "amazonSimpleNotificationService",
        "description": "Amazon Simple Notification Service (SNS) is a highly available, durable, secure, fully managed pub/sub messaging service that enables you to decouple microservices, distributed systems, and serverless applications.",
        "searchKeywords": [
            "Messaging",
            "SNS",
            "notification topic",
            "publish message",
            "subscription",
            "text message",
            "sms",
            "topics",
            "push notifications",
            "push notification service queuing"
        ],
        "type": "AWSService",
        "regions": [],
        "linkUrl": "https://aws.amazon.com/sns/",
        "isActive": "true",
        "subType": "subServiceSelector",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonSimpleNotificationService/en_US.json",
        "c2e": false,
        "templates": [
            "standardTopics",
            "fifoTopics"
        ],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/amazonSimpleNotificationService/en_US.json",
        "slug": "SNS",
        "mvpSupport": false,
        "comparableTerms": [
            "simplenotification",
            "simplenotificationservice",
            "simplenotificationservicesns",
            "sns"
        ]
    },
    "amazonSimpleQueueService": {
        "name": "Amazon Simple Queue Service (SQS)",
        "serviceCode": "amazonSimpleQueueService",
        "description": "Amazon Simple Queue Service (SQS) is a fully managed message queuing service that enables you to decouple and scale microservices, distributed systems, and serverless applications.",
        "searchKeywords": [
            "Messaging",
            "SQS",
            "queue service",
            "push notifications",
            "queueing",
            "message queueing",
            "batch processing",
            "managed queue",
            "transmit data",
            "hosted queues",
            "storing messages",
            "move data",
            "perform tasks",
            "decouple componenets",
            "message processing",
            "message repository",
            "temporary repository",
            "message delivery",
            "distributed queues",
            "delay queues"
        ],
        "type": "AWSService",
        "regions": [
            "af-south-1",
            "ap-east-1",
            "ap-south-1",
            "ap-northeast-3",
            "ap-northeast-2",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-southeast-3",
            "ap-northeast-1",
            "us-gov-west-1",
            "us-gov-east-1",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "eu-west-3",
            "eu-south-1",
            "eu-north-1",
            "me-south-1",
            "me-central-1",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/sqs",
        "isActive": "true",
        "hasDataTransfer": true,
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonSimpleQueueService/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "slug": "SQS",
        "mvpSupport": false,
        "comparableTerms": [
            "simplequeue",
            "simplequeueservice",
            "simplequeueservicesqs",
            "sqs"
        ]
    },
    "amazonSimpleStorageServiceGroup": {
        "name": "Amazon Simple Storage Service (S3)",
        "serviceCode": "amazonSimpleStorageServiceGroup",
        "description": "Amazon Simple Storage Service (Amazon S3) is storage for the internet. You can use Amazon S3 to store and retrieve any amount of data at any time, from anywhere on the web.",
        "searchKeywords": [
            "Storage",
            "Simple Storage Service",
            "bucket",
            "file storage",
            "cloud storage",
            "static website hosting",
            "object storage",
            "store objects",
            "store files",
            "data migration",
            "ongoing data ingestion",
            "backup and recovery",
            "big data analytics",
            "nearline archive",
            "disaster recovery",
            "content distribution",
            "cloud storage",
            "S3",
            "s3"
        ],
        "type": "AWSService",
        "regions": [],
        "linkUrl": "https://aws.amazon.com/s3/",
        "isActive": "true",
        "subType": "subServiceSelector",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonSimpleStorageServiceGroup/en_US.json",
        "c2e": false,
        "templates": [
            "amazonS3Standard",
            "amazonS3IntelligentTiering",
            "amazonS3StandardInfrequentAccess",
            "s3OneZoneInfrequentAccess",
            "amazonS3Glacier",
            "amazonS3GlacierDeepArhive",
            "amazonS3StorageManagement",
            "s3ObjectLambda",
            "s3GlacierInstantRetrieval",
            "awsS3DataTransfer"
        ],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/amazonSimpleStorageServiceGroup/en_US.json",
        "slug": "S3",
        "mvpSupport": false,
        "comparableTerms": [
            "s3",
            "simplestorageservicegroup",
            "simplestorageservices3"
        ]
    },
    "amazonSimpleWorkflowService": {
        "name": "Amazon Simple Workflow Service (SWF)",
        "serviceCode": "amazonSimpleWorkflowService",
        "description": "Amazon SWF helps developers build, run, and scale background jobs that have parallel or sequential steps. You can think of Amazon SWF as a fully-managed state tracker and task coordinator in the Cloud.",
        "searchKeywords": [],
        "type": "AWSService",
        "regions": [
            "af-south-1",
            "ap-east-1",
            "ap-northeast-1",
            "ap-northeast-2",
            "ap-northeast-3",
            "ap-south-1",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-southeast-3",
            "ca-central-1",
            "eu-central-1",
            "eu-north-1",
            "eu-south-1",
            "eu-west-1",
            "eu-west-2",
            "eu-west-3",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-gov-east-1",
            "us-gov-west-1",
            "us-west-1",
            "us-west-2",
            "me-south-1",
            "me-central-1"
        ],
        "linkUrl": "https://aws.amazon.com/swf/",
        "isActive": "true",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonSimpleWorkflowService/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "slug": "SWF",
        "mvpSupport": false,
        "comparableTerms": [
            "simpleworkflow",
            "simpleworkflowservice",
            "simpleworkflowserviceswf",
            "swf"
        ]
    },
    "amazonTextract": {
        "name": "Amazon Textract",
        "serviceCode": "amazonTextract",
        "description": "Amazon Textract is a fully managed machine learning service that automatically extracts printed text, handwriting, and other data from scanned documents that goes beyond simple optical character recognition (OCR) to identify, understand, and extract data from forms and tables.",
        "searchKeywords": [
            "textract",
            "text"
        ],
        "type": "AWSService",
        "regions": [
            "us-gov-west-1",
            "us-gov-east-1",
            "ap-south-1",
            "ap-northeast-2",
            "ap-southeast-1",
            "ap-southeast-2",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "eu-west-3",
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/textract/",
        "isActive": "true",
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonTextract/en_US.json",
        "c2e": false,
        "slug": "Textract",
        "mvpSupport": false,
        "comparableTerms": [
            "textract"
        ]
    },
    "amazonTranscribe": {
        "name": "Amazon Transcribe",
        "serviceCode": "amazonTranscribe",
        "description": "Amazon Transcribe is a fully-managed automatic speech recognition (ASR) service that makes it easy for developers to add speech-to-text capabilities to voice applications. Powered by deep learning, the service supports transcription through its batch file (asynchronous) and streaming (real-time) APIs. Amazon Transcribe offers accurate transcription across more than 30 global languages and accents.",
        "searchKeywords": [
            "transcribe",
            "transcription",
            "STT",
            "VTT",
            "audio",
            "voice",
            "subtitles",
            "caption",
            "language",
            "scribes",
            "vocabulary",
            "medical",
            "archiving",
            "archives",
            "call",
            "analytics",
            "call analytics"
        ],
        "type": "AWSService",
        "regions": [
            "af-south-1",
            "ap-east-1",
            "ap-northeast-1",
            "ap-northeast-2",
            "ap-south-1",
            "ap-southeast-1",
            "ap-southeast-2",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "eu-west-3",
            "eu-north-1",
            "sa-east-1",
            "me-south-1",
            "us-east-1",
            "us-east-2",
            "us-gov-east-1",
            "us-gov-west-1",
            "us-west-1",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/transcribe/",
        "isActive": "true",
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonTranscribe/en_US.json",
        "c2e": false,
        "slug": "Transcribe",
        "mvpSupport": false,
        "comparableTerms": [
            "transcribe"
        ]
    },
    "amazonTranscribeMedical": {
        "name": "Amazon Transcribe Medical",
        "serviceCode": "amazonTranscribeMedical",
        "description": "Amazon Transcribe Medical is a HIPAA-eligible automatic speech recognition (ASR) service that makes it easy for developers to add speech-to-text capabilities to their healthcare and life science applications.",
        "searchKeywords": [
            "transcribe",
            "transcription",
            "STT",
            "VTT",
            "audio",
            "voice",
            "subtitles",
            "caption",
            "language",
            "scribes",
            "vocabulary",
            "medical",
            "archiving",
            "archives"
        ],
        "type": "AWSService",
        "regions": [
            "ap-southeast-2",
            "ca-central-1",
            "eu-west-1",
            "us-east-1",
            "us-east-2",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/transcribe/",
        "isActive": "true",
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonTranscribeMedical/en_US.json",
        "c2e": false,
        "slug": "TranscribeMedical",
        "comparableTerms": [
            "transcribe",
            "transcribemedical"
        ]
    },
    "amazonTranslate": {
        "name": "Amazon Translate",
        "serviceCode": "amazonTranslate",
        "description": "Amazon Translate is a neural machine translation service that delivers fast, high-quality, and affordable language translation. Neural machine translation is a form of language translation automation that uses deep learning models to deliver more accurate and more natural sounding translation than traditional statistical and rule-based translation algorithms.",
        "searchKeywords": [
            "NLP",
            "Natural language processing",
            "language transalation",
            "Text analytics",
            "Language translation",
            "Amazon translate",
            "Translate"
        ],
        "type": "AWSService",
        "regions": [],
        "linkUrl": "https://aws.amazon.com/translate/",
        "isActive": "true",
        "subType": "subServiceSelector",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonTranslate/en_US.json",
        "c2e": false,
        "templates": [
            "standardRealTimeTranslation",
            "standardBatchTranslation",
            "activeCustomBatchTranslation"
        ],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/amazonTranslate/en_US.json",
        "slug": "Translate",
        "mvpSupport": false,
        "comparableTerms": [
            "translate"
        ]
    },
    "amazonVirtualPrivateCloud": {
        "name": "Amazon Virtual Private Cloud (VPC)",
        "serviceCode": "amazonVirtualPrivateCloud",
        "description": "Amazon Virtual Private Cloud (Amazon VPC) lets you provision a logically isolated section of the AWS Cloud where you can launch AWS resources in a virtual network that you define.",
        "searchKeywords": [
            "access control",
            "ACL",
            "AWS Privatelink",
            "Cloud connectivity",
            "corporate network",
            "elastic IP",
            "Gateway load balancer",
            "home network VPN",
            "IPAM",
            "NAT",
            "NAT gateway",
            "Network Access Analyzer",
            "Network Address Translation",
            "Networking Content Delivery",
            "PrivateLink",
            "Reachability Analyzer",
            "security",
            "single tenant hardware",
            "static ip",
            "subnets",
            "Traffic mirroring",
            "Transit Gateway",
            "Virtual Private Cloud",
            "VPN"
        ],
        "type": "AWSService",
        "regions": [],
        "linkUrl": "https://aws.amazon.com/vpc/",
        "isActive": "true",
        "subType": "subServiceSelector",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonVirtualPrivateCloud/en_US.json",
        "c2e": false,
        "templates": [
            "vpnConnectionVpc",
            "networkAddressTranslationNatGatewayVpc",
            "transitGatewayVpc",
            "awsPrivateLinkVpc",
            "dataTransferVpc",
            "gatewayLoadBalancerVpc",
            "ipamVpc",
            "networkAccessAnalyzerVpc",
            "trafficMirroringVpc",
            "reachabilityAnalyzerVpc",
            "cloudWan"
        ],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/amazonVirtualPrivateCloud/en_US.json",
        "slug": "VPC",
        "mvpSupport": false,
        "comparableTerms": [
            "virtualprivatecloud",
            "virtualprivatecloudvpc",
            "vpc"
        ]
    },
    "amazonWorkdocs": {
        "name": "Amazon WorkDocs",
        "serviceCode": "amazonWorkdocs",
        "description": "Amazon WorkDocs is a fully managed, secure content creation, storage, and collaboration service. With Amazon WorkDocs, you can easily create, edit, and share content, and because it’s stored centrally on AWS, access it from anywhere on any device.",
        "searchKeywords": [],
        "type": "AWSService",
        "regions": [
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-northeast-1",
            "eu-west-1",
            "us-east-1",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/workdocs/",
        "isActive": "true",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonWorkdocs/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "slug": "WorkDocs",
        "mvpSupport": false,
        "comparableTerms": [
            "workdocs"
        ]
    },
    "amazonWorkmail": {
        "name": "Amazon WorkMail",
        "serviceCode": "amazonWorkmail",
        "description": "Amazon WorkMail is a secure, managed business email and calendar service with support for existing desktop and mobile email client applications. Amazon WorkMail gives users the ability to seamlessly access their email, contacts, and calendars using the client application of their choice, including Microsoft Outlook, native iOS and Android email applications, any client application supporting the IMAP protocol, or directly through a web browser. You can integrate Amazon WorkMail with your existing corporate directory, use email journaling to meet compliance requirements, and control both the keys that encrypt your data and the location in which your data is stored. You can also set up interoperability with Microsoft Exchange Server, and programmatically manage users, groups, and resources using the Amazon WorkMail SDK.",
        "searchKeywords": [
            "workmail",
            "business email",
            "managed email",
            "calendar service",
            "managed service",
            "outlook",
            "iOS",
            "andriod",
            "email applications",
            "exchange server",
            "IMAP"
        ],
        "type": "AWSService",
        "regions": [
            "eu-west-1",
            "us-east-1",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/workmail/",
        "isActive": "true",
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonWorkmail/en_US.json",
        "c2e": false,
        "slug": "WorkMail",
        "mvpSupport": false,
        "comparableTerms": [
            "workmail"
        ]
    },
    "amazonWorkspaces": {
        "name": "Amazon WorkSpaces",
        "serviceCode": "amazonWorkspaces",
        "description": "Amazon WorkSpaces is a managed, secure cloud desktop service. You can use Amazon WorkSpaces to provision either Windows or Linux desktops in just a few minutes and quickly scale to provide thousands of desktops to workers across the globe.",
        "searchKeywords": [
            "cloud desktop",
            "workspaces"
        ],
        "type": "AWSService",
        "regions": [
            "us-gov-west-1",
            "ap-south-1",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-northeast-1",
            "ap-northeast-2",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "us-east-1",
            "us-west-2",
            "sa-east-1"
        ],
        "linkUrl": "https://aws.amazon.com/workspaces/",
        "isActive": "true",
        "hasDataTransfer": false,
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonWorkspaces/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "bulkImportEnabled": false,
        "serviceDefinitionUrlPath": "/data/amazonWorkspaces/en_US.json",
        "slug": "WorkSpaces",
        "mvpSupport": false,
        "comparableTerms": [
            "workspaces"
        ]
    },
    "applicationLoadBalancer": {
        "name": "Application Load Balancer",
        "serviceCode": "applicationLoadBalancer",
        "description": "Elastic Load Balancing automatically distributes incoming application traffic across multiple targets, such as Amazon EC2 instances, containers, IP addresses, and Lambda functions.",
        "searchKeywords": [
            "ELB",
            "Elastic Load Balancer",
            "Load Balancer",
            "Application Load Balancer",
            "Network Load Balancer",
            "Classic Load Balancer"
        ],
        "type": "AWSService",
        "regions": [
            "af-south-1",
            "ap-east-1",
            "ap-northeast-1",
            "ap-northeast-2",
            "ap-northeast-3",
            "ap-south-1",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-southeast-3",
            "ca-central-1",
            "eu-central-1",
            "eu-north-1",
            "eu-south-1",
            "eu-west-1",
            "eu-west-2",
            "eu-west-3",
            "me-south-1",
            "me-central-1",
            "sa-east-1",
            "us-gov-east-1",
            "us-gov-west-1",
            "us-east-1",
            "us-east-1-atl-1",
            "us-east-1-bos-1",
            "us-east-1-chi-1",
            "us-east-1-dfw-1",
            "us-east-1-iah-1",
            "us-east-1-mci-1",
            "us-east-1-mia-1",
            "us-east-1-msp-1",
            "us-east-1-nyc-1",
            "us-east-1-phl-1",
            "us-east-2",
            "us-west-1",
            "us-west-2",
            "us-west-2-den-1",
            "us-west-2-las-1",
            "us-west-2-lax-1",
            "us-west-2-pdx-1",
            "us-west-2-phx-1",
            "us-west-2-sea-1",
            "us-east-1-wl1",
            "us-east-1-wl1-atl1",
            "us-east-1-wl1-chi1",
            "us-east-1-wl1-clt1",
            "us-east-1-wl1-dfw1",
            "us-east-1-wl1-dtw1",
            "us-east-1-wl1-iah1",
            "us-east-1-wl1-mia1",
            "us-east-1-wl1-msp1",
            "us-east-1-wl1-nyc1",
            "us-east-1-wl1-was1",
            "us-west-2-wl1",
            "us-west-2-wl1-den1",
            "us-west-2-wl1-las1",
            "us-west-2-wl1-lax1",
            "us-west-2-wl1-phx1",
            "us-west-2-wl1-sea1"
        ],
        "linkUrl": "https://aws.amazon.com/elasticloadbalancing/",
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/applicationLoadBalancer/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "bulkImportEnabled": false,
        "serviceDefinitionUrlPath": "/data/applicationLoadBalancer/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "applicationloadbalancer"
        ],
        "parentServiceCode": "elasticLoadBalancing"
    },
    "appSyncApiCall": {
        "name": "AppSync API Request",
        "serviceCode": "appSyncApiCall",
        "searchKeywords": [
            "query",
            "graphql",
            "api"
        ],
        "type": "AWSService",
        "regions": [
            "ap-east-1",
            "ap-south-1",
            "ap-northeast-3",
            "ap-northeast-2",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-northeast-1",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "eu-south-1",
            "eu-west-3",
            "eu-north-1",
            "me-south-1",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/appsync/",
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/appSyncApiCall/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/appSyncApiCall/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "appsyncapicall",
            "appsyncapirequest"
        ],
        "parentServiceCode": "awsAppSync"
    },
    "appSyncCaching": {
        "name": "AppSync Caching",
        "serviceCode": "appSyncCaching",
        "searchKeywords": [
            "query",
            "graphql",
            "api"
        ],
        "type": "AWSService",
        "regions": [
            "ap-east-1",
            "ap-south-1",
            "ap-northeast-3",
            "ap-northeast-2",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-northeast-1",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "eu-south-1",
            "eu-west-3",
            "eu-north-1",
            "me-south-1",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/appsync/",
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/appSyncCaching/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/appSyncCaching/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "appsynccaching"
        ],
        "parentServiceCode": "awsAppSync"
    },
    "appsyncDataTransfer": {
        "name": "Appsync Data Transfer",
        "serviceCode": "appsyncDataTransfer",
        "searchKeywords": [
            "data transfer"
        ],
        "type": "AWSService",
        "regions": [
            "ap-east-1",
            "ap-south-1",
            "ap-northeast-3",
            "ap-northeast-2",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-northeast-1",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "eu-south-1",
            "eu-west-3",
            "eu-north-1",
            "me-south-1",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/appsync/",
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/appsyncDataTransfer/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "bulkImportEnabled": false,
        "serviceDefinitionUrlPath": "/data/appsyncDataTransfer/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "appsyncdatatransfer"
        ],
        "parentServiceCode": "awsAppSync"
    },
    "appSyncRealTime": {
        "name": "AppSync Real-Time",
        "serviceCode": "appSyncRealTime",
        "searchKeywords": [
            "query"
        ],
        "type": "AWSService",
        "regions": [
            "ap-east-1",
            "ap-south-1",
            "ap-northeast-3",
            "ap-northeast-2",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-northeast-1",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "eu-south-1",
            "eu-west-3",
            "eu-north-1",
            "me-south-1",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/appsync/",
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/appSyncRealTime/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/appSyncRealTime/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "appsyncrealtime"
        ],
        "parentServiceCode": "awsAppSync"
    },
    "awsSystemsManagerAutomation": {
        "name": "Automation",
        "serviceCode": "awsSystemsManagerAutomation",
        "description": "AWS Systems Manager Automation feature",
        "searchKeywords": [
            "System Manager",
            "Automation",
            "steps",
            "automate"
        ],
        "type": "AWSService",
        "regions": [
            "us-gov-west-1",
            "us-gov-east-1",
            "af-south-1",
            "ap-east-1",
            "ap-south-1",
            "ap-northeast-3",
            "ap-northeast-2",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-southeast-3",
            "ap-northeast-1",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "eu-south-1",
            "eu-west-3",
            "eu-north-1",
            "me-south-1",
            "me-central-1",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/systems-manager/",
        "isActive": "true",
        "hasDataTransfer": false,
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/awsSystemsManagerAutomation/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/awsSystemsManagerAutomation/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "automation",
            "systemsmanagerautomation"
        ],
        "parentServiceCode": "awsSystemsManager"
    },
    "awsAmplify": {
        "name": "AWS Amplify",
        "serviceCode": "awsAmplify",
        "description": "AWS Amplify is a set of tools and services that can be used together or on their own, to help front-end web and mobile developers build scalable full stack applications, powered by AWS. With Amplify, you can create an app backend for web and mobile, and then connect your Git branch to deploy and host a web app in a few clicks.",
        "searchKeywords": [
            "authentication",
            "datastore",
            "storage",
            "console",
            "analytics",
            "mobile apps",
            "flows",
            "predictions",
            "api",
            "graphql",
            "pubsub",
            "hosting",
            "libraries",
            "user management",
            "content management",
            "UI",
            "frontend",
            "database",
            "ci/cd",
            "git"
        ],
        "type": "AWSService",
        "regions": [
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2",
            "ap-east-1",
            "ap-northeast-1",
            "ap-northeast-2",
            "ap-south-1",
            "ap-southeast-1",
            "ap-southeast-2",
            "ca-central-1",
            "eu-central-1",
            "eu-north-1",
            "eu-south-1",
            "eu-west-1",
            "eu-west-2",
            "eu-west-3",
            "me-south-1",
            "sa-east-1"
        ],
        "linkUrl": "https://aws.amazon.com/amplify/",
        "isActive": "true",
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/awsAmplify/en_US.json",
        "c2e": false,
        "slug": "Amplify",
        "mvpSupport": false,
        "comparableTerms": [
            "amplify"
        ]
    },
    "awsAppConfig": {
        "name": "AWS AppConfig",
        "serviceCode": "awsAppConfig",
        "description": "AWS AppConfig enables you to provide validation logic to ensure your configuration data is syntactically and semantically correct according to your definitions before making it available to your application. AWS AppConfig also gives you the ability to roll out configuration changes over a defined time period while monitoring your application so that you can catch errors and roll back the changes if needed, to help you minimize the impact to the users.",
        "searchKeywords": [
            "Systems Manager",
            "AppConfig",
            "configuration",
            "monitoring"
        ],
        "type": "AWSService",
        "regions": [
            "ap-east-1",
            "ap-south-1",
            "ap-northeast-2",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-southeast-3",
            "ap-northeast-1",
            "ap-northeast-3",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "eu-west-3",
            "eu-north-1",
            "me-south-1",
            "me-central-1",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/systems-manager/",
        "isActive": "true",
        "hasDataTransfer": false,
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/awsAppConfig/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/awsAppConfig/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "appconfig"
        ],
        "parentServiceCode": "awsSystemsManager"
    },
    "awsAppSync": {
        "name": "AWS AppSync",
        "serviceCode": "awsAppSync",
        "description": "AWS AppSync is a fully managed service that makes it easy to develop GraphQL APIs by handling the heavy lifting of securely connecting to data sources like AWS DynamoDB, Lambda, and more.",
        "searchKeywords": [
            "appsync",
            "query",
            "data modification",
            "data transfer"
        ],
        "type": "AWSService",
        "regions": [],
        "linkUrl": "https://aws.amazon.com/appsync/",
        "isActive": "true",
        "subType": "subServiceSelector",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/awsAppSync/en_US.json",
        "c2e": false,
        "templates": [
            "appSyncApiCall",
            "appSyncRealTime",
            "appSyncCaching",
            "appsyncDataTransfer"
        ],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/awsAppSync/en_US.json",
        "slug": "appSync",
        "mvpSupport": false,
        "comparableTerms": [
            "appsync"
        ]
    },
    "mainframeBluAge": {
        "name": "AWS Blue Age automated refactoring",
        "serviceCode": "mainframeBluAge",
        "description": "For AWS M2 Blu Age managed runtime, you can choose on-demand instances and pay for the runtime by the hour with no long-term commitments or upfront fees, or choose committed plans for additional savings.",
        "searchKeywords": [],
        "type": "AWSService",
        "regions": [
            "ap-southeast-2",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "sa-east-1",
            "us-east-1",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/mainframe-modernization/pricing/",
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/mainframeBluAge/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/mainframeBluAge/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "blueageautomatedrefactoring",
            "mainframebluage"
        ],
        "parentServiceCode": "amazonMainframeModernization"
    },
    "awsBudgets": {
        "name": "AWS Budgets",
        "serviceCode": "awsBudgets",
        "description": "AWS Budgets lets you set custom cost and usage budgets that alert you when your budget thresholds are exceeded (or forecasted to exceed). You can also create budgets to track your aggregate Reservation and Savings Plans utilization and coverage metrics.",
        "searchKeywords": [
            "budgets",
            "cost management",
            "budgets report"
        ],
        "type": "AWSService",
        "regions": [],
        "linkUrl": "https://aws.amazon.com/aws-cost-management/aws-budgets/",
        "isActive": "true",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/awsBudgets/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/awsBudgets/en_US.json",
        "slug": "budgets",
        "mvpSupport": false,
        "comparableTerms": [
            "budgets",
            "costmanagementbudgets"
        ]
    },
    "awsCertificateManager": {
        "name": "AWS Certificate Manager",
        "serviceCode": "awsCertificateManager",
        "description": "AWS Certificate Manager is a service that lets you easily provision, manage, and deploy public and private Secure Sockets Layer/Transport Layer Security (SSL/TLS) certificates for use with AWS services and your internal connected resources.",
        "searchKeywords": [
            "PCA",
            "ACM",
            "OCSP",
            "certificates x.509",
            "private"
        ],
        "type": "AWSService",
        "regions": [
            "af-south-1",
            "ap-east-1",
            "ap-south-1",
            "ap-northeast-3",
            "ap-northeast-2",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-southeast-2",
            "us-gov-east-1",
            "us-gov-west-1",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "eu-south-1",
            "eu-west-3",
            "eu-north-1",
            "me-south-1",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/certificate-manager/",
        "isActive": "true",
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/awsCertificateManager/en_US.json",
        "c2e": false,
        "slug": "certificateManager",
        "mvpSupport": false,
        "comparableTerms": [
            "certificatemanager"
        ]
    },
    "awsCloudFormation": {
        "name": "AWS CloudFormation",
        "serviceCode": "awsCloudFormation",
        "description": "AWS CloudFormation provides a common language for you to model and provision AWS and third party application extensions in your cloud environment.",
        "searchKeywords": [
            "cloudformation",
            "formation",
            "cloud",
            "application resources"
        ],
        "type": "AWSService",
        "regions": [
            "us-gov-west-1",
            "us-gov-east-1",
            "af-south-1",
            "ap-east-1",
            "ap-south-1",
            "ap-northeast-3",
            "ap-northeast-2",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-southeast-3",
            "ap-northeast-1",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "eu-south-1",
            "eu-west-3",
            "eu-north-1",
            "me-south-1",
            "me-central-1",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/cloudformation/",
        "isActive": "true",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/awsCloudFormation/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "slug": "CloudFormation",
        "mvpSupport": false,
        "comparableTerms": [
            "cloudformation"
        ]
    },
    "awsCloudHsm": {
        "name": "AWS CloudHSM",
        "serviceCode": "awsCloudHsm",
        "description": "AWS CloudHSM is a cloud-based hardware security module (HSM) that enables you to easily generate and use your own encryption keys on the AWS Cloud. With CloudHSM, you can manage your own encryption keys using FIPS 140-2 Level 3 validated HSMs.",
        "searchKeywords": [
            "crypto"
        ],
        "type": "AWSService",
        "regions": [
            "ap-east-1",
            "ap-south-1",
            "ap-northeast-2",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-northeast-1",
            "us-gov-west-1",
            "us-gov-east-1",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "eu-west-3",
            "eu-north-1",
            "me-south-1",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2",
            "eu-south-1",
            "af-south-1"
        ],
        "linkUrl": "https://aws.amazon.com/cloudhsm",
        "isActive": "true",
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/awsCloudHsm/en_US.json",
        "c2e": false,
        "slug": "CloudHSM",
        "comparableTerms": [
            "cloudhsm"
        ]
    },
    "awsCloudTrail": {
        "name": "AWS CloudTrail",
        "serviceCode": "awsCloudTrail",
        "description": "AWS CloudTrail is a service that enables governance, compliance, operational auditing, and risk auditing of your AWS account. With CloudTrail, you can log, continuously monitor, and retain account activity related to actions across your AWS infrastructure.",
        "searchKeywords": [
            "cloudtrail",
            "operational auditing",
            "governance",
            "compliance",
            "risk auditing",
            "event history",
            "unusual activity",
            "troubleshooting",
            "operational analysis",
            "logs",
            "monitor account activity",
            "trail"
        ],
        "type": "AWSService",
        "regions": [
            "af-south-1",
            "ap-east-1",
            "ap-south-1",
            "ap-northeast-3",
            "ap-northeast-2",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-southeast-3",
            "ap-northeast-1",
            "us-gov-east-1",
            "us-gov-west-1",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "eu-south-1",
            "eu-west-3",
            "eu-north-1",
            "me-south-1",
            "me-central-1",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/cloudtrail/",
        "isActive": "true",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/awsCloudTrail/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "slug": "CloudTrail",
        "mvpSupport": false,
        "comparableTerms": [
            "cloudtrail"
        ]
    },
    "awsCodeArtifact": {
        "name": "AWS CodeArtifact",
        "serviceCode": "awsCodeArtifact",
        "description": "AWS CodeArtifact is a fully managed artifact repository service that makes it easy for organizations of any size to securely store, publish, and share software packages used in their software development process.",
        "searchKeywords": [
            "artifacts",
            "reqeusts",
            "data transfer",
            "public aritfact repositories",
            "storage",
            "npm",
            "maven",
            "nuget",
            "pypi",
            "python",
            "nuget"
        ],
        "type": "AWSService",
        "regions": [
            "us-east-1",
            "us-east-2",
            "us-west-2",
            "eu-north-1",
            "eu-south-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "eu-west-3",
            "ap-northeast-1",
            "ap-south-1",
            "ap-southeast-1",
            "ap-southeast-2"
        ],
        "linkUrl": "https://aws.amazon.com/codeartifact/",
        "isActive": "true",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/awsCodeArtifact/en_US.json",
        "c2e": false,
        "slug": "CodeArtifact",
        "mvpSupport": false,
        "comparableTerms": [
            "codeartifact"
        ]
    },
    "awsCodeBuild": {
        "name": "AWS CodeBuild",
        "serviceCode": "awsCodeBuild",
        "description": "AWS CodeBuild is a fully managed continuous integration service that compiles source code, runs tests, and produces software packages that are ready to deploy.",
        "searchKeywords": [
            "CodeBuild",
            "Code",
            "code build"
        ],
        "type": "AWSService",
        "regions": [
            "af-south-1",
            "ap-east-1",
            "ap-northeast-1",
            "ap-northeast-2",
            "ap-south-1",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-southeast-3",
            "ca-central-1",
            "eu-central-1",
            "eu-north-1",
            "eu-west-1",
            "eu-west-2",
            "eu-west-3",
            "eu-south-1",
            "me-south-1",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-gov-west-1",
            "us-gov-east-1",
            "us-west-1",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/codebuild/",
        "isActive": "true",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/awsCodeBuild/en_US.json",
        "c2e": false,
        "slug": "codebuild",
        "mvpSupport": false,
        "comparableTerms": [
            "codebuild"
        ]
    },
    "awsCodeDeploy": {
        "name": "AWS CodeDeploy",
        "serviceCode": "awsCodeDeploy",
        "description": "AWS CodeDeploy is a fully managed deployment service that automates software deployments to a variety of compute services such as Amazon EC2, AWS Fargate, AWS Lambda, and your on-premises servers.",
        "searchKeywords": [
            "codedeploy",
            "CodeDeploy",
            "deployment"
        ],
        "type": "AWSService",
        "regions": [
            "us-gov-west-1",
            "us-gov-east-1",
            "af-south-1",
            "ap-east-1",
            "ap-south-1",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-southeast-3",
            "ap-northeast-1",
            "ap-northeast-2",
            "ap-northeast-3",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "eu-west-3",
            "eu-north-1",
            "eu-south-1",
            "me-south-1",
            "me-central-1",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/codedeploy/",
        "isActive": "true",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/awsCodeDeploy/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "slug": "CodeDeploy",
        "mvpSupport": false,
        "comparableTerms": [
            "codedeploy"
        ]
    },
    "awsCodePipeline": {
        "name": "AWS CodePipeline",
        "serviceCode": "awsCodePipeline",
        "description": "AWS CodePipeline is a fully managed continuous delivery service that helps you automate your release pipelines for fast and reliable application and infrastructure updates.",
        "searchKeywords": [
            "code",
            "pipeline"
        ],
        "type": "AWSService",
        "regions": [
            "us-gov-west-1",
            "ap-east-1",
            "ap-south-1",
            "ap-northeast-2",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-northeast-1",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "eu-south-1",
            "eu-west-3",
            "eu-north-1",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/codepipeline/",
        "isActive": "true",
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/awsCodePipeline/en_US.json",
        "c2e": false,
        "slug": "CodePipeline",
        "comparableTerms": [
            "codepipeline"
        ]
    },
    "awsConfig": {
        "name": "AWS Config",
        "serviceCode": "awsConfig",
        "description": "AWS Config is a service that enables you to assess, audit, and evaluate the configurations of your AWS resources. Config continuously monitors and records your AWS resource configurations and allows you to automate the evaluation of recorded configurations against desired configurations.",
        "searchKeywords": [
            "Management Tools",
            "management tools",
            "configuration management",
            "CMDB",
            "inventory",
            "discovery",
            "Config Rules",
            "compliance",
            "governance",
            "audit"
        ],
        "type": "AWSService",
        "regions": [
            "af-south-1",
            "ap-east-1",
            "ap-south-1",
            "ap-northeast-2",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-southeast-3",
            "ap-northeast-1",
            "us-gov-west-1",
            "us-gov-east-1",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "eu-west-3",
            "eu-north-1",
            "eu-south-1",
            "me-south-1",
            "me-central-1",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/config/",
        "isActive": "true",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/awsConfig/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "slug": "Config",
        "mvpSupport": false,
        "comparableTerms": [
            "config"
        ]
    },
    "awsCostExplorer": {
        "name": "AWS Cost Explorer",
        "serviceCode": "awsCostExplorer",
        "description": "AWS Cost Explorer provides you with a set of default reports that you can use as the starting place for your analysis. From there, use the filtering and grouping capabilities to dive deeper into your cost and usage data and generate custom insights.",
        "searchKeywords": [
            "aws cost explorer",
            "aws budgets",
            "cost management",
            "budgets"
        ],
        "type": "AWSService",
        "regions": [],
        "linkUrl": "https://aws.amazon.com/aws-cost-management/aws-cost-explorer/",
        "isActive": "true",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/awsCostExplorer/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/awsCostExplorer/en_US.json",
        "slug": "cost-explorer",
        "mvpSupport": false,
        "comparableTerms": [
            "costexplorer",
            "costmanagementcostexplorer"
        ]
    },
    "awsDataPipeline": {
        "name": "AWS Data Pipeline",
        "serviceCode": "awsDataPipeline",
        "description": "AWS Data Pipeline is a web service that helps you reliably process and move data between different AWS compute and storage services, as well as on-premises data sources, at specified intervals.",
        "searchKeywords": [
            "datapipeline",
            "data",
            "move data"
        ],
        "type": "AWSService",
        "regions": [
            "ap-northeast-1",
            "ap-southeast-2",
            "eu-west-1",
            "us-west-2",
            "us-east-1"
        ],
        "linkUrl": "https://aws.amazon.com/datapipeline/",
        "isActive": "true",
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/awsDataPipeline/en_US.json",
        "c2e": false,
        "slug": "datapipeline",
        "mvpSupport": false,
        "comparableTerms": [
            "datapipeline"
        ]
    },
    "aWSDataTransfer": {
        "name": "AWS Data Transfer",
        "serviceCode": "aWSDataTransfer",
        "description": "The cost of transferring data at AWS for services without unique transfer costs.",
        "searchKeywords": [],
        "type": "AWSService",
        "regions": [
            "af-south-1",
            "ap-east-1",
            "ap-northeast-1",
            "ap-northeast-1-wl1-nrt1",
            "ap-northeast-2",
            "ap-northeast-2-wl1-cjj1",
            "ap-northeast-2-wl1-sel1",
            "ap-northeast-3",
            "ap-south-1",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-southeast-3",
            "ca-central-1",
            "ca-central-1-wl1-yto1",
            "cloudfront",
            "me-south-1",
            "me-central-1",
            "eu-central-1",
            "eu-central-1-wl1-dtm1",
            "eu-central-1-wl1-ber1",
            "eu-central-1-wl1-muc1",
            "eu-north-1",
            "eu-south-1",
            "eu-west-1",
            "eu-west-2",
            "eu-west-2-wl1-lon1",
            "eu-west-3",
            "sa-east-1",
            "us-east-1",
            "us-east-1-atl-1",
            "us-east-1-bos-1",
            "us-east-1-chi-1",
            "us-east-1-dfw-1",
            "us-west-2-den-1",
            "us-east-1-iah-1",
            "us-east-1-mci-1",
            "us-east-1-mia-1",
            "us-east-1-msp-1",
            "us-east-1-nyc-1",
            "us-east-1-phl-1",
            "us-east-2",
            "us-gov-east-1",
            "us-gov-west-1",
            "us-west-1",
            "us-west-2",
            "us-west-2-las-1",
            "us-west-2-lax-1",
            "us-west-2-phx-1",
            "us-west-2-pdx-1",
            "us-west-2-sea-1",
            "us-west-2-wl1",
            "us-west-2-wl1-las1",
            "us-east-1-wl1",
            "us-east-1-wl1-atl1",
            "us-east-1-wl1-chi1",
            "us-east-1-wl1-clt1",
            "us-east-1-wl1-dfw1",
            "us-east-1-wl1-dtw1",
            "us-east-1-wl1-iah1",
            "us-east-1-wl1-mia1",
            "us-east-1-wl1-msp1",
            "us-east-1-wl1-bna1",
            "us-east-1-wl1-nyc1",
            "us-east-1-wl1-tpa1",
            "us-east-1-wl1-was1",
            "us-west-2-wl1-den1",
            "us-west-2-wl1-phx1",
            "us-west-2-wl1-lax1",
            "us-west-2-wl1-sea1"
        ],
        "linkUrl": "https://aws.amazon.com/ec2/pricing/on-demand/#Data_Transfer",
        "isActive": "true",
        "hasDataTransfer": true,
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/aWSDataTransfer/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "slug": "DataTransfer",
        "mvpSupport": false,
        "comparableTerms": [
            "datatransfer"
        ]
    },
    "awsDatabaseMigrationService": {
        "name": "AWS Database Migration Service",
        "serviceCode": "awsDatabaseMigrationService",
        "description": "AWS Database Migration Service helps you migrate databases to AWS quickly and securely.",
        "searchKeywords": [
            "Database",
            "Aurora",
            "MySQL",
            "MariaDB",
            "Postgres",
            "Oracle",
            "SQL Server",
            "PostgreSQL",
            "Microsoft SQL Server",
            "Migration",
            "microsoft",
            "sql",
            "msft",
            "DMS",
            "SCT",
            "DB",
            "MS",
            "win"
        ],
        "type": "AWSService",
        "regions": [
            "af-south-1",
            "ap-northeast-1",
            "ap-northeast-2",
            "ap-northeast-3",
            "ap-south-1",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-southeast-3",
            "ca-central-1",
            "eu-central-1",
            "eu-south-1",
            "eu-west-1",
            "eu-west-2",
            "eu-west-3",
            "me-central-1",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-gov-east-1",
            "us-gov-west-1",
            "us-west-1",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/dms/",
        "isActive": "true",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/awsDatabaseMigrationService/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "slug": "DMS",
        "mvpSupport": false,
        "comparableTerms": [
            "databasemigration",
            "databasemigrationservice",
            "dms"
        ]
    },
    "aWSDataSync": {
        "name": "AWS DataSync",
        "serviceCode": "aWSDataSync",
        "description": "AWS DataSync is an online data transfer service that simplifies, automates, and accelerates moving data between on-premises storage systems and AWS Storage services, as well as between AWS Storage services.",
        "searchKeywords": [],
        "type": "AWSService",
        "regions": [
            "af-south-1",
            "ap-east-1",
            "ap-south-1",
            "ap-northeast-2",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-southeast-3",
            "ap-northeast-1",
            "ap-northeast-3",
            "us-gov-east-1",
            "us-gov-west-1",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "eu-west-3",
            "eu-north-1",
            "eu-south-1",
            "me-south-1",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/datasync/",
        "isActive": "true",
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/aWSDataSync/en_US.json",
        "c2e": false,
        "slug": "DataSync",
        "mvpSupport": false,
        "comparableTerms": [
            "datasync"
        ]
    },
    "awsDeepRacer": {
        "name": "AWS DeepRacer",
        "serviceCode": "awsDeepRacer",
        "description": "With AWS DeepRacer, you can create your own machine learning models (in a process called 'training') and race them (in a process called 'evaluation'). You pay for training, evaluating and storing your machine learning models. Charges are based on the amount of time you train and evaluate a new model and the size of the model stored. Additionally, you can purchase a fully autonomous 1/18th scale DeepRacer car, which will allow you to try your models out on real tracks. No purchase is necessary to enter the DeepRacer League.",
        "searchKeywords": [
            "deepracer",
            "machine learning",
            "model training",
            "model evaluation",
            "ml"
        ],
        "type": "AWSService",
        "regions": [
            "us-east-1"
        ],
        "linkUrl": "https://aws.amazon.com/deepracer/",
        "isActive": "true",
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/awsDeepRacer/en_US.json",
        "c2e": false,
        "slug": "DeepRacer",
        "mvpSupport": false,
        "comparableTerms": [
            "deepracer"
        ]
    },
    "awsDeviceFarm": {
        "name": "AWS Device Farm",
        "serviceCode": "awsDeviceFarm",
        "description": "AWS Device Farm is an application testing service that lets you improve the quality of your web and mobile apps by testing them across an extensive range of desktop browsers and real mobile devices; without having to provision and manage any testing infrastructure. The service enables you to run your tests concurrently on multiple desktop browsers or real devices to speed up the execution of your test suite, and generates videos and logs to help you quickly identify issues with your app.",
        "searchKeywords": [
            "application testing",
            "mobile devices",
            "desktop browsers",
            "device farm",
            "automated testing",
            "remote access",
            "iOS",
            "Android",
            "unlimited testing",
            "pay as you go",
            "device minutes",
            "device slots",
            "free device minutes",
            "browser instances"
        ],
        "type": "AWSService",
        "regions": [
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/device-farm/",
        "isActive": "true",
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/awsDeviceFarm/en_US.json",
        "c2e": false,
        "slug": "DeviceFarm",
        "mvpSupport": false,
        "comparableTerms": [
            "devicefarm"
        ]
    },
    "awsDirectConnect": {
        "name": "AWS Direct Connect",
        "serviceCode": "awsDirectConnect",
        "description": "AWS Direct Connect is a cloud service solution that makes it easy to establish a dedicated network connection from your premises to AWS.",
        "searchKeywords": [
            "Direct Connect",
            "Data Transfer"
        ],
        "type": "AWSService",
        "regions": [
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2",
            "af-south-1",
            "ap-east-1",
            "ap-south-1",
            "ap-northeast-3",
            "ap-northeast-2",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-northeast-1",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "eu-south-1",
            "eu-west-3",
            "eu-north-1",
            "me-south-1",
            "me-central-1",
            "sa-east-1",
            "us-gov-east-1",
            "us-gov-west-1"
        ],
        "linkUrl": "https://aws.amazon.com/directconnect/",
        "isActive": "true",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/awsDirectConnect/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "slug": "DirectConnect",
        "mvpSupport": false,
        "comparableTerms": [
            "directconnect"
        ]
    },
    "aWSDirectoryService": {
        "name": "AWS Directory Service",
        "serviceCode": "aWSDirectoryService",
        "description": "AWS Directory Service is a managed service offering, providing directories that contain information about your organization, including users, groups, computers, and other resources.",
        "searchKeywords": [],
        "type": "AWSService",
        "regions": [
            "ap-south-1",
            "ap-northeast-2",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-northeast-1",
            "us-gov-west-1",
            "us-gov-east-1",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "eu-west-3",
            "eu-south-1",
            "me-south-1",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/directoryservice/",
        "isActive": "true",
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/aWSDirectoryService/en_US.json",
        "c2e": false,
        "slug": "DirectoryService",
        "mvpSupport": false,
        "comparableTerms": [
            "directory",
            "directoryservice"
        ]
    },
    "awsDrsDrill": {
        "name": "AWS DRS - Drill/Recovery",
        "serviceCode": "awsDrsDrill",
        "description": "AWS Elastic Disaster Recovery (AWS DRS) minimizes downtime and data loss with fast, reliable recovery of on-premises and cloud-based applications using affordable storage, minimal compute, and point-in-time recovery.",
        "searchKeywords": [
            "disaster recovery",
            "replicate",
            "elastic recovery",
            "point in time",
            "recovery",
            "on-premises recovery",
            "cloud-based",
            "affordable storage"
        ],
        "type": "AWSService",
        "regions": [
            "eu-west-1",
            "ap-northeast-1",
            "us-east-2",
            "us-west-2",
            "us-east-1",
            "ap-southeast-2",
            "eu-west-2",
            "eu-central-1",
            "ap-southeast-1"
        ],
        "linkUrl": "https://aws.amazon.com/disaster-recovery/pricing",
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/awsDrsDrill/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/awsDrsDrill/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "drsdrill",
            "drsdrillrecovery"
        ],
        "parentServiceCode": "awsElasticDisasterRecovery"
    },
    "awsDrsRecoveryReplication": {
        "name": "AWS DRS - Replication",
        "serviceCode": "awsDrsRecoveryReplication",
        "description": "AWS Elastic Disaster Recovery (AWS DRS) minimizes downtime and data loss with fast, reliable recovery of on-premises and cloud-based applications using affordable storage, minimal compute, and point-in-time recovery.",
        "searchKeywords": [
            "disaster recovery",
            "replicate",
            "elastic recovery",
            "point in time",
            "recovery",
            "on-premises recovery",
            "cloud-based",
            "affordable storage"
        ],
        "type": "AWSService",
        "regions": [
            "eu-west-1",
            "ap-northeast-1",
            "us-east-2",
            "us-west-2",
            "us-east-1",
            "ap-southeast-2",
            "eu-west-2",
            "eu-central-1",
            "ap-southeast-1"
        ],
        "linkUrl": "https://aws.amazon.com/disaster-recovery/pricing",
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/awsDrsRecoveryReplication/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "bulkImportEnabled": false,
        "serviceDefinitionUrlPath": "/data/awsDrsRecoveryReplication/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "drsrecoveryreplication",
            "drsreplication"
        ],
        "parentServiceCode": "awsElasticDisasterRecovery"
    },
    "awsElasticDisasterRecovery": {
        "name": "AWS Elastic Disaster Recovery",
        "serviceCode": "awsElasticDisasterRecovery",
        "description": "AWS Elastic Disaster Recovery (AWS DRS) minimizes downtime and data loss with fast, reliable recovery of on-premises and cloud-based applications using affordable storage, minimal compute, and point-in-time recovery.",
        "searchKeywords": [
            "disaster recovery",
            "replicate",
            "elastic recovery",
            "point in time",
            "recovery",
            "on-premises recovery",
            "cloud-based",
            "affordable storage"
        ],
        "type": "AWSService",
        "regions": [],
        "linkUrl": "https://aws.amazon.com/disaster-recovery/",
        "isActive": "true",
        "subType": "subServiceSelector",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/awsElasticDisasterRecovery/en_US.json",
        "c2e": false,
        "templates": [
            "awsDrsRecoveryReplication",
            "awsDrsDrill"
        ],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/awsElasticDisasterRecovery/en_US.json",
        "slug": "ElasticDisasterRecovery",
        "mvpSupport": false,
        "comparableTerms": [
            "disasterrecovery",
            "elasticdisasterrecovery"
        ]
    },
    "awsElementalMediaTailor": {
        "name": "AWS Elemental Media Tailor",
        "serviceCode": "awsElementalMediaTailor",
        "description": "AWS Elemental MediaTailor is a channel assembly and personalized ad insertion service for video providers to create linear OTT (internet delivered) channels using existing video content and monetize those channels, or other live streams and VOD content, with personalized advertising.",
        "searchKeywords": [
            "elemental",
            "tailor",
            "mediatailor"
        ],
        "type": "AWSService",
        "regions": [
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-northeast-1",
            "eu-central-1",
            "eu-west-1",
            "us-east-1",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/mediatailor/",
        "isActive": "true",
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/awsElementalMediaTailor/en_US.json",
        "c2e": false,
        "slug": "ElementalMediaTailor",
        "mvpSupport": false,
        "comparableTerms": [
            "elementalmediatailor",
            "mediatailor"
        ]
    },
    "awsElementalMediaConnect": {
        "name": "AWS Elemental MediaConnect",
        "serviceCode": "awsElementalMediaConnect",
        "description": "AWS Elemental MediaConnect is a high-quality transport service for live video.",
        "searchKeywords": [
            "transport",
            "video",
            "broadcast",
            "live",
            "flows",
            "JPEG XS",
            "CDI"
        ],
        "type": "AWSService",
        "regions": [
            "ap-east-1",
            "ap-northeast-1",
            "ap-northeast-2",
            "ap-south-1",
            "ap-southeast-1",
            "ap-southeast-2",
            "eu-central-1",
            "eu-north-1",
            "eu-west-1",
            "eu-west-2",
            "eu-west-3",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/mediaconnect/",
        "isActive": "true",
        "hasDataTransfer": true,
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/awsElementalMediaConnect/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "slug": "ElementalMediaConnect",
        "mvpSupport": false,
        "comparableTerms": [
            "elementalmediaconnect",
            "mediaconnect"
        ]
    },
    "elementalMediaConvert": {
        "name": "AWS Elemental MediaConvert",
        "serviceCode": "elementalMediaConvert",
        "description": "AWS Elemental MediaConvert is a file-based video transcoding service with broadcast-grade features. It allows you to easily create video-on-demand (VOD) content for broadcast and multiscreen delivery at scale.",
        "searchKeywords": [],
        "type": "AWSService",
        "regions": [
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2",
            "ap-south-1",
            "ap-northeast-2",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-northeast-1",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "eu-west-3",
            "eu-north-1",
            "sa-east-1",
            "us-gov-west-1"
        ],
        "linkUrl": "https://aws.amazon.com/mediaconvert/",
        "isActive": "true",
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/elementalMediaConvert/en_US.json",
        "c2e": false,
        "mvpSupport": false,
        "comparableTerms": [
            "elementalmediaconvert",
            "mediaconvert"
        ]
    },
    "awsElementalMediaLive": {
        "name": "AWS Elemental MediaLive",
        "serviceCode": "awsElementalMediaLive",
        "description": "AWS Elemental MediaLive is a broadcast-grade live video processing service. It lets you create high-quality video streams for delivery to broadcast televisions and internet-connected multiscreen devices, like connected TVs, tablets, smart phones, and set-top boxes.",
        "searchKeywords": [
            "media",
            "video processing",
            "broadcast",
            "TV",
            "video streams",
            "channels"
        ],
        "type": "AWSService",
        "regions": [],
        "linkUrl": "https://aws.amazon.com/medialive/",
        "isActive": "true",
        "subType": "subServiceSelector",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/awsElementalMediaLive/en_US.json",
        "c2e": false,
        "templates": [
            "mediaLiveInput1",
            "mediaLiveOutput1",
            "mediaLiveAudioAddOns"
        ],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/awsElementalMediaLive/en_US.json",
        "slug": "ElementalMediaLive",
        "mvpSupport": false,
        "comparableTerms": [
            "elementalmedialive",
            "medialive"
        ]
    },
    "awsElementalMediaPackage": {
        "name": "AWS Elemental MediaPackage",
        "serviceCode": "awsElementalMediaPackage",
        "description": "AWS Elemental MediaPackage reliably prepares and protects your video for delivery over the Internet. From a single video input, AWS Elemental MediaPackage creates video streams formatted to play on connected TVs, mobile phones, computers, tablets, and game consoles.",
        "searchKeywords": [
            "media",
            "video processing",
            "broadcast",
            "TV",
            "video streams",
            "channels"
        ],
        "type": "AWSService",
        "regions": [
            "ap-south-1",
            "ap-northeast-2",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-northeast-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "eu-west-3",
            "eu-north-1",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/mediapackage/",
        "isActive": "true",
        "hasDataTransfer": true,
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/awsElementalMediaPackage/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "slug": "ElementalMediaPackage",
        "mvpSupport": false,
        "comparableTerms": [
            "elementalmediapackage",
            "mediapackage"
        ]
    },
    "awsFargate": {
        "name": "AWS Fargate",
        "serviceCode": "awsFargate",
        "description": "AWS Fargate is a serverless compute engine for containers that works with both Amazon Elastic Container Service (ECS) and Amazon Elastic Kubernetes Service (EKS). Fargate makes it easy for you to focus on building your applications. Fargate removes the need to provision and manage servers, lets you specify and pay for resources per application, and improves security through application isolation by design.",
        "searchKeywords": [
            "serverless",
            "compute",
            "engine",
            "ECS",
            "EKS",
            "container",
            "Kubernetes"
        ],
        "type": "AWSService",
        "regions": [
            "us-gov-west-1",
            "us-gov-east-1",
            "af-south-1",
            "ap-east-1",
            "ap-south-1",
            "ap-northeast-3",
            "ap-northeast-2",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-southeast-3",
            "ap-northeast-1",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "eu-south-1",
            "eu-west-3",
            "eu-north-1",
            "me-south-1",
            "me-central-1",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/fargate/",
        "isActive": "true",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/awsFargate/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/awsFargate/en_US.json",
        "slug": "Fargate",
        "mvpSupport": false,
        "comparableTerms": [
            "fargate"
        ]
    },
    "awsGlue": {
        "name": "AWS Glue",
        "serviceCode": "awsGlue",
        "description": "AWS Glue is a serverless data preparation service that makes it easy for data engineers, extract, transform, and load (ETL) developers, data analysts, and data scientists to extract, clean, enrich, normalize, and load data. AWS Glue reduces the time it takes to start analyzing your data from months to minutes.",
        "searchKeywords": [
            "etl",
            "AWS glue data catalog",
            "glue",
            "crawlers",
            "development endpoints",
            "databrew"
        ],
        "type": "AWSService",
        "regions": [],
        "linkUrl": "https://aws.amazon.com/glue/",
        "isActive": "true",
        "subType": "subServiceSelector",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/awsGlue/en_US.json",
        "c2e": false,
        "templates": [
            "awsEtlJobsAndDevelopmentEndpoints",
            "awsEtlJobsFlexExecutionOption",
            "awsGlueDataCatalogStorageRequests",
            "awsGlueDataBrewInteractiveSessions",
            "awsGlueCrawlers"
        ],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/awsGlue/en_US.json",
        "slug": "Glue",
        "mvpSupport": false,
        "comparableTerms": [
            "glue"
        ]
    },
    "awsGlueCrawlers": {
        "name": "AWS Glue Crawlers",
        "serviceCode": "awsGlueCrawlers",
        "description": "",
        "searchKeywords": [],
        "type": "AWSService",
        "regions": [
            "us-gov-west-1",
            "us-gov-east-1",
            "af-south-1",
            "ap-east-1",
            "ap-south-1",
            "ap-northeast-3",
            "ap-northeast-2",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-northeast-1",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "eu-south-1",
            "eu-west-3",
            "eu-north-1",
            "me-south-1",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2"
        ],
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/awsGlueCrawlers/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/awsGlueCrawlers/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "gluecrawlers"
        ],
        "parentServiceCode": "awsGlue"
    },
    "awsGlueDataCatalogStorageRequests": {
        "name": "AWS Glue Data Catalog storage requests",
        "serviceCode": "awsGlueDataCatalogStorageRequests",
        "description": "",
        "searchKeywords": [],
        "type": "AWSService",
        "regions": [
            "us-gov-west-1",
            "us-gov-east-1",
            "af-south-1",
            "ap-east-1",
            "ap-south-1",
            "ap-northeast-3",
            "ap-northeast-2",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-northeast-1",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "eu-south-1",
            "eu-west-3",
            "eu-north-1",
            "me-south-1",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2"
        ],
        "isActive": "true",
        "subType": "subService",
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/awsGlueDataCatalogStorageRequests/en_US.json",
        "c2e": false,
        "mvpSupport": false,
        "comparableTerms": [
            "gluedatacatalogstoragerequests"
        ],
        "parentServiceCode": "awsGlue"
    },
    "awsGlueDataBrewInteractiveSessions": {
        "name": "AWS Glue DataBrew interactive sessions",
        "serviceCode": "awsGlueDataBrewInteractiveSessions",
        "description": "",
        "searchKeywords": [],
        "type": "AWSService",
        "regions": [
            "ap-south-1",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-northeast-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "eu-west-3",
            "eu-north-1",
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2"
        ],
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/awsGlueDataBrewInteractiveSessions/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/awsGlueDataBrewInteractiveSessions/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "gluedatabrewinteractivesessions"
        ],
        "parentServiceCode": "awsGlue"
    },
    "awsEtlJobsAndDevelopmentEndpoints": {
        "name": "AWS Glue ETL jobs and development endpoints",
        "serviceCode": "awsEtlJobsAndDevelopmentEndpoints",
        "description": "",
        "searchKeywords": [],
        "type": "AWSService",
        "regions": [
            "us-gov-west-1",
            "us-gov-east-1",
            "af-south-1",
            "ap-east-1",
            "ap-south-1",
            "ap-northeast-3",
            "ap-northeast-2",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-northeast-1",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "eu-south-1",
            "eu-west-3",
            "eu-north-1",
            "me-south-1",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2"
        ],
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/awsEtlJobsAndDevelopmentEndpoints/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/awsEtlJobsAndDevelopmentEndpoints/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "etljobsanddevelopmentendpoints",
            "glueetljobsdevelopmentendpoints"
        ],
        "parentServiceCode": "awsGlue"
    },
    "awsEtlJobsFlexExecutionOption": {
        "name": "AWS Glue ETL jobs with Flex execution option",
        "serviceCode": "awsEtlJobsFlexExecutionOption",
        "description": "",
        "searchKeywords": [],
        "type": "AWSService",
        "regions": [
            "ap-northeast-1",
            "ap-northeast-2",
            "ap-south-1",
            "ap-southeast-1",
            "ap-southeast-2",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "eu-west-3",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2"
        ],
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/awsEtlJobsFlexExecutionOption/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "mvpSupport": false,
        "comparableTerms": [
            "etljobsflexexecutionoption",
            "glueetljobswithflexexecutionoption"
        ],
        "parentServiceCode": "awsGlue"
    },
    "awsIoTAnalytics": {
        "name": "AWS IoT Analytics",
        "serviceCode": "awsIoTAnalytics",
        "description": "AWS IoT Analytics is a fully-managed IoT analytics service that collects, pre-processes, enriches, stores, and analyzes IoT device data at scale.",
        "searchKeywords": [
            "AWS IoT Analytics",
            "iot analytics",
            "analytics"
        ],
        "type": "AWSService",
        "regions": [
            "ap-northeast-1",
            "ap-south-1",
            "ap-southeast-2",
            "eu-central-1",
            "eu-west-1",
            "us-east-1",
            "us-east-2",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/iot-analytics/",
        "isActive": "true",
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/awsIoTAnalytics/en_US.json",
        "c2e": false,
        "slug": "iot-analytics",
        "mvpSupport": false,
        "comparableTerms": [
            "iotanalytics"
        ]
    },
    "awsIoTCore": {
        "name": "AWS IoT Core",
        "serviceCode": "awsIoTCore",
        "description": "AWS IoT Core is a managed cloud service that lets connected devices easily and securely interact with cloud applications and other devices.",
        "searchKeywords": [
            "iot",
            "device",
            "messages",
            "shadow",
            "registry",
            "rules",
            "device shadow",
            "rules engine",
            "basic ingest",
            "mqtt",
            "LoRaWAN"
        ],
        "type": "AWSService",
        "regions": [],
        "linkUrl": "https://aws.amazon.com/iot-core/",
        "isActive": "true",
        "subType": "subServiceSelector",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/awsIoTCore/en_US.json",
        "c2e": false,
        "templates": [
            "awsIoTCoreMqtt",
            "awsIoTCoreHttp",
            "awsIoTCoreLoRaWan"
        ],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/awsIoTCore/en_US.json",
        "slug": "IoTCore",
        "mvpSupport": false,
        "comparableTerms": [
            "iotcore"
        ]
    },
    "awsIoTDeviceDefender": {
        "name": "AWS IoT Device Defender",
        "serviceCode": "awsIoTDeviceDefender",
        "description": "AWS IoT Device Defender is a fully managed service that helps you secure your fleet of IoT devices.",
        "searchKeywords": [
            "device",
            "iot",
            "iot device defender",
            "defender",
            "audit",
            "detect",
            "metric",
            "fleet"
        ],
        "type": "AWSService",
        "regions": [
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2",
            "ap-east-1",
            "ap-south-1",
            "ap-northeast-2",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-northeast-1",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "eu-west-3",
            "eu-north-1",
            "me-south-1",
            "us-gov-east-1",
            "us-gov-west-1"
        ],
        "linkUrl": "https://aws.amazon.com/iot-device-defender/",
        "isActive": "true",
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/awsIoTDeviceDefender/en_US.json",
        "c2e": false,
        "slug": "IoTDeviceDefender",
        "comparableTerms": [
            "iotdevicedefender"
        ]
    },
    "awsIoTDeviceManagement": {
        "name": "AWS IoT Device Management",
        "serviceCode": "awsIoTDeviceManagement",
        "description": "AWS IoT Device Management makes it easy for you to manage your fleets of connected devices at any scale.",
        "searchKeywords": [
            "device management",
            "fleet indexing",
            "index updates",
            "device query",
            "device queries",
            "jobs",
            "remote actions",
            "secure tunneling",
            "tunnels"
        ],
        "type": "AWSService",
        "regions": [
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2",
            "ap-east-1",
            "ap-south-1",
            "ap-northeast-2",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-northeast-1",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "eu-west-3",
            "eu-north-1",
            "me-south-1",
            "sa-east-1",
            "us-gov-east-1",
            "us-gov-west-1"
        ],
        "linkUrl": "https://aws.amazon.com/iot-device-management/",
        "isActive": "true",
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/awsIoTDeviceManagement/en_US.json",
        "c2e": false,
        "slug": "IoTDeviceManagement",
        "comparableTerms": [
            "iotdevicemanagement"
        ]
    },
    "awsIoTEvents": {
        "name": "AWS IoT Events",
        "serviceCode": "awsIoTEvents",
        "description": "AWS IoT Events makes it easy to detect and respond to changes indicated by IoT sensors and applications – such as malfunctioning machinery, a stuck conveyor belt, or a slowdown in production output – and automatically trigger actions or alerts in response.",
        "searchKeywords": [
            "iot",
            "iot events"
        ],
        "type": "AWSService",
        "regions": [
            "ap-northeast-1",
            "ap-northeast-2",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-south-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "us-east-1",
            "us-east-2",
            "us-west-2",
            "us-gov-west-1"
        ],
        "linkUrl": "https://aws.amazon.com/iot-events/",
        "isActive": "true",
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/awsIoTEvents/en_US.json",
        "c2e": false,
        "slug": "iot-events",
        "mvpSupport": false,
        "comparableTerms": [
            "iotevents"
        ]
    },
    "awsIoTGreengrass": {
        "name": "AWS IoT Greengrass",
        "serviceCode": "awsIoTGreengrass",
        "description": "AWS IoT Greengrass is an Internet of Things (IoT) open source edge runtime and cloud service that helps you build, deploy, and manage device software. Customers use AWS IoT Greengrass for their IoT applications on millions of devices in homes, factories, vehicles, and businesses.",
        "searchKeywords": [
            "greengrass",
            "AWS IoT Greengrass"
        ],
        "type": "AWSService",
        "regions": [
            "ap-northeast-1",
            "ap-northeast-2",
            "ap-south-1",
            "ap-southeast-1",
            "ap-southeast-2",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "us-east-1",
            "us-east-2",
            "us-gov-east-1",
            "us-gov-west-1",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/greengrass/",
        "isActive": "true",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/awsIoTGreengrass/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "slug": "greengrass",
        "mvpSupport": false,
        "comparableTerms": [
            "greengrass",
            "iotgreengrass"
        ]
    },
    "awsIoTThingsGraph": {
        "name": "AWS IoT Things Graph",
        "serviceCode": "awsIoTThingsGraph",
        "description": "AWS IoT Things Graph makes it easy to rapidly build IoT applications by connecting devices and web services from different vendors that speak different protocols.",
        "searchKeywords": [
            "IoT",
            "Things",
            "graph",
            "IoT Things Graph"
        ],
        "type": "AWSService",
        "regions": [
            "ap-northeast-2",
            "ap-southeast-2",
            "ap-northeast-1",
            "eu-west-1",
            "us-east-1",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/iot-things-graph/",
        "isActive": "true",
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/awsIoTThingsGraph/en_US.json",
        "c2e": false,
        "slug": "IoTThingsGraph",
        "comparableTerms": [
            "iotthingsgraph"
        ]
    },
    "awsKeyManagementService": {
        "name": "AWS Key Management Service",
        "serviceCode": "awsKeyManagementService",
        "description": "Securely Generate and Manage AWS Encryption Keys",
        "searchKeywords": [
            "KMS",
            "Key Management System"
        ],
        "type": "AWSService",
        "regions": [
            "af-south-1",
            "ap-east-1",
            "ap-northeast-1",
            "ap-northeast-2",
            "ap-northeast-3",
            "ap-south-1",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-southeast-3",
            "ca-central-1",
            "eu-central-1",
            "eu-north-1",
            "eu-south-1",
            "eu-west-1",
            "eu-west-2",
            "eu-west-3",
            "me-south-1",
            "me-central-1",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-gov-east-1",
            "us-gov-west-1",
            "us-west-1",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/kms/",
        "isActive": "true",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/awsKeyManagementService/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "slug": "KMS",
        "mvpSupport": false,
        "comparableTerms": [
            "keymanagement",
            "keymanagementservice",
            "kms"
        ]
    },
    "awsLakeFormation": {
        "name": "AWS Lake Formation",
        "serviceCode": "awsLakeFormation",
        "description": "AWS Lake Formation provides database, table, column and tag-based access controls, and cross-account sharing at no charge. Governed Tables provide ACID transactions as a fully managed service that enable you to reliably update multiple tables, while maintaining a consistent view for all users. Managing concurrent transactions and being able to travel back to previous version of the table requires storing metadata about each transaction. Lake Formation charges a fee for transaction requests and for metadata storage. In addition, to providing a consistent view of data and enforce row and cell-level security the Lake Formation Storage API scans data in Amazon S3 and applies row and cell filters before returning results to applications. There is a fee for this filtering.",
        "searchKeywords": [
            "Lake Formation",
            "LF",
            "If",
            "Formation",
            "lakeformation",
            "Lake"
        ],
        "type": "AWSService",
        "regions": [
            "us-east-1",
            "us-east-2",
            "us-west-2",
            "ap-northeast-1",
            "ap-northeast-2",
            "ap-south-1",
            "ap-southeast-1",
            "ap-southeast-2",
            "eu-west-1",
            "eu-west-2",
            "eu-central-1",
            "eu-north-1",
            "ca-central-1"
        ],
        "linkUrl": "https://aws.amazon.com/lake-formation/",
        "isActive": "true",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/awsLakeFormation/en_US.json",
        "c2e": false,
        "slug": "LakeFormation",
        "mvpSupport": false,
        "comparableTerms": [
            "lakeformation"
        ]
    },
    "aWSLambda": {
        "name": "AWS Lambda",
        "serviceCode": "aWSLambda",
        "description": "AWS Lambda lets you run code without provisioning or managing servers. You pay only for the compute time you consume - there is no charge when your code is not running.",
        "searchKeywords": [],
        "type": "AWSService",
        "regions": [
            "af-south-1",
            "ap-east-1",
            "ap-northeast-1",
            "ap-northeast-2",
            "ap-northeast-3",
            "ap-south-1",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-southeast-3",
            "ca-central-1",
            "eu-central-1",
            "eu-north-1",
            "eu-south-1",
            "eu-west-1",
            "eu-west-2",
            "eu-west-3",
            "me-south-1",
            "me-central-1",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-gov-east-1",
            "us-gov-west-1",
            "us-west-1",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/lambda/",
        "isActive": "true",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/aWSLambda/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/aWSLambda/en_US.json",
        "slug": "Lambda",
        "mvpSupport": false,
        "comparableTerms": [
            "lambda"
        ]
    },
    "locationService": {
        "name": "AWS Location Service",
        "serviceCode": "locationService",
        "description": "Amazon Location Service provides affordable data, tracking and geofencing capabilities, and native integrations with AWS services, so you can create sophisticated location-enabled applications quickly, without the high cost of custom development.",
        "searchKeywords": [
            "Location Service",
            "compromising data security",
            "user privacy",
            "asset tracking",
            "location-based marketing",
            "geofencing"
        ],
        "type": "AWSService",
        "regions": [],
        "linkUrl": "https://aws.amazon.com/location/",
        "isActive": "true",
        "subType": "subServiceSelector",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/locationService/en_US.json",
        "c2e": false,
        "templates": [
            "locationServiceMaps",
            "locationServicePlaces",
            "locationServiceRouting",
            "locationServiceTracking",
            "locationServiceGeofencing",
            "locationServiceServiceResources"
        ],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/locationService/en_US.json",
        "slug": "LocationService",
        "mvpSupport": false,
        "comparableTerms": [
            "location",
            "locationservice"
        ]
    },
    "amazonMainframeModernization": {
        "name": "AWS Mainframe Modernization",
        "serviceCode": "amazonMainframeModernization",
        "description": "AWS Mainframe Modernization (Preview) is a set of managed tools providing infrastructure and software for migrating, modernizing, and executing mainframe applications.",
        "searchKeywords": [
            "Blu Age",
            "Micro",
            "Mainframe",
            "m2",
            "instance",
            "modernization"
        ],
        "type": "AWSService",
        "regions": [],
        "linkUrl": "https://aws.amazon.com/mainframe-modernization/",
        "isActive": "true",
        "subType": "subServiceSelector",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonMainframeModernization/en_US.json",
        "c2e": false,
        "templates": [
            "mainframeBluAge",
            "mainframeMicroFocus"
        ],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/amazonMainframeModernization/en_US.json",
        "slug": "mainframeModernization",
        "mvpSupport": false,
        "comparableTerms": [
            "mainframemodernization"
        ]
    },
    "migrationHubRefactorSpaces": {
        "name": "AWS Migration Hub Refactor Spaces",
        "serviceCode": "migrationHubRefactorSpaces",
        "description": "AWS Migration Hub Refactor Spaces is the starting point for incremental application refactoring to microservices. Refactor Spaces eliminates the undifferentiated work of building and operating AWS infrastructure for incremental refactoring. You can use Refactor Spaces to reduce the risk of evolving applications into microservices or extending existing applications with new features written in microservices.",
        "searchKeywords": [
            "Migration Hub",
            "cloud migration",
            "IT asset",
            "inventory data",
            "Refactor Spaces"
        ],
        "type": "AWSService",
        "regions": [
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-northeast-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "eu-north-1",
            "us-east-1",
            "us-east-2",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/migration-hub/",
        "isActive": "true",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/migrationHubRefactorSpaces/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "slug": "migration-hub",
        "mvpSupport": false,
        "comparableTerms": [
            "migrationhub",
            "migrationhubrefactorspaces"
        ]
    },
    "amazonNetworkFirewall": {
        "name": "AWS Network Firewall",
        "serviceCode": "amazonNetworkFirewall",
        "description": "AWS Network Firewall is a managed service that makes it easy to deploy essential network protections for all of your Amazon Virtual Private Clouds (VPCs). The service can be setup with just a few clicks and scales automatically with your network traffic, so you don't have to worry about deploying and managing any infrastructure.",
        "searchKeywords": [
            "amazonNetworkFirewall",
            "AWS Network Firewall"
        ],
        "type": "AWSService",
        "regions": [
            "ap-east-1",
            "ap-south-1",
            "ap-northeast-2",
            "ap-northeast-3",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-northeast-1",
            "us-gov-west-1",
            "us-gov-east-1",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "eu-west-3",
            "eu-north-1",
            "eu-south-1",
            "me-south-1",
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2",
            "sa-east-1",
            "af-south-1"
        ],
        "linkUrl": "https://aws.amazon.com/network-firewall/",
        "isActive": "true",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonNetworkFirewall/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/amazonNetworkFirewall/en_US.json",
        "slug": "networkfirewall",
        "mvpSupport": false,
        "comparableTerms": [
            "networkfirewall"
        ]
    },
    "awsOutposts": {
        "name": "AWS Outposts",
        "serviceCode": "awsOutposts",
        "description": "AWS Outposts is a fully managed service that offers the same AWS infrastructure, AWS services, APIs, and tools to virtually any datacenter, co-location space, or on-premises facility for a truly consistent hybrid experience. AWS Outposts is ideal for workloads that require low latency access to on-premises systems, local data processing, data residency, and migration of applications with local system interdependencies.",
        "searchKeywords": [
            "Outposts",
            "AWS infrastructure",
            "AWS services",
            "API",
            "datacenter",
            "on-premises facility",
            "hybrid",
            "compute",
            "storage",
            "database",
            "EC2",
            "EBS",
            "S3"
        ],
        "type": "AWSService",
        "regions": [
            "us-east-1"
        ],
        "linkUrl": "https://aws.amazon.com/outposts/",
        "isActive": "true",
        "hasDataTransfer": false,
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/awsOutposts/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": true,
        "serviceDefinitionUrlPath": "/data/awsOutposts/en_US.json",
        "slug": "Outposts",
        "mvpSupport": false,
        "comparableTerms": [
            "outposts"
        ]
    },
    "aWSPricingCalculatorStrings": {
        "name": "AWS Pricing Calculator Strings",
        "serviceCode": "aWSPricingCalculatorStrings",
        "searchKeywords": [],
        "type": "static",
        "regions": [],
        "isActive": "true",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/aWSPricingCalculatorStrings/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "bulkImportEnabled": false,
        "serviceDefinitionUrlPath": "/data/aWSPricingCalculatorStrings/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "pricingcalculatorstrings"
        ]
    },
    "awsPrivateLinkVpc": {
        "name": "AWS PrivateLink",
        "serviceCode": "awsPrivateLinkVpc",
        "description": "WS Virtual Private Network solutions establish secure connections between your on-premises networks, remote offices, client devices, and the AWS global network. AWS VPN is comprised of two services: AWS Site-to-Site VPN and AWS Client VPN. Each service provides a highly-available, managed, and elastic cloud VPN solution to protect your network traffic.",
        "searchKeywords": [
            "access control",
            "ACL",
            "AWS Privatelink",
            "Cloud connectivity",
            "corporate network",
            "elastic IP",
            "Gateway load balancer",
            "home network VPN",
            "IPAM",
            "NAT",
            "NAT gateway",
            "Network Access Analyzer",
            "Network Address Translation",
            "Networking Content Delivery",
            "PrivateLink",
            "Reachability Analyzer",
            "security",
            "single tenant hardware",
            "static ip",
            "subnets",
            "Traffic mirroring",
            "Transit Gateway",
            "Virtual Private Cloud",
            "VPN"
        ],
        "type": "AWSService",
        "regions": [
            "af-south-1",
            "ap-east-1",
            "ap-northeast-1",
            "ap-northeast-2",
            "ap-northeast-3",
            "ap-south-1",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-southeast-3",
            "ca-central-1",
            "eu-central-1",
            "eu-north-1",
            "eu-south-1",
            "eu-west-1",
            "eu-west-2",
            "eu-west-3",
            "me-south-1",
            "me-central-1",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2",
            "us-gov-west-1"
        ],
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/awsPrivateLinkVpc/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/awsPrivateLinkVpc/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "privatelink",
            "privatelinkvpc"
        ],
        "parentServiceCode": "amazonVirtualPrivateCloud"
    },
    "awsProfessionalServices": {
        "name": "AWS Professional Services",
        "serviceCode": "awsProfessionalServices",
        "description": " The AWS Professional Services team provides assistance through a collection of offerings that help you achieve specific outcomes related to enterprise cloud adoption. We also deliver focused guidance through our global specialty practices, which cover a variety of solutions, technologies, and industries.",
        "searchKeywords": [
            "ProServe",
            "professional",
            "Service"
        ],
        "type": "AWSService",
        "regions": [],
        "linkUrl": "https://aws.amazon.com/professional-services/",
        "isActive": "true",
        "subType": "subServiceSelector",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/awsProfessionalServices/en_US.json",
        "c2e": true,
        "templates": [
            "proServeYear1Cost",
            "proServeYear2Cost",
            "proServeYear3Cost",
            "proServeYear4Cost",
            "proServeYear5Cost"
        ],
        "disableRegionSupport": true,
        "bulkImportEnabled": false,
        "serviceDefinitionUrlPath": "/data/awsProfessionalServices/en_US.json",
        "mvpSupport": true,
        "comparableTerms": [
            "professionalservices"
        ]
    },
    "awsSecretsManager": {
        "name": "AWS Secrets Manager",
        "serviceCode": "awsSecretsManager",
        "description": "AWS Secrets Manager enables you to rotate, manage, and retrieve secrets throughout their lifecycle, making it easier to maintain a secure environment that meets your security and compliance needs. With Secrets Manager, you pay based on the number of secrets stored and API calls made.",
        "searchKeywords": [
            "Secrets",
            "Secrets Manager"
        ],
        "type": "AWSService",
        "regions": [
            "us-gov-west-1",
            "us-gov-east-1",
            "af-south-1",
            "ap-east-1",
            "ap-south-1",
            "ap-northeast-2",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-southeast-3",
            "ap-northeast-1",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "eu-south-1",
            "eu-west-3",
            "eu-north-1",
            "me-south-1",
            "me-central-1",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/secrets-manager/",
        "isActive": "true",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/awsSecretsManager/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "slug": "SecretsManager",
        "mvpSupport": false,
        "comparableTerms": [
            "secretsmanager"
        ]
    },
    "awsSecurityHub": {
        "name": "AWS Security Hub",
        "serviceCode": "awsSecurityHub",
        "description": "AWS Security Hub performs security best practice checks and ingests security findings from AWS security services and partners.",
        "searchKeywords": [
            "security",
            "hub"
        ],
        "type": "AWSService",
        "regions": [
            "af-south-1",
            "ap-east-1",
            "ap-south-1",
            "ap-northeast-3",
            "ap-northeast-2",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-northeast-1",
            "us-gov-east-1",
            "us-gov-west-1",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "eu-south-1",
            "eu-west-3",
            "eu-north-1",
            "me-south-1",
            "sa-east-1",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/security-hub/",
        "isActive": "true",
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/awsSecurityHub/en_US.json",
        "c2e": false,
        "slug": "securityHub",
        "mvpSupport": false,
        "comparableTerms": [
            "securityhub"
        ]
    },
    "awsShield": {
        "name": "AWS Shield",
        "serviceCode": "awsShield",
        "description": "AWS Shield Advanced is a paid service that provides additional protections for internet-facing applications running on Amazon Elastic Compute Cloud (EC2), Elastic Load Balancing (ELB), Amazon CloudFront, AWS Global Accelerator, and Amazon Route 53. AWS Shield Advanced is available to all customers; however, to contact the AWS Shield Response Team customers will need the Enterprise or Business Support levels of AWS Premium Support.",
        "searchKeywords": [
            "shield",
            "DDoS"
        ],
        "type": "AWSService",
        "regions": [
            " "
        ],
        "linkUrl": "https://aws.amazon.com/shield/pricing/",
        "isActive": "true",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/awsShield/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "bulkImportEnabled": false,
        "serviceDefinitionUrlPath": "/data/awsShield/en_US.json",
        "slug": "shield",
        "mvpSupport": false,
        "comparableTerms": [
            "shield",
            "shieldpricing"
        ]
    },
    "awsSnowball": {
        "name": "AWS Snowball",
        "serviceCode": "awsSnowball",
        "description": "AWS Snowball, a part of the AWS Snow Family, is an edge computing, data migration, and edge storage device that comes in two options. Snowball Edge Storage Optimized devices provide both block storage and Amazon S3-compatible object storage, and 40 vCPUs. They are well suited for local storage and large scale-data transfer. Snowball Edge Compute Optimized devices provide 52 vCPUs, block and object storage, and an optional GPU for use cases like advanced machine learning and full motion video analysis in disconnected environments.",
        "searchKeywords": [
            "Snow",
            "Snowball",
            "Snowball Edge",
            "Disconnected Data Transfer",
            "Edge Computing",
            "Data Export"
        ],
        "type": "AWSService",
        "regions": [],
        "linkUrl": "https://aws.amazon.com/snowball/",
        "isActive": "true",
        "subType": "subServiceSelector",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/awsSnowball/en_US.json",
        "c2e": false,
        "templates": [
            "snowballEdgeComputeOptimizedWithEc2ComputeInstances",
            "snowballEdgeComputeOptimizedGpuWithEc2ComputeInstances",
            "snowballEdgeStorageOptimizedWithEc2ComputeInstances",
            "snowballEdgeStorageOptimizedDataTransferOnly"
        ],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/awsSnowball/en_US.json",
        "slug": "Snowball",
        "mvpSupport": false,
        "comparableTerms": [
            "snowball"
        ]
    },
    "awsSnowmobile": {
        "name": "AWS Snowmobile",
        "serviceCode": "awsSnowmobile",
        "description": "AWS Snowmobile is an Exabyte-scale data transfer service used to move extremely large amounts of data to AWS. You can transfer up to 100PB per Snowmobile, a 45-foot long ruggedized shipping container, pulled by a semi-trailer truck. Snowmobile makes it easy to move massive volumes of data to the cloud, including video libraries, image repositories, or even a complete data center migration. Transferring data with Snowmobile is more secure, fast and cost effective.",
        "searchKeywords": [
            "Snowmobile",
            "data transfer",
            "video libraries",
            "image repositories",
            "data center migration",
            "truck",
            "shipping container"
        ],
        "type": "AWSService",
        "regions": [
            "us-gov-west-1"
        ],
        "linkUrl": "https://aws.amazon.com/snowmobile/",
        "isActive": "true",
        "hasDataTransfer": false,
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/awsSnowmobile/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": true,
        "serviceDefinitionUrlPath": "/data/awsSnowmobile/en_US.json",
        "slug": "Snowmobile",
        "mvpSupport": false,
        "comparableTerms": [
            "snowmobile"
        ]
    },
    "awsStepFunctions": {
        "name": "AWS Step Functions",
        "serviceCode": "awsStepFunctions",
        "description": "AWS Step Functions is a serverless function orchestrator that makes it easy to sequence AWS Lambda functions and multiple AWS services into business-critical applications.",
        "searchKeywords": [
            "workflows",
            " workflow",
            " orchestrator",
            " orchestration",
            " serverless",
            " state machine",
            " State Machines",
            " States",
            " State",
            " Microservices",
            " application integration",
            " Amazon States Language",
            " ASL",
            " Data Science SDK",
            " data processing",
            " API orchestration",
            " DAG",
            " DAGs",
            " Step Functions",
            " Step Function",
            " Step",
            " media processing",
            " application orchestration",
            " serverless orchestration",
            " serverless workflow",
            " lambda orchestration",
            " serverless state machine",
            " asynchronous",
            " synchronous",
            " event-driven data processing",
            " event-driven",
            " event orchestration",
            " standard workflows",
            " standard workflow",
            " express workflow",
            " express workflows",
            " standard workflows",
            " error handling",
            " service integrations",
            " state management",
            " visual workflow",
            " visual monitoring",
            " high volume orchestration",
            " function",
            " functions",
            " machine learning workflow",
            " machine learning workflows",
            " JSON",
            " serverless workflows",
            " serverless workflow",
            " Business logic",
            " complex workflows",
            " data pipeline",
            " data processing",
            " decoupling",
            " decouple applications",
            " abstraction",
            " abstraction layer",
            " automation",
            " It automation",
            " connecting aws services",
            " integration of aws services",
            " coordinating AWS services",
            " managed workflows",
            " call back patterns",
            " callback pattern",
            " callback patterns",
            " call back pattern",
            " human approval",
            " manual approval",
            " human intervention",
            " EKS orchestration",
            " container orchestration",
            " short duration workflows",
            " long duration workflows",
            " short-duration workflows",
            " short-duration workflow",
            " long-running workflow",
            " long-running workflows",
            " machine-learning workflows",
            " ML workflows",
            " ML workflow",
            " API orchestration",
            " function",
            " functions",
            " compute function",
            " compute functions",
            " Lambda retry",
            " Lambda retries",
            " serverless compute",
            " parallel processing",
            " Lambda chaining",
            " error-handling",
            " retries",
            " saga pattern",
            " nested",
            " branching",
            " nesting",
            " nested pattern",
            " branching pattern",
            " nesting pattern",
            " serverless patterns",
            " event-driven patterns",
            " coordinating workflows"
        ],
        "type": "AWSService",
        "regions": [],
        "linkUrl": "https://aws.amazon.com/step-functions/",
        "isActive": "true",
        "subType": "subServiceSelector",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/awsStepFunctions/en_US.json",
        "c2e": false,
        "templates": [
            "stepFunctionStandard",
            "stepFunctionExpress"
        ],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/awsStepFunctions/en_US.json",
        "slug": "StepFunctions",
        "mvpSupport": false,
        "comparableTerms": [
            "stepfunctions"
        ]
    },
    "aWSStorageGateway": {
        "name": "AWS Storage Gateway",
        "serviceCode": "aWSStorageGateway",
        "description": "AWS Storage Gateway is a hybrid storage service that enables your on-premises applications to seamlessly use AWS cloud storage. You can use the service for backup and archiving, disaster recovery, cloud data processing, storage tiering, and migration.",
        "searchKeywords": [
            "Storage",
            "on premises",
            "cloud migration",
            "integrated storage",
            "store data in the cloud",
            "secure storage",
            "storage integration",
            "hybrid storage",
            "on prem storage",
            "gateway cached volumes",
            "gateway stored volumes",
            "gateway virtual tape library",
            "VTL",
            "backup",
            "disaster recovery",
            "disaster resilience",
            "corporate file sharing",
            "data mirroring",
            "cloud storage"
        ],
        "type": "AWSService",
        "regions": [
            ""
        ],
        "linkUrl": "https://aws.amazon.com/storagegateway/",
        "isActive": "true",
        "hasDataTransfer": true,
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/aWSStorageGateway/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "bulkImportEnabled": false,
        "serviceDefinitionUrlPath": "/data/aWSStorageGateway/en_US.json",
        "slug": "StorageGateway",
        "mvpSupport": false,
        "comparableTerms": [
            "storagegateway"
        ]
    },
    "awsSystemsManager": {
        "name": "AWS Systems Manager",
        "serviceCode": "awsSystemsManager",
        "description": "AWS Systems Manager gives you visibility and control of your infrastructure on AWS. Systems Manager provides a unified user interface so you can view operational data from multiple AWS services and allows you to automate operational tasks across your AWS resources.",
        "searchKeywords": [
            "Manager",
            "Systems",
            "control",
            "infrastructure",
            "operational data",
            "visibility",
            "resource management",
            "application management",
            "unified user interface",
            "OpsCenter",
            "Automation",
            "On-premesis instance management",
            "Distributor",
            "Parameter Store",
            "AWS AppConfig"
        ],
        "type": "AWSService",
        "regions": [],
        "linkUrl": "https://aws.amazon.com/systems-manager/",
        "isActive": "true",
        "subType": "subServiceSelector",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/awsSystemsManager/en_US.json",
        "c2e": false,
        "templates": [
            "awsSystemsManagerOpsCenter",
            "awsAppConfig",
            "awsSystemsManagerParameterStore",
            "awsSystemsManagerOnPremisesInstanceManagement",
            "awsSystemsManagerDistributor",
            "awsSystemsManagerAutomation",
            "awsSystemsManagerIncidentManager"
        ],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/awsSystemsManager/en_US.json",
        "slug": "SystemsManager",
        "mvpSupport": false,
        "comparableTerms": [
            "systemsmanager"
        ]
    },
    "aWSTransferForSFTP": {
        "name": "AWS Transfer Family",
        "serviceCode": "aWSTransferForSFTP",
        "description": "AWS Transfer Family is a fully managed SFTP, FTPS, and FTP service.",
        "searchKeywords": [
            "sftp",
            "amazon s3",
            "s3",
            "winscp",
            "filezilla",
            "cyberduck",
            "ssh",
            "transfer",
            "ftp",
            "ftp/s",
            "openssh",
            "file transfer",
            "secure file transfer",
            "ssh ftp",
            "secure shell file transfer protocol",
            "as2",
            "file transfer protocol"
        ],
        "type": "AWSService",
        "regions": [
            "ap-east-1",
            "ap-northeast-1",
            "ap-northeast-2",
            "ap-south-1",
            "ap-southeast-1",
            "ap-southeast-2",
            "ca-central-1",
            "eu-central-1",
            "eu-north-1",
            "eu-west-1",
            "eu-west-2",
            "eu-west-3",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2",
            "us-gov-west-1",
            "us-gov-east-1"
        ],
        "linkUrl": "https://aws.amazon.com/aws-transfer-family/",
        "isActive": "true",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/aWSTransferForSFTP/en_US.json",
        "c2e": false,
        "slug": "TransferFamily",
        "mvpSupport": false,
        "comparableTerms": [
            "transferfamily",
            "transferforsftp"
        ]
    },
    "awsWebApplicationFirewall": {
        "name": "AWS Web Application Firewall (WAF)",
        "serviceCode": "awsWebApplicationFirewall",
        "description": "AWS WAF is a web application firewall that helps protect your web applications or APIs against common web exploits that may affect availability, compromise security, or consume excessive resources.",
        "searchKeywords": [
            "Security Identity Compliance",
            "appsec",
            "application security",
            "web security",
            "blacklisting",
            "whitelisting",
            "Security as a service (SAAS)",
            "perimeter security",
            "perimeter protection",
            "bot detection",
            "DDoS",
            "firewall",
            "IP blocking",
            "OWASP",
            "IP reputation",
            "HTTP flood",
            "AWS Firewall Manager",
            "Cross Account WAF",
            "Cross Account Firewall",
            "Firewall Compliance",
            "Firewall Manager"
        ],
        "type": "AWSService",
        "regions": [
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2",
            "af-south-1",
            "ap-east-1",
            "ap-south-1",
            "ap-northeast-2",
            "ap-northeast-3",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-northeast-1",
            "us-gov-east-1",
            "us-gov-west-1",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "eu-south-1",
            "eu-west-3",
            "eu-north-1",
            "me-south-1",
            "sa-east-1"
        ],
        "linkUrl": "https://aws.amazon.com/waf/",
        "isActive": "true",
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/awsWebApplicationFirewall/en_US.json",
        "c2e": false,
        "slug": "WAF",
        "mvpSupport": false,
        "comparableTerms": [
            "waf",
            "webapplicationfirewall",
            "webapplicationfirewallwaf"
        ]
    },
    "awsXRay": {
        "name": "AWS X-Ray",
        "serviceCode": "awsXRay",
        "description": "AWS X-Ray makes it easy for developers to analyze the behavior of their production, distributed applications with end-to-end tracing capabilities. You can use X-Ray to identify performance bottlenecks, edge case errors, and other hard to detect issues.",
        "searchKeywords": [
            "X-Ray",
            "xray",
            "monitor"
        ],
        "type": "AWSService",
        "regions": [
            "af-south-1",
            "ap-east-1",
            "ap-northeast-1",
            "ap-northeast-2",
            "ap-northeast-3",
            "ap-south-1",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-southeast-3",
            "ca-central-1",
            "eu-central-1",
            "eu-north-1",
            "eu-south-1",
            "eu-west-1",
            "eu-west-2",
            "eu-west-3",
            "me-south-1",
            "me-central-1",
            "sa-east-1",
            "us-east-2",
            "us-gov-west-1",
            "us-gov-east-1",
            "us-west-1",
            "us-west-2",
            "us-east-1"
        ],
        "linkUrl": "https://aws.amazon.com/xray/",
        "isActive": "true",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/awsXRay/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "slug": "xray",
        "mvpSupport": false,
        "comparableTerms": [
            "xray"
        ]
    },
    "chimeSdk": {
        "name": "Chime SDK",
        "serviceCode": "chimeSdk",
        "description": "Amazon Chime lets you meet, chat, and collaborate with the security of AWS. You can work seamlessly on your devices, and meet from your desk or on the go - ensuring you always stay connected.",
        "searchKeywords": [],
        "type": "AWSService",
        "regions": [
            "us-east-1"
        ],
        "linkUrl": "https://aws.amazon.com/chime/",
        "isActive": "true",
        "subType": "subService",
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/chimeSdk/en_US.json",
        "c2e": false,
        "comparableTerms": [
            "chimesdk"
        ]
    },
    "chimeVoiceConnectorAnalysis": {
        "name": "Chime Voice Connector analysis",
        "serviceCode": "chimeVoiceConnectorAnalysis",
        "description": "Amazon Chime lets you meet, chat, and collaborate with the security of AWS. You can work seamlessly on your devices, and meet from your desk or on the go - ensuring you always stay connected.",
        "searchKeywords": [],
        "type": "AWSService",
        "regions": [
            "us-east-1"
        ],
        "linkUrl": "https://aws.amazon.com/chime/",
        "isActive": "true",
        "subType": "subService",
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/chimeVoiceConnectorAnalysis/en_US.json",
        "c2e": false,
        "mvpSupport": false,
        "comparableTerms": [
            "chimevoiceconnectoranalysis"
        ]
    },
    "classicLoadBalancer": {
        "name": "Classic Load Balancer",
        "serviceCode": "classicLoadBalancer",
        "description": "Elastic Load Balancing automatically distributes incoming application traffic across multiple targets, such as Amazon EC2 instances, containers, IP addresses, and Lambda functions.",
        "searchKeywords": [
            "ELB",
            "Elastic Load Balancer",
            "Load Balancer",
            "Application Load Balancer",
            "Network Load Balancer",
            "Classic Load Balancer"
        ],
        "type": "AWSService",
        "regions": [
            "af-south-1",
            "ap-east-1",
            "ap-northeast-1",
            "ap-northeast-2",
            "ap-northeast-3",
            "ap-south-1",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-southeast-3",
            "ca-central-1",
            "eu-central-1",
            "eu-north-1",
            "eu-south-1",
            "eu-west-1",
            "eu-west-2",
            "eu-west-3",
            "me-south-1",
            "me-central-1",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-gov-east-1",
            "us-gov-west-1",
            "us-west-1",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/elasticloadbalancing/",
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/classicLoadBalancer/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/classicLoadBalancer/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "classicloadbalancer"
        ],
        "parentServiceCode": "elasticLoadBalancing"
    },
    "cloudWan": {
        "name": "Cloud WAN",
        "serviceCode": "cloudWan",
        "description": "AWS Cloud WAN provides a central dashboard for making connections between your branch offices, data centers, and Amazon Virtual Private Clouds (VPCs) – building a global network with only a few clicks. You use network policies to automate network management and security tasks in one location. Cloud WAN generates a complete view of your on-premises and AWS networks to help you monitor network health, security, and performance.",
        "searchKeywords": [
            "Cloud WAN",
            "cloud",
            "cloudwan"
        ],
        "type": "AWSService",
        "regions": [
            "us-east-1"
        ],
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/cloudWan/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/cloudWan/en_US.json",
        "slug": "cloudwan",
        "mvpSupport": false,
        "comparableTerms": [
            "cloudwan"
        ],
        "parentServiceCode": "amazonVirtualPrivateCloud"
    },
    "comprehendCustomClassification": {
        "name": "Comprehend Custom Classification",
        "serviceCode": "comprehendCustomClassification",
        "description": "With Amazon Comprehend, you only pay for what you use. You are charged based on the amount of text processed on a monthly basis. Amazon Comprehend provides natural language processing, topic modeling, and Custom Classification capabilities, enabling a broad range of applications that can analyze text.",
        "searchKeywords": [
            "Comprehend",
            "NLP",
            "Natural language processing",
            "Sentiment analysis",
            "Text analytics",
            "Entity extraction",
            "Named entity recognition",
            "NER",
            "Key phrase extraction",
            "Topic modeling",
            "Unsupervised clustering",
            "Supervised machine learning",
            "Custom entity recognition",
            "Custom classification",
            "Document classifier",
            "Personally identifiable information",
            "PII",
            "Redaction",
            "Language detection",
            "Free form text analytics"
        ],
        "type": "AWSService",
        "regions": [
            "us-gov-west-1",
            "ap-south-1",
            "ap-northeast-2",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-northeast-1",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "us-east-1",
            "us-east-2",
            "us-west-2"
        ],
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/comprehendCustomClassification/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/comprehendCustomClassification/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "comprehendcustomclassification"
        ],
        "parentServiceCode": "amazonComprehend"
    },
    "comprehendCustomEntities": {
        "name": "Comprehend Custom Entities",
        "serviceCode": "comprehendCustomEntities",
        "description": "With Amazon Comprehend, you only pay for what you use. You are charged based on the amount of text processed on a monthly basis. Amazon Comprehend provides natural language processing, topic modeling, and Custom Classification capabilities, enabling a broad range of applications that can analyze text.",
        "searchKeywords": [],
        "type": "AWSService",
        "regions": [
            "us-gov-west-1",
            "ap-south-1",
            "ap-northeast-2",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-northeast-1",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "us-east-1",
            "us-east-2",
            "us-west-2"
        ],
        "isActive": "true",
        "subType": "subService",
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/comprehendCustomEntities/en_US.json",
        "c2e": false,
        "mvpSupport": false,
        "comparableTerms": [
            "comprehendcustomentities"
        ],
        "parentServiceCode": "amazonComprehend"
    },
    "containsPii": {
        "name": "Contains PII",
        "serviceCode": "containsPii",
        "description": "With Amazon Comprehend, you only pay for what you use. You are charged based on the amount of text processed on a monthly basis. Amazon Comprehend provides natural language processing, topic modeling, and Custom Classification capabilities, enabling a broad range of applications that can analyze text.",
        "searchKeywords": [
            "Comprehend",
            "NLP",
            "Natural language processing",
            "Sentiment analysis",
            "Text analytics",
            "Entity extraction",
            "Named entity recognition",
            "NER",
            "Key phrase extraction",
            "Topic modeling",
            "Unsupervised clustering",
            "Supervised machine learning",
            "Custom entity recognition",
            "Custom classification",
            "Document classifier",
            "Personally identifiable information",
            "PII",
            "Contains PII",
            "Redaction",
            "Language detection",
            "Free form text analytics"
        ],
        "type": "AWSService",
        "regions": [
            "us-gov-west-1",
            "ap-south-1",
            "ap-northeast-2",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-northeast-1",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "us-east-1",
            "us-east-2",
            "us-west-2"
        ],
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/containsPii/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/containsPii/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "containspii"
        ],
        "parentServiceCode": "amazonComprehend"
    },
    "awsS3DataTransfer": {
        "name": "Data Transfer",
        "serviceCode": "awsS3DataTransfer",
        "description": "The cost of transferring data at AWS for services without unique transfer costs.",
        "searchKeywords": [],
        "type": "AWSService",
        "regions": [
            "af-south-1",
            "ap-east-1",
            "ap-northeast-1",
            "ap-northeast-2",
            "ap-northeast-3",
            "ap-south-1",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-southeast-3",
            "ca-central-1",
            "me-south-1",
            "me-central-1",
            "eu-central-1",
            "eu-north-1",
            "eu-south-1",
            "eu-west-1",
            "eu-west-2",
            "eu-west-3",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-gov-east-1",
            "us-gov-west-1",
            "us-west-1",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/ec2/pricing/on-demand/#Data_Transfer",
        "isActive": "true",
        "hasDataTransfer": true,
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/awsS3DataTransfer/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "mvpSupport": false,
        "comparableTerms": [
            "datatransfer",
            "s3datatransfer"
        ],
        "parentServiceCode": "amazonSimpleStorageServiceGroup"
    },
    "dataTransferVpc": {
        "name": "Data Transfer",
        "serviceCode": "dataTransferVpc",
        "description": "WS Virtual Private Network solutions establish secure connections between your on-premises networks, remote offices, client devices, and the AWS global network. AWS VPN is comprised of two services: AWS Site-to-Site VPN and AWS Client VPN. Each service provides a highly-available, managed, and elastic cloud VPN solution to protect your network traffic.",
        "searchKeywords": [
            "access control",
            "ACL",
            "AWS Privatelink",
            "Cloud connectivity",
            "corporate network",
            "elastic IP",
            "Gateway load balancer",
            "home network VPN",
            "IPAM",
            "NAT",
            "NAT gateway",
            "Network Access Analyzer",
            "Network Address Translation",
            "Networking Content Delivery",
            "PrivateLink",
            "Reachability Analyzer",
            "security",
            "single tenant hardware",
            "static ip",
            "subnets",
            "Traffic mirroring",
            "Transit Gateway",
            "Virtual Private Cloud",
            "VPN"
        ],
        "type": "AWSService",
        "regions": [
            "af-south-1",
            "ap-east-1",
            "ap-southeast-3",
            "ap-south-1",
            "ap-northeast-3",
            "ap-northeast-2",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-northeast-1",
            "us-gov-east-1",
            "us-gov-west-1",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "eu-south-1",
            "eu-west-3",
            "eu-north-1",
            "me-south-1",
            "me-central-1",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2"
        ],
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/dataTransferVpc/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/dataTransferVpc/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "datatransfer",
            "datatransfervpc"
        ],
        "parentServiceCode": "amazonVirtualPrivateCloud"
    },
    "piiDetection": {
        "name": "Detect PII",
        "serviceCode": "piiDetection",
        "description": "With Amazon Comprehend, you only pay for what you use. You are charged based on the amount of text processed on a monthly basis. Amazon Comprehend provides natural language processing, topic modeling, and Custom Classification capabilities, enabling a broad range of applications that can analyze text.",
        "searchKeywords": [
            "Comprehend",
            "NLP",
            "Natural language processing",
            "Sentiment analysis",
            "Text analytics",
            "Entity extraction",
            "Named entity recognition",
            "NER",
            "Key phrase extraction",
            "Topic modeling",
            "Unsupervised clustering",
            "Supervised machine learning",
            "Custom entity recognition",
            "Custom classification",
            "Document classifier",
            "Personally identifiable information",
            "PII",
            "Redaction",
            "Language detection",
            "Free form text analytics"
        ],
        "type": "AWSService",
        "regions": [
            "us-gov-west-1",
            "ap-south-1",
            "ap-northeast-2",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-northeast-1",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "us-east-1",
            "us-east-2",
            "us-west-2"
        ],
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/piiDetection/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/piiDetection/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "detectpii",
            "piidetection"
        ],
        "parentServiceCode": "amazonComprehend"
    },
    "awsSystemsManagerDistributor": {
        "name": "Distributor",
        "serviceCode": "awsSystemsManagerDistributor",
        "description": "AWS Systems Manager Distributor feature",
        "searchKeywords": [
            "System Manager",
            "Distributor",
            "distriubte and maintain software packages"
        ],
        "type": "AWSService",
        "regions": [
            "us-gov-west-1",
            "us-gov-east-1",
            "af-south-1",
            "ap-east-1",
            "ap-south-1",
            "ap-northeast-3",
            "ap-northeast-2",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-southeast-3",
            "ap-northeast-1",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "eu-south-1",
            "eu-west-3",
            "eu-north-1",
            "me-south-1",
            "me-central-1",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/systems-manager/",
        "isActive": "true",
        "hasDataTransfer": false,
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/awsSystemsManagerDistributor/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/awsSystemsManagerDistributor/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "distributor",
            "systemsmanagerdistributor"
        ],
        "parentServiceCode": "awsSystemsManager"
    },
    "amazonDynamoDbDaxClusters": {
        "name": "DynamoDB Accelerator (DAX) clusters",
        "serviceCode": "amazonDynamoDbDaxClusters",
        "description": "Amazon DynamoDB is a key-value and document database that delivers single-digit millisecond performance at any scale. It's a fully managed, multiregion, multimaster, durable database with built-in security, backup and restore, and in-memory caching for internet-scale applications.",
        "searchKeywords": [
            "Database",
            "DDB",
            "NoSQL",
            "SQL",
            "Table",
            "nosql databases",
            "database schema",
            "database software",
            "cloud database",
            "document database",
            "key value store",
            "database as a service",
            "database scheme",
            "nosql hosting",
            "hosted nosql",
            "data store",
            "unstructured database",
            "Accelerator",
            "DAX"
        ],
        "type": "AWSService",
        "regions": [
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2",
            "ap-south-1",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-northeast-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "eu-west-3",
            "sa-east-1"
        ],
        "linkUrl": "https://aws.amazon.com/dynamodb/",
        "isActive": "true",
        "hasDataTransfer": true,
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonDynamoDbDaxClusters/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/amazonDynamoDbDaxClusters/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "dax",
            "dynamodbacceleratordaxclusters",
            "dynamodbdaxclusters"
        ],
        "parentServiceCode": "amazonDynamoDb"
    },
    "dynamoDbBackup": {
        "name": "DynamoDB Backup and restore",
        "serviceCode": "dynamoDbBackup",
        "description": "Amazon DynamoDB is a key-value and document database that delivers single-digit millisecond performance at any scale. It's a fully managed, multiregion, multimaster, durable database with built-in security, backup and restore, and in-memory caching for internet-scale applications.",
        "searchKeywords": [
            "Database",
            "DDB",
            "NoSQL",
            "SQL",
            "Table",
            "nosql databases",
            "database schema",
            "database software",
            "cloud database",
            "document database",
            "key value store",
            "database as a service",
            "database scheme",
            "nosql hosting",
            "hosted nosql",
            "data store",
            "unstructured database",
            "Accelerator",
            "DAX"
        ],
        "type": "AWSService",
        "regions": [
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2",
            "af-south-1",
            "ap-east-1",
            "ap-south-1",
            "ap-northeast-2",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-northeast-1",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "eu-south-1",
            "eu-west-3",
            "eu-north-1",
            "me-south-1",
            "me-central-1",
            "sa-east-1",
            "us-gov-east-1",
            "us-gov-west-1"
        ],
        "linkUrl": "https://aws.amazon.com/dynamodb/",
        "isActive": "true",
        "hasDataTransfer": true,
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/dynamoDbBackup/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/dynamoDbBackup/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "dynamodbbackup",
            "dynamodbbackuprestore"
        ],
        "parentServiceCode": "amazonDynamoDb"
    },
    "dynamoDbChangeDateCapture": {
        "name": "DynamoDB change data capture",
        "serviceCode": "dynamoDbChangeDateCapture",
        "description": "Amazon DynamoDB is a key-value and document database that delivers single-digit millisecond performance at any scale. It's a fully managed, multiregion, multimaster, durable database with built-in security, backup and restore, and in-memory caching for internet-scale applications.",
        "searchKeywords": [
            "Database",
            "DDB",
            "NoSQL",
            "SQL",
            "Table",
            "nosql databases",
            "database schema",
            "database software",
            "cloud database",
            "document database",
            "key value store",
            "database as a service",
            "database scheme",
            "nosql hosting",
            "hosted nosql",
            "data store",
            "unstructured database",
            "Accelerator",
            "DAX",
            "change data capture",
            "Kinesis"
        ],
        "type": "AWSService",
        "regions": [
            "ap-northeast-1",
            "ap-northeast-2",
            "ap-south-1",
            "ap-southeast-1",
            "ap-southeast-2",
            "ca-central-1",
            "eu-central-1",
            "eu-north-1",
            "eu-south-1",
            "eu-west-1",
            "eu-west-2",
            "eu-west-3",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/dynamodb/",
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/dynamoDbChangeDateCapture/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/dynamoDbChangeDateCapture/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "dynamodbchangedatacapture",
            "dynamodbchangedatecapture"
        ],
        "parentServiceCode": "amazonDynamoDb"
    },
    "dynamoDbDataExportToAmazonS3": {
        "name": "DynamoDB Data export to Amazon S3",
        "serviceCode": "dynamoDbDataExportToAmazonS3",
        "description": "Amazon DynamoDB is a key-value and document database that delivers single-digit millisecond performance at any scale. It's a fully managed, multiregion, multimaster, durable database with built-in security, backup and restore, and in-memory caching for internet-scale applications.",
        "searchKeywords": [
            "Database",
            "DDB",
            "NoSQL",
            "SQL",
            "Table",
            "nosql databases",
            "database schema",
            "database software",
            "cloud database",
            "document database",
            "key value store",
            "database as a service",
            "database scheme",
            "nosql hosting",
            "hosted nosql",
            "data store",
            "unstructured database",
            "Accelerator",
            "DAX"
        ],
        "type": "AWSService",
        "regions": [
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2",
            "af-south-1",
            "ap-east-1",
            "ap-south-1",
            "ap-northeast-3",
            "ap-northeast-2",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-northeast-1",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "eu-south-1",
            "eu-west-3",
            "eu-north-1",
            "me-south-1",
            "me-central-1",
            "sa-east-1",
            "us-gov-east-1",
            "us-gov-west-1"
        ],
        "linkUrl": "https://aws.amazon.com/dynamodb/",
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/dynamoDbDataExportToAmazonS3/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/dynamoDbDataExportToAmazonS3/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "dynamodbdataexporttoamazons3",
            "dynamodbdataexporttos3"
        ],
        "parentServiceCode": "amazonDynamoDb"
    },
    "dynamoDbDataImportFromAmazonS3": {
        "name": "DynamoDB Data Import from Amazon S3",
        "serviceCode": "dynamoDbDataImportFromAmazonS3",
        "description": "Amazon DynamoDB is a key-value and document database that delivers single-digit millisecond performance at any scale. It's a fully managed, multiregion, multimaster, durable database with built-in security, backup and restore, and in-memory caching for internet-scale applications.",
        "searchKeywords": [
            "Database",
            "DDB",
            "NoSQL",
            "SQL",
            "Table",
            "nosql databases",
            "database schema",
            "database software",
            "cloud database",
            "document database",
            "key value store",
            "database as a service",
            "database scheme",
            "nosql hosting",
            "hosted nosql",
            "data store",
            "unstructured database",
            "Accelerator",
            "DAX"
        ],
        "type": "AWSService",
        "regions": [
            "af-south-1",
            "ap-east-1",
            "ap-northeast-1",
            "ap-northeast-2",
            "ap-northeast-3",
            "ap-south-1",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-southeast-3",
            "ca-central-1",
            "eu-central-1",
            "eu-north-1",
            "eu-south-1",
            "eu-west-1",
            "eu-west-2",
            "eu-west-3",
            "me-south-1",
            "me-central-1",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-gov-east-1",
            "us-gov-west-1",
            "us-west-1",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/dynamodb/",
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/dynamoDbDataImportFromAmazonS3/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/dynamoDbDataImportFromAmazonS3/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "dynamodbdataimportfromamazons3",
            "dynamodbdataimportfroms3"
        ],
        "parentServiceCode": "amazonDynamoDb"
    },
    "dynamoDbOnDemand": {
        "name": "DynamoDB on-demand capacity",
        "serviceCode": "dynamoDbOnDemand",
        "description": "Amazon DynamoDB is a key-value and document database that delivers single-digit millisecond performance at any scale. It's a fully managed, multiregion, multimaster, durable database with built-in security, backup and restore, and in-memory caching for internet-scale applications.",
        "searchKeywords": [
            "Database",
            "DDB",
            "NoSQL",
            "SQL",
            "Table",
            "nosql databases",
            "database schema",
            "database software",
            "cloud database",
            "document database",
            "key value store",
            "database as a service",
            "database scheme",
            "nosql hosting",
            "hosted nosql",
            "data store",
            "unstructured database",
            "Accelerator",
            "DAX"
        ],
        "type": "AWSService",
        "regions": [
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2",
            "af-south-1",
            "ap-east-1",
            "ap-south-1",
            "ap-northeast-3",
            "ap-northeast-2",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-southeast-3",
            "ap-northeast-1",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "eu-south-1",
            "eu-west-3",
            "eu-north-1",
            "me-south-1",
            "me-central-1",
            "sa-east-1",
            "us-gov-east-1",
            "us-gov-west-1"
        ],
        "linkUrl": "https://aws.amazon.com/dynamodb/",
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/dynamoDbOnDemand/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/dynamoDbOnDemand/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "dynamodbdemandcapacity",
            "dynamodbondemand"
        ],
        "parentServiceCode": "amazonDynamoDb"
    },
    "amazonDynamoDbProvisionedThroughputCapacity": {
        "name": "DynamoDB provisioned capacity",
        "serviceCode": "amazonDynamoDbProvisionedThroughputCapacity",
        "description": "Amazon DynamoDB is a key-value and document database that delivers single-digit millisecond performance at any scale. It's a fully managed, multiregion, multimaster, durable database with built-in security, backup and restore, and in-memory caching for internet-scale applications.",
        "searchKeywords": [
            "Provisioned",
            "Throughput",
            "Database",
            "DynamoDB",
            "DDB",
            "NoSQL",
            "SQL",
            "Table",
            "nosql databases",
            "database schema",
            "database software",
            "cloud database",
            "document database",
            "key value store",
            "database as a service",
            "database scheme",
            "nosql hosting",
            "hosted nosql",
            "data store",
            "unstructured database",
            "Accelerator",
            "DAX"
        ],
        "type": "AWSService",
        "regions": [
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2",
            "af-south-1",
            "ap-east-1",
            "ap-south-1",
            "ap-northeast-3",
            "ap-northeast-2",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-southeast-3",
            "ap-northeast-1",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "eu-south-1",
            "eu-west-3",
            "eu-north-1",
            "me-south-1",
            "me-central-1",
            "sa-east-1",
            "us-gov-east-1",
            "us-gov-west-1"
        ],
        "linkUrl": "https://aws.amazon.com/dynamodb",
        "isActive": "true",
        "hasDataTransfer": true,
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonDynamoDbProvisionedThroughputCapacity/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/amazonDynamoDbProvisionedThroughputCapacity/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "dynamodbprovisionedcapacity",
            "dynamodbprovisionedthroughputcapacity"
        ],
        "parentServiceCode": "amazonDynamoDb"
    },
    "amazonDynamoDbStreams": {
        "name": "DynamoDB Streams",
        "serviceCode": "amazonDynamoDbStreams",
        "description": "Amazon DynamoDB is a key-value and document database that delivers single-digit millisecond performance at any scale. It's a fully managed, multiregion, multimaster, durable database with built-in security, backup and restore, and in-memory caching for internet-scale applications.",
        "searchKeywords": [
            "Database",
            "DDB",
            "NoSQL",
            "SQL",
            "Table",
            "nosql databases",
            "database schema",
            "database software",
            "cloud database",
            "document database",
            "key value store",
            "database as a service",
            "database scheme",
            "nosql hosting",
            "hosted nosql",
            "data store",
            "unstructured database",
            "Accelerator",
            "DAX"
        ],
        "type": "AWSService",
        "regions": [
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2",
            "af-south-1",
            "ap-east-1",
            "ap-south-1",
            "ap-northeast-3",
            "ap-northeast-2",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-northeast-1",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "eu-south-1",
            "eu-west-3",
            "eu-north-1",
            "me-south-1",
            "me-central-1",
            "sa-east-1",
            "us-gov-east-1",
            "us-gov-west-1"
        ],
        "linkUrl": "https://aws.amazon.com/dynamodb/",
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonDynamoDbStreams/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/amazonDynamoDbStreams/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "dynamodbstreams"
        ],
        "parentServiceCode": "amazonDynamoDb"
    },
    "elasticLoadBalancing": {
        "name": "Elastic Load Balancing",
        "serviceCode": "elasticLoadBalancing",
        "description": "Elastic Load Balancing automatically distributes incoming application traffic across multiple targets, such as Amazon EC2 instances, containers, IP addresses, and Lambda functions.",
        "searchKeywords": [
            "ELB",
            "Elastic Load Balancer",
            "Load Balancer",
            "Application Load Balancer",
            "Network Load Balancer",
            "Gateway Load Balancer",
            "Classic Load Balancer"
        ],
        "type": "AWSService",
        "regions": [],
        "linkUrl": "https://aws.amazon.com/elasticloadbalancing",
        "isActive": "true",
        "subType": "subServiceSelector",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/elasticLoadBalancing/en_US.json",
        "c2e": false,
        "templates": [
            "applicationLoadBalancer",
            "networkLoadBalancer",
            "gatewayLoadBalancer",
            "classicLoadBalancer"
        ],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/elasticLoadBalancing/en_US.json",
        "slug": "ElasticLoadBalancing",
        "mvpSupport": false,
        "comparableTerms": [
            "elasticloadbalancing"
        ]
    },
    "entityRecognition": {
        "name": "Entity Recognition",
        "serviceCode": "entityRecognition",
        "description": "With Amazon Comprehend, you only pay for what you use. You are charged based on the amount of text processed on a monthly basis. Amazon Comprehend provides natural language processing, topic modeling, and Custom Classification capabilities, enabling a broad range of applications that can analyze text.",
        "searchKeywords": [
            "Comprehend",
            "NLP",
            "Natural language processing",
            "Sentiment analysis",
            "Text analytics",
            "Entity extraction",
            "Named entity recognition",
            "NER",
            "Key phrase extraction",
            "Topic modeling",
            "Unsupervised clustering",
            "Supervised machine learning",
            "Custom entity recognition",
            "Custom classification",
            "Document classifier",
            "Personally identifiable information",
            "PII",
            "Redaction",
            "Language detection",
            "Free form text analytics"
        ],
        "type": "AWSService",
        "regions": [
            "us-gov-west-1",
            "ap-south-1",
            "ap-northeast-2",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-northeast-1",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "us-east-1",
            "us-east-2",
            "us-west-2"
        ],
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/entityRecognition/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/entityRecognition/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "entityrecognition"
        ],
        "parentServiceCode": "amazonComprehend"
    },
    "eventDetectionPerEventType": {
        "name": "Event Detection",
        "serviceCode": "eventDetectionPerEventType",
        "description": "Comprehend Events identifies real-world events such as acquisitions, IPOs and bankruptcies from text documents and extracts all the related details around the event such as investor, invested, deal amount and more. You can apply natural language processing with asynchronous jobs for event detection across large collections of documents.",
        "searchKeywords": [
            "Comprehend",
            "NLP",
            "Natural language processing",
            "Sentiment analysis",
            "Text analytics",
            "Entity extraction",
            "Named entity recognition",
            "NER",
            "Key phrase extraction",
            "Topic modeling",
            "Unsupervised clustering",
            "Supervised machine learning",
            "Custom entity recognition",
            "Custom classification",
            "Document classifier",
            "Personally identifiable information",
            "PII",
            "Redaction",
            "Language detection",
            "Free form text analytics",
            "Event",
            "Event Analysis"
        ],
        "type": "AWSService",
        "regions": [
            "us-gov-west-1",
            "ap-south-1",
            "ap-northeast-2",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-northeast-1",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "us-east-1",
            "us-east-2",
            "us-west-2"
        ],
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/eventDetectionPerEventType/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/eventDetectionPerEventType/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "eventdetection",
            "eventdetectionpereventtype"
        ],
        "parentServiceCode": "amazonComprehend"
    },
    "fifoTopics": {
        "name": "FIFO Topics",
        "serviceCode": "fifoTopics",
        "description": "Amazon Simple Notification Service (SNS) is a highly available, durable, secure, fully managed pub/sub messaging service that enables you to decouple microservices, distributed systems, and serverless applications",
        "searchKeywords": [
            "Messaging",
            "SNS",
            "notification topic",
            "publish message",
            "subscription",
            "text message",
            "sms",
            "topics",
            "push notifications",
            "push notification service queuing",
            "FIFO topics"
        ],
        "type": "AWSService",
        "regions": [
            "af-south-1",
            "ap-east-1",
            "ap-northeast-1",
            "ap-northeast-2",
            "ap-northeast-3",
            "ap-south-1",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-southeast-3",
            "ca-central-1",
            "eu-central-1",
            "eu-north-1",
            "eu-south-1",
            "eu-west-1",
            "eu-west-2",
            "eu-west-3",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-gov-east-1",
            "us-gov-west-1",
            "us-west-1",
            "us-west-2",
            "me-south-1"
        ],
        "linkUrl": "https://aws.amazon.com/sns/pricing/",
        "isActive": "true",
        "subType": "subService",
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/fifoTopics/en_US.json",
        "c2e": false,
        "mvpSupport": false,
        "comparableTerms": [
            "fifotopics"
        ],
        "parentServiceCode": "amazonSimpleNotificationService"
    },
    "gatewayLoadBalancer": {
        "name": "Gateway Load Balancer",
        "serviceCode": "gatewayLoadBalancer",
        "description": "Elastic Load Balancing automatically distributes incoming application traffic across multiple targets, such as Amazon EC2 instances, containers, IP addresses, and Lambda functions.",
        "searchKeywords": [
            "ELB",
            "Elastic Load Balancer",
            "Load Balancer",
            "Application Load Balancer",
            "Network Load Balancer",
            "Classic Load Balancer",
            "Gateway Load Balancer"
        ],
        "type": "AWSService",
        "regions": [
            "af-south-1",
            "ap-east-1",
            "ap-northeast-1",
            "ap-northeast-2",
            "ap-northeast-3",
            "ap-south-1",
            "ap-southeast-1",
            "ap-southeast-2",
            "ca-central-1",
            "eu-central-1",
            "eu-north-1",
            "eu-south-1",
            "eu-west-1",
            "eu-west-2",
            "eu-west-3",
            "me-south-1",
            "me-central-1",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2",
            "us-gov-east-1",
            "us-gov-west-1"
        ],
        "linkUrl": "https://aws.amazon.com/elasticloadbalancing/",
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/gatewayLoadBalancer/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/gatewayLoadBalancer/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "gatewayloadbalancer"
        ],
        "parentServiceCode": "elasticLoadBalancing"
    },
    "gatewayLoadBalancerVpc": {
        "name": "Gateway Load Balancer",
        "serviceCode": "gatewayLoadBalancerVpc",
        "description": "Elastic Load Balancing automatically distributes incoming application traffic across multiple targets, such as Amazon EC2 instances, containers, IP addresses, and Lambda functions.",
        "searchKeywords": [
            "ELB",
            "Elastic Load Balancer",
            "Load Balancer",
            "Application Load Balancer",
            "Network Load Balancer",
            "Classic Load Balancer",
            "Gateway Load Balancer"
        ],
        "type": "AWSService",
        "regions": [
            "af-south-1",
            "ap-east-1",
            "ap-northeast-1",
            "ap-northeast-2",
            "ap-northeast-3",
            "ap-south-1",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-southeast-3",
            "ca-central-1",
            "eu-central-1",
            "eu-north-1",
            "eu-south-1",
            "eu-west-1",
            "eu-west-2",
            "eu-west-3",
            "me-south-1",
            "me-central-1",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2",
            "us-gov-east-1",
            "us-gov-west-1"
        ],
        "linkUrl": "https://aws.amazon.com/elasticloadbalancing/",
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/gatewayLoadBalancerVpc/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/gatewayLoadBalancerVpc/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "gatewayloadbalancer",
            "gatewayloadbalancervpc"
        ],
        "parentServiceCode": "amazonVirtualPrivateCloud"
    },
    "locationServiceGeofencing": {
        "name": "Geofencing",
        "serviceCode": "locationServiceGeofencing",
        "description": "Amazon Location Service provides affordable data, tracking and geofencing capabilities, and native integrations with AWS services, so you can create sophisticated location-enabled applications quickly, without the high cost of custom development.",
        "searchKeywords": [
            "Location Service",
            "compromising data security",
            "user privacy",
            "asset tracking",
            "location-based marketing",
            "maps",
            "places",
            "routing",
            "tracking",
            "geofencing",
            "Service Resources"
        ],
        "type": "AWSService",
        "regions": [
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-northeast-1",
            "eu-central-1",
            "eu-west-1",
            "eu-north-1",
            "us-east-1",
            "us-east-2",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/location/",
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/locationServiceGeofencing/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/locationServiceGeofencing/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "geofencing",
            "locationservicegeofencing"
        ],
        "parentServiceCode": "locationService"
    },
    "awsIoTCoreHttp": {
        "name": "HTTP",
        "serviceCode": "awsIoTCoreHttp",
        "description": "AWS IoT Core is a managed cloud service that lets connected devices easily and securely interact with cloud applications and other devices.",
        "searchKeywords": [
            "iot",
            "device",
            "messages",
            "shadow",
            "registry",
            "rules",
            "device shadow",
            "rules engine",
            "basic ingest",
            "mqtt",
            "LoRaWAN"
        ],
        "type": "AWSService",
        "regions": [
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2",
            "ap-east-1",
            "ap-south-1",
            "ap-northeast-2",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-northeast-1",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "eu-west-3",
            "eu-north-1",
            "me-south-1",
            "sa-east-1",
            "us-gov-east-1",
            "us-gov-west-1"
        ],
        "linkUrl": "https://aws.amazon.com/iot-core/",
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/awsIoTCoreHttp/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/awsIoTCoreHttp/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "http",
            "iotcorehttp"
        ],
        "parentServiceCode": "awsIoTCore"
    },
    "awsSystemsManagerIncidentManager": {
        "name": "Incident Manager",
        "serviceCode": "awsSystemsManagerIncidentManager",
        "description": "AWS AppConfig enables you to provide validation logic to ensure your configuration data is syntactically and semantically correct according to your definitions before making it available to your application. AWS AppConfig also gives you the ability to roll out configuration changes over a defined time period while monitoring your application so that you can catch errors and roll back the changes if needed, to help you minimize the impact to the users.",
        "searchKeywords": [
            "Systems Manager",
            "AppConfig",
            "configuration",
            "monitoring"
        ],
        "type": "AWSService",
        "regions": [
            "us-east-1",
            "us-east-2",
            "us-west-2",
            "ap-southeast-1",
            "ap-northeast-1",
            "ap-southeast-2",
            "eu-north-1",
            "eu-west-1",
            "eu-central-1",
            "me-central-1"
        ],
        "linkUrl": "https://aws.amazon.com/systems-manager/",
        "isActive": "true",
        "hasDataTransfer": false,
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/awsSystemsManagerIncidentManager/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/awsSystemsManagerIncidentManager/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "incidentmanager",
            "systemsmanagerincidentmanager"
        ],
        "parentServiceCode": "awsSystemsManager"
    },
    "ipamVpc": {
        "name": "IPAM",
        "serviceCode": "ipamVpc",
        "description": "WS Virtual Private Network solutions establish secure connections between your on-premises networks, remote offices, client devices, and the AWS global network. AWS VPN is comprised of two services: AWS Site-to-Site VPN and AWS Client VPN. Each service provides a highly-available, managed, and elastic cloud VPN solution to protect your network traffic.",
        "searchKeywords": [
            "access control",
            "ACL",
            "AWS Privatelink",
            "Cloud connectivity",
            "corporate network",
            "elastic IP",
            "Gateway load balancer",
            "home network VPN",
            "IPAM",
            "NAT",
            "NAT gateway",
            "Network Access Analyzer",
            "Network Address Translation",
            "Networking Content Delivery",
            "PrivateLink",
            "Reachability Analyzer",
            "security",
            "single tenant hardware",
            "static ip",
            "subnets",
            "Traffic mirroring",
            "Transit Gateway",
            "Virtual Private Cloud",
            "VPN"
        ],
        "type": "AWSService",
        "regions": [
            "af-south-1",
            "ap-east-1",
            "ap-northeast-1",
            "ap-northeast-2",
            "ap-northeast-3",
            "ap-south-1",
            "ap-southeast-1",
            "ap-southeast-2",
            "ca-central-1",
            "eu-central-1",
            "eu-north-1",
            "eu-south-1",
            "eu-west-1",
            "eu-west-2",
            "eu-west-3",
            "me-south-1",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2"
        ],
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/ipamVpc/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/ipamVpc/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "ipam",
            "ipamvpc"
        ],
        "parentServiceCode": "amazonVirtualPrivateCloud"
    },
    "keyPhraseExtraction": {
        "name": "Keyphrase Extraction",
        "serviceCode": "keyPhraseExtraction",
        "description": "With Amazon Comprehend, you only pay for what you use. You are charged based on the amount of text processed on a monthly basis. Amazon Comprehend provides natural language processing, topic modeling, and Custom Classification capabilities, enabling a broad range of applications that can analyze text.",
        "searchKeywords": [
            "Comprehend",
            "NLP",
            "Natural language processing",
            "Sentiment analysis",
            "Text analytics",
            "Entity extraction",
            "Named entity recognition",
            "NER",
            "Key phrase extraction",
            "Topic modeling",
            "Unsupervised clustering",
            "Supervised machine learning",
            "Custom entity recognition",
            "Custom classification",
            "Document classifier",
            "Personally identifiable information",
            "PII",
            "Redaction",
            "Language detection",
            "Free form text analytics"
        ],
        "type": "AWSService",
        "regions": [
            "us-gov-west-1",
            "ap-south-1",
            "ap-northeast-2",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-northeast-1",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "us-east-1",
            "us-east-2",
            "us-west-2"
        ],
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/keyPhraseExtraction/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/keyPhraseExtraction/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "keyphraseextraction"
        ],
        "parentServiceCode": "amazonComprehend"
    },
    "languageDetection": {
        "name": "Language Detection",
        "serviceCode": "languageDetection",
        "description": "With Amazon Comprehend, you only pay for what you use. You are charged based on the amount of text processed on a monthly basis. Amazon Comprehend provides natural language processing, topic modeling, and Custom Classification capabilities, enabling a broad range of applications that can analyze text.",
        "searchKeywords": [
            "Comprehend",
            "NLP",
            "Natural language processing",
            "Sentiment analysis",
            "Text analytics",
            "Entity extraction",
            "Named entity recognition",
            "NER",
            "Key phrase extraction",
            "Topic modeling",
            "Unsupervised clustering",
            "Supervised machine learning",
            "Custom entity recognition",
            "Custom classification",
            "Document classifier",
            "Personally identifiable information",
            "PII",
            "Redaction",
            "Language detection",
            "Free form text analytics"
        ],
        "type": "AWSService",
        "regions": [
            "us-gov-west-1",
            "ap-south-1",
            "ap-northeast-2",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-northeast-1",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "us-east-1",
            "us-east-2",
            "us-west-2"
        ],
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/languageDetection/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/languageDetection/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "languagedetection"
        ],
        "parentServiceCode": "amazonComprehend"
    },
    "lightsailBlockStorage": {
        "name": "Lightsail Block Storage",
        "serviceCode": "lightsailBlockStorage",
        "searchKeywords": [
            "Storage",
            "Simple Storage Service",
            "bucket",
            "file storage",
            "cloud storage",
            "static website hosting",
            "object storage",
            "store objects",
            "store files",
            "data migration",
            "ongoing data ingestion",
            "backup and recovery",
            "big data analytics",
            "nearline archive",
            "disaster recovery",
            "content distribution",
            "cloud storage"
        ],
        "type": "AWSService",
        "regions": [
            "us-east-1",
            "us-east-2",
            "us-west-2",
            "ap-northeast-1",
            "ap-northeast-2",
            "ap-south-1",
            "ap-southeast-1",
            "ap-southeast-2",
            "ca-central-1",
            "eu-central-1",
            "eu-north-1",
            "eu-west-1",
            "eu-west-2",
            "eu-west-3"
        ],
        "linkUrl": "https://aws.amazon.com/lightsail/",
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/lightsailBlockStorage/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/lightsailBlockStorage/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "lightsailblockstorage"
        ],
        "parentServiceCode": "amazonLightsail"
    },
    "lightsailCdn": {
        "name": "Lightsail CDN",
        "serviceCode": "lightsailCdn",
        "searchKeywords": [
            "Storage",
            "Simple Storage Service",
            "bucket",
            "file storage",
            "cloud storage",
            "static website hosting",
            "object storage",
            "store objects",
            "store files",
            "data migration",
            "ongoing data ingestion",
            "backup and recovery",
            "big data analytics",
            "nearline archive",
            "disaster recovery",
            "content distribution",
            "cloud storage"
        ],
        "type": "AWSService",
        "regions": [
            "us-east-1"
        ],
        "linkUrl": "https://aws.amazon.com/lightsail/",
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/lightsailCdn/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/lightsailCdn/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "lightsailcdn"
        ],
        "parentServiceCode": "amazonLightsail"
    },
    "lightsailContainers": {
        "name": "Lightsail Containers",
        "serviceCode": "lightsailContainers",
        "searchKeywords": [
            "Storage",
            "Simple Storage Service",
            "bucket",
            "file storage",
            "cloud storage",
            "static website hosting",
            "object storage",
            "store objects",
            "store files",
            "data migration",
            "ongoing data ingestion",
            "backup and recovery",
            "big data analytics",
            "nearline archive",
            "disaster recovery",
            "content distribution",
            "cloud storage"
        ],
        "type": "AWSService",
        "regions": [
            "us-east-1",
            "us-east-2",
            "us-west-2",
            "ap-northeast-1",
            "ap-northeast-2",
            "ap-south-1",
            "ap-southeast-1",
            "ap-southeast-2",
            "ca-central-1",
            "eu-central-1",
            "eu-north-1",
            "eu-west-1",
            "eu-west-2",
            "eu-west-3"
        ],
        "linkUrl": "https://aws.amazon.com/lightsail/",
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/lightsailContainers/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/lightsailContainers/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "lightsailcontainers"
        ],
        "parentServiceCode": "amazonLightsail"
    },
    "lightsailDataTransfer": {
        "name": "Lightsail Data Transfer",
        "serviceCode": "lightsailDataTransfer",
        "searchKeywords": [
            "Storage",
            "Simple Storage Service",
            "bucket",
            "file storage",
            "cloud storage",
            "static website hosting",
            "object storage",
            "store objects",
            "store files",
            "data migration",
            "ongoing data ingestion",
            "backup and recovery",
            "big data analytics",
            "nearline archive",
            "disaster recovery",
            "content distribution",
            "cloud storage"
        ],
        "type": "AWSService",
        "regions": [
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/lightsail/",
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/lightsailDataTransfer/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "bulkImportEnabled": false,
        "serviceDefinitionUrlPath": "/data/lightsailDataTransfer/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "lightsaildatatransfer"
        ],
        "parentServiceCode": "amazonLightsail"
    },
    "lightsailLoadBalancer": {
        "name": "Lightsail Load Balancer",
        "serviceCode": "lightsailLoadBalancer",
        "searchKeywords": [
            "Storage",
            "Simple Storage Service",
            "bucket",
            "file storage",
            "cloud storage",
            "static website hosting",
            "object storage",
            "store objects",
            "store files",
            "data migration",
            "ongoing data ingestion",
            "backup and recovery",
            "big data analytics",
            "nearline archive",
            "disaster recovery",
            "content distribution",
            "cloud storage"
        ],
        "type": "AWSService",
        "regions": [
            "us-east-1",
            "us-east-2",
            "us-west-2",
            "ap-northeast-1",
            "ap-northeast-2",
            "ap-south-1",
            "ap-southeast-1",
            "ap-southeast-2",
            "ca-central-1",
            "eu-central-1",
            "eu-north-1",
            "eu-west-1",
            "eu-west-2",
            "eu-west-3"
        ],
        "linkUrl": "https://aws.amazon.com/lightsail/",
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/lightsailLoadBalancer/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/lightsailLoadBalancer/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "lightsailloadbalancer"
        ],
        "parentServiceCode": "amazonLightsail"
    },
    "lightsailManagedDatabases": {
        "name": "Lightsail Managed Databases",
        "serviceCode": "lightsailManagedDatabases",
        "searchKeywords": [
            "Storage",
            "Simple Storage Service",
            "bucket",
            "file storage",
            "cloud storage",
            "static website hosting",
            "object storage",
            "store objects",
            "store files",
            "data migration",
            "ongoing data ingestion",
            "backup and recovery",
            "big data analytics",
            "nearline archive",
            "disaster recovery",
            "content distribution",
            "cloud storage"
        ],
        "type": "AWSService",
        "regions": [
            "us-east-1",
            "us-east-2",
            "us-west-2",
            "ap-northeast-1",
            "ap-northeast-2",
            "ap-south-1",
            "ap-southeast-1",
            "ap-southeast-2",
            "ca-central-1",
            "eu-central-1",
            "eu-north-1",
            "eu-west-1",
            "eu-west-2",
            "eu-west-3"
        ],
        "linkUrl": "https://aws.amazon.com/lightsail/",
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/lightsailManagedDatabases/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/lightsailManagedDatabases/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "lightsailmanageddatabases"
        ],
        "parentServiceCode": "amazonLightsail"
    },
    "lightsailObjectStorage": {
        "name": "Lightsail Object Storage",
        "serviceCode": "lightsailObjectStorage",
        "searchKeywords": [
            "Storage",
            "Simple Storage Service",
            "bucket",
            "file storage",
            "cloud storage",
            "static website hosting",
            "object storage",
            "store objects",
            "store files",
            "data migration",
            "ongoing data ingestion",
            "backup and recovery",
            "big data analytics",
            "nearline archive",
            "disaster recovery",
            "content distribution",
            "cloud storage"
        ],
        "type": "AWSService",
        "regions": [
            "ap-south-1",
            "ap-northeast-2",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-northeast-1",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "eu-west-3",
            "eu-north-1",
            "us-east-2",
            "us-east-1",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/lightsail/",
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/lightsailObjectStorage/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/lightsailObjectStorage/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "lightsailobjectstorage"
        ],
        "parentServiceCode": "amazonLightsail"
    },
    "lightsailVirtualServers": {
        "name": "Lightsail Virtual Servers",
        "serviceCode": "lightsailVirtualServers",
        "searchKeywords": [
            "Storage",
            "Simple Storage Service",
            "bucket",
            "file storage",
            "cloud storage",
            "static website hosting",
            "object storage",
            "store objects",
            "store files",
            "data migration",
            "ongoing data ingestion",
            "backup and recovery",
            "big data analytics",
            "nearline archive",
            "disaster recovery",
            "content distribution",
            "cloud storage"
        ],
        "type": "AWSService",
        "regions": [
            "us-east-1",
            "us-east-2",
            "us-west-2",
            "ap-northeast-1",
            "ap-northeast-2",
            "ap-south-1",
            "ap-southeast-1",
            "ap-southeast-2",
            "ca-central-1",
            "eu-central-1",
            "eu-north-1",
            "eu-west-1",
            "eu-west-2",
            "eu-west-3"
        ],
        "linkUrl": "https://aws.amazon.com/lightsail/",
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/lightsailVirtualServers/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/lightsailVirtualServers/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "lightsailvirtualservers"
        ],
        "parentServiceCode": "amazonLightsail"
    },
    "awsIoTCoreLoRaWan": {
        "name": "LoRaWAN",
        "serviceCode": "awsIoTCoreLoRaWan",
        "description": "AWS IoT Core is a managed cloud service that lets connected devices easily and securely interact with cloud applications and other devices.",
        "searchKeywords": [
            "iot",
            "device",
            "messages",
            "shadow",
            "registry",
            "rules",
            "device shadow",
            "rules engine",
            "basic ingest",
            "mqtt",
            "LoRaWAN"
        ],
        "type": "AWSService",
        "regions": [
            "us-east-1",
            "eu-west-1"
        ],
        "linkUrl": "https://aws.amazon.com/iot-core/",
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/awsIoTCoreLoRaWan/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/awsIoTCoreLoRaWan/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "iotcorelorawan",
            "lorawan"
        ],
        "parentServiceCode": "awsIoTCore"
    },
    "locationServiceMaps": {
        "name": "Maps",
        "serviceCode": "locationServiceMaps",
        "description": "Amazon Location Service provides affordable data, tracking and geofencing capabilities, and native integrations with AWS services, so you can create sophisticated location-enabled applications quickly, without the high cost of custom development.",
        "searchKeywords": [
            "Location Service",
            "compromising data security",
            "user privacy",
            "asset tracking",
            "location-based marketing",
            "maps",
            "places",
            "routing",
            "tracking",
            "geofencing",
            "Service Resources"
        ],
        "type": "AWSService",
        "regions": [
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-northeast-1",
            "eu-central-1",
            "eu-west-1",
            "eu-north-1",
            "us-east-1",
            "us-east-2",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/location/",
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/locationServiceMaps/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/locationServiceMaps/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "locationservicemaps",
            "maps"
        ],
        "parentServiceCode": "locationService"
    },
    "mediaLiveAudioAddOns": {
        "name": "MediaLive Add Ons",
        "serviceCode": "mediaLiveAudioAddOns",
        "description": "Elemental Media Live Audio Add Ons",
        "searchKeywords": [
            "streaming",
            "media",
            "elemental media live"
        ],
        "type": "AWSService",
        "regions": [
            "us-east-1",
            "eu-west-2",
            "eu-central-1",
            "ap-southeast-1",
            "sa-east-1",
            "us-east-2",
            "ap-northeast-2",
            "eu-north-1",
            "ap-northeast-1",
            "ap-south-1",
            "eu-west-1",
            "us-west-2",
            "ap-southeast-2",
            "eu-west-3"
        ],
        "linkUrl": "https://aws.amazon.com/medialive/",
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/mediaLiveAudioAddOns/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "bulkImportEnabled": false,
        "serviceDefinitionUrlPath": "/data/mediaLiveAudioAddOns/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "medialiveaddons",
            "medialiveaudioaddons"
        ],
        "parentServiceCode": "awsElementalMediaLive"
    },
    "mediaLiveInput1": {
        "name": "MediaLive Inputs",
        "serviceCode": "mediaLiveInput1",
        "description": "EML input 1",
        "searchKeywords": [
            "streaming",
            "media",
            "elemental media live"
        ],
        "type": "AWSService",
        "regions": [
            "us-east-1",
            "eu-west-2",
            "eu-central-1",
            "ap-southeast-1",
            "sa-east-1",
            "us-east-2",
            "ap-northeast-2",
            "eu-north-1",
            "ap-northeast-1",
            "ap-south-1",
            "eu-west-1",
            "us-west-2",
            "ap-southeast-2",
            "eu-west-3"
        ],
        "linkUrl": "https://aws.amazon.com/medialive/",
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/mediaLiveInput1/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/mediaLiveInput1/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "medialiveinput1",
            "medialiveinputs"
        ],
        "parentServiceCode": "awsElementalMediaLive"
    },
    "mediaLiveOutput1": {
        "name": "MediaLive Outputs",
        "serviceCode": "mediaLiveOutput1",
        "description": "EML Output 1",
        "searchKeywords": [
            "streaming",
            "media",
            "elemental media live"
        ],
        "type": "AWSService",
        "regions": [
            "us-east-1",
            "eu-west-2",
            "eu-central-1",
            "ap-southeast-1",
            "sa-east-1",
            "us-east-2",
            "ap-northeast-2",
            "eu-north-1",
            "ap-northeast-1",
            "ap-south-1",
            "eu-west-1",
            "us-west-2",
            "ap-southeast-2",
            "eu-west-3"
        ],
        "linkUrl": "https://aws.amazon.com/medialive/",
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/mediaLiveOutput1/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/mediaLiveOutput1/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "medialiveoutput1",
            "medialiveoutputs"
        ],
        "parentServiceCode": "awsElementalMediaLive"
    },
    "medicalIcd10CmOntologyLinkingApi": {
        "name": "Medical ICD-10-CM Ontology Linking API",
        "serviceCode": "medicalIcd10CmOntologyLinkingApi",
        "description": "",
        "searchKeywords": [
            "Comprehend",
            "NLP",
            "Natural language processing",
            "Sentiment analysis",
            "Text analytics",
            "Entity extraction",
            "Named entity recognition",
            "NER",
            "Key phrase extraction",
            "Topic modeling",
            "Unsupervised clustering",
            "Supervised machine learning",
            "Custom entity recognition",
            "Custom classification",
            "Document classifier",
            "Personally identifiable information",
            "PII",
            "Redaction",
            "Language detection",
            "Free form text analytics"
        ],
        "type": "AWSService",
        "regions": [
            "ap-southeast-2",
            "ca-central-1",
            "eu-west-1",
            "eu-west-2",
            "us-east-1",
            "us-gov-west-1",
            "us-east-2",
            "us-west-2"
        ],
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/medicalIcd10CmOntologyLinkingApi/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/medicalIcd10CmOntologyLinkingApi/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "medicalicd10cmontologylinkingapi"
        ],
        "parentServiceCode": "amazonComprehendMedical"
    },
    "medicalNamedEntityAndRelationshipExtractionNeReApi": {
        "name": "Medical Named Entity and Relationship Extraction (NERe) API",
        "serviceCode": "medicalNamedEntityAndRelationshipExtractionNeReApi",
        "description": "",
        "searchKeywords": [
            "Comprehend",
            "NLP",
            "Natural language processing",
            "Sentiment analysis",
            "Text analytics",
            "Entity extraction",
            "Named entity recognition",
            "NER",
            "Key phrase extraction",
            "Topic modeling",
            "Unsupervised clustering",
            "Supervised machine learning",
            "Custom entity recognition",
            "Custom classification",
            "Document classifier",
            "Personally identifiable information",
            "PII",
            "Redaction",
            "Language detection",
            "Free form text analytics"
        ],
        "type": "AWSService",
        "regions": [
            "ap-southeast-2",
            "ca-central-1",
            "eu-west-1",
            "eu-west-2",
            "us-east-1",
            "us-east-2",
            "us-gov-west-1",
            "us-west-2"
        ],
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/medicalNamedEntityAndRelationshipExtractionNeReApi/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/medicalNamedEntityAndRelationshipExtractionNeReApi/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "medicalnamedentityandrelationshipextractionnereapi",
            "medicalnamedentityrelationshipextractionnereapi",
            "nere"
        ],
        "parentServiceCode": "amazonComprehendMedical"
    },
    "medicalProtectedHealthInformationDataExtractionAndIdentificationPhIdApi": {
        "name": "Medical Protected Health Information Data Extraction and Identification (PHId) API",
        "serviceCode": "medicalProtectedHealthInformationDataExtractionAndIdentificationPhIdApi",
        "description": "",
        "searchKeywords": [
            "Comprehend",
            "NLP",
            "Natural language processing",
            "Sentiment analysis",
            "Text analytics",
            "Entity extraction",
            "Named entity recognition",
            "NER",
            "Key phrase extraction",
            "Topic modeling",
            "Unsupervised clustering",
            "Supervised machine learning",
            "Custom entity recognition",
            "Custom classification",
            "Document classifier",
            "Personally identifiable information",
            "PII",
            "Redaction",
            "Language detection",
            "Free form text analytics"
        ],
        "type": "AWSService",
        "regions": [
            "ap-southeast-2",
            "ca-central-1",
            "eu-west-1",
            "eu-west-2",
            "us-east-1",
            "us-gov-west-1",
            "us-east-2",
            "us-west-2"
        ],
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/medicalProtectedHealthInformationDataExtractionAndIdentificationPhIdApi/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/medicalProtectedHealthInformationDataExtractionAndIdentificationPhIdApi/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "medicalprotectedhealthinformationdataextractionandidentificationphidapi",
            "medicalprotectedhealthinformationdataextractionidentificationphidapi",
            "phid"
        ],
        "parentServiceCode": "amazonComprehendMedical"
    },
    "medicalRxNormOntologyLinkingApi": {
        "name": "Medical RxNORM Ontology Linking API",
        "serviceCode": "medicalRxNormOntologyLinkingApi",
        "description": "",
        "searchKeywords": [
            "Comprehend",
            "NLP",
            "Natural language processing",
            "Sentiment analysis",
            "Text analytics",
            "Entity extraction",
            "Named entity recognition",
            "NER",
            "Key phrase extraction",
            "Topic modeling",
            "Unsupervised clustering",
            "Supervised machine learning",
            "Custom entity recognition",
            "Custom classification",
            "Document classifier",
            "Personally identifiable information",
            "PII",
            "Redaction",
            "Language detection",
            "Free form text analytics"
        ],
        "type": "AWSService",
        "regions": [
            "ap-southeast-2",
            "ca-central-1",
            "eu-west-1",
            "eu-west-2",
            "us-east-1",
            "us-gov-west-1",
            "us-east-2",
            "us-west-2"
        ],
        "isActive": "true",
        "subType": "subService",
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/medicalRxNormOntologyLinkingApi/en_US.json",
        "c2e": false,
        "mvpSupport": false,
        "comparableTerms": [
            "medicalrxnormontologylinkingapi"
        ],
        "parentServiceCode": "amazonComprehendMedical"
    },
    "medicalSystematizedNomenclatureOfMedicineClinicalTermsSnomedCtApi": {
        "name": "Medical Systematized Nomenclature of Medicine Clinical Terms (SNOMED CT) API",
        "serviceCode": "medicalSystematizedNomenclatureOfMedicineClinicalTermsSnomedCtApi",
        "description": "",
        "searchKeywords": [
            "Comprehend",
            "NLP",
            "Natural language processing",
            "Sentiment analysis",
            "Text analytics",
            "Entity extraction",
            "Named entity recognition",
            "NER",
            "Key phrase extraction",
            "Topic modeling",
            "Unsupervised clustering",
            "Supervised machine learning",
            "Custom entity recognition",
            "Custom classification",
            "Document classifier",
            "Personally identifiable information",
            "PII",
            "Redaction",
            "Language detection",
            "Free form text analytics"
        ],
        "type": "AWSService",
        "regions": [
            "ap-southeast-2",
            "ca-central-1",
            "eu-west-1",
            "eu-west-2",
            "us-east-1",
            "us-east-2",
            "us-gov-west-1",
            "us-west-2"
        ],
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/medicalSystematizedNomenclatureOfMedicineClinicalTermsSnomedCtApi/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/medicalSystematizedNomenclatureOfMedicineClinicalTermsSnomedCtApi/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "medicalsystematizednomenclaturemedicineclinicaltermssnomedctapi",
            "medicalsystematizednomenclatureofmedicineclinicaltermssnomedctapi",
            "snomedct"
        ],
        "parentServiceCode": "amazonComprehendMedical"
    },
    "chimeSdkMessaging": {
        "name": "Messaging",
        "serviceCode": "chimeSdkMessaging",
        "description": "TBD",
        "searchKeywords": [],
        "type": "AWSService",
        "regions": [
            "eu-central-1",
            "us-east-1"
        ],
        "linkUrl": "https://aws.amazon.com/chime/chime-sdk",
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/chimeSdkMessaging/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/chimeSdkMessaging/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "chimesdkmessaging",
            "messaging"
        ],
        "parentServiceCode": "amazonChimeSdk"
    },
    "mainframeMicroFocus": {
        "name": "Micro Focus replatforming",
        "serviceCode": "mainframeMicroFocus",
        "description": "For AWS M2 Blu Age managed runtime, you can choose on-demand instances and pay for the runtime by the hour with no long-term commitments or upfront fees, or choose committed plans for additional savings.",
        "searchKeywords": [],
        "type": "AWSService",
        "regions": [
            "ap-southeast-2",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "sa-east-1",
            "us-east-1",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/mainframe-modernization/pricing/",
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/mainframeMicroFocus/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/mainframeMicroFocus/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "mainframemicrofocus",
            "microfocusreplatforming"
        ],
        "parentServiceCode": "amazonMainframeModernization"
    },
    "awsIoTCoreMqtt": {
        "name": "MQTT",
        "serviceCode": "awsIoTCoreMqtt",
        "description": "AWS IoT Core is a managed cloud service that lets connected devices easily and securely interact with cloud applications and other devices.",
        "searchKeywords": [
            "iot",
            "device",
            "messages",
            "shadow",
            "registry",
            "rules",
            "device shadow",
            "rules engine",
            "basic ingest",
            "mqtt",
            "LoRaWAN"
        ],
        "type": "AWSService",
        "regions": [
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2",
            "ap-east-1",
            "ap-south-1",
            "ap-northeast-2",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-northeast-1",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "eu-west-3",
            "eu-north-1",
            "me-south-1",
            "sa-east-1",
            "us-gov-east-1",
            "us-gov-west-1"
        ],
        "linkUrl": "https://aws.amazon.com/iot-core/",
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/awsIoTCoreMqtt/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/awsIoTCoreMqtt/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "iotcoremqtt",
            "mqtt"
        ],
        "parentServiceCode": "awsIoTCore"
    },
    "networkAccessAnalyzerVpc": {
        "name": "Network Access Analyzer",
        "serviceCode": "networkAccessAnalyzerVpc",
        "description": "WS Virtual Private Network solutions establish secure connections between your on-premises networks, remote offices, client devices, and the AWS global network. AWS VPN is comprised of two services: AWS Site-to-Site VPN and AWS Client VPN. Each service provides a highly-available, managed, and elastic cloud VPN solution to protect your network traffic.",
        "searchKeywords": [
            "access control",
            "ACL",
            "AWS Privatelink",
            "Cloud connectivity",
            "corporate network",
            "elastic IP",
            "Gateway load balancer",
            "home network VPN",
            "IPAM",
            "NAT",
            "NAT gateway",
            "Network Access Analyzer",
            "Network Address Translation",
            "Networking Content Delivery",
            "PrivateLink",
            "Reachability Analyzer",
            "security",
            "single tenant hardware",
            "static ip",
            "subnets",
            "Traffic mirroring",
            "Transit Gateway",
            "Virtual Private Cloud",
            "VPN"
        ],
        "type": "AWSService",
        "regions": [
            "af-south-1",
            "ap-east-1",
            "ap-northeast-1",
            "ap-northeast-2",
            "ap-south-1",
            "ap-southeast-1",
            "ap-southeast-2",
            "ca-central-1",
            "eu-central-1",
            "eu-north-1",
            "eu-south-1",
            "eu-west-1",
            "eu-west-2",
            "eu-west-3",
            "me-south-1",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2"
        ],
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/networkAccessAnalyzerVpc/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/networkAccessAnalyzerVpc/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "networkaccessanalyzer",
            "networkaccessanalyzervpc"
        ],
        "parentServiceCode": "amazonVirtualPrivateCloud"
    },
    "networkAddressTranslationNatGatewayVpc": {
        "name": "Network Address Translation (NAT) Gateway",
        "serviceCode": "networkAddressTranslationNatGatewayVpc",
        "description": "WS Virtual Private Network solutions establish secure connections between your on-premises networks, remote offices, client devices, and the AWS global network. AWS VPN is comprised of two services: AWS Site-to-Site VPN and AWS Client VPN. Each service provides a highly-available, managed, and elastic cloud VPN solution to protect your network traffic.",
        "searchKeywords": [
            "access control",
            "ACL",
            "AWS Privatelink",
            "Cloud connectivity",
            "corporate network",
            "elastic IP",
            "Gateway load balancer",
            "home network VPN",
            "IPAM",
            "NAT",
            "NAT gateway",
            "Network Access Analyzer",
            "Network Address Translation",
            "Networking Content Delivery",
            "PrivateLink",
            "Reachability Analyzer",
            "security",
            "single tenant hardware",
            "static ip",
            "subnets",
            "Traffic mirroring",
            "Transit Gateway",
            "Virtual Private Cloud",
            "VPN"
        ],
        "type": "AWSService",
        "regions": [
            "af-south-1",
            "ap-east-1",
            "ap-northeast-1",
            "ap-northeast-2",
            "ap-northeast-3",
            "ap-south-1",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-southeast-3",
            "ca-central-1",
            "eu-central-1",
            "eu-north-1",
            "eu-south-1",
            "eu-west-1",
            "eu-west-2",
            "eu-west-3",
            "me-south-1",
            "me-central-1",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2",
            "us-gov-east-1",
            "us-gov-west-1"
        ],
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/networkAddressTranslationNatGatewayVpc/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/networkAddressTranslationNatGatewayVpc/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "nat",
            "networkaddresstranslationnatgateway",
            "networkaddresstranslationnatgatewayvpc"
        ],
        "parentServiceCode": "amazonVirtualPrivateCloud"
    },
    "networkLoadBalancer": {
        "name": "Network Load Balancer",
        "serviceCode": "networkLoadBalancer",
        "description": "Elastic Load Balancing automatically distributes incoming application traffic across multiple targets, such as Amazon EC2 instances, containers, IP addresses, and Lambda functions.",
        "searchKeywords": [
            "ELB",
            "Elastic Load Balancer",
            "Load Balancer",
            "Application Load Balancer",
            "Network Load Balancer",
            "Classic Load Balancer"
        ],
        "type": "AWSService",
        "regions": [
            "af-south-1",
            "ap-east-1",
            "ap-northeast-1",
            "ap-northeast-2",
            "ap-northeast-3",
            "ap-south-1",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-southeast-3",
            "ca-central-1",
            "eu-central-1",
            "eu-north-1",
            "eu-south-1",
            "eu-west-1",
            "eu-west-2",
            "eu-west-3",
            "me-south-1",
            "me-central-1",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-gov-east-1",
            "us-gov-west-1",
            "us-west-1",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/elasticloadbalancing/",
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/networkLoadBalancer/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/networkLoadBalancer/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "networkloadbalancer"
        ],
        "parentServiceCode": "elasticLoadBalancing"
    },
    "neuralTextToSpeech": {
        "name": "Neural Text-to-Speech",
        "serviceCode": "neuralTextToSpeech",
        "description": "Amazon Polly is a service that turns text into lifelike speech, allowing you to create applications that talk, and build entirely new categories of speech-enabled products.",
        "searchKeywords": [
            "polly",
            "NLP",
            "speech",
            "Neural Text-to-Speech"
        ],
        "type": "AWSService",
        "regions": [
            "us-gov-west-1",
            "ap-northeast-2",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-northeast-1",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "us-east-1",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/polly/",
        "isActive": "true",
        "subType": "subService",
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/neuralTextToSpeech/en_US.json",
        "c2e": false,
        "comparableTerms": [
            "neuraltexttospeech"
        ],
        "parentServiceCode": "amazonPolly"
    },
    "awsSystemsManagerOnPremisesInstanceManagement": {
        "name": "On-Premises Instance Management",
        "serviceCode": "awsSystemsManagerOnPremisesInstanceManagement",
        "description": "AWS Systems Manager On-Premises Instance Management feature",
        "searchKeywords": [
            "Systems Manager",
            "On-Premises Instance Management",
            "On-Prem",
            "Session Manager"
        ],
        "type": "AWSService",
        "regions": [
            "us-gov-west-1",
            "us-gov-east-1",
            "af-south-1",
            "ap-east-1",
            "ap-south-1",
            "ap-northeast-2",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-southeast-3",
            "ap-northeast-1",
            "ap-northeast-3",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "eu-south-1",
            "eu-west-3",
            "eu-north-1",
            "me-south-1",
            "me-central-1",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/systems-manager/",
        "isActive": "true",
        "hasDataTransfer": false,
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/awsSystemsManagerOnPremisesInstanceManagement/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/awsSystemsManagerOnPremisesInstanceManagement/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "onpremisesinstancemanagement",
            "systemsmanageronpremisesinstancemanagement"
        ],
        "parentServiceCode": "awsSystemsManager"
    },
    "awsSystemsManagerOpsCenter": {
        "name": "OpsCenter",
        "serviceCode": "awsSystemsManagerOpsCenter",
        "description": "AWS Systems Manager OpsCenter feature",
        "searchKeywords": [
            "System Manager",
            "OpsCenter",
            "operational issues",
            "OpsItems"
        ],
        "type": "AWSService",
        "regions": [
            "ap-east-1",
            "ap-south-1",
            "ap-northeast-2",
            "ap-northeast-3",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-southeast-3",
            "ap-northeast-1",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "eu-west-3",
            "eu-north-1",
            "me-south-1",
            "me-central-1",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2",
            "us-gov-west-1",
            "us-gov-east-1",
            "eu-south-1",
            "af-south-1"
        ],
        "linkUrl": "https://aws.amazon.com/systems-manager/",
        "isActive": "true",
        "hasDataTransfer": false,
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/awsSystemsManagerOpsCenter/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/awsSystemsManagerOpsCenter/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "opscenter",
            "systemsmanageropscenter"
        ],
        "parentServiceCode": "awsSystemsManager"
    },
    "awsSystemsManagerParameterStore": {
        "name": "Parameter Store",
        "serviceCode": "awsSystemsManagerParameterStore",
        "description": "AWS Systems Manager Parameter Store feature",
        "searchKeywords": [
            "System Manager",
            "Parameter Store",
            "API",
            "parameter"
        ],
        "type": "AWSService",
        "regions": [
            "us-gov-west-1",
            "us-gov-east-1",
            "af-south-1",
            "ap-east-1",
            "ap-south-1",
            "ap-northeast-3",
            "ap-northeast-2",
            "ap-southeast-2",
            "ap-southeast-3",
            "ap-northeast-1",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "eu-south-1",
            "eu-west-3",
            "eu-north-1",
            "me-south-1",
            "me-central-1",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/systems-manager/",
        "isActive": "true",
        "hasDataTransfer": false,
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/awsSystemsManagerParameterStore/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/awsSystemsManagerParameterStore/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "parameterstore",
            "systemsmanagerparameterstore"
        ],
        "parentServiceCode": "awsSystemsManager"
    },
    "locationServicePlaces": {
        "name": "Places",
        "serviceCode": "locationServicePlaces",
        "description": "Amazon Location Service provides affordable data, tracking and geofencing capabilities, and native integrations with AWS services, so you can create sophisticated location-enabled applications quickly, without the high cost of custom development.",
        "searchKeywords": [
            "Location Service",
            "compromising data security",
            "user privacy",
            "asset tracking",
            "location-based marketing",
            "maps",
            "places",
            "routing",
            "tracking",
            "geofencing",
            "Service Resources"
        ],
        "type": "AWSService",
        "regions": [
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-northeast-1",
            "eu-central-1",
            "eu-west-1",
            "eu-north-1",
            "us-east-1",
            "us-east-2",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/location/",
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/locationServicePlaces/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/locationServicePlaces/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "locationserviceplaces",
            "places"
        ],
        "parentServiceCode": "locationService"
    },
    "proServeYear1Cost": {
        "name": "ProServe Year 1 Price",
        "serviceCode": "proServeYear1Cost",
        "description": "AWS Professional Services Year 1 Price",
        "searchKeywords": [
            "ProServe",
            "professional",
            "services"
        ],
        "type": "AWSService",
        "regions": [
            "us-east-1",
            "us-gov-west-1"
        ],
        "linkUrl": "https://aws.amazon.com/professional-services/",
        "isActive": "true",
        "hasDataTransfer": false,
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/proServeYear1Cost/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": true,
        "bulkImportEnabled": false,
        "serviceDefinitionUrlPath": "/data/proServeYear1Cost/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "proserveyear1cost",
            "proserveyear1price"
        ],
        "parentServiceCode": "awsProfessionalServices"
    },
    "proServeYear2Cost": {
        "name": "ProServe Year 2 Price",
        "serviceCode": "proServeYear2Cost",
        "description": "AWS Professional Services Year 2 Price",
        "searchKeywords": [
            "ProServe",
            "professional",
            "services"
        ],
        "type": "AWSService",
        "regions": [
            "us-east-1",
            "us-gov-west-1"
        ],
        "linkUrl": "https://aws.amazon.com/professional-services/",
        "isActive": "true",
        "hasDataTransfer": false,
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/proServeYear2Cost/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": true,
        "bulkImportEnabled": false,
        "serviceDefinitionUrlPath": "/data/proServeYear2Cost/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "proserveyear2cost",
            "proserveyear2price"
        ],
        "parentServiceCode": "awsProfessionalServices"
    },
    "proServeYear3Cost": {
        "name": "ProServe Year 3 Price",
        "serviceCode": "proServeYear3Cost",
        "description": "AWS Professional Services Year 3 Price",
        "searchKeywords": [
            "ProServe",
            "professional",
            "services"
        ],
        "type": "AWSService",
        "regions": [
            "us-east-1",
            "us-gov-west-1"
        ],
        "linkUrl": "https://aws.amazon.com/professional-services/",
        "isActive": "true",
        "hasDataTransfer": false,
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/proServeYear3Cost/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": true,
        "bulkImportEnabled": false,
        "serviceDefinitionUrlPath": "/data/proServeYear3Cost/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "proserveyear3cost",
            "proserveyear3price"
        ],
        "parentServiceCode": "awsProfessionalServices"
    },
    "proServeYear4Cost": {
        "name": "ProServe Year 4 Price",
        "serviceCode": "proServeYear4Cost",
        "description": "AWS Professional Services Year 4 Price",
        "searchKeywords": [
            "ProServe",
            "professional",
            "services"
        ],
        "type": "AWSService",
        "regions": [
            "us-east-1",
            "us-gov-west-1"
        ],
        "linkUrl": "https://aws.amazon.com/professional-services/",
        "isActive": "true",
        "hasDataTransfer": false,
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/proServeYear4Cost/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": true,
        "bulkImportEnabled": false,
        "serviceDefinitionUrlPath": "/data/proServeYear4Cost/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "proserveyear4cost",
            "proserveyear4price"
        ],
        "parentServiceCode": "awsProfessionalServices"
    },
    "proServeYear5Cost": {
        "name": "ProServe Year 5 Price",
        "serviceCode": "proServeYear5Cost",
        "description": "AWS Professional Services Year 5 Price",
        "searchKeywords": [
            "ProServe",
            "professional",
            "services"
        ],
        "type": "AWSService",
        "regions": [
            "us-east-1",
            "us-gov-west-1"
        ],
        "linkUrl": "https://aws.amazon.com/professional-services/",
        "isActive": "true",
        "hasDataTransfer": false,
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/proServeYear5Cost/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": true,
        "bulkImportEnabled": false,
        "serviceDefinitionUrlPath": "/data/proServeYear5Cost/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "proserveyear5cost",
            "proserveyear5price"
        ],
        "parentServiceCode": "awsProfessionalServices"
    },
    "proxyPhoneSession": {
        "name": "Proxy Phone Session",
        "serviceCode": "proxyPhoneSession",
        "description": "Amazon Chime lets you meet, chat, and collaborate with the security of AWS. You can work seamlessly on your devices, and meet from your desk or on the go - ensuring you always stay connected.",
        "searchKeywords": [],
        "type": "AWSService",
        "regions": [
            "us-east-1",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/chime/chime-sdk",
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/proxyPhoneSession/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/proxyPhoneSession/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "proxyphonesession"
        ],
        "parentServiceCode": "amazonChimeSdk"
    },
    "ptsnAudio": {
        "name": "PSTN Audio",
        "serviceCode": "ptsnAudio",
        "description": "Amazon Chime lets you meet, chat, and collaborate with the security of AWS. You can work seamlessly on your devices, and meet from your desk or on the go - ensuring you always stay connected.",
        "searchKeywords": [],
        "type": "AWSService",
        "regions": [
            "us-east-1",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/chime/chime-sdk",
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/ptsnAudio/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "bulkImportEnabled": false,
        "serviceDefinitionUrlPath": "/data/ptsnAudio/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "pstnaudio",
            "ptsnaudio"
        ],
        "parentServiceCode": "amazonChimeSdk"
    },
    "reachabilityAnalyzerVpc": {
        "name": "Reachability Analyzer",
        "serviceCode": "reachabilityAnalyzerVpc",
        "description": "WS Virtual Private Network solutions establish secure connections between your on-premises networks, remote offices, client devices, and the AWS global network. AWS VPN is comprised of two services: AWS Site-to-Site VPN and AWS Client VPN. Each service provides a highly-available, managed, and elastic cloud VPN solution to protect your network traffic.",
        "searchKeywords": [
            "access control",
            "ACL",
            "AWS Privatelink",
            "Cloud connectivity",
            "corporate network",
            "elastic IP",
            "Gateway load balancer",
            "home network VPN",
            "IPAM",
            "NAT",
            "NAT gateway",
            "Network Access Analyzer",
            "Network Address Translation",
            "Networking Content Delivery",
            "PrivateLink",
            "Reachability Analyzer",
            "security",
            "single tenant hardware",
            "static ip",
            "subnets",
            "Traffic mirroring",
            "Transit Gateway",
            "Virtual Private Cloud",
            "VPN"
        ],
        "type": "AWSService",
        "regions": [
            "af-south-1",
            "ap-east-1",
            "ap-northeast-1",
            "ap-northeast-2",
            "ap-south-1",
            "ap-southeast-1",
            "ap-southeast-2",
            "ca-central-1",
            "eu-central-1",
            "eu-north-1",
            "eu-south-1",
            "eu-west-1",
            "eu-west-2",
            "eu-west-3",
            "me-south-1",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2"
        ],
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/reachabilityAnalyzerVpc/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/reachabilityAnalyzerVpc/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "reachabilityanalyzer",
            "reachabilityanalyzervpc"
        ],
        "parentServiceCode": "amazonVirtualPrivateCloud"
    },
    "rekognitionCustomLabels": {
        "name": "Rekognition Custom Labels",
        "serviceCode": "rekognitionCustomLabels",
        "searchKeywords": [],
        "type": "AWSService",
        "regions": [
            "ap-northeast-2",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-northeast-1",
            "eu-west-1",
            "us-east-1",
            "us-east-2",
            "us-west-2"
        ],
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/rekognitionCustomLabels/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/rekognitionCustomLabels/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "rekognitioncustomlabels"
        ],
        "parentServiceCode": "amazonRekognition"
    },
    "rekognitionImage": {
        "name": "Rekognition Image",
        "serviceCode": "rekognitionImage",
        "searchKeywords": [],
        "type": "AWSService",
        "regions": [
            "us-gov-west-1",
            "ap-south-1",
            "ap-northeast-2",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-northeast-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2"
        ],
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/rekognitionImage/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/rekognitionImage/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "rekognitionimage"
        ],
        "parentServiceCode": "amazonRekognition"
    },
    "rekognitionVideo": {
        "name": "Rekognition Stored Video",
        "serviceCode": "rekognitionVideo",
        "searchKeywords": [],
        "type": "AWSService",
        "regions": [
            "us-gov-west-1",
            "ap-south-1",
            "ap-northeast-2",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-northeast-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2"
        ],
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/rekognitionVideo/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/rekognitionVideo/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "rekognitionstoredvideo",
            "rekognitionvideo"
        ],
        "parentServiceCode": "amazonRekognition"
    },
    "rekognitionStreamingVideoEvents": {
        "name": "Rekognition Streaming Video Events",
        "serviceCode": "rekognitionStreamingVideoEvents",
        "searchKeywords": [],
        "type": "AWSService",
        "regions": [
            "ap-south-1",
            "ap-northeast-1",
            "eu-central-1",
            "eu-west-1",
            "us-east-1",
            "us-east-2",
            "us-west-2"
        ],
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/rekognitionStreamingVideoEvents/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/rekognitionStreamingVideoEvents/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "rekognitionstreamingvideoevents"
        ],
        "parentServiceCode": "amazonRekognition"
    },
    "locationServiceRouting": {
        "name": "Routing",
        "serviceCode": "locationServiceRouting",
        "description": "Amazon Location Service provides affordable data, tracking and geofencing capabilities, and native integrations with AWS services, so you can create sophisticated location-enabled applications quickly, without the high cost of custom development.",
        "searchKeywords": [
            "Location Service",
            "compromising data security",
            "user privacy",
            "asset tracking",
            "location-based marketing",
            "maps",
            "places",
            "routing",
            "tracking",
            "geofencing",
            "Service Resources"
        ],
        "type": "AWSService",
        "regions": [
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-northeast-1",
            "eu-central-1",
            "eu-west-1",
            "eu-north-1",
            "us-east-1",
            "us-east-2",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/location/",
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/locationServiceRouting/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/locationServiceRouting/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "locationservicerouting",
            "routing"
        ],
        "parentServiceCode": "locationService"
    },
    "sageMakerRStudioOnSageMaker": {
        "name": "RStudio on SageMaker",
        "serviceCode": "sageMakerRStudioOnSageMaker",
        "description": "With Amazon SageMaker, you pay only for what you use. Building, training, and deploying ML models is billed by the second, with no minimum fees and no upfront commitments.",
        "searchKeywords": [
            "Sagemaker",
            "Model",
            "ML",
            "Machine Learning",
            "EI",
            "data scientist"
        ],
        "type": "AWSService",
        "regions": [
            "ap-south-1",
            "ap-northeast-2",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-northeast-1",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "eu-west-3",
            "eu-north-1",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/sagemaker/",
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/sageMakerRStudioOnSageMaker/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/sageMakerRStudioOnSageMaker/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "rstudiosagemaker",
            "sagemakerrstudioonsagemaker"
        ],
        "parentServiceCode": "amazonSageMaker"
    },
    "amazonS3GlacierDeepArhive": {
        "name": "S3 Glacier Deep Archive",
        "serviceCode": "amazonS3GlacierDeepArhive",
        "description": "Amazon Simple Storage Service (Amazon S3) is storage for the internet. You can use Amazon S3 to store and retrieve any amount of data at any time, from anywhere on the web.",
        "searchKeywords": [
            "Storage",
            "Simple Storage Service",
            "bucket",
            "file storage",
            "cloud storage",
            "static website hosting",
            "object storage",
            "store objects",
            "store files",
            "data migration",
            "ongoing data ingestion",
            "backup and recovery",
            "big data analytics",
            "nearline archive",
            "disaster recovery",
            "content distribution",
            "cloud storage"
        ],
        "type": "AWSService",
        "regions": [
            "af-south-1",
            "ap-east-1",
            "ap-south-1",
            "ap-northeast-3",
            "ap-northeast-2",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-southeast-3",
            "ap-northeast-1",
            "us-gov-west-1",
            "us-gov-east-1",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "eu-west-3",
            "eu-north-1",
            "eu-south-1",
            "me-south-1",
            "me-central-1",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/s3/",
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonS3GlacierDeepArhive/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "mvpSupport": false,
        "comparableTerms": [
            "s3glacierdeeparchive",
            "s3glacierdeeparhive"
        ],
        "parentServiceCode": "amazonSimpleStorageServiceGroup"
    },
    "amazonS3Glacier": {
        "name": "S3 Glacier Flexible Retrieval",
        "serviceCode": "amazonS3Glacier",
        "description": "Amazon Simple Storage Service (Amazon S3) is storage for the internet. You can use Amazon S3 to store and retrieve any amount of data at any time, from anywhere on the web.",
        "searchKeywords": [
            "Storage",
            "Simple Storage Service",
            "bucket",
            "file storage",
            "cloud storage",
            "static website hosting",
            "object storage",
            "store objects",
            "store files",
            "data migration",
            "ongoing data ingestion",
            "backup and recovery",
            "big data analytics",
            "nearline archive",
            "disaster recovery",
            "content distribution",
            "cloud storage"
        ],
        "type": "AWSService",
        "regions": [
            "af-south-1",
            "ap-east-1",
            "ap-south-1",
            "ap-northeast-3",
            "ap-northeast-2",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-southeast-3",
            "ap-northeast-1",
            "us-gov-west-1",
            "us-gov-east-1",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "eu-west-3",
            "eu-north-1",
            "eu-south-1",
            "me-south-1",
            "me-central-1",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/s3",
        "isActive": "true",
        "subType": "TCOCalculator",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonS3Glacier/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "bulkImportEnabled": false,
        "serviceDefinitionUrlPath": "/data/amazonS3Glacier/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "s3",
            "s3glacier",
            "s3glacierflexibleretrieval"
        ],
        "parentServiceCode": "amazonSimpleStorageServiceGroup"
    },
    "s3GlacierInstantRetrieval": {
        "name": "S3 Glacier Instant Retrieval",
        "serviceCode": "s3GlacierInstantRetrieval",
        "description": "Amazon Simple Storage Service (Amazon S3) is storage for the internet. You can use Amazon S3 to store and retrieve any amount of data at any time, from anywhere on the web.",
        "searchKeywords": [
            "Storage",
            "Simple Storage Service",
            "bucket",
            "file storage",
            "cloud storage",
            "static website hosting",
            "object storage",
            "store objects",
            "store files",
            "data migration",
            "ongoing data ingestion",
            "backup and recovery",
            "big data analytics",
            "nearline archive",
            "disaster recovery",
            "content distribution",
            "cloud storage"
        ],
        "type": "AWSService",
        "regions": [
            "af-south-1",
            "ap-east-1",
            "ap-south-1",
            "ap-northeast-3",
            "ap-northeast-2",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-southeast-3",
            "ap-northeast-1",
            "us-gov-west-1",
            "us-gov-east-1",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "eu-west-3",
            "eu-north-1",
            "eu-south-1",
            "me-south-1",
            "me-central-1",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/s3/",
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/s3GlacierInstantRetrieval/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "bulkImportEnabled": false,
        "serviceDefinitionUrlPath": "/data/s3GlacierInstantRetrieval/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "s3glacierinstantretrieval"
        ],
        "parentServiceCode": "amazonSimpleStorageServiceGroup"
    },
    "amazonS3IntelligentTiering": {
        "name": "S3 Intelligent - Tiering",
        "serviceCode": "amazonS3IntelligentTiering",
        "description": "Amazon Simple Storage Service (Amazon S3) is storage for the internet. You can use Amazon S3 to store and retrieve any amount of data at any time, from anywhere on the web.",
        "searchKeywords": [
            "Storage",
            "Simple Storage Service",
            "bucket",
            "file storage",
            "cloud storage",
            "static website hosting",
            "object storage",
            "store objects",
            "store files",
            "data migration",
            "ongoing data ingestion",
            "backup and recovery",
            "big data analytics",
            "nearline archive",
            "disaster recovery",
            "content distribution",
            "cloud storage"
        ],
        "type": "AWSService",
        "regions": [
            "af-south-1",
            "ap-east-1",
            "ap-south-1",
            "ap-northeast-3",
            "ap-northeast-2",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-southeast-3",
            "ap-northeast-1",
            "us-gov-west-1",
            "us-gov-east-1",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "eu-west-3",
            "eu-north-1",
            "eu-south-1",
            "me-south-1",
            "me-central-1",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/s3/",
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonS3IntelligentTiering/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "bulkImportEnabled": false,
        "serviceDefinitionUrlPath": "/data/amazonS3IntelligentTiering/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "s3intelligenttiering"
        ],
        "parentServiceCode": "amazonSimpleStorageServiceGroup"
    },
    "amazonS3StorageManagement": {
        "name": "S3 Management and Analytics",
        "serviceCode": "amazonS3StorageManagement",
        "description": "S3 Storage Management and Analytics is priced per feature (Amazon S3 Inventory, S3 Storage Class Analysis, S3 Storage Lens, and S3 Object Tagging) that is enabled on your account’s bucket.",
        "searchKeywords": [
            "Storage",
            "Simple Storage Service",
            "bucket",
            "file storage",
            "cloud storage",
            "static website hosting",
            "object storage",
            "store objects",
            "store files",
            "data migration",
            "ongoing data ingestion",
            "backup and recovery",
            "big data analytics",
            "nearline archive",
            "disaster recovery",
            "content distribution",
            "cloud storage"
        ],
        "type": "AWSService",
        "regions": [
            "af-south-1",
            "ap-east-1",
            "ap-south-1",
            "ap-northeast-3",
            "ap-northeast-2",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-southeast-3",
            "ap-northeast-1",
            "us-gov-west-1",
            "us-gov-east-1",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "eu-west-3",
            "eu-north-1",
            "eu-south-1",
            "me-south-1",
            "me-central-1",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/s3/",
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonS3StorageManagement/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "mvpSupport": false,
        "comparableTerms": [
            "s3managementanalytics",
            "s3storagemanagement"
        ],
        "parentServiceCode": "amazonSimpleStorageServiceGroup"
    },
    "s3ObjectLambda": {
        "name": "S3 Object Lambda",
        "serviceCode": "s3ObjectLambda",
        "description": "Amazon Simple Storage Service (Amazon S3) is storage for the internet. You can use Amazon S3 to store and retrieve any amount of data at any time, from anywhere on the web.",
        "searchKeywords": [
            "Storage",
            "Simple Storage Service",
            "bucket",
            "file storage",
            "cloud storage",
            "static website hosting",
            "object storage",
            "store objects",
            "store files",
            "data migration",
            "ongoing data ingestion",
            "backup and recovery",
            "big data analytics",
            "nearline archive",
            "disaster recovery",
            "content distribution",
            "cloud storage",
            "S3",
            "s3"
        ],
        "type": "AWSService",
        "regions": [
            "af-south-1",
            "ap-east-1",
            "ap-south-1",
            "ap-northeast-2",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-southeast-3",
            "ap-northeast-1",
            "us-gov-west-1",
            "us-gov-east-1",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "eu-west-3",
            "eu-north-1",
            "eu-south-1",
            "me-south-1",
            "me-central-1",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/s3",
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/s3ObjectLambda/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "mvpSupport": false,
        "comparableTerms": [
            "s3objectlambda"
        ],
        "parentServiceCode": "amazonSimpleStorageServiceGroup"
    },
    "s3OneZoneInfrequentAccess": {
        "name": "S3 One Zone - Infrequent Access",
        "serviceCode": "s3OneZoneInfrequentAccess",
        "description": "Amazon Simple Storage Service (Amazon S3) is storage for the internet. You can use Amazon S3 to store and retrieve any amount of data at any time, from anywhere on the web.",
        "searchKeywords": [
            "Storage",
            "Simple Storage Service",
            "bucket",
            "file storage",
            "cloud storage",
            "static website hosting",
            "object storage",
            "store objects",
            "store files",
            "data migration",
            "ongoing data ingestion",
            "backup and recovery",
            "big data analytics",
            "nearline archive",
            "disaster recovery",
            "content distribution",
            "cloud storage"
        ],
        "type": "AWSService",
        "regions": [
            "af-south-1",
            "ap-east-1",
            "ap-south-1",
            "ap-northeast-3",
            "ap-northeast-2",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-southeast-3",
            "ap-northeast-1",
            "us-gov-west-1",
            "us-gov-east-1",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "eu-west-3",
            "eu-north-1",
            "eu-south-1",
            "me-south-1",
            "me-central-1",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/s3/",
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/s3OneZoneInfrequentAccess/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "bulkImportEnabled": false,
        "serviceDefinitionUrlPath": "/data/s3OneZoneInfrequentAccess/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "s3onezoneinfrequentaccess"
        ],
        "parentServiceCode": "amazonSimpleStorageServiceGroup"
    },
    "amazonS3Standard": {
        "name": "S3 Standard",
        "serviceCode": "amazonS3Standard",
        "description": "Amazon Simple Storage Service (Amazon S3) is storage for the internet. You can use Amazon S3 to store and retrieve any amount of data at any time, from anywhere on the web.",
        "searchKeywords": [
            "Storage",
            "Simple Storage Service",
            "bucket",
            "file storage",
            "cloud storage",
            "static website hosting",
            "object storage",
            "store objects",
            "store files",
            "data migration",
            "ongoing data ingestion",
            "backup and recovery",
            "big data analytics",
            "nearline archive",
            "disaster recovery",
            "content distribution",
            "cloud storage",
            "S3",
            "s3"
        ],
        "type": "AWSService",
        "regions": [
            "af-south-1",
            "ap-east-1",
            "ap-south-1",
            "ap-northeast-3",
            "ap-northeast-2",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-southeast-3",
            "ap-northeast-1",
            "us-gov-west-1",
            "us-gov-east-1",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "eu-west-3",
            "eu-north-1",
            "eu-south-1",
            "me-south-1",
            "me-central-1",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/s3",
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonS3Standard/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "bulkImportEnabled": false,
        "serviceDefinitionUrlPath": "/data/amazonS3Standard/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "s3standard"
        ],
        "parentServiceCode": "amazonSimpleStorageServiceGroup"
    },
    "amazonS3StandardInfrequentAccess": {
        "name": "S3 Standard - Infrequent Access",
        "serviceCode": "amazonS3StandardInfrequentAccess",
        "description": "Amazon Simple Storage Service (Amazon S3) is storage for the internet. You can use Amazon S3 to store and retrieve any amount of data at any time, from anywhere on the web.",
        "searchKeywords": [
            "Storage",
            "Simple Storage Service",
            "bucket",
            "file storage",
            "cloud storage",
            "static website hosting",
            "object storage",
            "store objects",
            "store files",
            "data migration",
            "ongoing data ingestion",
            "backup and recovery",
            "big data analytics",
            "nearline archive",
            "disaster recovery",
            "content distribution",
            "cloud storage"
        ],
        "type": "AWSService",
        "regions": [
            "af-south-1",
            "ap-east-1",
            "ap-south-1",
            "ap-northeast-3",
            "ap-northeast-2",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-southeast-3",
            "ap-northeast-1",
            "us-gov-west-1",
            "us-gov-east-1",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "eu-west-3",
            "eu-north-1",
            "eu-south-1",
            "me-south-1",
            "me-central-1",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/s3/",
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonS3StandardInfrequentAccess/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "bulkImportEnabled": false,
        "serviceDefinitionUrlPath": "/data/amazonS3StandardInfrequentAccess/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "s3standardinfrequentaccess"
        ],
        "parentServiceCode": "amazonSimpleStorageServiceGroup"
    },
    "sageMakerAsynchronousInference": {
        "name": "SageMaker Asynchronous Inference",
        "serviceCode": "sageMakerAsynchronousInference",
        "description": "With Amazon SageMaker, you pay only for what you use. Building, training, and deploying ML models is billed by the second, with no minimum fees and no upfront commitments.",
        "searchKeywords": [
            "Sagemaker",
            "Model",
            "ML",
            "Machine Learning",
            "EI",
            "data scientist"
        ],
        "type": "AWSService",
        "regions": [
            "ap-east-1",
            "ap-south-1",
            "ap-northeast-2",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-northeast-1",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "eu-north-1",
            "me-south-1",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/sagemaker/",
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/sageMakerAsynchronousInference/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/sageMakerAsynchronousInference/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "sagemakerasynchronousinference"
        ],
        "parentServiceCode": "amazonSageMaker"
    },
    "sageMakerBatchTransform": {
        "name": "SageMaker Batch Transform",
        "serviceCode": "sageMakerBatchTransform",
        "description": "With Amazon SageMaker, you pay only for what you use. Building, training, and deploying ML models is billed by the second, with no minimum fees and no upfront commitments.",
        "searchKeywords": [
            "Sagemaker",
            "Model",
            "ML",
            "Machine Learning",
            "EI",
            "data scientist"
        ],
        "type": "AWSService",
        "regions": [
            "us-east-1",
            "eu-west-1",
            "us-west-1",
            "ap-southeast-1",
            "ap-northeast-1",
            "us-gov-west-1",
            "us-west-2",
            "sa-east-1",
            "ap-southeast-2",
            "eu-central-1",
            "ap-northeast-2",
            "ap-northeast-3",
            "ap-south-1",
            "us-east-2",
            "ca-central-1",
            "eu-west-2",
            "eu-west-3",
            "eu-north-1",
            "ap-east-1",
            "me-south-1",
            "eu-south-1",
            "af-south-1"
        ],
        "linkUrl": "https://aws.amazon.com/sagemaker/",
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/sageMakerBatchTransform/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/sageMakerBatchTransform/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "sagemakerbatchtransform"
        ],
        "parentServiceCode": "amazonSageMaker"
    },
    "sageMakerDataWrangler": {
        "name": "SageMaker Data Wrangler",
        "serviceCode": "sageMakerDataWrangler",
        "description": "With Amazon SageMaker, you pay only for what you use. Building, training, and deploying ML models is billed by the second, with no minimum fees and no upfront commitments.",
        "searchKeywords": [
            "Sagemaker",
            "Model",
            "ML",
            "Machine Learning",
            "EI",
            "data scientist"
        ],
        "type": "AWSService",
        "regions": [
            "af-south-1",
            "ap-east-1",
            "ap-south-1",
            "ap-northeast-2",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-northeast-1",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "eu-south-1",
            "eu-west-3",
            "eu-north-1",
            "me-south-1",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/sagemaker/",
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/sageMakerDataWrangler/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/sageMakerDataWrangler/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "sagemakerdatawrangler"
        ],
        "parentServiceCode": "amazonSageMaker"
    },
    "amazonSageMakerEdgeManager": {
        "name": "SageMaker Edge Manager",
        "serviceCode": "amazonSageMakerEdgeManager",
        "description": "Amazon SageMaker Edge Manager makes it easy for ML developers to optimize, secure, monitor, and maintain ML models on fleets of edge devices.",
        "searchKeywords": [
            "Sagemaker",
            "Model",
            "ML",
            "Machine Learning",
            "EI",
            "data scientist",
            "Edge Manager"
        ],
        "type": "AWSService",
        "regions": [
            "ap-northeast-1",
            "eu-central-1",
            "eu-west-1",
            "us-east-1",
            "us-east-2",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/sagemaker/edge-manager/pricing/",
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonSageMakerEdgeManager/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/amazonSageMakerEdgeManager/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "sagemakeredgemanager"
        ],
        "parentServiceCode": "amazonSageMaker"
    },
    "sageMakerFeatureStore": {
        "name": "SageMaker Feature Store",
        "serviceCode": "sageMakerFeatureStore",
        "description": "With Amazon SageMaker, you pay only for what you use. Building, training, and deploying ML models is billed by the second, with no minimum fees and no upfront commitments.",
        "searchKeywords": [
            "Sagemaker",
            "Model",
            "ML",
            "Machine Learning",
            "EI",
            "data scientist"
        ],
        "type": "AWSService",
        "regions": [
            "us-east-1",
            "eu-west-1",
            "us-west-1",
            "ap-southeast-1",
            "ap-northeast-1",
            "us-west-2",
            "sa-east-1",
            "ap-southeast-2",
            "eu-central-1",
            "ap-northeast-2",
            "ap-south-1",
            "us-east-2",
            "ca-central-1",
            "eu-west-2",
            "eu-west-3",
            "eu-north-1",
            "ap-east-1",
            "me-south-1",
            "eu-south-1",
            "af-south-1"
        ],
        "linkUrl": "https://aws.amazon.com/sagemaker/",
        "isActive": "true",
        "hasDataTransfer": true,
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/sageMakerFeatureStore/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/sageMakerFeatureStore/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "sagemakerfeaturestore"
        ],
        "parentServiceCode": "amazonSageMaker"
    },
    "sageMakerOnDemandNotebookInstances": {
        "name": "SageMaker On-Demand Notebook Instances",
        "serviceCode": "sageMakerOnDemandNotebookInstances",
        "description": "With Amazon SageMaker, you pay only for what you use. Building, training, and deploying ML models is billed by the second, with no minimum fees and no upfront commitments.",
        "searchKeywords": [
            "Sagemaker",
            "Model",
            "ML",
            "Machine Learning",
            "EI",
            "data scientist"
        ],
        "type": "AWSService",
        "regions": [
            "us-east-1",
            "eu-west-1",
            "us-west-1",
            "ap-southeast-1",
            "ap-northeast-1",
            "us-gov-west-1",
            "us-west-2",
            "sa-east-1",
            "ap-southeast-2",
            "eu-central-1",
            "ap-northeast-2",
            "ap-northeast-3",
            "ap-south-1",
            "us-east-2",
            "ca-central-1",
            "eu-west-2",
            "eu-west-3",
            "eu-north-1",
            "ap-east-1",
            "me-south-1",
            "eu-south-1",
            "af-south-1"
        ],
        "linkUrl": "https://aws.amazon.com/sagemaker/",
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/sageMakerOnDemandNotebookInstances/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/sageMakerOnDemandNotebookInstances/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "sagemakerdemandnotebookinstances",
            "sagemakerondemandnotebookinstances"
        ],
        "parentServiceCode": "amazonSageMaker"
    },
    "sageMakerProcessing": {
        "name": "SageMaker Processing",
        "serviceCode": "sageMakerProcessing",
        "description": "With Amazon SageMaker, you pay only for what you use. Building, training, and deploying ML models is billed by the second, with no minimum fees and no upfront commitments.",
        "searchKeywords": [
            "Sagemaker",
            "Model",
            "ML",
            "Machine Learning",
            "EI",
            "data scientist"
        ],
        "type": "AWSService",
        "regions": [
            "us-east-1",
            "eu-west-1",
            "us-west-1",
            "ap-southeast-1",
            "ap-northeast-1",
            "us-gov-west-1",
            "us-west-2",
            "sa-east-1",
            "ap-southeast-2",
            "eu-central-1",
            "ap-northeast-2",
            "ap-northeast-3",
            "ap-south-1",
            "us-east-2",
            "ca-central-1",
            "eu-west-2",
            "eu-west-3",
            "eu-north-1",
            "ap-east-1",
            "me-south-1",
            "eu-south-1",
            "af-south-1"
        ],
        "linkUrl": "https://aws.amazon.com/sagemaker/",
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/sageMakerProcessing/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/sageMakerProcessing/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "sagemakerprocessing"
        ],
        "parentServiceCode": "amazonSageMaker"
    },
    "sageMakerRealTimeInference": {
        "name": "SageMaker Real-Time Inference",
        "serviceCode": "sageMakerRealTimeInference",
        "description": "With Amazon SageMaker, you pay only for what you use. Building, training, and deploying ML models is billed by the second, with no minimum fees and no upfront commitments.",
        "searchKeywords": [
            "Sagemaker",
            "Model",
            "ML",
            "Machine Learning",
            "EI",
            "data scientist"
        ],
        "type": "AWSService",
        "regions": [
            "us-east-1",
            "eu-west-1",
            "us-west-1",
            "ap-southeast-1",
            "ap-northeast-1",
            "us-gov-west-1",
            "us-west-2",
            "sa-east-1",
            "ap-southeast-2",
            "eu-central-1",
            "ap-northeast-2",
            "ap-northeast-3",
            "ap-south-1",
            "us-east-2",
            "ca-central-1",
            "eu-west-2",
            "eu-west-3",
            "eu-north-1",
            "ap-east-1",
            "me-south-1",
            "eu-south-1",
            "af-south-1"
        ],
        "linkUrl": "https://aws.amazon.com/sagemaker/",
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/sageMakerRealTimeInference/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/sageMakerRealTimeInference/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "sagemakerrealtimeinference"
        ],
        "parentServiceCode": "amazonSageMaker"
    },
    "sageMakerServerlessInference": {
        "name": "SageMaker Serverless Inference",
        "serviceCode": "sageMakerServerlessInference",
        "description": "With Amazon SageMaker, you pay only for what you use. Building, training, and deploying ML models is billed by the second, with no minimum fees and no upfront commitments.",
        "searchKeywords": [
            "Sagemaker",
            "Model",
            "ML",
            "Machine Learning",
            "EI",
            "data scientist",
            "Serverless",
            "Serverless Inference"
        ],
        "type": "AWSService",
        "regions": [
            "af-south-1",
            "ap-east-1",
            "ap-northeast-1",
            "ap-northeast-2",
            "ap-northeast-3",
            "ap-south-1",
            "ap-southeast-1",
            "ap-southeast-2",
            "ca-central-1",
            "eu-central-1",
            "eu-north-1",
            "eu-south-1",
            "eu-west-1",
            "eu-west-2",
            "eu-west-3",
            "me-south-1",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/sagemaker/",
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/sageMakerServerlessInference/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/sageMakerServerlessInference/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "sagemakerserverlessinference"
        ],
        "parentServiceCode": "amazonSageMaker"
    },
    "sageMakerStudioNotebooks": {
        "name": "SageMaker Studio Notebooks",
        "serviceCode": "sageMakerStudioNotebooks",
        "description": "With Amazon SageMaker, you pay only for what you use. Building, training, and deploying ML models is billed by the second, with no minimum fees and no upfront commitments.",
        "searchKeywords": [
            "Sagemaker",
            "Model",
            "ML",
            "Machine Learning",
            "EI",
            "data scientist"
        ],
        "type": "AWSService",
        "regions": [
            "af-south-1",
            "ap-east-1",
            "ap-south-1",
            "ap-northeast-1",
            "ap-northeast-2",
            "ap-northeast-3",
            "ap-southeast-1",
            "ap-southeast-2",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "eu-south-1",
            "eu-west-3",
            "eu-north-1",
            "me-south-1",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/sagemaker/",
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/sageMakerStudioNotebooks/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/sageMakerStudioNotebooks/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "sagemakerstudionotebooks"
        ],
        "parentServiceCode": "amazonSageMaker"
    },
    "sageMakerTraining": {
        "name": "SageMaker Training",
        "serviceCode": "sageMakerTraining",
        "description": "With Amazon SageMaker, you pay only for what you use. Building, training, and deploying ML models is billed by the second, with no minimum fees and no upfront commitments.",
        "searchKeywords": [
            "Sagemaker",
            "Model",
            "ML",
            "Machine Learning",
            "EI",
            "data scientist"
        ],
        "type": "AWSService",
        "regions": [
            "us-east-1",
            "eu-west-1",
            "us-west-1",
            "ap-southeast-1",
            "ap-northeast-1",
            "us-gov-west-1",
            "us-west-2",
            "sa-east-1",
            "ap-southeast-2",
            "eu-central-1",
            "ap-northeast-2",
            "ap-northeast-3",
            "ap-south-1",
            "us-east-2",
            "ca-central-1",
            "eu-west-2",
            "eu-west-3",
            "eu-north-1",
            "ap-east-1",
            "me-south-1",
            "eu-south-1",
            "af-south-1"
        ],
        "linkUrl": "https://aws.amazon.com/sagemaker/",
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/sageMakerTraining/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/sageMakerTraining/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "sagemakertraining"
        ],
        "parentServiceCode": "amazonSageMaker"
    },
    "sentimentAnalysis": {
        "name": "Sentiment Analysis",
        "serviceCode": "sentimentAnalysis",
        "description": "With Amazon Comprehend, you only pay for what you use. You are charged based on the amount of text processed on a monthly basis. Amazon Comprehend provides natural language processing, topic modeling, and Custom Classification capabilities, enabling a broad range of applications that can analyze text.",
        "searchKeywords": [
            "Comprehend",
            "NLP",
            "Natural language processing",
            "Sentiment analysis",
            "Text analytics",
            "Entity extraction",
            "Named entity recognition",
            "NER",
            "Key phrase extraction",
            "Topic modeling",
            "Unsupervised clustering",
            "Supervised machine learning",
            "Custom entity recognition",
            "Custom classification",
            "Document classifier",
            "Personally identifiable information",
            "PII",
            "Redaction",
            "Language detection",
            "Free form text analytics"
        ],
        "type": "AWSService",
        "regions": [
            "us-gov-west-1",
            "ap-south-1",
            "ap-northeast-2",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-northeast-1",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "us-east-1",
            "us-east-2",
            "us-west-2"
        ],
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/sentimentAnalysis/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/sentimentAnalysis/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "sentimentanalysis"
        ],
        "parentServiceCode": "amazonComprehend"
    },
    "locationServiceServiceResources": {
        "name": "Service Resources",
        "serviceCode": "locationServiceServiceResources",
        "description": "Amazon Location Service provides affordable data, tracking and geofencing capabilities, and native integrations with AWS services, so you can create sophisticated location-enabled applications quickly, without the high cost of custom development.",
        "searchKeywords": [
            "Location Service",
            "compromising data security",
            "user privacy",
            "asset tracking",
            "location-based marketing",
            "maps",
            "places",
            "routing",
            "tracking",
            "geofencing",
            "Service Resources"
        ],
        "type": "AWSService",
        "regions": [
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-northeast-1",
            "eu-central-1",
            "eu-west-1",
            "eu-north-1",
            "us-east-1",
            "us-east-2",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/location/",
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/locationServiceServiceResources/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/locationServiceServiceResources/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "locationserviceserviceresources",
            "serviceresources"
        ],
        "parentServiceCode": "locationService"
    },
    "sipTrunking": {
        "name": "SIP Trunking",
        "serviceCode": "sipTrunking",
        "description": "Amazon Chime lets you meet, chat, and collaborate with the security of AWS. You can work seamlessly on your devices, and meet from your desk or on the go - ensuring you always stay connected.",
        "searchKeywords": [],
        "type": "AWSService",
        "regions": [
            "us-east-1",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/chime/chime-sdk",
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/sipTrunking/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/sipTrunking/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "siptrunking"
        ],
        "parentServiceCode": "amazonChimeSdk"
    },
    "snowballEdgeComputeOptimizedGpuWithEc2ComputeInstances": {
        "name": "Snowball Edge Compute Optimized GPU with EC2 Compute Instances",
        "serviceCode": "snowballEdgeComputeOptimizedGpuWithEc2ComputeInstances",
        "description": "AWS Snowball, a part of the AWS Snow Family, is an edge computing, data migration, and edge storage device that comes in two options.",
        "searchKeywords": [
            "Snow",
            "Snowball",
            "Snowball Edge",
            "Disconnected Data Transfer",
            "Edge Computing",
            "Data Export"
        ],
        "type": "AWSService",
        "regions": [
            "ap-east-1",
            "ap-south-1",
            "ap-northeast-3",
            "ap-northeast-2",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-northeast-1",
            "af-south-1",
            "us-gov-east-1",
            "us-gov-west-1",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "eu-south-1",
            "eu-west-3",
            "eu-north-1",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/snowball/",
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/snowballEdgeComputeOptimizedGpuWithEc2ComputeInstances/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/snowballEdgeComputeOptimizedGpuWithEc2ComputeInstances/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "snowballedgecomputeoptimizedgpuwithec2computeinstances"
        ],
        "parentServiceCode": "awsSnowball"
    },
    "snowballEdgeComputeOptimizedWithEc2ComputeInstances": {
        "name": "Snowball Edge Compute Optimized with EC2 Compute Instances",
        "serviceCode": "snowballEdgeComputeOptimizedWithEc2ComputeInstances",
        "description": "AWS Snowball, a part of the AWS Snow Family, is an edge computing, data migration, and edge storage device that comes in two options.",
        "searchKeywords": [
            "Snow",
            "Snowball",
            "Snowball Edge",
            "Disconnected Data Transfer",
            "Edge Computing",
            "Data Export"
        ],
        "type": "AWSService",
        "regions": [
            "ap-east-1",
            "ap-south-1",
            "ap-northeast-3",
            "ap-northeast-2",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-northeast-1",
            "af-south-1",
            "us-gov-east-1",
            "us-gov-west-1",
            "ca-central-1",
            "eu-west-1",
            "eu-west-2",
            "eu-south-1",
            "eu-west-3",
            "eu-north-1",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/snowball/",
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/snowballEdgeComputeOptimizedWithEc2ComputeInstances/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/snowballEdgeComputeOptimizedWithEc2ComputeInstances/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "snowballedgecomputeoptimizedwithec2computeinstances"
        ],
        "parentServiceCode": "awsSnowball"
    },
    "snowballEdgeStorageOptimizedDataTransferOnly": {
        "name": "Snowball Edge Storage Optimized Data Transfer Only",
        "serviceCode": "snowballEdgeStorageOptimizedDataTransferOnly",
        "description": "AWS Snowball, a part of the AWS Snow Family, is an edge computing, data migration, and edge storage device that comes in two options.",
        "searchKeywords": [
            "Snow",
            "Snowball",
            "Snowball Edge",
            "Disconnected Data Transfer",
            "Edge Computing",
            "Data Export"
        ],
        "type": "AWSService",
        "regions": [
            "ap-east-1",
            "ap-south-1",
            "ap-northeast-3",
            "ap-northeast-2",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-northeast-1",
            "af-south-1",
            "us-gov-east-1",
            "us-gov-west-1",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "eu-south-1",
            "eu-west-3",
            "eu-north-1",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/snowball/",
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/snowballEdgeStorageOptimizedDataTransferOnly/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/snowballEdgeStorageOptimizedDataTransferOnly/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "snowballedgestorageoptimizeddatatransferonly"
        ],
        "parentServiceCode": "awsSnowball"
    },
    "snowballEdgeStorageOptimizedWithEc2ComputeInstances": {
        "name": "Snowball Edge Storage Optimized with EC2 Compute Instances",
        "serviceCode": "snowballEdgeStorageOptimizedWithEc2ComputeInstances",
        "description": "AWS Snowball, a part of the AWS Snow Family, is an edge computing, data migration, and edge storage device that comes in two options.",
        "searchKeywords": [
            "Snow",
            "Snowball",
            "Snowball Edge",
            "Disconnected Data Transfer",
            "Edge Computing",
            "Data Export"
        ],
        "type": "AWSService",
        "regions": [
            "ap-east-1",
            "ap-south-1",
            "ap-northeast-3",
            "ap-northeast-2",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-northeast-1",
            "af-south-1",
            "us-gov-east-1",
            "us-gov-west-1",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "eu-south-1",
            "eu-west-3",
            "eu-north-1",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/snowball/",
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/snowballEdgeStorageOptimizedWithEc2ComputeInstances/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/snowballEdgeStorageOptimizedWithEc2ComputeInstances/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "snowballedgestorageoptimizedwithec2computeinstances"
        ],
        "parentServiceCode": "awsSnowball"
    },
    "standardBatchTranslation": {
        "name": "Standard Batch Translation",
        "serviceCode": "standardBatchTranslation",
        "description": "Amazon Translate is a neural machine translation service that delivers fast, high-quality, and affordable language translation. Neural machine translation is a form of language translation automation that uses deep learning models to deliver more accurate and more natural sounding translation than traditional statistical and rule-based translation algorithms.",
        "searchKeywords": [
            "NLP",
            "Natural language processing",
            "language transalation",
            "Text analytics",
            "Language translation",
            "Amazon translate",
            "Translate"
        ],
        "type": "AWSService",
        "regions": [
            "us-east-1",
            "eu-west-1",
            "us-west-2",
            "eu-central-1",
            "ap-northeast-2",
            "us-east-2",
            "eu-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/translate/",
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/standardBatchTranslation/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/standardBatchTranslation/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "standardbatchtranslation"
        ],
        "parentServiceCode": "amazonTranslate"
    },
    "standardRealTimeTranslation": {
        "name": "Standard Real-Time Translation",
        "serviceCode": "standardRealTimeTranslation",
        "description": "Amazon Translate is a neural machine translation service that delivers fast, high-quality, and affordable language translation. Neural machine translation is a form of language translation automation that uses deep learning models to deliver more accurate and more natural sounding translation than traditional statistical and rule-based translation algorithms.",
        "searchKeywords": [
            "NLP",
            "Natural language processing",
            "language transalation",
            "Text analytics",
            "Language translation",
            "Amazon translate",
            "Translate"
        ],
        "type": "AWSService",
        "regions": [
            "us-east-1",
            "eu-west-1",
            "us-west-1",
            "ap-southeast-1",
            "ap-northeast-1",
            "us-gov-west-1",
            "us-west-2",
            "ap-southeast-2",
            "eu-central-1",
            "ap-northeast-2",
            "ap-south-1",
            "us-east-2",
            "ca-central-1",
            "eu-west-2",
            "eu-west-3",
            "eu-north-1",
            "ap-east-1"
        ],
        "linkUrl": "https://aws.amazon.com/translate/",
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/standardRealTimeTranslation/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/standardRealTimeTranslation/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "standardrealtimetranslation"
        ],
        "parentServiceCode": "amazonTranslate"
    },
    "standardTextToSpeechTts": {
        "name": "Standard Text-to-Speech",
        "serviceCode": "standardTextToSpeechTts",
        "description": "Amazon Polly is a service that turns text into lifelike speech, allowing you to create applications that talk, and build entirely new categories of speech-enabled products.",
        "searchKeywords": [
            "polly",
            "NLP",
            "speech"
        ],
        "type": "AWSService",
        "regions": [
            "us-gov-west-1",
            "ap-east-1",
            "ap-south-1",
            "ap-northeast-2",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-northeast-1",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "eu-west-3",
            "eu-north-1",
            "me-south-1",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/polly/",
        "isActive": "true",
        "subType": "subService",
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/standardTextToSpeechTts/en_US.json",
        "c2e": false,
        "comparableTerms": [
            "standardtexttospeech",
            "standardtexttospeechtts"
        ],
        "parentServiceCode": "amazonPolly"
    },
    "standardTopics": {
        "name": "Standard topics",
        "serviceCode": "standardTopics",
        "description": "Amazon Simple Notification Service (SNS) is a highly available, durable, secure, fully managed pub/sub messaging service that enables you to decouple microservices, distributed systems, and serverless applications",
        "searchKeywords": [
            "Messaging",
            "SNS",
            "notification topic",
            "publish message",
            "subscription",
            "text message",
            "sms",
            "topics",
            "push notifications",
            "push notification service queuing"
        ],
        "type": "AWSService",
        "regions": [
            "af-south-1",
            "ap-east-1",
            "ap-northeast-1",
            "ap-northeast-2",
            "ap-northeast-3",
            "ap-south-1",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-southeast-3",
            "ca-central-1",
            "eu-central-1",
            "eu-north-1",
            "eu-south-1",
            "eu-west-1",
            "eu-west-2",
            "eu-west-3",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-gov-east-1",
            "us-gov-west-1",
            "us-west-1",
            "us-west-2",
            "me-south-1",
            "me-central-1"
        ],
        "linkUrl": "https://aws.amazon.com/sns/pricing/",
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/standardTopics/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/standardTopics/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "standardtopics"
        ],
        "parentServiceCode": "amazonSimpleNotificationService"
    },
    "stepFunctionExpress": {
        "name": "Step Functions - Express Workflows",
        "serviceCode": "stepFunctionExpress",
        "description": "AWS Step Functions is a serverless function orchestrator that makes it easy to sequence AWS Lambda functions and multiple AWS services into business-critical applications.",
        "searchKeywords": [
            "workflows",
            " workflow",
            " orchestrator",
            " orchestration",
            " serverless",
            " state machine",
            " State Machines",
            " States",
            " State",
            " Microservices",
            " application integration",
            " Amazon States Language",
            " ASL",
            " Data Science SDK",
            " data processing",
            " API orchestration",
            " DAG",
            " DAGs",
            " Step Functions",
            " Step Function",
            " Step",
            " media processing",
            " application orchestration",
            " serverless orchestration",
            " serverless workflow",
            " lambda orchestration",
            " serverless state machine",
            " asynchronous",
            " synchronous",
            " event-driven data processing",
            " event-driven",
            " event orchestration",
            " standard workflows",
            " standard workflow",
            " express workflow",
            " express workflows",
            " standard workflows",
            " error handling",
            " service integrations",
            " state management",
            " visual workflow",
            " visual monitoring",
            " high volume orchestration",
            " function",
            " functions",
            " machine learning workflow",
            " machine learning workflows",
            " JSON",
            " serverless workflows",
            " serverless workflow",
            " Business logic",
            " complex workflows",
            " data pipeline",
            " data processing",
            " decoupling",
            " decouple applications",
            " abstraction",
            " abstraction layer",
            " automation",
            " It automation",
            " connecting aws services",
            " integration of aws services",
            " coordinating AWS services",
            " managed workflows",
            " call back patterns",
            " callback pattern",
            " callback patterns",
            " call back pattern",
            " human approval",
            " manual approval",
            " human intervention",
            " EKS orchestration",
            " container orchestration",
            " short duration workflows",
            " long duration workflows",
            " short-duration workflows",
            " short-duration workflow",
            " long-running workflow",
            " long-running workflows",
            " machine-learning workflows",
            " ML workflows",
            " ML workflow",
            " API orchestration",
            " function",
            " functions",
            " compute function",
            " compute functions",
            " Lambda retry",
            " Lambda retries",
            " serverless compute",
            " parallel processing",
            " Lambda chaining",
            " error-handling",
            " retries",
            " saga pattern",
            " nested",
            " branching",
            " nesting",
            " nested pattern",
            " branching pattern",
            " nesting pattern",
            " serverless patterns",
            " event-driven patterns",
            " coordinating workflows"
        ],
        "type": "AWSService",
        "regions": [
            "us-gov-west-1",
            "us-gov-east-1",
            "af-south-1",
            "ap-east-1",
            "ap-south-1",
            "ap-northeast-2",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-southeast-3",
            "ap-northeast-1",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "eu-south-1",
            "eu-west-3",
            "eu-north-1",
            "me-south-1",
            "me-central-1",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2"
        ],
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/stepFunctionExpress/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/stepFunctionExpress/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "stepfunctionexpress",
            "stepfunctionsexpressworkflows"
        ],
        "parentServiceCode": "awsStepFunctions"
    },
    "stepFunctionStandard": {
        "name": "Step Functions - Standard Workflows",
        "serviceCode": "stepFunctionStandard",
        "description": "AWS Step Functions is a serverless function orchestrator that makes it easy to sequence AWS Lambda functions and multiple AWS services into business-critical applications.",
        "searchKeywords": [
            "workflows",
            " workflow",
            " orchestrator",
            " orchestration",
            " serverless",
            " state machine",
            " State Machines",
            " States",
            " State",
            " Microservices",
            " application integration",
            " Amazon States Language",
            " ASL",
            " Data Science SDK",
            " data processing",
            " API orchestration",
            " DAG",
            " DAGs",
            " Step Functions",
            " Step Function",
            " Step",
            " media processing",
            " application orchestration",
            " serverless orchestration",
            " serverless workflow",
            " lambda orchestration",
            " serverless state machine",
            " asynchronous",
            " synchronous",
            " event-driven data processing",
            " event-driven",
            " event orchestration",
            " standard workflows",
            " standard workflow",
            " express workflow",
            " express workflows",
            " standard workflows",
            " error handling",
            " service integrations",
            " state management",
            " visual workflow",
            " visual monitoring",
            " high volume orchestration",
            " function",
            " functions",
            " machine learning workflow",
            " machine learning workflows",
            " JSON",
            " serverless workflows",
            " serverless workflow",
            " Business logic",
            " complex workflows",
            " data pipeline",
            " data processing",
            " decoupling",
            " decouple applications",
            " abstraction",
            " abstraction layer",
            " automation",
            " It automation",
            " connecting aws services",
            " integration of aws services",
            " coordinating AWS services",
            " managed workflows",
            " call back patterns",
            " callback pattern",
            " callback patterns",
            " call back pattern",
            " human approval",
            " manual approval",
            " human intervention",
            " EKS orchestration",
            " container orchestration",
            " short duration workflows",
            " long duration workflows",
            " short-duration workflows",
            " short-duration workflow",
            " long-running workflow",
            " long-running workflows",
            " machine-learning workflows",
            " ML workflows",
            " ML workflow",
            " API orchestration",
            " function",
            " functions",
            " compute function",
            " compute functions",
            " Lambda retry",
            " Lambda retries",
            " serverless compute",
            " parallel processing",
            " Lambda chaining",
            " error-handling",
            " retries",
            " saga pattern",
            " nested",
            " branching",
            " nesting",
            " nested pattern",
            " branching pattern",
            " nesting pattern",
            " serverless patterns",
            " event-driven patterns",
            " coordinating workflows"
        ],
        "type": "AWSService",
        "regions": [
            "us-gov-west-1",
            "us-gov-east-1",
            "af-south-1",
            "ap-east-1",
            "ap-south-1",
            "ap-northeast-2",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-southeast-3",
            "ap-northeast-1",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "eu-south-1",
            "eu-west-3",
            "eu-north-1",
            "me-south-1",
            "me-central-1",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2"
        ],
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/stepFunctionStandard/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/stepFunctionStandard/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "stepfunctionsstandardworkflows",
            "stepfunctionstandard"
        ],
        "parentServiceCode": "awsStepFunctions"
    },
    "syntaxAnalysis": {
        "name": "Syntax Analysis",
        "serviceCode": "syntaxAnalysis",
        "description": "With Amazon Comprehend, you only pay for what you use. You are charged based on the amount of text processed on a monthly basis. Amazon Comprehend provides natural language processing, topic modeling, and Custom Classification capabilities, enabling a broad range of applications that can analyze text.",
        "searchKeywords": [
            "Comprehend",
            "NLP",
            "Natural language processing",
            "Sentiment analysis",
            "Text analytics",
            "Entity extraction",
            "Named entity recognition",
            "NER",
            "Key phrase extraction",
            "Topic modeling",
            "Unsupervised clustering",
            "Supervised machine learning",
            "Custom entity recognition",
            "Custom classification",
            "Document classifier",
            "Personally identifiable information",
            "PII",
            "Redaction",
            "Language detection",
            "Free form text analytics"
        ],
        "type": "AWSService",
        "regions": [
            "us-gov-west-1",
            "ap-south-1",
            "ap-northeast-2",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-northeast-1",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "us-east-1",
            "us-east-2",
            "us-west-2"
        ],
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/syntaxAnalysis/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/syntaxAnalysis/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "syntaxanalysis"
        ],
        "parentServiceCode": "amazonComprehend"
    },
    "targetedSentiment": {
        "name": "Targeted Sentiment",
        "serviceCode": "targetedSentiment",
        "description": "With Amazon Comprehend, you only pay for what you use. You are charged based on the amount of text processed on a monthly basis. Amazon Comprehend provides natural language processing, topic modeling, and Custom Classification capabilities, enabling a broad range of applications that can analyze text.",
        "searchKeywords": [
            "Comprehend",
            "NLP",
            "Natural language processing",
            "Sentiment analysis",
            "Text analytics",
            "Entity extraction",
            "Named entity recognition",
            "NER",
            "Key phrase extraction",
            "Topic modeling",
            "Unsupervised clustering",
            "Supervised machine learning",
            "Custom entity recognition",
            "Custom classification",
            "Document classifier",
            "Personally identifiable information",
            "PII",
            "Redaction",
            "Language detection",
            "Free form text analytics",
            "Targeted Sentiment"
        ],
        "type": "AWSService",
        "regions": [
            "us-gov-west-1",
            "ap-south-1",
            "ap-northeast-2",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-northeast-1",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "us-east-1",
            "us-east-2",
            "us-west-2"
        ],
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/targetedSentiment/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/targetedSentiment/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "targetedsentiment"
        ],
        "parentServiceCode": "amazonComprehend"
    },
    "comprehendTopicModeling": {
        "name": "Topic Modeling",
        "serviceCode": "comprehendTopicModeling",
        "description": "With Amazon Comprehend, you only pay for what you use. You are charged based on the amount of text processed on a monthly basis. Amazon Comprehend provides natural language processing, topic modeling, and Custom Classification capabilities, enabling a broad range of applications that can analyze text.",
        "searchKeywords": [
            "Comprehend",
            "NLP",
            "Natural language processing",
            "Sentiment analysis",
            "Text analytics",
            "Entity extraction",
            "Named entity recognition",
            "NER",
            "Key phrase extraction",
            "Topic modeling",
            "Unsupervised clustering",
            "Supervised machine learning",
            "Custom entity recognition",
            "Custom classification",
            "Document classifier",
            "Personally identifiable information",
            "PII",
            "Redaction",
            "Language detection",
            "Free form text analytics"
        ],
        "type": "AWSService",
        "regions": [
            "us-gov-west-1",
            "ap-south-1",
            "ap-northeast-2",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-northeast-1",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "us-east-1",
            "us-east-2",
            "us-west-2"
        ],
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/comprehendTopicModeling/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/comprehendTopicModeling/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "comprehendtopicmodeling",
            "topicmodeling"
        ],
        "parentServiceCode": "amazonComprehend"
    },
    "locationServiceTracking": {
        "name": "Tracking",
        "serviceCode": "locationServiceTracking",
        "description": "Amazon Location Service provides affordable data, tracking and geofencing capabilities, and native integrations with AWS services, so you can create sophisticated location-enabled applications quickly, without the high cost of custom development.",
        "searchKeywords": [
            "Location Service",
            "compromising data security",
            "user privacy",
            "asset tracking",
            "location-based marketing",
            "maps",
            "places",
            "routing",
            "tracking",
            "geofencing",
            "Service Resources"
        ],
        "type": "AWSService",
        "regions": [
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-northeast-1",
            "eu-central-1",
            "eu-west-1",
            "eu-north-1",
            "us-east-1",
            "us-east-2",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/location/",
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/locationServiceTracking/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/locationServiceTracking/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "locationservicetracking",
            "tracking"
        ],
        "parentServiceCode": "locationService"
    },
    "trafficMirroringVpc": {
        "name": "Traffic Mirroring",
        "serviceCode": "trafficMirroringVpc",
        "description": "WS Virtual Private Network solutions establish secure connections between your on-premises networks, remote offices, client devices, and the AWS global network. AWS VPN is comprised of two services: AWS Site-to-Site VPN and AWS Client VPN. Each service provides a highly-available, managed, and elastic cloud VPN solution to protect your network traffic.",
        "searchKeywords": [
            "access control",
            "ACL",
            "AWS Privatelink",
            "Cloud connectivity",
            "corporate network",
            "elastic IP",
            "Gateway load balancer",
            "home network VPN",
            "IPAM",
            "NAT",
            "NAT gateway",
            "Network Access Analyzer",
            "Network Address Translation",
            "Networking Content Delivery",
            "PrivateLink",
            "Reachability Analyzer",
            "security",
            "single tenant hardware",
            "static ip",
            "subnets",
            "Traffic mirroring",
            "Transit Gateway",
            "Virtual Private Cloud",
            "VPN"
        ],
        "type": "AWSService",
        "regions": [
            "ap-east-1",
            "ap-northeast-1",
            "ap-northeast-2",
            "ap-south-1",
            "ap-southeast-1",
            "ap-southeast-2",
            "ca-central-1",
            "eu-central-1",
            "eu-north-1",
            "eu-west-1",
            "eu-west-2",
            "eu-west-3",
            "me-south-1",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2",
            "us-gov-east-1",
            "us-gov-west-1"
        ],
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/trafficMirroringVpc/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/trafficMirroringVpc/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "trafficmirroring",
            "trafficmirroringvpc"
        ],
        "parentServiceCode": "amazonVirtualPrivateCloud"
    },
    "transitGatewayVpc": {
        "name": "Transit Gateway",
        "serviceCode": "transitGatewayVpc",
        "description": "AWS Transit Gateway connects VPCs and on-premises networks through a central hub. This simplifies your network and puts an end to complex peering relationships. It acts as a cloud router – each new connection is only made once.",
        "searchKeywords": [
            "Transit Gateway"
        ],
        "type": "AWSService",
        "regions": [
            "af-south-1",
            "ap-east-1",
            "ap-northeast-1",
            "ap-northeast-2",
            "ap-northeast-3",
            "ap-south-1",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-southeast-3",
            "ca-central-1",
            "eu-central-1",
            "eu-north-1",
            "eu-south-1",
            "eu-west-1",
            "eu-west-2",
            "eu-west-3",
            "me-south-1",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2",
            "us-gov-east-1",
            "us-gov-west-1"
        ],
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/transitGatewayVpc/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/transitGatewayVpc/en_US.json",
        "slug": "transitgatewayvpc",
        "mvpSupport": false,
        "comparableTerms": [
            "transitgateway",
            "transitgatewayvpc"
        ],
        "parentServiceCode": "amazonVirtualPrivateCloud"
    },
    "vpnConnectionVpc": {
        "name": "VPN Connection",
        "serviceCode": "vpnConnectionVpc",
        "description": "WS Virtual Private Network solutions establish secure connections between your on-premises networks, remote offices, client devices, and the AWS global network. AWS VPN is comprised of two services: AWS Site-to-Site VPN and AWS Client VPN. Each service provides a highly-available, managed, and elastic cloud VPN solution to protect your network traffic.",
        "searchKeywords": [
            "access control",
            "ACL",
            "AWS Privatelink",
            "Cloud connectivity",
            "corporate network",
            "elastic IP",
            "Gateway load balancer",
            "home network VPN",
            "IPAM",
            "NAT",
            "NAT gateway",
            "Network Access Analyzer",
            "Network Address Translation",
            "Networking Content Delivery",
            "PrivateLink",
            "Reachability Analyzer",
            "security",
            "single tenant hardware",
            "static ip",
            "subnets",
            "Traffic mirroring",
            "Transit Gateway",
            "Virtual Private Cloud",
            "VPN"
        ],
        "type": "AWSService",
        "regions": [
            "af-south-1",
            "ap-east-1",
            "ap-northeast-1",
            "ap-northeast-2",
            "ap-northeast-3",
            "ap-south-1",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-southeast-3",
            "ca-central-1",
            "eu-central-1",
            "eu-north-1",
            "eu-south-1",
            "eu-west-1",
            "eu-west-2",
            "eu-west-3",
            "me-south-1",
            "me-central-1",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2",
            "us-gov-east-1",
            "us-gov-west-1"
        ],
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/vpnConnectionVpc/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/vpnConnectionVpc/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "vpnconnection",
            "vpnconnectionvpc"
        ],
        "parentServiceCode": "amazonVirtualPrivateCloud"
    },
    "webRtcMedia": {
        "name": "WebRTC Media",
        "serviceCode": "webRtcMedia",
        "description": "Amazon Chime lets you meet, chat, and collaborate with the security of AWS. You can work seamlessly on your devices, and meet from your desk or on the go - ensuring you always stay connected.",
        "searchKeywords": [],
        "type": "AWSService",
        "regions": [
            "ap-southeast-1",
            "us-gov-east-1",
            "us-gov-west-1",
            "eu-central-1",
            "us-east-1",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/chime/chime-sdk",
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/webRtcMedia/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "bulkImportEnabled": false,
        "serviceDefinitionUrlPath": "/data/webRtcMedia/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "webrtcmedia"
        ],
        "parentServiceCode": "amazonChimeSdk"
    },
    "windowsWorkloads": {
        "name": "Windows Server and SQL Server on Amazon EC2",
        "serviceCode": "windowsWorkloads",
        "description": "The Windows Server and SQL Server on Amazon EC2 calculator provides a pricing estimate for specific workloads. It recommends suitable cloud deployment options and cost-saving pricing models based on licensing and infrastructure inputs.",
        "searchKeywords": [
            "EC2",
            "Windows",
            "SQL",
            "Microsoft",
            "Compute",
            "VM",
            "Database",
            "migration",
            "msft",
            "olap",
            "oltp",
            "Win",
            "DB",
            "MS",
            "DW",
            "Data Warehouse",
            "SSIS",
            "SSAS",
            "SSRS",
            "ODS"
        ],
        "type": "AWSService",
        "regions": [
            "af-south-1",
            "ap-east-1",
            "ap-northeast-1",
            "ap-northeast-2",
            "ap-northeast-3",
            "ap-south-1",
            "ap-southeast-1",
            "ap-southeast-2",
            "ca-central-1",
            "eu-central-1",
            "eu-north-1",
            "eu-south-1",
            "eu-west-1",
            "eu-west-2",
            "eu-west-3",
            "me-south-1",
            "sa-east-1",
            "us-east-1-bos-1",
            "us-east-1-iah-1",
            "us-east-1-mia-1",
            "us-east-1",
            "us-east-2",
            "us-gov-east-1",
            "us-gov-west-1",
            "us-west-1",
            "us-west-2",
            "us-west-2-lax-1",
            "us-east-1-wl1-atl1",
            "us-east-1-wl1-dfw1",
            "us-east-1-wl1-mia1",
            "us-east-1-wl1-nyc1",
            "us-east-1-wl1-was1",
            "us-west-2-wl1",
            "us-west-2-wl1-las1",
            "us-east-1-wl1"
        ],
        "linkUrl": "https://aws.amazon.com/windows/",
        "isActive": "true",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/windowsWorkloads/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "bulkImportEnabled": false,
        "serviceDefinitionUrlPath": "/data/windowsWorkloads/en_US.json",
        "slug": "EC2WinSQL",
        "mvpSupport": false,
        "comparableTerms": [
            "ec2winsql",
            "windows",
            "windowsserversqlserveronec2",
            "windowsworkloads"
        ]
    }
};
exports.PRICING_SLUGS = [
    "appmigrationsvc",
    "APIGateway",
    "Appflow",
    "AppStream",
    "Athena",
    "AuroraMySQL",
    "AuroraPostgreSQL",
    "Braket",
    "CarrierIP",
    "Chime",
    "ChimeSDK",
    "CloudFront",
    "CloudWatch",
    "CodeGuruReviewer",
    "CodeGuruReviewerv2",
    "Cognito",
    "Comprehend",
    "ComprehendMedical",
    "detective",
    "DevOpsGuru",
    "DocumentDB",
    "DynamoDB",
    "EC2",
    "EC2DedicatedHosts",
    "EKS",
    "EBS",
    "ECR",
    "EFS",
    "ElasticGraphics",
    "ElasticIP",
    "ElasticTranscoder",
    "ElastiCache",
    "EMR",
    "eventbridge",
    "filecache",
    "FinSpace",
    "forecast",
    "frauddetector",
    "FSxForLustre",
    "FSxForNetAppOntap",
    "FSxForOpenZFS",
    "FSx",
    "GameLift",
    "guardduty",
    "HealthLake",
    "Inspector",
    "Kendra",
    "KinesisDataAnalytics",
    "KinesisDataFirehose",
    "KinesisDataStreams",
    "KinesisVideoStreams",
    "lex",
    "Lightsail",
    "LookoutForMetrics",
    "LookoutVision",
    "Macie",
    "ManagedBlockchain",
    "Prometheus",
    "MSK",
    "MWAA",
    "memorydb",
    "MQ",
    "neptune",
    "OpenSearchService",
    "personalize",
    "Pinpoint",
    "polly",
    "QuickSight",
    "RDSCustomForOracle",
    "RDSCustomForSQLServer",
    "RDSMariaDB",
    "RDSMySQL",
    "amazonRDSOracle",
    "RDSPostgreSQL",
    "RDSSQLServer",
    "RDSOutposts",
    "Redshift",
    "Rekognition",
    "Route53",
    "S3Glacier",
    "SageMaker",
    "SageMakerGroundTruth",
    "SES",
    "SNS",
    "SQS",
    "S3",
    "SWF",
    "Textract",
    "Transcribe",
    "TranscribeMedical",
    "Translate",
    "VPC",
    "WorkDocs",
    "WorkMail",
    "WorkSpaces",
    "Amplify",
    "appSync",
    "budgets",
    "certificateManager",
    "CloudFormation",
    "CloudHSM",
    "CloudTrail",
    "CodeArtifact",
    "codebuild",
    "CodeDeploy",
    "CodePipeline",
    "Config",
    "cost-explorer",
    "datapipeline",
    "DataTransfer",
    "DMS",
    "DataSync",
    "DeepRacer",
    "DeviceFarm",
    "DirectConnect",
    "DirectoryService",
    "ElasticDisasterRecovery",
    "ElementalMediaTailor",
    "ElementalMediaConnect",
    "ElementalMediaLive",
    "ElementalMediaPackage",
    "Fargate",
    "Glue",
    "iot-analytics",
    "IoTCore",
    "IoTDeviceDefender",
    "IoTDeviceManagement",
    "iot-events",
    "greengrass",
    "IoTThingsGraph",
    "KMS",
    "LakeFormation",
    "Lambda",
    "LocationService",
    "mainframeModernization",
    "migration-hub",
    "networkfirewall",
    "Outposts",
    "SecretsManager",
    "securityHub",
    "shield",
    "Snowball",
    "Snowmobile",
    "StepFunctions",
    "StorageGateway",
    "SystemsManager",
    "TransferFamily",
    "WAF",
    "xray",
    "cloudwan",
    "ElasticLoadBalancing",
    "transitgatewayvpc",
    "EC2WinSQL"
];
//# sourceMappingURL=data:application/json;base64,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