export declare const PRICING_MANIFEST: {
    readonly awsApplicationMigrationSvc: {
        readonly name: " AWS Application Migration Service";
        readonly serviceCode: "awsApplicationMigrationSvc";
        readonly description: "AWS Application Migration Service minimizes time-intensive, error-prone manual processes by automatically converting your source servers from physical, virtual, and cloud infrastructure to run natively on AWS. It further simplifies your migration by allowing you to use the same automated process for a wide range of applications.";
        readonly searchKeywords: readonly ["Application Migration Service", "migrating applications", "migration", "SAP", "Oracle", "SQL Server", "CloudEndure Migration"];
        readonly type: "AWSService";
        readonly regions: readonly ["af-south-1", "ap-east-1", "ap-northeast-1", "ap-northeast-2", "ap-northeast-3", "ap-south-1", "ap-southeast-1", "ap-southeast-2", "ca-central-1", "eu-central-1", "eu-north-1", "eu-south-1", "eu-west-1", "eu-west-2", "eu-west-3", "me-south-1", "sa-east-1", "us-east-1", "us-east-2", "us-west-1", "us-west-2"];
        readonly linkUrl: "https://aws.amazon.com/application-migration-service/";
        readonly isActive: "true";
        readonly disableConfigure: false;
        readonly serviceDefinitionLocation: "https://d1qsjq9pzbk1k6.cloudfront.net/data/awsApplicationMigrationSvc/en_US.json";
        readonly c2e: false;
        readonly templates: readonly [];
        readonly disableRegionSupport: false;
        readonly serviceDefinitionUrlPath: "/data/awsApplicationMigrationSvc/en_US.json";
        readonly slug: "appmigrationsvc";
        readonly mvpSupport: false;
        readonly comparableTerms: readonly ["applicationmigration", "applicationmigrationservice", "applicationmigrationsvc", "appmigration", "appmigrationsvc"];
    };
    readonly activeCustomBatchTranslation: {
        readonly name: "Active Custom Batch Translation";
        readonly serviceCode: "activeCustomBatchTranslation";
        readonly description: "Amazon Translate is a neural machine translation service that delivers fast, high-quality, and affordable language translation. Neural machine translation is a form of language translation automation that uses deep learning models to deliver more accurate and more natural sounding translation than traditional statistical and rule-based translation algorithms.";
        readonly searchKeywords: readonly ["NLP", "Natural language processing", "language transalation", "Text analytics", "Language translation", "Amazon translate", "Translate"];
        readonly type: "AWSService";
        readonly regions: readonly ["us-east-1", "eu-west-1", "us-west-2"];
        readonly linkUrl: "https://aws.amazon.com/translate/";
        readonly isActive: "true";
        readonly subType: "subService";
        readonly disableConfigure: false;
        readonly serviceDefinitionLocation: "https://d1qsjq9pzbk1k6.cloudfront.net/data/activeCustomBatchTranslation/en_US.json";
        readonly c2e: false;
        readonly templates: readonly [];
        readonly disableRegionSupport: false;
        readonly serviceDefinitionUrlPath: "/data/activeCustomBatchTranslation/en_US.json";
        readonly mvpSupport: false;
        readonly comparableTerms: readonly ["activecustombatchtranslation"];
        readonly parentServiceCode: "amazonTranslate";
    };
    readonly amazonApiGateway: {
        readonly name: "Amazon API Gateway";
        readonly serviceCode: "amazonApiGateway";
        readonly description: "Amazon API Gateway is a fully managed service that makes it easy for developers to create, publish, maintain, monitor, and secure APIs at any scale. APIs act as the front door for applications to access data, business logic, or functionality from your backend services.";
        readonly searchKeywords: readonly ["API", "api", "Rest", "websocket", "messages"];
        readonly type: "AWSService";
        readonly regions: readonly ["us-gov-west-1", "us-gov-east-1", "af-south-1", "ap-east-1", "ap-south-1", "ap-northeast-2", "ap-northeast-3", "ap-southeast-1", "ap-southeast-2", "ap-southeast-3", "ap-northeast-1", "ca-central-1", "eu-central-1", "eu-west-1", "eu-west-2", "eu-south-1", "eu-west-3", "eu-north-1", "me-south-1", "me-central-1", "sa-east-1", "us-east-1", "us-east-2", "us-west-1", "us-west-2"];
        readonly linkUrl: "https://aws.amazon.com/api-gateway/";
        readonly isActive: "true";
        readonly disableConfigure: false;
        readonly serviceDefinitionLocation: "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonApiGateway/en_US.json";
        readonly c2e: false;
        readonly templates: readonly [];
        readonly disableRegionSupport: false;
        readonly slug: "APIGateway";
        readonly mvpSupport: false;
        readonly comparableTerms: readonly ["apigateway"];
    };
    readonly amazonAppFlow: {
        readonly name: "Amazon AppFlow";
        readonly serviceCode: "amazonAppFlow";
        readonly description: "Amazon AppFlow offers significant cost-savings advantage compared to building connectors in-house or using other application integration services. There are no upfront charges or fees to use AppFlow, and customers only pay for the number of flows they run and the volume of data processed.";
        readonly searchKeywords: readonly ["appflow", "Amazon AppFlow", "App Flow", "AWS appflow"];
        readonly type: "AWSService";
        readonly regions: readonly ["ap-south-1", "af-south-1", "ap-northeast-2", "ap-southeast-1", "ap-southeast-2", "ap-northeast-1", "ca-central-1", "eu-central-1", "eu-west-1", "eu-west-2", "eu-west-3", "sa-east-1", "us-east-1", "us-east-2", "us-west-1", "us-west-2"];
        readonly linkUrl: "https://aws.amazon.com/appflow/";
        readonly isActive: "true";
        readonly serviceDefinitionLocation: "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonAppFlow/en_US.json";
        readonly c2e: false;
        readonly slug: "Appflow";
        readonly mvpSupport: false;
        readonly comparableTerms: readonly ["appflow"];
    };
    readonly amazonAppStream: {
        readonly name: "Amazon AppStream 2.0";
        readonly serviceCode: "amazonAppStream";
        readonly description: "Amazon AppStream 2.0 is a fully managed service that provides secure, reliable, and scalable access to applications and non-persistent desktops from any location.";
        readonly searchKeywords: readonly ["streaming", "app"];
        readonly type: "AWSService";
        readonly regions: readonly ["us-east-1", "us-east-2", "ap-south-1", "us-west-2", "us-gov-west-1", "ap-southeast-2", "eu-west-1", "ap-northeast-2", "eu-central-1", "ap-northeast-1", "eu-west-2", "ap-southeast-1", "ca-central-1"];
        readonly linkUrl: "https://aws.amazon.com/appstream2/";
        readonly isActive: "true";
        readonly disableConfigure: false;
        readonly serviceDefinitionLocation: "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonAppStream/en_US.json";
        readonly c2e: false;
        readonly templates: readonly [];
        readonly disableRegionSupport: false;
        readonly bulkImportEnabled: false;
        readonly serviceDefinitionUrlPath: "/data/amazonAppStream/en_US.json";
        readonly slug: "AppStream";
        readonly mvpSupport: false;
        readonly comparableTerms: readonly ["appstream", "appstream2", "appstream20"];
    };
    readonly amazonAthena: {
        readonly name: "Amazon Athena";
        readonly serviceCode: "amazonAthena";
        readonly description: "Amazon Athena is an interactive query service that makes it easy to analyze data in Amazon S3 using standard SQL. Athena is serverless, so there is no infrastructure to manage, and you pay only for the queries that you run.";
        readonly searchKeywords: readonly ["Analytics", "SQL", "query", "S3", "big data", "Presto", "serverless", "ad-hoc analysis", "log processing", "bigquery", "big query", "query S3 data"];
        readonly type: "AWSService";
        readonly regions: readonly ["af-south-1", "ap-east-1", "ap-south-1", "ap-northeast-2", "ap-northeast-3", "ap-southeast-1", "ap-southeast-2", "ap-northeast-1", "ca-central-1", "eu-central-1", "eu-west-1", "eu-west-2", "eu-west-3", "eu-north-1", "eu-south-1", "me-south-1", "us-gov-west-1", "us-gov-east-1", "us-east-1", "us-east-2", "us-west-1", "us-west-2", "sa-east-1"];
        readonly linkUrl: "https://aws.amazon.com/athena/";
        readonly isActive: "true";
        readonly disableConfigure: false;
        readonly serviceDefinitionLocation: "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonAthena/en_US.json";
        readonly c2e: false;
        readonly slug: "Athena";
        readonly mvpSupport: false;
        readonly comparableTerms: readonly ["athena"];
    };
    readonly amazonAuroraMySQLCompatible: {
        readonly name: "Amazon Aurora MySQL-Compatible";
        readonly serviceCode: "amazonAuroraMySQLCompatible";
        readonly description: "Amazon Aurora MySQL Compatible relational database is built for the cloud, that combines  performance and availability of traditional enterprise databases with the simplicity and cost-effectiveness of open source databases.";
        readonly searchKeywords: readonly ["Database", "Aurora", "MySQL", "MariaDB", "Postgres", "Oracle", "SQL Server", "Database", "PostgreSQL", "Microsoft SQL Server", "Relational Database Service", "Database", "database hosting", "hosted database", "Managed database"];
        readonly type: "AWSService";
        readonly regions: readonly ["af-south-1", "ap-east-1", "ap-northeast-1", "ap-northeast-2", "ap-northeast-3", "ap-south-1", "ap-southeast-1", "ap-southeast-2", "ap-southeast-3", "ca-central-1", "eu-central-1", "eu-north-1", "eu-south-1", "eu-west-1", "eu-west-2", "eu-west-3", "me-south-1", "me-central-1", "sa-east-1", "us-east-1", "us-east-2", "us-west-1", "us-west-2", "us-gov-east-1", "us-gov-west-1"];
        readonly linkUrl: "https://aws.amazon.com/rds/aurora/";
        readonly isActive: "true";
        readonly disableConfigure: false;
        readonly serviceDefinitionLocation: "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonAuroraMySQLCompatible/en_US.json";
        readonly c2e: false;
        readonly templates: readonly [];
        readonly disableRegionSupport: false;
        readonly bulkImportEnabled: false;
        readonly serviceDefinitionUrlPath: "/data/amazonAuroraMySQLCompatible/en_US.json";
        readonly slug: "AuroraMySQL";
        readonly mvpSupport: false;
        readonly comparableTerms: readonly ["auroramysql", "auroramysqlcompatible", "rdsaurora"];
    };
    readonly amazonRDSAuroraPostgreSQLCompatibleDB: {
        readonly name: "Amazon Aurora PostgreSQL-Compatible DB";
        readonly serviceCode: "amazonRDSAuroraPostgreSQLCompatibleDB";
        readonly description: "Amazon Aurora is a MySQL and PostgreSQL-compatible relational database built for the cloud, that combines the performance and availability of traditional enterprise databases with the simplicity and cost-effectiveness of open source databases.";
        readonly searchKeywords: readonly ["Database", "PostgreSQL", "Aurora", "database hosting", "hosted database", "Managed database"];
        readonly type: "AWSService";
        readonly regions: readonly ["af-south-1", "ap-east-1", "ap-northeast-1", "ap-northeast-2", "ap-northeast-3", "ap-south-1", "ap-southeast-1", "ap-southeast-2", "ap-southeast-3", "ca-central-1", "eu-central-1", "eu-north-1", "eu-south-1", "eu-west-1", "eu-west-2", "eu-west-3", "me-south-1", "me-central-1", "sa-east-1", "us-east-1", "us-east-2", "us-west-1", "us-west-2", "us-gov-east-1", "us-gov-west-1"];
        readonly linkUrl: "https://aws.amazon.com/aurora/";
        readonly isActive: "true";
        readonly hasDataTransfer: false;
        readonly disableConfigure: false;
        readonly serviceDefinitionLocation: "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonRDSAuroraPostgreSQLCompatibleDB/en_US.json";
        readonly c2e: false;
        readonly templates: readonly [];
        readonly disableRegionSupport: false;
        readonly bulkImportEnabled: false;
        readonly serviceDefinitionUrlPath: "/data/amazonRDSAuroraPostgreSQLCompatibleDB/en_US.json";
        readonly slug: "AuroraPostgreSQL";
        readonly mvpSupport: false;
        readonly comparableTerms: readonly ["aurora", "aurorapostgresql", "aurorapostgresqlcompatibledb", "rdsaurorapostgresqlcompatibledb"];
    };
    readonly amazonBraket: {
        readonly name: "Amazon Braket";
        readonly serviceCode: "amazonBraket";
        readonly description: "Amazon Braket is a fully managed quantum computing service that helps researchers and developers get started with the technology to accelerate research and discovery. Amazon Braket provides a development environment for you to explore and build quantum algorithms, test them on quantum circuit simulators, and run them on different quantum hardware technologies.";
        readonly searchKeywords: readonly ["quantum", "compute", "computing", "simulators", "algorithms", "Sagemaker", "notebooks"];
        readonly type: "AWSService";
        readonly regions: readonly ["us-east-1", "us-west-1", "us-west-2", "eu-west-2"];
        readonly linkUrl: "https://aws.amazon.com/braket/";
        readonly isActive: "true";
        readonly disableConfigure: false;
        readonly serviceDefinitionLocation: "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonBraket/en_US.json";
        readonly c2e: false;
        readonly templates: readonly [];
        readonly disableRegionSupport: false;
        readonly bulkImportEnabled: false;
        readonly serviceDefinitionUrlPath: "/data/amazonBraket/en_US.json";
        readonly slug: "Braket";
        readonly mvpSupport: false;
        readonly comparableTerms: readonly ["braket"];
    };
    readonly amazonCarrierIp: {
        readonly name: "Amazon Carrier IP";
        readonly serviceCode: "amazonCarrierIp";
        readonly description: "A Carrier IP address is the address that you assign to a network interface, which resides in a subnet in a Wavelength Zone (for example an EC2 instance)";
        readonly searchKeywords: readonly ["Compute", "Carrier", "Elastic Compute Cloud", "spot instance", "load balancing", "elb", "elastic load balancer", "auto scaling", "auto scaling groups", "application load balancer", "ALB", "spot requests", "reserved instances", "scheduled instances", "dedicated hosts", "AMIs", "CIPs", "Bundle tasks", "Volumes", "Snapshots", "Images", "Elastic Block Store", "block storage", "Security groups", "Elastic IP", "placement groups", "key pairs", "network interfaces", "load balancers", "target groups", "auto scaler", "launch configurations", "EBS", "ASG", "commands", "command history", "managed instances", "activations"];
        readonly type: "AWSService";
        readonly regions: readonly ["ap-northeast-1-wl1-kix1", "ap-northeast-1-wl1-nrt1", "ap-northeast-2-wl1-cjj1", "ap-northeast-2-wl1-sel1", "ca-central-1-wl1-yto1", "eu-west-2-wl1-lon1", "eu-central-1-wl1-ber1", "eu-central-1-wl1-dtm1", "eu-central-1-wl1-muc1", "us-east-1-wl1", "us-east-1-wl1-atl1", "us-east-1-wl1-clt1", "us-east-1-wl1-chi1", "us-east-1-wl1-dfw1", "us-east-1-wl1-dtw1", "us-east-1-wl1-iah1", "us-east-1-wl1-mia1", "us-east-1-wl1-msp1", "us-east-1-wl1-bna1", "us-east-1-wl1-nyc1", "us-east-1-wl1-tpa1", "us-east-1-wl1-was1", "us-west-2-wl1-den1", "us-west-2-wl1-las1", "us-west-2-wl1-lax1", "us-west-2-wl1-phx1", "us-west-2-wl1-sea1", "us-west-2-wl1"];
        readonly linkUrl: "https://aws.amazon.com/ec2/pricing/on-demand/";
        readonly isActive: "true";
        readonly serviceDefinitionLocation: "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonCarrierIp/en_US.json";
        readonly c2e: false;
        readonly slug: "CarrierIP";
        readonly mvpSupport: false;
        readonly comparableTerms: readonly ["carrierip"];
    };
    readonly amazonChime: {
        readonly name: "Amazon Chime";
        readonly serviceCode: "amazonChime";
        readonly description: "Amazon Chime is a communications service that lets you meet, chat, and place business calls inside and outside your organization, all using a single application.";
        readonly searchKeywords: readonly ["Chime", "Business Calling"];
        readonly type: "AWSService";
        readonly regions: readonly [];
        readonly linkUrl: "https://aws.amazon.com/chime/";
        readonly isActive: "true";
        readonly subType: "subServiceSelector";
        readonly disableConfigure: false;
        readonly serviceDefinitionLocation: "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonChime/en_US.json";
        readonly c2e: false;
        readonly templates: readonly ["chimeCostAnalysis", "chimeBusinessCallingAnalysis"];
        readonly disableRegionSupport: false;
        readonly serviceDefinitionUrlPath: "/data/amazonChime/en_US.json";
        readonly slug: "Chime";
        readonly mvpSupport: false;
        readonly comparableTerms: readonly ["chime"];
    };
    readonly chimeBusinessCallingAnalysis: {
        readonly name: "Amazon Chime Business Calling analysis";
        readonly serviceCode: "chimeBusinessCallingAnalysis";
        readonly description: "Amazon Chime lets you meet, chat, and collaborate with the security of AWS. You can work seamlessly on your devices, and meet from your desk or on the go - ensuring you always stay connected.";
        readonly searchKeywords: readonly [];
        readonly type: "AWSService";
        readonly regions: readonly ["us-east-1"];
        readonly linkUrl: "https://aws.amazon.com/chime/";
        readonly isActive: "true";
        readonly subType: "subService";
        readonly disableConfigure: false;
        readonly serviceDefinitionLocation: "https://d1qsjq9pzbk1k6.cloudfront.net/data/chimeBusinessCallingAnalysis/en_US.json";
        readonly c2e: false;
        readonly templates: readonly [];
        readonly disableRegionSupport: false;
        readonly serviceDefinitionUrlPath: "/data/chimeBusinessCallingAnalysis/en_US.json";
        readonly mvpSupport: false;
        readonly comparableTerms: readonly ["chimebusinesscallinganalysis"];
        readonly parentServiceCode: "amazonChime";
    };
    readonly amazonChimeTCO: {
        readonly name: "Amazon Chime cost comparison tool";
        readonly serviceCode: "amazonChimeTCO";
        readonly description: "Amazon Chime lets you meet, chat, and collaborate with the security of AWS. You can work seamlessly on your devices, and meet from your desk or on the go - ensuring you always stay connected.";
        readonly searchKeywords: readonly [];
        readonly type: "AWSService";
        readonly regions: readonly ["us-east-1"];
        readonly linkUrl: "https://aws.amazon.com/chime/";
        readonly isActive: "true";
        readonly subType: "TCOCalculator";
        readonly serviceDefinitionLocation: "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonChimeTCO/en_US.json";
        readonly c2e: false;
        readonly comparableTerms: readonly ["chime", "chimecostcomparisontool", "chimetco"];
    };
    readonly chimeCostAnalysis: {
        readonly name: "Amazon Chime Meetings App";
        readonly serviceCode: "chimeCostAnalysis";
        readonly description: "Amazon Chime lets you meet, chat, and collaborate with the security of AWS. You can work seamlessly on your devices, and meet from your desk or on the go - ensuring you always stay connected.";
        readonly searchKeywords: readonly [];
        readonly type: "AWSService";
        readonly regions: readonly ["us-east-1"];
        readonly linkUrl: "https://aws.amazon.com/chime/";
        readonly isActive: "true";
        readonly subType: "subService";
        readonly disableConfigure: false;
        readonly serviceDefinitionLocation: "https://d1qsjq9pzbk1k6.cloudfront.net/data/chimeCostAnalysis/en_US.json";
        readonly c2e: false;
        readonly templates: readonly [];
        readonly disableRegionSupport: false;
        readonly serviceDefinitionUrlPath: "/data/chimeCostAnalysis/en_US.json";
        readonly mvpSupport: false;
        readonly comparableTerms: readonly ["chimecostanalysis", "chimemeetingsapp"];
        readonly parentServiceCode: "amazonChime";
    };
    readonly amazonChimeSdk: {
        readonly name: "Amazon Chime SDK";
        readonly serviceCode: "amazonChimeSdk";
        readonly description: "With the Amazon Chime SDK, builders can easily add real-time voice, video, and messaging powered by machine learning into their applications.";
        readonly searchKeywords: readonly ["Chimesdk", "messaging", "SIP trunking", "webrtc media", "proxy phone session"];
        readonly type: "AWSService";
        readonly regions: readonly [];
        readonly linkUrl: "https://aws.amazon.com/chime/chime-sdk/";
        readonly isActive: "true";
        readonly subType: "subServiceSelector";
        readonly disableConfigure: false;
        readonly serviceDefinitionLocation: "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonChimeSdk/en_US.json";
        readonly c2e: false;
        readonly templates: readonly ["webRtcMedia", "ptsnAudio", "sipTrunking", "chimeSdkMessaging", "proxyPhoneSession"];
        readonly disableRegionSupport: false;
        readonly serviceDefinitionUrlPath: "/data/amazonChimeSdk/en_US.json";
        readonly slug: "ChimeSDK";
        readonly mvpSupport: false;
        readonly comparableTerms: readonly ["chimechimesdk", "chimesdk"];
    };
    readonly amazonCloudFront: {
        readonly name: "Amazon CloudFront";
        readonly serviceCode: "amazonCloudFront";
        readonly description: "Amazon CloudFront is a fast content delivery network (CDN) service that securely delivers data, videos, applications, and APIs to customers globally with low latency, high transfer speeds, all within a developer-friendly environment.";
        readonly searchKeywords: readonly ["cloudfront", "CDN"];
        readonly type: "AWSService";
        readonly regions: readonly ["ap-east-1", "ap-northeast-1", "ap-northeast-2", "ap-south-1", "ap-southeast-1", "ap-southeast-2", "ca-central-1", "eu-central-1", "eu-north-1", "eu-west-1", "eu-west-2", "eu-west-3", "me-south-1", "sa-east-1", "us-east-1", "us-east-2", "us-gov-east-1", "us-gov-west-1", "us-west-1", "us-west-2"];
        readonly linkUrl: "https://aws.amazon.com/cloudfront/";
        readonly isActive: "true";
        readonly serviceDefinitionLocation: "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonCloudFront/en_US.json";
        readonly c2e: false;
        readonly slug: "CloudFront";
        readonly mvpSupport: false;
        readonly comparableTerms: readonly ["cloudfront"];
    };
    readonly amazonCloudWatch: {
        readonly name: "Amazon CloudWatch";
        readonly serviceCode: "amazonCloudWatch";
        readonly description: "Amazon CloudWatch is a monitoring and management service that provides data and actionable insights for AWS, hybrid, and on-premises applications and infrastructure resources.";
        readonly searchKeywords: readonly ["Management Tools", "CW", "monitoring", "metrics", "graphs", "logs", "dashboard", "events", "alarms", "monitoring scripts", "management tools", "monitoring service", "network monitoring"];
        readonly type: "AWSService";
        readonly regions: readonly ["af-south-1", "ap-east-1", "ap-south-1", "ap-northeast-3", "ap-northeast-2", "ap-southeast-1", "ap-southeast-2", "ap-southeast-3", "ap-northeast-1", "us-gov-west-1", "us-gov-east-1", "ca-central-1", "eu-central-1", "eu-west-1", "eu-west-2", "eu-west-3", "eu-north-1", "eu-south-1", "me-south-1", "me-central-1", "sa-east-1", "us-east-1", "us-east-2", "us-west-1", "us-west-2"];
        readonly linkUrl: "https://aws.amazon.com/cloudwatch/";
        readonly isActive: "true";
        readonly disableConfigure: false;
        readonly serviceDefinitionLocation: "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonCloudWatch/en_US.json";
        readonly c2e: false;
        readonly templates: readonly [];
        readonly disableRegionSupport: false;
        readonly slug: "CloudWatch";
        readonly mvpSupport: false;
        readonly comparableTerms: readonly ["cloudwatch"];
    };
    readonly amazonCodeGuru: {
        readonly name: "Amazon CodeGuru Reviewer";
        readonly serviceCode: "amazonCodeGuru";
        readonly description: "Amazon CodeGuru Reviewer is a service that uses program analysis and machine learning to detect potential defects that are difficult for developers to find and recommends fixes in your Java code.";
        readonly searchKeywords: readonly ["CodeGuru", "Reviewer", "code reviews", "package scan", "pull request", "code analysis", "code quality"];
        readonly type: "AWSService";
        readonly regions: readonly ["ap-northeast-1", "ap-southeast-1", "ap-southeast-2", "eu-central-1", "eu-north-1", "eu-west-1", "eu-west-2", "us-east-1", "us-east-2", "us-west-2"];
        readonly linkUrl: "https://aws.amazon.com/codeguru/";
        readonly isActive: "true";
        readonly serviceDefinitionLocation: "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonCodeGuru/en_US.json";
        readonly c2e: false;
        readonly slug: "CodeGuruReviewer";
        readonly comparableTerms: readonly ["codeguru", "codegurureviewer"];
    };
    readonly codeGuruReviewer: {
        readonly name: "Amazon CodeGuru Reviewer Test";
        readonly serviceCode: "codeGuruReviewer";
        readonly description: "Amazon CodeGuru Reviewer is a service that uses program analysis and machine learning to detect potential defects that are difficult for developers to find and recommends fixes in your Java code.";
        readonly searchKeywords: readonly ["CodeGuru", "Reviewer", "code reviews", "package scan", "pull request", "code analysis", "code quality"];
        readonly type: "AWSService";
        readonly regions: readonly ["us-east-1", "us-east-2", "us-west-2", "eu-west-1", "ap-southeast-2"];
        readonly linkUrl: "https://docs.aws.amazon.com/codeguru/index.html";
        readonly isActive: "false";
        readonly serviceDefinitionLocation: "https://d1qsjq9pzbk1k6.cloudfront.net/data/codeGuruReviewer/en_US.json";
        readonly c2e: false;
        readonly slug: "CodeGuruReviewerv2";
        readonly comparableTerms: readonly ["codeguru", "codegurureviewer", "codegurureviewertest"];
    };
    readonly amazonCognito: {
        readonly name: "Amazon Cognito";
        readonly serviceCode: "amazonCognito";
        readonly description: "Amazon Cognito lets you add user sign-up, sign-in, and access control to your web and mobile apps quickly and easily. Amazon Cognito scales to millions of users and supports sign-in with social identity providers, such as Facebook, Google, and Amazon, and enterprise identity providers via SAML 2.0.";
        readonly searchKeywords: readonly ["apps", "security", "access", "control", "cognito", "MAU", "SMAL", "OIDC"];
        readonly type: "AWSService";
        readonly regions: readonly ["us-east-1", "us-east-2", "us-west-1", "us-west-2", "ap-south-1", "ap-northeast-2", "ap-southeast-1", "ap-southeast-2", "ap-northeast-1", "ca-central-1", "eu-central-1", "eu-west-1", "eu-west-2", "eu-west-3", "me-south-1", "eu-north-1", "sa-east-1", "us-gov-west-1"];
        readonly linkUrl: "https://aws.amazon.com/cognito/";
        readonly isActive: "true";
        readonly serviceDefinitionLocation: "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonCognito/en_US.json";
        readonly c2e: false;
        readonly slug: "Cognito";
        readonly mvpSupport: false;
        readonly comparableTerms: readonly ["cognito"];
    };
    readonly amazonComprehend: {
        readonly name: "Amazon Comprehend";
        readonly serviceCode: "amazonComprehend";
        readonly description: "With Amazon Comprehend, you only pay for what you use. You are charged based on the amount of text processed on a monthly basis. Amazon Comprehend provides natural language processing, topic modeling, and Custom Classification capabilities, enabling a broad range of applications that can analyze text.";
        readonly searchKeywords: readonly ["Comprehend", "NLP", "Natural language processing", "Sentiment analysis", "Text analytics", "Entity extraction", "Named entity recognition", "NER", "Key phrase extraction", "Topic modeling", "Unsupervised clustering", "Supervised machine learning", "Custom entity recognition", "Custom classification", "Document classifier", "Personally identifiable information", "PII", "Redaction", "Language detection", "Free form text analytics"];
        readonly type: "AWSService";
        readonly regions: readonly [];
        readonly linkUrl: "https://aws.amazon.com/comprehend";
        readonly isActive: "true";
        readonly subType: "subServiceSelector";
        readonly disableConfigure: false;
        readonly serviceDefinitionLocation: "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonComprehend/en_US.json";
        readonly c2e: false;
        readonly templates: readonly ["piiDetection", "containsPii", "entityRecognition", "sentimentAnalysis", "targetedSentiment", "comprehendCustomClassification", "comprehendCustomEntities", "keyPhraseExtraction", "languageDetection", "syntaxAnalysis", "comprehendTopicModeling", "eventDetectionPerEventType"];
        readonly disableRegionSupport: false;
        readonly serviceDefinitionUrlPath: "/data/amazonComprehend/en_US.json";
        readonly slug: "Comprehend";
        readonly mvpSupport: false;
        readonly comparableTerms: readonly ["comprehend"];
    };
    readonly amazonComprehendMedical: {
        readonly name: "Amazon Comprehend Medical";
        readonly serviceCode: "amazonComprehendMedical";
        readonly description: "Amazon Comprehend Medical is a HIPAA-eligible natural language processing (NLP) service that uses machine learning to extract health data from medical text–no machine learning experience is required.";
        readonly searchKeywords: readonly ["Comprehend Medical", "NLP", "Natural language processing"];
        readonly type: "AWSService";
        readonly regions: readonly [];
        readonly linkUrl: "https://aws.amazon.com/comprehend/medical/";
        readonly isActive: "true";
        readonly subType: "subServiceSelector";
        readonly disableConfigure: false;
        readonly serviceDefinitionLocation: "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonComprehendMedical/en_US.json";
        readonly c2e: false;
        readonly templates: readonly ["medicalNamedEntityAndRelationshipExtractionNeReApi", "medicalProtectedHealthInformationDataExtractionAndIdentificationPhIdApi", "medicalIcd10CmOntologyLinkingApi", "medicalSystematizedNomenclatureOfMedicineClinicalTermsSnomedCtApi", "medicalRxNormOntologyLinkingApi"];
        readonly disableRegionSupport: false;
        readonly serviceDefinitionUrlPath: "/data/amazonComprehendMedical/en_US.json";
        readonly slug: "ComprehendMedical";
        readonly mvpSupport: false;
        readonly comparableTerms: readonly ["comprehendmedical"];
    };
    readonly amazonDetective: {
        readonly name: "Amazon Detective";
        readonly serviceCode: "amazonDetective";
        readonly description: "Amazon Detective makes it easy to analyze, investigate, and quickly identify the root cause of potential security issues or suspicious activities. Amazon Detective automatically collects log data from your AWS resources and uses machine learning, statistical analysis, and graph theory to build a linked set of data that enables you to easily conduct faster and more efficient security investigations.";
        readonly searchKeywords: readonly ["detective", "amazon Detective"];
        readonly type: "AWSService";
        readonly regions: readonly ["af-south-1", "ap-east-1", "ap-northeast-1", "ap-northeast-2", "ap-south-1", "ap-southeast-1", "ap-southeast-2", "ca-central-1", "eu-central-1", "eu-north-1", "eu-south-1", "eu-west-1", "eu-west-2", "eu-west-3", "me-south-1", "sa-east-1", "us-east-1", "us-east-2", "us-gov-east-1", "us-gov-west-1", "us-west-1", "us-west-2"];
        readonly linkUrl: "https://aws.amazon.com/detective/";
        readonly isActive: "true";
        readonly serviceDefinitionLocation: "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonDetective/en_US.json";
        readonly c2e: false;
        readonly slug: "detective";
        readonly mvpSupport: false;
        readonly comparableTerms: readonly ["detective"];
    };
    readonly amazonDevOpsGuru: {
        readonly name: "Amazon DevOps Guru";
        readonly serviceCode: "amazonDevOpsGuru";
        readonly description: "Amazon DevOps Guru is a Machine Learning (ML) powered service that makes it easy to improve an application’s operational performance and availability. DevOps Guru detects behaviors that deviate from normal operating patterns so you can identify operational issues long before they impact your customers.";
        readonly searchKeywords: readonly ["devops", "guru", "devopsguru"];
        readonly type: "AWSService";
        readonly regions: readonly ["us-east-1"];
        readonly linkUrl: "https://aws.amazon.com/devops-guru/";
        readonly isActive: "true";
        readonly disableConfigure: false;
        readonly serviceDefinitionLocation: "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonDevOpsGuru/en_US.json";
        readonly c2e: false;
        readonly templates: readonly [];
        readonly disableRegionSupport: true;
        readonly serviceDefinitionUrlPath: "/data/amazonDevOpsGuru/en_US.json";
        readonly slug: "DevOpsGuru";
        readonly mvpSupport: false;
        readonly comparableTerms: readonly ["devopsguru"];
    };
    readonly amazonDocumentDB: {
        readonly name: "Amazon DocumentDB (with MongoDB compatibility)";
        readonly serviceCode: "amazonDocumentDB";
        readonly description: "Amazon DocumentDB (with MongoDB compatibility) is a fast, scalable, highly available, and fully managed document database service that supports MongoDB workloads.";
        readonly searchKeywords: readonly ["docdb", "MongoDB", "mongodb", "document database", "DocumentDB"];
        readonly type: "AWSService";
        readonly regions: readonly ["ap-south-1", "ap-northeast-2", "ap-southeast-1", "ap-southeast-2", "ap-northeast-1", "ca-central-1", "eu-central-1", "eu-west-1", "eu-west-2", "eu-west-3", "sa-east-1", "us-east-1", "us-east-2", "us-west-2", "us-gov-west-1"];
        readonly linkUrl: "https://aws.amazon.com/documentdb/";
        readonly isActive: "true";
        readonly hasDataTransfer: true;
        readonly disableConfigure: false;
        readonly serviceDefinitionLocation: "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonDocumentDB/en_US.json";
        readonly c2e: false;
        readonly templates: readonly [];
        readonly disableRegionSupport: false;
        readonly bulkImportEnabled: false;
        readonly serviceDefinitionUrlPath: "/data/amazonDocumentDB/en_US.json";
        readonly slug: "DocumentDB";
        readonly mvpSupport: false;
        readonly comparableTerms: readonly ["documentdb", "documentdbwithmongodbcompatibility", "withmongodbcompatibility"];
    };
    readonly amazonDynamoDb: {
        readonly name: "Amazon DynamoDB";
        readonly serviceCode: "amazonDynamoDb";
        readonly description: "Amazon DynamoDB is a key-value and document database that delivers single-digit millisecond performance at any scale. It's a fully managed, multiregion, multimaster, durable database with built-in security, backup and restore, and in-memory caching for internet-scale applications.";
        readonly searchKeywords: readonly ["DynamoDB", "Serverless", "key-value", "Database", "DDB", "NoSQL", "SQL", "Table", "nosql databases", "database schema", "database software", "cloud database", "document database", "key value store", "database as a service", "database scheme", "nosql hosting", "hosted nosql", "data store", "unstructured database", "Accelerator", "DAX"];
        readonly type: "AWSService";
        readonly regions: readonly [];
        readonly linkUrl: "https://aws.amazon.com/dynamodb/";
        readonly isActive: "true";
        readonly subType: "subServiceSelector";
        readonly disableConfigure: false;
        readonly serviceDefinitionLocation: "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonDynamoDb/en_US.json";
        readonly c2e: false;
        readonly templates: readonly ["dynamoDbOnDemand", "amazonDynamoDbProvisionedThroughputCapacity", "amazonDynamoDbDaxClusters", "amazonDynamoDbStreams", "dynamoDbBackup", "dynamoDbChangeDateCapture", "dynamoDbDataExportToAmazonS3", "dynamoDbDataImportFromAmazonS3"];
        readonly disableRegionSupport: false;
        readonly serviceDefinitionUrlPath: "/data/amazonDynamoDb/en_US.json";
        readonly slug: "DynamoDB";
        readonly mvpSupport: false;
        readonly comparableTerms: readonly ["dynamodb"];
    };
    readonly eC2Next: {
        readonly name: "Amazon EC2";
        readonly serviceCode: "eC2Next";
        readonly description: "Amazon EC2 offers the broadest and deepest compute platform with choice of processor, storage, networking, operating system, and purchase model.";
        readonly searchKeywords: readonly [];
        readonly type: "AWSService";
        readonly regions: readonly ["af-south-1", "ap-east-1", "ap-northeast-1", "ap-northeast-1-wl1-nrt1", "ap-northeast-2", "ap-northeast-2-wl1-cjj1", "ap-northeast-2-wl1-sel1", "ap-northeast-3", "ap-south-1", "ap-southeast-1", "ap-southeast-2", "ap-southeast-3", "eu-central-1-wl1-dtm1", "eu-central-1-wl1-ber1", "eu-central-1-wl1-muc1", "ca-central-1", "ca-central-1-wl1-yto1", "eu-central-1", "eu-north-1", "eu-south-1", "eu-west-1", "eu-west-2", "eu-west-2-wl1-lon1", "eu-west-3", "me-south-1", "me-central-1", "sa-east-1", "us-east-1", "us-east-1-atl-1", "us-east-1-bos-1", "us-east-1-chi-1", "us-east-1-dfw-1", "us-west-2-den-1", "us-east-1-iah-1", "us-east-1-mci-1", "us-east-1-mia-1", "us-east-1-msp-1", "us-east-1-nyc-1", "us-east-1-phl-1", "us-east-2", "us-gov-east-1", "us-gov-west-1", "us-west-1", "us-west-2", "us-west-2-las-1", "us-west-2-lax-1", "us-west-2-phx-1", "us-west-2-pdx-1", "us-west-2-sea-1", "us-east-1-wl1", "us-east-1-wl1-was1", "us-west-2-wl1", "us-west-2-wl1-las1", "us-west-2-wl1-lax1", "us-east-1-wl1-atl1", "us-east-1-wl1-chi1", "us-east-1-wl1-dfw1", "us-east-1-wl1-iah1", "us-east-1-wl1-mia1", "us-east-1-wl1-nyc1", "us-east-1-wl1-clt1", "us-east-1-wl1-dtw1", "us-east-1-wl1-msp1", "us-east-1-wl1-bna1", "us-east-1-wl1-tpa1", "us-west-2-wl1-den1", "us-west-2-wl1-phx1", "us-west-2-wl1-sea1"];
        readonly linkUrl: "https://aws.amazon.com/ec2/";
        readonly isActive: "true";
        readonly hasDataTransfer: true;
        readonly disableConfigure: false;
        readonly serviceDefinitionLocation: "https://d1qsjq9pzbk1k6.cloudfront.net/data/eC2Next/en_US.json";
        readonly c2e: false;
        readonly templates: readonly [];
        readonly disableRegionSupport: false;
        readonly slug: "EC2";
        readonly mvpSupport: false;
        readonly comparableTerms: readonly ["ec2", "ec2next"];
    };
    readonly amazonEc2DedicatedHosts: {
        readonly name: "Amazon EC2 Dedicated Hosts";
        readonly serviceCode: "amazonEc2DedicatedHosts";
        readonly description: "Amazon EC2 Dedicated Hosts allow you to use your eligible software licenses on Amazon EC2, so that you get the flexibility and cost effectiveness of using your own licenses, but with the resiliency, simplicity and elasticity of AWS. Includes support for EC2 High Memory and EC2 Mac instances.";
        readonly searchKeywords: readonly ["Mac", "High memory"];
        readonly type: "AWSService";
        readonly regions: readonly ["us-west-2", "us-west-2-lax-1", "us-west-1", "us-east-1", "us-east-2", "sa-east-1", "me-south-1", "me-central-1", "af-south-1", "eu-north-1", "eu-west-1", "eu-west-2", "eu-west-3", "eu-south-1", "eu-central-1", "ca-central-1", "us-gov-east-1", "us-gov-west-1", "ap-northeast-1", "ap-northeast-2", "ap-northeast-3", "ap-southeast-1", "ap-southeast-2", "ap-southeast-3", "ap-south-1", "ap-east-1"];
        readonly linkUrl: "https://aws.amazon.com/ec2/dedicated-hosts";
        readonly isActive: "true";
        readonly disableConfigure: false;
        readonly serviceDefinitionLocation: "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonEc2DedicatedHosts/en_US.json";
        readonly c2e: false;
        readonly templates: readonly [];
        readonly disableRegionSupport: false;
        readonly slug: "EC2DedicatedHosts";
        readonly mvpSupport: false;
        readonly comparableTerms: readonly ["ec2dedicatedhosts"];
    };
    readonly awsEks: {
        readonly name: "Amazon EKS";
        readonly serviceCode: "awsEks";
        readonly description: "Amazon Elastic Kubernetes Service (Amazon EKS) is a fully managed Kubernetes service. Customers such as Intel, Snap, Intuit, GoDaddy, and Autodesk trust EKS to run their most sensitive and mission critical applications because of its security, reliability, and scalability..";
        readonly searchKeywords: readonly ["eks", "elastic", "kubernetes"];
        readonly type: "AWSService";
        readonly regions: readonly ["us-gov-west-1", "us-gov-east-1", "af-south-1", "ap-east-1", "ap-south-1", "ap-northeast-2", "ap-southeast-1", "ap-southeast-2", "ap-southeast-3", "ap-northeast-1", "ap-northeast-3", "ca-central-1", "eu-central-1", "eu-west-1", "eu-west-2", "eu-south-1", "eu-west-3", "eu-north-1", "me-south-1", "sa-east-1", "us-east-1", "us-east-2", "us-west-1", "us-west-2"];
        readonly linkUrl: "https://aws.amazon.com/eks/";
        readonly isActive: "true";
        readonly disableConfigure: false;
        readonly serviceDefinitionLocation: "https://d1qsjq9pzbk1k6.cloudfront.net/data/awsEks/en_US.json";
        readonly c2e: false;
        readonly slug: "EKS";
        readonly mvpSupport: false;
        readonly comparableTerms: readonly ["eks"];
    };
    readonly amazonElasticBlockStore: {
        readonly name: "Amazon Elastic Block Store (EBS)";
        readonly serviceCode: "amazonElasticBlockStore";
        readonly description: "Amazon Elastic Block Storage (EBS) allows you to create persistent block storage volumes and attach them to Amazon EC2 instances.";
        readonly searchKeywords: readonly [];
        readonly type: "AWSService";
        readonly regions: readonly ["af-south-1", "ap-east-1", "ap-northeast-1", "ap-northeast-1-wl1-nrt1", "ap-northeast-2", "ap-northeast-2-wl1-cjj1", "ap-northeast-2-wl1-sel1", "ap-northeast-3", "ap-south-1", "ap-southeast-1", "ap-southeast-2", "ap-southeast-3", "ca-central-1", "ca-central-1-wl1-yto1", "eu-central-1", "eu-north-1", "eu-south-1", "eu-west-1", "eu-west-2", "eu-west-2-wl1-lon1", "eu-central-1-wl1-dtm1", "eu-central-1-wl1-ber1", "eu-central-1-wl1-muc1", "eu-west-3", "me-south-1", "me-central-1", "sa-east-1", "us-east-1", "us-east-1-atl-1", "us-east-1-bos-1", "us-east-1-chi-1", "us-east-1-dfw-1", "us-west-2-den-1", "us-east-1-iah-1", "us-east-1-mci-1", "us-east-1-mia-1", "us-east-1-msp-1", "us-east-1-nyc-1", "us-east-1-phl-1", "us-east-2", "us-gov-east-1", "us-gov-west-1", "us-west-1", "us-west-2", "us-west-2-las-1", "us-west-2-lax-1", "us-west-2-phx-1", "us-west-2-pdx-1", "us-west-2-sea-1", "us-east-1-wl1", "us-east-1-wl1-atl1", "us-east-1-wl1-chi1", "us-east-1-wl1-dfw1", "us-east-1-wl1-iah1", "us-east-1-wl1-mia1", "us-east-1-wl1-nyc1", "us-east-1-wl1-clt1", "us-east-1-wl1-dtw1", "us-east-1-wl1-msp1", "us-east-1-wl1-was1", "us-east-1-wl1-tpa1", "us-east-1-wl1-bna1", "us-west-2-wl1", "us-west-2-wl1-den1", "us-west-2-wl1-las1", "us-west-2-wl1-lax1", "us-west-2-wl1-phx1", "us-west-2-wl1-sea1"];
        readonly linkUrl: "https://aws.amazon.com/ebs/";
        readonly isActive: "true";
        readonly disableConfigure: false;
        readonly serviceDefinitionLocation: "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonElasticBlockStore/en_US.json";
        readonly c2e: false;
        readonly templates: readonly [];
        readonly disableRegionSupport: false;
        readonly bulkImportEnabled: false;
        readonly serviceDefinitionUrlPath: "/data/amazonElasticBlockStore/en_US.json";
        readonly slug: "EBS";
        readonly mvpSupport: false;
        readonly comparableTerms: readonly ["ebs", "elasticblockstore", "elasticblockstoreebs"];
    };
    readonly amazonElasticContainerRegistry: {
        readonly name: "Amazon Elastic Container Registry";
        readonly serviceCode: "amazonElasticContainerRegistry";
        readonly description: "Amazon Elastic Container Registry (ECR) is a fully-managed Docker container registry that makes it easy for developers to store, manage, and deploy Docker container images. Amazon ECR eliminates the need to operate your own container repositories or worry about scaling the underlying infrastructure. With Amazon ECR, there are no upfront fees or commitments. You pay only for the amount of data you store in your repositories and data transferred to the Internet.";
        readonly searchKeywords: readonly ["ECR", "ecr", "Elastic Container Registry", "Amazon ECR", "container registry", "container", "registry"];
        readonly type: "AWSService";
        readonly regions: readonly ["us-gov-west-1", "us-gov-east-1", "af-south-1", "ap-east-1", "ap-south-1", "ap-northeast-2", "ap-southeast-1", "ap-southeast-2", "ap-southeast-3", "ap-northeast-1", "ap-northeast-3", "ca-central-1", "eu-central-1", "eu-west-1", "eu-west-2", "eu-south-1", "eu-west-3", "eu-north-1", "me-south-1", "me-central-1", "sa-east-1", "us-east-1", "us-east-2", "us-west-1", "us-west-2"];
        readonly linkUrl: "https://aws.amazon.com/ecr/";
        readonly isActive: "true";
        readonly disableConfigure: false;
        readonly serviceDefinitionLocation: "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonElasticContainerRegistry/en_US.json";
        readonly c2e: false;
        readonly templates: readonly [];
        readonly disableRegionSupport: false;
        readonly slug: "ECR";
        readonly mvpSupport: false;
        readonly comparableTerms: readonly ["ecr", "elasticcontainerregistry"];
    };
    readonly amazonEFS: {
        readonly name: "Amazon Elastic File System (EFS)";
        readonly serviceCode: "amazonEFS";
        readonly description: "Amazon Elastic File System (EFS) provides a simple, serverless, set-and-forget elastic file system for use with AWS Cloud services and on-premises resources.";
        readonly searchKeywords: readonly ["Storage", "Elastic file system", "elastic file service", "cloud file system", "cloud based file", "system", "file system", "NFS", "network file system", "fully managed file system", "NAS", "managed file system", "network attached storage", "network storage", "SAN", "storage area network", "cloud storage", "shared", "shared file system", "RAID", "cloud file storage", "file system storage", "file management"];
        readonly type: "AWSService";
        readonly regions: readonly ["us-east-1", "us-east-2", "us-west-1", "us-west-2", "af-south-1", "ap-east-1", "ap-south-1", "ap-northeast-2", "ap-southeast-1", "ap-southeast-2", "ap-southeast-3", "ap-northeast-1", "ap-northeast-3", "ca-central-1", "eu-central-1", "eu-west-1", "eu-west-2", "eu-west-3", "eu-north-1", "eu-south-1", "me-south-1", "sa-east-1", "us-gov-west-1", "us-gov-east-1"];
        readonly linkUrl: "https://aws.amazon.com/efs/";
        readonly isActive: "true";
        readonly serviceDefinitionLocation: "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonEFS/en_US.json";
        readonly c2e: false;
        readonly slug: "EFS";
        readonly mvpSupport: false;
        readonly comparableTerms: readonly ["efs", "elasticfilesystemefs"];
    };
    readonly amazonElasticGraphics: {
        readonly name: "Amazon Elastic Graphics";
        readonly serviceCode: "amazonElasticGraphics";
        readonly description: "Amazon Elastic Graphics allows you to easily attach low-cost graphics acceleration to a wide range of EC2 instances over the network.";
        readonly searchKeywords: readonly ["Compute", "Elastic Compute Cloud", "spot instance", "load balancing", "elb", "elastic load balancer", "auto scaling", "auto scaling groups", "application load balancer", "ALB", "spot requests", "reserved instances", "scheduled instances", "dedicated hosts", "AMIs", "Bundle tasks", "Volumes", "Snapshots", "Images", "Elastic Block Store", "block storage", "Security groups", "Elastic IP", "placement groups", "key pairs", "network interfaces", "load balancers", "target groups", "auto scaler", "launch configurations", "EBS", "ASG", "commands", "Elastic Graphics", "command history", "managed instances", "activations"];
        readonly type: "AWSService";
        readonly regions: readonly ["ap-southeast-1", "ap-southeast-2", "ap-northeast-1", "eu-central-1", "eu-west-1", "us-east-1", "us-east-2", "us-west-2"];
        readonly linkUrl: "https://aws.amazon.com/ec2/elastic-graphics/";
        readonly isActive: "true";
        readonly disableConfigure: false;
        readonly serviceDefinitionLocation: "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonElasticGraphics/en_US.json";
        readonly c2e: false;
        readonly templates: readonly [];
        readonly disableRegionSupport: false;
        readonly slug: "ElasticGraphics";
        readonly mvpSupport: false;
        readonly comparableTerms: readonly ["ec2elasticgraphics", "elasticgraphics"];
    };
    readonly amazonElasticIP: {
        readonly name: "Amazon Elastic IP";
        readonly serviceCode: "amazonElasticIP";
        readonly description: "An Elastic IP address is a static IPv4 address designed for dynamic cloud computing. An Elastic IP address is associated with your AWS account. With an Elastic IP address, you can mask the failure of an instance or software by rapidly remapping the address to another instance in your account.";
        readonly searchKeywords: readonly ["Compute", "Elastic Compute Cloud", "spot instance", "load balancing", "elb", "elastic load balancer", "auto scaling", "auto scaling groups", "application load balancer", "ALB", "spot requests", "reserved instances", "scheduled instances", "dedicated hosts", "AMIs", "Bundle tasks", "Volumes", "Snapshots", "Images", "Elastic Block Store", "block storage", "Security groups", "Elastic IP", "placement groups", "key pairs", "network interfaces", "load balancers", "target groups", "auto scaler", "launch configurations", "EBS", "ASG", "commands", "command history", "managed instances", "activations"];
        readonly type: "AWSService";
        readonly regions: readonly ["ap-east-1", "ap-south-1", "ap-northeast-2", "ap-southeast-1", "ap-southeast-2", "ap-northeast-1", "us-gov-west-1", "us-gov-east-1", "ca-central-1", "eu-central-1", "eu-west-1", "eu-west-2", "eu-west-3", "eu-north-1", "me-south-1", "sa-east-1", "us-east-1", "us-east-2", "us-west-1", "us-west-2"];
        readonly linkUrl: "https://aws.amazon.com/ec2/pricing/on-demand/";
        readonly isActive: "true";
        readonly serviceDefinitionLocation: "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonElasticIP/en_US.json";
        readonly c2e: false;
        readonly slug: "ElasticIP";
        readonly comparableTerms: readonly ["elasticip"];
    };
    readonly amazonElasticTranscoder: {
        readonly name: "Amazon Elastic Transcoder";
        readonly serviceCode: "amazonElasticTranscoder";
        readonly description: "Amazon Elastic Transcoder is media transcoding in the cloud. It is designed to be a highly scalable, easy to use and a cost effective way for developers and businesses to convert (or “transcode”) media files from their source format into versions that will playback on devices like smartphones, tablets and PCs.";
        readonly searchKeywords: readonly [];
        readonly type: "AWSService";
        readonly regions: readonly ["ap-northeast-1", "ap-south-1", "ap-southeast-1", "ap-southeast-2", "eu-west-1", "us-east-1", "us-west-1", "us-west-2"];
        readonly linkUrl: "https://aws.amazon.com/elastictranscoder/";
        readonly isActive: "true";
        readonly serviceDefinitionLocation: "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonElasticTranscoder/en_US.json";
        readonly c2e: false;
        readonly slug: "ElasticTranscoder";
        readonly comparableTerms: readonly ["elastictranscoder"];
    };
    readonly amazonElastiCache: {
        readonly name: "Amazon ElastiCache";
        readonly serviceCode: "amazonElastiCache";
        readonly description: "Amazon ElastiCache offers fully managed Redis and Memcached. Seamlessly deploy, run, and scale popular open source compatible in-memory data stores. Build data-intensive apps or improve the performance of your existing apps by retrieving data from high throughput and low latency in-memory data stores.";
        readonly searchKeywords: readonly ["Database", "Database", "Cache", "Memcached", "Redis", "Caching", "in memory data store", "in memory caching", "auto discovery", "elasticache cluster", "replication", "adtech", "gaming", "media sharing", "Q&A", "social networking"];
        readonly type: "AWSService";
        readonly regions: readonly ["af-south-1", "ap-east-1", "ap-south-1", "ap-northeast-3", "ap-northeast-2", "ap-southeast-1", "ap-southeast-2", "ap-southeast-3", "ap-northeast-1", "us-gov-west-1", "us-gov-east-1", "ca-central-1", "eu-central-1", "eu-west-1", "eu-west-2", "eu-west-3", "eu-north-1", "eu-south-1", "me-south-1", "me-central-1", "sa-east-1", "us-east-1", "us-east-2", "us-west-1", "us-west-2"];
        readonly linkUrl: "https://aws.amazon.com/elasticache/";
        readonly isActive: "true";
        readonly hasDataTransfer: true;
        readonly disableConfigure: false;
        readonly serviceDefinitionLocation: "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonElastiCache/en_US.json";
        readonly c2e: false;
        readonly templates: readonly [];
        readonly disableRegionSupport: false;
        readonly slug: "ElastiCache";
        readonly mvpSupport: false;
        readonly comparableTerms: readonly ["elasticache"];
    };
    readonly amazonEMR: {
        readonly name: "Amazon EMR";
        readonly serviceCode: "amazonEMR";
        readonly description: "Amazon EMR is the industry-leading cloud big data platform for processing vast amounts of data using open source tools such as Apache Spark, Apache Hive, Apache HBase, Apache Flink, Apache Hudi, and Presto. Amazon EMR makes it easy to set up, operate, and scale your big data environments by automating time-consuming tasks like provisioning capacity and tuning clusters. With EMR you can run petabyte-scale analysis at less than half of the cost of traditional on-premises solutions and over 3x faster than standard Apache Spark. You can run workloads on Amazon EC2 instances, on Amazon Elastic Kubernetes Service (EKS) clusters, or on-premises using EMR on AWS Outposts.";
        readonly searchKeywords: readonly ["EMR", "elastic map reduce", "map reduce", "spark", "hadoop", "hbase", "hive", "hudi", "presto", "notebooks", "flink", "hue"];
        readonly type: "AWSService";
        readonly regions: readonly [];
        readonly linkUrl: "https://aws.amazon.com/emr/";
        readonly isActive: "true";
        readonly subType: "subServiceSelector";
        readonly disableConfigure: false;
        readonly serviceDefinitionLocation: "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonEMR/en_US.json";
        readonly c2e: false;
        readonly templates: readonly ["amazonEmrMasterNode", "amazonEmrCoreNode", "amazonEmrTaskNode", "amazonEmrOnEks", "amazonEmrServerless"];
        readonly disableRegionSupport: false;
        readonly serviceDefinitionUrlPath: "/data/amazonEMR/en_US.json";
        readonly slug: "EMR";
        readonly mvpSupport: false;
        readonly comparableTerms: readonly ["emr"];
    };
    readonly amazonEmrCoreNode: {
        readonly name: "Amazon EMR core node on EC2";
        readonly serviceCode: "amazonEmrCoreNode";
        readonly description: "";
        readonly searchKeywords: readonly [];
        readonly type: "AWSService";
        readonly regions: readonly ["af-south-1", "ap-east-1", "ap-south-1", "ap-northeast-3", "ap-northeast-2", "ap-southeast-1", "ap-southeast-2", "ap-southeast-3", "ap-northeast-1", "us-gov-east-1", "us-gov-west-1", "ca-central-1", "eu-central-1", "eu-west-1", "eu-west-2", "eu-west-3", "eu-south-1", "eu-north-1", "me-south-1", "me-central-1", "sa-east-1", "us-east-1", "us-east-2", "us-west-1", "us-west-2", "us-west-2-lax-1"];
        readonly linkUrl: "https://aws.amazon.com/emr/";
        readonly isActive: "true";
        readonly subType: "subService";
        readonly disableConfigure: false;
        readonly serviceDefinitionLocation: "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonEmrCoreNode/en_US.json";
        readonly c2e: false;
        readonly templates: readonly [];
        readonly disableRegionSupport: false;
        readonly serviceDefinitionUrlPath: "/data/amazonEmrCoreNode/en_US.json";
        readonly mvpSupport: false;
        readonly comparableTerms: readonly ["emrcorenode", "emrcorenodeec2"];
        readonly parentServiceCode: "amazonEMR";
    };
    readonly amazonEmrMasterNode: {
        readonly name: "Amazon EMR master node on EC2";
        readonly serviceCode: "amazonEmrMasterNode";
        readonly description: "";
        readonly searchKeywords: readonly [];
        readonly type: "AWSService";
        readonly regions: readonly ["af-south-1", "ap-east-1", "ap-south-1", "ap-northeast-3", "ap-northeast-2", "ap-southeast-1", "ap-southeast-2", "ap-southeast-3", "ap-northeast-1", "us-gov-east-1", "us-gov-west-1", "ca-central-1", "eu-central-1", "eu-west-1", "eu-west-2", "eu-west-3", "eu-south-1", "eu-north-1", "me-south-1", "me-central-1", "sa-east-1", "us-east-1", "us-east-2", "us-west-1", "us-west-2", "us-west-2-lax-1"];
        readonly linkUrl: "https://aws.amazon.com/emr/";
        readonly isActive: "true";
        readonly subType: "subService";
        readonly disableConfigure: false;
        readonly serviceDefinitionLocation: "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonEmrMasterNode/en_US.json";
        readonly c2e: false;
        readonly templates: readonly [];
        readonly disableRegionSupport: false;
        readonly serviceDefinitionUrlPath: "/data/amazonEmrMasterNode/en_US.json";
        readonly mvpSupport: false;
        readonly comparableTerms: readonly ["emrmasternode", "emrmasternodeec2"];
        readonly parentServiceCode: "amazonEMR";
    };
    readonly amazonEmrOnEks: {
        readonly name: "Amazon EMR on EKS";
        readonly serviceCode: "amazonEmrOnEks";
        readonly description: "";
        readonly searchKeywords: readonly [];
        readonly type: "AWSService";
        readonly regions: readonly ["ap-south-1", "ap-northeast-2", "ap-southeast-1", "ap-southeast-2", "ap-northeast-1", "ca-central-1", "eu-central-1", "eu-west-1", "eu-west-2", "eu-west-3", "eu-north-1", "sa-east-1", "us-east-1", "us-east-2", "us-west-1", "us-west-2"];
        readonly linkUrl: "https://aws.amazon.com/emr/";
        readonly isActive: "true";
        readonly subType: "subService";
        readonly disableConfigure: false;
        readonly serviceDefinitionLocation: "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonEmrOnEks/en_US.json";
        readonly c2e: false;
        readonly templates: readonly [];
        readonly disableRegionSupport: false;
        readonly serviceDefinitionUrlPath: "/data/amazonEmrOnEks/en_US.json";
        readonly mvpSupport: false;
        readonly comparableTerms: readonly ["emreks", "emroneks"];
        readonly parentServiceCode: "amazonEMR";
    };
    readonly amazonEmrServerless: {
        readonly name: "Amazon EMR Serverless";
        readonly serviceCode: "amazonEmrServerless";
        readonly description: "";
        readonly searchKeywords: readonly [];
        readonly type: "AWSService";
        readonly regions: readonly ["ap-northeast-1", "eu-west-1", "us-east-1", "us-west-2"];
        readonly linkUrl: "https://aws.amazon.com/emr/";
        readonly isActive: "true";
        readonly subType: "subService";
        readonly disableConfigure: false;
        readonly serviceDefinitionLocation: "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonEmrServerless/en_US.json";
        readonly c2e: false;
        readonly templates: readonly [];
        readonly disableRegionSupport: false;
        readonly serviceDefinitionUrlPath: "/data/amazonEmrServerless/en_US.json";
        readonly mvpSupport: false;
        readonly comparableTerms: readonly ["emrserverless"];
        readonly parentServiceCode: "amazonEMR";
    };
    readonly amazonEmrTaskNode: {
        readonly name: "Amazon EMR task node on EC2";
        readonly serviceCode: "amazonEmrTaskNode";
        readonly description: "";
        readonly searchKeywords: readonly [];
        readonly type: "AWSService";
        readonly regions: readonly ["af-south-1", "ap-east-1", "ap-south-1", "ap-northeast-3", "ap-northeast-2", "ap-southeast-1", "ap-southeast-2", "ap-southeast-3", "ap-northeast-1", "us-gov-east-1", "us-gov-west-1", "ca-central-1", "eu-central-1", "eu-west-1", "eu-west-2", "eu-west-3", "eu-south-1", "eu-north-1", "me-south-1", "me-central-1", "sa-east-1", "us-east-1", "us-east-2", "us-west-1", "us-west-2", "us-west-2-lax-1"];
        readonly linkUrl: "https://aws.amazon.com/emr/";
        readonly isActive: "true";
        readonly subType: "subService";
        readonly disableConfigure: false;
        readonly serviceDefinitionLocation: "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonEmrTaskNode/en_US.json";
        readonly c2e: false;
        readonly templates: readonly [];
        readonly disableRegionSupport: false;
        readonly serviceDefinitionUrlPath: "/data/amazonEmrTaskNode/en_US.json";
        readonly mvpSupport: false;
        readonly comparableTerms: readonly ["emrtasknode", "emrtasknodeec2"];
        readonly parentServiceCode: "amazonEMR";
    };
    readonly amazonEventBridge: {
        readonly name: "Amazon EventBridge";
        readonly serviceCode: "amazonEventBridge";
        readonly description: "Amazon EventBridge is a serverless event bus that makes it easier to build event-driven applications at scale using events generated from your applications, integrated Software-as-a-Service (SaaS) applications, and AWS services.";
        readonly searchKeywords: readonly ["amazon event bridge", "events", "Schema Registry", "SaaS"];
        readonly type: "AWSService";
        readonly regions: readonly ["af-south-1", "ap-east-1", "ap-northeast-1", "ap-northeast-2", "ap-northeast-3", "ap-south-1", "ap-southeast-1", "ap-southeast-2", "ap-southeast-3", "ca-central-1", "eu-central-1", "eu-north-1", "eu-south-1", "eu-west-1", "eu-west-2", "eu-west-3", "me-south-1", "me-central-1", "sa-east-1", "us-east-1", "us-east-2", "us-gov-east-1", "us-gov-west-1", "us-west-1", "us-west-2"];
        readonly linkUrl: "https://aws.amazon.com/eventbridge/";
        readonly isActive: "true";
        readonly disableConfigure: false;
        readonly serviceDefinitionLocation: "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonEventBridge/en_US.json";
        readonly c2e: false;
        readonly templates: readonly [];
        readonly disableRegionSupport: false;
        readonly slug: "eventbridge";
        readonly mvpSupport: false;
        readonly comparableTerms: readonly ["eventbridge"];
    };
    readonly amazonFileCache: {
        readonly name: "Amazon File Cache";
        readonly serviceCode: "amazonFileCache";
        readonly description: "Amazon File Cache provides a high-speed cache on AWS that makes it easier to process file data, regardless of where the data is stored.";
        readonly searchKeywords: readonly ["file cache", "amazon file cache"];
        readonly type: "AWSService";
        readonly regions: readonly [" "];
        readonly linkUrl: "https://aws.amazon.com/filecache/";
        readonly isActive: "true";
        readonly disableConfigure: false;
        readonly serviceDefinitionLocation: "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonFileCache/en_US.json";
        readonly c2e: false;
        readonly templates: readonly [];
        readonly disableRegionSupport: false;
        readonly serviceDefinitionUrlPath: "/data/amazonFileCache/en_US.json";
        readonly slug: "filecache";
        readonly mvpSupport: false;
        readonly comparableTerms: readonly ["filecache"];
    };
    readonly awsFinSpace: {
        readonly name: "Amazon FinSpace";
        readonly serviceCode: "awsFinSpace";
        readonly description: "Amazon FinSpace is a data management and analytics service for financial services industry (FSI) customers such as hedge funds, asset management firms, insurance companies, and investment banks to store, catalog, prepare, and analyze data at petabyte scale. Using the FinSpace web application and APIs, customers can set up users, add data, and create data views that are optimized for querying. Amazon FinSpace provides scalable clusters to prepare and analyze the data.";
        readonly searchKeywords: readonly ["data management", "analytics", "clusters", "users", "data", "storage", "financial"];
        readonly type: "AWSService";
        readonly regions: readonly ["us-east-1", "us-east-2", "us-west-2", "ca-central-1", "eu-west-1"];
        readonly linkUrl: "https://aws.amazon.com/finspace/";
        readonly isActive: "true";
        readonly disableConfigure: false;
        readonly serviceDefinitionLocation: "https://d1qsjq9pzbk1k6.cloudfront.net/data/awsFinSpace/en_US.json";
        readonly c2e: false;
        readonly templates: readonly [];
        readonly disableRegionSupport: false;
        readonly slug: "FinSpace";
        readonly mvpSupport: false;
        readonly comparableTerms: readonly ["finspace"];
    };
    readonly amazonForecast: {
        readonly name: "Amazon Forecast";
        readonly serviceCode: "amazonForecast";
        readonly description: "Amazon Forecast uses machine learning (ML) to generate more accurate demand forecasts with just a few clicks, without requiring any prior ML experience. Amazon Forecast includes algorithms that are based on over twenty years of forecasting experience and developed expertise used by Amazon.com bringing the same technology used at Amazon to developers as a fully managed service, removing the need to manage resources. Amazon Forecast uses ML to learn not only the best algorithm for each item, but the best ensemble of algorithms for each item, automatically creating the best model for your data.";
        readonly searchKeywords: readonly ["forecast", "amazon Forecast"];
        readonly type: "AWSService";
        readonly regions: readonly ["ap-northeast-1", "ap-northeast-2", "ap-south-1", "ap-southeast-1", "ap-southeast-2", "eu-central-1", "eu-west-1", "us-east-1", "us-east-2", "us-west-2"];
        readonly linkUrl: "https://aws.amazon.com/forecast/";
        readonly isActive: "true";
        readonly serviceDefinitionLocation: "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonForecast/en_US.json";
        readonly c2e: false;
        readonly slug: "forecast";
        readonly mvpSupport: false;
        readonly comparableTerms: readonly ["forecast"];
    };
    readonly amazonFraudDetector: {
        readonly name: "Amazon Fraud Detector";
        readonly serviceCode: "amazonFraudDetector";
        readonly description: "Amazon Fraud Detector, a fully managed service built on over 20 years of insights from Amazon, helps customers identify potentially fraudulent activities and catch more online fraud faster. With Amazon Fraud Detector, you pay only for what you use, and there are no minimum fees or upfront commitments. You are charged based on the compute hours used to train and host your models, the amount of storage you use, and the quantity of fraud predictions you make.";
        readonly searchKeywords: readonly ["fraud", "fraud detector", "detector"];
        readonly type: "AWSService";
        readonly regions: readonly ["ap-southeast-1", "ap-southeast-2", "eu-west-1", "us-east-1", "us-east-2", "us-west-2"];
        readonly linkUrl: "https://aws.amazon.com/fraud-detector/";
        readonly isActive: "true";
        readonly disableConfigure: false;
        readonly serviceDefinitionLocation: "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonFraudDetector/en_US.json";
        readonly c2e: false;
        readonly slug: "frauddetector";
        readonly mvpSupport: false;
        readonly comparableTerms: readonly ["frauddetector"];
    };
    readonly amazonFSxForLustre: {
        readonly name: "Amazon FSx for Lustre";
        readonly serviceCode: "amazonFSxForLustre";
        readonly description: "Amazon FSx for Lustre provides a simple, high-performance file system integrated with S3 for fast processing of workloads such as machine learning, high performance computing (HPC), video processing, financial modeling, and electronic design automation (EDA).";
        readonly searchKeywords: readonly ["storage", "file storage", "windows", "lustre", "hpc", "enterprise applications", "file shares", "file system", "cloud storage", "smb", "ntfs", "posix", "managed storage"];
        readonly type: "AWSService";
        readonly regions: readonly ["ap-east-1", "ap-south-1", "ap-northeast-1", "ap-northeast-2", "ap-southeast-1", "ca-central-1", "ap-southeast-2", "af-south-1", "eu-central-1", "eu-north-1", "eu-west-1", "eu-west-2", "eu-west-3", "me-south-1", "eu-south-1", "sa-east-1", "us-east-1", "us-east-2", "us-gov-east-1", "us-gov-west-1", "us-west-1", "us-west-2", "us-west-2-lax-1"];
        readonly linkUrl: "https://aws.amazon.com/fsx/lustre/";
        readonly isActive: "true";
        readonly serviceDefinitionLocation: "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonFSxForLustre/en_US.json";
        readonly c2e: false;
        readonly slug: "FSxForLustre";
        readonly mvpSupport: false;
        readonly comparableTerms: readonly ["fsxforlustre", "fsxlustre"];
    };
    readonly amazonFSxForNetAppOntap: {
        readonly name: "Amazon FSx for NetApp ONTAP";
        readonly serviceCode: "amazonFSxForNetAppOntap";
        readonly description: "Amazon FSx for NetApp ONTAP provides fully managed shared storage in the AWS Cloud with the popular data access and management capabilities of ONTAP.";
        readonly searchKeywords: readonly ["storage", "file storage", "windows", "lustre", "hpc", "enterprise applications", "file shares", "file system", "cloud storage", "smb", "ntfs", "posix", "managed storage", "microsoft", "file", "msft", "shared storage", "shared", "win", "ontap"];
        readonly type: "AWSService";
        readonly regions: readonly ["af-south-1", "ap-east-1", "ap-south-1", "ap-northeast-2", "ap-southeast-1", "ap-southeast-2", "ap-northeast-1", "us-gov-east-1", "us-gov-west-1", "ca-central-1", "eu-central-1", "eu-west-1", "eu-west-2", "eu-south-1", "eu-west-3", "eu-north-1", "me-south-1", "sa-east-1", "us-east-1", "us-east-2", "us-west-2"];
        readonly linkUrl: "https://aws.amazon.com/fsx/netapp-ontap/";
        readonly isActive: "true";
        readonly disableConfigure: false;
        readonly serviceDefinitionLocation: "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonFSxForNetAppOntap/en_US.json";
        readonly c2e: false;
        readonly templates: readonly [];
        readonly disableRegionSupport: false;
        readonly bulkImportEnabled: false;
        readonly serviceDefinitionUrlPath: "/data/amazonFSxForNetAppOntap/en_US.json";
        readonly slug: "FSxForNetAppOntap";
        readonly mvpSupport: false;
        readonly comparableTerms: readonly ["fsxfornetappontap", "fsxnetappontap"];
    };
    readonly amazonFSxForOpenZfs: {
        readonly name: "Amazon FSx for OpenZFS";
        readonly serviceCode: "amazonFSxForOpenZfs";
        readonly description: "Amazon FSx for OpenZFS provides fully managed shared file storage built on the OpenZFS file system, powered by the AWS Graviton family of processors, and accessible via the NFS protocol (v3, v4, v4.1, v4.2).";
        readonly searchKeywords: readonly ["storage", "file storage", "windows", "openzfs", "hpc", "enterprise applications", "file shares", "file system", "cloud storage", "smb", "ntfs", "posix", "managed storage"];
        readonly type: "AWSService";
        readonly regions: readonly ["us-east-2", "ap-northeast-1", "ap-southeast-1", "ap-southeast-2", "ca-central-1", "eu-central-1", "eu-west-1", "eu-west-2", "us-east-1", "us-west-2"];
        readonly linkUrl: "https://aws.amazon.com/fsx/openzfs/";
        readonly isActive: "true";
        readonly disableConfigure: false;
        readonly serviceDefinitionLocation: "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonFSxForOpenZfs/en_US.json";
        readonly c2e: false;
        readonly templates: readonly [];
        readonly disableRegionSupport: false;
        readonly bulkImportEnabled: false;
        readonly serviceDefinitionUrlPath: "/data/amazonFSxForOpenZfs/en_US.json";
        readonly slug: "FSxForOpenZFS";
        readonly mvpSupport: false;
        readonly comparableTerms: readonly ["fsxforopenzfs", "fsxopenzfs"];
    };
    readonly amazonFSx: {
        readonly name: "Amazon FSx for Windows File Server";
        readonly serviceCode: "amazonFSx";
        readonly description: "Amazon FSx for Windows provides a simple, fully managed native Microsoft Windows file system so you can easily move your Windows based applications that require file storage to AWS.";
        readonly searchKeywords: readonly ["storage", "file storage", "windows", "lustre", "hpc", "enterprise applications", "file shares", "file system", "cloud storage", "smb", "ntfs", "posix", "managed storage", "microsoft", "file", "msft", "shared storage", "shared", "win"];
        readonly type: "AWSService";
        readonly regions: readonly ["af-south-1", "ap-southeast-1", "ap-southeast-2", "ap-northeast-1", "ap-northeast-2", "ap-northeast-3", "eu-central-1", "ap-east-1", "ap-south-1", "ca-central-1", "eu-north-1", "eu-west-1", "eu-west-2", "eu-west-3", "eu-south-1", "me-south-1", "us-east-1", "us-east-2", "us-gov-east-1", "us-gov-west-1", "us-west-1", "us-west-2-lax-1", "us-west-2", "sa-east-1"];
        readonly linkUrl: "https://aws.amazon.com/fsx/windows/";
        readonly isActive: "true";
        readonly disableConfigure: false;
        readonly serviceDefinitionLocation: "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonFSx/en_US.json";
        readonly c2e: false;
        readonly slug: "FSx";
        readonly mvpSupport: false;
        readonly comparableTerms: readonly ["fsx", "fsxwindows", "fsxwindowsfileserver"];
    };
    readonly amazonGameLift: {
        readonly name: "Amazon GameLift";
        readonly serviceCode: "amazonGameLift";
        readonly description: "Amazon GameLift is a dedicated game server hosting solution that deploys, operates, and scales cloud servers for multiplayer games. Whether you’re looking for a fully managed solution, or just the feature you need, GameLift leverages the power of AWS to deliver the best latency possible, low player wait times, and maximum cost savings.";
        readonly searchKeywords: readonly ["gamelift", "gamelift instances", "gamelift flexmatch", "flexmatch"];
        readonly type: "AWSService";
        readonly regions: readonly ["us-east-1", "us-east-2", "us-west-1", "us-west-2", "af-south-1", "ap-northeast-1", "ap-northeast-2", "ap-northeast-3", "ap-east-1", "ap-southeast-1", "ap-southeast-2", "ap-south-1", "ca-central-1", "eu-north-1", "eu-central-1", "eu-south-1", "eu-west-1", "eu-west-2", "eu-west-3", "me-south-1", "sa-east-1", "us-east-1-atl-1", "us-east-1-chi-1", "us-east-1-dfw-1", "us-west-2-den-1", "us-east-1-iah-1", "us-east-1-mci-1", "us-west-2-lax-1", "us-west-2-phx-1"];
        readonly linkUrl: "https://aws.amazon.com/gamelift/";
        readonly isActive: "true";
        readonly disableConfigure: false;
        readonly serviceDefinitionLocation: "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonGameLift/en_US.json";
        readonly c2e: false;
        readonly templates: readonly [];
        readonly disableRegionSupport: false;
        readonly slug: "GameLift";
        readonly mvpSupport: false;
        readonly comparableTerms: readonly ["gamelift"];
    };
    readonly amazonGuardDuty: {
        readonly name: "Amazon GuardDuty";
        readonly serviceCode: "amazonGuardDuty";
        readonly description: "Amazon GuardDuty is a threat detection service that continuously monitors for malicious activity and unauthorized behavior to protect your AWS accounts, workloads, and data stored in Amazon S3.";
        readonly searchKeywords: readonly ["guard duty", "amazon GuardDuty"];
        readonly type: "AWSService";
        readonly regions: readonly ["af-south-1", "ap-east-1", "ap-northeast-1", "ap-northeast-2", "ap-south-1", "ap-southeast-1", "ap-southeast-2", "ap-southeast-3", "ap-northeast-3", "ca-central-1", "eu-central-1", "eu-north-1", "eu-south-1", "eu-west-1", "eu-west-2", "eu-west-3", "me-south-1", "sa-east-1", "us-east-1", "us-east-2", "us-gov-east-1", "us-gov-west-1", "us-west-1", "us-west-2"];
        readonly linkUrl: "https://aws.amazon.com/guardduty/";
        readonly isActive: "true";
        readonly disableConfigure: false;
        readonly serviceDefinitionLocation: "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonGuardDuty/en_US.json";
        readonly c2e: false;
        readonly slug: "guardduty";
        readonly mvpSupport: false;
        readonly comparableTerms: readonly ["guardduty"];
    };
    readonly amazonHealthlake: {
        readonly name: "Amazon Healthlake";
        readonly serviceCode: "amazonHealthlake";
        readonly description: "Amazon HealthLake is a HIPAA-eligible service offering healthcare and life sciences companies a complete view of individual or patient population health data for query and analytics at scale.";
        readonly searchKeywords: readonly ["FHIR", "HIPAA", "NLP"];
        readonly type: "AWSService";
        readonly regions: readonly ["us-east-1", "us-east-2", "us-west-2"];
        readonly linkUrl: "https://aws.amazon.com/healthlake/";
        readonly isActive: "true";
        readonly serviceDefinitionLocation: "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonHealthlake/en_US.json";
        readonly c2e: false;
        readonly slug: "HealthLake";
        readonly mvpSupport: false;
        readonly comparableTerms: readonly ["healthlake"];
    };
    readonly amazonInspector: {
        readonly name: "Amazon Inspector";
        readonly serviceCode: "amazonInspector";
        readonly description: "Amazon Inspector is an automated and continual vulnerability scanning service that assesses Amazon Elastic Compute Cloud (EC2) instances and container images to improve the security and compliance of infrastructure workloads.";
        readonly searchKeywords: readonly ["Analytics", "SQL", "query", "S3", "big data", "Presto", "serverless", "ad-hoc analysis", "log processing", "bigquery", "big query", "query S3 data"];
        readonly type: "AWSService";
        readonly regions: readonly ["ap-east-1", "ap-south-1", "ap-northeast-1", "ap-northeast-2", "ap-northeast-3", "ap-southeast-1", "ap-southeast-2", "us-gov-west-1", "us-gov-east-1", "ca-central-1", "eu-central-1", "eu-west-1", "eu-west-2", "eu-west-3", "eu-north-1", "eu-south-1", "me-south-1", "us-east-1", "us-east-2", "us-west-1", "us-west-2", "af-south-1", "sa-east-1"];
        readonly linkUrl: "https://aws.amazon.com/inspector/";
        readonly isActive: "true";
        readonly serviceDefinitionLocation: "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonInspector/en_US.json";
        readonly c2e: false;
        readonly slug: "Inspector";
        readonly mvpSupport: false;
        readonly comparableTerms: readonly ["inspector"];
    };
    readonly amazonKendra: {
        readonly name: "Amazon Kendra";
        readonly serviceCode: "amazonKendra";
        readonly description: "Amazon Kendra is an intelligent search service powered by machine learning. Kendra reimagines enterprise search for your websites and applications so your employees and customers can easily find the content they are looking for, even when it’s scattered across multiple locations and content repositories within your organization.";
        readonly searchKeywords: readonly ["kendra"];
        readonly type: "AWSService";
        readonly regions: readonly ["us-east-1", "us-west-2", "eu-west-1", "ap-southeast-2"];
        readonly linkUrl: "https://aws.amazon.com/kendra";
        readonly isActive: "true";
        readonly disableConfigure: false;
        readonly serviceDefinitionLocation: "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonKendra/en_US.json";
        readonly c2e: false;
        readonly templates: readonly [];
        readonly disableRegionSupport: false;
        readonly bulkImportEnabled: false;
        readonly serviceDefinitionUrlPath: "/data/amazonKendra/en_US.json";
        readonly slug: "Kendra";
        readonly mvpSupport: false;
        readonly comparableTerms: readonly ["kendra"];
    };
    readonly amazonKinesisDataAnalytics: {
        readonly name: "Amazon Kinesis Data Analytics";
        readonly serviceCode: "amazonKinesisDataAnalytics";
        readonly description: "Amazon Kinesis Data Analytics is the easiest way to analyze streaming data, gain actionable insights, and respond to your business and customer needs in real time.";
        readonly searchKeywords: readonly ["Kinesis", "streaming", "insights"];
        readonly type: "AWSService";
        readonly regions: readonly ["us-gov-west-1", "us-gov-east-1", "ap-east-1", "ap-south-1", "ap-southeast-1", "ap-southeast-2", "ap-northeast-1", "ap-northeast-2", "ap-northeast-3", "ca-central-1", "eu-central-1", "eu-west-1", "eu-west-2", "eu-west-3", "eu-north-1", "eu-south-1", "me-south-1", "sa-east-1", "us-east-1", "us-east-2", "us-west-1", "us-west-2", "af-south-1"];
        readonly linkUrl: "https://aws.amazon.com/kinesis/data-analytics/";
        readonly isActive: "true";
        readonly serviceDefinitionLocation: "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonKinesisDataAnalytics/en_US.json";
        readonly c2e: false;
        readonly slug: "KinesisDataAnalytics";
        readonly mvpSupport: false;
        readonly comparableTerms: readonly ["kinesisdataanalytics"];
    };
    readonly amazonKinesisFirehose: {
        readonly name: "Amazon Kinesis Data Firehose";
        readonly serviceCode: "amazonKinesisFirehose";
        readonly description: "With Amazon Kinesis Data Firehose, you pay for the volume of data you ingest into the service. There are no set up fees or upfront commitments. You are billed for the volume of data ingested into Kinesis Data Firehose, and if applicable, for data format conversion to Apache Parquet or ORC.";
        readonly searchKeywords: readonly ["Analytics", "kinesis analytics", "kinesis streams", "kinesis firehose", "firehose", "VPC", "data format conversion", "streaming", "data streaming", "real-time", "analysis", "kafka", "spark", "put records", "kcl", "kpl", "sql", "ORC", "stream processing", "sql on streams", "stream ingestion", "IoT analytics", "real-time bidding", "RTB", "log analytics", "clickstream analytics", "real time alerts", "real time dashboards", "real time monitoring", "dynamic partitioning"];
        readonly type: "AWSService";
        readonly regions: readonly ["us-gov-west-1", "us-gov-east-1", "af-south-1", "ap-east-1", "ap-south-1", "ap-northeast-2", "ap-southeast-1", "ap-southeast-2", "ap-southeast-3", "ap-northeast-1", "ap-northeast-2", "ap-northeast-3", "ca-central-1", "eu-central-1", "eu-west-1", "eu-west-2", "eu-south-1", "eu-west-3", "eu-north-1", "me-south-1", "sa-east-1", "us-east-1", "us-east-2", "us-west-1", "us-west-2"];
        readonly linkUrl: "https://aws.amazon.com/kinesis/data-firehose/";
        readonly isActive: "true";
        readonly disableConfigure: false;
        readonly serviceDefinitionLocation: "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonKinesisFirehose/en_US.json";
        readonly c2e: false;
        readonly templates: readonly [];
        readonly disableRegionSupport: false;
        readonly serviceDefinitionUrlPath: "/data/amazonKinesisFirehose/en_US.json";
        readonly slug: "KinesisDataFirehose";
        readonly mvpSupport: false;
        readonly comparableTerms: readonly ["kinesisdatafirehose", "kinesisfirehose"];
    };
    readonly amazonKinesisDataStreams: {
        readonly name: "Amazon Kinesis Data Streams";
        readonly serviceCode: "amazonKinesisDataStreams";
        readonly description: "Amazon Kinesis Data Streams (KDS) is a massively scalable and durable real-time data streaming service.";
        readonly searchKeywords: readonly ["Analytics", "kinesis analytics", "kinesis streams", "kinesis firehose", "streaming", "data streaming", "real-time", "analysis", "kafka", "spark", "put records", "kcl", "kpl", "sql", "stream processing", "sql on streams", "stream ingestion", "IoT analytics", "real-time bidding", "RTB", "log analytics", "clickstream analytics", "real time alerts", "real time dashboards", "real time monitoring"];
        readonly type: "AWSService";
        readonly regions: readonly ["af-south-1", "ap-east-1", "ap-northeast-1", "ap-northeast-2", "ap-northeast-3", "ap-south-1", "ap-southeast-1", "ap-southeast-2", "ap-southeast-3", "ca-central-1", "eu-central-1", "eu-north-1", "eu-south-1", "eu-west-1", "eu-west-2", "eu-west-3", "me-south-1", "me-central-1", "sa-east-1", "us-east-1", "us-east-2", "us-gov-east-1", "us-gov-west-1", "us-west-1", "us-west-2"];
        readonly linkUrl: "https://aws.amazon.com/kinesis/data-streams/";
        readonly isActive: "true";
        readonly disableConfigure: false;
        readonly serviceDefinitionLocation: "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonKinesisDataStreams/en_US.json";
        readonly c2e: false;
        readonly templates: readonly [];
        readonly disableRegionSupport: false;
        readonly slug: "KinesisDataStreams";
        readonly mvpSupport: false;
        readonly comparableTerms: readonly ["kinesisdatastreams"];
    };
    readonly amazonKinesisVideoStreams: {
        readonly name: "Amazon Kinesis Video Streams";
        readonly serviceCode: "amazonKinesisVideoStreams";
        readonly description: "Amazon Kinesis Video Streams makes it easy to securely stream video from connected devices to AWS for analytics, machine learning (ML), playback, and other processing. Kinesis Video Streams automatically provisions and elastically scales all the infrastructure needed to ingest streaming video data from millions of devices.";
        readonly searchKeywords: readonly ["video stream", "signaling channel", "turn streaming", "webRTC", "video analytics", "HTTP live streaming", "HLS", "KVS"];
        readonly type: "AWSService";
        readonly regions: readonly ["us-east-1", "us-east-2", "us-west-2", "ap-east-1", "ap-south-1", "ap-northeast-2", "ap-southeast-1", "ap-southeast-2", "ap-northeast-1", "ca-central-1", "eu-central-1", "eu-west-1", "eu-west-2", "eu-west-3", "sa-east-1"];
        readonly linkUrl: "https://aws.amazon.com/kinesis/video-streams";
        readonly isActive: "true";
        readonly disableConfigure: false;
        readonly serviceDefinitionLocation: "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonKinesisVideoStreams/en_US.json";
        readonly c2e: false;
        readonly templates: readonly [];
        readonly disableRegionSupport: false;
        readonly slug: "KinesisVideoStreams";
        readonly mvpSupport: false;
        readonly comparableTerms: readonly ["kinesisvideostreams"];
    };
    readonly amazonLex: {
        readonly name: "Amazon Lex";
        readonly serviceCode: "amazonLex";
        readonly description: "Amazon Lex is a service for building conversational interfaces into any application using voice and text. With Amazon Lex, you pay only for what you use.";
        readonly searchKeywords: readonly ["bot", "chat", "chatbot", "conversation", "conversational interfaces", "response", "speech", "streaming conversation", "text", "transcripts", "virtual agent", "voice chat"];
        readonly type: "AWSService";
        readonly regions: readonly ["us-east-1", "us-west-2", "af-south-1", "ap-northeast-2", "ap-southeast-1", "ap-southeast-2", "ap-northeast-1", "eu-west-2", "ca-central-1", "eu-central-1", "eu-west-1", "us-gov-west-1"];
        readonly linkUrl: "https://aws.amazon.com/lex";
        readonly isActive: "true";
        readonly serviceDefinitionLocation: "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonLex/en_US.json";
        readonly c2e: false;
        readonly slug: "lex";
        readonly mvpSupport: false;
        readonly comparableTerms: readonly ["lex"];
    };
    readonly amazonLightsail: {
        readonly name: "Amazon Lightsail";
        readonly serviceCode: "amazonLightsail";
        readonly description: "Lightsail is an easy-to-use virtual private server (VPS) that offers you everything needed to build an application or website, plus a cost-effective, monthly plan. Lightsail is ideal for simpler workloads, quick deployments, and getting started on AWS. It’s designed to help you start small, and then scale as you grow.";
        readonly searchKeywords: readonly ["virtual servers", "databases", "containers", "load balancer", "content delivery network", "CDN", "block storage", "snapshots", "vps", "virtual private server"];
        readonly type: "AWSService";
        readonly regions: readonly [];
        readonly linkUrl: "https://aws.amazon.com/lightsail/";
        readonly isActive: "true";
        readonly hasDataTransfer: true;
        readonly subType: "subServiceSelector";
        readonly disableConfigure: false;
        readonly serviceDefinitionLocation: "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonLightsail/en_US.json";
        readonly c2e: false;
        readonly templates: readonly ["lightsailVirtualServers", "lightsailManagedDatabases", "lightsailContainers", "lightsailObjectStorage", "lightsailCdn", "lightsailLoadBalancer", "lightsailBlockStorage", "lightsailDataTransfer"];
        readonly disableRegionSupport: false;
        readonly serviceDefinitionUrlPath: "/data/amazonLightsail/en_US.json";
        readonly slug: "Lightsail";
        readonly mvpSupport: false;
        readonly comparableTerms: readonly ["lightsail"];
    };
    readonly amazonLookoutForMetrics: {
        readonly name: "Amazon Lookout for Metrics";
        readonly serviceCode: "amazonLookoutForMetrics";
        readonly description: "Amazon Lookout for Metrics uses machine learning (ML) to automatically detect and diagnose anomalies (i.e. outliers from the norm) in business and operational data, such as a sudden dip in sales revenue or customer acquisition rates. In a couple of clicks, you can connect Amazon Lookout for Metrics to popular data stores like Amazon S3, Amazon Redshift, and Amazon Relational Database Service (RDS), as well as third-party SaaS applications, such as Salesforce, Servicenow, Zendesk, and Marketo, and start monitoring metrics that are important to your business. Amazon Lookout for Metrics automatically inspects and prepares the data from these sources to detect anomalies with greater speed and accuracy than traditional methods used for anomaly detection. You can also provide feedback on detected anomalies to tune the results and improve accuracy over time. Amazon Lookout for Metrics makes it easy to diagnose detected anomalies by grouping together anomalies that are related to the same event and sending an alert that includes a summary of the potential root cause. It also ranks anomalies in order of severity so that you can prioritize your attention to what matters the most to your business.";
        readonly searchKeywords: readonly ["lookout for metrics", "metrics", "anomalies", "anomaly detection", "machine learning", "ML-powered anomaly detection", "Anomaly Grouping and Ranking", "Tunable results", "automated alerts", "anomaly detection model", "detector", "outlier", "outlier detection"];
        readonly type: "AWSService";
        readonly regions: readonly ["us-east-2", "ap-southeast-2", "eu-north-1", "ap-southeast-1", "eu-west-1", "us-west-2", "us-east-1", "ap-northeast-1", "eu-central-1"];
        readonly linkUrl: "https://aws.amazon.com/lookout-for-metrics/";
        readonly isActive: "true";
        readonly serviceDefinitionLocation: "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonLookoutForMetrics/en_US.json";
        readonly c2e: false;
        readonly slug: "LookoutForMetrics";
        readonly mvpSupport: false;
        readonly comparableTerms: readonly ["lookoutformetrics", "lookoutmetrics"];
    };
    readonly amazonLookoutForVision: {
        readonly name: "Amazon Lookout for Vision";
        readonly serviceCode: "amazonLookoutForVision";
        readonly description: "Amazon Lookout for Vision is a machine learning (ML) service that spots defects and anomalies in visual representations using computer vision (CV). With Amazon Lookout for Vision, manufacturing companies can increase quality and reduce operational costs by quickly identifying differences in images of objects at scale.";
        readonly searchKeywords: readonly ["lookout", "vision"];
        readonly type: "AWSService";
        readonly regions: readonly ["ap-northeast-2", "ap-northeast-1", "eu-central-1", "eu-west-1", "us-east-1", "us-east-2", "us-west-2"];
        readonly linkUrl: "https://aws.amazon.com/lookout-for-vision/";
        readonly isActive: "true";
        readonly serviceDefinitionLocation: "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonLookoutForVision/en_US.json";
        readonly c2e: false;
        readonly slug: "LookoutVision";
        readonly comparableTerms: readonly ["lookoutforvision", "lookoutvision"];
    };
    readonly amazonMacie: {
        readonly name: "Amazon Macie";
        readonly serviceCode: "amazonMacie";
        readonly description: "Amazon Macie is a fully managed data security and data privacy service that uses machine learning and pattern matching to discover and protect your sensitive data in AWS. With Amazon Macie, you are charged based on the number of Amazon S3 buckets evaluated for bucket-level security and access controls and the quantity of data processed for sensitive data discovery.";
        readonly searchKeywords: readonly ["data security", "data privacy", "machine learning", "pattern matching", "sensitive data protection", "S3 buckets", "PII", "HIPAA", "GDPR"];
        readonly type: "AWSService";
        readonly regions: readonly ["us-east-1", "us-east-2", "us-west-1", "us-west-2", "af-south-1", "ap-east-1", "ap-south-1", "ap-northeast-3", "ap-northeast-2", "ap-southeast-1", "ap-southeast-2", "ap-northeast-1", "ca-central-1", "eu-central-1", "eu-west-1", "eu-west-2", "eu-south-1", "eu-west-3", "eu-north-1", "me-south-1", "sa-east-1"];
        readonly linkUrl: "https://aws.amazon.com/macie/";
        readonly isActive: "true";
        readonly serviceDefinitionLocation: "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonMacie/en_US.json";
        readonly c2e: false;
        readonly slug: "Macie";
        readonly mvpSupport: false;
        readonly comparableTerms: readonly ["macie"];
    };
    readonly amazonManagedBlockchain: {
        readonly name: "Amazon Managed Blockchain";
        readonly serviceCode: "amazonManagedBlockchain";
        readonly description: "Amazon Managed Blockchain is a fully managed service that makes it easy to join public networks or create and manage scalable private networks using the popular open-source frameworks Hyperledger Fabric and Ethereum.";
        readonly searchKeywords: readonly ["hyperledger Fabric", "ethereum", "blockchain", "managed blockchain"];
        readonly type: "AWSService";
        readonly regions: readonly ["us-east-1", "ap-northeast-1", "ap-northeast-2", "ap-southeast-1", "eu-west-1", "eu-west-2"];
        readonly linkUrl: "https://aws.amazon.com/managed-blockchain/";
        readonly isActive: "true";
        readonly serviceDefinitionLocation: "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonManagedBlockchain/en_US.json";
        readonly c2e: false;
        readonly slug: "ManagedBlockchain";
        readonly mvpSupport: false;
        readonly comparableTerms: readonly ["managedblockchain"];
    };
    readonly amazonManagedServiceForPrometheus: {
        readonly name: "Amazon Managed Service for Prometheus";
        readonly serviceCode: "amazonManagedServiceForPrometheus";
        readonly description: "Amazon Managed Service for Prometheus is a Prometheus-compatible monitoring service that makes it easy to monitor containerized applications at scale. The Cloud Native Computing Foundation’s Prometheus project is a popular open source monitoring and alerting solution optimized for container environments. With Amazon Managed Service for Prometheus, you can use the open source Prometheus query language (PromQL) to monitor the performance of containerized workloads, without having to manage the underlying infrastructure.";
        readonly searchKeywords: readonly ["MSP", "Prometheus", "Managed Service for Prometheus"];
        readonly type: "AWSService";
        readonly regions: readonly ["ap-southeast-1", "ap-southeast-2", "ap-northeast-1", "eu-central-1", "eu-west-1", "eu-west-2", "eu-north-1", "us-east-1", "us-east-2", "us-west-2"];
        readonly linkUrl: "https://aws.amazon.com/prometheus/";
        readonly isActive: "true";
        readonly disableConfigure: false;
        readonly serviceDefinitionLocation: "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonManagedServiceForPrometheus/en_US.json";
        readonly c2e: false;
        readonly slug: "Prometheus";
        readonly mvpSupport: false;
        readonly comparableTerms: readonly ["managedserviceforprometheus", "managedserviceprometheus", "prometheus"];
    };
    readonly amazonManagedStreamingForApacheKafkaMsk: {
        readonly name: "Amazon Managed Streaming for Apache Kafka (MSK)";
        readonly serviceCode: "amazonManagedStreamingForApacheKafkaMsk";
        readonly description: "Amazon MSK is a fully managed service that makes it easy for you to build and run applications that use Apache Kafka to process streaming data. With Amazon MSK, you can use native Apache Kafka APIs to populate data lakes, stream changes to and from databases, and power machine learning and analytics applications.";
        readonly searchKeywords: readonly ["MSK", "Apache Kafka"];
        readonly type: "AWSService";
        readonly regions: readonly ["af-south-1", "ap-east-1", "ap-south-1", "ap-northeast-2", "ap-southeast-1", "ap-southeast-2", "ap-northeast-1", "ap-northeast-3", "us-gov-east-1", "us-gov-west-1", "ca-central-1", "eu-central-1", "eu-west-1", "eu-west-2", "eu-south-1", "eu-west-3", "eu-north-1", "me-south-1", "sa-east-1", "us-east-1", "us-east-2", "us-west-1", "us-west-2"];
        readonly isActive: "true";
        readonly disableConfigure: false;
        readonly serviceDefinitionLocation: "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonManagedStreamingForApacheKafkaMsk/en_US.json";
        readonly c2e: false;
        readonly templates: readonly [];
        readonly disableRegionSupport: false;
        readonly slug: "MSK";
        readonly mvpSupport: false;
        readonly comparableTerms: readonly ["managedstreamingapachekafkamsk", "managedstreamingforapachekafkamsk", "msk"];
    };
    readonly amazonManagedWorkflowsForApacheAirflow: {
        readonly name: "Amazon Managed Workflows for Apache Airflow";
        readonly serviceCode: "amazonManagedWorkflowsForApacheAirflow";
        readonly description: "Amazon Managed Workflows for Apache Airflow (MWAA) is a managed orchestration service for Apache Airflow1 that makes it easier to set up and operate end-to-end data pipelines in the cloud at scale. Apache Airflow is an open-source tool used to programmatically author, schedule, and monitor sequences of processes and tasks referred to as “workflows.” With Managed Workflows, you can use Airflow and Python to create workflows without having to manage the underlying infrastructure for scalability, availability, and security.";
        readonly searchKeywords: readonly ["MWAA", "Workflows", "Apache Airflow", "Managed Workflows for Apache Airflow"];
        readonly type: "AWSService";
        readonly regions: readonly ["us-east-1", "us-east-2", "us-west-1", "us-west-2", "ap-south-1", "ap-northeast-2", "ap-southeast-1", "ap-southeast-2", "ap-northeast-1", "ca-central-1", "eu-central-1", "eu-west-1", "eu-west-2", "eu-west-3", "eu-north-1", "sa-east-1"];
        readonly linkUrl: "https://aws.amazon.com/managed-workflows-for-apache-airflow/";
        readonly isActive: "true";
        readonly serviceDefinitionLocation: "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonManagedWorkflowsForApacheAirflow/en_US.json";
        readonly c2e: false;
        readonly slug: "MWAA";
        readonly mvpSupport: false;
        readonly comparableTerms: readonly ["managedworkflowsapacheairflow", "managedworkflowsforapacheairflow", "mwaa"];
    };
    readonly amazonMemoryDbForRedis: {
        readonly name: "Amazon MemoryDB for Redis";
        readonly serviceCode: "amazonMemoryDbForRedis";
        readonly description: "Amazon MemoryDB for Redis is a Redis-compatible, durable, in-memory database that delivers ultra-fast performance and Multi-AZ durability.";
        readonly searchKeywords: readonly ["memorydb", "Amazon MemoryDB for Redis"];
        readonly type: "AWSService";
        readonly regions: readonly ["us-east-1", "us-east-2", "us-west-1", "us-west-2", "ap-east-1", "ap-south-1", "ap-northeast-2", "ap-southeast-1", "ap-southeast-2", "ap-northeast-1", "ca-central-1", "eu-central-1", "eu-west-1", "eu-west-2", "eu-west-3", "eu-north-1", "eu-south-1", "sa-east-1"];
        readonly linkUrl: "https://aws.amazon.com/memorydb/";
        readonly isActive: "true";
        readonly disableConfigure: false;
        readonly serviceDefinitionLocation: "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonMemoryDbForRedis/en_US.json";
        readonly c2e: false;
        readonly templates: readonly [];
        readonly disableRegionSupport: false;
        readonly bulkImportEnabled: false;
        readonly serviceDefinitionUrlPath: "/data/amazonMemoryDbForRedis/en_US.json";
        readonly slug: "memorydb";
        readonly mvpSupport: false;
        readonly comparableTerms: readonly ["memorydb", "memorydbforredis", "memorydbredis"];
    };
    readonly amazonMQ: {
        readonly name: "Amazon MQ";
        readonly serviceCode: "amazonMQ";
        readonly description: "Amazon MQ is a managed message broker service for Apache ActiveMQ that makes it easy to set up and operate message brokers in the cloud.";
        readonly searchKeywords: readonly ["MQ", "rabbit", "broker", "Apache ActiveMQ"];
        readonly type: "AWSService";
        readonly regions: readonly ["us-east-1", "us-east-2", "us-west-1", "us-west-2", "af-south-1", "ap-east-1", "ap-northeast-1", "ap-northeast-2", "ap-northeast-3", "ap-south-1", "ap-southeast-1", "ap-southeast-2", "ap-southeast-3", "ca-central-1", "eu-central-1", "eu-north-1", "eu-south-1", "eu-west-1", "eu-west-2", "eu-west-3", "sa-east-1", "me-south-1", "us-gov-west-1", "us-gov-east-1"];
        readonly linkUrl: "https://aws.amazon.com/amazon-mq/";
        readonly isActive: "true";
        readonly hasDataTransfer: true;
        readonly disableConfigure: false;
        readonly serviceDefinitionLocation: "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonMQ/en_US.json";
        readonly c2e: false;
        readonly templates: readonly [];
        readonly disableRegionSupport: false;
        readonly serviceDefinitionUrlPath: "/data/amazonMQ/en_US.json";
        readonly slug: "MQ";
        readonly mvpSupport: false;
        readonly comparableTerms: readonly ["mq"];
    };
    readonly amazonNeptune: {
        readonly name: "Amazon Neptune";
        readonly serviceCode: "amazonNeptune";
        readonly description: "Amazon Neptune is a fast, reliable, fully managed graph database service that makes it easy to build and run applications that work with highly connected datasets.";
        readonly searchKeywords: readonly ["Neptune", "Graph database"];
        readonly type: "AWSService";
        readonly regions: readonly ["af-south-1", "ap-east-1", "ap-northeast-1", "ap-northeast-2", "ap-south-1", "ap-southeast-1", "ap-southeast-2", "ca-central-1", "eu-central-1", "eu-north-1", "eu-west-1", "eu-west-2", "eu-west-3", "me-south-1", "sa-east-1", "us-east-1", "us-east-2", "us-gov-west-1", "us-gov-east-1", "us-west-1", "us-west-2"];
        readonly linkUrl: "https://aws.amazon.com/neptune/";
        readonly isActive: "true";
        readonly disableConfigure: false;
        readonly serviceDefinitionLocation: "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonNeptune/en_US.json";
        readonly c2e: false;
        readonly templates: readonly [];
        readonly disableRegionSupport: false;
        readonly slug: "neptune";
        readonly mvpSupport: false;
        readonly comparableTerms: readonly ["neptune"];
    };
    readonly amazonElasticsearchService: {
        readonly name: "Amazon OpenSearch Service";
        readonly serviceCode: "amazonElasticsearchService";
        readonly description: "Amazon OpenSearch Service is a fully managed service that makes it easy for you to deploy, secure, and operate OpenSearch clusters at scale.";
        readonly searchKeywords: readonly ["Analytics", "ES", "Kibana", "Logstash", "Search", "Text search", "Time series", "Log analytics", "Analytics", "Real time analytics", "Streaming data analytics", "CloudSearch", "search", "ultraWarm", "ultrawarm", "opensearch", "open search"];
        readonly type: "AWSService";
        readonly regions: readonly ["af-south-1", "ap-east-1", "ap-south-1", "ap-northeast-2", "ap-southeast-1", "ap-southeast-2", "ap-southeast-3", "ap-northeast-1", "ap-northeast-3", "us-gov-east-1", "us-gov-west-1", "ca-central-1", "eu-central-1", "eu-west-1", "eu-west-2", "eu-west-3", "eu-north-1", "eu-south-1", "me-south-1", "me-central-1", "sa-east-1", "us-east-1", "us-east-2", "us-west-1", "us-west-2"];
        readonly linkUrl: "https://aws.amazon.com/opensearch-service/";
        readonly isActive: "true";
        readonly disableConfigure: false;
        readonly serviceDefinitionLocation: "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonElasticsearchService/en_US.json";
        readonly c2e: false;
        readonly templates: readonly [];
        readonly disableRegionSupport: false;
        readonly bulkImportEnabled: false;
        readonly serviceDefinitionUrlPath: "/data/amazonElasticsearchService/en_US.json";
        readonly slug: "OpenSearchService";
        readonly mvpSupport: false;
        readonly comparableTerms: readonly ["elasticsearch", "elasticsearchservice", "opensearch", "opensearchservice"];
    };
    readonly amazonPersonalize: {
        readonly name: "Amazon Personalize";
        readonly serviceCode: "amazonPersonalize";
        readonly description: "Amazon Personalize enables developers to build applications with the same machine learning (ML) technology used by Amazon.com for real-time personalized recommendations – no ML expertise required.";
        readonly searchKeywords: readonly ["personalize", "Amazon personalize"];
        readonly type: "AWSService";
        readonly regions: readonly ["ap-northeast-1", "ap-northeast-2", "ap-south-1", "ap-southeast-1", "ap-southeast-2", "ca-central-1", "eu-central-1", "eu-west-1", "us-east-1", "us-east-2", "us-west-2"];
        readonly linkUrl: "https://aws.amazon.com/personalize/";
        readonly isActive: "true";
        readonly disableConfigure: false;
        readonly serviceDefinitionLocation: "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonPersonalize/en_US.json";
        readonly c2e: false;
        readonly slug: "personalize";
        readonly mvpSupport: false;
        readonly comparableTerms: readonly ["personalize"];
    };
    readonly amazonPinpoint: {
        readonly name: "Amazon Pinpoint";
        readonly serviceCode: "amazonPinpoint";
        readonly description: "Amazon Pinpoint is a flexible and scalable outbound and inbound marketing communications service. You can connect with customers over channels like email, SMS, push, or voice. Amazon Pinpoint is easy to set up, easy to use, and is flexible for all marketing communication scenarios. ";
        readonly searchKeywords: readonly ["marketing", "communications", "email", "SMS", "messages", "campaign"];
        readonly type: "AWSService";
        readonly regions: readonly ["us-west-2", "us-east-1", "ap-northeast-2", "ap-south-1", "ap-southeast-2", "ap-northeast-1", "ap-southeast-1", "eu-west-2", "eu-west-1", "eu-central-1", "ca-central-1", "us-gov-west-1"];
        readonly linkUrl: "https://aws.amazon.com/pinpoint/";
        readonly isActive: "true";
        readonly disableConfigure: false;
        readonly serviceDefinitionLocation: "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonPinpoint/en_US.json";
        readonly c2e: false;
        readonly templates: readonly [];
        readonly disableRegionSupport: false;
        readonly serviceDefinitionUrlPath: "/data/amazonPinpoint/en_US.json";
        readonly slug: "Pinpoint";
        readonly mvpSupport: false;
        readonly comparableTerms: readonly ["pinpoint"];
    };
    readonly amazonPolly: {
        readonly name: "Amazon Polly";
        readonly serviceCode: "amazonPolly";
        readonly description: "Amazon Polly is a service that turns text into lifelike speech, allowing you to create applications that talk, and build entirely new categories of speech-enabled products.";
        readonly searchKeywords: readonly ["polly", "NLP", "speech", "text to speech"];
        readonly type: "AWSService";
        readonly regions: readonly [];
        readonly linkUrl: "https://aws.amazon.com/polly/";
        readonly isActive: "true";
        readonly subType: "subServiceSelector";
        readonly disableConfigure: false;
        readonly serviceDefinitionLocation: "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonPolly/en_US.json";
        readonly c2e: false;
        readonly templates: readonly ["neuralTextToSpeech", "standardTextToSpeechTts"];
        readonly disableRegionSupport: false;
        readonly serviceDefinitionUrlPath: "/data/amazonPolly/en_US.json";
        readonly slug: "polly";
        readonly mvpSupport: false;
        readonly comparableTerms: readonly ["polly"];
    };
    readonly amazonQuickSight: {
        readonly name: "Amazon QuickSight";
        readonly serviceCode: "amazonQuickSight";
        readonly description: "Amazon QuickSight is a fast, cloud-powered business intelligence service that makes it easy to deliver insights to everyone in your organization. QuickSight dashboards can be embedded in applications, require no infrastructure setup or management, and can automatically scale to tens of thousands of users.";
        readonly searchKeywords: readonly ["QuickSight", "Serverless", "Embedding", "BI", "Business intelligence", "Data visualization", "Insights", "Embedded Analytics"];
        readonly type: "AWSService";
        readonly regions: readonly [];
        readonly linkUrl: "https://aws.amazon.com/quicksight/";
        readonly isActive: "true";
        readonly subType: "subServiceSelector";
        readonly disableConfigure: false;
        readonly serviceDefinitionLocation: "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonQuickSight/en_US.json";
        readonly c2e: false;
        readonly templates: readonly ["amazonQuickSightReadersAuthorsSpice", "amazonQuickSightAnomalyDetection"];
        readonly disableRegionSupport: false;
        readonly serviceDefinitionUrlPath: "/data/amazonQuickSight/en_US.json";
        readonly slug: "QuickSight";
        readonly mvpSupport: false;
        readonly comparableTerms: readonly ["quicksight"];
    };
    readonly amazonQuickSightAnomalyDetection: {
        readonly name: "Amazon QuickSight Alerts & Anomaly Detection";
        readonly serviceCode: "amazonQuickSightAnomalyDetection";
        readonly description: "";
        readonly searchKeywords: readonly [];
        readonly type: "AWSService";
        readonly regions: readonly ["us-east-1", "us-east-2", "us-west-2", "ap-south-1", "ap-southeast-1", "ap-southeast-2", "ap-northeast-1", "ca-central-1", "eu-central-1", "eu-west-1", "eu-west-2", "eu-north-1", "sa-east-1", "us-gov-west-1"];
        readonly isActive: "true";
        readonly subType: "subService";
        readonly serviceDefinitionLocation: "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonQuickSightAnomalyDetection/en_US.json";
        readonly c2e: false;
        readonly mvpSupport: false;
        readonly comparableTerms: readonly ["quicksightalertsanomalydetection", "quicksightanomalydetection"];
        readonly parentServiceCode: "amazonQuickSight";
    };
    readonly amazonQuickSightReadersAuthorsSpice: {
        readonly name: "Amazon QuickSight Readers, Authors, SPICE";
        readonly serviceCode: "amazonQuickSightReadersAuthorsSpice";
        readonly description: "Amazon QuickSight is a fast, cloud-powered business intelligence service that makes it easy to deliver insights to everyone in your organization. QuickSight dashboards can be embedded in applications, require no infrastructure setup or management, and can automatically scale to tens of thousands of users.";
        readonly searchKeywords: readonly ["QuickSight", "Serverless", "Embedding", "BI", "Business intelligence", "Data visualization", "Insights", "Embedded Analytics"];
        readonly type: "AWSService";
        readonly regions: readonly ["us-east-1", "us-east-2", "us-west-2", "ap-south-1", "ap-southeast-1", "ap-southeast-2", "ap-northeast-1", "ca-central-1", "eu-central-1", "eu-west-1", "eu-west-2", "eu-north-1", "sa-east-1", "us-gov-west-1"];
        readonly linkUrl: "https://aws.amazon.com/quicksight/";
        readonly isActive: "true";
        readonly subType: "subService";
        readonly serviceDefinitionLocation: "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonQuickSightReadersAuthorsSpice/en_US.json";
        readonly c2e: false;
        readonly comparableTerms: readonly ["quicksightreadersauthorsspice"];
        readonly parentServiceCode: "amazonQuickSight";
    };
    readonly amazonRdsCustomForOracle: {
        readonly name: "Amazon RDS Custom for Oracle";
        readonly serviceCode: "amazonRdsCustomForOracle";
        readonly description: "Amazon Relational Database Service (Amazon RDS) Custom is a managed database service for legacy, custom, and packaged applications that require access to the underlying OS and DB environment. Amazon RDS Custom automates setup, operation, and scaling of databases in the cloud while granting access to the database and underlying operating system to configure settings, install patches, and enable native features to meet the dependent application's requirements.";
        readonly searchKeywords: readonly [];
        readonly type: "AWSService";
        readonly regions: readonly ["ap-northeast-1", "ap-southeast-1", "ap-southeast-2", "ap-south-1", "eu-central-1", "eu-north-1", "eu-west-1", "eu-west-2", "us-east-1", "us-east-2", "us-west-2"];
        readonly linkUrl: "https://aws.amazon.com/rds/custom";
        readonly isActive: "true";
        readonly hasDataTransfer: false;
        readonly disableConfigure: false;
        readonly serviceDefinitionLocation: "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonRdsCustomForOracle/en_US.json";
        readonly c2e: false;
        readonly templates: readonly [];
        readonly disableRegionSupport: false;
        readonly slug: "RDSCustomForOracle";
        readonly mvpSupport: false;
        readonly comparableTerms: readonly ["rdscustom", "rdscustomfororacle", "rdscustomoracle"];
    };
    readonly amazonRdsCustomForSqlServer: {
        readonly name: "Amazon RDS Custom for SQL Server";
        readonly serviceCode: "amazonRdsCustomForSqlServer";
        readonly description: "Amazon Relational Database Service (Amazon RDS) Custom is a managed database service for legacy, custom, and packaged applications that require access to the underlying OS and DB environment. Amazon RDS Custom automates setup, operation, and scaling of databases in the cloud while granting access to the database and underlying operating system to configure settings, install patches, and enable native features to meet the dependent application's requirements.";
        readonly searchKeywords: readonly [];
        readonly type: "AWSService";
        readonly regions: readonly ["ap-northeast-1", "ap-southeast-1", "ap-southeast-2", "ap-south-1", "eu-central-1", "eu-north-1", "eu-west-1", "eu-west-2", "us-east-1", "us-east-2", "us-west-2"];
        readonly linkUrl: "https://aws.amazon.com/rds/custom";
        readonly isActive: "true";
        readonly hasDataTransfer: false;
        readonly disableConfigure: false;
        readonly serviceDefinitionLocation: "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonRdsCustomForSqlServer/en_US.json";
        readonly c2e: false;
        readonly templates: readonly [];
        readonly disableRegionSupport: false;
        readonly slug: "RDSCustomForSQLServer";
        readonly mvpSupport: false;
        readonly comparableTerms: readonly ["rdscustom", "rdscustomforsqlserver", "rdscustomsqlserver"];
    };
    readonly amazonRDSMariaDB: {
        readonly name: "Amazon RDS for MariaDB";
        readonly serviceCode: "amazonRDSMariaDB";
        readonly description: "Amazon RDS makes it easy to set up, operate, and scale MariaDB database deployments in the cloud.";
        readonly searchKeywords: readonly ["Database", "MariaDB", "database hosting", "hosted database", "Managed database"];
        readonly type: "AWSService";
        readonly regions: readonly ["af-south-1", "ap-northeast-1", "ap-northeast-2", "ap-northeast-3", "ap-south-1", "ap-southeast-1", "ap-southeast-2", "ap-southeast-3", "ca-central-1", "eu-central-1", "eu-west-1", "eu-west-2", "eu-west-3", "eu-north-1", "eu-south-1", "sa-east-1", "us-east-1", "us-east-2", "us-gov-west-1", "us-west-1", "us-west-2", "us-gov-east-1", "ap-east-1", "me-south-1", "me-central-1"];
        readonly linkUrl: "https://aws.amazon.com/rds/mariadb";
        readonly isActive: "true";
        readonly hasDataTransfer: true;
        readonly disableConfigure: false;
        readonly serviceDefinitionLocation: "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonRDSMariaDB/en_US.json";
        readonly c2e: false;
        readonly templates: readonly [];
        readonly disableRegionSupport: false;
        readonly bulkImportEnabled: false;
        readonly serviceDefinitionUrlPath: "/data/amazonRDSMariaDB/en_US.json";
        readonly slug: "RDSMariaDB";
        readonly mvpSupport: false;
        readonly comparableTerms: readonly ["rdsmariadb"];
    };
    readonly amazonRDSMySQLDB: {
        readonly name: "Amazon RDS for MySQL";
        readonly serviceCode: "amazonRDSMySQLDB";
        readonly description: "MySQL is the world's most popular open source relational database. Amazon RDS makes it easy to set up, operate, and scale MySQL deployments in the cloud.";
        readonly searchKeywords: readonly [];
        readonly type: "AWSService";
        readonly regions: readonly ["af-south-1", "ap-northeast-1", "ap-northeast-2", "ap-northeast-3", "ap-south-1", "ap-southeast-1", "ap-southeast-2", "ap-southeast-3", "ca-central-1", "eu-central-1", "eu-south-1", "eu-west-1", "eu-west-2", "eu-west-3", "sa-east-1", "us-east-1", "us-east-2", "us-gov-west-1", "us-west-1", "us-west-2", "us-gov-east-1", "eu-north-1", "ap-east-1", "me-south-1", "me-central-1"];
        readonly linkUrl: "https://aws.amazon.com/rds/mysql";
        readonly isActive: "true";
        readonly disableConfigure: false;
        readonly serviceDefinitionLocation: "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonRDSMySQLDB/en_US.json";
        readonly c2e: false;
        readonly templates: readonly [];
        readonly disableRegionSupport: false;
        readonly bulkImportEnabled: false;
        readonly serviceDefinitionUrlPath: "/data/amazonRDSMySQLDB/en_US.json";
        readonly slug: "RDSMySQL";
        readonly mvpSupport: false;
        readonly comparableTerms: readonly ["rdsmysql", "rdsmysqldb"];
    };
    readonly amazonRdsForOracle: {
        readonly name: "Amazon RDS for Oracle";
        readonly serviceCode: "amazonRdsForOracle";
        readonly description: "Oracle® Database is a relational database management system developed by Oracle. Amazon RDS makes it easy to set up, operate, and scale Oracle Database deployments in the cloud. With Amazon RDS, you can deploy multiple editions of Oracle Database in minutes with cost-efficient and re-sizable hardware capacity.";
        readonly searchKeywords: readonly [];
        readonly type: "AWSService";
        readonly regions: readonly ["us-west-2", "us-west-1", "us-east-2", "us-east-1", "sa-east-1", "me-south-1", "me-central-1", "af-south-1", "eu-north-1", "eu-west-3", "eu-west-2", "eu-west-1", "eu-south-1", "eu-central-1", "ca-central-1", "us-gov-east-1", "us-gov-west-1", "ap-northeast-1", "ap-southeast-2", "ap-southeast-1", "ap-northeast-2", "ap-northeast-3", "ap-southeast-3", "ap-south-1", "ap-east-1"];
        readonly linkUrl: "https://aws.amazon.com/rds/oracle";
        readonly isActive: "true";
        readonly hasDataTransfer: false;
        readonly disableConfigure: false;
        readonly serviceDefinitionLocation: "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonRdsForOracle/en_US.json";
        readonly c2e: false;
        readonly templates: readonly [];
        readonly disableRegionSupport: false;
        readonly slug: "amazonRDSOracle";
        readonly mvpSupport: false;
        readonly comparableTerms: readonly ["rdsfororacle", "rdsoracle"];
    };
    readonly amazonRDSPostgreSQLDB: {
        readonly name: "Amazon RDS for PostgreSQL";
        readonly serviceCode: "amazonRDSPostgreSQLDB";
        readonly description: "Amazon RDS makes it easy to set up, operate, and scale PostgreSQL deployments in the cloud. With Amazon RDS, you can deploy scalable PostgreSQL deployments in minutes with cost-efficient and resizable hardware capacity. ";
        readonly searchKeywords: readonly ["Database", "PostgreSQL", "postgresql", "database hosting", "hosted database", "Managed database"];
        readonly type: "AWSService";
        readonly regions: readonly ["af-south-1", "ap-northeast-1", "ap-northeast-2", "ap-northeast-3", "ap-south-1", "ap-southeast-1", "ap-southeast-2", "ap-southeast-3", "ca-central-1", "eu-central-1", "eu-north-1", "eu-south-1", "eu-west-1", "eu-west-2", "eu-west-3", "sa-east-1", "us-east-1", "us-east-2", "us-gov-west-1", "us-west-1", "us-west-2", "us-gov-east-1", "ap-east-1", "me-south-1", "me-central-1"];
        readonly linkUrl: "https://aws.amazon.com/rds/postgresql";
        readonly isActive: "true";
        readonly hasDataTransfer: true;
        readonly disableConfigure: false;
        readonly serviceDefinitionLocation: "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonRDSPostgreSQLDB/en_US.json";
        readonly c2e: false;
        readonly templates: readonly [];
        readonly disableRegionSupport: false;
        readonly bulkImportEnabled: false;
        readonly serviceDefinitionUrlPath: "/data/amazonRDSPostgreSQLDB/en_US.json";
        readonly slug: "RDSPostgreSQL";
        readonly mvpSupport: false;
        readonly comparableTerms: readonly ["rdspostgresql", "rdspostgresqldb"];
    };
    readonly amazonRDSForSQLServer: {
        readonly name: "Amazon RDS for SQL server";
        readonly serviceCode: "amazonRDSForSQLServer";
        readonly description: "SQL Server is a relational database management system developed by Microsoft. Amazon RDS for SQL Server makes it easy to set up, operate, and scale SQL Server deployments in the cloud.";
        readonly searchKeywords: readonly ["Database", "Aurora", "MySQL", "MariaDB", "Postgres", "Oracle", "SQL Server", "Database", "PostgreSQL", "Microsoft SQL Server", "Relational Database Service", "Database", "database hosting", "hosted database", "Managed database", "microsoft", "sql", "msft", "Managed Service", "MS", "Managed", "win"];
        readonly type: "AWSService";
        readonly regions: readonly ["af-south-1", "us-west-2", "us-west-1", "us-east-2", "us-east-1", "sa-east-1", "me-south-1", "me-central-1", "eu-north-1", "eu-west-3", "eu-west-2", "eu-west-1", "eu-south-1", "eu-central-1", "ca-central-1", "us-gov-east-1", "us-gov-west-1", "ap-northeast-1", "ap-southeast-3", "ap-southeast-2", "ap-southeast-1", "ap-northeast-2", "ap-northeast-3", "ap-south-1", "ap-east-1"];
        readonly linkUrl: "https://aws.amazon.com/rds/";
        readonly isActive: "true";
        readonly disableConfigure: false;
        readonly serviceDefinitionLocation: "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonRDSForSQLServer/en_US.json";
        readonly c2e: false;
        readonly templates: readonly [];
        readonly disableRegionSupport: false;
        readonly slug: "RDSSQLServer";
        readonly mvpSupport: false;
        readonly comparableTerms: readonly ["rds", "rdsforsqlserver", "rdssqlserver"];
    };
    readonly amazonRdsForOutposts: {
        readonly name: "Amazon RDS on AWS Outposts";
        readonly serviceCode: "amazonRdsForOutposts";
        readonly description: "Amazon Relational Database Service (Amazon RDS) on AWS Outposts allows you to deploy fully managed database instances in your on-premises environments. AWS Outposts is a fully managed service that extends AWS infrastructure, AWS services, APIs, and tools to virtually any datacenter, co-location space, or on-premises facility for a truly consistent hybrid experience. You can deploy Amazon RDS on Outposts to set up, operate, and scale Microsoft SQL Server, MySQL and PostgreSQL relational databases on premises, just as you would in the cloud. Amazon RDS on Outposts provides cost-efficient and resizable capacity for on-premises databases, while automating time-consuming administration tasks including infrastructure provisioning, database setup, patching, and backups, freeing you to focus on your applications.";
        readonly searchKeywords: readonly [];
        readonly type: "AWSService";
        readonly regions: readonly ["af-south-1", "ap-east-1", "ap-east-1", "ap-northeast-1", "ap-northeast-2", "ap-south-1", "ap-southeast-1", "ap-southeast-2", "ca-central-1", "eu-central-1", "eu-north-1", "eu-south-1", "eu-west-1", "eu-west-2", "eu-west-3", "me-south-1", "sa-east-1", "us-east-1", "us-east-2", "us-west-1", "us-west-2"];
        readonly linkUrl: "https://aws.amazon.com/rds/outposts";
        readonly isActive: "true";
        readonly hasDataTransfer: false;
        readonly disableConfigure: false;
        readonly serviceDefinitionLocation: "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonRdsForOutposts/en_US.json";
        readonly c2e: false;
        readonly templates: readonly [];
        readonly disableRegionSupport: false;
        readonly slug: "RDSOutposts";
        readonly mvpSupport: false;
        readonly comparableTerms: readonly ["rdsforoutposts", "rdsonoutposts", "rdsoutposts"];
    };
    readonly amazonRedshift: {
        readonly name: "Amazon Redshift";
        readonly serviceCode: "amazonRedshift";
        readonly description: "Amazon Redshift is a fully managed, petabyte-scale data warehouse service in the cloud. Amazon Redshift also extends data warehouse queries to your data lake, with no loading required. You can run analytic queries against petabytes of data stored locally in Redshift, and directly against exabytes of data stored in Amazon S3.";
        readonly searchKeywords: readonly ["Database", "data warehouse", "data warehouse solution", "MySQL", "SQL", "data analysis", "business intelligence", "dw", "datawarehouse"];
        readonly type: "AWSService";
        readonly regions: readonly ["af-south-1", "ap-east-1", "ap-south-1", "ap-northeast-3", "ap-northeast-2", "ap-southeast-1", "ap-southeast-2", "ap-southeast-3", "ap-northeast-1", "us-gov-west-1", "us-gov-east-1", "ca-central-1", "eu-central-1", "eu-west-1", "eu-west-2", "eu-west-3", "eu-north-1", "eu-south-1", "me-south-1", "me-central-1", "sa-east-1", "us-east-1", "us-east-2", "us-west-1", "us-west-2"];
        readonly linkUrl: "https://aws.amazon.com/redshift/";
        readonly isActive: "true";
        readonly disableConfigure: false;
        readonly serviceDefinitionLocation: "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonRedshift/en_US.json";
        readonly c2e: false;
        readonly templates: readonly [];
        readonly disableRegionSupport: false;
        readonly slug: "Redshift";
        readonly mvpSupport: false;
        readonly comparableTerms: readonly ["redshift"];
    };
    readonly amazonRekognition: {
        readonly name: "Amazon Rekognition";
        readonly serviceCode: "amazonRekognition";
        readonly description: "Amazon Rekognition makes it easy to add image and video analysis to your applications using proven, highly scalable, deep learning technology that requires no machine learning expertise to use. With Amazon Rekognition, you can identify objects, people, text, scenes, and activities in images and videos, as well as detect any inappropriate content.";
        readonly searchKeywords: readonly ["Rekognition", "image", "custom labels", "video"];
        readonly type: "AWSService";
        readonly regions: readonly [];
        readonly linkUrl: "https://aws.amazon.com/rekognition/";
        readonly isActive: "true";
        readonly subType: "subServiceSelector";
        readonly disableConfigure: false;
        readonly serviceDefinitionLocation: "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonRekognition/en_US.json";
        readonly c2e: false;
        readonly templates: readonly ["rekognitionImage", "rekognitionVideo", "rekognitionStreamingVideoEvents", "rekognitionCustomLabels"];
        readonly disableRegionSupport: false;
        readonly serviceDefinitionUrlPath: "/data/amazonRekognition/en_US.json";
        readonly slug: "Rekognition";
        readonly mvpSupport: false;
        readonly comparableTerms: readonly ["rekognition"];
    };
    readonly amazonRoute53: {
        readonly name: "Amazon Route 53";
        readonly serviceCode: "amazonRoute53";
        readonly description: "Amazon Route 53 is a cloud Domain Name System (DNS) web service.";
        readonly searchKeywords: readonly [];
        readonly type: "AWSService";
        readonly regions: readonly ["ap-northeast-1", "ap-northeast-2", "ap-south-1", "ap-southeast-1", "ap-southeast-2", "ca-central-1", "eu-central-1", "eu-west-1", "eu-west-2", "eu-west-3", "me-south-1", "me-central-1", "sa-east-1", "us-east-1", "us-east-2", "us-gov-west-1", "us-west-1", "us-west-2"];
        readonly linkUrl: "https://aws.amazon.com/route53/";
        readonly isActive: "true";
        readonly disableConfigure: false;
        readonly serviceDefinitionLocation: "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonRoute53/en_US.json";
        readonly c2e: false;
        readonly templates: readonly [];
        readonly disableRegionSupport: false;
        readonly slug: "Route53";
        readonly mvpSupport: false;
        readonly comparableTerms: readonly ["route53"];
    };
    readonly amazonS3: {
        readonly name: "Amazon S3";
        readonly serviceCode: "amazonS3";
        readonly description: "Amazon Simple Storage Service (Amazon S3) is the largest and most performant, secure, and feature-rich object storage service. With Amazon S3, organizations of all sizes and industries can store any amount of data for any use case, including applications, IoT, data lakes, analytics, backup and restore, archive, and disaster recovery.";
        readonly type: "AWSService";
        readonly regions: readonly ["us-east-1", "us-east-2", "us-west-2", "eu-west-1", "eu-west-2", "eu-central-1", "ap-northeast-1", "ap-northeast-2", "ap-southeast-1", "ap-southeast-2", "ap-south-1"];
        readonly linkUrl: "https://aws.amazon.com/s3";
        readonly isActive: "false";
        readonly serviceDefinitionLocation: "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonS3/en_US.json";
        readonly comparableTerms: readonly ["s3"];
    };
    readonly amazonGlacier: {
        readonly name: "Amazon S3 Glacier (Glacier API only)";
        readonly serviceCode: "amazonGlacier";
        readonly description: "S3 Glacier is a secure, durable, and low-cost storage class for data archiving. You can reliably store any amount of data at costs that are competitive with or cheaper than on-premises solutions. To keep costs low yet suitable for varying needs, S3 Glacier provides three retrieval options that range from a few minutes to hours.";
        readonly searchKeywords: readonly [];
        readonly type: "AWSService";
        readonly regions: readonly ["af-south-1", "ap-east-1", "ap-northeast-1", "ap-northeast-2", "ap-northeast-3", "ap-south-1", "ap-southeast-1", "ap-southeast-2", "ca-central-1", "eu-central-1", "eu-north-1", "eu-south-1", "eu-west-1", "eu-west-2", "eu-west-3", "sa-east-1", "us-east-1", "us-east-2", "us-gov-east-1", "us-gov-west-1", "us-west-1", "us-west-2", "me-south-1", "me-central-1"];
        readonly linkUrl: "https://aws.amazon.com/glacier/";
        readonly isActive: "true";
        readonly hasDataTransfer: true;
        readonly disableConfigure: false;
        readonly serviceDefinitionLocation: "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonGlacier/en_US.json";
        readonly c2e: false;
        readonly templates: readonly [];
        readonly disableRegionSupport: false;
        readonly serviceDefinitionUrlPath: "/data/amazonGlacier/en_US.json";
        readonly slug: "S3Glacier";
        readonly mvpSupport: false;
        readonly comparableTerms: readonly ["glacier", "glacierapionly", "s3glacier", "s3glacierglacierapionly"];
    };
    readonly amazonSageMaker: {
        readonly name: "Amazon SageMaker";
        readonly serviceCode: "amazonSageMaker";
        readonly description: "With Amazon SageMaker, you pay only for what you use. Building, training, and deploying ML models is billed by the second, with no minimum fees and no upfront commitments. Pricing within Amazon SageMaker is broken down by on-demand ML instances, ML storage, and fees for data processing in hosting instances.";
        readonly searchKeywords: readonly ["Sagemaker", "Model", "ML", "Machine Learning", "EI", "data scientist", "Data Wrangler", "Feature Store", "Sagemaker Edge"];
        readonly type: "AWSService";
        readonly regions: readonly [];
        readonly linkUrl: "https://aws.amazon.com/sagemaker/";
        readonly isActive: "true";
        readonly subType: "subServiceSelector";
        readonly disableConfigure: false;
        readonly serviceDefinitionLocation: "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonSageMaker/en_US.json";
        readonly c2e: false;
        readonly templates: readonly ["sageMakerStudioNotebooks", "sageMakerRStudioOnSageMaker", "sageMakerOnDemandNotebookInstances", "sageMakerProcessing", "sageMakerDataWrangler", "sageMakerFeatureStore", "sageMakerTraining", "sageMakerRealTimeInference", "sageMakerAsynchronousInference", "sageMakerBatchTransform", "amazonSageMakerEdgeManager", "sageMakerServerlessInference"];
        readonly disableRegionSupport: false;
        readonly serviceDefinitionUrlPath: "/data/amazonSageMaker/en_US.json";
        readonly slug: "SageMaker";
        readonly mvpSupport: false;
        readonly comparableTerms: readonly ["sagemaker"];
    };
    readonly amazonSageMakerGroundTruth: {
        readonly name: "Amazon SageMaker Ground Truth";
        readonly serviceCode: "amazonSageMakerGroundTruth";
        readonly description: "Amazon SageMaker Ground Truth helps you build training datasets for machine learning. Ground Truth will label your content (images, audio, text, etc) by guiding a human labeler step-by-step in a process called a workflow.";
        readonly searchKeywords: readonly ["Sagemaker", "ground truth", "computer vision", "3d point clouds", "image labeling", "labeler", "Model", "ML", "Machine Learning", "EI", "data scientist"];
        readonly type: "AWSService";
        readonly regions: readonly ["us-east-1", "eu-west-1", "ap-southeast-1", "ap-northeast-1", "us-west-2", "ap-southeast-2", "eu-central-1", "ap-northeast-2", "ap-south-1", "us-east-2", "ca-central-1", "eu-west-2"];
        readonly linkUrl: "https://aws.amazon.com/sagemaker/groundtruth/";
        readonly isActive: "true";
        readonly serviceDefinitionLocation: "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonSageMakerGroundTruth/en_US.json";
        readonly c2e: false;
        readonly slug: "SageMakerGroundTruth";
        readonly mvpSupport: false;
        readonly comparableTerms: readonly ["sagemakergroundtruth"];
    };
    readonly amazonSimpleEmailService: {
        readonly name: "Amazon Simple Email Service (SES)";
        readonly serviceCode: "amazonSimpleEmailService";
        readonly description: "Amazon Simple Email Service (Amazon SES) is a cloud-based email sending service designed to help digital marketers and application developers send marketing, notification, and transactional emails.";
        readonly searchKeywords: readonly ["SES", "Email", "Amazon Simple Email Service", "Simple Email Service"];
        readonly type: "AWSService";
        readonly regions: readonly ["af-south-1", "ap-south-1", "ap-northeast-2", "ap-northeast-3", "ap-southeast-1", "ap-southeast-2", "ap-northeast-1", "ca-central-1", "eu-central-1", "eu-west-1", "eu-west-2", "eu-west-3", "eu-north-1", "eu-south-1", "me-south-1", "sa-east-1", "us-east-1", "us-east-2", "us-west-1", "us-west-2", "us-west-2-wl1", "us-gov-west-1"];
        readonly linkUrl: "https://aws.amazon.com/ses/";
        readonly isActive: "true";
        readonly serviceDefinitionLocation: "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonSimpleEmailService/en_US.json";
        readonly c2e: false;
        readonly slug: "SES";
        readonly mvpSupport: false;
        readonly comparableTerms: readonly ["ses", "simpleemail", "simpleemailservice", "simpleemailserviceses"];
    };
    readonly amazonSimpleNotificationService: {
        readonly name: "Amazon Simple Notification Service (SNS)";
        readonly serviceCode: "amazonSimpleNotificationService";
        readonly description: "Amazon Simple Notification Service (SNS) is a highly available, durable, secure, fully managed pub/sub messaging service that enables you to decouple microservices, distributed systems, and serverless applications.";
        readonly searchKeywords: readonly ["Messaging", "SNS", "notification topic", "publish message", "subscription", "text message", "sms", "topics", "push notifications", "push notification service queuing"];
        readonly type: "AWSService";
        readonly regions: readonly [];
        readonly linkUrl: "https://aws.amazon.com/sns/";
        readonly isActive: "true";
        readonly subType: "subServiceSelector";
        readonly disableConfigure: false;
        readonly serviceDefinitionLocation: "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonSimpleNotificationService/en_US.json";
        readonly c2e: false;
        readonly templates: readonly ["standardTopics", "fifoTopics"];
        readonly disableRegionSupport: false;
        readonly serviceDefinitionUrlPath: "/data/amazonSimpleNotificationService/en_US.json";
        readonly slug: "SNS";
        readonly mvpSupport: false;
        readonly comparableTerms: readonly ["simplenotification", "simplenotificationservice", "simplenotificationservicesns", "sns"];
    };
    readonly amazonSimpleQueueService: {
        readonly name: "Amazon Simple Queue Service (SQS)";
        readonly serviceCode: "amazonSimpleQueueService";
        readonly description: "Amazon Simple Queue Service (SQS) is a fully managed message queuing service that enables you to decouple and scale microservices, distributed systems, and serverless applications.";
        readonly searchKeywords: readonly ["Messaging", "SQS", "queue service", "push notifications", "queueing", "message queueing", "batch processing", "managed queue", "transmit data", "hosted queues", "storing messages", "move data", "perform tasks", "decouple componenets", "message processing", "message repository", "temporary repository", "message delivery", "distributed queues", "delay queues"];
        readonly type: "AWSService";
        readonly regions: readonly ["af-south-1", "ap-east-1", "ap-south-1", "ap-northeast-3", "ap-northeast-2", "ap-southeast-1", "ap-southeast-2", "ap-southeast-3", "ap-northeast-1", "us-gov-west-1", "us-gov-east-1", "ca-central-1", "eu-central-1", "eu-west-1", "eu-west-2", "eu-west-3", "eu-south-1", "eu-north-1", "me-south-1", "me-central-1", "sa-east-1", "us-east-1", "us-east-2", "us-west-1", "us-west-2"];
        readonly linkUrl: "https://aws.amazon.com/sqs";
        readonly isActive: "true";
        readonly hasDataTransfer: true;
        readonly disableConfigure: false;
        readonly serviceDefinitionLocation: "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonSimpleQueueService/en_US.json";
        readonly c2e: false;
        readonly templates: readonly [];
        readonly disableRegionSupport: false;
        readonly slug: "SQS";
        readonly mvpSupport: false;
        readonly comparableTerms: readonly ["simplequeue", "simplequeueservice", "simplequeueservicesqs", "sqs"];
    };
    readonly amazonSimpleStorageServiceGroup: {
        readonly name: "Amazon Simple Storage Service (S3)";
        readonly serviceCode: "amazonSimpleStorageServiceGroup";
        readonly description: "Amazon Simple Storage Service (Amazon S3) is storage for the internet. You can use Amazon S3 to store and retrieve any amount of data at any time, from anywhere on the web.";
        readonly searchKeywords: readonly ["Storage", "Simple Storage Service", "bucket", "file storage", "cloud storage", "static website hosting", "object storage", "store objects", "store files", "data migration", "ongoing data ingestion", "backup and recovery", "big data analytics", "nearline archive", "disaster recovery", "content distribution", "cloud storage", "S3", "s3"];
        readonly type: "AWSService";
        readonly regions: readonly [];
        readonly linkUrl: "https://aws.amazon.com/s3/";
        readonly isActive: "true";
        readonly subType: "subServiceSelector";
        readonly disableConfigure: false;
        readonly serviceDefinitionLocation: "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonSimpleStorageServiceGroup/en_US.json";
        readonly c2e: false;
        readonly templates: readonly ["amazonS3Standard", "amazonS3IntelligentTiering", "amazonS3StandardInfrequentAccess", "s3OneZoneInfrequentAccess", "amazonS3Glacier", "amazonS3GlacierDeepArhive", "amazonS3StorageManagement", "s3ObjectLambda", "s3GlacierInstantRetrieval", "awsS3DataTransfer"];
        readonly disableRegionSupport: false;
        readonly serviceDefinitionUrlPath: "/data/amazonSimpleStorageServiceGroup/en_US.json";
        readonly slug: "S3";
        readonly mvpSupport: false;
        readonly comparableTerms: readonly ["s3", "simplestorageservicegroup", "simplestorageservices3"];
    };
    readonly amazonSimpleWorkflowService: {
        readonly name: "Amazon Simple Workflow Service (SWF)";
        readonly serviceCode: "amazonSimpleWorkflowService";
        readonly description: "Amazon SWF helps developers build, run, and scale background jobs that have parallel or sequential steps. You can think of Amazon SWF as a fully-managed state tracker and task coordinator in the Cloud.";
        readonly searchKeywords: readonly [];
        readonly type: "AWSService";
        readonly regions: readonly ["af-south-1", "ap-east-1", "ap-northeast-1", "ap-northeast-2", "ap-northeast-3", "ap-south-1", "ap-southeast-1", "ap-southeast-2", "ap-southeast-3", "ca-central-1", "eu-central-1", "eu-north-1", "eu-south-1", "eu-west-1", "eu-west-2", "eu-west-3", "sa-east-1", "us-east-1", "us-east-2", "us-gov-east-1", "us-gov-west-1", "us-west-1", "us-west-2", "me-south-1", "me-central-1"];
        readonly linkUrl: "https://aws.amazon.com/swf/";
        readonly isActive: "true";
        readonly disableConfigure: false;
        readonly serviceDefinitionLocation: "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonSimpleWorkflowService/en_US.json";
        readonly c2e: false;
        readonly templates: readonly [];
        readonly disableRegionSupport: false;
        readonly slug: "SWF";
        readonly mvpSupport: false;
        readonly comparableTerms: readonly ["simpleworkflow", "simpleworkflowservice", "simpleworkflowserviceswf", "swf"];
    };
    readonly amazonTextract: {
        readonly name: "Amazon Textract";
        readonly serviceCode: "amazonTextract";
        readonly description: "Amazon Textract is a fully managed machine learning service that automatically extracts printed text, handwriting, and other data from scanned documents that goes beyond simple optical character recognition (OCR) to identify, understand, and extract data from forms and tables.";
        readonly searchKeywords: readonly ["textract", "text"];
        readonly type: "AWSService";
        readonly regions: readonly ["us-gov-west-1", "us-gov-east-1", "ap-south-1", "ap-northeast-2", "ap-southeast-1", "ap-southeast-2", "ca-central-1", "eu-central-1", "eu-west-1", "eu-west-2", "eu-west-3", "us-east-1", "us-east-2", "us-west-1", "us-west-2"];
        readonly linkUrl: "https://aws.amazon.com/textract/";
        readonly isActive: "true";
        readonly serviceDefinitionLocation: "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonTextract/en_US.json";
        readonly c2e: false;
        readonly slug: "Textract";
        readonly mvpSupport: false;
        readonly comparableTerms: readonly ["textract"];
    };
    readonly amazonTranscribe: {
        readonly name: "Amazon Transcribe";
        readonly serviceCode: "amazonTranscribe";
        readonly description: "Amazon Transcribe is a fully-managed automatic speech recognition (ASR) service that makes it easy for developers to add speech-to-text capabilities to voice applications. Powered by deep learning, the service supports transcription through its batch file (asynchronous) and streaming (real-time) APIs. Amazon Transcribe offers accurate transcription across more than 30 global languages and accents.";
        readonly searchKeywords: readonly ["transcribe", "transcription", "STT", "VTT", "audio", "voice", "subtitles", "caption", "language", "scribes", "vocabulary", "medical", "archiving", "archives", "call", "analytics", "call analytics"];
        readonly type: "AWSService";
        readonly regions: readonly ["af-south-1", "ap-east-1", "ap-northeast-1", "ap-northeast-2", "ap-south-1", "ap-southeast-1", "ap-southeast-2", "ca-central-1", "eu-central-1", "eu-west-1", "eu-west-2", "eu-west-3", "eu-north-1", "sa-east-1", "me-south-1", "us-east-1", "us-east-2", "us-gov-east-1", "us-gov-west-1", "us-west-1", "us-west-2"];
        readonly linkUrl: "https://aws.amazon.com/transcribe/";
        readonly isActive: "true";
        readonly serviceDefinitionLocation: "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonTranscribe/en_US.json";
        readonly c2e: false;
        readonly slug: "Transcribe";
        readonly mvpSupport: false;
        readonly comparableTerms: readonly ["transcribe"];
    };
    readonly amazonTranscribeMedical: {
        readonly name: "Amazon Transcribe Medical";
        readonly serviceCode: "amazonTranscribeMedical";
        readonly description: "Amazon Transcribe Medical is a HIPAA-eligible automatic speech recognition (ASR) service that makes it easy for developers to add speech-to-text capabilities to their healthcare and life science applications.";
        readonly searchKeywords: readonly ["transcribe", "transcription", "STT", "VTT", "audio", "voice", "subtitles", "caption", "language", "scribes", "vocabulary", "medical", "archiving", "archives"];
        readonly type: "AWSService";
        readonly regions: readonly ["ap-southeast-2", "ca-central-1", "eu-west-1", "us-east-1", "us-east-2", "us-west-2"];
        readonly linkUrl: "https://aws.amazon.com/transcribe/";
        readonly isActive: "true";
        readonly serviceDefinitionLocation: "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonTranscribeMedical/en_US.json";
        readonly c2e: false;
        readonly slug: "TranscribeMedical";
        readonly comparableTerms: readonly ["transcribe", "transcribemedical"];
    };
    readonly amazonTranslate: {
        readonly name: "Amazon Translate";
        readonly serviceCode: "amazonTranslate";
        readonly description: "Amazon Translate is a neural machine translation service that delivers fast, high-quality, and affordable language translation. Neural machine translation is a form of language translation automation that uses deep learning models to deliver more accurate and more natural sounding translation than traditional statistical and rule-based translation algorithms.";
        readonly searchKeywords: readonly ["NLP", "Natural language processing", "language transalation", "Text analytics", "Language translation", "Amazon translate", "Translate"];
        readonly type: "AWSService";
        readonly regions: readonly [];
        readonly linkUrl: "https://aws.amazon.com/translate/";
        readonly isActive: "true";
        readonly subType: "subServiceSelector";
        readonly disableConfigure: false;
        readonly serviceDefinitionLocation: "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonTranslate/en_US.json";
        readonly c2e: false;
        readonly templates: readonly ["standardRealTimeTranslation", "standardBatchTranslation", "activeCustomBatchTranslation"];
        readonly disableRegionSupport: false;
        readonly serviceDefinitionUrlPath: "/data/amazonTranslate/en_US.json";
        readonly slug: "Translate";
        readonly mvpSupport: false;
        readonly comparableTerms: readonly ["translate"];
    };
    readonly amazonVirtualPrivateCloud: {
        readonly name: "Amazon Virtual Private Cloud (VPC)";
        readonly serviceCode: "amazonVirtualPrivateCloud";
        readonly description: "Amazon Virtual Private Cloud (Amazon VPC) lets you provision a logically isolated section of the AWS Cloud where you can launch AWS resources in a virtual network that you define.";
        readonly searchKeywords: readonly ["access control", "ACL", "AWS Privatelink", "Cloud connectivity", "corporate network", "elastic IP", "Gateway load balancer", "home network VPN", "IPAM", "NAT", "NAT gateway", "Network Access Analyzer", "Network Address Translation", "Networking Content Delivery", "PrivateLink", "Reachability Analyzer", "security", "single tenant hardware", "static ip", "subnets", "Traffic mirroring", "Transit Gateway", "Virtual Private Cloud", "VPN"];
        readonly type: "AWSService";
        readonly regions: readonly [];
        readonly linkUrl: "https://aws.amazon.com/vpc/";
        readonly isActive: "true";
        readonly subType: "subServiceSelector";
        readonly disableConfigure: false;
        readonly serviceDefinitionLocation: "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonVirtualPrivateCloud/en_US.json";
        readonly c2e: false;
        readonly templates: readonly ["vpnConnectionVpc", "networkAddressTranslationNatGatewayVpc", "transitGatewayVpc", "awsPrivateLinkVpc", "dataTransferVpc", "gatewayLoadBalancerVpc", "ipamVpc", "networkAccessAnalyzerVpc", "trafficMirroringVpc", "reachabilityAnalyzerVpc", "cloudWan"];
        readonly disableRegionSupport: false;
        readonly serviceDefinitionUrlPath: "/data/amazonVirtualPrivateCloud/en_US.json";
        readonly slug: "VPC";
        readonly mvpSupport: false;
        readonly comparableTerms: readonly ["virtualprivatecloud", "virtualprivatecloudvpc", "vpc"];
    };
    readonly amazonWorkdocs: {
        readonly name: "Amazon WorkDocs";
        readonly serviceCode: "amazonWorkdocs";
        readonly description: "Amazon WorkDocs is a fully managed, secure content creation, storage, and collaboration service. With Amazon WorkDocs, you can easily create, edit, and share content, and because it’s stored centrally on AWS, access it from anywhere on any device.";
        readonly searchKeywords: readonly [];
        readonly type: "AWSService";
        readonly regions: readonly ["ap-southeast-1", "ap-southeast-2", "ap-northeast-1", "eu-west-1", "us-east-1", "us-west-2"];
        readonly linkUrl: "https://aws.amazon.com/workdocs/";
        readonly isActive: "true";
        readonly disableConfigure: false;
        readonly serviceDefinitionLocation: "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonWorkdocs/en_US.json";
        readonly c2e: false;
        readonly templates: readonly [];
        readonly disableRegionSupport: false;
        readonly slug: "WorkDocs";
        readonly mvpSupport: false;
        readonly comparableTerms: readonly ["workdocs"];
    };
    readonly amazonWorkmail: {
        readonly name: "Amazon WorkMail";
        readonly serviceCode: "amazonWorkmail";
        readonly description: "Amazon WorkMail is a secure, managed business email and calendar service with support for existing desktop and mobile email client applications. Amazon WorkMail gives users the ability to seamlessly access their email, contacts, and calendars using the client application of their choice, including Microsoft Outlook, native iOS and Android email applications, any client application supporting the IMAP protocol, or directly through a web browser. You can integrate Amazon WorkMail with your existing corporate directory, use email journaling to meet compliance requirements, and control both the keys that encrypt your data and the location in which your data is stored. You can also set up interoperability with Microsoft Exchange Server, and programmatically manage users, groups, and resources using the Amazon WorkMail SDK.";
        readonly searchKeywords: readonly ["workmail", "business email", "managed email", "calendar service", "managed service", "outlook", "iOS", "andriod", "email applications", "exchange server", "IMAP"];
        readonly type: "AWSService";
        readonly regions: readonly ["eu-west-1", "us-east-1", "us-west-2"];
        readonly linkUrl: "https://aws.amazon.com/workmail/";
        readonly isActive: "true";
        readonly serviceDefinitionLocation: "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonWorkmail/en_US.json";
        readonly c2e: false;
        readonly slug: "WorkMail";
        readonly mvpSupport: false;
        readonly comparableTerms: readonly ["workmail"];
    };
    readonly amazonWorkspaces: {
        readonly name: "Amazon WorkSpaces";
        readonly serviceCode: "amazonWorkspaces";
        readonly description: "Amazon WorkSpaces is a managed, secure cloud desktop service. You can use Amazon WorkSpaces to provision either Windows or Linux desktops in just a few minutes and quickly scale to provide thousands of desktops to workers across the globe.";
        readonly searchKeywords: readonly ["cloud desktop", "workspaces"];
        readonly type: "AWSService";
        readonly regions: readonly ["us-gov-west-1", "ap-south-1", "ap-southeast-1", "ap-southeast-2", "ap-northeast-1", "ap-northeast-2", "ca-central-1", "eu-central-1", "eu-west-1", "eu-west-2", "us-east-1", "us-west-2", "sa-east-1"];
        readonly linkUrl: "https://aws.amazon.com/workspaces/";
        readonly isActive: "true";
        readonly hasDataTransfer: false;
        readonly disableConfigure: false;
        readonly serviceDefinitionLocation: "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonWorkspaces/en_US.json";
        readonly c2e: false;
        readonly templates: readonly [];
        readonly disableRegionSupport: false;
        readonly bulkImportEnabled: false;
        readonly serviceDefinitionUrlPath: "/data/amazonWorkspaces/en_US.json";
        readonly slug: "WorkSpaces";
        readonly mvpSupport: false;
        readonly comparableTerms: readonly ["workspaces"];
    };
    readonly applicationLoadBalancer: {
        readonly name: "Application Load Balancer";
        readonly serviceCode: "applicationLoadBalancer";
        readonly description: "Elastic Load Balancing automatically distributes incoming application traffic across multiple targets, such as Amazon EC2 instances, containers, IP addresses, and Lambda functions.";
        readonly searchKeywords: readonly ["ELB", "Elastic Load Balancer", "Load Balancer", "Application Load Balancer", "Network Load Balancer", "Classic Load Balancer"];
        readonly type: "AWSService";
        readonly regions: readonly ["af-south-1", "ap-east-1", "ap-northeast-1", "ap-northeast-2", "ap-northeast-3", "ap-south-1", "ap-southeast-1", "ap-southeast-2", "ap-southeast-3", "ca-central-1", "eu-central-1", "eu-north-1", "eu-south-1", "eu-west-1", "eu-west-2", "eu-west-3", "me-south-1", "me-central-1", "sa-east-1", "us-gov-east-1", "us-gov-west-1", "us-east-1", "us-east-1-atl-1", "us-east-1-bos-1", "us-east-1-chi-1", "us-east-1-dfw-1", "us-east-1-iah-1", "us-east-1-mci-1", "us-east-1-mia-1", "us-east-1-msp-1", "us-east-1-nyc-1", "us-east-1-phl-1", "us-east-2", "us-west-1", "us-west-2", "us-west-2-den-1", "us-west-2-las-1", "us-west-2-lax-1", "us-west-2-pdx-1", "us-west-2-phx-1", "us-west-2-sea-1", "us-east-1-wl1", "us-east-1-wl1-atl1", "us-east-1-wl1-chi1", "us-east-1-wl1-clt1", "us-east-1-wl1-dfw1", "us-east-1-wl1-dtw1", "us-east-1-wl1-iah1", "us-east-1-wl1-mia1", "us-east-1-wl1-msp1", "us-east-1-wl1-nyc1", "us-east-1-wl1-was1", "us-west-2-wl1", "us-west-2-wl1-den1", "us-west-2-wl1-las1", "us-west-2-wl1-lax1", "us-west-2-wl1-phx1", "us-west-2-wl1-sea1"];
        readonly linkUrl: "https://aws.amazon.com/elasticloadbalancing/";
        readonly isActive: "true";
        readonly subType: "subService";
        readonly disableConfigure: false;
        readonly serviceDefinitionLocation: "https://d1qsjq9pzbk1k6.cloudfront.net/data/applicationLoadBalancer/en_US.json";
        readonly c2e: false;
        readonly templates: readonly [];
        readonly disableRegionSupport: false;
        readonly bulkImportEnabled: false;
        readonly serviceDefinitionUrlPath: "/data/applicationLoadBalancer/en_US.json";
        readonly mvpSupport: false;
        readonly comparableTerms: readonly ["applicationloadbalancer"];
        readonly parentServiceCode: "elasticLoadBalancing";
    };
    readonly appSyncApiCall: {
        readonly name: "AppSync API Request";
        readonly serviceCode: "appSyncApiCall";
        readonly searchKeywords: readonly ["query", "graphql", "api"];
        readonly type: "AWSService";
        readonly regions: readonly ["ap-east-1", "ap-south-1", "ap-northeast-3", "ap-northeast-2", "ap-southeast-1", "ap-southeast-2", "ap-northeast-1", "ca-central-1", "eu-central-1", "eu-west-1", "eu-west-2", "eu-south-1", "eu-west-3", "eu-north-1", "me-south-1", "sa-east-1", "us-east-1", "us-east-2", "us-west-1", "us-west-2"];
        readonly linkUrl: "https://aws.amazon.com/appsync/";
        readonly isActive: "true";
        readonly subType: "subService";
        readonly disableConfigure: false;
        readonly serviceDefinitionLocation: "https://d1qsjq9pzbk1k6.cloudfront.net/data/appSyncApiCall/en_US.json";
        readonly c2e: false;
        readonly templates: readonly [];
        readonly disableRegionSupport: false;
        readonly serviceDefinitionUrlPath: "/data/appSyncApiCall/en_US.json";
        readonly mvpSupport: false;
        readonly comparableTerms: readonly ["appsyncapicall", "appsyncapirequest"];
        readonly parentServiceCode: "awsAppSync";
    };
    readonly appSyncCaching: {
        readonly name: "AppSync Caching";
        readonly serviceCode: "appSyncCaching";
        readonly searchKeywords: readonly ["query", "graphql", "api"];
        readonly type: "AWSService";
        readonly regions: readonly ["ap-east-1", "ap-south-1", "ap-northeast-3", "ap-northeast-2", "ap-southeast-1", "ap-southeast-2", "ap-northeast-1", "ca-central-1", "eu-central-1", "eu-west-1", "eu-west-2", "eu-south-1", "eu-west-3", "eu-north-1", "me-south-1", "sa-east-1", "us-east-1", "us-east-2", "us-west-1", "us-west-2"];
        readonly linkUrl: "https://aws.amazon.com/appsync/";
        readonly isActive: "true";
        readonly subType: "subService";
        readonly disableConfigure: false;
        readonly serviceDefinitionLocation: "https://d1qsjq9pzbk1k6.cloudfront.net/data/appSyncCaching/en_US.json";
        readonly c2e: false;
        readonly templates: readonly [];
        readonly disableRegionSupport: false;
        readonly serviceDefinitionUrlPath: "/data/appSyncCaching/en_US.json";
        readonly mvpSupport: false;
        readonly comparableTerms: readonly ["appsynccaching"];
        readonly parentServiceCode: "awsAppSync";
    };
    readonly appsyncDataTransfer: {
        readonly name: "Appsync Data Transfer";
        readonly serviceCode: "appsyncDataTransfer";
        readonly searchKeywords: readonly ["data transfer"];
        readonly type: "AWSService";
        readonly regions: readonly ["ap-east-1", "ap-south-1", "ap-northeast-3", "ap-northeast-2", "ap-southeast-1", "ap-southeast-2", "ap-northeast-1", "ca-central-1", "eu-central-1", "eu-west-1", "eu-west-2", "eu-south-1", "eu-west-3", "eu-north-1", "me-south-1", "sa-east-1", "us-east-1", "us-east-2", "us-west-1", "us-west-2"];
        readonly linkUrl: "https://aws.amazon.com/appsync/";
        readonly isActive: "true";
        readonly subType: "subService";
        readonly disableConfigure: false;
        readonly serviceDefinitionLocation: "https://d1qsjq9pzbk1k6.cloudfront.net/data/appsyncDataTransfer/en_US.json";
        readonly c2e: false;
        readonly templates: readonly [];
        readonly disableRegionSupport: false;
        readonly bulkImportEnabled: false;
        readonly serviceDefinitionUrlPath: "/data/appsyncDataTransfer/en_US.json";
        readonly mvpSupport: false;
        readonly comparableTerms: readonly ["appsyncdatatransfer"];
        readonly parentServiceCode: "awsAppSync";
    };
    readonly appSyncRealTime: {
        readonly name: "AppSync Real-Time";
        readonly serviceCode: "appSyncRealTime";
        readonly searchKeywords: readonly ["query"];
        readonly type: "AWSService";
        readonly regions: readonly ["ap-east-1", "ap-south-1", "ap-northeast-3", "ap-northeast-2", "ap-southeast-1", "ap-southeast-2", "ap-northeast-1", "ca-central-1", "eu-central-1", "eu-west-1", "eu-west-2", "eu-south-1", "eu-west-3", "eu-north-1", "me-south-1", "sa-east-1", "us-east-1", "us-east-2", "us-west-1", "us-west-2"];
        readonly linkUrl: "https://aws.amazon.com/appsync/";
        readonly isActive: "true";
        readonly subType: "subService";
        readonly disableConfigure: false;
        readonly serviceDefinitionLocation: "https://d1qsjq9pzbk1k6.cloudfront.net/data/appSyncRealTime/en_US.json";
        readonly c2e: false;
        readonly templates: readonly [];
        readonly disableRegionSupport: false;
        readonly serviceDefinitionUrlPath: "/data/appSyncRealTime/en_US.json";
        readonly mvpSupport: false;
        readonly comparableTerms: readonly ["appsyncrealtime"];
        readonly parentServiceCode: "awsAppSync";
    };
    readonly awsSystemsManagerAutomation: {
        readonly name: "Automation";
        readonly serviceCode: "awsSystemsManagerAutomation";
        readonly description: "AWS Systems Manager Automation feature";
        readonly searchKeywords: readonly ["System Manager", "Automation", "steps", "automate"];
        readonly type: "AWSService";
        readonly regions: readonly ["us-gov-west-1", "us-gov-east-1", "af-south-1", "ap-east-1", "ap-south-1", "ap-northeast-3", "ap-northeast-2", "ap-southeast-1", "ap-southeast-2", "ap-southeast-3", "ap-northeast-1", "ca-central-1", "eu-central-1", "eu-west-1", "eu-west-2", "eu-south-1", "eu-west-3", "eu-north-1", "me-south-1", "me-central-1", "sa-east-1", "us-east-1", "us-east-2", "us-west-1", "us-west-2"];
        readonly linkUrl: "https://aws.amazon.com/systems-manager/";
        readonly isActive: "true";
        readonly hasDataTransfer: false;
        readonly subType: "subService";
        readonly disableConfigure: false;
        readonly serviceDefinitionLocation: "https://d1qsjq9pzbk1k6.cloudfront.net/data/awsSystemsManagerAutomation/en_US.json";
        readonly c2e: false;
        readonly templates: readonly [];
        readonly disableRegionSupport: false;
        readonly serviceDefinitionUrlPath: "/data/awsSystemsManagerAutomation/en_US.json";
        readonly mvpSupport: false;
        readonly comparableTerms: readonly ["automation", "systemsmanagerautomation"];
        readonly parentServiceCode: "awsSystemsManager";
    };
    readonly awsAmplify: {
        readonly name: "AWS Amplify";
        readonly serviceCode: "awsAmplify";
        readonly description: "AWS Amplify is a set of tools and services that can be used together or on their own, to help front-end web and mobile developers build scalable full stack applications, powered by AWS. With Amplify, you can create an app backend for web and mobile, and then connect your Git branch to deploy and host a web app in a few clicks.";
        readonly searchKeywords: readonly ["authentication", "datastore", "storage", "console", "analytics", "mobile apps", "flows", "predictions", "api", "graphql", "pubsub", "hosting", "libraries", "user management", "content management", "UI", "frontend", "database", "ci/cd", "git"];
        readonly type: "AWSService";
        readonly regions: readonly ["us-east-1", "us-east-2", "us-west-1", "us-west-2", "ap-east-1", "ap-northeast-1", "ap-northeast-2", "ap-south-1", "ap-southeast-1", "ap-southeast-2", "ca-central-1", "eu-central-1", "eu-north-1", "eu-south-1", "eu-west-1", "eu-west-2", "eu-west-3", "me-south-1", "sa-east-1"];
        readonly linkUrl: "https://aws.amazon.com/amplify/";
        readonly isActive: "true";
        readonly serviceDefinitionLocation: "https://d1qsjq9pzbk1k6.cloudfront.net/data/awsAmplify/en_US.json";
        readonly c2e: false;
        readonly slug: "Amplify";
        readonly mvpSupport: false;
        readonly comparableTerms: readonly ["amplify"];
    };
    readonly awsAppConfig: {
        readonly name: "AWS AppConfig";
        readonly serviceCode: "awsAppConfig";
        readonly description: "AWS AppConfig enables you to provide validation logic to ensure your configuration data is syntactically and semantically correct according to your definitions before making it available to your application. AWS AppConfig also gives you the ability to roll out configuration changes over a defined time period while monitoring your application so that you can catch errors and roll back the changes if needed, to help you minimize the impact to the users.";
        readonly searchKeywords: readonly ["Systems Manager", "AppConfig", "configuration", "monitoring"];
        readonly type: "AWSService";
        readonly regions: readonly ["ap-east-1", "ap-south-1", "ap-northeast-2", "ap-southeast-1", "ap-southeast-2", "ap-southeast-3", "ap-northeast-1", "ap-northeast-3", "ca-central-1", "eu-central-1", "eu-west-1", "eu-west-2", "eu-west-3", "eu-north-1", "me-south-1", "me-central-1", "sa-east-1", "us-east-1", "us-east-2", "us-west-1", "us-west-2"];
        readonly linkUrl: "https://aws.amazon.com/systems-manager/";
        readonly isActive: "true";
        readonly hasDataTransfer: false;
        readonly subType: "subService";
        readonly disableConfigure: false;
        readonly serviceDefinitionLocation: "https://d1qsjq9pzbk1k6.cloudfront.net/data/awsAppConfig/en_US.json";
        readonly c2e: false;
        readonly templates: readonly [];
        readonly disableRegionSupport: false;
        readonly serviceDefinitionUrlPath: "/data/awsAppConfig/en_US.json";
        readonly mvpSupport: false;
        readonly comparableTerms: readonly ["appconfig"];
        readonly parentServiceCode: "awsSystemsManager";
    };
    readonly awsAppSync: {
        readonly name: "AWS AppSync";
        readonly serviceCode: "awsAppSync";
        readonly description: "AWS AppSync is a fully managed service that makes it easy to develop GraphQL APIs by handling the heavy lifting of securely connecting to data sources like AWS DynamoDB, Lambda, and more.";
        readonly searchKeywords: readonly ["appsync", "query", "data modification", "data transfer"];
        readonly type: "AWSService";
        readonly regions: readonly [];
        readonly linkUrl: "https://aws.amazon.com/appsync/";
        readonly isActive: "true";
        readonly subType: "subServiceSelector";
        readonly disableConfigure: false;
        readonly serviceDefinitionLocation: "https://d1qsjq9pzbk1k6.cloudfront.net/data/awsAppSync/en_US.json";
        readonly c2e: false;
        readonly templates: readonly ["appSyncApiCall", "appSyncRealTime", "appSyncCaching", "appsyncDataTransfer"];
        readonly disableRegionSupport: false;
        readonly serviceDefinitionUrlPath: "/data/awsAppSync/en_US.json";
        readonly slug: "appSync";
        readonly mvpSupport: false;
        readonly comparableTerms: readonly ["appsync"];
    };
    readonly mainframeBluAge: {
        readonly name: "AWS Blue Age automated refactoring";
        readonly serviceCode: "mainframeBluAge";
        readonly description: "For AWS M2 Blu Age managed runtime, you can choose on-demand instances and pay for the runtime by the hour with no long-term commitments or upfront fees, or choose committed plans for additional savings.";
        readonly searchKeywords: readonly [];
        readonly type: "AWSService";
        readonly regions: readonly ["ap-southeast-2", "ca-central-1", "eu-central-1", "eu-west-1", "sa-east-1", "us-east-1", "us-west-2"];
        readonly linkUrl: "https://aws.amazon.com/mainframe-modernization/pricing/";
        readonly isActive: "true";
        readonly subType: "subService";
        readonly disableConfigure: false;
        readonly serviceDefinitionLocation: "https://d1qsjq9pzbk1k6.cloudfront.net/data/mainframeBluAge/en_US.json";
        readonly c2e: false;
        readonly templates: readonly [];
        readonly disableRegionSupport: false;
        readonly serviceDefinitionUrlPath: "/data/mainframeBluAge/en_US.json";
        readonly mvpSupport: false;
        readonly comparableTerms: readonly ["blueageautomatedrefactoring", "mainframebluage"];
        readonly parentServiceCode: "amazonMainframeModernization";
    };
    readonly awsBudgets: {
        readonly name: "AWS Budgets";
        readonly serviceCode: "awsBudgets";
        readonly description: "AWS Budgets lets you set custom cost and usage budgets that alert you when your budget thresholds are exceeded (or forecasted to exceed). You can also create budgets to track your aggregate Reservation and Savings Plans utilization and coverage metrics.";
        readonly searchKeywords: readonly ["budgets", "cost management", "budgets report"];
        readonly type: "AWSService";
        readonly regions: readonly [];
        readonly linkUrl: "https://aws.amazon.com/aws-cost-management/aws-budgets/";
        readonly isActive: "true";
        readonly disableConfigure: false;
        readonly serviceDefinitionLocation: "https://d1qsjq9pzbk1k6.cloudfront.net/data/awsBudgets/en_US.json";
        readonly c2e: false;
        readonly templates: readonly [];
        readonly disableRegionSupport: false;
        readonly serviceDefinitionUrlPath: "/data/awsBudgets/en_US.json";
        readonly slug: "budgets";
        readonly mvpSupport: false;
        readonly comparableTerms: readonly ["budgets", "costmanagementbudgets"];
    };
    readonly awsCertificateManager: {
        readonly name: "AWS Certificate Manager";
        readonly serviceCode: "awsCertificateManager";
        readonly description: "AWS Certificate Manager is a service that lets you easily provision, manage, and deploy public and private Secure Sockets Layer/Transport Layer Security (SSL/TLS) certificates for use with AWS services and your internal connected resources.";
        readonly searchKeywords: readonly ["PCA", "ACM", "OCSP", "certificates x.509", "private"];
        readonly type: "AWSService";
        readonly regions: readonly ["af-south-1", "ap-east-1", "ap-south-1", "ap-northeast-3", "ap-northeast-2", "ap-southeast-1", "ap-southeast-2", "ap-southeast-2", "us-gov-east-1", "us-gov-west-1", "ca-central-1", "eu-central-1", "eu-west-1", "eu-west-2", "eu-south-1", "eu-west-3", "eu-north-1", "me-south-1", "sa-east-1", "us-east-1", "us-east-2", "us-west-1", "us-west-2"];
        readonly linkUrl: "https://aws.amazon.com/certificate-manager/";
        readonly isActive: "true";
        readonly serviceDefinitionLocation: "https://d1qsjq9pzbk1k6.cloudfront.net/data/awsCertificateManager/en_US.json";
        readonly c2e: false;
        readonly slug: "certificateManager";
        readonly mvpSupport: false;
        readonly comparableTerms: readonly ["certificatemanager"];
    };
    readonly awsCloudFormation: {
        readonly name: "AWS CloudFormation";
        readonly serviceCode: "awsCloudFormation";
        readonly description: "AWS CloudFormation provides a common language for you to model and provision AWS and third party application extensions in your cloud environment.";
        readonly searchKeywords: readonly ["cloudformation", "formation", "cloud", "application resources"];
        readonly type: "AWSService";
        readonly regions: readonly ["us-gov-west-1", "us-gov-east-1", "af-south-1", "ap-east-1", "ap-south-1", "ap-northeast-3", "ap-northeast-2", "ap-southeast-1", "ap-southeast-2", "ap-southeast-3", "ap-northeast-1", "ca-central-1", "eu-central-1", "eu-west-1", "eu-west-2", "eu-south-1", "eu-west-3", "eu-north-1", "me-south-1", "me-central-1", "sa-east-1", "us-east-1", "us-east-2", "us-west-1", "us-west-2"];
        readonly linkUrl: "https://aws.amazon.com/cloudformation/";
        readonly isActive: "true";
        readonly disableConfigure: false;
        readonly serviceDefinitionLocation: "https://d1qsjq9pzbk1k6.cloudfront.net/data/awsCloudFormation/en_US.json";
        readonly c2e: false;
        readonly templates: readonly [];
        readonly disableRegionSupport: false;
        readonly slug: "CloudFormation";
        readonly mvpSupport: false;
        readonly comparableTerms: readonly ["cloudformation"];
    };
    readonly awsCloudHsm: {
        readonly name: "AWS CloudHSM";
        readonly serviceCode: "awsCloudHsm";
        readonly description: "AWS CloudHSM is a cloud-based hardware security module (HSM) that enables you to easily generate and use your own encryption keys on the AWS Cloud. With CloudHSM, you can manage your own encryption keys using FIPS 140-2 Level 3 validated HSMs.";
        readonly searchKeywords: readonly ["crypto"];
        readonly type: "AWSService";
        readonly regions: readonly ["ap-east-1", "ap-south-1", "ap-northeast-2", "ap-southeast-1", "ap-southeast-2", "ap-northeast-1", "us-gov-west-1", "us-gov-east-1", "ca-central-1", "eu-central-1", "eu-west-1", "eu-west-2", "eu-west-3", "eu-north-1", "me-south-1", "sa-east-1", "us-east-1", "us-east-2", "us-west-1", "us-west-2", "eu-south-1", "af-south-1"];
        readonly linkUrl: "https://aws.amazon.com/cloudhsm";
        readonly isActive: "true";
        readonly serviceDefinitionLocation: "https://d1qsjq9pzbk1k6.cloudfront.net/data/awsCloudHsm/en_US.json";
        readonly c2e: false;
        readonly slug: "CloudHSM";
        readonly comparableTerms: readonly ["cloudhsm"];
    };
    readonly awsCloudTrail: {
        readonly name: "AWS CloudTrail";
        readonly serviceCode: "awsCloudTrail";
        readonly description: "AWS CloudTrail is a service that enables governance, compliance, operational auditing, and risk auditing of your AWS account. With CloudTrail, you can log, continuously monitor, and retain account activity related to actions across your AWS infrastructure.";
        readonly searchKeywords: readonly ["cloudtrail", "operational auditing", "governance", "compliance", "risk auditing", "event history", "unusual activity", "troubleshooting", "operational analysis", "logs", "monitor account activity", "trail"];
        readonly type: "AWSService";
        readonly regions: readonly ["af-south-1", "ap-east-1", "ap-south-1", "ap-northeast-3", "ap-northeast-2", "ap-southeast-1", "ap-southeast-2", "ap-southeast-3", "ap-northeast-1", "us-gov-east-1", "us-gov-west-1", "ca-central-1", "eu-central-1", "eu-west-1", "eu-west-2", "eu-south-1", "eu-west-3", "eu-north-1", "me-south-1", "me-central-1", "sa-east-1", "us-east-1", "us-east-2", "us-west-1", "us-west-2"];
        readonly linkUrl: "https://aws.amazon.com/cloudtrail/";
        readonly isActive: "true";
        readonly disableConfigure: false;
        readonly serviceDefinitionLocation: "https://d1qsjq9pzbk1k6.cloudfront.net/data/awsCloudTrail/en_US.json";
        readonly c2e: false;
        readonly templates: readonly [];
        readonly disableRegionSupport: false;
        readonly slug: "CloudTrail";
        readonly mvpSupport: false;
        readonly comparableTerms: readonly ["cloudtrail"];
    };
    readonly awsCodeArtifact: {
        readonly name: "AWS CodeArtifact";
        readonly serviceCode: "awsCodeArtifact";
        readonly description: "AWS CodeArtifact is a fully managed artifact repository service that makes it easy for organizations of any size to securely store, publish, and share software packages used in their software development process.";
        readonly searchKeywords: readonly ["artifacts", "reqeusts", "data transfer", "public aritfact repositories", "storage", "npm", "maven", "nuget", "pypi", "python", "nuget"];
        readonly type: "AWSService";
        readonly regions: readonly ["us-east-1", "us-east-2", "us-west-2", "eu-north-1", "eu-south-1", "eu-central-1", "eu-west-1", "eu-west-2", "eu-west-3", "ap-northeast-1", "ap-south-1", "ap-southeast-1", "ap-southeast-2"];
        readonly linkUrl: "https://aws.amazon.com/codeartifact/";
        readonly isActive: "true";
        readonly disableConfigure: false;
        readonly serviceDefinitionLocation: "https://d1qsjq9pzbk1k6.cloudfront.net/data/awsCodeArtifact/en_US.json";
        readonly c2e: false;
        readonly slug: "CodeArtifact";
        readonly mvpSupport: false;
        readonly comparableTerms: readonly ["codeartifact"];
    };
    readonly awsCodeBuild: {
        readonly name: "AWS CodeBuild";
        readonly serviceCode: "awsCodeBuild";
        readonly description: "AWS CodeBuild is a fully managed continuous integration service that compiles source code, runs tests, and produces software packages that are ready to deploy.";
        readonly searchKeywords: readonly ["CodeBuild", "Code", "code build"];
        readonly type: "AWSService";
        readonly regions: readonly ["af-south-1", "ap-east-1", "ap-northeast-1", "ap-northeast-2", "ap-south-1", "ap-southeast-1", "ap-southeast-2", "ap-southeast-3", "ca-central-1", "eu-central-1", "eu-north-1", "eu-west-1", "eu-west-2", "eu-west-3", "eu-south-1", "me-south-1", "sa-east-1", "us-east-1", "us-east-2", "us-gov-west-1", "us-gov-east-1", "us-west-1", "us-west-2"];
        readonly linkUrl: "https://aws.amazon.com/codebuild/";
        readonly isActive: "true";
        readonly disableConfigure: false;
        readonly serviceDefinitionLocation: "https://d1qsjq9pzbk1k6.cloudfront.net/data/awsCodeBuild/en_US.json";
        readonly c2e: false;
        readonly slug: "codebuild";
        readonly mvpSupport: false;
        readonly comparableTerms: readonly ["codebuild"];
    };
    readonly awsCodeDeploy: {
        readonly name: "AWS CodeDeploy";
        readonly serviceCode: "awsCodeDeploy";
        readonly description: "AWS CodeDeploy is a fully managed deployment service that automates software deployments to a variety of compute services such as Amazon EC2, AWS Fargate, AWS Lambda, and your on-premises servers.";
        readonly searchKeywords: readonly ["codedeploy", "CodeDeploy", "deployment"];
        readonly type: "AWSService";
        readonly regions: readonly ["us-gov-west-1", "us-gov-east-1", "af-south-1", "ap-east-1", "ap-south-1", "ap-southeast-1", "ap-southeast-2", "ap-southeast-3", "ap-northeast-1", "ap-northeast-2", "ap-northeast-3", "ca-central-1", "eu-central-1", "eu-west-1", "eu-west-2", "eu-west-3", "eu-north-1", "eu-south-1", "me-south-1", "me-central-1", "sa-east-1", "us-east-1", "us-east-2", "us-west-1", "us-west-2"];
        readonly linkUrl: "https://aws.amazon.com/codedeploy/";
        readonly isActive: "true";
        readonly disableConfigure: false;
        readonly serviceDefinitionLocation: "https://d1qsjq9pzbk1k6.cloudfront.net/data/awsCodeDeploy/en_US.json";
        readonly c2e: false;
        readonly templates: readonly [];
        readonly disableRegionSupport: false;
        readonly slug: "CodeDeploy";
        readonly mvpSupport: false;
        readonly comparableTerms: readonly ["codedeploy"];
    };
    readonly awsCodePipeline: {
        readonly name: "AWS CodePipeline";
        readonly serviceCode: "awsCodePipeline";
        readonly description: "AWS CodePipeline is a fully managed continuous delivery service that helps you automate your release pipelines for fast and reliable application and infrastructure updates.";
        readonly searchKeywords: readonly ["code", "pipeline"];
        readonly type: "AWSService";
        readonly regions: readonly ["us-gov-west-1", "ap-east-1", "ap-south-1", "ap-northeast-2", "ap-southeast-1", "ap-southeast-2", "ap-northeast-1", "ca-central-1", "eu-central-1", "eu-west-1", "eu-west-2", "eu-south-1", "eu-west-3", "eu-north-1", "sa-east-1", "us-east-1", "us-east-2", "us-west-1", "us-west-2"];
        readonly linkUrl: "https://aws.amazon.com/codepipeline/";
        readonly isActive: "true";
        readonly serviceDefinitionLocation: "https://d1qsjq9pzbk1k6.cloudfront.net/data/awsCodePipeline/en_US.json";
        readonly c2e: false;
        readonly slug: "CodePipeline";
        readonly comparableTerms: readonly ["codepipeline"];
    };
    readonly awsConfig: {
        readonly name: "AWS Config";
        readonly serviceCode: "awsConfig";
        readonly description: "AWS Config is a service that enables you to assess, audit, and evaluate the configurations of your AWS resources. Config continuously monitors and records your AWS resource configurations and allows you to automate the evaluation of recorded configurations against desired configurations.";
        readonly searchKeywords: readonly ["Management Tools", "management tools", "configuration management", "CMDB", "inventory", "discovery", "Config Rules", "compliance", "governance", "audit"];
        readonly type: "AWSService";
        readonly regions: readonly ["af-south-1", "ap-east-1", "ap-south-1", "ap-northeast-2", "ap-southeast-1", "ap-southeast-2", "ap-southeast-3", "ap-northeast-1", "us-gov-west-1", "us-gov-east-1", "ca-central-1", "eu-central-1", "eu-west-1", "eu-west-2", "eu-west-3", "eu-north-1", "eu-south-1", "me-south-1", "me-central-1", "sa-east-1", "us-east-1", "us-east-2", "us-west-1", "us-west-2"];
        readonly linkUrl: "https://aws.amazon.com/config/";
        readonly isActive: "true";
        readonly disableConfigure: false;
        readonly serviceDefinitionLocation: "https://d1qsjq9pzbk1k6.cloudfront.net/data/awsConfig/en_US.json";
        readonly c2e: false;
        readonly templates: readonly [];
        readonly disableRegionSupport: false;
        readonly slug: "Config";
        readonly mvpSupport: false;
        readonly comparableTerms: readonly ["config"];
    };
    readonly awsCostExplorer: {
        readonly name: "AWS Cost Explorer";
        readonly serviceCode: "awsCostExplorer";
        readonly description: "AWS Cost Explorer provides you with a set of default reports that you can use as the starting place for your analysis. From there, use the filtering and grouping capabilities to dive deeper into your cost and usage data and generate custom insights.";
        readonly searchKeywords: readonly ["aws cost explorer", "aws budgets", "cost management", "budgets"];
        readonly type: "AWSService";
        readonly regions: readonly [];
        readonly linkUrl: "https://aws.amazon.com/aws-cost-management/aws-cost-explorer/";
        readonly isActive: "true";
        readonly disableConfigure: false;
        readonly serviceDefinitionLocation: "https://d1qsjq9pzbk1k6.cloudfront.net/data/awsCostExplorer/en_US.json";
        readonly c2e: false;
        readonly templates: readonly [];
        readonly disableRegionSupport: false;
        readonly serviceDefinitionUrlPath: "/data/awsCostExplorer/en_US.json";
        readonly slug: "cost-explorer";
        readonly mvpSupport: false;
        readonly comparableTerms: readonly ["costexplorer", "costmanagementcostexplorer"];
    };
    readonly awsDataPipeline: {
        readonly name: "AWS Data Pipeline";
        readonly serviceCode: "awsDataPipeline";
        readonly description: "AWS Data Pipeline is a web service that helps you reliably process and move data between different AWS compute and storage services, as well as on-premises data sources, at specified intervals.";
        readonly searchKeywords: readonly ["datapipeline", "data", "move data"];
        readonly type: "AWSService";
        readonly regions: readonly ["ap-northeast-1", "ap-southeast-2", "eu-west-1", "us-west-2", "us-east-1"];
        readonly linkUrl: "https://aws.amazon.com/datapipeline/";
        readonly isActive: "true";
        readonly serviceDefinitionLocation: "https://d1qsjq9pzbk1k6.cloudfront.net/data/awsDataPipeline/en_US.json";
        readonly c2e: false;
        readonly slug: "datapipeline";
        readonly mvpSupport: false;
        readonly comparableTerms: readonly ["datapipeline"];
    };
    readonly aWSDataTransfer: {
        readonly name: "AWS Data Transfer";
        readonly serviceCode: "aWSDataTransfer";
        readonly description: "The cost of transferring data at AWS for services without unique transfer costs.";
        readonly searchKeywords: readonly [];
        readonly type: "AWSService";
        readonly regions: readonly ["af-south-1", "ap-east-1", "ap-northeast-1", "ap-northeast-1-wl1-nrt1", "ap-northeast-2", "ap-northeast-2-wl1-cjj1", "ap-northeast-2-wl1-sel1", "ap-northeast-3", "ap-south-1", "ap-southeast-1", "ap-southeast-2", "ap-southeast-3", "ca-central-1", "ca-central-1-wl1-yto1", "cloudfront", "me-south-1", "me-central-1", "eu-central-1", "eu-central-1-wl1-dtm1", "eu-central-1-wl1-ber1", "eu-central-1-wl1-muc1", "eu-north-1", "eu-south-1", "eu-west-1", "eu-west-2", "eu-west-2-wl1-lon1", "eu-west-3", "sa-east-1", "us-east-1", "us-east-1-atl-1", "us-east-1-bos-1", "us-east-1-chi-1", "us-east-1-dfw-1", "us-west-2-den-1", "us-east-1-iah-1", "us-east-1-mci-1", "us-east-1-mia-1", "us-east-1-msp-1", "us-east-1-nyc-1", "us-east-1-phl-1", "us-east-2", "us-gov-east-1", "us-gov-west-1", "us-west-1", "us-west-2", "us-west-2-las-1", "us-west-2-lax-1", "us-west-2-phx-1", "us-west-2-pdx-1", "us-west-2-sea-1", "us-west-2-wl1", "us-west-2-wl1-las1", "us-east-1-wl1", "us-east-1-wl1-atl1", "us-east-1-wl1-chi1", "us-east-1-wl1-clt1", "us-east-1-wl1-dfw1", "us-east-1-wl1-dtw1", "us-east-1-wl1-iah1", "us-east-1-wl1-mia1", "us-east-1-wl1-msp1", "us-east-1-wl1-bna1", "us-east-1-wl1-nyc1", "us-east-1-wl1-tpa1", "us-east-1-wl1-was1", "us-west-2-wl1-den1", "us-west-2-wl1-phx1", "us-west-2-wl1-lax1", "us-west-2-wl1-sea1"];
        readonly linkUrl: "https://aws.amazon.com/ec2/pricing/on-demand/#Data_Transfer";
        readonly isActive: "true";
        readonly hasDataTransfer: true;
        readonly disableConfigure: false;
        readonly serviceDefinitionLocation: "https://d1qsjq9pzbk1k6.cloudfront.net/data/aWSDataTransfer/en_US.json";
        readonly c2e: false;
        readonly templates: readonly [];
        readonly disableRegionSupport: false;
        readonly slug: "DataTransfer";
        readonly mvpSupport: false;
        readonly comparableTerms: readonly ["datatransfer"];
    };
    readonly awsDatabaseMigrationService: {
        readonly name: "AWS Database Migration Service";
        readonly serviceCode: "awsDatabaseMigrationService";
        readonly description: "AWS Database Migration Service helps you migrate databases to AWS quickly and securely.";
        readonly searchKeywords: readonly ["Database", "Aurora", "MySQL", "MariaDB", "Postgres", "Oracle", "SQL Server", "PostgreSQL", "Microsoft SQL Server", "Migration", "microsoft", "sql", "msft", "DMS", "SCT", "DB", "MS", "win"];
        readonly type: "AWSService";
        readonly regions: readonly ["af-south-1", "ap-northeast-1", "ap-northeast-2", "ap-northeast-3", "ap-south-1", "ap-southeast-1", "ap-southeast-2", "ap-southeast-3", "ca-central-1", "eu-central-1", "eu-south-1", "eu-west-1", "eu-west-2", "eu-west-3", "me-central-1", "sa-east-1", "us-east-1", "us-east-2", "us-gov-east-1", "us-gov-west-1", "us-west-1", "us-west-2"];
        readonly linkUrl: "https://aws.amazon.com/dms/";
        readonly isActive: "true";
        readonly disableConfigure: false;
        readonly serviceDefinitionLocation: "https://d1qsjq9pzbk1k6.cloudfront.net/data/awsDatabaseMigrationService/en_US.json";
        readonly c2e: false;
        readonly templates: readonly [];
        readonly disableRegionSupport: false;
        readonly slug: "DMS";
        readonly mvpSupport: false;
        readonly comparableTerms: readonly ["databasemigration", "databasemigrationservice", "dms"];
    };
    readonly aWSDataSync: {
        readonly name: "AWS DataSync";
        readonly serviceCode: "aWSDataSync";
        readonly description: "AWS DataSync is an online data transfer service that simplifies, automates, and accelerates moving data between on-premises storage systems and AWS Storage services, as well as between AWS Storage services.";
        readonly searchKeywords: readonly [];
        readonly type: "AWSService";
        readonly regions: readonly ["af-south-1", "ap-east-1", "ap-south-1", "ap-northeast-2", "ap-southeast-1", "ap-southeast-2", "ap-southeast-3", "ap-northeast-1", "ap-northeast-3", "us-gov-east-1", "us-gov-west-1", "ca-central-1", "eu-central-1", "eu-west-1", "eu-west-2", "eu-west-3", "eu-north-1", "eu-south-1", "me-south-1", "sa-east-1", "us-east-1", "us-east-2", "us-west-1", "us-west-2"];
        readonly linkUrl: "https://aws.amazon.com/datasync/";
        readonly isActive: "true";
        readonly serviceDefinitionLocation: "https://d1qsjq9pzbk1k6.cloudfront.net/data/aWSDataSync/en_US.json";
        readonly c2e: false;
        readonly slug: "DataSync";
        readonly mvpSupport: false;
        readonly comparableTerms: readonly ["datasync"];
    };
    readonly awsDeepRacer: {
        readonly name: "AWS DeepRacer";
        readonly serviceCode: "awsDeepRacer";
        readonly description: "With AWS DeepRacer, you can create your own machine learning models (in a process called 'training') and race them (in a process called 'evaluation'). You pay for training, evaluating and storing your machine learning models. Charges are based on the amount of time you train and evaluate a new model and the size of the model stored. Additionally, you can purchase a fully autonomous 1/18th scale DeepRacer car, which will allow you to try your models out on real tracks. No purchase is necessary to enter the DeepRacer League.";
        readonly searchKeywords: readonly ["deepracer", "machine learning", "model training", "model evaluation", "ml"];
        readonly type: "AWSService";
        readonly regions: readonly ["us-east-1"];
        readonly linkUrl: "https://aws.amazon.com/deepracer/";
        readonly isActive: "true";
        readonly serviceDefinitionLocation: "https://d1qsjq9pzbk1k6.cloudfront.net/data/awsDeepRacer/en_US.json";
        readonly c2e: false;
        readonly slug: "DeepRacer";
        readonly mvpSupport: false;
        readonly comparableTerms: readonly ["deepracer"];
    };
    readonly awsDeviceFarm: {
        readonly name: "AWS Device Farm";
        readonly serviceCode: "awsDeviceFarm";
        readonly description: "AWS Device Farm is an application testing service that lets you improve the quality of your web and mobile apps by testing them across an extensive range of desktop browsers and real mobile devices; without having to provision and manage any testing infrastructure. The service enables you to run your tests concurrently on multiple desktop browsers or real devices to speed up the execution of your test suite, and generates videos and logs to help you quickly identify issues with your app.";
        readonly searchKeywords: readonly ["application testing", "mobile devices", "desktop browsers", "device farm", "automated testing", "remote access", "iOS", "Android", "unlimited testing", "pay as you go", "device minutes", "device slots", "free device minutes", "browser instances"];
        readonly type: "AWSService";
        readonly regions: readonly ["us-west-2"];
        readonly linkUrl: "https://aws.amazon.com/device-farm/";
        readonly isActive: "true";
        readonly serviceDefinitionLocation: "https://d1qsjq9pzbk1k6.cloudfront.net/data/awsDeviceFarm/en_US.json";
        readonly c2e: false;
        readonly slug: "DeviceFarm";
        readonly mvpSupport: false;
        readonly comparableTerms: readonly ["devicefarm"];
    };
    readonly awsDirectConnect: {
        readonly name: "AWS Direct Connect";
        readonly serviceCode: "awsDirectConnect";
        readonly description: "AWS Direct Connect is a cloud service solution that makes it easy to establish a dedicated network connection from your premises to AWS.";
        readonly searchKeywords: readonly ["Direct Connect", "Data Transfer"];
        readonly type: "AWSService";
        readonly regions: readonly ["us-east-1", "us-east-2", "us-west-1", "us-west-2", "af-south-1", "ap-east-1", "ap-south-1", "ap-northeast-3", "ap-northeast-2", "ap-southeast-1", "ap-southeast-2", "ap-northeast-1", "ca-central-1", "eu-central-1", "eu-west-1", "eu-west-2", "eu-south-1", "eu-west-3", "eu-north-1", "me-south-1", "me-central-1", "sa-east-1", "us-gov-east-1", "us-gov-west-1"];
        readonly linkUrl: "https://aws.amazon.com/directconnect/";
        readonly isActive: "true";
        readonly disableConfigure: false;
        readonly serviceDefinitionLocation: "https://d1qsjq9pzbk1k6.cloudfront.net/data/awsDirectConnect/en_US.json";
        readonly c2e: false;
        readonly templates: readonly [];
        readonly disableRegionSupport: false;
        readonly slug: "DirectConnect";
        readonly mvpSupport: false;
        readonly comparableTerms: readonly ["directconnect"];
    };
    readonly aWSDirectoryService: {
        readonly name: "AWS Directory Service";
        readonly serviceCode: "aWSDirectoryService";
        readonly description: "AWS Directory Service is a managed service offering, providing directories that contain information about your organization, including users, groups, computers, and other resources.";
        readonly searchKeywords: readonly [];
        readonly type: "AWSService";
        readonly regions: readonly ["ap-south-1", "ap-northeast-2", "ap-southeast-1", "ap-southeast-2", "ap-northeast-1", "us-gov-west-1", "us-gov-east-1", "ca-central-1", "eu-central-1", "eu-west-1", "eu-west-2", "eu-west-3", "eu-south-1", "me-south-1", "sa-east-1", "us-east-1", "us-east-2", "us-west-1", "us-west-2"];
        readonly linkUrl: "https://aws.amazon.com/directoryservice/";
        readonly isActive: "true";
        readonly serviceDefinitionLocation: "https://d1qsjq9pzbk1k6.cloudfront.net/data/aWSDirectoryService/en_US.json";
        readonly c2e: false;
        readonly slug: "DirectoryService";
        readonly mvpSupport: false;
        readonly comparableTerms: readonly ["directory", "directoryservice"];
    };
    readonly awsDrsDrill: {
        readonly name: "AWS DRS - Drill/Recovery";
        readonly serviceCode: "awsDrsDrill";
        readonly description: "AWS Elastic Disaster Recovery (AWS DRS) minimizes downtime and data loss with fast, reliable recovery of on-premises and cloud-based applications using affordable storage, minimal compute, and point-in-time recovery.";
        readonly searchKeywords: readonly ["disaster recovery", "replicate", "elastic recovery", "point in time", "recovery", "on-premises recovery", "cloud-based", "affordable storage"];
        readonly type: "AWSService";
        readonly regions: readonly ["eu-west-1", "ap-northeast-1", "us-east-2", "us-west-2", "us-east-1", "ap-southeast-2", "eu-west-2", "eu-central-1", "ap-southeast-1"];
        readonly linkUrl: "https://aws.amazon.com/disaster-recovery/pricing";
        readonly isActive: "true";
        readonly subType: "subService";
        readonly disableConfigure: false;
        readonly serviceDefinitionLocation: "https://d1qsjq9pzbk1k6.cloudfront.net/data/awsDrsDrill/en_US.json";
        readonly c2e: false;
        readonly templates: readonly [];
        readonly disableRegionSupport: false;
        readonly serviceDefinitionUrlPath: "/data/awsDrsDrill/en_US.json";
        readonly mvpSupport: false;
        readonly comparableTerms: readonly ["drsdrill", "drsdrillrecovery"];
        readonly parentServiceCode: "awsElasticDisasterRecovery";
    };
    readonly awsDrsRecoveryReplication: {
        readonly name: "AWS DRS - Replication";
        readonly serviceCode: "awsDrsRecoveryReplication";
        readonly description: "AWS Elastic Disaster Recovery (AWS DRS) minimizes downtime and data loss with fast, reliable recovery of on-premises and cloud-based applications using affordable storage, minimal compute, and point-in-time recovery.";
        readonly searchKeywords: readonly ["disaster recovery", "replicate", "elastic recovery", "point in time", "recovery", "on-premises recovery", "cloud-based", "affordable storage"];
        readonly type: "AWSService";
        readonly regions: readonly ["eu-west-1", "ap-northeast-1", "us-east-2", "us-west-2", "us-east-1", "ap-southeast-2", "eu-west-2", "eu-central-1", "ap-southeast-1"];
        readonly linkUrl: "https://aws.amazon.com/disaster-recovery/pricing";
        readonly isActive: "true";
        readonly subType: "subService";
        readonly disableConfigure: false;
        readonly serviceDefinitionLocation: "https://d1qsjq9pzbk1k6.cloudfront.net/data/awsDrsRecoveryReplication/en_US.json";
        readonly c2e: false;
        readonly templates: readonly [];
        readonly disableRegionSupport: false;
        readonly bulkImportEnabled: false;
        readonly serviceDefinitionUrlPath: "/data/awsDrsRecoveryReplication/en_US.json";
        readonly mvpSupport: false;
        readonly comparableTerms: readonly ["drsrecoveryreplication", "drsreplication"];
        readonly parentServiceCode: "awsElasticDisasterRecovery";
    };
    readonly awsElasticDisasterRecovery: {
        readonly name: "AWS Elastic Disaster Recovery";
        readonly serviceCode: "awsElasticDisasterRecovery";
        readonly description: "AWS Elastic Disaster Recovery (AWS DRS) minimizes downtime and data loss with fast, reliable recovery of on-premises and cloud-based applications using affordable storage, minimal compute, and point-in-time recovery.";
        readonly searchKeywords: readonly ["disaster recovery", "replicate", "elastic recovery", "point in time", "recovery", "on-premises recovery", "cloud-based", "affordable storage"];
        readonly type: "AWSService";
        readonly regions: readonly [];
        readonly linkUrl: "https://aws.amazon.com/disaster-recovery/";
        readonly isActive: "true";
        readonly subType: "subServiceSelector";
        readonly disableConfigure: false;
        readonly serviceDefinitionLocation: "https://d1qsjq9pzbk1k6.cloudfront.net/data/awsElasticDisasterRecovery/en_US.json";
        readonly c2e: false;
        readonly templates: readonly ["awsDrsRecoveryReplication", "awsDrsDrill"];
        readonly disableRegionSupport: false;
        readonly serviceDefinitionUrlPath: "/data/awsElasticDisasterRecovery/en_US.json";
        readonly slug: "ElasticDisasterRecovery";
        readonly mvpSupport: false;
        readonly comparableTerms: readonly ["disasterrecovery", "elasticdisasterrecovery"];
    };
    readonly awsElementalMediaTailor: {
        readonly name: "AWS Elemental Media Tailor";
        readonly serviceCode: "awsElementalMediaTailor";
        readonly description: "AWS Elemental MediaTailor is a channel assembly and personalized ad insertion service for video providers to create linear OTT (internet delivered) channels using existing video content and monetize those channels, or other live streams and VOD content, with personalized advertising.";
        readonly searchKeywords: readonly ["elemental", "tailor", "mediatailor"];
        readonly type: "AWSService";
        readonly regions: readonly ["ap-southeast-1", "ap-southeast-2", "ap-northeast-1", "eu-central-1", "eu-west-1", "us-east-1", "us-west-2"];
        readonly linkUrl: "https://aws.amazon.com/mediatailor/";
        readonly isActive: "true";
        readonly serviceDefinitionLocation: "https://d1qsjq9pzbk1k6.cloudfront.net/data/awsElementalMediaTailor/en_US.json";
        readonly c2e: false;
        readonly slug: "ElementalMediaTailor";
        readonly mvpSupport: false;
        readonly comparableTerms: readonly ["elementalmediatailor", "mediatailor"];
    };
    readonly awsElementalMediaConnect: {
        readonly name: "AWS Elemental MediaConnect";
        readonly serviceCode: "awsElementalMediaConnect";
        readonly description: "AWS Elemental MediaConnect is a high-quality transport service for live video.";
        readonly searchKeywords: readonly ["transport", "video", "broadcast", "live", "flows", "JPEG XS", "CDI"];
        readonly type: "AWSService";
        readonly regions: readonly ["ap-east-1", "ap-northeast-1", "ap-northeast-2", "ap-south-1", "ap-southeast-1", "ap-southeast-2", "eu-central-1", "eu-north-1", "eu-west-1", "eu-west-2", "eu-west-3", "sa-east-1", "us-east-1", "us-east-2", "us-west-1", "us-west-2"];
        readonly linkUrl: "https://aws.amazon.com/mediaconnect/";
        readonly isActive: "true";
        readonly hasDataTransfer: true;
        readonly disableConfigure: false;
        readonly serviceDefinitionLocation: "https://d1qsjq9pzbk1k6.cloudfront.net/data/awsElementalMediaConnect/en_US.json";
        readonly c2e: false;
        readonly templates: readonly [];
        readonly disableRegionSupport: false;
        readonly slug: "ElementalMediaConnect";
        readonly mvpSupport: false;
        readonly comparableTerms: readonly ["elementalmediaconnect", "mediaconnect"];
    };
    readonly elementalMediaConvert: {
        readonly name: "AWS Elemental MediaConvert";
        readonly serviceCode: "elementalMediaConvert";
        readonly description: "AWS Elemental MediaConvert is a file-based video transcoding service with broadcast-grade features. It allows you to easily create video-on-demand (VOD) content for broadcast and multiscreen delivery at scale.";
        readonly searchKeywords: readonly [];
        readonly type: "AWSService";
        readonly regions: readonly ["us-east-1", "us-east-2", "us-west-1", "us-west-2", "ap-south-1", "ap-northeast-2", "ap-southeast-1", "ap-southeast-2", "ap-northeast-1", "ca-central-1", "eu-central-1", "eu-west-1", "eu-west-2", "eu-west-3", "eu-north-1", "sa-east-1", "us-gov-west-1"];
        readonly linkUrl: "https://aws.amazon.com/mediaconvert/";
        readonly isActive: "true";
        readonly serviceDefinitionLocation: "https://d1qsjq9pzbk1k6.cloudfront.net/data/elementalMediaConvert/en_US.json";
        readonly c2e: false;
        readonly mvpSupport: false;
        readonly comparableTerms: readonly ["elementalmediaconvert", "mediaconvert"];
    };
    readonly awsElementalMediaLive: {
        readonly name: "AWS Elemental MediaLive";
        readonly serviceCode: "awsElementalMediaLive";
        readonly description: "AWS Elemental MediaLive is a broadcast-grade live video processing service. It lets you create high-quality video streams for delivery to broadcast televisions and internet-connected multiscreen devices, like connected TVs, tablets, smart phones, and set-top boxes.";
        readonly searchKeywords: readonly ["media", "video processing", "broadcast", "TV", "video streams", "channels"];
        readonly type: "AWSService";
        readonly regions: readonly [];
        readonly linkUrl: "https://aws.amazon.com/medialive/";
        readonly isActive: "true";
        readonly subType: "subServiceSelector";
        readonly disableConfigure: false;
        readonly serviceDefinitionLocation: "https://d1qsjq9pzbk1k6.cloudfront.net/data/awsElementalMediaLive/en_US.json";
        readonly c2e: false;
        readonly templates: readonly ["mediaLiveInput1", "mediaLiveOutput1", "mediaLiveAudioAddOns"];
        readonly disableRegionSupport: false;
        readonly serviceDefinitionUrlPath: "/data/awsElementalMediaLive/en_US.json";
        readonly slug: "ElementalMediaLive";
        readonly mvpSupport: false;
        readonly comparableTerms: readonly ["elementalmedialive", "medialive"];
    };
    readonly awsElementalMediaPackage: {
        readonly name: "AWS Elemental MediaPackage";
        readonly serviceCode: "awsElementalMediaPackage";
        readonly description: "AWS Elemental MediaPackage reliably prepares and protects your video for delivery over the Internet. From a single video input, AWS Elemental MediaPackage creates video streams formatted to play on connected TVs, mobile phones, computers, tablets, and game consoles.";
        readonly searchKeywords: readonly ["media", "video processing", "broadcast", "TV", "video streams", "channels"];
        readonly type: "AWSService";
        readonly regions: readonly ["ap-south-1", "ap-northeast-2", "ap-southeast-1", "ap-southeast-2", "ap-northeast-1", "eu-central-1", "eu-west-1", "eu-west-2", "eu-west-3", "eu-north-1", "sa-east-1", "us-east-1", "us-east-2", "us-west-1", "us-west-2"];
        readonly linkUrl: "https://aws.amazon.com/mediapackage/";
        readonly isActive: "true";
        readonly hasDataTransfer: true;
        readonly disableConfigure: false;
        readonly serviceDefinitionLocation: "https://d1qsjq9pzbk1k6.cloudfront.net/data/awsElementalMediaPackage/en_US.json";
        readonly c2e: false;
        readonly templates: readonly [];
        readonly disableRegionSupport: false;
        readonly slug: "ElementalMediaPackage";
        readonly mvpSupport: false;
        readonly comparableTerms: readonly ["elementalmediapackage", "mediapackage"];
    };
    readonly awsFargate: {
        readonly name: "AWS Fargate";
        readonly serviceCode: "awsFargate";
        readonly description: "AWS Fargate is a serverless compute engine for containers that works with both Amazon Elastic Container Service (ECS) and Amazon Elastic Kubernetes Service (EKS). Fargate makes it easy for you to focus on building your applications. Fargate removes the need to provision and manage servers, lets you specify and pay for resources per application, and improves security through application isolation by design.";
        readonly searchKeywords: readonly ["serverless", "compute", "engine", "ECS", "EKS", "container", "Kubernetes"];
        readonly type: "AWSService";
        readonly regions: readonly ["us-gov-west-1", "us-gov-east-1", "af-south-1", "ap-east-1", "ap-south-1", "ap-northeast-3", "ap-northeast-2", "ap-southeast-1", "ap-southeast-2", "ap-southeast-3", "ap-northeast-1", "ca-central-1", "eu-central-1", "eu-west-1", "eu-west-2", "eu-south-1", "eu-west-3", "eu-north-1", "me-south-1", "me-central-1", "sa-east-1", "us-east-1", "us-east-2", "us-west-1", "us-west-2"];
        readonly linkUrl: "https://aws.amazon.com/fargate/";
        readonly isActive: "true";
        readonly disableConfigure: false;
        readonly serviceDefinitionLocation: "https://d1qsjq9pzbk1k6.cloudfront.net/data/awsFargate/en_US.json";
        readonly c2e: false;
        readonly templates: readonly [];
        readonly disableRegionSupport: false;
        readonly serviceDefinitionUrlPath: "/data/awsFargate/en_US.json";
        readonly slug: "Fargate";
        readonly mvpSupport: false;
        readonly comparableTerms: readonly ["fargate"];
    };
    readonly awsGlue: {
        readonly name: "AWS Glue";
        readonly serviceCode: "awsGlue";
        readonly description: "AWS Glue is a serverless data preparation service that makes it easy for data engineers, extract, transform, and load (ETL) developers, data analysts, and data scientists to extract, clean, enrich, normalize, and load data. AWS Glue reduces the time it takes to start analyzing your data from months to minutes.";
        readonly searchKeywords: readonly ["etl", "AWS glue data catalog", "glue", "crawlers", "development endpoints", "databrew"];
        readonly type: "AWSService";
        readonly regions: readonly [];
        readonly linkUrl: "https://aws.amazon.com/glue/";
        readonly isActive: "true";
        readonly subType: "subServiceSelector";
        readonly disableConfigure: false;
        readonly serviceDefinitionLocation: "https://d1qsjq9pzbk1k6.cloudfront.net/data/awsGlue/en_US.json";
        readonly c2e: false;
        readonly templates: readonly ["awsEtlJobsAndDevelopmentEndpoints", "awsEtlJobsFlexExecutionOption", "awsGlueDataCatalogStorageRequests", "awsGlueDataBrewInteractiveSessions", "awsGlueCrawlers"];
        readonly disableRegionSupport: false;
        readonly serviceDefinitionUrlPath: "/data/awsGlue/en_US.json";
        readonly slug: "Glue";
        readonly mvpSupport: false;
        readonly comparableTerms: readonly ["glue"];
    };
    readonly awsGlueCrawlers: {
        readonly name: "AWS Glue Crawlers";
        readonly serviceCode: "awsGlueCrawlers";
        readonly description: "";
        readonly searchKeywords: readonly [];
        readonly type: "AWSService";
        readonly regions: readonly ["us-gov-west-1", "us-gov-east-1", "af-south-1", "ap-east-1", "ap-south-1", "ap-northeast-3", "ap-northeast-2", "ap-southeast-1", "ap-southeast-2", "ap-northeast-1", "ca-central-1", "eu-central-1", "eu-west-1", "eu-west-2", "eu-south-1", "eu-west-3", "eu-north-1", "me-south-1", "sa-east-1", "us-east-1", "us-east-2", "us-west-1", "us-west-2"];
        readonly isActive: "true";
        readonly subType: "subService";
        readonly disableConfigure: false;
        readonly serviceDefinitionLocation: "https://d1qsjq9pzbk1k6.cloudfront.net/data/awsGlueCrawlers/en_US.json";
        readonly c2e: false;
        readonly templates: readonly [];
        readonly disableRegionSupport: false;
        readonly serviceDefinitionUrlPath: "/data/awsGlueCrawlers/en_US.json";
        readonly mvpSupport: false;
        readonly comparableTerms: readonly ["gluecrawlers"];
        readonly parentServiceCode: "awsGlue";
    };
    readonly awsGlueDataCatalogStorageRequests: {
        readonly name: "AWS Glue Data Catalog storage requests";
        readonly serviceCode: "awsGlueDataCatalogStorageRequests";
        readonly description: "";
        readonly searchKeywords: readonly [];
        readonly type: "AWSService";
        readonly regions: readonly ["us-gov-west-1", "us-gov-east-1", "af-south-1", "ap-east-1", "ap-south-1", "ap-northeast-3", "ap-northeast-2", "ap-southeast-1", "ap-southeast-2", "ap-northeast-1", "ca-central-1", "eu-central-1", "eu-west-1", "eu-west-2", "eu-south-1", "eu-west-3", "eu-north-1", "me-south-1", "sa-east-1", "us-east-1", "us-east-2", "us-west-1", "us-west-2"];
        readonly isActive: "true";
        readonly subType: "subService";
        readonly serviceDefinitionLocation: "https://d1qsjq9pzbk1k6.cloudfront.net/data/awsGlueDataCatalogStorageRequests/en_US.json";
        readonly c2e: false;
        readonly mvpSupport: false;
        readonly comparableTerms: readonly ["gluedatacatalogstoragerequests"];
        readonly parentServiceCode: "awsGlue";
    };
    readonly awsGlueDataBrewInteractiveSessions: {
        readonly name: "AWS Glue DataBrew interactive sessions";
        readonly serviceCode: "awsGlueDataBrewInteractiveSessions";
        readonly description: "";
        readonly searchKeywords: readonly [];
        readonly type: "AWSService";
        readonly regions: readonly ["ap-south-1", "ap-southeast-1", "ap-southeast-2", "ap-northeast-1", "eu-central-1", "eu-west-1", "eu-west-2", "eu-west-3", "eu-north-1", "us-east-1", "us-east-2", "us-west-1", "us-west-2"];
        readonly isActive: "true";
        readonly subType: "subService";
        readonly disableConfigure: false;
        readonly serviceDefinitionLocation: "https://d1qsjq9pzbk1k6.cloudfront.net/data/awsGlueDataBrewInteractiveSessions/en_US.json";
        readonly c2e: false;
        readonly templates: readonly [];
        readonly disableRegionSupport: false;
        readonly serviceDefinitionUrlPath: "/data/awsGlueDataBrewInteractiveSessions/en_US.json";
        readonly mvpSupport: false;
        readonly comparableTerms: readonly ["gluedatabrewinteractivesessions"];
        readonly parentServiceCode: "awsGlue";
    };
    readonly awsEtlJobsAndDevelopmentEndpoints: {
        readonly name: "AWS Glue ETL jobs and development endpoints";
        readonly serviceCode: "awsEtlJobsAndDevelopmentEndpoints";
        readonly description: "";
        readonly searchKeywords: readonly [];
        readonly type: "AWSService";
        readonly regions: readonly ["us-gov-west-1", "us-gov-east-1", "af-south-1", "ap-east-1", "ap-south-1", "ap-northeast-3", "ap-northeast-2", "ap-southeast-1", "ap-southeast-2", "ap-northeast-1", "ca-central-1", "eu-central-1", "eu-west-1", "eu-west-2", "eu-south-1", "eu-west-3", "eu-north-1", "me-south-1", "sa-east-1", "us-east-1", "us-east-2", "us-west-1", "us-west-2"];
        readonly isActive: "true";
        readonly subType: "subService";
        readonly disableConfigure: false;
        readonly serviceDefinitionLocation: "https://d1qsjq9pzbk1k6.cloudfront.net/data/awsEtlJobsAndDevelopmentEndpoints/en_US.json";
        readonly c2e: false;
        readonly templates: readonly [];
        readonly disableRegionSupport: false;
        readonly serviceDefinitionUrlPath: "/data/awsEtlJobsAndDevelopmentEndpoints/en_US.json";
        readonly mvpSupport: false;
        readonly comparableTerms: readonly ["etljobsanddevelopmentendpoints", "glueetljobsdevelopmentendpoints"];
        readonly parentServiceCode: "awsGlue";
    };
    readonly awsEtlJobsFlexExecutionOption: {
        readonly name: "AWS Glue ETL jobs with Flex execution option";
        readonly serviceCode: "awsEtlJobsFlexExecutionOption";
        readonly description: "";
        readonly searchKeywords: readonly [];
        readonly type: "AWSService";
        readonly regions: readonly ["ap-northeast-1", "ap-northeast-2", "ap-south-1", "ap-southeast-1", "ap-southeast-2", "ca-central-1", "eu-central-1", "eu-west-1", "eu-west-2", "eu-west-3", "sa-east-1", "us-east-1", "us-east-2", "us-west-1", "us-west-2"];
        readonly isActive: "true";
        readonly subType: "subService";
        readonly disableConfigure: false;
        readonly serviceDefinitionLocation: "https://d1qsjq9pzbk1k6.cloudfront.net/data/awsEtlJobsFlexExecutionOption/en_US.json";
        readonly c2e: false;
        readonly templates: readonly [];
        readonly disableRegionSupport: false;
        readonly mvpSupport: false;
        readonly comparableTerms: readonly ["etljobsflexexecutionoption", "glueetljobswithflexexecutionoption"];
        readonly parentServiceCode: "awsGlue";
    };
    readonly awsIoTAnalytics: {
        readonly name: "AWS IoT Analytics";
        readonly serviceCode: "awsIoTAnalytics";
        readonly description: "AWS IoT Analytics is a fully-managed IoT analytics service that collects, pre-processes, enriches, stores, and analyzes IoT device data at scale.";
        readonly searchKeywords: readonly ["AWS IoT Analytics", "iot analytics", "analytics"];
        readonly type: "AWSService";
        readonly regions: readonly ["ap-northeast-1", "ap-south-1", "ap-southeast-2", "eu-central-1", "eu-west-1", "us-east-1", "us-east-2", "us-west-2"];
        readonly linkUrl: "https://aws.amazon.com/iot-analytics/";
        readonly isActive: "true";
        readonly serviceDefinitionLocation: "https://d1qsjq9pzbk1k6.cloudfront.net/data/awsIoTAnalytics/en_US.json";
        readonly c2e: false;
        readonly slug: "iot-analytics";
        readonly mvpSupport: false;
        readonly comparableTerms: readonly ["iotanalytics"];
    };
    readonly awsIoTCore: {
        readonly name: "AWS IoT Core";
        readonly serviceCode: "awsIoTCore";
        readonly description: "AWS IoT Core is a managed cloud service that lets connected devices easily and securely interact with cloud applications and other devices.";
        readonly searchKeywords: readonly ["iot", "device", "messages", "shadow", "registry", "rules", "device shadow", "rules engine", "basic ingest", "mqtt", "LoRaWAN"];
        readonly type: "AWSService";
        readonly regions: readonly [];
        readonly linkUrl: "https://aws.amazon.com/iot-core/";
        readonly isActive: "true";
        readonly subType: "subServiceSelector";
        readonly disableConfigure: false;
        readonly serviceDefinitionLocation: "https://d1qsjq9pzbk1k6.cloudfront.net/data/awsIoTCore/en_US.json";
        readonly c2e: false;
        readonly templates: readonly ["awsIoTCoreMqtt", "awsIoTCoreHttp", "awsIoTCoreLoRaWan"];
        readonly disableRegionSupport: false;
        readonly serviceDefinitionUrlPath: "/data/awsIoTCore/en_US.json";
        readonly slug: "IoTCore";
        readonly mvpSupport: false;
        readonly comparableTerms: readonly ["iotcore"];
    };
    readonly awsIoTDeviceDefender: {
        readonly name: "AWS IoT Device Defender";
        readonly serviceCode: "awsIoTDeviceDefender";
        readonly description: "AWS IoT Device Defender is a fully managed service that helps you secure your fleet of IoT devices.";
        readonly searchKeywords: readonly ["device", "iot", "iot device defender", "defender", "audit", "detect", "metric", "fleet"];
        readonly type: "AWSService";
        readonly regions: readonly ["us-east-1", "us-east-2", "us-west-1", "us-west-2", "ap-east-1", "ap-south-1", "ap-northeast-2", "ap-southeast-1", "ap-southeast-2", "ap-northeast-1", "ca-central-1", "eu-central-1", "eu-west-1", "eu-west-2", "eu-west-3", "eu-north-1", "me-south-1", "us-gov-east-1", "us-gov-west-1"];
        readonly linkUrl: "https://aws.amazon.com/iot-device-defender/";
        readonly isActive: "true";
        readonly serviceDefinitionLocation: "https://d1qsjq9pzbk1k6.cloudfront.net/data/awsIoTDeviceDefender/en_US.json";
        readonly c2e: false;
        readonly slug: "IoTDeviceDefender";
        readonly comparableTerms: readonly ["iotdevicedefender"];
    };
    readonly awsIoTDeviceManagement: {
        readonly name: "AWS IoT Device Management";
        readonly serviceCode: "awsIoTDeviceManagement";
        readonly description: "AWS IoT Device Management makes it easy for you to manage your fleets of connected devices at any scale.";
        readonly searchKeywords: readonly ["device management", "fleet indexing", "index updates", "device query", "device queries", "jobs", "remote actions", "secure tunneling", "tunnels"];
        readonly type: "AWSService";
        readonly regions: readonly ["us-east-1", "us-east-2", "us-west-1", "us-west-2", "ap-east-1", "ap-south-1", "ap-northeast-2", "ap-southeast-1", "ap-southeast-2", "ap-northeast-1", "ca-central-1", "eu-central-1", "eu-west-1", "eu-west-2", "eu-west-3", "eu-north-1", "me-south-1", "sa-east-1", "us-gov-east-1", "us-gov-west-1"];
        readonly linkUrl: "https://aws.amazon.com/iot-device-management/";
        readonly isActive: "true";
        readonly serviceDefinitionLocation: "https://d1qsjq9pzbk1k6.cloudfront.net/data/awsIoTDeviceManagement/en_US.json";
        readonly c2e: false;
        readonly slug: "IoTDeviceManagement";
        readonly comparableTerms: readonly ["iotdevicemanagement"];
    };
    readonly awsIoTEvents: {
        readonly name: "AWS IoT Events";
        readonly serviceCode: "awsIoTEvents";
        readonly description: "AWS IoT Events makes it easy to detect and respond to changes indicated by IoT sensors and applications – such as malfunctioning machinery, a stuck conveyor belt, or a slowdown in production output – and automatically trigger actions or alerts in response.";
        readonly searchKeywords: readonly ["iot", "iot events"];
        readonly type: "AWSService";
        readonly regions: readonly ["ap-northeast-1", "ap-northeast-2", "ap-southeast-1", "ap-southeast-2", "ap-south-1", "eu-central-1", "eu-west-1", "eu-west-2", "us-east-1", "us-east-2", "us-west-2", "us-gov-west-1"];
        readonly linkUrl: "https://aws.amazon.com/iot-events/";
        readonly isActive: "true";
        readonly serviceDefinitionLocation: "https://d1qsjq9pzbk1k6.cloudfront.net/data/awsIoTEvents/en_US.json";
        readonly c2e: false;
        readonly slug: "iot-events";
        readonly mvpSupport: false;
        readonly comparableTerms: readonly ["iotevents"];
    };
    readonly awsIoTGreengrass: {
        readonly name: "AWS IoT Greengrass";
        readonly serviceCode: "awsIoTGreengrass";
        readonly description: "AWS IoT Greengrass is an Internet of Things (IoT) open source edge runtime and cloud service that helps you build, deploy, and manage device software. Customers use AWS IoT Greengrass for their IoT applications on millions of devices in homes, factories, vehicles, and businesses.";
        readonly searchKeywords: readonly ["greengrass", "AWS IoT Greengrass"];
        readonly type: "AWSService";
        readonly regions: readonly ["ap-northeast-1", "ap-northeast-2", "ap-south-1", "ap-southeast-1", "ap-southeast-2", "eu-central-1", "eu-west-1", "eu-west-2", "us-east-1", "us-east-2", "us-gov-east-1", "us-gov-west-1", "us-west-2"];
        readonly linkUrl: "https://aws.amazon.com/greengrass/";
        readonly isActive: "true";
        readonly disableConfigure: false;
        readonly serviceDefinitionLocation: "https://d1qsjq9pzbk1k6.cloudfront.net/data/awsIoTGreengrass/en_US.json";
        readonly c2e: false;
        readonly templates: readonly [];
        readonly disableRegionSupport: false;
        readonly slug: "greengrass";
        readonly mvpSupport: false;
        readonly comparableTerms: readonly ["greengrass", "iotgreengrass"];
    };
    readonly awsIoTThingsGraph: {
        readonly name: "AWS IoT Things Graph";
        readonly serviceCode: "awsIoTThingsGraph";
        readonly description: "AWS IoT Things Graph makes it easy to rapidly build IoT applications by connecting devices and web services from different vendors that speak different protocols.";
        readonly searchKeywords: readonly ["IoT", "Things", "graph", "IoT Things Graph"];
        readonly type: "AWSService";
        readonly regions: readonly ["ap-northeast-2", "ap-southeast-2", "ap-northeast-1", "eu-west-1", "us-east-1", "us-west-2"];
        readonly linkUrl: "https://aws.amazon.com/iot-things-graph/";
        readonly isActive: "true";
        readonly serviceDefinitionLocation: "https://d1qsjq9pzbk1k6.cloudfront.net/data/awsIoTThingsGraph/en_US.json";
        readonly c2e: false;
        readonly slug: "IoTThingsGraph";
        readonly comparableTerms: readonly ["iotthingsgraph"];
    };
    readonly awsKeyManagementService: {
        readonly name: "AWS Key Management Service";
        readonly serviceCode: "awsKeyManagementService";
        readonly description: "Securely Generate and Manage AWS Encryption Keys";
        readonly searchKeywords: readonly ["KMS", "Key Management System"];
        readonly type: "AWSService";
        readonly regions: readonly ["af-south-1", "ap-east-1", "ap-northeast-1", "ap-northeast-2", "ap-northeast-3", "ap-south-1", "ap-southeast-1", "ap-southeast-2", "ap-southeast-3", "ca-central-1", "eu-central-1", "eu-north-1", "eu-south-1", "eu-west-1", "eu-west-2", "eu-west-3", "me-south-1", "me-central-1", "sa-east-1", "us-east-1", "us-east-2", "us-gov-east-1", "us-gov-west-1", "us-west-1", "us-west-2"];
        readonly linkUrl: "https://aws.amazon.com/kms/";
        readonly isActive: "true";
        readonly disableConfigure: false;
        readonly serviceDefinitionLocation: "https://d1qsjq9pzbk1k6.cloudfront.net/data/awsKeyManagementService/en_US.json";
        readonly c2e: false;
        readonly templates: readonly [];
        readonly disableRegionSupport: false;
        readonly slug: "KMS";
        readonly mvpSupport: false;
        readonly comparableTerms: readonly ["keymanagement", "keymanagementservice", "kms"];
    };
    readonly awsLakeFormation: {
        readonly name: "AWS Lake Formation";
        readonly serviceCode: "awsLakeFormation";
        readonly description: "AWS Lake Formation provides database, table, column and tag-based access controls, and cross-account sharing at no charge. Governed Tables provide ACID transactions as a fully managed service that enable you to reliably update multiple tables, while maintaining a consistent view for all users. Managing concurrent transactions and being able to travel back to previous version of the table requires storing metadata about each transaction. Lake Formation charges a fee for transaction requests and for metadata storage. In addition, to providing a consistent view of data and enforce row and cell-level security the Lake Formation Storage API scans data in Amazon S3 and applies row and cell filters before returning results to applications. There is a fee for this filtering.";
        readonly searchKeywords: readonly ["Lake Formation", "LF", "If", "Formation", "lakeformation", "Lake"];
        readonly type: "AWSService";
        readonly regions: readonly ["us-east-1", "us-east-2", "us-west-2", "ap-northeast-1", "ap-northeast-2", "ap-south-1", "ap-southeast-1", "ap-southeast-2", "eu-west-1", "eu-west-2", "eu-central-1", "eu-north-1", "ca-central-1"];
        readonly linkUrl: "https://aws.amazon.com/lake-formation/";
        readonly isActive: "true";
        readonly disableConfigure: false;
        readonly serviceDefinitionLocation: "https://d1qsjq9pzbk1k6.cloudfront.net/data/awsLakeFormation/en_US.json";
        readonly c2e: false;
        readonly slug: "LakeFormation";
        readonly mvpSupport: false;
        readonly comparableTerms: readonly ["lakeformation"];
    };
    readonly aWSLambda: {
        readonly name: "AWS Lambda";
        readonly serviceCode: "aWSLambda";
        readonly description: "AWS Lambda lets you run code without provisioning or managing servers. You pay only for the compute time you consume - there is no charge when your code is not running.";
        readonly searchKeywords: readonly [];
        readonly type: "AWSService";
        readonly regions: readonly ["af-south-1", "ap-east-1", "ap-northeast-1", "ap-northeast-2", "ap-northeast-3", "ap-south-1", "ap-southeast-1", "ap-southeast-2", "ap-southeast-3", "ca-central-1", "eu-central-1", "eu-north-1", "eu-south-1", "eu-west-1", "eu-west-2", "eu-west-3", "me-south-1", "me-central-1", "sa-east-1", "us-east-1", "us-east-2", "us-gov-east-1", "us-gov-west-1", "us-west-1", "us-west-2"];
        readonly linkUrl: "https://aws.amazon.com/lambda/";
        readonly isActive: "true";
        readonly disableConfigure: false;
        readonly serviceDefinitionLocation: "https://d1qsjq9pzbk1k6.cloudfront.net/data/aWSLambda/en_US.json";
        readonly c2e: false;
        readonly templates: readonly [];
        readonly disableRegionSupport: false;
        readonly serviceDefinitionUrlPath: "/data/aWSLambda/en_US.json";
        readonly slug: "Lambda";
        readonly mvpSupport: false;
        readonly comparableTerms: readonly ["lambda"];
    };
    readonly locationService: {
        readonly name: "AWS Location Service";
        readonly serviceCode: "locationService";
        readonly description: "Amazon Location Service provides affordable data, tracking and geofencing capabilities, and native integrations with AWS services, so you can create sophisticated location-enabled applications quickly, without the high cost of custom development.";
        readonly searchKeywords: readonly ["Location Service", "compromising data security", "user privacy", "asset tracking", "location-based marketing", "geofencing"];
        readonly type: "AWSService";
        readonly regions: readonly [];
        readonly linkUrl: "https://aws.amazon.com/location/";
        readonly isActive: "true";
        readonly subType: "subServiceSelector";
        readonly disableConfigure: false;
        readonly serviceDefinitionLocation: "https://d1qsjq9pzbk1k6.cloudfront.net/data/locationService/en_US.json";
        readonly c2e: false;
        readonly templates: readonly ["locationServiceMaps", "locationServicePlaces", "locationServiceRouting", "locationServiceTracking", "locationServiceGeofencing", "locationServiceServiceResources"];
        readonly disableRegionSupport: false;
        readonly serviceDefinitionUrlPath: "/data/locationService/en_US.json";
        readonly slug: "LocationService";
        readonly mvpSupport: false;
        readonly comparableTerms: readonly ["location", "locationservice"];
    };
    readonly amazonMainframeModernization: {
        readonly name: "AWS Mainframe Modernization";
        readonly serviceCode: "amazonMainframeModernization";
        readonly description: "AWS Mainframe Modernization (Preview) is a set of managed tools providing infrastructure and software for migrating, modernizing, and executing mainframe applications.";
        readonly searchKeywords: readonly ["Blu Age", "Micro", "Mainframe", "m2", "instance", "modernization"];
        readonly type: "AWSService";
        readonly regions: readonly [];
        readonly linkUrl: "https://aws.amazon.com/mainframe-modernization/";
        readonly isActive: "true";
        readonly subType: "subServiceSelector";
        readonly disableConfigure: false;
        readonly serviceDefinitionLocation: "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonMainframeModernization/en_US.json";
        readonly c2e: false;
        readonly templates: readonly ["mainframeBluAge", "mainframeMicroFocus"];
        readonly disableRegionSupport: false;
        readonly serviceDefinitionUrlPath: "/data/amazonMainframeModernization/en_US.json";
        readonly slug: "mainframeModernization";
        readonly mvpSupport: false;
        readonly comparableTerms: readonly ["mainframemodernization"];
    };
    readonly migrationHubRefactorSpaces: {
        readonly name: "AWS Migration Hub Refactor Spaces";
        readonly serviceCode: "migrationHubRefactorSpaces";
        readonly description: "AWS Migration Hub Refactor Spaces is the starting point for incremental application refactoring to microservices. Refactor Spaces eliminates the undifferentiated work of building and operating AWS infrastructure for incremental refactoring. You can use Refactor Spaces to reduce the risk of evolving applications into microservices or extending existing applications with new features written in microservices.";
        readonly searchKeywords: readonly ["Migration Hub", "cloud migration", "IT asset", "inventory data", "Refactor Spaces"];
        readonly type: "AWSService";
        readonly regions: readonly ["ap-southeast-1", "ap-southeast-2", "ap-northeast-1", "eu-central-1", "eu-west-1", "eu-west-2", "eu-north-1", "us-east-1", "us-east-2", "us-west-2"];
        readonly linkUrl: "https://aws.amazon.com/migration-hub/";
        readonly isActive: "true";
        readonly disableConfigure: false;
        readonly serviceDefinitionLocation: "https://d1qsjq9pzbk1k6.cloudfront.net/data/migrationHubRefactorSpaces/en_US.json";
        readonly c2e: false;
        readonly templates: readonly [];
        readonly disableRegionSupport: false;
        readonly slug: "migration-hub";
        readonly mvpSupport: false;
        readonly comparableTerms: readonly ["migrationhub", "migrationhubrefactorspaces"];
    };
    readonly amazonNetworkFirewall: {
        readonly name: "AWS Network Firewall";
        readonly serviceCode: "amazonNetworkFirewall";
        readonly description: "AWS Network Firewall is a managed service that makes it easy to deploy essential network protections for all of your Amazon Virtual Private Clouds (VPCs). The service can be setup with just a few clicks and scales automatically with your network traffic, so you don't have to worry about deploying and managing any infrastructure.";
        readonly searchKeywords: readonly ["amazonNetworkFirewall", "AWS Network Firewall"];
        readonly type: "AWSService";
        readonly regions: readonly ["ap-east-1", "ap-south-1", "ap-northeast-2", "ap-northeast-3", "ap-southeast-1", "ap-southeast-2", "ap-northeast-1", "us-gov-west-1", "us-gov-east-1", "ca-central-1", "eu-central-1", "eu-west-1", "eu-west-2", "eu-west-3", "eu-north-1", "eu-south-1", "me-south-1", "us-east-1", "us-east-2", "us-west-1", "us-west-2", "sa-east-1", "af-south-1"];
        readonly linkUrl: "https://aws.amazon.com/network-firewall/";
        readonly isActive: "true";
        readonly disableConfigure: false;
        readonly serviceDefinitionLocation: "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonNetworkFirewall/en_US.json";
        readonly c2e: false;
        readonly templates: readonly [];
        readonly disableRegionSupport: false;
        readonly serviceDefinitionUrlPath: "/data/amazonNetworkFirewall/en_US.json";
        readonly slug: "networkfirewall";
        readonly mvpSupport: false;
        readonly comparableTerms: readonly ["networkfirewall"];
    };
    readonly awsOutposts: {
        readonly name: "AWS Outposts";
        readonly serviceCode: "awsOutposts";
        readonly description: "AWS Outposts is a fully managed service that offers the same AWS infrastructure, AWS services, APIs, and tools to virtually any datacenter, co-location space, or on-premises facility for a truly consistent hybrid experience. AWS Outposts is ideal for workloads that require low latency access to on-premises systems, local data processing, data residency, and migration of applications with local system interdependencies.";
        readonly searchKeywords: readonly ["Outposts", "AWS infrastructure", "AWS services", "API", "datacenter", "on-premises facility", "hybrid", "compute", "storage", "database", "EC2", "EBS", "S3"];
        readonly type: "AWSService";
        readonly regions: readonly ["us-east-1"];
        readonly linkUrl: "https://aws.amazon.com/outposts/";
        readonly isActive: "true";
        readonly hasDataTransfer: false;
        readonly disableConfigure: false;
        readonly serviceDefinitionLocation: "https://d1qsjq9pzbk1k6.cloudfront.net/data/awsOutposts/en_US.json";
        readonly c2e: false;
        readonly templates: readonly [];
        readonly disableRegionSupport: true;
        readonly serviceDefinitionUrlPath: "/data/awsOutposts/en_US.json";
        readonly slug: "Outposts";
        readonly mvpSupport: false;
        readonly comparableTerms: readonly ["outposts"];
    };
    readonly aWSPricingCalculatorStrings: {
        readonly name: "AWS Pricing Calculator Strings";
        readonly serviceCode: "aWSPricingCalculatorStrings";
        readonly searchKeywords: readonly [];
        readonly type: "static";
        readonly regions: readonly [];
        readonly isActive: "true";
        readonly disableConfigure: false;
        readonly serviceDefinitionLocation: "https://d1qsjq9pzbk1k6.cloudfront.net/data/aWSPricingCalculatorStrings/en_US.json";
        readonly c2e: false;
        readonly templates: readonly [];
        readonly disableRegionSupport: false;
        readonly bulkImportEnabled: false;
        readonly serviceDefinitionUrlPath: "/data/aWSPricingCalculatorStrings/en_US.json";
        readonly mvpSupport: false;
        readonly comparableTerms: readonly ["pricingcalculatorstrings"];
    };
    readonly awsPrivateLinkVpc: {
        readonly name: "AWS PrivateLink";
        readonly serviceCode: "awsPrivateLinkVpc";
        readonly description: "WS Virtual Private Network solutions establish secure connections between your on-premises networks, remote offices, client devices, and the AWS global network. AWS VPN is comprised of two services: AWS Site-to-Site VPN and AWS Client VPN. Each service provides a highly-available, managed, and elastic cloud VPN solution to protect your network traffic.";
        readonly searchKeywords: readonly ["access control", "ACL", "AWS Privatelink", "Cloud connectivity", "corporate network", "elastic IP", "Gateway load balancer", "home network VPN", "IPAM", "NAT", "NAT gateway", "Network Access Analyzer", "Network Address Translation", "Networking Content Delivery", "PrivateLink", "Reachability Analyzer", "security", "single tenant hardware", "static ip", "subnets", "Traffic mirroring", "Transit Gateway", "Virtual Private Cloud", "VPN"];
        readonly type: "AWSService";
        readonly regions: readonly ["af-south-1", "ap-east-1", "ap-northeast-1", "ap-northeast-2", "ap-northeast-3", "ap-south-1", "ap-southeast-1", "ap-southeast-2", "ap-southeast-3", "ca-central-1", "eu-central-1", "eu-north-1", "eu-south-1", "eu-west-1", "eu-west-2", "eu-west-3", "me-south-1", "me-central-1", "sa-east-1", "us-east-1", "us-east-2", "us-west-1", "us-west-2", "us-gov-west-1"];
        readonly isActive: "true";
        readonly subType: "subService";
        readonly disableConfigure: false;
        readonly serviceDefinitionLocation: "https://d1qsjq9pzbk1k6.cloudfront.net/data/awsPrivateLinkVpc/en_US.json";
        readonly c2e: false;
        readonly templates: readonly [];
        readonly disableRegionSupport: false;
        readonly serviceDefinitionUrlPath: "/data/awsPrivateLinkVpc/en_US.json";
        readonly mvpSupport: false;
        readonly comparableTerms: readonly ["privatelink", "privatelinkvpc"];
        readonly parentServiceCode: "amazonVirtualPrivateCloud";
    };
    readonly awsProfessionalServices: {
        readonly name: "AWS Professional Services";
        readonly serviceCode: "awsProfessionalServices";
        readonly description: " The AWS Professional Services team provides assistance through a collection of offerings that help you achieve specific outcomes related to enterprise cloud adoption. We also deliver focused guidance through our global specialty practices, which cover a variety of solutions, technologies, and industries.";
        readonly searchKeywords: readonly ["ProServe", "professional", "Service"];
        readonly type: "AWSService";
        readonly regions: readonly [];
        readonly linkUrl: "https://aws.amazon.com/professional-services/";
        readonly isActive: "true";
        readonly subType: "subServiceSelector";
        readonly disableConfigure: false;
        readonly serviceDefinitionLocation: "https://d1qsjq9pzbk1k6.cloudfront.net/data/awsProfessionalServices/en_US.json";
        readonly c2e: true;
        readonly templates: readonly ["proServeYear1Cost", "proServeYear2Cost", "proServeYear3Cost", "proServeYear4Cost", "proServeYear5Cost"];
        readonly disableRegionSupport: true;
        readonly bulkImportEnabled: false;
        readonly serviceDefinitionUrlPath: "/data/awsProfessionalServices/en_US.json";
        readonly mvpSupport: true;
        readonly comparableTerms: readonly ["professionalservices"];
    };
    readonly awsSecretsManager: {
        readonly name: "AWS Secrets Manager";
        readonly serviceCode: "awsSecretsManager";
        readonly description: "AWS Secrets Manager enables you to rotate, manage, and retrieve secrets throughout their lifecycle, making it easier to maintain a secure environment that meets your security and compliance needs. With Secrets Manager, you pay based on the number of secrets stored and API calls made.";
        readonly searchKeywords: readonly ["Secrets", "Secrets Manager"];
        readonly type: "AWSService";
        readonly regions: readonly ["us-gov-west-1", "us-gov-east-1", "af-south-1", "ap-east-1", "ap-south-1", "ap-northeast-2", "ap-southeast-1", "ap-southeast-2", "ap-southeast-3", "ap-northeast-1", "ca-central-1", "eu-central-1", "eu-west-1", "eu-west-2", "eu-south-1", "eu-west-3", "eu-north-1", "me-south-1", "me-central-1", "sa-east-1", "us-east-1", "us-east-2", "us-west-1", "us-west-2"];
        readonly linkUrl: "https://aws.amazon.com/secrets-manager/";
        readonly isActive: "true";
        readonly disableConfigure: false;
        readonly serviceDefinitionLocation: "https://d1qsjq9pzbk1k6.cloudfront.net/data/awsSecretsManager/en_US.json";
        readonly c2e: false;
        readonly templates: readonly [];
        readonly disableRegionSupport: false;
        readonly slug: "SecretsManager";
        readonly mvpSupport: false;
        readonly comparableTerms: readonly ["secretsmanager"];
    };
    readonly awsSecurityHub: {
        readonly name: "AWS Security Hub";
        readonly serviceCode: "awsSecurityHub";
        readonly description: "AWS Security Hub performs security best practice checks and ingests security findings from AWS security services and partners.";
        readonly searchKeywords: readonly ["security", "hub"];
        readonly type: "AWSService";
        readonly regions: readonly ["af-south-1", "ap-east-1", "ap-south-1", "ap-northeast-3", "ap-northeast-2", "ap-southeast-1", "ap-southeast-2", "ap-northeast-1", "us-gov-east-1", "us-gov-west-1", "ca-central-1", "eu-central-1", "eu-west-1", "eu-west-2", "eu-south-1", "eu-west-3", "eu-north-1", "me-south-1", "sa-east-1", "sa-east-1", "us-east-1", "us-east-2", "us-west-1", "us-west-2"];
        readonly linkUrl: "https://aws.amazon.com/security-hub/";
        readonly isActive: "true";
        readonly serviceDefinitionLocation: "https://d1qsjq9pzbk1k6.cloudfront.net/data/awsSecurityHub/en_US.json";
        readonly c2e: false;
        readonly slug: "securityHub";
        readonly mvpSupport: false;
        readonly comparableTerms: readonly ["securityhub"];
    };
    readonly awsShield: {
        readonly name: "AWS Shield";
        readonly serviceCode: "awsShield";
        readonly description: "AWS Shield Advanced is a paid service that provides additional protections for internet-facing applications running on Amazon Elastic Compute Cloud (EC2), Elastic Load Balancing (ELB), Amazon CloudFront, AWS Global Accelerator, and Amazon Route 53. AWS Shield Advanced is available to all customers; however, to contact the AWS Shield Response Team customers will need the Enterprise or Business Support levels of AWS Premium Support.";
        readonly searchKeywords: readonly ["shield", "DDoS"];
        readonly type: "AWSService";
        readonly regions: readonly [" "];
        readonly linkUrl: "https://aws.amazon.com/shield/pricing/";
        readonly isActive: "true";
        readonly disableConfigure: false;
        readonly serviceDefinitionLocation: "https://d1qsjq9pzbk1k6.cloudfront.net/data/awsShield/en_US.json";
        readonly c2e: false;
        readonly templates: readonly [];
        readonly disableRegionSupport: false;
        readonly bulkImportEnabled: false;
        readonly serviceDefinitionUrlPath: "/data/awsShield/en_US.json";
        readonly slug: "shield";
        readonly mvpSupport: false;
        readonly comparableTerms: readonly ["shield", "shieldpricing"];
    };
    readonly awsSnowball: {
        readonly name: "AWS Snowball";
        readonly serviceCode: "awsSnowball";
        readonly description: "AWS Snowball, a part of the AWS Snow Family, is an edge computing, data migration, and edge storage device that comes in two options. Snowball Edge Storage Optimized devices provide both block storage and Amazon S3-compatible object storage, and 40 vCPUs. They are well suited for local storage and large scale-data transfer. Snowball Edge Compute Optimized devices provide 52 vCPUs, block and object storage, and an optional GPU for use cases like advanced machine learning and full motion video analysis in disconnected environments.";
        readonly searchKeywords: readonly ["Snow", "Snowball", "Snowball Edge", "Disconnected Data Transfer", "Edge Computing", "Data Export"];
        readonly type: "AWSService";
        readonly regions: readonly [];
        readonly linkUrl: "https://aws.amazon.com/snowball/";
        readonly isActive: "true";
        readonly subType: "subServiceSelector";
        readonly disableConfigure: false;
        readonly serviceDefinitionLocation: "https://d1qsjq9pzbk1k6.cloudfront.net/data/awsSnowball/en_US.json";
        readonly c2e: false;
        readonly templates: readonly ["snowballEdgeComputeOptimizedWithEc2ComputeInstances", "snowballEdgeComputeOptimizedGpuWithEc2ComputeInstances", "snowballEdgeStorageOptimizedWithEc2ComputeInstances", "snowballEdgeStorageOptimizedDataTransferOnly"];
        readonly disableRegionSupport: false;
        readonly serviceDefinitionUrlPath: "/data/awsSnowball/en_US.json";
        readonly slug: "Snowball";
        readonly mvpSupport: false;
        readonly comparableTerms: readonly ["snowball"];
    };
    readonly awsSnowmobile: {
        readonly name: "AWS Snowmobile";
        readonly serviceCode: "awsSnowmobile";
        readonly description: "AWS Snowmobile is an Exabyte-scale data transfer service used to move extremely large amounts of data to AWS. You can transfer up to 100PB per Snowmobile, a 45-foot long ruggedized shipping container, pulled by a semi-trailer truck. Snowmobile makes it easy to move massive volumes of data to the cloud, including video libraries, image repositories, or even a complete data center migration. Transferring data with Snowmobile is more secure, fast and cost effective.";
        readonly searchKeywords: readonly ["Snowmobile", "data transfer", "video libraries", "image repositories", "data center migration", "truck", "shipping container"];
        readonly type: "AWSService";
        readonly regions: readonly ["us-gov-west-1"];
        readonly linkUrl: "https://aws.amazon.com/snowmobile/";
        readonly isActive: "true";
        readonly hasDataTransfer: false;
        readonly disableConfigure: false;
        readonly serviceDefinitionLocation: "https://d1qsjq9pzbk1k6.cloudfront.net/data/awsSnowmobile/en_US.json";
        readonly c2e: false;
        readonly templates: readonly [];
        readonly disableRegionSupport: true;
        readonly serviceDefinitionUrlPath: "/data/awsSnowmobile/en_US.json";
        readonly slug: "Snowmobile";
        readonly mvpSupport: false;
        readonly comparableTerms: readonly ["snowmobile"];
    };
    readonly awsStepFunctions: {
        readonly name: "AWS Step Functions";
        readonly serviceCode: "awsStepFunctions";
        readonly description: "AWS Step Functions is a serverless function orchestrator that makes it easy to sequence AWS Lambda functions and multiple AWS services into business-critical applications.";
        readonly searchKeywords: readonly ["workflows", " workflow", " orchestrator", " orchestration", " serverless", " state machine", " State Machines", " States", " State", " Microservices", " application integration", " Amazon States Language", " ASL", " Data Science SDK", " data processing", " API orchestration", " DAG", " DAGs", " Step Functions", " Step Function", " Step", " media processing", " application orchestration", " serverless orchestration", " serverless workflow", " lambda orchestration", " serverless state machine", " asynchronous", " synchronous", " event-driven data processing", " event-driven", " event orchestration", " standard workflows", " standard workflow", " express workflow", " express workflows", " standard workflows", " error handling", " service integrations", " state management", " visual workflow", " visual monitoring", " high volume orchestration", " function", " functions", " machine learning workflow", " machine learning workflows", " JSON", " serverless workflows", " serverless workflow", " Business logic", " complex workflows", " data pipeline", " data processing", " decoupling", " decouple applications", " abstraction", " abstraction layer", " automation", " It automation", " connecting aws services", " integration of aws services", " coordinating AWS services", " managed workflows", " call back patterns", " callback pattern", " callback patterns", " call back pattern", " human approval", " manual approval", " human intervention", " EKS orchestration", " container orchestration", " short duration workflows", " long duration workflows", " short-duration workflows", " short-duration workflow", " long-running workflow", " long-running workflows", " machine-learning workflows", " ML workflows", " ML workflow", " API orchestration", " function", " functions", " compute function", " compute functions", " Lambda retry", " Lambda retries", " serverless compute", " parallel processing", " Lambda chaining", " error-handling", " retries", " saga pattern", " nested", " branching", " nesting", " nested pattern", " branching pattern", " nesting pattern", " serverless patterns", " event-driven patterns", " coordinating workflows"];
        readonly type: "AWSService";
        readonly regions: readonly [];
        readonly linkUrl: "https://aws.amazon.com/step-functions/";
        readonly isActive: "true";
        readonly subType: "subServiceSelector";
        readonly disableConfigure: false;
        readonly serviceDefinitionLocation: "https://d1qsjq9pzbk1k6.cloudfront.net/data/awsStepFunctions/en_US.json";
        readonly c2e: false;
        readonly templates: readonly ["stepFunctionStandard", "stepFunctionExpress"];
        readonly disableRegionSupport: false;
        readonly serviceDefinitionUrlPath: "/data/awsStepFunctions/en_US.json";
        readonly slug: "StepFunctions";
        readonly mvpSupport: false;
        readonly comparableTerms: readonly ["stepfunctions"];
    };
    readonly aWSStorageGateway: {
        readonly name: "AWS Storage Gateway";
        readonly serviceCode: "aWSStorageGateway";
        readonly description: "AWS Storage Gateway is a hybrid storage service that enables your on-premises applications to seamlessly use AWS cloud storage. You can use the service for backup and archiving, disaster recovery, cloud data processing, storage tiering, and migration.";
        readonly searchKeywords: readonly ["Storage", "on premises", "cloud migration", "integrated storage", "store data in the cloud", "secure storage", "storage integration", "hybrid storage", "on prem storage", "gateway cached volumes", "gateway stored volumes", "gateway virtual tape library", "VTL", "backup", "disaster recovery", "disaster resilience", "corporate file sharing", "data mirroring", "cloud storage"];
        readonly type: "AWSService";
        readonly regions: readonly [""];
        readonly linkUrl: "https://aws.amazon.com/storagegateway/";
        readonly isActive: "true";
        readonly hasDataTransfer: true;
        readonly disableConfigure: false;
        readonly serviceDefinitionLocation: "https://d1qsjq9pzbk1k6.cloudfront.net/data/aWSStorageGateway/en_US.json";
        readonly c2e: false;
        readonly templates: readonly [];
        readonly disableRegionSupport: false;
        readonly bulkImportEnabled: false;
        readonly serviceDefinitionUrlPath: "/data/aWSStorageGateway/en_US.json";
        readonly slug: "StorageGateway";
        readonly mvpSupport: false;
        readonly comparableTerms: readonly ["storagegateway"];
    };
    readonly awsSystemsManager: {
        readonly name: "AWS Systems Manager";
        readonly serviceCode: "awsSystemsManager";
        readonly description: "AWS Systems Manager gives you visibility and control of your infrastructure on AWS. Systems Manager provides a unified user interface so you can view operational data from multiple AWS services and allows you to automate operational tasks across your AWS resources.";
        readonly searchKeywords: readonly ["Manager", "Systems", "control", "infrastructure", "operational data", "visibility", "resource management", "application management", "unified user interface", "OpsCenter", "Automation", "On-premesis instance management", "Distributor", "Parameter Store", "AWS AppConfig"];
        readonly type: "AWSService";
        readonly regions: readonly [];
        readonly linkUrl: "https://aws.amazon.com/systems-manager/";
        readonly isActive: "true";
        readonly subType: "subServiceSelector";
        readonly disableConfigure: false;
        readonly serviceDefinitionLocation: "https://d1qsjq9pzbk1k6.cloudfront.net/data/awsSystemsManager/en_US.json";
        readonly c2e: false;
        readonly templates: readonly ["awsSystemsManagerOpsCenter", "awsAppConfig", "awsSystemsManagerParameterStore", "awsSystemsManagerOnPremisesInstanceManagement", "awsSystemsManagerDistributor", "awsSystemsManagerAutomation", "awsSystemsManagerIncidentManager"];
        readonly disableRegionSupport: false;
        readonly serviceDefinitionUrlPath: "/data/awsSystemsManager/en_US.json";
        readonly slug: "SystemsManager";
        readonly mvpSupport: false;
        readonly comparableTerms: readonly ["systemsmanager"];
    };
    readonly aWSTransferForSFTP: {
        readonly name: "AWS Transfer Family";
        readonly serviceCode: "aWSTransferForSFTP";
        readonly description: "AWS Transfer Family is a fully managed SFTP, FTPS, and FTP service.";
        readonly searchKeywords: readonly ["sftp", "amazon s3", "s3", "winscp", "filezilla", "cyberduck", "ssh", "transfer", "ftp", "ftp/s", "openssh", "file transfer", "secure file transfer", "ssh ftp", "secure shell file transfer protocol", "as2", "file transfer protocol"];
        readonly type: "AWSService";
        readonly regions: readonly ["ap-east-1", "ap-northeast-1", "ap-northeast-2", "ap-south-1", "ap-southeast-1", "ap-southeast-2", "ca-central-1", "eu-central-1", "eu-north-1", "eu-west-1", "eu-west-2", "eu-west-3", "sa-east-1", "us-east-1", "us-east-2", "us-west-1", "us-west-2", "us-gov-west-1", "us-gov-east-1"];
        readonly linkUrl: "https://aws.amazon.com/aws-transfer-family/";
        readonly isActive: "true";
        readonly disableConfigure: false;
        readonly serviceDefinitionLocation: "https://d1qsjq9pzbk1k6.cloudfront.net/data/aWSTransferForSFTP/en_US.json";
        readonly c2e: false;
        readonly slug: "TransferFamily";
        readonly mvpSupport: false;
        readonly comparableTerms: readonly ["transferfamily", "transferforsftp"];
    };
    readonly awsWebApplicationFirewall: {
        readonly name: "AWS Web Application Firewall (WAF)";
        readonly serviceCode: "awsWebApplicationFirewall";
        readonly description: "AWS WAF is a web application firewall that helps protect your web applications or APIs against common web exploits that may affect availability, compromise security, or consume excessive resources.";
        readonly searchKeywords: readonly ["Security Identity Compliance", "appsec", "application security", "web security", "blacklisting", "whitelisting", "Security as a service (SAAS)", "perimeter security", "perimeter protection", "bot detection", "DDoS", "firewall", "IP blocking", "OWASP", "IP reputation", "HTTP flood", "AWS Firewall Manager", "Cross Account WAF", "Cross Account Firewall", "Firewall Compliance", "Firewall Manager"];
        readonly type: "AWSService";
        readonly regions: readonly ["us-east-1", "us-east-2", "us-west-1", "us-west-2", "af-south-1", "ap-east-1", "ap-south-1", "ap-northeast-2", "ap-northeast-3", "ap-southeast-1", "ap-southeast-2", "ap-northeast-1", "us-gov-east-1", "us-gov-west-1", "ca-central-1", "eu-central-1", "eu-west-1", "eu-west-2", "eu-south-1", "eu-west-3", "eu-north-1", "me-south-1", "sa-east-1"];
        readonly linkUrl: "https://aws.amazon.com/waf/";
        readonly isActive: "true";
        readonly serviceDefinitionLocation: "https://d1qsjq9pzbk1k6.cloudfront.net/data/awsWebApplicationFirewall/en_US.json";
        readonly c2e: false;
        readonly slug: "WAF";
        readonly mvpSupport: false;
        readonly comparableTerms: readonly ["waf", "webapplicationfirewall", "webapplicationfirewallwaf"];
    };
    readonly awsXRay: {
        readonly name: "AWS X-Ray";
        readonly serviceCode: "awsXRay";
        readonly description: "AWS X-Ray makes it easy for developers to analyze the behavior of their production, distributed applications with end-to-end tracing capabilities. You can use X-Ray to identify performance bottlenecks, edge case errors, and other hard to detect issues.";
        readonly searchKeywords: readonly ["X-Ray", "xray", "monitor"];
        readonly type: "AWSService";
        readonly regions: readonly ["af-south-1", "ap-east-1", "ap-northeast-1", "ap-northeast-2", "ap-northeast-3", "ap-south-1", "ap-southeast-1", "ap-southeast-2", "ap-southeast-3", "ca-central-1", "eu-central-1", "eu-north-1", "eu-south-1", "eu-west-1", "eu-west-2", "eu-west-3", "me-south-1", "me-central-1", "sa-east-1", "us-east-2", "us-gov-west-1", "us-gov-east-1", "us-west-1", "us-west-2", "us-east-1"];
        readonly linkUrl: "https://aws.amazon.com/xray/";
        readonly isActive: "true";
        readonly disableConfigure: false;
        readonly serviceDefinitionLocation: "https://d1qsjq9pzbk1k6.cloudfront.net/data/awsXRay/en_US.json";
        readonly c2e: false;
        readonly templates: readonly [];
        readonly disableRegionSupport: false;
        readonly slug: "xray";
        readonly mvpSupport: false;
        readonly comparableTerms: readonly ["xray"];
    };
    readonly chimeSdk: {
        readonly name: "Chime SDK";
        readonly serviceCode: "chimeSdk";
        readonly description: "Amazon Chime lets you meet, chat, and collaborate with the security of AWS. You can work seamlessly on your devices, and meet from your desk or on the go - ensuring you always stay connected.";
        readonly searchKeywords: readonly [];
        readonly type: "AWSService";
        readonly regions: readonly ["us-east-1"];
        readonly linkUrl: "https://aws.amazon.com/chime/";
        readonly isActive: "true";
        readonly subType: "subService";
        readonly serviceDefinitionLocation: "https://d1qsjq9pzbk1k6.cloudfront.net/data/chimeSdk/en_US.json";
        readonly c2e: false;
        readonly comparableTerms: readonly ["chimesdk"];
    };
    readonly chimeVoiceConnectorAnalysis: {
        readonly name: "Chime Voice Connector analysis";
        readonly serviceCode: "chimeVoiceConnectorAnalysis";
        readonly description: "Amazon Chime lets you meet, chat, and collaborate with the security of AWS. You can work seamlessly on your devices, and meet from your desk or on the go - ensuring you always stay connected.";
        readonly searchKeywords: readonly [];
        readonly type: "AWSService";
        readonly regions: readonly ["us-east-1"];
        readonly linkUrl: "https://aws.amazon.com/chime/";
        readonly isActive: "true";
        readonly subType: "subService";
        readonly serviceDefinitionLocation: "https://d1qsjq9pzbk1k6.cloudfront.net/data/chimeVoiceConnectorAnalysis/en_US.json";
        readonly c2e: false;
        readonly mvpSupport: false;
        readonly comparableTerms: readonly ["chimevoiceconnectoranalysis"];
    };
    readonly classicLoadBalancer: {
        readonly name: "Classic Load Balancer";
        readonly serviceCode: "classicLoadBalancer";
        readonly description: "Elastic Load Balancing automatically distributes incoming application traffic across multiple targets, such as Amazon EC2 instances, containers, IP addresses, and Lambda functions.";
        readonly searchKeywords: readonly ["ELB", "Elastic Load Balancer", "Load Balancer", "Application Load Balancer", "Network Load Balancer", "Classic Load Balancer"];
        readonly type: "AWSService";
        readonly regions: readonly ["af-south-1", "ap-east-1", "ap-northeast-1", "ap-northeast-2", "ap-northeast-3", "ap-south-1", "ap-southeast-1", "ap-southeast-2", "ap-southeast-3", "ca-central-1", "eu-central-1", "eu-north-1", "eu-south-1", "eu-west-1", "eu-west-2", "eu-west-3", "me-south-1", "me-central-1", "sa-east-1", "us-east-1", "us-east-2", "us-gov-east-1", "us-gov-west-1", "us-west-1", "us-west-2"];
        readonly linkUrl: "https://aws.amazon.com/elasticloadbalancing/";
        readonly isActive: "true";
        readonly subType: "subService";
        readonly disableConfigure: false;
        readonly serviceDefinitionLocation: "https://d1qsjq9pzbk1k6.cloudfront.net/data/classicLoadBalancer/en_US.json";
        readonly c2e: false;
        readonly templates: readonly [];
        readonly disableRegionSupport: false;
        readonly serviceDefinitionUrlPath: "/data/classicLoadBalancer/en_US.json";
        readonly mvpSupport: false;
        readonly comparableTerms: readonly ["classicloadbalancer"];
        readonly parentServiceCode: "elasticLoadBalancing";
    };
    readonly cloudWan: {
        readonly name: "Cloud WAN";
        readonly serviceCode: "cloudWan";
        readonly description: "AWS Cloud WAN provides a central dashboard for making connections between your branch offices, data centers, and Amazon Virtual Private Clouds (VPCs) – building a global network with only a few clicks. You use network policies to automate network management and security tasks in one location. Cloud WAN generates a complete view of your on-premises and AWS networks to help you monitor network health, security, and performance.";
        readonly searchKeywords: readonly ["Cloud WAN", "cloud", "cloudwan"];
        readonly type: "AWSService";
        readonly regions: readonly ["us-east-1"];
        readonly isActive: "true";
        readonly subType: "subService";
        readonly disableConfigure: false;
        readonly serviceDefinitionLocation: "https://d1qsjq9pzbk1k6.cloudfront.net/data/cloudWan/en_US.json";
        readonly c2e: false;
        readonly templates: readonly [];
        readonly disableRegionSupport: false;
        readonly serviceDefinitionUrlPath: "/data/cloudWan/en_US.json";
        readonly slug: "cloudwan";
        readonly mvpSupport: false;
        readonly comparableTerms: readonly ["cloudwan"];
        readonly parentServiceCode: "amazonVirtualPrivateCloud";
    };
    readonly comprehendCustomClassification: {
        readonly name: "Comprehend Custom Classification";
        readonly serviceCode: "comprehendCustomClassification";
        readonly description: "With Amazon Comprehend, you only pay for what you use. You are charged based on the amount of text processed on a monthly basis. Amazon Comprehend provides natural language processing, topic modeling, and Custom Classification capabilities, enabling a broad range of applications that can analyze text.";
        readonly searchKeywords: readonly ["Comprehend", "NLP", "Natural language processing", "Sentiment analysis", "Text analytics", "Entity extraction", "Named entity recognition", "NER", "Key phrase extraction", "Topic modeling", "Unsupervised clustering", "Supervised machine learning", "Custom entity recognition", "Custom classification", "Document classifier", "Personally identifiable information", "PII", "Redaction", "Language detection", "Free form text analytics"];
        readonly type: "AWSService";
        readonly regions: readonly ["us-gov-west-1", "ap-south-1", "ap-northeast-2", "ap-southeast-1", "ap-southeast-2", "ap-northeast-1", "ca-central-1", "eu-central-1", "eu-west-1", "eu-west-2", "us-east-1", "us-east-2", "us-west-2"];
        readonly isActive: "true";
        readonly subType: "subService";
        readonly disableConfigure: false;
        readonly serviceDefinitionLocation: "https://d1qsjq9pzbk1k6.cloudfront.net/data/comprehendCustomClassification/en_US.json";
        readonly c2e: false;
        readonly templates: readonly [];
        readonly disableRegionSupport: false;
        readonly serviceDefinitionUrlPath: "/data/comprehendCustomClassification/en_US.json";
        readonly mvpSupport: false;
        readonly comparableTerms: readonly ["comprehendcustomclassification"];
        readonly parentServiceCode: "amazonComprehend";
    };
    readonly comprehendCustomEntities: {
        readonly name: "Comprehend Custom Entities";
        readonly serviceCode: "comprehendCustomEntities";
        readonly description: "With Amazon Comprehend, you only pay for what you use. You are charged based on the amount of text processed on a monthly basis. Amazon Comprehend provides natural language processing, topic modeling, and Custom Classification capabilities, enabling a broad range of applications that can analyze text.";
        readonly searchKeywords: readonly [];
        readonly type: "AWSService";
        readonly regions: readonly ["us-gov-west-1", "ap-south-1", "ap-northeast-2", "ap-southeast-1", "ap-southeast-2", "ap-northeast-1", "ca-central-1", "eu-central-1", "eu-west-1", "eu-west-2", "us-east-1", "us-east-2", "us-west-2"];
        readonly isActive: "true";
        readonly subType: "subService";
        readonly serviceDefinitionLocation: "https://d1qsjq9pzbk1k6.cloudfront.net/data/comprehendCustomEntities/en_US.json";
        readonly c2e: false;
        readonly mvpSupport: false;
        readonly comparableTerms: readonly ["comprehendcustomentities"];
        readonly parentServiceCode: "amazonComprehend";
    };
    readonly containsPii: {
        readonly name: "Contains PII";
        readonly serviceCode: "containsPii";
        readonly description: "With Amazon Comprehend, you only pay for what you use. You are charged based on the amount of text processed on a monthly basis. Amazon Comprehend provides natural language processing, topic modeling, and Custom Classification capabilities, enabling a broad range of applications that can analyze text.";
        readonly searchKeywords: readonly ["Comprehend", "NLP", "Natural language processing", "Sentiment analysis", "Text analytics", "Entity extraction", "Named entity recognition", "NER", "Key phrase extraction", "Topic modeling", "Unsupervised clustering", "Supervised machine learning", "Custom entity recognition", "Custom classification", "Document classifier", "Personally identifiable information", "PII", "Contains PII", "Redaction", "Language detection", "Free form text analytics"];
        readonly type: "AWSService";
        readonly regions: readonly ["us-gov-west-1", "ap-south-1", "ap-northeast-2", "ap-southeast-1", "ap-southeast-2", "ap-northeast-1", "ca-central-1", "eu-central-1", "eu-west-1", "eu-west-2", "us-east-1", "us-east-2", "us-west-2"];
        readonly isActive: "true";
        readonly subType: "subService";
        readonly disableConfigure: false;
        readonly serviceDefinitionLocation: "https://d1qsjq9pzbk1k6.cloudfront.net/data/containsPii/en_US.json";
        readonly c2e: false;
        readonly templates: readonly [];
        readonly disableRegionSupport: false;
        readonly serviceDefinitionUrlPath: "/data/containsPii/en_US.json";
        readonly mvpSupport: false;
        readonly comparableTerms: readonly ["containspii"];
        readonly parentServiceCode: "amazonComprehend";
    };
    readonly awsS3DataTransfer: {
        readonly name: "Data Transfer";
        readonly serviceCode: "awsS3DataTransfer";
        readonly description: "The cost of transferring data at AWS for services without unique transfer costs.";
        readonly searchKeywords: readonly [];
        readonly type: "AWSService";
        readonly regions: readonly ["af-south-1", "ap-east-1", "ap-northeast-1", "ap-northeast-2", "ap-northeast-3", "ap-south-1", "ap-southeast-1", "ap-southeast-2", "ap-southeast-3", "ca-central-1", "me-south-1", "me-central-1", "eu-central-1", "eu-north-1", "eu-south-1", "eu-west-1", "eu-west-2", "eu-west-3", "sa-east-1", "us-east-1", "us-east-2", "us-gov-east-1", "us-gov-west-1", "us-west-1", "us-west-2"];
        readonly linkUrl: "https://aws.amazon.com/ec2/pricing/on-demand/#Data_Transfer";
        readonly isActive: "true";
        readonly hasDataTransfer: true;
        readonly subType: "subService";
        readonly disableConfigure: false;
        readonly serviceDefinitionLocation: "https://d1qsjq9pzbk1k6.cloudfront.net/data/awsS3DataTransfer/en_US.json";
        readonly c2e: false;
        readonly templates: readonly [];
        readonly disableRegionSupport: false;
        readonly mvpSupport: false;
        readonly comparableTerms: readonly ["datatransfer", "s3datatransfer"];
        readonly parentServiceCode: "amazonSimpleStorageServiceGroup";
    };
    readonly dataTransferVpc: {
        readonly name: "Data Transfer";
        readonly serviceCode: "dataTransferVpc";
        readonly description: "WS Virtual Private Network solutions establish secure connections between your on-premises networks, remote offices, client devices, and the AWS global network. AWS VPN is comprised of two services: AWS Site-to-Site VPN and AWS Client VPN. Each service provides a highly-available, managed, and elastic cloud VPN solution to protect your network traffic.";
        readonly searchKeywords: readonly ["access control", "ACL", "AWS Privatelink", "Cloud connectivity", "corporate network", "elastic IP", "Gateway load balancer", "home network VPN", "IPAM", "NAT", "NAT gateway", "Network Access Analyzer", "Network Address Translation", "Networking Content Delivery", "PrivateLink", "Reachability Analyzer", "security", "single tenant hardware", "static ip", "subnets", "Traffic mirroring", "Transit Gateway", "Virtual Private Cloud", "VPN"];
        readonly type: "AWSService";
        readonly regions: readonly ["af-south-1", "ap-east-1", "ap-southeast-3", "ap-south-1", "ap-northeast-3", "ap-northeast-2", "ap-southeast-1", "ap-southeast-2", "ap-northeast-1", "us-gov-east-1", "us-gov-west-1", "ca-central-1", "eu-central-1", "eu-west-1", "eu-west-2", "eu-south-1", "eu-west-3", "eu-north-1", "me-south-1", "me-central-1", "sa-east-1", "us-east-1", "us-east-2", "us-west-1", "us-west-2"];
        readonly isActive: "true";
        readonly subType: "subService";
        readonly disableConfigure: false;
        readonly serviceDefinitionLocation: "https://d1qsjq9pzbk1k6.cloudfront.net/data/dataTransferVpc/en_US.json";
        readonly c2e: false;
        readonly templates: readonly [];
        readonly disableRegionSupport: false;
        readonly serviceDefinitionUrlPath: "/data/dataTransferVpc/en_US.json";
        readonly mvpSupport: false;
        readonly comparableTerms: readonly ["datatransfer", "datatransfervpc"];
        readonly parentServiceCode: "amazonVirtualPrivateCloud";
    };
    readonly piiDetection: {
        readonly name: "Detect PII";
        readonly serviceCode: "piiDetection";
        readonly description: "With Amazon Comprehend, you only pay for what you use. You are charged based on the amount of text processed on a monthly basis. Amazon Comprehend provides natural language processing, topic modeling, and Custom Classification capabilities, enabling a broad range of applications that can analyze text.";
        readonly searchKeywords: readonly ["Comprehend", "NLP", "Natural language processing", "Sentiment analysis", "Text analytics", "Entity extraction", "Named entity recognition", "NER", "Key phrase extraction", "Topic modeling", "Unsupervised clustering", "Supervised machine learning", "Custom entity recognition", "Custom classification", "Document classifier", "Personally identifiable information", "PII", "Redaction", "Language detection", "Free form text analytics"];
        readonly type: "AWSService";
        readonly regions: readonly ["us-gov-west-1", "ap-south-1", "ap-northeast-2", "ap-southeast-1", "ap-southeast-2", "ap-northeast-1", "ca-central-1", "eu-central-1", "eu-west-1", "eu-west-2", "us-east-1", "us-east-2", "us-west-2"];
        readonly isActive: "true";
        readonly subType: "subService";
        readonly disableConfigure: false;
        readonly serviceDefinitionLocation: "https://d1qsjq9pzbk1k6.cloudfront.net/data/piiDetection/en_US.json";
        readonly c2e: false;
        readonly templates: readonly [];
        readonly disableRegionSupport: false;
        readonly serviceDefinitionUrlPath: "/data/piiDetection/en_US.json";
        readonly mvpSupport: false;
        readonly comparableTerms: readonly ["detectpii", "piidetection"];
        readonly parentServiceCode: "amazonComprehend";
    };
    readonly awsSystemsManagerDistributor: {
        readonly name: "Distributor";
        readonly serviceCode: "awsSystemsManagerDistributor";
        readonly description: "AWS Systems Manager Distributor feature";
        readonly searchKeywords: readonly ["System Manager", "Distributor", "distriubte and maintain software packages"];
        readonly type: "AWSService";
        readonly regions: readonly ["us-gov-west-1", "us-gov-east-1", "af-south-1", "ap-east-1", "ap-south-1", "ap-northeast-3", "ap-northeast-2", "ap-southeast-1", "ap-southeast-2", "ap-southeast-3", "ap-northeast-1", "ca-central-1", "eu-central-1", "eu-west-1", "eu-west-2", "eu-south-1", "eu-west-3", "eu-north-1", "me-south-1", "me-central-1", "sa-east-1", "us-east-1", "us-east-2", "us-west-1", "us-west-2"];
        readonly linkUrl: "https://aws.amazon.com/systems-manager/";
        readonly isActive: "true";
        readonly hasDataTransfer: false;
        readonly subType: "subService";
        readonly disableConfigure: false;
        readonly serviceDefinitionLocation: "https://d1qsjq9pzbk1k6.cloudfront.net/data/awsSystemsManagerDistributor/en_US.json";
        readonly c2e: false;
        readonly templates: readonly [];
        readonly disableRegionSupport: false;
        readonly serviceDefinitionUrlPath: "/data/awsSystemsManagerDistributor/en_US.json";
        readonly mvpSupport: false;
        readonly comparableTerms: readonly ["distributor", "systemsmanagerdistributor"];
        readonly parentServiceCode: "awsSystemsManager";
    };
    readonly amazonDynamoDbDaxClusters: {
        readonly name: "DynamoDB Accelerator (DAX) clusters";
        readonly serviceCode: "amazonDynamoDbDaxClusters";
        readonly description: "Amazon DynamoDB is a key-value and document database that delivers single-digit millisecond performance at any scale. It's a fully managed, multiregion, multimaster, durable database with built-in security, backup and restore, and in-memory caching for internet-scale applications.";
        readonly searchKeywords: readonly ["Database", "DDB", "NoSQL", "SQL", "Table", "nosql databases", "database schema", "database software", "cloud database", "document database", "key value store", "database as a service", "database scheme", "nosql hosting", "hosted nosql", "data store", "unstructured database", "Accelerator", "DAX"];
        readonly type: "AWSService";
        readonly regions: readonly ["us-east-1", "us-east-2", "us-west-1", "us-west-2", "ap-south-1", "ap-southeast-1", "ap-southeast-2", "ap-northeast-1", "eu-central-1", "eu-west-1", "eu-west-2", "eu-west-3", "sa-east-1"];
        readonly linkUrl: "https://aws.amazon.com/dynamodb/";
        readonly isActive: "true";
        readonly hasDataTransfer: true;
        readonly subType: "subService";
        readonly disableConfigure: false;
        readonly serviceDefinitionLocation: "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonDynamoDbDaxClusters/en_US.json";
        readonly c2e: false;
        readonly templates: readonly [];
        readonly disableRegionSupport: false;
        readonly serviceDefinitionUrlPath: "/data/amazonDynamoDbDaxClusters/en_US.json";
        readonly mvpSupport: false;
        readonly comparableTerms: readonly ["dax", "dynamodbacceleratordaxclusters", "dynamodbdaxclusters"];
        readonly parentServiceCode: "amazonDynamoDb";
    };
    readonly dynamoDbBackup: {
        readonly name: "DynamoDB Backup and restore";
        readonly serviceCode: "dynamoDbBackup";
        readonly description: "Amazon DynamoDB is a key-value and document database that delivers single-digit millisecond performance at any scale. It's a fully managed, multiregion, multimaster, durable database with built-in security, backup and restore, and in-memory caching for internet-scale applications.";
        readonly searchKeywords: readonly ["Database", "DDB", "NoSQL", "SQL", "Table", "nosql databases", "database schema", "database software", "cloud database", "document database", "key value store", "database as a service", "database scheme", "nosql hosting", "hosted nosql", "data store", "unstructured database", "Accelerator", "DAX"];
        readonly type: "AWSService";
        readonly regions: readonly ["us-east-1", "us-east-2", "us-west-1", "us-west-2", "af-south-1", "ap-east-1", "ap-south-1", "ap-northeast-2", "ap-southeast-1", "ap-southeast-2", "ap-northeast-1", "ca-central-1", "eu-central-1", "eu-west-1", "eu-west-2", "eu-south-1", "eu-west-3", "eu-north-1", "me-south-1", "me-central-1", "sa-east-1", "us-gov-east-1", "us-gov-west-1"];
        readonly linkUrl: "https://aws.amazon.com/dynamodb/";
        readonly isActive: "true";
        readonly hasDataTransfer: true;
        readonly subType: "subService";
        readonly disableConfigure: false;
        readonly serviceDefinitionLocation: "https://d1qsjq9pzbk1k6.cloudfront.net/data/dynamoDbBackup/en_US.json";
        readonly c2e: false;
        readonly templates: readonly [];
        readonly disableRegionSupport: false;
        readonly serviceDefinitionUrlPath: "/data/dynamoDbBackup/en_US.json";
        readonly mvpSupport: false;
        readonly comparableTerms: readonly ["dynamodbbackup", "dynamodbbackuprestore"];
        readonly parentServiceCode: "amazonDynamoDb";
    };
    readonly dynamoDbChangeDateCapture: {
        readonly name: "DynamoDB change data capture";
        readonly serviceCode: "dynamoDbChangeDateCapture";
        readonly description: "Amazon DynamoDB is a key-value and document database that delivers single-digit millisecond performance at any scale. It's a fully managed, multiregion, multimaster, durable database with built-in security, backup and restore, and in-memory caching for internet-scale applications.";
        readonly searchKeywords: readonly ["Database", "DDB", "NoSQL", "SQL", "Table", "nosql databases", "database schema", "database software", "cloud database", "document database", "key value store", "database as a service", "database scheme", "nosql hosting", "hosted nosql", "data store", "unstructured database", "Accelerator", "DAX", "change data capture", "Kinesis"];
        readonly type: "AWSService";
        readonly regions: readonly ["ap-northeast-1", "ap-northeast-2", "ap-south-1", "ap-southeast-1", "ap-southeast-2", "ca-central-1", "eu-central-1", "eu-north-1", "eu-south-1", "eu-west-1", "eu-west-2", "eu-west-3", "sa-east-1", "us-east-1", "us-east-2", "us-west-1", "us-west-2"];
        readonly linkUrl: "https://aws.amazon.com/dynamodb/";
        readonly isActive: "true";
        readonly subType: "subService";
        readonly disableConfigure: false;
        readonly serviceDefinitionLocation: "https://d1qsjq9pzbk1k6.cloudfront.net/data/dynamoDbChangeDateCapture/en_US.json";
        readonly c2e: false;
        readonly templates: readonly [];
        readonly disableRegionSupport: false;
        readonly serviceDefinitionUrlPath: "/data/dynamoDbChangeDateCapture/en_US.json";
        readonly mvpSupport: false;
        readonly comparableTerms: readonly ["dynamodbchangedatacapture", "dynamodbchangedatecapture"];
        readonly parentServiceCode: "amazonDynamoDb";
    };
    readonly dynamoDbDataExportToAmazonS3: {
        readonly name: "DynamoDB Data export to Amazon S3";
        readonly serviceCode: "dynamoDbDataExportToAmazonS3";
        readonly description: "Amazon DynamoDB is a key-value and document database that delivers single-digit millisecond performance at any scale. It's a fully managed, multiregion, multimaster, durable database with built-in security, backup and restore, and in-memory caching for internet-scale applications.";
        readonly searchKeywords: readonly ["Database", "DDB", "NoSQL", "SQL", "Table", "nosql databases", "database schema", "database software", "cloud database", "document database", "key value store", "database as a service", "database scheme", "nosql hosting", "hosted nosql", "data store", "unstructured database", "Accelerator", "DAX"];
        readonly type: "AWSService";
        readonly regions: readonly ["us-east-1", "us-east-2", "us-west-1", "us-west-2", "af-south-1", "ap-east-1", "ap-south-1", "ap-northeast-3", "ap-northeast-2", "ap-southeast-1", "ap-southeast-2", "ap-northeast-1", "ca-central-1", "eu-central-1", "eu-west-1", "eu-west-2", "eu-south-1", "eu-west-3", "eu-north-1", "me-south-1", "me-central-1", "sa-east-1", "us-gov-east-1", "us-gov-west-1"];
        readonly linkUrl: "https://aws.amazon.com/dynamodb/";
        readonly isActive: "true";
        readonly subType: "subService";
        readonly disableConfigure: false;
        readonly serviceDefinitionLocation: "https://d1qsjq9pzbk1k6.cloudfront.net/data/dynamoDbDataExportToAmazonS3/en_US.json";
        readonly c2e: false;
        readonly templates: readonly [];
        readonly disableRegionSupport: false;
        readonly serviceDefinitionUrlPath: "/data/dynamoDbDataExportToAmazonS3/en_US.json";
        readonly mvpSupport: false;
        readonly comparableTerms: readonly ["dynamodbdataexporttoamazons3", "dynamodbdataexporttos3"];
        readonly parentServiceCode: "amazonDynamoDb";
    };
    readonly dynamoDbDataImportFromAmazonS3: {
        readonly name: "DynamoDB Data Import from Amazon S3";
        readonly serviceCode: "dynamoDbDataImportFromAmazonS3";
        readonly description: "Amazon DynamoDB is a key-value and document database that delivers single-digit millisecond performance at any scale. It's a fully managed, multiregion, multimaster, durable database with built-in security, backup and restore, and in-memory caching for internet-scale applications.";
        readonly searchKeywords: readonly ["Database", "DDB", "NoSQL", "SQL", "Table", "nosql databases", "database schema", "database software", "cloud database", "document database", "key value store", "database as a service", "database scheme", "nosql hosting", "hosted nosql", "data store", "unstructured database", "Accelerator", "DAX"];
        readonly type: "AWSService";
        readonly regions: readonly ["af-south-1", "ap-east-1", "ap-northeast-1", "ap-northeast-2", "ap-northeast-3", "ap-south-1", "ap-southeast-1", "ap-southeast-2", "ap-southeast-3", "ca-central-1", "eu-central-1", "eu-north-1", "eu-south-1", "eu-west-1", "eu-west-2", "eu-west-3", "me-south-1", "me-central-1", "sa-east-1", "us-east-1", "us-east-2", "us-gov-east-1", "us-gov-west-1", "us-west-1", "us-west-2"];
        readonly linkUrl: "https://aws.amazon.com/dynamodb/";
        readonly isActive: "true";
        readonly subType: "subService";
        readonly disableConfigure: false;
        readonly serviceDefinitionLocation: "https://d1qsjq9pzbk1k6.cloudfront.net/data/dynamoDbDataImportFromAmazonS3/en_US.json";
        readonly c2e: false;
        readonly templates: readonly [];
        readonly disableRegionSupport: false;
        readonly serviceDefinitionUrlPath: "/data/dynamoDbDataImportFromAmazonS3/en_US.json";
        readonly mvpSupport: false;
        readonly comparableTerms: readonly ["dynamodbdataimportfromamazons3", "dynamodbdataimportfroms3"];
        readonly parentServiceCode: "amazonDynamoDb";
    };
    readonly dynamoDbOnDemand: {
        readonly name: "DynamoDB on-demand capacity";
        readonly serviceCode: "dynamoDbOnDemand";
        readonly description: "Amazon DynamoDB is a key-value and document database that delivers single-digit millisecond performance at any scale. It's a fully managed, multiregion, multimaster, durable database with built-in security, backup and restore, and in-memory caching for internet-scale applications.";
        readonly searchKeywords: readonly ["Database", "DDB", "NoSQL", "SQL", "Table", "nosql databases", "database schema", "database software", "cloud database", "document database", "key value store", "database as a service", "database scheme", "nosql hosting", "hosted nosql", "data store", "unstructured database", "Accelerator", "DAX"];
        readonly type: "AWSService";
        readonly regions: readonly ["us-east-1", "us-east-2", "us-west-1", "us-west-2", "af-south-1", "ap-east-1", "ap-south-1", "ap-northeast-3", "ap-northeast-2", "ap-southeast-1", "ap-southeast-2", "ap-southeast-3", "ap-northeast-1", "ca-central-1", "eu-central-1", "eu-west-1", "eu-west-2", "eu-south-1", "eu-west-3", "eu-north-1", "me-south-1", "me-central-1", "sa-east-1", "us-gov-east-1", "us-gov-west-1"];
        readonly linkUrl: "https://aws.amazon.com/dynamodb/";
        readonly isActive: "true";
        readonly subType: "subService";
        readonly disableConfigure: false;
        readonly serviceDefinitionLocation: "https://d1qsjq9pzbk1k6.cloudfront.net/data/dynamoDbOnDemand/en_US.json";
        readonly c2e: false;
        readonly templates: readonly [];
        readonly disableRegionSupport: false;
        readonly serviceDefinitionUrlPath: "/data/dynamoDbOnDemand/en_US.json";
        readonly mvpSupport: false;
        readonly comparableTerms: readonly ["dynamodbdemandcapacity", "dynamodbondemand"];
        readonly parentServiceCode: "amazonDynamoDb";
    };
    readonly amazonDynamoDbProvisionedThroughputCapacity: {
        readonly name: "DynamoDB provisioned capacity";
        readonly serviceCode: "amazonDynamoDbProvisionedThroughputCapacity";
        readonly description: "Amazon DynamoDB is a key-value and document database that delivers single-digit millisecond performance at any scale. It's a fully managed, multiregion, multimaster, durable database with built-in security, backup and restore, and in-memory caching for internet-scale applications.";
        readonly searchKeywords: readonly ["Provisioned", "Throughput", "Database", "DynamoDB", "DDB", "NoSQL", "SQL", "Table", "nosql databases", "database schema", "database software", "cloud database", "document database", "key value store", "database as a service", "database scheme", "nosql hosting", "hosted nosql", "data store", "unstructured database", "Accelerator", "DAX"];
        readonly type: "AWSService";
        readonly regions: readonly ["us-east-1", "us-east-2", "us-west-1", "us-west-2", "af-south-1", "ap-east-1", "ap-south-1", "ap-northeast-3", "ap-northeast-2", "ap-southeast-1", "ap-southeast-2", "ap-southeast-3", "ap-northeast-1", "ca-central-1", "eu-central-1", "eu-west-1", "eu-west-2", "eu-south-1", "eu-west-3", "eu-north-1", "me-south-1", "me-central-1", "sa-east-1", "us-gov-east-1", "us-gov-west-1"];
        readonly linkUrl: "https://aws.amazon.com/dynamodb";
        readonly isActive: "true";
        readonly hasDataTransfer: true;
        readonly subType: "subService";
        readonly disableConfigure: false;
        readonly serviceDefinitionLocation: "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonDynamoDbProvisionedThroughputCapacity/en_US.json";
        readonly c2e: false;
        readonly templates: readonly [];
        readonly disableRegionSupport: false;
        readonly serviceDefinitionUrlPath: "/data/amazonDynamoDbProvisionedThroughputCapacity/en_US.json";
        readonly mvpSupport: false;
        readonly comparableTerms: readonly ["dynamodbprovisionedcapacity", "dynamodbprovisionedthroughputcapacity"];
        readonly parentServiceCode: "amazonDynamoDb";
    };
    readonly amazonDynamoDbStreams: {
        readonly name: "DynamoDB Streams";
        readonly serviceCode: "amazonDynamoDbStreams";
        readonly description: "Amazon DynamoDB is a key-value and document database that delivers single-digit millisecond performance at any scale. It's a fully managed, multiregion, multimaster, durable database with built-in security, backup and restore, and in-memory caching for internet-scale applications.";
        readonly searchKeywords: readonly ["Database", "DDB", "NoSQL", "SQL", "Table", "nosql databases", "database schema", "database software", "cloud database", "document database", "key value store", "database as a service", "database scheme", "nosql hosting", "hosted nosql", "data store", "unstructured database", "Accelerator", "DAX"];
        readonly type: "AWSService";
        readonly regions: readonly ["us-east-1", "us-east-2", "us-west-1", "us-west-2", "af-south-1", "ap-east-1", "ap-south-1", "ap-northeast-3", "ap-northeast-2", "ap-southeast-1", "ap-southeast-2", "ap-northeast-1", "ca-central-1", "eu-central-1", "eu-west-1", "eu-west-2", "eu-south-1", "eu-west-3", "eu-north-1", "me-south-1", "me-central-1", "sa-east-1", "us-gov-east-1", "us-gov-west-1"];
        readonly linkUrl: "https://aws.amazon.com/dynamodb/";
        readonly isActive: "true";
        readonly subType: "subService";
        readonly disableConfigure: false;
        readonly serviceDefinitionLocation: "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonDynamoDbStreams/en_US.json";
        readonly c2e: false;
        readonly templates: readonly [];
        readonly disableRegionSupport: false;
        readonly serviceDefinitionUrlPath: "/data/amazonDynamoDbStreams/en_US.json";
        readonly mvpSupport: false;
        readonly comparableTerms: readonly ["dynamodbstreams"];
        readonly parentServiceCode: "amazonDynamoDb";
    };
    readonly elasticLoadBalancing: {
        readonly name: "Elastic Load Balancing";
        readonly serviceCode: "elasticLoadBalancing";
        readonly description: "Elastic Load Balancing automatically distributes incoming application traffic across multiple targets, such as Amazon EC2 instances, containers, IP addresses, and Lambda functions.";
        readonly searchKeywords: readonly ["ELB", "Elastic Load Balancer", "Load Balancer", "Application Load Balancer", "Network Load Balancer", "Gateway Load Balancer", "Classic Load Balancer"];
        readonly type: "AWSService";
        readonly regions: readonly [];
        readonly linkUrl: "https://aws.amazon.com/elasticloadbalancing";
        readonly isActive: "true";
        readonly subType: "subServiceSelector";
        readonly disableConfigure: false;
        readonly serviceDefinitionLocation: "https://d1qsjq9pzbk1k6.cloudfront.net/data/elasticLoadBalancing/en_US.json";
        readonly c2e: false;
        readonly templates: readonly ["applicationLoadBalancer", "networkLoadBalancer", "gatewayLoadBalancer", "classicLoadBalancer"];
        readonly disableRegionSupport: false;
        readonly serviceDefinitionUrlPath: "/data/elasticLoadBalancing/en_US.json";
        readonly slug: "ElasticLoadBalancing";
        readonly mvpSupport: false;
        readonly comparableTerms: readonly ["elasticloadbalancing"];
    };
    readonly entityRecognition: {
        readonly name: "Entity Recognition";
        readonly serviceCode: "entityRecognition";
        readonly description: "With Amazon Comprehend, you only pay for what you use. You are charged based on the amount of text processed on a monthly basis. Amazon Comprehend provides natural language processing, topic modeling, and Custom Classification capabilities, enabling a broad range of applications that can analyze text.";
        readonly searchKeywords: readonly ["Comprehend", "NLP", "Natural language processing", "Sentiment analysis", "Text analytics", "Entity extraction", "Named entity recognition", "NER", "Key phrase extraction", "Topic modeling", "Unsupervised clustering", "Supervised machine learning", "Custom entity recognition", "Custom classification", "Document classifier", "Personally identifiable information", "PII", "Redaction", "Language detection", "Free form text analytics"];
        readonly type: "AWSService";
        readonly regions: readonly ["us-gov-west-1", "ap-south-1", "ap-northeast-2", "ap-southeast-1", "ap-southeast-2", "ap-northeast-1", "ca-central-1", "eu-central-1", "eu-west-1", "eu-west-2", "us-east-1", "us-east-2", "us-west-2"];
        readonly isActive: "true";
        readonly subType: "subService";
        readonly disableConfigure: false;
        readonly serviceDefinitionLocation: "https://d1qsjq9pzbk1k6.cloudfront.net/data/entityRecognition/en_US.json";
        readonly c2e: false;
        readonly templates: readonly [];
        readonly disableRegionSupport: false;
        readonly serviceDefinitionUrlPath: "/data/entityRecognition/en_US.json";
        readonly mvpSupport: false;
        readonly comparableTerms: readonly ["entityrecognition"];
        readonly parentServiceCode: "amazonComprehend";
    };
    readonly eventDetectionPerEventType: {
        readonly name: "Event Detection";
        readonly serviceCode: "eventDetectionPerEventType";
        readonly description: "Comprehend Events identifies real-world events such as acquisitions, IPOs and bankruptcies from text documents and extracts all the related details around the event such as investor, invested, deal amount and more. You can apply natural language processing with asynchronous jobs for event detection across large collections of documents.";
        readonly searchKeywords: readonly ["Comprehend", "NLP", "Natural language processing", "Sentiment analysis", "Text analytics", "Entity extraction", "Named entity recognition", "NER", "Key phrase extraction", "Topic modeling", "Unsupervised clustering", "Supervised machine learning", "Custom entity recognition", "Custom classification", "Document classifier", "Personally identifiable information", "PII", "Redaction", "Language detection", "Free form text analytics", "Event", "Event Analysis"];
        readonly type: "AWSService";
        readonly regions: readonly ["us-gov-west-1", "ap-south-1", "ap-northeast-2", "ap-southeast-1", "ap-southeast-2", "ap-northeast-1", "ca-central-1", "eu-central-1", "eu-west-1", "eu-west-2", "us-east-1", "us-east-2", "us-west-2"];
        readonly isActive: "true";
        readonly subType: "subService";
        readonly disableConfigure: false;
        readonly serviceDefinitionLocation: "https://d1qsjq9pzbk1k6.cloudfront.net/data/eventDetectionPerEventType/en_US.json";
        readonly c2e: false;
        readonly templates: readonly [];
        readonly disableRegionSupport: false;
        readonly serviceDefinitionUrlPath: "/data/eventDetectionPerEventType/en_US.json";
        readonly mvpSupport: false;
        readonly comparableTerms: readonly ["eventdetection", "eventdetectionpereventtype"];
        readonly parentServiceCode: "amazonComprehend";
    };
    readonly fifoTopics: {
        readonly name: "FIFO Topics";
        readonly serviceCode: "fifoTopics";
        readonly description: "Amazon Simple Notification Service (SNS) is a highly available, durable, secure, fully managed pub/sub messaging service that enables you to decouple microservices, distributed systems, and serverless applications";
        readonly searchKeywords: readonly ["Messaging", "SNS", "notification topic", "publish message", "subscription", "text message", "sms", "topics", "push notifications", "push notification service queuing", "FIFO topics"];
        readonly type: "AWSService";
        readonly regions: readonly ["af-south-1", "ap-east-1", "ap-northeast-1", "ap-northeast-2", "ap-northeast-3", "ap-south-1", "ap-southeast-1", "ap-southeast-2", "ap-southeast-3", "ca-central-1", "eu-central-1", "eu-north-1", "eu-south-1", "eu-west-1", "eu-west-2", "eu-west-3", "sa-east-1", "us-east-1", "us-east-2", "us-gov-east-1", "us-gov-west-1", "us-west-1", "us-west-2", "me-south-1"];
        readonly linkUrl: "https://aws.amazon.com/sns/pricing/";
        readonly isActive: "true";
        readonly subType: "subService";
        readonly serviceDefinitionLocation: "https://d1qsjq9pzbk1k6.cloudfront.net/data/fifoTopics/en_US.json";
        readonly c2e: false;
        readonly mvpSupport: false;
        readonly comparableTerms: readonly ["fifotopics"];
        readonly parentServiceCode: "amazonSimpleNotificationService";
    };
    readonly gatewayLoadBalancer: {
        readonly name: "Gateway Load Balancer";
        readonly serviceCode: "gatewayLoadBalancer";
        readonly description: "Elastic Load Balancing automatically distributes incoming application traffic across multiple targets, such as Amazon EC2 instances, containers, IP addresses, and Lambda functions.";
        readonly searchKeywords: readonly ["ELB", "Elastic Load Balancer", "Load Balancer", "Application Load Balancer", "Network Load Balancer", "Classic Load Balancer", "Gateway Load Balancer"];
        readonly type: "AWSService";
        readonly regions: readonly ["af-south-1", "ap-east-1", "ap-northeast-1", "ap-northeast-2", "ap-northeast-3", "ap-south-1", "ap-southeast-1", "ap-southeast-2", "ca-central-1", "eu-central-1", "eu-north-1", "eu-south-1", "eu-west-1", "eu-west-2", "eu-west-3", "me-south-1", "me-central-1", "sa-east-1", "us-east-1", "us-east-2", "us-west-1", "us-west-2", "us-gov-east-1", "us-gov-west-1"];
        readonly linkUrl: "https://aws.amazon.com/elasticloadbalancing/";
        readonly isActive: "true";
        readonly subType: "subService";
        readonly disableConfigure: false;
        readonly serviceDefinitionLocation: "https://d1qsjq9pzbk1k6.cloudfront.net/data/gatewayLoadBalancer/en_US.json";
        readonly c2e: false;
        readonly templates: readonly [];
        readonly disableRegionSupport: false;
        readonly serviceDefinitionUrlPath: "/data/gatewayLoadBalancer/en_US.json";
        readonly mvpSupport: false;
        readonly comparableTerms: readonly ["gatewayloadbalancer"];
        readonly parentServiceCode: "elasticLoadBalancing";
    };
    readonly gatewayLoadBalancerVpc: {
        readonly name: "Gateway Load Balancer";
        readonly serviceCode: "gatewayLoadBalancerVpc";
        readonly description: "Elastic Load Balancing automatically distributes incoming application traffic across multiple targets, such as Amazon EC2 instances, containers, IP addresses, and Lambda functions.";
        readonly searchKeywords: readonly ["ELB", "Elastic Load Balancer", "Load Balancer", "Application Load Balancer", "Network Load Balancer", "Classic Load Balancer", "Gateway Load Balancer"];
        readonly type: "AWSService";
        readonly regions: readonly ["af-south-1", "ap-east-1", "ap-northeast-1", "ap-northeast-2", "ap-northeast-3", "ap-south-1", "ap-southeast-1", "ap-southeast-2", "ap-southeast-3", "ca-central-1", "eu-central-1", "eu-north-1", "eu-south-1", "eu-west-1", "eu-west-2", "eu-west-3", "me-south-1", "me-central-1", "sa-east-1", "us-east-1", "us-east-2", "us-west-1", "us-west-2", "us-gov-east-1", "us-gov-west-1"];
        readonly linkUrl: "https://aws.amazon.com/elasticloadbalancing/";
        readonly isActive: "true";
        readonly subType: "subService";
        readonly disableConfigure: false;
        readonly serviceDefinitionLocation: "https://d1qsjq9pzbk1k6.cloudfront.net/data/gatewayLoadBalancerVpc/en_US.json";
        readonly c2e: false;
        readonly templates: readonly [];
        readonly disableRegionSupport: false;
        readonly serviceDefinitionUrlPath: "/data/gatewayLoadBalancerVpc/en_US.json";
        readonly mvpSupport: false;
        readonly comparableTerms: readonly ["gatewayloadbalancer", "gatewayloadbalancervpc"];
        readonly parentServiceCode: "amazonVirtualPrivateCloud";
    };
    readonly locationServiceGeofencing: {
        readonly name: "Geofencing";
        readonly serviceCode: "locationServiceGeofencing";
        readonly description: "Amazon Location Service provides affordable data, tracking and geofencing capabilities, and native integrations with AWS services, so you can create sophisticated location-enabled applications quickly, without the high cost of custom development.";
        readonly searchKeywords: readonly ["Location Service", "compromising data security", "user privacy", "asset tracking", "location-based marketing", "maps", "places", "routing", "tracking", "geofencing", "Service Resources"];
        readonly type: "AWSService";
        readonly regions: readonly ["ap-southeast-1", "ap-southeast-2", "ap-northeast-1", "eu-central-1", "eu-west-1", "eu-north-1", "us-east-1", "us-east-2", "us-west-2"];
        readonly linkUrl: "https://aws.amazon.com/location/";
        readonly isActive: "true";
        readonly subType: "subService";
        readonly disableConfigure: false;
        readonly serviceDefinitionLocation: "https://d1qsjq9pzbk1k6.cloudfront.net/data/locationServiceGeofencing/en_US.json";
        readonly c2e: false;
        readonly templates: readonly [];
        readonly disableRegionSupport: false;
        readonly serviceDefinitionUrlPath: "/data/locationServiceGeofencing/en_US.json";
        readonly mvpSupport: false;
        readonly comparableTerms: readonly ["geofencing", "locationservicegeofencing"];
        readonly parentServiceCode: "locationService";
    };
    readonly awsIoTCoreHttp: {
        readonly name: "HTTP";
        readonly serviceCode: "awsIoTCoreHttp";
        readonly description: "AWS IoT Core is a managed cloud service that lets connected devices easily and securely interact with cloud applications and other devices.";
        readonly searchKeywords: readonly ["iot", "device", "messages", "shadow", "registry", "rules", "device shadow", "rules engine", "basic ingest", "mqtt", "LoRaWAN"];
        readonly type: "AWSService";
        readonly regions: readonly ["us-east-1", "us-east-2", "us-west-1", "us-west-2", "ap-east-1", "ap-south-1", "ap-northeast-2", "ap-southeast-1", "ap-southeast-2", "ap-northeast-1", "ca-central-1", "eu-central-1", "eu-west-1", "eu-west-2", "eu-west-3", "eu-north-1", "me-south-1", "sa-east-1", "us-gov-east-1", "us-gov-west-1"];
        readonly linkUrl: "https://aws.amazon.com/iot-core/";
        readonly isActive: "true";
        readonly subType: "subService";
        readonly disableConfigure: false;
        readonly serviceDefinitionLocation: "https://d1qsjq9pzbk1k6.cloudfront.net/data/awsIoTCoreHttp/en_US.json";
        readonly c2e: false;
        readonly templates: readonly [];
        readonly disableRegionSupport: false;
        readonly serviceDefinitionUrlPath: "/data/awsIoTCoreHttp/en_US.json";
        readonly mvpSupport: false;
        readonly comparableTerms: readonly ["http", "iotcorehttp"];
        readonly parentServiceCode: "awsIoTCore";
    };
    readonly awsSystemsManagerIncidentManager: {
        readonly name: "Incident Manager";
        readonly serviceCode: "awsSystemsManagerIncidentManager";
        readonly description: "AWS AppConfig enables you to provide validation logic to ensure your configuration data is syntactically and semantically correct according to your definitions before making it available to your application. AWS AppConfig also gives you the ability to roll out configuration changes over a defined time period while monitoring your application so that you can catch errors and roll back the changes if needed, to help you minimize the impact to the users.";
        readonly searchKeywords: readonly ["Systems Manager", "AppConfig", "configuration", "monitoring"];
        readonly type: "AWSService";
        readonly regions: readonly ["us-east-1", "us-east-2", "us-west-2", "ap-southeast-1", "ap-northeast-1", "ap-southeast-2", "eu-north-1", "eu-west-1", "eu-central-1", "me-central-1"];
        readonly linkUrl: "https://aws.amazon.com/systems-manager/";
        readonly isActive: "true";
        readonly hasDataTransfer: false;
        readonly subType: "subService";
        readonly disableConfigure: false;
        readonly serviceDefinitionLocation: "https://d1qsjq9pzbk1k6.cloudfront.net/data/awsSystemsManagerIncidentManager/en_US.json";
        readonly c2e: false;
        readonly templates: readonly [];
        readonly disableRegionSupport: false;
        readonly serviceDefinitionUrlPath: "/data/awsSystemsManagerIncidentManager/en_US.json";
        readonly mvpSupport: false;
        readonly comparableTerms: readonly ["incidentmanager", "systemsmanagerincidentmanager"];
        readonly parentServiceCode: "awsSystemsManager";
    };
    readonly ipamVpc: {
        readonly name: "IPAM";
        readonly serviceCode: "ipamVpc";
        readonly description: "WS Virtual Private Network solutions establish secure connections between your on-premises networks, remote offices, client devices, and the AWS global network. AWS VPN is comprised of two services: AWS Site-to-Site VPN and AWS Client VPN. Each service provides a highly-available, managed, and elastic cloud VPN solution to protect your network traffic.";
        readonly searchKeywords: readonly ["access control", "ACL", "AWS Privatelink", "Cloud connectivity", "corporate network", "elastic IP", "Gateway load balancer", "home network VPN", "IPAM", "NAT", "NAT gateway", "Network Access Analyzer", "Network Address Translation", "Networking Content Delivery", "PrivateLink", "Reachability Analyzer", "security", "single tenant hardware", "static ip", "subnets", "Traffic mirroring", "Transit Gateway", "Virtual Private Cloud", "VPN"];
        readonly type: "AWSService";
        readonly regions: readonly ["af-south-1", "ap-east-1", "ap-northeast-1", "ap-northeast-2", "ap-northeast-3", "ap-south-1", "ap-southeast-1", "ap-southeast-2", "ca-central-1", "eu-central-1", "eu-north-1", "eu-south-1", "eu-west-1", "eu-west-2", "eu-west-3", "me-south-1", "sa-east-1", "us-east-1", "us-east-2", "us-west-1", "us-west-2"];
        readonly isActive: "true";
        readonly subType: "subService";
        readonly disableConfigure: false;
        readonly serviceDefinitionLocation: "https://d1qsjq9pzbk1k6.cloudfront.net/data/ipamVpc/en_US.json";
        readonly c2e: false;
        readonly templates: readonly [];
        readonly disableRegionSupport: false;
        readonly serviceDefinitionUrlPath: "/data/ipamVpc/en_US.json";
        readonly mvpSupport: false;
        readonly comparableTerms: readonly ["ipam", "ipamvpc"];
        readonly parentServiceCode: "amazonVirtualPrivateCloud";
    };
    readonly keyPhraseExtraction: {
        readonly name: "Keyphrase Extraction";
        readonly serviceCode: "keyPhraseExtraction";
        readonly description: "With Amazon Comprehend, you only pay for what you use. You are charged based on the amount of text processed on a monthly basis. Amazon Comprehend provides natural language processing, topic modeling, and Custom Classification capabilities, enabling a broad range of applications that can analyze text.";
        readonly searchKeywords: readonly ["Comprehend", "NLP", "Natural language processing", "Sentiment analysis", "Text analytics", "Entity extraction", "Named entity recognition", "NER", "Key phrase extraction", "Topic modeling", "Unsupervised clustering", "Supervised machine learning", "Custom entity recognition", "Custom classification", "Document classifier", "Personally identifiable information", "PII", "Redaction", "Language detection", "Free form text analytics"];
        readonly type: "AWSService";
        readonly regions: readonly ["us-gov-west-1", "ap-south-1", "ap-northeast-2", "ap-southeast-1", "ap-southeast-2", "ap-northeast-1", "ca-central-1", "eu-central-1", "eu-west-1", "eu-west-2", "us-east-1", "us-east-2", "us-west-2"];
        readonly isActive: "true";
        readonly subType: "subService";
        readonly disableConfigure: false;
        readonly serviceDefinitionLocation: "https://d1qsjq9pzbk1k6.cloudfront.net/data/keyPhraseExtraction/en_US.json";
        readonly c2e: false;
        readonly templates: readonly [];
        readonly disableRegionSupport: false;
        readonly serviceDefinitionUrlPath: "/data/keyPhraseExtraction/en_US.json";
        readonly mvpSupport: false;
        readonly comparableTerms: readonly ["keyphraseextraction"];
        readonly parentServiceCode: "amazonComprehend";
    };
    readonly languageDetection: {
        readonly name: "Language Detection";
        readonly serviceCode: "languageDetection";
        readonly description: "With Amazon Comprehend, you only pay for what you use. You are charged based on the amount of text processed on a monthly basis. Amazon Comprehend provides natural language processing, topic modeling, and Custom Classification capabilities, enabling a broad range of applications that can analyze text.";
        readonly searchKeywords: readonly ["Comprehend", "NLP", "Natural language processing", "Sentiment analysis", "Text analytics", "Entity extraction", "Named entity recognition", "NER", "Key phrase extraction", "Topic modeling", "Unsupervised clustering", "Supervised machine learning", "Custom entity recognition", "Custom classification", "Document classifier", "Personally identifiable information", "PII", "Redaction", "Language detection", "Free form text analytics"];
        readonly type: "AWSService";
        readonly regions: readonly ["us-gov-west-1", "ap-south-1", "ap-northeast-2", "ap-southeast-1", "ap-southeast-2", "ap-northeast-1", "ca-central-1", "eu-central-1", "eu-west-1", "eu-west-2", "us-east-1", "us-east-2", "us-west-2"];
        readonly isActive: "true";
        readonly subType: "subService";
        readonly disableConfigure: false;
        readonly serviceDefinitionLocation: "https://d1qsjq9pzbk1k6.cloudfront.net/data/languageDetection/en_US.json";
        readonly c2e: false;
        readonly templates: readonly [];
        readonly disableRegionSupport: false;
        readonly serviceDefinitionUrlPath: "/data/languageDetection/en_US.json";
        readonly mvpSupport: false;
        readonly comparableTerms: readonly ["languagedetection"];
        readonly parentServiceCode: "amazonComprehend";
    };
    readonly lightsailBlockStorage: {
        readonly name: "Lightsail Block Storage";
        readonly serviceCode: "lightsailBlockStorage";
        readonly searchKeywords: readonly ["Storage", "Simple Storage Service", "bucket", "file storage", "cloud storage", "static website hosting", "object storage", "store objects", "store files", "data migration", "ongoing data ingestion", "backup and recovery", "big data analytics", "nearline archive", "disaster recovery", "content distribution", "cloud storage"];
        readonly type: "AWSService";
        readonly regions: readonly ["us-east-1", "us-east-2", "us-west-2", "ap-northeast-1", "ap-northeast-2", "ap-south-1", "ap-southeast-1", "ap-southeast-2", "ca-central-1", "eu-central-1", "eu-north-1", "eu-west-1", "eu-west-2", "eu-west-3"];
        readonly linkUrl: "https://aws.amazon.com/lightsail/";
        readonly isActive: "true";
        readonly subType: "subService";
        readonly disableConfigure: false;
        readonly serviceDefinitionLocation: "https://d1qsjq9pzbk1k6.cloudfront.net/data/lightsailBlockStorage/en_US.json";
        readonly c2e: false;
        readonly templates: readonly [];
        readonly disableRegionSupport: false;
        readonly serviceDefinitionUrlPath: "/data/lightsailBlockStorage/en_US.json";
        readonly mvpSupport: false;
        readonly comparableTerms: readonly ["lightsailblockstorage"];
        readonly parentServiceCode: "amazonLightsail";
    };
    readonly lightsailCdn: {
        readonly name: "Lightsail CDN";
        readonly serviceCode: "lightsailCdn";
        readonly searchKeywords: readonly ["Storage", "Simple Storage Service", "bucket", "file storage", "cloud storage", "static website hosting", "object storage", "store objects", "store files", "data migration", "ongoing data ingestion", "backup and recovery", "big data analytics", "nearline archive", "disaster recovery", "content distribution", "cloud storage"];
        readonly type: "AWSService";
        readonly regions: readonly ["us-east-1"];
        readonly linkUrl: "https://aws.amazon.com/lightsail/";
        readonly isActive: "true";
        readonly subType: "subService";
        readonly disableConfigure: false;
        readonly serviceDefinitionLocation: "https://d1qsjq9pzbk1k6.cloudfront.net/data/lightsailCdn/en_US.json";
        readonly c2e: false;
        readonly templates: readonly [];
        readonly disableRegionSupport: false;
        readonly serviceDefinitionUrlPath: "/data/lightsailCdn/en_US.json";
        readonly mvpSupport: false;
        readonly comparableTerms: readonly ["lightsailcdn"];
        readonly parentServiceCode: "amazonLightsail";
    };
    readonly lightsailContainers: {
        readonly name: "Lightsail Containers";
        readonly serviceCode: "lightsailContainers";
        readonly searchKeywords: readonly ["Storage", "Simple Storage Service", "bucket", "file storage", "cloud storage", "static website hosting", "object storage", "store objects", "store files", "data migration", "ongoing data ingestion", "backup and recovery", "big data analytics", "nearline archive", "disaster recovery", "content distribution", "cloud storage"];
        readonly type: "AWSService";
        readonly regions: readonly ["us-east-1", "us-east-2", "us-west-2", "ap-northeast-1", "ap-northeast-2", "ap-south-1", "ap-southeast-1", "ap-southeast-2", "ca-central-1", "eu-central-1", "eu-north-1", "eu-west-1", "eu-west-2", "eu-west-3"];
        readonly linkUrl: "https://aws.amazon.com/lightsail/";
        readonly isActive: "true";
        readonly subType: "subService";
        readonly disableConfigure: false;
        readonly serviceDefinitionLocation: "https://d1qsjq9pzbk1k6.cloudfront.net/data/lightsailContainers/en_US.json";
        readonly c2e: false;
        readonly templates: readonly [];
        readonly disableRegionSupport: false;
        readonly serviceDefinitionUrlPath: "/data/lightsailContainers/en_US.json";
        readonly mvpSupport: false;
        readonly comparableTerms: readonly ["lightsailcontainers"];
        readonly parentServiceCode: "amazonLightsail";
    };
    readonly lightsailDataTransfer: {
        readonly name: "Lightsail Data Transfer";
        readonly serviceCode: "lightsailDataTransfer";
        readonly searchKeywords: readonly ["Storage", "Simple Storage Service", "bucket", "file storage", "cloud storage", "static website hosting", "object storage", "store objects", "store files", "data migration", "ongoing data ingestion", "backup and recovery", "big data analytics", "nearline archive", "disaster recovery", "content distribution", "cloud storage"];
        readonly type: "AWSService";
        readonly regions: readonly ["us-west-2"];
        readonly linkUrl: "https://aws.amazon.com/lightsail/";
        readonly isActive: "true";
        readonly subType: "subService";
        readonly disableConfigure: false;
        readonly serviceDefinitionLocation: "https://d1qsjq9pzbk1k6.cloudfront.net/data/lightsailDataTransfer/en_US.json";
        readonly c2e: false;
        readonly templates: readonly [];
        readonly disableRegionSupport: false;
        readonly bulkImportEnabled: false;
        readonly serviceDefinitionUrlPath: "/data/lightsailDataTransfer/en_US.json";
        readonly mvpSupport: false;
        readonly comparableTerms: readonly ["lightsaildatatransfer"];
        readonly parentServiceCode: "amazonLightsail";
    };
    readonly lightsailLoadBalancer: {
        readonly name: "Lightsail Load Balancer";
        readonly serviceCode: "lightsailLoadBalancer";
        readonly searchKeywords: readonly ["Storage", "Simple Storage Service", "bucket", "file storage", "cloud storage", "static website hosting", "object storage", "store objects", "store files", "data migration", "ongoing data ingestion", "backup and recovery", "big data analytics", "nearline archive", "disaster recovery", "content distribution", "cloud storage"];
        readonly type: "AWSService";
        readonly regions: readonly ["us-east-1", "us-east-2", "us-west-2", "ap-northeast-1", "ap-northeast-2", "ap-south-1", "ap-southeast-1", "ap-southeast-2", "ca-central-1", "eu-central-1", "eu-north-1", "eu-west-1", "eu-west-2", "eu-west-3"];
        readonly linkUrl: "https://aws.amazon.com/lightsail/";
        readonly isActive: "true";
        readonly subType: "subService";
        readonly disableConfigure: false;
        readonly serviceDefinitionLocation: "https://d1qsjq9pzbk1k6.cloudfront.net/data/lightsailLoadBalancer/en_US.json";
        readonly c2e: false;
        readonly templates: readonly [];
        readonly disableRegionSupport: false;
        readonly serviceDefinitionUrlPath: "/data/lightsailLoadBalancer/en_US.json";
        readonly mvpSupport: false;
        readonly comparableTerms: readonly ["lightsailloadbalancer"];
        readonly parentServiceCode: "amazonLightsail";
    };
    readonly lightsailManagedDatabases: {
        readonly name: "Lightsail Managed Databases";
        readonly serviceCode: "lightsailManagedDatabases";
        readonly searchKeywords: readonly ["Storage", "Simple Storage Service", "bucket", "file storage", "cloud storage", "static website hosting", "object storage", "store objects", "store files", "data migration", "ongoing data ingestion", "backup and recovery", "big data analytics", "nearline archive", "disaster recovery", "content distribution", "cloud storage"];
        readonly type: "AWSService";
        readonly regions: readonly ["us-east-1", "us-east-2", "us-west-2", "ap-northeast-1", "ap-northeast-2", "ap-south-1", "ap-southeast-1", "ap-southeast-2", "ca-central-1", "eu-central-1", "eu-north-1", "eu-west-1", "eu-west-2", "eu-west-3"];
        readonly linkUrl: "https://aws.amazon.com/lightsail/";
        readonly isActive: "true";
        readonly subType: "subService";
        readonly disableConfigure: false;
        readonly serviceDefinitionLocation: "https://d1qsjq9pzbk1k6.cloudfront.net/data/lightsailManagedDatabases/en_US.json";
        readonly c2e: false;
        readonly templates: readonly [];
        readonly disableRegionSupport: false;
        readonly serviceDefinitionUrlPath: "/data/lightsailManagedDatabases/en_US.json";
        readonly mvpSupport: false;
        readonly comparableTerms: readonly ["lightsailmanageddatabases"];
        readonly parentServiceCode: "amazonLightsail";
    };
    readonly lightsailObjectStorage: {
        readonly name: "Lightsail Object Storage";
        readonly serviceCode: "lightsailObjectStorage";
        readonly searchKeywords: readonly ["Storage", "Simple Storage Service", "bucket", "file storage", "cloud storage", "static website hosting", "object storage", "store objects", "store files", "data migration", "ongoing data ingestion", "backup and recovery", "big data analytics", "nearline archive", "disaster recovery", "content distribution", "cloud storage"];
        readonly type: "AWSService";
        readonly regions: readonly ["ap-south-1", "ap-northeast-2", "ap-southeast-1", "ap-southeast-2", "ap-northeast-1", "ca-central-1", "eu-central-1", "eu-west-1", "eu-west-2", "eu-west-3", "eu-north-1", "us-east-2", "us-east-1", "us-west-2"];
        readonly linkUrl: "https://aws.amazon.com/lightsail/";
        readonly isActive: "true";
        readonly subType: "subService";
        readonly disableConfigure: false;
        readonly serviceDefinitionLocation: "https://d1qsjq9pzbk1k6.cloudfront.net/data/lightsailObjectStorage/en_US.json";
        readonly c2e: false;
        readonly templates: readonly [];
        readonly disableRegionSupport: false;
        readonly serviceDefinitionUrlPath: "/data/lightsailObjectStorage/en_US.json";
        readonly mvpSupport: false;
        readonly comparableTerms: readonly ["lightsailobjectstorage"];
        readonly parentServiceCode: "amazonLightsail";
    };
    readonly lightsailVirtualServers: {
        readonly name: "Lightsail Virtual Servers";
        readonly serviceCode: "lightsailVirtualServers";
        readonly searchKeywords: readonly ["Storage", "Simple Storage Service", "bucket", "file storage", "cloud storage", "static website hosting", "object storage", "store objects", "store files", "data migration", "ongoing data ingestion", "backup and recovery", "big data analytics", "nearline archive", "disaster recovery", "content distribution", "cloud storage"];
        readonly type: "AWSService";
        readonly regions: readonly ["us-east-1", "us-east-2", "us-west-2", "ap-northeast-1", "ap-northeast-2", "ap-south-1", "ap-southeast-1", "ap-southeast-2", "ca-central-1", "eu-central-1", "eu-north-1", "eu-west-1", "eu-west-2", "eu-west-3"];
        readonly linkUrl: "https://aws.amazon.com/lightsail/";
        readonly isActive: "true";
        readonly subType: "subService";
        readonly disableConfigure: false;
        readonly serviceDefinitionLocation: "https://d1qsjq9pzbk1k6.cloudfront.net/data/lightsailVirtualServers/en_US.json";
        readonly c2e: false;
        readonly templates: readonly [];
        readonly disableRegionSupport: false;
        readonly serviceDefinitionUrlPath: "/data/lightsailVirtualServers/en_US.json";
        readonly mvpSupport: false;
        readonly comparableTerms: readonly ["lightsailvirtualservers"];
        readonly parentServiceCode: "amazonLightsail";
    };
    readonly awsIoTCoreLoRaWan: {
        readonly name: "LoRaWAN";
        readonly serviceCode: "awsIoTCoreLoRaWan";
        readonly description: "AWS IoT Core is a managed cloud service that lets connected devices easily and securely interact with cloud applications and other devices.";
        readonly searchKeywords: readonly ["iot", "device", "messages", "shadow", "registry", "rules", "device shadow", "rules engine", "basic ingest", "mqtt", "LoRaWAN"];
        readonly type: "AWSService";
        readonly regions: readonly ["us-east-1", "eu-west-1"];
        readonly linkUrl: "https://aws.amazon.com/iot-core/";
        readonly isActive: "true";
        readonly subType: "subService";
        readonly disableConfigure: false;
        readonly serviceDefinitionLocation: "https://d1qsjq9pzbk1k6.cloudfront.net/data/awsIoTCoreLoRaWan/en_US.json";
        readonly c2e: false;
        readonly templates: readonly [];
        readonly disableRegionSupport: false;
        readonly serviceDefinitionUrlPath: "/data/awsIoTCoreLoRaWan/en_US.json";
        readonly mvpSupport: false;
        readonly comparableTerms: readonly ["iotcorelorawan", "lorawan"];
        readonly parentServiceCode: "awsIoTCore";
    };
    readonly locationServiceMaps: {
        readonly name: "Maps";
        readonly serviceCode: "locationServiceMaps";
        readonly description: "Amazon Location Service provides affordable data, tracking and geofencing capabilities, and native integrations with AWS services, so you can create sophisticated location-enabled applications quickly, without the high cost of custom development.";
        readonly searchKeywords: readonly ["Location Service", "compromising data security", "user privacy", "asset tracking", "location-based marketing", "maps", "places", "routing", "tracking", "geofencing", "Service Resources"];
        readonly type: "AWSService";
        readonly regions: readonly ["ap-southeast-1", "ap-southeast-2", "ap-northeast-1", "eu-central-1", "eu-west-1", "eu-north-1", "us-east-1", "us-east-2", "us-west-2"];
        readonly linkUrl: "https://aws.amazon.com/location/";
        readonly isActive: "true";
        readonly subType: "subService";
        readonly disableConfigure: false;
        readonly serviceDefinitionLocation: "https://d1qsjq9pzbk1k6.cloudfront.net/data/locationServiceMaps/en_US.json";
        readonly c2e: false;
        readonly templates: readonly [];
        readonly disableRegionSupport: false;
        readonly serviceDefinitionUrlPath: "/data/locationServiceMaps/en_US.json";
        readonly mvpSupport: false;
        readonly comparableTerms: readonly ["locationservicemaps", "maps"];
        readonly parentServiceCode: "locationService";
    };
    readonly mediaLiveAudioAddOns: {
        readonly name: "MediaLive Add Ons";
        readonly serviceCode: "mediaLiveAudioAddOns";
        readonly description: "Elemental Media Live Audio Add Ons";
        readonly searchKeywords: readonly ["streaming", "media", "elemental media live"];
        readonly type: "AWSService";
        readonly regions: readonly ["us-east-1", "eu-west-2", "eu-central-1", "ap-southeast-1", "sa-east-1", "us-east-2", "ap-northeast-2", "eu-north-1", "ap-northeast-1", "ap-south-1", "eu-west-1", "us-west-2", "ap-southeast-2", "eu-west-3"];
        readonly linkUrl: "https://aws.amazon.com/medialive/";
        readonly isActive: "true";
        readonly subType: "subService";
        readonly disableConfigure: false;
        readonly serviceDefinitionLocation: "https://d1qsjq9pzbk1k6.cloudfront.net/data/mediaLiveAudioAddOns/en_US.json";
        readonly c2e: false;
        readonly templates: readonly [];
        readonly disableRegionSupport: false;
        readonly bulkImportEnabled: false;
        readonly serviceDefinitionUrlPath: "/data/mediaLiveAudioAddOns/en_US.json";
        readonly mvpSupport: false;
        readonly comparableTerms: readonly ["medialiveaddons", "medialiveaudioaddons"];
        readonly parentServiceCode: "awsElementalMediaLive";
    };
    readonly mediaLiveInput1: {
        readonly name: "MediaLive Inputs";
        readonly serviceCode: "mediaLiveInput1";
        readonly description: "EML input 1";
        readonly searchKeywords: readonly ["streaming", "media", "elemental media live"];
        readonly type: "AWSService";
        readonly regions: readonly ["us-east-1", "eu-west-2", "eu-central-1", "ap-southeast-1", "sa-east-1", "us-east-2", "ap-northeast-2", "eu-north-1", "ap-northeast-1", "ap-south-1", "eu-west-1", "us-west-2", "ap-southeast-2", "eu-west-3"];
        readonly linkUrl: "https://aws.amazon.com/medialive/";
        readonly isActive: "true";
        readonly subType: "subService";
        readonly disableConfigure: false;
        readonly serviceDefinitionLocation: "https://d1qsjq9pzbk1k6.cloudfront.net/data/mediaLiveInput1/en_US.json";
        readonly c2e: false;
        readonly templates: readonly [];
        readonly disableRegionSupport: false;
        readonly serviceDefinitionUrlPath: "/data/mediaLiveInput1/en_US.json";
        readonly mvpSupport: false;
        readonly comparableTerms: readonly ["medialiveinput1", "medialiveinputs"];
        readonly parentServiceCode: "awsElementalMediaLive";
    };
    readonly mediaLiveOutput1: {
        readonly name: "MediaLive Outputs";
        readonly serviceCode: "mediaLiveOutput1";
        readonly description: "EML Output 1";
        readonly searchKeywords: readonly ["streaming", "media", "elemental media live"];
        readonly type: "AWSService";
        readonly regions: readonly ["us-east-1", "eu-west-2", "eu-central-1", "ap-southeast-1", "sa-east-1", "us-east-2", "ap-northeast-2", "eu-north-1", "ap-northeast-1", "ap-south-1", "eu-west-1", "us-west-2", "ap-southeast-2", "eu-west-3"];
        readonly linkUrl: "https://aws.amazon.com/medialive/";
        readonly isActive: "true";
        readonly subType: "subService";
        readonly disableConfigure: false;
        readonly serviceDefinitionLocation: "https://d1qsjq9pzbk1k6.cloudfront.net/data/mediaLiveOutput1/en_US.json";
        readonly c2e: false;
        readonly templates: readonly [];
        readonly disableRegionSupport: false;
        readonly serviceDefinitionUrlPath: "/data/mediaLiveOutput1/en_US.json";
        readonly mvpSupport: false;
        readonly comparableTerms: readonly ["medialiveoutput1", "medialiveoutputs"];
        readonly parentServiceCode: "awsElementalMediaLive";
    };
    readonly medicalIcd10CmOntologyLinkingApi: {
        readonly name: "Medical ICD-10-CM Ontology Linking API";
        readonly serviceCode: "medicalIcd10CmOntologyLinkingApi";
        readonly description: "";
        readonly searchKeywords: readonly ["Comprehend", "NLP", "Natural language processing", "Sentiment analysis", "Text analytics", "Entity extraction", "Named entity recognition", "NER", "Key phrase extraction", "Topic modeling", "Unsupervised clustering", "Supervised machine learning", "Custom entity recognition", "Custom classification", "Document classifier", "Personally identifiable information", "PII", "Redaction", "Language detection", "Free form text analytics"];
        readonly type: "AWSService";
        readonly regions: readonly ["ap-southeast-2", "ca-central-1", "eu-west-1", "eu-west-2", "us-east-1", "us-gov-west-1", "us-east-2", "us-west-2"];
        readonly isActive: "true";
        readonly subType: "subService";
        readonly disableConfigure: false;
        readonly serviceDefinitionLocation: "https://d1qsjq9pzbk1k6.cloudfront.net/data/medicalIcd10CmOntologyLinkingApi/en_US.json";
        readonly c2e: false;
        readonly templates: readonly [];
        readonly disableRegionSupport: false;
        readonly serviceDefinitionUrlPath: "/data/medicalIcd10CmOntologyLinkingApi/en_US.json";
        readonly mvpSupport: false;
        readonly comparableTerms: readonly ["medicalicd10cmontologylinkingapi"];
        readonly parentServiceCode: "amazonComprehendMedical";
    };
    readonly medicalNamedEntityAndRelationshipExtractionNeReApi: {
        readonly name: "Medical Named Entity and Relationship Extraction (NERe) API";
        readonly serviceCode: "medicalNamedEntityAndRelationshipExtractionNeReApi";
        readonly description: "";
        readonly searchKeywords: readonly ["Comprehend", "NLP", "Natural language processing", "Sentiment analysis", "Text analytics", "Entity extraction", "Named entity recognition", "NER", "Key phrase extraction", "Topic modeling", "Unsupervised clustering", "Supervised machine learning", "Custom entity recognition", "Custom classification", "Document classifier", "Personally identifiable information", "PII", "Redaction", "Language detection", "Free form text analytics"];
        readonly type: "AWSService";
        readonly regions: readonly ["ap-southeast-2", "ca-central-1", "eu-west-1", "eu-west-2", "us-east-1", "us-east-2", "us-gov-west-1", "us-west-2"];
        readonly isActive: "true";
        readonly subType: "subService";
        readonly disableConfigure: false;
        readonly serviceDefinitionLocation: "https://d1qsjq9pzbk1k6.cloudfront.net/data/medicalNamedEntityAndRelationshipExtractionNeReApi/en_US.json";
        readonly c2e: false;
        readonly templates: readonly [];
        readonly disableRegionSupport: false;
        readonly serviceDefinitionUrlPath: "/data/medicalNamedEntityAndRelationshipExtractionNeReApi/en_US.json";
        readonly mvpSupport: false;
        readonly comparableTerms: readonly ["medicalnamedentityandrelationshipextractionnereapi", "medicalnamedentityrelationshipextractionnereapi", "nere"];
        readonly parentServiceCode: "amazonComprehendMedical";
    };
    readonly medicalProtectedHealthInformationDataExtractionAndIdentificationPhIdApi: {
        readonly name: "Medical Protected Health Information Data Extraction and Identification (PHId) API";
        readonly serviceCode: "medicalProtectedHealthInformationDataExtractionAndIdentificationPhIdApi";
        readonly description: "";
        readonly searchKeywords: readonly ["Comprehend", "NLP", "Natural language processing", "Sentiment analysis", "Text analytics", "Entity extraction", "Named entity recognition", "NER", "Key phrase extraction", "Topic modeling", "Unsupervised clustering", "Supervised machine learning", "Custom entity recognition", "Custom classification", "Document classifier", "Personally identifiable information", "PII", "Redaction", "Language detection", "Free form text analytics"];
        readonly type: "AWSService";
        readonly regions: readonly ["ap-southeast-2", "ca-central-1", "eu-west-1", "eu-west-2", "us-east-1", "us-gov-west-1", "us-east-2", "us-west-2"];
        readonly isActive: "true";
        readonly subType: "subService";
        readonly disableConfigure: false;
        readonly serviceDefinitionLocation: "https://d1qsjq9pzbk1k6.cloudfront.net/data/medicalProtectedHealthInformationDataExtractionAndIdentificationPhIdApi/en_US.json";
        readonly c2e: false;
        readonly templates: readonly [];
        readonly disableRegionSupport: false;
        readonly serviceDefinitionUrlPath: "/data/medicalProtectedHealthInformationDataExtractionAndIdentificationPhIdApi/en_US.json";
        readonly mvpSupport: false;
        readonly comparableTerms: readonly ["medicalprotectedhealthinformationdataextractionandidentificationphidapi", "medicalprotectedhealthinformationdataextractionidentificationphidapi", "phid"];
        readonly parentServiceCode: "amazonComprehendMedical";
    };
    readonly medicalRxNormOntologyLinkingApi: {
        readonly name: "Medical RxNORM Ontology Linking API";
        readonly serviceCode: "medicalRxNormOntologyLinkingApi";
        readonly description: "";
        readonly searchKeywords: readonly ["Comprehend", "NLP", "Natural language processing", "Sentiment analysis", "Text analytics", "Entity extraction", "Named entity recognition", "NER", "Key phrase extraction", "Topic modeling", "Unsupervised clustering", "Supervised machine learning", "Custom entity recognition", "Custom classification", "Document classifier", "Personally identifiable information", "PII", "Redaction", "Language detection", "Free form text analytics"];
        readonly type: "AWSService";
        readonly regions: readonly ["ap-southeast-2", "ca-central-1", "eu-west-1", "eu-west-2", "us-east-1", "us-gov-west-1", "us-east-2", "us-west-2"];
        readonly isActive: "true";
        readonly subType: "subService";
        readonly serviceDefinitionLocation: "https://d1qsjq9pzbk1k6.cloudfront.net/data/medicalRxNormOntologyLinkingApi/en_US.json";
        readonly c2e: false;
        readonly mvpSupport: false;
        readonly comparableTerms: readonly ["medicalrxnormontologylinkingapi"];
        readonly parentServiceCode: "amazonComprehendMedical";
    };
    readonly medicalSystematizedNomenclatureOfMedicineClinicalTermsSnomedCtApi: {
        readonly name: "Medical Systematized Nomenclature of Medicine Clinical Terms (SNOMED CT) API";
        readonly serviceCode: "medicalSystematizedNomenclatureOfMedicineClinicalTermsSnomedCtApi";
        readonly description: "";
        readonly searchKeywords: readonly ["Comprehend", "NLP", "Natural language processing", "Sentiment analysis", "Text analytics", "Entity extraction", "Named entity recognition", "NER", "Key phrase extraction", "Topic modeling", "Unsupervised clustering", "Supervised machine learning", "Custom entity recognition", "Custom classification", "Document classifier", "Personally identifiable information", "PII", "Redaction", "Language detection", "Free form text analytics"];
        readonly type: "AWSService";
        readonly regions: readonly ["ap-southeast-2", "ca-central-1", "eu-west-1", "eu-west-2", "us-east-1", "us-east-2", "us-gov-west-1", "us-west-2"];
        readonly isActive: "true";
        readonly subType: "subService";
        readonly disableConfigure: false;
        readonly serviceDefinitionLocation: "https://d1qsjq9pzbk1k6.cloudfront.net/data/medicalSystematizedNomenclatureOfMedicineClinicalTermsSnomedCtApi/en_US.json";
        readonly c2e: false;
        readonly templates: readonly [];
        readonly disableRegionSupport: false;
        readonly serviceDefinitionUrlPath: "/data/medicalSystematizedNomenclatureOfMedicineClinicalTermsSnomedCtApi/en_US.json";
        readonly mvpSupport: false;
        readonly comparableTerms: readonly ["medicalsystematizednomenclaturemedicineclinicaltermssnomedctapi", "medicalsystematizednomenclatureofmedicineclinicaltermssnomedctapi", "snomedct"];
        readonly parentServiceCode: "amazonComprehendMedical";
    };
    readonly chimeSdkMessaging: {
        readonly name: "Messaging";
        readonly serviceCode: "chimeSdkMessaging";
        readonly description: "TBD";
        readonly searchKeywords: readonly [];
        readonly type: "AWSService";
        readonly regions: readonly ["eu-central-1", "us-east-1"];
        readonly linkUrl: "https://aws.amazon.com/chime/chime-sdk";
        readonly isActive: "true";
        readonly subType: "subService";
        readonly disableConfigure: false;
        readonly serviceDefinitionLocation: "https://d1qsjq9pzbk1k6.cloudfront.net/data/chimeSdkMessaging/en_US.json";
        readonly c2e: false;
        readonly templates: readonly [];
        readonly disableRegionSupport: false;
        readonly serviceDefinitionUrlPath: "/data/chimeSdkMessaging/en_US.json";
        readonly mvpSupport: false;
        readonly comparableTerms: readonly ["chimesdkmessaging", "messaging"];
        readonly parentServiceCode: "amazonChimeSdk";
    };
    readonly mainframeMicroFocus: {
        readonly name: "Micro Focus replatforming";
        readonly serviceCode: "mainframeMicroFocus";
        readonly description: "For AWS M2 Blu Age managed runtime, you can choose on-demand instances and pay for the runtime by the hour with no long-term commitments or upfront fees, or choose committed plans for additional savings.";
        readonly searchKeywords: readonly [];
        readonly type: "AWSService";
        readonly regions: readonly ["ap-southeast-2", "ca-central-1", "eu-central-1", "eu-west-1", "sa-east-1", "us-east-1", "us-west-2"];
        readonly linkUrl: "https://aws.amazon.com/mainframe-modernization/pricing/";
        readonly isActive: "true";
        readonly subType: "subService";
        readonly disableConfigure: false;
        readonly serviceDefinitionLocation: "https://d1qsjq9pzbk1k6.cloudfront.net/data/mainframeMicroFocus/en_US.json";
        readonly c2e: false;
        readonly templates: readonly [];
        readonly disableRegionSupport: false;
        readonly serviceDefinitionUrlPath: "/data/mainframeMicroFocus/en_US.json";
        readonly mvpSupport: false;
        readonly comparableTerms: readonly ["mainframemicrofocus", "microfocusreplatforming"];
        readonly parentServiceCode: "amazonMainframeModernization";
    };
    readonly awsIoTCoreMqtt: {
        readonly name: "MQTT";
        readonly serviceCode: "awsIoTCoreMqtt";
        readonly description: "AWS IoT Core is a managed cloud service that lets connected devices easily and securely interact with cloud applications and other devices.";
        readonly searchKeywords: readonly ["iot", "device", "messages", "shadow", "registry", "rules", "device shadow", "rules engine", "basic ingest", "mqtt", "LoRaWAN"];
        readonly type: "AWSService";
        readonly regions: readonly ["us-east-1", "us-east-2", "us-west-1", "us-west-2", "ap-east-1", "ap-south-1", "ap-northeast-2", "ap-southeast-1", "ap-southeast-2", "ap-northeast-1", "ca-central-1", "eu-central-1", "eu-west-1", "eu-west-2", "eu-west-3", "eu-north-1", "me-south-1", "sa-east-1", "us-gov-east-1", "us-gov-west-1"];
        readonly linkUrl: "https://aws.amazon.com/iot-core/";
        readonly isActive: "true";
        readonly subType: "subService";
        readonly disableConfigure: false;
        readonly serviceDefinitionLocation: "https://d1qsjq9pzbk1k6.cloudfront.net/data/awsIoTCoreMqtt/en_US.json";
        readonly c2e: false;
        readonly templates: readonly [];
        readonly disableRegionSupport: false;
        readonly serviceDefinitionUrlPath: "/data/awsIoTCoreMqtt/en_US.json";
        readonly mvpSupport: false;
        readonly comparableTerms: readonly ["iotcoremqtt", "mqtt"];
        readonly parentServiceCode: "awsIoTCore";
    };
    readonly networkAccessAnalyzerVpc: {
        readonly name: "Network Access Analyzer";
        readonly serviceCode: "networkAccessAnalyzerVpc";
        readonly description: "WS Virtual Private Network solutions establish secure connections between your on-premises networks, remote offices, client devices, and the AWS global network. AWS VPN is comprised of two services: AWS Site-to-Site VPN and AWS Client VPN. Each service provides a highly-available, managed, and elastic cloud VPN solution to protect your network traffic.";
        readonly searchKeywords: readonly ["access control", "ACL", "AWS Privatelink", "Cloud connectivity", "corporate network", "elastic IP", "Gateway load balancer", "home network VPN", "IPAM", "NAT", "NAT gateway", "Network Access Analyzer", "Network Address Translation", "Networking Content Delivery", "PrivateLink", "Reachability Analyzer", "security", "single tenant hardware", "static ip", "subnets", "Traffic mirroring", "Transit Gateway", "Virtual Private Cloud", "VPN"];
        readonly type: "AWSService";
        readonly regions: readonly ["af-south-1", "ap-east-1", "ap-northeast-1", "ap-northeast-2", "ap-south-1", "ap-southeast-1", "ap-southeast-2", "ca-central-1", "eu-central-1", "eu-north-1", "eu-south-1", "eu-west-1", "eu-west-2", "eu-west-3", "me-south-1", "sa-east-1", "us-east-1", "us-east-2", "us-west-1", "us-west-2"];
        readonly isActive: "true";
        readonly subType: "subService";
        readonly disableConfigure: false;
        readonly serviceDefinitionLocation: "https://d1qsjq9pzbk1k6.cloudfront.net/data/networkAccessAnalyzerVpc/en_US.json";
        readonly c2e: false;
        readonly templates: readonly [];
        readonly disableRegionSupport: false;
        readonly serviceDefinitionUrlPath: "/data/networkAccessAnalyzerVpc/en_US.json";
        readonly mvpSupport: false;
        readonly comparableTerms: readonly ["networkaccessanalyzer", "networkaccessanalyzervpc"];
        readonly parentServiceCode: "amazonVirtualPrivateCloud";
    };
    readonly networkAddressTranslationNatGatewayVpc: {
        readonly name: "Network Address Translation (NAT) Gateway";
        readonly serviceCode: "networkAddressTranslationNatGatewayVpc";
        readonly description: "WS Virtual Private Network solutions establish secure connections between your on-premises networks, remote offices, client devices, and the AWS global network. AWS VPN is comprised of two services: AWS Site-to-Site VPN and AWS Client VPN. Each service provides a highly-available, managed, and elastic cloud VPN solution to protect your network traffic.";
        readonly searchKeywords: readonly ["access control", "ACL", "AWS Privatelink", "Cloud connectivity", "corporate network", "elastic IP", "Gateway load balancer", "home network VPN", "IPAM", "NAT", "NAT gateway", "Network Access Analyzer", "Network Address Translation", "Networking Content Delivery", "PrivateLink", "Reachability Analyzer", "security", "single tenant hardware", "static ip", "subnets", "Traffic mirroring", "Transit Gateway", "Virtual Private Cloud", "VPN"];
        readonly type: "AWSService";
        readonly regions: readonly ["af-south-1", "ap-east-1", "ap-northeast-1", "ap-northeast-2", "ap-northeast-3", "ap-south-1", "ap-southeast-1", "ap-southeast-2", "ap-southeast-3", "ca-central-1", "eu-central-1", "eu-north-1", "eu-south-1", "eu-west-1", "eu-west-2", "eu-west-3", "me-south-1", "me-central-1", "sa-east-1", "us-east-1", "us-east-2", "us-west-1", "us-west-2", "us-gov-east-1", "us-gov-west-1"];
        readonly isActive: "true";
        readonly subType: "subService";
        readonly disableConfigure: false;
        readonly serviceDefinitionLocation: "https://d1qsjq9pzbk1k6.cloudfront.net/data/networkAddressTranslationNatGatewayVpc/en_US.json";
        readonly c2e: false;
        readonly templates: readonly [];
        readonly disableRegionSupport: false;
        readonly serviceDefinitionUrlPath: "/data/networkAddressTranslationNatGatewayVpc/en_US.json";
        readonly mvpSupport: false;
        readonly comparableTerms: readonly ["nat", "networkaddresstranslationnatgateway", "networkaddresstranslationnatgatewayvpc"];
        readonly parentServiceCode: "amazonVirtualPrivateCloud";
    };
    readonly networkLoadBalancer: {
        readonly name: "Network Load Balancer";
        readonly serviceCode: "networkLoadBalancer";
        readonly description: "Elastic Load Balancing automatically distributes incoming application traffic across multiple targets, such as Amazon EC2 instances, containers, IP addresses, and Lambda functions.";
        readonly searchKeywords: readonly ["ELB", "Elastic Load Balancer", "Load Balancer", "Application Load Balancer", "Network Load Balancer", "Classic Load Balancer"];
        readonly type: "AWSService";
        readonly regions: readonly ["af-south-1", "ap-east-1", "ap-northeast-1", "ap-northeast-2", "ap-northeast-3", "ap-south-1", "ap-southeast-1", "ap-southeast-2", "ap-southeast-3", "ca-central-1", "eu-central-1", "eu-north-1", "eu-south-1", "eu-west-1", "eu-west-2", "eu-west-3", "me-south-1", "me-central-1", "sa-east-1", "us-east-1", "us-east-2", "us-gov-east-1", "us-gov-west-1", "us-west-1", "us-west-2"];
        readonly linkUrl: "https://aws.amazon.com/elasticloadbalancing/";
        readonly isActive: "true";
        readonly subType: "subService";
        readonly disableConfigure: false;
        readonly serviceDefinitionLocation: "https://d1qsjq9pzbk1k6.cloudfront.net/data/networkLoadBalancer/en_US.json";
        readonly c2e: false;
        readonly templates: readonly [];
        readonly disableRegionSupport: false;
        readonly serviceDefinitionUrlPath: "/data/networkLoadBalancer/en_US.json";
        readonly mvpSupport: false;
        readonly comparableTerms: readonly ["networkloadbalancer"];
        readonly parentServiceCode: "elasticLoadBalancing";
    };
    readonly neuralTextToSpeech: {
        readonly name: "Neural Text-to-Speech";
        readonly serviceCode: "neuralTextToSpeech";
        readonly description: "Amazon Polly is a service that turns text into lifelike speech, allowing you to create applications that talk, and build entirely new categories of speech-enabled products.";
        readonly searchKeywords: readonly ["polly", "NLP", "speech", "Neural Text-to-Speech"];
        readonly type: "AWSService";
        readonly regions: readonly ["us-gov-west-1", "ap-northeast-2", "ap-southeast-1", "ap-southeast-2", "ap-northeast-1", "ca-central-1", "eu-central-1", "eu-west-1", "eu-west-2", "us-east-1", "us-west-2"];
        readonly linkUrl: "https://aws.amazon.com/polly/";
        readonly isActive: "true";
        readonly subType: "subService";
        readonly serviceDefinitionLocation: "https://d1qsjq9pzbk1k6.cloudfront.net/data/neuralTextToSpeech/en_US.json";
        readonly c2e: false;
        readonly comparableTerms: readonly ["neuraltexttospeech"];
        readonly parentServiceCode: "amazonPolly";
    };
    readonly awsSystemsManagerOnPremisesInstanceManagement: {
        readonly name: "On-Premises Instance Management";
        readonly serviceCode: "awsSystemsManagerOnPremisesInstanceManagement";
        readonly description: "AWS Systems Manager On-Premises Instance Management feature";
        readonly searchKeywords: readonly ["Systems Manager", "On-Premises Instance Management", "On-Prem", "Session Manager"];
        readonly type: "AWSService";
        readonly regions: readonly ["us-gov-west-1", "us-gov-east-1", "af-south-1", "ap-east-1", "ap-south-1", "ap-northeast-2", "ap-southeast-1", "ap-southeast-2", "ap-southeast-3", "ap-northeast-1", "ap-northeast-3", "ca-central-1", "eu-central-1", "eu-west-1", "eu-west-2", "eu-south-1", "eu-west-3", "eu-north-1", "me-south-1", "me-central-1", "sa-east-1", "us-east-1", "us-east-2", "us-west-1", "us-west-2"];
        readonly linkUrl: "https://aws.amazon.com/systems-manager/";
        readonly isActive: "true";
        readonly hasDataTransfer: false;
        readonly subType: "subService";
        readonly disableConfigure: false;
        readonly serviceDefinitionLocation: "https://d1qsjq9pzbk1k6.cloudfront.net/data/awsSystemsManagerOnPremisesInstanceManagement/en_US.json";
        readonly c2e: false;
        readonly templates: readonly [];
        readonly disableRegionSupport: false;
        readonly serviceDefinitionUrlPath: "/data/awsSystemsManagerOnPremisesInstanceManagement/en_US.json";
        readonly mvpSupport: false;
        readonly comparableTerms: readonly ["onpremisesinstancemanagement", "systemsmanageronpremisesinstancemanagement"];
        readonly parentServiceCode: "awsSystemsManager";
    };
    readonly awsSystemsManagerOpsCenter: {
        readonly name: "OpsCenter";
        readonly serviceCode: "awsSystemsManagerOpsCenter";
        readonly description: "AWS Systems Manager OpsCenter feature";
        readonly searchKeywords: readonly ["System Manager", "OpsCenter", "operational issues", "OpsItems"];
        readonly type: "AWSService";
        readonly regions: readonly ["ap-east-1", "ap-south-1", "ap-northeast-2", "ap-northeast-3", "ap-southeast-1", "ap-southeast-2", "ap-southeast-3", "ap-northeast-1", "ca-central-1", "eu-central-1", "eu-west-1", "eu-west-2", "eu-west-3", "eu-north-1", "me-south-1", "me-central-1", "sa-east-1", "us-east-1", "us-east-2", "us-west-1", "us-west-2", "us-gov-west-1", "us-gov-east-1", "eu-south-1", "af-south-1"];
        readonly linkUrl: "https://aws.amazon.com/systems-manager/";
        readonly isActive: "true";
        readonly hasDataTransfer: false;
        readonly subType: "subService";
        readonly disableConfigure: false;
        readonly serviceDefinitionLocation: "https://d1qsjq9pzbk1k6.cloudfront.net/data/awsSystemsManagerOpsCenter/en_US.json";
        readonly c2e: false;
        readonly templates: readonly [];
        readonly disableRegionSupport: false;
        readonly serviceDefinitionUrlPath: "/data/awsSystemsManagerOpsCenter/en_US.json";
        readonly mvpSupport: false;
        readonly comparableTerms: readonly ["opscenter", "systemsmanageropscenter"];
        readonly parentServiceCode: "awsSystemsManager";
    };
    readonly awsSystemsManagerParameterStore: {
        readonly name: "Parameter Store";
        readonly serviceCode: "awsSystemsManagerParameterStore";
        readonly description: "AWS Systems Manager Parameter Store feature";
        readonly searchKeywords: readonly ["System Manager", "Parameter Store", "API", "parameter"];
        readonly type: "AWSService";
        readonly regions: readonly ["us-gov-west-1", "us-gov-east-1", "af-south-1", "ap-east-1", "ap-south-1", "ap-northeast-3", "ap-northeast-2", "ap-southeast-2", "ap-southeast-3", "ap-northeast-1", "ca-central-1", "eu-central-1", "eu-west-1", "eu-west-2", "eu-south-1", "eu-west-3", "eu-north-1", "me-south-1", "me-central-1", "sa-east-1", "us-east-1", "us-east-2", "us-west-1", "us-west-2"];
        readonly linkUrl: "https://aws.amazon.com/systems-manager/";
        readonly isActive: "true";
        readonly hasDataTransfer: false;
        readonly subType: "subService";
        readonly disableConfigure: false;
        readonly serviceDefinitionLocation: "https://d1qsjq9pzbk1k6.cloudfront.net/data/awsSystemsManagerParameterStore/en_US.json";
        readonly c2e: false;
        readonly templates: readonly [];
        readonly disableRegionSupport: false;
        readonly serviceDefinitionUrlPath: "/data/awsSystemsManagerParameterStore/en_US.json";
        readonly mvpSupport: false;
        readonly comparableTerms: readonly ["parameterstore", "systemsmanagerparameterstore"];
        readonly parentServiceCode: "awsSystemsManager";
    };
    readonly locationServicePlaces: {
        readonly name: "Places";
        readonly serviceCode: "locationServicePlaces";
        readonly description: "Amazon Location Service provides affordable data, tracking and geofencing capabilities, and native integrations with AWS services, so you can create sophisticated location-enabled applications quickly, without the high cost of custom development.";
        readonly searchKeywords: readonly ["Location Service", "compromising data security", "user privacy", "asset tracking", "location-based marketing", "maps", "places", "routing", "tracking", "geofencing", "Service Resources"];
        readonly type: "AWSService";
        readonly regions: readonly ["ap-southeast-1", "ap-southeast-2", "ap-northeast-1", "eu-central-1", "eu-west-1", "eu-north-1", "us-east-1", "us-east-2", "us-west-2"];
        readonly linkUrl: "https://aws.amazon.com/location/";
        readonly isActive: "true";
        readonly subType: "subService";
        readonly disableConfigure: false;
        readonly serviceDefinitionLocation: "https://d1qsjq9pzbk1k6.cloudfront.net/data/locationServicePlaces/en_US.json";
        readonly c2e: false;
        readonly templates: readonly [];
        readonly disableRegionSupport: false;
        readonly serviceDefinitionUrlPath: "/data/locationServicePlaces/en_US.json";
        readonly mvpSupport: false;
        readonly comparableTerms: readonly ["locationserviceplaces", "places"];
        readonly parentServiceCode: "locationService";
    };
    readonly proServeYear1Cost: {
        readonly name: "ProServe Year 1 Price";
        readonly serviceCode: "proServeYear1Cost";
        readonly description: "AWS Professional Services Year 1 Price";
        readonly searchKeywords: readonly ["ProServe", "professional", "services"];
        readonly type: "AWSService";
        readonly regions: readonly ["us-east-1", "us-gov-west-1"];
        readonly linkUrl: "https://aws.amazon.com/professional-services/";
        readonly isActive: "true";
        readonly hasDataTransfer: false;
        readonly subType: "subService";
        readonly disableConfigure: false;
        readonly serviceDefinitionLocation: "https://d1qsjq9pzbk1k6.cloudfront.net/data/proServeYear1Cost/en_US.json";
        readonly c2e: false;
        readonly templates: readonly [];
        readonly disableRegionSupport: true;
        readonly bulkImportEnabled: false;
        readonly serviceDefinitionUrlPath: "/data/proServeYear1Cost/en_US.json";
        readonly mvpSupport: false;
        readonly comparableTerms: readonly ["proserveyear1cost", "proserveyear1price"];
        readonly parentServiceCode: "awsProfessionalServices";
    };
    readonly proServeYear2Cost: {
        readonly name: "ProServe Year 2 Price";
        readonly serviceCode: "proServeYear2Cost";
        readonly description: "AWS Professional Services Year 2 Price";
        readonly searchKeywords: readonly ["ProServe", "professional", "services"];
        readonly type: "AWSService";
        readonly regions: readonly ["us-east-1", "us-gov-west-1"];
        readonly linkUrl: "https://aws.amazon.com/professional-services/";
        readonly isActive: "true";
        readonly hasDataTransfer: false;
        readonly subType: "subService";
        readonly disableConfigure: false;
        readonly serviceDefinitionLocation: "https://d1qsjq9pzbk1k6.cloudfront.net/data/proServeYear2Cost/en_US.json";
        readonly c2e: false;
        readonly templates: readonly [];
        readonly disableRegionSupport: true;
        readonly bulkImportEnabled: false;
        readonly serviceDefinitionUrlPath: "/data/proServeYear2Cost/en_US.json";
        readonly mvpSupport: false;
        readonly comparableTerms: readonly ["proserveyear2cost", "proserveyear2price"];
        readonly parentServiceCode: "awsProfessionalServices";
    };
    readonly proServeYear3Cost: {
        readonly name: "ProServe Year 3 Price";
        readonly serviceCode: "proServeYear3Cost";
        readonly description: "AWS Professional Services Year 3 Price";
        readonly searchKeywords: readonly ["ProServe", "professional", "services"];
        readonly type: "AWSService";
        readonly regions: readonly ["us-east-1", "us-gov-west-1"];
        readonly linkUrl: "https://aws.amazon.com/professional-services/";
        readonly isActive: "true";
        readonly hasDataTransfer: false;
        readonly subType: "subService";
        readonly disableConfigure: false;
        readonly serviceDefinitionLocation: "https://d1qsjq9pzbk1k6.cloudfront.net/data/proServeYear3Cost/en_US.json";
        readonly c2e: false;
        readonly templates: readonly [];
        readonly disableRegionSupport: true;
        readonly bulkImportEnabled: false;
        readonly serviceDefinitionUrlPath: "/data/proServeYear3Cost/en_US.json";
        readonly mvpSupport: false;
        readonly comparableTerms: readonly ["proserveyear3cost", "proserveyear3price"];
        readonly parentServiceCode: "awsProfessionalServices";
    };
    readonly proServeYear4Cost: {
        readonly name: "ProServe Year 4 Price";
        readonly serviceCode: "proServeYear4Cost";
        readonly description: "AWS Professional Services Year 4 Price";
        readonly searchKeywords: readonly ["ProServe", "professional", "services"];
        readonly type: "AWSService";
        readonly regions: readonly ["us-east-1", "us-gov-west-1"];
        readonly linkUrl: "https://aws.amazon.com/professional-services/";
        readonly isActive: "true";
        readonly hasDataTransfer: false;
        readonly subType: "subService";
        readonly disableConfigure: false;
        readonly serviceDefinitionLocation: "https://d1qsjq9pzbk1k6.cloudfront.net/data/proServeYear4Cost/en_US.json";
        readonly c2e: false;
        readonly templates: readonly [];
        readonly disableRegionSupport: true;
        readonly bulkImportEnabled: false;
        readonly serviceDefinitionUrlPath: "/data/proServeYear4Cost/en_US.json";
        readonly mvpSupport: false;
        readonly comparableTerms: readonly ["proserveyear4cost", "proserveyear4price"];
        readonly parentServiceCode: "awsProfessionalServices";
    };
    readonly proServeYear5Cost: {
        readonly name: "ProServe Year 5 Price";
        readonly serviceCode: "proServeYear5Cost";
        readonly description: "AWS Professional Services Year 5 Price";
        readonly searchKeywords: readonly ["ProServe", "professional", "services"];
        readonly type: "AWSService";
        readonly regions: readonly ["us-east-1", "us-gov-west-1"];
        readonly linkUrl: "https://aws.amazon.com/professional-services/";
        readonly isActive: "true";
        readonly hasDataTransfer: false;
        readonly subType: "subService";
        readonly disableConfigure: false;
        readonly serviceDefinitionLocation: "https://d1qsjq9pzbk1k6.cloudfront.net/data/proServeYear5Cost/en_US.json";
        readonly c2e: false;
        readonly templates: readonly [];
        readonly disableRegionSupport: true;
        readonly bulkImportEnabled: false;
        readonly serviceDefinitionUrlPath: "/data/proServeYear5Cost/en_US.json";
        readonly mvpSupport: false;
        readonly comparableTerms: readonly ["proserveyear5cost", "proserveyear5price"];
        readonly parentServiceCode: "awsProfessionalServices";
    };
    readonly proxyPhoneSession: {
        readonly name: "Proxy Phone Session";
        readonly serviceCode: "proxyPhoneSession";
        readonly description: "Amazon Chime lets you meet, chat, and collaborate with the security of AWS. You can work seamlessly on your devices, and meet from your desk or on the go - ensuring you always stay connected.";
        readonly searchKeywords: readonly [];
        readonly type: "AWSService";
        readonly regions: readonly ["us-east-1", "us-west-2"];
        readonly linkUrl: "https://aws.amazon.com/chime/chime-sdk";
        readonly isActive: "true";
        readonly subType: "subService";
        readonly disableConfigure: false;
        readonly serviceDefinitionLocation: "https://d1qsjq9pzbk1k6.cloudfront.net/data/proxyPhoneSession/en_US.json";
        readonly c2e: false;
        readonly templates: readonly [];
        readonly disableRegionSupport: false;
        readonly serviceDefinitionUrlPath: "/data/proxyPhoneSession/en_US.json";
        readonly mvpSupport: false;
        readonly comparableTerms: readonly ["proxyphonesession"];
        readonly parentServiceCode: "amazonChimeSdk";
    };
    readonly ptsnAudio: {
        readonly name: "PSTN Audio";
        readonly serviceCode: "ptsnAudio";
        readonly description: "Amazon Chime lets you meet, chat, and collaborate with the security of AWS. You can work seamlessly on your devices, and meet from your desk or on the go - ensuring you always stay connected.";
        readonly searchKeywords: readonly [];
        readonly type: "AWSService";
        readonly regions: readonly ["us-east-1", "us-west-2"];
        readonly linkUrl: "https://aws.amazon.com/chime/chime-sdk";
        readonly isActive: "true";
        readonly subType: "subService";
        readonly disableConfigure: false;
        readonly serviceDefinitionLocation: "https://d1qsjq9pzbk1k6.cloudfront.net/data/ptsnAudio/en_US.json";
        readonly c2e: false;
        readonly templates: readonly [];
        readonly disableRegionSupport: false;
        readonly bulkImportEnabled: false;
        readonly serviceDefinitionUrlPath: "/data/ptsnAudio/en_US.json";
        readonly mvpSupport: false;
        readonly comparableTerms: readonly ["pstnaudio", "ptsnaudio"];
        readonly parentServiceCode: "amazonChimeSdk";
    };
    readonly reachabilityAnalyzerVpc: {
        readonly name: "Reachability Analyzer";
        readonly serviceCode: "reachabilityAnalyzerVpc";
        readonly description: "WS Virtual Private Network solutions establish secure connections between your on-premises networks, remote offices, client devices, and the AWS global network. AWS VPN is comprised of two services: AWS Site-to-Site VPN and AWS Client VPN. Each service provides a highly-available, managed, and elastic cloud VPN solution to protect your network traffic.";
        readonly searchKeywords: readonly ["access control", "ACL", "AWS Privatelink", "Cloud connectivity", "corporate network", "elastic IP", "Gateway load balancer", "home network VPN", "IPAM", "NAT", "NAT gateway", "Network Access Analyzer", "Network Address Translation", "Networking Content Delivery", "PrivateLink", "Reachability Analyzer", "security", "single tenant hardware", "static ip", "subnets", "Traffic mirroring", "Transit Gateway", "Virtual Private Cloud", "VPN"];
        readonly type: "AWSService";
        readonly regions: readonly ["af-south-1", "ap-east-1", "ap-northeast-1", "ap-northeast-2", "ap-south-1", "ap-southeast-1", "ap-southeast-2", "ca-central-1", "eu-central-1", "eu-north-1", "eu-south-1", "eu-west-1", "eu-west-2", "eu-west-3", "me-south-1", "sa-east-1", "us-east-1", "us-east-2", "us-west-1", "us-west-2"];
        readonly isActive: "true";
        readonly subType: "subService";
        readonly disableConfigure: false;
        readonly serviceDefinitionLocation: "https://d1qsjq9pzbk1k6.cloudfront.net/data/reachabilityAnalyzerVpc/en_US.json";
        readonly c2e: false;
        readonly templates: readonly [];
        readonly disableRegionSupport: false;
        readonly serviceDefinitionUrlPath: "/data/reachabilityAnalyzerVpc/en_US.json";
        readonly mvpSupport: false;
        readonly comparableTerms: readonly ["reachabilityanalyzer", "reachabilityanalyzervpc"];
        readonly parentServiceCode: "amazonVirtualPrivateCloud";
    };
    readonly rekognitionCustomLabels: {
        readonly name: "Rekognition Custom Labels";
        readonly serviceCode: "rekognitionCustomLabels";
        readonly searchKeywords: readonly [];
        readonly type: "AWSService";
        readonly regions: readonly ["ap-northeast-2", "ap-southeast-1", "ap-southeast-2", "ap-northeast-1", "eu-west-1", "us-east-1", "us-east-2", "us-west-2"];
        readonly isActive: "true";
        readonly subType: "subService";
        readonly disableConfigure: false;
        readonly serviceDefinitionLocation: "https://d1qsjq9pzbk1k6.cloudfront.net/data/rekognitionCustomLabels/en_US.json";
        readonly c2e: false;
        readonly templates: readonly [];
        readonly disableRegionSupport: false;
        readonly serviceDefinitionUrlPath: "/data/rekognitionCustomLabels/en_US.json";
        readonly mvpSupport: false;
        readonly comparableTerms: readonly ["rekognitioncustomlabels"];
        readonly parentServiceCode: "amazonRekognition";
    };
    readonly rekognitionImage: {
        readonly name: "Rekognition Image";
        readonly serviceCode: "rekognitionImage";
        readonly searchKeywords: readonly [];
        readonly type: "AWSService";
        readonly regions: readonly ["us-gov-west-1", "ap-south-1", "ap-northeast-2", "ap-southeast-1", "ap-southeast-2", "ap-northeast-1", "eu-central-1", "eu-west-1", "eu-west-2", "us-east-1", "us-east-2", "us-west-1", "us-west-2"];
        readonly isActive: "true";
        readonly subType: "subService";
        readonly disableConfigure: false;
        readonly serviceDefinitionLocation: "https://d1qsjq9pzbk1k6.cloudfront.net/data/rekognitionImage/en_US.json";
        readonly c2e: false;
        readonly templates: readonly [];
        readonly disableRegionSupport: false;
        readonly serviceDefinitionUrlPath: "/data/rekognitionImage/en_US.json";
        readonly mvpSupport: false;
        readonly comparableTerms: readonly ["rekognitionimage"];
        readonly parentServiceCode: "amazonRekognition";
    };
    readonly rekognitionVideo: {
        readonly name: "Rekognition Stored Video";
        readonly serviceCode: "rekognitionVideo";
        readonly searchKeywords: readonly [];
        readonly type: "AWSService";
        readonly regions: readonly ["us-gov-west-1", "ap-south-1", "ap-northeast-2", "ap-southeast-1", "ap-southeast-2", "ap-northeast-1", "eu-central-1", "eu-west-1", "eu-west-2", "us-east-1", "us-east-2", "us-west-1", "us-west-2"];
        readonly isActive: "true";
        readonly subType: "subService";
        readonly disableConfigure: false;
        readonly serviceDefinitionLocation: "https://d1qsjq9pzbk1k6.cloudfront.net/data/rekognitionVideo/en_US.json";
        readonly c2e: false;
        readonly templates: readonly [];
        readonly disableRegionSupport: false;
        readonly serviceDefinitionUrlPath: "/data/rekognitionVideo/en_US.json";
        readonly mvpSupport: false;
        readonly comparableTerms: readonly ["rekognitionstoredvideo", "rekognitionvideo"];
        readonly parentServiceCode: "amazonRekognition";
    };
    readonly rekognitionStreamingVideoEvents: {
        readonly name: "Rekognition Streaming Video Events";
        readonly serviceCode: "rekognitionStreamingVideoEvents";
        readonly searchKeywords: readonly [];
        readonly type: "AWSService";
        readonly regions: readonly ["ap-south-1", "ap-northeast-1", "eu-central-1", "eu-west-1", "us-east-1", "us-east-2", "us-west-2"];
        readonly isActive: "true";
        readonly subType: "subService";
        readonly disableConfigure: false;
        readonly serviceDefinitionLocation: "https://d1qsjq9pzbk1k6.cloudfront.net/data/rekognitionStreamingVideoEvents/en_US.json";
        readonly c2e: false;
        readonly templates: readonly [];
        readonly disableRegionSupport: false;
        readonly serviceDefinitionUrlPath: "/data/rekognitionStreamingVideoEvents/en_US.json";
        readonly mvpSupport: false;
        readonly comparableTerms: readonly ["rekognitionstreamingvideoevents"];
        readonly parentServiceCode: "amazonRekognition";
    };
    readonly locationServiceRouting: {
        readonly name: "Routing";
        readonly serviceCode: "locationServiceRouting";
        readonly description: "Amazon Location Service provides affordable data, tracking and geofencing capabilities, and native integrations with AWS services, so you can create sophisticated location-enabled applications quickly, without the high cost of custom development.";
        readonly searchKeywords: readonly ["Location Service", "compromising data security", "user privacy", "asset tracking", "location-based marketing", "maps", "places", "routing", "tracking", "geofencing", "Service Resources"];
        readonly type: "AWSService";
        readonly regions: readonly ["ap-southeast-1", "ap-southeast-2", "ap-northeast-1", "eu-central-1", "eu-west-1", "eu-north-1", "us-east-1", "us-east-2", "us-west-2"];
        readonly linkUrl: "https://aws.amazon.com/location/";
        readonly isActive: "true";
        readonly subType: "subService";
        readonly disableConfigure: false;
        readonly serviceDefinitionLocation: "https://d1qsjq9pzbk1k6.cloudfront.net/data/locationServiceRouting/en_US.json";
        readonly c2e: false;
        readonly templates: readonly [];
        readonly disableRegionSupport: false;
        readonly serviceDefinitionUrlPath: "/data/locationServiceRouting/en_US.json";
        readonly mvpSupport: false;
        readonly comparableTerms: readonly ["locationservicerouting", "routing"];
        readonly parentServiceCode: "locationService";
    };
    readonly sageMakerRStudioOnSageMaker: {
        readonly name: "RStudio on SageMaker";
        readonly serviceCode: "sageMakerRStudioOnSageMaker";
        readonly description: "With Amazon SageMaker, you pay only for what you use. Building, training, and deploying ML models is billed by the second, with no minimum fees and no upfront commitments.";
        readonly searchKeywords: readonly ["Sagemaker", "Model", "ML", "Machine Learning", "EI", "data scientist"];
        readonly type: "AWSService";
        readonly regions: readonly ["ap-south-1", "ap-northeast-2", "ap-southeast-1", "ap-southeast-2", "ap-northeast-1", "ca-central-1", "eu-central-1", "eu-west-1", "eu-west-2", "eu-west-3", "eu-north-1", "sa-east-1", "us-east-1", "us-east-2", "us-west-1", "us-west-2"];
        readonly linkUrl: "https://aws.amazon.com/sagemaker/";
        readonly isActive: "true";
        readonly subType: "subService";
        readonly disableConfigure: false;
        readonly serviceDefinitionLocation: "https://d1qsjq9pzbk1k6.cloudfront.net/data/sageMakerRStudioOnSageMaker/en_US.json";
        readonly c2e: false;
        readonly templates: readonly [];
        readonly disableRegionSupport: false;
        readonly serviceDefinitionUrlPath: "/data/sageMakerRStudioOnSageMaker/en_US.json";
        readonly mvpSupport: false;
        readonly comparableTerms: readonly ["rstudiosagemaker", "sagemakerrstudioonsagemaker"];
        readonly parentServiceCode: "amazonSageMaker";
    };
    readonly amazonS3GlacierDeepArhive: {
        readonly name: "S3 Glacier Deep Archive";
        readonly serviceCode: "amazonS3GlacierDeepArhive";
        readonly description: "Amazon Simple Storage Service (Amazon S3) is storage for the internet. You can use Amazon S3 to store and retrieve any amount of data at any time, from anywhere on the web.";
        readonly searchKeywords: readonly ["Storage", "Simple Storage Service", "bucket", "file storage", "cloud storage", "static website hosting", "object storage", "store objects", "store files", "data migration", "ongoing data ingestion", "backup and recovery", "big data analytics", "nearline archive", "disaster recovery", "content distribution", "cloud storage"];
        readonly type: "AWSService";
        readonly regions: readonly ["af-south-1", "ap-east-1", "ap-south-1", "ap-northeast-3", "ap-northeast-2", "ap-southeast-1", "ap-southeast-2", "ap-southeast-3", "ap-northeast-1", "us-gov-west-1", "us-gov-east-1", "ca-central-1", "eu-central-1", "eu-west-1", "eu-west-2", "eu-west-3", "eu-north-1", "eu-south-1", "me-south-1", "me-central-1", "sa-east-1", "us-east-1", "us-east-2", "us-west-1", "us-west-2"];
        readonly linkUrl: "https://aws.amazon.com/s3/";
        readonly isActive: "true";
        readonly subType: "subService";
        readonly disableConfigure: false;
        readonly serviceDefinitionLocation: "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonS3GlacierDeepArhive/en_US.json";
        readonly c2e: false;
        readonly templates: readonly [];
        readonly disableRegionSupport: false;
        readonly mvpSupport: false;
        readonly comparableTerms: readonly ["s3glacierdeeparchive", "s3glacierdeeparhive"];
        readonly parentServiceCode: "amazonSimpleStorageServiceGroup";
    };
    readonly amazonS3Glacier: {
        readonly name: "S3 Glacier Flexible Retrieval";
        readonly serviceCode: "amazonS3Glacier";
        readonly description: "Amazon Simple Storage Service (Amazon S3) is storage for the internet. You can use Amazon S3 to store and retrieve any amount of data at any time, from anywhere on the web.";
        readonly searchKeywords: readonly ["Storage", "Simple Storage Service", "bucket", "file storage", "cloud storage", "static website hosting", "object storage", "store objects", "store files", "data migration", "ongoing data ingestion", "backup and recovery", "big data analytics", "nearline archive", "disaster recovery", "content distribution", "cloud storage"];
        readonly type: "AWSService";
        readonly regions: readonly ["af-south-1", "ap-east-1", "ap-south-1", "ap-northeast-3", "ap-northeast-2", "ap-southeast-1", "ap-southeast-2", "ap-southeast-3", "ap-northeast-1", "us-gov-west-1", "us-gov-east-1", "ca-central-1", "eu-central-1", "eu-west-1", "eu-west-2", "eu-west-3", "eu-north-1", "eu-south-1", "me-south-1", "me-central-1", "sa-east-1", "us-east-1", "us-east-2", "us-west-1", "us-west-2"];
        readonly linkUrl: "https://aws.amazon.com/s3";
        readonly isActive: "true";
        readonly subType: "TCOCalculator";
        readonly disableConfigure: false;
        readonly serviceDefinitionLocation: "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonS3Glacier/en_US.json";
        readonly c2e: false;
        readonly templates: readonly [];
        readonly disableRegionSupport: false;
        readonly bulkImportEnabled: false;
        readonly serviceDefinitionUrlPath: "/data/amazonS3Glacier/en_US.json";
        readonly mvpSupport: false;
        readonly comparableTerms: readonly ["s3", "s3glacier", "s3glacierflexibleretrieval"];
        readonly parentServiceCode: "amazonSimpleStorageServiceGroup";
    };
    readonly s3GlacierInstantRetrieval: {
        readonly name: "S3 Glacier Instant Retrieval";
        readonly serviceCode: "s3GlacierInstantRetrieval";
        readonly description: "Amazon Simple Storage Service (Amazon S3) is storage for the internet. You can use Amazon S3 to store and retrieve any amount of data at any time, from anywhere on the web.";
        readonly searchKeywords: readonly ["Storage", "Simple Storage Service", "bucket", "file storage", "cloud storage", "static website hosting", "object storage", "store objects", "store files", "data migration", "ongoing data ingestion", "backup and recovery", "big data analytics", "nearline archive", "disaster recovery", "content distribution", "cloud storage"];
        readonly type: "AWSService";
        readonly regions: readonly ["af-south-1", "ap-east-1", "ap-south-1", "ap-northeast-3", "ap-northeast-2", "ap-southeast-1", "ap-southeast-2", "ap-southeast-3", "ap-northeast-1", "us-gov-west-1", "us-gov-east-1", "ca-central-1", "eu-central-1", "eu-west-1", "eu-west-2", "eu-west-3", "eu-north-1", "eu-south-1", "me-south-1", "me-central-1", "sa-east-1", "us-east-1", "us-east-2", "us-west-1", "us-west-2"];
        readonly linkUrl: "https://aws.amazon.com/s3/";
        readonly isActive: "true";
        readonly subType: "subService";
        readonly disableConfigure: false;
        readonly serviceDefinitionLocation: "https://d1qsjq9pzbk1k6.cloudfront.net/data/s3GlacierInstantRetrieval/en_US.json";
        readonly c2e: false;
        readonly templates: readonly [];
        readonly disableRegionSupport: false;
        readonly bulkImportEnabled: false;
        readonly serviceDefinitionUrlPath: "/data/s3GlacierInstantRetrieval/en_US.json";
        readonly mvpSupport: false;
        readonly comparableTerms: readonly ["s3glacierinstantretrieval"];
        readonly parentServiceCode: "amazonSimpleStorageServiceGroup";
    };
    readonly amazonS3IntelligentTiering: {
        readonly name: "S3 Intelligent - Tiering";
        readonly serviceCode: "amazonS3IntelligentTiering";
        readonly description: "Amazon Simple Storage Service (Amazon S3) is storage for the internet. You can use Amazon S3 to store and retrieve any amount of data at any time, from anywhere on the web.";
        readonly searchKeywords: readonly ["Storage", "Simple Storage Service", "bucket", "file storage", "cloud storage", "static website hosting", "object storage", "store objects", "store files", "data migration", "ongoing data ingestion", "backup and recovery", "big data analytics", "nearline archive", "disaster recovery", "content distribution", "cloud storage"];
        readonly type: "AWSService";
        readonly regions: readonly ["af-south-1", "ap-east-1", "ap-south-1", "ap-northeast-3", "ap-northeast-2", "ap-southeast-1", "ap-southeast-2", "ap-southeast-3", "ap-northeast-1", "us-gov-west-1", "us-gov-east-1", "ca-central-1", "eu-central-1", "eu-west-1", "eu-west-2", "eu-west-3", "eu-north-1", "eu-south-1", "me-south-1", "me-central-1", "sa-east-1", "us-east-1", "us-east-2", "us-west-1", "us-west-2"];
        readonly linkUrl: "https://aws.amazon.com/s3/";
        readonly isActive: "true";
        readonly subType: "subService";
        readonly disableConfigure: false;
        readonly serviceDefinitionLocation: "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonS3IntelligentTiering/en_US.json";
        readonly c2e: false;
        readonly templates: readonly [];
        readonly disableRegionSupport: false;
        readonly bulkImportEnabled: false;
        readonly serviceDefinitionUrlPath: "/data/amazonS3IntelligentTiering/en_US.json";
        readonly mvpSupport: false;
        readonly comparableTerms: readonly ["s3intelligenttiering"];
        readonly parentServiceCode: "amazonSimpleStorageServiceGroup";
    };
    readonly amazonS3StorageManagement: {
        readonly name: "S3 Management and Analytics";
        readonly serviceCode: "amazonS3StorageManagement";
        readonly description: "S3 Storage Management and Analytics is priced per feature (Amazon S3 Inventory, S3 Storage Class Analysis, S3 Storage Lens, and S3 Object Tagging) that is enabled on your account’s bucket.";
        readonly searchKeywords: readonly ["Storage", "Simple Storage Service", "bucket", "file storage", "cloud storage", "static website hosting", "object storage", "store objects", "store files", "data migration", "ongoing data ingestion", "backup and recovery", "big data analytics", "nearline archive", "disaster recovery", "content distribution", "cloud storage"];
        readonly type: "AWSService";
        readonly regions: readonly ["af-south-1", "ap-east-1", "ap-south-1", "ap-northeast-3", "ap-northeast-2", "ap-southeast-1", "ap-southeast-2", "ap-southeast-3", "ap-northeast-1", "us-gov-west-1", "us-gov-east-1", "ca-central-1", "eu-central-1", "eu-west-1", "eu-west-2", "eu-west-3", "eu-north-1", "eu-south-1", "me-south-1", "me-central-1", "sa-east-1", "us-east-1", "us-east-2", "us-west-1", "us-west-2"];
        readonly linkUrl: "https://aws.amazon.com/s3/";
        readonly isActive: "true";
        readonly subType: "subService";
        readonly disableConfigure: false;
        readonly serviceDefinitionLocation: "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonS3StorageManagement/en_US.json";
        readonly c2e: false;
        readonly templates: readonly [];
        readonly disableRegionSupport: false;
        readonly mvpSupport: false;
        readonly comparableTerms: readonly ["s3managementanalytics", "s3storagemanagement"];
        readonly parentServiceCode: "amazonSimpleStorageServiceGroup";
    };
    readonly s3ObjectLambda: {
        readonly name: "S3 Object Lambda";
        readonly serviceCode: "s3ObjectLambda";
        readonly description: "Amazon Simple Storage Service (Amazon S3) is storage for the internet. You can use Amazon S3 to store and retrieve any amount of data at any time, from anywhere on the web.";
        readonly searchKeywords: readonly ["Storage", "Simple Storage Service", "bucket", "file storage", "cloud storage", "static website hosting", "object storage", "store objects", "store files", "data migration", "ongoing data ingestion", "backup and recovery", "big data analytics", "nearline archive", "disaster recovery", "content distribution", "cloud storage", "S3", "s3"];
        readonly type: "AWSService";
        readonly regions: readonly ["af-south-1", "ap-east-1", "ap-south-1", "ap-northeast-2", "ap-southeast-1", "ap-southeast-2", "ap-southeast-3", "ap-northeast-1", "us-gov-west-1", "us-gov-east-1", "ca-central-1", "eu-central-1", "eu-west-1", "eu-west-2", "eu-west-3", "eu-north-1", "eu-south-1", "me-south-1", "me-central-1", "sa-east-1", "us-east-1", "us-east-2", "us-west-1", "us-west-2"];
        readonly linkUrl: "https://aws.amazon.com/s3";
        readonly isActive: "true";
        readonly subType: "subService";
        readonly disableConfigure: false;
        readonly serviceDefinitionLocation: "https://d1qsjq9pzbk1k6.cloudfront.net/data/s3ObjectLambda/en_US.json";
        readonly c2e: false;
        readonly templates: readonly [];
        readonly disableRegionSupport: false;
        readonly mvpSupport: false;
        readonly comparableTerms: readonly ["s3objectlambda"];
        readonly parentServiceCode: "amazonSimpleStorageServiceGroup";
    };
    readonly s3OneZoneInfrequentAccess: {
        readonly name: "S3 One Zone - Infrequent Access";
        readonly serviceCode: "s3OneZoneInfrequentAccess";
        readonly description: "Amazon Simple Storage Service (Amazon S3) is storage for the internet. You can use Amazon S3 to store and retrieve any amount of data at any time, from anywhere on the web.";
        readonly searchKeywords: readonly ["Storage", "Simple Storage Service", "bucket", "file storage", "cloud storage", "static website hosting", "object storage", "store objects", "store files", "data migration", "ongoing data ingestion", "backup and recovery", "big data analytics", "nearline archive", "disaster recovery", "content distribution", "cloud storage"];
        readonly type: "AWSService";
        readonly regions: readonly ["af-south-1", "ap-east-1", "ap-south-1", "ap-northeast-3", "ap-northeast-2", "ap-southeast-1", "ap-southeast-2", "ap-southeast-3", "ap-northeast-1", "us-gov-west-1", "us-gov-east-1", "ca-central-1", "eu-central-1", "eu-west-1", "eu-west-2", "eu-west-3", "eu-north-1", "eu-south-1", "me-south-1", "me-central-1", "sa-east-1", "us-east-1", "us-east-2", "us-west-1", "us-west-2"];
        readonly linkUrl: "https://aws.amazon.com/s3/";
        readonly isActive: "true";
        readonly subType: "subService";
        readonly disableConfigure: false;
        readonly serviceDefinitionLocation: "https://d1qsjq9pzbk1k6.cloudfront.net/data/s3OneZoneInfrequentAccess/en_US.json";
        readonly c2e: false;
        readonly templates: readonly [];
        readonly disableRegionSupport: false;
        readonly bulkImportEnabled: false;
        readonly serviceDefinitionUrlPath: "/data/s3OneZoneInfrequentAccess/en_US.json";
        readonly mvpSupport: false;
        readonly comparableTerms: readonly ["s3onezoneinfrequentaccess"];
        readonly parentServiceCode: "amazonSimpleStorageServiceGroup";
    };
    readonly amazonS3Standard: {
        readonly name: "S3 Standard";
        readonly serviceCode: "amazonS3Standard";
        readonly description: "Amazon Simple Storage Service (Amazon S3) is storage for the internet. You can use Amazon S3 to store and retrieve any amount of data at any time, from anywhere on the web.";
        readonly searchKeywords: readonly ["Storage", "Simple Storage Service", "bucket", "file storage", "cloud storage", "static website hosting", "object storage", "store objects", "store files", "data migration", "ongoing data ingestion", "backup and recovery", "big data analytics", "nearline archive", "disaster recovery", "content distribution", "cloud storage", "S3", "s3"];
        readonly type: "AWSService";
        readonly regions: readonly ["af-south-1", "ap-east-1", "ap-south-1", "ap-northeast-3", "ap-northeast-2", "ap-southeast-1", "ap-southeast-2", "ap-southeast-3", "ap-northeast-1", "us-gov-west-1", "us-gov-east-1", "ca-central-1", "eu-central-1", "eu-west-1", "eu-west-2", "eu-west-3", "eu-north-1", "eu-south-1", "me-south-1", "me-central-1", "sa-east-1", "us-east-1", "us-east-2", "us-west-1", "us-west-2"];
        readonly linkUrl: "https://aws.amazon.com/s3";
        readonly isActive: "true";
        readonly subType: "subService";
        readonly disableConfigure: false;
        readonly serviceDefinitionLocation: "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonS3Standard/en_US.json";
        readonly c2e: false;
        readonly templates: readonly [];
        readonly disableRegionSupport: false;
        readonly bulkImportEnabled: false;
        readonly serviceDefinitionUrlPath: "/data/amazonS3Standard/en_US.json";
        readonly mvpSupport: false;
        readonly comparableTerms: readonly ["s3standard"];
        readonly parentServiceCode: "amazonSimpleStorageServiceGroup";
    };
    readonly amazonS3StandardInfrequentAccess: {
        readonly name: "S3 Standard - Infrequent Access";
        readonly serviceCode: "amazonS3StandardInfrequentAccess";
        readonly description: "Amazon Simple Storage Service (Amazon S3) is storage for the internet. You can use Amazon S3 to store and retrieve any amount of data at any time, from anywhere on the web.";
        readonly searchKeywords: readonly ["Storage", "Simple Storage Service", "bucket", "file storage", "cloud storage", "static website hosting", "object storage", "store objects", "store files", "data migration", "ongoing data ingestion", "backup and recovery", "big data analytics", "nearline archive", "disaster recovery", "content distribution", "cloud storage"];
        readonly type: "AWSService";
        readonly regions: readonly ["af-south-1", "ap-east-1", "ap-south-1", "ap-northeast-3", "ap-northeast-2", "ap-southeast-1", "ap-southeast-2", "ap-southeast-3", "ap-northeast-1", "us-gov-west-1", "us-gov-east-1", "ca-central-1", "eu-central-1", "eu-west-1", "eu-west-2", "eu-west-3", "eu-north-1", "eu-south-1", "me-south-1", "me-central-1", "sa-east-1", "us-east-1", "us-east-2", "us-west-1", "us-west-2"];
        readonly linkUrl: "https://aws.amazon.com/s3/";
        readonly isActive: "true";
        readonly subType: "subService";
        readonly disableConfigure: false;
        readonly serviceDefinitionLocation: "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonS3StandardInfrequentAccess/en_US.json";
        readonly c2e: false;
        readonly templates: readonly [];
        readonly disableRegionSupport: false;
        readonly bulkImportEnabled: false;
        readonly serviceDefinitionUrlPath: "/data/amazonS3StandardInfrequentAccess/en_US.json";
        readonly mvpSupport: false;
        readonly comparableTerms: readonly ["s3standardinfrequentaccess"];
        readonly parentServiceCode: "amazonSimpleStorageServiceGroup";
    };
    readonly sageMakerAsynchronousInference: {
        readonly name: "SageMaker Asynchronous Inference";
        readonly serviceCode: "sageMakerAsynchronousInference";
        readonly description: "With Amazon SageMaker, you pay only for what you use. Building, training, and deploying ML models is billed by the second, with no minimum fees and no upfront commitments.";
        readonly searchKeywords: readonly ["Sagemaker", "Model", "ML", "Machine Learning", "EI", "data scientist"];
        readonly type: "AWSService";
        readonly regions: readonly ["ap-east-1", "ap-south-1", "ap-northeast-2", "ap-southeast-1", "ap-southeast-2", "ap-northeast-1", "ca-central-1", "eu-central-1", "eu-west-1", "eu-west-2", "eu-north-1", "me-south-1", "sa-east-1", "us-east-1", "us-east-2", "us-west-1", "us-west-2"];
        readonly linkUrl: "https://aws.amazon.com/sagemaker/";
        readonly isActive: "true";
        readonly subType: "subService";
        readonly disableConfigure: false;
        readonly serviceDefinitionLocation: "https://d1qsjq9pzbk1k6.cloudfront.net/data/sageMakerAsynchronousInference/en_US.json";
        readonly c2e: false;
        readonly templates: readonly [];
        readonly disableRegionSupport: false;
        readonly serviceDefinitionUrlPath: "/data/sageMakerAsynchronousInference/en_US.json";
        readonly mvpSupport: false;
        readonly comparableTerms: readonly ["sagemakerasynchronousinference"];
        readonly parentServiceCode: "amazonSageMaker";
    };
    readonly sageMakerBatchTransform: {
        readonly name: "SageMaker Batch Transform";
        readonly serviceCode: "sageMakerBatchTransform";
        readonly description: "With Amazon SageMaker, you pay only for what you use. Building, training, and deploying ML models is billed by the second, with no minimum fees and no upfront commitments.";
        readonly searchKeywords: readonly ["Sagemaker", "Model", "ML", "Machine Learning", "EI", "data scientist"];
        readonly type: "AWSService";
        readonly regions: readonly ["us-east-1", "eu-west-1", "us-west-1", "ap-southeast-1", "ap-northeast-1", "us-gov-west-1", "us-west-2", "sa-east-1", "ap-southeast-2", "eu-central-1", "ap-northeast-2", "ap-northeast-3", "ap-south-1", "us-east-2", "ca-central-1", "eu-west-2", "eu-west-3", "eu-north-1", "ap-east-1", "me-south-1", "eu-south-1", "af-south-1"];
        readonly linkUrl: "https://aws.amazon.com/sagemaker/";
        readonly isActive: "true";
        readonly subType: "subService";
        readonly disableConfigure: false;
        readonly serviceDefinitionLocation: "https://d1qsjq9pzbk1k6.cloudfront.net/data/sageMakerBatchTransform/en_US.json";
        readonly c2e: false;
        readonly templates: readonly [];
        readonly disableRegionSupport: false;
        readonly serviceDefinitionUrlPath: "/data/sageMakerBatchTransform/en_US.json";
        readonly mvpSupport: false;
        readonly comparableTerms: readonly ["sagemakerbatchtransform"];
        readonly parentServiceCode: "amazonSageMaker";
    };
    readonly sageMakerDataWrangler: {
        readonly name: "SageMaker Data Wrangler";
        readonly serviceCode: "sageMakerDataWrangler";
        readonly description: "With Amazon SageMaker, you pay only for what you use. Building, training, and deploying ML models is billed by the second, with no minimum fees and no upfront commitments.";
        readonly searchKeywords: readonly ["Sagemaker", "Model", "ML", "Machine Learning", "EI", "data scientist"];
        readonly type: "AWSService";
        readonly regions: readonly ["af-south-1", "ap-east-1", "ap-south-1", "ap-northeast-2", "ap-southeast-1", "ap-southeast-2", "ap-northeast-1", "ca-central-1", "eu-central-1", "eu-west-1", "eu-west-2", "eu-south-1", "eu-west-3", "eu-north-1", "me-south-1", "sa-east-1", "us-east-1", "us-east-2", "us-west-1", "us-west-2"];
        readonly linkUrl: "https://aws.amazon.com/sagemaker/";
        readonly isActive: "true";
        readonly subType: "subService";
        readonly disableConfigure: false;
        readonly serviceDefinitionLocation: "https://d1qsjq9pzbk1k6.cloudfront.net/data/sageMakerDataWrangler/en_US.json";
        readonly c2e: false;
        readonly templates: readonly [];
        readonly disableRegionSupport: false;
        readonly serviceDefinitionUrlPath: "/data/sageMakerDataWrangler/en_US.json";
        readonly mvpSupport: false;
        readonly comparableTerms: readonly ["sagemakerdatawrangler"];
        readonly parentServiceCode: "amazonSageMaker";
    };
    readonly amazonSageMakerEdgeManager: {
        readonly name: "SageMaker Edge Manager";
        readonly serviceCode: "amazonSageMakerEdgeManager";
        readonly description: "Amazon SageMaker Edge Manager makes it easy for ML developers to optimize, secure, monitor, and maintain ML models on fleets of edge devices.";
        readonly searchKeywords: readonly ["Sagemaker", "Model", "ML", "Machine Learning", "EI", "data scientist", "Edge Manager"];
        readonly type: "AWSService";
        readonly regions: readonly ["ap-northeast-1", "eu-central-1", "eu-west-1", "us-east-1", "us-east-2", "us-west-2"];
        readonly linkUrl: "https://aws.amazon.com/sagemaker/edge-manager/pricing/";
        readonly isActive: "true";
        readonly subType: "subService";
        readonly disableConfigure: false;
        readonly serviceDefinitionLocation: "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonSageMakerEdgeManager/en_US.json";
        readonly c2e: false;
        readonly templates: readonly [];
        readonly disableRegionSupport: false;
        readonly serviceDefinitionUrlPath: "/data/amazonSageMakerEdgeManager/en_US.json";
        readonly mvpSupport: false;
        readonly comparableTerms: readonly ["sagemakeredgemanager"];
        readonly parentServiceCode: "amazonSageMaker";
    };
    readonly sageMakerFeatureStore: {
        readonly name: "SageMaker Feature Store";
        readonly serviceCode: "sageMakerFeatureStore";
        readonly description: "With Amazon SageMaker, you pay only for what you use. Building, training, and deploying ML models is billed by the second, with no minimum fees and no upfront commitments.";
        readonly searchKeywords: readonly ["Sagemaker", "Model", "ML", "Machine Learning", "EI", "data scientist"];
        readonly type: "AWSService";
        readonly regions: readonly ["us-east-1", "eu-west-1", "us-west-1", "ap-southeast-1", "ap-northeast-1", "us-west-2", "sa-east-1", "ap-southeast-2", "eu-central-1", "ap-northeast-2", "ap-south-1", "us-east-2", "ca-central-1", "eu-west-2", "eu-west-3", "eu-north-1", "ap-east-1", "me-south-1", "eu-south-1", "af-south-1"];
        readonly linkUrl: "https://aws.amazon.com/sagemaker/";
        readonly isActive: "true";
        readonly hasDataTransfer: true;
        readonly subType: "subService";
        readonly disableConfigure: false;
        readonly serviceDefinitionLocation: "https://d1qsjq9pzbk1k6.cloudfront.net/data/sageMakerFeatureStore/en_US.json";
        readonly c2e: false;
        readonly templates: readonly [];
        readonly disableRegionSupport: false;
        readonly serviceDefinitionUrlPath: "/data/sageMakerFeatureStore/en_US.json";
        readonly mvpSupport: false;
        readonly comparableTerms: readonly ["sagemakerfeaturestore"];
        readonly parentServiceCode: "amazonSageMaker";
    };
    readonly sageMakerOnDemandNotebookInstances: {
        readonly name: "SageMaker On-Demand Notebook Instances";
        readonly serviceCode: "sageMakerOnDemandNotebookInstances";
        readonly description: "With Amazon SageMaker, you pay only for what you use. Building, training, and deploying ML models is billed by the second, with no minimum fees and no upfront commitments.";
        readonly searchKeywords: readonly ["Sagemaker", "Model", "ML", "Machine Learning", "EI", "data scientist"];
        readonly type: "AWSService";
        readonly regions: readonly ["us-east-1", "eu-west-1", "us-west-1", "ap-southeast-1", "ap-northeast-1", "us-gov-west-1", "us-west-2", "sa-east-1", "ap-southeast-2", "eu-central-1", "ap-northeast-2", "ap-northeast-3", "ap-south-1", "us-east-2", "ca-central-1", "eu-west-2", "eu-west-3", "eu-north-1", "ap-east-1", "me-south-1", "eu-south-1", "af-south-1"];
        readonly linkUrl: "https://aws.amazon.com/sagemaker/";
        readonly isActive: "true";
        readonly subType: "subService";
        readonly disableConfigure: false;
        readonly serviceDefinitionLocation: "https://d1qsjq9pzbk1k6.cloudfront.net/data/sageMakerOnDemandNotebookInstances/en_US.json";
        readonly c2e: false;
        readonly templates: readonly [];
        readonly disableRegionSupport: false;
        readonly serviceDefinitionUrlPath: "/data/sageMakerOnDemandNotebookInstances/en_US.json";
        readonly mvpSupport: false;
        readonly comparableTerms: readonly ["sagemakerdemandnotebookinstances", "sagemakerondemandnotebookinstances"];
        readonly parentServiceCode: "amazonSageMaker";
    };
    readonly sageMakerProcessing: {
        readonly name: "SageMaker Processing";
        readonly serviceCode: "sageMakerProcessing";
        readonly description: "With Amazon SageMaker, you pay only for what you use. Building, training, and deploying ML models is billed by the second, with no minimum fees and no upfront commitments.";
        readonly searchKeywords: readonly ["Sagemaker", "Model", "ML", "Machine Learning", "EI", "data scientist"];
        readonly type: "AWSService";
        readonly regions: readonly ["us-east-1", "eu-west-1", "us-west-1", "ap-southeast-1", "ap-northeast-1", "us-gov-west-1", "us-west-2", "sa-east-1", "ap-southeast-2", "eu-central-1", "ap-northeast-2", "ap-northeast-3", "ap-south-1", "us-east-2", "ca-central-1", "eu-west-2", "eu-west-3", "eu-north-1", "ap-east-1", "me-south-1", "eu-south-1", "af-south-1"];
        readonly linkUrl: "https://aws.amazon.com/sagemaker/";
        readonly isActive: "true";
        readonly subType: "subService";
        readonly disableConfigure: false;
        readonly serviceDefinitionLocation: "https://d1qsjq9pzbk1k6.cloudfront.net/data/sageMakerProcessing/en_US.json";
        readonly c2e: false;
        readonly templates: readonly [];
        readonly disableRegionSupport: false;
        readonly serviceDefinitionUrlPath: "/data/sageMakerProcessing/en_US.json";
        readonly mvpSupport: false;
        readonly comparableTerms: readonly ["sagemakerprocessing"];
        readonly parentServiceCode: "amazonSageMaker";
    };
    readonly sageMakerRealTimeInference: {
        readonly name: "SageMaker Real-Time Inference";
        readonly serviceCode: "sageMakerRealTimeInference";
        readonly description: "With Amazon SageMaker, you pay only for what you use. Building, training, and deploying ML models is billed by the second, with no minimum fees and no upfront commitments.";
        readonly searchKeywords: readonly ["Sagemaker", "Model", "ML", "Machine Learning", "EI", "data scientist"];
        readonly type: "AWSService";
        readonly regions: readonly ["us-east-1", "eu-west-1", "us-west-1", "ap-southeast-1", "ap-northeast-1", "us-gov-west-1", "us-west-2", "sa-east-1", "ap-southeast-2", "eu-central-1", "ap-northeast-2", "ap-northeast-3", "ap-south-1", "us-east-2", "ca-central-1", "eu-west-2", "eu-west-3", "eu-north-1", "ap-east-1", "me-south-1", "eu-south-1", "af-south-1"];
        readonly linkUrl: "https://aws.amazon.com/sagemaker/";
        readonly isActive: "true";
        readonly subType: "subService";
        readonly disableConfigure: false;
        readonly serviceDefinitionLocation: "https://d1qsjq9pzbk1k6.cloudfront.net/data/sageMakerRealTimeInference/en_US.json";
        readonly c2e: false;
        readonly templates: readonly [];
        readonly disableRegionSupport: false;
        readonly serviceDefinitionUrlPath: "/data/sageMakerRealTimeInference/en_US.json";
        readonly mvpSupport: false;
        readonly comparableTerms: readonly ["sagemakerrealtimeinference"];
        readonly parentServiceCode: "amazonSageMaker";
    };
    readonly sageMakerServerlessInference: {
        readonly name: "SageMaker Serverless Inference";
        readonly serviceCode: "sageMakerServerlessInference";
        readonly description: "With Amazon SageMaker, you pay only for what you use. Building, training, and deploying ML models is billed by the second, with no minimum fees and no upfront commitments.";
        readonly searchKeywords: readonly ["Sagemaker", "Model", "ML", "Machine Learning", "EI", "data scientist", "Serverless", "Serverless Inference"];
        readonly type: "AWSService";
        readonly regions: readonly ["af-south-1", "ap-east-1", "ap-northeast-1", "ap-northeast-2", "ap-northeast-3", "ap-south-1", "ap-southeast-1", "ap-southeast-2", "ca-central-1", "eu-central-1", "eu-north-1", "eu-south-1", "eu-west-1", "eu-west-2", "eu-west-3", "me-south-1", "sa-east-1", "us-east-1", "us-east-2", "us-west-1", "us-west-2"];
        readonly linkUrl: "https://aws.amazon.com/sagemaker/";
        readonly isActive: "true";
        readonly subType: "subService";
        readonly disableConfigure: false;
        readonly serviceDefinitionLocation: "https://d1qsjq9pzbk1k6.cloudfront.net/data/sageMakerServerlessInference/en_US.json";
        readonly c2e: false;
        readonly templates: readonly [];
        readonly disableRegionSupport: false;
        readonly serviceDefinitionUrlPath: "/data/sageMakerServerlessInference/en_US.json";
        readonly mvpSupport: false;
        readonly comparableTerms: readonly ["sagemakerserverlessinference"];
        readonly parentServiceCode: "amazonSageMaker";
    };
    readonly sageMakerStudioNotebooks: {
        readonly name: "SageMaker Studio Notebooks";
        readonly serviceCode: "sageMakerStudioNotebooks";
        readonly description: "With Amazon SageMaker, you pay only for what you use. Building, training, and deploying ML models is billed by the second, with no minimum fees and no upfront commitments.";
        readonly searchKeywords: readonly ["Sagemaker", "Model", "ML", "Machine Learning", "EI", "data scientist"];
        readonly type: "AWSService";
        readonly regions: readonly ["af-south-1", "ap-east-1", "ap-south-1", "ap-northeast-1", "ap-northeast-2", "ap-northeast-3", "ap-southeast-1", "ap-southeast-2", "ca-central-1", "eu-central-1", "eu-west-1", "eu-west-2", "eu-south-1", "eu-west-3", "eu-north-1", "me-south-1", "sa-east-1", "us-east-1", "us-east-2", "us-west-1", "us-west-2"];
        readonly linkUrl: "https://aws.amazon.com/sagemaker/";
        readonly isActive: "true";
        readonly subType: "subService";
        readonly disableConfigure: false;
        readonly serviceDefinitionLocation: "https://d1qsjq9pzbk1k6.cloudfront.net/data/sageMakerStudioNotebooks/en_US.json";
        readonly c2e: false;
        readonly templates: readonly [];
        readonly disableRegionSupport: false;
        readonly serviceDefinitionUrlPath: "/data/sageMakerStudioNotebooks/en_US.json";
        readonly mvpSupport: false;
        readonly comparableTerms: readonly ["sagemakerstudionotebooks"];
        readonly parentServiceCode: "amazonSageMaker";
    };
    readonly sageMakerTraining: {
        readonly name: "SageMaker Training";
        readonly serviceCode: "sageMakerTraining";
        readonly description: "With Amazon SageMaker, you pay only for what you use. Building, training, and deploying ML models is billed by the second, with no minimum fees and no upfront commitments.";
        readonly searchKeywords: readonly ["Sagemaker", "Model", "ML", "Machine Learning", "EI", "data scientist"];
        readonly type: "AWSService";
        readonly regions: readonly ["us-east-1", "eu-west-1", "us-west-1", "ap-southeast-1", "ap-northeast-1", "us-gov-west-1", "us-west-2", "sa-east-1", "ap-southeast-2", "eu-central-1", "ap-northeast-2", "ap-northeast-3", "ap-south-1", "us-east-2", "ca-central-1", "eu-west-2", "eu-west-3", "eu-north-1", "ap-east-1", "me-south-1", "eu-south-1", "af-south-1"];
        readonly linkUrl: "https://aws.amazon.com/sagemaker/";
        readonly isActive: "true";
        readonly subType: "subService";
        readonly disableConfigure: false;
        readonly serviceDefinitionLocation: "https://d1qsjq9pzbk1k6.cloudfront.net/data/sageMakerTraining/en_US.json";
        readonly c2e: false;
        readonly templates: readonly [];
        readonly disableRegionSupport: false;
        readonly serviceDefinitionUrlPath: "/data/sageMakerTraining/en_US.json";
        readonly mvpSupport: false;
        readonly comparableTerms: readonly ["sagemakertraining"];
        readonly parentServiceCode: "amazonSageMaker";
    };
    readonly sentimentAnalysis: {
        readonly name: "Sentiment Analysis";
        readonly serviceCode: "sentimentAnalysis";
        readonly description: "With Amazon Comprehend, you only pay for what you use. You are charged based on the amount of text processed on a monthly basis. Amazon Comprehend provides natural language processing, topic modeling, and Custom Classification capabilities, enabling a broad range of applications that can analyze text.";
        readonly searchKeywords: readonly ["Comprehend", "NLP", "Natural language processing", "Sentiment analysis", "Text analytics", "Entity extraction", "Named entity recognition", "NER", "Key phrase extraction", "Topic modeling", "Unsupervised clustering", "Supervised machine learning", "Custom entity recognition", "Custom classification", "Document classifier", "Personally identifiable information", "PII", "Redaction", "Language detection", "Free form text analytics"];
        readonly type: "AWSService";
        readonly regions: readonly ["us-gov-west-1", "ap-south-1", "ap-northeast-2", "ap-southeast-1", "ap-southeast-2", "ap-northeast-1", "ca-central-1", "eu-central-1", "eu-west-1", "eu-west-2", "us-east-1", "us-east-2", "us-west-2"];
        readonly isActive: "true";
        readonly subType: "subService";
        readonly disableConfigure: false;
        readonly serviceDefinitionLocation: "https://d1qsjq9pzbk1k6.cloudfront.net/data/sentimentAnalysis/en_US.json";
        readonly c2e: false;
        readonly templates: readonly [];
        readonly disableRegionSupport: false;
        readonly serviceDefinitionUrlPath: "/data/sentimentAnalysis/en_US.json";
        readonly mvpSupport: false;
        readonly comparableTerms: readonly ["sentimentanalysis"];
        readonly parentServiceCode: "amazonComprehend";
    };
    readonly locationServiceServiceResources: {
        readonly name: "Service Resources";
        readonly serviceCode: "locationServiceServiceResources";
        readonly description: "Amazon Location Service provides affordable data, tracking and geofencing capabilities, and native integrations with AWS services, so you can create sophisticated location-enabled applications quickly, without the high cost of custom development.";
        readonly searchKeywords: readonly ["Location Service", "compromising data security", "user privacy", "asset tracking", "location-based marketing", "maps", "places", "routing", "tracking", "geofencing", "Service Resources"];
        readonly type: "AWSService";
        readonly regions: readonly ["ap-southeast-1", "ap-southeast-2", "ap-northeast-1", "eu-central-1", "eu-west-1", "eu-north-1", "us-east-1", "us-east-2", "us-west-2"];
        readonly linkUrl: "https://aws.amazon.com/location/";
        readonly isActive: "true";
        readonly subType: "subService";
        readonly disableConfigure: false;
        readonly serviceDefinitionLocation: "https://d1qsjq9pzbk1k6.cloudfront.net/data/locationServiceServiceResources/en_US.json";
        readonly c2e: false;
        readonly templates: readonly [];
        readonly disableRegionSupport: false;
        readonly serviceDefinitionUrlPath: "/data/locationServiceServiceResources/en_US.json";
        readonly mvpSupport: false;
        readonly comparableTerms: readonly ["locationserviceserviceresources", "serviceresources"];
        readonly parentServiceCode: "locationService";
    };
    readonly sipTrunking: {
        readonly name: "SIP Trunking";
        readonly serviceCode: "sipTrunking";
        readonly description: "Amazon Chime lets you meet, chat, and collaborate with the security of AWS. You can work seamlessly on your devices, and meet from your desk or on the go - ensuring you always stay connected.";
        readonly searchKeywords: readonly [];
        readonly type: "AWSService";
        readonly regions: readonly ["us-east-1", "us-west-2"];
        readonly linkUrl: "https://aws.amazon.com/chime/chime-sdk";
        readonly isActive: "true";
        readonly subType: "subService";
        readonly disableConfigure: false;
        readonly serviceDefinitionLocation: "https://d1qsjq9pzbk1k6.cloudfront.net/data/sipTrunking/en_US.json";
        readonly c2e: false;
        readonly templates: readonly [];
        readonly disableRegionSupport: false;
        readonly serviceDefinitionUrlPath: "/data/sipTrunking/en_US.json";
        readonly mvpSupport: false;
        readonly comparableTerms: readonly ["siptrunking"];
        readonly parentServiceCode: "amazonChimeSdk";
    };
    readonly snowballEdgeComputeOptimizedGpuWithEc2ComputeInstances: {
        readonly name: "Snowball Edge Compute Optimized GPU with EC2 Compute Instances";
        readonly serviceCode: "snowballEdgeComputeOptimizedGpuWithEc2ComputeInstances";
        readonly description: "AWS Snowball, a part of the AWS Snow Family, is an edge computing, data migration, and edge storage device that comes in two options.";
        readonly searchKeywords: readonly ["Snow", "Snowball", "Snowball Edge", "Disconnected Data Transfer", "Edge Computing", "Data Export"];
        readonly type: "AWSService";
        readonly regions: readonly ["ap-east-1", "ap-south-1", "ap-northeast-3", "ap-northeast-2", "ap-southeast-1", "ap-southeast-2", "ap-northeast-1", "af-south-1", "us-gov-east-1", "us-gov-west-1", "ca-central-1", "eu-central-1", "eu-west-1", "eu-west-2", "eu-south-1", "eu-west-3", "eu-north-1", "sa-east-1", "us-east-1", "us-east-2", "us-west-1", "us-west-2"];
        readonly linkUrl: "https://aws.amazon.com/snowball/";
        readonly isActive: "true";
        readonly subType: "subService";
        readonly disableConfigure: false;
        readonly serviceDefinitionLocation: "https://d1qsjq9pzbk1k6.cloudfront.net/data/snowballEdgeComputeOptimizedGpuWithEc2ComputeInstances/en_US.json";
        readonly c2e: false;
        readonly templates: readonly [];
        readonly disableRegionSupport: false;
        readonly serviceDefinitionUrlPath: "/data/snowballEdgeComputeOptimizedGpuWithEc2ComputeInstances/en_US.json";
        readonly mvpSupport: false;
        readonly comparableTerms: readonly ["snowballedgecomputeoptimizedgpuwithec2computeinstances"];
        readonly parentServiceCode: "awsSnowball";
    };
    readonly snowballEdgeComputeOptimizedWithEc2ComputeInstances: {
        readonly name: "Snowball Edge Compute Optimized with EC2 Compute Instances";
        readonly serviceCode: "snowballEdgeComputeOptimizedWithEc2ComputeInstances";
        readonly description: "AWS Snowball, a part of the AWS Snow Family, is an edge computing, data migration, and edge storage device that comes in two options.";
        readonly searchKeywords: readonly ["Snow", "Snowball", "Snowball Edge", "Disconnected Data Transfer", "Edge Computing", "Data Export"];
        readonly type: "AWSService";
        readonly regions: readonly ["ap-east-1", "ap-south-1", "ap-northeast-3", "ap-northeast-2", "ap-southeast-1", "ap-southeast-2", "ap-northeast-1", "af-south-1", "us-gov-east-1", "us-gov-west-1", "ca-central-1", "eu-west-1", "eu-west-2", "eu-south-1", "eu-west-3", "eu-north-1", "sa-east-1", "us-east-1", "us-east-2", "us-west-1", "us-west-2"];
        readonly linkUrl: "https://aws.amazon.com/snowball/";
        readonly isActive: "true";
        readonly subType: "subService";
        readonly disableConfigure: false;
        readonly serviceDefinitionLocation: "https://d1qsjq9pzbk1k6.cloudfront.net/data/snowballEdgeComputeOptimizedWithEc2ComputeInstances/en_US.json";
        readonly c2e: false;
        readonly templates: readonly [];
        readonly disableRegionSupport: false;
        readonly serviceDefinitionUrlPath: "/data/snowballEdgeComputeOptimizedWithEc2ComputeInstances/en_US.json";
        readonly mvpSupport: false;
        readonly comparableTerms: readonly ["snowballedgecomputeoptimizedwithec2computeinstances"];
        readonly parentServiceCode: "awsSnowball";
    };
    readonly snowballEdgeStorageOptimizedDataTransferOnly: {
        readonly name: "Snowball Edge Storage Optimized Data Transfer Only";
        readonly serviceCode: "snowballEdgeStorageOptimizedDataTransferOnly";
        readonly description: "AWS Snowball, a part of the AWS Snow Family, is an edge computing, data migration, and edge storage device that comes in two options.";
        readonly searchKeywords: readonly ["Snow", "Snowball", "Snowball Edge", "Disconnected Data Transfer", "Edge Computing", "Data Export"];
        readonly type: "AWSService";
        readonly regions: readonly ["ap-east-1", "ap-south-1", "ap-northeast-3", "ap-northeast-2", "ap-southeast-1", "ap-southeast-2", "ap-northeast-1", "af-south-1", "us-gov-east-1", "us-gov-west-1", "ca-central-1", "eu-central-1", "eu-west-1", "eu-west-2", "eu-south-1", "eu-west-3", "eu-north-1", "sa-east-1", "us-east-1", "us-east-2", "us-west-1", "us-west-2"];
        readonly linkUrl: "https://aws.amazon.com/snowball/";
        readonly isActive: "true";
        readonly subType: "subService";
        readonly disableConfigure: false;
        readonly serviceDefinitionLocation: "https://d1qsjq9pzbk1k6.cloudfront.net/data/snowballEdgeStorageOptimizedDataTransferOnly/en_US.json";
        readonly c2e: false;
        readonly templates: readonly [];
        readonly disableRegionSupport: false;
        readonly serviceDefinitionUrlPath: "/data/snowballEdgeStorageOptimizedDataTransferOnly/en_US.json";
        readonly mvpSupport: false;
        readonly comparableTerms: readonly ["snowballedgestorageoptimizeddatatransferonly"];
        readonly parentServiceCode: "awsSnowball";
    };
    readonly snowballEdgeStorageOptimizedWithEc2ComputeInstances: {
        readonly name: "Snowball Edge Storage Optimized with EC2 Compute Instances";
        readonly serviceCode: "snowballEdgeStorageOptimizedWithEc2ComputeInstances";
        readonly description: "AWS Snowball, a part of the AWS Snow Family, is an edge computing, data migration, and edge storage device that comes in two options.";
        readonly searchKeywords: readonly ["Snow", "Snowball", "Snowball Edge", "Disconnected Data Transfer", "Edge Computing", "Data Export"];
        readonly type: "AWSService";
        readonly regions: readonly ["ap-east-1", "ap-south-1", "ap-northeast-3", "ap-northeast-2", "ap-southeast-1", "ap-southeast-2", "ap-northeast-1", "af-south-1", "us-gov-east-1", "us-gov-west-1", "ca-central-1", "eu-central-1", "eu-west-1", "eu-west-2", "eu-south-1", "eu-west-3", "eu-north-1", "sa-east-1", "us-east-1", "us-east-2", "us-west-1", "us-west-2"];
        readonly linkUrl: "https://aws.amazon.com/snowball/";
        readonly isActive: "true";
        readonly subType: "subService";
        readonly disableConfigure: false;
        readonly serviceDefinitionLocation: "https://d1qsjq9pzbk1k6.cloudfront.net/data/snowballEdgeStorageOptimizedWithEc2ComputeInstances/en_US.json";
        readonly c2e: false;
        readonly templates: readonly [];
        readonly disableRegionSupport: false;
        readonly serviceDefinitionUrlPath: "/data/snowballEdgeStorageOptimizedWithEc2ComputeInstances/en_US.json";
        readonly mvpSupport: false;
        readonly comparableTerms: readonly ["snowballedgestorageoptimizedwithec2computeinstances"];
        readonly parentServiceCode: "awsSnowball";
    };
    readonly standardBatchTranslation: {
        readonly name: "Standard Batch Translation";
        readonly serviceCode: "standardBatchTranslation";
        readonly description: "Amazon Translate is a neural machine translation service that delivers fast, high-quality, and affordable language translation. Neural machine translation is a form of language translation automation that uses deep learning models to deliver more accurate and more natural sounding translation than traditional statistical and rule-based translation algorithms.";
        readonly searchKeywords: readonly ["NLP", "Natural language processing", "language transalation", "Text analytics", "Language translation", "Amazon translate", "Translate"];
        readonly type: "AWSService";
        readonly regions: readonly ["us-east-1", "eu-west-1", "us-west-2", "eu-central-1", "ap-northeast-2", "us-east-2", "eu-west-2"];
        readonly linkUrl: "https://aws.amazon.com/translate/";
        readonly isActive: "true";
        readonly subType: "subService";
        readonly disableConfigure: false;
        readonly serviceDefinitionLocation: "https://d1qsjq9pzbk1k6.cloudfront.net/data/standardBatchTranslation/en_US.json";
        readonly c2e: false;
        readonly templates: readonly [];
        readonly disableRegionSupport: false;
        readonly serviceDefinitionUrlPath: "/data/standardBatchTranslation/en_US.json";
        readonly mvpSupport: false;
        readonly comparableTerms: readonly ["standardbatchtranslation"];
        readonly parentServiceCode: "amazonTranslate";
    };
    readonly standardRealTimeTranslation: {
        readonly name: "Standard Real-Time Translation";
        readonly serviceCode: "standardRealTimeTranslation";
        readonly description: "Amazon Translate is a neural machine translation service that delivers fast, high-quality, and affordable language translation. Neural machine translation is a form of language translation automation that uses deep learning models to deliver more accurate and more natural sounding translation than traditional statistical and rule-based translation algorithms.";
        readonly searchKeywords: readonly ["NLP", "Natural language processing", "language transalation", "Text analytics", "Language translation", "Amazon translate", "Translate"];
        readonly type: "AWSService";
        readonly regions: readonly ["us-east-1", "eu-west-1", "us-west-1", "ap-southeast-1", "ap-northeast-1", "us-gov-west-1", "us-west-2", "ap-southeast-2", "eu-central-1", "ap-northeast-2", "ap-south-1", "us-east-2", "ca-central-1", "eu-west-2", "eu-west-3", "eu-north-1", "ap-east-1"];
        readonly linkUrl: "https://aws.amazon.com/translate/";
        readonly isActive: "true";
        readonly subType: "subService";
        readonly disableConfigure: false;
        readonly serviceDefinitionLocation: "https://d1qsjq9pzbk1k6.cloudfront.net/data/standardRealTimeTranslation/en_US.json";
        readonly c2e: false;
        readonly templates: readonly [];
        readonly disableRegionSupport: false;
        readonly serviceDefinitionUrlPath: "/data/standardRealTimeTranslation/en_US.json";
        readonly mvpSupport: false;
        readonly comparableTerms: readonly ["standardrealtimetranslation"];
        readonly parentServiceCode: "amazonTranslate";
    };
    readonly standardTextToSpeechTts: {
        readonly name: "Standard Text-to-Speech";
        readonly serviceCode: "standardTextToSpeechTts";
        readonly description: "Amazon Polly is a service that turns text into lifelike speech, allowing you to create applications that talk, and build entirely new categories of speech-enabled products.";
        readonly searchKeywords: readonly ["polly", "NLP", "speech"];
        readonly type: "AWSService";
        readonly regions: readonly ["us-gov-west-1", "ap-east-1", "ap-south-1", "ap-northeast-2", "ap-southeast-1", "ap-southeast-2", "ap-northeast-1", "ca-central-1", "eu-central-1", "eu-west-1", "eu-west-2", "eu-west-3", "eu-north-1", "me-south-1", "sa-east-1", "us-east-1", "us-east-2", "us-west-1", "us-west-2"];
        readonly linkUrl: "https://aws.amazon.com/polly/";
        readonly isActive: "true";
        readonly subType: "subService";
        readonly serviceDefinitionLocation: "https://d1qsjq9pzbk1k6.cloudfront.net/data/standardTextToSpeechTts/en_US.json";
        readonly c2e: false;
        readonly comparableTerms: readonly ["standardtexttospeech", "standardtexttospeechtts"];
        readonly parentServiceCode: "amazonPolly";
    };
    readonly standardTopics: {
        readonly name: "Standard topics";
        readonly serviceCode: "standardTopics";
        readonly description: "Amazon Simple Notification Service (SNS) is a highly available, durable, secure, fully managed pub/sub messaging service that enables you to decouple microservices, distributed systems, and serverless applications";
        readonly searchKeywords: readonly ["Messaging", "SNS", "notification topic", "publish message", "subscription", "text message", "sms", "topics", "push notifications", "push notification service queuing"];
        readonly type: "AWSService";
        readonly regions: readonly ["af-south-1", "ap-east-1", "ap-northeast-1", "ap-northeast-2", "ap-northeast-3", "ap-south-1", "ap-southeast-1", "ap-southeast-2", "ap-southeast-3", "ca-central-1", "eu-central-1", "eu-north-1", "eu-south-1", "eu-west-1", "eu-west-2", "eu-west-3", "sa-east-1", "us-east-1", "us-east-2", "us-gov-east-1", "us-gov-west-1", "us-west-1", "us-west-2", "me-south-1", "me-central-1"];
        readonly linkUrl: "https://aws.amazon.com/sns/pricing/";
        readonly isActive: "true";
        readonly subType: "subService";
        readonly disableConfigure: false;
        readonly serviceDefinitionLocation: "https://d1qsjq9pzbk1k6.cloudfront.net/data/standardTopics/en_US.json";
        readonly c2e: false;
        readonly templates: readonly [];
        readonly disableRegionSupport: false;
        readonly serviceDefinitionUrlPath: "/data/standardTopics/en_US.json";
        readonly mvpSupport: false;
        readonly comparableTerms: readonly ["standardtopics"];
        readonly parentServiceCode: "amazonSimpleNotificationService";
    };
    readonly stepFunctionExpress: {
        readonly name: "Step Functions - Express Workflows";
        readonly serviceCode: "stepFunctionExpress";
        readonly description: "AWS Step Functions is a serverless function orchestrator that makes it easy to sequence AWS Lambda functions and multiple AWS services into business-critical applications.";
        readonly searchKeywords: readonly ["workflows", " workflow", " orchestrator", " orchestration", " serverless", " state machine", " State Machines", " States", " State", " Microservices", " application integration", " Amazon States Language", " ASL", " Data Science SDK", " data processing", " API orchestration", " DAG", " DAGs", " Step Functions", " Step Function", " Step", " media processing", " application orchestration", " serverless orchestration", " serverless workflow", " lambda orchestration", " serverless state machine", " asynchronous", " synchronous", " event-driven data processing", " event-driven", " event orchestration", " standard workflows", " standard workflow", " express workflow", " express workflows", " standard workflows", " error handling", " service integrations", " state management", " visual workflow", " visual monitoring", " high volume orchestration", " function", " functions", " machine learning workflow", " machine learning workflows", " JSON", " serverless workflows", " serverless workflow", " Business logic", " complex workflows", " data pipeline", " data processing", " decoupling", " decouple applications", " abstraction", " abstraction layer", " automation", " It automation", " connecting aws services", " integration of aws services", " coordinating AWS services", " managed workflows", " call back patterns", " callback pattern", " callback patterns", " call back pattern", " human approval", " manual approval", " human intervention", " EKS orchestration", " container orchestration", " short duration workflows", " long duration workflows", " short-duration workflows", " short-duration workflow", " long-running workflow", " long-running workflows", " machine-learning workflows", " ML workflows", " ML workflow", " API orchestration", " function", " functions", " compute function", " compute functions", " Lambda retry", " Lambda retries", " serverless compute", " parallel processing", " Lambda chaining", " error-handling", " retries", " saga pattern", " nested", " branching", " nesting", " nested pattern", " branching pattern", " nesting pattern", " serverless patterns", " event-driven patterns", " coordinating workflows"];
        readonly type: "AWSService";
        readonly regions: readonly ["us-gov-west-1", "us-gov-east-1", "af-south-1", "ap-east-1", "ap-south-1", "ap-northeast-2", "ap-southeast-1", "ap-southeast-2", "ap-southeast-3", "ap-northeast-1", "ca-central-1", "eu-central-1", "eu-west-1", "eu-west-2", "eu-south-1", "eu-west-3", "eu-north-1", "me-south-1", "me-central-1", "sa-east-1", "us-east-1", "us-east-2", "us-west-1", "us-west-2"];
        readonly isActive: "true";
        readonly subType: "subService";
        readonly disableConfigure: false;
        readonly serviceDefinitionLocation: "https://d1qsjq9pzbk1k6.cloudfront.net/data/stepFunctionExpress/en_US.json";
        readonly c2e: false;
        readonly templates: readonly [];
        readonly disableRegionSupport: false;
        readonly serviceDefinitionUrlPath: "/data/stepFunctionExpress/en_US.json";
        readonly mvpSupport: false;
        readonly comparableTerms: readonly ["stepfunctionexpress", "stepfunctionsexpressworkflows"];
        readonly parentServiceCode: "awsStepFunctions";
    };
    readonly stepFunctionStandard: {
        readonly name: "Step Functions - Standard Workflows";
        readonly serviceCode: "stepFunctionStandard";
        readonly description: "AWS Step Functions is a serverless function orchestrator that makes it easy to sequence AWS Lambda functions and multiple AWS services into business-critical applications.";
        readonly searchKeywords: readonly ["workflows", " workflow", " orchestrator", " orchestration", " serverless", " state machine", " State Machines", " States", " State", " Microservices", " application integration", " Amazon States Language", " ASL", " Data Science SDK", " data processing", " API orchestration", " DAG", " DAGs", " Step Functions", " Step Function", " Step", " media processing", " application orchestration", " serverless orchestration", " serverless workflow", " lambda orchestration", " serverless state machine", " asynchronous", " synchronous", " event-driven data processing", " event-driven", " event orchestration", " standard workflows", " standard workflow", " express workflow", " express workflows", " standard workflows", " error handling", " service integrations", " state management", " visual workflow", " visual monitoring", " high volume orchestration", " function", " functions", " machine learning workflow", " machine learning workflows", " JSON", " serverless workflows", " serverless workflow", " Business logic", " complex workflows", " data pipeline", " data processing", " decoupling", " decouple applications", " abstraction", " abstraction layer", " automation", " It automation", " connecting aws services", " integration of aws services", " coordinating AWS services", " managed workflows", " call back patterns", " callback pattern", " callback patterns", " call back pattern", " human approval", " manual approval", " human intervention", " EKS orchestration", " container orchestration", " short duration workflows", " long duration workflows", " short-duration workflows", " short-duration workflow", " long-running workflow", " long-running workflows", " machine-learning workflows", " ML workflows", " ML workflow", " API orchestration", " function", " functions", " compute function", " compute functions", " Lambda retry", " Lambda retries", " serverless compute", " parallel processing", " Lambda chaining", " error-handling", " retries", " saga pattern", " nested", " branching", " nesting", " nested pattern", " branching pattern", " nesting pattern", " serverless patterns", " event-driven patterns", " coordinating workflows"];
        readonly type: "AWSService";
        readonly regions: readonly ["us-gov-west-1", "us-gov-east-1", "af-south-1", "ap-east-1", "ap-south-1", "ap-northeast-2", "ap-southeast-1", "ap-southeast-2", "ap-southeast-3", "ap-northeast-1", "ca-central-1", "eu-central-1", "eu-west-1", "eu-west-2", "eu-south-1", "eu-west-3", "eu-north-1", "me-south-1", "me-central-1", "sa-east-1", "us-east-1", "us-east-2", "us-west-1", "us-west-2"];
        readonly isActive: "true";
        readonly subType: "subService";
        readonly disableConfigure: false;
        readonly serviceDefinitionLocation: "https://d1qsjq9pzbk1k6.cloudfront.net/data/stepFunctionStandard/en_US.json";
        readonly c2e: false;
        readonly templates: readonly [];
        readonly disableRegionSupport: false;
        readonly serviceDefinitionUrlPath: "/data/stepFunctionStandard/en_US.json";
        readonly mvpSupport: false;
        readonly comparableTerms: readonly ["stepfunctionsstandardworkflows", "stepfunctionstandard"];
        readonly parentServiceCode: "awsStepFunctions";
    };
    readonly syntaxAnalysis: {
        readonly name: "Syntax Analysis";
        readonly serviceCode: "syntaxAnalysis";
        readonly description: "With Amazon Comprehend, you only pay for what you use. You are charged based on the amount of text processed on a monthly basis. Amazon Comprehend provides natural language processing, topic modeling, and Custom Classification capabilities, enabling a broad range of applications that can analyze text.";
        readonly searchKeywords: readonly ["Comprehend", "NLP", "Natural language processing", "Sentiment analysis", "Text analytics", "Entity extraction", "Named entity recognition", "NER", "Key phrase extraction", "Topic modeling", "Unsupervised clustering", "Supervised machine learning", "Custom entity recognition", "Custom classification", "Document classifier", "Personally identifiable information", "PII", "Redaction", "Language detection", "Free form text analytics"];
        readonly type: "AWSService";
        readonly regions: readonly ["us-gov-west-1", "ap-south-1", "ap-northeast-2", "ap-southeast-1", "ap-southeast-2", "ap-northeast-1", "ca-central-1", "eu-central-1", "eu-west-1", "eu-west-2", "us-east-1", "us-east-2", "us-west-2"];
        readonly isActive: "true";
        readonly subType: "subService";
        readonly disableConfigure: false;
        readonly serviceDefinitionLocation: "https://d1qsjq9pzbk1k6.cloudfront.net/data/syntaxAnalysis/en_US.json";
        readonly c2e: false;
        readonly templates: readonly [];
        readonly disableRegionSupport: false;
        readonly serviceDefinitionUrlPath: "/data/syntaxAnalysis/en_US.json";
        readonly mvpSupport: false;
        readonly comparableTerms: readonly ["syntaxanalysis"];
        readonly parentServiceCode: "amazonComprehend";
    };
    readonly targetedSentiment: {
        readonly name: "Targeted Sentiment";
        readonly serviceCode: "targetedSentiment";
        readonly description: "With Amazon Comprehend, you only pay for what you use. You are charged based on the amount of text processed on a monthly basis. Amazon Comprehend provides natural language processing, topic modeling, and Custom Classification capabilities, enabling a broad range of applications that can analyze text.";
        readonly searchKeywords: readonly ["Comprehend", "NLP", "Natural language processing", "Sentiment analysis", "Text analytics", "Entity extraction", "Named entity recognition", "NER", "Key phrase extraction", "Topic modeling", "Unsupervised clustering", "Supervised machine learning", "Custom entity recognition", "Custom classification", "Document classifier", "Personally identifiable information", "PII", "Redaction", "Language detection", "Free form text analytics", "Targeted Sentiment"];
        readonly type: "AWSService";
        readonly regions: readonly ["us-gov-west-1", "ap-south-1", "ap-northeast-2", "ap-southeast-1", "ap-southeast-2", "ap-northeast-1", "ca-central-1", "eu-central-1", "eu-west-1", "eu-west-2", "us-east-1", "us-east-2", "us-west-2"];
        readonly isActive: "true";
        readonly subType: "subService";
        readonly disableConfigure: false;
        readonly serviceDefinitionLocation: "https://d1qsjq9pzbk1k6.cloudfront.net/data/targetedSentiment/en_US.json";
        readonly c2e: false;
        readonly templates: readonly [];
        readonly disableRegionSupport: false;
        readonly serviceDefinitionUrlPath: "/data/targetedSentiment/en_US.json";
        readonly mvpSupport: false;
        readonly comparableTerms: readonly ["targetedsentiment"];
        readonly parentServiceCode: "amazonComprehend";
    };
    readonly comprehendTopicModeling: {
        readonly name: "Topic Modeling";
        readonly serviceCode: "comprehendTopicModeling";
        readonly description: "With Amazon Comprehend, you only pay for what you use. You are charged based on the amount of text processed on a monthly basis. Amazon Comprehend provides natural language processing, topic modeling, and Custom Classification capabilities, enabling a broad range of applications that can analyze text.";
        readonly searchKeywords: readonly ["Comprehend", "NLP", "Natural language processing", "Sentiment analysis", "Text analytics", "Entity extraction", "Named entity recognition", "NER", "Key phrase extraction", "Topic modeling", "Unsupervised clustering", "Supervised machine learning", "Custom entity recognition", "Custom classification", "Document classifier", "Personally identifiable information", "PII", "Redaction", "Language detection", "Free form text analytics"];
        readonly type: "AWSService";
        readonly regions: readonly ["us-gov-west-1", "ap-south-1", "ap-northeast-2", "ap-southeast-1", "ap-southeast-2", "ap-northeast-1", "ca-central-1", "eu-central-1", "eu-west-1", "eu-west-2", "us-east-1", "us-east-2", "us-west-2"];
        readonly isActive: "true";
        readonly subType: "subService";
        readonly disableConfigure: false;
        readonly serviceDefinitionLocation: "https://d1qsjq9pzbk1k6.cloudfront.net/data/comprehendTopicModeling/en_US.json";
        readonly c2e: false;
        readonly templates: readonly [];
        readonly disableRegionSupport: false;
        readonly serviceDefinitionUrlPath: "/data/comprehendTopicModeling/en_US.json";
        readonly mvpSupport: false;
        readonly comparableTerms: readonly ["comprehendtopicmodeling", "topicmodeling"];
        readonly parentServiceCode: "amazonComprehend";
    };
    readonly locationServiceTracking: {
        readonly name: "Tracking";
        readonly serviceCode: "locationServiceTracking";
        readonly description: "Amazon Location Service provides affordable data, tracking and geofencing capabilities, and native integrations with AWS services, so you can create sophisticated location-enabled applications quickly, without the high cost of custom development.";
        readonly searchKeywords: readonly ["Location Service", "compromising data security", "user privacy", "asset tracking", "location-based marketing", "maps", "places", "routing", "tracking", "geofencing", "Service Resources"];
        readonly type: "AWSService";
        readonly regions: readonly ["ap-southeast-1", "ap-southeast-2", "ap-northeast-1", "eu-central-1", "eu-west-1", "eu-north-1", "us-east-1", "us-east-2", "us-west-2"];
        readonly linkUrl: "https://aws.amazon.com/location/";
        readonly isActive: "true";
        readonly subType: "subService";
        readonly disableConfigure: false;
        readonly serviceDefinitionLocation: "https://d1qsjq9pzbk1k6.cloudfront.net/data/locationServiceTracking/en_US.json";
        readonly c2e: false;
        readonly templates: readonly [];
        readonly disableRegionSupport: false;
        readonly serviceDefinitionUrlPath: "/data/locationServiceTracking/en_US.json";
        readonly mvpSupport: false;
        readonly comparableTerms: readonly ["locationservicetracking", "tracking"];
        readonly parentServiceCode: "locationService";
    };
    readonly trafficMirroringVpc: {
        readonly name: "Traffic Mirroring";
        readonly serviceCode: "trafficMirroringVpc";
        readonly description: "WS Virtual Private Network solutions establish secure connections between your on-premises networks, remote offices, client devices, and the AWS global network. AWS VPN is comprised of two services: AWS Site-to-Site VPN and AWS Client VPN. Each service provides a highly-available, managed, and elastic cloud VPN solution to protect your network traffic.";
        readonly searchKeywords: readonly ["access control", "ACL", "AWS Privatelink", "Cloud connectivity", "corporate network", "elastic IP", "Gateway load balancer", "home network VPN", "IPAM", "NAT", "NAT gateway", "Network Access Analyzer", "Network Address Translation", "Networking Content Delivery", "PrivateLink", "Reachability Analyzer", "security", "single tenant hardware", "static ip", "subnets", "Traffic mirroring", "Transit Gateway", "Virtual Private Cloud", "VPN"];
        readonly type: "AWSService";
        readonly regions: readonly ["ap-east-1", "ap-northeast-1", "ap-northeast-2", "ap-south-1", "ap-southeast-1", "ap-southeast-2", "ca-central-1", "eu-central-1", "eu-north-1", "eu-west-1", "eu-west-2", "eu-west-3", "me-south-1", "sa-east-1", "us-east-1", "us-east-2", "us-west-1", "us-west-2", "us-gov-east-1", "us-gov-west-1"];
        readonly isActive: "true";
        readonly subType: "subService";
        readonly disableConfigure: false;
        readonly serviceDefinitionLocation: "https://d1qsjq9pzbk1k6.cloudfront.net/data/trafficMirroringVpc/en_US.json";
        readonly c2e: false;
        readonly templates: readonly [];
        readonly disableRegionSupport: false;
        readonly serviceDefinitionUrlPath: "/data/trafficMirroringVpc/en_US.json";
        readonly mvpSupport: false;
        readonly comparableTerms: readonly ["trafficmirroring", "trafficmirroringvpc"];
        readonly parentServiceCode: "amazonVirtualPrivateCloud";
    };
    readonly transitGatewayVpc: {
        readonly name: "Transit Gateway";
        readonly serviceCode: "transitGatewayVpc";
        readonly description: "AWS Transit Gateway connects VPCs and on-premises networks through a central hub. This simplifies your network and puts an end to complex peering relationships. It acts as a cloud router – each new connection is only made once.";
        readonly searchKeywords: readonly ["Transit Gateway"];
        readonly type: "AWSService";
        readonly regions: readonly ["af-south-1", "ap-east-1", "ap-northeast-1", "ap-northeast-2", "ap-northeast-3", "ap-south-1", "ap-southeast-1", "ap-southeast-2", "ap-southeast-3", "ca-central-1", "eu-central-1", "eu-north-1", "eu-south-1", "eu-west-1", "eu-west-2", "eu-west-3", "me-south-1", "sa-east-1", "us-east-1", "us-east-2", "us-west-1", "us-west-2", "us-gov-east-1", "us-gov-west-1"];
        readonly isActive: "true";
        readonly subType: "subService";
        readonly disableConfigure: false;
        readonly serviceDefinitionLocation: "https://d1qsjq9pzbk1k6.cloudfront.net/data/transitGatewayVpc/en_US.json";
        readonly c2e: false;
        readonly templates: readonly [];
        readonly disableRegionSupport: false;
        readonly serviceDefinitionUrlPath: "/data/transitGatewayVpc/en_US.json";
        readonly slug: "transitgatewayvpc";
        readonly mvpSupport: false;
        readonly comparableTerms: readonly ["transitgateway", "transitgatewayvpc"];
        readonly parentServiceCode: "amazonVirtualPrivateCloud";
    };
    readonly vpnConnectionVpc: {
        readonly name: "VPN Connection";
        readonly serviceCode: "vpnConnectionVpc";
        readonly description: "WS Virtual Private Network solutions establish secure connections between your on-premises networks, remote offices, client devices, and the AWS global network. AWS VPN is comprised of two services: AWS Site-to-Site VPN and AWS Client VPN. Each service provides a highly-available, managed, and elastic cloud VPN solution to protect your network traffic.";
        readonly searchKeywords: readonly ["access control", "ACL", "AWS Privatelink", "Cloud connectivity", "corporate network", "elastic IP", "Gateway load balancer", "home network VPN", "IPAM", "NAT", "NAT gateway", "Network Access Analyzer", "Network Address Translation", "Networking Content Delivery", "PrivateLink", "Reachability Analyzer", "security", "single tenant hardware", "static ip", "subnets", "Traffic mirroring", "Transit Gateway", "Virtual Private Cloud", "VPN"];
        readonly type: "AWSService";
        readonly regions: readonly ["af-south-1", "ap-east-1", "ap-northeast-1", "ap-northeast-2", "ap-northeast-3", "ap-south-1", "ap-southeast-1", "ap-southeast-2", "ap-southeast-3", "ca-central-1", "eu-central-1", "eu-north-1", "eu-south-1", "eu-west-1", "eu-west-2", "eu-west-3", "me-south-1", "me-central-1", "sa-east-1", "us-east-1", "us-east-2", "us-west-1", "us-west-2", "us-gov-east-1", "us-gov-west-1"];
        readonly isActive: "true";
        readonly subType: "subService";
        readonly disableConfigure: false;
        readonly serviceDefinitionLocation: "https://d1qsjq9pzbk1k6.cloudfront.net/data/vpnConnectionVpc/en_US.json";
        readonly c2e: false;
        readonly templates: readonly [];
        readonly disableRegionSupport: false;
        readonly serviceDefinitionUrlPath: "/data/vpnConnectionVpc/en_US.json";
        readonly mvpSupport: false;
        readonly comparableTerms: readonly ["vpnconnection", "vpnconnectionvpc"];
        readonly parentServiceCode: "amazonVirtualPrivateCloud";
    };
    readonly webRtcMedia: {
        readonly name: "WebRTC Media";
        readonly serviceCode: "webRtcMedia";
        readonly description: "Amazon Chime lets you meet, chat, and collaborate with the security of AWS. You can work seamlessly on your devices, and meet from your desk or on the go - ensuring you always stay connected.";
        readonly searchKeywords: readonly [];
        readonly type: "AWSService";
        readonly regions: readonly ["ap-southeast-1", "us-gov-east-1", "us-gov-west-1", "eu-central-1", "us-east-1", "us-west-2"];
        readonly linkUrl: "https://aws.amazon.com/chime/chime-sdk";
        readonly isActive: "true";
        readonly subType: "subService";
        readonly disableConfigure: false;
        readonly serviceDefinitionLocation: "https://d1qsjq9pzbk1k6.cloudfront.net/data/webRtcMedia/en_US.json";
        readonly c2e: false;
        readonly templates: readonly [];
        readonly disableRegionSupport: false;
        readonly bulkImportEnabled: false;
        readonly serviceDefinitionUrlPath: "/data/webRtcMedia/en_US.json";
        readonly mvpSupport: false;
        readonly comparableTerms: readonly ["webrtcmedia"];
        readonly parentServiceCode: "amazonChimeSdk";
    };
    readonly windowsWorkloads: {
        readonly name: "Windows Server and SQL Server on Amazon EC2";
        readonly serviceCode: "windowsWorkloads";
        readonly description: "The Windows Server and SQL Server on Amazon EC2 calculator provides a pricing estimate for specific workloads. It recommends suitable cloud deployment options and cost-saving pricing models based on licensing and infrastructure inputs.";
        readonly searchKeywords: readonly ["EC2", "Windows", "SQL", "Microsoft", "Compute", "VM", "Database", "migration", "msft", "olap", "oltp", "Win", "DB", "MS", "DW", "Data Warehouse", "SSIS", "SSAS", "SSRS", "ODS"];
        readonly type: "AWSService";
        readonly regions: readonly ["af-south-1", "ap-east-1", "ap-northeast-1", "ap-northeast-2", "ap-northeast-3", "ap-south-1", "ap-southeast-1", "ap-southeast-2", "ca-central-1", "eu-central-1", "eu-north-1", "eu-south-1", "eu-west-1", "eu-west-2", "eu-west-3", "me-south-1", "sa-east-1", "us-east-1-bos-1", "us-east-1-iah-1", "us-east-1-mia-1", "us-east-1", "us-east-2", "us-gov-east-1", "us-gov-west-1", "us-west-1", "us-west-2", "us-west-2-lax-1", "us-east-1-wl1-atl1", "us-east-1-wl1-dfw1", "us-east-1-wl1-mia1", "us-east-1-wl1-nyc1", "us-east-1-wl1-was1", "us-west-2-wl1", "us-west-2-wl1-las1", "us-east-1-wl1"];
        readonly linkUrl: "https://aws.amazon.com/windows/";
        readonly isActive: "true";
        readonly disableConfigure: false;
        readonly serviceDefinitionLocation: "https://d1qsjq9pzbk1k6.cloudfront.net/data/windowsWorkloads/en_US.json";
        readonly c2e: false;
        readonly templates: readonly [];
        readonly disableRegionSupport: false;
        readonly bulkImportEnabled: false;
        readonly serviceDefinitionUrlPath: "/data/windowsWorkloads/en_US.json";
        readonly slug: "EC2WinSQL";
        readonly mvpSupport: false;
        readonly comparableTerms: readonly ["ec2winsql", "windows", "windowsserversqlserveronec2", "windowsworkloads"];
    };
};
export declare const PRICING_SLUGS: readonly ["appmigrationsvc", "APIGateway", "Appflow", "AppStream", "Athena", "AuroraMySQL", "AuroraPostgreSQL", "Braket", "CarrierIP", "Chime", "ChimeSDK", "CloudFront", "CloudWatch", "CodeGuruReviewer", "CodeGuruReviewerv2", "Cognito", "Comprehend", "ComprehendMedical", "detective", "DevOpsGuru", "DocumentDB", "DynamoDB", "EC2", "EC2DedicatedHosts", "EKS", "EBS", "ECR", "EFS", "ElasticGraphics", "ElasticIP", "ElasticTranscoder", "ElastiCache", "EMR", "eventbridge", "filecache", "FinSpace", "forecast", "frauddetector", "FSxForLustre", "FSxForNetAppOntap", "FSxForOpenZFS", "FSx", "GameLift", "guardduty", "HealthLake", "Inspector", "Kendra", "KinesisDataAnalytics", "KinesisDataFirehose", "KinesisDataStreams", "KinesisVideoStreams", "lex", "Lightsail", "LookoutForMetrics", "LookoutVision", "Macie", "ManagedBlockchain", "Prometheus", "MSK", "MWAA", "memorydb", "MQ", "neptune", "OpenSearchService", "personalize", "Pinpoint", "polly", "QuickSight", "RDSCustomForOracle", "RDSCustomForSQLServer", "RDSMariaDB", "RDSMySQL", "amazonRDSOracle", "RDSPostgreSQL", "RDSSQLServer", "RDSOutposts", "Redshift", "Rekognition", "Route53", "S3Glacier", "SageMaker", "SageMakerGroundTruth", "SES", "SNS", "SQS", "S3", "SWF", "Textract", "Transcribe", "TranscribeMedical", "Translate", "VPC", "WorkDocs", "WorkMail", "WorkSpaces", "Amplify", "appSync", "budgets", "certificateManager", "CloudFormation", "CloudHSM", "CloudTrail", "CodeArtifact", "codebuild", "CodeDeploy", "CodePipeline", "Config", "cost-explorer", "datapipeline", "DataTransfer", "DMS", "DataSync", "DeepRacer", "DeviceFarm", "DirectConnect", "DirectoryService", "ElasticDisasterRecovery", "ElementalMediaTailor", "ElementalMediaConnect", "ElementalMediaLive", "ElementalMediaPackage", "Fargate", "Glue", "iot-analytics", "IoTCore", "IoTDeviceDefender", "IoTDeviceManagement", "iot-events", "greengrass", "IoTThingsGraph", "KMS", "LakeFormation", "Lambda", "LocationService", "mainframeModernization", "migration-hub", "networkfirewall", "Outposts", "SecretsManager", "securityHub", "shield", "Snowball", "Snowmobile", "StepFunctions", "StorageGateway", "SystemsManager", "TransferFamily", "WAF", "xray", "cloudwan", "ElasticLoadBalancing", "transitgatewayvpc", "EC2WinSQL"];
