"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.sameEnv = exports.hashcode = void 0;
const cdk = require("aws-cdk-lib");
const helpers_internal_1 = require("aws-cdk-lib/core/lib/helpers-internal");
/**
 * Generates a hash from the provided string for the purposes of avoiding construct ID collision
 * for models with multiple distinct sets of model data.
 * @param s A string for which to generate a hash
 * @returns A hex string representing the hash of the provided string
 */
function hashcode(s) {
    return helpers_internal_1.md5hash(s);
}
exports.hashcode = hashcode;
/**
 * Whether two strings probably contain the same environment attribute (region or account).
 *
 * Used to compare either accounts or regions, and also returns true if both
 * are unresolved (in which case both are expected to be "current region" or "current account").
 * @param attr1 The first attribute to compare
 * @param attr2 The second attribute to compare
 */
function sameEnv(attr1, attr2) {
    return [cdk.TokenComparison.SAME, cdk.TokenComparison.BOTH_UNRESOLVED].includes(cdk.Token.compareStrings(attr1, attr2));
}
exports.sameEnv = sameEnv;
//# sourceMappingURL=data:application/json;base64,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