# -*- coding: utf-8 -*-
from setuptools import setup

package_dir = \
{'': 'src'}

packages = \
['aceye']

package_data = \
{'': ['*'],
 'aceye': ['ARP Adjacency Endpoints/CSV/*',
           'ARP Adjacency Endpoints/HTML/*',
           'ARP Adjacency Endpoints/JSON/*',
           'ARP Adjacency Endpoints/Markdown/*',
           'ARP Adjacency Endpoints/Mindmap/*',
           'ARP Adjacency Endpoints/YAML/*',
           'ARP Database/CSV/*',
           'ARP Database/HTML/*',
           'ARP Database/JSON/*',
           'ARP Database/Markdown/*',
           'ARP Database/Mindmap/*',
           'ARP Database/YAML/*',
           'ARP Domain/CSV/*',
           'ARP Domain/HTML/*',
           'ARP Domain/JSON/*',
           'ARP Domain/Markdown/*',
           'ARP Domain/Mindmap/*',
           'ARP Domain/YAML/*',
           'ARP Entity/CSV/*',
           'ARP Entity/HTML/*',
           'ARP Entity/JSON/*',
           'ARP Entity/Markdown/*',
           'ARP Entity/Mindmap/*',
           'ARP Entity/YAML/*',
           'ARP Instances/CSV/*',
           'ARP Instances/HTML/*',
           'ARP Instances/JSON/*',
           'ARP Instances/Markdown/*',
           'ARP Instances/Mindmap/*',
           'ARP Instances/YAML/*',
           'ARP Interfaces/CSV/*',
           'ARP Interfaces/HTML/*',
           'ARP Interfaces/JSON/*',
           'ARP Interfaces/Markdown/*',
           'ARP Interfaces/Mindmap/*',
           'ARP Interfaces/YAML/*',
           'Access Control Entities/CSV/*',
           'Access Control Entities/HTML/*',
           'Access Control Entities/JSON/*',
           'Access Control Entities/Markdown/*',
           'Access Control Entities/Mindmap/*',
           'Access Control Entities/YAML/*',
           'Access Control Instances/CSV/*',
           'Access Control Instances/HTML/*',
           'Access Control Instances/JSON/*',
           'Access Control Instances/Markdown/*',
           'Access Control Instances/Mindmap/*',
           'Access Control Instances/YAML/*',
           'Access Control Rules/CSV/*',
           'Access Control Rules/HTML/*',
           'Access Control Rules/JSON/*',
           'Access Control Rules/Markdown/*',
           'Access Control Rules/Mindmap/*',
           'Access Control Rules/YAML/*',
           'Access Control Scope/CSV/*',
           'Access Control Scope/HTML/*',
           'Access Control Scope/JSON/*',
           'Access Control Scope/Markdown/*',
           'Access Control Scope/Mindmap/*',
           'Access Control Scope/YAML/*',
           'Application Profiles/CSV/*',
           'Application Profiles/HTML/*',
           'Application Profiles/JSON/*',
           'Application Profiles/Markdown/*',
           'Application Profiles/Mindmap/*',
           'Application Profiles/YAML/*',
           'Attachable Access Entity Profiles/CSV/*',
           'Attachable Access Entity Profiles/HTML/*',
           'Attachable Access Entity Profiles/JSON/*',
           'Attachable Access Entity Profiles/Markdown/*',
           'Attachable Access Entity Profiles/Mindmap/*',
           'Attachable Access Entity Profiles/YAML/*',
           'Audit Log/CSV/*',
           'Audit Log/HTML/*',
           'Audit Log/JSON/*',
           'Audit Log/Markdown/*',
           'Audit Log/Mindmap/*',
           'Audit Log/YAML/*',
           'BGP Domain Address Families/CSV/*',
           'BGP Domain Address Families/HTML/*',
           'BGP Domain Address Families/JSON/*',
           'BGP Domain Address Families/Markdown/*',
           'BGP Domain Address Families/Mindmap/*',
           'BGP Domain Address Families/YAML/*',
           'BGP Domains/CSV/*',
           'BGP Domains/HTML/*',
           'BGP Domains/JSON/*',
           'BGP Domains/Markdown/*',
           'BGP Domains/Mindmap/*',
           'BGP Domains/YAML/*',
           'BGP Entities/CSV/*',
           'BGP Entities/HTML/*',
           'BGP Entities/JSON/*',
           'BGP Entities/Markdown/*',
           'BGP Entities/Mindmap/*',
           'BGP Entities/YAML/*',
           'BGP Instances Policy/CSV/*',
           'BGP Instances Policy/HTML/*',
           'BGP Instances Policy/JSON/*',
           'BGP Instances Policy/Markdown/*',
           'BGP Instances Policy/Mindmap/*',
           'BGP Instances Policy/YAML/*',
           'BGP Instances/CSV/*',
           'BGP Instances/HTML/*',
           'BGP Instances/JSON/*',
           'BGP Instances/Markdown/*',
           'BGP Instances/Mindmap/*',
           'BGP Instances/YAML/*',
           'BGP Peers AF Entries/CSV/*',
           'BGP Peers AF Entries/HTML/*',
           'BGP Peers AF Entries/JSON/*',
           'BGP Peers AF Entries/Markdown/*',
           'BGP Peers AF Entries/Mindmap/*',
           'BGP Peers AF Entries/YAML/*',
           'BGP Peers/CSV/*',
           'BGP Peers/HTML/*',
           'BGP Peers/JSON/*',
           'BGP Peers/Markdown/*',
           'BGP Peers/Mindmap/*',
           'BGP Peers/YAML/*',
           'BGP Route Reflectors/CSV/*',
           'BGP Route Reflectors/HTML/*',
           'BGP Route Reflectors/JSON/*',
           'BGP Route Reflectors/Markdown/*',
           'BGP Route Reflectors/Mindmap/*',
           'BGP Route Reflectors/YAML/*',
           'Bridge Domains/CSV/*',
           'Bridge Domains/HTML/*',
           'Bridge Domains/JSON/*',
           'Bridge Domains/Markdown/*',
           'Bridge Domains/Mindmap/*',
           'Bridge Domains/YAML/*',
           'Cluster Aggregate Interfaces/CSV/*',
           'Cluster Aggregate Interfaces/HTML/*',
           'Cluster Aggregate Interfaces/JSON/*',
           'Cluster Aggregate Interfaces/Markdown/*',
           'Cluster Aggregate Interfaces/Mindmap/*',
           'Cluster Aggregate Interfaces/YAML/*',
           'Cluster Health/CSV/*',
           'Cluster Health/HTML/*',
           'Cluster Health/JSON/*',
           'Cluster Health/Markdown/*',
           'Cluster Health/Mindmap/*',
           'Cluster Health/YAML/*',
           'Cluster Physical Interfaces/CSV/*',
           'Cluster Physical Interfaces/HTML/*',
           'Cluster Physical Interfaces/JSON/*',
           'Cluster Physical Interfaces/Markdown/*',
           'Cluster Physical Interfaces/Mindmap/*',
           'Cluster Physical Interfaces/YAML/*',
           'Compute Controllers/CSV/*',
           'Compute Controllers/HTML/*',
           'Compute Controllers/JSON/*',
           'Compute Controllers/Markdown/*',
           'Compute Controllers/Mindmap/*',
           'Compute Controllers/YAML/*',
           'Compute Domains/CSV/*',
           'Compute Domains/HTML/*',
           'Compute Domains/JSON/*',
           'Compute Domains/Markdown/*',
           'Compute Domains/Mindmap/*',
           'Compute Domains/YAML/*',
           'Compute Endpoint Policy Descriptions/CSV/*',
           'Compute Endpoint Policy Descriptions/HTML/*',
           'Compute Endpoint Policy Descriptions/JSON/*',
           'Compute Endpoint Policy Descriptions/Markdown/*',
           'Compute Endpoint Policy Descriptions/Mindmap/*',
           'Compute Endpoint Policy Descriptions/YAML/*',
           'Compute Providers/CSV/*',
           'Compute Providers/HTML/*',
           'Compute Providers/JSON/*',
           'Compute Providers/Markdown/*',
           'Compute Providers/Mindmap/*',
           'Compute Providers/YAML/*',
           'Contexts/CSV/*',
           'Contexts/HTML/*',
           'Contexts/JSON/*',
           'Contexts/Markdown/*',
           'Contexts/Mindmap/*',
           'Contexts/YAML/*',
           'Contract Subjects/CSV/*',
           'Contract Subjects/HTML/*',
           'Contract Subjects/JSON/*',
           'Contract Subjects/Markdown/*',
           'Contract Subjects/Mindmap/*',
           'Contract Subjects/YAML/*',
           'Contracts/CSV/*',
           'Contracts/HTML/*',
           'Contracts/JSON/*',
           'Contracts/Markdown/*',
           'Contracts/Mindmap/*',
           'Contracts/YAML/*',
           'Device Packages/CSV/*',
           'Device Packages/HTML/*',
           'Device Packages/JSON/*',
           'Device Packages/Markdown/*',
           'Device Packages/Mindmap/*',
           'Device Packages/YAML/*',
           'EPG/CSV/*',
           'EPG/HTML/*',
           'EPG/JSON/*',
           'EPG/Markdown/*',
           'EPG/Mindmap/*',
           'EPG/YAML/*',
           'Endpoints/CSV/*',
           'Endpoints/HTML/*',
           'Endpoints/JSON/*',
           'Endpoints/Markdown/*',
           'Endpoints/Mindmap/*',
           'Endpoints/YAML/*',
           'Events/CSV/*',
           'Events/HTML/*',
           'Events/JSON/*',
           'Events/Markdown/*',
           'Events/Mindmap/*',
           'Events/YAML/*',
           'Fabric Membership/CSV/*',
           'Fabric Membership/HTML/*',
           'Fabric Membership/JSON/*',
           'Fabric Membership/Markdown/*',
           'Fabric Membership/Mindmap/*',
           'Fabric Membership/YAML/*',
           'Fabric Nodes/CSV/*',
           'Fabric Nodes/HTML/*',
           'Fabric Nodes/JSON/*',
           'Fabric Nodes/Markdown/*',
           'Fabric Nodes/Mindmap/*',
           'Fabric Nodes/YAML/*',
           'Fabric Paths/CSV/*',
           'Fabric Paths/HTML/*',
           'Fabric Paths/JSON/*',
           'Fabric Paths/Markdown/*',
           'Fabric Paths/Mindmap/*',
           'Fabric Paths/YAML/*',
           'Fabric Pods/CSV/*',
           'Fabric Pods/HTML/*',
           'Fabric Pods/JSON/*',
           'Fabric Pods/Markdown/*',
           'Fabric Pods/Mindmap/*',
           'Fabric Pods/YAML/*',
           'Fault Summary/CSV/*',
           'Fault Summary/HTML/*',
           'Fault Summary/JSON/*',
           'Fault Summary/Markdown/*',
           'Fault Summary/Mindmap/*',
           'Fault Summary/YAML/*',
           'Filters/CSV/*',
           'Filters/HTML/*',
           'Filters/JSON/*',
           'Filters/Markdown/*',
           'Filters/Mindmap/*',
           'Filters/YAML/*',
           'Health/CSV/*',
           'Health/HTML/*',
           'Health/JSON/*',
           'Health/Markdown/*',
           'Health/Mindmap/*',
           'Health/YAML/*',
           'IP Addresses/CSV/*',
           'IP Addresses/HTML/*',
           'IP Addresses/JSON/*',
           'IP Addresses/Markdown/*',
           'IP Addresses/Mindmap/*',
           'IP Addresses/YAML/*',
           'Interface Policies/CSV/*',
           'Interface Policies/HTML/*',
           'Interface Policies/JSON/*',
           'Interface Policies/Markdown/*',
           'Interface Policies/Mindmap/*',
           'Interface Policies/YAML/*',
           'Interface Profiles/CSV/*',
           'Interface Profiles/HTML/*',
           'Interface Profiles/JSON/*',
           'Interface Profiles/Markdown/*',
           'Interface Profiles/Mindmap/*',
           'Interface Profiles/YAML/*',
           'L2Outs/CSV/*',
           'L2Outs/HTML/*',
           'L2Outs/JSON/*',
           'L2Outs/Markdown/*',
           'L2Outs/Mindmap/*',
           'L2Outs/YAML/*',
           'L3 Domains/CSV/*',
           'L3 Domains/HTML/*',
           'L3 Domains/JSON/*',
           'L3 Domains/Markdown/*',
           'L3 Domains/Mindmap/*',
           'L3 Domains/YAML/*',
           'L3 Interfaces/CSV/*',
           'L3 Interfaces/HTML/*',
           'L3 Interfaces/JSON/*',
           'L3 Interfaces/Markdown/*',
           'L3 Interfaces/Mindmap/*',
           'L3 Interfaces/YAML/*',
           'L3Outs/CSV/*',
           'L3Outs/HTML/*',
           'L3Outs/JSON/*',
           'L3Outs/Markdown/*',
           'L3Outs/Mindmap/*',
           'L3Outs/YAML/*',
           'Leaf Interface Profiles/CSV/*',
           'Leaf Interface Profiles/HTML/*',
           'Leaf Interface Profiles/JSON/*',
           'Leaf Interface Profiles/Markdown/*',
           'Leaf Interface Profiles/Mindmap/*',
           'Leaf Interface Profiles/YAML/*',
           'Leaf Switch Profiles/CSV/*',
           'Leaf Switch Profiles/HTML/*',
           'Leaf Switch Profiles/JSON/*',
           'Leaf Switch Profiles/Markdown/*',
           'Leaf Switch Profiles/Mindmap/*',
           'Leaf Switch Profiles/YAML/*',
           'License Entitlements/CSV/*',
           'License Entitlements/HTML/*',
           'License Entitlements/JSON/*',
           'License Entitlements/Markdown/*',
           'License Entitlements/Mindmap/*',
           'License Entitlements/YAML/*',
           'Physical Domains/CSV/*',
           'Physical Domains/HTML/*',
           'Physical Domains/JSON/*',
           'Physical Domains/Markdown/*',
           'Physical Domains/Mindmap/*',
           'Physical Domains/YAML/*',
           'Physical Interfaces/CSV/*',
           'Physical Interfaces/HTML/*',
           'Physical Interfaces/JSON/*',
           'Physical Interfaces/Markdown/*',
           'Physical Interfaces/Mindmap/*',
           'Physical Interfaces/YAML/*',
           'Prefix List Detailed/CSV/*',
           'Prefix List Detailed/HTML/*',
           'Prefix List Detailed/JSON/*',
           'Prefix List Detailed/Markdown/*',
           'Prefix List Detailed/Mindmap/*',
           'Prefix List Detailed/YAML/*',
           'Prefix List/CSV/*',
           'Prefix List/HTML/*',
           'Prefix List/JSON/*',
           'Prefix List/Markdown/*',
           'Prefix List/Mindmap/*',
           'Prefix List/YAML/*',
           'QOS Classes/CSV/*',
           'QOS Classes/HTML/*',
           'QOS Classes/JSON/*',
           'QOS Classes/Markdown/*',
           'QOS Classes/Mindmap/*',
           'QOS Classes/YAML/*',
           'Security Domains/CSV/*',
           'Security Domains/HTML/*',
           'Security Domains/JSON/*',
           'Security Domains/Markdown/*',
           'Security Domains/Mindmap/*',
           'Security Domains/YAML/*',
           'Spine Interface Profiles/CSV/*',
           'Spine Interface Profiles/HTML/*',
           'Spine Interface Profiles/JSON/*',
           'Spine Interface Profiles/Markdown/*',
           'Spine Interface Profiles/Mindmap/*',
           'Spine Interface Profiles/YAML/*',
           'Spine Switch Profiles/CSV/*',
           'Spine Switch Profiles/HTML/*',
           'Spine Switch Profiles/JSON/*',
           'Spine Switch Profiles/Markdown/*',
           'Spine Switch Profiles/Mindmap/*',
           'Spine Switch Profiles/YAML/*',
           'Subnets/CSV/*',
           'Subnets/HTML/*',
           'Subnets/JSON/*',
           'Subnets/Markdown/*',
           'Subnets/Mindmap/*',
           'Subnets/YAML/*',
           'Tenant Health/CSV/*',
           'Tenant Health/HTML/*',
           'Tenant Health/JSON/*',
           'Tenant Health/Markdown/*',
           'Tenant Health/Mindmap/*',
           'Tenant Health/YAML/*',
           'Tenant/CSV/*',
           'Tenant/HTML/*',
           'Tenant/JSON/*',
           'Tenant/Markdown/*',
           'Tenant/Mindmap/*',
           'Tenant/YAML/*',
           'Top System/CSV/*',
           'Top System/HTML/*',
           'Top System/JSON/*',
           'Top System/Markdown/*',
           'Top System/Mindmap/*',
           'Top System/YAML/*',
           'Users/CSV/*',
           'Users/HTML/*',
           'Users/JSON/*',
           'Users/Markdown/*',
           'Users/Mindmap/*',
           'Users/YAML/*',
           'VLAN Pools/CSV/*',
           'VLAN Pools/HTML/*',
           'VLAN Pools/JSON/*',
           'VLAN Pools/Markdown/*',
           'VLAN Pools/Mindmap/*',
           'VLAN Pools/YAML/*']}

install_requires = \
['Jinja2>=3.1.2,<4.0.0',
 'PyYAML>=6.0,<7.0',
 'requests>=2.28.1,<3.0.0',
 'rich-click>=1.5.1,<2.0.0']

entry_points = \
{'console_scripts': ['aceye = aceye.script:run']}

setup_kwargs = {
    'name': 'aceye',
    'version': '1.1.58',
    'description': 'Business ready documents from Cisco ACI',
    'long_description': '[![published](https://static.production.devnetcloud.com/codeexchange/assets/images/devnet-published.svg)](https://developer.cisco.com/codeexchange/github/repo/automateyournetwork/ACEye)\n\n# ACEye\n\nBusiness Ready Documents for Cisco ACI\n\n## Current API Coverage\n\nAccess Control Entities\n\nAccess Control Instances\n\nAccess Control Rules\n\nAccess Control Scope\n\nApplication Profiles\n\nARP Adjacency Endpoints\n\nARP Database\n\nARP Domain\n\nARP Entity\n\nARP Instances\n\nARP Interfaces\n\nAttachable Access Entity Profiles\n\n*Audit Log\n\nBridge Domains Address Families\n\nBGP Domains\n\nBGP Entities\n\nBGP Instances\n\nBGP Instances Policy\n\nBGP Peers\n\nBGP Peer AF Entries\n\nBGP Route Reflectors\n\nBridge Domains\n\nCluster Aggregate Interfaces\n\nCluster Health\n\nCluster Physical Interfaces\n\nCompute Controllers\n\nCompute Domains\n\nCompute Endpoint Policy Descriptions\n\nCompute Providers\n\nContexts (VRFs)\n\nContracts\n\nContract Subjects\n\nDevice Packages\n\nEndpoints (All Connected Fabric Endpoints)\n\nEPG (Endpoint Groups)\n\n*Events\n\nFabric Membership\n\nFabric Node SSL Certifcates\n\nFabric Nodes\n\nFabric Paths\n\nFabric Pods\n\nFault Summary\n\nFilters\n\nHealth\n\nInterface Policies\n\nInterface Profiles\n\nIP Addresses\n\nLicense Entitlements\n\nL2Outs\n\nL3 Domains\n\nL3 Interfaces\n\nL3Outs\n\nLeaf Interface Profiles\n\nLeaf Switch Profiles\n\nPhysical Domains\n\nPhysical Interfaces\n\nPrefix List\n\nPrefix List Detailed\n\nQOS Classes\n\nSecurity Domains\n\nSpine Interface Profiles\n\nSpine Switch Profiles\n\nSubnets\n\nTenant\n\nTenant Health\n\nTop System\n\nUsers\n\nVLAN Pools\n\n* Both Audit Log and Events are commented out of the base package due to the potentially huge number of records; should you want the Audit Log / Events please uncomment out lines 72-73 (Audit Log) and 76-77 (Events)\n\n\n## Installation\n\n```console\n$ python3 -m venv ACI\n$ source ACI/bin/activate\n(ACI) $ pip install aceye\n```\n\n## Usage - Help\n\n```console\n(ACI) $ aceye --help\n```\n\n![ACEye Help](/images/help.png)\n\n## Usage - In-line\n\n```console\n(ACI) $ aceye --url <url to APIC> --username <APIC username> --password <APIC password>\n```\n\n## Usage - Interactive\n\n```console\n(ACI) $ aceye\nAPIC URL: <URL to APIC>\nAPIC Username: <APIC Username>\nAPIC Password: <APIC Password>\n```\n\n## Usage - Environment Variables\n\n```console\n(ACI) $ export URL=<URL to APIC>\n(ACI) $ export USERNAME=<APIC Username>\n(ACI) $ export PASSWORD=<APIC Password>\n```\n\n## Recommended VS Code Extensions\n\nExcel Viewer - CSV Files\n\nMarkdown Preview - Markdown Files\n\nMarkmap - Mindmap Files\n\nOpen in Default Browser - HTML Files\n\n## Contact\n\nPlease contact John Capobianco if you need any assistance\n',
    'author': 'John Capobianco',
    'author_email': 'ptcapo@gmail.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': None,
    'package_dir': package_dir,
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.8,<4.0',
}


setup(**setup_kwargs)
