"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.AppsyncFunction = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const aws_appsync_1 = require("aws-cdk-lib/aws-appsync");
/**
 * AppSync Functions are local functions that perform certain operations
 * onto a backend data source. Developers can compose operations (Functions)
 * and execute them in sequence with Pipeline Resolvers.
 *
 * @resource AWS::AppSync::FunctionConfiguration
 */
class AppsyncFunction extends aws_cdk_lib_1.Resource {
    constructor(scope, id, props) {
        super(scope, id);
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_appsync_alpha_AppsyncFunctionProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, AppsyncFunction);
            }
            throw error;
        }
        this.function = new aws_appsync_1.CfnFunctionConfiguration(this, 'Resource', {
            name: props.name,
            description: props.description,
            apiId: props.api.apiId,
            dataSourceName: props.dataSource.name,
            functionVersion: '2018-05-29',
            requestMappingTemplate: props.requestMappingTemplate?.renderTemplate(),
            responseMappingTemplate: props.responseMappingTemplate?.renderTemplate(),
        });
        this.functionName = this.function.attrName;
        this.functionArn = this.function.attrFunctionArn;
        this.functionId = this.function.attrFunctionId;
        this.dataSource = props.dataSource;
        this.function.addDependsOn(this.dataSource.ds);
        props.api.addSchemaDependency(this.function);
    }
    /**
     * Import Appsync Function from arn
     */
    static fromAppsyncFunctionAttributes(scope, id, attrs) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_appsync_alpha_AppsyncFunctionAttributes(attrs);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.fromAppsyncFunctionAttributes);
            }
            throw error;
        }
        class Import extends aws_cdk_lib_1.Resource {
            constructor(s, i) {
                super(s, i);
                this.functionId = aws_cdk_lib_1.Lazy.stringValue({
                    produce: () => aws_cdk_lib_1.Fn.select(3, aws_cdk_lib_1.Fn.split('/', attrs.functionArn)),
                });
                this.functionArn = attrs.functionArn;
            }
        }
        return new Import(scope, id);
    }
}
exports.AppsyncFunction = AppsyncFunction;
_a = JSII_RTTI_SYMBOL_1;
AppsyncFunction[_a] = { fqn: "@aws-cdk/aws-appsync-alpha.AppsyncFunction", version: "2.28.0-alpha.0" };
//# sourceMappingURL=data:application/json;base64,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