import * as cdk from '@aws-cdk/core';
import * as cfn_parse from '@aws-cdk/core/lib/cfn-parse';
/**
 * Properties for defining a `AWS::AmazonMQ::Broker`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amazonmq-broker.html
 */
export interface CfnBrokerProps {
    /**
     * `AWS::AmazonMQ::Broker.AutoMinorVersionUpgrade`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amazonmq-broker.html#cfn-amazonmq-broker-autominorversionupgrade
     */
    readonly autoMinorVersionUpgrade: boolean | cdk.IResolvable;
    /**
     * `AWS::AmazonMQ::Broker.BrokerName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amazonmq-broker.html#cfn-amazonmq-broker-brokername
     */
    readonly brokerName: string;
    /**
     * `AWS::AmazonMQ::Broker.DeploymentMode`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amazonmq-broker.html#cfn-amazonmq-broker-deploymentmode
     */
    readonly deploymentMode: string;
    /**
     * `AWS::AmazonMQ::Broker.EngineType`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amazonmq-broker.html#cfn-amazonmq-broker-enginetype
     */
    readonly engineType: string;
    /**
     * `AWS::AmazonMQ::Broker.EngineVersion`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amazonmq-broker.html#cfn-amazonmq-broker-engineversion
     */
    readonly engineVersion: string;
    /**
     * `AWS::AmazonMQ::Broker.HostInstanceType`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amazonmq-broker.html#cfn-amazonmq-broker-hostinstancetype
     */
    readonly hostInstanceType: string;
    /**
     * `AWS::AmazonMQ::Broker.PubliclyAccessible`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amazonmq-broker.html#cfn-amazonmq-broker-publiclyaccessible
     */
    readonly publiclyAccessible: boolean | cdk.IResolvable;
    /**
     * `AWS::AmazonMQ::Broker.Users`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amazonmq-broker.html#cfn-amazonmq-broker-users
     */
    readonly users: Array<CfnBroker.UserProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::AmazonMQ::Broker.AuthenticationStrategy`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amazonmq-broker.html#cfn-amazonmq-broker-authenticationstrategy
     */
    readonly authenticationStrategy?: string;
    /**
     * `AWS::AmazonMQ::Broker.Configuration`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amazonmq-broker.html#cfn-amazonmq-broker-configuration
     */
    readonly configuration?: CfnBroker.ConfigurationIdProperty | cdk.IResolvable;
    /**
     * `AWS::AmazonMQ::Broker.EncryptionOptions`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amazonmq-broker.html#cfn-amazonmq-broker-encryptionoptions
     */
    readonly encryptionOptions?: CfnBroker.EncryptionOptionsProperty | cdk.IResolvable;
    /**
     * `AWS::AmazonMQ::Broker.LdapServerMetadata`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amazonmq-broker.html#cfn-amazonmq-broker-ldapservermetadata
     */
    readonly ldapServerMetadata?: CfnBroker.LdapServerMetadataProperty | cdk.IResolvable;
    /**
     * `AWS::AmazonMQ::Broker.Logs`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amazonmq-broker.html#cfn-amazonmq-broker-logs
     */
    readonly logs?: CfnBroker.LogListProperty | cdk.IResolvable;
    /**
     * `AWS::AmazonMQ::Broker.MaintenanceWindowStartTime`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amazonmq-broker.html#cfn-amazonmq-broker-maintenancewindowstarttime
     */
    readonly maintenanceWindowStartTime?: CfnBroker.MaintenanceWindowProperty | cdk.IResolvable;
    /**
     * `AWS::AmazonMQ::Broker.SecurityGroups`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amazonmq-broker.html#cfn-amazonmq-broker-securitygroups
     */
    readonly securityGroups?: string[];
    /**
     * `AWS::AmazonMQ::Broker.StorageType`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amazonmq-broker.html#cfn-amazonmq-broker-storagetype
     */
    readonly storageType?: string;
    /**
     * `AWS::AmazonMQ::Broker.SubnetIds`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amazonmq-broker.html#cfn-amazonmq-broker-subnetids
     */
    readonly subnetIds?: string[];
    /**
     * `AWS::AmazonMQ::Broker.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amazonmq-broker.html#cfn-amazonmq-broker-tags
     */
    readonly tags?: CfnBroker.TagsEntryProperty[];
}
/**
 * A CloudFormation `AWS::AmazonMQ::Broker`.
 *
 * @external
 * @cloudformationResource AWS::AmazonMQ::Broker
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amazonmq-broker.html
 */
export declare class CfnBroker extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::AmazonMQ::Broker";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnBroker;
    /**
     * @external
     * @cloudformationAttribute AmqpEndpoints
     */
    readonly attrAmqpEndpoints: string[];
    /**
     * @external
     * @cloudformationAttribute Arn
     */
    readonly attrArn: string;
    /**
     * @external
     * @cloudformationAttribute ConfigurationId
     */
    readonly attrConfigurationId: string;
    /**
     * @external
     * @cloudformationAttribute ConfigurationRevision
     */
    readonly attrConfigurationRevision: number;
    /**
     * @external
     * @cloudformationAttribute IpAddresses
     */
    readonly attrIpAddresses: string[];
    /**
     * @external
     * @cloudformationAttribute MqttEndpoints
     */
    readonly attrMqttEndpoints: string[];
    /**
     * @external
     * @cloudformationAttribute OpenWireEndpoints
     */
    readonly attrOpenWireEndpoints: string[];
    /**
     * @external
     * @cloudformationAttribute StompEndpoints
     */
    readonly attrStompEndpoints: string[];
    /**
     * @external
     * @cloudformationAttribute WssEndpoints
     */
    readonly attrWssEndpoints: string[];
    /**
     * `AWS::AmazonMQ::Broker.AutoMinorVersionUpgrade`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amazonmq-broker.html#cfn-amazonmq-broker-autominorversionupgrade
     */
    autoMinorVersionUpgrade: boolean | cdk.IResolvable;
    /**
     * `AWS::AmazonMQ::Broker.BrokerName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amazonmq-broker.html#cfn-amazonmq-broker-brokername
     */
    brokerName: string;
    /**
     * `AWS::AmazonMQ::Broker.DeploymentMode`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amazonmq-broker.html#cfn-amazonmq-broker-deploymentmode
     */
    deploymentMode: string;
    /**
     * `AWS::AmazonMQ::Broker.EngineType`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amazonmq-broker.html#cfn-amazonmq-broker-enginetype
     */
    engineType: string;
    /**
     * `AWS::AmazonMQ::Broker.EngineVersion`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amazonmq-broker.html#cfn-amazonmq-broker-engineversion
     */
    engineVersion: string;
    /**
     * `AWS::AmazonMQ::Broker.HostInstanceType`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amazonmq-broker.html#cfn-amazonmq-broker-hostinstancetype
     */
    hostInstanceType: string;
    /**
     * `AWS::AmazonMQ::Broker.PubliclyAccessible`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amazonmq-broker.html#cfn-amazonmq-broker-publiclyaccessible
     */
    publiclyAccessible: boolean | cdk.IResolvable;
    /**
     * `AWS::AmazonMQ::Broker.Users`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amazonmq-broker.html#cfn-amazonmq-broker-users
     */
    users: Array<CfnBroker.UserProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::AmazonMQ::Broker.AuthenticationStrategy`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amazonmq-broker.html#cfn-amazonmq-broker-authenticationstrategy
     */
    authenticationStrategy: string | undefined;
    /**
     * `AWS::AmazonMQ::Broker.Configuration`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amazonmq-broker.html#cfn-amazonmq-broker-configuration
     */
    configuration: CfnBroker.ConfigurationIdProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::AmazonMQ::Broker.EncryptionOptions`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amazonmq-broker.html#cfn-amazonmq-broker-encryptionoptions
     */
    encryptionOptions: CfnBroker.EncryptionOptionsProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::AmazonMQ::Broker.LdapServerMetadata`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amazonmq-broker.html#cfn-amazonmq-broker-ldapservermetadata
     */
    ldapServerMetadata: CfnBroker.LdapServerMetadataProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::AmazonMQ::Broker.Logs`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amazonmq-broker.html#cfn-amazonmq-broker-logs
     */
    logs: CfnBroker.LogListProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::AmazonMQ::Broker.MaintenanceWindowStartTime`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amazonmq-broker.html#cfn-amazonmq-broker-maintenancewindowstarttime
     */
    maintenanceWindowStartTime: CfnBroker.MaintenanceWindowProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::AmazonMQ::Broker.SecurityGroups`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amazonmq-broker.html#cfn-amazonmq-broker-securitygroups
     */
    securityGroups: string[] | undefined;
    /**
     * `AWS::AmazonMQ::Broker.StorageType`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amazonmq-broker.html#cfn-amazonmq-broker-storagetype
     */
    storageType: string | undefined;
    /**
     * `AWS::AmazonMQ::Broker.SubnetIds`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amazonmq-broker.html#cfn-amazonmq-broker-subnetids
     */
    subnetIds: string[] | undefined;
    /**
     * `AWS::AmazonMQ::Broker.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amazonmq-broker.html#cfn-amazonmq-broker-tags
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::AmazonMQ::Broker`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnBrokerProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @external
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::AmazonMQ::Broker`.
 *
 * @external
 * @cloudformationResource AWS::AmazonMQ::Broker
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amazonmq-broker.html
 */
export declare namespace CfnBroker {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amazonmq-broker-configurationid.html
     */
    interface ConfigurationIdProperty {
        /**
         * `CfnBroker.ConfigurationIdProperty.Id`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amazonmq-broker-configurationid.html#cfn-amazonmq-broker-configurationid-id
         */
        readonly id: string;
        /**
         * `CfnBroker.ConfigurationIdProperty.Revision`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amazonmq-broker-configurationid.html#cfn-amazonmq-broker-configurationid-revision
         */
        readonly revision: number;
    }
}
/**
 * A CloudFormation `AWS::AmazonMQ::Broker`.
 *
 * @external
 * @cloudformationResource AWS::AmazonMQ::Broker
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amazonmq-broker.html
 */
export declare namespace CfnBroker {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amazonmq-broker-encryptionoptions.html
     */
    interface EncryptionOptionsProperty {
        /**
         * `CfnBroker.EncryptionOptionsProperty.KmsKeyId`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amazonmq-broker-encryptionoptions.html#cfn-amazonmq-broker-encryptionoptions-kmskeyid
         */
        readonly kmsKeyId?: string;
        /**
         * `CfnBroker.EncryptionOptionsProperty.UseAwsOwnedKey`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amazonmq-broker-encryptionoptions.html#cfn-amazonmq-broker-encryptionoptions-useawsownedkey
         */
        readonly useAwsOwnedKey: boolean | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::AmazonMQ::Broker`.
 *
 * @external
 * @cloudformationResource AWS::AmazonMQ::Broker
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amazonmq-broker.html
 */
export declare namespace CfnBroker {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amazonmq-broker-ldapservermetadata.html
     */
    interface LdapServerMetadataProperty {
        /**
         * `CfnBroker.LdapServerMetadataProperty.Hosts`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amazonmq-broker-ldapservermetadata.html#cfn-amazonmq-broker-ldapservermetadata-hosts
         */
        readonly hosts: string[];
        /**
         * `CfnBroker.LdapServerMetadataProperty.RoleBase`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amazonmq-broker-ldapservermetadata.html#cfn-amazonmq-broker-ldapservermetadata-rolebase
         */
        readonly roleBase: string;
        /**
         * `CfnBroker.LdapServerMetadataProperty.RoleName`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amazonmq-broker-ldapservermetadata.html#cfn-amazonmq-broker-ldapservermetadata-rolename
         */
        readonly roleName?: string;
        /**
         * `CfnBroker.LdapServerMetadataProperty.RoleSearchMatching`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amazonmq-broker-ldapservermetadata.html#cfn-amazonmq-broker-ldapservermetadata-rolesearchmatching
         */
        readonly roleSearchMatching: string;
        /**
         * `CfnBroker.LdapServerMetadataProperty.RoleSearchSubtree`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amazonmq-broker-ldapservermetadata.html#cfn-amazonmq-broker-ldapservermetadata-rolesearchsubtree
         */
        readonly roleSearchSubtree?: boolean | cdk.IResolvable;
        /**
         * `CfnBroker.LdapServerMetadataProperty.ServiceAccountPassword`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amazonmq-broker-ldapservermetadata.html#cfn-amazonmq-broker-ldapservermetadata-serviceaccountpassword
         */
        readonly serviceAccountPassword: string;
        /**
         * `CfnBroker.LdapServerMetadataProperty.ServiceAccountUsername`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amazonmq-broker-ldapservermetadata.html#cfn-amazonmq-broker-ldapservermetadata-serviceaccountusername
         */
        readonly serviceAccountUsername: string;
        /**
         * `CfnBroker.LdapServerMetadataProperty.UserBase`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amazonmq-broker-ldapservermetadata.html#cfn-amazonmq-broker-ldapservermetadata-userbase
         */
        readonly userBase: string;
        /**
         * `CfnBroker.LdapServerMetadataProperty.UserRoleName`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amazonmq-broker-ldapservermetadata.html#cfn-amazonmq-broker-ldapservermetadata-userrolename
         */
        readonly userRoleName?: string;
        /**
         * `CfnBroker.LdapServerMetadataProperty.UserSearchMatching`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amazonmq-broker-ldapservermetadata.html#cfn-amazonmq-broker-ldapservermetadata-usersearchmatching
         */
        readonly userSearchMatching: string;
        /**
         * `CfnBroker.LdapServerMetadataProperty.UserSearchSubtree`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amazonmq-broker-ldapservermetadata.html#cfn-amazonmq-broker-ldapservermetadata-usersearchsubtree
         */
        readonly userSearchSubtree?: boolean | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::AmazonMQ::Broker`.
 *
 * @external
 * @cloudformationResource AWS::AmazonMQ::Broker
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amazonmq-broker.html
 */
export declare namespace CfnBroker {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amazonmq-broker-loglist.html
     */
    interface LogListProperty {
        /**
         * `CfnBroker.LogListProperty.Audit`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amazonmq-broker-loglist.html#cfn-amazonmq-broker-loglist-audit
         */
        readonly audit?: boolean | cdk.IResolvable;
        /**
         * `CfnBroker.LogListProperty.General`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amazonmq-broker-loglist.html#cfn-amazonmq-broker-loglist-general
         */
        readonly general?: boolean | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::AmazonMQ::Broker`.
 *
 * @external
 * @cloudformationResource AWS::AmazonMQ::Broker
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amazonmq-broker.html
 */
export declare namespace CfnBroker {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amazonmq-broker-maintenancewindow.html
     */
    interface MaintenanceWindowProperty {
        /**
         * `CfnBroker.MaintenanceWindowProperty.DayOfWeek`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amazonmq-broker-maintenancewindow.html#cfn-amazonmq-broker-maintenancewindow-dayofweek
         */
        readonly dayOfWeek: string;
        /**
         * `CfnBroker.MaintenanceWindowProperty.TimeOfDay`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amazonmq-broker-maintenancewindow.html#cfn-amazonmq-broker-maintenancewindow-timeofday
         */
        readonly timeOfDay: string;
        /**
         * `CfnBroker.MaintenanceWindowProperty.TimeZone`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amazonmq-broker-maintenancewindow.html#cfn-amazonmq-broker-maintenancewindow-timezone
         */
        readonly timeZone: string;
    }
}
/**
 * A CloudFormation `AWS::AmazonMQ::Broker`.
 *
 * @external
 * @cloudformationResource AWS::AmazonMQ::Broker
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amazonmq-broker.html
 */
export declare namespace CfnBroker {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amazonmq-broker-tagsentry.html
     */
    interface TagsEntryProperty {
        /**
         * `CfnBroker.TagsEntryProperty.Key`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amazonmq-broker-tagsentry.html#cfn-amazonmq-broker-tagsentry-key
         */
        readonly key: string;
        /**
         * `CfnBroker.TagsEntryProperty.Value`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amazonmq-broker-tagsentry.html#cfn-amazonmq-broker-tagsentry-value
         */
        readonly value: string;
    }
}
/**
 * A CloudFormation `AWS::AmazonMQ::Broker`.
 *
 * @external
 * @cloudformationResource AWS::AmazonMQ::Broker
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amazonmq-broker.html
 */
export declare namespace CfnBroker {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amazonmq-broker-user.html
     */
    interface UserProperty {
        /**
         * `CfnBroker.UserProperty.ConsoleAccess`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amazonmq-broker-user.html#cfn-amazonmq-broker-user-consoleaccess
         */
        readonly consoleAccess?: boolean | cdk.IResolvable;
        /**
         * `CfnBroker.UserProperty.Groups`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amazonmq-broker-user.html#cfn-amazonmq-broker-user-groups
         */
        readonly groups?: string[];
        /**
         * `CfnBroker.UserProperty.Password`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amazonmq-broker-user.html#cfn-amazonmq-broker-user-password
         */
        readonly password: string;
        /**
         * `CfnBroker.UserProperty.Username`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amazonmq-broker-user.html#cfn-amazonmq-broker-user-username
         */
        readonly username: string;
    }
}
/**
 * Properties for defining a `AWS::AmazonMQ::Configuration`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amazonmq-configuration.html
 */
export interface CfnConfigurationProps {
    /**
     * `AWS::AmazonMQ::Configuration.Data`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amazonmq-configuration.html#cfn-amazonmq-configuration-data
     */
    readonly data: string;
    /**
     * `AWS::AmazonMQ::Configuration.EngineType`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amazonmq-configuration.html#cfn-amazonmq-configuration-enginetype
     */
    readonly engineType: string;
    /**
     * `AWS::AmazonMQ::Configuration.EngineVersion`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amazonmq-configuration.html#cfn-amazonmq-configuration-engineversion
     */
    readonly engineVersion: string;
    /**
     * `AWS::AmazonMQ::Configuration.Name`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amazonmq-configuration.html#cfn-amazonmq-configuration-name
     */
    readonly name: string;
    /**
     * `AWS::AmazonMQ::Configuration.AuthenticationStrategy`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amazonmq-configuration.html#cfn-amazonmq-configuration-authenticationstrategy
     */
    readonly authenticationStrategy?: string;
    /**
     * `AWS::AmazonMQ::Configuration.Description`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amazonmq-configuration.html#cfn-amazonmq-configuration-description
     */
    readonly description?: string;
    /**
     * `AWS::AmazonMQ::Configuration.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amazonmq-configuration.html#cfn-amazonmq-configuration-tags
     */
    readonly tags?: CfnConfiguration.TagsEntryProperty[];
}
/**
 * A CloudFormation `AWS::AmazonMQ::Configuration`.
 *
 * @external
 * @cloudformationResource AWS::AmazonMQ::Configuration
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amazonmq-configuration.html
 */
export declare class CfnConfiguration extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::AmazonMQ::Configuration";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnConfiguration;
    /**
     * @external
     * @cloudformationAttribute Arn
     */
    readonly attrArn: string;
    /**
     * @external
     * @cloudformationAttribute Id
     */
    readonly attrId: string;
    /**
     * @external
     * @cloudformationAttribute Revision
     */
    readonly attrRevision: number;
    /**
     * `AWS::AmazonMQ::Configuration.Data`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amazonmq-configuration.html#cfn-amazonmq-configuration-data
     */
    data: string;
    /**
     * `AWS::AmazonMQ::Configuration.EngineType`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amazonmq-configuration.html#cfn-amazonmq-configuration-enginetype
     */
    engineType: string;
    /**
     * `AWS::AmazonMQ::Configuration.EngineVersion`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amazonmq-configuration.html#cfn-amazonmq-configuration-engineversion
     */
    engineVersion: string;
    /**
     * `AWS::AmazonMQ::Configuration.Name`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amazonmq-configuration.html#cfn-amazonmq-configuration-name
     */
    name: string;
    /**
     * `AWS::AmazonMQ::Configuration.AuthenticationStrategy`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amazonmq-configuration.html#cfn-amazonmq-configuration-authenticationstrategy
     */
    authenticationStrategy: string | undefined;
    /**
     * `AWS::AmazonMQ::Configuration.Description`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amazonmq-configuration.html#cfn-amazonmq-configuration-description
     */
    description: string | undefined;
    /**
     * `AWS::AmazonMQ::Configuration.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amazonmq-configuration.html#cfn-amazonmq-configuration-tags
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::AmazonMQ::Configuration`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnConfigurationProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @external
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::AmazonMQ::Configuration`.
 *
 * @external
 * @cloudformationResource AWS::AmazonMQ::Configuration
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amazonmq-configuration.html
 */
export declare namespace CfnConfiguration {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amazonmq-configuration-tagsentry.html
     */
    interface TagsEntryProperty {
        /**
         * `CfnConfiguration.TagsEntryProperty.Key`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amazonmq-configuration-tagsentry.html#cfn-amazonmq-configuration-tagsentry-key
         */
        readonly key: string;
        /**
         * `CfnConfiguration.TagsEntryProperty.Value`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amazonmq-configuration-tagsentry.html#cfn-amazonmq-configuration-tagsentry-value
         */
        readonly value: string;
    }
}
/**
 * Properties for defining a `AWS::AmazonMQ::ConfigurationAssociation`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amazonmq-configurationassociation.html
 */
export interface CfnConfigurationAssociationProps {
    /**
     * `AWS::AmazonMQ::ConfigurationAssociation.Broker`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amazonmq-configurationassociation.html#cfn-amazonmq-configurationassociation-broker
     */
    readonly broker: string;
    /**
     * `AWS::AmazonMQ::ConfigurationAssociation.Configuration`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amazonmq-configurationassociation.html#cfn-amazonmq-configurationassociation-configuration
     */
    readonly configuration: CfnConfigurationAssociation.ConfigurationIdProperty | cdk.IResolvable;
}
/**
 * A CloudFormation `AWS::AmazonMQ::ConfigurationAssociation`.
 *
 * @external
 * @cloudformationResource AWS::AmazonMQ::ConfigurationAssociation
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amazonmq-configurationassociation.html
 */
export declare class CfnConfigurationAssociation extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::AmazonMQ::ConfigurationAssociation";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnConfigurationAssociation;
    /**
     * `AWS::AmazonMQ::ConfigurationAssociation.Broker`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amazonmq-configurationassociation.html#cfn-amazonmq-configurationassociation-broker
     */
    broker: string;
    /**
     * `AWS::AmazonMQ::ConfigurationAssociation.Configuration`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amazonmq-configurationassociation.html#cfn-amazonmq-configurationassociation-configuration
     */
    configuration: CfnConfigurationAssociation.ConfigurationIdProperty | cdk.IResolvable;
    /**
     * Create a new `AWS::AmazonMQ::ConfigurationAssociation`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnConfigurationAssociationProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @external
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::AmazonMQ::ConfigurationAssociation`.
 *
 * @external
 * @cloudformationResource AWS::AmazonMQ::ConfigurationAssociation
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amazonmq-configurationassociation.html
 */
export declare namespace CfnConfigurationAssociation {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amazonmq-configurationassociation-configurationid.html
     */
    interface ConfigurationIdProperty {
        /**
         * `CfnConfigurationAssociation.ConfigurationIdProperty.Id`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amazonmq-configurationassociation-configurationid.html#cfn-amazonmq-configurationassociation-configurationid-id
         */
        readonly id: string;
        /**
         * `CfnConfigurationAssociation.ConfigurationIdProperty.Revision`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amazonmq-configurationassociation-configurationid.html#cfn-amazonmq-configurationassociation-configurationid-revision
         */
        readonly revision: number;
    }
}
