'''
  apkg
  ~~~~

  A package manager for Agda.

'''

# ----------------------------------------------------------------------------

import click

from pprint    import pprint
from pony.orm  import *
from pathlib   import Path

from ..config  import ( AGDA_DEFAULTS_PATH
                      , AGDA_DIR_PATH
                      , AGDA_LIBRARIES_PATH
                      , AGDA_PKG_PATH
                      , AGDA_VERSION
                      , DATABASE_FILE_NAME
                      , DATABASE_FILE_PATH
                      , DATABASE_SEARCH_INDEXES_PATH
                      , GITHUB_USER
                      , PACKAGE_SOURCES_PATH
                      , INDEX_REPOSITORY_BRANCH
                      , INDEX_REPOSITORY_NAME
                      , INDEX_REPOSITORY_PATH
                      , INDEX_REPOSITORY_URL
                      , REPO
                      )

from ..service.readLibFile import readLibFile
from ..service.database    import db
from ..service.database    import ( Library
                                  , LibraryVersion
                                  , Keyword
                                  , TestedWith
                                  , Dependency
                                  )

# ----------------------------------------------------------------------------

@db_session
def getLibraries():
  return select(l for l in LibraryVersion if l.installed)[:]

@db_session
def getDefaultLibraries():
  return select(l for l in Library if l.installed and l.default)[:]

@db_session
def writeAgdaDirFiles(debug = False):
  header = "-- File generated by Agda-Pkg\n"
  if debug: click.echo("Updating files for Agda...")
  # libraries file
  libVersions = getLibraries()

  try:
    AGDA_LIBRARIES_PATH.write_text(header + \
      '\n'.join([v.agdaLibFilePath.as_posix() for v in libVersions])+'\n')
    if debug: click.echo(AGDA_LIBRARIES_PATH.as_posix() + " (updated)")
  except Exception as e:
    click.echo(e)

  # defaults file
  defaults = getDefaultLibraries()
  default_libraries = header + '\n'.join( lib.name for lib in defaults) + '\n'
  AGDA_DEFAULTS_PATH.write_text(default_libraries)
  if debug: click.echo(AGDA_DEFAULTS_PATH.as_posix() + " (updated)")
