"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
Definition of the `Arguebuf` format for storing structured argument graphs."""
import builtins
import collections.abc
import google.protobuf.descriptor
import google.protobuf.internal.containers
import google.protobuf.internal.enum_type_wrapper
import google.protobuf.message
import google.protobuf.struct_pb2
import google.protobuf.timestamp_pb2
import sys
import typing

if sys.version_info >= (3, 10):
    import typing as typing_extensions
else:
    import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

class _Support:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _SupportEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_Support.ValueType], builtins.type):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    SUPPORT_DEFAULT: _Support.ValueType  # 0
    SUPPORT_POSITION_TO_KNOW: _Support.ValueType  # 1
    SUPPORT_EXPERT_OPINION: _Support.ValueType  # 2
    SUPPORT_WITNESS_TESTIMONY: _Support.ValueType  # 3
    SUPPORT_POPULAR_OPINION: _Support.ValueType  # 4
    SUPPORT_POPULAR_PRACTICE: _Support.ValueType  # 5
    SUPPORT_EXAMPLE: _Support.ValueType  # 6
    SUPPORT_ANALOGY: _Support.ValueType  # 7
    SUPPORT_PRACTICAL_REASONING_FROM_ANALOGY: _Support.ValueType  # 8
    SUPPORT_COMPOSITION: _Support.ValueType  # 9
    SUPPORT_DIVISION: _Support.ValueType  # 10
    SUPPORT_OPPOSITIONS: _Support.ValueType  # 11
    SUPPORT_RHETORICAL_OPPOSITIONS: _Support.ValueType  # 12
    SUPPORT_ALTERNATIVES: _Support.ValueType  # 13
    SUPPORT_VERBAL_CLASSIFICATION: _Support.ValueType  # 14
    SUPPORT_VERBAL_CLASSIFICATION_DEFINITION: _Support.ValueType  # 15
    SUPPORT_VERBAL_CLASSIFICATION_VAGUENESS: _Support.ValueType  # 16
    SUPPORT_VERBAL_CLASSIFICATION_ARBITRARINESS: _Support.ValueType  # 17
    SUPPORT_INTERACTION_OF_ACT_AND_PERSON: _Support.ValueType  # 18
    SUPPORT_VALUES: _Support.ValueType  # 19
    SUPPORT_POSITIVE_VALUES: _Support.ValueType  # 61
    SUPPORT_NEGATIVE_VALUES: _Support.ValueType  # 62
    SUPPORT_SACRIFICE: _Support.ValueType  # 20
    SUPPORT_THE_GROUP_AND_ITS_MEMBERS: _Support.ValueType  # 21
    SUPPORT_PRACTICAL_REASONING: _Support.ValueType  # 22
    SUPPORT_TWO_PERSON_PRACTICAL_REASONING: _Support.ValueType  # 23
    SUPPORT_WASTE: _Support.ValueType  # 24
    SUPPORT_SUNK_COSTS: _Support.ValueType  # 25
    SUPPORT_IGNORANCE: _Support.ValueType  # 26
    SUPPORT_EPISTEMIC_IGNORANCE: _Support.ValueType  # 27
    SUPPORT_CAUSE_TO_EFFECT: _Support.ValueType  # 28
    SUPPORT_CORRELATION_TO_CAUSE: _Support.ValueType  # 29
    SUPPORT_SIGN: _Support.ValueType  # 30
    SUPPORT_ABDUCTIVE: _Support.ValueType  # 31
    SUPPORT_EVIDENCE_TO_HYPOTHESIS: _Support.ValueType  # 32
    SUPPORT_CONSEQUENCES: _Support.ValueType  # 33
    SUPPORT_POSITIVE_CONSEQUENCES: _Support.ValueType  # 63
    SUPPORT_NEGATIVE_CONSEQUENCES: _Support.ValueType  # 64
    SUPPORT_PRAGMATIC_ALTERNATIVES: _Support.ValueType  # 34
    SUPPORT_THREAT: _Support.ValueType  # 35
    SUPPORT_FEAR_APPEAL: _Support.ValueType  # 36
    SUPPORT_DANGER_APPEAL: _Support.ValueType  # 37
    SUPPORT_NEED_FOR_HELP: _Support.ValueType  # 38
    SUPPORT_DISTRESS: _Support.ValueType  # 39
    SUPPORT_COMMITMENT: _Support.ValueType  # 40
    SUPPORT_ETHOTIC: _Support.ValueType  # 41
    SUPPORT_GENERIC_AD_HOMINEM: _Support.ValueType  # 42
    SUPPORT_PRAGMATIC_INCONSISTENCY: _Support.ValueType  # 43
    SUPPORT_INCONSISTENT_COMMITMENT: _Support.ValueType  # 44
    SUPPORT_CIRCUMSTANTIAL_AD_HOMINEM: _Support.ValueType  # 45
    SUPPORT_BIAS: _Support.ValueType  # 46
    SUPPORT_BIAS_AD_HOMINEM: _Support.ValueType  # 47
    SUPPORT_GRADUALISM: _Support.ValueType  # 48
    SUPPORT_SLIPPERY_SLOPE: _Support.ValueType  # 49
    SUPPORT_PRECEDENT_SLIPPERY_SLOPE: _Support.ValueType  # 50
    SUPPORT_SORITES_SLIPPERY_SLOPE: _Support.ValueType  # 51
    SUPPORT_VERBAL_SLIPPERY_SLOPE: _Support.ValueType  # 52
    SUPPORT_FULL_SLIPPERY_SLOPE: _Support.ValueType  # 53
    SUPPORT_CONSTITUTIVE_RULE_CLAIMS: _Support.ValueType  # 54
    SUPPORT_RULES: _Support.ValueType  # 55
    SUPPORT_EXCEPTIONAL_CASE: _Support.ValueType  # 56
    SUPPORT_PRECEDENT: _Support.ValueType  # 57
    SUPPORT_PLEA_FOR_EXCUSE: _Support.ValueType  # 58
    SUPPORT_PERCEPTION: _Support.ValueType  # 59
    SUPPORT_MEMORY: _Support.ValueType  # 60

class Support(_Support, metaclass=_SupportEnumTypeWrapper):
    """Argumentation schemes for type support.
    Source: Walton, Douglas, Christopher Reed, and Fabrizio Macagno. 2008. Argumentation Schemes. Cambridge University Press.
    """

SUPPORT_DEFAULT: Support.ValueType  # 0
SUPPORT_POSITION_TO_KNOW: Support.ValueType  # 1
SUPPORT_EXPERT_OPINION: Support.ValueType  # 2
SUPPORT_WITNESS_TESTIMONY: Support.ValueType  # 3
SUPPORT_POPULAR_OPINION: Support.ValueType  # 4
SUPPORT_POPULAR_PRACTICE: Support.ValueType  # 5
SUPPORT_EXAMPLE: Support.ValueType  # 6
SUPPORT_ANALOGY: Support.ValueType  # 7
SUPPORT_PRACTICAL_REASONING_FROM_ANALOGY: Support.ValueType  # 8
SUPPORT_COMPOSITION: Support.ValueType  # 9
SUPPORT_DIVISION: Support.ValueType  # 10
SUPPORT_OPPOSITIONS: Support.ValueType  # 11
SUPPORT_RHETORICAL_OPPOSITIONS: Support.ValueType  # 12
SUPPORT_ALTERNATIVES: Support.ValueType  # 13
SUPPORT_VERBAL_CLASSIFICATION: Support.ValueType  # 14
SUPPORT_VERBAL_CLASSIFICATION_DEFINITION: Support.ValueType  # 15
SUPPORT_VERBAL_CLASSIFICATION_VAGUENESS: Support.ValueType  # 16
SUPPORT_VERBAL_CLASSIFICATION_ARBITRARINESS: Support.ValueType  # 17
SUPPORT_INTERACTION_OF_ACT_AND_PERSON: Support.ValueType  # 18
SUPPORT_VALUES: Support.ValueType  # 19
SUPPORT_POSITIVE_VALUES: Support.ValueType  # 61
SUPPORT_NEGATIVE_VALUES: Support.ValueType  # 62
SUPPORT_SACRIFICE: Support.ValueType  # 20
SUPPORT_THE_GROUP_AND_ITS_MEMBERS: Support.ValueType  # 21
SUPPORT_PRACTICAL_REASONING: Support.ValueType  # 22
SUPPORT_TWO_PERSON_PRACTICAL_REASONING: Support.ValueType  # 23
SUPPORT_WASTE: Support.ValueType  # 24
SUPPORT_SUNK_COSTS: Support.ValueType  # 25
SUPPORT_IGNORANCE: Support.ValueType  # 26
SUPPORT_EPISTEMIC_IGNORANCE: Support.ValueType  # 27
SUPPORT_CAUSE_TO_EFFECT: Support.ValueType  # 28
SUPPORT_CORRELATION_TO_CAUSE: Support.ValueType  # 29
SUPPORT_SIGN: Support.ValueType  # 30
SUPPORT_ABDUCTIVE: Support.ValueType  # 31
SUPPORT_EVIDENCE_TO_HYPOTHESIS: Support.ValueType  # 32
SUPPORT_CONSEQUENCES: Support.ValueType  # 33
SUPPORT_POSITIVE_CONSEQUENCES: Support.ValueType  # 63
SUPPORT_NEGATIVE_CONSEQUENCES: Support.ValueType  # 64
SUPPORT_PRAGMATIC_ALTERNATIVES: Support.ValueType  # 34
SUPPORT_THREAT: Support.ValueType  # 35
SUPPORT_FEAR_APPEAL: Support.ValueType  # 36
SUPPORT_DANGER_APPEAL: Support.ValueType  # 37
SUPPORT_NEED_FOR_HELP: Support.ValueType  # 38
SUPPORT_DISTRESS: Support.ValueType  # 39
SUPPORT_COMMITMENT: Support.ValueType  # 40
SUPPORT_ETHOTIC: Support.ValueType  # 41
SUPPORT_GENERIC_AD_HOMINEM: Support.ValueType  # 42
SUPPORT_PRAGMATIC_INCONSISTENCY: Support.ValueType  # 43
SUPPORT_INCONSISTENT_COMMITMENT: Support.ValueType  # 44
SUPPORT_CIRCUMSTANTIAL_AD_HOMINEM: Support.ValueType  # 45
SUPPORT_BIAS: Support.ValueType  # 46
SUPPORT_BIAS_AD_HOMINEM: Support.ValueType  # 47
SUPPORT_GRADUALISM: Support.ValueType  # 48
SUPPORT_SLIPPERY_SLOPE: Support.ValueType  # 49
SUPPORT_PRECEDENT_SLIPPERY_SLOPE: Support.ValueType  # 50
SUPPORT_SORITES_SLIPPERY_SLOPE: Support.ValueType  # 51
SUPPORT_VERBAL_SLIPPERY_SLOPE: Support.ValueType  # 52
SUPPORT_FULL_SLIPPERY_SLOPE: Support.ValueType  # 53
SUPPORT_CONSTITUTIVE_RULE_CLAIMS: Support.ValueType  # 54
SUPPORT_RULES: Support.ValueType  # 55
SUPPORT_EXCEPTIONAL_CASE: Support.ValueType  # 56
SUPPORT_PRECEDENT: Support.ValueType  # 57
SUPPORT_PLEA_FOR_EXCUSE: Support.ValueType  # 58
SUPPORT_PERCEPTION: Support.ValueType  # 59
SUPPORT_MEMORY: Support.ValueType  # 60
global___Support = Support

class _Attack:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _AttackEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_Attack.ValueType], builtins.type):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    ATTACK_DEFAULT: _Attack.ValueType  # 0

class Attack(_Attack, metaclass=_AttackEnumTypeWrapper):
    """Argumentation schemes for type attack."""

ATTACK_DEFAULT: Attack.ValueType  # 0
global___Attack = Attack

class _Preference:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _PreferenceEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_Preference.ValueType], builtins.type):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    PREFERENCE_DEFAULT: _Preference.ValueType  # 0

class Preference(_Preference, metaclass=_PreferenceEnumTypeWrapper):
    """Argumentation schemes for type preference."""

PREFERENCE_DEFAULT: Preference.ValueType  # 0
global___Preference = Preference

class _Rephrase:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _RephraseEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_Rephrase.ValueType], builtins.type):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    REPHRASE_DEFAULT: _Rephrase.ValueType  # 0

class Rephrase(_Rephrase, metaclass=_RephraseEnumTypeWrapper):
    """Argumentation schemes for type rephrase."""

REPHRASE_DEFAULT: Rephrase.ValueType  # 0
global___Rephrase = Rephrase

@typing_extensions.final
class Graph(google.protobuf.message.Message):
    """Main message to store the argument graph.
    Each attribute having of type `map<string, X>` is a dictionary where a unique ID points to a message.
    The ID does not follow a specific format, but we reccomend to use UUIDv1 everywhere.
    An alternative could be to use a counter for each attribute, but this is error prone and not recommended.
    The ID should be treated the same way as a primary key in a database and may be referenced in other places of the argument.
    For instance, edges only store the IDs of connected nodes.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing_extensions.final
    class NodesEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        @property
        def value(self) -> global___Node: ...
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: global___Node | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing_extensions.Literal["value", b"value"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing_extensions.Literal["key", b"key", "value", b"value"]) -> None: ...

    @typing_extensions.final
    class EdgesEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        @property
        def value(self) -> global___Edge: ...
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: global___Edge | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing_extensions.Literal["value", b"value"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing_extensions.Literal["key", b"key", "value", b"value"]) -> None: ...

    @typing_extensions.final
    class ResourcesEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        @property
        def value(self) -> global___Resource: ...
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: global___Resource | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing_extensions.Literal["value", b"value"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing_extensions.Literal["key", b"key", "value", b"value"]) -> None: ...

    @typing_extensions.final
    class ParticipantsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        @property
        def value(self) -> global___Participant: ...
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: global___Participant | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing_extensions.Literal["value", b"value"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing_extensions.Literal["key", b"key", "value", b"value"]) -> None: ...

    @typing_extensions.final
    class AnalystsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        @property
        def value(self) -> global___Analyst: ...
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: global___Analyst | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing_extensions.Literal["value", b"value"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing_extensions.Literal["key", b"key", "value", b"value"]) -> None: ...

    NODES_FIELD_NUMBER: builtins.int
    EDGES_FIELD_NUMBER: builtins.int
    RESOURCES_FIELD_NUMBER: builtins.int
    PARTICIPANTS_FIELD_NUMBER: builtins.int
    ANALYSTS_FIELD_NUMBER: builtins.int
    MAJOR_CLAIM_FIELD_NUMBER: builtins.int
    SCHEMA_VERSION_FIELD_NUMBER: builtins.int
    LIBRARY_VERSION_FIELD_NUMBER: builtins.int
    METADATA_FIELD_NUMBER: builtins.int
    USERDATA_FIELD_NUMBER: builtins.int
    @property
    def nodes(self) -> google.protobuf.internal.containers.MessageMap[builtins.str, global___Node]:
        """Dictionary of atom/scheme nodes."""
    @property
    def edges(self) -> google.protobuf.internal.containers.MessageMap[builtins.str, global___Edge]:
        """Dictionary of edges connecting nodes."""
    @property
    def resources(self) -> google.protobuf.internal.containers.MessageMap[builtins.str, global___Resource]:
        """Dictionary of resources (i.e., source texts) of the argument such as newspaper articles."""
    @property
    def participants(self) -> google.protobuf.internal.containers.MessageMap[builtins.str, global___Participant]:
        """Dictionary of participants (i.e., persons, users) that created the original argument."""
    @property
    def analysts(self) -> google.protobuf.internal.containers.MessageMap[builtins.str, global___Analyst]:
        """Dictionary of analysts/annotators that created the graph-based representation of the original argument."""
    major_claim: builtins.str
    """ID of the atom node being the major claim of the graph."""
    schema_version: builtins.int
    """Version of the protobuf schema. Should be always `1`."""
    library_version: builtins.str
    """Library used for serializing the graph.
    Should be unique accross programming languages (e.g., `arguebuf-python:1.2.0`).
    """
    @property
    def metadata(self) -> global___Metadata:
        """Store programmatic data like creation times."""
    @property
    def userdata(self) -> google.protobuf.struct_pb2.Struct:
        """Store arbitrary data as needed by a user.
        May contain all valid JSON values.
        """
    def __init__(
        self,
        *,
        nodes: collections.abc.Mapping[builtins.str, global___Node] | None = ...,
        edges: collections.abc.Mapping[builtins.str, global___Edge] | None = ...,
        resources: collections.abc.Mapping[builtins.str, global___Resource] | None = ...,
        participants: collections.abc.Mapping[builtins.str, global___Participant] | None = ...,
        analysts: collections.abc.Mapping[builtins.str, global___Analyst] | None = ...,
        major_claim: builtins.str | None = ...,
        schema_version: builtins.int = ...,
        library_version: builtins.str = ...,
        metadata: global___Metadata | None = ...,
        userdata: google.protobuf.struct_pb2.Struct | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["_major_claim", b"_major_claim", "major_claim", b"major_claim", "metadata", b"metadata", "userdata", b"userdata"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["_major_claim", b"_major_claim", "analysts", b"analysts", "edges", b"edges", "library_version", b"library_version", "major_claim", b"major_claim", "metadata", b"metadata", "nodes", b"nodes", "participants", b"participants", "resources", b"resources", "schema_version", b"schema_version", "userdata", b"userdata"]) -> None: ...
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_major_claim", b"_major_claim"]) -> typing_extensions.Literal["major_claim"] | None: ...

global___Graph = Graph

@typing_extensions.final
class Metadata(google.protobuf.message.Message):
    """Store metadata like created/update timestamps.
    It is used as an attribute type by most other messages.
    These attribute should NOT be modified by users directly!
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CREATED_FIELD_NUMBER: builtins.int
    UPDATED_FIELD_NUMBER: builtins.int
    @property
    def created(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Creation time of the element."""
    @property
    def updated(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Update time of the element"""
    def __init__(
        self,
        *,
        created: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        updated: google.protobuf.timestamp_pb2.Timestamp | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["created", b"created", "updated", b"updated"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["created", b"created", "updated", b"updated"]) -> None: ...

global___Metadata = Metadata

@typing_extensions.final
class Resource(google.protobuf.message.Message):
    """A resource is the original source of an argument.
    Examples include newspaper articles, protocols, and essays.
    These may be linked to atom nodes via their `reference` attribute.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    TEXT_FIELD_NUMBER: builtins.int
    TITLE_FIELD_NUMBER: builtins.int
    SOURCE_FIELD_NUMBER: builtins.int
    TIMESTAMP_FIELD_NUMBER: builtins.int
    METADATA_FIELD_NUMBER: builtins.int
    USERDATA_FIELD_NUMBER: builtins.int
    text: builtins.str
    """Plain-text content of the original argument."""
    title: builtins.str
    """Title (if available) of the source."""
    source: builtins.str
    """URL or other unique attribute to find/identify the resource"""
    @property
    def timestamp(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Creation time of the resource."""
    @property
    def metadata(self) -> global___Metadata:
        """Store programmatic data like creation times."""
    @property
    def userdata(self) -> google.protobuf.struct_pb2.Struct:
        """Store arbitrary data as needed by a user.
        May contain all valid JSON values.
        """
    def __init__(
        self,
        *,
        text: builtins.str = ...,
        title: builtins.str | None = ...,
        source: builtins.str | None = ...,
        timestamp: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        metadata: global___Metadata | None = ...,
        userdata: google.protobuf.struct_pb2.Struct | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["_source", b"_source", "_title", b"_title", "metadata", b"metadata", "source", b"source", "timestamp", b"timestamp", "title", b"title", "userdata", b"userdata"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["_source", b"_source", "_title", b"_title", "metadata", b"metadata", "source", b"source", "text", b"text", "timestamp", b"timestamp", "title", b"title", "userdata", b"userdata"]) -> None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_source", b"_source"]) -> typing_extensions.Literal["source"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_title", b"_title"]) -> typing_extensions.Literal["title"] | None: ...

global___Resource = Resource

@typing_extensions.final
class Participant(google.protobuf.message.Message):
    """A participant is a person/user that contributed to the original argument (e.g., an expert providing a statement)."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    USERNAME_FIELD_NUMBER: builtins.int
    EMAIL_FIELD_NUMBER: builtins.int
    URL_FIELD_NUMBER: builtins.int
    LOCATION_FIELD_NUMBER: builtins.int
    DESCRIPTION_FIELD_NUMBER: builtins.int
    METADATA_FIELD_NUMBER: builtins.int
    USERDATA_FIELD_NUMBER: builtins.int
    name: builtins.str
    """Full name."""
    username: builtins.str
    """Optional: username."""
    email: builtins.str
    """Optional: email address."""
    url: builtins.str
    """Optional: link to relevant website."""
    location: builtins.str
    """Optional: relevant place."""
    description: builtins.str
    """Optional: description (e.g., role of a person)."""
    @property
    def metadata(self) -> global___Metadata:
        """Store programmatic data like creation times."""
    @property
    def userdata(self) -> google.protobuf.struct_pb2.Struct:
        """Store arbitrary data as needed by a user.
        May contain all valid JSON values.
        """
    def __init__(
        self,
        *,
        name: builtins.str = ...,
        username: builtins.str | None = ...,
        email: builtins.str | None = ...,
        url: builtins.str | None = ...,
        location: builtins.str | None = ...,
        description: builtins.str | None = ...,
        metadata: global___Metadata | None = ...,
        userdata: google.protobuf.struct_pb2.Struct | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["_description", b"_description", "_email", b"_email", "_location", b"_location", "_url", b"_url", "_username", b"_username", "description", b"description", "email", b"email", "location", b"location", "metadata", b"metadata", "url", b"url", "userdata", b"userdata", "username", b"username"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["_description", b"_description", "_email", b"_email", "_location", b"_location", "_url", b"_url", "_username", b"_username", "description", b"description", "email", b"email", "location", b"location", "metadata", b"metadata", "name", b"name", "url", b"url", "userdata", b"userdata", "username", b"username"]) -> None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_description", b"_description"]) -> typing_extensions.Literal["description"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_email", b"_email"]) -> typing_extensions.Literal["email"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_location", b"_location"]) -> typing_extensions.Literal["location"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_url", b"_url"]) -> typing_extensions.Literal["url"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_username", b"_username"]) -> typing_extensions.Literal["username"] | None: ...

global___Participant = Participant

@typing_extensions.final
class Analyst(google.protobuf.message.Message):
    """Analysts are the persons that transform the textual argument to an argument graph.
    They are also known as annotators.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    EMAIL_FIELD_NUMBER: builtins.int
    USERDATA_FIELD_NUMBER: builtins.int
    name: builtins.str
    """Full name."""
    email: builtins.str
    """Optional: email address."""
    @property
    def userdata(self) -> google.protobuf.struct_pb2.Struct:
        """Store arbitrary data as needed by a user.
        May contain all valid JSON values.
        """
    def __init__(
        self,
        *,
        name: builtins.str = ...,
        email: builtins.str | None = ...,
        userdata: google.protobuf.struct_pb2.Struct | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["_email", b"_email", "email", b"email", "userdata", b"userdata"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["_email", b"_email", "email", b"email", "name", b"name", "userdata", b"userdata"]) -> None: ...
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_email", b"_email"]) -> typing_extensions.Literal["email"] | None: ...

global___Analyst = Analyst

@typing_extensions.final
class Edge(google.protobuf.message.Message):
    """An edge serves as a connection between two nodes."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    SOURCE_FIELD_NUMBER: builtins.int
    TARGET_FIELD_NUMBER: builtins.int
    METADATA_FIELD_NUMBER: builtins.int
    USERDATA_FIELD_NUMBER: builtins.int
    source: builtins.str
    """ID of the source node."""
    target: builtins.str
    """ID of the target node."""
    @property
    def metadata(self) -> global___Metadata:
        """Store programmatic data like creation times."""
    @property
    def userdata(self) -> google.protobuf.struct_pb2.Struct:
        """Store arbitrary data as needed by a user.
        May contain all valid JSON values.
        """
    def __init__(
        self,
        *,
        source: builtins.str = ...,
        target: builtins.str = ...,
        metadata: global___Metadata | None = ...,
        userdata: google.protobuf.struct_pb2.Struct | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["metadata", b"metadata", "userdata", b"userdata"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["metadata", b"metadata", "source", b"source", "target", b"target", "userdata", b"userdata"]) -> None: ...

global___Edge = Edge

@typing_extensions.final
class Node(google.protobuf.message.Message):
    """A node contains the semantic information of the argument."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ATOM_FIELD_NUMBER: builtins.int
    SCHEME_FIELD_NUMBER: builtins.int
    METADATA_FIELD_NUMBER: builtins.int
    USERDATA_FIELD_NUMBER: builtins.int
    @property
    def atom(self) -> global___Atom: ...
    @property
    def scheme(self) -> global___Scheme: ...
    @property
    def metadata(self) -> global___Metadata:
        """Store programmatic data like creation times."""
    @property
    def userdata(self) -> google.protobuf.struct_pb2.Struct:
        """Store arbitrary data as needed by a user.
        May contain all valid JSON values.
        """
    def __init__(
        self,
        *,
        atom: global___Atom | None = ...,
        scheme: global___Scheme | None = ...,
        metadata: global___Metadata | None = ...,
        userdata: google.protobuf.struct_pb2.Struct | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["atom", b"atom", "metadata", b"metadata", "scheme", b"scheme", "type", b"type", "userdata", b"userdata"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["atom", b"atom", "metadata", b"metadata", "scheme", b"scheme", "type", b"type", "userdata", b"userdata"]) -> None: ...
    def WhichOneof(self, oneof_group: typing_extensions.Literal["type", b"type"]) -> typing_extensions.Literal["atom", "scheme"] | None: ...

global___Node = Node

@typing_extensions.final
class Atom(google.protobuf.message.Message):
    """Atom nodes contain textual information and as such parts of the original resource.
    Atoms are also known as `ADUs` or claims/premises in the argumentation domain.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    TEXT_FIELD_NUMBER: builtins.int
    REFERENCE_FIELD_NUMBER: builtins.int
    PARTICIPANT_FIELD_NUMBER: builtins.int
    text: builtins.str
    """Textual content of the argumentative discourse unit (ADU)."""
    @property
    def reference(self) -> global___Reference:
        """Optional: Reference to the related resource."""
    participant: builtins.str
    """Optional: ID of the related participant."""
    def __init__(
        self,
        *,
        text: builtins.str = ...,
        reference: global___Reference | None = ...,
        participant: builtins.str | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["_participant", b"_participant", "participant", b"participant", "reference", b"reference"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["_participant", b"_participant", "participant", b"participant", "reference", b"reference", "text", b"text"]) -> None: ...
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_participant", b"_participant"]) -> typing_extensions.Literal["participant"] | None: ...

global___Atom = Atom

@typing_extensions.final
class Reference(google.protobuf.message.Message):
    """References are used to store links between atom nodes and resources."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    RESOURCE_FIELD_NUMBER: builtins.int
    OFFSET_FIELD_NUMBER: builtins.int
    TEXT_FIELD_NUMBER: builtins.int
    resource: builtins.str
    """Optional: ID of the related resouce."""
    offset: builtins.int
    """Optional: Starting point of the atom's text within the resource's text."""
    text: builtins.str
    """Original text of the related resource used for the atom."""
    def __init__(
        self,
        *,
        resource: builtins.str | None = ...,
        offset: builtins.int | None = ...,
        text: builtins.str = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["_offset", b"_offset", "_resource", b"_resource", "offset", b"offset", "resource", b"resource"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["_offset", b"_offset", "_resource", b"_resource", "offset", b"offset", "resource", b"resource", "text", b"text"]) -> None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_offset", b"_offset"]) -> typing_extensions.Literal["offset"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_resource", b"_resource"]) -> typing_extensions.Literal["resource"] | None: ...

global___Reference = Reference

@typing_extensions.final
class Scheme(google.protobuf.message.Message):
    """Scheme nodes encode the relations between other nodes."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    SUPPORT_FIELD_NUMBER: builtins.int
    ATTACK_FIELD_NUMBER: builtins.int
    PREFERENCE_FIELD_NUMBER: builtins.int
    REPHRASE_FIELD_NUMBER: builtins.int
    PREMISE_DESCRIPTORS_FIELD_NUMBER: builtins.int
    support: global___Support.ValueType
    attack: global___Attack.ValueType
    preference: global___Preference.ValueType
    rephrase: global___Rephrase.ValueType
    @property
    def premise_descriptors(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """List of atom ID's to assign the connected premises to their role in the argumentation scheme.
        Please note: The order of the ID's is important here and should correspond the one found in the underlying literature used for a specific project.
        """
    def __init__(
        self,
        *,
        support: global___Support.ValueType = ...,
        attack: global___Attack.ValueType = ...,
        preference: global___Preference.ValueType = ...,
        rephrase: global___Rephrase.ValueType = ...,
        premise_descriptors: collections.abc.Iterable[builtins.str] | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["attack", b"attack", "preference", b"preference", "rephrase", b"rephrase", "support", b"support", "type", b"type"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["attack", b"attack", "preference", b"preference", "premise_descriptors", b"premise_descriptors", "rephrase", b"rephrase", "support", b"support", "type", b"type"]) -> None: ...
    def WhichOneof(self, oneof_group: typing_extensions.Literal["type", b"type"]) -> typing_extensions.Literal["support", "attack", "preference", "rephrase"] | None: ...

global___Scheme = Scheme
