# Generated by Django 3.1.4 on 2021-01-12 00:25

from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    dependencies = [
        ("eveonline", "0012_index_additions"),
        ("standingssync", "0001_initial-new"),
    ]

    operations = [
        migrations.CreateModel(
            name="EveContact",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("standing", models.FloatField()),
                ("is_war_target", models.BooleanField()),
            ],
        ),
        migrations.CreateModel(
            name="EveEntity",
            fields=[
                ("id", models.PositiveIntegerField(primary_key=True, serialize=False)),
                (
                    "category",
                    models.CharField(
                        choices=[
                            ("AL", "alliance"),
                            ("CO", "corporation"),
                            ("CH", "character"),
                        ],
                        db_index=True,
                        max_length=2,
                    ),
                ),
            ],
        ),
        migrations.CreateModel(
            name="EveWar",
            fields=[
                ("id", models.PositiveIntegerField(primary_key=True, serialize=False)),
                ("declared", models.DateTimeField()),
                (
                    "finished",
                    models.DateTimeField(db_index=True, default=None, null=True),
                ),
                ("is_mutual", models.BooleanField()),
                ("is_open_for_allies", models.BooleanField()),
                ("retracted", models.DateTimeField(default=None, null=True)),
                (
                    "started",
                    models.DateTimeField(db_index=True, default=None, null=True),
                ),
                (
                    "aggressor",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="aggressor_war",
                        to="standingssync.eveentity",
                    ),
                ),
                (
                    "allies",
                    models.ManyToManyField(
                        related_name="ally", to="standingssync.EveEntity"
                    ),
                ),
                (
                    "defender",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="defender_war",
                        to="standingssync.eveentity",
                    ),
                ),
            ],
        ),
        migrations.RenameField(
            model_name="syncedcharacter",
            old_name="character",
            new_name="character_ownership",
        ),
        migrations.RenameField(
            model_name="syncmanager",
            old_name="character",
            new_name="character_ownership",
        ),
        migrations.AlterField(
            model_name="syncedcharacter",
            name="manager",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE,
                related_name="synced_characters",
                to="standingssync.syncmanager",
            ),
        ),
        migrations.AlterField(
            model_name="syncedcharacter",
            name="version_hash",
            field=models.CharField(default="", max_length=32),
        ),
        migrations.AlterField(
            model_name="syncmanager",
            name="alliance",
            field=models.OneToOneField(
                on_delete=django.db.models.deletion.CASCADE,
                primary_key=True,
                related_name="+",
                serialize=False,
                to="eveonline.eveallianceinfo",
            ),
        ),
        migrations.AlterField(
            model_name="syncmanager",
            name="version_hash",
            field=models.CharField(default="", max_length=32),
        ),
        migrations.DeleteModel(
            name="AllianceContact",
        ),
        migrations.AddField(
            model_name="evecontact",
            name="eve_entity",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE,
                related_name="contacts",
                to="standingssync.eveentity",
            ),
        ),
        migrations.AddField(
            model_name="evecontact",
            name="manager",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE,
                related_name="contacts",
                to="standingssync.syncmanager",
            ),
        ),
        migrations.AddConstraint(
            model_name="evecontact",
            constraint=models.UniqueConstraint(
                fields=("manager", "eve_entity"), name="fk_eve_contact"
            ),
        ),
    ]
