"""Add feature model

Revision ID: ce5a475e1888
Revises: 16bd2982f46e
Create Date: 2020-12-19 07:39:35.572972

"""
from alembic import op
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision = "ce5a475e1888"
down_revision = "16bd2982f46e"
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table(
        "features",
        sa.Column("id", sa.Integer(), autoincrement=True, nullable=False),
        sa.Column("key", sa.String(length=200), nullable=True),
        sa.Column("value", sa.String(), nullable=True),
        sa.Column("description", sa.String(), nullable=True),
        sa.Column("arm_id", sa.Integer(), nullable=False),
        sa.ForeignKeyConstraint(
            ["arm_id"],
            ["arms.id"],
        ),
        sa.PrimaryKeyConstraint("id"),
    )
    op.create_index(op.f("ix_features_id"), "features", ["id"], unique=False)
    op.create_index(op.f("ix_features_key"), "features", ["key"], unique=False)
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_index(op.f("ix_features_key"), table_name="features")
    op.drop_index(op.f("ix_features_id"), table_name="features")
    op.drop_table("features")
    # ### end Alembic commands ###
