# arlas-city-api-python
Upload GTFS data

This Python package is automatically generated by the [Swagger Codegen](https://github.com/swagger-api/swagger-codegen) project:

- API version: 0.0.2
- Package version: 1.0.0
- Build package: io.swagger.codegen.languages.PythonClientCodegen
For more information, please visit [http://www.gisaia.com/](http://www.gisaia.com/)

## Requirements.

Python 2.7 and 3.4+

## Installation & Usage
### pip install

If the python package is hosted on Github, you can install directly from Github

```sh
pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git`)

Then import the package:
```python
import arlas_city_api_python 
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import arlas_city_api_python
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python
from __future__ import print_function
import time
import arlas_city_api_python
from arlas_city_api_python.rest import ApiException
from pprint import pprint
# create an instance of the API class
api_instance = arlas_city_api_python.StatusApi()
collection = 'collection_example' # str | Destination collection for the upload.
size = 10 # int | Page Size (optional) (default to 10)
page = 1 # int | Page ID (optional) (default to 1)
pretty = false # bool | Pretty print (optional) (default to false)

try:
    # List of jobs.
    api_response = api_instance.job_list(collection, size=size, page=page, pretty=pretty)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling StatusApi->job_list: %s\n" % e)

```

## Documentation for API Endpoints

All URIs are relative to *http://localhost/arlas_city_server*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*StatusApi* | [**job_list**](docs/StatusApi.md#job_list) | **GET** /status/{collection}/jobs | List of jobs.
*StatusApi* | [**job_status**](docs/StatusApi.md#job_status) | **GET** /status/{collection}/jobs/{id} | Status of a job.
*WriteApi* | [**upload**](docs/WriteApi.md#upload) | **POST** /write/{collection}/_upload | Upload a GTFS archive.


## Documentation For Models

 - [Error](docs/Error.md)
 - [FeedStatistics](docs/FeedStatistics.md)
 - [IssuesDetails](docs/IssuesDetails.md)
 - [Job](docs/Job.md)
 - [JobResource](docs/JobResource.md)
 - [Step](docs/Step.md)
 - [UploadReport](docs/UploadReport.md)
 - [ValidationResults](docs/ValidationResults.md)


## Documentation For Authorization

 All endpoints do not require authorization.


## Author

contact@gisaia.com

