import builtins  # noqa: F401
from files_sdk.api import Api  # noqa: F401
from files_sdk.list_obj import ListObj
from files_sdk.error import (  # noqa: F401
    InvalidParameterError,
    MissingParameterError,
    NotImplementedError,
)


class UserSftpClientUse:
    default_attributes = {
        "id": None,  # int64 - UserSftpClientUse ID
        "sftp_client": None,  # string - The SFTP client used
        "created_at": None,  # date-time - The earliest recorded use of this SFTP client (for this user)
        "updated_at": None,  # date-time - The most recent use of this SFTP client (for this user)
        "user_id": None,  # int64 - ID of the user who performed this access
    }

    def __init__(self, attributes=None, options=None):
        if not isinstance(attributes, dict):
            attributes = {}
        if not isinstance(options, dict):
            options = {}
        self.set_attributes(attributes)
        self.options = options

    def set_attributes(self, attributes):
        for (
            attribute,
            default_value,
        ) in UserSftpClientUse.default_attributes.items():
            value = attributes.get(attribute, default_value)
            setattr(self, attribute, value)

    def get_attributes(self):
        attrs = {
            k: getattr(self, k, None)
            for k in UserSftpClientUse.default_attributes
            if getattr(self, k, None) is not None
        }
        return attrs


# Parameters:
#   user_id - int64 - User ID. If provided, will return uses for this user.
#   cursor - string - Used for pagination.  When a list request has more records available, cursors are provided in the response headers `X-Files-Cursor-Next` and `X-Files-Cursor-Prev`.  Send one of those cursor value here to resume an existing list from the next available record.  Note: many of our SDKs have iterator methods that will automatically handle cursor-based pagination.
#   per_page - int64 - Number of records to show per page.  (Max: 10,000, 1,000 or less is recommended).
def list(params=None, options=None):
    if not isinstance(params, dict):
        params = {}
    if not isinstance(options, dict):
        options = {}
    if "user_id" in params and not isinstance(params["user_id"], int):
        raise InvalidParameterError("Bad parameter: user_id must be an int")
    if "cursor" in params and not isinstance(params["cursor"], str):
        raise InvalidParameterError("Bad parameter: cursor must be an str")
    if "per_page" in params and not isinstance(params["per_page"], int):
        raise InvalidParameterError("Bad parameter: per_page must be an int")
    return ListObj(
        UserSftpClientUse, "GET", "/user_sftp_client_uses", params, options
    )


def all(params=None, options=None):
    list(params, options)


def new(*args, **kwargs):
    return UserSftpClientUse(*args, **kwargs)
