import builtins  # noqa: F401
from files_sdk.api import Api  # noqa: F401
from files_sdk.list_obj import ListObj
from files_sdk.error import (  # noqa: F401
    InvalidParameterError,
    MissingParameterError,
    NotImplementedError,
)


class PartnerSite:
    default_attributes = {
        "partner_id": None,  # int64 - Partner ID
        "partner_name": None,  # string - Partner Name
        "linked_site_id": None,  # int64 - Linked Site ID
        "linked_site_name": None,  # string - Linked Site Name
        "main_site_id": None,  # int64 - Main Site ID
        "main_site_name": None,  # string - Main Site Name
    }

    def __init__(self, attributes=None, options=None):
        if not isinstance(attributes, dict):
            attributes = {}
        if not isinstance(options, dict):
            options = {}
        self.set_attributes(attributes)
        self.options = options

    def set_attributes(self, attributes):
        for attribute, default_value in PartnerSite.default_attributes.items():
            value = attributes.get(attribute, default_value)
            setattr(self, attribute, value)

    def get_attributes(self):
        attrs = {
            k: getattr(self, k, None)
            for k in PartnerSite.default_attributes
            if getattr(self, k, None) is not None
        }
        return attrs


def linkeds(params=None, options=None):
    if not isinstance(params, dict):
        params = {}
    if not isinstance(options, dict):
        options = {}
    response, options = Api.send_request(
        "GET", "/partner_sites/linked_partner_sites", params, options
    )
    return [PartnerSite(entity_data, options) for entity_data in response.data]


# Parameters:
#   cursor - string - Used for pagination.  When a list request has more records available, cursors are provided in the response headers `X-Files-Cursor-Next` and `X-Files-Cursor-Prev`.  Send one of those cursor value here to resume an existing list from the next available record.  Note: many of our SDKs have iterator methods that will automatically handle cursor-based pagination.
#   per_page - int64 - Number of records to show per page.  (Max: 10,000, 1,000 or less is recommended).
def list(params=None, options=None):
    if not isinstance(params, dict):
        params = {}
    if not isinstance(options, dict):
        options = {}
    if "cursor" in params and not isinstance(params["cursor"], str):
        raise InvalidParameterError("Bad parameter: cursor must be an str")
    if "per_page" in params and not isinstance(params["per_page"], int):
        raise InvalidParameterError("Bad parameter: per_page must be an int")
    return ListObj(PartnerSite, "GET", "/partner_sites", params, options)


def all(params=None, options=None):
    list(params, options)


def new(*args, **kwargs):
    return PartnerSite(*args, **kwargs)
