import logging as _logging
import arcgis
from datetime import datetime
from arcgis.features import FeatureSet
from arcgis.mapping import MapImageLayer
from arcgis.geoprocessing import DataFile, LinearUnit, RasterData
from arcgis.geoprocessing._support import _execute_gp_tool

_log = _logging.getLogger(__name__)

_use_async = False


def get_travel_modes(
    gis=None):
    """


Get a list of travel modes that can be used with directions and routing services available in your portal.

Parameters:

gis: Optional, the GIS on which this tool runs. If not specified, the active GIS is used.


Returns the following as a named tuple:
   supported_travel_modes - Supported Travel Modes as a FeatureSet
   default_travel_mode - Default Travel Mode as a str

See https://logistics.arcgis.com/arcgis/rest/directories/arcgisoutput/World/Utilities_GPServer/World_Utilities/GetTravelModes.htm for additional help.
    """
    kwargs = locals()

    param_db = {
        "supported_travel_modes": (FeatureSet, "Supported Travel Modes"),
        "default_travel_mode": (str, "Default Travel Mode"),
    }
    return_values = [
        {"name": "supported_travel_modes", "display_name": "Supported Travel Modes", "type": FeatureSet},
        {"name": "default_travel_mode", "display_name": "Default Travel Mode", "type": str},
    ]

    if gis is None:
        gis = arcgis.env.active_gis

    url = gis.properties.helperServices.routingUtilities.url

    return _execute_gp_tool(gis, "GetTravelModes", kwargs, param_db, return_values, _use_async, url)

get_travel_modes.__annotations__ = {
    'return': tuple}

def get_tool_info(
    service_name='asyncRoute',
    tool_name='FindRoutes',
    gis=None):
    """


Get additional information such as the description of the network dataset used for the analysis and the execution limits for a tool in a geoprocessing service.

Parameters:

   service_name: Service Name (str). Required parameter.  Specify the service name containing the tool. The parameter value should be specified using one of the following keywords that reference a particular geoprocessing service.asyncClosestFacility - The asynchronous geoprocessing service used to perform the closest facility analysis.asyncLocationAllocation - The asynchronous geoprocessing service used to perform the location-allocation analysis.asyncRoute - The asynchronous geoprocessing service used to perform the route analysis.asyncServiceArea - The asynchronous geoprocessing service used to perform the service area analysis.asyncVRP - The asynchronous geoprocessing service used to perform the vehicle routing problem analysis.syncVRP - The synchronous geoprocessing service used to perform the vehicle routing problem analysis.The default value is asyncRoute.
      Choice list:['asyncClosestFacility', 'asyncLocationAllocation', 'asyncODCostMatrix', 'asyncRoute', 'asyncServiceArea', 'asyncVRP', 'syncVRP']

   tool_name: Tool Name (str). Required parameter.  Specify the tool name in the geoprocessing service. The parameter value should be a valid tool name in the geoprocessing service specified by the serviceName parameter. The default value is FindRoutes.
      Choice list:['EditVehicleRoutingProblem', 'FindClosestFacilities', 'FindRoutes', 'GenerateOriginDestinationCostMatrix', 'GenerateServiceAreas', 'SolveLocationAllocation', 'SolveVehicleRoutingProblem']

gis: Optional, the GIS on which this tool runs. If not specified, the active GIS is used.


Returns:
   tool_info - Tool Info as a str

See https://logistics.arcgis.com/arcgis/rest/directories/arcgisoutput/World/Utilities_GPServer/World_Utilities/GetToolInfo.htm for additional help.
    """
    kwargs = locals()

    param_db = {
        "service_name": (str, "serviceName"),
        "tool_name": (str, "toolName"),
        "tool_info": (str, "Tool Info"),
    }
    return_values = [
        {"name": "tool_info", "display_name": "Tool Info", "type": str},
    ]

    if gis is None:
        gis = arcgis.env.active_gis

    url = gis.properties.helperServices.routingUtilities.url
    return _execute_gp_tool(gis, "GetToolInfo", kwargs, param_db, return_values, _use_async, url)

get_tool_info.__annotations__ = {
    'service_name': str,
    'tool_name': str,
    'return': str}