"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.S3ToStepfunctions = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const defaults = require("@aws-solutions-constructs/core");
const aws_eventbridge_stepfunctions_1 = require("@aws-solutions-constructs/aws-eventbridge-stepfunctions");
// Note: To ensure CDKv2 compatibility, keep the import statement for Construct separate
const constructs_1 = require("constructs");
class S3ToStepfunctions extends constructs_1.Construct {
    /**
     * @summary Constructs a new instance of the S3ToStepfunctions class.
     * @param {cdk.App} scope - represents the scope for all the resources.
     * @param {string} id - this is a a scope-unique id.
     * @param {S3ToStepfunctionsProps} props - user provided props for the construct
     * @access public
     */
    constructor(scope, id, props) {
        super(scope, id);
        defaults.CheckProps(props);
        let bucket;
        if (props.deployCloudTrail !== undefined) {
            defaults.printWarning("The deployCloudTrail prop has been deprecated since this construct no longer requires \
      AWS CloudTrail to implement its functionality. This construct no longer creates a CloudTrail in your account.");
        }
        if (!props.existingBucketObj) {
            [this.s3Bucket, this.s3LoggingBucket] = defaults.buildS3Bucket(this, {
                bucketProps: props.bucketProps,
                loggingBucketProps: props.loggingBucketProps,
                logS3AccessLogs: props.logS3AccessLogs
            });
            bucket = this.s3Bucket;
            const cfnBucket = bucket.node.defaultChild;
            cfnBucket.addPropertyOverride('NotificationConfiguration.EventBridgeConfiguration.EventBridgeEnabled', true);
        }
        else {
            bucket = props.existingBucketObj;
        }
        this.s3BucketInterface = bucket;
        let _eventRuleProps = {};
        if (props.eventRuleProps) {
            _eventRuleProps = props.eventRuleProps;
        }
        else {
            // By default the EventBridge Rule will filter any PutObject, POST Object, CopyObject,
            // or CompleteMultipartUpload events for the S3 Bucket
            _eventRuleProps = {
                eventPattern: {
                    source: ['aws.s3'],
                    detailType: ["Object Created"],
                    detail: {
                        bucket: {
                            name: [bucket.bucketName]
                        }
                    }
                }
            };
        }
        const eventbridgeToStepfunctions = new aws_eventbridge_stepfunctions_1.EventbridgeToStepfunctions(this, `${id}-event-rule-step-function-construct`, {
            stateMachineProps: props.stateMachineProps,
            eventRuleProps: _eventRuleProps,
            createCloudWatchAlarms: props.createCloudWatchAlarms,
            logGroupProps: props.logGroupProps
        });
        this.stateMachine = eventbridgeToStepfunctions.stateMachine;
        this.stateMachineLogGroup = eventbridgeToStepfunctions.stateMachineLogGroup;
        this.cloudwatchAlarms = eventbridgeToStepfunctions.cloudwatchAlarms;
    }
}
exports.S3ToStepfunctions = S3ToStepfunctions;
_a = JSII_RTTI_SYMBOL_1;
S3ToStepfunctions[_a] = { fqn: "@aws-solutions-constructs/aws-s3-stepfunctions.S3ToStepfunctions", version: "2.5.0" };
//# sourceMappingURL=data:application/json;base64,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