import * as lambda from '@aws-cdk/aws-lambda';
import * as sqs from '@aws-cdk/aws-sqs';
/**
 * @stability stable
 */
export interface SqsEventSourceProps {
    /**
     * The largest number of records that AWS Lambda will retrieve from your event source at the time of invoking your function.
     *
     * Your function receives an
     * event with all the retrieved records.
     *
     * Valid Range: Minimum value of 1. Maximum value of 10.
     *
     * @default 10
     * @stability stable
     */
    readonly batchSize?: number;
    /**
     * If the SQS event source mapping should be enabled.
     *
     * @default true
     * @stability stable
     */
    readonly enabled?: boolean;
}
/**
 * Use an Amazon SQS queue as an event source for AWS Lambda.
 *
 * @stability stable
 */
export declare class SqsEventSource implements lambda.IEventSource {
    readonly queue: sqs.IQueue;
    private readonly props;
    private _eventSourceMappingId?;
    /**
     * @stability stable
     */
    constructor(queue: sqs.IQueue, props?: SqsEventSourceProps);
    /**
     * Called by `lambda.addEventSource` to allow the event source to bind to this function.
     *
     * @stability stable
     */
    bind(target: lambda.IFunction): void;
    /**
     * The identifier for this EventSourceMapping.
     *
     * @stability stable
     */
    get eventSourceMappingId(): string;
}
