# Generated by Django 3.2.11 on 2022-01-28 18:39

from django.db import migrations, models


class Migration(migrations.Migration):

    dependencies = [
        ("auth", "0012_alter_user_first_name_max_length"),
        ("structures", "0033_fix_notification_type_fuel_alert"),
    ]

    operations = [
        migrations.AddField(
            model_name="notification",
            name="structures",
            field=models.ManyToManyField(
                help_text="Structures this notification is about (if any)",
                related_name="notifications",
                to="structures.Structure",
            ),
        ),
        migrations.AddField(
            model_name="structure",
            name="webhooks",
            field=models.ManyToManyField(
                blank=True,
                default=None,
                help_text="Webhooks for sending notifications to. If any webhook is enabled, these will be used instead of the webhooks defined for the respective owner. If no webhook is enabled the owner's setting will be used. ",
                related_name="structures",
                to="structures.Webhook",
            ),
        ),
        migrations.AlterField(
            model_name="owner",
            name="ping_groups",
            field=models.ManyToManyField(
                blank=True,
                default=None,
                help_text="Groups to be pinged for each notification. ",
                related_name="_structures_owner_ping_groups_+",
                to="auth.Group",
            ),
        ),
        migrations.AlterField(
            model_name="owner",
            name="webhooks",
            field=models.ManyToManyField(
                blank=True,
                default=None,
                help_text="Notifications are sent to these webhooks. ",
                related_name="owners",
                to="structures.Webhook",
            ),
        ),
        migrations.AlterField(
            model_name="structure",
            name="tags",
            field=models.ManyToManyField(
                blank=True,
                default=None,
                help_text="List of tags for this structure. ",
                related_name="structures",
                to="structures.StructureTag",
            ),
        ),
    ]
