# AUTOGENERATED! DO NOT EDIT! File to edit: 01_schema.ipynb (unless otherwise specified).

__all__ = ['get_schema', 'dtype_to_bqtype', 'df_to_bq_schema']

# Cell
#export
import pandas as pd
from dotenv import load_dotenv
load_dotenv()
from google.cloud import bigquery

# Cell


def get_schema(table_id: str) -> list:
    """Get schema given a table_id.
    """
    client = bigquery.Client()
    table = client.get_table(table_id)
    schema = table.schema
    return schema



# Cell


def dtype_to_bqtype(dtype, default_type: str = 'STRING') -> str:
    "Convert from a pandas type to BigQuery type."
    bqtype = default_type
    if dtype == 'int64':
        bqtype = 'INTEGER'
    return bqtype


def df_to_bq_schema(df):
    "Read a pandas DF and return a BigQuery schema for that DF."
    schema = []
    for col, dtype in df.dtypes.iteritems():
        schema.append(bigquery.SchemaField(col, dtype_to_bqtype(dtype)))
    return schema

