# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['arkfunds']

package_data = \
{'': ['*']}

install_requires = \
['pandas>=1.3.0,<2.0.0', 'requests>=2.26.0,<3.0.0']

setup_kwargs = {
    'name': 'arkfunds',
    'version': '0.1.0',
    'description': 'Python library for monitoring Ark Invest funds data.',
    'long_description': '# python-arkfunds\n\npython-arkfunds is a Python library for monitoring Ark Invest funds data.\n\n## Quickstart\n```python\nfrom arkfunds import ETF, Stock\n\n# ARK ETFs\narkk = ETF(\'ARKK\')\n\narkk.profile()\narkk.holdings()\narkk.trades()\narkk.news()\n\narkk.price()\narkk.price_history()\narkk.change()\narkk.changep()\narkk.last_trade()\n\n# Stocks\ntsla = Stock("TSLA")\n\ntsla.profile()\ntsla.fund_ownership()\ntsla.trades()\n```\n\n## Usage: ARK ETFs\n```python\nfrom arkfunds import ETF\narkk = ETF(\'<ark fund symbol>\')\n```\n\n### ETF Profile\n```python\nimport json\nfrom arkfunds import ETF\narkk = ETF(\'ARKK\')\n\nprofile = arkk.profile()\nprint(json.dumps(profile, indent=2))\n\n# Output:\n# [\n#   {\n#     "symbol": "ARKK",\n#     "name": "ARK Innovation ETF",\n#     "description": "ARKK is an actively managed ETF that seeks long-term growth of capital by investing under normal circumstances primarily (at least 65% of its assets) in domestic and foreign equity securities of companies that are relevant to the Fund\'s investment theme of disruptive innovation.",\n#     "fund_type": "Active Equity ETF",\n#     "inception_date": "2014-10-31",\n#     "cusip": "00214Q104",\n#     "isin": "US00214Q1040",\n#     "website": "https://ark-funds.com/arkk"\n#   }\n# ]\n```\n\n### ETF Holdings\n```python\nfrom arkfunds import ETF\narkk = ETF(\'ARKK\')\n\ndf = arkk.holdings()\nprint(df.head(5))\n\n# Output:\n#           date  fund                       company ticker      cusip     shares  market_value  weight  weight_rank\n# 0   2021-07-23  ARKK                     TESLA INC   TSLA  88160R101    3598676  2.336476e+09   10.08            1\n# 1   2021-07-23  ARKK                      ROKU INC   ROKU  77543R102    3243131  1.364223e+09    5.88            2\n# 2   2021-07-23  ARKK            TELADOC HEALTH INC   TDOC  87918A105    8587318  1.312743e+09    5.66            3\n# 3   2021-07-23  ARKK                SQUARE INC - A     SQ  852234103    4626083  1.205511e+09    5.20            4\n# 4   2021-07-23  ARKK         SHOPIFY INC - CLASS A   SHOP  82509L107     717382  1.143571e+09    4.93            5\n```\n\n### ETF Trades\n```python\nfrom arkfunds import ETF\narkk = ETF(\'ARKK\')\n\ndf = arkk.trades()\nprint(df)\n\n# Output:\n#           date  fund direction ticker                                company      cusip   shares  etf_percent\n# 0   2021-07-23  ARKK       Buy      U                     UNITY SOFTWARE INC  91332U101    23749       0.0106\n# 1   2021-07-23  ARKK       Buy   FATE                  FATE THERAPEUTICS INC  31189P102    74121       0.0270\n# 2   2021-07-23  ARKK       Buy   TWTR                            TWITTER INC  90184L102   982205       0.2983\n# 3   2021-07-23  ARKK       Buy   PACB  PACIFIC BIOSCIENCES OF CALIFORNIA INC  69404D108   265173       0.0345\n# 4   2021-07-23  ARKK       Buy   PATH                             UIPATH INC  90364P105    80566       0.0217\n# 5   2021-07-23  ARKK      Sell    TXG                       10X GENOMICS INC  88025U109    19665       0.0155\n# 6   2021-07-23  ARKK      Sell   TWST                  TWIST BIOSCIENCE CORP  90184D100     5672       0.0029\n# 7   2021-07-23  ARKK      Sell  TCEHY                   TENCENT HOLDINGS LTD  88032Q109      134       0.0000\n# 8   2021-07-23  ARKK      Sell   ROKU                               ROKU INC  77543R102    59042       0.1180\n# 9   2021-07-23  ARKK      Sell   PSTG                       PURE STORAGE INC  74624M102      350       0.0000\n# 10  2021-07-23  ARKK      Sell    NVS                            NOVARTIS AG  66987V109      216       0.0001\n# 11  2021-07-23  ARKK      Sell   DOCU                           DOCUSIGN INC  256163106    39242       0.0519\n# 12  2021-07-23  ARKK      Sell   BEKE                        KE HOLDINGS INC  482497104  2033197       0.2549\n```\n\n### ETF News\n```python\nfrom arkfunds import ETF\narkk = ETF(\'ARKK\')\n\ndf = arkk.news()\nprint(df.head(5))\n\n# Output: \n#      id                   datetime related  ...                                            summary                                                url                                              image\n# 0  2101  2021-07-23T08:42:00+00:00    ARKK  ...  One of Cathie Wood\'s ARK Invest funds bought o...  https://247wallst.com/investing/2021/07/23/cat...  https://247wallst.com/wp-content/uploads/2020/...\n# 1  2102  2021-07-23T06:39:00+00:00    ARKK  ...                                                     https://www.gurufocus.com/news/1483143/cra-fin...                                                   \n# 2  2095  2021-07-22T13:42:00+00:00    ARKK  ...  Ark Invest founder and CEO Cathie Wood achieve...  https://www.benzinga.com/news/21/07/22110608/e...  https://cdn.benzinga.com/files/imagecache/og_i...\n# 3  2103  2021-07-22T11:10:00+00:00    ARKK  ...  When it comes to innovation and making your wo...  https://investorplace.com/2021/07/7-best-etfs-...  https://investorplace.com/wp-content/uploads/2...\n# 4  2090  2021-07-22T10:51:00+00:00    ARKK  ...  The coronavirus pandemic is fast becoming one ...  https://www.marketwatch.com/story/biden-says-c...           https://images.mktw.net/im-373488/social\n#\n# [5 rows x 8 columns]                                                 \n```\n\n### ETF Prices\n```python\nfrom arkfunds import ETF\narkk = ETF(\'ARKK\')\n\np = arkk.price()\nprint(p)\n# Output:\n# 122.43\n\nc = arkk.change()\nprint(c)\n# Output:\n# 0.7200012\n\ncp = arkk.changep()\nprint(cp)\n# Output:\n# 0.5915711\n\nlt = arkk.last_trade()\nprint(lt)\n# Output:\n# datetime.datetime(2021, 7, 23, 20, 0)\n\ndf = arkk.price_history(days_back=7, frequency="d")\nprint(df)\n\n# Output: \n#         Date        Open        High         Low       Close   Adj Close    Volume\n# 0 2021-07-19  113.919998  117.580002  113.269997  117.279999  117.279999  11861800\n# 1 2021-07-20  117.510002  121.175003  116.449997  120.760002  120.760002   6707700\n# 2 2021-07-21  120.875000  122.910004  119.980003  122.660004  122.660004   5738200\n# 3 2021-07-22  122.500000  123.419998  121.250000  121.709999  121.709999   4781500\n# 4 2021-07-23  122.000000  122.559998  120.379997  122.430000  122.430000   4383900\n```\n\n## Usage: Stocks\n```python\nfrom arkfunds import Stock\nstock = Stock(\'<symbol>\')\n```\n\n### Stock Profile\n```python\nimport json\nfrom arkfunds import Stock\ntsla = Stock(\'TSLA\')\n\nprofile = tsla.profile()\nprint(json.dumps(profile, indent=2))\n\n# Output:\n# {\n#   "ticker": "TSLA",\n#   "name": "Tesla, Inc.",\n#   "country": "United States",\n#   "industry": "Auto Manufacturers",\n#   "sector": "Consumer Cyclical",\n#   "fullTimeEmployees": 70757,\n#   "summary": "Tesla, Inc. designs, develops, manufactures, leases, and sells electric vehicles, and energy generation and storage systems in the United States, China, and internationally. The company operates in two segments, Automotive, and Energy Generation and Storage. The Automotive segment offers electric vehicles, as well as sells automotive regulatory credits. It provides sedans and sport utility vehicles through direct and used vehicle sales, a network of Tesla Superchargers, and in-app upgrades; and purchase financing and leasing services. This segment is also involved in the provision of non-warranty after-sales vehicle services, sale of used vehicles, retail merchandise, and vehicle insurance, as well as sale of products through its subsidiaries to third party customers; services for electric vehicles through its company-owned service locations, and Tesla mobile service technicians; and vehicle limited warranties and extended service plans. The Energy Generation and Storage segment engages in the design, manufacture, installation, sale, and leasing of solar energy generation and energy storage products, and related services to residential, commercial, and industrial customers and utilities through its website, stores, and galleries, as well as through a network of channel partners. This segment also offers service and repairs to its energy product customers, including under warranty; and various financing options to its solar customers. The company was formerly known as Tesla Motors, Inc. and changed its name to Tesla, Inc. in February 2017. Tesla, Inc. was founded in 2003 and is headquartered in Palo Alto, California.",\n#   "website": "http://www.tesla.com",\n#   "market": "us_market",\n#   "exchange": "NasdaqGS",\n#   "currency": "USD",\n#   "marketCap": 619787255808.0,\n#   "sharesOutstanding": 963329984\n# }\n```\n\n### Stock Fund Ownership\n```python\nfrom arkfunds import Stock\ntsla = Stock(\'TSLA\')\n\ndf = tsla.fund_ownership()\nprint(df)\n\n# Output:\n#          date ticker  fund  weight  weight_rank   shares  market_value\n# 0  2021-07-23   TSLA  ARKK   10.08            1  3598676  2.336476e+09\n# 1  2021-07-23   TSLA  ARKQ   11.02            1   482989  3.135854e+08\n# 2  2021-07-23   TSLA  ARKW   10.10            1   913753  5.932633e+08\n```\n\n### Stock Trades\n```python\nfrom arkfunds import Stock\ntsla = Stock(\'TSLA\')\n\ndf = tsla.trades()\nprint(df)\n\n# Output:\n#           date  fund direction ticker    company      cusip  shares  etf_percent\n# 0   2021-07-07  ARKK       Buy   TSLA  TESLA INC  88160R101  110731       0.2941\n# 1   2021-06-04  ARKK       Buy   TSLA  TESLA INC  88160R101    4977       0.0144\n# 2   2021-06-04  ARKQ       Buy   TSLA  TESLA INC  88160R101    3068       0.0612\n# 3   2021-06-04  ARKW       Buy   TSLA  TESLA INC  88160R101    4718       0.0521\n# 4   2021-05-19  ARKK       Buy   TSLA  TESLA INC  88160R101   43065       0.1220\n# ..         ...   ...       ...    ...        ...        ...     ...          ...\n# 66  2020-09-24  ARKQ       Buy   TSLA  TESLA INC  88160R101    2639       0.1582\n# 67  2020-09-24  ARKW       Buy   TSLA  TESLA INC  88160R101   19794       0.3054\n# 68  2020-09-23  ARKK       Buy   TSLA  TESLA INC  88160R101  142166       0.6770\n# 69  2020-09-23  ARKW       Buy   TSLA  TESLA INC  88160R101   22190       0.3682\n# 70  2020-09-18  ARKK      Sell   TSLA  TESLA INC  88160R101   85200       0.4400\n# \n# [71 rows x 8 columns]\n```\n\n## License\n\nThis project is licensed under the **MIT license**. Feel free to edit and distribute this template as you like.\n\nSee [LICENSE](LICENSE) for more information.\n',
    'author': 'Fredrik Haarstad',
    'author_email': 'codemonkey@zomg.no',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/frefrik/python-arkfunds',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.8,<4.0',
}


setup(**setup_kwargs)
