# Generated by Django 2.1.8 on 2019-07-02 17:18

import cms.models.fields
import django.contrib.postgres.fields
from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('cms', '0022_auto_20180620_1551'),
    ]

    operations = [
        migrations.CreateModel(
            name='AllinkLegacyLink',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('link_object_id', models.IntegerField(help_text='To which object directs the url.', null=True)),
                ('link_model', models.CharField(help_text='Dotted Path to referenced Model', max_length=300, null=True)),
                ('link_url_name', models.CharField(help_text='Name of the App-URL to use.', max_length=64, null=True)),
                ('link_url_kwargs', django.contrib.postgres.fields.ArrayField(base_field=models.CharField(blank=True, max_length=50, null=True), blank=True, help_text='Keyword arguments used to reverse url.', null=True, size=None)),
                ('old', models.CharField(help_text='We strip away the anchor part of the URL as this part is not passed to the server.', max_length=255, unique=True, verbose_name='Old Link')),
                ('overwrite', models.CharField(blank=True, help_text="Overwrites 'New Page', use for special urls that are not listed there", max_length=255, null=True, verbose_name='Overwrite Link')),
                ('active', models.BooleanField(default=True, verbose_name='Active')),
                ('match_subpages', models.BooleanField(default=False, help_text='If True, matches all subpages and redirects them to this link.', verbose_name='Match subpages')),
                ('last_test_result', models.NullBooleanField(default=None, help_text='Was the last automatic test successfull? (True = Yes, False = No, None = Not yet tested)', verbose_name='Result of last test')),
                ('last_test_date', models.DateTimeField(blank=True, null=True, verbose_name='Date of last test')),
                ('redirect_when_logged_out', models.BooleanField(default=False, help_text='If True, current site will not redirect when user is logged in. If False, the page will be redirected.', verbose_name='Redirect when logged out')),
                ('language', models.CharField(choices=[('en', 'English')], default=('en', 'English'), max_length=200, null=True, verbose_name='Language')),
                ('link_apphook_page', cms.models.fields.PageField(help_text='If provided, overrides the external link.', null=True, on_delete=django.db.models.deletion.PROTECT, related_name='allink_legacy_redirect_allinklegacylink_app_legacy_redirects', to='cms.Page', verbose_name='New Apphook-Page')),
                ('link_page', cms.models.fields.PageField(help_text='If provided, overrides the external link and New Apphook-Page.', null=True, on_delete=django.db.models.deletion.PROTECT, to='cms.Page', verbose_name='New Page')),
            ],
            options={
                'verbose_name': 'Legacy Link',
                'verbose_name_plural': 'Legacy Links',
            },
        ),
    ]
