# Generated by Django 2.1.8 on 2019-07-02 17:18

from django.conf import settings
import django.contrib.postgres.fields
from django.db import migrations, models
import django.db.models.deletion
import djangocms_text_ckeditor.fields
import filer.fields.folder
import filer.fields.image


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('filer', '0011_auto_20190418_0137'),
        ('cms', '0022_auto_20180620_1551'),
        migrations.swappable_dependency(settings.FILER_IMAGE_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name='AllinkGalleryImagePlugin',
            fields=[
                ('cmsplugin_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, related_name='allink_gallery_allinkgalleryimageplugin', serialize=False, to='cms.CMSPlugin')),
                ('title', models.CharField(blank=True, max_length=255, null=True, verbose_name='Title')),
                ('text', djangocms_text_ckeditor.fields.HTMLField(blank=True, null=True, verbose_name='Text')),
                ('template', models.CharField(help_text='Choose a template.', max_length=50, verbose_name='Template')),
                ('ratio', models.CharField(blank=True, max_length=50, null=True, verbose_name='Ratio')),
                ('image', filer.fields.image.FilerImageField(on_delete=django.db.models.deletion.PROTECT, to=settings.FILER_IMAGE_MODEL, verbose_name='Image')),
            ],
            options={
                'abstract': False,
            },
            bases=('cms.cmsplugin',),
        ),
        migrations.CreateModel(
            name='AllinkGalleryPlugin',
            fields=[
                ('cmsplugin_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, related_name='allink_gallery_allinkgalleryplugin', serialize=False, to='cms.CMSPlugin')),
                ('template', models.CharField(help_text='Choose a template.', max_length=50, verbose_name='Template')),
                ('ratio', models.CharField(blank=True, max_length=50, null=True, verbose_name='Ratio')),
                ('fullscreen_enabled', models.BooleanField(default=True, help_text='This option enables a fullscreen button for this gallery.', verbose_name='Fullscreen option visible')),
                ('counter_enabled', models.BooleanField(default=False, help_text='This option enables a gallery counter.', verbose_name='Gallery counter visible')),
                ('auto_start_enabled', models.BooleanField(default=True, help_text='This option enables autoplay for this gallery.', verbose_name='Autostart')),
                ('project_css_classes', django.contrib.postgres.fields.ArrayField(base_field=models.CharField(blank=True, max_length=50, null=True), blank=True, null=True, size=None)),
                ('folder', filer.fields.folder.FilerFolderField(blank=True, help_text="All Images (.png, .gif, .jpg, .jpeg) will be used in gallery. If a folder is specified, the child plugin won't be rendered.", null=True, on_delete=django.db.models.deletion.PROTECT, to='filer.Folder')),
            ],
            options={
                'abstract': False,
            },
            bases=('cms.cmsplugin',),
        ),
    ]
