# Generated by Django 2.1.8 on 2019-07-02 17:18

from django.conf import settings
import django.contrib.postgres.fields
from django.db import migrations, models
import django.db.models.deletion
import filer.fields.file
import filer.fields.image


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.FILER_IMAGE_MODEL),
        ('cms', '0022_auto_20180620_1551'),
        ('filer', '0011_auto_20190418_0137'),
    ]

    operations = [
        migrations.CreateModel(
            name='AllinkContentColumnPlugin',
            fields=[
                ('cmsplugin_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, related_name='allink_content_allinkcontentcolumnplugin', serialize=False, to='cms.CMSPlugin')),
                ('title', models.CharField(blank=True, max_length=255, null=True, verbose_name='Title')),
                ('order_mobile', models.IntegerField(blank=True, help_text='Some columns should be ordered differently on mobile devices when columns are stacked vertically. This option allows you to define the position of the this column.<br><br>Note: Columns ordering is ascending (lowest number displayed first)', null=True, verbose_name='Order Mobile')),
                ('alignment_horizontal_mobile', models.CharField(blank=True, choices=[('left', 'Left'), ('center', 'Center'), ('right', 'Right')], help_text='This option overrides the projects default alignment for mobile. (Usually "left")', max_length=50, null=True, verbose_name='Alignment horizontal mobile')),
                ('alignment_horizontal_desktop', models.CharField(blank=True, choices=[('left', 'Left'), ('center', 'Center'), ('right', 'Right')], help_text='This option overrides the projects default alignment for desktop. (Usually "left")', max_length=50, null=True, verbose_name='Alignment horizontal desktop')),
                ('alignment_vertical_desktop', models.CharField(blank=True, choices=[('top', 'Top'), ('middle', 'Middle'), ('bottom', 'Bottom')], help_text='This option overrides the projects default alignment for desktop. (Usually "top")', max_length=50, null=True, verbose_name='Alignment vertical desktop')),
            ],
            options={
                'abstract': False,
            },
            bases=('cms.cmsplugin',),
        ),
        migrations.CreateModel(
            name='AllinkContentPlugin',
            fields=[
                ('title', models.CharField(blank=True, help_text='The section title', max_length=255, null=True, verbose_name='Title')),
                ('title_size', models.CharField(max_length=50, verbose_name='Section Title Size')),
                ('template', models.CharField(help_text='Choose a template.', max_length=50, verbose_name='Template')),
                ('container_enabled', models.BooleanField(default=True, help_text='If checked, an inner container with a maximum width is added', verbose_name='Activate "container"')),
                ('inverted_colors_enabled', models.BooleanField(default=False, help_text='If checked, the predefined inverted text colors are applied (suitable when using a background image/video)', verbose_name='Activate "inverted text colors"')),
                ('overlay_enabled', models.BooleanField(default=False, help_text='If checked, a predefined overlay background gradient/color is applied.<br><strong>Important:</strong> Only applied when used in combination with a background image/video/color', verbose_name='Activate "overlay"')),
                ('bg_color', models.CharField(blank=True, max_length=50, null=True, verbose_name='Set a predefined background color')),
                ('dynamic_height_enabled', models.BooleanField(default=False, help_text='If checked, the section\'s height will grow depending on the height of its children.<br>Note: This option is being ignored when "full height" or "parallax" are enabled.', verbose_name='Activate dynamic height')),
                ('anchor', models.CharField(blank=True, help_text='ID of this content section which can be used for anchor reference from links.<br>Note: Only letters, numbers and hyphen. No spaces or special chars.', max_length=255, verbose_name='ID')),
                ('ignore_in_pdf', models.BooleanField(default=False, help_text='If checked, this content section will be ignored when generting a pdf.', verbose_name='Ignore for pdf export')),
                ('project_css_classes', django.contrib.postgres.fields.ArrayField(base_field=models.CharField(blank=True, max_length=50, null=True), blank=True, null=True, size=None)),
                ('project_on_screen_effect', models.CharField(blank=True, default='default', max_length=50, null=True)),
                ('cmsplugin_ptr', models.OneToOneField(on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, related_name='allink_content_allinkcontentplugin', serialize=False, to='cms.CMSPlugin')),
                ('project_css_spacings_top_bottom', models.CharField(blank=True, help_text='Choose a spacing (top and bottom).', max_length=50, null=True, verbose_name='Spacings')),
                ('project_css_spacings_top', models.CharField(blank=True, help_text='Choose a top spacing.', max_length=50, null=True, verbose_name='Spacings top')),
                ('project_css_spacings_bottom', models.CharField(blank=True, help_text='Choose a bottom spacing.', max_length=50, null=True, verbose_name='Spacings bottom')),
                ('bg_image_outer_container', filer.fields.image.FilerImageField(blank=True, help_text='Optional: Set a background image for the content section.', null=True, on_delete=django.db.models.deletion.PROTECT, related_name='allink_content_allinkcontentplugin_bg_image', to=settings.FILER_IMAGE_MODEL, verbose_name='Background-Image')),
                ('video_file', filer.fields.file.FilerFileField(blank=True, help_text='Recommended video settings:<br><br>Format: mp4<br>Codec: H.264<br>Target Bitrate: 2 (video loads quick and runs smooth)<br>Audio: Not recommended (no audio = smaller file size and less annoyed visitors)<br>File size: Dependent of video length. Generally speaking: Less is more.', null=True, on_delete=django.db.models.deletion.PROTECT, related_name='content_video_file', to='filer.File', verbose_name='Source')),
                ('video_mobile_image', filer.fields.image.FilerImageField(blank=True, help_text='The image that is being displayed on mobile devices instead of the video.', null=True, on_delete=django.db.models.deletion.PROTECT, related_name='content_video_mobile_image', to=settings.FILER_IMAGE_MODEL, verbose_name='Mobile Image')),
                ('video_poster_image', filer.fields.image.FilerImageField(blank=True, help_text='This image is displayed while the video is loading. Ideally, use an <strong>exact screen capture image</strong> of the very first frame of the video for best results.', null=True, on_delete=django.db.models.deletion.PROTECT, related_name='content_video_poster_image', to=settings.FILER_IMAGE_MODEL, verbose_name='Video Start Image')),
            ],
            options={
                'abstract': False,
            },
            bases=('cms.cmsplugin',),
        ),
    ]
