# Generated by Django 2.2.17 on 2021-01-14 09:21

from django.db import migrations
from django.conf import settings
from django.core.exceptions import ObjectDoesNotExist


def forwards_func(apps, schema_editor):
    BasePeople = apps.get_model('people', 'People')
    PeopleTranslation = apps.get_model('people', 'PeopleTranslation')

    for object in BasePeople.objects.all():
        object_translation = PeopleTranslation.objects.get(
            master_id=object.pk,
            language_code=settings.LANGUAGE_CODE
        )
        if object_translation is not None:
            object_translation.country = object.country_old
            object_translation.save()


def backwards_func(apps, schema_editor):
    BasePeople = apps.get_model('people', 'People')
    PeopleTranslation = apps.get_model('people', 'PeopleTranslation')

    for object in BasePeople.objects.all():
        translation = _get_translation(object, PeopleTranslation)
        object.country_old = translation.country
        object.save()   # Note this only calls Model.save()


def _get_translation(object, MyModelTranslation):
    translations = MyModelTranslation.objects.filter(master_id=object.pk)
    try:
        # Try default translation
        return translations.get(language_code=settings.LANGUAGE_CODE)
    except ObjectDoesNotExist:
        try:
            # Try default language
            return translations.get(language_code=settings.PARLER_DEFAULT_LANGUAGE_CODE)
        except ObjectDoesNotExist:
            # Maybe the object was translated only in a specific language?
            # Hope there is a single
            return translations.get()


class Migration(migrations.Migration):

    dependencies = [
        ('people', '0009_peopletranslation_country'),
    ]

    operations = [
        migrations.RunPython(forwards_func, backwards_func),
        migrations.RemoveField(
            model_name='people',
            name='country_old',
        ),
    ]
