# Generated by Django 2.2.16 on 2021-03-10 14:06

import aldryn_translation_tools.models
import allink_core.core.models.fields
import allink_core.core.models.mixins
import cms.models.fields
from django.conf import settings
import django.contrib.postgres.fields
from django.db import migrations, models
import django.db.models.deletion
import django.utils.timezone
import djangocms_text_ckeditor.fields
import filer.fields.image
import model_utils.fields
import parler.models


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('allink_categories', '0003_allinkcategory_logo'),
        ('cms', '0022_auto_20180620_1551'),
        migrations.swappable_dependency(settings.FILER_IMAGE_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name='Partner',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', model_utils.fields.AutoCreatedField(default=django.utils.timezone.now, editable=False, verbose_name='created')),
                ('modified', model_utils.fields.AutoLastModifiedField(default=django.utils.timezone.now, editable=False, verbose_name='modified')),
                ('status', models.IntegerField(choices=[(1, 'active'), (2, 'inactive')], default=1, verbose_name='status')),
                ('sort_order', models.PositiveIntegerField(db_index=True, default=0, editable=False)),
                ('link', models.URLField(blank=True, null=True, verbose_name='Logo Link')),
                ('categories', models.ManyToManyField(blank=True, to='allink_categories.AllinkCategory')),
                ('content_placeholder', cms.models.fields.PlaceholderField(editable=False, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='partner_partner_content_placeholder', slotname='partner_content', to='cms.Placeholder')),
                ('header_placeholder', cms.models.fields.PlaceholderField(editable=False, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='partner_partner_header_placeholder', slotname='partner_header', to='cms.Placeholder')),
                ('internallink', cms.models.fields.PageField(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='cms.Page', verbose_name='Internal Logo Link')),
                ('og_image', filer.fields.image.FilerImageField(blank=True, help_text='og: image is used when shared on Facebook/ Twitter etc. (Min. 1200 x 630 px)<br>Page: 1. fallback is teaser_image, 2. fallback is field allink_config.default_og_image.<br>App: 1. fallback = preview_image 2. fallback is teaser_image, 3. fallback is defined in allink_config.default_og_image.<br>', null=True, on_delete=django.db.models.deletion.PROTECT, related_name='partner_partner_og_image', to=settings.FILER_IMAGE_MODEL, verbose_name='og:Image')),
                ('preview_image', filer.fields.image.FilerImageField(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='partner_partner_preview_image', to=settings.FILER_IMAGE_MODEL, verbose_name='Preview Image')),
                ('teaser_image', filer.fields.image.FilerImageField(blank=True, help_text='Optional field for teaser image. og: properties are used when shared on Facebook/ Twitter etc. (Min. 1200 x 630 px)<br>Also used as "meta" property="og:image"<br>Page: 1. fallback is allink_config.default_og_image.<br>App: 1. fallback = preview_image 2. fallback is defined in allink_config.default_og_image.<br>', null=True, on_delete=django.db.models.deletion.PROTECT, related_name='partner_partner_teaser_image', to=settings.FILER_IMAGE_MODEL, verbose_name='Teaser image')),
            ],
            options={
                'verbose_name': 'Partner',
                'verbose_name_plural': 'Partner',
                'ordering': ('sort_order',),
                'abstract': False,
            },
            bases=(aldryn_translation_tools.models.TranslationHelperMixin, allink_core.core.models.mixins.AllinkTranslatedAutoSlugifyMixin, allink_core.core.models.mixins.AllinkInvalidatePlaceholderCacheMixin, allink_core.core.models.mixins.AllinkMetaTagMixin, allink_core.core.models.mixins.AllinkTeaserMixin, allink_core.core.models.mixins.AllinkDetailMixin, parler.models.TranslatableModelMixin, models.Model),
        ),
        migrations.CreateModel(
            name='PartnerTranslation',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('language_code', models.CharField(db_index=True, max_length=15, verbose_name='Language')),
                ('og_title', models.CharField(blank=True, default='', help_text='title-tag is used when shared on Facebook/ Twitter etc.<br>Also used to overwrite "meta property="og:image.."" and title-tag<br>Page: fallback is field "title" of the page.<br>App: fallback is field "title".', max_length=255, verbose_name='og:title | <title> Tag')),
                ('og_description', models.TextField(blank=True, default='', help_text='Description is used when shared on Facebook/ Twitter etc.<br>Also used to overwrite  "meta" property="og:description" .. and "meta name="description"<br>Page: fallback is field "teaser_description" of the page, if set. Otherwise empty.<br>App: fallback is field "lead", if set. Otherwise empty.', max_length=255, verbose_name='og:description | meta description')),
                ('teaser_title', models.CharField(blank=True, default='', help_text='Page: fallback is field "title" of the page.<br>App: fallback is field "title".', max_length=255, verbose_name='Teaser title')),
                ('teaser_technical_title', models.CharField(blank=True, default='', help_text='Page: no fallback.<br>App: fallback is hardcoded per app in the teaser_dict.', max_length=255, verbose_name='Teaser technical title')),
                ('teaser_description', models.TextField(blank=True, default='', help_text='Page: no fallback.<br>App: fallback is field "lead".Please only use 80 to 120 characters. Best results will be achieved with around 100 characters.', verbose_name='Teaser description')),
                ('teaser_link_text', models.CharField(blank=True, default='', help_text='Page: no fallback.<br>App: fallback is hardcoded per app in the teaser_dict.', max_length=255, verbose_name='Teaser link text')),
                ('teaser_link_url', models.URLField(blank=True, help_text='Provide a valid URL to an external website.', max_length=500, null=True, verbose_name='External link')),
                ('slug', models.SlugField(blank=True, default='', help_text='Leave blank to auto-generate a unique slug.', max_length=255, verbose_name='Slug')),
                ('title', models.CharField(max_length=255)),
                ('lead', djangocms_text_ckeditor.fields.HTMLField(blank=True, help_text='Teaser text that in some cases is used in the list view and/or in the detail view.', null=True, verbose_name='Lead Text')),
                ('master', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='translations', to='partner.Partner')),
            ],
            options={
                'abstract': False,
            },
            bases=(parler.models.TranslatedFieldsModelMixin, models.Model),
        ),
        migrations.CreateModel(
            name='PartnerAppContentPlugin',
            fields=[
                ('manual_filtering', models.CharField(blank=True, max_length=50, null=True)),
                ('manual_ordering', models.CharField(blank=True, max_length=50, null=True)),
                ('template', models.CharField(help_text='Choose a template.', max_length=50, verbose_name='Template')),
                ('category_navigation_enabled', models.BooleanField(default=False, help_text='If checked, a filter navigation with all selected categories is displayed.<br>Please note: A category is only displayed if it contains items.', verbose_name='Show category navigation')),
                ('category_navigation_all', models.BooleanField(default=False, help_text='If checked, a category "all" in filter navigation is displayed.', verbose_name='Show category "all"')),
                ('softpage_enabled', models.BooleanField(default=True, help_text='If checked, the detail view of an entry will be displayed in a "softpage". Otherwise the page will be reloaded.', verbose_name='Show detailed information in Softpage')),
                ('detail_link_enabled', models.BooleanField(default=True, help_text='If checked, a link/button to the detail view will be displayed.', verbose_name='Show detail link')),
                ('items_per_row', models.IntegerField(choices=[(1, 1), (2, 2), (3, 3), (4, 4)], default=3, help_text='Only applied if a "Grid" template has been selected.', verbose_name='Grid items per row')),
                ('paginated_by', models.IntegerField(default=0, help_text='Limit the number of entries (in case of the "load more" pagination type: entries per page). Default is "0" (show all entries)', verbose_name='Max. entries per page')),
                ('pagination_type', models.CharField(choices=[('no', 'None'), ('load', 'Add "Load more"-Button'), ('load_rest', 'Add "Load all"-Button'), ('load_url', 'Add "Custom URL"-Button')], default=('no', 'None'), max_length=50, verbose_name='Pagination Type')),
                ('load_more_button_text', models.CharField(blank=True, help_text='If left blank, a default text will be used. <br>Note: Should the default text be adjusted site-wide, please contact the project manager (such changes can be made on a code level)', max_length=255, null=True, verbose_name='Text for "Load .."-Button')),
                ('detail_link_text', models.CharField(blank=True, help_text='If left blank, a default text will be used.<br>Note: Should the default text be adjusted site-wide, please contact the project manager (such changes can be made on a code level)', max_length=255, null=True, verbose_name='Text for "Detail"-Link')),
                ('project_css_classes', django.contrib.postgres.fields.ArrayField(base_field=models.CharField(blank=True, max_length=50, null=True), blank=True, null=True, size=None)),
                ('cmsplugin_ptr', models.OneToOneField(on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, related_name='partner_partnerappcontentplugin', serialize=False, to='cms.CMSPlugin')),
                ('apphook_page', cms.models.fields.PageField(blank=True, help_text='If provided, this Apphook-Page will be used to generate the detail link.', null=True, on_delete=django.db.models.deletion.PROTECT, to='cms.Page', verbose_name='Apphook Page')),
                ('categories', models.ManyToManyField(blank=True, to='allink_categories.AllinkCategory')),
                ('categories_and', models.ManyToManyField(blank=True, related_name='partner_partnerappcontentplugin_categories_and', to='allink_categories.AllinkCategory')),
                ('category_navigation', models.ManyToManyField(blank=True, help_text='You can explicitly define the categories for the category navigation here. This will override the automatically set of categories (either the one generated from "Filter & Ordering" or "Manual entries")', related_name='partner_partnerappcontentplugin_category_navigation', to='allink_categories.AllinkCategory', verbose_name='Categories for Navigation')),
                ('load_more_internallink', cms.models.fields.PageField(blank=True, help_text='Link for Button Below Items if custom URL is chosen', null=True, on_delete=django.db.models.deletion.CASCADE, related_name='load_more_internallink_partner', to='cms.Page', verbose_name='Custom Load More Link')),
                ('manual_entries', allink_core.core.models.fields.SortedM2MModelField(blank=True, help_text='Select and arrange specific entries, or, leave blank to select all. (If manual entries are selected the category filtering will be applied as well.)', to='partner.Partner')),
            ],
            options={
                'abstract': False,
            },
            bases=('cms.cmsplugin',),
        ),
    ]
