"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.PricingManifest = void 0;
/*! Copyright [Amazon.com](http://amazon.com/), Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0 */
const pricing_manifest_1 = require("../../generated/pricing-manifest");
const utils_1 = require("../../utils");
/** Service pricing manifest namespace */
var PricingManifest;
(function (PricingManifest) {
    /** Set of service slugs */
    PricingManifest.Slugs = new Set(pricing_manifest_1.PRICING_SLUGS);
    /** Record of all services defined in pricing manifest */
    PricingManifest.Services = pricing_manifest_1.PRICING_MANIFEST;
    const _ComparableTermCache = new Map(Object.values(PricingManifest.Services).flatMap((service) => {
        return service.comparableTerms.map((term) => [term, service]);
    }));
    /**
     * Find pricing service definition associated with a given term.
     */
    function findService(term) {
        // check if term is serviceCode
        if (term in PricingManifest.Services) {
            return PricingManifest.Services[term];
        }
        term = utils_1.normalizeComparisonString(term);
        if (_ComparableTermCache.has(term)) {
            return _ComparableTermCache.get(term);
        }
        return;
    }
    PricingManifest.findService = findService;
})(PricingManifest = exports.PricingManifest || (exports.PricingManifest = {}));
//# sourceMappingURL=data:application/json;base64,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