/** @internal */
export declare const AwsServiceMapping: {
    readonly ACMPCA: {
        readonly provider: "AWS";
        readonly pricingServiceCode: "awsCertificateManager";
        readonly assetKey: "certificate_manager";
        readonly drawioShape: "certificate_manager";
    };
    readonly APS: {
        readonly provider: "AWS";
        readonly pricingServiceCode: "amazonManagedServiceForPrometheus";
        readonly assetKey: "aps";
        readonly drawioShape: "managed_service_for_prometheus";
    };
    readonly AccessAnalyzer: {
        readonly provider: "AWS";
        readonly assetKey: "iam";
        readonly drawioShape: "identity_and_access_management";
    };
    readonly AmazonMQ: {
        readonly provider: "AWS";
        readonly pricingServiceCode: "amazonMQ";
        readonly assetKey: "mq";
        readonly drawioShape: "mq";
    };
    readonly Amplify: {
        readonly provider: "AWS";
        readonly pricingServiceCode: "awsAmplify";
        readonly assetKey: "amplify";
        readonly drawioShape: "amplify";
    };
    readonly AmplifyUIBuilder: {
        readonly provider: "AWS";
        readonly pricingServiceCode: "awsAmplify";
        readonly assetKey: "amplify";
        readonly drawioShape: "amplify";
    };
    readonly ApiGateway: {
        readonly provider: "AWS";
        readonly pricingServiceCode: "amazonApiGateway";
        readonly assetKey: "api_gateway";
        readonly drawioShape: "api_gateway";
    };
    readonly ApiGatewayV2: {
        readonly provider: "AWS";
        readonly pricingServiceCode: "amazonApiGateway";
        readonly assetKey: "api_gateway";
        readonly drawioShape: "api_gateway";
    };
    readonly AppConfig: {
        readonly provider: "AWS";
        readonly pricingServiceCode: "awsAppConfig";
        readonly assetKey: "appconfig";
        readonly drawioShape: "app_config";
    };
    readonly AppFlow: {
        readonly provider: "AWS";
        readonly pricingServiceCode: "amazonAppFlow";
        readonly assetKey: "appflow";
        readonly drawioShape: "appflow";
    };
    readonly AppIntegrations: {
        readonly provider: "AWS";
        readonly assetKey: "application_discovery_service";
        readonly drawioShape: "application_discovery_service";
    };
    readonly AppMesh: {
        readonly provider: "AWS";
        readonly assetKey: "app_mesh";
        readonly drawioShape: "app_mesh";
    };
    readonly AppRunner: {
        readonly provider: "AWS";
        readonly pricingServiceCode: "awsAppRunner";
        readonly assetKey: "app_runner";
        readonly drawioShape: "app_runner";
    };
    readonly AppStream: {
        readonly provider: "AWS";
        readonly pricingServiceCode: "amazonAppStream";
        readonly assetKey: "appstream";
        readonly drawioShape: "appstream_20";
    };
    readonly AppSync: {
        readonly provider: "AWS";
        readonly pricingServiceCode: "awsAppSync";
        readonly assetKey: "appsync";
        readonly drawioShape: "appsync";
    };
    readonly ApplicationAutoScaling: {
        readonly provider: "AWS";
        readonly assetKey: "application_auto_scaling";
        readonly drawioShape: "application_auto_scaling";
    };
    readonly ApplicationInsights: {
        readonly provider: "AWS";
        readonly pricingServiceCode: "amazonCloudWatch";
        readonly assetKey: "cloudwatch";
        readonly drawioShape: "cloudwatch";
    };
    readonly Athena: {
        readonly provider: "AWS";
        readonly pricingServiceCode: "amazonAthena";
        readonly assetKey: "athena";
        readonly drawioShape: "athena";
    };
    readonly AuditManager: {
        readonly provider: "AWS";
        readonly assetKey: "audit_manager";
        readonly drawioShape: "audit_manager";
    };
    readonly AutoScaling: {
        readonly provider: "AWS";
        readonly assetKey: "auto_scaling";
        readonly drawioShape: "autoscaling";
    };
    readonly AutoScalingPlans: {
        readonly provider: "AWS";
        readonly assetKey: "auto_scaling";
        readonly drawioShape: "autoscaling";
    };
    readonly Backup: {
        readonly provider: "AWS";
        readonly pricingServiceCode: "awsBackup";
        readonly assetKey: "backup";
        readonly drawioShape: "backup";
    };
    readonly Batch: {
        readonly provider: "AWS";
        readonly assetKey: "batch";
        readonly drawioShape: "batch";
    };
    readonly BillingConductor: {
        readonly provider: "AWS";
        readonly assetKey: "billing_conductor";
    };
    readonly Budgets: {
        readonly provider: "AWS";
        readonly pricingServiceCode: "awsBudgets";
        readonly assetKey: "budgets";
        readonly drawioShape: "budgets";
    };
    readonly CE: {
        readonly provider: "AWS";
        readonly pricingServiceCode: "awsCostExplorer";
        readonly assetKey: "cost_explorer";
        readonly drawioShape: "cost_explorer";
    };
    readonly CUR: {
        readonly provider: "AWS";
        readonly assetKey: "cost_and_usage_report";
        readonly drawioShape: "cost_and_usage_report";
    };
    readonly Cassandra: {
        readonly provider: "AWS";
        readonly assetKey: "keyspaces";
        readonly drawioShape: "keyspaces";
    };
    readonly CertificateManager: {
        readonly provider: "AWS";
        readonly pricingServiceCode: "awsCertificateManager";
        readonly assetKey: "certificate_manager";
        readonly drawioShape: "certificate_manager";
    };
    readonly Chatbot: {
        readonly provider: "AWS";
        readonly assetKey: "chatbot";
        readonly drawioShape: "chatbot";
    };
    readonly Cloud9: {
        readonly provider: "AWS";
        readonly assetKey: "cloud9";
        readonly drawioShape: "cloud9";
    };
    readonly CloudFormation: {
        readonly provider: "AWS";
        readonly pricingServiceCode: "awsCloudFormation";
        readonly assetKey: "cloudformation";
        readonly drawioShape: "cloudformation";
    };
    readonly CloudFront: {
        readonly provider: "AWS";
        readonly pricingServiceCode: "amazonCloudFront";
        readonly assetKey: "cloudfront";
        readonly drawioShape: "cloudfront";
    };
    readonly CloudTrail: {
        readonly provider: "AWS";
        readonly pricingServiceCode: "awsCloudTrail";
        readonly assetKey: "cloudtrail";
        readonly drawioShape: "cloudtrail";
    };
    readonly CloudWatch: {
        readonly provider: "AWS";
        readonly pricingServiceCode: "amazonCloudWatch";
        readonly assetKey: "cloudwatch";
        readonly drawioShape: "cloudwatch";
    };
    readonly CodeArtifact: {
        readonly provider: "AWS";
        readonly pricingServiceCode: "awsCodeArtifact";
        readonly assetKey: "codeartifact";
        readonly drawioShape: "codeartifact";
    };
    readonly CodeBuild: {
        readonly provider: "AWS";
        readonly pricingServiceCode: "awsCodeBuild";
        readonly assetKey: "codebuild";
        readonly drawioShape: "codebuild";
    };
    readonly CodeCommit: {
        readonly provider: "AWS";
        readonly assetKey: "codecommit";
        readonly drawioShape: "codecommit";
    };
    readonly CodeDeploy: {
        readonly provider: "AWS";
        readonly pricingServiceCode: "awsCodeDeploy";
        readonly assetKey: "codedeploy";
        readonly drawioShape: "codedeploy";
    };
    readonly CodeGuruProfiler: {
        readonly provider: "AWS";
        readonly pricingServiceCode: "codeGuruReviewer";
        readonly assetKey: "codeguru";
        readonly drawioShape: "codeguru";
    };
    readonly CodeGuruReviewer: {
        readonly provider: "AWS";
        readonly pricingServiceCode: "codeGuruReviewer";
        readonly assetKey: "codeguru";
        readonly drawioShape: "codeguru";
    };
    readonly CodePipeline: {
        readonly provider: "AWS";
        readonly pricingServiceCode: "awsCodePipeline";
        readonly assetKey: "codepipeline";
        readonly drawioShape: "codepipeline";
    };
    readonly CodeStar: {
        readonly provider: "AWS";
        readonly assetKey: "codestar";
        readonly drawioShape: "codestar";
    };
    readonly CodeStarConnections: {
        readonly provider: "AWS";
        readonly assetKey: "codestar";
        readonly drawioShape: "codestar";
    };
    readonly CodeStarNotifications: {
        readonly provider: "AWS";
        readonly assetKey: "codestar";
        readonly drawioShape: "codestar";
    };
    readonly Cognito: {
        readonly provider: "AWS";
        readonly pricingServiceCode: "amazonCognito";
        readonly assetKey: "cognito";
        readonly drawioShape: "cognito";
    };
    readonly Config: {
        readonly provider: "AWS";
        readonly pricingServiceCode: "awsConfig";
        readonly assetKey: "config";
        readonly drawioShape: "config";
    };
    readonly Connect: {
        readonly provider: "AWS";
        readonly assetKey: "connect";
        readonly drawioShape: "connector";
    };
    readonly ConnectCampaigns: {
        readonly provider: "AWS";
        readonly assetKey: "connect";
        readonly drawioShape: "connector";
    };
    readonly ControlTower: {
        readonly provider: "AWS";
        readonly assetKey: "control_tower";
        readonly drawioShape: "control_tower";
    };
    readonly CustomerProfiles: {
        readonly provider: "AWS";
        readonly assetKey: "connect";
        readonly drawioShape: "connector";
    };
    readonly DAX: {
        readonly provider: "AWS";
        readonly pricingServiceCode: "amazonDynamoDbDaxClusters";
        readonly assetKey: "data_exchange";
        readonly drawioShape: "data_exchange";
    };
    readonly DLM: {
        readonly provider: "AWS";
        readonly pricingServiceCode: "amazonElasticBlockStore";
        readonly assetKey: "ebs";
        readonly drawioShape: "elastic_block_store";
    };
    readonly DMS: {
        readonly provider: "AWS";
        readonly pricingServiceCode: "awsDatabaseMigrationService";
        readonly assetKey: "database_migration_service";
        readonly drawioShape: "database_migration_service";
    };
    readonly DataBrew: {
        readonly provider: "AWS";
        readonly pricingServiceCode: "awsGlueDataBrewInteractiveSessions";
        readonly assetKey: "glue_databrew";
        readonly drawioShape: "glue_databrew";
    };
    readonly DataPipeline: {
        readonly provider: "AWS";
        readonly pricingServiceCode: "awsDataPipeline";
        readonly assetKey: "data_pipeline";
        readonly drawioShape: "data_pipeline";
    };
    readonly DataSync: {
        readonly provider: "AWS";
        readonly pricingServiceCode: "aWSDataSync";
        readonly assetKey: "datasync";
        readonly drawioShape: "datasync";
    };
    readonly Detective: {
        readonly provider: "AWS";
        readonly pricingServiceCode: "amazonDetective";
        readonly assetKey: "detective";
        readonly drawioShape: "detective";
    };
    readonly DevOpsGuru: {
        readonly provider: "AWS";
        readonly pricingServiceCode: "amazonDevOpsGuru";
        readonly assetKey: "devops_guru";
        readonly drawioShape: "devops_guru";
    };
    readonly DeviceFarm: {
        readonly provider: "AWS";
        readonly pricingServiceCode: "awsDeviceFarm";
        readonly assetKey: "device_farm";
        readonly drawioShape: "device_farm";
    };
    readonly DirectoryService: {
        readonly provider: "AWS";
        readonly pricingServiceCode: "aWSDirectoryService";
        readonly assetKey: "directory_service";
        readonly drawioShape: "directory_service";
    };
    readonly DocDB: {
        readonly provider: "AWS";
        readonly pricingServiceCode: "amazonDocumentDB";
        readonly assetKey: "documentdb";
        readonly drawioShape: "documentdb_with_mongodb_compatibility";
    };
    readonly DocDBElastic: {
        readonly provider: "AWS";
    };
    readonly DynamoDB: {
        readonly provider: "AWS";
        readonly pricingServiceCode: "amazonDynamoDb";
        readonly assetKey: "dynamodb";
        readonly drawioShape: "dynamodb";
    };
    readonly EC2: {
        readonly provider: "AWS";
        readonly pricingServiceCode: "ec2Enhancement";
        readonly assetKey: "ec2";
        readonly drawioShape: "ec2";
    };
    readonly ECR: {
        readonly provider: "AWS";
        readonly pricingServiceCode: "amazonElasticContainerRegistry";
        readonly assetKey: "ecr";
        readonly drawioShape: "ecr";
    };
    readonly ECS: {
        readonly provider: "AWS";
        readonly assetKey: "ecs";
        readonly drawioShape: "ecs";
    };
    readonly EFS: {
        readonly provider: "AWS";
        readonly pricingServiceCode: "amazonEFS";
        readonly assetKey: "efs";
        readonly drawioShape: "efs_infrequentaccess";
    };
    readonly EKS: {
        readonly provider: "AWS";
        readonly pricingServiceCode: "awsEks";
        readonly assetKey: "eks";
        readonly drawioShape: "eks";
    };
    readonly EMR: {
        readonly provider: "AWS";
        readonly pricingServiceCode: "amazonEMR";
        readonly assetKey: "emr";
        readonly drawioShape: "emr";
    };
    readonly EMRContainers: {
        readonly provider: "AWS";
        readonly pricingServiceCode: "amazonEMR";
        readonly assetKey: "emr";
        readonly drawioShape: "emr";
    };
    readonly EMRServerless: {
        readonly provider: "AWS";
        readonly pricingServiceCode: "amazonEmrServerless";
        readonly assetKey: "emr";
        readonly drawioShape: "emr";
    };
    readonly ElastiCache: {
        readonly provider: "AWS";
        readonly pricingServiceCode: "amazonElastiCache";
        readonly assetKey: "elasticache";
        readonly drawioShape: "elasticache";
    };
    readonly ElasticBeanstalk: {
        readonly provider: "AWS";
        readonly assetKey: "elastic_beanstalk";
        readonly drawioShape: "elastic_beanstalk";
    };
    readonly ElasticLoadBalancing: {
        readonly provider: "AWS";
        readonly pricingServiceCode: "elasticLoadBalancing";
        readonly assetKey: "elastic_load_balancing";
        readonly drawioShape: "elastic_load_balancing";
    };
    readonly ElasticLoadBalancingV2: {
        readonly provider: "AWS";
        readonly pricingServiceCode: "elasticLoadBalancing";
        readonly assetKey: "elastic_load_balancing";
        readonly drawioShape: "elastic_load_balancing";
    };
    readonly Elasticsearch: {
        readonly provider: "AWS";
        readonly pricingServiceCode: "amazonElasticsearchService";
        readonly assetKey: "opensearch";
        readonly drawioShape: "elasticsearch_service";
    };
    readonly EventSchemas: {
        readonly provider: "AWS";
        readonly pricingServiceCode: "amazonEventBridge";
        readonly assetKey: "eventbridge";
        readonly drawioShape: "eventbridge";
    };
    readonly Events: {
        readonly provider: "AWS";
        readonly pricingServiceCode: "amazonEventBridge";
        readonly assetKey: "eventbridge";
        readonly drawioShape: "eventbridge";
    };
    readonly Evidently: {
        readonly provider: "AWS";
        readonly pricingServiceCode: "amazonCloudWatch";
        readonly assetKey: "cloudwatch";
        readonly drawioShape: "cloudwatch";
    };
    readonly FIS: {
        readonly provider: "AWS";
        readonly assetKey: "fault_injection_simulator";
        readonly drawioShape: "fault_injection_simulator";
    };
    readonly FMS: {
        readonly provider: "AWS";
        readonly pricingServiceCode: "amazonNetworkFirewall";
        readonly assetKey: "network_firewall";
        readonly drawioShape: "network_firewall";
    };
    readonly FSx: {
        readonly provider: "AWS";
        readonly pricingServiceCode: "amazonFSx";
        readonly assetKey: "fsx";
        readonly drawioShape: "fsx";
    };
    readonly FinSpace: {
        readonly provider: "AWS";
        readonly pricingServiceCode: "awsFinSpace";
        readonly assetKey: "finspace";
        readonly drawioShape: "finspace";
    };
    readonly Forecast: {
        readonly provider: "AWS";
        readonly pricingServiceCode: "amazonForecast";
        readonly assetKey: "forecast";
        readonly drawioShape: "forecast";
    };
    readonly FraudDetector: {
        readonly provider: "AWS";
        readonly pricingServiceCode: "amazonFraudDetector";
        readonly assetKey: "fraud_detector";
        readonly drawioShape: "fraud_detector";
    };
    readonly GameLift: {
        readonly provider: "AWS";
        readonly pricingServiceCode: "amazonGameLift";
        readonly assetKey: "gamelift";
        readonly drawioShape: "gamelift";
    };
    readonly GlobalAccelerator: {
        readonly provider: "AWS";
        readonly assetKey: "global_accelerator";
        readonly drawioShape: "global_accelerator";
    };
    readonly Glue: {
        readonly provider: "AWS";
        readonly pricingServiceCode: "awsGlue";
        readonly assetKey: "glue";
        readonly drawioShape: "glue";
    };
    readonly Grafana: {
        readonly provider: "AWS";
    };
    readonly Greengrass: {
        readonly provider: "AWS";
        readonly pricingServiceCode: "awsIoTGreengrass";
        readonly assetKey: "iot_greengrass";
        readonly drawioShape: "greengrass";
    };
    readonly GreengrassV2: {
        readonly provider: "AWS";
        readonly pricingServiceCode: "awsIoTGreengrass";
        readonly assetKey: "iot_greengrass";
        readonly drawioShape: "greengrass";
    };
    readonly GroundStation: {
        readonly provider: "AWS";
        readonly assetKey: "ground_station";
        readonly drawioShape: "ground_station";
    };
    readonly GuardDuty: {
        readonly provider: "AWS";
        readonly pricingServiceCode: "amazonGuardDuty";
        readonly assetKey: "guardduty";
        readonly drawioShape: "guardduty";
    };
    readonly HealthLake: {
        readonly provider: "AWS";
        readonly pricingServiceCode: "amazonHealthlake";
        readonly assetKey: "healthlake";
        readonly drawioShape: "healthlake";
    };
    readonly IAM: {
        readonly provider: "AWS";
        readonly assetKey: "iam";
        readonly drawioShape: "identity_and_access_management";
    };
    readonly IVS: {
        readonly provider: "AWS";
        readonly assetKey: "interactive_video_service";
    };
    readonly IdentityStore: {
        readonly provider: "AWS";
    };
    readonly ImageBuilder: {
        readonly provider: "AWS";
        readonly pricingServiceCode: "ec2Enhancement";
        readonly assetKey: "ec2";
        readonly drawioShape: "ec2";
    };
    readonly Inspector: {
        readonly provider: "AWS";
        readonly pricingServiceCode: "amazonInspector";
        readonly assetKey: "inspector";
        readonly drawioShape: "inspector";
    };
    readonly InspectorV2: {
        readonly provider: "AWS";
        readonly pricingServiceCode: "amazonInspector";
        readonly assetKey: "inspector";
        readonly drawioShape: "inspector";
    };
    readonly IoT1Click: {
        readonly provider: "AWS";
        readonly assetKey: "iot_1_click";
        readonly drawioShape: "iot_1click";
    };
    readonly IoT: {
        readonly provider: "AWS";
        readonly pricingServiceCode: "awsIoTCore";
        readonly assetKey: "iot_core";
        readonly drawioShape: "iot_core";
    };
    readonly IoTAnalytics: {
        readonly provider: "AWS";
        readonly pricingServiceCode: "awsIoTAnalytics";
        readonly assetKey: "iot_analytics";
        readonly drawioShape: "iot_analytics";
    };
    readonly IoTCoreDeviceAdvisor: {
        readonly provider: "AWS";
        readonly pricingServiceCode: "awsIoTCore";
        readonly assetKey: "iot_core";
        readonly drawioShape: "iot_core";
    };
    readonly IoTEvents: {
        readonly provider: "AWS";
        readonly pricingServiceCode: "awsIoTEvents";
        readonly assetKey: "iot_events";
        readonly drawioShape: "iot_events";
    };
    readonly IoTFleetHub: {
        readonly provider: "AWS";
        readonly pricingServiceCode: "awsIoTDeviceManagement";
        readonly assetKey: "iot_device_management";
        readonly drawioShape: "iot_device_management";
    };
    readonly IoTFleetWise: {
        readonly provider: "AWS";
        readonly pricingServiceCode: "awsIoTFleetWise";
        readonly assetKey: "iot_fleetwise";
        readonly drawioShape: "iot_fleetwise";
    };
    readonly IoTSiteWise: {
        readonly provider: "AWS";
        readonly assetKey: "iot_sitewise";
        readonly drawioShape: "iot_sitewise";
    };
    readonly IoTThingsGraph: {
        readonly provider: "AWS";
        readonly pricingServiceCode: "awsIoTThingsGraph";
        readonly assetKey: "iot_things_graph";
        readonly drawioShape: "iot_things_graph";
    };
    readonly IoTTwinMaker: {
        readonly provider: "AWS";
        readonly assetKey: "iot_twinmaker";
        readonly drawioShape: "iot_twinmaker";
    };
    readonly IoTWireless: {
        readonly provider: "AWS";
        readonly pricingServiceCode: "awsIoTCore";
        readonly assetKey: "iot_core";
        readonly drawioShape: "iot_core";
    };
    readonly KMS: {
        readonly provider: "AWS";
        readonly pricingServiceCode: "awsKeyManagementService";
        readonly assetKey: "key_management_service";
        readonly drawioShape: "key_management_service";
    };
    readonly KafkaConnect: {
        readonly provider: "AWS";
        readonly pricingServiceCode: "amazonManagedStreamingForApacheKafkaMsk";
        readonly assetKey: "msk";
        readonly drawioShape: "managed_streaming_for_kafka";
    };
    readonly Kendra: {
        readonly provider: "AWS";
        readonly pricingServiceCode: "amazonKendra";
        readonly assetKey: "kendra";
        readonly drawioShape: "kendra";
    };
    readonly KendraRanking: {
        readonly provider: "AWS";
        readonly pricingServiceCode: "amazonKendra";
        readonly assetKey: "kendra";
        readonly drawioShape: "kendra";
    };
    readonly Kinesis: {
        readonly provider: "AWS";
        readonly pricingServiceCode: "amazonKinesisDataStreams";
        readonly assetKey: "kinesis_data_streams";
        readonly drawioShape: "kinesis_data_streams";
    };
    readonly KinesisAnalytics: {
        readonly provider: "AWS";
        readonly pricingServiceCode: "amazonKinesisDataAnalytics";
        readonly assetKey: "kinesis_data_analytics";
        readonly drawioShape: "kinesis_data_analytics";
    };
    readonly KinesisAnalyticsV2: {
        readonly provider: "AWS";
        readonly pricingServiceCode: "amazonKinesisDataAnalytics";
        readonly assetKey: "kinesis_data_analytics";
        readonly drawioShape: "kinesis_data_analytics";
    };
    readonly KinesisFirehose: {
        readonly provider: "AWS";
        readonly pricingServiceCode: "amazonKinesisFirehose";
        readonly assetKey: "kinesis_firehose";
    };
    readonly KinesisVideo: {
        readonly provider: "AWS";
        readonly pricingServiceCode: "amazonKinesisVideoStreams";
        readonly assetKey: "kinesis_video_streams";
        readonly drawioShape: "kinesis_video_streams";
    };
    readonly LakeFormation: {
        readonly provider: "AWS";
        readonly pricingServiceCode: "awsLakeFormation";
        readonly assetKey: "lake_formation";
        readonly drawioShape: "lake_formation";
    };
    readonly Lambda: {
        readonly provider: "AWS";
        readonly pricingServiceCode: "aWSLambda";
        readonly assetKey: "lambda";
        readonly drawioShape: "lambda";
    };
    readonly Lex: {
        readonly provider: "AWS";
        readonly pricingServiceCode: "amazonLex";
        readonly assetKey: "lex";
        readonly drawioShape: "lex";
    };
    readonly LicenseManager: {
        readonly provider: "AWS";
        readonly assetKey: "license_manager";
        readonly drawioShape: "license_manager";
    };
    readonly Lightsail: {
        readonly provider: "AWS";
        readonly pricingServiceCode: "amazonLightsail";
        readonly assetKey: "lightsail";
        readonly drawioShape: "lightsail";
    };
    readonly Location: {
        readonly provider: "AWS";
        readonly pricingServiceCode: "locationService";
        readonly assetKey: "location_service";
        readonly drawioShape: "location_service";
    };
    readonly Logs: {
        readonly provider: "AWS";
        readonly pricingServiceCode: "amazonCloudWatch";
        readonly assetKey: "cloudwatch";
        readonly drawioShape: "cloudwatch";
    };
    readonly LookoutEquipment: {
        readonly provider: "AWS";
        readonly assetKey: "lookout_for_equipment";
        readonly drawioShape: "lookout_for_equipment";
    };
    readonly LookoutMetrics: {
        readonly provider: "AWS";
        readonly pricingServiceCode: "amazonLookoutForMetrics";
        readonly assetKey: "lookout_for_metrics";
        readonly drawioShape: "lookout_for_metrics";
    };
    readonly LookoutVision: {
        readonly provider: "AWS";
        readonly pricingServiceCode: "amazonLookoutForVision";
        readonly assetKey: "lookout_for_vision";
        readonly drawioShape: "lookout_for_vision";
    };
    readonly M2: {
        readonly provider: "AWS";
        readonly pricingServiceCode: "amazonMainframeModernization";
        readonly assetKey: "mainframe_modernization";
        readonly drawioShape: "mainframe_modernization";
    };
    readonly MSK: {
        readonly provider: "AWS";
        readonly pricingServiceCode: "amazonManagedStreamingForApacheKafkaMsk";
        readonly assetKey: "msk";
        readonly drawioShape: "managed_streaming_for_kafka";
    };
    readonly MWAA: {
        readonly provider: "AWS";
        readonly pricingServiceCode: "amazonManagedWorkflowsForApacheAirflow";
        readonly assetKey: "mwaa";
        readonly drawioShape: "managed_workflows_for_apache_airflow";
    };
    readonly Macie: {
        readonly provider: "AWS";
        readonly pricingServiceCode: "amazonMacie";
        readonly assetKey: "macie";
        readonly drawioShape: "macie";
    };
    readonly ManagedBlockchain: {
        readonly provider: "AWS";
        readonly pricingServiceCode: "amazonManagedBlockchain";
        readonly assetKey: "managed_blockchain";
        readonly drawioShape: "managed_blockchain";
    };
    readonly MediaConnect: {
        readonly provider: "AWS";
        readonly pricingServiceCode: "awsElementalMediaConnect";
        readonly assetKey: "elemental_mediaconnect";
        readonly drawioShape: "elemental_mediaconnect";
    };
    readonly MediaConvert: {
        readonly provider: "AWS";
        readonly pricingServiceCode: "elementalMediaConvert";
        readonly assetKey: "elemental_mediaconvert";
        readonly drawioShape: "elemental_mediaconvert";
    };
    readonly MediaLive: {
        readonly provider: "AWS";
        readonly pricingServiceCode: "awsElementalMediaLive";
        readonly assetKey: "elemental_medialive";
        readonly drawioShape: "elemental_medialive";
    };
    readonly MediaPackage: {
        readonly provider: "AWS";
        readonly pricingServiceCode: "awsElementalMediaPackage";
        readonly assetKey: "elemental_mediapackage";
        readonly drawioShape: "elemental_mediapackage";
    };
    readonly MediaStore: {
        readonly provider: "AWS";
        readonly assetKey: "elemental_mediastore";
        readonly drawioShape: "elemental_mediastore";
    };
    readonly MediaTailor: {
        readonly provider: "AWS";
        readonly pricingServiceCode: "awsElementalMediaTailor";
        readonly assetKey: "elemental_mediatailor";
        readonly drawioShape: "elemental_mediatailor";
    };
    readonly MemoryDB: {
        readonly provider: "AWS";
        readonly pricingServiceCode: "amazonMemoryDbForRedis";
        readonly assetKey: "memorydb_for_redis";
        readonly drawioShape: "memorydb_for_redis";
    };
    readonly Neptune: {
        readonly provider: "AWS";
        readonly pricingServiceCode: "amazonNeptune";
        readonly assetKey: "neptune";
        readonly drawioShape: "neptune";
    };
    readonly NetworkFirewall: {
        readonly provider: "AWS";
        readonly pricingServiceCode: "amazonNetworkFirewall";
        readonly assetKey: "network_firewall";
        readonly drawioShape: "network_firewall";
    };
    readonly NetworkManager: {
        readonly provider: "AWS";
        readonly pricingServiceCode: "amazonVirtualPrivateCloud";
        readonly assetKey: "vpc";
        readonly drawioShape: "virtual_private_cloud";
    };
    readonly NimbleStudio: {
        readonly provider: "AWS";
        readonly assetKey: "nimble_studio";
        readonly drawioShape: "nimble_studio";
    };
    readonly Oam: {
        readonly provider: "AWS";
    };
    readonly OpenSearchServerless: {
        readonly provider: "AWS";
        readonly pricingServiceCode: "amazonElasticsearchService";
        readonly assetKey: "opensearch";
        readonly drawioShape: "elasticsearch_service";
    };
    readonly OpenSearchService: {
        readonly provider: "AWS";
        readonly pricingServiceCode: "amazonElasticsearchService";
        readonly assetKey: "opensearch";
        readonly drawioShape: "elasticsearch_service";
    };
    readonly OpsWorks: {
        readonly provider: "AWS";
        readonly assetKey: "opsworks";
        readonly drawioShape: "opsworks";
    };
    readonly OpsWorksCM: {
        readonly provider: "AWS";
        readonly assetKey: "opsworks";
        readonly drawioShape: "opsworks";
    };
    readonly Organizations: {
        readonly provider: "AWS";
        readonly assetKey: "organizations";
        readonly drawioShape: "organizations";
    };
    readonly Panorama: {
        readonly provider: "AWS";
        readonly assetKey: "panorama";
        readonly drawioShape: "panorama";
    };
    readonly Personalize: {
        readonly provider: "AWS";
        readonly pricingServiceCode: "amazonPersonalize";
        readonly assetKey: "personalize";
        readonly drawioShape: "personalize";
    };
    readonly Pinpoint: {
        readonly provider: "AWS";
        readonly pricingServiceCode: "amazonPinpoint";
        readonly assetKey: "pinpoint";
        readonly drawioShape: "pinpoint";
    };
    readonly PinpointEmail: {
        readonly provider: "AWS";
        readonly pricingServiceCode: "amazonPinpoint";
        readonly assetKey: "pinpoint";
        readonly drawioShape: "pinpoint";
    };
    readonly Pipes: {
        readonly provider: "AWS";
    };
    readonly QLDB: {
        readonly provider: "AWS";
        readonly assetKey: "quantum_ledger_database";
        readonly drawioShape: "quantum_ledger_database";
    };
    readonly QuickSight: {
        readonly provider: "AWS";
        readonly pricingServiceCode: "amazonQuickSight";
        readonly assetKey: "quicksight";
        readonly drawioShape: "quicksight";
    };
    readonly RAM: {
        readonly provider: "AWS";
        readonly assetKey: "resource_access_manager";
        readonly drawioShape: "resource_access_manager";
    };
    readonly RDS: {
        readonly provider: "AWS";
        readonly pricingServiceCode: "amazonRDSForSQLServer";
        readonly assetKey: "rds";
        readonly drawioShape: "rds";
    };
    readonly RUM: {
        readonly provider: "AWS";
        readonly pricingServiceCode: "amazonCloudWatch";
        readonly assetKey: "cloudwatch";
        readonly drawioShape: "cloudwatch";
    };
    readonly Redshift: {
        readonly provider: "AWS";
        readonly pricingServiceCode: "amazonRedshift";
        readonly assetKey: "redshift";
        readonly drawioShape: "redshift";
    };
    readonly RedshiftServerless: {
        readonly provider: "AWS";
        readonly pricingServiceCode: "amazonRedshift";
        readonly assetKey: "redshift";
        readonly drawioShape: "redshift";
    };
    readonly RefactorSpaces: {
        readonly provider: "AWS";
        readonly pricingServiceCode: "migrationHubRefactorSpaces";
        readonly assetKey: "migration_hub";
        readonly drawioShape: "migration_hub";
    };
    readonly Rekognition: {
        readonly provider: "AWS";
        readonly pricingServiceCode: "amazonRekognition";
        readonly assetKey: "rekognition";
        readonly drawioShape: "rekognition";
    };
    readonly ResilienceHub: {
        readonly provider: "AWS";
        readonly assetKey: "resilience_hub";
        readonly drawioShape: "resilience_hub";
    };
    readonly ResourceExplorer2: {
        readonly provider: "AWS";
    };
    readonly ResourceGroups: {
        readonly provider: "AWS";
        readonly pricingServiceCode: "awsSystemsManager";
        readonly assetKey: "ssm";
        readonly drawioShape: "systems_manager";
    };
    readonly RoboMaker: {
        readonly provider: "AWS";
        readonly assetKey: "robomaker";
        readonly drawioShape: "robomaker";
    };
    readonly RolesAnywhere: {
        readonly provider: "AWS";
        readonly assetKey: "iam";
        readonly drawioShape: "identity_and_access_management";
    };
    readonly Route53: {
        readonly provider: "AWS";
        readonly pricingServiceCode: "amazonRoute53";
        readonly assetKey: "route_53";
        readonly drawioShape: "route_53";
    };
    readonly Route53RecoveryControl: {
        readonly provider: "AWS";
        readonly pricingServiceCode: "amazonRoute53";
        readonly assetKey: "route_53";
        readonly drawioShape: "route_53";
    };
    readonly Route53RecoveryReadiness: {
        readonly provider: "AWS";
        readonly pricingServiceCode: "amazonRoute53";
        readonly assetKey: "route_53";
        readonly drawioShape: "route_53";
    };
    readonly Route53Resolver: {
        readonly provider: "AWS";
        readonly pricingServiceCode: "amazonRoute53";
        readonly assetKey: "route_53";
        readonly drawioShape: "route_53";
    };
    readonly S3: {
        readonly provider: "AWS";
        readonly pricingServiceCode: "amazonSimpleStorageServiceGroup";
        readonly assetKey: "s3";
        readonly drawioShape: "s3";
    };
    readonly S3ObjectLambda: {
        readonly provider: "AWS";
        readonly pricingServiceCode: "s3ObjectLambda";
        readonly assetKey: "s3";
        readonly drawioShape: "s3";
    };
    readonly S3Outposts: {
        readonly provider: "AWS";
        readonly assetKey: "s3_on_outposts";
        readonly drawioShape: "s3_on_outposts";
    };
    readonly SDB: {
        readonly provider: "AWS";
    };
    readonly SES: {
        readonly provider: "AWS";
        readonly pricingServiceCode: "amazonSimpleEmailService";
        readonly assetKey: "ses";
        readonly drawioShape: "simple_email_service";
    };
    readonly SNS: {
        readonly provider: "AWS";
        readonly pricingServiceCode: "amazonSimpleNotificationService";
        readonly assetKey: "sns";
        readonly drawioShape: "sns";
    };
    readonly SQS: {
        readonly provider: "AWS";
        readonly pricingServiceCode: "amazonSimpleQueueService";
        readonly assetKey: "sqs";
        readonly drawioShape: "sqs";
    };
    readonly SSM: {
        readonly provider: "AWS";
        readonly pricingServiceCode: "awsSystemsManager";
        readonly assetKey: "ssm";
        readonly drawioShape: "systems_manager";
    };
    readonly SSMContacts: {
        readonly provider: "AWS";
        readonly pricingServiceCode: "awsSystemsManager";
        readonly assetKey: "ssm";
        readonly drawioShape: "systems_manager";
    };
    readonly SSMIncidents: {
        readonly provider: "AWS";
        readonly pricingServiceCode: "awsSystemsManager";
        readonly assetKey: "ssm";
        readonly drawioShape: "systems_manager";
    };
    readonly SSO: {
        readonly provider: "AWS";
        readonly assetKey: "iam_identity_center";
        readonly drawioShape: "single_sign_on";
    };
    readonly SageMaker: {
        readonly provider: "AWS";
        readonly pricingServiceCode: "amazonSageMaker";
        readonly assetKey: "sagemaker";
        readonly drawioShape: "sagemaker";
    };
    readonly Scheduler: {
        readonly provider: "AWS";
    };
    readonly SecretsManager: {
        readonly provider: "AWS";
        readonly pricingServiceCode: "awsSecretsManager";
        readonly assetKey: "secrets_manager";
        readonly drawioShape: "secrets_manager";
    };
    readonly SecurityHub: {
        readonly provider: "AWS";
        readonly pricingServiceCode: "awsSecurityHub";
        readonly assetKey: "security_hub";
        readonly drawioShape: "security_hub";
    };
    readonly Serverless: {
        readonly provider: "AWS";
        readonly assetKey: "serverless_application_repository";
        readonly drawioShape: "serverless_application_repository";
    };
    readonly ServiceCatalog: {
        readonly provider: "AWS";
        readonly assetKey: "service_catalog";
        readonly drawioShape: "service_catalog";
    };
    readonly ServiceCatalogAppRegistry: {
        readonly provider: "AWS";
        readonly assetKey: "service_catalog";
        readonly drawioShape: "service_catalog";
    };
    readonly ServiceDiscovery: {
        readonly provider: "AWS";
        readonly assetKey: "application_discovery_service";
        readonly drawioShape: "application_discovery_service";
    };
    readonly Signer: {
        readonly provider: "AWS";
        readonly assetKey: "signer";
        readonly drawioShape: "signer";
    };
    readonly StepFunctions: {
        readonly provider: "AWS";
        readonly pricingServiceCode: "awsStepFunctions";
        readonly assetKey: "step_functions";
        readonly drawioShape: "step_functions";
    };
    readonly SupportApp: {
        readonly provider: "AWS";
        readonly assetKey: "support";
        readonly drawioShape: "support";
    };
    readonly Synthetics: {
        readonly provider: "AWS";
        readonly pricingServiceCode: "amazonCloudWatch";
        readonly assetKey: "cloudwatch";
        readonly drawioShape: "cloudwatch";
    };
    readonly Timestream: {
        readonly provider: "AWS";
        readonly assetKey: "timestream";
        readonly drawioShape: "timestream";
    };
    readonly Transfer: {
        readonly provider: "AWS";
        readonly pricingServiceCode: "aWSTransferForSFTP";
        readonly assetKey: "transfer_family";
        readonly drawioShape: "transfer_family";
    };
    readonly VoiceID: {
        readonly provider: "AWS";
        readonly assetKey: "connect";
        readonly drawioShape: "connector";
    };
    readonly WAF: {
        readonly provider: "AWS";
        readonly pricingServiceCode: "awsWebApplicationFirewall";
        readonly assetKey: "waf";
        readonly drawioShape: "waf";
    };
    readonly WAFRegional: {
        readonly provider: "AWS";
        readonly pricingServiceCode: "awsWebApplicationFirewall";
        readonly assetKey: "waf";
        readonly drawioShape: "waf";
    };
    readonly WAFv2: {
        readonly provider: "AWS";
        readonly pricingServiceCode: "awsWebApplicationFirewall";
        readonly assetKey: "waf";
        readonly drawioShape: "waf";
    };
    readonly Wisdom: {
        readonly provider: "AWS";
        readonly assetKey: "connect";
        readonly drawioShape: "connector";
    };
    readonly WorkSpaces: {
        readonly provider: "AWS";
        readonly pricingServiceCode: "amazonWorkspaces";
        readonly assetKey: "workspaces";
        readonly drawioShape: "workspaces";
    };
    readonly XRay: {
        readonly provider: "AWS";
        readonly pricingServiceCode: "awsXRay";
        readonly assetKey: "x_ray";
        readonly drawioShape: "xray";
    };
    readonly ASK: {
        readonly provider: "Alexa";
        readonly assetKey: "alexa_for_business";
        readonly drawioShape: "alexa_for_business";
    };
};
/** @internal */
export declare const AwsResourceMapping: {
    readonly "AWS::ACMPCA::Certificate": {
        readonly service: "ACMPCA";
        readonly serviceAssetKey: "certificate_manager";
        readonly generalIconKey: "ssl_padlock";
        readonly drawioGeneralShape: "ssl_padlock";
    };
    readonly "AWS::ACMPCA::CertificateAuthority": {
        readonly service: "ACMPCA";
        readonly serviceAssetKey: "certificate_manager";
        readonly assetKey: "certificate_manager_certificate_authority";
    };
    readonly "AWS::ACMPCA::CertificateAuthorityActivation": {
        readonly service: "ACMPCA";
        readonly serviceAssetKey: "certificate_manager";
    };
    readonly "AWS::ACMPCA::Permission": {
        readonly service: "ACMPCA";
        readonly serviceAssetKey: "certificate_manager";
        readonly generalIconKey: "policy";
        readonly drawioGeneralShape: "addon";
    };
    readonly "AWS::APS::RuleGroupsNamespace": {
        readonly service: "APS";
        readonly serviceAssetKey: "aps";
    };
    readonly "AWS::APS::Workspace": {
        readonly service: "APS";
        readonly serviceAssetKey: "aps";
    };
    readonly "AWS::AccessAnalyzer::Analyzer": {
        readonly service: "AccessAnalyzer";
        readonly serviceAssetKey: "iam";
    };
    readonly "AWS::AmazonMQ::Broker": {
        readonly service: "AmazonMQ";
        readonly serviceAssetKey: "mq";
        readonly assetKey: "mq_broker";
        readonly drawioShape: "mq_broker";
    };
    readonly "AWS::AmazonMQ::Configuration": {
        readonly service: "AmazonMQ";
        readonly serviceAssetKey: "mq";
        readonly generalIconKey: "config";
        readonly drawioGeneralShape: "gear";
    };
    readonly "AWS::AmazonMQ::ConfigurationAssociation": {
        readonly service: "AmazonMQ";
        readonly serviceAssetKey: "mq";
    };
    readonly "AWS::Amplify::App": {
        readonly service: "Amplify";
        readonly serviceAssetKey: "amplify";
        readonly generalIconKey: "generic_application";
    };
    readonly "AWS::Amplify::Branch": {
        readonly service: "Amplify";
        readonly serviceAssetKey: "amplify";
        readonly generalIconKey: "git_repository";
    };
    readonly "AWS::Amplify::Domain": {
        readonly service: "Amplify";
        readonly serviceAssetKey: "amplify";
    };
    readonly "AWS::AmplifyUIBuilder::Component": {
        readonly service: "AmplifyUIBuilder";
        readonly serviceAssetKey: "amplify";
    };
    readonly "AWS::AmplifyUIBuilder::Form": {
        readonly service: "AmplifyUIBuilder";
        readonly serviceAssetKey: "amplify";
    };
    readonly "AWS::AmplifyUIBuilder::Theme": {
        readonly service: "AmplifyUIBuilder";
        readonly serviceAssetKey: "amplify";
    };
    readonly "AWS::ApiGateway::Account": {
        readonly service: "ApiGateway";
        readonly serviceAssetKey: "api_gateway";
    };
    readonly "AWS::ApiGateway::ApiKey": {
        readonly service: "ApiGateway";
        readonly serviceAssetKey: "api_gateway";
        readonly generalIconKey: "key";
        readonly drawioGeneralShape: "permissions";
    };
    readonly "AWS::ApiGateway::Authorizer": {
        readonly service: "ApiGateway";
        readonly serviceAssetKey: "api_gateway";
    };
    readonly "AWS::ApiGateway::BasePathMapping": {
        readonly service: "ApiGateway";
        readonly serviceAssetKey: "api_gateway";
    };
    readonly "AWS::ApiGateway::ClientCertificate": {
        readonly service: "ApiGateway";
        readonly serviceAssetKey: "api_gateway";
        readonly generalIconKey: "ssl_padlock";
        readonly drawioGeneralShape: "ssl_padlock";
    };
    readonly "AWS::ApiGateway::Deployment": {
        readonly service: "ApiGateway";
        readonly serviceAssetKey: "api_gateway";
    };
    readonly "AWS::ApiGateway::DocumentationPart": {
        readonly service: "ApiGateway";
        readonly serviceAssetKey: "api_gateway";
        readonly generalIconKey: "document";
    };
    readonly "AWS::ApiGateway::DocumentationVersion": {
        readonly service: "ApiGateway";
        readonly serviceAssetKey: "api_gateway";
        readonly generalIconKey: "document";
    };
    readonly "AWS::ApiGateway::DomainName": {
        readonly service: "ApiGateway";
        readonly serviceAssetKey: "api_gateway";
    };
    readonly "AWS::ApiGateway::GatewayResponse": {
        readonly service: "ApiGateway";
        readonly serviceAssetKey: "api_gateway";
    };
    readonly "AWS::ApiGateway::Method": {
        readonly service: "ApiGateway";
        readonly serviceAssetKey: "api_gateway";
    };
    readonly "AWS::ApiGateway::Model": {
        readonly service: "ApiGateway";
        readonly serviceAssetKey: "api_gateway";
        readonly generalIconKey: "document";
    };
    readonly "AWS::ApiGateway::RequestValidator": {
        readonly service: "ApiGateway";
        readonly serviceAssetKey: "api_gateway";
    };
    readonly "AWS::ApiGateway::Resource": {
        readonly service: "ApiGateway";
        readonly serviceAssetKey: "api_gateway";
    };
    readonly "AWS::ApiGateway::RestApi": {
        readonly service: "ApiGateway";
        readonly serviceAssetKey: "api_gateway";
    };
    readonly "AWS::ApiGateway::Stage": {
        readonly service: "ApiGateway";
        readonly serviceAssetKey: "api_gateway";
    };
    readonly "AWS::ApiGateway::UsagePlan": {
        readonly service: "ApiGateway";
        readonly serviceAssetKey: "api_gateway";
    };
    readonly "AWS::ApiGateway::UsagePlanKey": {
        readonly service: "ApiGateway";
        readonly serviceAssetKey: "api_gateway";
        readonly generalIconKey: "key";
        readonly drawioGeneralShape: "permissions";
    };
    readonly "AWS::ApiGateway::VpcLink": {
        readonly service: "ApiGateway";
        readonly serviceAssetKey: "api_gateway";
    };
    readonly "AWS::ApiGatewayV2::Api": {
        readonly service: "ApiGatewayV2";
        readonly serviceAssetKey: "api_gateway";
    };
    readonly "AWS::ApiGatewayV2::ApiGatewayManagedOverrides": {
        readonly service: "ApiGatewayV2";
        readonly serviceAssetKey: "api_gateway";
    };
    readonly "AWS::ApiGatewayV2::ApiMapping": {
        readonly service: "ApiGatewayV2";
        readonly serviceAssetKey: "api_gateway";
    };
    readonly "AWS::ApiGatewayV2::Authorizer": {
        readonly service: "ApiGatewayV2";
        readonly serviceAssetKey: "api_gateway";
    };
    readonly "AWS::ApiGatewayV2::Deployment": {
        readonly service: "ApiGatewayV2";
        readonly serviceAssetKey: "api_gateway";
    };
    readonly "AWS::ApiGatewayV2::DomainName": {
        readonly service: "ApiGatewayV2";
        readonly serviceAssetKey: "api_gateway";
    };
    readonly "AWS::ApiGatewayV2::Integration": {
        readonly service: "ApiGatewayV2";
        readonly serviceAssetKey: "api_gateway";
    };
    readonly "AWS::ApiGatewayV2::IntegrationResponse": {
        readonly service: "ApiGatewayV2";
        readonly serviceAssetKey: "api_gateway";
    };
    readonly "AWS::ApiGatewayV2::Model": {
        readonly service: "ApiGatewayV2";
        readonly serviceAssetKey: "api_gateway";
        readonly generalIconKey: "document";
    };
    readonly "AWS::ApiGatewayV2::Route": {
        readonly service: "ApiGatewayV2";
        readonly serviceAssetKey: "api_gateway";
    };
    readonly "AWS::ApiGatewayV2::RouteResponse": {
        readonly service: "ApiGatewayV2";
        readonly serviceAssetKey: "api_gateway";
    };
    readonly "AWS::ApiGatewayV2::Stage": {
        readonly service: "ApiGatewayV2";
        readonly serviceAssetKey: "api_gateway";
    };
    readonly "AWS::ApiGatewayV2::VpcLink": {
        readonly service: "ApiGatewayV2";
        readonly serviceAssetKey: "api_gateway";
    };
    readonly "AWS::AppConfig::Application": {
        readonly service: "AppConfig";
        readonly serviceAssetKey: "appconfig";
        readonly generalIconKey: "generic_application";
    };
    readonly "AWS::AppConfig::ConfigurationProfile": {
        readonly service: "AppConfig";
        readonly serviceAssetKey: "appconfig";
    };
    readonly "AWS::AppConfig::Deployment": {
        readonly service: "AppConfig";
        readonly serviceAssetKey: "appconfig";
    };
    readonly "AWS::AppConfig::DeploymentStrategy": {
        readonly service: "AppConfig";
        readonly serviceAssetKey: "appconfig";
    };
    readonly "AWS::AppConfig::Environment": {
        readonly service: "AppConfig";
        readonly serviceAssetKey: "appconfig";
    };
    readonly "AWS::AppConfig::HostedConfigurationVersion": {
        readonly service: "AppConfig";
        readonly serviceAssetKey: "appconfig";
    };
    readonly "AWS::AppFlow::Connector": {
        readonly service: "AppFlow";
        readonly serviceAssetKey: "appflow";
    };
    readonly "AWS::AppFlow::ConnectorProfile": {
        readonly service: "AppFlow";
        readonly serviceAssetKey: "appflow";
    };
    readonly "AWS::AppFlow::Flow": {
        readonly service: "AppFlow";
        readonly serviceAssetKey: "appflow";
    };
    readonly "AWS::AppIntegrations::DataIntegration": {
        readonly service: "AppIntegrations";
        readonly serviceAssetKey: "application_discovery_service";
    };
    readonly "AWS::AppIntegrations::EventIntegration": {
        readonly service: "AppIntegrations";
        readonly serviceAssetKey: "application_discovery_service";
    };
    readonly "AWS::AppMesh::GatewayRoute": {
        readonly service: "AppMesh";
        readonly serviceAssetKey: "app_mesh";
    };
    readonly "AWS::AppMesh::Mesh": {
        readonly service: "AppMesh";
        readonly serviceAssetKey: "app_mesh";
        readonly assetKey: "app_mesh_mesh";
        readonly drawioShape: "mesh";
    };
    readonly "AWS::AppMesh::Route": {
        readonly service: "AppMesh";
        readonly serviceAssetKey: "app_mesh";
    };
    readonly "AWS::AppMesh::VirtualGateway": {
        readonly service: "AppMesh";
        readonly serviceAssetKey: "app_mesh";
        readonly assetKey: "app_mesh_virtual_gateway";
        readonly drawioShape: "virtual_gateway";
    };
    readonly "AWS::AppMesh::VirtualNode": {
        readonly service: "AppMesh";
        readonly serviceAssetKey: "app_mesh";
        readonly assetKey: "app_mesh_virtual_node";
        readonly drawioShape: "virtual_node";
    };
    readonly "AWS::AppMesh::VirtualRouter": {
        readonly service: "AppMesh";
        readonly serviceAssetKey: "app_mesh";
        readonly assetKey: "app_mesh_virtual_router";
        readonly drawioShape: "virtual_router";
    };
    readonly "AWS::AppMesh::VirtualService": {
        readonly service: "AppMesh";
        readonly serviceAssetKey: "app_mesh";
        readonly assetKey: "app_mesh_virtual_service";
        readonly drawioShape: "virtual_service";
    };
    readonly "AWS::AppRunner::ObservabilityConfiguration": {
        readonly service: "AppRunner";
        readonly serviceAssetKey: "app_runner";
        readonly generalIconKey: "config";
        readonly drawioGeneralShape: "gear";
    };
    readonly "AWS::AppRunner::Service": {
        readonly service: "AppRunner";
        readonly serviceAssetKey: "app_runner";
    };
    readonly "AWS::AppRunner::VpcConnector": {
        readonly service: "AppRunner";
        readonly serviceAssetKey: "app_runner";
    };
    readonly "AWS::AppRunner::VpcIngressConnection": {
        readonly service: "AppRunner";
        readonly serviceAssetKey: "app_runner";
    };
    readonly "AWS::AppStream::AppBlock": {
        readonly service: "AppStream";
        readonly serviceAssetKey: "appstream";
    };
    readonly "AWS::AppStream::Application": {
        readonly service: "AppStream";
        readonly serviceAssetKey: "appstream";
        readonly generalIconKey: "generic_application";
    };
    readonly "AWS::AppStream::ApplicationEntitlementAssociation": {
        readonly service: "AppStream";
        readonly serviceAssetKey: "appstream";
    };
    readonly "AWS::AppStream::ApplicationFleetAssociation": {
        readonly service: "AppStream";
        readonly serviceAssetKey: "appstream";
    };
    readonly "AWS::AppStream::DirectoryConfig": {
        readonly service: "AppStream";
        readonly serviceAssetKey: "appstream";
        readonly generalIconKey: "config";
        readonly drawioGeneralShape: "gear";
    };
    readonly "AWS::AppStream::Entitlement": {
        readonly service: "AppStream";
        readonly serviceAssetKey: "appstream";
    };
    readonly "AWS::AppStream::Fleet": {
        readonly service: "AppStream";
        readonly serviceAssetKey: "appstream";
    };
    readonly "AWS::AppStream::ImageBuilder": {
        readonly service: "AppStream";
        readonly serviceAssetKey: "appstream";
    };
    readonly "AWS::AppStream::Stack": {
        readonly service: "AppStream";
        readonly serviceAssetKey: "appstream";
    };
    readonly "AWS::AppStream::StackFleetAssociation": {
        readonly service: "AppStream";
        readonly serviceAssetKey: "appstream";
    };
    readonly "AWS::AppStream::StackUserAssociation": {
        readonly service: "AppStream";
        readonly serviceAssetKey: "appstream";
    };
    readonly "AWS::AppStream::User": {
        readonly service: "AppStream";
        readonly serviceAssetKey: "appstream";
        readonly generalIconKey: "user";
        readonly drawioGeneralShape: "user";
    };
    readonly "AWS::AppSync::ApiCache": {
        readonly service: "AppSync";
        readonly serviceAssetKey: "appsync";
    };
    readonly "AWS::AppSync::ApiKey": {
        readonly service: "AppSync";
        readonly serviceAssetKey: "appsync";
        readonly generalIconKey: "key";
        readonly drawioGeneralShape: "permissions";
    };
    readonly "AWS::AppSync::DataSource": {
        readonly service: "AppSync";
        readonly serviceAssetKey: "appsync";
    };
    readonly "AWS::AppSync::DomainName": {
        readonly service: "AppSync";
        readonly serviceAssetKey: "appsync";
    };
    readonly "AWS::AppSync::DomainNameApiAssociation": {
        readonly service: "AppSync";
        readonly serviceAssetKey: "appsync";
    };
    readonly "AWS::AppSync::FunctionConfiguration": {
        readonly service: "AppSync";
        readonly serviceAssetKey: "appsync";
        readonly generalIconKey: "config";
        readonly drawioGeneralShape: "gear";
    };
    readonly "AWS::AppSync::GraphQLApi": {
        readonly service: "AppSync";
        readonly serviceAssetKey: "appsync";
    };
    readonly "AWS::AppSync::GraphQLSchema": {
        readonly service: "AppSync";
        readonly serviceAssetKey: "appsync";
    };
    readonly "AWS::AppSync::Resolver": {
        readonly service: "AppSync";
        readonly serviceAssetKey: "appsync";
    };
    readonly "AWS::ApplicationAutoScaling::ScalableTarget": {
        readonly service: "ApplicationAutoScaling";
        readonly serviceAssetKey: "application_auto_scaling";
    };
    readonly "AWS::ApplicationAutoScaling::ScalingPolicy": {
        readonly service: "ApplicationAutoScaling";
        readonly serviceAssetKey: "application_auto_scaling";
        readonly generalIconKey: "policy";
        readonly drawioGeneralShape: "addon";
    };
    readonly "AWS::ApplicationInsights::Application": {
        readonly service: "ApplicationInsights";
        readonly serviceAssetKey: "cloudwatch";
        readonly generalIconKey: "generic_application";
    };
    readonly "AWS::Athena::DataCatalog": {
        readonly service: "Athena";
        readonly serviceAssetKey: "athena";
        readonly generalIconKey: "logs";
        readonly drawioGeneralShape: "logs";
    };
    readonly "AWS::Athena::NamedQuery": {
        readonly service: "Athena";
        readonly serviceAssetKey: "athena";
    };
    readonly "AWS::Athena::PreparedStatement": {
        readonly service: "Athena";
        readonly serviceAssetKey: "athena";
    };
    readonly "AWS::Athena::WorkGroup": {
        readonly service: "Athena";
        readonly serviceAssetKey: "athena";
    };
    readonly "AWS::AuditManager::Assessment": {
        readonly service: "AuditManager";
        readonly serviceAssetKey: "audit_manager";
    };
    readonly "AWS::AutoScaling::AutoScalingGroup": {
        readonly service: "AutoScaling";
        readonly serviceAssetKey: "auto_scaling";
    };
    readonly "AWS::AutoScaling::LaunchConfiguration": {
        readonly service: "AutoScaling";
        readonly serviceAssetKey: "auto_scaling";
        readonly generalIconKey: "config";
        readonly drawioGeneralShape: "gear";
    };
    readonly "AWS::AutoScaling::LifecycleHook": {
        readonly service: "AutoScaling";
        readonly serviceAssetKey: "auto_scaling";
    };
    readonly "AWS::AutoScaling::ScalingPolicy": {
        readonly service: "AutoScaling";
        readonly serviceAssetKey: "auto_scaling";
        readonly generalIconKey: "policy";
        readonly drawioGeneralShape: "addon";
    };
    readonly "AWS::AutoScaling::ScheduledAction": {
        readonly service: "AutoScaling";
        readonly serviceAssetKey: "auto_scaling";
    };
    readonly "AWS::AutoScaling::WarmPool": {
        readonly service: "AutoScaling";
        readonly serviceAssetKey: "auto_scaling";
    };
    readonly "AWS::AutoScalingPlans::ScalingPlan": {
        readonly service: "AutoScalingPlans";
        readonly serviceAssetKey: "auto_scaling";
    };
    readonly "AWS::Backup::BackupPlan": {
        readonly service: "Backup";
        readonly serviceAssetKey: "backup";
        readonly assetKey: "backup_backup_plan";
        readonly drawioShape: "backup_backup_plan";
    };
    readonly "AWS::Backup::BackupSelection": {
        readonly service: "Backup";
        readonly serviceAssetKey: "backup";
    };
    readonly "AWS::Backup::BackupVault": {
        readonly service: "Backup";
        readonly serviceAssetKey: "backup";
        readonly assetKey: "backup_backup_vault";
    };
    readonly "AWS::Backup::Framework": {
        readonly service: "Backup";
        readonly serviceAssetKey: "backup";
    };
    readonly "AWS::Backup::ReportPlan": {
        readonly service: "Backup";
        readonly serviceAssetKey: "backup";
    };
    readonly "AWS::Batch::ComputeEnvironment": {
        readonly service: "Batch";
        readonly serviceAssetKey: "batch";
    };
    readonly "AWS::Batch::JobDefinition": {
        readonly service: "Batch";
        readonly serviceAssetKey: "batch";
    };
    readonly "AWS::Batch::JobQueue": {
        readonly service: "Batch";
        readonly serviceAssetKey: "batch";
    };
    readonly "AWS::Batch::SchedulingPolicy": {
        readonly service: "Batch";
        readonly serviceAssetKey: "batch";
        readonly generalIconKey: "policy";
        readonly drawioGeneralShape: "addon";
    };
    readonly "AWS::BillingConductor::BillingGroup": {
        readonly service: "BillingConductor";
        readonly serviceAssetKey: "billing_conductor";
    };
    readonly "AWS::BillingConductor::CustomLineItem": {
        readonly service: "BillingConductor";
        readonly serviceAssetKey: "billing_conductor";
    };
    readonly "AWS::BillingConductor::PricingPlan": {
        readonly service: "BillingConductor";
        readonly serviceAssetKey: "billing_conductor";
    };
    readonly "AWS::BillingConductor::PricingRule": {
        readonly service: "BillingConductor";
        readonly serviceAssetKey: "billing_conductor";
        readonly generalIconKey: "rule";
        readonly drawioGeneralShape: "rule";
    };
    readonly "AWS::Budgets::Budget": {
        readonly service: "Budgets";
        readonly serviceAssetKey: "budgets";
    };
    readonly "AWS::Budgets::BudgetsAction": {
        readonly service: "Budgets";
        readonly serviceAssetKey: "budgets";
    };
    readonly "AWS::CE::AnomalyMonitor": {
        readonly service: "CE";
        readonly serviceAssetKey: "cost_explorer";
    };
    readonly "AWS::CE::AnomalySubscription": {
        readonly service: "CE";
        readonly serviceAssetKey: "cost_explorer";
    };
    readonly "AWS::CE::CostCategory": {
        readonly service: "CE";
        readonly serviceAssetKey: "cost_explorer";
    };
    readonly "AWS::CUR::ReportDefinition": {
        readonly service: "CUR";
        readonly serviceAssetKey: "cost_and_usage_report";
    };
    readonly "AWS::Cassandra::Keyspace": {
        readonly service: "Cassandra";
        readonly serviceAssetKey: "keyspaces";
    };
    readonly "AWS::Cassandra::Table": {
        readonly service: "Cassandra";
        readonly serviceAssetKey: "keyspaces";
    };
    readonly "AWS::CertificateManager::Account": {
        readonly service: "CertificateManager";
        readonly serviceAssetKey: "certificate_manager";
    };
    readonly "AWS::CertificateManager::Certificate": {
        readonly service: "CertificateManager";
        readonly serviceAssetKey: "certificate_manager";
        readonly generalIconKey: "ssl_padlock";
        readonly drawioGeneralShape: "ssl_padlock";
    };
    readonly "AWS::Chatbot::SlackChannelConfiguration": {
        readonly service: "Chatbot";
        readonly serviceAssetKey: "chatbot";
        readonly generalIconKey: "config";
        readonly drawioGeneralShape: "gear";
    };
    readonly "AWS::Cloud9::EnvironmentEC2": {
        readonly service: "Cloud9";
        readonly serviceAssetKey: "cloud9";
    };
    readonly "AWS::CloudFormation::CustomResource": {
        readonly service: "CloudFormation";
        readonly serviceAssetKey: "cloudformation";
    };
    readonly "AWS::CloudFormation::HookDefaultVersion": {
        readonly service: "CloudFormation";
        readonly serviceAssetKey: "cloudformation";
    };
    readonly "AWS::CloudFormation::HookTypeConfig": {
        readonly service: "CloudFormation";
        readonly serviceAssetKey: "cloudformation";
        readonly generalIconKey: "config";
        readonly drawioGeneralShape: "gear";
    };
    readonly "AWS::CloudFormation::HookVersion": {
        readonly service: "CloudFormation";
        readonly serviceAssetKey: "cloudformation";
    };
    readonly "AWS::CloudFormation::Macro": {
        readonly service: "CloudFormation";
        readonly serviceAssetKey: "cloudformation";
    };
    readonly "AWS::CloudFormation::ModuleDefaultVersion": {
        readonly service: "CloudFormation";
        readonly serviceAssetKey: "cloudformation";
    };
    readonly "AWS::CloudFormation::ModuleVersion": {
        readonly service: "CloudFormation";
        readonly serviceAssetKey: "cloudformation";
    };
    readonly "AWS::CloudFormation::PublicTypeVersion": {
        readonly service: "CloudFormation";
        readonly serviceAssetKey: "cloudformation";
    };
    readonly "AWS::CloudFormation::Publisher": {
        readonly service: "CloudFormation";
        readonly serviceAssetKey: "cloudformation";
    };
    readonly "AWS::CloudFormation::ResourceDefaultVersion": {
        readonly service: "CloudFormation";
        readonly serviceAssetKey: "cloudformation";
    };
    readonly "AWS::CloudFormation::ResourceVersion": {
        readonly service: "CloudFormation";
        readonly serviceAssetKey: "cloudformation";
    };
    readonly "AWS::CloudFormation::Stack": {
        readonly service: "CloudFormation";
        readonly serviceAssetKey: "cloudformation";
        readonly assetKey: "cloudformation_stack";
        readonly drawioShape: "stack";
    };
    readonly "AWS::CloudFormation::StackSet": {
        readonly service: "CloudFormation";
        readonly serviceAssetKey: "cloudformation";
    };
    readonly "AWS::CloudFormation::TypeActivation": {
        readonly service: "CloudFormation";
        readonly serviceAssetKey: "cloudformation";
    };
    readonly "AWS::CloudFormation::WaitCondition": {
        readonly service: "CloudFormation";
        readonly serviceAssetKey: "cloudformation";
    };
    readonly "AWS::CloudFormation::WaitConditionHandle": {
        readonly service: "CloudFormation";
        readonly serviceAssetKey: "cloudformation";
    };
    readonly "AWS::CloudFront::CachePolicy": {
        readonly service: "CloudFront";
        readonly serviceAssetKey: "cloudfront";
        readonly generalIconKey: "policy";
        readonly drawioGeneralShape: "addon";
    };
    readonly "AWS::CloudFront::CloudFrontOriginAccessIdentity": {
        readonly service: "CloudFront";
        readonly serviceAssetKey: "cloudfront";
    };
    readonly "AWS::CloudFront::ContinuousDeploymentPolicy": {
        readonly service: "CloudFront";
        readonly serviceAssetKey: "cloudfront";
        readonly generalIconKey: "policy";
        readonly drawioGeneralShape: "addon";
    };
    readonly "AWS::CloudFront::Distribution": {
        readonly service: "CloudFront";
        readonly serviceAssetKey: "cloudfront";
    };
    readonly "AWS::CloudFront::Function": {
        readonly service: "CloudFront";
        readonly serviceAssetKey: "cloudfront";
    };
    readonly "AWS::CloudFront::KeyGroup": {
        readonly service: "CloudFront";
        readonly serviceAssetKey: "cloudfront";
    };
    readonly "AWS::CloudFront::MonitoringSubscription": {
        readonly service: "CloudFront";
        readonly serviceAssetKey: "cloudfront";
    };
    readonly "AWS::CloudFront::OriginAccessControl": {
        readonly service: "CloudFront";
        readonly serviceAssetKey: "cloudfront";
    };
    readonly "AWS::CloudFront::OriginRequestPolicy": {
        readonly service: "CloudFront";
        readonly serviceAssetKey: "cloudfront";
        readonly generalIconKey: "policy";
        readonly drawioGeneralShape: "addon";
    };
    readonly "AWS::CloudFront::PublicKey": {
        readonly service: "CloudFront";
        readonly serviceAssetKey: "cloudfront";
        readonly generalIconKey: "key";
        readonly drawioGeneralShape: "permissions";
    };
    readonly "AWS::CloudFront::RealtimeLogConfig": {
        readonly service: "CloudFront";
        readonly serviceAssetKey: "cloudfront";
        readonly generalIconKey: "config";
        readonly drawioGeneralShape: "gear";
    };
    readonly "AWS::CloudFront::ResponseHeadersPolicy": {
        readonly service: "CloudFront";
        readonly serviceAssetKey: "cloudfront";
        readonly generalIconKey: "policy";
        readonly drawioGeneralShape: "addon";
    };
    readonly "AWS::CloudFront::StreamingDistribution": {
        readonly service: "CloudFront";
        readonly serviceAssetKey: "cloudfront";
        readonly assetKey: "cloudfront_streaming_distribution";
        readonly drawioShape: "streaming_distribution";
    };
    readonly "AWS::CloudTrail::EventDataStore": {
        readonly service: "CloudTrail";
        readonly serviceAssetKey: "cloudtrail";
    };
    readonly "AWS::CloudTrail::Trail": {
        readonly service: "CloudTrail";
        readonly serviceAssetKey: "cloudtrail";
    };
    readonly "AWS::CloudWatch::Alarm": {
        readonly service: "CloudWatch";
        readonly serviceAssetKey: "cloudwatch";
        readonly assetKey: "cloudwatch_alarm";
        readonly generalIconKey: "alarm";
        readonly drawioShape: "alarm";
        readonly drawioGeneralShape: "alarm";
    };
    readonly "AWS::CloudWatch::AnomalyDetector": {
        readonly service: "CloudWatch";
        readonly serviceAssetKey: "cloudwatch";
    };
    readonly "AWS::CloudWatch::CompositeAlarm": {
        readonly service: "CloudWatch";
        readonly serviceAssetKey: "cloudwatch";
        readonly generalIconKey: "alarm";
        readonly drawioGeneralShape: "alarm";
    };
    readonly "AWS::CloudWatch::Dashboard": {
        readonly service: "CloudWatch";
        readonly serviceAssetKey: "cloudwatch";
    };
    readonly "AWS::CloudWatch::InsightRule": {
        readonly service: "CloudWatch";
        readonly serviceAssetKey: "cloudwatch";
        readonly generalIconKey: "rule";
        readonly drawioGeneralShape: "rule";
    };
    readonly "AWS::CloudWatch::MetricStream": {
        readonly service: "CloudWatch";
        readonly serviceAssetKey: "cloudwatch";
    };
    readonly "AWS::CodeArtifact::Domain": {
        readonly service: "CodeArtifact";
        readonly serviceAssetKey: "codeartifact";
    };
    readonly "AWS::CodeArtifact::Repository": {
        readonly service: "CodeArtifact";
        readonly serviceAssetKey: "codeartifact";
    };
    readonly "AWS::CodeBuild::Project": {
        readonly service: "CodeBuild";
        readonly serviceAssetKey: "codebuild";
    };
    readonly "AWS::CodeBuild::ReportGroup": {
        readonly service: "CodeBuild";
        readonly serviceAssetKey: "codebuild";
    };
    readonly "AWS::CodeBuild::SourceCredential": {
        readonly service: "CodeBuild";
        readonly serviceAssetKey: "codebuild";
    };
    readonly "AWS::CodeCommit::Repository": {
        readonly service: "CodeCommit";
        readonly serviceAssetKey: "codecommit";
    };
    readonly "AWS::CodeDeploy::Application": {
        readonly service: "CodeDeploy";
        readonly serviceAssetKey: "codedeploy";
        readonly generalIconKey: "generic_application";
    };
    readonly "AWS::CodeDeploy::DeploymentConfig": {
        readonly service: "CodeDeploy";
        readonly serviceAssetKey: "codedeploy";
        readonly generalIconKey: "config";
        readonly drawioGeneralShape: "gear";
    };
    readonly "AWS::CodeDeploy::DeploymentGroup": {
        readonly service: "CodeDeploy";
        readonly serviceAssetKey: "codedeploy";
    };
    readonly "AWS::CodeGuruProfiler::ProfilingGroup": {
        readonly service: "CodeGuruProfiler";
        readonly serviceAssetKey: "codeguru";
    };
    readonly "AWS::CodeGuruReviewer::RepositoryAssociation": {
        readonly service: "CodeGuruReviewer";
        readonly serviceAssetKey: "codeguru";
    };
    readonly "AWS::CodePipeline::CustomActionType": {
        readonly service: "CodePipeline";
        readonly serviceAssetKey: "codepipeline";
    };
    readonly "AWS::CodePipeline::Pipeline": {
        readonly service: "CodePipeline";
        readonly serviceAssetKey: "codepipeline";
    };
    readonly "AWS::CodePipeline::Webhook": {
        readonly service: "CodePipeline";
        readonly serviceAssetKey: "codepipeline";
    };
    readonly "AWS::CodeStar::GitHubRepository": {
        readonly service: "CodeStar";
        readonly serviceAssetKey: "codestar";
    };
    readonly "AWS::CodeStarConnections::Connection": {
        readonly service: "CodeStarConnections";
        readonly serviceAssetKey: "codestar";
    };
    readonly "AWS::CodeStarNotifications::NotificationRule": {
        readonly service: "CodeStarNotifications";
        readonly serviceAssetKey: "codestar";
        readonly generalIconKey: "rule";
        readonly drawioGeneralShape: "rule";
    };
    readonly "AWS::Cognito::IdentityPool": {
        readonly service: "Cognito";
        readonly serviceAssetKey: "cognito";
    };
    readonly "AWS::Cognito::IdentityPoolRoleAttachment": {
        readonly service: "Cognito";
        readonly serviceAssetKey: "cognito";
        readonly generalIconKey: "attachment";
        readonly drawioGeneralShape: "transit_gateway_attachment";
    };
    readonly "AWS::Cognito::UserPool": {
        readonly service: "Cognito";
        readonly serviceAssetKey: "cognito";
    };
    readonly "AWS::Cognito::UserPoolClient": {
        readonly service: "Cognito";
        readonly serviceAssetKey: "cognito";
    };
    readonly "AWS::Cognito::UserPoolDomain": {
        readonly service: "Cognito";
        readonly serviceAssetKey: "cognito";
    };
    readonly "AWS::Cognito::UserPoolGroup": {
        readonly service: "Cognito";
        readonly serviceAssetKey: "cognito";
    };
    readonly "AWS::Cognito::UserPoolIdentityProvider": {
        readonly service: "Cognito";
        readonly serviceAssetKey: "cognito";
    };
    readonly "AWS::Cognito::UserPoolResourceServer": {
        readonly service: "Cognito";
        readonly serviceAssetKey: "cognito";
        readonly generalIconKey: "traditional_server";
        readonly drawioGeneralShape: "traditional_server";
    };
    readonly "AWS::Cognito::UserPoolRiskConfigurationAttachment": {
        readonly service: "Cognito";
        readonly serviceAssetKey: "cognito";
        readonly generalIconKey: "attachment";
        readonly drawioGeneralShape: "transit_gateway_attachment";
    };
    readonly "AWS::Cognito::UserPoolUICustomizationAttachment": {
        readonly service: "Cognito";
        readonly serviceAssetKey: "cognito";
        readonly generalIconKey: "attachment";
        readonly drawioGeneralShape: "transit_gateway_attachment";
    };
    readonly "AWS::Cognito::UserPoolUser": {
        readonly service: "Cognito";
        readonly serviceAssetKey: "cognito";
        readonly generalIconKey: "user";
        readonly drawioGeneralShape: "user";
    };
    readonly "AWS::Cognito::UserPoolUserToGroupAttachment": {
        readonly service: "Cognito";
        readonly serviceAssetKey: "cognito";
        readonly generalIconKey: "attachment";
        readonly drawioGeneralShape: "transit_gateway_attachment";
    };
    readonly "AWS::Config::AggregationAuthorization": {
        readonly service: "Config";
        readonly serviceAssetKey: "config";
    };
    readonly "AWS::Config::ConfigRule": {
        readonly service: "Config";
        readonly serviceAssetKey: "config";
        readonly generalIconKey: "rule";
        readonly drawioGeneralShape: "rule";
    };
    readonly "AWS::Config::ConfigurationAggregator": {
        readonly service: "Config";
        readonly serviceAssetKey: "config";
    };
    readonly "AWS::Config::ConfigurationRecorder": {
        readonly service: "Config";
        readonly serviceAssetKey: "config";
    };
    readonly "AWS::Config::ConformancePack": {
        readonly service: "Config";
        readonly serviceAssetKey: "config";
    };
    readonly "AWS::Config::DeliveryChannel": {
        readonly service: "Config";
        readonly serviceAssetKey: "config";
    };
    readonly "AWS::Config::OrganizationConfigRule": {
        readonly service: "Config";
        readonly serviceAssetKey: "config";
        readonly generalIconKey: "rule";
        readonly drawioGeneralShape: "rule";
    };
    readonly "AWS::Config::OrganizationConformancePack": {
        readonly service: "Config";
        readonly serviceAssetKey: "config";
    };
    readonly "AWS::Config::RemediationConfiguration": {
        readonly service: "Config";
        readonly serviceAssetKey: "config";
        readonly generalIconKey: "config";
        readonly drawioGeneralShape: "gear";
    };
    readonly "AWS::Config::StoredQuery": {
        readonly service: "Config";
        readonly serviceAssetKey: "config";
    };
    readonly "AWS::Connect::ApprovedOrigin": {
        readonly service: "Connect";
        readonly serviceAssetKey: "connect";
    };
    readonly "AWS::Connect::ContactFlow": {
        readonly service: "Connect";
        readonly serviceAssetKey: "connect";
    };
    readonly "AWS::Connect::ContactFlowModule": {
        readonly service: "Connect";
        readonly serviceAssetKey: "connect";
    };
    readonly "AWS::Connect::HoursOfOperation": {
        readonly service: "Connect";
        readonly serviceAssetKey: "connect";
    };
    readonly "AWS::Connect::Instance": {
        readonly service: "Connect";
        readonly serviceAssetKey: "connect";
    };
    readonly "AWS::Connect::InstanceStorageConfig": {
        readonly service: "Connect";
        readonly serviceAssetKey: "connect";
        readonly generalIconKey: "config";
        readonly drawioGeneralShape: "gear";
    };
    readonly "AWS::Connect::IntegrationAssociation": {
        readonly service: "Connect";
        readonly serviceAssetKey: "connect";
    };
    readonly "AWS::Connect::PhoneNumber": {
        readonly service: "Connect";
        readonly serviceAssetKey: "connect";
    };
    readonly "AWS::Connect::QuickConnect": {
        readonly service: "Connect";
        readonly serviceAssetKey: "connect";
    };
    readonly "AWS::Connect::Rule": {
        readonly service: "Connect";
        readonly serviceAssetKey: "connect";
        readonly generalIconKey: "rule";
        readonly drawioGeneralShape: "rule";
    };
    readonly "AWS::Connect::SecurityKey": {
        readonly service: "Connect";
        readonly serviceAssetKey: "connect";
        readonly generalIconKey: "key";
        readonly drawioGeneralShape: "permissions";
    };
    readonly "AWS::Connect::TaskTemplate": {
        readonly service: "Connect";
        readonly serviceAssetKey: "connect";
        readonly generalIconKey: "template";
        readonly drawioGeneralShape: "template";
    };
    readonly "AWS::Connect::User": {
        readonly service: "Connect";
        readonly serviceAssetKey: "connect";
        readonly generalIconKey: "user";
        readonly drawioGeneralShape: "user";
    };
    readonly "AWS::Connect::UserHierarchyGroup": {
        readonly service: "Connect";
        readonly serviceAssetKey: "connect";
    };
    readonly "AWS::ConnectCampaigns::Campaign": {
        readonly service: "ConnectCampaigns";
        readonly serviceAssetKey: "connect";
    };
    readonly "AWS::ControlTower::EnabledControl": {
        readonly service: "ControlTower";
        readonly serviceAssetKey: "control_tower";
    };
    readonly "AWS::CustomerProfiles::Domain": {
        readonly service: "CustomerProfiles";
        readonly serviceAssetKey: "connect";
    };
    readonly "AWS::CustomerProfiles::Integration": {
        readonly service: "CustomerProfiles";
        readonly serviceAssetKey: "connect";
    };
    readonly "AWS::CustomerProfiles::ObjectType": {
        readonly service: "CustomerProfiles";
        readonly serviceAssetKey: "connect";
    };
    readonly "AWS::DAX::Cluster": {
        readonly service: "DAX";
        readonly serviceAssetKey: "data_exchange";
    };
    readonly "AWS::DAX::ParameterGroup": {
        readonly service: "DAX";
        readonly serviceAssetKey: "data_exchange";
    };
    readonly "AWS::DAX::SubnetGroup": {
        readonly service: "DAX";
        readonly serviceAssetKey: "data_exchange";
    };
    readonly "AWS::DLM::LifecyclePolicy": {
        readonly service: "DLM";
        readonly serviceAssetKey: "ebs";
        readonly generalIconKey: "policy";
        readonly drawioGeneralShape: "addon";
    };
    readonly "AWS::DMS::Certificate": {
        readonly service: "DMS";
        readonly serviceAssetKey: "database_migration_service";
        readonly generalIconKey: "ssl_padlock";
        readonly drawioGeneralShape: "ssl_padlock";
    };
    readonly "AWS::DMS::Endpoint": {
        readonly service: "DMS";
        readonly serviceAssetKey: "database_migration_service";
    };
    readonly "AWS::DMS::EventSubscription": {
        readonly service: "DMS";
        readonly serviceAssetKey: "database_migration_service";
    };
    readonly "AWS::DMS::ReplicationInstance": {
        readonly service: "DMS";
        readonly serviceAssetKey: "database_migration_service";
    };
    readonly "AWS::DMS::ReplicationSubnetGroup": {
        readonly service: "DMS";
        readonly serviceAssetKey: "database_migration_service";
    };
    readonly "AWS::DMS::ReplicationTask": {
        readonly service: "DMS";
        readonly serviceAssetKey: "database_migration_service";
    };
    readonly "AWS::DataBrew::Dataset": {
        readonly service: "DataBrew";
        readonly serviceAssetKey: "glue_databrew";
    };
    readonly "AWS::DataBrew::Job": {
        readonly service: "DataBrew";
        readonly serviceAssetKey: "glue_databrew";
    };
    readonly "AWS::DataBrew::Project": {
        readonly service: "DataBrew";
        readonly serviceAssetKey: "glue_databrew";
    };
    readonly "AWS::DataBrew::Recipe": {
        readonly service: "DataBrew";
        readonly serviceAssetKey: "glue_databrew";
    };
    readonly "AWS::DataBrew::Ruleset": {
        readonly service: "DataBrew";
        readonly serviceAssetKey: "glue_databrew";
    };
    readonly "AWS::DataBrew::Schedule": {
        readonly service: "DataBrew";
        readonly serviceAssetKey: "glue_databrew";
    };
    readonly "AWS::DataPipeline::Pipeline": {
        readonly service: "DataPipeline";
        readonly serviceAssetKey: "data_pipeline";
    };
    readonly "AWS::DataSync::Agent": {
        readonly service: "DataSync";
        readonly serviceAssetKey: "datasync";
        readonly assetKey: "datasync_agent";
        readonly drawioShape: "agent2";
    };
    readonly "AWS::DataSync::LocationEFS": {
        readonly service: "DataSync";
        readonly serviceAssetKey: "datasync";
    };
    readonly "AWS::DataSync::LocationFSxLustre": {
        readonly service: "DataSync";
        readonly serviceAssetKey: "datasync";
    };
    readonly "AWS::DataSync::LocationFSxONTAP": {
        readonly service: "DataSync";
        readonly serviceAssetKey: "datasync";
    };
    readonly "AWS::DataSync::LocationFSxOpenZFS": {
        readonly service: "DataSync";
        readonly serviceAssetKey: "datasync";
    };
    readonly "AWS::DataSync::LocationFSxWindows": {
        readonly service: "DataSync";
        readonly serviceAssetKey: "datasync";
    };
    readonly "AWS::DataSync::LocationHDFS": {
        readonly service: "DataSync";
        readonly serviceAssetKey: "datasync";
    };
    readonly "AWS::DataSync::LocationNFS": {
        readonly service: "DataSync";
        readonly serviceAssetKey: "datasync";
    };
    readonly "AWS::DataSync::LocationObjectStorage": {
        readonly service: "DataSync";
        readonly serviceAssetKey: "datasync";
    };
    readonly "AWS::DataSync::LocationS3": {
        readonly service: "DataSync";
        readonly serviceAssetKey: "datasync";
    };
    readonly "AWS::DataSync::LocationSMB": {
        readonly service: "DataSync";
        readonly serviceAssetKey: "datasync";
    };
    readonly "AWS::DataSync::Task": {
        readonly service: "DataSync";
        readonly serviceAssetKey: "datasync";
    };
    readonly "AWS::Detective::Graph": {
        readonly service: "Detective";
        readonly serviceAssetKey: "detective";
    };
    readonly "AWS::Detective::MemberInvitation": {
        readonly service: "Detective";
        readonly serviceAssetKey: "detective";
    };
    readonly "AWS::DevOpsGuru::NotificationChannel": {
        readonly service: "DevOpsGuru";
        readonly serviceAssetKey: "devops_guru";
    };
    readonly "AWS::DevOpsGuru::ResourceCollection": {
        readonly service: "DevOpsGuru";
        readonly serviceAssetKey: "devops_guru";
    };
    readonly "AWS::DeviceFarm::DevicePool": {
        readonly service: "DeviceFarm";
        readonly serviceAssetKey: "device_farm";
    };
    readonly "AWS::DeviceFarm::InstanceProfile": {
        readonly service: "DeviceFarm";
        readonly serviceAssetKey: "device_farm";
    };
    readonly "AWS::DeviceFarm::NetworkProfile": {
        readonly service: "DeviceFarm";
        readonly serviceAssetKey: "device_farm";
    };
    readonly "AWS::DeviceFarm::Project": {
        readonly service: "DeviceFarm";
        readonly serviceAssetKey: "device_farm";
    };
    readonly "AWS::DeviceFarm::TestGridProject": {
        readonly service: "DeviceFarm";
        readonly serviceAssetKey: "device_farm";
    };
    readonly "AWS::DeviceFarm::VPCEConfiguration": {
        readonly service: "DeviceFarm";
        readonly serviceAssetKey: "device_farm";
        readonly generalIconKey: "config";
        readonly drawioGeneralShape: "gear";
    };
    readonly "AWS::DirectoryService::MicrosoftAD": {
        readonly service: "DirectoryService";
        readonly serviceAssetKey: "directory_service";
    };
    readonly "AWS::DirectoryService::SimpleAD": {
        readonly service: "DirectoryService";
        readonly serviceAssetKey: "directory_service";
        readonly assetKey: "directory_service_simple_ad";
        readonly drawioShape: "simple_ad";
    };
    readonly "AWS::DocDB::DBCluster": {
        readonly service: "DocDB";
        readonly serviceAssetKey: "documentdb";
    };
    readonly "AWS::DocDB::DBClusterParameterGroup": {
        readonly service: "DocDB";
        readonly serviceAssetKey: "documentdb";
    };
    readonly "AWS::DocDB::DBInstance": {
        readonly service: "DocDB";
        readonly serviceAssetKey: "documentdb";
    };
    readonly "AWS::DocDB::DBSubnetGroup": {
        readonly service: "DocDB";
        readonly serviceAssetKey: "documentdb";
    };
    readonly "AWS::DocDBElastic::Cluster": {
        readonly service: "DocDBElastic";
    };
    readonly "AWS::DynamoDB::GlobalTable": {
        readonly service: "DynamoDB";
        readonly serviceAssetKey: "dynamodb";
    };
    readonly "AWS::DynamoDB::Table": {
        readonly service: "DynamoDB";
        readonly serviceAssetKey: "dynamodb";
        readonly assetKey: "dynamodb_table";
        readonly drawioShape: "table";
    };
    readonly "AWS::EC2::CapacityReservation": {
        readonly service: "EC2";
        readonly serviceAssetKey: "ec2";
    };
    readonly "AWS::EC2::CapacityReservationFleet": {
        readonly service: "EC2";
        readonly serviceAssetKey: "ec2";
    };
    readonly "AWS::EC2::CarrierGateway": {
        readonly service: "EC2";
        readonly serviceAssetKey: "vpc";
        readonly assetKey: "vpc_carrier_gateway";
        readonly drawioShape: "vpc_carrier_gateway";
    };
    readonly "AWS::EC2::ClientVpnAuthorizationRule": {
        readonly service: "EC2";
        readonly serviceAssetKey: "ec2";
        readonly generalIconKey: "rule";
        readonly drawioGeneralShape: "rule";
    };
    readonly "AWS::EC2::ClientVpnEndpoint": {
        readonly service: "EC2";
        readonly serviceAssetKey: "ec2";
    };
    readonly "AWS::EC2::ClientVpnRoute": {
        readonly service: "EC2";
        readonly serviceAssetKey: "ec2";
    };
    readonly "AWS::EC2::ClientVpnTargetNetworkAssociation": {
        readonly service: "EC2";
        readonly serviceAssetKey: "ec2";
    };
    readonly "AWS::EC2::CustomerGateway": {
        readonly service: "EC2";
        readonly serviceAssetKey: "vpc";
        readonly assetKey: "vpc_customer_gateway";
        readonly drawioShape: "customer_gateway";
    };
    readonly "AWS::EC2::DHCPOptions": {
        readonly service: "EC2";
        readonly serviceAssetKey: "ec2";
    };
    readonly "AWS::EC2::EC2Fleet": {
        readonly service: "EC2";
        readonly serviceAssetKey: "ec2";
    };
    readonly "AWS::EC2::EIP": {
        readonly service: "EC2";
        readonly serviceAssetKey: "ec2";
    };
    readonly "AWS::EC2::EIPAssociation": {
        readonly service: "EC2";
        readonly serviceAssetKey: "ec2";
    };
    readonly "AWS::EC2::EgressOnlyInternetGateway": {
        readonly service: "EC2";
        readonly serviceAssetKey: "ec2";
    };
    readonly "AWS::EC2::EnclaveCertificateIamRoleAssociation": {
        readonly service: "EC2";
        readonly serviceAssetKey: "ec2";
    };
    readonly "AWS::EC2::FlowLog": {
        readonly service: "EC2";
        readonly serviceAssetKey: "ec2";
        readonly generalIconKey: "logs";
        readonly drawioGeneralShape: "logs";
    };
    readonly "AWS::EC2::GatewayRouteTableAssociation": {
        readonly service: "EC2";
        readonly serviceAssetKey: "ec2";
    };
    readonly "AWS::EC2::Host": {
        readonly service: "EC2";
        readonly serviceAssetKey: "ec2";
    };
    readonly "AWS::EC2::IPAM": {
        readonly service: "EC2";
        readonly serviceAssetKey: "ec2";
    };
    readonly "AWS::EC2::IPAMAllocation": {
        readonly service: "EC2";
        readonly serviceAssetKey: "ec2";
    };
    readonly "AWS::EC2::IPAMPool": {
        readonly service: "EC2";
        readonly serviceAssetKey: "ec2";
    };
    readonly "AWS::EC2::IPAMScope": {
        readonly service: "EC2";
        readonly serviceAssetKey: "ec2";
    };
    readonly "AWS::EC2::Instance": {
        readonly service: "EC2";
        readonly serviceAssetKey: "ec2";
        readonly assetKey: "ec2_instance";
        readonly drawioShape: "instance";
    };
    readonly "AWS::EC2::InternetGateway": {
        readonly service: "EC2";
        readonly serviceAssetKey: "vpc";
        readonly assetKey: "vpc_internet_gateway";
        readonly drawioShape: "internet_gateway";
    };
    readonly "AWS::EC2::KeyPair": {
        readonly service: "EC2";
        readonly serviceAssetKey: "ec2";
    };
    readonly "AWS::EC2::LaunchTemplate": {
        readonly service: "EC2";
        readonly serviceAssetKey: "ec2";
        readonly generalIconKey: "template";
        readonly drawioGeneralShape: "template";
    };
    readonly "AWS::EC2::LocalGatewayRoute": {
        readonly service: "EC2";
        readonly serviceAssetKey: "ec2";
    };
    readonly "AWS::EC2::LocalGatewayRouteTableVPCAssociation": {
        readonly service: "EC2";
        readonly serviceAssetKey: "ec2";
    };
    readonly "AWS::EC2::NatGateway": {
        readonly service: "EC2";
        readonly serviceAssetKey: "vpc";
        readonly assetKey: "vpc_nat_gateway";
        readonly drawioShape: "nat_gateway";
    };
    readonly "AWS::EC2::NetworkAcl": {
        readonly service: "EC2";
        readonly serviceAssetKey: "ec2";
        readonly assetKey: "vpc_network_access_control_list";
        readonly drawioShape: "network_access_control_list";
    };
    readonly "AWS::EC2::NetworkAclEntry": {
        readonly service: "EC2";
        readonly serviceAssetKey: "ec2";
    };
    readonly "AWS::EC2::NetworkInsightsAccessScope": {
        readonly service: "EC2";
        readonly serviceAssetKey: "ec2";
    };
    readonly "AWS::EC2::NetworkInsightsAccessScopeAnalysis": {
        readonly service: "EC2";
        readonly serviceAssetKey: "ec2";
    };
    readonly "AWS::EC2::NetworkInsightsAnalysis": {
        readonly service: "EC2";
        readonly serviceAssetKey: "ec2";
    };
    readonly "AWS::EC2::NetworkInsightsPath": {
        readonly service: "EC2";
        readonly serviceAssetKey: "ec2";
    };
    readonly "AWS::EC2::NetworkInterface": {
        readonly service: "EC2";
        readonly serviceAssetKey: "ec2";
        readonly assetKey: "vpc_elastic_network_interface";
        readonly drawioShape: "elastic_network_interface";
    };
    readonly "AWS::EC2::NetworkInterfaceAttachment": {
        readonly service: "EC2";
        readonly serviceAssetKey: "ec2";
        readonly generalIconKey: "attachment";
        readonly drawioGeneralShape: "transit_gateway_attachment";
    };
    readonly "AWS::EC2::NetworkInterfacePermission": {
        readonly service: "EC2";
        readonly serviceAssetKey: "ec2";
        readonly generalIconKey: "policy";
        readonly drawioGeneralShape: "addon";
    };
    readonly "AWS::EC2::NetworkPerformanceMetricSubscription": {
        readonly service: "EC2";
        readonly serviceAssetKey: "ec2";
    };
    readonly "AWS::EC2::PlacementGroup": {
        readonly service: "EC2";
        readonly serviceAssetKey: "ec2";
    };
    readonly "AWS::EC2::PrefixList": {
        readonly service: "EC2";
        readonly serviceAssetKey: "ec2";
    };
    readonly "AWS::EC2::Route": {
        readonly service: "EC2";
        readonly serviceAssetKey: "ec2";
    };
    readonly "AWS::EC2::RouteTable": {
        readonly service: "EC2";
        readonly serviceAssetKey: "ec2";
    };
    readonly "AWS::EC2::SecurityGroup": {
        readonly service: "EC2";
        readonly serviceAssetKey: "ec2";
    };
    readonly "AWS::EC2::SecurityGroupEgress": {
        readonly service: "EC2";
        readonly serviceAssetKey: "ec2";
    };
    readonly "AWS::EC2::SecurityGroupIngress": {
        readonly service: "EC2";
        readonly serviceAssetKey: "ec2";
    };
    readonly "AWS::EC2::SpotFleet": {
        readonly service: "EC2";
        readonly serviceAssetKey: "ec2";
    };
    readonly "AWS::EC2::Subnet": {
        readonly service: "EC2";
        readonly serviceAssetKey: "ec2";
    };
    readonly "AWS::EC2::SubnetCidrBlock": {
        readonly service: "EC2";
        readonly serviceAssetKey: "ec2";
    };
    readonly "AWS::EC2::SubnetNetworkAclAssociation": {
        readonly service: "EC2";
        readonly serviceAssetKey: "ec2";
    };
    readonly "AWS::EC2::SubnetRouteTableAssociation": {
        readonly service: "EC2";
        readonly serviceAssetKey: "ec2";
    };
    readonly "AWS::EC2::TrafficMirrorFilter": {
        readonly service: "EC2";
        readonly serviceAssetKey: "ec2";
    };
    readonly "AWS::EC2::TrafficMirrorFilterRule": {
        readonly service: "EC2";
        readonly serviceAssetKey: "ec2";
        readonly generalIconKey: "rule";
        readonly drawioGeneralShape: "rule";
    };
    readonly "AWS::EC2::TrafficMirrorSession": {
        readonly service: "EC2";
        readonly serviceAssetKey: "ec2";
    };
    readonly "AWS::EC2::TrafficMirrorTarget": {
        readonly service: "EC2";
        readonly serviceAssetKey: "ec2";
    };
    readonly "AWS::EC2::TransitGateway": {
        readonly service: "EC2";
        readonly serviceAssetKey: "ec2";
    };
    readonly "AWS::EC2::TransitGatewayAttachment": {
        readonly service: "EC2";
        readonly serviceAssetKey: "ec2";
        readonly assetKey: "transit_gateway_attachment";
        readonly generalIconKey: "attachment";
        readonly drawioShape: "transit_gateway_attachment";
        readonly drawioGeneralShape: "transit_gateway_attachment";
    };
    readonly "AWS::EC2::TransitGatewayConnect": {
        readonly service: "EC2";
        readonly serviceAssetKey: "ec2";
    };
    readonly "AWS::EC2::TransitGatewayMulticastDomain": {
        readonly service: "EC2";
        readonly serviceAssetKey: "ec2";
    };
    readonly "AWS::EC2::TransitGatewayMulticastDomainAssociation": {
        readonly service: "EC2";
        readonly serviceAssetKey: "ec2";
    };
    readonly "AWS::EC2::TransitGatewayMulticastGroupMember": {
        readonly service: "EC2";
        readonly serviceAssetKey: "ec2";
    };
    readonly "AWS::EC2::TransitGatewayMulticastGroupSource": {
        readonly service: "EC2";
        readonly serviceAssetKey: "ec2";
    };
    readonly "AWS::EC2::TransitGatewayPeeringAttachment": {
        readonly service: "EC2";
        readonly serviceAssetKey: "ec2";
        readonly generalIconKey: "attachment";
        readonly drawioGeneralShape: "transit_gateway_attachment";
    };
    readonly "AWS::EC2::TransitGatewayRoute": {
        readonly service: "EC2";
        readonly serviceAssetKey: "ec2";
    };
    readonly "AWS::EC2::TransitGatewayRouteTable": {
        readonly service: "EC2";
        readonly serviceAssetKey: "ec2";
    };
    readonly "AWS::EC2::TransitGatewayRouteTableAssociation": {
        readonly service: "EC2";
        readonly serviceAssetKey: "ec2";
    };
    readonly "AWS::EC2::TransitGatewayRouteTablePropagation": {
        readonly service: "EC2";
        readonly serviceAssetKey: "ec2";
    };
    readonly "AWS::EC2::TransitGatewayVpcAttachment": {
        readonly service: "EC2";
        readonly serviceAssetKey: "ec2";
        readonly generalIconKey: "attachment";
        readonly drawioGeneralShape: "transit_gateway_attachment";
    };
    readonly "AWS::EC2::VPC": {
        readonly service: "EC2";
        readonly serviceAssetKey: "vpc";
    };
    readonly "AWS::EC2::VPCCidrBlock": {
        readonly service: "EC2";
        readonly serviceAssetKey: "vpc";
    };
    readonly "AWS::EC2::VPCDHCPOptionsAssociation": {
        readonly service: "EC2";
        readonly serviceAssetKey: "vpc";
    };
    readonly "AWS::EC2::VPCEndpoint": {
        readonly service: "EC2";
        readonly serviceAssetKey: "vpc";
    };
    readonly "AWS::EC2::VPCEndpointConnectionNotification": {
        readonly service: "EC2";
        readonly serviceAssetKey: "vpc";
    };
    readonly "AWS::EC2::VPCEndpointService": {
        readonly service: "EC2";
        readonly serviceAssetKey: "vpc";
    };
    readonly "AWS::EC2::VPCEndpointServicePermissions": {
        readonly service: "EC2";
        readonly serviceAssetKey: "vpc";
        readonly generalIconKey: "policy";
        readonly drawioGeneralShape: "addon";
    };
    readonly "AWS::EC2::VPCGatewayAttachment": {
        readonly service: "EC2";
        readonly serviceAssetKey: "vpc";
        readonly generalIconKey: "attachment";
        readonly drawioGeneralShape: "transit_gateway_attachment";
    };
    readonly "AWS::EC2::VPCPeeringConnection": {
        readonly service: "EC2";
        readonly serviceAssetKey: "vpc";
        readonly assetKey: "vpc_peering_connection";
        readonly drawioShape: "peering";
    };
    readonly "AWS::EC2::VPNConnection": {
        readonly service: "EC2";
        readonly serviceAssetKey: "vpc";
        readonly assetKey: "vpc_vpn_connection";
        readonly drawioShape: "vpn_connection";
    };
    readonly "AWS::EC2::VPNConnectionRoute": {
        readonly service: "EC2";
        readonly serviceAssetKey: "ec2";
    };
    readonly "AWS::EC2::VPNGateway": {
        readonly service: "EC2";
        readonly serviceAssetKey: "vpc";
        readonly assetKey: "vpc_vpn_gateway";
        readonly drawioShape: "vpn_gateway";
    };
    readonly "AWS::EC2::VPNGatewayRoutePropagation": {
        readonly service: "EC2";
        readonly serviceAssetKey: "ec2";
    };
    readonly "AWS::EC2::Volume": {
        readonly service: "EC2";
        readonly serviceAssetKey: "ec2";
    };
    readonly "AWS::EC2::VolumeAttachment": {
        readonly service: "EC2";
        readonly serviceAssetKey: "ec2";
        readonly generalIconKey: "attachment";
        readonly drawioGeneralShape: "transit_gateway_attachment";
    };
    readonly "AWS::ECR::PublicRepository": {
        readonly service: "ECR";
        readonly serviceAssetKey: "ecr";
    };
    readonly "AWS::ECR::PullThroughCacheRule": {
        readonly service: "ECR";
        readonly serviceAssetKey: "ecr";
        readonly generalIconKey: "rule";
        readonly drawioGeneralShape: "rule";
    };
    readonly "AWS::ECR::RegistryPolicy": {
        readonly service: "ECR";
        readonly serviceAssetKey: "ecr";
        readonly generalIconKey: "policy";
        readonly drawioGeneralShape: "addon";
    };
    readonly "AWS::ECR::ReplicationConfiguration": {
        readonly service: "ECR";
        readonly serviceAssetKey: "ecr";
        readonly generalIconKey: "config";
        readonly drawioGeneralShape: "gear";
    };
    readonly "AWS::ECR::Repository": {
        readonly service: "ECR";
        readonly serviceAssetKey: "ecr";
    };
    readonly "AWS::ECS::CapacityProvider": {
        readonly service: "ECS";
        readonly serviceAssetKey: "ecs";
    };
    readonly "AWS::ECS::Cluster": {
        readonly service: "ECS";
        readonly serviceAssetKey: "ecs";
    };
    readonly "AWS::ECS::ClusterCapacityProviderAssociations": {
        readonly service: "ECS";
        readonly serviceAssetKey: "ecs";
    };
    readonly "AWS::ECS::PrimaryTaskSet": {
        readonly service: "ECS";
        readonly serviceAssetKey: "ecs";
    };
    readonly "AWS::ECS::Service": {
        readonly service: "ECS";
        readonly serviceAssetKey: "ecs";
        readonly assetKey: "ecs_service";
        readonly drawioShape: "ecs";
    };
    readonly "AWS::ECS::TaskDefinition": {
        readonly service: "ECS";
        readonly serviceAssetKey: "ecs";
    };
    readonly "AWS::ECS::TaskSet": {
        readonly service: "ECS";
        readonly serviceAssetKey: "ecs";
    };
    readonly "AWS::EFS::AccessPoint": {
        readonly service: "EFS";
        readonly serviceAssetKey: "efs";
    };
    readonly "AWS::EFS::FileSystem": {
        readonly service: "EFS";
        readonly serviceAssetKey: "efs";
        readonly assetKey: "efs_file_system";
        readonly drawioShape: "file_system";
    };
    readonly "AWS::EFS::MountTarget": {
        readonly service: "EFS";
        readonly serviceAssetKey: "efs";
    };
    readonly "AWS::EKS::Addon": {
        readonly service: "EKS";
        readonly serviceAssetKey: "eks";
    };
    readonly "AWS::EKS::Cluster": {
        readonly service: "EKS";
        readonly serviceAssetKey: "eks";
    };
    readonly "AWS::EKS::FargateProfile": {
        readonly service: "EKS";
        readonly serviceAssetKey: "eks";
    };
    readonly "AWS::EKS::IdentityProviderConfig": {
        readonly service: "EKS";
        readonly serviceAssetKey: "eks";
        readonly generalIconKey: "config";
        readonly drawioGeneralShape: "gear";
    };
    readonly "AWS::EKS::Nodegroup": {
        readonly service: "EKS";
        readonly serviceAssetKey: "eks";
    };
    readonly "AWS::EMR::Cluster": {
        readonly service: "EMR";
        readonly serviceAssetKey: "emr";
        readonly assetKey: "emr_cluster";
        readonly drawioShape: "cluster";
    };
    readonly "AWS::EMR::InstanceFleetConfig": {
        readonly service: "EMR";
        readonly serviceAssetKey: "emr";
        readonly generalIconKey: "config";
        readonly drawioGeneralShape: "gear";
    };
    readonly "AWS::EMR::InstanceGroupConfig": {
        readonly service: "EMR";
        readonly serviceAssetKey: "emr";
        readonly generalIconKey: "config";
        readonly drawioGeneralShape: "gear";
    };
    readonly "AWS::EMR::SecurityConfiguration": {
        readonly service: "EMR";
        readonly serviceAssetKey: "emr";
        readonly generalIconKey: "config";
        readonly drawioGeneralShape: "gear";
    };
    readonly "AWS::EMR::Step": {
        readonly service: "EMR";
        readonly serviceAssetKey: "emr";
    };
    readonly "AWS::EMR::Studio": {
        readonly service: "EMR";
        readonly serviceAssetKey: "emr";
    };
    readonly "AWS::EMR::StudioSessionMapping": {
        readonly service: "EMR";
        readonly serviceAssetKey: "emr";
    };
    readonly "AWS::EMRContainers::VirtualCluster": {
        readonly service: "EMRContainers";
        readonly serviceAssetKey: "emr";
    };
    readonly "AWS::EMRServerless::Application": {
        readonly service: "EMRServerless";
        readonly serviceAssetKey: "emr";
        readonly generalIconKey: "generic_application";
    };
    readonly "AWS::ElastiCache::CacheCluster": {
        readonly service: "ElastiCache";
        readonly serviceAssetKey: "elasticache";
    };
    readonly "AWS::ElastiCache::GlobalReplicationGroup": {
        readonly service: "ElastiCache";
        readonly serviceAssetKey: "elasticache";
    };
    readonly "AWS::ElastiCache::ParameterGroup": {
        readonly service: "ElastiCache";
        readonly serviceAssetKey: "elasticache";
    };
    readonly "AWS::ElastiCache::ReplicationGroup": {
        readonly service: "ElastiCache";
        readonly serviceAssetKey: "elasticache";
    };
    readonly "AWS::ElastiCache::SecurityGroup": {
        readonly service: "ElastiCache";
        readonly serviceAssetKey: "elasticache";
    };
    readonly "AWS::ElastiCache::SecurityGroupIngress": {
        readonly service: "ElastiCache";
        readonly serviceAssetKey: "elasticache";
    };
    readonly "AWS::ElastiCache::SubnetGroup": {
        readonly service: "ElastiCache";
        readonly serviceAssetKey: "elasticache";
    };
    readonly "AWS::ElastiCache::User": {
        readonly service: "ElastiCache";
        readonly serviceAssetKey: "elasticache";
        readonly generalIconKey: "user";
        readonly drawioGeneralShape: "user";
    };
    readonly "AWS::ElastiCache::UserGroup": {
        readonly service: "ElastiCache";
        readonly serviceAssetKey: "elasticache";
    };
    readonly "AWS::ElasticBeanstalk::Application": {
        readonly service: "ElasticBeanstalk";
        readonly serviceAssetKey: "elastic_beanstalk";
        readonly assetKey: "elastic_beanstalk_application";
        readonly generalIconKey: "generic_application";
        readonly drawioShape: "application";
    };
    readonly "AWS::ElasticBeanstalk::ApplicationVersion": {
        readonly service: "ElasticBeanstalk";
        readonly serviceAssetKey: "elastic_beanstalk";
    };
    readonly "AWS::ElasticBeanstalk::ConfigurationTemplate": {
        readonly service: "ElasticBeanstalk";
        readonly serviceAssetKey: "elastic_beanstalk";
        readonly generalIconKey: "template";
        readonly drawioGeneralShape: "template";
    };
    readonly "AWS::ElasticBeanstalk::Environment": {
        readonly service: "ElasticBeanstalk";
        readonly serviceAssetKey: "elastic_beanstalk";
    };
    readonly "AWS::ElasticLoadBalancing::LoadBalancer": {
        readonly service: "ElasticLoadBalancing";
        readonly serviceAssetKey: "elastic_load_balancing";
    };
    readonly "AWS::ElasticLoadBalancingV2::Listener": {
        readonly service: "ElasticLoadBalancingV2";
        readonly serviceAssetKey: "elastic_load_balancing";
    };
    readonly "AWS::ElasticLoadBalancingV2::ListenerCertificate": {
        readonly service: "ElasticLoadBalancingV2";
        readonly serviceAssetKey: "elastic_load_balancing";
    };
    readonly "AWS::ElasticLoadBalancingV2::ListenerRule": {
        readonly service: "ElasticLoadBalancingV2";
        readonly serviceAssetKey: "elastic_load_balancing";
        readonly generalIconKey: "rule";
        readonly drawioGeneralShape: "rule";
    };
    readonly "AWS::ElasticLoadBalancingV2::LoadBalancer": {
        readonly service: "ElasticLoadBalancingV2";
        readonly serviceAssetKey: "elastic_load_balancing";
    };
    readonly "AWS::ElasticLoadBalancingV2::TargetGroup": {
        readonly service: "ElasticLoadBalancingV2";
        readonly serviceAssetKey: "elastic_load_balancing";
    };
    readonly "AWS::Elasticsearch::Domain": {
        readonly service: "Elasticsearch";
        readonly serviceAssetKey: "opensearch";
    };
    readonly "AWS::EventSchemas::Discoverer": {
        readonly service: "EventSchemas";
        readonly serviceAssetKey: "eventbridge";
    };
    readonly "AWS::EventSchemas::Registry": {
        readonly service: "EventSchemas";
        readonly serviceAssetKey: "eventbridge";
    };
    readonly "AWS::EventSchemas::RegistryPolicy": {
        readonly service: "EventSchemas";
        readonly serviceAssetKey: "eventbridge";
        readonly generalIconKey: "policy";
        readonly drawioGeneralShape: "addon";
    };
    readonly "AWS::EventSchemas::Schema": {
        readonly service: "EventSchemas";
        readonly serviceAssetKey: "eventbridge";
        readonly assetKey: "eventbridge_schema";
        readonly drawioShape: "eventbridge_schema";
    };
    readonly "AWS::Events::ApiDestination": {
        readonly service: "Events";
        readonly serviceAssetKey: "eventbridge";
    };
    readonly "AWS::Events::Archive": {
        readonly service: "Events";
        readonly serviceAssetKey: "eventbridge";
    };
    readonly "AWS::Events::Connection": {
        readonly service: "Events";
        readonly serviceAssetKey: "eventbridge";
    };
    readonly "AWS::Events::Endpoint": {
        readonly service: "Events";
        readonly serviceAssetKey: "eventbridge";
    };
    readonly "AWS::Events::EventBus": {
        readonly service: "Events";
        readonly serviceAssetKey: "eventbridge";
    };
    readonly "AWS::Events::EventBusPolicy": {
        readonly service: "Events";
        readonly serviceAssetKey: "eventbridge";
        readonly generalIconKey: "policy";
        readonly drawioGeneralShape: "addon";
    };
    readonly "AWS::Events::Rule": {
        readonly service: "Events";
        readonly serviceAssetKey: "eventbridge";
        readonly assetKey: "eventbridge_rule";
        readonly generalIconKey: "rule";
        readonly drawioGeneralShape: "rule";
    };
    readonly "AWS::Evidently::Experiment": {
        readonly service: "Evidently";
        readonly serviceAssetKey: "cloudwatch";
    };
    readonly "AWS::Evidently::Feature": {
        readonly service: "Evidently";
        readonly serviceAssetKey: "cloudwatch";
    };
    readonly "AWS::Evidently::Launch": {
        readonly service: "Evidently";
        readonly serviceAssetKey: "cloudwatch";
    };
    readonly "AWS::Evidently::Project": {
        readonly service: "Evidently";
        readonly serviceAssetKey: "cloudwatch";
    };
    readonly "AWS::Evidently::Segment": {
        readonly service: "Evidently";
        readonly serviceAssetKey: "cloudwatch";
    };
    readonly "AWS::FIS::ExperimentTemplate": {
        readonly service: "FIS";
        readonly serviceAssetKey: "fault_injection_simulator";
        readonly generalIconKey: "template";
        readonly drawioGeneralShape: "template";
    };
    readonly "AWS::FMS::NotificationChannel": {
        readonly service: "FMS";
        readonly serviceAssetKey: "network_firewall";
    };
    readonly "AWS::FMS::Policy": {
        readonly service: "FMS";
        readonly serviceAssetKey: "network_firewall";
        readonly generalIconKey: "policy";
        readonly drawioGeneralShape: "addon";
    };
    readonly "AWS::FSx::DataRepositoryAssociation": {
        readonly service: "FSx";
        readonly serviceAssetKey: "fsx";
    };
    readonly "AWS::FSx::FileSystem": {
        readonly service: "FSx";
        readonly serviceAssetKey: "fsx";
        readonly assetKey: "efs_file_system";
        readonly drawioShape: "file_system";
    };
    readonly "AWS::FSx::Snapshot": {
        readonly service: "FSx";
        readonly serviceAssetKey: "fsx";
    };
    readonly "AWS::FSx::StorageVirtualMachine": {
        readonly service: "FSx";
        readonly serviceAssetKey: "fsx";
    };
    readonly "AWS::FSx::Volume": {
        readonly service: "FSx";
        readonly serviceAssetKey: "fsx";
    };
    readonly "AWS::FinSpace::Environment": {
        readonly service: "FinSpace";
        readonly serviceAssetKey: "finspace";
    };
    readonly "AWS::Forecast::Dataset": {
        readonly service: "Forecast";
        readonly serviceAssetKey: "forecast";
    };
    readonly "AWS::Forecast::DatasetGroup": {
        readonly service: "Forecast";
        readonly serviceAssetKey: "forecast";
    };
    readonly "AWS::FraudDetector::Detector": {
        readonly service: "FraudDetector";
        readonly serviceAssetKey: "fraud_detector";
    };
    readonly "AWS::FraudDetector::EntityType": {
        readonly service: "FraudDetector";
        readonly serviceAssetKey: "fraud_detector";
    };
    readonly "AWS::FraudDetector::EventType": {
        readonly service: "FraudDetector";
        readonly serviceAssetKey: "fraud_detector";
    };
    readonly "AWS::FraudDetector::Label": {
        readonly service: "FraudDetector";
        readonly serviceAssetKey: "fraud_detector";
    };
    readonly "AWS::FraudDetector::Outcome": {
        readonly service: "FraudDetector";
        readonly serviceAssetKey: "fraud_detector";
    };
    readonly "AWS::FraudDetector::Variable": {
        readonly service: "FraudDetector";
        readonly serviceAssetKey: "fraud_detector";
    };
    readonly "AWS::GameLift::Alias": {
        readonly service: "GameLift";
        readonly serviceAssetKey: "gamelift";
    };
    readonly "AWS::GameLift::Build": {
        readonly service: "GameLift";
        readonly serviceAssetKey: "gamelift";
    };
    readonly "AWS::GameLift::Fleet": {
        readonly service: "GameLift";
        readonly serviceAssetKey: "gamelift";
    };
    readonly "AWS::GameLift::GameServerGroup": {
        readonly service: "GameLift";
        readonly serviceAssetKey: "gamelift";
    };
    readonly "AWS::GameLift::GameSessionQueue": {
        readonly service: "GameLift";
        readonly serviceAssetKey: "gamelift";
    };
    readonly "AWS::GameLift::Location": {
        readonly service: "GameLift";
        readonly serviceAssetKey: "gamelift";
    };
    readonly "AWS::GameLift::MatchmakingConfiguration": {
        readonly service: "GameLift";
        readonly serviceAssetKey: "gamelift";
        readonly generalIconKey: "config";
        readonly drawioGeneralShape: "gear";
    };
    readonly "AWS::GameLift::MatchmakingRuleSet": {
        readonly service: "GameLift";
        readonly serviceAssetKey: "gamelift";
    };
    readonly "AWS::GameLift::Script": {
        readonly service: "GameLift";
        readonly serviceAssetKey: "gamelift";
    };
    readonly "AWS::GlobalAccelerator::Accelerator": {
        readonly service: "GlobalAccelerator";
        readonly serviceAssetKey: "global_accelerator";
    };
    readonly "AWS::GlobalAccelerator::EndpointGroup": {
        readonly service: "GlobalAccelerator";
        readonly serviceAssetKey: "global_accelerator";
    };
    readonly "AWS::GlobalAccelerator::Listener": {
        readonly service: "GlobalAccelerator";
        readonly serviceAssetKey: "global_accelerator";
    };
    readonly "AWS::Glue::Classifier": {
        readonly service: "Glue";
        readonly serviceAssetKey: "glue";
    };
    readonly "AWS::Glue::Connection": {
        readonly service: "Glue";
        readonly serviceAssetKey: "glue";
    };
    readonly "AWS::Glue::Crawler": {
        readonly service: "Glue";
        readonly serviceAssetKey: "glue";
        readonly assetKey: "glue_crawler";
    };
    readonly "AWS::Glue::DataCatalogEncryptionSettings": {
        readonly service: "Glue";
        readonly serviceAssetKey: "glue";
    };
    readonly "AWS::Glue::Database": {
        readonly service: "Glue";
        readonly serviceAssetKey: "glue";
        readonly generalIconKey: "generic_database";
    };
    readonly "AWS::Glue::DevEndpoint": {
        readonly service: "Glue";
        readonly serviceAssetKey: "glue";
    };
    readonly "AWS::Glue::Job": {
        readonly service: "Glue";
        readonly serviceAssetKey: "glue";
    };
    readonly "AWS::Glue::MLTransform": {
        readonly service: "Glue";
        readonly serviceAssetKey: "glue";
    };
    readonly "AWS::Glue::Partition": {
        readonly service: "Glue";
        readonly serviceAssetKey: "glue";
    };
    readonly "AWS::Glue::Registry": {
        readonly service: "Glue";
        readonly serviceAssetKey: "glue";
    };
    readonly "AWS::Glue::Schema": {
        readonly service: "Glue";
        readonly serviceAssetKey: "glue";
        readonly assetKey: "eventbridge_schema";
        readonly drawioShape: "eventbridge_schema";
    };
    readonly "AWS::Glue::SchemaVersion": {
        readonly service: "Glue";
        readonly serviceAssetKey: "glue";
    };
    readonly "AWS::Glue::SchemaVersionMetadata": {
        readonly service: "Glue";
        readonly serviceAssetKey: "glue";
    };
    readonly "AWS::Glue::SecurityConfiguration": {
        readonly service: "Glue";
        readonly serviceAssetKey: "glue";
        readonly generalIconKey: "config";
        readonly drawioGeneralShape: "gear";
    };
    readonly "AWS::Glue::Table": {
        readonly service: "Glue";
        readonly serviceAssetKey: "glue";
        readonly assetKey: "dynamodb_table";
        readonly drawioShape: "table";
    };
    readonly "AWS::Glue::Trigger": {
        readonly service: "Glue";
        readonly serviceAssetKey: "glue";
    };
    readonly "AWS::Glue::Workflow": {
        readonly service: "Glue";
        readonly serviceAssetKey: "glue";
    };
    readonly "AWS::Grafana::Workspace": {
        readonly service: "Grafana";
    };
    readonly "AWS::Greengrass::ConnectorDefinition": {
        readonly service: "Greengrass";
        readonly serviceAssetKey: "iot_greengrass";
    };
    readonly "AWS::Greengrass::ConnectorDefinitionVersion": {
        readonly service: "Greengrass";
        readonly serviceAssetKey: "iot_greengrass";
    };
    readonly "AWS::Greengrass::CoreDefinition": {
        readonly service: "Greengrass";
        readonly serviceAssetKey: "iot_greengrass";
    };
    readonly "AWS::Greengrass::CoreDefinitionVersion": {
        readonly service: "Greengrass";
        readonly serviceAssetKey: "iot_greengrass";
    };
    readonly "AWS::Greengrass::DeviceDefinition": {
        readonly service: "Greengrass";
        readonly serviceAssetKey: "iot_greengrass";
    };
    readonly "AWS::Greengrass::DeviceDefinitionVersion": {
        readonly service: "Greengrass";
        readonly serviceAssetKey: "iot_greengrass";
    };
    readonly "AWS::Greengrass::FunctionDefinition": {
        readonly service: "Greengrass";
        readonly serviceAssetKey: "iot_greengrass";
    };
    readonly "AWS::Greengrass::FunctionDefinitionVersion": {
        readonly service: "Greengrass";
        readonly serviceAssetKey: "iot_greengrass";
    };
    readonly "AWS::Greengrass::Group": {
        readonly service: "Greengrass";
        readonly serviceAssetKey: "iot_greengrass";
    };
    readonly "AWS::Greengrass::GroupVersion": {
        readonly service: "Greengrass";
        readonly serviceAssetKey: "iot_greengrass";
    };
    readonly "AWS::Greengrass::LoggerDefinition": {
        readonly service: "Greengrass";
        readonly serviceAssetKey: "iot_greengrass";
    };
    readonly "AWS::Greengrass::LoggerDefinitionVersion": {
        readonly service: "Greengrass";
        readonly serviceAssetKey: "iot_greengrass";
    };
    readonly "AWS::Greengrass::ResourceDefinition": {
        readonly service: "Greengrass";
        readonly serviceAssetKey: "iot_greengrass";
    };
    readonly "AWS::Greengrass::ResourceDefinitionVersion": {
        readonly service: "Greengrass";
        readonly serviceAssetKey: "iot_greengrass";
    };
    readonly "AWS::Greengrass::SubscriptionDefinition": {
        readonly service: "Greengrass";
        readonly serviceAssetKey: "iot_greengrass";
    };
    readonly "AWS::Greengrass::SubscriptionDefinitionVersion": {
        readonly service: "Greengrass";
        readonly serviceAssetKey: "iot_greengrass";
    };
    readonly "AWS::GreengrassV2::ComponentVersion": {
        readonly service: "GreengrassV2";
        readonly serviceAssetKey: "iot_greengrass";
    };
    readonly "AWS::GreengrassV2::Deployment": {
        readonly service: "GreengrassV2";
        readonly serviceAssetKey: "iot_greengrass";
    };
    readonly "AWS::GroundStation::Config": {
        readonly service: "GroundStation";
        readonly serviceAssetKey: "ground_station";
        readonly generalIconKey: "config";
        readonly drawioGeneralShape: "gear";
    };
    readonly "AWS::GroundStation::DataflowEndpointGroup": {
        readonly service: "GroundStation";
        readonly serviceAssetKey: "ground_station";
    };
    readonly "AWS::GroundStation::MissionProfile": {
        readonly service: "GroundStation";
        readonly serviceAssetKey: "ground_station";
    };
    readonly "AWS::GuardDuty::Detector": {
        readonly service: "GuardDuty";
        readonly serviceAssetKey: "guardduty";
    };
    readonly "AWS::GuardDuty::Filter": {
        readonly service: "GuardDuty";
        readonly serviceAssetKey: "guardduty";
    };
    readonly "AWS::GuardDuty::IPSet": {
        readonly service: "GuardDuty";
        readonly serviceAssetKey: "guardduty";
    };
    readonly "AWS::GuardDuty::Master": {
        readonly service: "GuardDuty";
        readonly serviceAssetKey: "guardduty";
    };
    readonly "AWS::GuardDuty::Member": {
        readonly service: "GuardDuty";
        readonly serviceAssetKey: "guardduty";
    };
    readonly "AWS::GuardDuty::ThreatIntelSet": {
        readonly service: "GuardDuty";
        readonly serviceAssetKey: "guardduty";
    };
    readonly "AWS::HealthLake::FHIRDatastore": {
        readonly service: "HealthLake";
        readonly serviceAssetKey: "healthlake";
    };
    readonly "AWS::IAM::AccessKey": {
        readonly service: "IAM";
        readonly serviceAssetKey: "iam";
        readonly generalIconKey: "key";
        readonly drawioGeneralShape: "permissions";
    };
    readonly "AWS::IAM::Group": {
        readonly service: "IAM";
        readonly serviceAssetKey: "iam";
    };
    readonly "AWS::IAM::InstanceProfile": {
        readonly service: "IAM";
        readonly serviceAssetKey: "iam";
    };
    readonly "AWS::IAM::ManagedPolicy": {
        readonly service: "IAM";
        readonly serviceAssetKey: "iam";
        readonly generalIconKey: "policy";
        readonly drawioGeneralShape: "addon";
    };
    readonly "AWS::IAM::OIDCProvider": {
        readonly service: "IAM";
        readonly serviceAssetKey: "iam";
    };
    readonly "AWS::IAM::Policy": {
        readonly service: "IAM";
        readonly serviceAssetKey: "iam";
        readonly generalIconKey: "policy";
        readonly drawioGeneralShape: "addon";
    };
    readonly "AWS::IAM::Role": {
        readonly service: "IAM";
        readonly serviceAssetKey: "iam";
        readonly assetKey: "iam_role";
        readonly generalIconKey: "role";
        readonly drawioShape: "role";
        readonly drawioGeneralShape: "role";
    };
    readonly "AWS::IAM::SAMLProvider": {
        readonly service: "IAM";
        readonly serviceAssetKey: "iam";
    };
    readonly "AWS::IAM::ServerCertificate": {
        readonly service: "IAM";
        readonly serviceAssetKey: "iam";
    };
    readonly "AWS::IAM::ServiceLinkedRole": {
        readonly service: "IAM";
        readonly serviceAssetKey: "iam";
        readonly generalIconKey: "role";
        readonly drawioGeneralShape: "role";
    };
    readonly "AWS::IAM::User": {
        readonly service: "IAM";
        readonly serviceAssetKey: "iam";
        readonly generalIconKey: "user";
        readonly drawioGeneralShape: "user";
    };
    readonly "AWS::IAM::UserToGroupAddition": {
        readonly service: "IAM";
        readonly serviceAssetKey: "iam";
    };
    readonly "AWS::IAM::VirtualMFADevice": {
        readonly service: "IAM";
        readonly serviceAssetKey: "iam";
    };
    readonly "AWS::IVS::Channel": {
        readonly service: "IVS";
        readonly serviceAssetKey: "interactive_video_service";
    };
    readonly "AWS::IVS::PlaybackKeyPair": {
        readonly service: "IVS";
        readonly serviceAssetKey: "interactive_video_service";
    };
    readonly "AWS::IVS::RecordingConfiguration": {
        readonly service: "IVS";
        readonly serviceAssetKey: "interactive_video_service";
        readonly generalIconKey: "config";
        readonly drawioGeneralShape: "gear";
    };
    readonly "AWS::IVS::StreamKey": {
        readonly service: "IVS";
        readonly serviceAssetKey: "interactive_video_service";
        readonly generalIconKey: "key";
        readonly drawioGeneralShape: "permissions";
    };
    readonly "AWS::IdentityStore::Group": {
        readonly service: "IdentityStore";
    };
    readonly "AWS::IdentityStore::GroupMembership": {
        readonly service: "IdentityStore";
    };
    readonly "AWS::ImageBuilder::Component": {
        readonly service: "ImageBuilder";
        readonly serviceAssetKey: "ec2";
    };
    readonly "AWS::ImageBuilder::ContainerRecipe": {
        readonly service: "ImageBuilder";
        readonly serviceAssetKey: "ec2";
    };
    readonly "AWS::ImageBuilder::DistributionConfiguration": {
        readonly service: "ImageBuilder";
        readonly serviceAssetKey: "ec2";
        readonly generalIconKey: "config";
        readonly drawioGeneralShape: "gear";
    };
    readonly "AWS::ImageBuilder::Image": {
        readonly service: "ImageBuilder";
        readonly serviceAssetKey: "ec2";
    };
    readonly "AWS::ImageBuilder::ImagePipeline": {
        readonly service: "ImageBuilder";
        readonly serviceAssetKey: "ec2";
    };
    readonly "AWS::ImageBuilder::ImageRecipe": {
        readonly service: "ImageBuilder";
        readonly serviceAssetKey: "ec2";
    };
    readonly "AWS::ImageBuilder::InfrastructureConfiguration": {
        readonly service: "ImageBuilder";
        readonly serviceAssetKey: "ec2";
        readonly generalIconKey: "config";
        readonly drawioGeneralShape: "gear";
    };
    readonly "AWS::Inspector::AssessmentTarget": {
        readonly service: "Inspector";
        readonly serviceAssetKey: "inspector";
    };
    readonly "AWS::Inspector::AssessmentTemplate": {
        readonly service: "Inspector";
        readonly serviceAssetKey: "inspector";
        readonly generalIconKey: "template";
        readonly drawioGeneralShape: "template";
    };
    readonly "AWS::Inspector::ResourceGroup": {
        readonly service: "Inspector";
        readonly serviceAssetKey: "inspector";
    };
    readonly "AWS::InspectorV2::Filter": {
        readonly service: "InspectorV2";
        readonly serviceAssetKey: "inspector";
    };
    readonly "AWS::IoT1Click::Device": {
        readonly service: "IoT1Click";
        readonly serviceAssetKey: "iot_1_click";
    };
    readonly "AWS::IoT1Click::Placement": {
        readonly service: "IoT1Click";
        readonly serviceAssetKey: "iot_1_click";
    };
    readonly "AWS::IoT1Click::Project": {
        readonly service: "IoT1Click";
        readonly serviceAssetKey: "iot_1_click";
    };
    readonly "AWS::IoT::AccountAuditConfiguration": {
        readonly service: "IoT";
        readonly serviceAssetKey: "iot_core";
        readonly generalIconKey: "config";
        readonly drawioGeneralShape: "gear";
    };
    readonly "AWS::IoT::Authorizer": {
        readonly service: "IoT";
        readonly serviceAssetKey: "iot_core";
    };
    readonly "AWS::IoT::CACertificate": {
        readonly service: "IoT";
        readonly serviceAssetKey: "iot_core";
    };
    readonly "AWS::IoT::Certificate": {
        readonly service: "IoT";
        readonly serviceAssetKey: "iot_core";
        readonly assetKey: "iot_core_certificate";
        readonly generalIconKey: "ssl_padlock";
        readonly drawioGeneralShape: "ssl_padlock";
    };
    readonly "AWS::IoT::CustomMetric": {
        readonly service: "IoT";
        readonly serviceAssetKey: "iot_core";
    };
    readonly "AWS::IoT::Dimension": {
        readonly service: "IoT";
        readonly serviceAssetKey: "iot_core";
    };
    readonly "AWS::IoT::DomainConfiguration": {
        readonly service: "IoT";
        readonly serviceAssetKey: "iot_core";
        readonly generalIconKey: "config";
        readonly drawioGeneralShape: "gear";
    };
    readonly "AWS::IoT::FleetMetric": {
        readonly service: "IoT";
        readonly serviceAssetKey: "iot_core";
    };
    readonly "AWS::IoT::JobTemplate": {
        readonly service: "IoT";
        readonly serviceAssetKey: "iot_core";
        readonly generalIconKey: "template";
        readonly drawioGeneralShape: "template";
    };
    readonly "AWS::IoT::Logging": {
        readonly service: "IoT";
        readonly serviceAssetKey: "iot_core";
    };
    readonly "AWS::IoT::MitigationAction": {
        readonly service: "IoT";
        readonly serviceAssetKey: "iot_core";
    };
    readonly "AWS::IoT::Policy": {
        readonly service: "IoT";
        readonly serviceAssetKey: "iot_core";
        readonly assetKey: "iot_core_policy";
        readonly generalIconKey: "policy";
        readonly drawioGeneralShape: "addon";
    };
    readonly "AWS::IoT::PolicyPrincipalAttachment": {
        readonly service: "IoT";
        readonly serviceAssetKey: "iot_core";
        readonly generalIconKey: "attachment";
        readonly drawioGeneralShape: "transit_gateway_attachment";
    };
    readonly "AWS::IoT::ProvisioningTemplate": {
        readonly service: "IoT";
        readonly serviceAssetKey: "iot_core";
        readonly generalIconKey: "template";
        readonly drawioGeneralShape: "template";
    };
    readonly "AWS::IoT::ResourceSpecificLogging": {
        readonly service: "IoT";
        readonly serviceAssetKey: "iot_core";
    };
    readonly "AWS::IoT::RoleAlias": {
        readonly service: "IoT";
        readonly serviceAssetKey: "iot_core";
    };
    readonly "AWS::IoT::ScheduledAudit": {
        readonly service: "IoT";
        readonly serviceAssetKey: "iot_core";
    };
    readonly "AWS::IoT::SecurityProfile": {
        readonly service: "IoT";
        readonly serviceAssetKey: "iot_core";
    };
    readonly "AWS::IoT::Thing": {
        readonly service: "IoT";
        readonly serviceAssetKey: "iot_core";
    };
    readonly "AWS::IoT::ThingPrincipalAttachment": {
        readonly service: "IoT";
        readonly serviceAssetKey: "iot_core";
        readonly generalIconKey: "attachment";
        readonly drawioGeneralShape: "transit_gateway_attachment";
    };
    readonly "AWS::IoT::TopicRule": {
        readonly service: "IoT";
        readonly serviceAssetKey: "iot_core";
        readonly generalIconKey: "rule";
        readonly drawioGeneralShape: "rule";
    };
    readonly "AWS::IoT::TopicRuleDestination": {
        readonly service: "IoT";
        readonly serviceAssetKey: "iot_core";
    };
    readonly "AWS::IoTAnalytics::Channel": {
        readonly service: "IoTAnalytics";
        readonly serviceAssetKey: "iot_analytics";
        readonly assetKey: "iot_analytics_channel";
        readonly drawioShape: "iot_analytics_channel";
    };
    readonly "AWS::IoTAnalytics::Dataset": {
        readonly service: "IoTAnalytics";
        readonly serviceAssetKey: "iot_analytics";
        readonly assetKey: "iot_analytics_dataset";
        readonly drawioShape: "data_set";
    };
    readonly "AWS::IoTAnalytics::Datastore": {
        readonly service: "IoTAnalytics";
        readonly serviceAssetKey: "iot_analytics";
        readonly assetKey: "iot_analytics_data_store";
        readonly drawioShape: "iot_analytics_data_store";
    };
    readonly "AWS::IoTAnalytics::Pipeline": {
        readonly service: "IoTAnalytics";
        readonly serviceAssetKey: "iot_analytics";
        readonly assetKey: "iot_analytics_pipeline";
        readonly drawioShape: "iot_analytics_pipeline";
    };
    readonly "AWS::IoTCoreDeviceAdvisor::SuiteDefinition": {
        readonly service: "IoTCoreDeviceAdvisor";
        readonly serviceAssetKey: "iot_core";
    };
    readonly "AWS::IoTEvents::AlarmModel": {
        readonly service: "IoTEvents";
        readonly serviceAssetKey: "iot_events";
    };
    readonly "AWS::IoTEvents::DetectorModel": {
        readonly service: "IoTEvents";
        readonly serviceAssetKey: "iot_events";
    };
    readonly "AWS::IoTEvents::Input": {
        readonly service: "IoTEvents";
        readonly serviceAssetKey: "iot_events";
    };
    readonly "AWS::IoTFleetHub::Application": {
        readonly service: "IoTFleetHub";
        readonly serviceAssetKey: "iot_device_management";
        readonly assetKey: "elastic_beanstalk_application";
        readonly generalIconKey: "generic_application";
        readonly drawioShape: "application";
    };
    readonly "AWS::IoTFleetWise::Campaign": {
        readonly service: "IoTFleetWise";
        readonly serviceAssetKey: "iot_fleetwise";
    };
    readonly "AWS::IoTFleetWise::DecoderManifest": {
        readonly service: "IoTFleetWise";
        readonly serviceAssetKey: "iot_fleetwise";
    };
    readonly "AWS::IoTFleetWise::Fleet": {
        readonly service: "IoTFleetWise";
        readonly serviceAssetKey: "iot_fleetwise";
    };
    readonly "AWS::IoTFleetWise::ModelManifest": {
        readonly service: "IoTFleetWise";
        readonly serviceAssetKey: "iot_fleetwise";
    };
    readonly "AWS::IoTFleetWise::SignalCatalog": {
        readonly service: "IoTFleetWise";
        readonly serviceAssetKey: "iot_fleetwise";
        readonly generalIconKey: "logs";
        readonly drawioGeneralShape: "logs";
    };
    readonly "AWS::IoTFleetWise::Vehicle": {
        readonly service: "IoTFleetWise";
        readonly serviceAssetKey: "iot_fleetwise";
    };
    readonly "AWS::IoTSiteWise::AccessPolicy": {
        readonly service: "IoTSiteWise";
        readonly serviceAssetKey: "iot_sitewise";
        readonly generalIconKey: "policy";
        readonly drawioGeneralShape: "addon";
    };
    readonly "AWS::IoTSiteWise::Asset": {
        readonly service: "IoTSiteWise";
        readonly serviceAssetKey: "iot_sitewise";
        readonly assetKey: "iot_sitewise_asset";
        readonly drawioShape: "iot_sitewise_asset";
    };
    readonly "AWS::IoTSiteWise::AssetModel": {
        readonly service: "IoTSiteWise";
        readonly serviceAssetKey: "iot_sitewise";
        readonly assetKey: "iot_sitewise_asset_model";
        readonly drawioShape: "iot_sitewise_asset_model";
    };
    readonly "AWS::IoTSiteWise::Dashboard": {
        readonly service: "IoTSiteWise";
        readonly serviceAssetKey: "iot_sitewise";
    };
    readonly "AWS::IoTSiteWise::Gateway": {
        readonly service: "IoTSiteWise";
        readonly serviceAssetKey: "iot_sitewise";
    };
    readonly "AWS::IoTSiteWise::Portal": {
        readonly service: "IoTSiteWise";
        readonly serviceAssetKey: "iot_sitewise";
    };
    readonly "AWS::IoTSiteWise::Project": {
        readonly service: "IoTSiteWise";
        readonly serviceAssetKey: "iot_sitewise";
    };
    readonly "AWS::IoTThingsGraph::FlowTemplate": {
        readonly service: "IoTThingsGraph";
        readonly serviceAssetKey: "iot_things_graph";
        readonly generalIconKey: "template";
        readonly drawioGeneralShape: "template";
    };
    readonly "AWS::IoTTwinMaker::ComponentType": {
        readonly service: "IoTTwinMaker";
        readonly serviceAssetKey: "iot_twinmaker";
    };
    readonly "AWS::IoTTwinMaker::Entity": {
        readonly service: "IoTTwinMaker";
        readonly serviceAssetKey: "iot_twinmaker";
    };
    readonly "AWS::IoTTwinMaker::Scene": {
        readonly service: "IoTTwinMaker";
        readonly serviceAssetKey: "iot_twinmaker";
    };
    readonly "AWS::IoTTwinMaker::SyncJob": {
        readonly service: "IoTTwinMaker";
        readonly serviceAssetKey: "iot_twinmaker";
    };
    readonly "AWS::IoTTwinMaker::Workspace": {
        readonly service: "IoTTwinMaker";
        readonly serviceAssetKey: "iot_twinmaker";
    };
    readonly "AWS::IoTWireless::Destination": {
        readonly service: "IoTWireless";
        readonly serviceAssetKey: "iot_core";
    };
    readonly "AWS::IoTWireless::DeviceProfile": {
        readonly service: "IoTWireless";
        readonly serviceAssetKey: "iot_core";
    };
    readonly "AWS::IoTWireless::FuotaTask": {
        readonly service: "IoTWireless";
        readonly serviceAssetKey: "iot_core";
    };
    readonly "AWS::IoTWireless::MulticastGroup": {
        readonly service: "IoTWireless";
        readonly serviceAssetKey: "iot_core";
    };
    readonly "AWS::IoTWireless::NetworkAnalyzerConfiguration": {
        readonly service: "IoTWireless";
        readonly serviceAssetKey: "iot_core";
        readonly generalIconKey: "config";
        readonly drawioGeneralShape: "gear";
    };
    readonly "AWS::IoTWireless::PartnerAccount": {
        readonly service: "IoTWireless";
        readonly serviceAssetKey: "iot_core";
    };
    readonly "AWS::IoTWireless::ServiceProfile": {
        readonly service: "IoTWireless";
        readonly serviceAssetKey: "iot_core";
    };
    readonly "AWS::IoTWireless::TaskDefinition": {
        readonly service: "IoTWireless";
        readonly serviceAssetKey: "iot_core";
    };
    readonly "AWS::IoTWireless::WirelessDevice": {
        readonly service: "IoTWireless";
        readonly serviceAssetKey: "iot_core";
    };
    readonly "AWS::IoTWireless::WirelessGateway": {
        readonly service: "IoTWireless";
        readonly serviceAssetKey: "iot_core";
    };
    readonly "AWS::KMS::Alias": {
        readonly service: "KMS";
        readonly serviceAssetKey: "key_management_service";
    };
    readonly "AWS::KMS::Key": {
        readonly service: "KMS";
        readonly serviceAssetKey: "key_management_service";
        readonly generalIconKey: "key";
        readonly drawioGeneralShape: "permissions";
    };
    readonly "AWS::KMS::ReplicaKey": {
        readonly service: "KMS";
        readonly serviceAssetKey: "key_management_service";
        readonly generalIconKey: "key";
        readonly drawioGeneralShape: "permissions";
    };
    readonly "AWS::KafkaConnect::Connector": {
        readonly service: "KafkaConnect";
        readonly serviceAssetKey: "msk";
    };
    readonly "AWS::Kendra::DataSource": {
        readonly service: "Kendra";
        readonly serviceAssetKey: "kendra";
    };
    readonly "AWS::Kendra::Faq": {
        readonly service: "Kendra";
        readonly serviceAssetKey: "kendra";
    };
    readonly "AWS::Kendra::Index": {
        readonly service: "Kendra";
        readonly serviceAssetKey: "kendra";
    };
    readonly "AWS::KendraRanking::ExecutionPlan": {
        readonly service: "KendraRanking";
        readonly serviceAssetKey: "kendra";
    };
    readonly "AWS::Kinesis::Stream": {
        readonly service: "Kinesis";
        readonly serviceAssetKey: "kinesis_data_streams";
    };
    readonly "AWS::Kinesis::StreamConsumer": {
        readonly service: "Kinesis";
        readonly serviceAssetKey: "kinesis_data_streams";
    };
    readonly "AWS::KinesisAnalytics::Application": {
        readonly service: "KinesisAnalytics";
        readonly serviceAssetKey: "kinesis_data_analytics";
        readonly assetKey: "elastic_beanstalk_application";
        readonly generalIconKey: "generic_application";
        readonly drawioShape: "application";
    };
    readonly "AWS::KinesisAnalytics::ApplicationOutput": {
        readonly service: "KinesisAnalytics";
        readonly serviceAssetKey: "kinesis_data_analytics";
    };
    readonly "AWS::KinesisAnalytics::ApplicationReferenceDataSource": {
        readonly service: "KinesisAnalytics";
        readonly serviceAssetKey: "kinesis_data_analytics";
    };
    readonly "AWS::KinesisAnalyticsV2::Application": {
        readonly service: "KinesisAnalyticsV2";
        readonly serviceAssetKey: "kinesis_data_analytics";
        readonly assetKey: "elastic_beanstalk_application";
        readonly generalIconKey: "generic_application";
        readonly drawioShape: "application";
    };
    readonly "AWS::KinesisAnalyticsV2::ApplicationCloudWatchLoggingOption": {
        readonly service: "KinesisAnalyticsV2";
        readonly serviceAssetKey: "kinesis_data_analytics";
    };
    readonly "AWS::KinesisAnalyticsV2::ApplicationOutput": {
        readonly service: "KinesisAnalyticsV2";
        readonly serviceAssetKey: "kinesis_data_analytics";
    };
    readonly "AWS::KinesisAnalyticsV2::ApplicationReferenceDataSource": {
        readonly service: "KinesisAnalyticsV2";
        readonly serviceAssetKey: "kinesis_data_analytics";
    };
    readonly "AWS::KinesisFirehose::DeliveryStream": {
        readonly service: "KinesisFirehose";
        readonly serviceAssetKey: "kinesis_firehose";
    };
    readonly "AWS::KinesisVideo::SignalingChannel": {
        readonly service: "KinesisVideo";
        readonly serviceAssetKey: "kinesis_video_streams";
    };
    readonly "AWS::KinesisVideo::Stream": {
        readonly service: "KinesisVideo";
        readonly serviceAssetKey: "kinesis_video_streams";
    };
    readonly "AWS::LakeFormation::DataCellsFilter": {
        readonly service: "LakeFormation";
        readonly serviceAssetKey: "lake_formation";
    };
    readonly "AWS::LakeFormation::DataLakeSettings": {
        readonly service: "LakeFormation";
        readonly serviceAssetKey: "lake_formation";
    };
    readonly "AWS::LakeFormation::Permissions": {
        readonly service: "LakeFormation";
        readonly serviceAssetKey: "lake_formation";
        readonly assetKey: "iam_permissions";
        readonly generalIconKey: "policy";
        readonly drawioShape: "permissions";
        readonly drawioGeneralShape: "addon";
    };
    readonly "AWS::LakeFormation::PrincipalPermissions": {
        readonly service: "LakeFormation";
        readonly serviceAssetKey: "lake_formation";
        readonly generalIconKey: "policy";
        readonly drawioGeneralShape: "addon";
    };
    readonly "AWS::LakeFormation::Resource": {
        readonly service: "LakeFormation";
        readonly serviceAssetKey: "lake_formation";
    };
    readonly "AWS::LakeFormation::Tag": {
        readonly service: "LakeFormation";
        readonly serviceAssetKey: "lake_formation";
    };
    readonly "AWS::LakeFormation::TagAssociation": {
        readonly service: "LakeFormation";
        readonly serviceAssetKey: "lake_formation";
    };
    readonly "AWS::Lambda::Alias": {
        readonly service: "Lambda";
        readonly serviceAssetKey: "lambda";
    };
    readonly "AWS::Lambda::CodeSigningConfig": {
        readonly service: "Lambda";
        readonly serviceAssetKey: "lambda";
        readonly generalIconKey: "config";
        readonly drawioGeneralShape: "gear";
    };
    readonly "AWS::Lambda::EventInvokeConfig": {
        readonly service: "Lambda";
        readonly serviceAssetKey: "lambda";
        readonly generalIconKey: "config";
        readonly drawioGeneralShape: "gear";
    };
    readonly "AWS::Lambda::EventSourceMapping": {
        readonly service: "Lambda";
        readonly serviceAssetKey: "lambda";
    };
    readonly "AWS::Lambda::Function": {
        readonly service: "Lambda";
        readonly serviceAssetKey: "lambda";
        readonly assetKey: "lambda_lambda_function";
    };
    readonly "AWS::Lambda::LayerVersion": {
        readonly service: "Lambda";
        readonly serviceAssetKey: "lambda";
    };
    readonly "AWS::Lambda::LayerVersionPermission": {
        readonly service: "Lambda";
        readonly serviceAssetKey: "lambda";
        readonly generalIconKey: "policy";
        readonly drawioGeneralShape: "addon";
    };
    readonly "AWS::Lambda::Permission": {
        readonly service: "Lambda";
        readonly serviceAssetKey: "lambda";
        readonly generalIconKey: "policy";
        readonly drawioGeneralShape: "addon";
    };
    readonly "AWS::Lambda::Url": {
        readonly service: "Lambda";
        readonly serviceAssetKey: "lambda";
    };
    readonly "AWS::Lambda::Version": {
        readonly service: "Lambda";
        readonly serviceAssetKey: "lambda";
    };
    readonly "AWS::Lex::Bot": {
        readonly service: "Lex";
        readonly serviceAssetKey: "lex";
    };
    readonly "AWS::Lex::BotAlias": {
        readonly service: "Lex";
        readonly serviceAssetKey: "lex";
    };
    readonly "AWS::Lex::BotVersion": {
        readonly service: "Lex";
        readonly serviceAssetKey: "lex";
    };
    readonly "AWS::Lex::ResourcePolicy": {
        readonly service: "Lex";
        readonly serviceAssetKey: "lex";
        readonly generalIconKey: "policy";
        readonly drawioGeneralShape: "addon";
    };
    readonly "AWS::LicenseManager::Grant": {
        readonly service: "LicenseManager";
        readonly serviceAssetKey: "license_manager";
    };
    readonly "AWS::LicenseManager::License": {
        readonly service: "LicenseManager";
        readonly serviceAssetKey: "license_manager";
    };
    readonly "AWS::Lightsail::Alarm": {
        readonly service: "Lightsail";
        readonly serviceAssetKey: "lightsail";
        readonly assetKey: "cloudwatch_alarm";
        readonly generalIconKey: "alarm";
        readonly drawioShape: "alarm";
        readonly drawioGeneralShape: "alarm";
    };
    readonly "AWS::Lightsail::Bucket": {
        readonly service: "Lightsail";
        readonly serviceAssetKey: "lightsail";
    };
    readonly "AWS::Lightsail::Certificate": {
        readonly service: "Lightsail";
        readonly serviceAssetKey: "lightsail";
        readonly assetKey: "iot_core_certificate";
        readonly generalIconKey: "ssl_padlock";
        readonly drawioGeneralShape: "ssl_padlock";
    };
    readonly "AWS::Lightsail::Container": {
        readonly service: "Lightsail";
        readonly serviceAssetKey: "lightsail";
    };
    readonly "AWS::Lightsail::Database": {
        readonly service: "Lightsail";
        readonly serviceAssetKey: "lightsail";
        readonly generalIconKey: "generic_database";
    };
    readonly "AWS::Lightsail::Disk": {
        readonly service: "Lightsail";
        readonly serviceAssetKey: "lightsail";
    };
    readonly "AWS::Lightsail::Distribution": {
        readonly service: "Lightsail";
        readonly serviceAssetKey: "lightsail";
    };
    readonly "AWS::Lightsail::Instance": {
        readonly service: "Lightsail";
        readonly serviceAssetKey: "lightsail";
        readonly assetKey: "ec2_instance";
        readonly drawioShape: "instance";
    };
    readonly "AWS::Lightsail::LoadBalancer": {
        readonly service: "Lightsail";
        readonly serviceAssetKey: "lightsail";
    };
    readonly "AWS::Lightsail::LoadBalancerTlsCertificate": {
        readonly service: "Lightsail";
        readonly serviceAssetKey: "lightsail";
    };
    readonly "AWS::Lightsail::StaticIp": {
        readonly service: "Lightsail";
        readonly serviceAssetKey: "lightsail";
    };
    readonly "AWS::Location::GeofenceCollection": {
        readonly service: "Location";
        readonly serviceAssetKey: "location_service";
    };
    readonly "AWS::Location::Map": {
        readonly service: "Location";
        readonly serviceAssetKey: "location_service";
        readonly assetKey: "location_service_map";
        readonly drawioShape: "location_service_map";
    };
    readonly "AWS::Location::PlaceIndex": {
        readonly service: "Location";
        readonly serviceAssetKey: "location_service";
    };
    readonly "AWS::Location::RouteCalculator": {
        readonly service: "Location";
        readonly serviceAssetKey: "location_service";
    };
    readonly "AWS::Location::Tracker": {
        readonly service: "Location";
        readonly serviceAssetKey: "location_service";
    };
    readonly "AWS::Location::TrackerConsumer": {
        readonly service: "Location";
        readonly serviceAssetKey: "location_service";
    };
    readonly "AWS::Logs::Destination": {
        readonly service: "Logs";
        readonly serviceAssetKey: "cloudwatch";
    };
    readonly "AWS::Logs::LogGroup": {
        readonly service: "Logs";
        readonly serviceAssetKey: "cloudwatch";
    };
    readonly "AWS::Logs::LogStream": {
        readonly service: "Logs";
        readonly serviceAssetKey: "cloudwatch";
    };
    readonly "AWS::Logs::MetricFilter": {
        readonly service: "Logs";
        readonly serviceAssetKey: "cloudwatch";
    };
    readonly "AWS::Logs::QueryDefinition": {
        readonly service: "Logs";
        readonly serviceAssetKey: "cloudwatch";
    };
    readonly "AWS::Logs::ResourcePolicy": {
        readonly service: "Logs";
        readonly serviceAssetKey: "cloudwatch";
        readonly generalIconKey: "policy";
        readonly drawioGeneralShape: "addon";
    };
    readonly "AWS::Logs::SubscriptionFilter": {
        readonly service: "Logs";
        readonly serviceAssetKey: "cloudwatch";
    };
    readonly "AWS::LookoutEquipment::InferenceScheduler": {
        readonly service: "LookoutEquipment";
        readonly serviceAssetKey: "lookout_for_equipment";
    };
    readonly "AWS::LookoutMetrics::Alert": {
        readonly service: "LookoutMetrics";
        readonly serviceAssetKey: "lookout_for_metrics";
        readonly generalIconKey: "alarm";
        readonly drawioGeneralShape: "alarm";
    };
    readonly "AWS::LookoutMetrics::AnomalyDetector": {
        readonly service: "LookoutMetrics";
        readonly serviceAssetKey: "lookout_for_metrics";
    };
    readonly "AWS::LookoutVision::Project": {
        readonly service: "LookoutVision";
        readonly serviceAssetKey: "lookout_for_vision";
    };
    readonly "AWS::M2::Application": {
        readonly service: "M2";
        readonly serviceAssetKey: "mainframe_modernization";
        readonly assetKey: "elastic_beanstalk_application";
        readonly generalIconKey: "generic_application";
        readonly drawioShape: "application";
    };
    readonly "AWS::M2::Environment": {
        readonly service: "M2";
        readonly serviceAssetKey: "mainframe_modernization";
    };
    readonly "AWS::MSK::BatchScramSecret": {
        readonly service: "MSK";
        readonly serviceAssetKey: "msk";
    };
    readonly "AWS::MSK::Cluster": {
        readonly service: "MSK";
        readonly serviceAssetKey: "msk";
        readonly assetKey: "emr_cluster";
        readonly drawioShape: "cluster";
    };
    readonly "AWS::MSK::Configuration": {
        readonly service: "MSK";
        readonly serviceAssetKey: "msk";
        readonly generalIconKey: "config";
        readonly drawioGeneralShape: "gear";
    };
    readonly "AWS::MSK::ServerlessCluster": {
        readonly service: "MSK";
        readonly serviceAssetKey: "msk";
    };
    readonly "AWS::MWAA::Environment": {
        readonly service: "MWAA";
        readonly serviceAssetKey: "mwaa";
    };
    readonly "AWS::Macie::AllowList": {
        readonly service: "Macie";
        readonly serviceAssetKey: "macie";
    };
    readonly "AWS::Macie::CustomDataIdentifier": {
        readonly service: "Macie";
        readonly serviceAssetKey: "macie";
    };
    readonly "AWS::Macie::FindingsFilter": {
        readonly service: "Macie";
        readonly serviceAssetKey: "macie";
    };
    readonly "AWS::Macie::Session": {
        readonly service: "Macie";
        readonly serviceAssetKey: "macie";
    };
    readonly "AWS::ManagedBlockchain::Member": {
        readonly service: "ManagedBlockchain";
        readonly serviceAssetKey: "managed_blockchain";
    };
    readonly "AWS::ManagedBlockchain::Node": {
        readonly service: "ManagedBlockchain";
        readonly serviceAssetKey: "managed_blockchain";
    };
    readonly "AWS::MediaConnect::Flow": {
        readonly service: "MediaConnect";
        readonly serviceAssetKey: "elemental_mediaconnect";
    };
    readonly "AWS::MediaConnect::FlowEntitlement": {
        readonly service: "MediaConnect";
        readonly serviceAssetKey: "elemental_mediaconnect";
    };
    readonly "AWS::MediaConnect::FlowOutput": {
        readonly service: "MediaConnect";
        readonly serviceAssetKey: "elemental_mediaconnect";
    };
    readonly "AWS::MediaConnect::FlowSource": {
        readonly service: "MediaConnect";
        readonly serviceAssetKey: "elemental_mediaconnect";
    };
    readonly "AWS::MediaConnect::FlowVpcInterface": {
        readonly service: "MediaConnect";
        readonly serviceAssetKey: "elemental_mediaconnect";
    };
    readonly "AWS::MediaConvert::JobTemplate": {
        readonly service: "MediaConvert";
        readonly serviceAssetKey: "elemental_mediaconvert";
        readonly generalIconKey: "template";
        readonly drawioGeneralShape: "template";
    };
    readonly "AWS::MediaConvert::Preset": {
        readonly service: "MediaConvert";
        readonly serviceAssetKey: "elemental_mediaconvert";
    };
    readonly "AWS::MediaConvert::Queue": {
        readonly service: "MediaConvert";
        readonly serviceAssetKey: "elemental_mediaconvert";
    };
    readonly "AWS::MediaLive::Channel": {
        readonly service: "MediaLive";
        readonly serviceAssetKey: "elemental_medialive";
        readonly assetKey: "iot_analytics_channel";
        readonly drawioShape: "iot_analytics_channel";
    };
    readonly "AWS::MediaLive::Input": {
        readonly service: "MediaLive";
        readonly serviceAssetKey: "elemental_medialive";
    };
    readonly "AWS::MediaLive::InputSecurityGroup": {
        readonly service: "MediaLive";
        readonly serviceAssetKey: "elemental_medialive";
    };
    readonly "AWS::MediaPackage::Asset": {
        readonly service: "MediaPackage";
        readonly serviceAssetKey: "elemental_mediapackage";
        readonly assetKey: "iot_sitewise_asset";
        readonly drawioShape: "iot_sitewise_asset";
    };
    readonly "AWS::MediaPackage::Channel": {
        readonly service: "MediaPackage";
        readonly serviceAssetKey: "elemental_mediapackage";
        readonly assetKey: "iot_analytics_channel";
        readonly drawioShape: "iot_analytics_channel";
    };
    readonly "AWS::MediaPackage::OriginEndpoint": {
        readonly service: "MediaPackage";
        readonly serviceAssetKey: "elemental_mediapackage";
    };
    readonly "AWS::MediaPackage::PackagingConfiguration": {
        readonly service: "MediaPackage";
        readonly serviceAssetKey: "elemental_mediapackage";
        readonly generalIconKey: "config";
        readonly drawioGeneralShape: "gear";
    };
    readonly "AWS::MediaPackage::PackagingGroup": {
        readonly service: "MediaPackage";
        readonly serviceAssetKey: "elemental_mediapackage";
    };
    readonly "AWS::MediaStore::Container": {
        readonly service: "MediaStore";
        readonly serviceAssetKey: "elemental_mediastore";
    };
    readonly "AWS::MediaTailor::PlaybackConfiguration": {
        readonly service: "MediaTailor";
        readonly serviceAssetKey: "elemental_mediatailor";
        readonly generalIconKey: "config";
        readonly drawioGeneralShape: "gear";
    };
    readonly "AWS::MemoryDB::ACL": {
        readonly service: "MemoryDB";
        readonly serviceAssetKey: "memorydb_for_redis";
    };
    readonly "AWS::MemoryDB::Cluster": {
        readonly service: "MemoryDB";
        readonly serviceAssetKey: "memorydb_for_redis";
        readonly assetKey: "emr_cluster";
        readonly drawioShape: "cluster";
    };
    readonly "AWS::MemoryDB::ParameterGroup": {
        readonly service: "MemoryDB";
        readonly serviceAssetKey: "memorydb_for_redis";
    };
    readonly "AWS::MemoryDB::SubnetGroup": {
        readonly service: "MemoryDB";
        readonly serviceAssetKey: "memorydb_for_redis";
    };
    readonly "AWS::MemoryDB::User": {
        readonly service: "MemoryDB";
        readonly serviceAssetKey: "memorydb_for_redis";
        readonly generalIconKey: "user";
        readonly drawioGeneralShape: "user";
    };
    readonly "AWS::Neptune::DBCluster": {
        readonly service: "Neptune";
        readonly serviceAssetKey: "neptune";
    };
    readonly "AWS::Neptune::DBClusterParameterGroup": {
        readonly service: "Neptune";
        readonly serviceAssetKey: "neptune";
    };
    readonly "AWS::Neptune::DBInstance": {
        readonly service: "Neptune";
        readonly serviceAssetKey: "neptune";
    };
    readonly "AWS::Neptune::DBParameterGroup": {
        readonly service: "Neptune";
        readonly serviceAssetKey: "neptune";
    };
    readonly "AWS::Neptune::DBSubnetGroup": {
        readonly service: "Neptune";
        readonly serviceAssetKey: "neptune";
    };
    readonly "AWS::NetworkFirewall::Firewall": {
        readonly service: "NetworkFirewall";
        readonly serviceAssetKey: "network_firewall";
    };
    readonly "AWS::NetworkFirewall::FirewallPolicy": {
        readonly service: "NetworkFirewall";
        readonly serviceAssetKey: "network_firewall";
        readonly generalIconKey: "policy";
        readonly drawioGeneralShape: "addon";
    };
    readonly "AWS::NetworkFirewall::LoggingConfiguration": {
        readonly service: "NetworkFirewall";
        readonly serviceAssetKey: "network_firewall";
        readonly generalIconKey: "config";
        readonly drawioGeneralShape: "gear";
    };
    readonly "AWS::NetworkFirewall::RuleGroup": {
        readonly service: "NetworkFirewall";
        readonly serviceAssetKey: "network_firewall";
    };
    readonly "AWS::NetworkManager::ConnectAttachment": {
        readonly service: "NetworkManager";
        readonly serviceAssetKey: "vpc";
        readonly generalIconKey: "attachment";
        readonly drawioGeneralShape: "transit_gateway_attachment";
    };
    readonly "AWS::NetworkManager::ConnectPeer": {
        readonly service: "NetworkManager";
        readonly serviceAssetKey: "vpc";
    };
    readonly "AWS::NetworkManager::CoreNetwork": {
        readonly service: "NetworkManager";
        readonly serviceAssetKey: "vpc";
    };
    readonly "AWS::NetworkManager::CustomerGatewayAssociation": {
        readonly service: "NetworkManager";
        readonly serviceAssetKey: "vpc";
    };
    readonly "AWS::NetworkManager::Device": {
        readonly service: "NetworkManager";
        readonly serviceAssetKey: "vpc";
    };
    readonly "AWS::NetworkManager::GlobalNetwork": {
        readonly service: "NetworkManager";
        readonly serviceAssetKey: "vpc";
    };
    readonly "AWS::NetworkManager::Link": {
        readonly service: "NetworkManager";
        readonly serviceAssetKey: "vpc";
    };
    readonly "AWS::NetworkManager::LinkAssociation": {
        readonly service: "NetworkManager";
        readonly serviceAssetKey: "vpc";
    };
    readonly "AWS::NetworkManager::Site": {
        readonly service: "NetworkManager";
        readonly serviceAssetKey: "vpc";
    };
    readonly "AWS::NetworkManager::SiteToSiteVpnAttachment": {
        readonly service: "NetworkManager";
        readonly serviceAssetKey: "vpc";
        readonly generalIconKey: "attachment";
        readonly drawioGeneralShape: "transit_gateway_attachment";
    };
    readonly "AWS::NetworkManager::TransitGatewayRegistration": {
        readonly service: "NetworkManager";
        readonly serviceAssetKey: "vpc";
    };
    readonly "AWS::NetworkManager::VpcAttachment": {
        readonly service: "NetworkManager";
        readonly serviceAssetKey: "vpc";
        readonly generalIconKey: "attachment";
        readonly drawioGeneralShape: "transit_gateway_attachment";
    };
    readonly "AWS::NimbleStudio::LaunchProfile": {
        readonly service: "NimbleStudio";
        readonly serviceAssetKey: "nimble_studio";
    };
    readonly "AWS::NimbleStudio::StreamingImage": {
        readonly service: "NimbleStudio";
        readonly serviceAssetKey: "nimble_studio";
    };
    readonly "AWS::NimbleStudio::Studio": {
        readonly service: "NimbleStudio";
        readonly serviceAssetKey: "nimble_studio";
    };
    readonly "AWS::NimbleStudio::StudioComponent": {
        readonly service: "NimbleStudio";
        readonly serviceAssetKey: "nimble_studio";
    };
    readonly "AWS::Oam::Link": {
        readonly service: "Oam";
    };
    readonly "AWS::Oam::Sink": {
        readonly service: "Oam";
    };
    readonly "AWS::OpenSearchServerless::AccessPolicy": {
        readonly service: "OpenSearchServerless";
        readonly serviceAssetKey: "opensearch";
        readonly generalIconKey: "policy";
        readonly drawioGeneralShape: "addon";
    };
    readonly "AWS::OpenSearchServerless::Collection": {
        readonly service: "OpenSearchServerless";
        readonly serviceAssetKey: "opensearch";
    };
    readonly "AWS::OpenSearchServerless::SecurityConfig": {
        readonly service: "OpenSearchServerless";
        readonly serviceAssetKey: "opensearch";
        readonly generalIconKey: "config";
        readonly drawioGeneralShape: "gear";
    };
    readonly "AWS::OpenSearchServerless::SecurityPolicy": {
        readonly service: "OpenSearchServerless";
        readonly serviceAssetKey: "opensearch";
        readonly generalIconKey: "policy";
        readonly drawioGeneralShape: "addon";
    };
    readonly "AWS::OpenSearchServerless::VpcEndpoint": {
        readonly service: "OpenSearchServerless";
        readonly serviceAssetKey: "opensearch";
    };
    readonly "AWS::OpenSearchService::Domain": {
        readonly service: "OpenSearchService";
        readonly serviceAssetKey: "opensearch";
    };
    readonly "AWS::OpsWorks::App": {
        readonly service: "OpsWorks";
        readonly serviceAssetKey: "opsworks";
        readonly generalIconKey: "generic_application";
    };
    readonly "AWS::OpsWorks::ElasticLoadBalancerAttachment": {
        readonly service: "OpsWorks";
        readonly serviceAssetKey: "opsworks";
        readonly generalIconKey: "attachment";
        readonly drawioGeneralShape: "transit_gateway_attachment";
    };
    readonly "AWS::OpsWorks::Instance": {
        readonly service: "OpsWorks";
        readonly serviceAssetKey: "opsworks";
        readonly assetKey: "ec2_instance";
        readonly drawioShape: "instance";
    };
    readonly "AWS::OpsWorks::Layer": {
        readonly service: "OpsWorks";
        readonly serviceAssetKey: "opsworks";
    };
    readonly "AWS::OpsWorks::Stack": {
        readonly service: "OpsWorks";
        readonly serviceAssetKey: "opsworks";
        readonly assetKey: "cloudformation_stack";
        readonly drawioShape: "stack";
    };
    readonly "AWS::OpsWorks::UserProfile": {
        readonly service: "OpsWorks";
        readonly serviceAssetKey: "opsworks";
    };
    readonly "AWS::OpsWorks::Volume": {
        readonly service: "OpsWorks";
        readonly serviceAssetKey: "opsworks";
    };
    readonly "AWS::OpsWorksCM::Server": {
        readonly service: "OpsWorksCM";
        readonly serviceAssetKey: "opsworks";
        readonly generalIconKey: "traditional_server";
        readonly drawioGeneralShape: "traditional_server";
    };
    readonly "AWS::Organizations::Account": {
        readonly service: "Organizations";
        readonly serviceAssetKey: "organizations";
        readonly assetKey: "organizations_account";
        readonly drawioShape: "organizations_account";
    };
    readonly "AWS::Organizations::OrganizationalUnit": {
        readonly service: "Organizations";
        readonly serviceAssetKey: "organizations";
        readonly assetKey: "organizations_organizational_unit";
        readonly drawioShape: "organizations_organizational_unit";
    };
    readonly "AWS::Organizations::Policy": {
        readonly service: "Organizations";
        readonly serviceAssetKey: "organizations";
        readonly assetKey: "iot_core_policy";
        readonly generalIconKey: "policy";
        readonly drawioGeneralShape: "addon";
    };
    readonly "AWS::Panorama::ApplicationInstance": {
        readonly service: "Panorama";
        readonly serviceAssetKey: "panorama";
    };
    readonly "AWS::Panorama::Package": {
        readonly service: "Panorama";
        readonly serviceAssetKey: "panorama";
    };
    readonly "AWS::Panorama::PackageVersion": {
        readonly service: "Panorama";
        readonly serviceAssetKey: "panorama";
    };
    readonly "AWS::Personalize::Dataset": {
        readonly service: "Personalize";
        readonly serviceAssetKey: "personalize";
        readonly assetKey: "iot_analytics_dataset";
        readonly drawioShape: "data_set";
    };
    readonly "AWS::Personalize::DatasetGroup": {
        readonly service: "Personalize";
        readonly serviceAssetKey: "personalize";
    };
    readonly "AWS::Personalize::Schema": {
        readonly service: "Personalize";
        readonly serviceAssetKey: "personalize";
        readonly assetKey: "eventbridge_schema";
        readonly drawioShape: "eventbridge_schema";
    };
    readonly "AWS::Personalize::Solution": {
        readonly service: "Personalize";
        readonly serviceAssetKey: "personalize";
    };
    readonly "AWS::Pinpoint::ADMChannel": {
        readonly service: "Pinpoint";
        readonly serviceAssetKey: "pinpoint";
    };
    readonly "AWS::Pinpoint::APNSChannel": {
        readonly service: "Pinpoint";
        readonly serviceAssetKey: "pinpoint";
    };
    readonly "AWS::Pinpoint::APNSSandboxChannel": {
        readonly service: "Pinpoint";
        readonly serviceAssetKey: "pinpoint";
    };
    readonly "AWS::Pinpoint::APNSVoipChannel": {
        readonly service: "Pinpoint";
        readonly serviceAssetKey: "pinpoint";
    };
    readonly "AWS::Pinpoint::APNSVoipSandboxChannel": {
        readonly service: "Pinpoint";
        readonly serviceAssetKey: "pinpoint";
    };
    readonly "AWS::Pinpoint::App": {
        readonly service: "Pinpoint";
        readonly serviceAssetKey: "pinpoint";
        readonly generalIconKey: "generic_application";
    };
    readonly "AWS::Pinpoint::ApplicationSettings": {
        readonly service: "Pinpoint";
        readonly serviceAssetKey: "pinpoint";
    };
    readonly "AWS::Pinpoint::BaiduChannel": {
        readonly service: "Pinpoint";
        readonly serviceAssetKey: "pinpoint";
    };
    readonly "AWS::Pinpoint::Campaign": {
        readonly service: "Pinpoint";
        readonly serviceAssetKey: "pinpoint";
    };
    readonly "AWS::Pinpoint::EmailChannel": {
        readonly service: "Pinpoint";
        readonly serviceAssetKey: "pinpoint";
    };
    readonly "AWS::Pinpoint::EmailTemplate": {
        readonly service: "Pinpoint";
        readonly serviceAssetKey: "pinpoint";
        readonly generalIconKey: "template";
        readonly drawioGeneralShape: "template";
    };
    readonly "AWS::Pinpoint::EventStream": {
        readonly service: "Pinpoint";
        readonly serviceAssetKey: "pinpoint";
    };
    readonly "AWS::Pinpoint::GCMChannel": {
        readonly service: "Pinpoint";
        readonly serviceAssetKey: "pinpoint";
    };
    readonly "AWS::Pinpoint::InAppTemplate": {
        readonly service: "Pinpoint";
        readonly serviceAssetKey: "pinpoint";
        readonly generalIconKey: "template";
        readonly drawioGeneralShape: "template";
    };
    readonly "AWS::Pinpoint::PushTemplate": {
        readonly service: "Pinpoint";
        readonly serviceAssetKey: "pinpoint";
        readonly generalIconKey: "template";
        readonly drawioGeneralShape: "template";
    };
    readonly "AWS::Pinpoint::SMSChannel": {
        readonly service: "Pinpoint";
        readonly serviceAssetKey: "pinpoint";
    };
    readonly "AWS::Pinpoint::Segment": {
        readonly service: "Pinpoint";
        readonly serviceAssetKey: "pinpoint";
    };
    readonly "AWS::Pinpoint::SmsTemplate": {
        readonly service: "Pinpoint";
        readonly serviceAssetKey: "pinpoint";
        readonly generalIconKey: "template";
        readonly drawioGeneralShape: "template";
    };
    readonly "AWS::Pinpoint::VoiceChannel": {
        readonly service: "Pinpoint";
        readonly serviceAssetKey: "pinpoint";
    };
    readonly "AWS::PinpointEmail::ConfigurationSet": {
        readonly service: "PinpointEmail";
        readonly serviceAssetKey: "pinpoint";
    };
    readonly "AWS::PinpointEmail::ConfigurationSetEventDestination": {
        readonly service: "PinpointEmail";
        readonly serviceAssetKey: "pinpoint";
    };
    readonly "AWS::PinpointEmail::DedicatedIpPool": {
        readonly service: "PinpointEmail";
        readonly serviceAssetKey: "pinpoint";
    };
    readonly "AWS::PinpointEmail::Identity": {
        readonly service: "PinpointEmail";
        readonly serviceAssetKey: "pinpoint";
    };
    readonly "AWS::Pipes::Pipe": {
        readonly service: "Pipes";
    };
    readonly "AWS::QLDB::Ledger": {
        readonly service: "QLDB";
        readonly serviceAssetKey: "quantum_ledger_database";
    };
    readonly "AWS::QLDB::Stream": {
        readonly service: "QLDB";
        readonly serviceAssetKey: "quantum_ledger_database";
    };
    readonly "AWS::QuickSight::Analysis": {
        readonly service: "QuickSight";
        readonly serviceAssetKey: "quicksight";
    };
    readonly "AWS::QuickSight::Dashboard": {
        readonly service: "QuickSight";
        readonly serviceAssetKey: "quicksight";
    };
    readonly "AWS::QuickSight::DataSet": {
        readonly service: "QuickSight";
        readonly serviceAssetKey: "quicksight";
        readonly assetKey: "iot_analytics_dataset";
        readonly drawioShape: "data_set";
    };
    readonly "AWS::QuickSight::DataSource": {
        readonly service: "QuickSight";
        readonly serviceAssetKey: "quicksight";
    };
    readonly "AWS::QuickSight::Template": {
        readonly service: "QuickSight";
        readonly serviceAssetKey: "quicksight";
        readonly generalIconKey: "template";
        readonly drawioGeneralShape: "template";
    };
    readonly "AWS::QuickSight::Theme": {
        readonly service: "QuickSight";
        readonly serviceAssetKey: "quicksight";
    };
    readonly "AWS::RAM::ResourceShare": {
        readonly service: "RAM";
        readonly serviceAssetKey: "resource_access_manager";
    };
    readonly "AWS::RDS::DBCluster": {
        readonly service: "RDS";
        readonly serviceAssetKey: "rds";
    };
    readonly "AWS::RDS::DBClusterParameterGroup": {
        readonly service: "RDS";
        readonly serviceAssetKey: "rds";
    };
    readonly "AWS::RDS::DBInstance": {
        readonly service: "RDS";
        readonly serviceAssetKey: "rds";
        readonly assetKey: "rds_instance";
        readonly drawioShape: "rds_instance";
    };
    readonly "AWS::RDS::DBParameterGroup": {
        readonly service: "RDS";
        readonly serviceAssetKey: "rds";
    };
    readonly "AWS::RDS::DBProxy": {
        readonly service: "RDS";
        readonly serviceAssetKey: "rds";
    };
    readonly "AWS::RDS::DBProxyEndpoint": {
        readonly service: "RDS";
        readonly serviceAssetKey: "rds";
    };
    readonly "AWS::RDS::DBProxyTargetGroup": {
        readonly service: "RDS";
        readonly serviceAssetKey: "rds";
    };
    readonly "AWS::RDS::DBSecurityGroup": {
        readonly service: "RDS";
        readonly serviceAssetKey: "rds";
    };
    readonly "AWS::RDS::DBSecurityGroupIngress": {
        readonly service: "RDS";
        readonly serviceAssetKey: "rds";
    };
    readonly "AWS::RDS::DBSubnetGroup": {
        readonly service: "RDS";
        readonly serviceAssetKey: "rds";
    };
    readonly "AWS::RDS::EventSubscription": {
        readonly service: "RDS";
        readonly serviceAssetKey: "rds";
    };
    readonly "AWS::RDS::GlobalCluster": {
        readonly service: "RDS";
        readonly serviceAssetKey: "rds";
    };
    readonly "AWS::RDS::OptionGroup": {
        readonly service: "RDS";
        readonly serviceAssetKey: "rds";
    };
    readonly "AWS::RUM::AppMonitor": {
        readonly service: "RUM";
        readonly serviceAssetKey: "cloudwatch";
    };
    readonly "AWS::Redshift::Cluster": {
        readonly service: "Redshift";
        readonly serviceAssetKey: "redshift";
        readonly assetKey: "emr_cluster";
        readonly drawioShape: "cluster";
    };
    readonly "AWS::Redshift::ClusterParameterGroup": {
        readonly service: "Redshift";
        readonly serviceAssetKey: "redshift";
    };
    readonly "AWS::Redshift::ClusterSecurityGroup": {
        readonly service: "Redshift";
        readonly serviceAssetKey: "redshift";
    };
    readonly "AWS::Redshift::ClusterSecurityGroupIngress": {
        readonly service: "Redshift";
        readonly serviceAssetKey: "redshift";
    };
    readonly "AWS::Redshift::ClusterSubnetGroup": {
        readonly service: "Redshift";
        readonly serviceAssetKey: "redshift";
    };
    readonly "AWS::Redshift::EndpointAccess": {
        readonly service: "Redshift";
        readonly serviceAssetKey: "redshift";
    };
    readonly "AWS::Redshift::EndpointAuthorization": {
        readonly service: "Redshift";
        readonly serviceAssetKey: "redshift";
    };
    readonly "AWS::Redshift::EventSubscription": {
        readonly service: "Redshift";
        readonly serviceAssetKey: "redshift";
    };
    readonly "AWS::Redshift::ScheduledAction": {
        readonly service: "Redshift";
        readonly serviceAssetKey: "redshift";
    };
    readonly "AWS::RedshiftServerless::Namespace": {
        readonly service: "RedshiftServerless";
        readonly serviceAssetKey: "redshift";
    };
    readonly "AWS::RedshiftServerless::Workgroup": {
        readonly service: "RedshiftServerless";
        readonly serviceAssetKey: "redshift";
    };
    readonly "AWS::RefactorSpaces::Application": {
        readonly service: "RefactorSpaces";
        readonly serviceAssetKey: "migration_hub";
        readonly assetKey: "elastic_beanstalk_application";
        readonly generalIconKey: "generic_application";
        readonly drawioShape: "application";
    };
    readonly "AWS::RefactorSpaces::Environment": {
        readonly service: "RefactorSpaces";
        readonly serviceAssetKey: "migration_hub";
    };
    readonly "AWS::RefactorSpaces::Route": {
        readonly service: "RefactorSpaces";
        readonly serviceAssetKey: "migration_hub";
    };
    readonly "AWS::RefactorSpaces::Service": {
        readonly service: "RefactorSpaces";
        readonly serviceAssetKey: "migration_hub";
        readonly assetKey: "ecs_service";
        readonly drawioShape: "ecs";
    };
    readonly "AWS::Rekognition::Collection": {
        readonly service: "Rekognition";
        readonly serviceAssetKey: "rekognition";
    };
    readonly "AWS::Rekognition::Project": {
        readonly service: "Rekognition";
        readonly serviceAssetKey: "rekognition";
    };
    readonly "AWS::Rekognition::StreamProcessor": {
        readonly service: "Rekognition";
        readonly serviceAssetKey: "rekognition";
    };
    readonly "AWS::ResilienceHub::App": {
        readonly service: "ResilienceHub";
        readonly serviceAssetKey: "resilience_hub";
        readonly generalIconKey: "generic_application";
    };
    readonly "AWS::ResilienceHub::ResiliencyPolicy": {
        readonly service: "ResilienceHub";
        readonly serviceAssetKey: "resilience_hub";
        readonly generalIconKey: "policy";
        readonly drawioGeneralShape: "addon";
    };
    readonly "AWS::ResourceExplorer2::DefaultViewAssociation": {
        readonly service: "ResourceExplorer2";
    };
    readonly "AWS::ResourceExplorer2::Index": {
        readonly service: "ResourceExplorer2";
    };
    readonly "AWS::ResourceExplorer2::View": {
        readonly service: "ResourceExplorer2";
    };
    readonly "AWS::ResourceGroups::Group": {
        readonly service: "ResourceGroups";
        readonly serviceAssetKey: "ssm";
    };
    readonly "AWS::RoboMaker::Fleet": {
        readonly service: "RoboMaker";
        readonly serviceAssetKey: "robomaker";
    };
    readonly "AWS::RoboMaker::Robot": {
        readonly service: "RoboMaker";
        readonly serviceAssetKey: "robomaker";
    };
    readonly "AWS::RoboMaker::RobotApplication": {
        readonly service: "RoboMaker";
        readonly serviceAssetKey: "robomaker";
    };
    readonly "AWS::RoboMaker::RobotApplicationVersion": {
        readonly service: "RoboMaker";
        readonly serviceAssetKey: "robomaker";
    };
    readonly "AWS::RoboMaker::SimulationApplication": {
        readonly service: "RoboMaker";
        readonly serviceAssetKey: "robomaker";
    };
    readonly "AWS::RoboMaker::SimulationApplicationVersion": {
        readonly service: "RoboMaker";
        readonly serviceAssetKey: "robomaker";
    };
    readonly "AWS::RolesAnywhere::CRL": {
        readonly service: "RolesAnywhere";
        readonly serviceAssetKey: "iam";
    };
    readonly "AWS::RolesAnywhere::Profile": {
        readonly service: "RolesAnywhere";
        readonly serviceAssetKey: "iam";
    };
    readonly "AWS::RolesAnywhere::TrustAnchor": {
        readonly service: "RolesAnywhere";
        readonly serviceAssetKey: "iam";
    };
    readonly "AWS::Route53::CidrCollection": {
        readonly service: "Route53";
        readonly serviceAssetKey: "route_53";
    };
    readonly "AWS::Route53::DNSSEC": {
        readonly service: "Route53";
        readonly serviceAssetKey: "route_53";
    };
    readonly "AWS::Route53::HealthCheck": {
        readonly service: "Route53";
        readonly serviceAssetKey: "route_53";
    };
    readonly "AWS::Route53::HostedZone": {
        readonly service: "Route53";
        readonly serviceAssetKey: "route_53";
        readonly assetKey: "route_53_hosted_zone";
        readonly drawioShape: "hosted_zone";
    };
    readonly "AWS::Route53::KeySigningKey": {
        readonly service: "Route53";
        readonly serviceAssetKey: "route_53";
        readonly generalIconKey: "key";
        readonly drawioGeneralShape: "permissions";
    };
    readonly "AWS::Route53::RecordSet": {
        readonly service: "Route53";
        readonly serviceAssetKey: "route_53";
    };
    readonly "AWS::Route53::RecordSetGroup": {
        readonly service: "Route53";
        readonly serviceAssetKey: "route_53";
    };
    readonly "AWS::Route53RecoveryControl::Cluster": {
        readonly service: "Route53RecoveryControl";
        readonly serviceAssetKey: "route_53";
        readonly assetKey: "emr_cluster";
        readonly drawioShape: "cluster";
    };
    readonly "AWS::Route53RecoveryControl::ControlPanel": {
        readonly service: "Route53RecoveryControl";
        readonly serviceAssetKey: "route_53";
    };
    readonly "AWS::Route53RecoveryControl::RoutingControl": {
        readonly service: "Route53RecoveryControl";
        readonly serviceAssetKey: "route_53";
    };
    readonly "AWS::Route53RecoveryControl::SafetyRule": {
        readonly service: "Route53RecoveryControl";
        readonly serviceAssetKey: "route_53";
        readonly generalIconKey: "rule";
        readonly drawioGeneralShape: "rule";
    };
    readonly "AWS::Route53RecoveryReadiness::Cell": {
        readonly service: "Route53RecoveryReadiness";
        readonly serviceAssetKey: "route_53";
    };
    readonly "AWS::Route53RecoveryReadiness::ReadinessCheck": {
        readonly service: "Route53RecoveryReadiness";
        readonly serviceAssetKey: "route_53";
    };
    readonly "AWS::Route53RecoveryReadiness::RecoveryGroup": {
        readonly service: "Route53RecoveryReadiness";
        readonly serviceAssetKey: "route_53";
    };
    readonly "AWS::Route53RecoveryReadiness::ResourceSet": {
        readonly service: "Route53RecoveryReadiness";
        readonly serviceAssetKey: "route_53";
    };
    readonly "AWS::Route53Resolver::FirewallDomainList": {
        readonly service: "Route53Resolver";
        readonly serviceAssetKey: "route_53";
    };
    readonly "AWS::Route53Resolver::FirewallRuleGroup": {
        readonly service: "Route53Resolver";
        readonly serviceAssetKey: "route_53";
    };
    readonly "AWS::Route53Resolver::FirewallRuleGroupAssociation": {
        readonly service: "Route53Resolver";
        readonly serviceAssetKey: "route_53";
    };
    readonly "AWS::Route53Resolver::ResolverConfig": {
        readonly service: "Route53Resolver";
        readonly serviceAssetKey: "route_53";
        readonly generalIconKey: "config";
        readonly drawioGeneralShape: "gear";
    };
    readonly "AWS::Route53Resolver::ResolverDNSSECConfig": {
        readonly service: "Route53Resolver";
        readonly serviceAssetKey: "route_53";
        readonly generalIconKey: "config";
        readonly drawioGeneralShape: "gear";
    };
    readonly "AWS::Route53Resolver::ResolverEndpoint": {
        readonly service: "Route53Resolver";
        readonly serviceAssetKey: "route_53";
    };
    readonly "AWS::Route53Resolver::ResolverQueryLoggingConfig": {
        readonly service: "Route53Resolver";
        readonly serviceAssetKey: "route_53";
        readonly generalIconKey: "config";
        readonly drawioGeneralShape: "gear";
    };
    readonly "AWS::Route53Resolver::ResolverQueryLoggingConfigAssociation": {
        readonly service: "Route53Resolver";
        readonly serviceAssetKey: "route_53";
    };
    readonly "AWS::Route53Resolver::ResolverRule": {
        readonly service: "Route53Resolver";
        readonly serviceAssetKey: "route_53";
        readonly generalIconKey: "rule";
        readonly drawioGeneralShape: "rule";
    };
    readonly "AWS::Route53Resolver::ResolverRuleAssociation": {
        readonly service: "Route53Resolver";
        readonly serviceAssetKey: "route_53";
    };
    readonly "AWS::S3::AccessPoint": {
        readonly service: "S3";
        readonly serviceAssetKey: "s3";
    };
    readonly "AWS::S3::Bucket": {
        readonly service: "S3";
        readonly serviceAssetKey: "s3";
        readonly assetKey: "s3_bucket";
        readonly drawioShape: "bucket";
    };
    readonly "AWS::S3::BucketPolicy": {
        readonly service: "S3";
        readonly serviceAssetKey: "s3";
        readonly generalIconKey: "policy";
        readonly drawioGeneralShape: "addon";
    };
    readonly "AWS::S3::MultiRegionAccessPoint": {
        readonly service: "S3";
        readonly serviceAssetKey: "s3";
    };
    readonly "AWS::S3::MultiRegionAccessPointPolicy": {
        readonly service: "S3";
        readonly serviceAssetKey: "s3";
        readonly generalIconKey: "policy";
        readonly drawioGeneralShape: "addon";
    };
    readonly "AWS::S3::StorageLens": {
        readonly service: "S3";
        readonly serviceAssetKey: "s3";
    };
    readonly "AWS::S3ObjectLambda::AccessPoint": {
        readonly service: "S3ObjectLambda";
        readonly serviceAssetKey: "s3";
    };
    readonly "AWS::S3ObjectLambda::AccessPointPolicy": {
        readonly service: "S3ObjectLambda";
        readonly serviceAssetKey: "s3";
        readonly generalIconKey: "policy";
        readonly drawioGeneralShape: "addon";
    };
    readonly "AWS::S3Outposts::AccessPoint": {
        readonly service: "S3Outposts";
        readonly serviceAssetKey: "s3_on_outposts";
    };
    readonly "AWS::S3Outposts::Bucket": {
        readonly service: "S3Outposts";
        readonly serviceAssetKey: "s3_on_outposts";
        readonly assetKey: "s3_bucket";
        readonly drawioShape: "bucket";
    };
    readonly "AWS::S3Outposts::BucketPolicy": {
        readonly service: "S3Outposts";
        readonly serviceAssetKey: "s3_on_outposts";
        readonly generalIconKey: "policy";
        readonly drawioGeneralShape: "addon";
    };
    readonly "AWS::S3Outposts::Endpoint": {
        readonly service: "S3Outposts";
        readonly serviceAssetKey: "s3_on_outposts";
    };
    readonly "AWS::SDB::Domain": {
        readonly service: "SDB";
    };
    readonly "AWS::SES::ConfigurationSet": {
        readonly service: "SES";
        readonly serviceAssetKey: "ses";
    };
    readonly "AWS::SES::ConfigurationSetEventDestination": {
        readonly service: "SES";
        readonly serviceAssetKey: "ses";
    };
    readonly "AWS::SES::ContactList": {
        readonly service: "SES";
        readonly serviceAssetKey: "ses";
    };
    readonly "AWS::SES::DedicatedIpPool": {
        readonly service: "SES";
        readonly serviceAssetKey: "ses";
    };
    readonly "AWS::SES::EmailIdentity": {
        readonly service: "SES";
        readonly serviceAssetKey: "ses";
    };
    readonly "AWS::SES::ReceiptFilter": {
        readonly service: "SES";
        readonly serviceAssetKey: "ses";
    };
    readonly "AWS::SES::ReceiptRule": {
        readonly service: "SES";
        readonly serviceAssetKey: "ses";
        readonly generalIconKey: "rule";
        readonly drawioGeneralShape: "rule";
    };
    readonly "AWS::SES::ReceiptRuleSet": {
        readonly service: "SES";
        readonly serviceAssetKey: "ses";
    };
    readonly "AWS::SES::Template": {
        readonly service: "SES";
        readonly serviceAssetKey: "ses";
        readonly generalIconKey: "template";
        readonly drawioGeneralShape: "template";
    };
    readonly "AWS::SES::VdmAttributes": {
        readonly service: "SES";
        readonly serviceAssetKey: "ses";
    };
    readonly "AWS::SNS::Subscription": {
        readonly service: "SNS";
        readonly serviceAssetKey: "sns";
    };
    readonly "AWS::SNS::Topic": {
        readonly service: "SNS";
        readonly serviceAssetKey: "sns";
        readonly assetKey: "sns_topic";
        readonly drawioShape: "topic";
    };
    readonly "AWS::SNS::TopicPolicy": {
        readonly service: "SNS";
        readonly serviceAssetKey: "sns";
        readonly generalIconKey: "policy";
        readonly drawioGeneralShape: "addon";
    };
    readonly "AWS::SQS::Queue": {
        readonly service: "SQS";
        readonly serviceAssetKey: "sqs";
        readonly assetKey: "sqs_queue";
        readonly drawioShape: "queue";
    };
    readonly "AWS::SQS::QueuePolicy": {
        readonly service: "SQS";
        readonly serviceAssetKey: "sqs";
        readonly generalIconKey: "policy";
        readonly drawioGeneralShape: "addon";
    };
    readonly "AWS::SSM::Association": {
        readonly service: "SSM";
        readonly serviceAssetKey: "ssm";
    };
    readonly "AWS::SSM::Document": {
        readonly service: "SSM";
        readonly serviceAssetKey: "ssm";
    };
    readonly "AWS::SSM::MaintenanceWindow": {
        readonly service: "SSM";
        readonly serviceAssetKey: "ssm";
    };
    readonly "AWS::SSM::MaintenanceWindowTarget": {
        readonly service: "SSM";
        readonly serviceAssetKey: "ssm";
    };
    readonly "AWS::SSM::MaintenanceWindowTask": {
        readonly service: "SSM";
        readonly serviceAssetKey: "ssm";
    };
    readonly "AWS::SSM::Parameter": {
        readonly service: "SSM";
        readonly serviceAssetKey: "ssm";
    };
    readonly "AWS::SSM::PatchBaseline": {
        readonly service: "SSM";
        readonly serviceAssetKey: "ssm";
    };
    readonly "AWS::SSM::ResourceDataSync": {
        readonly service: "SSM";
        readonly serviceAssetKey: "ssm";
    };
    readonly "AWS::SSM::ResourcePolicy": {
        readonly service: "SSM";
        readonly serviceAssetKey: "ssm";
        readonly generalIconKey: "policy";
        readonly drawioGeneralShape: "addon";
    };
    readonly "AWS::SSMContacts::Contact": {
        readonly service: "SSMContacts";
        readonly serviceAssetKey: "ssm";
    };
    readonly "AWS::SSMContacts::ContactChannel": {
        readonly service: "SSMContacts";
        readonly serviceAssetKey: "ssm";
    };
    readonly "AWS::SSMIncidents::ReplicationSet": {
        readonly service: "SSMIncidents";
        readonly serviceAssetKey: "ssm";
    };
    readonly "AWS::SSMIncidents::ResponsePlan": {
        readonly service: "SSMIncidents";
        readonly serviceAssetKey: "ssm";
    };
    readonly "AWS::SSO::Assignment": {
        readonly service: "SSO";
        readonly serviceAssetKey: "iam_identity_center";
    };
    readonly "AWS::SSO::InstanceAccessControlAttributeConfiguration": {
        readonly service: "SSO";
        readonly serviceAssetKey: "iam_identity_center";
        readonly generalIconKey: "config";
        readonly drawioGeneralShape: "gear";
    };
    readonly "AWS::SSO::PermissionSet": {
        readonly service: "SSO";
        readonly serviceAssetKey: "iam_identity_center";
    };
    readonly "AWS::SageMaker::App": {
        readonly service: "SageMaker";
        readonly serviceAssetKey: "sagemaker";
        readonly generalIconKey: "generic_application";
    };
    readonly "AWS::SageMaker::AppImageConfig": {
        readonly service: "SageMaker";
        readonly serviceAssetKey: "sagemaker";
        readonly generalIconKey: "config";
        readonly drawioGeneralShape: "gear";
    };
    readonly "AWS::SageMaker::CodeRepository": {
        readonly service: "SageMaker";
        readonly serviceAssetKey: "sagemaker";
    };
    readonly "AWS::SageMaker::DataQualityJobDefinition": {
        readonly service: "SageMaker";
        readonly serviceAssetKey: "sagemaker";
    };
    readonly "AWS::SageMaker::Device": {
        readonly service: "SageMaker";
        readonly serviceAssetKey: "sagemaker";
    };
    readonly "AWS::SageMaker::DeviceFleet": {
        readonly service: "SageMaker";
        readonly serviceAssetKey: "sagemaker";
    };
    readonly "AWS::SageMaker::Domain": {
        readonly service: "SageMaker";
        readonly serviceAssetKey: "sagemaker";
    };
    readonly "AWS::SageMaker::Endpoint": {
        readonly service: "SageMaker";
        readonly serviceAssetKey: "sagemaker";
    };
    readonly "AWS::SageMaker::EndpointConfig": {
        readonly service: "SageMaker";
        readonly serviceAssetKey: "sagemaker";
        readonly generalIconKey: "config";
        readonly drawioGeneralShape: "gear";
    };
    readonly "AWS::SageMaker::FeatureGroup": {
        readonly service: "SageMaker";
        readonly serviceAssetKey: "sagemaker";
    };
    readonly "AWS::SageMaker::Image": {
        readonly service: "SageMaker";
        readonly serviceAssetKey: "sagemaker";
    };
    readonly "AWS::SageMaker::ImageVersion": {
        readonly service: "SageMaker";
        readonly serviceAssetKey: "sagemaker";
    };
    readonly "AWS::SageMaker::Model": {
        readonly service: "SageMaker";
        readonly serviceAssetKey: "sagemaker";
        readonly assetKey: "sagemaker_model";
        readonly generalIconKey: "document";
        readonly drawioShape: "sagemaker_model";
    };
    readonly "AWS::SageMaker::ModelBiasJobDefinition": {
        readonly service: "SageMaker";
        readonly serviceAssetKey: "sagemaker";
    };
    readonly "AWS::SageMaker::ModelExplainabilityJobDefinition": {
        readonly service: "SageMaker";
        readonly serviceAssetKey: "sagemaker";
    };
    readonly "AWS::SageMaker::ModelPackage": {
        readonly service: "SageMaker";
        readonly serviceAssetKey: "sagemaker";
    };
    readonly "AWS::SageMaker::ModelPackageGroup": {
        readonly service: "SageMaker";
        readonly serviceAssetKey: "sagemaker";
    };
    readonly "AWS::SageMaker::ModelQualityJobDefinition": {
        readonly service: "SageMaker";
        readonly serviceAssetKey: "sagemaker";
    };
    readonly "AWS::SageMaker::MonitoringSchedule": {
        readonly service: "SageMaker";
        readonly serviceAssetKey: "sagemaker";
    };
    readonly "AWS::SageMaker::NotebookInstance": {
        readonly service: "SageMaker";
        readonly serviceAssetKey: "sagemaker";
    };
    readonly "AWS::SageMaker::NotebookInstanceLifecycleConfig": {
        readonly service: "SageMaker";
        readonly serviceAssetKey: "sagemaker";
        readonly generalIconKey: "config";
        readonly drawioGeneralShape: "gear";
    };
    readonly "AWS::SageMaker::Pipeline": {
        readonly service: "SageMaker";
        readonly serviceAssetKey: "sagemaker";
        readonly assetKey: "iot_analytics_pipeline";
        readonly drawioShape: "iot_analytics_pipeline";
    };
    readonly "AWS::SageMaker::Project": {
        readonly service: "SageMaker";
        readonly serviceAssetKey: "sagemaker";
    };
    readonly "AWS::SageMaker::UserProfile": {
        readonly service: "SageMaker";
        readonly serviceAssetKey: "sagemaker";
    };
    readonly "AWS::SageMaker::Workteam": {
        readonly service: "SageMaker";
        readonly serviceAssetKey: "sagemaker";
    };
    readonly "AWS::Scheduler::Schedule": {
        readonly service: "Scheduler";
    };
    readonly "AWS::Scheduler::ScheduleGroup": {
        readonly service: "Scheduler";
    };
    readonly "AWS::SecretsManager::ResourcePolicy": {
        readonly service: "SecretsManager";
        readonly serviceAssetKey: "secrets_manager";
        readonly generalIconKey: "policy";
        readonly drawioGeneralShape: "addon";
    };
    readonly "AWS::SecretsManager::RotationSchedule": {
        readonly service: "SecretsManager";
        readonly serviceAssetKey: "secrets_manager";
    };
    readonly "AWS::SecretsManager::Secret": {
        readonly service: "SecretsManager";
        readonly serviceAssetKey: "secrets_manager";
    };
    readonly "AWS::SecretsManager::SecretTargetAttachment": {
        readonly service: "SecretsManager";
        readonly serviceAssetKey: "secrets_manager";
        readonly generalIconKey: "attachment";
        readonly drawioGeneralShape: "transit_gateway_attachment";
    };
    readonly "AWS::SecurityHub::Hub": {
        readonly service: "SecurityHub";
        readonly serviceAssetKey: "security_hub";
    };
    readonly "AWS::Serverless::Api": {
        readonly service: "Serverless";
        readonly serviceAssetKey: "serverless_application_repository";
    };
    readonly "AWS::Serverless::Application": {
        readonly service: "Serverless";
        readonly serviceAssetKey: "serverless_application_repository";
        readonly assetKey: "elastic_beanstalk_application";
        readonly generalIconKey: "generic_application";
        readonly drawioShape: "application";
    };
    readonly "AWS::Serverless::Function": {
        readonly service: "Serverless";
        readonly serviceAssetKey: "serverless_application_repository";
        readonly assetKey: "lambda_lambda_function";
    };
    readonly "AWS::Serverless::HttpApi": {
        readonly service: "Serverless";
        readonly serviceAssetKey: "serverless_application_repository";
    };
    readonly "AWS::Serverless::LayerVersion": {
        readonly service: "Serverless";
        readonly serviceAssetKey: "serverless_application_repository";
    };
    readonly "AWS::Serverless::SimpleTable": {
        readonly service: "Serverless";
        readonly serviceAssetKey: "serverless_application_repository";
    };
    readonly "AWS::Serverless::StateMachine": {
        readonly service: "Serverless";
        readonly serviceAssetKey: "serverless_application_repository";
    };
    readonly "AWS::ServiceCatalog::AcceptedPortfolioShare": {
        readonly service: "ServiceCatalog";
        readonly serviceAssetKey: "service_catalog";
    };
    readonly "AWS::ServiceCatalog::CloudFormationProduct": {
        readonly service: "ServiceCatalog";
        readonly serviceAssetKey: "service_catalog";
    };
    readonly "AWS::ServiceCatalog::CloudFormationProvisionedProduct": {
        readonly service: "ServiceCatalog";
        readonly serviceAssetKey: "service_catalog";
    };
    readonly "AWS::ServiceCatalog::LaunchNotificationConstraint": {
        readonly service: "ServiceCatalog";
        readonly serviceAssetKey: "service_catalog";
    };
    readonly "AWS::ServiceCatalog::LaunchRoleConstraint": {
        readonly service: "ServiceCatalog";
        readonly serviceAssetKey: "service_catalog";
    };
    readonly "AWS::ServiceCatalog::LaunchTemplateConstraint": {
        readonly service: "ServiceCatalog";
        readonly serviceAssetKey: "service_catalog";
        readonly generalIconKey: "template";
        readonly drawioGeneralShape: "template";
    };
    readonly "AWS::ServiceCatalog::Portfolio": {
        readonly service: "ServiceCatalog";
        readonly serviceAssetKey: "service_catalog";
    };
    readonly "AWS::ServiceCatalog::PortfolioPrincipalAssociation": {
        readonly service: "ServiceCatalog";
        readonly serviceAssetKey: "service_catalog";
    };
    readonly "AWS::ServiceCatalog::PortfolioProductAssociation": {
        readonly service: "ServiceCatalog";
        readonly serviceAssetKey: "service_catalog";
    };
    readonly "AWS::ServiceCatalog::PortfolioShare": {
        readonly service: "ServiceCatalog";
        readonly serviceAssetKey: "service_catalog";
    };
    readonly "AWS::ServiceCatalog::ResourceUpdateConstraint": {
        readonly service: "ServiceCatalog";
        readonly serviceAssetKey: "service_catalog";
    };
    readonly "AWS::ServiceCatalog::ServiceAction": {
        readonly service: "ServiceCatalog";
        readonly serviceAssetKey: "service_catalog";
    };
    readonly "AWS::ServiceCatalog::ServiceActionAssociation": {
        readonly service: "ServiceCatalog";
        readonly serviceAssetKey: "service_catalog";
    };
    readonly "AWS::ServiceCatalog::StackSetConstraint": {
        readonly service: "ServiceCatalog";
        readonly serviceAssetKey: "service_catalog";
    };
    readonly "AWS::ServiceCatalog::TagOption": {
        readonly service: "ServiceCatalog";
        readonly serviceAssetKey: "service_catalog";
    };
    readonly "AWS::ServiceCatalog::TagOptionAssociation": {
        readonly service: "ServiceCatalog";
        readonly serviceAssetKey: "service_catalog";
    };
    readonly "AWS::ServiceCatalogAppRegistry::Application": {
        readonly service: "ServiceCatalogAppRegistry";
        readonly serviceAssetKey: "service_catalog";
        readonly assetKey: "elastic_beanstalk_application";
        readonly generalIconKey: "generic_application";
        readonly drawioShape: "application";
    };
    readonly "AWS::ServiceCatalogAppRegistry::AttributeGroup": {
        readonly service: "ServiceCatalogAppRegistry";
        readonly serviceAssetKey: "service_catalog";
    };
    readonly "AWS::ServiceCatalogAppRegistry::AttributeGroupAssociation": {
        readonly service: "ServiceCatalogAppRegistry";
        readonly serviceAssetKey: "service_catalog";
    };
    readonly "AWS::ServiceCatalogAppRegistry::ResourceAssociation": {
        readonly service: "ServiceCatalogAppRegistry";
        readonly serviceAssetKey: "service_catalog";
    };
    readonly "AWS::ServiceDiscovery::HttpNamespace": {
        readonly service: "ServiceDiscovery";
        readonly serviceAssetKey: "application_discovery_service";
    };
    readonly "AWS::ServiceDiscovery::Instance": {
        readonly service: "ServiceDiscovery";
        readonly serviceAssetKey: "application_discovery_service";
        readonly assetKey: "ec2_instance";
        readonly drawioShape: "instance";
    };
    readonly "AWS::ServiceDiscovery::PrivateDnsNamespace": {
        readonly service: "ServiceDiscovery";
        readonly serviceAssetKey: "application_discovery_service";
    };
    readonly "AWS::ServiceDiscovery::PublicDnsNamespace": {
        readonly service: "ServiceDiscovery";
        readonly serviceAssetKey: "application_discovery_service";
    };
    readonly "AWS::ServiceDiscovery::Service": {
        readonly service: "ServiceDiscovery";
        readonly serviceAssetKey: "application_discovery_service";
        readonly assetKey: "ecs_service";
        readonly drawioShape: "ecs";
    };
    readonly "AWS::Signer::ProfilePermission": {
        readonly service: "Signer";
        readonly serviceAssetKey: "signer";
        readonly generalIconKey: "policy";
        readonly drawioGeneralShape: "addon";
    };
    readonly "AWS::Signer::SigningProfile": {
        readonly service: "Signer";
        readonly serviceAssetKey: "signer";
    };
    readonly "AWS::StepFunctions::Activity": {
        readonly service: "StepFunctions";
        readonly serviceAssetKey: "step_functions";
    };
    readonly "AWS::StepFunctions::StateMachine": {
        readonly service: "StepFunctions";
        readonly serviceAssetKey: "step_functions";
    };
    readonly "AWS::SupportApp::AccountAlias": {
        readonly service: "SupportApp";
        readonly serviceAssetKey: "support";
    };
    readonly "AWS::SupportApp::SlackChannelConfiguration": {
        readonly service: "SupportApp";
        readonly serviceAssetKey: "support";
        readonly generalIconKey: "config";
        readonly drawioGeneralShape: "gear";
    };
    readonly "AWS::SupportApp::SlackWorkspaceConfiguration": {
        readonly service: "SupportApp";
        readonly serviceAssetKey: "support";
        readonly generalIconKey: "config";
        readonly drawioGeneralShape: "gear";
    };
    readonly "AWS::Synthetics::Canary": {
        readonly service: "Synthetics";
        readonly serviceAssetKey: "cloudwatch";
    };
    readonly "AWS::Synthetics::Group": {
        readonly service: "Synthetics";
        readonly serviceAssetKey: "cloudwatch";
    };
    readonly "AWS::Timestream::Database": {
        readonly service: "Timestream";
        readonly serviceAssetKey: "timestream";
        readonly generalIconKey: "generic_database";
    };
    readonly "AWS::Timestream::ScheduledQuery": {
        readonly service: "Timestream";
        readonly serviceAssetKey: "timestream";
    };
    readonly "AWS::Timestream::Table": {
        readonly service: "Timestream";
        readonly serviceAssetKey: "timestream";
        readonly assetKey: "dynamodb_table";
        readonly drawioShape: "table";
    };
    readonly "AWS::Transfer::Agreement": {
        readonly service: "Transfer";
        readonly serviceAssetKey: "transfer_family";
    };
    readonly "AWS::Transfer::Certificate": {
        readonly service: "Transfer";
        readonly serviceAssetKey: "transfer_family";
        readonly assetKey: "iot_core_certificate";
        readonly generalIconKey: "ssl_padlock";
        readonly drawioGeneralShape: "ssl_padlock";
    };
    readonly "AWS::Transfer::Connector": {
        readonly service: "Transfer";
        readonly serviceAssetKey: "transfer_family";
    };
    readonly "AWS::Transfer::Profile": {
        readonly service: "Transfer";
        readonly serviceAssetKey: "transfer_family";
    };
    readonly "AWS::Transfer::Server": {
        readonly service: "Transfer";
        readonly serviceAssetKey: "transfer_family";
        readonly generalIconKey: "traditional_server";
        readonly drawioGeneralShape: "traditional_server";
    };
    readonly "AWS::Transfer::User": {
        readonly service: "Transfer";
        readonly serviceAssetKey: "transfer_family";
        readonly generalIconKey: "user";
        readonly drawioGeneralShape: "user";
    };
    readonly "AWS::Transfer::Workflow": {
        readonly service: "Transfer";
        readonly serviceAssetKey: "transfer_family";
    };
    readonly "AWS::VoiceID::Domain": {
        readonly service: "VoiceID";
        readonly serviceAssetKey: "connect";
    };
    readonly "AWS::WAF::ByteMatchSet": {
        readonly service: "WAF";
        readonly serviceAssetKey: "waf";
    };
    readonly "AWS::WAF::IPSet": {
        readonly service: "WAF";
        readonly serviceAssetKey: "waf";
    };
    readonly "AWS::WAF::Rule": {
        readonly service: "WAF";
        readonly serviceAssetKey: "waf";
        readonly assetKey: "eventbridge_rule";
        readonly generalIconKey: "rule";
        readonly drawioGeneralShape: "rule";
    };
    readonly "AWS::WAF::SizeConstraintSet": {
        readonly service: "WAF";
        readonly serviceAssetKey: "waf";
    };
    readonly "AWS::WAF::SqlInjectionMatchSet": {
        readonly service: "WAF";
        readonly serviceAssetKey: "waf";
    };
    readonly "AWS::WAF::WebACL": {
        readonly service: "WAF";
        readonly serviceAssetKey: "waf";
    };
    readonly "AWS::WAF::XssMatchSet": {
        readonly service: "WAF";
        readonly serviceAssetKey: "waf";
    };
    readonly "AWS::WAFRegional::ByteMatchSet": {
        readonly service: "WAFRegional";
        readonly serviceAssetKey: "waf";
    };
    readonly "AWS::WAFRegional::GeoMatchSet": {
        readonly service: "WAFRegional";
        readonly serviceAssetKey: "waf";
    };
    readonly "AWS::WAFRegional::IPSet": {
        readonly service: "WAFRegional";
        readonly serviceAssetKey: "waf";
    };
    readonly "AWS::WAFRegional::RateBasedRule": {
        readonly service: "WAFRegional";
        readonly serviceAssetKey: "waf";
        readonly generalIconKey: "rule";
        readonly drawioGeneralShape: "rule";
    };
    readonly "AWS::WAFRegional::RegexPatternSet": {
        readonly service: "WAFRegional";
        readonly serviceAssetKey: "waf";
    };
    readonly "AWS::WAFRegional::Rule": {
        readonly service: "WAFRegional";
        readonly serviceAssetKey: "waf";
        readonly assetKey: "eventbridge_rule";
        readonly generalIconKey: "rule";
        readonly drawioGeneralShape: "rule";
    };
    readonly "AWS::WAFRegional::SizeConstraintSet": {
        readonly service: "WAFRegional";
        readonly serviceAssetKey: "waf";
    };
    readonly "AWS::WAFRegional::SqlInjectionMatchSet": {
        readonly service: "WAFRegional";
        readonly serviceAssetKey: "waf";
    };
    readonly "AWS::WAFRegional::WebACL": {
        readonly service: "WAFRegional";
        readonly serviceAssetKey: "waf";
    };
    readonly "AWS::WAFRegional::WebACLAssociation": {
        readonly service: "WAFRegional";
        readonly serviceAssetKey: "waf";
    };
    readonly "AWS::WAFRegional::XssMatchSet": {
        readonly service: "WAFRegional";
        readonly serviceAssetKey: "waf";
    };
    readonly "AWS::WAFv2::IPSet": {
        readonly service: "WAFv2";
        readonly serviceAssetKey: "waf";
    };
    readonly "AWS::WAFv2::LoggingConfiguration": {
        readonly service: "WAFv2";
        readonly serviceAssetKey: "waf";
        readonly generalIconKey: "config";
        readonly drawioGeneralShape: "gear";
    };
    readonly "AWS::WAFv2::RegexPatternSet": {
        readonly service: "WAFv2";
        readonly serviceAssetKey: "waf";
    };
    readonly "AWS::WAFv2::RuleGroup": {
        readonly service: "WAFv2";
        readonly serviceAssetKey: "waf";
    };
    readonly "AWS::WAFv2::WebACL": {
        readonly service: "WAFv2";
        readonly serviceAssetKey: "waf";
    };
    readonly "AWS::WAFv2::WebACLAssociation": {
        readonly service: "WAFv2";
        readonly serviceAssetKey: "waf";
    };
    readonly "AWS::Wisdom::Assistant": {
        readonly service: "Wisdom";
        readonly serviceAssetKey: "connect";
    };
    readonly "AWS::Wisdom::AssistantAssociation": {
        readonly service: "Wisdom";
        readonly serviceAssetKey: "connect";
    };
    readonly "AWS::Wisdom::KnowledgeBase": {
        readonly service: "Wisdom";
        readonly serviceAssetKey: "connect";
    };
    readonly "AWS::WorkSpaces::ConnectionAlias": {
        readonly service: "WorkSpaces";
        readonly serviceAssetKey: "workspaces";
    };
    readonly "AWS::WorkSpaces::Workspace": {
        readonly service: "WorkSpaces";
        readonly serviceAssetKey: "workspaces";
    };
    readonly "AWS::XRay::Group": {
        readonly service: "XRay";
        readonly serviceAssetKey: "x_ray";
    };
    readonly "AWS::XRay::ResourcePolicy": {
        readonly service: "XRay";
        readonly serviceAssetKey: "x_ray";
        readonly generalIconKey: "policy";
        readonly drawioGeneralShape: "addon";
    };
    readonly "AWS::XRay::SamplingRule": {
        readonly service: "XRay";
        readonly serviceAssetKey: "x_ray";
        readonly generalIconKey: "rule";
        readonly drawioGeneralShape: "rule";
    };
    readonly "Alexa::ASK::Skill": {
        readonly service: "ASK";
        readonly serviceAssetKey: "alexa_for_business";
    };
};
/** @internal */
export declare const DrawioShapeToAssetMapping: {
    readonly A1_INSTANCE: "compute/ec2/instance/a1";
    readonly ACCESS_ANALYZER: "security_identity_compliance/iam/iam_access_analyzer";
    readonly ACTION: "internet_of_things/iot_core/action";
    readonly ACTIVATE: "customer_enablement/activate/service_icon";
    readonly ACTUATOR: "internet_of_things/iot_core/actuator";
    readonly ADDON: "security_identity_compliance/iam/add_on";
    readonly AD_CONNECTOR: "security_identity_compliance/directory_service/ad_connector";
    readonly AGENT: "security_identity_compliance/inspector/agent";
    readonly AGENT2: "migration_transfer/datasync/agent";
    readonly ALARM: "management_governance/cloudwatch/alarm";
    readonly ALEXA_ENABLED_DEVICE: false;
    readonly ALEXA_FOR_BUSINESS: "business_applications/alexa_for_business/service_icon";
    readonly ALEXA_SKILL: false;
    readonly ALEXA_SMART_HOME_SKILL: false;
    readonly ALEXA_VOICE_SERVICE: false;
    readonly ALL_PRODUCTS: false;
    readonly AMI: "compute/ec2/ami";
    readonly AMPLIFY: "front_end_web_mobile/amplify/service_icon";
    readonly AMPLIFY_AWS_AMPLIFY_STUDIO: "front_end_web_mobile/amplify/service_icon";
    readonly ANALYTICS: "analytics/category_icon";
    readonly APACHE_MXNET_ON_AWS: "machine_learning/apache_mxnet_on_aws/service_icon";
    readonly API_GATEWAY: "application_integration/api_gateway/service_icon";
    readonly APPFLOW: "application_integration/appflow/service_icon";
    readonly APPLICATION: "compute/elastic_beanstalk/application";
    readonly APPLICATION_AUTO_SCALING: "management_governance/application_auto_scaling/service_icon";
    readonly APPLICATION_COST_PROFILER: "cloud_financial_management/application_cost_profiler/service_icon";
    readonly APPLICATION_DISCOVERY_SERVICE: "migration_transfer/application_discovery_service/service_icon";
    readonly APPLICATION_INTEGRATION: "application_integration/category_icon";
    readonly APPLICATION_LOAD_BALANCER: "networking_content_delivery/elastic_load_balancing/application_load_balancer";
    readonly APPS: "management_governance/opsworks/apps";
    readonly APPSTREAM_20: "end_user_computing/appstream/service_icon";
    readonly APPSYNC: "application_integration/appsync/service_icon";
    readonly APP_CONFIG: "management_governance/appconfig/service_icon";
    readonly APP_MESH: "networking_content_delivery/app_mesh/service_icon";
    readonly APP_RUNNER: "compute/app_runner/service_icon";
    readonly APP_WIZARD: false;
    readonly ARCHIVE: "storage/s3_glacier/archive";
    readonly ARTIFACT: "security_identity_compliance/artifact/service_icon";
    readonly AR_VR: "vr_ar/category_icon";
    readonly ATHENA: "analytics/athena/service_icon";
    readonly ATTRIBUTE: "database/dynamodb/attribute";
    readonly ATTRIBUTES: "database/dynamodb/attributes";
    readonly AUDIT_MANAGER: "security_identity_compliance/audit_manager/service_icon";
    readonly AUGMENTED_AI: false;
    readonly AURORA: "database/aurora/service_icon";
    readonly AURORA_INSTANCE: "database/aurora/service_icon";
    readonly AURORA_INSTANCE_ALT: "database/aurora/service_icon";
    readonly AUTOMATION: "management_governance/ssm/automation";
    readonly AUTOSCALING: "management_governance/auto_scaling/service_icon";
    readonly AUTO_SCALING: "management_governance/auto_scaling/service_icon";
    readonly AUTO_SCALING2: "management_governance/auto_scaling/service_icon";
    readonly AUTO_SCALING3: "management_governance/auto_scaling/service_icon";
    readonly AWS_CLOUD: false;
    readonly BACKINT_AGENT: "management_governance/backint_agent/service_icon";
    readonly BACKUP: "storage/backup/service_icon";
    readonly BACKUP_AWS_BACKUP_SUPPORT_FOR_AMAZON_S3: "storage/backup/service_icon";
    readonly BACKUP_AWS_BACKUP_SUPPORT_FOR_VMWARE_WORKLOADS: "storage/backup/service_icon";
    readonly BACKUP_BACKUP_PLAN: "storage/backup/backup_plan";
    readonly BACKUP_BACKUP_RESTORE: "storage/backup/backup_restore";
    readonly BACKUP_COMPLIANCE_REPORTING: "storage/backup/compliance_reporting";
    readonly BACKUP_COMPUTE: "storage/backup/compute";
    readonly BACKUP_DATABASE: "storage/backup/database";
    readonly BACKUP_GATEWAY: "storage/backup/gateway";
    readonly BACKUP_PLAN: "storage/backup/service_icon";
    readonly BACKUP_RECOVERY_POINT_OBJECTIVE: "storage/backup/recovery_point_objective";
    readonly BACKUP_RECOVERY_TIME_OBJECTIVE: "storage/backup/recovery_time_objective";
    readonly BACKUP_RESTORE: "storage/backup/service_icon";
    readonly BACKUP_STORAGE: "storage/backup/storage";
    readonly BACKUP_VAULT: "storage/backup/service_icon";
    readonly BACKUP_VIRTUAL_MACHINE: "storage/backup/virtual_machine";
    readonly BACKUP_VIRTUAL_MACHINE_MONITOR: "storage/backup/virtual_machine_monitor";
    readonly BANK: "internet_of_things/thing/bank";
    readonly BATCH: "compute/batch/service_icon";
    readonly BLOCKCHAIN: "blockchain/category_icon";
    readonly BLOCKCHAIN_RESOURCE: false;
    readonly BOTTLEROCKET: "compute/bottlerocket/service_icon";
    readonly BRAKET: "quantum_technologies/braket/service_icon";
    readonly BRAKET_CHANDELIER: "quantum_technologies/braket/chandelier";
    readonly BRAKET_CHIP: "quantum_technologies/braket/chip";
    readonly BRAKET_NOISE_SIMULATOR: "quantum_technologies/braket/noise_simulator";
    readonly BRAKET_QPU: "quantum_technologies/braket/qpu";
    readonly BRAKET_SIMULATOR: "quantum_technologies/braket/simulator";
    readonly BRAKET_SIMULATOR_1: "quantum_technologies/braket/simulator_1";
    readonly BRAKET_SIMULATOR_2: "quantum_technologies/braket/simulator_2";
    readonly BRAKET_SIMULATOR_3: "quantum_technologies/braket/simulator_3";
    readonly BRAKET_SIMULATOR_4: "quantum_technologies/braket/simulator_4";
    readonly BRAKET_STATE_VECTOR: "quantum_technologies/braket/state_vector";
    readonly BRAKET_TENSOR_NETWORK: "quantum_technologies/braket/tensor_network";
    readonly BUCKET: "storage/s3/bucket";
    readonly BUCKET_WITH_OBJECTS: "storage/s3/bucket_with_objects";
    readonly BUDGETS: "cloud_financial_management/budgets/service_icon";
    readonly BUDGETS_2: "cloud_financial_management/budgets/service_icon";
    readonly BUSINESS_APPLICATION: "business_applications/category_icon";
    readonly BYCICLE: false;
    readonly C4_INSTANCE: "compute/ec2/instance/c4";
    readonly C5A: "compute/ec2/instance/c5a";
    readonly C5AD: "compute/ec2/instance/c5ad";
    readonly C5D: "compute/ec2/instance/c5d";
    readonly C5N_INSTANCE: "compute/ec2/instance/c5n";
    readonly C5_INSTANCE: "compute/ec2/instance/c5";
    readonly C6GD: "compute/ec2/instance/c6gd";
    readonly C6G_INSTANCE: "compute/ec2/instance/c6g";
    readonly CACHED_VOLUME: "storage/storage_gateway/cached_volume";
    readonly CACHE_NODE: "database/elasticache/cache_node";
    readonly CAMERA: "general/camera";
    readonly CAMERA2: false;
    readonly CAR: "internet_of_things/thing/car";
    readonly CART: "internet_of_things/thing/cart";
    readonly CERTIFICATE_MANAGER: "security_identity_compliance/certificate_manager/service_icon";
    readonly CERTIFICATE_MANAGER_2: "security_identity_compliance/certificate_manager/service_icon";
    readonly CERTIFICATE_MANAGER_3: "security_identity_compliance/certificate_manager/service_icon";
    readonly CHANGE_SET: "management_governance/cloudformation/change_set";
    readonly CHATBOT: "management_governance/chatbot/service_icon";
    readonly CHECKLIST: "management_governance/trusted_advisor/checklist";
    readonly CHECKLIST_COST: "management_governance/trusted_advisor/checklist_cost";
    readonly CHECKLIST_FAULT_TOLERANT: "management_governance/trusted_advisor/checklist_fault_tolerant";
    readonly CHECKLIST_PERFORMANCE: "management_governance/trusted_advisor/checklist_performance";
    readonly CHECKLIST_SECURITY: "management_governance/trusted_advisor/checklist_security";
    readonly CHIME: "business_applications/chime/service_icon";
    readonly CHIME_SDK: "business_applications/chime_sdk/service_icon";
    readonly CLASSIC_LOAD_BALANCER: "networking_content_delivery/elastic_load_balancing/classic_load_balancer";
    readonly CLIENT: "general/client";
    readonly CLIENT_VPN: "networking_content_delivery/client_vpn/service_icon";
    readonly CLOUD9: "developer_tools/cloud9/service_icon";
    readonly CLOUDENDURE_DISASTER_RECOVERY: "storage/cloudendure_disaster_recovery/service_icon";
    readonly CLOUDENDURE_MIGRATION: false;
    readonly CLOUDFORMATION: "management_governance/cloudformation/service_icon";
    readonly CLOUDFRONT: "networking_content_delivery/cloudfront/service_icon";
    readonly CLOUDFRONT_FUNCTIONS: "networking_content_delivery/cloudfront/functions";
    readonly CLOUDHSM: "security_identity_compliance/cloudhsm/service_icon";
    readonly CLOUDSEARCH: "analytics/cloudsearch/service_icon";
    readonly CLOUDSEARCH2: "analytics/cloudsearch/service_icon";
    readonly CLOUDSHELL: "developer_tools/cloudshell/service_icon";
    readonly CLOUDTRAIL: "management_governance/cloudtrail/service_icon";
    readonly CLOUDWATCH: "management_governance/cloudwatch/service_icon";
    readonly CLOUDWATCH_2: "management_governance/cloudwatch/service_icon";
    readonly CLOUDWATCH_EVIDENTLY: "management_governance/cloudwatch/evidently";
    readonly CLOUDWATCH_METRICS_INSIGHTS: "management_governance/cloudwatch/metrics_insights";
    readonly CLOUDWATCH_RUM: "management_governance/cloudwatch/rum";
    readonly CLOUDWATCH_SYNTHETICS: "management_governance/cloudwatch/synthetics";
    readonly CLOUD_CONTROL_API: "developer_tools/cloud_control_api/service_icon";
    readonly CLOUD_DEVELOPMENT_KIT: "developer_tools/cloud_development_kit/service_icon";
    readonly CLOUD_DIGITAL_INTERFACE: false;
    readonly CLOUD_DIRECTORY: "networking_content_delivery/cloud_directory/service_icon";
    readonly CLOUD_EXTENSION_ROS: false;
    readonly CLOUD_MAP: "networking_content_delivery/cloud_map/service";
    readonly CLOUD_MAP_RESOURCE: "networking_content_delivery/cloud_map/resource";
    readonly CLOUD_WAN: "networking_content_delivery/cloud_wan/service_icon";
    readonly CLOUD_WAN_SEGMENT_NETWORK: "networking_content_delivery/cloud_wan/segment_network";
    readonly CLOUD_WAN_VIRTUAL_POP: "networking_content_delivery/cloud_wan/virtual_pop";
    readonly CLUSTER: "analytics/emr/cluster";
    readonly CODEARTIFACT: "developer_tools/codeartifact/service_icon";
    readonly CODEBUILD: "developer_tools/codebuild/service_icon";
    readonly CODECOMMIT: "developer_tools/codecommit/service_icon";
    readonly CODEDEPLOY: "developer_tools/codedeploy/service_icon";
    readonly CODEGURU: "machine_learning/codeguru/service_icon";
    readonly CODEGURU_2: "machine_learning/codeguru/service_icon";
    readonly CODEPIPELINE: "developer_tools/codepipeline/service_icon";
    readonly CODESTAR: "developer_tools/codestar/service_icon";
    readonly COFFEE_POT: "internet_of_things/thing/coffee_pot";
    readonly COGNITO: "security_identity_compliance/cognito/service_icon";
    readonly COMMAND_LINE_INTERFACE: "developer_tools/command_line_interface/service_icon";
    readonly COMPREHEND: "machine_learning/comprehend/service_icon";
    readonly COMPREHEND_MEDICAL: "machine_learning/comprehend_medical/service_icon";
    readonly COMPUTE: "compute/category_icon";
    readonly COMPUTE_OPTIMIZER: "compute/compute_optimizer/service_icon";
    readonly CONFIG: "management_governance/config/service_icon";
    readonly CONNECT: "internet_of_things/iot_greengrass/connector";
    readonly CONNECTOR: "business_applications/connect/service_icon";
    readonly CONTAINERS: "containers/category_icon";
    readonly CONTAINER_1: "containers/ecs/container_1";
    readonly CONTAINER_2: "containers/ecs/container_2";
    readonly CONTAINER_3: "containers/ecs/container_3";
    readonly CONTAINER_REGISTRY_IMAGE: "containers/ecr/image";
    readonly CONTROL_TOWER: "management_governance/control_tower/service_icon";
    readonly CORPORATE_DATA_CENTER: false;
    readonly CORPORATE_DATA_CENTER2: false;
    readonly CORRETTO: "developer_tools/corretto/service_icon";
    readonly COST_AND_USAGE_REPORT: "cloud_financial_management/cost_and_usage_report/service_icon";
    readonly COST_EXPLORER: "cloud_financial_management/cost_explorer/service_icon";
    readonly COST_MANAGEMENT: "cloud_financial_management/category_icon";
    readonly CUSTOMER_ENABLEMENT: "customer_enablement/category_icon";
    readonly CUSTOMER_ENGAGEMENT: "customer_enablement/category_icon";
    readonly CUSTOMER_GATEWAY: "networking_content_delivery/vpc/customer_gateway";
    readonly CUSTOM_BILLING_MANAGER: false;
    readonly CUSTOM_EVENT_BUS_RESOURCE: "application_integration/eventbridge/custom_event_bus";
    readonly D2_INSTANCE: "compute/ec2/instance/d2";
    readonly D3EN_INSTANCE: "compute/ec2/instance/d3en";
    readonly D3_INSTANCE: "compute/ec2/instance/d3";
    readonly DATABASE: "database/category_icon";
    readonly DATABASE_MIGRATION_SERVICE: "database/database_migration_service/service_icon";
    readonly DATABASE_MIGRATION_WORKFLOW_JOB: "database/database_migration_service/database_migration_workflow_job";
    readonly DATASYNC: "migration_transfer/datasync/service_icon";
    readonly DATA_ENCRYPTION_KEY: "security_identity_compliance/iam/data_encryption_key";
    readonly DATA_EXCHANGE: "analytics/data_exchange/service_icon";
    readonly DATA_EXCHANGE_FOR_APIS: "analytics/data_exchange/service_icon";
    readonly DATA_LAKE_RESOURCE_ICON: false;
    readonly DATA_PIPELINE: "analytics/data_pipeline/service_icon";
    readonly DATA_SET: "internet_of_things/iot_analytics/dataset";
    readonly DB_INSTANCE: "compute/ec2/instance/db";
    readonly DB_INSTANCE_READ_REPLICA: false;
    readonly DB_INSTANCE_STANDBY: false;
    readonly DB_ON_INSTANCE: false;
    readonly DB_ON_INSTANCE2: false;
    readonly DEEPCOMPOSER: "machine_learning/deepcomposer/service_icon";
    readonly DEEPLENS: "machine_learning/deeplens/service_icon";
    readonly DEEPRACER: "machine_learning/deepracer/service_icon";
    readonly DEEP_LEARNING_AMIS: "machine_learning/deep_learning_amis/service_icon";
    readonly DEEP_LEARNING_CONTAINERS: "machine_learning/deep_learning_containers/service_icon";
    readonly DEFAULT_EVENT_BUS_RESOURCE: "application_integration/eventbridge/default_event_bus";
    readonly DENSE_COMPUTE_NODE: "analytics/redshift/dense_compute_node";
    readonly DENSE_STORAGE_NODE: "analytics/redshift/dense_storage_node";
    readonly DEPLOYMENT: "compute/elastic_beanstalk/deployment";
    readonly DEPLOYMENTS: "management_governance/opsworks/deployments";
    readonly DESIRED_STATE: "internet_of_things/iot_core/desired_state";
    readonly DESKTOP_AND_APP_STREAMING: "end_user_computing/category_icon";
    readonly DETECTIVE: "security_identity_compliance/detective/service_icon";
    readonly DEVELOPER_TOOLS: "developer_tools/category_icon";
    readonly DEVELOPMENT_ENVIRONMENT: "robotics/robomaker/development_environment";
    readonly DEVICE_FARM: "front_end_web_mobile/device_farm/service_icon";
    readonly DEVOPS_GURU: "machine_learning/devops_guru/service_icon";
    readonly DEVOPS_GURU_INSIGHTS: "machine_learning/devops_guru/insights";
    readonly DIRECTORY_SERVICE: "security_identity_compliance/directory_service/service_icon";
    readonly DIRECT_CONNECT: "networking_content_delivery/direct_connect/service_icon";
    readonly DISK: "general/disk";
    readonly DISTRO_FOR_OPENTELEMETRY: "management_governance/distro_for_opentelemetry/service_icon";
    readonly DOCUMENTDB_WITH_MONGODB_COMPATIBILITY: "database/documentdb/service_icon";
    readonly DOCUMENTS: "general/documents";
    readonly DOCUMENTS2: false;
    readonly DOOR_LOCK: "internet_of_things/thing/door_lock";
    readonly DOWNLOAD_DISTRIBUTION: "networking_content_delivery/cloudfront/download_distribution";
    readonly DYNAMODB: "database/dynamodb/service_icon";
    readonly DYNAMODB_DAX: "database/dynamodb/service_icon";
    readonly DYNAMODB_STANDARD_ACCESS_TABLE_CLASS: "database/dynamodb/standard_access_table_class";
    readonly DYNAMODB_STANDARD_INFREQUENT_ACCESS_TABLE_CLASS: "database/dynamodb/standard_infrequent_access_table_class";
    readonly DYNAMODB_STREAM: "database/dynamodb/stream";
    readonly EC2: "compute/ec2/service_icon";
    readonly EC2_AWS_MICROSERVICE_EXTRACTOR_FOR_NET: "compute/ec2/service_icon";
    readonly EC2_C6A_INSTANCE: "compute/ec2/instance/c6a";
    readonly EC2_C6GN_INSTANCE: "compute/ec2/instance/c6gn";
    readonly EC2_C6I_INSTANCE: "compute/ec2/instance/c6i";
    readonly EC2_C7G_INSTANCE: "compute/ec2/instance/c7g";
    readonly EC2_DL1_INSTANCE: "compute/ec2/instance/dl1";
    readonly EC2_G5G_INSTANCE: "compute/ec2/instance/g5g";
    readonly EC2_G5_INSTANCE: "compute/ec2/instance/g5";
    readonly EC2_HPC6A_INSTANCE: "compute/ec2/instance/hpc6a";
    readonly EC2_I4I_INSTANCE: "compute/ec2/instance/i4i";
    readonly EC2_IM4GN_INSTANCE: "compute/ec2/instance/im4gn";
    readonly EC2_IMAGE_BUILDER: "compute/ec2_image_builder/service_icon";
    readonly EC2_INSTANCE_CONTENTS: "compute/ec2/service_icon";
    readonly EC2_IS4GEN_INSTANCE: "compute/ec2/instance/is4gen";
    readonly EC2_M1_MAC_INSTANCE: "compute/ec2/instance/m1_mac";
    readonly EC2_M6A_INSTANCE: "compute/ec2/instance/m6a";
    readonly EC2_M6I_INSTANCE: "compute/ec2/instance/m6i";
    readonly EC2_R6I_INSTANCE: "compute/ec2/instance/r6i";
    readonly EC2_TRN1_INSTANCE: "compute/ec2/instance/trn1";
    readonly EC2_VT1_INSTANCE: "compute/ec2/instance/vt1";
    readonly EC2_X2GD_INSTANCE: "compute/ec2/instance/x2gd";
    readonly EC2_X2IDN_INSTANCE: "compute/ec2/instance/x2idn";
    readonly EC2_X2IEDN_INSTANCE: "compute/ec2/instance/x2iedn";
    readonly EC2_X2IEZN_INSTANCE: "compute/ec2/instance/x2iezn";
    readonly ECHO: "internet_of_things/iot_core/echo";
    readonly ECR: "containers/ecr/service_icon";
    readonly ECS: "containers/ecs/service";
    readonly ECS_ANYWHERE: "containers/ecs_anywhere/service_icon";
    readonly ECS_COPILOT_CLI: "containers/ecs/copilot_cli";
    readonly ECS_SERVICE: "containers/ecs/service";
    readonly ECS_TASK: "containers/ecs/task";
    readonly EDGE_LOCATION: "networking_content_delivery/cloudfront/edge_location";
    readonly EFS_INFREQUENTACCESS: "storage/efs/service_icon";
    readonly EFS_STANDARD: "storage/efs/standard";
    readonly EKS: "containers/eks/service_icon";
    readonly EKS_ANYWHERE: "containers/eks_anywhere/service_icon";
    readonly EKS_CLOUD: "containers/eks_cloud/service_icon";
    readonly EKS_DISTRO: "containers/eks_distro/service_icon";
    readonly ELASTICACHE: "database/elasticache/service_icon";
    readonly ELASTICACHE_FOR_MEMCACHED: "database/elasticache/service_icon";
    readonly ELASTICACHE_FOR_REDIS: "database/elasticache/service_icon";
    readonly ELASTICSEARCH_SERVICE: "analytics/opensearch/service_icon";
    readonly ELASTIC_BEANSTALK: "compute/elastic_beanstalk/service_icon";
    readonly ELASTIC_BLOCK_STORE: "storage/ebs/service_icon";
    readonly ELASTIC_BLOCK_STORE_AMAZON_DATA_LIFECYCLE_MANAGER: "storage/ebs/data_lifecycle_manager";
    readonly ELASTIC_BLOCK_STORE_VOLUME_GP3: "storage/ebs/volume_gp3";
    readonly ELASTIC_FABRIC_ADAPTER: "compute/elastic_fabric_adapter/service_icon";
    readonly ELASTIC_FILE_SYSTEM: "storage/efs/service_icon";
    readonly ELASTIC_FILE_SYSTEM_INFREQUENT_ACCESS: "storage/efs/standard_infrequent_access";
    readonly ELASTIC_FILE_SYSTEM_INTELLIGENT_TIERING: "storage/efs/intelligent_tiering";
    readonly ELASTIC_FILE_SYSTEM_ONE_ZONE: "storage/efs/one_zone";
    readonly ELASTIC_FILE_SYSTEM_ONE_ZONE_INFREQUENT_ACCESS: "storage/efs/one_zone_infrequent_access";
    readonly ELASTIC_FILE_SYSTEM_ONE_ZONE_STANDARD: "storage/efs/standard";
    readonly ELASTIC_FILE_SYSTEM_STANDARD: "storage/efs/standard";
    readonly ELASTIC_FILE_SYSTEM_STANDARD_INFREQUENT_ACCESS: "storage/efs/standard_infrequent_access";
    readonly ELASTIC_INFERENCE: "machine_learning/elastic_inference/service_icon";
    readonly ELASTIC_INFERENCE_2: "machine_learning/elastic_inference/service_icon";
    readonly ELASTIC_IP_ADDRESS: "compute/ec2/elastic_ip_address";
    readonly ELASTIC_LOAD_BALANCING: "networking_content_delivery/elastic_load_balancing/service_icon";
    readonly ELASTIC_NETWORK_ADAPTER: "networking_content_delivery/vpc/elastic_network_adapter";
    readonly ELASTIC_NETWORK_INTERFACE: "networking_content_delivery/vpc/elastic_network_interface";
    readonly ELASTIC_TRANSCODER: "media_services/elastic_transcoder/service_icon";
    readonly ELEMENTAL: false;
    readonly ELEMENTAL_LINK: "media_services/elemental_link/service_icon";
    readonly ELEMENTAL_MEDIACONNECT: "media_services/elemental_mediaconnect/service_icon";
    readonly ELEMENTAL_MEDIACONVERT: "media_services/elemental_mediaconvert/service_icon";
    readonly ELEMENTAL_MEDIALIVE: "media_services/elemental_medialive/service_icon";
    readonly ELEMENTAL_MEDIAPACKAGE: "media_services/elemental_mediapackage/service_icon";
    readonly ELEMENTAL_MEDIASTORE: "media_services/elemental_mediastore/service_icon";
    readonly ELEMENTAL_MEDIATAILOR: "media_services/elemental_mediatailor/service_icon";
    readonly EMAIL: "general/email";
    readonly EMAIL_2: false;
    readonly EMAIL_NOTIFICATION: "application_integration/sns/email_notification";
    readonly EMR: "analytics/emr/service_icon";
    readonly EMR_ENGINE: "analytics/emr/service_icon";
    readonly EMR_ENGINE_MAPR_M3: "analytics/emr/service_icon";
    readonly EMR_ENGINE_MAPR_M5: "analytics/emr/service_icon";
    readonly EMR_ENGINE_MAPR_M7: "analytics/emr/service_icon";
    readonly ENCRYPTED_DATA: "security_identity_compliance/iam/encrypted_data";
    readonly ENDPOINT: "security_identity_compliance/network_firewall/endpoints";
    readonly ENDPOINTS: "networking_content_delivery/vpc/endpoints";
    readonly EVENT: "management_governance/cloudwatch/event_event_based";
    readonly EVENTBRIDGE: "application_integration/eventbridge/service_icon";
    readonly EVENTBRIDGE_CUSTOM_EVENT_BUS_RESOURCE: "application_integration/eventbridge/service_icon";
    readonly EVENTBRIDGE_DEFAULT_EVENT_BUS_RESOURCE: "application_integration/eventbridge/service_icon";
    readonly EVENTBRIDGE_SAAS_PARTNER_EVENT_BUS_RESOURCE: "application_integration/eventbridge/service_icon";
    readonly EVENTBRIDGE_SCHEMA: "application_integration/eventbridge/schema";
    readonly EVENTBRIDGE_SCHEMA_REGISTRY: "application_integration/eventbridge/schema_registry";
    readonly EVENT_EVENT_BASED: "management_governance/cloudwatch/event_event_based";
    readonly EVENT_RESOURCE: false;
    readonly EVENT_TIME_BASED: "management_governance/cloudwatch/event_time_based";
    readonly EXPRESS_WORKFLOW: "application_integration/express_workflows/service_icon";
    readonly EXTERNAL_SDK: "general/sdk";
    readonly EXTERNAL_TOOLKIT: "general/toolkit";
    readonly F1_INSTANCE: "compute/ec2/instance/f1";
    readonly FACTORY: "internet_of_things/thing/factory";
    readonly FARGATE: "containers/fargate/service_icon";
    readonly FAULT_INJECTION_SIMULATOR: "management_governance/fault_injection_simulator/service_icon";
    readonly FILE_GATEWAY: "storage/storage_gateway/file_gateway";
    readonly FILE_SYSTEM: "storage/efs/file_system";
    readonly FILTERING_RULE: "security_identity_compliance/waf/filtering_rule";
    readonly FINDING: "security_identity_compliance/security_hub/finding";
    readonly FINSPACE: "analytics/finspace/service_icon";
    readonly FIRETV: false;
    readonly FIRETV_STICK: false;
    readonly FIREWALL_MANAGER: "security_identity_compliance/firewall_manager/service_icon";
    readonly FLEET_MANAGEMENT: "robotics/robomaker/fleet_management";
    readonly FLOW_LOGS: "networking_content_delivery/vpc/flow_logs";
    readonly FORECAST: "machine_learning/forecast/service_icon";
    readonly FORUMS: "general/forums";
    readonly FRAUD_DETECTOR: "machine_learning/fraud_detector/service_icon";
    readonly FREERTOS: "internet_of_things/freertos/service_icon";
    readonly FSX: "storage/fsx/service_icon";
    readonly FSX_FILE_GATEWAY: "storage/fsx/service_icon";
    readonly FSX_FOR_LUSTRE: "storage/fsx_for_lustre/service_icon";
    readonly FSX_FOR_NETAPP_ONTAP: "storage/fsx_for_netapp_ontap/service_icon";
    readonly FSX_FOR_OPENZFS: "storage/fsx_for_openzfs/service_icon";
    readonly FSX_FOR_WINDOWS_FILE_SERVER: "storage/fsx/service_icon";
    readonly G3_INSTANCE: "compute/ec2/instance/g3";
    readonly G4AD_INSTANCE: "compute/ec2/instance/g4ad";
    readonly G4DN: "compute/ec2/instance/g4dn";
    readonly GAMEKIT: "game_tech/gamekit/service_icon";
    readonly GAMELIFT: "game_tech/gamelift/service_icon";
    readonly GAMESPARKS: "game_tech/gamesparks/service_icon";
    readonly GAME_TECH: "game_tech/category_icon";
    readonly GAME_TECH2: false;
    readonly GATEWAY: "networking_content_delivery/direct_connect/gateway";
    readonly GATEWAY_LOAD_BALANCER: "networking_content_delivery/elastic_load_balancing/gateway_load_balancer";
    readonly GEAR: "general/gear";
    readonly GENERAL_ACCESS_POINTS: "storage/s3/general_access_points";
    readonly GENERIC: "internet_of_things/thing/generic";
    readonly GENERIC_DATABASE: false;
    readonly GENERIC_FIREWALL: "general/firewall";
    readonly GENOMICS_CLI: "compute/genomics_cli/service_icon";
    readonly GLACIER: "storage/s3_glacier/service_icon";
    readonly GLACIER_DEEP_ARCHIVE: "storage/s3_glacier/deep_archive";
    readonly GLOBAL_ACCELERATOR: "networking_content_delivery/global_accelerator/service_icon";
    readonly GLOBAL_SECONDARY_INDEX: "database/dynamodb/global_secondary_index";
    readonly GLUE: "analytics/glue/service_icon";
    readonly GLUE_CRAWLERS: "analytics/glue/service_icon";
    readonly GLUE_DATABREW: "analytics/glue_databrew/service_icon";
    readonly GLUE_DATA_CATALOG: "analytics/glue/data_catalog";
    readonly GLUE_ELASTIC_VIEWS: "analytics/glue_elastic_views/service_icon";
    readonly GREENGRASS: "internet_of_things/iot_greengrass/service_icon";
    readonly GROUND_STATION: "satellite/ground_station/service_icon";
    readonly GROUP_ACCOUNT: "groups/account";
    readonly GROUP_AUTO_SCALING_GROUP: "groups/auto_scaling_group";
    readonly GROUP_AVAILABILITY_ZONE: false;
    readonly GROUP_AWS_CLOUD: "groups/aws_cloud";
    readonly GROUP_AWS_CLOUD_ALT: "groups/aws_cloud_alt";
    readonly GROUP_AWS_STEP_FUNCTIONS_WORKFLOW: "groups/aws_step_functions_workflow";
    readonly GROUP_CORPORATE_DATA_CENTER: "groups/corporate_data_center";
    readonly GROUP_EC2_INSTANCE_CONTENTS: "groups/ec2_instance_contents";
    readonly GROUP_ELASTIC_BEANSTALK: "groups/elastic_beanstalk";
    readonly GROUP_ELASTIC_LOAD_BALANCING: false;
    readonly GROUP_IOT_GREENGRASS: "groups/iot_greengrass";
    readonly GROUP_IOT_GREENGRASS_DEPLOYMENT: "groups/iot_greengrass_deployment";
    readonly GROUP_ON_PREMISE: "groups/on_premise";
    readonly GROUP_REGION: "groups/region";
    readonly GROUP_SECURITY_GROUP: false;
    readonly GROUP_SPOT_FLEET: "groups/spot_fleet";
    readonly GROUP_SUBNET: false;
    readonly GROUP_VPC: "groups/vpc";
    readonly GUARDDUTY: "security_identity_compliance/guardduty/service_icon";
    readonly H1_INSTANCE: "compute/ec2/instance/h1";
    readonly HABANA_GAUDI: "compute/ec2/instance/habana_gaudi";
    readonly HARDWARE_BOARD: false;
    readonly HDFS_CLUSTER: "analytics/emr/hdfs_cluster";
    readonly HEALTHLAKE: "machine_learning/healthlake/service_icon";
    readonly HIGH_MEMORY_INSTANCE: false;
    readonly HONEYCODE: "business_applications/honeycode/service_icon";
    readonly HOSTED_ZONE: "networking_content_delivery/route_53/hosted_zone";
    readonly HOUSE: "internet_of_things/thing/house";
    readonly HTTP2_PROTOCOL: "internet_of_things/iot_core/http2_protocol";
    readonly HTTP_NOTIFICATION: "application_integration/sns/http_notification";
    readonly HTTP_PROTOCOL: "internet_of_things/iot_http/protocol";
    readonly I2: "compute/ec2/instance/i2";
    readonly I3EN: "compute/ec2/instance/i3en";
    readonly I3_INSTANCE: "compute/ec2/instance/i3";
    readonly IDENTITY_AND_ACCESS_MANAGEMENT: "security_identity_compliance/iam/service_icon";
    readonly ILLUSTRATION_DESKTOP: false;
    readonly ILLUSTRATION_DEVICES: false;
    readonly ILLUSTRATION_NOTIFICATION: false;
    readonly IMPORT_EXPORT: "storage/snowball/snowball_import_export";
    readonly INF1: "compute/ec2/instance/inf1";
    readonly INFERENTIA: "compute/ec2/inferentia";
    readonly INFREQUENT_ACCESS_STORAGE_CLASS: "storage/s3/s3_standard_ia";
    readonly INSPECTOR: "security_identity_compliance/inspector/service_icon";
    readonly INSTANCE: "compute/ec2/instance";
    readonly INSTANCE2: false;
    readonly INSTANCES: "compute/ec2/instances";
    readonly INSTANCES_2: false;
    readonly INSTANCE_WITH_CLOUDWATCH: "compute/ec2/instance_with_cloudwatch";
    readonly INSTANCE_WITH_CLOUDWATCH2: false;
    readonly INTELLIGENT_TIERING: "storage/s3/s3_intelligent_tiering";
    readonly INTERACTIVE_VIDEO: "general/multimedia";
    readonly INTERNET: "general/internet";
    readonly INTERNET_ALT1: "general/internet_alt1";
    readonly INTERNET_ALT2: "general/internet_alt2";
    readonly INTERNET_ALT22: false;
    readonly INTERNET_GATEWAY: "networking_content_delivery/vpc/internet_gateway";
    readonly INTERNET_OF_THINGS: "internet_of_things/category_icon";
    readonly INVENTORY: "management_governance/ssm/inventory";
    readonly IOT_1CLICK: "internet_of_things/iot_1_click/service_icon";
    readonly IOT_ANALYTICS: "internet_of_things/iot_analytics/service_icon";
    readonly IOT_ANALYTICS_CHANNEL: "internet_of_things/iot_analytics/channel";
    readonly IOT_ANALYTICS_DATA_STORE: "internet_of_things/iot_analytics/data_store";
    readonly IOT_ANALYTICS_PIPELINE: "internet_of_things/iot_analytics/pipeline";
    readonly IOT_BUTTON: "internet_of_things/iot_button/service_icon";
    readonly IOT_CORE: "internet_of_things/iot_core/service_icon";
    readonly IOT_DEVICE_DEFENDER: "internet_of_things/iot_device_defender/service_icon";
    readonly IOT_DEVICE_DEFENDER_IOT_DEVICE_JOBS: "internet_of_things/iot_device_defender/iot_device_jobs";
    readonly IOT_DEVICE_GATEWAY: "internet_of_things/iot_core/device_gateway";
    readonly IOT_DEVICE_JOBS_RESOURCE: "internet_of_things/iot_device_defender/iot_device_jobs";
    readonly IOT_DEVICE_MANAGEMENT: "internet_of_things/iot_device_management/service_icon";
    readonly IOT_EVENTS: "internet_of_things/iot_events/service_icon";
    readonly IOT_EXPRESSLINK: "internet_of_things/iot_expresslink/service_icon";
    readonly IOT_FLEETWISE: "internet_of_things/iot_fleetwise/service_icon";
    readonly IOT_GREENGRASS_ARTIFACT: "internet_of_things/iot_greengrass/artifact";
    readonly IOT_GREENGRASS_COMPONENT: "internet_of_things/iot_greengrass/component";
    readonly IOT_GREENGRASS_COMPONENT_MACHINE_LEARNING: "internet_of_things/iot_greengrass/component_machine_learning";
    readonly IOT_GREENGRASS_COMPONENT_NUCLEUS: "internet_of_things/iot_greengrass/component_nucleus";
    readonly IOT_GREENGRASS_COMPONENT_PRIVATE: "internet_of_things/iot_greengrass/component_private";
    readonly IOT_GREENGRASS_COMPONENT_PUBLIC: "internet_of_things/iot_greengrass/component_public";
    readonly IOT_GREENGRASS_INTERPROCESS_COMMUNICATION: "internet_of_things/iot_greengrass/interprocess_communication";
    readonly IOT_GREENGRASS_PROTOCOL: "internet_of_things/iot_greengrass/protocol";
    readonly IOT_GREENGRASS_RECIPE: "internet_of_things/iot_greengrass/recipe";
    readonly IOT_GREENGRASS_STREAM_MANAGER: "internet_of_things/iot_greengrass/stream_manager";
    readonly IOT_LORAWAN_PROTOCOL: "internet_of_things/iot_core/lorawan_protocol";
    readonly IOT_OVER_THE_AIR_UPDATE: "internet_of_things/iot_core/over_air_update";
    readonly IOT_ROBORUNNER: "internet_of_things/iot_roborunner/service_icon";
    readonly IOT_SAILBOAT: "internet_of_things/iot_core/sailboat";
    readonly IOT_SITEWISE: "internet_of_things/iot_sitewise/service_icon";
    readonly IOT_SITEWISE_ASSET: "internet_of_things/iot_sitewise/asset";
    readonly IOT_SITEWISE_ASSET_HIERARCHY: "internet_of_things/iot_sitewise/asset_hierarchy";
    readonly IOT_SITEWISE_ASSET_MODEL: "internet_of_things/iot_sitewise/asset_model";
    readonly IOT_SITEWISE_ASSET_PROPERTIES: "internet_of_things/iot_sitewise/asset_properties";
    readonly IOT_SITEWISE_DATA_STREAMS: "internet_of_things/iot_sitewise/data_streams";
    readonly IOT_THINGS_GRAPH: "internet_of_things/iot_things_graph/service_icon";
    readonly IOT_THING_FREERTOS_DEVICE: false;
    readonly IOT_THING_HUMIDITY_SENSOR: false;
    readonly IOT_THING_INDUSTRIAL_PC: false;
    readonly IOT_THING_PLC: false;
    readonly IOT_THING_RELAY: false;
    readonly IOT_THING_STACKLIGHT: false;
    readonly IOT_THING_TEMPERATURE_HUMIDITY_SENSOR: false;
    readonly IOT_THING_TEMPERATURE_SENSOR: false;
    readonly IOT_THING_TEMPERATURE_VIBRATION_SENSOR: false;
    readonly IOT_THING_VIBRATION_SENSOR: false;
    readonly IOT_TWINMAKER: "internet_of_things/iot_twinmaker/service_icon";
    readonly IQ: "customer_enablement/iq/service_icon";
    readonly ITEM: "database/dynamodb/item";
    readonly ITEMS: "database/dynamodb/items";
    readonly KENDRA: "machine_learning/kendra/service_icon";
    readonly KEYSPACES: "database/keyspaces/service_icon";
    readonly KEY_MANAGEMENT_SERVICE: "security_identity_compliance/key_management_service/service_icon";
    readonly KINESIS: "analytics/kinesis/service_icon";
    readonly KINESIS_DATA_ANALYTICS: "analytics/kinesis_data_analytics/service_icon";
    readonly KINESIS_DATA_FIREHOSE: "analytics/kinesis/service_icon";
    readonly KINESIS_DATA_STREAMS: "analytics/kinesis_data_streams/service_icon";
    readonly KINESIS_VIDEO_STREAMS: "analytics/kinesis_video_streams/service_icon";
    readonly LAKE_FORMATION: "analytics/lake_formation/service_icon";
    readonly LAMBDA: "compute/lambda/service_icon";
    readonly LAMBDA_FUNCTION: "compute/lambda/service_icon";
    readonly LAYERS: "management_governance/opsworks/layers";
    readonly LEX: "machine_learning/lex/service_icon";
    readonly LICENSE_MANAGER: "management_governance/license_manager/service_icon";
    readonly LICENSE_MANAGER_APPLICATION_DISCOVERY: "management_governance/license_manager/application_discovery";
    readonly LICENSE_MANAGER_LICENSE_BLENDING: "management_governance/license_manager/license_blending";
    readonly LIGHTBULB: "internet_of_things/thing/lightbulb";
    readonly LIGHTSAIL: "compute/lightsail/service_icon";
    readonly LOCAL_ZONES: "compute/local_zones/service_icon";
    readonly LOCATION_SERVICE: "front_end_web_mobile/location_service/service_icon";
    readonly LOCATION_SERVICE_GEOFENCE: "front_end_web_mobile/location_service/geofence";
    readonly LOCATION_SERVICE_MAP: "front_end_web_mobile/location_service/map";
    readonly LOCATION_SERVICE_PLACE: "front_end_web_mobile/location_service/place";
    readonly LOCATION_SERVICE_ROUTES: "front_end_web_mobile/location_service/routes";
    readonly LOCATION_SERVICE_TRACK: "front_end_web_mobile/location_service/track";
    readonly LOGS: "management_governance/cloudwatch/logs";
    readonly LONG_TERM_SECURITY_CREDENTIAL: "security_identity_compliance/iam/long_term_security_credential";
    readonly LOOKOUT_FOR_EQUIPMENT: "machine_learning/lookout_for_equipment/service_icon";
    readonly LOOKOUT_FOR_METRICS: "machine_learning/lookout_for_metrics/service_icon";
    readonly LOOKOUT_FOR_VISION: "machine_learning/lookout_for_vision/service_icon";
    readonly LUMBERYARD: "game_tech/lumberyard/service_icon";
    readonly M4_INSTANCE: "compute/ec2/instance/m4";
    readonly M5A_INSTANCE: "compute/ec2/instance/m5a";
    readonly M5DN_INSTANCE: "compute/ec2/instance/m5dn";
    readonly M5D_INSTANCE: "compute/ec2/instance/m5d";
    readonly M5N: "compute/ec2/instance/m5n";
    readonly M5N_INSTANCE: "compute/ec2/instance/m5n";
    readonly M5ZN_INSTANCE: "compute/ec2/instance/m5zn";
    readonly M5_INSTANCE: "compute/ec2/instance/m5";
    readonly M6GD_INSTANCE: "compute/ec2/instance/m6gd";
    readonly M6G_INSTANCE: "compute/ec2/instance/m6g";
    readonly MACHINE_LEARNING: "machine_learning/category_icon";
    readonly MACIE: "security_identity_compliance/macie/service_icon";
    readonly MAC_INSTANCE: "compute/ec2/instance/mac";
    readonly MAINFRAME_MODERNIZATION: "migration_transfer/mainframe_modernization/service_icon";
    readonly MAINFRAME_MODERNIZATION_ANALYZER: "migration_transfer/mainframe_modernization/analyzer";
    readonly MAINFRAME_MODERNIZATION_COMPILER: "migration_transfer/mainframe_modernization/compiler";
    readonly MAINFRAME_MODERNIZATION_CONVERTER: "migration_transfer/mainframe_modernization/converter";
    readonly MAINFRAME_MODERNIZATION_DEVELOPER: "migration_transfer/mainframe_modernization/developer";
    readonly MAINFRAME_MODERNIZATION_RUNTIME: "migration_transfer/mainframe_modernization/runtime";
    readonly MAINTENANCE_WINDOWS: "management_governance/ssm/maintenance_windows";
    readonly MANAGED_APACHE_CASSANDRA_SERVICE: "database/keyspaces/service_icon";
    readonly MANAGED_BLOCKCHAIN: "blockchain/managed_blockchain/service_icon";
    readonly MANAGED_MS_AD: "security_identity_compliance/directory_service/managed_microsoft_ad";
    readonly MANAGED_SERVICES: "customer_enablement/managed_services/service_icon";
    readonly MANAGED_SERVICE_FOR_GRAFANA: "management_governance/managed_grafana/service_icon";
    readonly MANAGED_SERVICE_FOR_PROMETHEUS: "management_governance/aps/service_icon";
    readonly MANAGED_STREAMING_FOR_KAFKA: "analytics/msk/service_icon";
    readonly MANAGED_WORKFLOWS_FOR_APACHE_AIRFLOW: "application_integration/mwaa/service_icon";
    readonly MANAGEMENT_AND_GOVERNANCE: "management_governance/category_icon";
    readonly MANAGEMENT_CONSOLE: "management_governance/management_console/service_icon";
    readonly MARKETPLACE: "general/marketplace";
    readonly MEDIA_SERVICES: "media_services/category_icon";
    readonly MEDICAL_EMERGENCY: "internet_of_things/thing/medical_emergency";
    readonly MEMORYDB_FOR_REDIS: "database/memorydb_for_redis/service_icon";
    readonly MESH: "networking_content_delivery/app_mesh/mesh";
    readonly MESSAGE: "application_integration/sqs/message";
    readonly MFA_TOKEN: "security_identity_compliance/iam/mfa_token";
    readonly MIGRATION_AND_TRANSFER: "migration_transfer/category_icon";
    readonly MIGRATION_EVALUATOR: "migration_transfer/migration_evaluator/service_icon";
    readonly MIGRATION_HUB: "migration_transfer/migration_hub/service_icon";
    readonly MIGRATION_HUB_REFACTOR_SPACES_APPLICATIONS: "migration_transfer/migration_hub/refactor_spaces_applications";
    readonly MIGRATION_HUB_REFACTOR_SPACES_ENVIRONMENTS: "migration_transfer/migration_hub/refactor_spaces_environments";
    readonly MIGRATION_HUB_REFACTOR_SPACES_SERVICES: "migration_transfer/migration_hub/refactor_spaces_services";
    readonly MOBILE: "front_end_web_mobile/category_icon";
    readonly MOBILE_APPLICATION: false;
    readonly MOBILE_CLIENT: "general/mobile_client";
    readonly MOBILE_HUB: "application_integration/console_mobile_application/service_icon";
    readonly MONITORING: "management_governance/opsworks/monitoring";
    readonly MONITRON: "machine_learning/monitron/service_icon";
    readonly MQ: "application_integration/mq/service_icon";
    readonly MQTT_PROTOCOL: "application_integration/mq/service_icon";
    readonly MQ_BROKER: "application_integration/mq/broker";
    readonly MSK_AMAZON_MSK_CONNECT: "analytics/msk/service_icon";
    readonly MS_SQL_INSTANCE: false;
    readonly MS_SQL_INSTANCE_ALTERNATE: false;
    readonly MULTIMEDIA: "general/multimedia";
    readonly MULTIPLE_VOLUMES_RESOURCE: "storage/ebs/multiple_volumes";
    readonly MYSQL_DB_INSTANCE: false;
    readonly MYSQL_DB_INSTANCE_ALTERNATE: false;
    readonly NAMESPACE: "networking_content_delivery/cloud_map/namespace";
    readonly NAT_GATEWAY: "networking_content_delivery/vpc/nat_gateway";
    readonly NEPTUNE: "database/neptune/service_icon";
    readonly NETWORKING_AND_CONTENT_DELIVERY: "networking_content_delivery/category_icon";
    readonly NETWORK_ACCESS_CONTROL_LIST: "networking_content_delivery/vpc/network_access_control_list";
    readonly NETWORK_FIREWALL: "security_identity_compliance/network_firewall/service_icon";
    readonly NETWORK_FIREWALL_ENDPOINTS: "security_identity_compliance/network_firewall/endpoints";
    readonly NETWORK_LOAD_BALANCER: "networking_content_delivery/elastic_load_balancing/network_load_balancer";
    readonly NEURON_ML_SDK: "machine_learning/neuron/service_icon";
    readonly NICE_DCV: "compute/nice_dcv/service_icon";
    readonly NICE_ENGINFRAME: "compute/nice_enginframe/service_icon";
    readonly NIMBLE_STUDIO: "media_services/nimble_studio/service_icon";
    readonly NITRO_ENCLAVES: "compute/nitro_enclaves/service_icon";
    readonly NON_CACHED_VOLUME: "storage/storage_gateway/noncached_volume";
    readonly NOTEBOOK: "machine_learning/sagemaker/notebook";
    readonly OBJECT: "storage/s3/object";
    readonly OFFICE_BUILDING: "general/office_building";
    readonly ONE_ZONE_IA: "storage/s3/s3_one_zone_ia";
    readonly OPEN_3D_ENGINE: "game_tech/open_3d_engine/service_icon";
    readonly OPSWORKS: "management_governance/opsworks/service_icon";
    readonly OPSWORKS_APPS: "management_governance/opsworks/apps";
    readonly OPSWORKS_PERMISSIONS: "management_governance/opsworks/permissions";
    readonly OPTIMIZED_INSTANCE: false;
    readonly ORACLE_DB_INSTANCE: false;
    readonly ORACLE_DB_INSTANCE_ALTERNATE: false;
    readonly ORGANIZATIONS: "management_governance/organizations/service_icon";
    readonly ORGANIZATIONS_ACCOUNT: "management_governance/organizations/account";
    readonly ORGANIZATIONS_ACCOUNT2: "management_governance/organizations/service_icon";
    readonly ORGANIZATIONS_MANAGEMENT_ACCOUNT: "management_governance/organizations/management_account";
    readonly ORGANIZATIONS_MANAGEMENT_ACCOUNT2: "management_governance/organizations/service_icon";
    readonly ORGANIZATIONS_ORGANIZATIONAL_UNIT: "management_governance/organizations/organizational_unit";
    readonly ORGANIZATIONS_ORGANIZATIONAL_UNIT2: "management_governance/organizations/service_icon";
    readonly OUTPOSTS: "storage/s3/s3_on_outposts";
    readonly OUTPOSTS_1U_AND_2U_SERVERS: "compute/outposts_rack/service_icon";
    readonly OUTPOSTS_FAMILY: "compute/outposts_family/service_icon";
    readonly P2_INSTANCE: "compute/ec2/instance/p2";
    readonly P3DN_INSTANCE: "compute/ec2/instance/p3dn";
    readonly P3_INSTANCE: "compute/ec2/instance/p3";
    readonly P4D_INSTANCE: "compute/ec2/instance/p4d";
    readonly P4_INSTANCE: "compute/ec2/instance/p4";
    readonly PANORAMA: "machine_learning/panorama/service_icon";
    readonly PARALLEL_CLUSTER: "compute/parallelcluster/service_icon";
    readonly PARAMETER_STORE: "management_governance/ssm/parameter_store";
    readonly PATCH_MANAGER: "management_governance/ssm/patch_manager";
    readonly PEERING: "networking_content_delivery/vpc/peering_connection";
    readonly PERMISSIONS: "security_identity_compliance/iam/permissions";
    readonly PERMISSIONS_2: false;
    readonly PERSONALIZE: "machine_learning/personalize/service_icon";
    readonly PERSONAL_HEALTH_DASHBOARD: "management_governance/personal_health_dashboard/service_icon";
    readonly PINPOINT: "business_applications/pinpoint/service_icon";
    readonly PINPOINT_JOURNEY: "business_applications/pinpoint/journey";
    readonly POLICE_EMERGENCY: "internet_of_things/thing/police_emergency";
    readonly POLICY: "security_identity_compliance/iam/add_on";
    readonly POLLY: "machine_learning/polly/service_icon";
    readonly POSTGRESQL_INSTANCE: false;
    readonly PRIVATELINK: "networking_content_delivery/privatelink/service_icon";
    readonly PRIVATE_5G: "networking_content_delivery/private_5g/service_icon";
    readonly PROFESSIONAL_SERVICES: "customer_enablement/professional_services/service_icon";
    readonly PROTON: "management_governance/proton/service_icon";
    readonly QUANTUM_LEDGER_DATABASE: "blockchain/quantum_ledger_database/service_icon";
    readonly QUANTUM_TECHNOLOGIES: "quantum_technologies/category_icon";
    readonly QUESTION: "general/question";
    readonly QUEUE: "application_integration/sqs/queue";
    readonly QUICKSIGHT: "analytics/quicksight/service_icon";
    readonly R4_INSTANCE: "compute/ec2/instance/r4";
    readonly R5AD_INSTANCE: "compute/ec2/instance/r5ad";
    readonly R5A_INSTANCE: "compute/ec2/instance/r5a";
    readonly R5B_INSTANCE: "compute/ec2/instance/r5b";
    readonly R5D_INSTANCE: "compute/ec2/instance/r5d";
    readonly R5GD_INSTANCE: "compute/ec2/instance/r5gd";
    readonly R5N: "compute/ec2/instance/r5n";
    readonly R5N_INSTANCE: "compute/ec2/instance/r5n";
    readonly R5_INSTANCE: "compute/ec2/instance/r5";
    readonly R6G_INSTANCE: "compute/ec2/instance/r6g";
    readonly RDN_INSTANCE: "compute/ec2/instance/rdn";
    readonly RDS: "database/rds/service_icon";
    readonly RDS_INSTANCE: "database/rds/instance";
    readonly RDS_INSTANCE_ALT: "database/rds/service_icon";
    readonly RDS_MARIADB_INSTANCE: "database/rds/service_icon";
    readonly RDS_MARIADB_INSTANCE_ALT: "database/rds/service_icon";
    readonly RDS_MULTI_AZ: "database/rds/multi_az";
    readonly RDS_MULTI_AZ_DB_CLUSTER: "database/rds/multi_az_db_cluster";
    readonly RDS_MYSQL_INSTANCE: "database/rds/service_icon";
    readonly RDS_MYSQL_INSTANCE_ALT: "database/rds/service_icon";
    readonly RDS_ON_VMWARE: "database/rds_on_vmware/service_icon";
    readonly RDS_ORACLE_INSTANCE: "database/rds/service_icon";
    readonly RDS_ORACLE_INSTANCE_ALT: "database/rds/service_icon";
    readonly RDS_PIOP: "database/rds/service_icon";
    readonly RDS_PIOPS: "database/rds/service_icon";
    readonly RDS_POSTGRESQL_INSTANCE: "database/rds/service_icon";
    readonly RDS_POSTGRESQL_INSTANCE_ALT: "database/rds/service_icon";
    readonly RDS_PROXY: "database/rds/service_icon";
    readonly RDS_PROXY_ALT: "database/rds/service_icon";
    readonly RDS_SQL_SERVER_INSTANCE: "database/rds/service_icon";
    readonly RDS_SQL_SERVER_INSTANCE_ALT: "database/rds/service_icon";
    readonly REDSHIFT: "analytics/redshift/service_icon";
    readonly REDSHIFT_ML: "analytics/redshift/ml";
    readonly REDSHIFT_RA3: "analytics/redshift/ra3";
    readonly RED_HAT_OPENSHIFT: "containers/red_hat_openshift/service_icon";
    readonly REGISTRY: "containers/ecr/registry";
    readonly REKOGNITION: "machine_learning/rekognition/service_icon";
    readonly REKOGNITION_2: "machine_learning/rekognition/service_icon";
    readonly REKOGNITION_IMAGE: "machine_learning/rekognition/image";
    readonly REKOGNITION_VIDEO: "machine_learning/rekognition/video";
    readonly REPLICATION: "storage/s3/s3_replication";
    readonly REPLICATION_TIME_CONTROL: "storage/s3/s3_replication_time_control";
    readonly REPORTED_STATE: "internet_of_things/iot_core/reported_state";
    readonly REPOST: "customer_enablement/repost/service_icon";
    readonly RESCUE: "compute/ec2/rescue";
    readonly RESERVED_INSTANCE_REPORTING: "cloud_financial_management/reserved_instance_reporting/service_icon";
    readonly RESILIENCE_HUB: "management_governance/resilience_hub/service_icon";
    readonly RESOURCE: "networking_content_delivery/cloud_map/resource";
    readonly RESOURCES: "management_governance/opsworks/resources";
    readonly RESOURCE_ACCESS_MANAGER: "security_identity_compliance/resource_access_manager/service_icon";
    readonly ROBOMAKER: "robotics/robomaker/service_icon";
    readonly ROBOTICS: "robotics/category_icon";
    readonly ROLE: "security_identity_compliance/iam/role";
    readonly ROUTER: "networking_content_delivery/vpc/router";
    readonly ROUTE_53: "networking_content_delivery/route_53/service_icon";
    readonly ROUTE_53_APPLICATION_RECOVERY_CONTROLLER: "networking_content_delivery/route_53/application_recovery_controller";
    readonly ROUTE_53_READINESS_CHECKS: "networking_content_delivery/route_53/readiness_checks";
    readonly ROUTE_53_RESOLVER: "networking_content_delivery/route_53/resolver";
    readonly ROUTE_53_RESOLVER_DNS_FIREWALL: "networking_content_delivery/route_53/resolver_dns_firewall";
    readonly ROUTE_53_RESOLVER_QUERY_LOGGING: "networking_content_delivery/route_53/resolver_query_logging";
    readonly ROUTE_53_ROUTING_CONTROLS: "networking_content_delivery/route_53/routing_controls";
    readonly ROUTE_TABLE: "networking_content_delivery/route_53/route_table";
    readonly RULE: "management_governance/cloudwatch/rule";
    readonly RULE_2: false;
    readonly RULE_3: false;
    readonly RUN_COMMAND: "management_governance/ssm/run_command";
    readonly S3: "storage/s3/service_icon";
    readonly S3_FILE_GATEWAY: "storage/s3/service_icon";
    readonly S3_OBJECT_LAMBDA: "storage/s3/service_icon";
    readonly S3_OBJECT_LAMBDA_ACCESS_POINTS: "storage/s3/service_icon";
    readonly S3_ON_OUTPOSTS: "storage/s3_on_outposts/service_icon";
    readonly S3_ON_OUTPOSTS_STORAGE: "storage/s3/service_icon";
    readonly S3_REPLICATION_TIME_CONTROL: "storage/s3/service_icon";
    readonly S3_STORAGE_LENS: "storage/s3/service_icon";
    readonly SAAS_EVENT_BUS_RESOURCE: "application_integration/eventbridge/saas_partner_event";
    readonly SAGEMAKER: "machine_learning/sagemaker/service_icon";
    readonly SAGEMAKER_CANVAS: "machine_learning/sagemaker/canvas";
    readonly SAGEMAKER_GROUND_TRUTH: "machine_learning/sagemaker_ground_truth/service_icon";
    readonly SAGEMAKER_MODEL: "machine_learning/sagemaker/model";
    readonly SAGEMAKER_NOTEBOOK: "machine_learning/sagemaker/notebook";
    readonly SAGEMAKER_STUDIO_LAB: "machine_learning/sagemaker_studio_lab/service_icon";
    readonly SAGEMAKER_TRAIN: "machine_learning/sagemaker/train";
    readonly SAML_TOKEN: "general/saml_token";
    readonly SATELLITE: "satellite/category_icon";
    readonly SAVINGS_PLANS: "cloud_financial_management/savings_plans/service_icon";
    readonly SEARCH_DOCUMENTS: "analytics/cloudsearch/search_documents";
    readonly SECRETS_MANAGER: "security_identity_compliance/secrets_manager/service_icon";
    readonly SECURITY_GROUP: false;
    readonly SECURITY_HUB: "security_identity_compliance/security_hub/service_icon";
    readonly SECURITY_HUB_FINDING: "security_identity_compliance/security_hub/finding";
    readonly SECURITY_IDENTITY_AND_COMPLIANCE: "security_identity_compliance/category_icon";
    readonly SENSOR: "internet_of_things/iot_core/sensor";
    readonly SERVERLESS: "serverless/category_icon";
    readonly SERVERLESS_APPLICATION_REPOSITORY: "compute/serverless_application_repository/service_icon";
    readonly SERVER_MIGRATION_SERVICE: "migration_transfer/server_migration_service/service_icon";
    readonly SERVICE: "compute/ec2/service_icon";
    readonly SERVICE_CATALOG: "management_governance/service_catalog/service_icon";
    readonly SERVO: "internet_of_things/iot_core/servo";
    readonly SHADOW: "internet_of_things/iot_core/shadow";
    readonly SHIELD: "security_identity_compliance/shield/service_icon";
    readonly SHIELD_SHIELD_ADVANCED: "security_identity_compliance/shield/shield_advanced";
    readonly SIGNER: "security_identity_compliance/signer/service_icon";
    readonly SIMPLE_AD: "security_identity_compliance/directory_service/simple_ad";
    readonly SIMPLE_EMAIL_SERVICE: "business_applications/ses/service_icon";
    readonly SIMPLE_STORAGE_SERVICE_S3_GLACIER_INSTANT_RETRIEVAL: false;
    readonly SIMULATION: "robotics/robomaker/simulation";
    readonly SIMULATOR: "internet_of_things/iot_core/simulator";
    readonly SINGLE_SIGN_ON: "security_identity_compliance/iam_identity_center/service_icon";
    readonly SITE_TO_SITE_VPN: "networking_content_delivery/site_to_site_vpn/service_icon";
    readonly SNAPSHOT: "storage/ebs/snapshot";
    readonly SNOWBALL: "storage/snowball/service_icon";
    readonly SNOWBALL_EDGE: "storage/snowball_edge/service_icon";
    readonly SNOWCONE: "storage/snowcone/service_icon";
    readonly SNOWMOBILE: "storage/snowmobile/service_icon";
    readonly SNS: "application_integration/sns/service_icon";
    readonly SPOT_INSTANCE: "compute/ec2/instance/spot";
    readonly SQL_PRIMARY: false;
    readonly SQL_REPLICA: false;
    readonly SQL_WORKBENCH: false;
    readonly SQS: "application_integration/sqs/service_icon";
    readonly SSL_PADLOCK: "general/ssl_padlock";
    readonly STACK: "management_governance/cloudformation/stack";
    readonly STACK2: "management_governance/opsworks/stack2";
    readonly STANDARD_IA: "storage/s3/s3_standard_ia";
    readonly STATE_MANAGER: "management_governance/ssm/state_manager";
    readonly STEP_FUNCTIONS: "application_integration/step_functions/service_icon";
    readonly STORAGE: "storage/category_icon";
    readonly STORAGE_GATEWAY: "storage/storage_gateway/service_icon";
    readonly STREAMING_DISTRIBUTION: "networking_content_delivery/cloudfront/streaming_distribution";
    readonly STS: "security_identity_compliance/iam/sts";
    readonly STS_ALTERNATE: "security_identity_compliance/iam/sts_alternate";
    readonly SUMERIAN: "vr_ar/sumerian/service_icon";
    readonly SUPPORT: "customer_enablement/support/service_icon";
    readonly SYSTEMS_MANAGER: "management_governance/ssm/service_icon";
    readonly SYSTEMS_MANAGER_INCIDENT_MANAGER: "management_governance/systems_manager_incident_manager/service_icon";
    readonly SYSTEMS_MANAGER_OPSCENTER: "management_governance/ssm/opscenter";
    readonly T2_INSTANCE: "compute/ec2/instance/t2";
    readonly T3A_INSTANCE: "compute/ec2/instance/t3a";
    readonly T3_INSTANCE: "compute/ec2/instance/t3";
    readonly T4G_INSTANCE: "compute/ec2/instance/t4g";
    readonly TABLE: "database/dynamodb/table";
    readonly TAPE_GATEWAY: "storage/storage_gateway/tape_gateway";
    readonly TAPE_STORAGE: "general/tape_storage";
    readonly TEMPLATE: "management_governance/cloudformation/template";
    readonly TEMPORARY_SECURITY_CREDENTIAL: "security_identity_compliance/iam/temporary_security_credential";
    readonly TENSORFLOW_ON_AWS: "machine_learning/tensorflow_on_aws/service_icon";
    readonly TEXTRACT: "machine_learning/textract/service_icon";
    readonly THERMOSTAT: "internet_of_things/thing/thermostat";
    readonly THINKBOX_DEADLINE: "compute/thinkbox_deadline/service_icon";
    readonly THINKBOX_DRAFT: false;
    readonly THINKBOX_FROST: "compute/thinkbox_frost/service_icon";
    readonly THINKBOX_KRAKATOA: "compute/thinkbox_krakatoa/service_icon";
    readonly THINKBOX_SEQUOIA: "compute/thinkbox_sequoia/service_icon";
    readonly THINKBOX_STOKE: "compute/thinkbox_stoke/service_icon";
    readonly THINKBOX_XMESH: "compute/thinkbox_xmesh/service_icon";
    readonly TIMESTREAM: "database/timestream/service_icon";
    readonly TOOLS_AND_SDKS: "developer_tools/tools_and_sdks/service_icon";
    readonly TOPIC: "application_integration/sns/topic";
    readonly TOPIC_2: "internet_of_things/iot_core/topic";
    readonly TORCHSERVE: "machine_learning/torchserve/service_icon";
    readonly TRADITIONAL_SERVER: "general/traditional_server";
    readonly TRAINING_CERTIFICATION: "customer_enablement/training_certification/service_icon";
    readonly TRAINIUM_INSTANCE: "compute/ec2/instance/trainium";
    readonly TRANSCRIBE: "machine_learning/transcribe/service_icon";
    readonly TRANSFER_FAMILY: "migration_transfer/transfer_family/service_icon";
    readonly TRANSFER_FOR_FTPS_RESOURCE: "migration_transfer/transfer_family/ftps";
    readonly TRANSFER_FOR_FTP_RESOURCE: "migration_transfer/transfer_family/ftp";
    readonly TRANSFER_FOR_SFTP: "migration_transfer/transfer_family/sftp";
    readonly TRANSFER_FOR_SFTP_RESOURCE: "migration_transfer/transfer_family/sftp";
    readonly TRANSIT_GATEWAY: "networking_content_delivery/transit_gateway/service_icon";
    readonly TRANSIT_GATEWAY_ATTACHMENT: "networking_content_delivery/transit_gateway/attachment";
    readonly TRANSLATE: "machine_learning/translate/service_icon";
    readonly TRAVEL: "internet_of_things/thing/travel";
    readonly TRUSTED_ADVISOR: "management_governance/trusted_advisor/service_icon";
    readonly USER: "general/user";
    readonly USERS: "general/users";
    readonly UTILITY: "internet_of_things/thing/utility";
    readonly VAULT: "storage/s3_glacier/vault";
    readonly VIRTUAL_GATEWAY: "networking_content_delivery/app_mesh/virtual_gateway";
    readonly VIRTUAL_NODE: "networking_content_delivery/app_mesh/virtual_node";
    readonly VIRTUAL_PRIVATE_CLOUD: "networking_content_delivery/vpc/service_icon";
    readonly VIRTUAL_ROUTER: "networking_content_delivery/app_mesh/virtual_router";
    readonly VIRTUAL_SERVICE: "networking_content_delivery/app_mesh/virtual_service";
    readonly VIRTUAL_TAPE_LIBRARY: "storage/storage_gateway/virtual_tape_library";
    readonly VMWARE_CLOUD_ON_AWS: "compute/vmware_cloud_on_aws/service_icon";
    readonly VOLUME: "storage/ebs/volume";
    readonly VOLUME_GATEWAY: "storage/storage_gateway/volume_gateway";
    readonly VPC: "networking_content_delivery/vpc/service_icon";
    readonly VPC_ACCESS_POINTS: "networking_content_delivery/vpc/service_icon";
    readonly VPC_CARRIER_GATEWAY: "networking_content_delivery/vpc/carrier_gateway";
    readonly VPC_NETWORK_ACCESS_ANALYZER: "networking_content_delivery/vpc/network_access_analyzer";
    readonly VPC_PRIVATELINK: "networking_content_delivery/vpc/service_icon";
    readonly VPC_REACHABILITY_ANALYZER: "networking_content_delivery/vpc/reachability_analyzer";
    readonly VPC_TRAFFIC_MIRRORING: "networking_content_delivery/vpc/traffic_mirroring";
    readonly VPN_CONNECTION: "networking_content_delivery/vpc/vpn_connection";
    readonly VPN_GATEWAY: "networking_content_delivery/vpc/vpn_gateway";
    readonly WAF: "security_identity_compliance/waf/service_icon";
    readonly WAF_BAD_BOT: "security_identity_compliance/waf/bad_bot";
    readonly WAF_BOT: "security_identity_compliance/waf/bot";
    readonly WAF_BOT_CONTROL: "security_identity_compliance/waf/bot_control";
    readonly WAF_LABELS: "security_identity_compliance/waf/labels";
    readonly WAF_MANAGED_RULE: "security_identity_compliance/waf/managed_rule";
    readonly WAF_RULE: "security_identity_compliance/waf/rule";
    readonly WAVELENGTH: "compute/wavelength/service_icon";
    readonly WELL_ARCHITECTED_TOOL: "management_governance/well_architected_tool/service_icon";
    readonly WELL_ARCHITECT_TOOL: "management_governance/well_architected_tool/service_icon";
    readonly WINDFARM: "internet_of_things/thing/windfarm";
    readonly WORKDOCS: "business_applications/workdocs/service_icon";
    readonly WORKLINK: "end_user_computing/worklink/service_icon";
    readonly WORKMAIL: "business_applications/workmail/service_icon";
    readonly WORKSPACES: "end_user_computing/workspaces/service_icon";
    readonly WORKSPACES_WORKSPACES_WEB: "end_user_computing/workspaces/service_icon";
    readonly X1E_INSTANCE: "compute/ec2/instance/x1e";
    readonly X1_INSTANCE: "compute/ec2/instance/x1";
    readonly X1_INSTANCE2: false;
    readonly XRAY: "developer_tools/x_ray/service_icon";
    readonly Z1D_INSTANCE: "compute/ec2/instance/z1d";
};
