import * as iam from '@aws-cdk/aws-iam';
import * as cdk from '@aws-cdk/core';
import { RoleProps } from './iam-role-props';
import { IGithubActionsIdentityProvider } from './provider';
/**
 * (experimental) Github related configuration that forms the trust policy for this IAM Role.
 *
 * @experimental
 */
export interface GithubConfiguration {
    /**
     * (experimental) Reference to Github OpenID Connect Provider configured in AWS IAM.
     *
     * Either pass an construct defined by `new GithubActionsIdentityProvider`
     * or a retrieved reference from `GithubActionsIdentityProvider.fromAccount`.
     * There can be only one (per AWS Account).
     *
     * @experimental
     */
    readonly provider: IGithubActionsIdentityProvider;
    /**
     * (experimental) Repository owner (organization or username).
     *
     * @experimental
     * @example
     *
     * 'octo-org'
     */
    readonly owner: string;
    /**
     * (experimental) Repository name (slug) without the owner.
     *
     * @experimental
     * @example
     *
     * 'octo-repo'
     */
    readonly repo: string;
    /**
     * (experimental) Subject condition filter, appended after `repo:${owner}/${repo}:` string in IAM Role trust relationship.
     *
     * @default '*'
     *
     * You may use this value to only allow Github to assume the role on specific branches, tags, environments, pull requests etc.
     * @see https://docs.github.com/en/actions/deployment/security-hardening-your-deployments/about-security-hardening-with-openid-connect#examples
     * @experimental
     * @example
     *
     * 'ref:refs/tags/v*'
     * 'ref:refs/heads/demo-branch'
     * 'pull_request'
     * 'environment:Production'
     */
    readonly filter?: string;
}
/**
 * (experimental) Props that define the IAM Role that can be assumed by Github Actions workflow via Github OpenID Connect Identity Provider.
 *
 * Besides `GithubConfiguration`, you may pass in any `iam.RoleProps` except `assumedBy`
 * which will be defined by this construct (CDK will fail if you do).
 *
 * @experimental
 * @example
 *
 * {
 *   provider: GithubActionsIdentityProvider.fromAccount(scope, "GithubProvider"),
 *   owner: 'octo-org',
 *   repo: 'octo-repo',
 *   filter: 'ref:refs/tags/v*',
 *   roleName: 'MyDeployRole',
 * }
 */
export interface GithubActionsRoleProps extends GithubConfiguration, RoleProps {
}
/**
 * (experimental) Define an IAM Role that can be assumed by Github Actions workflow via Github OpenID Connect Identity Provider.
 *
 * Besides `GithubConfiguration`, you may pass in any `iam.RoleProps` except `assumedBy`
 * which will be defined by this construct (CDK will fail if you do).
 *
 * @experimental
 * @example
 *
 * const uploadRole = new GithubActionsRole(scope, "UploadRole", {
 *   provider: GithubActionsIdentityProvider.fromAccount(scope, "GithubProvider"),
 *   owner: 'octo-org',
 *   repo: 'octo-repo',
 *   filter: 'ref:refs/tags/v*',
 *   roleName: 'MyUploadRole',
 * });
 *
 * myBucket.grantWrite(uploadRole);
 */
export declare class GithubActionsRole extends iam.Role {
    /**
     * Extracts props given for the created IAM Role Construct.
     * @param props for the GithubActionsRole
     * @returns for the IAM Role
     */
    private static extractRoleProps;
    /** Validates the Github owner (organization or user) name. */
    private static validateOwner;
    /** Validates the Github repository name (without owner). */
    private static validateRepo;
    /** Formats the `sub` value used in trust policy. */
    private static formatSubject;
    /**
     * (experimental) Define an IAM Role that can be assumed by Github Actions workflow via Github OpenID Connect Identity Provider.
     *
     * Besides `GithubConfiguration`, you may pass in any `iam.RoleProps` except `assumedBy`
     * which will be defined by this construct (CDK will fail if you do).
     *
     * @experimental
     * @example
     *
     * const uploadRole = new GithubActionsRole(scope, "UploadRole", {
     *   provider: GithubActionsIdentityProvider.fromAccount(scope, "GithubProvider"),
     *   owner: 'octo-org',
     *   repo: 'octo-repo',
     *   filter: 'ref:refs/tags/v*',
     *   roleName: 'MyUploadRole',
     * });
     *
     * myBucket.grantWrite(uploadRole);
     */
    constructor(scope: cdk.Construct, id: string, props: GithubActionsRoleProps);
}
