# coding: utf-8

"""
    Argo

    Python client for Argo Workflows  # noqa: E501

    The version of the OpenAPI document: 2.11.7
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from argo.workflows.client.configuration import Configuration


class V1alpha1Outputs(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'artifacts': 'list[V1alpha1Artifact]',
        'exit_code': 'str',
        'parameters': 'list[V1alpha1Parameter]',
        'result': 'str'
    }

    attribute_map = {
        'artifacts': 'artifacts',
        'exit_code': 'exitCode',
        'parameters': 'parameters',
        'result': 'result'
    }

    def __init__(self, artifacts=None, exit_code=None, parameters=None, result=None, local_vars_configuration=None):  # noqa: E501
        """V1alpha1Outputs - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._artifacts = None
        self._exit_code = None
        self._parameters = None
        self._result = None
        self.discriminator = None

        if artifacts is not None:
            self.artifacts = artifacts
        if exit_code is not None:
            self.exit_code = exit_code
        if parameters is not None:
            self.parameters = parameters
        if result is not None:
            self.result = result

    @property
    def artifacts(self):
        """Gets the artifacts of this V1alpha1Outputs.  # noqa: E501

        Artifacts holds the list of output artifacts produced by a step  # noqa: E501

        :return: The artifacts of this V1alpha1Outputs.  # noqa: E501
        :rtype: list[V1alpha1Artifact]
        """
        return self._artifacts

    @artifacts.setter
    def artifacts(self, artifacts):
        """Sets the artifacts of this V1alpha1Outputs.

        Artifacts holds the list of output artifacts produced by a step  # noqa: E501

        :param artifacts: The artifacts of this V1alpha1Outputs.  # noqa: E501
        :type: list[V1alpha1Artifact]
        """

        self._artifacts = artifacts

    @property
    def exit_code(self):
        """Gets the exit_code of this V1alpha1Outputs.  # noqa: E501

        ExitCode holds the exit code of a script template  # noqa: E501

        :return: The exit_code of this V1alpha1Outputs.  # noqa: E501
        :rtype: str
        """
        return self._exit_code

    @exit_code.setter
    def exit_code(self, exit_code):
        """Sets the exit_code of this V1alpha1Outputs.

        ExitCode holds the exit code of a script template  # noqa: E501

        :param exit_code: The exit_code of this V1alpha1Outputs.  # noqa: E501
        :type: str
        """

        self._exit_code = exit_code

    @property
    def parameters(self):
        """Gets the parameters of this V1alpha1Outputs.  # noqa: E501

        Parameters holds the list of output parameters produced by a step  # noqa: E501

        :return: The parameters of this V1alpha1Outputs.  # noqa: E501
        :rtype: list[V1alpha1Parameter]
        """
        return self._parameters

    @parameters.setter
    def parameters(self, parameters):
        """Sets the parameters of this V1alpha1Outputs.

        Parameters holds the list of output parameters produced by a step  # noqa: E501

        :param parameters: The parameters of this V1alpha1Outputs.  # noqa: E501
        :type: list[V1alpha1Parameter]
        """

        self._parameters = parameters

    @property
    def result(self):
        """Gets the result of this V1alpha1Outputs.  # noqa: E501

        Result holds the result (stdout) of a script template  # noqa: E501

        :return: The result of this V1alpha1Outputs.  # noqa: E501
        :rtype: str
        """
        return self._result

    @result.setter
    def result(self, result):
        """Sets the result of this V1alpha1Outputs.

        Result holds the result (stdout) of a script template  # noqa: E501

        :param result: The result of this V1alpha1Outputs.  # noqa: E501
        :type: str
        """

        self._result = result

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, V1alpha1Outputs):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, V1alpha1Outputs):
            return True

        return self.to_dict() != other.to_dict()
