import * as cdk from '@aws-cdk/core';
import * as cfn_parse from '@aws-cdk/core/lib/cfn-parse';
/**
 * Properties for defining a `AWS::MediaPackage::Asset`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediapackage-asset.html
 */
export interface CfnAssetProps {
    /**
     * `AWS::MediaPackage::Asset.Id`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediapackage-asset.html#cfn-mediapackage-asset-id
     */
    readonly id: string;
    /**
     * `AWS::MediaPackage::Asset.PackagingGroupId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediapackage-asset.html#cfn-mediapackage-asset-packaginggroupid
     */
    readonly packagingGroupId: string;
    /**
     * `AWS::MediaPackage::Asset.SourceArn`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediapackage-asset.html#cfn-mediapackage-asset-sourcearn
     */
    readonly sourceArn: string;
    /**
     * `AWS::MediaPackage::Asset.SourceRoleArn`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediapackage-asset.html#cfn-mediapackage-asset-sourcerolearn
     */
    readonly sourceRoleArn: string;
    /**
     * `AWS::MediaPackage::Asset.EgressEndpoints`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediapackage-asset.html#cfn-mediapackage-asset-egressendpoints
     */
    readonly egressEndpoints?: Array<CfnAsset.EgressEndpointProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::MediaPackage::Asset.ResourceId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediapackage-asset.html#cfn-mediapackage-asset-resourceid
     */
    readonly resourceId?: string;
    /**
     * `AWS::MediaPackage::Asset.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediapackage-asset.html#cfn-mediapackage-asset-tags
     */
    readonly tags?: cdk.CfnTag[];
}
/**
 * A CloudFormation `AWS::MediaPackage::Asset`.
 *
 * @external
 * @cloudformationResource AWS::MediaPackage::Asset
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediapackage-asset.html
 */
export declare class CfnAsset extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::MediaPackage::Asset";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnAsset;
    /**
     * @external
     * @cloudformationAttribute Arn
     */
    readonly attrArn: string;
    /**
     * @external
     * @cloudformationAttribute CreatedAt
     */
    readonly attrCreatedAt: string;
    /**
     * `AWS::MediaPackage::Asset.Id`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediapackage-asset.html#cfn-mediapackage-asset-id
     */
    id: string;
    /**
     * `AWS::MediaPackage::Asset.PackagingGroupId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediapackage-asset.html#cfn-mediapackage-asset-packaginggroupid
     */
    packagingGroupId: string;
    /**
     * `AWS::MediaPackage::Asset.SourceArn`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediapackage-asset.html#cfn-mediapackage-asset-sourcearn
     */
    sourceArn: string;
    /**
     * `AWS::MediaPackage::Asset.SourceRoleArn`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediapackage-asset.html#cfn-mediapackage-asset-sourcerolearn
     */
    sourceRoleArn: string;
    /**
     * `AWS::MediaPackage::Asset.EgressEndpoints`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediapackage-asset.html#cfn-mediapackage-asset-egressendpoints
     */
    egressEndpoints: Array<CfnAsset.EgressEndpointProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * `AWS::MediaPackage::Asset.ResourceId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediapackage-asset.html#cfn-mediapackage-asset-resourceid
     */
    resourceId: string | undefined;
    /**
     * `AWS::MediaPackage::Asset.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediapackage-asset.html#cfn-mediapackage-asset-tags
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::MediaPackage::Asset`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnAssetProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @external
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::MediaPackage::Asset`.
 *
 * @external
 * @cloudformationResource AWS::MediaPackage::Asset
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediapackage-asset.html
 */
export declare namespace CfnAsset {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackage-asset-egressendpoint.html
     */
    interface EgressEndpointProperty {
        /**
         * `CfnAsset.EgressEndpointProperty.PackagingConfigurationId`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackage-asset-egressendpoint.html#cfn-mediapackage-asset-egressendpoint-packagingconfigurationid
         */
        readonly packagingConfigurationId: string;
        /**
         * `CfnAsset.EgressEndpointProperty.Url`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackage-asset-egressendpoint.html#cfn-mediapackage-asset-egressendpoint-url
         */
        readonly url: string;
    }
}
/**
 * Properties for defining a `AWS::MediaPackage::Channel`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediapackage-channel.html
 */
export interface CfnChannelProps {
    /**
     * `AWS::MediaPackage::Channel.Id`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediapackage-channel.html#cfn-mediapackage-channel-id
     */
    readonly id: string;
    /**
     * `AWS::MediaPackage::Channel.Description`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediapackage-channel.html#cfn-mediapackage-channel-description
     */
    readonly description?: string;
    /**
     * `AWS::MediaPackage::Channel.EgressAccessLogs`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediapackage-channel.html#cfn-mediapackage-channel-egressaccesslogs
     */
    readonly egressAccessLogs?: CfnChannel.LogConfigurationProperty | cdk.IResolvable;
    /**
     * `AWS::MediaPackage::Channel.IngressAccessLogs`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediapackage-channel.html#cfn-mediapackage-channel-ingressaccesslogs
     */
    readonly ingressAccessLogs?: CfnChannel.LogConfigurationProperty | cdk.IResolvable;
    /**
     * `AWS::MediaPackage::Channel.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediapackage-channel.html#cfn-mediapackage-channel-tags
     */
    readonly tags?: cdk.CfnTag[];
}
/**
 * A CloudFormation `AWS::MediaPackage::Channel`.
 *
 * @external
 * @cloudformationResource AWS::MediaPackage::Channel
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediapackage-channel.html
 */
export declare class CfnChannel extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::MediaPackage::Channel";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnChannel;
    /**
     * @external
     * @cloudformationAttribute Arn
     */
    readonly attrArn: string;
    /**
     * `AWS::MediaPackage::Channel.Id`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediapackage-channel.html#cfn-mediapackage-channel-id
     */
    id: string;
    /**
     * `AWS::MediaPackage::Channel.Description`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediapackage-channel.html#cfn-mediapackage-channel-description
     */
    description: string | undefined;
    /**
     * `AWS::MediaPackage::Channel.EgressAccessLogs`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediapackage-channel.html#cfn-mediapackage-channel-egressaccesslogs
     */
    egressAccessLogs: CfnChannel.LogConfigurationProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::MediaPackage::Channel.IngressAccessLogs`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediapackage-channel.html#cfn-mediapackage-channel-ingressaccesslogs
     */
    ingressAccessLogs: CfnChannel.LogConfigurationProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::MediaPackage::Channel.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediapackage-channel.html#cfn-mediapackage-channel-tags
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::MediaPackage::Channel`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnChannelProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @external
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::MediaPackage::Channel`.
 *
 * @external
 * @cloudformationResource AWS::MediaPackage::Channel
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediapackage-channel.html
 */
export declare namespace CfnChannel {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackage-channel-logconfiguration.html
     */
    interface LogConfigurationProperty {
        /**
         * `CfnChannel.LogConfigurationProperty.LogGroupName`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackage-channel-logconfiguration.html#cfn-mediapackage-channel-logconfiguration-loggroupname
         */
        readonly logGroupName?: string;
    }
}
/**
 * Properties for defining a `AWS::MediaPackage::OriginEndpoint`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediapackage-originendpoint.html
 */
export interface CfnOriginEndpointProps {
    /**
     * `AWS::MediaPackage::OriginEndpoint.ChannelId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediapackage-originendpoint.html#cfn-mediapackage-originendpoint-channelid
     */
    readonly channelId: string;
    /**
     * `AWS::MediaPackage::OriginEndpoint.Id`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediapackage-originendpoint.html#cfn-mediapackage-originendpoint-id
     */
    readonly id: string;
    /**
     * `AWS::MediaPackage::OriginEndpoint.Authorization`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediapackage-originendpoint.html#cfn-mediapackage-originendpoint-authorization
     */
    readonly authorization?: CfnOriginEndpoint.AuthorizationProperty | cdk.IResolvable;
    /**
     * `AWS::MediaPackage::OriginEndpoint.CmafPackage`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediapackage-originendpoint.html#cfn-mediapackage-originendpoint-cmafpackage
     */
    readonly cmafPackage?: CfnOriginEndpoint.CmafPackageProperty | cdk.IResolvable;
    /**
     * `AWS::MediaPackage::OriginEndpoint.DashPackage`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediapackage-originendpoint.html#cfn-mediapackage-originendpoint-dashpackage
     */
    readonly dashPackage?: CfnOriginEndpoint.DashPackageProperty | cdk.IResolvable;
    /**
     * `AWS::MediaPackage::OriginEndpoint.Description`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediapackage-originendpoint.html#cfn-mediapackage-originendpoint-description
     */
    readonly description?: string;
    /**
     * `AWS::MediaPackage::OriginEndpoint.HlsPackage`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediapackage-originendpoint.html#cfn-mediapackage-originendpoint-hlspackage
     */
    readonly hlsPackage?: CfnOriginEndpoint.HlsPackageProperty | cdk.IResolvable;
    /**
     * `AWS::MediaPackage::OriginEndpoint.ManifestName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediapackage-originendpoint.html#cfn-mediapackage-originendpoint-manifestname
     */
    readonly manifestName?: string;
    /**
     * `AWS::MediaPackage::OriginEndpoint.MssPackage`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediapackage-originendpoint.html#cfn-mediapackage-originendpoint-msspackage
     */
    readonly mssPackage?: CfnOriginEndpoint.MssPackageProperty | cdk.IResolvable;
    /**
     * `AWS::MediaPackage::OriginEndpoint.Origination`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediapackage-originendpoint.html#cfn-mediapackage-originendpoint-origination
     */
    readonly origination?: string;
    /**
     * `AWS::MediaPackage::OriginEndpoint.StartoverWindowSeconds`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediapackage-originendpoint.html#cfn-mediapackage-originendpoint-startoverwindowseconds
     */
    readonly startoverWindowSeconds?: number;
    /**
     * `AWS::MediaPackage::OriginEndpoint.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediapackage-originendpoint.html#cfn-mediapackage-originendpoint-tags
     */
    readonly tags?: cdk.CfnTag[];
    /**
     * `AWS::MediaPackage::OriginEndpoint.TimeDelaySeconds`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediapackage-originendpoint.html#cfn-mediapackage-originendpoint-timedelayseconds
     */
    readonly timeDelaySeconds?: number;
    /**
     * `AWS::MediaPackage::OriginEndpoint.Whitelist`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediapackage-originendpoint.html#cfn-mediapackage-originendpoint-whitelist
     */
    readonly whitelist?: string[];
}
/**
 * A CloudFormation `AWS::MediaPackage::OriginEndpoint`.
 *
 * @external
 * @cloudformationResource AWS::MediaPackage::OriginEndpoint
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediapackage-originendpoint.html
 */
export declare class CfnOriginEndpoint extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::MediaPackage::OriginEndpoint";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnOriginEndpoint;
    /**
     * @external
     * @cloudformationAttribute Arn
     */
    readonly attrArn: string;
    /**
     * @external
     * @cloudformationAttribute Url
     */
    readonly attrUrl: string;
    /**
     * `AWS::MediaPackage::OriginEndpoint.ChannelId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediapackage-originendpoint.html#cfn-mediapackage-originendpoint-channelid
     */
    channelId: string;
    /**
     * `AWS::MediaPackage::OriginEndpoint.Id`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediapackage-originendpoint.html#cfn-mediapackage-originendpoint-id
     */
    id: string;
    /**
     * `AWS::MediaPackage::OriginEndpoint.Authorization`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediapackage-originendpoint.html#cfn-mediapackage-originendpoint-authorization
     */
    authorization: CfnOriginEndpoint.AuthorizationProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::MediaPackage::OriginEndpoint.CmafPackage`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediapackage-originendpoint.html#cfn-mediapackage-originendpoint-cmafpackage
     */
    cmafPackage: CfnOriginEndpoint.CmafPackageProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::MediaPackage::OriginEndpoint.DashPackage`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediapackage-originendpoint.html#cfn-mediapackage-originendpoint-dashpackage
     */
    dashPackage: CfnOriginEndpoint.DashPackageProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::MediaPackage::OriginEndpoint.Description`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediapackage-originendpoint.html#cfn-mediapackage-originendpoint-description
     */
    description: string | undefined;
    /**
     * `AWS::MediaPackage::OriginEndpoint.HlsPackage`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediapackage-originendpoint.html#cfn-mediapackage-originendpoint-hlspackage
     */
    hlsPackage: CfnOriginEndpoint.HlsPackageProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::MediaPackage::OriginEndpoint.ManifestName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediapackage-originendpoint.html#cfn-mediapackage-originendpoint-manifestname
     */
    manifestName: string | undefined;
    /**
     * `AWS::MediaPackage::OriginEndpoint.MssPackage`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediapackage-originendpoint.html#cfn-mediapackage-originendpoint-msspackage
     */
    mssPackage: CfnOriginEndpoint.MssPackageProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::MediaPackage::OriginEndpoint.Origination`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediapackage-originendpoint.html#cfn-mediapackage-originendpoint-origination
     */
    origination: string | undefined;
    /**
     * `AWS::MediaPackage::OriginEndpoint.StartoverWindowSeconds`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediapackage-originendpoint.html#cfn-mediapackage-originendpoint-startoverwindowseconds
     */
    startoverWindowSeconds: number | undefined;
    /**
     * `AWS::MediaPackage::OriginEndpoint.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediapackage-originendpoint.html#cfn-mediapackage-originendpoint-tags
     */
    readonly tags: cdk.TagManager;
    /**
     * `AWS::MediaPackage::OriginEndpoint.TimeDelaySeconds`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediapackage-originendpoint.html#cfn-mediapackage-originendpoint-timedelayseconds
     */
    timeDelaySeconds: number | undefined;
    /**
     * `AWS::MediaPackage::OriginEndpoint.Whitelist`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediapackage-originendpoint.html#cfn-mediapackage-originendpoint-whitelist
     */
    whitelist: string[] | undefined;
    /**
     * Create a new `AWS::MediaPackage::OriginEndpoint`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnOriginEndpointProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @external
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::MediaPackage::OriginEndpoint`.
 *
 * @external
 * @cloudformationResource AWS::MediaPackage::OriginEndpoint
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediapackage-originendpoint.html
 */
export declare namespace CfnOriginEndpoint {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackage-originendpoint-authorization.html
     */
    interface AuthorizationProperty {
        /**
         * `CfnOriginEndpoint.AuthorizationProperty.CdnIdentifierSecret`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackage-originendpoint-authorization.html#cfn-mediapackage-originendpoint-authorization-cdnidentifiersecret
         */
        readonly cdnIdentifierSecret: string;
        /**
         * `CfnOriginEndpoint.AuthorizationProperty.SecretsRoleArn`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackage-originendpoint-authorization.html#cfn-mediapackage-originendpoint-authorization-secretsrolearn
         */
        readonly secretsRoleArn: string;
    }
}
/**
 * A CloudFormation `AWS::MediaPackage::OriginEndpoint`.
 *
 * @external
 * @cloudformationResource AWS::MediaPackage::OriginEndpoint
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediapackage-originendpoint.html
 */
export declare namespace CfnOriginEndpoint {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackage-originendpoint-cmafencryption.html
     */
    interface CmafEncryptionProperty {
        /**
         * `CfnOriginEndpoint.CmafEncryptionProperty.ConstantInitializationVector`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackage-originendpoint-cmafencryption.html#cfn-mediapackage-originendpoint-cmafencryption-constantinitializationvector
         */
        readonly constantInitializationVector?: string;
        /**
         * `CfnOriginEndpoint.CmafEncryptionProperty.KeyRotationIntervalSeconds`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackage-originendpoint-cmafencryption.html#cfn-mediapackage-originendpoint-cmafencryption-keyrotationintervalseconds
         */
        readonly keyRotationIntervalSeconds?: number;
        /**
         * `CfnOriginEndpoint.CmafEncryptionProperty.SpekeKeyProvider`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackage-originendpoint-cmafencryption.html#cfn-mediapackage-originendpoint-cmafencryption-spekekeyprovider
         */
        readonly spekeKeyProvider: CfnOriginEndpoint.SpekeKeyProviderProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::MediaPackage::OriginEndpoint`.
 *
 * @external
 * @cloudformationResource AWS::MediaPackage::OriginEndpoint
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediapackage-originendpoint.html
 */
export declare namespace CfnOriginEndpoint {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackage-originendpoint-cmafpackage.html
     */
    interface CmafPackageProperty {
        /**
         * `CfnOriginEndpoint.CmafPackageProperty.Encryption`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackage-originendpoint-cmafpackage.html#cfn-mediapackage-originendpoint-cmafpackage-encryption
         */
        readonly encryption?: CfnOriginEndpoint.CmafEncryptionProperty | cdk.IResolvable;
        /**
         * `CfnOriginEndpoint.CmafPackageProperty.HlsManifests`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackage-originendpoint-cmafpackage.html#cfn-mediapackage-originendpoint-cmafpackage-hlsmanifests
         */
        readonly hlsManifests?: Array<CfnOriginEndpoint.HlsManifestProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnOriginEndpoint.CmafPackageProperty.SegmentDurationSeconds`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackage-originendpoint-cmafpackage.html#cfn-mediapackage-originendpoint-cmafpackage-segmentdurationseconds
         */
        readonly segmentDurationSeconds?: number;
        /**
         * `CfnOriginEndpoint.CmafPackageProperty.SegmentPrefix`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackage-originendpoint-cmafpackage.html#cfn-mediapackage-originendpoint-cmafpackage-segmentprefix
         */
        readonly segmentPrefix?: string;
        /**
         * `CfnOriginEndpoint.CmafPackageProperty.StreamSelection`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackage-originendpoint-cmafpackage.html#cfn-mediapackage-originendpoint-cmafpackage-streamselection
         */
        readonly streamSelection?: CfnOriginEndpoint.StreamSelectionProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::MediaPackage::OriginEndpoint`.
 *
 * @external
 * @cloudformationResource AWS::MediaPackage::OriginEndpoint
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediapackage-originendpoint.html
 */
export declare namespace CfnOriginEndpoint {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackage-originendpoint-dashencryption.html
     */
    interface DashEncryptionProperty {
        /**
         * `CfnOriginEndpoint.DashEncryptionProperty.KeyRotationIntervalSeconds`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackage-originendpoint-dashencryption.html#cfn-mediapackage-originendpoint-dashencryption-keyrotationintervalseconds
         */
        readonly keyRotationIntervalSeconds?: number;
        /**
         * `CfnOriginEndpoint.DashEncryptionProperty.SpekeKeyProvider`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackage-originendpoint-dashencryption.html#cfn-mediapackage-originendpoint-dashencryption-spekekeyprovider
         */
        readonly spekeKeyProvider: CfnOriginEndpoint.SpekeKeyProviderProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::MediaPackage::OriginEndpoint`.
 *
 * @external
 * @cloudformationResource AWS::MediaPackage::OriginEndpoint
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediapackage-originendpoint.html
 */
export declare namespace CfnOriginEndpoint {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackage-originendpoint-dashpackage.html
     */
    interface DashPackageProperty {
        /**
         * `CfnOriginEndpoint.DashPackageProperty.AdTriggers`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackage-originendpoint-dashpackage.html#cfn-mediapackage-originendpoint-dashpackage-adtriggers
         */
        readonly adTriggers?: string[];
        /**
         * `CfnOriginEndpoint.DashPackageProperty.AdsOnDeliveryRestrictions`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackage-originendpoint-dashpackage.html#cfn-mediapackage-originendpoint-dashpackage-adsondeliveryrestrictions
         */
        readonly adsOnDeliveryRestrictions?: string;
        /**
         * `CfnOriginEndpoint.DashPackageProperty.Encryption`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackage-originendpoint-dashpackage.html#cfn-mediapackage-originendpoint-dashpackage-encryption
         */
        readonly encryption?: CfnOriginEndpoint.DashEncryptionProperty | cdk.IResolvable;
        /**
         * `CfnOriginEndpoint.DashPackageProperty.ManifestLayout`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackage-originendpoint-dashpackage.html#cfn-mediapackage-originendpoint-dashpackage-manifestlayout
         */
        readonly manifestLayout?: string;
        /**
         * `CfnOriginEndpoint.DashPackageProperty.ManifestWindowSeconds`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackage-originendpoint-dashpackage.html#cfn-mediapackage-originendpoint-dashpackage-manifestwindowseconds
         */
        readonly manifestWindowSeconds?: number;
        /**
         * `CfnOriginEndpoint.DashPackageProperty.MinBufferTimeSeconds`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackage-originendpoint-dashpackage.html#cfn-mediapackage-originendpoint-dashpackage-minbuffertimeseconds
         */
        readonly minBufferTimeSeconds?: number;
        /**
         * `CfnOriginEndpoint.DashPackageProperty.MinUpdatePeriodSeconds`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackage-originendpoint-dashpackage.html#cfn-mediapackage-originendpoint-dashpackage-minupdateperiodseconds
         */
        readonly minUpdatePeriodSeconds?: number;
        /**
         * `CfnOriginEndpoint.DashPackageProperty.PeriodTriggers`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackage-originendpoint-dashpackage.html#cfn-mediapackage-originendpoint-dashpackage-periodtriggers
         */
        readonly periodTriggers?: string[];
        /**
         * `CfnOriginEndpoint.DashPackageProperty.Profile`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackage-originendpoint-dashpackage.html#cfn-mediapackage-originendpoint-dashpackage-profile
         */
        readonly profile?: string;
        /**
         * `CfnOriginEndpoint.DashPackageProperty.SegmentDurationSeconds`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackage-originendpoint-dashpackage.html#cfn-mediapackage-originendpoint-dashpackage-segmentdurationseconds
         */
        readonly segmentDurationSeconds?: number;
        /**
         * `CfnOriginEndpoint.DashPackageProperty.SegmentTemplateFormat`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackage-originendpoint-dashpackage.html#cfn-mediapackage-originendpoint-dashpackage-segmenttemplateformat
         */
        readonly segmentTemplateFormat?: string;
        /**
         * `CfnOriginEndpoint.DashPackageProperty.StreamSelection`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackage-originendpoint-dashpackage.html#cfn-mediapackage-originendpoint-dashpackage-streamselection
         */
        readonly streamSelection?: CfnOriginEndpoint.StreamSelectionProperty | cdk.IResolvable;
        /**
         * `CfnOriginEndpoint.DashPackageProperty.SuggestedPresentationDelaySeconds`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackage-originendpoint-dashpackage.html#cfn-mediapackage-originendpoint-dashpackage-suggestedpresentationdelayseconds
         */
        readonly suggestedPresentationDelaySeconds?: number;
        /**
         * `CfnOriginEndpoint.DashPackageProperty.UtcTiming`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackage-originendpoint-dashpackage.html#cfn-mediapackage-originendpoint-dashpackage-utctiming
         */
        readonly utcTiming?: string;
        /**
         * `CfnOriginEndpoint.DashPackageProperty.UtcTimingUri`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackage-originendpoint-dashpackage.html#cfn-mediapackage-originendpoint-dashpackage-utctiminguri
         */
        readonly utcTimingUri?: string;
    }
}
/**
 * A CloudFormation `AWS::MediaPackage::OriginEndpoint`.
 *
 * @external
 * @cloudformationResource AWS::MediaPackage::OriginEndpoint
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediapackage-originendpoint.html
 */
export declare namespace CfnOriginEndpoint {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackage-originendpoint-hlsencryption.html
     */
    interface HlsEncryptionProperty {
        /**
         * `CfnOriginEndpoint.HlsEncryptionProperty.ConstantInitializationVector`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackage-originendpoint-hlsencryption.html#cfn-mediapackage-originendpoint-hlsencryption-constantinitializationvector
         */
        readonly constantInitializationVector?: string;
        /**
         * `CfnOriginEndpoint.HlsEncryptionProperty.EncryptionMethod`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackage-originendpoint-hlsencryption.html#cfn-mediapackage-originendpoint-hlsencryption-encryptionmethod
         */
        readonly encryptionMethod?: string;
        /**
         * `CfnOriginEndpoint.HlsEncryptionProperty.KeyRotationIntervalSeconds`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackage-originendpoint-hlsencryption.html#cfn-mediapackage-originendpoint-hlsencryption-keyrotationintervalseconds
         */
        readonly keyRotationIntervalSeconds?: number;
        /**
         * `CfnOriginEndpoint.HlsEncryptionProperty.RepeatExtXKey`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackage-originendpoint-hlsencryption.html#cfn-mediapackage-originendpoint-hlsencryption-repeatextxkey
         */
        readonly repeatExtXKey?: boolean | cdk.IResolvable;
        /**
         * `CfnOriginEndpoint.HlsEncryptionProperty.SpekeKeyProvider`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackage-originendpoint-hlsencryption.html#cfn-mediapackage-originendpoint-hlsencryption-spekekeyprovider
         */
        readonly spekeKeyProvider: CfnOriginEndpoint.SpekeKeyProviderProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::MediaPackage::OriginEndpoint`.
 *
 * @external
 * @cloudformationResource AWS::MediaPackage::OriginEndpoint
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediapackage-originendpoint.html
 */
export declare namespace CfnOriginEndpoint {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackage-originendpoint-hlsmanifest.html
     */
    interface HlsManifestProperty {
        /**
         * `CfnOriginEndpoint.HlsManifestProperty.AdMarkers`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackage-originendpoint-hlsmanifest.html#cfn-mediapackage-originendpoint-hlsmanifest-admarkers
         */
        readonly adMarkers?: string;
        /**
         * `CfnOriginEndpoint.HlsManifestProperty.AdTriggers`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackage-originendpoint-hlsmanifest.html#cfn-mediapackage-originendpoint-hlsmanifest-adtriggers
         */
        readonly adTriggers?: string[];
        /**
         * `CfnOriginEndpoint.HlsManifestProperty.AdsOnDeliveryRestrictions`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackage-originendpoint-hlsmanifest.html#cfn-mediapackage-originendpoint-hlsmanifest-adsondeliveryrestrictions
         */
        readonly adsOnDeliveryRestrictions?: string;
        /**
         * `CfnOriginEndpoint.HlsManifestProperty.Id`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackage-originendpoint-hlsmanifest.html#cfn-mediapackage-originendpoint-hlsmanifest-id
         */
        readonly id: string;
        /**
         * `CfnOriginEndpoint.HlsManifestProperty.IncludeIframeOnlyStream`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackage-originendpoint-hlsmanifest.html#cfn-mediapackage-originendpoint-hlsmanifest-includeiframeonlystream
         */
        readonly includeIframeOnlyStream?: boolean | cdk.IResolvable;
        /**
         * `CfnOriginEndpoint.HlsManifestProperty.ManifestName`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackage-originendpoint-hlsmanifest.html#cfn-mediapackage-originendpoint-hlsmanifest-manifestname
         */
        readonly manifestName?: string;
        /**
         * `CfnOriginEndpoint.HlsManifestProperty.PlaylistType`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackage-originendpoint-hlsmanifest.html#cfn-mediapackage-originendpoint-hlsmanifest-playlisttype
         */
        readonly playlistType?: string;
        /**
         * `CfnOriginEndpoint.HlsManifestProperty.PlaylistWindowSeconds`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackage-originendpoint-hlsmanifest.html#cfn-mediapackage-originendpoint-hlsmanifest-playlistwindowseconds
         */
        readonly playlistWindowSeconds?: number;
        /**
         * `CfnOriginEndpoint.HlsManifestProperty.ProgramDateTimeIntervalSeconds`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackage-originendpoint-hlsmanifest.html#cfn-mediapackage-originendpoint-hlsmanifest-programdatetimeintervalseconds
         */
        readonly programDateTimeIntervalSeconds?: number;
        /**
         * `CfnOriginEndpoint.HlsManifestProperty.Url`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackage-originendpoint-hlsmanifest.html#cfn-mediapackage-originendpoint-hlsmanifest-url
         */
        readonly url?: string;
    }
}
/**
 * A CloudFormation `AWS::MediaPackage::OriginEndpoint`.
 *
 * @external
 * @cloudformationResource AWS::MediaPackage::OriginEndpoint
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediapackage-originendpoint.html
 */
export declare namespace CfnOriginEndpoint {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackage-originendpoint-hlspackage.html
     */
    interface HlsPackageProperty {
        /**
         * `CfnOriginEndpoint.HlsPackageProperty.AdMarkers`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackage-originendpoint-hlspackage.html#cfn-mediapackage-originendpoint-hlspackage-admarkers
         */
        readonly adMarkers?: string;
        /**
         * `CfnOriginEndpoint.HlsPackageProperty.AdTriggers`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackage-originendpoint-hlspackage.html#cfn-mediapackage-originendpoint-hlspackage-adtriggers
         */
        readonly adTriggers?: string[];
        /**
         * `CfnOriginEndpoint.HlsPackageProperty.AdsOnDeliveryRestrictions`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackage-originendpoint-hlspackage.html#cfn-mediapackage-originendpoint-hlspackage-adsondeliveryrestrictions
         */
        readonly adsOnDeliveryRestrictions?: string;
        /**
         * `CfnOriginEndpoint.HlsPackageProperty.Encryption`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackage-originendpoint-hlspackage.html#cfn-mediapackage-originendpoint-hlspackage-encryption
         */
        readonly encryption?: CfnOriginEndpoint.HlsEncryptionProperty | cdk.IResolvable;
        /**
         * `CfnOriginEndpoint.HlsPackageProperty.IncludeIframeOnlyStream`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackage-originendpoint-hlspackage.html#cfn-mediapackage-originendpoint-hlspackage-includeiframeonlystream
         */
        readonly includeIframeOnlyStream?: boolean | cdk.IResolvable;
        /**
         * `CfnOriginEndpoint.HlsPackageProperty.PlaylistType`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackage-originendpoint-hlspackage.html#cfn-mediapackage-originendpoint-hlspackage-playlisttype
         */
        readonly playlistType?: string;
        /**
         * `CfnOriginEndpoint.HlsPackageProperty.PlaylistWindowSeconds`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackage-originendpoint-hlspackage.html#cfn-mediapackage-originendpoint-hlspackage-playlistwindowseconds
         */
        readonly playlistWindowSeconds?: number;
        /**
         * `CfnOriginEndpoint.HlsPackageProperty.ProgramDateTimeIntervalSeconds`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackage-originendpoint-hlspackage.html#cfn-mediapackage-originendpoint-hlspackage-programdatetimeintervalseconds
         */
        readonly programDateTimeIntervalSeconds?: number;
        /**
         * `CfnOriginEndpoint.HlsPackageProperty.SegmentDurationSeconds`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackage-originendpoint-hlspackage.html#cfn-mediapackage-originendpoint-hlspackage-segmentdurationseconds
         */
        readonly segmentDurationSeconds?: number;
        /**
         * `CfnOriginEndpoint.HlsPackageProperty.StreamSelection`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackage-originendpoint-hlspackage.html#cfn-mediapackage-originendpoint-hlspackage-streamselection
         */
        readonly streamSelection?: CfnOriginEndpoint.StreamSelectionProperty | cdk.IResolvable;
        /**
         * `CfnOriginEndpoint.HlsPackageProperty.UseAudioRenditionGroup`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackage-originendpoint-hlspackage.html#cfn-mediapackage-originendpoint-hlspackage-useaudiorenditiongroup
         */
        readonly useAudioRenditionGroup?: boolean | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::MediaPackage::OriginEndpoint`.
 *
 * @external
 * @cloudformationResource AWS::MediaPackage::OriginEndpoint
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediapackage-originendpoint.html
 */
export declare namespace CfnOriginEndpoint {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackage-originendpoint-mssencryption.html
     */
    interface MssEncryptionProperty {
        /**
         * `CfnOriginEndpoint.MssEncryptionProperty.SpekeKeyProvider`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackage-originendpoint-mssencryption.html#cfn-mediapackage-originendpoint-mssencryption-spekekeyprovider
         */
        readonly spekeKeyProvider: CfnOriginEndpoint.SpekeKeyProviderProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::MediaPackage::OriginEndpoint`.
 *
 * @external
 * @cloudformationResource AWS::MediaPackage::OriginEndpoint
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediapackage-originendpoint.html
 */
export declare namespace CfnOriginEndpoint {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackage-originendpoint-msspackage.html
     */
    interface MssPackageProperty {
        /**
         * `CfnOriginEndpoint.MssPackageProperty.Encryption`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackage-originendpoint-msspackage.html#cfn-mediapackage-originendpoint-msspackage-encryption
         */
        readonly encryption?: CfnOriginEndpoint.MssEncryptionProperty | cdk.IResolvable;
        /**
         * `CfnOriginEndpoint.MssPackageProperty.ManifestWindowSeconds`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackage-originendpoint-msspackage.html#cfn-mediapackage-originendpoint-msspackage-manifestwindowseconds
         */
        readonly manifestWindowSeconds?: number;
        /**
         * `CfnOriginEndpoint.MssPackageProperty.SegmentDurationSeconds`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackage-originendpoint-msspackage.html#cfn-mediapackage-originendpoint-msspackage-segmentdurationseconds
         */
        readonly segmentDurationSeconds?: number;
        /**
         * `CfnOriginEndpoint.MssPackageProperty.StreamSelection`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackage-originendpoint-msspackage.html#cfn-mediapackage-originendpoint-msspackage-streamselection
         */
        readonly streamSelection?: CfnOriginEndpoint.StreamSelectionProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::MediaPackage::OriginEndpoint`.
 *
 * @external
 * @cloudformationResource AWS::MediaPackage::OriginEndpoint
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediapackage-originendpoint.html
 */
export declare namespace CfnOriginEndpoint {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackage-originendpoint-spekekeyprovider.html
     */
    interface SpekeKeyProviderProperty {
        /**
         * `CfnOriginEndpoint.SpekeKeyProviderProperty.CertificateArn`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackage-originendpoint-spekekeyprovider.html#cfn-mediapackage-originendpoint-spekekeyprovider-certificatearn
         */
        readonly certificateArn?: string;
        /**
         * `CfnOriginEndpoint.SpekeKeyProviderProperty.ResourceId`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackage-originendpoint-spekekeyprovider.html#cfn-mediapackage-originendpoint-spekekeyprovider-resourceid
         */
        readonly resourceId: string;
        /**
         * `CfnOriginEndpoint.SpekeKeyProviderProperty.RoleArn`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackage-originendpoint-spekekeyprovider.html#cfn-mediapackage-originendpoint-spekekeyprovider-rolearn
         */
        readonly roleArn: string;
        /**
         * `CfnOriginEndpoint.SpekeKeyProviderProperty.SystemIds`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackage-originendpoint-spekekeyprovider.html#cfn-mediapackage-originendpoint-spekekeyprovider-systemids
         */
        readonly systemIds: string[];
        /**
         * `CfnOriginEndpoint.SpekeKeyProviderProperty.Url`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackage-originendpoint-spekekeyprovider.html#cfn-mediapackage-originendpoint-spekekeyprovider-url
         */
        readonly url: string;
    }
}
/**
 * A CloudFormation `AWS::MediaPackage::OriginEndpoint`.
 *
 * @external
 * @cloudformationResource AWS::MediaPackage::OriginEndpoint
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediapackage-originendpoint.html
 */
export declare namespace CfnOriginEndpoint {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackage-originendpoint-streamselection.html
     */
    interface StreamSelectionProperty {
        /**
         * `CfnOriginEndpoint.StreamSelectionProperty.MaxVideoBitsPerSecond`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackage-originendpoint-streamselection.html#cfn-mediapackage-originendpoint-streamselection-maxvideobitspersecond
         */
        readonly maxVideoBitsPerSecond?: number;
        /**
         * `CfnOriginEndpoint.StreamSelectionProperty.MinVideoBitsPerSecond`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackage-originendpoint-streamselection.html#cfn-mediapackage-originendpoint-streamselection-minvideobitspersecond
         */
        readonly minVideoBitsPerSecond?: number;
        /**
         * `CfnOriginEndpoint.StreamSelectionProperty.StreamOrder`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackage-originendpoint-streamselection.html#cfn-mediapackage-originendpoint-streamselection-streamorder
         */
        readonly streamOrder?: string;
    }
}
/**
 * Properties for defining a `AWS::MediaPackage::PackagingConfiguration`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediapackage-packagingconfiguration.html
 */
export interface CfnPackagingConfigurationProps {
    /**
     * `AWS::MediaPackage::PackagingConfiguration.Id`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediapackage-packagingconfiguration.html#cfn-mediapackage-packagingconfiguration-id
     */
    readonly id: string;
    /**
     * `AWS::MediaPackage::PackagingConfiguration.PackagingGroupId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediapackage-packagingconfiguration.html#cfn-mediapackage-packagingconfiguration-packaginggroupid
     */
    readonly packagingGroupId: string;
    /**
     * `AWS::MediaPackage::PackagingConfiguration.CmafPackage`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediapackage-packagingconfiguration.html#cfn-mediapackage-packagingconfiguration-cmafpackage
     */
    readonly cmafPackage?: CfnPackagingConfiguration.CmafPackageProperty | cdk.IResolvable;
    /**
     * `AWS::MediaPackage::PackagingConfiguration.DashPackage`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediapackage-packagingconfiguration.html#cfn-mediapackage-packagingconfiguration-dashpackage
     */
    readonly dashPackage?: CfnPackagingConfiguration.DashPackageProperty | cdk.IResolvable;
    /**
     * `AWS::MediaPackage::PackagingConfiguration.HlsPackage`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediapackage-packagingconfiguration.html#cfn-mediapackage-packagingconfiguration-hlspackage
     */
    readonly hlsPackage?: CfnPackagingConfiguration.HlsPackageProperty | cdk.IResolvable;
    /**
     * `AWS::MediaPackage::PackagingConfiguration.MssPackage`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediapackage-packagingconfiguration.html#cfn-mediapackage-packagingconfiguration-msspackage
     */
    readonly mssPackage?: CfnPackagingConfiguration.MssPackageProperty | cdk.IResolvable;
    /**
     * `AWS::MediaPackage::PackagingConfiguration.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediapackage-packagingconfiguration.html#cfn-mediapackage-packagingconfiguration-tags
     */
    readonly tags?: cdk.CfnTag[];
}
/**
 * A CloudFormation `AWS::MediaPackage::PackagingConfiguration`.
 *
 * @external
 * @cloudformationResource AWS::MediaPackage::PackagingConfiguration
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediapackage-packagingconfiguration.html
 */
export declare class CfnPackagingConfiguration extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::MediaPackage::PackagingConfiguration";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnPackagingConfiguration;
    /**
     * @external
     * @cloudformationAttribute Arn
     */
    readonly attrArn: string;
    /**
     * `AWS::MediaPackage::PackagingConfiguration.Id`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediapackage-packagingconfiguration.html#cfn-mediapackage-packagingconfiguration-id
     */
    id: string;
    /**
     * `AWS::MediaPackage::PackagingConfiguration.PackagingGroupId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediapackage-packagingconfiguration.html#cfn-mediapackage-packagingconfiguration-packaginggroupid
     */
    packagingGroupId: string;
    /**
     * `AWS::MediaPackage::PackagingConfiguration.CmafPackage`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediapackage-packagingconfiguration.html#cfn-mediapackage-packagingconfiguration-cmafpackage
     */
    cmafPackage: CfnPackagingConfiguration.CmafPackageProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::MediaPackage::PackagingConfiguration.DashPackage`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediapackage-packagingconfiguration.html#cfn-mediapackage-packagingconfiguration-dashpackage
     */
    dashPackage: CfnPackagingConfiguration.DashPackageProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::MediaPackage::PackagingConfiguration.HlsPackage`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediapackage-packagingconfiguration.html#cfn-mediapackage-packagingconfiguration-hlspackage
     */
    hlsPackage: CfnPackagingConfiguration.HlsPackageProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::MediaPackage::PackagingConfiguration.MssPackage`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediapackage-packagingconfiguration.html#cfn-mediapackage-packagingconfiguration-msspackage
     */
    mssPackage: CfnPackagingConfiguration.MssPackageProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::MediaPackage::PackagingConfiguration.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediapackage-packagingconfiguration.html#cfn-mediapackage-packagingconfiguration-tags
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::MediaPackage::PackagingConfiguration`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnPackagingConfigurationProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @external
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::MediaPackage::PackagingConfiguration`.
 *
 * @external
 * @cloudformationResource AWS::MediaPackage::PackagingConfiguration
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediapackage-packagingconfiguration.html
 */
export declare namespace CfnPackagingConfiguration {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackage-packagingconfiguration-cmafencryption.html
     */
    interface CmafEncryptionProperty {
        /**
         * `CfnPackagingConfiguration.CmafEncryptionProperty.SpekeKeyProvider`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackage-packagingconfiguration-cmafencryption.html#cfn-mediapackage-packagingconfiguration-cmafencryption-spekekeyprovider
         */
        readonly spekeKeyProvider: CfnPackagingConfiguration.SpekeKeyProviderProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::MediaPackage::PackagingConfiguration`.
 *
 * @external
 * @cloudformationResource AWS::MediaPackage::PackagingConfiguration
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediapackage-packagingconfiguration.html
 */
export declare namespace CfnPackagingConfiguration {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackage-packagingconfiguration-cmafpackage.html
     */
    interface CmafPackageProperty {
        /**
         * `CfnPackagingConfiguration.CmafPackageProperty.Encryption`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackage-packagingconfiguration-cmafpackage.html#cfn-mediapackage-packagingconfiguration-cmafpackage-encryption
         */
        readonly encryption?: CfnPackagingConfiguration.CmafEncryptionProperty | cdk.IResolvable;
        /**
         * `CfnPackagingConfiguration.CmafPackageProperty.HlsManifests`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackage-packagingconfiguration-cmafpackage.html#cfn-mediapackage-packagingconfiguration-cmafpackage-hlsmanifests
         */
        readonly hlsManifests: Array<CfnPackagingConfiguration.HlsManifestProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnPackagingConfiguration.CmafPackageProperty.IncludeEncoderConfigurationInSegments`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackage-packagingconfiguration-cmafpackage.html#cfn-mediapackage-packagingconfiguration-cmafpackage-includeencoderconfigurationinsegments
         */
        readonly includeEncoderConfigurationInSegments?: boolean | cdk.IResolvable;
        /**
         * `CfnPackagingConfiguration.CmafPackageProperty.SegmentDurationSeconds`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackage-packagingconfiguration-cmafpackage.html#cfn-mediapackage-packagingconfiguration-cmafpackage-segmentdurationseconds
         */
        readonly segmentDurationSeconds?: number;
    }
}
/**
 * A CloudFormation `AWS::MediaPackage::PackagingConfiguration`.
 *
 * @external
 * @cloudformationResource AWS::MediaPackage::PackagingConfiguration
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediapackage-packagingconfiguration.html
 */
export declare namespace CfnPackagingConfiguration {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackage-packagingconfiguration-dashencryption.html
     */
    interface DashEncryptionProperty {
        /**
         * `CfnPackagingConfiguration.DashEncryptionProperty.SpekeKeyProvider`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackage-packagingconfiguration-dashencryption.html#cfn-mediapackage-packagingconfiguration-dashencryption-spekekeyprovider
         */
        readonly spekeKeyProvider: CfnPackagingConfiguration.SpekeKeyProviderProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::MediaPackage::PackagingConfiguration`.
 *
 * @external
 * @cloudformationResource AWS::MediaPackage::PackagingConfiguration
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediapackage-packagingconfiguration.html
 */
export declare namespace CfnPackagingConfiguration {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackage-packagingconfiguration-dashmanifest.html
     */
    interface DashManifestProperty {
        /**
         * `CfnPackagingConfiguration.DashManifestProperty.ManifestLayout`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackage-packagingconfiguration-dashmanifest.html#cfn-mediapackage-packagingconfiguration-dashmanifest-manifestlayout
         */
        readonly manifestLayout?: string;
        /**
         * `CfnPackagingConfiguration.DashManifestProperty.ManifestName`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackage-packagingconfiguration-dashmanifest.html#cfn-mediapackage-packagingconfiguration-dashmanifest-manifestname
         */
        readonly manifestName?: string;
        /**
         * `CfnPackagingConfiguration.DashManifestProperty.MinBufferTimeSeconds`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackage-packagingconfiguration-dashmanifest.html#cfn-mediapackage-packagingconfiguration-dashmanifest-minbuffertimeseconds
         */
        readonly minBufferTimeSeconds?: number;
        /**
         * `CfnPackagingConfiguration.DashManifestProperty.Profile`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackage-packagingconfiguration-dashmanifest.html#cfn-mediapackage-packagingconfiguration-dashmanifest-profile
         */
        readonly profile?: string;
        /**
         * `CfnPackagingConfiguration.DashManifestProperty.StreamSelection`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackage-packagingconfiguration-dashmanifest.html#cfn-mediapackage-packagingconfiguration-dashmanifest-streamselection
         */
        readonly streamSelection?: CfnPackagingConfiguration.StreamSelectionProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::MediaPackage::PackagingConfiguration`.
 *
 * @external
 * @cloudformationResource AWS::MediaPackage::PackagingConfiguration
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediapackage-packagingconfiguration.html
 */
export declare namespace CfnPackagingConfiguration {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackage-packagingconfiguration-dashpackage.html
     */
    interface DashPackageProperty {
        /**
         * `CfnPackagingConfiguration.DashPackageProperty.DashManifests`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackage-packagingconfiguration-dashpackage.html#cfn-mediapackage-packagingconfiguration-dashpackage-dashmanifests
         */
        readonly dashManifests: Array<CfnPackagingConfiguration.DashManifestProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnPackagingConfiguration.DashPackageProperty.Encryption`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackage-packagingconfiguration-dashpackage.html#cfn-mediapackage-packagingconfiguration-dashpackage-encryption
         */
        readonly encryption?: CfnPackagingConfiguration.DashEncryptionProperty | cdk.IResolvable;
        /**
         * `CfnPackagingConfiguration.DashPackageProperty.IncludeEncoderConfigurationInSegments`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackage-packagingconfiguration-dashpackage.html#cfn-mediapackage-packagingconfiguration-dashpackage-includeencoderconfigurationinsegments
         */
        readonly includeEncoderConfigurationInSegments?: boolean | cdk.IResolvable;
        /**
         * `CfnPackagingConfiguration.DashPackageProperty.PeriodTriggers`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackage-packagingconfiguration-dashpackage.html#cfn-mediapackage-packagingconfiguration-dashpackage-periodtriggers
         */
        readonly periodTriggers?: string[];
        /**
         * `CfnPackagingConfiguration.DashPackageProperty.SegmentDurationSeconds`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackage-packagingconfiguration-dashpackage.html#cfn-mediapackage-packagingconfiguration-dashpackage-segmentdurationseconds
         */
        readonly segmentDurationSeconds?: number;
        /**
         * `CfnPackagingConfiguration.DashPackageProperty.SegmentTemplateFormat`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackage-packagingconfiguration-dashpackage.html#cfn-mediapackage-packagingconfiguration-dashpackage-segmenttemplateformat
         */
        readonly segmentTemplateFormat?: string;
    }
}
/**
 * A CloudFormation `AWS::MediaPackage::PackagingConfiguration`.
 *
 * @external
 * @cloudformationResource AWS::MediaPackage::PackagingConfiguration
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediapackage-packagingconfiguration.html
 */
export declare namespace CfnPackagingConfiguration {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackage-packagingconfiguration-hlsencryption.html
     */
    interface HlsEncryptionProperty {
        /**
         * `CfnPackagingConfiguration.HlsEncryptionProperty.ConstantInitializationVector`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackage-packagingconfiguration-hlsencryption.html#cfn-mediapackage-packagingconfiguration-hlsencryption-constantinitializationvector
         */
        readonly constantInitializationVector?: string;
        /**
         * `CfnPackagingConfiguration.HlsEncryptionProperty.EncryptionMethod`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackage-packagingconfiguration-hlsencryption.html#cfn-mediapackage-packagingconfiguration-hlsencryption-encryptionmethod
         */
        readonly encryptionMethod?: string;
        /**
         * `CfnPackagingConfiguration.HlsEncryptionProperty.SpekeKeyProvider`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackage-packagingconfiguration-hlsencryption.html#cfn-mediapackage-packagingconfiguration-hlsencryption-spekekeyprovider
         */
        readonly spekeKeyProvider: CfnPackagingConfiguration.SpekeKeyProviderProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::MediaPackage::PackagingConfiguration`.
 *
 * @external
 * @cloudformationResource AWS::MediaPackage::PackagingConfiguration
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediapackage-packagingconfiguration.html
 */
export declare namespace CfnPackagingConfiguration {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackage-packagingconfiguration-hlsmanifest.html
     */
    interface HlsManifestProperty {
        /**
         * `CfnPackagingConfiguration.HlsManifestProperty.AdMarkers`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackage-packagingconfiguration-hlsmanifest.html#cfn-mediapackage-packagingconfiguration-hlsmanifest-admarkers
         */
        readonly adMarkers?: string;
        /**
         * `CfnPackagingConfiguration.HlsManifestProperty.IncludeIframeOnlyStream`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackage-packagingconfiguration-hlsmanifest.html#cfn-mediapackage-packagingconfiguration-hlsmanifest-includeiframeonlystream
         */
        readonly includeIframeOnlyStream?: boolean | cdk.IResolvable;
        /**
         * `CfnPackagingConfiguration.HlsManifestProperty.ManifestName`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackage-packagingconfiguration-hlsmanifest.html#cfn-mediapackage-packagingconfiguration-hlsmanifest-manifestname
         */
        readonly manifestName?: string;
        /**
         * `CfnPackagingConfiguration.HlsManifestProperty.ProgramDateTimeIntervalSeconds`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackage-packagingconfiguration-hlsmanifest.html#cfn-mediapackage-packagingconfiguration-hlsmanifest-programdatetimeintervalseconds
         */
        readonly programDateTimeIntervalSeconds?: number;
        /**
         * `CfnPackagingConfiguration.HlsManifestProperty.RepeatExtXKey`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackage-packagingconfiguration-hlsmanifest.html#cfn-mediapackage-packagingconfiguration-hlsmanifest-repeatextxkey
         */
        readonly repeatExtXKey?: boolean | cdk.IResolvable;
        /**
         * `CfnPackagingConfiguration.HlsManifestProperty.StreamSelection`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackage-packagingconfiguration-hlsmanifest.html#cfn-mediapackage-packagingconfiguration-hlsmanifest-streamselection
         */
        readonly streamSelection?: CfnPackagingConfiguration.StreamSelectionProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::MediaPackage::PackagingConfiguration`.
 *
 * @external
 * @cloudformationResource AWS::MediaPackage::PackagingConfiguration
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediapackage-packagingconfiguration.html
 */
export declare namespace CfnPackagingConfiguration {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackage-packagingconfiguration-hlspackage.html
     */
    interface HlsPackageProperty {
        /**
         * `CfnPackagingConfiguration.HlsPackageProperty.Encryption`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackage-packagingconfiguration-hlspackage.html#cfn-mediapackage-packagingconfiguration-hlspackage-encryption
         */
        readonly encryption?: CfnPackagingConfiguration.HlsEncryptionProperty | cdk.IResolvable;
        /**
         * `CfnPackagingConfiguration.HlsPackageProperty.HlsManifests`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackage-packagingconfiguration-hlspackage.html#cfn-mediapackage-packagingconfiguration-hlspackage-hlsmanifests
         */
        readonly hlsManifests: Array<CfnPackagingConfiguration.HlsManifestProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnPackagingConfiguration.HlsPackageProperty.SegmentDurationSeconds`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackage-packagingconfiguration-hlspackage.html#cfn-mediapackage-packagingconfiguration-hlspackage-segmentdurationseconds
         */
        readonly segmentDurationSeconds?: number;
        /**
         * `CfnPackagingConfiguration.HlsPackageProperty.UseAudioRenditionGroup`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackage-packagingconfiguration-hlspackage.html#cfn-mediapackage-packagingconfiguration-hlspackage-useaudiorenditiongroup
         */
        readonly useAudioRenditionGroup?: boolean | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::MediaPackage::PackagingConfiguration`.
 *
 * @external
 * @cloudformationResource AWS::MediaPackage::PackagingConfiguration
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediapackage-packagingconfiguration.html
 */
export declare namespace CfnPackagingConfiguration {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackage-packagingconfiguration-mssencryption.html
     */
    interface MssEncryptionProperty {
        /**
         * `CfnPackagingConfiguration.MssEncryptionProperty.SpekeKeyProvider`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackage-packagingconfiguration-mssencryption.html#cfn-mediapackage-packagingconfiguration-mssencryption-spekekeyprovider
         */
        readonly spekeKeyProvider: CfnPackagingConfiguration.SpekeKeyProviderProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::MediaPackage::PackagingConfiguration`.
 *
 * @external
 * @cloudformationResource AWS::MediaPackage::PackagingConfiguration
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediapackage-packagingconfiguration.html
 */
export declare namespace CfnPackagingConfiguration {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackage-packagingconfiguration-mssmanifest.html
     */
    interface MssManifestProperty {
        /**
         * `CfnPackagingConfiguration.MssManifestProperty.ManifestName`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackage-packagingconfiguration-mssmanifest.html#cfn-mediapackage-packagingconfiguration-mssmanifest-manifestname
         */
        readonly manifestName?: string;
        /**
         * `CfnPackagingConfiguration.MssManifestProperty.StreamSelection`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackage-packagingconfiguration-mssmanifest.html#cfn-mediapackage-packagingconfiguration-mssmanifest-streamselection
         */
        readonly streamSelection?: CfnPackagingConfiguration.StreamSelectionProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::MediaPackage::PackagingConfiguration`.
 *
 * @external
 * @cloudformationResource AWS::MediaPackage::PackagingConfiguration
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediapackage-packagingconfiguration.html
 */
export declare namespace CfnPackagingConfiguration {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackage-packagingconfiguration-msspackage.html
     */
    interface MssPackageProperty {
        /**
         * `CfnPackagingConfiguration.MssPackageProperty.Encryption`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackage-packagingconfiguration-msspackage.html#cfn-mediapackage-packagingconfiguration-msspackage-encryption
         */
        readonly encryption?: CfnPackagingConfiguration.MssEncryptionProperty | cdk.IResolvable;
        /**
         * `CfnPackagingConfiguration.MssPackageProperty.MssManifests`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackage-packagingconfiguration-msspackage.html#cfn-mediapackage-packagingconfiguration-msspackage-mssmanifests
         */
        readonly mssManifests: Array<CfnPackagingConfiguration.MssManifestProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnPackagingConfiguration.MssPackageProperty.SegmentDurationSeconds`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackage-packagingconfiguration-msspackage.html#cfn-mediapackage-packagingconfiguration-msspackage-segmentdurationseconds
         */
        readonly segmentDurationSeconds?: number;
    }
}
/**
 * A CloudFormation `AWS::MediaPackage::PackagingConfiguration`.
 *
 * @external
 * @cloudformationResource AWS::MediaPackage::PackagingConfiguration
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediapackage-packagingconfiguration.html
 */
export declare namespace CfnPackagingConfiguration {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackage-packagingconfiguration-spekekeyprovider.html
     */
    interface SpekeKeyProviderProperty {
        /**
         * `CfnPackagingConfiguration.SpekeKeyProviderProperty.RoleArn`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackage-packagingconfiguration-spekekeyprovider.html#cfn-mediapackage-packagingconfiguration-spekekeyprovider-rolearn
         */
        readonly roleArn: string;
        /**
         * `CfnPackagingConfiguration.SpekeKeyProviderProperty.SystemIds`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackage-packagingconfiguration-spekekeyprovider.html#cfn-mediapackage-packagingconfiguration-spekekeyprovider-systemids
         */
        readonly systemIds: string[];
        /**
         * `CfnPackagingConfiguration.SpekeKeyProviderProperty.Url`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackage-packagingconfiguration-spekekeyprovider.html#cfn-mediapackage-packagingconfiguration-spekekeyprovider-url
         */
        readonly url: string;
    }
}
/**
 * A CloudFormation `AWS::MediaPackage::PackagingConfiguration`.
 *
 * @external
 * @cloudformationResource AWS::MediaPackage::PackagingConfiguration
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediapackage-packagingconfiguration.html
 */
export declare namespace CfnPackagingConfiguration {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackage-packagingconfiguration-streamselection.html
     */
    interface StreamSelectionProperty {
        /**
         * `CfnPackagingConfiguration.StreamSelectionProperty.MaxVideoBitsPerSecond`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackage-packagingconfiguration-streamselection.html#cfn-mediapackage-packagingconfiguration-streamselection-maxvideobitspersecond
         */
        readonly maxVideoBitsPerSecond?: number;
        /**
         * `CfnPackagingConfiguration.StreamSelectionProperty.MinVideoBitsPerSecond`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackage-packagingconfiguration-streamselection.html#cfn-mediapackage-packagingconfiguration-streamselection-minvideobitspersecond
         */
        readonly minVideoBitsPerSecond?: number;
        /**
         * `CfnPackagingConfiguration.StreamSelectionProperty.StreamOrder`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackage-packagingconfiguration-streamselection.html#cfn-mediapackage-packagingconfiguration-streamselection-streamorder
         */
        readonly streamOrder?: string;
    }
}
/**
 * Properties for defining a `AWS::MediaPackage::PackagingGroup`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediapackage-packaginggroup.html
 */
export interface CfnPackagingGroupProps {
    /**
     * `AWS::MediaPackage::PackagingGroup.Id`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediapackage-packaginggroup.html#cfn-mediapackage-packaginggroup-id
     */
    readonly id: string;
    /**
     * `AWS::MediaPackage::PackagingGroup.Authorization`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediapackage-packaginggroup.html#cfn-mediapackage-packaginggroup-authorization
     */
    readonly authorization?: CfnPackagingGroup.AuthorizationProperty | cdk.IResolvable;
    /**
     * `AWS::MediaPackage::PackagingGroup.EgressAccessLogs`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediapackage-packaginggroup.html#cfn-mediapackage-packaginggroup-egressaccesslogs
     */
    readonly egressAccessLogs?: CfnPackagingGroup.LogConfigurationProperty | cdk.IResolvable;
    /**
     * `AWS::MediaPackage::PackagingGroup.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediapackage-packaginggroup.html#cfn-mediapackage-packaginggroup-tags
     */
    readonly tags?: cdk.CfnTag[];
}
/**
 * A CloudFormation `AWS::MediaPackage::PackagingGroup`.
 *
 * @external
 * @cloudformationResource AWS::MediaPackage::PackagingGroup
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediapackage-packaginggroup.html
 */
export declare class CfnPackagingGroup extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::MediaPackage::PackagingGroup";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnPackagingGroup;
    /**
     * @external
     * @cloudformationAttribute Arn
     */
    readonly attrArn: string;
    /**
     * @external
     * @cloudformationAttribute DomainName
     */
    readonly attrDomainName: string;
    /**
     * `AWS::MediaPackage::PackagingGroup.Id`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediapackage-packaginggroup.html#cfn-mediapackage-packaginggroup-id
     */
    id: string;
    /**
     * `AWS::MediaPackage::PackagingGroup.Authorization`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediapackage-packaginggroup.html#cfn-mediapackage-packaginggroup-authorization
     */
    authorization: CfnPackagingGroup.AuthorizationProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::MediaPackage::PackagingGroup.EgressAccessLogs`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediapackage-packaginggroup.html#cfn-mediapackage-packaginggroup-egressaccesslogs
     */
    egressAccessLogs: CfnPackagingGroup.LogConfigurationProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::MediaPackage::PackagingGroup.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediapackage-packaginggroup.html#cfn-mediapackage-packaginggroup-tags
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::MediaPackage::PackagingGroup`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnPackagingGroupProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @external
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::MediaPackage::PackagingGroup`.
 *
 * @external
 * @cloudformationResource AWS::MediaPackage::PackagingGroup
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediapackage-packaginggroup.html
 */
export declare namespace CfnPackagingGroup {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackage-packaginggroup-authorization.html
     */
    interface AuthorizationProperty {
        /**
         * `CfnPackagingGroup.AuthorizationProperty.CdnIdentifierSecret`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackage-packaginggroup-authorization.html#cfn-mediapackage-packaginggroup-authorization-cdnidentifiersecret
         */
        readonly cdnIdentifierSecret: string;
        /**
         * `CfnPackagingGroup.AuthorizationProperty.SecretsRoleArn`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackage-packaginggroup-authorization.html#cfn-mediapackage-packaginggroup-authorization-secretsrolearn
         */
        readonly secretsRoleArn: string;
    }
}
/**
 * A CloudFormation `AWS::MediaPackage::PackagingGroup`.
 *
 * @external
 * @cloudformationResource AWS::MediaPackage::PackagingGroup
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediapackage-packaginggroup.html
 */
export declare namespace CfnPackagingGroup {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackage-packaginggroup-logconfiguration.html
     */
    interface LogConfigurationProperty {
        /**
         * `CfnPackagingGroup.LogConfigurationProperty.LogGroupName`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackage-packaginggroup-logconfiguration.html#cfn-mediapackage-packaginggroup-logconfiguration-loggroupname
         */
        readonly logGroupName?: string;
    }
}
