"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.FirewallRuleGroupAssociation = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const core_1 = require("@aws-cdk/core");
const route53resolver_generated_1 = require("./route53resolver.generated");
/**
 * A Firewall Rule Group Association
 */
class FirewallRuleGroupAssociation extends core_1.Resource {
    constructor(scope, id, props) {
        super(scope, id);
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_route53resolver_FirewallRuleGroupAssociationProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, FirewallRuleGroupAssociation);
            }
            throw error;
        }
        if (!core_1.Token.isUnresolved(props.priority) && (props.priority <= 100 || props.priority >= 9000)) {
            throw new Error(`Priority must be greater than 100 and less than 9000, got ${props.priority}`);
        }
        const association = new route53resolver_generated_1.CfnFirewallRuleGroupAssociation(this, 'Resource', {
            firewallRuleGroupId: props.firewallRuleGroup.firewallRuleGroupId,
            priority: props.priority,
            vpcId: props.vpc.vpcId,
        });
        this.firewallRuleGroupAssociationArn = association.attrArn;
        this.firewallRuleGroupAssociationCreationTime = association.attrCreationTime;
        this.firewallRuleGroupAssociationCreatorRequestId = association.attrCreatorRequestId;
        this.firewallRuleGroupAssociationId = association.attrId;
        this.firewallRuleGroupAssociationManagedOwnerName = association.attrManagedOwnerName;
        this.firewallRuleGroupAssociationModificationTime = association.attrModificationTime;
        this.firewallRuleGroupAssociationStatus = association.attrStatus;
        this.firewallRuleGroupAssociationStatusMessage = association.attrStatusMessage;
    }
}
exports.FirewallRuleGroupAssociation = FirewallRuleGroupAssociation;
_a = JSII_RTTI_SYMBOL_1;
FirewallRuleGroupAssociation[_a] = { fqn: "@aws-cdk/aws-route53resolver.FirewallRuleGroupAssociation", version: "1.194.0" };
//# sourceMappingURL=data:application/json;base64,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