"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.InstanceTarget = exports.InstanceIdTarget = void 0;
const elbv2 = require("@aws-cdk/aws-elasticloadbalancingv2");
/**
 * An EC2 instance that is the target for load balancing
 *
 * If you register a target of this type, you are responsible for making
 * sure the load balancer's security group can connect to the instance.
 */
class InstanceIdTarget {
    /**
     * Create a new Instance target
     *
     * @param instanceId Instance ID of the instance to register to
     * @param port Override the default port for the target group
     */
    constructor(instanceId, port) {
        this.instanceId = instanceId;
        this.port = port;
    }
    /**
     * Register this instance target with a load balancer
     *
     * Don't call this, it is called automatically when you add the target to a
     * load balancer.
     */
    attachToApplicationTargetGroup(targetGroup) {
        return this.attach(targetGroup);
    }
    /**
     * Register this instance target with a load balancer
     *
     * Don't call this, it is called automatically when you add the target to a
     * load balancer.
     */
    attachToNetworkTargetGroup(targetGroup) {
        return this.attach(targetGroup);
    }
    attach(_targetGroup) {
        return {
            targetType: elbv2.TargetType.INSTANCE,
            targetJson: { id: this.instanceId, port: this.port },
        };
    }
}
exports.InstanceIdTarget = InstanceIdTarget;
class InstanceTarget extends InstanceIdTarget {
    /**
     * Create a new Instance target
     *
     * @param instance Instance to register to
     * @param port Override the default port for the target group
     */
    constructor(instance, port) {
        super(instance.instanceId, port);
    }
}
exports.InstanceTarget = InstanceTarget;
//# sourceMappingURL=data:application/json;base64,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