<div align="center">
  <img src="docs/_static/aglogowtext.png"><br>
</div>

-----------------

[![PyPI Latest Release](https://img.shields.io/pypi/v/alphagradient.svg)](https://pypi.org/project/pandas/)
![Tests](https://github.com/nathanheidacker/alphagradient/actions/workflows/tests.yml/badge.svg)
[![License](https://img.shields.io/pypi/l/alphagradient.svg)](https://github.com/nathanheidacker/alphagradient/blob/main/LICENSE)
[![Code style: black](https://img.shields.io/badge/code%20style-black-000000.svg)](https://github.com/psf/black)


## Documentation

For now, official documentation is hosted on [nathanheidacker.github.io](https://nathanheidacker.github.io)

## Introduction

**AlphaGradient** is a package for creating and backtesting financial algorithms in native python. AlphaGradient implements asset and portfolio-analagous datastructures that interact in intuitive ways, and provides a framework for developing algorithms that utilize these objects in highly parallelized backtests. AlphaGradient is built on top of the industry's most widely adopted libraries, and requires (comparatively) little technical knowhow and time investment to pick up.

To be able to use AlphaGradient effectively, you must know...
- basic finance
- **really** basic python

Where other libraries might require you to be a programmer first and and a certified quantitative financial analyst second, AlphaGradient is truly geared towards hobbyist algorithmic traders who want to play around with ideas for financial algorithms. Within minutes, you can have a fully backtestable algorithm using nothing but basic python.

AlphaGradient is to the algorithmic trader as console gaming is to the gamer; it gets the job done and comes at a bargain--batteries included. If you have even a passing interest in finance or algorithmic trading, this package makes it as easy as possible to get involved without having a background in computer science.

## Installation
The source code is currently hosted on GitHub at:
https://github.com/nathanheidacker/alphagradient

Binary installers for the latest released version are available at the [Python
Package Index (PyPI)](https://pypi.org/project/alphagradient)

```
# using pip
pip install alphagradient
```

## Dependencies
- [pandas](https://github.com/pandas-dev/pandas)
- [numpy](https://github.com/numpy/numpy)
- [aenum](https://github.com/ethanfurman/aenum)
- [yfinance](https://github.com/ranaroussi/yfinance)
- [tqdm](https://github.com/tqdm/tqdm)
- [pathos](https://github.com/uqfoundation/pathos)

## License
AlphaGradient is licensed under the [Apache License](LICENSE)

## About Me and Contact Info
Im a student from Northwestern University in Evanston Illinois studying cognitive science and artificial intelligence. I'm currently seeking employment. If you're interested in my work, feel free to contact me at 
[this email](nathanheidacker2022@u.northwestern.edu)
