"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.drawioStyleObjectToString = exports.DRAWIO_RESOURCE_STYLE_BASE = exports.DrawioAws4ParentShapes = void 0;
/*! Copyright [Amazon.com](http://amazon.com/), Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0 */
/*********************************************************************************************************************
 Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.

 Licensed under the Apache License, Version 2.0 (the "License").
 You may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 ******************************************************************************************************************** */
/** Draiwio aws4 parent shapes enum */
var DrawioAws4ParentShapes;
(function (DrawioAws4ParentShapes) {
    DrawioAws4ParentShapes["RESOURCE_ICON"] = "mxgraph.aws4.resourceIcon";
})(DrawioAws4ParentShapes = exports.DrawioAws4ParentShapes || (exports.DrawioAws4ParentShapes = {}));
/** Base drawio aws resource style */
exports.DRAWIO_RESOURCE_STYLE_BASE = {
    outlineConnect: 0,
    gradientDirection: "north",
    strokeColor: "#ffffff",
    dashed: 0,
    verticalLabelPosition: "bottom",
    verticalAlign: "top",
    align: "center",
    html: 1,
    fontSize: 12,
    fontStyle: 0,
    aspect: "fixed",
};
/** Convert drawio style object to style string */
function drawioStyleObjectToString(styleObject) {
    return Object.entries(styleObject)
        .map(([key, value]) => `${key}=${value};`)
        .join("");
}
exports.drawioStyleObjectToString = drawioStyleObjectToString;
//# sourceMappingURL=data:application/json;base64,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