"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.PRICING_SLUGS = exports.PRICING_MANIFEST = void 0;
// AUTO-GENERATED - DO NOT EDIT
/* eslint-disable */
exports.PRICING_MANIFEST = {
    "awsApplicationMigrationSvc": {
        "name": " AWS Application Migration Service",
        "serviceCode": "awsApplicationMigrationSvc",
        "description": "AWS Application Migration Service minimizes time-intensive, error-prone manual processes by automatically converting your source servers from physical, virtual, and cloud infrastructure to run natively on AWS. It further simplifies your migration by allowing you to use the same automated process for a wide range of applications.",
        "searchKeywords": [
            "Application Migration Service",
            "migrating applications",
            "migration",
            "SAP",
            "Oracle",
            "SQL Server",
            "CloudEndure Migration"
        ],
        "type": "AWSService",
        "regions": [
            "af-south-1",
            "ap-east-1",
            "ap-northeast-1",
            "ap-northeast-2",
            "ap-northeast-3",
            "ap-south-1",
            "ap-southeast-1",
            "ap-southeast-2",
            "ca-central-1",
            "eu-central-1",
            "eu-north-1",
            "eu-south-1",
            "eu-west-1",
            "eu-west-2",
            "eu-west-3",
            "me-south-1",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/application-migration-service/",
        "isActive": "true",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/awsApplicationMigrationSvc/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/awsApplicationMigrationSvc/en_US.json",
        "slug": "appmigrationsvc",
        "mvpSupport": false,
        "comparableTerms": [
            "applicationmigration",
            "applicationmigrationservice",
            "applicationmigrationsvc",
            "appmigration",
            "appmigrationsvc"
        ]
    },
    "activeCustomBatchTranslation": {
        "name": "Active Custom Batch Translation",
        "serviceCode": "activeCustomBatchTranslation",
        "description": "Amazon Translate is a neural machine translation service that delivers fast, high-quality, and affordable language translation. Neural machine translation is a form of language translation automation that uses deep learning models to deliver more accurate and more natural sounding translation than traditional statistical and rule-based translation algorithms.",
        "searchKeywords": [
            "NLP",
            "Natural language processing",
            "language transalation",
            "Text analytics",
            "Language translation",
            "Amazon translate",
            "Translate"
        ],
        "type": "AWSService",
        "regions": [
            "us-east-1",
            "eu-west-1",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/translate/",
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/activeCustomBatchTranslation/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/activeCustomBatchTranslation/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "activecustombatchtranslation"
        ],
        "parentServiceCode": "amazonTranslate"
    },
    "amazonApiGateway": {
        "name": "Amazon API Gateway",
        "serviceCode": "amazonApiGateway",
        "description": "Amazon API Gateway is a fully managed service that makes it easy for developers to create, publish, maintain, monitor, and secure APIs at any scale. APIs act as the front door for applications to access data, business logic, or functionality from your backend services.",
        "searchKeywords": [
            "API",
            "api",
            "Rest",
            "websocket",
            "messages"
        ],
        "type": "AWSService",
        "regions": [
            "us-gov-west-1",
            "us-gov-east-1",
            "af-south-1",
            "ap-east-1",
            "ap-south-1",
            "ap-northeast-2",
            "ap-northeast-3",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-southeast-3",
            "ap-northeast-1",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "eu-south-1",
            "eu-west-3",
            "eu-north-1",
            "me-south-1",
            "me-central-1",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/api-gateway/",
        "isActive": "true",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonApiGateway/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "slug": "APIGateway",
        "mvpSupport": false,
        "comparableTerms": [
            "apigateway"
        ]
    },
    "amazonAppFlow": {
        "name": "Amazon AppFlow",
        "serviceCode": "amazonAppFlow",
        "description": "Amazon AppFlow offers significant cost-savings advantage compared to building connectors in-house or using other application integration services. There are no upfront charges or fees to use AppFlow, and customers only pay for the number of flows they run and the volume of data processed.",
        "searchKeywords": [
            "appflow",
            "Amazon AppFlow",
            "App Flow",
            "AWS appflow"
        ],
        "type": "AWSService",
        "regions": [
            "ap-south-1",
            "af-south-1",
            "ap-northeast-2",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-northeast-1",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "eu-west-3",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/appflow/",
        "isActive": "true",
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonAppFlow/en_US.json",
        "c2e": false,
        "slug": "Appflow",
        "mvpSupport": false,
        "comparableTerms": [
            "appflow"
        ]
    },
    "amazonAppStream": {
        "name": "Amazon AppStream 2.0",
        "serviceCode": "amazonAppStream",
        "description": "Amazon AppStream 2.0 is a fully managed service that provides secure, reliable, and scalable access to applications and non-persistent desktops from any location.",
        "searchKeywords": [
            "streaming",
            "app"
        ],
        "type": "AWSService",
        "regions": [
            "us-east-1",
            "us-east-2",
            "ap-south-1",
            "us-west-2",
            "us-gov-west-1",
            "ap-southeast-2",
            "eu-west-1",
            "ap-northeast-2",
            "eu-central-1",
            "ap-northeast-1",
            "eu-west-2",
            "ap-southeast-1",
            "ca-central-1"
        ],
        "linkUrl": "https://aws.amazon.com/appstream2/",
        "isActive": "true",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonAppStream/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "bulkImportEnabled": false,
        "serviceDefinitionUrlPath": "/data/amazonAppStream/en_US.json",
        "slug": "AppStream",
        "mvpSupport": false,
        "comparableTerms": [
            "appstream",
            "appstream2",
            "appstream20"
        ]
    },
    "amazonAthena": {
        "name": "Amazon Athena",
        "serviceCode": "amazonAthena",
        "description": "Amazon Athena is an interactive query service that makes it easy to analyze data in Amazon S3 using standard SQL. Athena is serverless, so there is no infrastructure to manage, and you pay only for the queries that you run.",
        "searchKeywords": [
            "Analytics",
            "SQL",
            "query",
            "S3",
            "big data",
            "Presto",
            "serverless",
            "ad-hoc analysis",
            "log processing",
            "bigquery",
            "big query",
            "query S3 data",
            "spark",
            "spark session",
            "code execustion"
        ],
        "type": "AWSService",
        "regions": [
            "af-south-1",
            "ap-east-1",
            "ap-south-1",
            "ap-northeast-2",
            "ap-northeast-3",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-northeast-1",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "eu-west-3",
            "eu-north-1",
            "eu-south-1",
            "me-south-1",
            "us-gov-west-1",
            "us-gov-east-1",
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2",
            "sa-east-1"
        ],
        "linkUrl": "https://aws.amazon.com/athena/",
        "isActive": "true",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonAthena/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/amazonAthena/en_US.json",
        "slug": "Athena",
        "mvpSupport": false,
        "comparableTerms": [
            "athena"
        ]
    },
    "amazonAuroraMySQLCompatible": {
        "name": "Amazon Aurora MySQL-Compatible",
        "serviceCode": "amazonAuroraMySQLCompatible",
        "description": "Amazon Aurora MySQL Compatible relational database is built for the cloud, that combines  performance and availability of traditional enterprise databases with the simplicity and cost-effectiveness of open source databases.",
        "searchKeywords": [
            "Database",
            "Aurora",
            "MySQL",
            "MariaDB",
            "Postgres",
            "Oracle",
            "SQL Server",
            "Database",
            "PostgreSQL",
            "Microsoft SQL Server",
            "Relational Database Service",
            "Database",
            "database hosting",
            "hosted database",
            "Managed database"
        ],
        "type": "AWSService",
        "regions": [
            "af-south-1",
            "ap-east-1",
            "ap-northeast-1",
            "ap-northeast-2",
            "ap-northeast-3",
            "ap-south-1",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-southeast-3",
            "ca-central-1",
            "eu-central-1",
            "eu-north-1",
            "eu-south-1",
            "eu-west-1",
            "eu-west-2",
            "eu-west-3",
            "me-south-1",
            "me-central-1",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2",
            "us-gov-east-1",
            "us-gov-west-1"
        ],
        "linkUrl": "https://aws.amazon.com/rds/aurora/",
        "isActive": "true",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonAuroraMySQLCompatible/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "bulkImportEnabled": false,
        "serviceDefinitionUrlPath": "/data/amazonAuroraMySQLCompatible/en_US.json",
        "slug": "AuroraMySQL",
        "mvpSupport": false,
        "comparableTerms": [
            "auroramysql",
            "auroramysqlcompatible",
            "rdsaurora"
        ]
    },
    "amazonRDSAuroraPostgreSQLCompatibleDB": {
        "name": "Amazon Aurora PostgreSQL-Compatible DB",
        "serviceCode": "amazonRDSAuroraPostgreSQLCompatibleDB",
        "description": "Amazon Aurora is a MySQL and PostgreSQL-compatible relational database built for the cloud, that combines the performance and availability of traditional enterprise databases with the simplicity and cost-effectiveness of open source databases.",
        "searchKeywords": [
            "Database",
            "PostgreSQL",
            "Aurora",
            "database hosting",
            "hosted database",
            "Managed database"
        ],
        "type": "AWSService",
        "regions": [
            "af-south-1",
            "ap-east-1",
            "ap-northeast-1",
            "ap-northeast-2",
            "ap-northeast-3",
            "ap-south-1",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-southeast-3",
            "ca-central-1",
            "eu-central-1",
            "eu-north-1",
            "eu-south-1",
            "eu-west-1",
            "eu-west-2",
            "eu-west-3",
            "me-south-1",
            "me-central-1",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2",
            "us-gov-east-1",
            "us-gov-west-1"
        ],
        "linkUrl": "https://aws.amazon.com/aurora/",
        "isActive": "true",
        "hasDataTransfer": false,
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonRDSAuroraPostgreSQLCompatibleDB/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "bulkImportEnabled": false,
        "serviceDefinitionUrlPath": "/data/amazonRDSAuroraPostgreSQLCompatibleDB/en_US.json",
        "slug": "AuroraPostgreSQL",
        "mvpSupport": false,
        "comparableTerms": [
            "aurora",
            "aurorapostgresql",
            "aurorapostgresqlcompatibledb",
            "rdsaurorapostgresqlcompatibledb"
        ]
    },
    "amazonBraket": {
        "name": "Amazon Braket",
        "serviceCode": "amazonBraket",
        "description": "Amazon Braket is a fully managed quantum computing service that helps researchers and developers get started with the technology to accelerate research and discovery. Amazon Braket provides a development environment for you to explore and build quantum algorithms, test them on quantum circuit simulators, and run them on different quantum hardware technologies.",
        "searchKeywords": [
            "quantum",
            "compute",
            "computing",
            "simulators",
            "algorithms",
            "Sagemaker",
            "notebooks"
        ],
        "type": "AWSService",
        "regions": [
            "us-east-1",
            "us-west-1",
            "us-west-2",
            "eu-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/braket/",
        "isActive": "true",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonBraket/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "bulkImportEnabled": false,
        "serviceDefinitionUrlPath": "/data/amazonBraket/en_US.json",
        "slug": "Braket",
        "mvpSupport": false,
        "comparableTerms": [
            "braket"
        ]
    },
    "amazonCarrierIp": {
        "name": "Amazon Carrier IP",
        "serviceCode": "amazonCarrierIp",
        "description": "A Carrier IP address is the address that you assign to a network interface, which resides in a subnet in a Wavelength Zone (for example an EC2 instance)",
        "searchKeywords": [
            "Compute",
            "Carrier",
            "Elastic Compute Cloud",
            "spot instance",
            "load balancing",
            "elb",
            "elastic load balancer",
            "auto scaling",
            "auto scaling groups",
            "application load balancer",
            "ALB",
            "spot requests",
            "reserved instances",
            "scheduled instances",
            "dedicated hosts",
            "AMIs",
            "CIPs",
            "Bundle tasks",
            "Volumes",
            "Snapshots",
            "Images",
            "Elastic Block Store",
            "block storage",
            "Security groups",
            "Elastic IP",
            "placement groups",
            "key pairs",
            "network interfaces",
            "load balancers",
            "target groups",
            "auto scaler",
            "launch configurations",
            "EBS",
            "ASG",
            "commands",
            "command history",
            "managed instances",
            "activations"
        ],
        "type": "AWSService",
        "regions": [
            "ap-northeast-1-wl1-kix1",
            "ap-northeast-1-wl1-nrt1",
            "ap-northeast-2-wl1-cjj1",
            "ap-northeast-2-wl1-sel1",
            "ca-central-1-wl1-yto1",
            "eu-west-2-wl1-lon1",
            "eu-central-1-wl1-ber1",
            "eu-central-1-wl1-dtm1",
            "eu-central-1-wl1-muc1",
            "us-east-1-wl1",
            "us-east-1-wl1-atl1",
            "us-east-1-wl1-clt1",
            "us-east-1-wl1-chi1",
            "us-east-1-wl1-dfw1",
            "us-east-1-wl1-dtw1",
            "us-east-1-wl1-iah1",
            "us-east-1-wl1-mia1",
            "us-east-1-wl1-msp1",
            "us-east-1-wl1-bna1",
            "us-east-1-wl1-nyc1",
            "us-east-1-wl1-tpa1",
            "us-east-1-wl1-was1",
            "us-west-2-wl1-den1",
            "us-west-2-wl1-las1",
            "us-west-2-wl1-lax1",
            "us-west-2-wl1-phx1",
            "us-west-2-wl1-sea1",
            "us-west-2-wl1"
        ],
        "linkUrl": "https://aws.amazon.com/ec2/pricing/on-demand/",
        "isActive": "true",
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonCarrierIp/en_US.json",
        "c2e": false,
        "slug": "CarrierIP",
        "mvpSupport": false,
        "comparableTerms": [
            "carrierip"
        ]
    },
    "amazonChime": {
        "name": "Amazon Chime",
        "serviceCode": "amazonChime",
        "description": "Amazon Chime is a communications service that lets you meet, chat, and place business calls inside and outside your organization, all using a single application.",
        "searchKeywords": [
            "Chime",
            "Business Calling"
        ],
        "type": "AWSService",
        "regions": [],
        "linkUrl": "https://aws.amazon.com/chime/",
        "isActive": "true",
        "subType": "subServiceSelector",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonChime/en_US.json",
        "c2e": false,
        "templates": [
            "chimeCostAnalysis",
            "chimeBusinessCallingAnalysis"
        ],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/amazonChime/en_US.json",
        "slug": "Chime",
        "mvpSupport": false,
        "comparableTerms": [
            "chime"
        ]
    },
    "chimeBusinessCallingAnalysis": {
        "name": "Amazon Chime Business Calling analysis",
        "serviceCode": "chimeBusinessCallingAnalysis",
        "description": "Amazon Chime lets you meet, chat, and collaborate with the security of AWS. You can work seamlessly on your devices, and meet from your desk or on the go - ensuring you always stay connected.",
        "searchKeywords": [],
        "type": "AWSService",
        "regions": [
            "us-east-1"
        ],
        "linkUrl": "https://aws.amazon.com/chime/",
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/chimeBusinessCallingAnalysis/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/chimeBusinessCallingAnalysis/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "chimebusinesscallinganalysis"
        ],
        "parentServiceCode": "amazonChime"
    },
    "amazonChimeTCO": {
        "name": "Amazon Chime cost comparison tool",
        "serviceCode": "amazonChimeTCO",
        "description": "Amazon Chime lets you meet, chat, and collaborate with the security of AWS. You can work seamlessly on your devices, and meet from your desk or on the go - ensuring you always stay connected.",
        "searchKeywords": [],
        "type": "AWSService",
        "regions": [
            "us-east-1"
        ],
        "linkUrl": "https://aws.amazon.com/chime/",
        "isActive": "true",
        "subType": "TCOCalculator",
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonChimeTCO/en_US.json",
        "c2e": false,
        "comparableTerms": [
            "chimecostcomparisontool",
            "chimetco"
        ]
    },
    "chimeCostAnalysis": {
        "name": "Amazon Chime Meetings App",
        "serviceCode": "chimeCostAnalysis",
        "description": "Amazon Chime lets you meet, chat, and collaborate with the security of AWS. You can work seamlessly on your devices, and meet from your desk or on the go - ensuring you always stay connected.",
        "searchKeywords": [],
        "type": "AWSService",
        "regions": [
            "us-east-1"
        ],
        "linkUrl": "https://aws.amazon.com/chime/",
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/chimeCostAnalysis/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/chimeCostAnalysis/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "chimecostanalysis",
            "chimemeetingsapp"
        ],
        "parentServiceCode": "amazonChime"
    },
    "amazonChimeSdk": {
        "name": "Amazon Chime SDK",
        "serviceCode": "amazonChimeSdk",
        "description": "With the Amazon Chime SDK, builders can easily add real-time voice, video, and messaging powered by machine learning into their applications.",
        "searchKeywords": [
            "Chimesdk",
            "messaging",
            "SIP trunking",
            "webrtc media",
            "proxy phone session"
        ],
        "type": "AWSService",
        "regions": [],
        "linkUrl": "https://aws.amazon.com/chime/chime-sdk/",
        "isActive": "true",
        "subType": "subServiceSelector",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonChimeSdk/en_US.json",
        "c2e": false,
        "templates": [
            "webRtcMedia",
            "ptsnAudio",
            "sipTrunking",
            "chimeSdkMessaging",
            "proxyPhoneSession"
        ],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/amazonChimeSdk/en_US.json",
        "slug": "ChimeSDK",
        "mvpSupport": false,
        "comparableTerms": [
            "chimechimesdk",
            "chimesdk"
        ]
    },
    "amazonCloudFront": {
        "name": "Amazon CloudFront",
        "serviceCode": "amazonCloudFront",
        "description": "Amazon CloudFront is a fast content delivery network (CDN) service that securely delivers data, videos, applications, and APIs to customers globally with low latency, high transfer speeds, all within a developer-friendly environment.",
        "searchKeywords": [
            "cloudfront",
            "CDN"
        ],
        "type": "AWSService",
        "regions": [
            "ap-east-1",
            "ap-northeast-1",
            "ap-northeast-2",
            "ap-south-1",
            "ap-southeast-1",
            "ap-southeast-2",
            "ca-central-1",
            "eu-central-1",
            "eu-north-1",
            "eu-west-1",
            "eu-west-2",
            "eu-west-3",
            "me-south-1",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-gov-east-1",
            "us-gov-west-1",
            "us-west-1",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/cloudfront/",
        "isActive": "true",
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonCloudFront/en_US.json",
        "c2e": false,
        "slug": "CloudFront",
        "mvpSupport": false,
        "comparableTerms": [
            "cloudfront"
        ]
    },
    "amazonCloudWatch": {
        "name": "Amazon CloudWatch",
        "serviceCode": "amazonCloudWatch",
        "description": "Amazon CloudWatch is a monitoring and management service that provides data and actionable insights for AWS, hybrid, and on-premises applications and infrastructure resources.",
        "searchKeywords": [
            "Management Tools",
            "CW",
            "monitoring",
            "metrics",
            "graphs",
            "logs",
            "dashboard",
            "events",
            "alarms",
            "monitoring scripts",
            "management tools",
            "monitoring service",
            "network monitoring"
        ],
        "type": "AWSService",
        "regions": [
            "af-south-1",
            "ap-east-1",
            "ap-south-1",
            "ap-northeast-3",
            "ap-northeast-2",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-southeast-3",
            "ap-northeast-1",
            "us-gov-west-1",
            "us-gov-east-1",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "eu-west-3",
            "eu-north-1",
            "eu-south-1",
            "me-south-1",
            "me-central-1",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/cloudwatch/",
        "isActive": "true",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonCloudWatch/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/amazonCloudWatch/en_US.json",
        "slug": "CloudWatch",
        "mvpSupport": false,
        "comparableTerms": [
            "cloudwatch"
        ]
    },
    "amazonCodeGuru": {
        "name": "Amazon CodeGuru Reviewer",
        "serviceCode": "amazonCodeGuru",
        "description": "Amazon CodeGuru Reviewer is a service that uses program analysis and machine learning to detect potential defects that are difficult for developers to find and recommends fixes in your Java code.",
        "searchKeywords": [
            "CodeGuru",
            "Reviewer",
            "code reviews",
            "package scan",
            "pull request",
            "code analysis",
            "code quality"
        ],
        "type": "AWSService",
        "regions": [
            "ap-northeast-1",
            "ap-southeast-1",
            "ap-southeast-2",
            "eu-central-1",
            "eu-north-1",
            "eu-west-1",
            "eu-west-2",
            "us-east-1",
            "us-east-2",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/codeguru/",
        "isActive": "true",
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonCodeGuru/en_US.json",
        "c2e": false,
        "slug": "CodeGuruReviewer",
        "comparableTerms": [
            "codeguru",
            "codegurureviewer"
        ]
    },
    "codeGuruReviewer": {
        "name": "Amazon CodeGuru Reviewer Test",
        "serviceCode": "codeGuruReviewer",
        "description": "Amazon CodeGuru Reviewer is a service that uses program analysis and machine learning to detect potential defects that are difficult for developers to find and recommends fixes in your Java code.",
        "searchKeywords": [
            "CodeGuru",
            "Reviewer",
            "code reviews",
            "package scan",
            "pull request",
            "code analysis",
            "code quality"
        ],
        "type": "AWSService",
        "regions": [
            "us-east-1",
            "us-east-2",
            "us-west-2",
            "eu-west-1",
            "ap-southeast-2"
        ],
        "linkUrl": "https://docs.aws.amazon.com/codeguru/index.html",
        "isActive": "false",
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/codeGuruReviewer/en_US.json",
        "c2e": false,
        "slug": "CodeGuruReviewerv2",
        "comparableTerms": [
            "codeguru",
            "codegurureviewer",
            "codegurureviewertest"
        ]
    },
    "amazonCognito": {
        "name": "Amazon Cognito",
        "serviceCode": "amazonCognito",
        "description": "Amazon Cognito lets you add user sign-up, sign-in, and access control to your web and mobile apps quickly and easily. Amazon Cognito scales to millions of users and supports sign-in with social identity providers, such as Facebook, Google, and Amazon, and enterprise identity providers via SAML 2.0.",
        "searchKeywords": [
            "apps",
            "security",
            "access",
            "control",
            "cognito",
            "MAU",
            "SMAL",
            "OIDC"
        ],
        "type": "AWSService",
        "regions": [
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2",
            "ap-south-1",
            "ap-northeast-2",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-northeast-1",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "eu-west-3",
            "me-south-1",
            "eu-north-1",
            "sa-east-1",
            "us-gov-west-1"
        ],
        "linkUrl": "https://aws.amazon.com/cognito/",
        "isActive": "true",
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonCognito/en_US.json",
        "c2e": false,
        "slug": "Cognito",
        "mvpSupport": false,
        "comparableTerms": [
            "cognito"
        ]
    },
    "amazonComprehend": {
        "name": "Amazon Comprehend",
        "serviceCode": "amazonComprehend",
        "description": "With Amazon Comprehend, you only pay for what you use. You are charged based on the amount of text processed on a monthly basis. Amazon Comprehend provides natural language processing, topic modeling, and Custom Classification capabilities, enabling a broad range of applications that can analyze text.",
        "searchKeywords": [
            "Comprehend",
            "NLP",
            "Natural language processing",
            "Sentiment analysis",
            "Text analytics",
            "Entity extraction",
            "Named entity recognition",
            "NER",
            "Key phrase extraction",
            "Topic modeling",
            "Unsupervised clustering",
            "Supervised machine learning",
            "Custom entity recognition",
            "Custom classification",
            "Document classifier",
            "Personally identifiable information",
            "PII",
            "Redaction",
            "Language detection",
            "Free form text analytics"
        ],
        "type": "AWSService",
        "regions": [],
        "linkUrl": "https://aws.amazon.com/comprehend",
        "isActive": "true",
        "subType": "subServiceSelector",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonComprehend/en_US.json",
        "c2e": false,
        "templates": [
            "piiDetection",
            "containsPii",
            "entityRecognition",
            "sentimentAnalysis",
            "targetedSentiment",
            "comprehendCustomClassification",
            "comprehendCustomEntities",
            "keyPhraseExtraction",
            "languageDetection",
            "syntaxAnalysis",
            "comprehendTopicModeling",
            "eventDetectionPerEventType"
        ],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/amazonComprehend/en_US.json",
        "slug": "Comprehend",
        "mvpSupport": false,
        "comparableTerms": [
            "comprehend"
        ]
    },
    "amazonComprehendMedical": {
        "name": "Amazon Comprehend Medical",
        "serviceCode": "amazonComprehendMedical",
        "description": "Amazon Comprehend Medical is a HIPAA-eligible natural language processing (NLP) service that uses machine learning to extract health data from medical text–no machine learning experience is required.",
        "searchKeywords": [
            "Comprehend Medical",
            "NLP",
            "Natural language processing"
        ],
        "type": "AWSService",
        "regions": [],
        "linkUrl": "https://aws.amazon.com/comprehend/medical/",
        "isActive": "true",
        "subType": "subServiceSelector",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonComprehendMedical/en_US.json",
        "c2e": false,
        "templates": [
            "medicalNamedEntityAndRelationshipExtractionNeReApi",
            "medicalProtectedHealthInformationDataExtractionAndIdentificationPhIdApi",
            "medicalIcd10CmOntologyLinkingApi",
            "medicalSystematizedNomenclatureOfMedicineClinicalTermsSnomedCtApi",
            "medicalRxNormOntologyLinkingApi"
        ],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/amazonComprehendMedical/en_US.json",
        "slug": "ComprehendMedical",
        "mvpSupport": false,
        "comparableTerms": [
            "comprehendmedical"
        ]
    },
    "amazonDetective": {
        "name": "Amazon Detective",
        "serviceCode": "amazonDetective",
        "description": "Amazon Detective makes it easy to analyze, investigate, and quickly identify the root cause of potential security issues or suspicious activities. Amazon Detective automatically collects log data from your AWS resources and uses machine learning, statistical analysis, and graph theory to build a linked set of data that enables you to easily conduct faster and more efficient security investigations.",
        "searchKeywords": [
            "detective",
            "amazon Detective"
        ],
        "type": "AWSService",
        "regions": [
            "af-south-1",
            "ap-east-1",
            "ap-northeast-1",
            "ap-northeast-2",
            "ap-south-1",
            "ap-southeast-1",
            "ap-southeast-2",
            "ca-central-1",
            "eu-central-1",
            "eu-north-1",
            "eu-south-1",
            "eu-west-1",
            "eu-west-2",
            "eu-west-3",
            "me-south-1",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-gov-east-1",
            "us-gov-west-1",
            "us-west-1",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/detective/",
        "isActive": "true",
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonDetective/en_US.json",
        "c2e": false,
        "slug": "detective",
        "mvpSupport": false,
        "comparableTerms": [
            "detective"
        ]
    },
    "amazonDevOpsGuru": {
        "name": "Amazon DevOps Guru",
        "serviceCode": "amazonDevOpsGuru",
        "description": "Amazon DevOps Guru is a Machine Learning (ML) powered service that makes it easy to improve an application’s operational performance and availability. DevOps Guru detects behaviors that deviate from normal operating patterns so you can identify operational issues long before they impact your customers.",
        "searchKeywords": [
            "devops",
            "guru",
            "devopsguru"
        ],
        "type": "AWSService",
        "regions": [
            "us-east-1"
        ],
        "linkUrl": "https://aws.amazon.com/devops-guru/",
        "isActive": "true",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonDevOpsGuru/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": true,
        "serviceDefinitionUrlPath": "/data/amazonDevOpsGuru/en_US.json",
        "slug": "DevOpsGuru",
        "mvpSupport": false,
        "comparableTerms": [
            "devopsguru"
        ]
    },
    "amazonDocumentDB": {
        "name": "Amazon DocumentDB (with MongoDB compatibility)",
        "serviceCode": "amazonDocumentDB",
        "description": "Amazon DocumentDB (with MongoDB compatibility) is a fast, scalable, highly available, and fully managed document database service that supports MongoDB workloads.",
        "searchKeywords": [
            "docdb",
            "MongoDB",
            "mongodb",
            "document database",
            "DocumentDB"
        ],
        "type": "AWSService",
        "regions": [
            "ap-south-1",
            "ap-northeast-2",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-northeast-1",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "eu-west-3",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-west-2",
            "us-gov-west-1"
        ],
        "linkUrl": "https://aws.amazon.com/documentdb/",
        "isActive": "true",
        "hasDataTransfer": true,
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonDocumentDB/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/amazonDocumentDB/en_US.json",
        "slug": "DocumentDB",
        "mvpSupport": false,
        "comparableTerms": [
            "documentdb",
            "documentdbwithmongodbcompatibility",
            "withmongodbcompatibility"
        ]
    },
    "amazonDynamoDb": {
        "name": "Amazon DynamoDB",
        "serviceCode": "amazonDynamoDb",
        "description": "Amazon DynamoDB is a key-value and document database that delivers single-digit millisecond performance at any scale. It's a fully managed, multiregion, multimaster, durable database with built-in security, backup and restore, and in-memory caching for internet-scale applications.",
        "searchKeywords": [
            "DynamoDB",
            "Serverless",
            "key-value",
            "Database",
            "DDB",
            "NoSQL",
            "SQL",
            "Table",
            "nosql databases",
            "database schema",
            "database software",
            "cloud database",
            "document database",
            "key value store",
            "database as a service",
            "database scheme",
            "nosql hosting",
            "hosted nosql",
            "data store",
            "unstructured database",
            "Accelerator",
            "DAX"
        ],
        "type": "AWSService",
        "regions": [],
        "linkUrl": "https://aws.amazon.com/dynamodb/",
        "isActive": "true",
        "subType": "subServiceSelector",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonDynamoDb/en_US.json",
        "c2e": false,
        "templates": [
            "dynamoDbOnDemand",
            "amazonDynamoDbProvisionedThroughputCapacity",
            "amazonDynamoDbDaxClusters",
            "amazonDynamoDbStreams",
            "dynamoDbBackup",
            "dynamoDbChangeDateCapture",
            "dynamoDbDataExportToAmazonS3",
            "dynamoDbDataImportFromAmazonS3"
        ],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/amazonDynamoDb/en_US.json",
        "slug": "DynamoDB",
        "mvpSupport": false,
        "comparableTerms": [
            "dynamodb"
        ]
    },
    "eC2Next": {
        "name": "Amazon EC2",
        "serviceCode": "eC2Next",
        "description": "Amazon EC2 offers the broadest and deepest compute platform with choice of processor, storage, networking, operating system, and purchase model.",
        "searchKeywords": [],
        "type": "AWSService",
        "regions": [
            "af-south-1",
            "ap-east-1",
            "ap-northeast-1",
            "ap-northeast-1-wl1-nrt1",
            "ap-northeast-2",
            "ap-northeast-2-wl1-cjj1",
            "ap-northeast-2-wl1-sel1",
            "ap-northeast-3",
            "ap-south-1",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-southeast-3",
            "eu-central-1-wl1-dtm1",
            "eu-central-1-wl1-ber1",
            "eu-central-1-wl1-muc1",
            "ca-central-1",
            "ca-central-1-wl1-yto1",
            "eu-central-1",
            "eu-north-1",
            "eu-south-1",
            "eu-west-1",
            "eu-west-2",
            "eu-west-2-wl1-lon1",
            "eu-west-3",
            "me-south-1",
            "me-central-1",
            "sa-east-1",
            "us-east-1",
            "us-east-1-atl-1",
            "us-east-1-bos-1",
            "us-east-1-chi-1",
            "us-east-1-dfw-1",
            "us-west-2-den-1",
            "us-east-1-iah-1",
            "us-east-1-mci-1",
            "us-east-1-mia-1",
            "us-east-1-msp-1",
            "us-east-1-nyc-1",
            "us-east-1-phl-1",
            "us-east-2",
            "us-gov-east-1",
            "us-gov-west-1",
            "us-west-1",
            "us-west-2",
            "us-west-2-las-1",
            "us-west-2-lax-1",
            "us-west-2-phx-1",
            "us-west-2-pdx-1",
            "us-west-2-sea-1",
            "us-east-1-wl1",
            "us-east-1-wl1-was1",
            "us-west-2-wl1",
            "us-west-2-wl1-las1",
            "us-west-2-wl1-lax1",
            "us-east-1-wl1-atl1",
            "us-east-1-wl1-chi1",
            "us-east-1-wl1-dfw1",
            "us-east-1-wl1-iah1",
            "us-east-1-wl1-mia1",
            "us-east-1-wl1-nyc1",
            "us-east-1-wl1-clt1",
            "us-east-1-wl1-dtw1",
            "us-east-1-wl1-msp1",
            "us-east-1-wl1-bna1",
            "us-east-1-wl1-tpa1",
            "us-west-2-wl1-den1",
            "us-west-2-wl1-phx1",
            "us-west-2-wl1-sea1"
        ],
        "linkUrl": "https://aws.amazon.com/ec2/",
        "isActive": "false",
        "hasDataTransfer": true,
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/eC2Next/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/eC2Next/en_US.json",
        "slug": "EC2",
        "mvpSupport": false,
        "comparableTerms": [
            "ec2",
            "ec2next"
        ]
    },
    "ec2Enhancement": {
        "name": "Amazon EC2 ",
        "serviceCode": "ec2Enhancement",
        "description": "Amazon EC2 provides a wide selection of instance types optimized to fit different use cases. Instance types comprise varying combinations of CPU, memory, storage, and networking capacity and give you the flexibility to choose the appropriate mix of resources for your applications.",
        "searchKeywords": [
            "EC2 Dedicated Hosts",
            "Dedicated Hosts",
            "EC2"
        ],
        "type": "AWSService",
        "regions": [
            "af-south-1",
            "ap-east-1"
        ],
        "linkUrl": "https://aws.amazon.com/ec2/",
        "isActive": "true",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/ec2Enhancement/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "bulkImportEnabled": [
            {
                "label": "EC2 Instances",
                "filename": "Amazon_EC2_Instances_BulkUpload_Template_Commercial.xlsx"
            },
            {
                "label": "EC2 Dedicated Hosts",
                "filename": "Amazon_EC2_DedicatedHosts_BulkUpload_Template_Commercial.xlsx"
            }
        ],
        "serviceDefinitionUrlPath": "/data/ec2Enhancement/en_US.json",
        "slug": "ec2-enhancement",
        "mvpSupport": false,
        "comparableTerms": [
            "ec2",
            "ec2enhancement"
        ]
    },
    "amazonEc2DedicatedHosts": {
        "name": "Amazon EC2 Dedicated Hosts",
        "serviceCode": "amazonEc2DedicatedHosts",
        "description": "Amazon EC2 Dedicated Hosts allow you to use your eligible software licenses on Amazon EC2, so that you get the flexibility and cost effectiveness of using your own licenses, but with the resiliency, simplicity and elasticity of AWS. Includes support for EC2 High Memory and EC2 Mac instances.",
        "searchKeywords": [
            "Mac",
            "High memory"
        ],
        "type": "AWSService",
        "regions": [
            "us-west-2",
            "us-west-2-lax-1",
            "us-west-1",
            "us-east-1",
            "us-east-2",
            "sa-east-1",
            "me-south-1",
            "me-central-1",
            "af-south-1",
            "eu-north-1",
            "eu-west-1",
            "eu-west-2",
            "eu-west-3",
            "eu-south-1",
            "eu-central-1",
            "ca-central-1",
            "us-gov-east-1",
            "us-gov-west-1",
            "ap-northeast-1",
            "ap-northeast-2",
            "ap-northeast-3",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-southeast-3",
            "ap-south-1",
            "ap-east-1"
        ],
        "linkUrl": "https://aws.amazon.com/ec2/dedicated-hosts",
        "isActive": "false",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonEc2DedicatedHosts/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "bulkImportEnabled": [],
        "serviceDefinitionUrlPath": "/data/amazonEc2DedicatedHosts/en_US.json",
        "slug": "EC2DedicatedHosts",
        "mvpSupport": false,
        "comparableTerms": [
            "ec2dedicatedhosts"
        ]
    },
    "awsEks": {
        "name": "Amazon EKS",
        "serviceCode": "awsEks",
        "description": "Amazon Elastic Kubernetes Service (Amazon EKS) is a fully managed Kubernetes service. Customers such as Intel, Snap, Intuit, GoDaddy, and Autodesk trust EKS to run their most sensitive and mission critical applications because of its security, reliability, and scalability..",
        "searchKeywords": [
            "eks",
            "elastic",
            "kubernetes"
        ],
        "type": "AWSService",
        "regions": [
            "us-gov-west-1",
            "us-gov-east-1",
            "af-south-1",
            "ap-east-1",
            "ap-south-1",
            "ap-northeast-2",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-southeast-3",
            "ap-northeast-1",
            "ap-northeast-3",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "eu-south-1",
            "eu-west-3",
            "eu-north-1",
            "me-south-1",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/eks/",
        "isActive": "true",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/awsEks/en_US.json",
        "c2e": false,
        "slug": "EKS",
        "mvpSupport": false,
        "comparableTerms": [
            "eks"
        ]
    },
    "amazonElasticBlockStore": {
        "name": "Amazon Elastic Block Store (EBS)",
        "serviceCode": "amazonElasticBlockStore",
        "description": "Amazon Elastic Block Storage (EBS) allows you to create persistent block storage volumes and attach them to Amazon EC2 instances.",
        "searchKeywords": [],
        "type": "AWSService",
        "regions": [
            "af-south-1",
            "ap-east-1",
            "ap-northeast-1",
            "ap-northeast-1-wl1-nrt1",
            "ap-northeast-2",
            "ap-northeast-2-wl1-cjj1",
            "ap-northeast-2-wl1-sel1",
            "ap-northeast-3",
            "ap-south-1",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-southeast-3",
            "ca-central-1",
            "ca-central-1-wl1-yto1",
            "eu-central-1",
            "eu-north-1",
            "eu-south-1",
            "eu-west-1",
            "eu-west-2",
            "eu-west-2-wl1-lon1",
            "eu-central-1-wl1-dtm1",
            "eu-central-1-wl1-ber1",
            "eu-central-1-wl1-muc1",
            "eu-west-3",
            "me-south-1",
            "me-central-1",
            "sa-east-1",
            "us-east-1",
            "us-east-1-atl-1",
            "us-east-1-bos-1",
            "us-east-1-chi-1",
            "us-east-1-dfw-1",
            "us-west-2-den-1",
            "us-east-1-iah-1",
            "us-east-1-mci-1",
            "us-east-1-mia-1",
            "us-east-1-msp-1",
            "us-east-1-nyc-1",
            "us-east-1-phl-1",
            "us-east-2",
            "us-gov-east-1",
            "us-gov-west-1",
            "us-west-1",
            "us-west-2",
            "us-west-2-las-1",
            "us-west-2-lax-1",
            "us-west-2-phx-1",
            "us-west-2-pdx-1",
            "us-west-2-sea-1",
            "us-east-1-wl1",
            "us-east-1-wl1-atl1",
            "us-east-1-wl1-chi1",
            "us-east-1-wl1-dfw1",
            "us-east-1-wl1-iah1",
            "us-east-1-wl1-mia1",
            "us-east-1-wl1-nyc1",
            "us-east-1-wl1-clt1",
            "us-east-1-wl1-dtw1",
            "us-east-1-wl1-msp1",
            "us-east-1-wl1-was1",
            "us-east-1-wl1-tpa1",
            "us-east-1-wl1-bna1",
            "us-west-2-wl1",
            "us-west-2-wl1-den1",
            "us-west-2-wl1-las1",
            "us-west-2-wl1-lax1",
            "us-west-2-wl1-phx1",
            "us-west-2-wl1-sea1"
        ],
        "linkUrl": "https://aws.amazon.com/ebs/",
        "isActive": "true",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonElasticBlockStore/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "bulkImportEnabled": [
            {
                "label": "Elastic Block Store (EBS)",
                "filename": "Amazon_Elastic_Block_Store_EBS_BulkUpload_Template_Commercial.xlsx"
            }
        ],
        "serviceDefinitionUrlPath": "/data/amazonElasticBlockStore/en_US.json",
        "slug": "EBS",
        "mvpSupport": false,
        "comparableTerms": [
            "ebs",
            "elasticblockstore",
            "elasticblockstoreebs"
        ]
    },
    "amazonElasticContainerRegistry": {
        "name": "Amazon Elastic Container Registry",
        "serviceCode": "amazonElasticContainerRegistry",
        "description": "Amazon Elastic Container Registry (ECR) is a fully-managed Docker container registry that makes it easy for developers to store, manage, and deploy Docker container images. Amazon ECR eliminates the need to operate your own container repositories or worry about scaling the underlying infrastructure. With Amazon ECR, there are no upfront fees or commitments. You pay only for the amount of data you store in your repositories and data transferred to the Internet.",
        "searchKeywords": [
            "ECR",
            "ecr",
            "Elastic Container Registry",
            "Amazon ECR",
            "container registry",
            "container",
            "registry"
        ],
        "type": "AWSService",
        "regions": [
            "us-gov-west-1",
            "us-gov-east-1",
            "af-south-1",
            "ap-east-1",
            "ap-south-1",
            "ap-northeast-2",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-southeast-3",
            "ap-northeast-1",
            "ap-northeast-3",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "eu-south-1",
            "eu-west-3",
            "eu-north-1",
            "me-south-1",
            "me-central-1",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/ecr/",
        "isActive": "true",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonElasticContainerRegistry/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "slug": "ECR",
        "mvpSupport": false,
        "comparableTerms": [
            "ecr",
            "elasticcontainerregistry"
        ]
    },
    "amazonEFS": {
        "name": "Amazon Elastic File System (EFS)",
        "serviceCode": "amazonEFS",
        "description": "Amazon Elastic File System (EFS) provides a simple, serverless, set-and-forget elastic file system for use with AWS Cloud services and on-premises resources.",
        "searchKeywords": [
            "Storage",
            "Elastic file system",
            "elastic file service",
            "cloud file system",
            "cloud based file",
            "system",
            "file system",
            "NFS",
            "network file system",
            "fully managed file system",
            "NAS",
            "managed file system",
            "network attached storage",
            "network storage",
            "SAN",
            "storage area network",
            "cloud storage",
            "shared",
            "shared file system",
            "RAID",
            "cloud file storage",
            "file system storage",
            "file management"
        ],
        "type": "AWSService",
        "regions": [
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2",
            "af-south-1",
            "ap-east-1",
            "ap-south-1",
            "ap-northeast-2",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-southeast-3",
            "ap-northeast-1",
            "ap-northeast-3",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "eu-west-3",
            "eu-north-1",
            "eu-south-1",
            "me-south-1",
            "sa-east-1",
            "us-gov-west-1",
            "us-gov-east-1"
        ],
        "linkUrl": "https://aws.amazon.com/efs/",
        "isActive": "true",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonEFS/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/amazonEFS/en_US.json",
        "slug": "EFS",
        "mvpSupport": false,
        "comparableTerms": [
            "efs",
            "elasticfilesystemefs"
        ]
    },
    "amazonElasticGraphics": {
        "name": "Amazon Elastic Graphics",
        "serviceCode": "amazonElasticGraphics",
        "description": "Amazon Elastic Graphics allows you to easily attach low-cost graphics acceleration to a wide range of EC2 instances over the network.",
        "searchKeywords": [
            "Compute",
            "Elastic Compute Cloud",
            "spot instance",
            "load balancing",
            "elb",
            "elastic load balancer",
            "auto scaling",
            "auto scaling groups",
            "application load balancer",
            "ALB",
            "spot requests",
            "reserved instances",
            "scheduled instances",
            "dedicated hosts",
            "AMIs",
            "Bundle tasks",
            "Volumes",
            "Snapshots",
            "Images",
            "Elastic Block Store",
            "block storage",
            "Security groups",
            "Elastic IP",
            "placement groups",
            "key pairs",
            "network interfaces",
            "load balancers",
            "target groups",
            "auto scaler",
            "launch configurations",
            "EBS",
            "ASG",
            "commands",
            "Elastic Graphics",
            "command history",
            "managed instances",
            "activations"
        ],
        "type": "AWSService",
        "regions": [
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-northeast-1",
            "eu-central-1",
            "eu-west-1",
            "us-east-1",
            "us-east-2",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/ec2/elastic-graphics/",
        "isActive": "true",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonElasticGraphics/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "slug": "ElasticGraphics",
        "mvpSupport": false,
        "comparableTerms": [
            "ec2elasticgraphics",
            "elasticgraphics"
        ]
    },
    "amazonElasticIP": {
        "name": "Amazon Elastic IP",
        "serviceCode": "amazonElasticIP",
        "description": "An Elastic IP address is a static IPv4 address designed for dynamic cloud computing. An Elastic IP address is associated with your AWS account. With an Elastic IP address, you can mask the failure of an instance or software by rapidly remapping the address to another instance in your account.",
        "searchKeywords": [
            "Compute",
            "Elastic Compute Cloud",
            "spot instance",
            "load balancing",
            "elb",
            "elastic load balancer",
            "auto scaling",
            "auto scaling groups",
            "application load balancer",
            "ALB",
            "spot requests",
            "reserved instances",
            "scheduled instances",
            "dedicated hosts",
            "AMIs",
            "Bundle tasks",
            "Volumes",
            "Snapshots",
            "Images",
            "Elastic Block Store",
            "block storage",
            "Security groups",
            "Elastic IP",
            "placement groups",
            "key pairs",
            "network interfaces",
            "load balancers",
            "target groups",
            "auto scaler",
            "launch configurations",
            "EBS",
            "ASG",
            "commands",
            "command history",
            "managed instances",
            "activations"
        ],
        "type": "AWSService",
        "regions": [
            "ap-east-1",
            "ap-south-1",
            "ap-northeast-2",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-northeast-1",
            "us-gov-west-1",
            "us-gov-east-1",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "eu-west-3",
            "eu-north-1",
            "me-south-1",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/ec2/pricing/on-demand/",
        "isActive": "true",
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonElasticIP/en_US.json",
        "c2e": false,
        "slug": "ElasticIP",
        "comparableTerms": [
            "elasticip"
        ]
    },
    "amazonElasticTranscoder": {
        "name": "Amazon Elastic Transcoder",
        "serviceCode": "amazonElasticTranscoder",
        "description": "Amazon Elastic Transcoder is media transcoding in the cloud. It is designed to be a highly scalable, easy to use and a cost effective way for developers and businesses to convert (or “transcode”) media files from their source format into versions that will playback on devices like smartphones, tablets and PCs.",
        "searchKeywords": [],
        "type": "AWSService",
        "regions": [
            "ap-northeast-1",
            "ap-south-1",
            "ap-southeast-1",
            "ap-southeast-2",
            "eu-west-1",
            "us-east-1",
            "us-west-1",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/elastictranscoder/",
        "isActive": "true",
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonElasticTranscoder/en_US.json",
        "c2e": false,
        "slug": "ElasticTranscoder",
        "comparableTerms": [
            "elastictranscoder"
        ]
    },
    "amazonElastiCache": {
        "name": "Amazon ElastiCache",
        "serviceCode": "amazonElastiCache",
        "description": "Amazon ElastiCache offers fully managed Redis and Memcached. Seamlessly deploy, run, and scale popular open source compatible in-memory data stores. Build data-intensive apps or improve the performance of your existing apps by retrieving data from high throughput and low latency in-memory data stores.",
        "searchKeywords": [
            "Database",
            "Database",
            "Cache",
            "Memcached",
            "Redis",
            "Caching",
            "in memory data store",
            "in memory caching",
            "auto discovery",
            "elasticache cluster",
            "replication",
            "adtech",
            "gaming",
            "media sharing",
            "Q&A",
            "social networking"
        ],
        "type": "AWSService",
        "regions": [
            "af-south-1",
            "ap-east-1",
            "ap-south-1",
            "ap-northeast-3",
            "ap-northeast-2",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-southeast-3",
            "ap-northeast-1",
            "us-gov-west-1",
            "us-gov-east-1",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "eu-west-3",
            "eu-north-1",
            "eu-south-1",
            "me-south-1",
            "me-central-1",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/elasticache/",
        "isActive": "true",
        "hasDataTransfer": true,
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonElastiCache/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/amazonElastiCache/en_US.json",
        "slug": "ElastiCache",
        "mvpSupport": false,
        "comparableTerms": [
            "elasticache"
        ]
    },
    "amazonEMR": {
        "name": "Amazon EMR",
        "serviceCode": "amazonEMR",
        "description": "Amazon EMR is the industry-leading cloud big data platform for processing vast amounts of data using open source tools such as Apache Spark, Apache Hive, Apache HBase, Apache Flink, Apache Hudi, and Presto. Amazon EMR makes it easy to set up, operate, and scale your big data environments by automating time-consuming tasks like provisioning capacity and tuning clusters. With EMR you can run petabyte-scale analysis at less than half of the cost of traditional on-premises solutions and over 3x faster than standard Apache Spark. You can run workloads on Amazon EC2 instances, on Amazon Elastic Kubernetes Service (EKS) clusters, or on-premises using EMR on AWS Outposts.",
        "searchKeywords": [
            "EMR",
            "elastic map reduce",
            "map reduce",
            "spark",
            "hadoop",
            "hbase",
            "hive",
            "hudi",
            "presto",
            "notebooks",
            "flink",
            "hue"
        ],
        "type": "AWSService",
        "regions": [],
        "linkUrl": "https://aws.amazon.com/emr/",
        "isActive": "true",
        "subType": "subServiceSelector",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonEMR/en_US.json",
        "c2e": false,
        "templates": [
            "amazonEmrMasterNode",
            "amazonEmrCoreNode",
            "amazonEmrTaskNode",
            "amazonEmrOnEks",
            "amazonEmrServerless"
        ],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/amazonEMR/en_US.json",
        "slug": "EMR",
        "mvpSupport": false,
        "comparableTerms": [
            "emr"
        ]
    },
    "amazonEmrCoreNode": {
        "name": "Amazon EMR core node on EC2",
        "serviceCode": "amazonEmrCoreNode",
        "description": "",
        "searchKeywords": [],
        "type": "AWSService",
        "regions": [
            "af-south-1",
            "ap-east-1",
            "ap-south-1",
            "ap-northeast-3",
            "ap-northeast-2",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-southeast-3",
            "ap-northeast-1",
            "us-gov-east-1",
            "us-gov-west-1",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "eu-west-3",
            "eu-south-1",
            "eu-north-1",
            "me-south-1",
            "me-central-1",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2",
            "us-west-2-lax-1"
        ],
        "linkUrl": "https://aws.amazon.com/emr/",
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonEmrCoreNode/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/amazonEmrCoreNode/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "emrcorenode",
            "emrcorenodeec2"
        ],
        "parentServiceCode": "amazonEMR"
    },
    "amazonEmrMasterNode": {
        "name": "Amazon EMR master node on EC2",
        "serviceCode": "amazonEmrMasterNode",
        "description": "",
        "searchKeywords": [],
        "type": "AWSService",
        "regions": [
            "af-south-1",
            "ap-east-1",
            "ap-south-1",
            "ap-northeast-3",
            "ap-northeast-2",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-southeast-3",
            "ap-northeast-1",
            "us-gov-east-1",
            "us-gov-west-1",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "eu-west-3",
            "eu-south-1",
            "eu-north-1",
            "me-south-1",
            "me-central-1",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2",
            "us-west-2-lax-1"
        ],
        "linkUrl": "https://aws.amazon.com/emr/",
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonEmrMasterNode/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/amazonEmrMasterNode/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "emrmasternode",
            "emrmasternodeec2"
        ],
        "parentServiceCode": "amazonEMR"
    },
    "amazonEmrOnEks": {
        "name": "Amazon EMR on EKS",
        "serviceCode": "amazonEmrOnEks",
        "description": "",
        "searchKeywords": [],
        "type": "AWSService",
        "regions": [
            "ap-south-1",
            "ap-northeast-2",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-northeast-1",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "eu-west-3",
            "eu-north-1",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/emr/",
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonEmrOnEks/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/amazonEmrOnEks/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "emreks",
            "emroneks"
        ],
        "parentServiceCode": "amazonEMR"
    },
    "amazonEmrServerless": {
        "name": "Amazon EMR Serverless",
        "serviceCode": "amazonEmrServerless",
        "description": "",
        "searchKeywords": [],
        "type": "AWSService",
        "regions": [
            "ap-northeast-1",
            "eu-west-1",
            "us-east-1",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/emr/",
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonEmrServerless/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "bulkImportEnabled": false,
        "serviceDefinitionUrlPath": "/data/amazonEmrServerless/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "emrserverless"
        ],
        "parentServiceCode": "amazonEMR"
    },
    "amazonEmrTaskNode": {
        "name": "Amazon EMR task node on EC2",
        "serviceCode": "amazonEmrTaskNode",
        "description": "",
        "searchKeywords": [],
        "type": "AWSService",
        "regions": [
            "af-south-1",
            "ap-east-1",
            "ap-south-1",
            "ap-northeast-3",
            "ap-northeast-2",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-southeast-3",
            "ap-northeast-1",
            "us-gov-east-1",
            "us-gov-west-1",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "eu-west-3",
            "eu-south-1",
            "eu-north-1",
            "me-south-1",
            "me-central-1",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2",
            "us-west-2-lax-1"
        ],
        "linkUrl": "https://aws.amazon.com/emr/",
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonEmrTaskNode/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/amazonEmrTaskNode/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "emrtasknode",
            "emrtasknodeec2"
        ],
        "parentServiceCode": "amazonEMR"
    },
    "amazonEventBridge": {
        "name": "Amazon EventBridge",
        "serviceCode": "amazonEventBridge",
        "description": "Amazon EventBridge is a serverless event bus that makes it easier to build event-driven applications at scale using events generated from your applications, integrated Software-as-a-Service (SaaS) applications, and AWS services.",
        "searchKeywords": [
            "amazon event bridge",
            "events",
            "Schema Registry",
            "SaaS"
        ],
        "type": "AWSService",
        "regions": [
            "af-south-1",
            "ap-east-1",
            "ap-northeast-1",
            "ap-northeast-2",
            "ap-northeast-3",
            "ap-south-1",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-southeast-3",
            "ca-central-1",
            "eu-central-1",
            "eu-north-1",
            "eu-south-1",
            "eu-west-1",
            "eu-west-2",
            "eu-west-3",
            "me-south-1",
            "me-central-1",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-gov-east-1",
            "us-gov-west-1",
            "us-west-1",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/eventbridge/",
        "isActive": "true",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonEventBridge/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/amazonEventBridge/en_US.json",
        "slug": "eventbridge",
        "mvpSupport": false,
        "comparableTerms": [
            "eventbridge"
        ]
    },
    "amazonFileCache": {
        "name": "Amazon File Cache",
        "serviceCode": "amazonFileCache",
        "description": "Amazon File Cache provides a high-speed cache on AWS that makes it easier to process file data, regardless of where the data is stored.",
        "searchKeywords": [
            "file cache",
            "amazon file cache"
        ],
        "type": "AWSService",
        "regions": [
            " "
        ],
        "linkUrl": "https://aws.amazon.com/filecache/",
        "isActive": "true",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonFileCache/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/amazonFileCache/en_US.json",
        "slug": "filecache",
        "mvpSupport": false,
        "comparableTerms": [
            "filecache"
        ]
    },
    "awsFinSpace": {
        "name": "Amazon FinSpace",
        "serviceCode": "awsFinSpace",
        "description": "Amazon FinSpace is a data management and analytics service for financial services industry (FSI) customers such as hedge funds, asset management firms, insurance companies, and investment banks to store, catalog, prepare, and analyze data at petabyte scale. Using the FinSpace web application and APIs, customers can set up users, add data, and create data views that are optimized for querying. Amazon FinSpace provides scalable clusters to prepare and analyze the data.",
        "searchKeywords": [
            "data management",
            "analytics",
            "clusters",
            "users",
            "data",
            "storage",
            "financial"
        ],
        "type": "AWSService",
        "regions": [
            "us-east-1",
            "us-east-2",
            "us-west-2",
            "ca-central-1",
            "eu-west-1"
        ],
        "linkUrl": "https://aws.amazon.com/finspace/",
        "isActive": "true",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/awsFinSpace/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "slug": "FinSpace",
        "mvpSupport": false,
        "comparableTerms": [
            "finspace"
        ]
    },
    "amazonForecast": {
        "name": "Amazon Forecast",
        "serviceCode": "amazonForecast",
        "description": "Amazon Forecast uses machine learning (ML) to generate more accurate demand forecasts with just a few clicks, without requiring any prior ML experience. Amazon Forecast includes algorithms that are based on over twenty years of forecasting experience and developed expertise used by Amazon.com bringing the same technology used at Amazon to developers as a fully managed service, removing the need to manage resources. Amazon Forecast uses ML to learn not only the best algorithm for each item, but the best ensemble of algorithms for each item, automatically creating the best model for your data.",
        "searchKeywords": [
            "forecast",
            "amazon Forecast"
        ],
        "type": "AWSService",
        "regions": [
            "ap-northeast-1",
            "ap-northeast-2",
            "ap-south-1",
            "ap-southeast-1",
            "ap-southeast-2",
            "eu-central-1",
            "eu-west-1",
            "us-east-1",
            "us-east-2",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/forecast/",
        "isActive": "true",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonForecast/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/amazonForecast/en_US.json",
        "slug": "forecast",
        "mvpSupport": false,
        "comparableTerms": [
            "forecast"
        ]
    },
    "amazonFraudDetector": {
        "name": "Amazon Fraud Detector",
        "serviceCode": "amazonFraudDetector",
        "description": "Amazon Fraud Detector, a fully managed service built on over 20 years of insights from Amazon, helps customers identify potentially fraudulent activities and catch more online fraud faster. With Amazon Fraud Detector, you pay only for what you use, and there are no minimum fees or upfront commitments. You are charged based on the compute hours used to train and host your models, the amount of storage you use, and the quantity of fraud predictions you make.",
        "searchKeywords": [
            "fraud",
            "fraud detector",
            "detector"
        ],
        "type": "AWSService",
        "regions": [
            "ap-southeast-1",
            "ap-southeast-2",
            "eu-west-1",
            "us-east-1",
            "us-east-2",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/fraud-detector/",
        "isActive": "true",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonFraudDetector/en_US.json",
        "c2e": false,
        "slug": "frauddetector",
        "mvpSupport": false,
        "comparableTerms": [
            "frauddetector"
        ]
    },
    "amazonFSxForLustre": {
        "name": "Amazon FSx for Lustre",
        "serviceCode": "amazonFSxForLustre",
        "description": "Amazon FSx for Lustre provides a simple, high-performance file system integrated with S3 for fast processing of workloads such as machine learning, high performance computing (HPC), video processing, financial modeling, and electronic design automation (EDA).",
        "searchKeywords": [
            "storage",
            "file storage",
            "windows",
            "lustre",
            "hpc",
            "enterprise applications",
            "file shares",
            "file system",
            "cloud storage",
            "smb",
            "ntfs",
            "posix",
            "managed storage"
        ],
        "type": "AWSService",
        "regions": [
            "ap-east-1",
            "ap-south-1",
            "ap-northeast-1",
            "ap-northeast-2",
            "ap-southeast-1",
            "ca-central-1",
            "ap-southeast-2",
            "af-south-1",
            "eu-central-1",
            "eu-north-1",
            "eu-west-1",
            "eu-west-2",
            "eu-west-3",
            "me-south-1",
            "eu-south-1",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-gov-east-1",
            "us-gov-west-1",
            "us-west-1",
            "us-west-2",
            "us-west-2-lax-1"
        ],
        "linkUrl": "https://aws.amazon.com/fsx/lustre/",
        "isActive": "true",
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonFSxForLustre/en_US.json",
        "c2e": false,
        "slug": "FSxForLustre",
        "mvpSupport": false,
        "comparableTerms": [
            "fsxforlustre",
            "fsxlustre"
        ]
    },
    "amazonFSxForNetAppOntap": {
        "name": "Amazon FSx for NetApp ONTAP",
        "serviceCode": "amazonFSxForNetAppOntap",
        "description": "Amazon FSx for NetApp ONTAP provides fully managed shared storage in the AWS Cloud with the popular data access and management capabilities of ONTAP.",
        "searchKeywords": [
            "storage",
            "file storage",
            "windows",
            "lustre",
            "hpc",
            "enterprise applications",
            "file shares",
            "file system",
            "cloud storage",
            "smb",
            "ntfs",
            "posix",
            "managed storage",
            "microsoft",
            "file",
            "msft",
            "shared storage",
            "shared",
            "win",
            "ontap"
        ],
        "type": "AWSService",
        "regions": [
            "af-south-1",
            "ap-east-1",
            "ap-south-1",
            "ap-northeast-2",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-northeast-1",
            "us-gov-east-1",
            "us-gov-west-1",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "eu-south-1",
            "eu-west-3",
            "eu-north-1",
            "me-south-1",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/fsx/netapp-ontap/",
        "isActive": "true",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonFSxForNetAppOntap/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "bulkImportEnabled": false,
        "serviceDefinitionUrlPath": "/data/amazonFSxForNetAppOntap/en_US.json",
        "slug": "FSxForNetAppOntap",
        "mvpSupport": false,
        "comparableTerms": [
            "fsxfornetappontap",
            "fsxnetappontap"
        ]
    },
    "amazonFSxForOpenZfs": {
        "name": "Amazon FSx for OpenZFS",
        "serviceCode": "amazonFSxForOpenZfs",
        "description": "Amazon FSx for OpenZFS provides fully managed shared file storage built on the OpenZFS file system, powered by the AWS Graviton family of processors, and accessible via the NFS protocol (v3, v4, v4.1, v4.2).",
        "searchKeywords": [
            "storage",
            "file storage",
            "windows",
            "openzfs",
            "hpc",
            "enterprise applications",
            "file shares",
            "file system",
            "cloud storage",
            "smb",
            "ntfs",
            "posix",
            "managed storage"
        ],
        "type": "AWSService",
        "regions": [
            "us-east-2",
            "ap-northeast-1",
            "ap-southeast-1",
            "ap-southeast-2",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "us-east-1",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/fsx/openzfs/",
        "isActive": "true",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonFSxForOpenZfs/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "bulkImportEnabled": false,
        "serviceDefinitionUrlPath": "/data/amazonFSxForOpenZfs/en_US.json",
        "slug": "FSxForOpenZFS",
        "mvpSupport": false,
        "comparableTerms": [
            "fsxforopenzfs",
            "fsxopenzfs"
        ]
    },
    "amazonFSx": {
        "name": "Amazon FSx for Windows File Server",
        "serviceCode": "amazonFSx",
        "description": "Amazon FSx for Windows provides a simple, fully managed native Microsoft Windows file system so you can easily move your Windows based applications that require file storage to AWS.",
        "searchKeywords": [
            "storage",
            "file storage",
            "windows",
            "lustre",
            "hpc",
            "enterprise applications",
            "file shares",
            "file system",
            "cloud storage",
            "smb",
            "ntfs",
            "posix",
            "managed storage",
            "microsoft",
            "file",
            "msft",
            "shared storage",
            "shared",
            "win"
        ],
        "type": "AWSService",
        "regions": [
            "af-south-1",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-northeast-1",
            "ap-northeast-2",
            "ap-northeast-3",
            "eu-central-1",
            "ap-east-1",
            "ap-south-1",
            "ca-central-1",
            "eu-north-1",
            "eu-west-1",
            "eu-west-2",
            "eu-west-3",
            "eu-south-1",
            "me-south-1",
            "us-east-1",
            "us-east-2",
            "us-gov-east-1",
            "us-gov-west-1",
            "us-west-1",
            "us-west-2-lax-1",
            "us-west-2",
            "sa-east-1"
        ],
        "linkUrl": "https://aws.amazon.com/fsx/windows/",
        "isActive": "true",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonFSx/en_US.json",
        "c2e": false,
        "slug": "FSx",
        "mvpSupport": false,
        "comparableTerms": [
            "fsx",
            "fsxwindows",
            "fsxwindowsfileserver"
        ]
    },
    "amazonGameLift": {
        "name": "Amazon GameLift",
        "serviceCode": "amazonGameLift",
        "description": "Amazon GameLift is a dedicated game server hosting solution that deploys, operates, and scales cloud servers for multiplayer games. Whether you’re looking for a fully managed solution, or just the feature you need, GameLift leverages the power of AWS to deliver the best latency possible, low player wait times, and maximum cost savings.",
        "searchKeywords": [
            "AAA game engine",
            "anywhere",
            "auto scaling",
            "custom location",
            "device sdk",
            "ec2",
            "ec2 game server",
            "fleet management",
            "fleetIQ",
            "FlexMatch",
            "game backend",
            "game dev",
            "Game development",
            "game engine",
            "game hosting",
            "game placement",
            "game player",
            "game scaling",
            "game server",
            "game server alias",
            "game server management",
            "game server queue",
            "game servers",
            "game session placement",
            "game session queue",
            "game sessions",
            "gamedev",
            "gamelift",
            "games",
            "gaming",
            "gaming platform",
            "global game hosting",
            "instances",
            "lightweight game server",
            "lumber yard",
            "lumberjack",
            "lumberyard",
            "lumberyard download",
            "lumberyard game",
            "lumberyard game engine",
            "lumberyard games",
            "managed game hosting",
            "managed game server",
            "managed server",
            "matchmaker",
            "matchmaking",
            "matchmaking configuration",
            "matchmaking rule",
            "mobile game engine",
            "multiplayer backend",
            "multiplayer game",
            "multiplayer game server",
            "on demand",
            "real time game server",
            "real time servers",
            "remote",
            "rts",
            "rule set",
            "rules engine",
            "spot"
        ],
        "type": "AWSService",
        "regions": [
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2",
            "af-south-1",
            "ap-northeast-1",
            "ap-northeast-2",
            "ap-northeast-3",
            "ap-east-1",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-south-1",
            "ca-central-1",
            "eu-north-1",
            "eu-central-1",
            "eu-south-1",
            "eu-west-1",
            "eu-west-2",
            "eu-west-3",
            "me-south-1",
            "sa-east-1",
            "us-east-1-atl-1",
            "us-east-1-chi-1",
            "us-east-1-dfw-1",
            "us-west-2-den-1",
            "us-east-1-iah-1",
            "us-east-1-mci-1",
            "us-west-2-lax-1",
            "us-west-2-phx-1"
        ],
        "linkUrl": "https://aws.amazon.com/gamelift/",
        "isActive": "true",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonGameLift/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "bulkImportEnabled": false,
        "serviceDefinitionUrlPath": "/data/amazonGameLift/en_US.json",
        "slug": "GameLift",
        "mvpSupport": false,
        "comparableTerms": [
            "gamelift"
        ]
    },
    "amazonGuardDuty": {
        "name": "Amazon GuardDuty",
        "serviceCode": "amazonGuardDuty",
        "description": "Amazon GuardDuty is a threat detection service that continuously monitors for malicious activity and unauthorized behavior to protect your AWS accounts, workloads, and data stored in Amazon S3.",
        "searchKeywords": [
            "guard duty",
            "amazon GuardDuty"
        ],
        "type": "AWSService",
        "regions": [
            "af-south-1",
            "ap-east-1",
            "ap-northeast-1",
            "ap-northeast-2",
            "ap-south-1",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-southeast-3",
            "ap-northeast-3",
            "ca-central-1",
            "eu-central-1",
            "eu-north-1",
            "eu-south-1",
            "eu-west-1",
            "eu-west-2",
            "eu-west-3",
            "me-south-1",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-gov-east-1",
            "us-gov-west-1",
            "us-west-1",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/guardduty/",
        "isActive": "true",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonGuardDuty/en_US.json",
        "c2e": false,
        "slug": "guardduty",
        "mvpSupport": false,
        "comparableTerms": [
            "guardduty"
        ]
    },
    "amazonHealthlake": {
        "name": "Amazon Healthlake",
        "serviceCode": "amazonHealthlake",
        "description": "Amazon HealthLake is a HIPAA-eligible service offering healthcare and life sciences companies a complete view of individual or patient population health data for query and analytics at scale.",
        "searchKeywords": [
            "FHIR",
            "HIPAA",
            "NLP"
        ],
        "type": "AWSService",
        "regions": [
            "us-east-1",
            "us-east-2",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/healthlake/",
        "isActive": "true",
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonHealthlake/en_US.json",
        "c2e": false,
        "slug": "HealthLake",
        "mvpSupport": false,
        "comparableTerms": [
            "healthlake"
        ]
    },
    "amazonInspector": {
        "name": "Amazon Inspector",
        "serviceCode": "amazonInspector",
        "description": "Amazon Inspector is an automated and continual vulnerability scanning service that assesses Amazon Elastic Compute Cloud (EC2) instances and container images to improve the security and compliance of infrastructure workloads.",
        "searchKeywords": [
            "Analytics",
            "SQL",
            "query",
            "S3",
            "big data",
            "Presto",
            "serverless",
            "ad-hoc analysis",
            "log processing",
            "bigquery",
            "big query",
            "query S3 data"
        ],
        "type": "AWSService",
        "regions": [
            "ap-east-1",
            "ap-south-1",
            "ap-northeast-1",
            "ap-northeast-2",
            "ap-northeast-3",
            "ap-southeast-1",
            "ap-southeast-2",
            "us-gov-west-1",
            "us-gov-east-1",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "eu-west-3",
            "eu-north-1",
            "eu-south-1",
            "me-south-1",
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2",
            "af-south-1",
            "sa-east-1"
        ],
        "linkUrl": "https://aws.amazon.com/inspector/",
        "isActive": "true",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonInspector/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/amazonInspector/en_US.json",
        "slug": "Inspector",
        "mvpSupport": false,
        "comparableTerms": [
            "inspector"
        ]
    },
    "amazonKendra": {
        "name": "Amazon Kendra",
        "serviceCode": "amazonKendra",
        "description": "Amazon Kendra is an intelligent search service powered by machine learning. Kendra reimagines enterprise search for your websites and applications so your employees and customers can easily find the content they are looking for, even when it’s scattered across multiple locations and content repositories within your organization.",
        "searchKeywords": [
            "kendra"
        ],
        "type": "AWSService",
        "regions": [
            "us-east-1",
            "us-west-2",
            "eu-west-1",
            "ap-southeast-2"
        ],
        "linkUrl": "https://aws.amazon.com/kendra",
        "isActive": "true",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonKendra/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "bulkImportEnabled": false,
        "serviceDefinitionUrlPath": "/data/amazonKendra/en_US.json",
        "slug": "Kendra",
        "mvpSupport": false,
        "comparableTerms": [
            "kendra"
        ]
    },
    "amazonKinesisDataAnalytics": {
        "name": "Amazon Kinesis Data Analytics",
        "serviceCode": "amazonKinesisDataAnalytics",
        "description": "Amazon Kinesis Data Analytics is the easiest way to analyze streaming data, gain actionable insights, and respond to your business and customer needs in real time.",
        "searchKeywords": [
            "Kinesis",
            "streaming",
            "insights",
            "Flink",
            "Apache Flink"
        ],
        "type": "AWSService",
        "regions": [
            "us-gov-west-1",
            "us-gov-east-1",
            "ap-east-1",
            "ap-south-1",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-northeast-1",
            "ap-northeast-2",
            "ap-northeast-3",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "eu-west-3",
            "eu-north-1",
            "eu-south-1",
            "me-south-1",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2",
            "af-south-1"
        ],
        "linkUrl": "https://aws.amazon.com/kinesis/data-analytics/",
        "isActive": "true",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonKinesisDataAnalytics/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/amazonKinesisDataAnalytics/en_US.json",
        "slug": "KinesisDataAnalytics",
        "mvpSupport": false,
        "comparableTerms": [
            "kinesisdataanalytics"
        ]
    },
    "amazonKinesisFirehose": {
        "name": "Amazon Kinesis Data Firehose",
        "serviceCode": "amazonKinesisFirehose",
        "description": "With Amazon Kinesis Data Firehose, you pay for the volume of data you ingest into the service. There are no set up fees or upfront commitments. You are billed for the volume of data ingested into Kinesis Data Firehose, and if applicable, for data format conversion to Apache Parquet or ORC.",
        "searchKeywords": [
            "Analytics",
            "kinesis analytics",
            "kinesis streams",
            "kinesis firehose",
            "firehose",
            "VPC",
            "data format conversion",
            "streaming",
            "data streaming",
            "real-time",
            "analysis",
            "kafka",
            "spark",
            "put records",
            "kcl",
            "kpl",
            "sql",
            "ORC",
            "stream processing",
            "sql on streams",
            "stream ingestion",
            "IoT analytics",
            "real-time bidding",
            "RTB",
            "log analytics",
            "clickstream analytics",
            "real time alerts",
            "real time dashboards",
            "real time monitoring",
            "dynamic partitioning"
        ],
        "type": "AWSService",
        "regions": [
            "us-gov-west-1",
            "us-gov-east-1",
            "af-south-1",
            "ap-east-1",
            "ap-south-1",
            "ap-northeast-2",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-southeast-3",
            "ap-northeast-1",
            "ap-northeast-2",
            "ap-northeast-3",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "eu-south-1",
            "eu-west-3",
            "eu-north-1",
            "me-south-1",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/kinesis/data-firehose/",
        "isActive": "true",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonKinesisFirehose/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/amazonKinesisFirehose/en_US.json",
        "slug": "KinesisDataFirehose",
        "mvpSupport": false,
        "comparableTerms": [
            "kinesisdatafirehose",
            "kinesisfirehose"
        ]
    },
    "amazonKinesisDataStreams": {
        "name": "Amazon Kinesis Data Streams",
        "serviceCode": "amazonKinesisDataStreams",
        "description": "Amazon Kinesis Data Streams (KDS) is a massively scalable and durable real-time data streaming service.",
        "searchKeywords": [
            "Analytics",
            "kinesis analytics",
            "kinesis streams",
            "kinesis firehose",
            "streaming",
            "data streaming",
            "real-time",
            "analysis",
            "kafka",
            "spark",
            "put records",
            "kcl",
            "kpl",
            "sql",
            "stream processing",
            "sql on streams",
            "stream ingestion",
            "IoT analytics",
            "real-time bidding",
            "RTB",
            "log analytics",
            "clickstream analytics",
            "real time alerts",
            "real time dashboards",
            "real time monitoring"
        ],
        "type": "AWSService",
        "regions": [
            "af-south-1",
            "ap-east-1",
            "ap-northeast-1",
            "ap-northeast-2",
            "ap-northeast-3",
            "ap-south-1",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-southeast-3",
            "ca-central-1",
            "eu-central-1",
            "eu-north-1",
            "eu-south-1",
            "eu-west-1",
            "eu-west-2",
            "eu-west-3",
            "me-south-1",
            "me-central-1",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-gov-east-1",
            "us-gov-west-1",
            "us-west-1",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/kinesis/data-streams/",
        "isActive": "true",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonKinesisDataStreams/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "slug": "KinesisDataStreams",
        "mvpSupport": false,
        "comparableTerms": [
            "kinesisdatastreams"
        ]
    },
    "amazonKinesisVideoStreams": {
        "name": "Amazon Kinesis Video Streams",
        "serviceCode": "amazonKinesisVideoStreams",
        "description": "Amazon Kinesis Video Streams makes it easy to securely stream video from connected devices to AWS for analytics, machine learning (ML), playback, and other processing. Kinesis Video Streams automatically provisions and elastically scales all the infrastructure needed to ingest streaming video data from millions of devices.",
        "searchKeywords": [
            "video stream",
            "signaling channel",
            "turn streaming",
            "webRTC",
            "video analytics",
            "HTTP live streaming",
            "HLS",
            "KVS"
        ],
        "type": "AWSService",
        "regions": [
            "us-east-1",
            "us-east-2",
            "us-west-2",
            "ap-east-1",
            "ap-south-1",
            "ap-northeast-2",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-northeast-1",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "eu-west-3",
            "sa-east-1"
        ],
        "linkUrl": "https://aws.amazon.com/kinesis/video-streams",
        "isActive": "true",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonKinesisVideoStreams/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "slug": "KinesisVideoStreams",
        "mvpSupport": false,
        "comparableTerms": [
            "kinesisvideostreams"
        ]
    },
    "amazonLex": {
        "name": "Amazon Lex",
        "serviceCode": "amazonLex",
        "description": "Amazon Lex is a service for building conversational interfaces into any application using voice and text. With Amazon Lex, you pay only for what you use.",
        "searchKeywords": [
            "bot",
            "chat",
            "chatbot",
            "conversation",
            "conversational interfaces",
            "response",
            "speech",
            "streaming conversation",
            "text",
            "transcripts",
            "virtual agent",
            "voice chat"
        ],
        "type": "AWSService",
        "regions": [
            "us-east-1",
            "us-west-2",
            "af-south-1",
            "ap-northeast-2",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-northeast-1",
            "eu-west-2",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "us-gov-west-1"
        ],
        "linkUrl": "https://aws.amazon.com/lex",
        "isActive": "true",
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonLex/en_US.json",
        "c2e": false,
        "slug": "lex",
        "mvpSupport": false,
        "comparableTerms": [
            "lex"
        ]
    },
    "amazonLightsail": {
        "name": "Amazon Lightsail",
        "serviceCode": "amazonLightsail",
        "description": "Lightsail is an easy-to-use virtual private server (VPS) that offers you everything needed to build an application or website, plus a cost-effective, monthly plan. Lightsail is ideal for simpler workloads, quick deployments, and getting started on AWS. It’s designed to help you start small, and then scale as you grow.",
        "searchKeywords": [
            "virtual servers",
            "databases",
            "containers",
            "load balancer",
            "content delivery network",
            "CDN",
            "block storage",
            "snapshots",
            "vps",
            "virtual private server"
        ],
        "type": "AWSService",
        "regions": [],
        "linkUrl": "https://aws.amazon.com/lightsail/",
        "isActive": "true",
        "hasDataTransfer": true,
        "subType": "subServiceSelector",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonLightsail/en_US.json",
        "c2e": false,
        "templates": [
            "lightsailVirtualServers",
            "lightsailManagedDatabases",
            "lightsailContainers",
            "lightsailObjectStorage",
            "lightsailCdn",
            "lightsailLoadBalancer",
            "lightsailBlockStorage",
            "lightsailDataTransfer"
        ],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/amazonLightsail/en_US.json",
        "slug": "Lightsail",
        "mvpSupport": false,
        "comparableTerms": [
            "lightsail"
        ]
    },
    "amazonLookoutForMetrics": {
        "name": "Amazon Lookout for Metrics",
        "serviceCode": "amazonLookoutForMetrics",
        "description": "Amazon Lookout for Metrics uses machine learning (ML) to automatically detect and diagnose anomalies (i.e. outliers from the norm) in business and operational data, such as a sudden dip in sales revenue or customer acquisition rates. In a couple of clicks, you can connect Amazon Lookout for Metrics to popular data stores like Amazon S3, Amazon Redshift, and Amazon Relational Database Service (RDS), as well as third-party SaaS applications, such as Salesforce, Servicenow, Zendesk, and Marketo, and start monitoring metrics that are important to your business. Amazon Lookout for Metrics automatically inspects and prepares the data from these sources to detect anomalies with greater speed and accuracy than traditional methods used for anomaly detection. You can also provide feedback on detected anomalies to tune the results and improve accuracy over time. Amazon Lookout for Metrics makes it easy to diagnose detected anomalies by grouping together anomalies that are related to the same event and sending an alert that includes a summary of the potential root cause. It also ranks anomalies in order of severity so that you can prioritize your attention to what matters the most to your business.",
        "searchKeywords": [
            "lookout for metrics",
            "metrics",
            "anomalies",
            "anomaly detection",
            "machine learning",
            "ML-powered anomaly detection",
            "Anomaly Grouping and Ranking",
            "Tunable results",
            "automated alerts",
            "anomaly detection model",
            "detector",
            "outlier",
            "outlier detection"
        ],
        "type": "AWSService",
        "regions": [
            "us-east-2",
            "ap-southeast-2",
            "eu-north-1",
            "ap-southeast-1",
            "eu-west-1",
            "us-west-2",
            "us-east-1",
            "ap-northeast-1",
            "eu-central-1"
        ],
        "linkUrl": "https://aws.amazon.com/lookout-for-metrics/",
        "isActive": "true",
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonLookoutForMetrics/en_US.json",
        "c2e": false,
        "slug": "LookoutForMetrics",
        "mvpSupport": false,
        "comparableTerms": [
            "lookoutformetrics",
            "lookoutmetrics"
        ]
    },
    "amazonLookoutForVision": {
        "name": "Amazon Lookout for Vision",
        "serviceCode": "amazonLookoutForVision",
        "description": "Amazon Lookout for Vision is a machine learning (ML) service that spots defects and anomalies in visual representations using computer vision (CV). With Amazon Lookout for Vision, manufacturing companies can increase quality and reduce operational costs by quickly identifying differences in images of objects at scale.",
        "searchKeywords": [
            "lookout",
            "vision"
        ],
        "type": "AWSService",
        "regions": [
            "ap-northeast-2",
            "ap-northeast-1",
            "eu-central-1",
            "eu-west-1",
            "us-east-1",
            "us-east-2",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/lookout-for-vision/",
        "isActive": "true",
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonLookoutForVision/en_US.json",
        "c2e": false,
        "slug": "LookoutVision",
        "comparableTerms": [
            "lookoutforvision",
            "lookoutvision"
        ]
    },
    "amazonMacie": {
        "name": "Amazon Macie",
        "serviceCode": "amazonMacie",
        "description": "Amazon Macie is a fully managed data security and data privacy service that uses machine learning and pattern matching to discover and protect your sensitive data in AWS. With Amazon Macie, you are charged based on the number of Amazon S3 buckets evaluated for bucket-level security and access controls and the quantity of data processed for sensitive data discovery.",
        "searchKeywords": [
            "data security",
            "data privacy",
            "machine learning",
            "pattern matching",
            "sensitive data protection",
            "S3 buckets",
            "PII",
            "HIPAA",
            "GDPR"
        ],
        "type": "AWSService",
        "regions": [
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2",
            "af-south-1",
            "ap-east-1",
            "ap-south-1",
            "ap-northeast-3",
            "ap-northeast-2",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-northeast-1",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "eu-south-1",
            "eu-west-3",
            "eu-north-1",
            "me-south-1",
            "sa-east-1"
        ],
        "linkUrl": "https://aws.amazon.com/macie/",
        "isActive": "true",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonMacie/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/amazonMacie/en_US.json",
        "slug": "Macie",
        "mvpSupport": false,
        "comparableTerms": [
            "macie"
        ]
    },
    "amazonManagedBlockchain": {
        "name": "Amazon Managed Blockchain",
        "serviceCode": "amazonManagedBlockchain",
        "description": "Amazon Managed Blockchain is a fully managed service that makes it easy to join public networks or create and manage scalable private networks using the popular open-source frameworks Hyperledger Fabric and Ethereum.",
        "searchKeywords": [
            "hyperledger Fabric",
            "ethereum",
            "blockchain",
            "managed blockchain"
        ],
        "type": "AWSService",
        "regions": [
            "us-east-1",
            "ap-northeast-1",
            "ap-northeast-2",
            "ap-southeast-1",
            "eu-west-1",
            "eu-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/managed-blockchain/",
        "isActive": "true",
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonManagedBlockchain/en_US.json",
        "c2e": false,
        "slug": "ManagedBlockchain",
        "mvpSupport": false,
        "comparableTerms": [
            "managedblockchain"
        ]
    },
    "amazonManagedServiceForPrometheus": {
        "name": "Amazon Managed Service for Prometheus",
        "serviceCode": "amazonManagedServiceForPrometheus",
        "description": "Amazon Managed Service for Prometheus is a Prometheus-compatible monitoring service that makes it easy to monitor containerized applications at scale. The Cloud Native Computing Foundation’s Prometheus project is a popular open source monitoring and alerting solution optimized for container environments. With Amazon Managed Service for Prometheus, you can use the open source Prometheus query language (PromQL) to monitor the performance of containerized workloads, without having to manage the underlying infrastructure.",
        "searchKeywords": [
            "MSP",
            "Prometheus",
            "Managed Service for Prometheus"
        ],
        "type": "AWSService",
        "regions": [
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-northeast-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "eu-north-1",
            "us-east-1",
            "us-east-2",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/prometheus/",
        "isActive": "true",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonManagedServiceForPrometheus/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/amazonManagedServiceForPrometheus/en_US.json",
        "slug": "Prometheus",
        "mvpSupport": false,
        "comparableTerms": [
            "managedserviceforprometheus",
            "managedserviceprometheus",
            "prometheus"
        ]
    },
    "amazonManagedStreamingForApacheKafkaMsk": {
        "name": "Amazon Managed Streaming for Apache Kafka (MSK)",
        "serviceCode": "amazonManagedStreamingForApacheKafkaMsk",
        "description": "Amazon MSK is a fully managed service that makes it easy for you to build and run applications that use Apache Kafka to process streaming data. With Amazon MSK, you can use native Apache Kafka APIs to populate data lakes, stream changes to and from databases, and power machine learning and analytics applications.",
        "searchKeywords": [
            "MSK",
            "Apache Kafka"
        ],
        "type": "AWSService",
        "regions": [
            "af-south-1",
            "ap-east-1",
            "ap-south-1",
            "ap-northeast-2",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-northeast-1",
            "ap-northeast-3",
            "us-gov-east-1",
            "us-gov-west-1",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "eu-south-1",
            "eu-west-3",
            "eu-north-1",
            "me-south-1",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2"
        ],
        "isActive": "true",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonManagedStreamingForApacheKafkaMsk/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "slug": "MSK",
        "mvpSupport": false,
        "comparableTerms": [
            "managedstreamingapachekafkamsk",
            "managedstreamingforapachekafkamsk",
            "msk"
        ]
    },
    "amazonManagedWorkflowsForApacheAirflow": {
        "name": "Amazon Managed Workflows for Apache Airflow",
        "serviceCode": "amazonManagedWorkflowsForApacheAirflow",
        "description": "Amazon Managed Workflows for Apache Airflow (MWAA) is a managed orchestration service for Apache Airflow1 that makes it easier to set up and operate end-to-end data pipelines in the cloud at scale. Apache Airflow is an open-source tool used to programmatically author, schedule, and monitor sequences of processes and tasks referred to as “workflows.” With Managed Workflows, you can use Airflow and Python to create workflows without having to manage the underlying infrastructure for scalability, availability, and security.",
        "searchKeywords": [
            "MWAA",
            "Workflows",
            "Apache Airflow",
            "Managed Workflows for Apache Airflow"
        ],
        "type": "AWSService",
        "regions": [
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2",
            "ap-south-1",
            "ap-northeast-2",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-northeast-1",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "eu-west-3",
            "eu-north-1",
            "sa-east-1"
        ],
        "linkUrl": "https://aws.amazon.com/managed-workflows-for-apache-airflow/",
        "isActive": "true",
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonManagedWorkflowsForApacheAirflow/en_US.json",
        "c2e": false,
        "slug": "MWAA",
        "mvpSupport": false,
        "comparableTerms": [
            "managedworkflowsapacheairflow",
            "managedworkflowsforapacheairflow",
            "mwaa"
        ]
    },
    "amazonMemoryDbForRedis": {
        "name": "Amazon MemoryDB for Redis",
        "serviceCode": "amazonMemoryDbForRedis",
        "description": "Amazon MemoryDB for Redis is a Redis-compatible, durable, in-memory database that delivers ultra-fast performance and Multi-AZ durability.",
        "searchKeywords": [
            "memorydb",
            "Amazon MemoryDB for Redis"
        ],
        "type": "AWSService",
        "regions": [
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2",
            "ap-east-1",
            "ap-south-1",
            "ap-northeast-2",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-northeast-1",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "eu-west-3",
            "eu-north-1",
            "eu-south-1",
            "sa-east-1"
        ],
        "linkUrl": "https://aws.amazon.com/memorydb/",
        "isActive": "true",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonMemoryDbForRedis/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/amazonMemoryDbForRedis/en_US.json",
        "slug": "memorydb",
        "mvpSupport": false,
        "comparableTerms": [
            "memorydb",
            "memorydbforredis",
            "memorydbredis"
        ]
    },
    "amazonMQ": {
        "name": "Amazon MQ",
        "serviceCode": "amazonMQ",
        "description": "Amazon MQ is a managed message broker service for Apache ActiveMQ that makes it easy to set up and operate message brokers in the cloud.",
        "searchKeywords": [
            "MQ",
            "rabbit",
            "broker",
            "Apache ActiveMQ"
        ],
        "type": "AWSService",
        "regions": [
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2",
            "af-south-1",
            "ap-east-1",
            "ap-northeast-1",
            "ap-northeast-2",
            "ap-northeast-3",
            "ap-south-1",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-southeast-3",
            "ca-central-1",
            "eu-central-1",
            "eu-north-1",
            "eu-south-1",
            "eu-west-1",
            "eu-west-2",
            "eu-west-3",
            "sa-east-1",
            "me-south-1",
            "us-gov-west-1",
            "us-gov-east-1"
        ],
        "linkUrl": "https://aws.amazon.com/amazon-mq/",
        "isActive": "true",
        "hasDataTransfer": true,
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonMQ/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/amazonMQ/en_US.json",
        "slug": "MQ",
        "mvpSupport": false,
        "comparableTerms": [
            "mq"
        ]
    },
    "amazonNeptune": {
        "name": "Amazon Neptune",
        "serviceCode": "amazonNeptune",
        "description": "Amazon Neptune is a fast, reliable, fully managed graph database service that makes it easy to build and run applications that work with highly connected datasets.",
        "searchKeywords": [
            "Neptune",
            "Graph database"
        ],
        "type": "AWSService",
        "regions": [
            "af-south-1",
            "ap-east-1",
            "ap-northeast-1",
            "ap-northeast-2",
            "ap-south-1",
            "ap-southeast-1",
            "ap-southeast-2",
            "ca-central-1",
            "eu-central-1",
            "eu-north-1",
            "eu-west-1",
            "eu-west-2",
            "eu-west-3",
            "me-south-1",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-gov-west-1",
            "us-gov-east-1",
            "us-west-1",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/neptune/",
        "isActive": "true",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonNeptune/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "slug": "neptune",
        "mvpSupport": false,
        "comparableTerms": [
            "neptune"
        ]
    },
    "amazonElasticsearchService": {
        "name": "Amazon OpenSearch Service",
        "serviceCode": "amazonElasticsearchService",
        "description": "Amazon OpenSearch Service is a fully managed service that makes it easy for you to deploy, secure, and operate OpenSearch clusters at scale.",
        "searchKeywords": [
            "Analytics",
            "ES",
            "Kibana",
            "Logstash",
            "Search",
            "Text search",
            "Time series",
            "Log analytics",
            "Analytics",
            "Real time analytics",
            "Streaming data analytics",
            "CloudSearch",
            "search",
            "ultraWarm",
            "ultrawarm",
            "opensearch",
            "open search"
        ],
        "type": "AWSService",
        "regions": [
            "af-south-1",
            "ap-east-1",
            "ap-south-1",
            "ap-northeast-2",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-southeast-3",
            "ap-northeast-1",
            "ap-northeast-3",
            "us-gov-east-1",
            "us-gov-west-1",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "eu-west-3",
            "eu-north-1",
            "eu-south-1",
            "me-south-1",
            "me-central-1",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/opensearch-service/",
        "isActive": "true",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonElasticsearchService/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "bulkImportEnabled": false,
        "serviceDefinitionUrlPath": "/data/amazonElasticsearchService/en_US.json",
        "slug": "OpenSearchService",
        "mvpSupport": false,
        "comparableTerms": [
            "elasticsearch",
            "elasticsearchservice",
            "opensearch",
            "opensearchservice"
        ]
    },
    "amazonPersonalize": {
        "name": "Amazon Personalize",
        "serviceCode": "amazonPersonalize",
        "description": "Amazon Personalize enables developers to build applications with the same machine learning (ML) technology used by Amazon.com for real-time personalized recommendations – no ML expertise required.",
        "searchKeywords": [
            "personalize",
            "Amazon personalize"
        ],
        "type": "AWSService",
        "regions": [],
        "linkUrl": "https://aws.amazon.com/personalize/",
        "isActive": "true",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonPersonalize/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/amazonPersonalize/en_US.json",
        "slug": "personalize",
        "mvpSupport": false,
        "comparableTerms": [
            "personalize"
        ]
    },
    "amazonPinpoint": {
        "name": "Amazon Pinpoint",
        "serviceCode": "amazonPinpoint",
        "description": "Amazon Pinpoint is a flexible and scalable outbound and inbound marketing communications service. You can connect with customers over channels like email, SMS, push, or voice. Amazon Pinpoint is easy to set up, easy to use, and is flexible for all marketing communication scenarios. ",
        "searchKeywords": [
            "marketing",
            "communications",
            "email",
            "SMS",
            "messages",
            "campaign"
        ],
        "type": "AWSService",
        "regions": [
            "us-west-2",
            "us-east-1",
            "ap-northeast-2",
            "ap-south-1",
            "ap-southeast-2",
            "ap-northeast-1",
            "ap-southeast-1",
            "eu-west-2",
            "eu-west-1",
            "eu-central-1",
            "ca-central-1",
            "us-gov-west-1"
        ],
        "linkUrl": "https://aws.amazon.com/pinpoint/",
        "isActive": "true",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonPinpoint/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/amazonPinpoint/en_US.json",
        "slug": "Pinpoint",
        "mvpSupport": false,
        "comparableTerms": [
            "pinpoint"
        ]
    },
    "amazonPolly": {
        "name": "Amazon Polly",
        "serviceCode": "amazonPolly",
        "description": "Amazon Polly is a service that turns text into lifelike speech, allowing you to create applications that talk, and build entirely new categories of speech-enabled products.",
        "searchKeywords": [
            "polly",
            "NLP",
            "speech",
            "text to speech"
        ],
        "type": "AWSService",
        "regions": [],
        "linkUrl": "https://aws.amazon.com/polly/",
        "isActive": "true",
        "subType": "subServiceSelector",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonPolly/en_US.json",
        "c2e": false,
        "templates": [
            "neuralTextToSpeech",
            "standardTextToSpeechTts"
        ],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/amazonPolly/en_US.json",
        "slug": "polly",
        "mvpSupport": false,
        "comparableTerms": [
            "polly"
        ]
    },
    "amazonQuickSight": {
        "name": "Amazon QuickSight",
        "serviceCode": "amazonQuickSight",
        "description": "Amazon QuickSight is a fast, cloud-powered business intelligence service that makes it easy to deliver insights to everyone in your organization. QuickSight dashboards can be embedded in applications, require no infrastructure setup or management, and can automatically scale to tens of thousands of users.",
        "searchKeywords": [
            "QuickSight",
            "Serverless",
            "Embedding",
            "BI",
            "Business intelligence",
            "Data visualization",
            "Insights",
            "Embedded Analytics"
        ],
        "type": "AWSService",
        "regions": [],
        "linkUrl": "https://aws.amazon.com/quicksight/",
        "isActive": "true",
        "subType": "subServiceSelector",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonQuickSight/en_US.json",
        "c2e": false,
        "templates": [
            "amazonQuickSightReadersAuthorsSpice",
            "amazonQuickSightAnomalyDetection"
        ],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/amazonQuickSight/en_US.json",
        "slug": "QuickSight",
        "mvpSupport": false,
        "comparableTerms": [
            "quicksight"
        ]
    },
    "amazonQuickSightAnomalyDetection": {
        "name": "Amazon QuickSight Alerts & Anomaly Detection",
        "serviceCode": "amazonQuickSightAnomalyDetection",
        "description": "",
        "searchKeywords": [],
        "type": "AWSService",
        "regions": [
            "us-east-1",
            "us-east-2",
            "us-west-2",
            "ap-south-1",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-northeast-1",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "eu-north-1",
            "sa-east-1",
            "us-gov-west-1"
        ],
        "isActive": "true",
        "subType": "subService",
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonQuickSightAnomalyDetection/en_US.json",
        "c2e": false,
        "mvpSupport": false,
        "comparableTerms": [
            "quicksightalertsanomalydetection",
            "quicksightanomalydetection"
        ],
        "parentServiceCode": "amazonQuickSight"
    },
    "amazonQuickSightReadersAuthorsSpice": {
        "name": "Amazon QuickSight Readers, Authors, SPICE",
        "serviceCode": "amazonQuickSightReadersAuthorsSpice",
        "description": "Amazon QuickSight is a fast, cloud-powered business intelligence service that makes it easy to deliver insights to everyone in your organization. QuickSight dashboards can be embedded in applications, require no infrastructure setup or management, and can automatically scale to tens of thousands of users.",
        "searchKeywords": [
            "QuickSight",
            "Serverless",
            "Embedding",
            "BI",
            "Business intelligence",
            "Data visualization",
            "Insights",
            "Embedded Analytics"
        ],
        "type": "AWSService",
        "regions": [
            "us-east-1",
            "us-east-2",
            "us-west-2",
            "ap-south-1",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-northeast-1",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "eu-north-1",
            "sa-east-1",
            "us-gov-west-1"
        ],
        "linkUrl": "https://aws.amazon.com/quicksight/",
        "isActive": "true",
        "subType": "subService",
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonQuickSightReadersAuthorsSpice/en_US.json",
        "c2e": false,
        "comparableTerms": [
            "quicksightreadersauthorsspice"
        ],
        "parentServiceCode": "amazonQuickSight"
    },
    "amazonRdsCustomForOracle": {
        "name": "Amazon RDS Custom for Oracle",
        "serviceCode": "amazonRdsCustomForOracle",
        "description": "Amazon Relational Database Service (Amazon RDS) Custom is a managed database service for legacy, custom, and packaged applications that require access to the underlying OS and DB environment. Amazon RDS Custom automates setup, operation, and scaling of databases in the cloud while granting access to the database and underlying operating system to configure settings, install patches, and enable native features to meet the dependent application's requirements.",
        "searchKeywords": [],
        "type": "AWSService",
        "regions": [
            "ap-northeast-1",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-south-1",
            "eu-central-1",
            "eu-north-1",
            "eu-west-1",
            "eu-west-2",
            "us-east-1",
            "us-east-2",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/rds/custom",
        "isActive": "true",
        "hasDataTransfer": false,
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonRdsCustomForOracle/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "slug": "RDSCustomForOracle",
        "mvpSupport": false,
        "comparableTerms": [
            "rdscustom",
            "rdscustomfororacle",
            "rdscustomoracle"
        ]
    },
    "amazonRdsCustomForSqlServer": {
        "name": "Amazon RDS Custom for SQL Server",
        "serviceCode": "amazonRdsCustomForSqlServer",
        "description": "Amazon Relational Database Service (Amazon RDS) Custom is a managed database service for legacy, custom, and packaged applications that require access to the underlying OS and DB environment. Amazon RDS Custom automates setup, operation, and scaling of databases in the cloud while granting access to the database and underlying operating system to configure settings, install patches, and enable native features to meet the dependent application's requirements.",
        "searchKeywords": [],
        "type": "AWSService",
        "regions": [
            "ap-northeast-1",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-south-1",
            "eu-central-1",
            "eu-north-1",
            "eu-west-1",
            "eu-west-2",
            "us-east-1",
            "us-east-2",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/rds/custom",
        "isActive": "true",
        "hasDataTransfer": false,
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonRdsCustomForSqlServer/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "slug": "RDSCustomForSQLServer",
        "mvpSupport": false,
        "comparableTerms": [
            "rdscustom",
            "rdscustomforsqlserver",
            "rdscustomsqlserver"
        ]
    },
    "amazonRDSMariaDB": {
        "name": "Amazon RDS for MariaDB",
        "serviceCode": "amazonRDSMariaDB",
        "description": "Amazon RDS makes it easy to set up, operate, and scale MariaDB database deployments in the cloud.",
        "searchKeywords": [
            "Database",
            "MariaDB",
            "database hosting",
            "hosted database",
            "Managed database"
        ],
        "type": "AWSService",
        "regions": [
            "af-south-1",
            "ap-northeast-1",
            "ap-northeast-2",
            "ap-northeast-3",
            "ap-south-1",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-southeast-3",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "eu-west-3",
            "eu-north-1",
            "eu-south-1",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-gov-west-1",
            "us-west-1",
            "us-west-2",
            "us-gov-east-1",
            "ap-east-1",
            "me-south-1",
            "me-central-1"
        ],
        "linkUrl": "https://aws.amazon.com/rds/mariadb",
        "isActive": "true",
        "hasDataTransfer": true,
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonRDSMariaDB/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/amazonRDSMariaDB/en_US.json",
        "slug": "RDSMariaDB",
        "mvpSupport": false,
        "comparableTerms": [
            "rdsmariadb"
        ]
    },
    "amazonRDSMySQLDB": {
        "name": "Amazon RDS for MySQL",
        "serviceCode": "amazonRDSMySQLDB",
        "description": "MySQL is the world's most popular open source relational database. Amazon RDS makes it easy to set up, operate, and scale MySQL deployments in the cloud.",
        "searchKeywords": [],
        "type": "AWSService",
        "regions": [
            "af-south-1",
            "ap-northeast-1",
            "ap-northeast-2",
            "ap-northeast-3",
            "ap-south-1",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-southeast-3",
            "ca-central-1",
            "eu-central-1",
            "eu-south-1",
            "eu-west-1",
            "eu-west-2",
            "eu-west-3",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-gov-west-1",
            "us-west-1",
            "us-west-2",
            "us-gov-east-1",
            "eu-north-1",
            "ap-east-1",
            "me-south-1",
            "me-central-1"
        ],
        "linkUrl": "https://aws.amazon.com/rds/mysql",
        "isActive": "true",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonRDSMySQLDB/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/amazonRDSMySQLDB/en_US.json",
        "slug": "RDSMySQL",
        "mvpSupport": false,
        "comparableTerms": [
            "rdsmysql",
            "rdsmysqldb"
        ]
    },
    "amazonRdsForOracle": {
        "name": "Amazon RDS for Oracle",
        "serviceCode": "amazonRdsForOracle",
        "description": "Oracle® Database is a relational database management system developed by Oracle. Amazon RDS makes it easy to set up, operate, and scale Oracle Database deployments in the cloud. With Amazon RDS, you can deploy multiple editions of Oracle Database in minutes with cost-efficient and re-sizable hardware capacity.",
        "searchKeywords": [],
        "type": "AWSService",
        "regions": [
            "us-west-2",
            "us-west-1",
            "us-east-2",
            "us-east-1",
            "sa-east-1",
            "me-south-1",
            "me-central-1",
            "af-south-1",
            "eu-north-1",
            "eu-west-3",
            "eu-west-2",
            "eu-west-1",
            "eu-south-1",
            "eu-central-1",
            "ca-central-1",
            "us-gov-east-1",
            "us-gov-west-1",
            "ap-northeast-1",
            "ap-southeast-2",
            "ap-southeast-1",
            "ap-northeast-2",
            "ap-northeast-3",
            "ap-southeast-3",
            "ap-south-1",
            "ap-east-1"
        ],
        "linkUrl": "https://aws.amazon.com/rds/oracle",
        "isActive": "true",
        "hasDataTransfer": false,
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonRdsForOracle/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/amazonRdsForOracle/en_US.json",
        "slug": "amazonRDSOracle",
        "mvpSupport": false,
        "comparableTerms": [
            "rdsfororacle",
            "rdsoracle"
        ]
    },
    "amazonRDSPostgreSQLDB": {
        "name": "Amazon RDS for PostgreSQL",
        "serviceCode": "amazonRDSPostgreSQLDB",
        "description": "Amazon RDS makes it easy to set up, operate, and scale PostgreSQL deployments in the cloud. With Amazon RDS, you can deploy scalable PostgreSQL deployments in minutes with cost-efficient and resizable hardware capacity. ",
        "searchKeywords": [
            "Database",
            "PostgreSQL",
            "postgresql",
            "database hosting",
            "hosted database",
            "Managed database"
        ],
        "type": "AWSService",
        "regions": [
            "af-south-1",
            "ap-northeast-1",
            "ap-northeast-2",
            "ap-northeast-3",
            "ap-south-1",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-southeast-3",
            "ca-central-1",
            "eu-central-1",
            "eu-north-1",
            "eu-south-1",
            "eu-west-1",
            "eu-west-2",
            "eu-west-3",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-gov-west-1",
            "us-west-1",
            "us-west-2",
            "us-gov-east-1",
            "ap-east-1",
            "me-south-1",
            "me-central-1"
        ],
        "linkUrl": "https://aws.amazon.com/rds/postgresql",
        "isActive": "true",
        "hasDataTransfer": true,
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonRDSPostgreSQLDB/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/amazonRDSPostgreSQLDB/en_US.json",
        "slug": "RDSPostgreSQL",
        "mvpSupport": false,
        "comparableTerms": [
            "rdspostgresql",
            "rdspostgresqldb"
        ]
    },
    "amazonRDSForSQLServer": {
        "name": "Amazon RDS for SQL server",
        "serviceCode": "amazonRDSForSQLServer",
        "description": "SQL Server is a relational database management system developed by Microsoft. Amazon RDS for SQL Server makes it easy to set up, operate, and scale SQL Server deployments in the cloud.",
        "searchKeywords": [
            "Database",
            "Aurora",
            "MySQL",
            "MariaDB",
            "Postgres",
            "Oracle",
            "SQL Server",
            "Database",
            "PostgreSQL",
            "Microsoft SQL Server",
            "Relational Database Service",
            "Database",
            "database hosting",
            "hosted database",
            "Managed database",
            "microsoft",
            "sql",
            "msft",
            "Managed Service",
            "MS",
            "Managed",
            "win"
        ],
        "type": "AWSService",
        "regions": [
            "af-south-1",
            "us-west-2",
            "us-west-1",
            "us-east-2",
            "us-east-1",
            "sa-east-1",
            "me-south-1",
            "me-central-1",
            "eu-north-1",
            "eu-west-3",
            "eu-west-2",
            "eu-west-1",
            "eu-south-1",
            "eu-central-1",
            "ca-central-1",
            "us-gov-east-1",
            "us-gov-west-1",
            "ap-northeast-1",
            "ap-southeast-3",
            "ap-southeast-2",
            "ap-southeast-1",
            "ap-northeast-2",
            "ap-northeast-3",
            "ap-south-1",
            "ap-east-1"
        ],
        "linkUrl": "https://aws.amazon.com/rds/",
        "isActive": "true",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonRDSForSQLServer/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/amazonRDSForSQLServer/en_US.json",
        "slug": "RDSSQLServer",
        "mvpSupport": false,
        "comparableTerms": [
            "rds",
            "rdsforsqlserver",
            "rdssqlserver"
        ]
    },
    "amazonRdsForOutposts": {
        "name": "Amazon RDS on AWS Outposts",
        "serviceCode": "amazonRdsForOutposts",
        "description": "Amazon Relational Database Service (Amazon RDS) on AWS Outposts allows you to deploy fully managed database instances in your on-premises environments. AWS Outposts is a fully managed service that extends AWS infrastructure, AWS services, APIs, and tools to virtually any datacenter, co-location space, or on-premises facility for a truly consistent hybrid experience. You can deploy Amazon RDS on Outposts to set up, operate, and scale Microsoft SQL Server, MySQL and PostgreSQL relational databases on premises, just as you would in the cloud. Amazon RDS on Outposts provides cost-efficient and resizable capacity for on-premises databases, while automating time-consuming administration tasks including infrastructure provisioning, database setup, patching, and backups, freeing you to focus on your applications.",
        "searchKeywords": [],
        "type": "AWSService",
        "regions": [
            "af-south-1",
            "ap-east-1",
            "ap-east-1",
            "ap-northeast-1",
            "ap-northeast-2",
            "ap-south-1",
            "ap-southeast-1",
            "ap-southeast-2",
            "ca-central-1",
            "eu-central-1",
            "eu-north-1",
            "eu-south-1",
            "eu-west-1",
            "eu-west-2",
            "eu-west-3",
            "me-south-1",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/rds/outposts",
        "isActive": "true",
        "hasDataTransfer": false,
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonRdsForOutposts/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "slug": "RDSOutposts",
        "mvpSupport": false,
        "comparableTerms": [
            "rdsforoutposts",
            "rdsonoutposts",
            "rdsoutposts"
        ]
    },
    "amazonRedshift": {
        "name": "Amazon Redshift",
        "serviceCode": "amazonRedshift",
        "description": "Amazon Redshift is a fully managed, petabyte-scale data warehouse service in the cloud. Amazon Redshift also extends data warehouse queries to your data lake, with no loading required. You can run analytic queries against petabytes of data stored locally in Redshift, and directly against exabytes of data stored in Amazon S3.",
        "searchKeywords": [
            "Database",
            "data warehouse",
            "data warehouse solution",
            "MySQL",
            "SQL",
            "data analysis",
            "business intelligence",
            "dw",
            "datawarehouse"
        ],
        "type": "AWSService",
        "regions": [
            "af-south-1",
            "ap-east-1",
            "ap-south-1",
            "ap-northeast-3",
            "ap-northeast-2",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-southeast-3",
            "ap-northeast-1",
            "us-gov-west-1",
            "us-gov-east-1",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "eu-west-3",
            "eu-north-1",
            "eu-south-1",
            "me-south-1",
            "me-central-1",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/redshift/",
        "isActive": "true",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonRedshift/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "slug": "Redshift",
        "mvpSupport": false,
        "comparableTerms": [
            "redshift"
        ]
    },
    "amazonRekognition": {
        "name": "Amazon Rekognition",
        "serviceCode": "amazonRekognition",
        "description": "Amazon Rekognition makes it easy to add image and video analysis to your applications using proven, highly scalable, deep learning technology that requires no machine learning expertise to use. With Amazon Rekognition, you can identify objects, people, text, scenes, and activities in images and videos, as well as detect any inappropriate content.",
        "searchKeywords": [
            "Rekognition",
            "image",
            "custom labels",
            "video"
        ],
        "type": "AWSService",
        "regions": [],
        "linkUrl": "https://aws.amazon.com/rekognition/",
        "isActive": "true",
        "subType": "subServiceSelector",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonRekognition/en_US.json",
        "c2e": false,
        "templates": [
            "rekognitionImage",
            "rekognitionVideo",
            "rekognitionStreamingVideoEvents",
            "rekognitionCustomLabels"
        ],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/amazonRekognition/en_US.json",
        "slug": "Rekognition",
        "mvpSupport": false,
        "comparableTerms": [
            "rekognition"
        ]
    },
    "amazonRoute53": {
        "name": "Amazon Route 53",
        "serviceCode": "amazonRoute53",
        "description": "Amazon Route 53 is a cloud Domain Name System (DNS) web service.",
        "searchKeywords": [],
        "type": "AWSService",
        "regions": [
            "ap-northeast-1",
            "ap-northeast-2",
            "ap-south-1",
            "ap-southeast-1",
            "ap-southeast-2",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "eu-west-3",
            "me-south-1",
            "me-central-1",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-gov-west-1",
            "us-west-1",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/route53/",
        "isActive": "true",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonRoute53/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/amazonRoute53/en_US.json",
        "slug": "Route53",
        "mvpSupport": false,
        "comparableTerms": [
            "route53"
        ]
    },
    "amazonS3": {
        "name": "Amazon S3",
        "serviceCode": "amazonS3",
        "description": "Amazon Simple Storage Service (Amazon S3) is the largest and most performant, secure, and feature-rich object storage service. With Amazon S3, organizations of all sizes and industries can store any amount of data for any use case, including applications, IoT, data lakes, analytics, backup and restore, archive, and disaster recovery.",
        "type": "AWSService",
        "regions": [
            "us-east-1",
            "us-east-2",
            "us-west-2",
            "eu-west-1",
            "eu-west-2",
            "eu-central-1",
            "ap-northeast-1",
            "ap-northeast-2",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-south-1"
        ],
        "linkUrl": "https://aws.amazon.com/s3",
        "isActive": "false",
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonS3/en_US.json",
        "comparableTerms": [
            "s3"
        ]
    },
    "amazonGlacier": {
        "name": "Amazon S3 Glacier (Glacier API only)",
        "serviceCode": "amazonGlacier",
        "description": "S3 Glacier is a secure, durable, and low-cost storage class for data archiving. You can reliably store any amount of data at costs that are competitive with or cheaper than on-premises solutions. To keep costs low yet suitable for varying needs, S3 Glacier provides three retrieval options that range from a few minutes to hours.",
        "searchKeywords": [],
        "type": "AWSService",
        "regions": [
            "af-south-1",
            "ap-east-1",
            "ap-northeast-1",
            "ap-northeast-2",
            "ap-northeast-3",
            "ap-south-1",
            "ap-southeast-1",
            "ap-southeast-2",
            "ca-central-1",
            "eu-central-1",
            "eu-north-1",
            "eu-south-1",
            "eu-west-1",
            "eu-west-2",
            "eu-west-3",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-gov-east-1",
            "us-gov-west-1",
            "us-west-1",
            "us-west-2",
            "me-south-1",
            "me-central-1"
        ],
        "linkUrl": "https://aws.amazon.com/glacier/",
        "isActive": "false",
        "hasDataTransfer": true,
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonGlacier/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/amazonGlacier/en_US.json",
        "slug": "S3Glacier",
        "mvpSupport": false,
        "comparableTerms": [
            "glacier",
            "glacierapionly",
            "s3glacier",
            "s3glacierglacierapionly"
        ]
    },
    "amazonSageMaker": {
        "name": "Amazon SageMaker",
        "serviceCode": "amazonSageMaker",
        "description": "With Amazon SageMaker, you pay only for what you use. Building, training, and deploying ML models is billed by the second, with no minimum fees and no upfront commitments. Pricing within Amazon SageMaker is broken down by on-demand ML instances, ML storage, and fees for data processing in hosting instances.",
        "searchKeywords": [
            "Sagemaker",
            "Model",
            "ML",
            "Machine Learning",
            "EI",
            "data scientist",
            "Data Wrangler",
            "Feature Store",
            "Sagemaker Edge"
        ],
        "type": "AWSService",
        "regions": [],
        "linkUrl": "https://aws.amazon.com/sagemaker/",
        "isActive": "true",
        "subType": "subServiceSelector",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonSageMaker/en_US.json",
        "c2e": false,
        "templates": [
            "sageMakerStudioNotebooks",
            "sageMakerRStudioOnSageMaker",
            "sageMakerOnDemandNotebookInstances",
            "sageMakerProcessing",
            "sageMakerDataWrangler",
            "sageMakerFeatureStore",
            "sageMakerTraining",
            "sageMakerRealTimeInference",
            "sageMakerAsynchronousInference",
            "sageMakerBatchTransform",
            "amazonSageMakerEdgeManager",
            "sageMakerServerlessInference",
            "sageMakerAutopilot"
        ],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/amazonSageMaker/en_US.json",
        "slug": "SageMaker",
        "mvpSupport": false,
        "comparableTerms": [
            "sagemaker"
        ]
    },
    "amazonSageMakerGroundTruth": {
        "name": "Amazon SageMaker Ground Truth",
        "serviceCode": "amazonSageMakerGroundTruth",
        "description": "Amazon SageMaker Ground Truth helps you build training datasets for machine learning. Ground Truth will label your content (images, audio, text, etc) by guiding a human labeler step-by-step in a process called a workflow.",
        "searchKeywords": [
            "Sagemaker",
            "ground truth",
            "computer vision",
            "3d point clouds",
            "image labeling",
            "labeler",
            "Model",
            "ML",
            "Machine Learning",
            "EI",
            "data scientist"
        ],
        "type": "AWSService",
        "regions": [
            "us-east-1",
            "eu-west-1",
            "ap-southeast-1",
            "ap-northeast-1",
            "us-west-2",
            "ap-southeast-2",
            "eu-central-1",
            "ap-northeast-2",
            "ap-south-1",
            "us-east-2",
            "ca-central-1",
            "eu-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/sagemaker/groundtruth/",
        "isActive": "true",
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonSageMakerGroundTruth/en_US.json",
        "c2e": false,
        "slug": "SageMakerGroundTruth",
        "mvpSupport": false,
        "comparableTerms": [
            "sagemakergroundtruth"
        ]
    },
    "amazonSimpleEmailService": {
        "name": "Amazon Simple Email Service (SES)",
        "serviceCode": "amazonSimpleEmailService",
        "description": "Amazon Simple Email Service (Amazon SES) is a cloud-based email sending service designed to help digital marketers and application developers send marketing, notification, and transactional emails.",
        "searchKeywords": [
            "SES",
            "Email",
            "Amazon Simple Email Service",
            "Simple Email Service"
        ],
        "type": "AWSService",
        "regions": [
            "af-south-1",
            "ap-south-1",
            "ap-northeast-2",
            "ap-northeast-3",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-northeast-1",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "eu-west-3",
            "eu-north-1",
            "eu-south-1",
            "me-south-1",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2",
            "us-west-2-wl1",
            "us-gov-west-1"
        ],
        "linkUrl": "https://aws.amazon.com/ses/",
        "isActive": "true",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonSimpleEmailService/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/amazonSimpleEmailService/en_US.json",
        "slug": "SES",
        "mvpSupport": false,
        "comparableTerms": [
            "ses",
            "simpleemail",
            "simpleemailservice",
            "simpleemailserviceses"
        ]
    },
    "amazonSimpleNotificationService": {
        "name": "Amazon Simple Notification Service (SNS)",
        "serviceCode": "amazonSimpleNotificationService",
        "description": "Amazon Simple Notification Service (SNS) is a highly available, durable, secure, fully managed pub/sub messaging service that enables you to decouple microservices, distributed systems, and serverless applications.",
        "searchKeywords": [
            "Messaging",
            "SNS",
            "notification topic",
            "publish message",
            "subscription",
            "text message",
            "sms",
            "topics",
            "push notifications",
            "push notification service queuing"
        ],
        "type": "AWSService",
        "regions": [],
        "linkUrl": "https://aws.amazon.com/sns/",
        "isActive": "true",
        "subType": "subServiceSelector",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonSimpleNotificationService/en_US.json",
        "c2e": false,
        "templates": [
            "standardTopics",
            "fifoTopics"
        ],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/amazonSimpleNotificationService/en_US.json",
        "slug": "SNS",
        "mvpSupport": false,
        "comparableTerms": [
            "simplenotification",
            "simplenotificationservice",
            "simplenotificationservicesns",
            "sns"
        ]
    },
    "amazonSimpleQueueService": {
        "name": "Amazon Simple Queue Service (SQS)",
        "serviceCode": "amazonSimpleQueueService",
        "description": "Amazon Simple Queue Service (SQS) is a fully managed message queuing service that enables you to decouple and scale microservices, distributed systems, and serverless applications.",
        "searchKeywords": [
            "Messaging",
            "SQS",
            "queue service",
            "push notifications",
            "queueing",
            "message queueing",
            "batch processing",
            "managed queue",
            "transmit data",
            "hosted queues",
            "storing messages",
            "move data",
            "perform tasks",
            "decouple componenets",
            "message processing",
            "message repository",
            "temporary repository",
            "message delivery",
            "distributed queues",
            "delay queues"
        ],
        "type": "AWSService",
        "regions": [
            "af-south-1",
            "ap-east-1",
            "ap-south-1",
            "ap-northeast-3",
            "ap-northeast-2",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-southeast-3",
            "ap-northeast-1",
            "us-gov-west-1",
            "us-gov-east-1",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "eu-west-3",
            "eu-south-1",
            "eu-north-1",
            "me-south-1",
            "me-central-1",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/sqs",
        "isActive": "true",
        "hasDataTransfer": true,
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonSimpleQueueService/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "slug": "SQS",
        "mvpSupport": false,
        "comparableTerms": [
            "simplequeue",
            "simplequeueservice",
            "simplequeueservicesqs",
            "sqs"
        ]
    },
    "amazonSimpleStorageServiceGroup": {
        "name": "Amazon Simple Storage Service (S3)",
        "serviceCode": "amazonSimpleStorageServiceGroup",
        "description": "Amazon Simple Storage Service (Amazon S3) is storage for the internet. You can use Amazon S3 to store and retrieve any amount of data at any time, from anywhere on the web.",
        "searchKeywords": [
            "Storage",
            "Simple Storage Service",
            "bucket",
            "file storage",
            "cloud storage",
            "static website hosting",
            "object storage",
            "store objects",
            "store files",
            "data migration",
            "ongoing data ingestion",
            "backup and recovery",
            "big data analytics",
            "nearline archive",
            "disaster recovery",
            "content distribution",
            "cloud storage",
            "S3",
            "s3"
        ],
        "type": "AWSService",
        "regions": [],
        "linkUrl": "https://aws.amazon.com/s3/",
        "isActive": "true",
        "subType": "subServiceSelector",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonSimpleStorageServiceGroup/en_US.json",
        "c2e": false,
        "templates": [
            "amazonS3Standard",
            "amazonS3IntelligentTiering",
            "amazonS3StandardInfrequentAccess",
            "s3OneZoneInfrequentAccess",
            "amazonS3Glacier",
            "amazonS3GlacierDeepArhive",
            "amazonS3StorageManagement",
            "s3ObjectLambda",
            "s3GlacierInstantRetrieval",
            "awsS3DataTransfer"
        ],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/amazonSimpleStorageServiceGroup/en_US.json",
        "slug": "S3",
        "mvpSupport": false,
        "comparableTerms": [
            "s3",
            "simplestorageservicegroup",
            "simplestorageservices3"
        ]
    },
    "amazonSimpleWorkflowService": {
        "name": "Amazon Simple Workflow Service (SWF)",
        "serviceCode": "amazonSimpleWorkflowService",
        "description": "Amazon SWF helps developers build, run, and scale background jobs that have parallel or sequential steps. You can think of Amazon SWF as a fully-managed state tracker and task coordinator in the Cloud.",
        "searchKeywords": [],
        "type": "AWSService",
        "regions": [
            "af-south-1",
            "ap-east-1",
            "ap-northeast-1",
            "ap-northeast-2",
            "ap-northeast-3",
            "ap-south-1",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-southeast-3",
            "ca-central-1",
            "eu-central-1",
            "eu-north-1",
            "eu-south-1",
            "eu-west-1",
            "eu-west-2",
            "eu-west-3",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-gov-east-1",
            "us-gov-west-1",
            "us-west-1",
            "us-west-2",
            "me-south-1",
            "me-central-1"
        ],
        "linkUrl": "https://aws.amazon.com/swf/",
        "isActive": "true",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonSimpleWorkflowService/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "slug": "SWF",
        "mvpSupport": false,
        "comparableTerms": [
            "simpleworkflow",
            "simpleworkflowservice",
            "simpleworkflowserviceswf",
            "swf"
        ]
    },
    "amazonTextract": {
        "name": "Amazon Textract",
        "serviceCode": "amazonTextract",
        "description": "Amazon Textract is a fully managed machine learning service that automatically extracts printed text, handwriting, and other data from scanned documents that goes beyond simple optical character recognition (OCR) to identify, understand, and extract data from forms and tables.",
        "searchKeywords": [
            "textract",
            "text"
        ],
        "type": "AWSService",
        "regions": [
            "us-gov-west-1",
            "us-gov-east-1",
            "ap-south-1",
            "ap-northeast-2",
            "ap-southeast-1",
            "ap-southeast-2",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "eu-west-3",
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/textract/",
        "isActive": "true",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonTextract/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "bulkImportEnabled": false,
        "serviceDefinitionUrlPath": "/data/amazonTextract/en_US.json",
        "slug": "Textract",
        "mvpSupport": false,
        "comparableTerms": [
            "textract"
        ]
    },
    "amazonTranscribe": {
        "name": "Amazon Transcribe",
        "serviceCode": "amazonTranscribe",
        "description": "Amazon Transcribe is a fully-managed automatic speech recognition (ASR) service that makes it easy for developers to add speech-to-text capabilities to voice applications. Powered by deep learning, the service supports transcription through its batch file (asynchronous) and streaming (real-time) APIs. Amazon Transcribe offers accurate transcription across more than 30 global languages and accents.",
        "searchKeywords": [
            "transcribe",
            "transcription",
            "STT",
            "VTT",
            "audio",
            "voice",
            "subtitles",
            "caption",
            "language",
            "scribes",
            "vocabulary",
            "medical",
            "archiving",
            "archives",
            "call",
            "analytics",
            "call analytics"
        ],
        "type": "AWSService",
        "regions": [
            "af-south-1",
            "ap-east-1",
            "ap-northeast-1",
            "ap-northeast-2",
            "ap-south-1",
            "ap-southeast-1",
            "ap-southeast-2",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "eu-west-3",
            "eu-north-1",
            "sa-east-1",
            "me-south-1",
            "us-east-1",
            "us-east-2",
            "us-gov-east-1",
            "us-gov-west-1",
            "us-west-1",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/transcribe/",
        "isActive": "true",
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonTranscribe/en_US.json",
        "c2e": false,
        "slug": "Transcribe",
        "mvpSupport": false,
        "comparableTerms": [
            "transcribe"
        ]
    },
    "amazonTranscribeMedical": {
        "name": "Amazon Transcribe Medical",
        "serviceCode": "amazonTranscribeMedical",
        "description": "Amazon Transcribe Medical is a HIPAA-eligible automatic speech recognition (ASR) service that makes it easy for developers to add speech-to-text capabilities to their healthcare and life science applications.",
        "searchKeywords": [
            "transcribe",
            "transcription",
            "STT",
            "VTT",
            "audio",
            "voice",
            "subtitles",
            "caption",
            "language",
            "scribes",
            "vocabulary",
            "medical",
            "archiving",
            "archives"
        ],
        "type": "AWSService",
        "regions": [
            "ap-southeast-2",
            "ca-central-1",
            "eu-west-1",
            "us-east-1",
            "us-east-2",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/transcribe/",
        "isActive": "true",
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonTranscribeMedical/en_US.json",
        "c2e": false,
        "slug": "TranscribeMedical",
        "comparableTerms": [
            "transcribe",
            "transcribemedical"
        ]
    },
    "amazonTranslate": {
        "name": "Amazon Translate",
        "serviceCode": "amazonTranslate",
        "description": "Amazon Translate is a neural machine translation service that delivers fast, high-quality, and affordable language translation. Neural machine translation is a form of language translation automation that uses deep learning models to deliver more accurate and more natural sounding translation than traditional statistical and rule-based translation algorithms.",
        "searchKeywords": [
            "NLP",
            "Natural language processing",
            "language transalation",
            "Text analytics",
            "Language translation",
            "Amazon translate",
            "Translate"
        ],
        "type": "AWSService",
        "regions": [],
        "linkUrl": "https://aws.amazon.com/translate/",
        "isActive": "true",
        "subType": "subServiceSelector",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonTranslate/en_US.json",
        "c2e": false,
        "templates": [
            "standardRealTimeTranslation",
            "standardBatchTranslation",
            "activeCustomBatchTranslation"
        ],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/amazonTranslate/en_US.json",
        "slug": "Translate",
        "mvpSupport": false,
        "comparableTerms": [
            "translate"
        ]
    },
    "amazonVirtualPrivateCloud": {
        "name": "Amazon Virtual Private Cloud (VPC)",
        "serviceCode": "amazonVirtualPrivateCloud",
        "description": "Amazon Virtual Private Cloud (Amazon VPC) lets you provision a logically isolated section of the AWS Cloud where you can launch AWS resources in a virtual network that you define.",
        "searchKeywords": [
            "access control",
            "ACL",
            "AWS Privatelink",
            "Cloud connectivity",
            "corporate network",
            "elastic IP",
            "Gateway load balancer",
            "home network VPN",
            "IPAM",
            "NAT",
            "NAT gateway",
            "Network Access Analyzer",
            "Network Address Translation",
            "Networking Content Delivery",
            "PrivateLink",
            "Reachability Analyzer",
            "security",
            "single tenant hardware",
            "static ip",
            "subnets",
            "Traffic mirroring",
            "Transit Gateway",
            "Virtual Private Cloud",
            "VPN"
        ],
        "type": "AWSService",
        "regions": [],
        "linkUrl": "https://aws.amazon.com/vpc/",
        "isActive": "true",
        "subType": "subServiceSelector",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonVirtualPrivateCloud/en_US.json",
        "c2e": false,
        "templates": [
            "vpnConnectionVpc",
            "networkAddressTranslationNatGatewayVpc",
            "transitGatewayVpc",
            "awsPrivateLinkVpc",
            "dataTransferVpc",
            "gatewayLoadBalancerVpc",
            "ipamVpc",
            "networkAccessAnalyzerVpc",
            "trafficMirroringVpc",
            "reachabilityAnalyzerVpc",
            "cloudWan"
        ],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/amazonVirtualPrivateCloud/en_US.json",
        "slug": "VPC",
        "mvpSupport": false,
        "comparableTerms": [
            "virtualprivatecloud",
            "virtualprivatecloudvpc",
            "vpc"
        ]
    },
    "amazonWorkdocs": {
        "name": "Amazon WorkDocs",
        "serviceCode": "amazonWorkdocs",
        "description": "Amazon WorkDocs is a fully managed, secure content creation, storage, and collaboration service. With Amazon WorkDocs, you can easily create, edit, and share content, and because it’s stored centrally on AWS, access it from anywhere on any device.",
        "searchKeywords": [],
        "type": "AWSService",
        "regions": [
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-northeast-1",
            "eu-west-1",
            "us-east-1",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/workdocs/",
        "isActive": "true",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonWorkdocs/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "slug": "WorkDocs",
        "mvpSupport": false,
        "comparableTerms": [
            "workdocs"
        ]
    },
    "amazonWorkmail": {
        "name": "Amazon WorkMail",
        "serviceCode": "amazonWorkmail",
        "description": "Amazon WorkMail is a secure, managed business email and calendar service with support for existing desktop and mobile email client applications. Amazon WorkMail gives users the ability to seamlessly access their email, contacts, and calendars using the client application of their choice, including Microsoft Outlook, native iOS and Android email applications, any client application supporting the IMAP protocol, or directly through a web browser. You can integrate Amazon WorkMail with your existing corporate directory, use email journaling to meet compliance requirements, and control both the keys that encrypt your data and the location in which your data is stored. You can also set up interoperability with Microsoft Exchange Server, and programmatically manage users, groups, and resources using the Amazon WorkMail SDK.",
        "searchKeywords": [
            "workmail",
            "business email",
            "managed email",
            "calendar service",
            "managed service",
            "outlook",
            "iOS",
            "andriod",
            "email applications",
            "exchange server",
            "IMAP"
        ],
        "type": "AWSService",
        "regions": [
            "eu-west-1",
            "us-east-1",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/workmail/",
        "isActive": "true",
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonWorkmail/en_US.json",
        "c2e": false,
        "slug": "WorkMail",
        "mvpSupport": false,
        "comparableTerms": [
            "workmail"
        ]
    },
    "amazonWorkspaces": {
        "name": "Amazon WorkSpaces",
        "serviceCode": "amazonWorkspaces",
        "description": "Amazon WorkSpaces is a managed, secure cloud desktop service. You can use Amazon WorkSpaces to provision either Windows or Linux desktops in just a few minutes and quickly scale to provide thousands of desktops to workers across the globe.",
        "searchKeywords": [
            "cloud desktop",
            "workspaces"
        ],
        "type": "AWSService",
        "regions": [
            "us-gov-west-1",
            "ap-south-1",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-northeast-1",
            "ap-northeast-2",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "us-east-1",
            "us-west-2",
            "sa-east-1"
        ],
        "linkUrl": "https://aws.amazon.com/workspaces/",
        "isActive": "true",
        "hasDataTransfer": false,
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonWorkspaces/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "bulkImportEnabled": false,
        "serviceDefinitionUrlPath": "/data/amazonWorkspaces/en_US.json",
        "slug": "WorkSpaces",
        "mvpSupport": false,
        "comparableTerms": [
            "workspaces"
        ]
    },
    "applicationLoadBalancer": {
        "name": "Application Load Balancer",
        "serviceCode": "applicationLoadBalancer",
        "description": "Elastic Load Balancing automatically distributes incoming application traffic across multiple targets, such as Amazon EC2 instances, containers, IP addresses, and Lambda functions.",
        "searchKeywords": [
            "ELB",
            "Elastic Load Balancer",
            "Load Balancer",
            "Application Load Balancer",
            "Network Load Balancer",
            "Classic Load Balancer"
        ],
        "type": "AWSService",
        "regions": [
            "af-south-1",
            "ap-east-1",
            "ap-northeast-1",
            "ap-northeast-2",
            "ap-northeast-3",
            "ap-south-1",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-southeast-3",
            "ca-central-1",
            "eu-central-1",
            "eu-north-1",
            "eu-south-1",
            "eu-west-1",
            "eu-west-2",
            "eu-west-3",
            "me-south-1",
            "me-central-1",
            "sa-east-1",
            "us-gov-east-1",
            "us-gov-west-1",
            "us-east-1",
            "us-east-1-atl-1",
            "us-east-1-bos-1",
            "us-east-1-chi-1",
            "us-east-1-dfw-1",
            "us-east-1-iah-1",
            "us-east-1-mci-1",
            "us-east-1-mia-1",
            "us-east-1-msp-1",
            "us-east-1-nyc-1",
            "us-east-1-phl-1",
            "us-east-2",
            "us-west-1",
            "us-west-2",
            "us-west-2-den-1",
            "us-west-2-las-1",
            "us-west-2-lax-1",
            "us-west-2-pdx-1",
            "us-west-2-phx-1",
            "us-west-2-sea-1",
            "us-east-1-wl1",
            "us-east-1-wl1-atl1",
            "us-east-1-wl1-chi1",
            "us-east-1-wl1-clt1",
            "us-east-1-wl1-dfw1",
            "us-east-1-wl1-dtw1",
            "us-east-1-wl1-iah1",
            "us-east-1-wl1-mia1",
            "us-east-1-wl1-msp1",
            "us-east-1-wl1-nyc1",
            "us-east-1-wl1-was1",
            "us-west-2-wl1",
            "us-west-2-wl1-den1",
            "us-west-2-wl1-las1",
            "us-west-2-wl1-lax1",
            "us-west-2-wl1-phx1",
            "us-west-2-wl1-sea1"
        ],
        "linkUrl": "https://aws.amazon.com/elasticloadbalancing/",
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/applicationLoadBalancer/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "bulkImportEnabled": false,
        "serviceDefinitionUrlPath": "/data/applicationLoadBalancer/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "applicationloadbalancer"
        ],
        "parentServiceCode": "elasticLoadBalancing"
    },
    "appSyncApiCall": {
        "name": "AppSync API Request",
        "serviceCode": "appSyncApiCall",
        "searchKeywords": [
            "query",
            "graphql",
            "api"
        ],
        "type": "AWSService",
        "regions": [
            "ap-east-1",
            "ap-south-1",
            "ap-northeast-3",
            "ap-northeast-2",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-northeast-1",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "eu-south-1",
            "eu-west-3",
            "eu-north-1",
            "me-south-1",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/appsync/",
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/appSyncApiCall/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/appSyncApiCall/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "appsyncapicall",
            "appsyncapirequest"
        ],
        "parentServiceCode": "awsAppSync"
    },
    "appSyncCaching": {
        "name": "AppSync Caching",
        "serviceCode": "appSyncCaching",
        "searchKeywords": [
            "query",
            "graphql",
            "api"
        ],
        "type": "AWSService",
        "regions": [
            "ap-east-1",
            "ap-south-1",
            "ap-northeast-3",
            "ap-northeast-2",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-northeast-1",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "eu-south-1",
            "eu-west-3",
            "eu-north-1",
            "me-south-1",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/appsync/",
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/appSyncCaching/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/appSyncCaching/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "appsynccaching"
        ],
        "parentServiceCode": "awsAppSync"
    },
    "appsyncDataTransfer": {
        "name": "Appsync Data Transfer",
        "serviceCode": "appsyncDataTransfer",
        "searchKeywords": [
            "data transfer"
        ],
        "type": "AWSService",
        "regions": [
            "ap-east-1",
            "ap-south-1",
            "ap-northeast-3",
            "ap-northeast-2",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-northeast-1",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "eu-south-1",
            "eu-west-3",
            "eu-north-1",
            "me-south-1",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/appsync/",
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/appsyncDataTransfer/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "bulkImportEnabled": false,
        "serviceDefinitionUrlPath": "/data/appsyncDataTransfer/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "appsyncdatatransfer"
        ],
        "parentServiceCode": "awsAppSync"
    },
    "appSyncRealTime": {
        "name": "AppSync Real-Time",
        "serviceCode": "appSyncRealTime",
        "searchKeywords": [
            "query"
        ],
        "type": "AWSService",
        "regions": [
            "ap-east-1",
            "ap-south-1",
            "ap-northeast-3",
            "ap-northeast-2",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-northeast-1",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "eu-south-1",
            "eu-west-3",
            "eu-north-1",
            "me-south-1",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/appsync/",
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/appSyncRealTime/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/appSyncRealTime/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "appsyncrealtime"
        ],
        "parentServiceCode": "awsAppSync"
    },
    "as2": {
        "name": "AS2",
        "serviceCode": "as2",
        "searchKeywords": [
            "sftp",
            "FTPS",
            "as2",
            "amazon s3",
            "s3",
            "winscp",
            "filezilla",
            "cyberduck",
            "ssh",
            "transfer",
            "ftp",
            "ftp/s",
            "openssh",
            "file transfer",
            "secure file transfer",
            "ssh ftp",
            "secure shell file transfer protocol",
            "file transfer protocol"
        ],
        "type": "AWSService",
        "regions": [
            "ap-east-1",
            "ap-northeast-1",
            "ap-northeast-2",
            "ap-south-1",
            "ap-southeast-1",
            "ap-southeast-2",
            "ca-central-1",
            "eu-central-1",
            "eu-north-1",
            "eu-west-1",
            "eu-west-2",
            "eu-west-3",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2",
            "us-gov-west-1",
            "us-gov-east-1"
        ],
        "linkUrl": "https://aws.amazon.com/aws-transfer-family/",
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/as2/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "bulkImportEnabled": false,
        "serviceDefinitionUrlPath": "/data/as2/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "as2"
        ],
        "parentServiceCode": "aWSTransferForSFTP"
    },
    "amazonAuroraBackup": {
        "name": "Aurora",
        "serviceCode": "amazonAuroraBackup",
        "description": "AWS Backup for Aurora",
        "searchKeywords": [],
        "type": "AWSService",
        "regions": [
            "us-gov-west-1",
            "us-gov-east-1",
            "af-south-1",
            "ap-east-1",
            "ap-south-1",
            "ap-northeast-3",
            "ap-northeast-2",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-southeast-3",
            "ap-northeast-1",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "eu-south-1",
            "eu-west-3",
            "eu-north-1",
            "me-south-1",
            "me-central-1",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/backup/",
        "isActive": "true",
        "hasDataTransfer": true,
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonAuroraBackup/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/amazonAuroraBackup/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "aurorabackup",
            "backupaurora"
        ],
        "parentServiceCode": "awsBackup"
    },
    "awsSystemsManagerAutomation": {
        "name": "Automation",
        "serviceCode": "awsSystemsManagerAutomation",
        "description": "AWS Systems Manager Automation feature",
        "searchKeywords": [
            "System Manager",
            "Automation",
            "steps",
            "automate"
        ],
        "type": "AWSService",
        "regions": [
            "us-gov-west-1",
            "us-gov-east-1",
            "af-south-1",
            "ap-east-1",
            "ap-south-1",
            "ap-northeast-3",
            "ap-northeast-2",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-southeast-3",
            "ap-northeast-1",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "eu-south-1",
            "eu-west-3",
            "eu-north-1",
            "me-south-1",
            "me-central-1",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/systems-manager/",
        "isActive": "true",
        "hasDataTransfer": false,
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/awsSystemsManagerAutomation/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/awsSystemsManagerAutomation/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "automation",
            "systemsmanagerautomation"
        ],
        "parentServiceCode": "awsSystemsManager"
    },
    "awsAmplify": {
        "name": "AWS Amplify",
        "serviceCode": "awsAmplify",
        "description": "AWS Amplify is a set of tools and services that can be used together or on their own, to help front-end web and mobile developers build scalable full stack applications, powered by AWS. With Amplify, you can create an app backend for web and mobile, and then connect your Git branch to deploy and host a web app in a few clicks.",
        "searchKeywords": [
            "authentication",
            "datastore",
            "storage",
            "console",
            "analytics",
            "mobile apps",
            "flows",
            "predictions",
            "api",
            "graphql",
            "pubsub",
            "hosting",
            "libraries",
            "user management",
            "content management",
            "UI",
            "frontend",
            "database",
            "ci/cd",
            "git",
            "amplify",
            "SSR request"
        ],
        "type": "AWSService",
        "regions": [
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2",
            "ap-east-1",
            "ap-northeast-1",
            "ap-northeast-2",
            "ap-south-1",
            "ap-southeast-1",
            "ap-southeast-2",
            "ca-central-1",
            "eu-central-1",
            "eu-north-1",
            "eu-south-1",
            "eu-west-1",
            "eu-west-2",
            "eu-west-3",
            "me-south-1",
            "sa-east-1"
        ],
        "linkUrl": "https://aws.amazon.com/amplify/",
        "isActive": "true",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/awsAmplify/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/awsAmplify/en_US.json",
        "slug": "Amplify",
        "mvpSupport": false,
        "comparableTerms": [
            "amplify"
        ]
    },
    "awsAppRunner": {
        "name": "AWS App Runner",
        "serviceCode": "awsAppRunner",
        "description": "AWS App Runner is a fully managed service that makes it easy for developers to quickly deploy containerized web applications and APIs, at scale and with no prior infrastructure experience required. Start with your source code or a container image. App Runner builds and deploys the web application automatically, load balances traffic with encryption, scales to meet your traffic needs, and makes it easy for your services to communicate with other AWS services and applications that run in a private Amazon VPC. With App Runner, rather than thinking about servers or scaling, you have more time to focus on your applications.",
        "searchKeywords": [
            "apprunner"
        ],
        "type": "AWSService",
        "regions": [
            "ap-northeast-1",
            "eu-west-1",
            "us-east-1",
            "us-east-2",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/apprunner/",
        "isActive": "true",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/awsAppRunner/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/awsAppRunner/en_US.json",
        "slug": "apprunner",
        "mvpSupport": false,
        "comparableTerms": [
            "apprunner"
        ]
    },
    "awsAppConfig": {
        "name": "AWS AppConfig",
        "serviceCode": "awsAppConfig",
        "description": "AWS AppConfig enables you to provide validation logic to ensure your configuration data is syntactically and semantically correct according to your definitions before making it available to your application. AWS AppConfig also gives you the ability to roll out configuration changes over a defined time period while monitoring your application so that you can catch errors and roll back the changes if needed, to help you minimize the impact to the users.",
        "searchKeywords": [
            "Systems Manager",
            "AppConfig",
            "configuration",
            "monitoring"
        ],
        "type": "AWSService",
        "regions": [
            "ap-east-1",
            "ap-south-1",
            "ap-northeast-2",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-southeast-3",
            "ap-northeast-1",
            "ap-northeast-3",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "eu-west-3",
            "eu-north-1",
            "me-south-1",
            "me-central-1",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/systems-manager/",
        "isActive": "true",
        "hasDataTransfer": false,
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/awsAppConfig/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/awsAppConfig/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "appconfig"
        ],
        "parentServiceCode": "awsSystemsManager"
    },
    "awsAppSync": {
        "name": "AWS AppSync",
        "serviceCode": "awsAppSync",
        "description": "AWS AppSync is a fully managed service that makes it easy to develop GraphQL APIs by handling the heavy lifting of securely connecting to data sources like AWS DynamoDB, Lambda, and more.",
        "searchKeywords": [
            "appsync",
            "query",
            "data modification",
            "data transfer"
        ],
        "type": "AWSService",
        "regions": [],
        "linkUrl": "https://aws.amazon.com/appsync/",
        "isActive": "true",
        "subType": "subServiceSelector",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/awsAppSync/en_US.json",
        "c2e": false,
        "templates": [
            "appSyncApiCall",
            "appSyncRealTime",
            "appSyncCaching",
            "appsyncDataTransfer"
        ],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/awsAppSync/en_US.json",
        "slug": "appSync",
        "mvpSupport": false,
        "comparableTerms": [
            "appsync"
        ]
    },
    "awsBackup": {
        "name": "AWS Backup",
        "serviceCode": "awsBackup",
        "description": "AWS Backup is a centralized and fully-managed service with an end-to-end solution for business and regulatory compliance requirements. Using this service, you can automate data protection across AWS services, in the cloud, and on premises. With a few clicks in the AWS Backup console, you can automate your data protection policies and schedules without creating custom scripts and manual processes.",
        "searchKeywords": [
            "data",
            "protection",
            "regulatory compliance",
            "EFS",
            "EBS",
            "RDS",
            "S3",
            "Aurora",
            "FSx",
            "Windows",
            "Lustre",
            "NetApp ONTAP",
            "OpenZFS",
            "Storage Gateway",
            "gateway",
            "VMware",
            "Neptune",
            "DynamoDB",
            "DocumentDB",
            "Backup"
        ],
        "type": "AWSService",
        "regions": [],
        "linkUrl": "https://aws.amazon.com/backup/",
        "isActive": "true",
        "subType": "subServiceSelector",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/awsBackup/en_US.json",
        "c2e": false,
        "templates": [
            "amazonEfsBackup",
            "amazonVMwareBackup",
            "amazonEbsBackup",
            "amazonRdsBackup",
            "amazonStorageGatewayBackup",
            "amazonS3Backup",
            "amazonFSxWindowsBackup",
            "amazonFSxLustreBackup",
            "amazonFSxNetAppOntapBackup",
            "amazonFSxOpenZfsBackup",
            "amazonDynamoDbBackup",
            "amazonAuroraBackup",
            "amazonNeptuneBackup",
            "amazonDocumentDbBackup"
        ],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/awsBackup/en_US.json",
        "slug": "Backup",
        "mvpSupport": false,
        "comparableTerms": [
            "backup"
        ]
    },
    "mainframeBluAge": {
        "name": "AWS Blue Age automated refactoring",
        "serviceCode": "mainframeBluAge",
        "description": "For AWS M2 Blu Age managed runtime, you can choose on-demand instances and pay for the runtime by the hour with no long-term commitments or upfront fees, or choose committed plans for additional savings.",
        "searchKeywords": [],
        "type": "AWSService",
        "regions": [
            "ap-southeast-2",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "sa-east-1",
            "us-east-1",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/mainframe-modernization/pricing/",
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/mainframeBluAge/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/mainframeBluAge/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "blueageautomatedrefactoring",
            "mainframebluage"
        ],
        "parentServiceCode": "amazonMainframeModernization"
    },
    "awsBudgets": {
        "name": "AWS Budgets",
        "serviceCode": "awsBudgets",
        "description": "AWS Budgets lets you set custom cost and usage budgets that alert you when your budget thresholds are exceeded (or forecasted to exceed). You can also create budgets to track your aggregate Reservation and Savings Plans utilization and coverage metrics.",
        "searchKeywords": [
            "budgets",
            "cost management",
            "budgets report"
        ],
        "type": "AWSService",
        "regions": [],
        "linkUrl": "https://aws.amazon.com/aws-cost-management/aws-budgets/",
        "isActive": "true",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/awsBudgets/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/awsBudgets/en_US.json",
        "slug": "budgets",
        "mvpSupport": false,
        "comparableTerms": [
            "budgets",
            "costmanagementbudgets"
        ]
    },
    "awsCloudFormation": {
        "name": "AWS CloudFormation",
        "serviceCode": "awsCloudFormation",
        "description": "AWS CloudFormation provides a common language for you to model and provision AWS and third party application extensions in your cloud environment.",
        "searchKeywords": [
            "cloudformation",
            "formation",
            "cloud",
            "application resources"
        ],
        "type": "AWSService",
        "regions": [
            "us-gov-west-1",
            "us-gov-east-1",
            "af-south-1",
            "ap-east-1",
            "ap-south-1",
            "ap-northeast-3",
            "ap-northeast-2",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-southeast-3",
            "ap-northeast-1",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "eu-south-1",
            "eu-west-3",
            "eu-north-1",
            "me-south-1",
            "me-central-1",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/cloudformation/",
        "isActive": "true",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/awsCloudFormation/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "slug": "CloudFormation",
        "mvpSupport": false,
        "comparableTerms": [
            "cloudformation"
        ]
    },
    "awsCloudHsm": {
        "name": "AWS CloudHSM",
        "serviceCode": "awsCloudHsm",
        "description": "AWS CloudHSM is a cloud-based hardware security module (HSM) that enables you to easily generate and use your own encryption keys on the AWS Cloud. With CloudHSM, you can manage your own encryption keys using FIPS 140-2 Level 3 validated HSMs.",
        "searchKeywords": [
            "crypto"
        ],
        "type": "AWSService",
        "regions": [
            "ap-east-1",
            "ap-south-1",
            "ap-northeast-2",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-northeast-1",
            "us-gov-west-1",
            "us-gov-east-1",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "eu-west-3",
            "eu-north-1",
            "me-south-1",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2",
            "eu-south-1",
            "af-south-1"
        ],
        "linkUrl": "https://aws.amazon.com/cloudhsm",
        "isActive": "true",
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/awsCloudHsm/en_US.json",
        "c2e": false,
        "slug": "CloudHSM",
        "comparableTerms": [
            "cloudhsm"
        ]
    },
    "awsCloudTrail": {
        "name": "AWS CloudTrail",
        "serviceCode": "awsCloudTrail",
        "description": "AWS CloudTrail is a service that enables governance, compliance, operational auditing, and risk auditing of your AWS account. With CloudTrail, you can log, continuously monitor, and retain account activity related to actions across your AWS infrastructure.",
        "searchKeywords": [
            "cloudtrail",
            "operational auditing",
            "governance",
            "compliance",
            "risk auditing",
            "event history",
            "unusual activity",
            "troubleshooting",
            "operational analysis",
            "logs",
            "monitor account activity",
            "trail"
        ],
        "type": "AWSService",
        "regions": [
            "af-south-1",
            "ap-east-1",
            "ap-south-1",
            "ap-northeast-3",
            "ap-northeast-2",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-southeast-3",
            "ap-northeast-1",
            "us-gov-east-1",
            "us-gov-west-1",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "eu-south-1",
            "eu-west-3",
            "eu-north-1",
            "me-south-1",
            "me-central-1",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/cloudtrail/",
        "isActive": "true",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/awsCloudTrail/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/awsCloudTrail/en_US.json",
        "slug": "CloudTrail",
        "mvpSupport": false,
        "comparableTerms": [
            "cloudtrail"
        ]
    },
    "awsCodeArtifact": {
        "name": "AWS CodeArtifact",
        "serviceCode": "awsCodeArtifact",
        "description": "AWS CodeArtifact is a fully managed artifact repository service that makes it easy for organizations of any size to securely store, publish, and share software packages used in their software development process.",
        "searchKeywords": [
            "artifacts",
            "reqeusts",
            "data transfer",
            "public aritfact repositories",
            "storage",
            "npm",
            "maven",
            "nuget",
            "pypi",
            "python",
            "nuget"
        ],
        "type": "AWSService",
        "regions": [
            "us-east-1",
            "us-east-2",
            "us-west-2",
            "eu-north-1",
            "eu-south-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "eu-west-3",
            "ap-northeast-1",
            "ap-south-1",
            "ap-southeast-1",
            "ap-southeast-2"
        ],
        "linkUrl": "https://aws.amazon.com/codeartifact/",
        "isActive": "true",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/awsCodeArtifact/en_US.json",
        "c2e": false,
        "slug": "CodeArtifact",
        "mvpSupport": false,
        "comparableTerms": [
            "codeartifact"
        ]
    },
    "awsCodeBuild": {
        "name": "AWS CodeBuild",
        "serviceCode": "awsCodeBuild",
        "description": "AWS CodeBuild is a fully managed continuous integration service that compiles source code, runs tests, and produces software packages that are ready to deploy.",
        "searchKeywords": [
            "CodeBuild",
            "Code",
            "code build"
        ],
        "type": "AWSService",
        "regions": [
            "af-south-1",
            "ap-east-1",
            "ap-northeast-1",
            "ap-northeast-2",
            "ap-south-1",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-southeast-3",
            "ca-central-1",
            "eu-central-1",
            "eu-north-1",
            "eu-west-1",
            "eu-west-2",
            "eu-west-3",
            "eu-south-1",
            "me-south-1",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-gov-west-1",
            "us-gov-east-1",
            "us-west-1",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/codebuild/",
        "isActive": "true",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/awsCodeBuild/en_US.json",
        "c2e": false,
        "slug": "codebuild",
        "mvpSupport": false,
        "comparableTerms": [
            "codebuild"
        ]
    },
    "awsCodeDeploy": {
        "name": "AWS CodeDeploy",
        "serviceCode": "awsCodeDeploy",
        "description": "AWS CodeDeploy is a fully managed deployment service that automates software deployments to a variety of compute services such as Amazon EC2, AWS Fargate, AWS Lambda, and your on-premises servers.",
        "searchKeywords": [
            "codedeploy",
            "CodeDeploy",
            "deployment"
        ],
        "type": "AWSService",
        "regions": [
            "us-gov-west-1",
            "us-gov-east-1",
            "af-south-1",
            "ap-east-1",
            "ap-south-1",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-southeast-3",
            "ap-northeast-1",
            "ap-northeast-2",
            "ap-northeast-3",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "eu-west-3",
            "eu-north-1",
            "eu-south-1",
            "me-south-1",
            "me-central-1",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/codedeploy/",
        "isActive": "true",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/awsCodeDeploy/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "slug": "CodeDeploy",
        "mvpSupport": false,
        "comparableTerms": [
            "codedeploy"
        ]
    },
    "awsCodePipeline": {
        "name": "AWS CodePipeline",
        "serviceCode": "awsCodePipeline",
        "description": "AWS CodePipeline is a fully managed continuous delivery service that helps you automate your release pipelines for fast and reliable application and infrastructure updates.",
        "searchKeywords": [
            "code",
            "pipeline"
        ],
        "type": "AWSService",
        "regions": [
            "us-gov-west-1",
            "ap-east-1",
            "ap-south-1",
            "ap-northeast-2",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-northeast-1",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "eu-south-1",
            "eu-west-3",
            "eu-north-1",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/codepipeline/",
        "isActive": "true",
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/awsCodePipeline/en_US.json",
        "c2e": false,
        "slug": "CodePipeline",
        "comparableTerms": [
            "codepipeline"
        ]
    },
    "awsConfig": {
        "name": "AWS Config",
        "serviceCode": "awsConfig",
        "description": "AWS Config is a service that enables you to assess, audit, and evaluate the configurations of your AWS resources. Config continuously monitors and records your AWS resource configurations and allows you to automate the evaluation of recorded configurations against desired configurations.",
        "searchKeywords": [
            "Management Tools",
            "management tools",
            "configuration management",
            "CMDB",
            "inventory",
            "discovery",
            "Config Rules",
            "compliance",
            "governance",
            "audit"
        ],
        "type": "AWSService",
        "regions": [
            "af-south-1",
            "ap-east-1",
            "ap-south-1",
            "ap-northeast-2",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-southeast-3",
            "ap-northeast-1",
            "us-gov-west-1",
            "us-gov-east-1",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "eu-west-3",
            "eu-north-1",
            "eu-south-1",
            "me-south-1",
            "me-central-1",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/config/",
        "isActive": "true",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/awsConfig/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "slug": "Config",
        "mvpSupport": false,
        "comparableTerms": [
            "config"
        ]
    },
    "awsCostExplorer": {
        "name": "AWS Cost Explorer",
        "serviceCode": "awsCostExplorer",
        "description": "AWS Cost Explorer provides you with a set of default reports that you can use as the starting place for your analysis. From there, use the filtering and grouping capabilities to dive deeper into your cost and usage data and generate custom insights.",
        "searchKeywords": [
            "aws cost explorer",
            "aws budgets",
            "cost management",
            "budgets"
        ],
        "type": "AWSService",
        "regions": [],
        "linkUrl": "https://aws.amazon.com/aws-cost-management/aws-cost-explorer/",
        "isActive": "true",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/awsCostExplorer/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/awsCostExplorer/en_US.json",
        "slug": "cost-explorer",
        "mvpSupport": false,
        "comparableTerms": [
            "costexplorer",
            "costmanagementcostexplorer"
        ]
    },
    "awsDataPipeline": {
        "name": "AWS Data Pipeline",
        "serviceCode": "awsDataPipeline",
        "description": "AWS Data Pipeline is a web service that helps you reliably process and move data between different AWS compute and storage services, as well as on-premises data sources, at specified intervals.",
        "searchKeywords": [
            "datapipeline",
            "data",
            "move data"
        ],
        "type": "AWSService",
        "regions": [
            "ap-northeast-1",
            "ap-southeast-2",
            "eu-west-1",
            "us-west-2",
            "us-east-1"
        ],
        "linkUrl": "https://aws.amazon.com/datapipeline/",
        "isActive": "true",
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/awsDataPipeline/en_US.json",
        "c2e": false,
        "slug": "datapipeline",
        "mvpSupport": false,
        "comparableTerms": [
            "datapipeline"
        ]
    },
    "aWSDataTransfer": {
        "name": "AWS Data Transfer",
        "serviceCode": "aWSDataTransfer",
        "description": "The cost of transferring data at AWS for services without unique transfer costs.",
        "searchKeywords": [],
        "type": "AWSService",
        "regions": [
            "af-south-1",
            "ap-east-1",
            "ap-northeast-1",
            "ap-northeast-1-wl1-nrt1",
            "ap-northeast-2",
            "ap-northeast-2-wl1-cjj1",
            "ap-northeast-2-wl1-sel1",
            "ap-northeast-3",
            "ap-south-1",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-southeast-3",
            "ca-central-1",
            "ca-central-1-wl1-yto1",
            "cloudfront",
            "me-south-1",
            "me-central-1",
            "eu-central-1",
            "eu-central-1-wl1-dtm1",
            "eu-central-1-wl1-ber1",
            "eu-central-1-wl1-muc1",
            "eu-north-1",
            "eu-south-1",
            "eu-west-1",
            "eu-west-2",
            "eu-west-2-wl1-lon1",
            "eu-west-3",
            "sa-east-1",
            "us-east-1",
            "us-east-1-atl-1",
            "us-east-1-bos-1",
            "us-east-1-chi-1",
            "us-east-1-dfw-1",
            "us-west-2-den-1",
            "us-east-1-iah-1",
            "us-east-1-mci-1",
            "us-east-1-mia-1",
            "us-east-1-msp-1",
            "us-east-1-nyc-1",
            "us-east-1-phl-1",
            "us-east-2",
            "us-gov-east-1",
            "us-gov-west-1",
            "us-west-1",
            "us-west-2",
            "us-west-2-las-1",
            "us-west-2-lax-1",
            "us-west-2-phx-1",
            "us-west-2-pdx-1",
            "us-west-2-sea-1",
            "us-west-2-wl1",
            "us-west-2-wl1-las1",
            "us-east-1-wl1",
            "us-east-1-wl1-atl1",
            "us-east-1-wl1-chi1",
            "us-east-1-wl1-clt1",
            "us-east-1-wl1-dfw1",
            "us-east-1-wl1-dtw1",
            "us-east-1-wl1-iah1",
            "us-east-1-wl1-mia1",
            "us-east-1-wl1-msp1",
            "us-east-1-wl1-bna1",
            "us-east-1-wl1-nyc1",
            "us-east-1-wl1-tpa1",
            "us-east-1-wl1-was1",
            "us-west-2-wl1-den1",
            "us-west-2-wl1-phx1",
            "us-west-2-wl1-lax1",
            "us-west-2-wl1-sea1"
        ],
        "linkUrl": "https://aws.amazon.com/ec2/pricing/on-demand/#Data_Transfer",
        "isActive": "true",
        "hasDataTransfer": true,
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/aWSDataTransfer/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "slug": "DataTransfer",
        "mvpSupport": false,
        "comparableTerms": [
            "datatransfer"
        ]
    },
    "awsDatabaseMigrationService": {
        "name": "AWS Database Migration Service",
        "serviceCode": "awsDatabaseMigrationService",
        "description": "AWS Database Migration Service helps you migrate databases to AWS quickly and securely.",
        "searchKeywords": [
            "Database",
            "Aurora",
            "MySQL",
            "MariaDB",
            "Postgres",
            "Oracle",
            "SQL Server",
            "PostgreSQL",
            "Microsoft SQL Server",
            "Migration",
            "microsoft",
            "sql",
            "msft",
            "DMS",
            "SCT",
            "DB",
            "MS",
            "win"
        ],
        "type": "AWSService",
        "regions": [
            "af-south-1",
            "ap-northeast-1",
            "ap-northeast-2",
            "ap-northeast-3",
            "ap-south-1",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-southeast-3",
            "ca-central-1",
            "eu-central-1",
            "eu-south-1",
            "eu-west-1",
            "eu-west-2",
            "eu-west-3",
            "me-central-1",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-gov-east-1",
            "us-gov-west-1",
            "us-west-1",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/dms/",
        "isActive": "true",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/awsDatabaseMigrationService/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "slug": "DMS",
        "mvpSupport": false,
        "comparableTerms": [
            "databasemigration",
            "databasemigrationservice",
            "dms"
        ]
    },
    "aWSDataSync": {
        "name": "AWS DataSync",
        "serviceCode": "aWSDataSync",
        "description": "AWS DataSync is an online data transfer service that simplifies, automates, and accelerates moving data between on-premises storage systems and AWS Storage services, as well as between AWS Storage services.",
        "searchKeywords": [],
        "type": "AWSService",
        "regions": [
            "af-south-1",
            "ap-east-1",
            "ap-south-1",
            "ap-northeast-2",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-southeast-3",
            "ap-northeast-1",
            "ap-northeast-3",
            "us-gov-east-1",
            "us-gov-west-1",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "eu-west-3",
            "eu-north-1",
            "eu-south-1",
            "me-south-1",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/datasync/",
        "isActive": "true",
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/aWSDataSync/en_US.json",
        "c2e": false,
        "slug": "DataSync",
        "mvpSupport": false,
        "comparableTerms": [
            "datasync"
        ]
    },
    "awsDeepRacer": {
        "name": "AWS DeepRacer",
        "serviceCode": "awsDeepRacer",
        "description": "With AWS DeepRacer, you can create your own machine learning models (in a process called 'training') and race them (in a process called 'evaluation'). You pay for training, evaluating and storing your machine learning models. Charges are based on the amount of time you train and evaluate a new model and the size of the model stored. Additionally, you can purchase a fully autonomous 1/18th scale DeepRacer car, which will allow you to try your models out on real tracks. No purchase is necessary to enter the DeepRacer League.",
        "searchKeywords": [
            "deepracer",
            "machine learning",
            "model training",
            "model evaluation",
            "ml"
        ],
        "type": "AWSService",
        "regions": [
            "us-east-1"
        ],
        "linkUrl": "https://aws.amazon.com/deepracer/",
        "isActive": "true",
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/awsDeepRacer/en_US.json",
        "c2e": false,
        "slug": "DeepRacer",
        "mvpSupport": false,
        "comparableTerms": [
            "deepracer"
        ]
    },
    "awsDeviceFarm": {
        "name": "AWS Device Farm",
        "serviceCode": "awsDeviceFarm",
        "description": "AWS Device Farm is an application testing service that lets you improve the quality of your web and mobile apps by testing them across an extensive range of desktop browsers and real mobile devices; without having to provision and manage any testing infrastructure. The service enables you to run your tests concurrently on multiple desktop browsers or real devices to speed up the execution of your test suite, and generates videos and logs to help you quickly identify issues with your app.",
        "searchKeywords": [
            "application testing",
            "mobile devices",
            "desktop browsers",
            "device farm",
            "automated testing",
            "remote access",
            "iOS",
            "Android",
            "unlimited testing",
            "pay as you go",
            "device minutes",
            "device slots",
            "free device minutes",
            "browser instances"
        ],
        "type": "AWSService",
        "regions": [
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/device-farm/",
        "isActive": "true",
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/awsDeviceFarm/en_US.json",
        "c2e": false,
        "slug": "DeviceFarm",
        "mvpSupport": false,
        "comparableTerms": [
            "devicefarm"
        ]
    },
    "awsDirectConnect": {
        "name": "AWS Direct Connect",
        "serviceCode": "awsDirectConnect",
        "description": "AWS Direct Connect is a cloud service solution that makes it easy to establish a dedicated network connection from your premises to AWS.",
        "searchKeywords": [
            "Direct Connect",
            "Data Transfer"
        ],
        "type": "AWSService",
        "regions": [
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2",
            "af-south-1",
            "ap-east-1",
            "ap-south-1",
            "ap-northeast-3",
            "ap-northeast-2",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-northeast-1",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "eu-south-1",
            "eu-west-3",
            "eu-north-1",
            "me-south-1",
            "me-central-1",
            "sa-east-1",
            "us-gov-east-1",
            "us-gov-west-1"
        ],
        "linkUrl": "https://aws.amazon.com/directconnect/",
        "isActive": "true",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/awsDirectConnect/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "slug": "DirectConnect",
        "mvpSupport": false,
        "comparableTerms": [
            "directconnect"
        ]
    },
    "aWSDirectoryService": {
        "name": "AWS Directory Service",
        "serviceCode": "aWSDirectoryService",
        "description": "AWS Directory Service is a managed service offering, providing directories that contain information about your organization, including users, groups, computers, and other resources.",
        "searchKeywords": [],
        "type": "AWSService",
        "regions": [
            "ap-south-1",
            "ap-northeast-2",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-northeast-1",
            "us-gov-west-1",
            "us-gov-east-1",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "eu-west-3",
            "eu-south-1",
            "me-south-1",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/directoryservice/",
        "isActive": "true",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/aWSDirectoryService/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/aWSDirectoryService/en_US.json",
        "slug": "DirectoryService",
        "mvpSupport": false,
        "comparableTerms": [
            "directory",
            "directoryservice"
        ]
    },
    "awsDrsDrill": {
        "name": "AWS DRS - Drill/Recovery",
        "serviceCode": "awsDrsDrill",
        "description": "AWS Elastic Disaster Recovery (AWS DRS) minimizes downtime and data loss with fast, reliable recovery of on-premises and cloud-based applications using affordable storage, minimal compute, and point-in-time recovery.",
        "searchKeywords": [
            "disaster recovery",
            "replicate",
            "elastic recovery",
            "point in time",
            "recovery",
            "on-premises recovery",
            "cloud-based",
            "affordable storage"
        ],
        "type": "AWSService",
        "regions": [
            "eu-west-1",
            "ap-northeast-1",
            "us-east-2",
            "us-west-2",
            "us-east-1",
            "ap-southeast-2",
            "eu-west-2",
            "eu-central-1",
            "ap-southeast-1"
        ],
        "linkUrl": "https://aws.amazon.com/disaster-recovery/pricing",
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/awsDrsDrill/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/awsDrsDrill/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "drsdrill",
            "drsdrillrecovery"
        ],
        "parentServiceCode": "awsElasticDisasterRecovery"
    },
    "awsDrsRecoveryReplication": {
        "name": "AWS DRS - Replication",
        "serviceCode": "awsDrsRecoveryReplication",
        "description": "AWS Elastic Disaster Recovery (AWS DRS) minimizes downtime and data loss with fast, reliable recovery of on-premises and cloud-based applications using affordable storage, minimal compute, and point-in-time recovery.",
        "searchKeywords": [
            "disaster recovery",
            "replicate",
            "elastic recovery",
            "point in time",
            "recovery",
            "on-premises recovery",
            "cloud-based",
            "affordable storage"
        ],
        "type": "AWSService",
        "regions": [
            "eu-west-1",
            "ap-northeast-1",
            "us-east-2",
            "us-west-2",
            "us-east-1",
            "ap-southeast-2",
            "eu-west-2",
            "eu-central-1",
            "ap-southeast-1"
        ],
        "linkUrl": "https://aws.amazon.com/disaster-recovery/pricing",
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/awsDrsRecoveryReplication/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/awsDrsRecoveryReplication/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "drsrecoveryreplication",
            "drsreplication"
        ],
        "parentServiceCode": "awsElasticDisasterRecovery"
    },
    "awsElasticDisasterRecovery": {
        "name": "AWS Elastic Disaster Recovery",
        "serviceCode": "awsElasticDisasterRecovery",
        "description": "AWS Elastic Disaster Recovery (AWS DRS) minimizes downtime and data loss with fast, reliable recovery of on-premises and cloud-based applications using affordable storage, minimal compute, and point-in-time recovery.",
        "searchKeywords": [
            "disaster recovery",
            "replicate",
            "elastic recovery",
            "point in time",
            "recovery",
            "on-premises recovery",
            "cloud-based",
            "affordable storage"
        ],
        "type": "AWSService",
        "regions": [],
        "linkUrl": "https://aws.amazon.com/disaster-recovery/",
        "isActive": "true",
        "subType": "subServiceSelector",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/awsElasticDisasterRecovery/en_US.json",
        "c2e": false,
        "templates": [
            "awsDrsRecoveryReplication",
            "awsDrsDrill"
        ],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/awsElasticDisasterRecovery/en_US.json",
        "slug": "ElasticDisasterRecovery",
        "mvpSupport": false,
        "comparableTerms": [
            "disasterrecovery",
            "elasticdisasterrecovery"
        ]
    },
    "awsElementalMediaTailor": {
        "name": "AWS Elemental Media Tailor",
        "serviceCode": "awsElementalMediaTailor",
        "description": "AWS Elemental MediaTailor is a channel assembly and personalized ad insertion service for video providers to create linear OTT (internet delivered) channels using existing video content and monetize those channels, or other live streams and VOD content, with personalized advertising.",
        "searchKeywords": [
            "elemental",
            "tailor",
            "mediatailor"
        ],
        "type": "AWSService",
        "regions": [
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-northeast-1",
            "eu-central-1",
            "eu-west-1",
            "us-east-1",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/mediatailor/",
        "isActive": "true",
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/awsElementalMediaTailor/en_US.json",
        "c2e": false,
        "slug": "ElementalMediaTailor",
        "mvpSupport": false,
        "comparableTerms": [
            "elementalmediatailor",
            "mediatailor"
        ]
    },
    "awsElementalMediaConnect": {
        "name": "AWS Elemental MediaConnect",
        "serviceCode": "awsElementalMediaConnect",
        "description": "AWS Elemental MediaConnect is a high-quality transport service for live video.",
        "searchKeywords": [
            "transport",
            "video",
            "broadcast",
            "live",
            "flows",
            "JPEG XS",
            "CDI"
        ],
        "type": "AWSService",
        "regions": [
            "ap-east-1",
            "ap-northeast-1",
            "ap-northeast-2",
            "ap-south-1",
            "ap-southeast-1",
            "ap-southeast-2",
            "eu-central-1",
            "eu-north-1",
            "eu-west-1",
            "eu-west-2",
            "eu-west-3",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/mediaconnect/",
        "isActive": "true",
        "hasDataTransfer": true,
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/awsElementalMediaConnect/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "slug": "ElementalMediaConnect",
        "mvpSupport": false,
        "comparableTerms": [
            "elementalmediaconnect",
            "mediaconnect"
        ]
    },
    "elementalMediaConvert": {
        "name": "AWS Elemental MediaConvert",
        "serviceCode": "elementalMediaConvert",
        "description": "AWS Elemental MediaConvert is a file-based video transcoding service with broadcast-grade features. It allows you to easily create video-on-demand (VOD) content for broadcast and multiscreen delivery at scale.",
        "searchKeywords": [],
        "type": "AWSService",
        "regions": [
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2",
            "ap-south-1",
            "ap-northeast-2",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-northeast-1",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "eu-west-3",
            "eu-north-1",
            "sa-east-1",
            "us-gov-west-1"
        ],
        "linkUrl": "https://aws.amazon.com/mediaconvert/",
        "isActive": "true",
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/elementalMediaConvert/en_US.json",
        "c2e": false,
        "mvpSupport": false,
        "comparableTerms": [
            "elementalmediaconvert",
            "mediaconvert"
        ]
    },
    "awsElementalMediaLive": {
        "name": "AWS Elemental MediaLive",
        "serviceCode": "awsElementalMediaLive",
        "description": "AWS Elemental MediaLive is a broadcast-grade live video processing service. It lets you create high-quality video streams for delivery to broadcast televisions and internet-connected multiscreen devices, like connected TVs, tablets, smart phones, and set-top boxes.",
        "searchKeywords": [
            "media",
            "video processing",
            "broadcast",
            "TV",
            "video streams",
            "channels"
        ],
        "type": "AWSService",
        "regions": [],
        "linkUrl": "https://aws.amazon.com/medialive/",
        "isActive": "true",
        "subType": "subServiceSelector",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/awsElementalMediaLive/en_US.json",
        "c2e": false,
        "templates": [
            "mediaLiveInput1",
            "mediaLiveOutput1",
            "mediaLiveAudioAddOns"
        ],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/awsElementalMediaLive/en_US.json",
        "slug": "ElementalMediaLive",
        "mvpSupport": false,
        "comparableTerms": [
            "elementalmedialive",
            "medialive"
        ]
    },
    "awsElementalMediaPackage": {
        "name": "AWS Elemental MediaPackage",
        "serviceCode": "awsElementalMediaPackage",
        "description": "AWS Elemental MediaPackage reliably prepares and protects your video for delivery over the Internet. From a single video input, AWS Elemental MediaPackage creates video streams formatted to play on connected TVs, mobile phones, computers, tablets, and game consoles.",
        "searchKeywords": [
            "media",
            "video processing",
            "broadcast",
            "TV",
            "video streams",
            "channels"
        ],
        "type": "AWSService",
        "regions": [
            "ap-south-1",
            "ap-northeast-2",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-northeast-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "eu-west-3",
            "eu-north-1",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/mediapackage/",
        "isActive": "true",
        "hasDataTransfer": true,
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/awsElementalMediaPackage/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "slug": "ElementalMediaPackage",
        "mvpSupport": false,
        "comparableTerms": [
            "elementalmediapackage",
            "mediapackage"
        ]
    },
    "awsFargate": {
        "name": "AWS Fargate",
        "serviceCode": "awsFargate",
        "description": "AWS Fargate is a serverless compute engine for containers that works with both Amazon Elastic Container Service (ECS) and Amazon Elastic Kubernetes Service (EKS). Fargate makes it easy for you to focus on building your applications. Fargate removes the need to provision and manage servers, lets you specify and pay for resources per application, and improves security through application isolation by design.",
        "searchKeywords": [
            "serverless",
            "compute",
            "engine",
            "ECS",
            "EKS",
            "container",
            "Kubernetes"
        ],
        "type": "AWSService",
        "regions": [
            "us-gov-west-1",
            "us-gov-east-1",
            "af-south-1",
            "ap-east-1",
            "ap-south-1",
            "ap-northeast-3",
            "ap-northeast-2",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-southeast-3",
            "ap-northeast-1",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "eu-south-1",
            "eu-west-3",
            "eu-north-1",
            "me-south-1",
            "me-central-1",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/fargate/",
        "isActive": "true",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/awsFargate/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/awsFargate/en_US.json",
        "slug": "Fargate",
        "mvpSupport": false,
        "comparableTerms": [
            "fargate"
        ]
    },
    "awsGlue": {
        "name": "AWS Glue",
        "serviceCode": "awsGlue",
        "description": "AWS Glue is a serverless data preparation service that makes it easy for data engineers, extract, transform, and load (ETL) developers, data analysts, and data scientists to extract, clean, enrich, normalize, and load data. AWS Glue reduces the time it takes to start analyzing your data from months to minutes.",
        "searchKeywords": [
            "etl",
            "AWS glue data catalog",
            "glue",
            "crawlers",
            "development endpoints",
            "databrew"
        ],
        "type": "AWSService",
        "regions": [],
        "linkUrl": "https://aws.amazon.com/glue/",
        "isActive": "true",
        "subType": "subServiceSelector",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/awsGlue/en_US.json",
        "c2e": false,
        "templates": [
            "awsEtlJobsAndDevelopmentEndpoints",
            "awsEtlJobsFlexExecutionOption",
            "awsGlueDataCatalogStorageRequests",
            "awsGlueDataBrewInteractiveSessions",
            "awsGlueCrawlers"
        ],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/awsGlue/en_US.json",
        "slug": "Glue",
        "mvpSupport": false,
        "comparableTerms": [
            "glue"
        ]
    },
    "awsGlueCrawlers": {
        "name": "AWS Glue Crawlers",
        "serviceCode": "awsGlueCrawlers",
        "description": "",
        "searchKeywords": [],
        "type": "AWSService",
        "regions": [
            "us-gov-west-1",
            "us-gov-east-1",
            "af-south-1",
            "ap-east-1",
            "ap-south-1",
            "ap-northeast-3",
            "ap-northeast-2",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-northeast-1",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "eu-south-1",
            "eu-west-3",
            "eu-north-1",
            "me-south-1",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2"
        ],
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/awsGlueCrawlers/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/awsGlueCrawlers/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "gluecrawlers"
        ],
        "parentServiceCode": "awsGlue"
    },
    "awsGlueDataCatalogStorageRequests": {
        "name": "AWS Glue Data Catalog storage requests",
        "serviceCode": "awsGlueDataCatalogStorageRequests",
        "description": "",
        "searchKeywords": [],
        "type": "AWSService",
        "regions": [
            "us-gov-west-1",
            "us-gov-east-1",
            "af-south-1",
            "ap-east-1",
            "ap-south-1",
            "ap-northeast-3",
            "ap-northeast-2",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-northeast-1",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "eu-south-1",
            "eu-west-3",
            "eu-north-1",
            "me-south-1",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2"
        ],
        "isActive": "true",
        "subType": "subService",
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/awsGlueDataCatalogStorageRequests/en_US.json",
        "c2e": false,
        "mvpSupport": false,
        "comparableTerms": [
            "gluedatacatalogstoragerequests"
        ],
        "parentServiceCode": "awsGlue"
    },
    "awsGlueDataBrewInteractiveSessions": {
        "name": "AWS Glue DataBrew interactive sessions",
        "serviceCode": "awsGlueDataBrewInteractiveSessions",
        "description": "",
        "searchKeywords": [],
        "type": "AWSService",
        "regions": [
            "ap-south-1",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-northeast-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "eu-west-3",
            "eu-north-1",
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2"
        ],
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/awsGlueDataBrewInteractiveSessions/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/awsGlueDataBrewInteractiveSessions/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "gluedatabrewinteractivesessions"
        ],
        "parentServiceCode": "awsGlue"
    },
    "awsEtlJobsAndDevelopmentEndpoints": {
        "name": "AWS Glue ETL jobs and interactive sessions",
        "serviceCode": "awsEtlJobsAndDevelopmentEndpoints",
        "description": "",
        "searchKeywords": [],
        "type": "AWSService",
        "regions": [
            "us-gov-west-1",
            "us-gov-east-1",
            "af-south-1",
            "ap-east-1",
            "ap-south-1",
            "ap-northeast-3",
            "ap-northeast-2",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-northeast-1",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "eu-south-1",
            "eu-west-3",
            "eu-north-1",
            "me-south-1",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2"
        ],
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/awsEtlJobsAndDevelopmentEndpoints/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "bulkImportEnabled": false,
        "serviceDefinitionUrlPath": "/data/awsEtlJobsAndDevelopmentEndpoints/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "etljobsanddevelopmentendpoints",
            "glueetljobsinteractivesessions"
        ],
        "parentServiceCode": "awsGlue"
    },
    "awsEtlJobsFlexExecutionOption": {
        "name": "AWS Glue ETL jobs with Flex execution option",
        "serviceCode": "awsEtlJobsFlexExecutionOption",
        "description": "",
        "searchKeywords": [],
        "type": "AWSService",
        "regions": [
            "ap-northeast-1",
            "ap-northeast-2",
            "ap-south-1",
            "ap-southeast-1",
            "ap-southeast-2",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "eu-west-3",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2"
        ],
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/awsEtlJobsFlexExecutionOption/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "mvpSupport": false,
        "comparableTerms": [
            "etljobsflexexecutionoption",
            "glueetljobswithflexexecutionoption"
        ],
        "parentServiceCode": "awsGlue"
    },
    "awsIoTAnalytics": {
        "name": "AWS IoT Analytics",
        "serviceCode": "awsIoTAnalytics",
        "description": "AWS IoT Analytics is a fully-managed IoT analytics service that collects, pre-processes, enriches, stores, and analyzes IoT device data at scale.",
        "searchKeywords": [
            "AWS IoT Analytics",
            "iot analytics",
            "analytics"
        ],
        "type": "AWSService",
        "regions": [
            "ap-northeast-1",
            "ap-south-1",
            "ap-southeast-2",
            "eu-central-1",
            "eu-west-1",
            "us-east-1",
            "us-east-2",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/iot-analytics/",
        "isActive": "true",
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/awsIoTAnalytics/en_US.json",
        "c2e": false,
        "slug": "iot-analytics",
        "mvpSupport": false,
        "comparableTerms": [
            "iotanalytics"
        ]
    },
    "awsIoTCore": {
        "name": "AWS IoT Core",
        "serviceCode": "awsIoTCore",
        "description": "AWS IoT Core is a managed cloud service that lets connected devices easily and securely interact with cloud applications and other devices.",
        "searchKeywords": [
            "iot",
            "device",
            "messages",
            "shadow",
            "registry",
            "rules",
            "device shadow",
            "rules engine",
            "basic ingest",
            "mqtt",
            "LoRaWAN"
        ],
        "type": "AWSService",
        "regions": [],
        "linkUrl": "https://aws.amazon.com/iot-core/",
        "isActive": "true",
        "subType": "subServiceSelector",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/awsIoTCore/en_US.json",
        "c2e": false,
        "templates": [
            "awsIoTCoreMqtt",
            "awsIoTCoreHttp",
            "awsIoTCoreLoRaWan"
        ],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/awsIoTCore/en_US.json",
        "slug": "IoTCore",
        "mvpSupport": false,
        "comparableTerms": [
            "iotcore"
        ]
    },
    "awsIoTDeviceDefender": {
        "name": "AWS IoT Device Defender",
        "serviceCode": "awsIoTDeviceDefender",
        "description": "AWS IoT Device Defender is a fully managed service that helps you secure your fleet of IoT devices.",
        "searchKeywords": [
            "device",
            "iot",
            "iot device defender",
            "defender",
            "audit",
            "detect",
            "metric",
            "fleet"
        ],
        "type": "AWSService",
        "regions": [
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2",
            "ap-east-1",
            "ap-south-1",
            "ap-northeast-2",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-northeast-1",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "eu-west-3",
            "eu-north-1",
            "me-south-1",
            "us-gov-east-1",
            "us-gov-west-1"
        ],
        "linkUrl": "https://aws.amazon.com/iot-device-defender/",
        "isActive": "true",
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/awsIoTDeviceDefender/en_US.json",
        "c2e": false,
        "slug": "IoTDeviceDefender",
        "comparableTerms": [
            "iotdevicedefender"
        ]
    },
    "awsIoTDeviceManagement": {
        "name": "AWS IoT Device Management",
        "serviceCode": "awsIoTDeviceManagement",
        "description": "AWS IoT Device Management makes it easy for you to manage your fleets of connected devices at any scale.",
        "searchKeywords": [
            "device management",
            "fleet indexing",
            "index updates",
            "device query",
            "device queries",
            "jobs",
            "remote actions",
            "secure tunneling",
            "tunnels"
        ],
        "type": "AWSService",
        "regions": [
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2",
            "ap-east-1",
            "ap-south-1",
            "ap-northeast-2",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-northeast-1",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "eu-west-3",
            "eu-north-1",
            "me-south-1",
            "sa-east-1",
            "us-gov-east-1",
            "us-gov-west-1"
        ],
        "linkUrl": "https://aws.amazon.com/iot-device-management/",
        "isActive": "true",
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/awsIoTDeviceManagement/en_US.json",
        "c2e": false,
        "slug": "IoTDeviceManagement",
        "comparableTerms": [
            "iotdevicemanagement"
        ]
    },
    "awsIoTEvents": {
        "name": "AWS IoT Events",
        "serviceCode": "awsIoTEvents",
        "description": "AWS IoT Events makes it easy to detect and respond to changes indicated by IoT sensors and applications – such as malfunctioning machinery, a stuck conveyor belt, or a slowdown in production output – and automatically trigger actions or alerts in response.",
        "searchKeywords": [
            "iot",
            "iot events"
        ],
        "type": "AWSService",
        "regions": [
            "ap-northeast-1",
            "ap-northeast-2",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-south-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "us-east-1",
            "us-east-2",
            "us-west-2",
            "us-gov-west-1"
        ],
        "linkUrl": "https://aws.amazon.com/iot-events/",
        "isActive": "true",
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/awsIoTEvents/en_US.json",
        "c2e": false,
        "slug": "iot-events",
        "mvpSupport": false,
        "comparableTerms": [
            "iotevents"
        ]
    },
    "awsIoTFleetWise": {
        "name": "AWS IoT FleetWise",
        "serviceCode": "awsIoTFleetWise",
        "description": "AWS IoT FleetWise makes it easier for you to collect, transform, and transfer vehicle data to the cloud in near real time and use that data to improve vehicle quality, safety, and autonomy.",
        "searchKeywords": [
            "iot",
            "device",
            "fleetwise",
            "iot auto"
        ],
        "type": "AWSService",
        "regions": [],
        "linkUrl": "https://aws.amazon.com/iot-fleetwise/",
        "isActive": "true",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/awsIoTFleetWise/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/awsIoTFleetWise/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "iotfleetwise"
        ]
    },
    "awsIoTGreengrass": {
        "name": "AWS IoT Greengrass",
        "serviceCode": "awsIoTGreengrass",
        "description": "AWS IoT Greengrass is an Internet of Things (IoT) open source edge runtime and cloud service that helps you build, deploy, and manage device software. Customers use AWS IoT Greengrass for their IoT applications on millions of devices in homes, factories, vehicles, and businesses.",
        "searchKeywords": [
            "greengrass",
            "AWS IoT Greengrass"
        ],
        "type": "AWSService",
        "regions": [
            "ap-northeast-1",
            "ap-northeast-2",
            "ap-south-1",
            "ap-southeast-1",
            "ap-southeast-2",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "us-east-1",
            "us-east-2",
            "us-gov-east-1",
            "us-gov-west-1",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/greengrass/",
        "isActive": "true",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/awsIoTGreengrass/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "slug": "greengrass",
        "mvpSupport": false,
        "comparableTerms": [
            "greengrass",
            "iotgreengrass"
        ]
    },
    "awsIoTThingsGraph": {
        "name": "AWS IoT Things Graph",
        "serviceCode": "awsIoTThingsGraph",
        "description": "AWS IoT Things Graph makes it easy to rapidly build IoT applications by connecting devices and web services from different vendors that speak different protocols.",
        "searchKeywords": [
            "IoT",
            "Things",
            "graph",
            "IoT Things Graph"
        ],
        "type": "AWSService",
        "regions": [
            "ap-northeast-2",
            "ap-southeast-2",
            "ap-northeast-1",
            "eu-west-1",
            "us-east-1",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/iot-things-graph/",
        "isActive": "true",
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/awsIoTThingsGraph/en_US.json",
        "c2e": false,
        "slug": "IoTThingsGraph",
        "comparableTerms": [
            "iotthingsgraph"
        ]
    },
    "awsKeyManagementService": {
        "name": "AWS Key Management Service",
        "serviceCode": "awsKeyManagementService",
        "description": "Securely Generate and Manage AWS Encryption Keys",
        "searchKeywords": [
            "KMS",
            "Key Management System"
        ],
        "type": "AWSService",
        "regions": [
            "af-south-1",
            "ap-east-1",
            "ap-northeast-1",
            "ap-northeast-2",
            "ap-northeast-3",
            "ap-south-1",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-southeast-3",
            "ca-central-1",
            "eu-central-1",
            "eu-north-1",
            "eu-south-1",
            "eu-west-1",
            "eu-west-2",
            "eu-west-3",
            "me-south-1",
            "me-central-1",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-gov-east-1",
            "us-gov-west-1",
            "us-west-1",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/kms/",
        "isActive": "true",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/awsKeyManagementService/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "slug": "KMS",
        "mvpSupport": false,
        "comparableTerms": [
            "keymanagement",
            "keymanagementservice",
            "kms"
        ]
    },
    "awsLakeFormation": {
        "name": "AWS Lake Formation",
        "serviceCode": "awsLakeFormation",
        "description": "AWS Lake Formation provides database, table, column and tag-based access controls, and cross-account sharing at no charge. Governed Tables provide ACID transactions as a fully managed service that enable you to reliably update multiple tables, while maintaining a consistent view for all users. Managing concurrent transactions and being able to travel back to previous version of the table requires storing metadata about each transaction. Lake Formation charges a fee for transaction requests and for metadata storage. In addition, to providing a consistent view of data and enforce row and cell-level security the Lake Formation Storage API scans data in Amazon S3 and applies row and cell filters before returning results to applications. There is a fee for this filtering.",
        "searchKeywords": [
            "Lake Formation",
            "LF",
            "If",
            "Formation",
            "lakeformation",
            "Lake"
        ],
        "type": "AWSService",
        "regions": [
            "us-east-1",
            "us-east-2",
            "us-west-2",
            "ap-northeast-1",
            "ap-northeast-2",
            "ap-south-1",
            "ap-southeast-1",
            "ap-southeast-2",
            "eu-west-1",
            "eu-west-2",
            "eu-central-1",
            "eu-north-1",
            "ca-central-1"
        ],
        "linkUrl": "https://aws.amazon.com/lake-formation/",
        "isActive": "true",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/awsLakeFormation/en_US.json",
        "c2e": false,
        "slug": "LakeFormation",
        "mvpSupport": false,
        "comparableTerms": [
            "lakeformation"
        ]
    },
    "aWSLambda": {
        "name": "AWS Lambda",
        "serviceCode": "aWSLambda",
        "description": "AWS Lambda lets you run code without provisioning or managing servers. You pay only for the compute time you consume - there is no charge when your code is not running.",
        "searchKeywords": [],
        "type": "AWSService",
        "regions": [
            "af-south-1",
            "ap-east-1",
            "ap-northeast-1",
            "ap-northeast-2",
            "ap-northeast-3",
            "ap-south-1",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-southeast-3",
            "ca-central-1",
            "eu-central-1",
            "eu-north-1",
            "eu-south-1",
            "eu-west-1",
            "eu-west-2",
            "eu-west-3",
            "me-south-1",
            "me-central-1",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-gov-east-1",
            "us-gov-west-1",
            "us-west-1",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/lambda/",
        "isActive": "true",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/aWSLambda/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/aWSLambda/en_US.json",
        "slug": "Lambda",
        "mvpSupport": false,
        "comparableTerms": [
            "lambda"
        ]
    },
    "locationService": {
        "name": "AWS Location Service",
        "serviceCode": "locationService",
        "description": "Amazon Location Service provides affordable data, tracking and geofencing capabilities, and native integrations with AWS services, so you can create sophisticated location-enabled applications quickly, without the high cost of custom development.",
        "searchKeywords": [
            "Location Service",
            "compromising data security",
            "user privacy",
            "asset tracking",
            "location-based marketing",
            "geofencing"
        ],
        "type": "AWSService",
        "regions": [],
        "linkUrl": "https://aws.amazon.com/location/",
        "isActive": "true",
        "subType": "subServiceSelector",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/locationService/en_US.json",
        "c2e": false,
        "templates": [
            "locationServiceMaps",
            "locationServicePlaces",
            "locationServiceRouting",
            "locationServiceTracking",
            "locationServiceGeofencing",
            "locationServiceServiceResources"
        ],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/locationService/en_US.json",
        "slug": "LocationService",
        "mvpSupport": false,
        "comparableTerms": [
            "location",
            "locationservice"
        ]
    },
    "amazonMainframeModernization": {
        "name": "AWS Mainframe Modernization",
        "serviceCode": "amazonMainframeModernization",
        "description": "AWS Mainframe Modernization (Preview) is a set of managed tools providing infrastructure and software for migrating, modernizing, and executing mainframe applications.",
        "searchKeywords": [
            "Blu Age",
            "Micro",
            "Mainframe",
            "m2",
            "instance",
            "modernization"
        ],
        "type": "AWSService",
        "regions": [],
        "linkUrl": "https://aws.amazon.com/mainframe-modernization/",
        "isActive": "true",
        "subType": "subServiceSelector",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonMainframeModernization/en_US.json",
        "c2e": false,
        "templates": [
            "mainframeBluAge",
            "mainframeMicroFocus"
        ],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/amazonMainframeModernization/en_US.json",
        "slug": "mainframeModernization",
        "mvpSupport": false,
        "comparableTerms": [
            "mainframemodernization"
        ]
    },
    "migrationHubRefactorSpaces": {
        "name": "AWS Migration Hub Refactor Spaces",
        "serviceCode": "migrationHubRefactorSpaces",
        "description": "AWS Migration Hub Refactor Spaces is the starting point for incremental application refactoring to microservices. Refactor Spaces eliminates the undifferentiated work of building and operating AWS infrastructure for incremental refactoring. You can use Refactor Spaces to reduce the risk of evolving applications into microservices or extending existing applications with new features written in microservices.",
        "searchKeywords": [
            "Migration Hub",
            "cloud migration",
            "IT asset",
            "inventory data",
            "Refactor Spaces"
        ],
        "type": "AWSService",
        "regions": [
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-northeast-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "eu-north-1",
            "us-east-1",
            "us-east-2",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/migration-hub/",
        "isActive": "true",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/migrationHubRefactorSpaces/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "slug": "migration-hub",
        "mvpSupport": false,
        "comparableTerms": [
            "migrationhub",
            "migrationhubrefactorspaces"
        ]
    },
    "modularDataCenter": {
        "name": "AWS Modular Data Center (MDC)",
        "serviceCode": "modularDataCenter",
        "description": "AWS Modular Data Center (MDC) is a service that makes it simple and cost-effective for defense and intelligence agencies to deploy AWS managed data centers anywhere in the world to run low latency applications. AWS MDC is available as a self-contained modular data center—a physical, environmentally-controlled enclosure that holds up to five racks of AWS Outposts or AWS Snowball Edge devices, and can scale further through deployment of additional modules. AWS MDC reduces the time and resources it takes for customers to deploy data centers in remote environments with limited infrastructure. Customers can proactively monitor and manage their modular data centers using a management system that comes with every MDC. Each modular data center is equipped with Building Management System (BMS) sensors to monitor the environmental conditions of the MDC including temperature, humidity, ventilation, HVAC performance, and power quality. The BMS also monitors the life safety systems, such as smoke detection, fire alarm, and the Access Control (ACS) / Intrusion Detection System (IDS).",
        "searchKeywords": [
            "Modular Data Center"
        ],
        "type": "AWSService",
        "regions": [
            "us-east-1"
        ],
        "isActive": "true",
        "hasDataTransfer": false,
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/modularDataCenter/en_US.json",
        "c2e": true,
        "templates": [],
        "disableRegionSupport": true,
        "serviceDefinitionUrlPath": "/data/modularDataCenter/en_US.json",
        "slug": "MDC",
        "mvpSupport": true,
        "comparableTerms": [
            "mdc",
            "modulardatacenter",
            "modulardatacentermdc"
        ]
    },
    "amazonNetworkFirewall": {
        "name": "AWS Network Firewall",
        "serviceCode": "amazonNetworkFirewall",
        "description": "AWS Network Firewall is a managed service that makes it easy to deploy essential network protections for all of your Amazon Virtual Private Clouds (VPCs). The service can be setup with just a few clicks and scales automatically with your network traffic, so you don't have to worry about deploying and managing any infrastructure.",
        "searchKeywords": [
            "amazonNetworkFirewall",
            "AWS Network Firewall"
        ],
        "type": "AWSService",
        "regions": [
            "ap-east-1",
            "ap-south-1",
            "ap-northeast-2",
            "ap-northeast-3",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-northeast-1",
            "us-gov-west-1",
            "us-gov-east-1",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "eu-west-3",
            "eu-north-1",
            "eu-south-1",
            "me-south-1",
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2",
            "sa-east-1",
            "af-south-1"
        ],
        "linkUrl": "https://aws.amazon.com/network-firewall/",
        "isActive": "true",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonNetworkFirewall/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/amazonNetworkFirewall/en_US.json",
        "slug": "networkfirewall",
        "mvpSupport": false,
        "comparableTerms": [
            "networkfirewall"
        ]
    },
    "awsOutposts": {
        "name": "AWS Outposts",
        "serviceCode": "awsOutposts",
        "description": "AWS Outposts is a fully managed service that offers the same AWS infrastructure, AWS services, APIs, and tools to virtually any datacenter, co-location space, or on-premises facility for a truly consistent hybrid experience. AWS Outposts is ideal for workloads that require low latency access to on-premises systems, local data processing, data residency, and migration of applications with local system interdependencies.",
        "searchKeywords": [
            "Outposts",
            "AWS infrastructure",
            "AWS services",
            "API",
            "datacenter",
            "on-premises facility",
            "hybrid",
            "compute",
            "storage",
            "database",
            "EC2",
            "EBS",
            "S3"
        ],
        "type": "AWSService",
        "regions": [
            "us-east-1"
        ],
        "linkUrl": "https://aws.amazon.com/outposts/",
        "isActive": "true",
        "hasDataTransfer": false,
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/awsOutposts/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": true,
        "serviceDefinitionUrlPath": "/data/awsOutposts/en_US.json",
        "slug": "Outposts",
        "mvpSupport": false,
        "comparableTerms": [
            "outposts"
        ]
    },
    "aWSPricingCalculatorStrings": {
        "name": "AWS Pricing Calculator Strings",
        "serviceCode": "aWSPricingCalculatorStrings",
        "searchKeywords": [],
        "type": "static",
        "regions": [],
        "isActive": "true",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/aWSPricingCalculatorStrings/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/aWSPricingCalculatorStrings/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "pricingcalculatorstrings"
        ]
    },
    "awsCertificateManager": {
        "name": "AWS Private Certificate Authority",
        "serviceCode": "awsCertificateManager",
        "description": "AWS Private Certificate Authority is a service that lets you easily provision, manage, and deploy public and private Secure Sockets Layer/Transport Layer Security (SSL/TLS) certificates for use with AWS services and your internal connected resources.",
        "searchKeywords": [
            "PCA",
            "OCSP",
            "certificates x.509",
            "private"
        ],
        "type": "AWSService",
        "regions": [
            "af-south-1",
            "ap-east-1",
            "ap-south-1",
            "ap-northeast-3",
            "ap-northeast-2",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-southeast-2",
            "us-gov-east-1",
            "us-gov-west-1",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "eu-south-1",
            "eu-west-3",
            "eu-north-1",
            "me-south-1",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/certificate-manager/",
        "isActive": "true",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/awsCertificateManager/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/awsCertificateManager/en_US.json",
        "slug": "certificateManager",
        "mvpSupport": false,
        "comparableTerms": [
            "certificatemanager",
            "privatecertificateauthority"
        ]
    },
    "awsPrivateLinkVpc": {
        "name": "AWS PrivateLink",
        "serviceCode": "awsPrivateLinkVpc",
        "description": "WS Virtual Private Network solutions establish secure connections between your on-premises networks, remote offices, client devices, and the AWS global network. AWS VPN is comprised of two services: AWS Site-to-Site VPN and AWS Client VPN. Each service provides a highly-available, managed, and elastic cloud VPN solution to protect your network traffic.",
        "searchKeywords": [
            "access control",
            "ACL",
            "AWS Privatelink",
            "Cloud connectivity",
            "corporate network",
            "elastic IP",
            "Gateway load balancer",
            "home network VPN",
            "IPAM",
            "NAT",
            "NAT gateway",
            "Network Access Analyzer",
            "Network Address Translation",
            "Networking Content Delivery",
            "PrivateLink",
            "Reachability Analyzer",
            "security",
            "single tenant hardware",
            "static ip",
            "subnets",
            "Traffic mirroring",
            "Transit Gateway",
            "Virtual Private Cloud",
            "VPN"
        ],
        "type": "AWSService",
        "regions": [
            "af-south-1",
            "ap-east-1",
            "ap-northeast-1",
            "ap-northeast-2",
            "ap-northeast-3",
            "ap-south-1",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-southeast-3",
            "ca-central-1",
            "eu-central-1",
            "eu-north-1",
            "eu-south-1",
            "eu-west-1",
            "eu-west-2",
            "eu-west-3",
            "me-south-1",
            "me-central-1",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2",
            "us-gov-west-1"
        ],
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/awsPrivateLinkVpc/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/awsPrivateLinkVpc/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "privatelink",
            "privatelinkvpc"
        ],
        "parentServiceCode": "amazonVirtualPrivateCloud"
    },
    "awsProfessionalServices": {
        "name": "AWS Professional Services",
        "serviceCode": "awsProfessionalServices",
        "description": " The AWS Professional Services team provides assistance through a collection of offerings that help you achieve specific outcomes related to enterprise cloud adoption. We also deliver focused guidance through our global specialty practices, which cover a variety of solutions, technologies, and industries.",
        "searchKeywords": [
            "ProServe",
            "professional",
            "Service"
        ],
        "type": "AWSService",
        "regions": [],
        "linkUrl": "https://aws.amazon.com/professional-services/",
        "isActive": "true",
        "subType": "subServiceSelector",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/awsProfessionalServices/en_US.json",
        "c2e": true,
        "templates": [
            "proServeYear1Cost",
            "proServeYear2Cost",
            "proServeYear3Cost",
            "proServeYear4Cost",
            "proServeYear5Cost"
        ],
        "disableRegionSupport": true,
        "bulkImportEnabled": false,
        "serviceDefinitionUrlPath": "/data/awsProfessionalServices/en_US.json",
        "mvpSupport": true,
        "comparableTerms": [
            "professionalservices"
        ]
    },
    "awsSecretsManager": {
        "name": "AWS Secrets Manager",
        "serviceCode": "awsSecretsManager",
        "description": "AWS Secrets Manager enables you to rotate, manage, and retrieve secrets throughout their lifecycle, making it easier to maintain a secure environment that meets your security and compliance needs. With Secrets Manager, you pay based on the number of secrets stored and API calls made.",
        "searchKeywords": [
            "Secrets",
            "Secrets Manager"
        ],
        "type": "AWSService",
        "regions": [
            "us-gov-west-1",
            "us-gov-east-1",
            "af-south-1",
            "ap-east-1",
            "ap-south-1",
            "ap-northeast-2",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-southeast-3",
            "ap-northeast-1",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "eu-south-1",
            "eu-west-3",
            "eu-north-1",
            "me-south-1",
            "me-central-1",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/secrets-manager/",
        "isActive": "true",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/awsSecretsManager/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "slug": "SecretsManager",
        "mvpSupport": false,
        "comparableTerms": [
            "secretsmanager"
        ]
    },
    "awsSecurityHub": {
        "name": "AWS Security Hub",
        "serviceCode": "awsSecurityHub",
        "description": "AWS Security Hub performs security best practice checks and ingests security findings from AWS security services and partners.",
        "searchKeywords": [
            "security",
            "hub"
        ],
        "type": "AWSService",
        "regions": [
            "af-south-1",
            "ap-east-1",
            "ap-south-1",
            "ap-northeast-3",
            "ap-northeast-2",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-northeast-1",
            "us-gov-east-1",
            "us-gov-west-1",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "eu-south-1",
            "eu-west-3",
            "eu-north-1",
            "me-south-1",
            "sa-east-1",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/security-hub/",
        "isActive": "true",
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/awsSecurityHub/en_US.json",
        "c2e": false,
        "slug": "securityHub",
        "mvpSupport": false,
        "comparableTerms": [
            "securityhub"
        ]
    },
    "awsShield": {
        "name": "AWS Shield",
        "serviceCode": "awsShield",
        "description": "AWS Shield Advanced is a paid service that provides additional protections for internet-facing applications running on Amazon Elastic Compute Cloud (EC2), Elastic Load Balancing (ELB), Amazon CloudFront, AWS Global Accelerator, and Amazon Route 53. AWS Shield Advanced is available to all customers; however, to contact the AWS Shield Response Team customers will need the Enterprise or Business Support levels of AWS Premium Support.",
        "searchKeywords": [
            "shield",
            "DDoS"
        ],
        "type": "AWSService",
        "regions": [
            " "
        ],
        "linkUrl": "https://aws.amazon.com/shield/pricing/",
        "isActive": "true",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/awsShield/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "bulkImportEnabled": false,
        "serviceDefinitionUrlPath": "/data/awsShield/en_US.json",
        "slug": "shield",
        "mvpSupport": false,
        "comparableTerms": [
            "shield",
            "shieldpricing"
        ]
    },
    "simSpaceWeaver": {
        "name": "AWS SimSpace Weaver",
        "serviceCode": "simSpaceWeaver",
        "description": "AWS SimSpace Weaver is a fully managed compute service that helps customers build, operate, and oversee large-scale spatial simulations. AWS SimSpace Weaver helps developers expand their spatial simulation capabilities to new levels of scale and complexity—resulting in deeper insights and larger virtual worlds with millions of independent and interacting entities.",
        "searchKeywords": [
            "sim space weaver",
            "simspaceweaver"
        ],
        "type": "AWSService",
        "regions": [],
        "linkUrl": "https://aws.amazon.com/simspaceweaver/",
        "isActive": "true",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/simSpaceWeaver/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "bulkImportEnabled": false,
        "serviceDefinitionUrlPath": "/data/simSpaceWeaver/en_US.json",
        "slug": "simspaceweaver",
        "mvpSupport": false,
        "comparableTerms": [
            "simspaceweaver"
        ]
    },
    "awsSnowball": {
        "name": "AWS Snowball",
        "serviceCode": "awsSnowball",
        "description": "AWS Snowball, a part of the AWS Snow Family, is an edge computing, data migration, and edge storage device that comes in two options. Snowball Edge Storage Optimized devices provide both block storage and Amazon S3-compatible object storage, and 40 vCPUs. They are well suited for local storage and large scale-data transfer. Snowball Edge Compute Optimized devices provide 52 vCPUs, block and object storage, and an optional GPU for use cases like advanced machine learning and full motion video analysis in disconnected environments.",
        "searchKeywords": [
            "Snow",
            "Snowball",
            "Snowball Edge",
            "Disconnected Data Transfer",
            "Edge Computing",
            "Data Export"
        ],
        "type": "AWSService",
        "regions": [],
        "linkUrl": "https://aws.amazon.com/snowball/",
        "isActive": "true",
        "subType": "subServiceSelector",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/awsSnowball/en_US.json",
        "c2e": false,
        "templates": [
            "snowballEdgeComputeOptimizedWithEc2ComputeInstances",
            "snowballEdgeComputeOptimizedGpuWithEc2ComputeInstances",
            "snowballEdgeStorageOptimizedWithEc2ComputeInstances",
            "snowballEdgeStorageOptimizedDataTransferOnly"
        ],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/awsSnowball/en_US.json",
        "slug": "Snowball",
        "mvpSupport": false,
        "comparableTerms": [
            "snowball"
        ]
    },
    "awsSnowmobile": {
        "name": "AWS Snowmobile",
        "serviceCode": "awsSnowmobile",
        "description": "AWS Snowmobile is an Exabyte-scale data transfer service used to move extremely large amounts of data to AWS. You can transfer up to 100PB per Snowmobile, a 45-foot long ruggedized shipping container, pulled by a semi-trailer truck. Snowmobile makes it easy to move massive volumes of data to the cloud, including video libraries, image repositories, or even a complete data center migration. Transferring data with Snowmobile is more secure, fast and cost effective.",
        "searchKeywords": [
            "Snowmobile",
            "data transfer",
            "video libraries",
            "image repositories",
            "data center migration",
            "truck",
            "shipping container"
        ],
        "type": "AWSService",
        "regions": [
            "us-gov-west-1"
        ],
        "linkUrl": "https://aws.amazon.com/snowmobile/",
        "isActive": "true",
        "hasDataTransfer": false,
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/awsSnowmobile/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": true,
        "serviceDefinitionUrlPath": "/data/awsSnowmobile/en_US.json",
        "slug": "Snowmobile",
        "mvpSupport": false,
        "comparableTerms": [
            "snowmobile"
        ]
    },
    "awsStepFunctions": {
        "name": "AWS Step Functions",
        "serviceCode": "awsStepFunctions",
        "description": "AWS Step Functions is a serverless function orchestrator that makes it easy to sequence AWS Lambda functions and multiple AWS services into business-critical applications.",
        "searchKeywords": [
            "workflows",
            " workflow",
            " orchestrator",
            " orchestration",
            " serverless",
            " state machine",
            " State Machines",
            " States",
            " State",
            " Microservices",
            " application integration",
            " Amazon States Language",
            " ASL",
            " Data Science SDK",
            " data processing",
            " API orchestration",
            " DAG",
            " DAGs",
            " Step Functions",
            " Step Function",
            " Step",
            " media processing",
            " application orchestration",
            " serverless orchestration",
            " serverless workflow",
            " lambda orchestration",
            " serverless state machine",
            " asynchronous",
            " synchronous",
            " event-driven data processing",
            " event-driven",
            " event orchestration",
            " standard workflows",
            " standard workflow",
            " express workflow",
            " express workflows",
            " standard workflows",
            " error handling",
            " service integrations",
            " state management",
            " visual workflow",
            " visual monitoring",
            " high volume orchestration",
            " function",
            " functions",
            " machine learning workflow",
            " machine learning workflows",
            " JSON",
            " serverless workflows",
            " serverless workflow",
            " Business logic",
            " complex workflows",
            " data pipeline",
            " data processing",
            " decoupling",
            " decouple applications",
            " abstraction",
            " abstraction layer",
            " automation",
            " It automation",
            " connecting aws services",
            " integration of aws services",
            " coordinating AWS services",
            " managed workflows",
            " call back patterns",
            " callback pattern",
            " callback patterns",
            " call back pattern",
            " human approval",
            " manual approval",
            " human intervention",
            " EKS orchestration",
            " container orchestration",
            " short duration workflows",
            " long duration workflows",
            " short-duration workflows",
            " short-duration workflow",
            " long-running workflow",
            " long-running workflows",
            " machine-learning workflows",
            " ML workflows",
            " ML workflow",
            " API orchestration",
            " function",
            " functions",
            " compute function",
            " compute functions",
            " Lambda retry",
            " Lambda retries",
            " serverless compute",
            " parallel processing",
            " Lambda chaining",
            " error-handling",
            " retries",
            " saga pattern",
            " nested",
            " branching",
            " nesting",
            " nested pattern",
            " branching pattern",
            " nesting pattern",
            " serverless patterns",
            " event-driven patterns",
            " coordinating workflows"
        ],
        "type": "AWSService",
        "regions": [],
        "linkUrl": "https://aws.amazon.com/step-functions/",
        "isActive": "true",
        "subType": "subServiceSelector",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/awsStepFunctions/en_US.json",
        "c2e": false,
        "templates": [
            "stepFunctionStandard",
            "stepFunctionExpress"
        ],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/awsStepFunctions/en_US.json",
        "slug": "StepFunctions",
        "mvpSupport": false,
        "comparableTerms": [
            "stepfunctions"
        ]
    },
    "aWSStorageGateway": {
        "name": "AWS Storage Gateway",
        "serviceCode": "aWSStorageGateway",
        "description": "AWS Storage Gateway is a hybrid storage service that enables your on-premises applications to seamlessly use AWS cloud storage. You can use the service for backup and archiving, disaster recovery, cloud data processing, storage tiering, and migration.",
        "searchKeywords": [
            "Storage",
            "on premises",
            "cloud migration",
            "integrated storage",
            "store data in the cloud",
            "secure storage",
            "storage integration",
            "hybrid storage",
            "on prem storage",
            "gateway cached volumes",
            "gateway stored volumes",
            "gateway virtual tape library",
            "VTL",
            "backup",
            "disaster recovery",
            "disaster resilience",
            "corporate file sharing",
            "data mirroring",
            "cloud storage"
        ],
        "type": "AWSService",
        "regions": [
            ""
        ],
        "linkUrl": "https://aws.amazon.com/storagegateway/",
        "isActive": "true",
        "hasDataTransfer": true,
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/aWSStorageGateway/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/aWSStorageGateway/en_US.json",
        "slug": "StorageGateway",
        "mvpSupport": false,
        "comparableTerms": [
            "storagegateway"
        ]
    },
    "awsSystemsManager": {
        "name": "AWS Systems Manager",
        "serviceCode": "awsSystemsManager",
        "description": "AWS Systems Manager gives you visibility and control of your infrastructure on AWS. Systems Manager provides a unified user interface so you can view operational data from multiple AWS services and allows you to automate operational tasks across your AWS resources.",
        "searchKeywords": [
            "Manager",
            "Systems",
            "control",
            "infrastructure",
            "operational data",
            "visibility",
            "resource management",
            "application management",
            "unified user interface",
            "OpsCenter",
            "Automation",
            "On-premesis instance management",
            "Distributor",
            "Parameter Store",
            "AWS AppConfig"
        ],
        "type": "AWSService",
        "regions": [],
        "linkUrl": "https://aws.amazon.com/systems-manager/",
        "isActive": "true",
        "subType": "subServiceSelector",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/awsSystemsManager/en_US.json",
        "c2e": false,
        "templates": [
            "awsSystemsManagerOpsCenter",
            "awsAppConfig",
            "awsSystemsManagerParameterStore",
            "awsSystemsManagerOnPremisesInstanceManagement",
            "awsSystemsManagerDistributor",
            "awsSystemsManagerAutomation",
            "awsSystemsManagerIncidentManager"
        ],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/awsSystemsManager/en_US.json",
        "slug": "SystemsManager",
        "mvpSupport": false,
        "comparableTerms": [
            "systemsmanager"
        ]
    },
    "aWSTransferForSFTP": {
        "name": "AWS Transfer Family",
        "serviceCode": "aWSTransferForSFTP",
        "description": "Amazon Transfer Family is a fully managed SFTP, FTPS, FTP, and AS2 service.",
        "searchKeywords": [
            "sftp",
            "FTPS",
            "as2",
            "amazon s3",
            "s3",
            "winscp",
            "filezilla",
            "cyberduck",
            "ssh",
            "transfer",
            "ftp",
            "ftp/s",
            "openssh",
            "file transfer",
            "secure file transfer",
            "ssh ftp",
            "secure shell file transfer protocol",
            "file transfer protocol"
        ],
        "type": "AWSService",
        "regions": [],
        "linkUrl": "https://aws.amazon.com/aws-transfer-family/",
        "isActive": "true",
        "subType": "subServiceSelector",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/aWSTransferForSFTP/en_US.json",
        "c2e": false,
        "templates": [
            "as2",
            "sftp",
            "ftps",
            "ftp"
        ],
        "disableRegionSupport": false,
        "bulkImportEnabled": false,
        "serviceDefinitionUrlPath": "/data/aWSTransferForSFTP/en_US.json",
        "slug": "TransferFamily",
        "mvpSupport": false,
        "comparableTerms": [
            "transferfamily",
            "transferforsftp"
        ]
    },
    "awsWebApplicationFirewall": {
        "name": "AWS Web Application Firewall (WAF)",
        "serviceCode": "awsWebApplicationFirewall",
        "description": "AWS WAF is a web application firewall that helps protect your web applications or APIs against common web exploits that may affect availability, compromise security, or consume excessive resources.",
        "searchKeywords": [
            "Security Identity Compliance",
            "appsec",
            "application security",
            "web security",
            "blacklisting",
            "whitelisting",
            "Security as a service (SAAS)",
            "perimeter security",
            "perimeter protection",
            "bot detection",
            "DDoS",
            "firewall",
            "IP blocking",
            "OWASP",
            "IP reputation",
            "HTTP flood",
            "AWS Firewall Manager",
            "Cross Account WAF",
            "Cross Account Firewall",
            "Firewall Compliance",
            "Firewall Manager"
        ],
        "type": "AWSService",
        "regions": [
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2",
            "af-south-1",
            "ap-east-1",
            "ap-south-1",
            "ap-northeast-2",
            "ap-northeast-3",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-northeast-1",
            "us-gov-east-1",
            "us-gov-west-1",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "eu-south-1",
            "eu-west-3",
            "eu-north-1",
            "me-south-1",
            "sa-east-1"
        ],
        "linkUrl": "https://aws.amazon.com/waf/",
        "isActive": "true",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/awsWebApplicationFirewall/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/awsWebApplicationFirewall/en_US.json",
        "slug": "WAF",
        "mvpSupport": false,
        "comparableTerms": [
            "waf",
            "webapplicationfirewall",
            "webapplicationfirewallwaf"
        ]
    },
    "awsWickr": {
        "name": "AWS Wickr",
        "serviceCode": "awsWickr",
        "description": "Enable secure communication with end-to-end encryption. ",
        "searchKeywords": [
            "aws wickr",
            "wickr"
        ],
        "type": "AWSService",
        "regions": [
            " "
        ],
        "linkUrl": "https://aws.amazon.com/wickr",
        "isActive": "true",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/awsWickr/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "bulkImportEnabled": false,
        "serviceDefinitionUrlPath": "/data/awsWickr/en_US.json",
        "slug": "wickr",
        "mvpSupport": false,
        "comparableTerms": [
            "wickr"
        ]
    },
    "awsXRay": {
        "name": "AWS X-Ray",
        "serviceCode": "awsXRay",
        "description": "AWS X-Ray makes it easy for developers to analyze the behavior of their production, distributed applications with end-to-end tracing capabilities. You can use X-Ray to identify performance bottlenecks, edge case errors, and other hard to detect issues.",
        "searchKeywords": [
            "X-Ray",
            "xray",
            "monitor"
        ],
        "type": "AWSService",
        "regions": [
            "af-south-1",
            "ap-east-1",
            "ap-northeast-1",
            "ap-northeast-2",
            "ap-northeast-3",
            "ap-south-1",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-southeast-3",
            "ca-central-1",
            "eu-central-1",
            "eu-north-1",
            "eu-south-1",
            "eu-west-1",
            "eu-west-2",
            "eu-west-3",
            "me-south-1",
            "me-central-1",
            "sa-east-1",
            "us-east-2",
            "us-gov-west-1",
            "us-gov-east-1",
            "us-west-1",
            "us-west-2",
            "us-east-1"
        ],
        "linkUrl": "https://aws.amazon.com/xray/",
        "isActive": "true",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/awsXRay/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "slug": "xray",
        "mvpSupport": false,
        "comparableTerms": [
            "xray"
        ]
    },
    "chimeSdk": {
        "name": "Chime SDK",
        "serviceCode": "chimeSdk",
        "description": "Amazon Chime lets you meet, chat, and collaborate with the security of AWS. You can work seamlessly on your devices, and meet from your desk or on the go - ensuring you always stay connected.",
        "searchKeywords": [],
        "type": "AWSService",
        "regions": [
            "us-east-1"
        ],
        "linkUrl": "https://aws.amazon.com/chime/",
        "isActive": "true",
        "subType": "subService",
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/chimeSdk/en_US.json",
        "c2e": false,
        "comparableTerms": [
            "chimesdk"
        ]
    },
    "chimeVoiceConnectorAnalysis": {
        "name": "Chime Voice Connector analysis",
        "serviceCode": "chimeVoiceConnectorAnalysis",
        "description": "Amazon Chime lets you meet, chat, and collaborate with the security of AWS. You can work seamlessly on your devices, and meet from your desk or on the go - ensuring you always stay connected.",
        "searchKeywords": [],
        "type": "AWSService",
        "regions": [
            "us-east-1"
        ],
        "linkUrl": "https://aws.amazon.com/chime/",
        "isActive": "true",
        "subType": "subService",
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/chimeVoiceConnectorAnalysis/en_US.json",
        "c2e": false,
        "mvpSupport": false,
        "comparableTerms": [
            "chimevoiceconnectoranalysis"
        ]
    },
    "classicLoadBalancer": {
        "name": "Classic Load Balancer",
        "serviceCode": "classicLoadBalancer",
        "description": "Elastic Load Balancing automatically distributes incoming application traffic across multiple targets, such as Amazon EC2 instances, containers, IP addresses, and Lambda functions.",
        "searchKeywords": [
            "ELB",
            "Elastic Load Balancer",
            "Load Balancer",
            "Application Load Balancer",
            "Network Load Balancer",
            "Classic Load Balancer"
        ],
        "type": "AWSService",
        "regions": [
            "af-south-1",
            "ap-east-1",
            "ap-northeast-1",
            "ap-northeast-2",
            "ap-northeast-3",
            "ap-south-1",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-southeast-3",
            "ca-central-1",
            "eu-central-1",
            "eu-north-1",
            "eu-south-1",
            "eu-west-1",
            "eu-west-2",
            "eu-west-3",
            "me-south-1",
            "me-central-1",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-gov-east-1",
            "us-gov-west-1",
            "us-west-1",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/elasticloadbalancing/",
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/classicLoadBalancer/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/classicLoadBalancer/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "classicloadbalancer"
        ],
        "parentServiceCode": "elasticLoadBalancing"
    },
    "cloudWan": {
        "name": "Cloud WAN",
        "serviceCode": "cloudWan",
        "description": "AWS Cloud WAN provides a central dashboard for making connections between your branch offices, data centers, and Amazon Virtual Private Clouds (VPCs) – building a global network with only a few clicks. You use network policies to automate network management and security tasks in one location. Cloud WAN generates a complete view of your on-premises and AWS networks to help you monitor network health, security, and performance.",
        "searchKeywords": [
            "Cloud WAN",
            "cloud",
            "cloudwan"
        ],
        "type": "AWSService",
        "regions": [
            "us-east-1"
        ],
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/cloudWan/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/cloudWan/en_US.json",
        "slug": "cloudwan",
        "mvpSupport": false,
        "comparableTerms": [
            "cloudwan"
        ],
        "parentServiceCode": "amazonVirtualPrivateCloud"
    },
    "comprehendCustomClassification": {
        "name": "Comprehend Custom Classification",
        "serviceCode": "comprehendCustomClassification",
        "description": "With Amazon Comprehend, you only pay for what you use. You are charged based on the amount of text processed on a monthly basis. Amazon Comprehend provides natural language processing, topic modeling, and Custom Classification capabilities, enabling a broad range of applications that can analyze text.",
        "searchKeywords": [
            "Comprehend",
            "NLP",
            "Natural language processing",
            "Sentiment analysis",
            "Text analytics",
            "Entity extraction",
            "Named entity recognition",
            "NER",
            "Key phrase extraction",
            "Topic modeling",
            "Unsupervised clustering",
            "Supervised machine learning",
            "Custom entity recognition",
            "Custom classification",
            "Document classifier",
            "Personally identifiable information",
            "PII",
            "Redaction",
            "Language detection",
            "Free form text analytics"
        ],
        "type": "AWSService",
        "regions": [
            "us-gov-west-1",
            "ap-south-1",
            "ap-northeast-2",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-northeast-1",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "us-east-1",
            "us-east-2",
            "us-west-2"
        ],
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/comprehendCustomClassification/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/comprehendCustomClassification/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "comprehendcustomclassification"
        ],
        "parentServiceCode": "amazonComprehend"
    },
    "comprehendCustomEntities": {
        "name": "Comprehend Custom Entities",
        "serviceCode": "comprehendCustomEntities",
        "description": "With Amazon Comprehend, you only pay for what you use. You are charged based on the amount of text processed on a monthly basis. Amazon Comprehend provides natural language processing, topic modeling, and Custom Classification capabilities, enabling a broad range of applications that can analyze text.",
        "searchKeywords": [],
        "type": "AWSService",
        "regions": [
            "us-gov-west-1",
            "ap-south-1",
            "ap-northeast-2",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-northeast-1",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "us-east-1",
            "us-east-2",
            "us-west-2"
        ],
        "isActive": "true",
        "subType": "subService",
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/comprehendCustomEntities/en_US.json",
        "c2e": false,
        "mvpSupport": false,
        "comparableTerms": [
            "comprehendcustomentities"
        ],
        "parentServiceCode": "amazonComprehend"
    },
    "containsPii": {
        "name": "Contains PII",
        "serviceCode": "containsPii",
        "description": "With Amazon Comprehend, you only pay for what you use. You are charged based on the amount of text processed on a monthly basis. Amazon Comprehend provides natural language processing, topic modeling, and Custom Classification capabilities, enabling a broad range of applications that can analyze text.",
        "searchKeywords": [
            "Comprehend",
            "NLP",
            "Natural language processing",
            "Sentiment analysis",
            "Text analytics",
            "Entity extraction",
            "Named entity recognition",
            "NER",
            "Key phrase extraction",
            "Topic modeling",
            "Unsupervised clustering",
            "Supervised machine learning",
            "Custom entity recognition",
            "Custom classification",
            "Document classifier",
            "Personally identifiable information",
            "PII",
            "Contains PII",
            "Redaction",
            "Language detection",
            "Free form text analytics"
        ],
        "type": "AWSService",
        "regions": [
            "us-gov-west-1",
            "ap-south-1",
            "ap-northeast-2",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-northeast-1",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "us-east-1",
            "us-east-2",
            "us-west-2"
        ],
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/containsPii/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/containsPii/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "containspii"
        ],
        "parentServiceCode": "amazonComprehend"
    },
    "awsS3DataTransfer": {
        "name": "Data Transfer",
        "serviceCode": "awsS3DataTransfer",
        "description": "The cost of transferring data at AWS for services without unique transfer costs.",
        "searchKeywords": [],
        "type": "AWSService",
        "regions": [
            "af-south-1",
            "ap-east-1",
            "ap-northeast-1",
            "ap-northeast-2",
            "ap-northeast-3",
            "ap-south-1",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-southeast-3",
            "ca-central-1",
            "me-south-1",
            "me-central-1",
            "eu-central-1",
            "eu-north-1",
            "eu-south-1",
            "eu-west-1",
            "eu-west-2",
            "eu-west-3",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-gov-east-1",
            "us-gov-west-1",
            "us-west-1",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/ec2/pricing/on-demand/#Data_Transfer",
        "isActive": "true",
        "hasDataTransfer": true,
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/awsS3DataTransfer/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "mvpSupport": false,
        "comparableTerms": [
            "datatransfer",
            "s3datatransfer"
        ],
        "parentServiceCode": "amazonSimpleStorageServiceGroup"
    },
    "dataTransferVpc": {
        "name": "Data Transfer",
        "serviceCode": "dataTransferVpc",
        "description": "WS Virtual Private Network solutions establish secure connections between your on-premises networks, remote offices, client devices, and the AWS global network. AWS VPN is comprised of two services: AWS Site-to-Site VPN and AWS Client VPN. Each service provides a highly-available, managed, and elastic cloud VPN solution to protect your network traffic.",
        "searchKeywords": [
            "access control",
            "ACL",
            "AWS Privatelink",
            "Cloud connectivity",
            "corporate network",
            "elastic IP",
            "Gateway load balancer",
            "home network VPN",
            "IPAM",
            "NAT",
            "NAT gateway",
            "Network Access Analyzer",
            "Network Address Translation",
            "Networking Content Delivery",
            "PrivateLink",
            "Reachability Analyzer",
            "security",
            "single tenant hardware",
            "static ip",
            "subnets",
            "Traffic mirroring",
            "Transit Gateway",
            "Virtual Private Cloud",
            "VPN"
        ],
        "type": "AWSService",
        "regions": [
            "af-south-1",
            "ap-east-1",
            "ap-southeast-3",
            "ap-south-1",
            "ap-northeast-3",
            "ap-northeast-2",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-northeast-1",
            "us-gov-east-1",
            "us-gov-west-1",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "eu-south-1",
            "eu-west-3",
            "eu-north-1",
            "me-south-1",
            "me-central-1",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2"
        ],
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/dataTransferVpc/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/dataTransferVpc/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "datatransfer",
            "datatransfervpc"
        ],
        "parentServiceCode": "amazonVirtualPrivateCloud"
    },
    "piiDetection": {
        "name": "Detect PII",
        "serviceCode": "piiDetection",
        "description": "With Amazon Comprehend, you only pay for what you use. You are charged based on the amount of text processed on a monthly basis. Amazon Comprehend provides natural language processing, topic modeling, and Custom Classification capabilities, enabling a broad range of applications that can analyze text.",
        "searchKeywords": [
            "Comprehend",
            "NLP",
            "Natural language processing",
            "Sentiment analysis",
            "Text analytics",
            "Entity extraction",
            "Named entity recognition",
            "NER",
            "Key phrase extraction",
            "Topic modeling",
            "Unsupervised clustering",
            "Supervised machine learning",
            "Custom entity recognition",
            "Custom classification",
            "Document classifier",
            "Personally identifiable information",
            "PII",
            "Redaction",
            "Language detection",
            "Free form text analytics"
        ],
        "type": "AWSService",
        "regions": [
            "us-gov-west-1",
            "ap-south-1",
            "ap-northeast-2",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-northeast-1",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "us-east-1",
            "us-east-2",
            "us-west-2"
        ],
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/piiDetection/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/piiDetection/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "detectpii",
            "piidetection"
        ],
        "parentServiceCode": "amazonComprehend"
    },
    "awsSystemsManagerDistributor": {
        "name": "Distributor",
        "serviceCode": "awsSystemsManagerDistributor",
        "description": "AWS Systems Manager Distributor feature",
        "searchKeywords": [
            "System Manager",
            "Distributor",
            "distriubte and maintain software packages"
        ],
        "type": "AWSService",
        "regions": [
            "us-gov-west-1",
            "us-gov-east-1",
            "af-south-1",
            "ap-east-1",
            "ap-south-1",
            "ap-northeast-3",
            "ap-northeast-2",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-southeast-3",
            "ap-northeast-1",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "eu-south-1",
            "eu-west-3",
            "eu-north-1",
            "me-south-1",
            "me-central-1",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/systems-manager/",
        "isActive": "true",
        "hasDataTransfer": false,
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/awsSystemsManagerDistributor/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/awsSystemsManagerDistributor/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "distributor",
            "systemsmanagerdistributor"
        ],
        "parentServiceCode": "awsSystemsManager"
    },
    "amazonDocumentDbBackup": {
        "name": "DocumentDB",
        "serviceCode": "amazonDocumentDbBackup",
        "description": "AWS Backup for DocumentDB",
        "searchKeywords": [],
        "type": "AWSService",
        "regions": [
            "us-gov-west-1",
            "us-gov-east-1",
            "af-south-1",
            "ap-east-1",
            "ap-south-1",
            "ap-northeast-3",
            "ap-northeast-2",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-southeast-3",
            "ap-northeast-1",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "eu-south-1",
            "eu-west-3",
            "eu-north-1",
            "me-south-1",
            "me-central-1",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/backup/",
        "isActive": "true",
        "hasDataTransfer": true,
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonDocumentDbBackup/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/amazonDocumentDbBackup/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "backupdocumentdb",
            "documentdbbackup"
        ],
        "parentServiceCode": "awsBackup"
    },
    "amazonDynamoDbBackup": {
        "name": "DynamoDB",
        "serviceCode": "amazonDynamoDbBackup",
        "description": "AWS Backup for DynamoDB",
        "searchKeywords": [],
        "type": "AWSService",
        "regions": [
            "us-gov-west-1",
            "us-gov-east-1",
            "af-south-1",
            "ap-east-1",
            "ap-south-1",
            "ap-northeast-3",
            "ap-northeast-2",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-southeast-3",
            "ap-northeast-1",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "eu-south-1",
            "eu-west-3",
            "eu-north-1",
            "me-south-1",
            "me-central-1",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/backup/",
        "isActive": "true",
        "hasDataTransfer": true,
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonDynamoDbBackup/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/amazonDynamoDbBackup/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "backupdynamodb",
            "dynamodbbackup"
        ],
        "parentServiceCode": "awsBackup"
    },
    "amazonDynamoDbDaxClusters": {
        "name": "DynamoDB Accelerator (DAX) clusters",
        "serviceCode": "amazonDynamoDbDaxClusters",
        "description": "Amazon DynamoDB is a key-value and document database that delivers single-digit millisecond performance at any scale. It's a fully managed, multiregion, multimaster, durable database with built-in security, backup and restore, and in-memory caching for internet-scale applications.",
        "searchKeywords": [
            "Database",
            "DDB",
            "NoSQL",
            "SQL",
            "Table",
            "nosql databases",
            "database schema",
            "database software",
            "cloud database",
            "document database",
            "key value store",
            "database as a service",
            "database scheme",
            "nosql hosting",
            "hosted nosql",
            "data store",
            "unstructured database",
            "Accelerator",
            "DAX"
        ],
        "type": "AWSService",
        "regions": [
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2",
            "ap-south-1",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-northeast-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "eu-west-3",
            "sa-east-1"
        ],
        "linkUrl": "https://aws.amazon.com/dynamodb/",
        "isActive": "true",
        "hasDataTransfer": true,
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonDynamoDbDaxClusters/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/amazonDynamoDbDaxClusters/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "dax",
            "dynamodbacceleratordaxclusters",
            "dynamodbdaxclusters"
        ],
        "parentServiceCode": "amazonDynamoDb"
    },
    "dynamoDbBackup": {
        "name": "DynamoDB Backup and restore",
        "serviceCode": "dynamoDbBackup",
        "description": "Amazon DynamoDB is a key-value and document database that delivers single-digit millisecond performance at any scale. It's a fully managed, multiregion, multimaster, durable database with built-in security, backup and restore, and in-memory caching for internet-scale applications.",
        "searchKeywords": [
            "Database",
            "DDB",
            "NoSQL",
            "SQL",
            "Table",
            "nosql databases",
            "database schema",
            "database software",
            "cloud database",
            "document database",
            "key value store",
            "database as a service",
            "database scheme",
            "nosql hosting",
            "hosted nosql",
            "data store",
            "unstructured database",
            "Accelerator",
            "DAX"
        ],
        "type": "AWSService",
        "regions": [
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2",
            "af-south-1",
            "ap-east-1",
            "ap-south-1",
            "ap-northeast-2",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-northeast-1",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "eu-south-1",
            "eu-west-3",
            "eu-north-1",
            "me-south-1",
            "me-central-1",
            "sa-east-1",
            "us-gov-east-1",
            "us-gov-west-1"
        ],
        "linkUrl": "https://aws.amazon.com/dynamodb/",
        "isActive": "true",
        "hasDataTransfer": true,
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/dynamoDbBackup/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/dynamoDbBackup/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "dynamodbbackup",
            "dynamodbbackuprestore"
        ],
        "parentServiceCode": "amazonDynamoDb"
    },
    "dynamoDbChangeDateCapture": {
        "name": "DynamoDB change data capture",
        "serviceCode": "dynamoDbChangeDateCapture",
        "description": "Amazon DynamoDB is a key-value and document database that delivers single-digit millisecond performance at any scale. It's a fully managed, multiregion, multimaster, durable database with built-in security, backup and restore, and in-memory caching for internet-scale applications.",
        "searchKeywords": [
            "Database",
            "DDB",
            "NoSQL",
            "SQL",
            "Table",
            "nosql databases",
            "database schema",
            "database software",
            "cloud database",
            "document database",
            "key value store",
            "database as a service",
            "database scheme",
            "nosql hosting",
            "hosted nosql",
            "data store",
            "unstructured database",
            "Accelerator",
            "DAX",
            "change data capture",
            "Kinesis"
        ],
        "type": "AWSService",
        "regions": [
            "ap-northeast-1",
            "ap-northeast-2",
            "ap-south-1",
            "ap-southeast-1",
            "ap-southeast-2",
            "ca-central-1",
            "eu-central-1",
            "eu-north-1",
            "eu-south-1",
            "eu-west-1",
            "eu-west-2",
            "eu-west-3",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/dynamodb/",
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/dynamoDbChangeDateCapture/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/dynamoDbChangeDateCapture/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "dynamodbchangedatacapture",
            "dynamodbchangedatecapture"
        ],
        "parentServiceCode": "amazonDynamoDb"
    },
    "dynamoDbDataExportToAmazonS3": {
        "name": "DynamoDB Data export to Amazon S3",
        "serviceCode": "dynamoDbDataExportToAmazonS3",
        "description": "Amazon DynamoDB is a key-value and document database that delivers single-digit millisecond performance at any scale. It's a fully managed, multiregion, multimaster, durable database with built-in security, backup and restore, and in-memory caching for internet-scale applications.",
        "searchKeywords": [
            "Database",
            "DDB",
            "NoSQL",
            "SQL",
            "Table",
            "nosql databases",
            "database schema",
            "database software",
            "cloud database",
            "document database",
            "key value store",
            "database as a service",
            "database scheme",
            "nosql hosting",
            "hosted nosql",
            "data store",
            "unstructured database",
            "Accelerator",
            "DAX"
        ],
        "type": "AWSService",
        "regions": [
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2",
            "af-south-1",
            "ap-east-1",
            "ap-south-1",
            "ap-northeast-3",
            "ap-northeast-2",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-northeast-1",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "eu-south-1",
            "eu-west-3",
            "eu-north-1",
            "me-south-1",
            "me-central-1",
            "sa-east-1",
            "us-gov-east-1",
            "us-gov-west-1"
        ],
        "linkUrl": "https://aws.amazon.com/dynamodb/",
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/dynamoDbDataExportToAmazonS3/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/dynamoDbDataExportToAmazonS3/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "dynamodbdataexporttoamazons3",
            "dynamodbdataexporttos3"
        ],
        "parentServiceCode": "amazonDynamoDb"
    },
    "dynamoDbDataImportFromAmazonS3": {
        "name": "DynamoDB Data Import from Amazon S3",
        "serviceCode": "dynamoDbDataImportFromAmazonS3",
        "description": "Amazon DynamoDB is a key-value and document database that delivers single-digit millisecond performance at any scale. It's a fully managed, multiregion, multimaster, durable database with built-in security, backup and restore, and in-memory caching for internet-scale applications.",
        "searchKeywords": [
            "Database",
            "DDB",
            "NoSQL",
            "SQL",
            "Table",
            "nosql databases",
            "database schema",
            "database software",
            "cloud database",
            "document database",
            "key value store",
            "database as a service",
            "database scheme",
            "nosql hosting",
            "hosted nosql",
            "data store",
            "unstructured database",
            "Accelerator",
            "DAX"
        ],
        "type": "AWSService",
        "regions": [
            "af-south-1",
            "ap-east-1",
            "ap-northeast-1",
            "ap-northeast-2",
            "ap-northeast-3",
            "ap-south-1",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-southeast-3",
            "ca-central-1",
            "eu-central-1",
            "eu-north-1",
            "eu-south-1",
            "eu-west-1",
            "eu-west-2",
            "eu-west-3",
            "me-south-1",
            "me-central-1",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-gov-east-1",
            "us-gov-west-1",
            "us-west-1",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/dynamodb/",
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/dynamoDbDataImportFromAmazonS3/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/dynamoDbDataImportFromAmazonS3/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "dynamodbdataimportfromamazons3",
            "dynamodbdataimportfroms3"
        ],
        "parentServiceCode": "amazonDynamoDb"
    },
    "dynamoDbOnDemand": {
        "name": "DynamoDB on-demand capacity",
        "serviceCode": "dynamoDbOnDemand",
        "description": "Amazon DynamoDB is a key-value and document database that delivers single-digit millisecond performance at any scale. It's a fully managed, multiregion, multimaster, durable database with built-in security, backup and restore, and in-memory caching for internet-scale applications.",
        "searchKeywords": [
            "Database",
            "DDB",
            "NoSQL",
            "SQL",
            "Table",
            "nosql databases",
            "database schema",
            "database software",
            "cloud database",
            "document database",
            "key value store",
            "database as a service",
            "database scheme",
            "nosql hosting",
            "hosted nosql",
            "data store",
            "unstructured database",
            "Accelerator",
            "DAX"
        ],
        "type": "AWSService",
        "regions": [
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2",
            "af-south-1",
            "ap-east-1",
            "ap-south-1",
            "ap-northeast-3",
            "ap-northeast-2",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-southeast-3",
            "ap-northeast-1",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "eu-south-1",
            "eu-west-3",
            "eu-north-1",
            "me-south-1",
            "me-central-1",
            "sa-east-1",
            "us-gov-east-1",
            "us-gov-west-1"
        ],
        "linkUrl": "https://aws.amazon.com/dynamodb/",
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/dynamoDbOnDemand/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/dynamoDbOnDemand/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "dynamodbdemandcapacity",
            "dynamodbondemand"
        ],
        "parentServiceCode": "amazonDynamoDb"
    },
    "amazonDynamoDbProvisionedThroughputCapacity": {
        "name": "DynamoDB provisioned capacity",
        "serviceCode": "amazonDynamoDbProvisionedThroughputCapacity",
        "description": "Amazon DynamoDB is a key-value and document database that delivers single-digit millisecond performance at any scale. It's a fully managed, multiregion, multimaster, durable database with built-in security, backup and restore, and in-memory caching for internet-scale applications.",
        "searchKeywords": [
            "Provisioned",
            "Throughput",
            "Database",
            "DynamoDB",
            "DDB",
            "NoSQL",
            "SQL",
            "Table",
            "nosql databases",
            "database schema",
            "database software",
            "cloud database",
            "document database",
            "key value store",
            "database as a service",
            "database scheme",
            "nosql hosting",
            "hosted nosql",
            "data store",
            "unstructured database",
            "Accelerator",
            "DAX"
        ],
        "type": "AWSService",
        "regions": [
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2",
            "af-south-1",
            "ap-east-1",
            "ap-south-1",
            "ap-northeast-3",
            "ap-northeast-2",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-southeast-3",
            "ap-northeast-1",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "eu-south-1",
            "eu-west-3",
            "eu-north-1",
            "me-south-1",
            "me-central-1",
            "sa-east-1",
            "us-gov-east-1",
            "us-gov-west-1"
        ],
        "linkUrl": "https://aws.amazon.com/dynamodb",
        "isActive": "true",
        "hasDataTransfer": true,
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonDynamoDbProvisionedThroughputCapacity/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/amazonDynamoDbProvisionedThroughputCapacity/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "dynamodbprovisionedcapacity",
            "dynamodbprovisionedthroughputcapacity"
        ],
        "parentServiceCode": "amazonDynamoDb"
    },
    "amazonDynamoDbStreams": {
        "name": "DynamoDB Streams",
        "serviceCode": "amazonDynamoDbStreams",
        "description": "Amazon DynamoDB is a key-value and document database that delivers single-digit millisecond performance at any scale. It's a fully managed, multiregion, multimaster, durable database with built-in security, backup and restore, and in-memory caching for internet-scale applications.",
        "searchKeywords": [
            "Database",
            "DDB",
            "NoSQL",
            "SQL",
            "Table",
            "nosql databases",
            "database schema",
            "database software",
            "cloud database",
            "document database",
            "key value store",
            "database as a service",
            "database scheme",
            "nosql hosting",
            "hosted nosql",
            "data store",
            "unstructured database",
            "Accelerator",
            "DAX"
        ],
        "type": "AWSService",
        "regions": [
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2",
            "af-south-1",
            "ap-east-1",
            "ap-south-1",
            "ap-northeast-3",
            "ap-northeast-2",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-northeast-1",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "eu-south-1",
            "eu-west-3",
            "eu-north-1",
            "me-south-1",
            "me-central-1",
            "sa-east-1",
            "us-gov-east-1",
            "us-gov-west-1"
        ],
        "linkUrl": "https://aws.amazon.com/dynamodb/",
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonDynamoDbStreams/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/amazonDynamoDbStreams/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "dynamodbstreams"
        ],
        "parentServiceCode": "amazonDynamoDb"
    },
    "amazonEbsBackup": {
        "name": "EBS",
        "serviceCode": "amazonEbsBackup",
        "description": "AWS Backup for EBS",
        "searchKeywords": [],
        "type": "AWSService",
        "regions": [
            "us-gov-west-1",
            "us-gov-east-1",
            "af-south-1",
            "ap-east-1",
            "ap-south-1",
            "ap-northeast-3",
            "ap-northeast-2",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-southeast-3",
            "ap-northeast-1",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "eu-south-1",
            "eu-west-3",
            "eu-north-1",
            "me-south-1",
            "me-central-1",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/backup/",
        "isActive": "true",
        "hasDataTransfer": true,
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonEbsBackup/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/amazonEbsBackup/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "backupebs",
            "ebsbackup"
        ],
        "parentServiceCode": "awsBackup"
    },
    "amazonEfsBackup": {
        "name": "EFS",
        "serviceCode": "amazonEfsBackup",
        "description": "AWS Backup for EFS",
        "searchKeywords": [],
        "type": "AWSService",
        "regions": [
            "us-gov-west-1",
            "us-gov-east-1",
            "af-south-1",
            "ap-east-1",
            "ap-south-1",
            "ap-northeast-3",
            "ap-northeast-2",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-southeast-3",
            "ap-northeast-1",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "eu-south-1",
            "eu-west-3",
            "eu-north-1",
            "me-south-1",
            "me-central-1",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/backup/",
        "isActive": "true",
        "hasDataTransfer": true,
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonEfsBackup/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/amazonEfsBackup/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "backupefs",
            "efsbackup"
        ],
        "parentServiceCode": "awsBackup"
    },
    "elasticLoadBalancing": {
        "name": "Elastic Load Balancing",
        "serviceCode": "elasticLoadBalancing",
        "description": "Elastic Load Balancing automatically distributes incoming application traffic across multiple targets, such as Amazon EC2 instances, containers, IP addresses, and Lambda functions.",
        "searchKeywords": [
            "ELB",
            "Elastic Load Balancer",
            "Load Balancer",
            "Application Load Balancer",
            "Network Load Balancer",
            "Gateway Load Balancer",
            "Classic Load Balancer"
        ],
        "type": "AWSService",
        "regions": [],
        "linkUrl": "https://aws.amazon.com/elasticloadbalancing",
        "isActive": "true",
        "subType": "subServiceSelector",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/elasticLoadBalancing/en_US.json",
        "c2e": false,
        "templates": [
            "applicationLoadBalancer",
            "networkLoadBalancer",
            "gatewayLoadBalancer",
            "classicLoadBalancer"
        ],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/elasticLoadBalancing/en_US.json",
        "slug": "ElasticLoadBalancing",
        "mvpSupport": false,
        "comparableTerms": [
            "elasticloadbalancing"
        ]
    },
    "entityRecognition": {
        "name": "Entity Recognition",
        "serviceCode": "entityRecognition",
        "description": "With Amazon Comprehend, you only pay for what you use. You are charged based on the amount of text processed on a monthly basis. Amazon Comprehend provides natural language processing, topic modeling, and Custom Classification capabilities, enabling a broad range of applications that can analyze text.",
        "searchKeywords": [
            "Comprehend",
            "NLP",
            "Natural language processing",
            "Sentiment analysis",
            "Text analytics",
            "Entity extraction",
            "Named entity recognition",
            "NER",
            "Key phrase extraction",
            "Topic modeling",
            "Unsupervised clustering",
            "Supervised machine learning",
            "Custom entity recognition",
            "Custom classification",
            "Document classifier",
            "Personally identifiable information",
            "PII",
            "Redaction",
            "Language detection",
            "Free form text analytics"
        ],
        "type": "AWSService",
        "regions": [
            "us-gov-west-1",
            "ap-south-1",
            "ap-northeast-2",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-northeast-1",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "us-east-1",
            "us-east-2",
            "us-west-2"
        ],
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/entityRecognition/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/entityRecognition/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "entityrecognition"
        ],
        "parentServiceCode": "amazonComprehend"
    },
    "eventDetectionPerEventType": {
        "name": "Event Detection",
        "serviceCode": "eventDetectionPerEventType",
        "description": "Comprehend Events identifies real-world events such as acquisitions, IPOs and bankruptcies from text documents and extracts all the related details around the event such as investor, invested, deal amount and more. You can apply natural language processing with asynchronous jobs for event detection across large collections of documents.",
        "searchKeywords": [
            "Comprehend",
            "NLP",
            "Natural language processing",
            "Sentiment analysis",
            "Text analytics",
            "Entity extraction",
            "Named entity recognition",
            "NER",
            "Key phrase extraction",
            "Topic modeling",
            "Unsupervised clustering",
            "Supervised machine learning",
            "Custom entity recognition",
            "Custom classification",
            "Document classifier",
            "Personally identifiable information",
            "PII",
            "Redaction",
            "Language detection",
            "Free form text analytics",
            "Event",
            "Event Analysis"
        ],
        "type": "AWSService",
        "regions": [
            "us-gov-west-1",
            "ap-south-1",
            "ap-northeast-2",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-northeast-1",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "us-east-1",
            "us-east-2",
            "us-west-2"
        ],
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/eventDetectionPerEventType/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/eventDetectionPerEventType/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "eventdetection",
            "eventdetectionpereventtype"
        ],
        "parentServiceCode": "amazonComprehend"
    },
    "fifoTopics": {
        "name": "FIFO Topics",
        "serviceCode": "fifoTopics",
        "description": "Amazon Simple Notification Service (SNS) is a highly available, durable, secure, fully managed pub/sub messaging service that enables you to decouple microservices, distributed systems, and serverless applications",
        "searchKeywords": [
            "Messaging",
            "SNS",
            "notification topic",
            "publish message",
            "subscription",
            "text message",
            "sms",
            "topics",
            "push notifications",
            "push notification service queuing",
            "FIFO topics"
        ],
        "type": "AWSService",
        "regions": [],
        "linkUrl": "https://aws.amazon.com/sns/pricing/",
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/fifoTopics/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "bulkImportEnabled": false,
        "serviceDefinitionUrlPath": "/data/fifoTopics/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "fifotopics"
        ],
        "parentServiceCode": "amazonSimpleNotificationService"
    },
    "amazonFSxLustreBackup": {
        "name": "FSx Lustre",
        "serviceCode": "amazonFSxLustreBackup",
        "description": "AWS Backup for FSx for Lustre",
        "searchKeywords": [],
        "type": "AWSService",
        "regions": [
            "us-gov-west-1",
            "us-gov-east-1",
            "af-south-1",
            "ap-east-1",
            "ap-south-1",
            "ap-northeast-3",
            "ap-northeast-2",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-southeast-3",
            "ap-northeast-1",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "eu-south-1",
            "eu-west-3",
            "eu-north-1",
            "me-south-1",
            "me-central-1",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/backup/",
        "isActive": "true",
        "hasDataTransfer": true,
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonFSxLustreBackup/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/amazonFSxLustreBackup/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "fsxlustre",
            "fsxlustrebackup"
        ],
        "parentServiceCode": "awsBackup"
    },
    "amazonFSxNetAppOntapBackup": {
        "name": "FSx NetApp ONTAP",
        "serviceCode": "amazonFSxNetAppOntapBackup",
        "description": "AWS Backup for FSx NetApp ONTAP",
        "searchKeywords": [],
        "type": "AWSService",
        "regions": [
            "us-gov-west-1",
            "us-gov-east-1",
            "af-south-1",
            "ap-east-1",
            "ap-south-1",
            "ap-northeast-3",
            "ap-northeast-2",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-southeast-3",
            "ap-northeast-1",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "eu-south-1",
            "eu-west-3",
            "eu-north-1",
            "me-south-1",
            "me-central-1",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/backup/",
        "isActive": "true",
        "hasDataTransfer": true,
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonFSxNetAppOntapBackup/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/amazonFSxNetAppOntapBackup/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "backupfsxnetappontap",
            "fsxnetappontapbackup"
        ],
        "parentServiceCode": "awsBackup"
    },
    "amazonFSxOpenZfsBackup": {
        "name": "FSx OpenZFS",
        "serviceCode": "amazonFSxOpenZfsBackup",
        "description": "AWS Backup for FSx OpenZFS",
        "searchKeywords": [],
        "type": "AWSService",
        "regions": [
            "us-gov-west-1",
            "us-gov-east-1",
            "af-south-1",
            "ap-east-1",
            "ap-south-1",
            "ap-northeast-3",
            "ap-northeast-2",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-southeast-3",
            "ap-northeast-1",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "eu-south-1",
            "eu-west-3",
            "eu-north-1",
            "me-south-1",
            "me-central-1",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/backup/",
        "isActive": "true",
        "hasDataTransfer": true,
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonFSxOpenZfsBackup/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/amazonFSxOpenZfsBackup/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "backupfsxopenzfs",
            "fsxopenzfsbackup"
        ],
        "parentServiceCode": "awsBackup"
    },
    "amazonFSxWindowsBackup": {
        "name": "FSx Windows",
        "serviceCode": "amazonFSxWindowsBackup",
        "description": "AWS Backup for FSx for Windows",
        "searchKeywords": [],
        "type": "AWSService",
        "regions": [
            "us-gov-west-1",
            "us-gov-east-1",
            "af-south-1",
            "ap-east-1",
            "ap-south-1",
            "ap-northeast-3",
            "ap-northeast-2",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-southeast-3",
            "ap-northeast-1",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "eu-south-1",
            "eu-west-3",
            "eu-north-1",
            "me-south-1",
            "me-central-1",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/backup/",
        "isActive": "true",
        "hasDataTransfer": true,
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonFSxWindowsBackup/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/amazonFSxWindowsBackup/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "fsxwindows",
            "fsxwindowsbackup"
        ],
        "parentServiceCode": "awsBackup"
    },
    "ftp": {
        "name": "FTP",
        "serviceCode": "ftp",
        "searchKeywords": [
            "sftp",
            "FTPS",
            "as2",
            "amazon s3",
            "s3",
            "winscp",
            "filezilla",
            "cyberduck",
            "ssh",
            "transfer",
            "ftp",
            "ftp/s",
            "openssh",
            "file transfer",
            "secure file transfer",
            "ssh ftp",
            "secure shell file transfer protocol",
            "file transfer protocol"
        ],
        "type": "AWSService",
        "regions": [
            "ap-east-1",
            "ap-northeast-1",
            "ap-northeast-2",
            "ap-south-1",
            "ap-southeast-1",
            "ap-southeast-2",
            "ca-central-1",
            "eu-central-1",
            "eu-north-1",
            "eu-west-1",
            "eu-west-2",
            "eu-west-3",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2",
            "us-gov-west-1",
            "us-gov-east-1"
        ],
        "linkUrl": "https://aws.amazon.com/aws-transfer-family/",
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/ftp/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "bulkImportEnabled": false,
        "serviceDefinitionUrlPath": "/data/ftp/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "ftp"
        ],
        "parentServiceCode": "aWSTransferForSFTP"
    },
    "ftps": {
        "name": "FTPS",
        "serviceCode": "ftps",
        "searchKeywords": [
            "sftp",
            "FTPS",
            "as2",
            "amazon s3",
            "s3",
            "winscp",
            "filezilla",
            "cyberduck",
            "ssh",
            "transfer",
            "ftp",
            "ftp/s",
            "openssh",
            "file transfer",
            "secure file transfer",
            "ssh ftp",
            "secure shell file transfer protocol",
            "file transfer protocol"
        ],
        "type": "AWSService",
        "regions": [
            "ap-east-1",
            "ap-northeast-1",
            "ap-northeast-2",
            "ap-south-1",
            "ap-southeast-1",
            "ap-southeast-2",
            "ca-central-1",
            "eu-central-1",
            "eu-north-1",
            "eu-west-1",
            "eu-west-2",
            "eu-west-3",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2",
            "us-gov-west-1",
            "us-gov-east-1"
        ],
        "linkUrl": "https://aws.amazon.com/aws-transfer-family/",
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/ftps/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "bulkImportEnabled": false,
        "serviceDefinitionUrlPath": "/data/ftps/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "ftps"
        ],
        "parentServiceCode": "aWSTransferForSFTP"
    },
    "gatewayLoadBalancer": {
        "name": "Gateway Load Balancer",
        "serviceCode": "gatewayLoadBalancer",
        "description": "Elastic Load Balancing automatically distributes incoming application traffic across multiple targets, such as Amazon EC2 instances, containers, IP addresses, and Lambda functions.",
        "searchKeywords": [
            "ELB",
            "Elastic Load Balancer",
            "Load Balancer",
            "Application Load Balancer",
            "Network Load Balancer",
            "Classic Load Balancer",
            "Gateway Load Balancer"
        ],
        "type": "AWSService",
        "regions": [
            "af-south-1",
            "ap-east-1",
            "ap-northeast-1",
            "ap-northeast-2",
            "ap-northeast-3",
            "ap-south-1",
            "ap-southeast-1",
            "ap-southeast-2",
            "ca-central-1",
            "eu-central-1",
            "eu-north-1",
            "eu-south-1",
            "eu-west-1",
            "eu-west-2",
            "eu-west-3",
            "me-south-1",
            "me-central-1",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2",
            "us-gov-east-1",
            "us-gov-west-1"
        ],
        "linkUrl": "https://aws.amazon.com/elasticloadbalancing/",
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/gatewayLoadBalancer/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/gatewayLoadBalancer/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "gatewayloadbalancer"
        ],
        "parentServiceCode": "elasticLoadBalancing"
    },
    "gatewayLoadBalancerVpc": {
        "name": "Gateway Load Balancer",
        "serviceCode": "gatewayLoadBalancerVpc",
        "description": "Elastic Load Balancing automatically distributes incoming application traffic across multiple targets, such as Amazon EC2 instances, containers, IP addresses, and Lambda functions.",
        "searchKeywords": [
            "ELB",
            "Elastic Load Balancer",
            "Load Balancer",
            "Application Load Balancer",
            "Network Load Balancer",
            "Classic Load Balancer",
            "Gateway Load Balancer"
        ],
        "type": "AWSService",
        "regions": [
            "af-south-1",
            "ap-east-1",
            "ap-northeast-1",
            "ap-northeast-2",
            "ap-northeast-3",
            "ap-south-1",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-southeast-3",
            "ca-central-1",
            "eu-central-1",
            "eu-north-1",
            "eu-south-1",
            "eu-west-1",
            "eu-west-2",
            "eu-west-3",
            "me-south-1",
            "me-central-1",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2",
            "us-gov-east-1",
            "us-gov-west-1"
        ],
        "linkUrl": "https://aws.amazon.com/elasticloadbalancing/",
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/gatewayLoadBalancerVpc/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/gatewayLoadBalancerVpc/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "gatewayloadbalancer",
            "gatewayloadbalancervpc"
        ],
        "parentServiceCode": "amazonVirtualPrivateCloud"
    },
    "locationServiceGeofencing": {
        "name": "Geofencing",
        "serviceCode": "locationServiceGeofencing",
        "description": "Amazon Location Service provides affordable data, tracking and geofencing capabilities, and native integrations with AWS services, so you can create sophisticated location-enabled applications quickly, without the high cost of custom development.",
        "searchKeywords": [
            "Location Service",
            "compromising data security",
            "user privacy",
            "asset tracking",
            "location-based marketing",
            "maps",
            "places",
            "routing",
            "tracking",
            "geofencing",
            "Service Resources"
        ],
        "type": "AWSService",
        "regions": [
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-northeast-1",
            "eu-central-1",
            "eu-west-1",
            "eu-north-1",
            "us-east-1",
            "us-east-2",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/location/",
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/locationServiceGeofencing/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/locationServiceGeofencing/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "geofencing",
            "locationservicegeofencing"
        ],
        "parentServiceCode": "locationService"
    },
    "awsIoTCoreHttp": {
        "name": "HTTP",
        "serviceCode": "awsIoTCoreHttp",
        "description": "AWS IoT Core is a managed cloud service that lets connected devices easily and securely interact with cloud applications and other devices.",
        "searchKeywords": [
            "iot",
            "device",
            "messages",
            "shadow",
            "registry",
            "rules",
            "device shadow",
            "rules engine",
            "basic ingest",
            "mqtt",
            "LoRaWAN"
        ],
        "type": "AWSService",
        "regions": [
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2",
            "ap-east-1",
            "ap-south-1",
            "ap-northeast-2",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-northeast-1",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "eu-west-3",
            "eu-north-1",
            "me-south-1",
            "sa-east-1",
            "us-gov-east-1",
            "us-gov-west-1"
        ],
        "linkUrl": "https://aws.amazon.com/iot-core/",
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/awsIoTCoreHttp/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "bulkImportEnabled": false,
        "serviceDefinitionUrlPath": "/data/awsIoTCoreHttp/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "http",
            "iotcorehttp"
        ],
        "parentServiceCode": "awsIoTCore"
    },
    "awsSystemsManagerIncidentManager": {
        "name": "Incident Manager",
        "serviceCode": "awsSystemsManagerIncidentManager",
        "description": "AWS AppConfig enables you to provide validation logic to ensure your configuration data is syntactically and semantically correct according to your definitions before making it available to your application. AWS AppConfig also gives you the ability to roll out configuration changes over a defined time period while monitoring your application so that you can catch errors and roll back the changes if needed, to help you minimize the impact to the users.",
        "searchKeywords": [
            "Systems Manager",
            "AppConfig",
            "configuration",
            "monitoring"
        ],
        "type": "AWSService",
        "regions": [
            "us-east-1",
            "us-east-2",
            "us-west-2",
            "ap-southeast-1",
            "ap-northeast-1",
            "ap-southeast-2",
            "eu-north-1",
            "eu-west-1",
            "eu-central-1",
            "me-central-1"
        ],
        "linkUrl": "https://aws.amazon.com/systems-manager/",
        "isActive": "true",
        "hasDataTransfer": false,
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/awsSystemsManagerIncidentManager/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/awsSystemsManagerIncidentManager/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "incidentmanager",
            "systemsmanagerincidentmanager"
        ],
        "parentServiceCode": "awsSystemsManager"
    },
    "ipamVpc": {
        "name": "IPAM",
        "serviceCode": "ipamVpc",
        "description": "WS Virtual Private Network solutions establish secure connections between your on-premises networks, remote offices, client devices, and the AWS global network. AWS VPN is comprised of two services: AWS Site-to-Site VPN and AWS Client VPN. Each service provides a highly-available, managed, and elastic cloud VPN solution to protect your network traffic.",
        "searchKeywords": [
            "access control",
            "ACL",
            "AWS Privatelink",
            "Cloud connectivity",
            "corporate network",
            "elastic IP",
            "Gateway load balancer",
            "home network VPN",
            "IPAM",
            "NAT",
            "NAT gateway",
            "Network Access Analyzer",
            "Network Address Translation",
            "Networking Content Delivery",
            "PrivateLink",
            "Reachability Analyzer",
            "security",
            "single tenant hardware",
            "static ip",
            "subnets",
            "Traffic mirroring",
            "Transit Gateway",
            "Virtual Private Cloud",
            "VPN"
        ],
        "type": "AWSService",
        "regions": [
            "af-south-1",
            "ap-east-1",
            "ap-northeast-1",
            "ap-northeast-2",
            "ap-northeast-3",
            "ap-south-1",
            "ap-southeast-1",
            "ap-southeast-2",
            "ca-central-1",
            "eu-central-1",
            "eu-north-1",
            "eu-south-1",
            "eu-west-1",
            "eu-west-2",
            "eu-west-3",
            "me-south-1",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2"
        ],
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/ipamVpc/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/ipamVpc/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "ipam",
            "ipamvpc"
        ],
        "parentServiceCode": "amazonVirtualPrivateCloud"
    },
    "keyPhraseExtraction": {
        "name": "Keyphrase Extraction",
        "serviceCode": "keyPhraseExtraction",
        "description": "With Amazon Comprehend, you only pay for what you use. You are charged based on the amount of text processed on a monthly basis. Amazon Comprehend provides natural language processing, topic modeling, and Custom Classification capabilities, enabling a broad range of applications that can analyze text.",
        "searchKeywords": [
            "Comprehend",
            "NLP",
            "Natural language processing",
            "Sentiment analysis",
            "Text analytics",
            "Entity extraction",
            "Named entity recognition",
            "NER",
            "Key phrase extraction",
            "Topic modeling",
            "Unsupervised clustering",
            "Supervised machine learning",
            "Custom entity recognition",
            "Custom classification",
            "Document classifier",
            "Personally identifiable information",
            "PII",
            "Redaction",
            "Language detection",
            "Free form text analytics"
        ],
        "type": "AWSService",
        "regions": [
            "us-gov-west-1",
            "ap-south-1",
            "ap-northeast-2",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-northeast-1",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "us-east-1",
            "us-east-2",
            "us-west-2"
        ],
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/keyPhraseExtraction/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/keyPhraseExtraction/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "keyphraseextraction"
        ],
        "parentServiceCode": "amazonComprehend"
    },
    "languageDetection": {
        "name": "Language Detection",
        "serviceCode": "languageDetection",
        "description": "With Amazon Comprehend, you only pay for what you use. You are charged based on the amount of text processed on a monthly basis. Amazon Comprehend provides natural language processing, topic modeling, and Custom Classification capabilities, enabling a broad range of applications that can analyze text.",
        "searchKeywords": [
            "Comprehend",
            "NLP",
            "Natural language processing",
            "Sentiment analysis",
            "Text analytics",
            "Entity extraction",
            "Named entity recognition",
            "NER",
            "Key phrase extraction",
            "Topic modeling",
            "Unsupervised clustering",
            "Supervised machine learning",
            "Custom entity recognition",
            "Custom classification",
            "Document classifier",
            "Personally identifiable information",
            "PII",
            "Redaction",
            "Language detection",
            "Free form text analytics"
        ],
        "type": "AWSService",
        "regions": [
            "us-gov-west-1",
            "ap-south-1",
            "ap-northeast-2",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-northeast-1",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "us-east-1",
            "us-east-2",
            "us-west-2"
        ],
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/languageDetection/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/languageDetection/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "languagedetection"
        ],
        "parentServiceCode": "amazonComprehend"
    },
    "lightsailBlockStorage": {
        "name": "Lightsail Block Storage",
        "serviceCode": "lightsailBlockStorage",
        "searchKeywords": [
            "Storage",
            "Simple Storage Service",
            "bucket",
            "file storage",
            "cloud storage",
            "static website hosting",
            "object storage",
            "store objects",
            "store files",
            "data migration",
            "ongoing data ingestion",
            "backup and recovery",
            "big data analytics",
            "nearline archive",
            "disaster recovery",
            "content distribution",
            "cloud storage"
        ],
        "type": "AWSService",
        "regions": [
            "us-east-1",
            "us-east-2",
            "us-west-2",
            "ap-northeast-1",
            "ap-northeast-2",
            "ap-south-1",
            "ap-southeast-1",
            "ap-southeast-2",
            "ca-central-1",
            "eu-central-1",
            "eu-north-1",
            "eu-west-1",
            "eu-west-2",
            "eu-west-3"
        ],
        "linkUrl": "https://aws.amazon.com/lightsail/",
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/lightsailBlockStorage/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/lightsailBlockStorage/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "lightsailblockstorage"
        ],
        "parentServiceCode": "amazonLightsail"
    },
    "lightsailCdn": {
        "name": "Lightsail CDN",
        "serviceCode": "lightsailCdn",
        "searchKeywords": [
            "Storage",
            "Simple Storage Service",
            "bucket",
            "file storage",
            "cloud storage",
            "static website hosting",
            "object storage",
            "store objects",
            "store files",
            "data migration",
            "ongoing data ingestion",
            "backup and recovery",
            "big data analytics",
            "nearline archive",
            "disaster recovery",
            "content distribution",
            "cloud storage"
        ],
        "type": "AWSService",
        "regions": [
            "us-east-1"
        ],
        "linkUrl": "https://aws.amazon.com/lightsail/",
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/lightsailCdn/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/lightsailCdn/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "lightsailcdn"
        ],
        "parentServiceCode": "amazonLightsail"
    },
    "lightsailContainers": {
        "name": "Lightsail Containers",
        "serviceCode": "lightsailContainers",
        "searchKeywords": [
            "Storage",
            "Simple Storage Service",
            "bucket",
            "file storage",
            "cloud storage",
            "static website hosting",
            "object storage",
            "store objects",
            "store files",
            "data migration",
            "ongoing data ingestion",
            "backup and recovery",
            "big data analytics",
            "nearline archive",
            "disaster recovery",
            "content distribution",
            "cloud storage"
        ],
        "type": "AWSService",
        "regions": [
            "us-east-1",
            "us-east-2",
            "us-west-2",
            "ap-northeast-1",
            "ap-northeast-2",
            "ap-south-1",
            "ap-southeast-1",
            "ap-southeast-2",
            "ca-central-1",
            "eu-central-1",
            "eu-north-1",
            "eu-west-1",
            "eu-west-2",
            "eu-west-3"
        ],
        "linkUrl": "https://aws.amazon.com/lightsail/",
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/lightsailContainers/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/lightsailContainers/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "lightsailcontainers"
        ],
        "parentServiceCode": "amazonLightsail"
    },
    "lightsailDataTransfer": {
        "name": "Lightsail Data Transfer",
        "serviceCode": "lightsailDataTransfer",
        "searchKeywords": [
            "Storage",
            "Simple Storage Service",
            "bucket",
            "file storage",
            "cloud storage",
            "static website hosting",
            "object storage",
            "store objects",
            "store files",
            "data migration",
            "ongoing data ingestion",
            "backup and recovery",
            "big data analytics",
            "nearline archive",
            "disaster recovery",
            "content distribution",
            "cloud storage"
        ],
        "type": "AWSService",
        "regions": [
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/lightsail/",
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/lightsailDataTransfer/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "bulkImportEnabled": false,
        "serviceDefinitionUrlPath": "/data/lightsailDataTransfer/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "lightsaildatatransfer"
        ],
        "parentServiceCode": "amazonLightsail"
    },
    "lightsailLoadBalancer": {
        "name": "Lightsail Load Balancer",
        "serviceCode": "lightsailLoadBalancer",
        "searchKeywords": [
            "Storage",
            "Simple Storage Service",
            "bucket",
            "file storage",
            "cloud storage",
            "static website hosting",
            "object storage",
            "store objects",
            "store files",
            "data migration",
            "ongoing data ingestion",
            "backup and recovery",
            "big data analytics",
            "nearline archive",
            "disaster recovery",
            "content distribution",
            "cloud storage"
        ],
        "type": "AWSService",
        "regions": [
            "us-east-1",
            "us-east-2",
            "us-west-2",
            "ap-northeast-1",
            "ap-northeast-2",
            "ap-south-1",
            "ap-southeast-1",
            "ap-southeast-2",
            "ca-central-1",
            "eu-central-1",
            "eu-north-1",
            "eu-west-1",
            "eu-west-2",
            "eu-west-3"
        ],
        "linkUrl": "https://aws.amazon.com/lightsail/",
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/lightsailLoadBalancer/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/lightsailLoadBalancer/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "lightsailloadbalancer"
        ],
        "parentServiceCode": "amazonLightsail"
    },
    "lightsailManagedDatabases": {
        "name": "Lightsail Managed Databases",
        "serviceCode": "lightsailManagedDatabases",
        "searchKeywords": [
            "Storage",
            "Simple Storage Service",
            "bucket",
            "file storage",
            "cloud storage",
            "static website hosting",
            "object storage",
            "store objects",
            "store files",
            "data migration",
            "ongoing data ingestion",
            "backup and recovery",
            "big data analytics",
            "nearline archive",
            "disaster recovery",
            "content distribution",
            "cloud storage"
        ],
        "type": "AWSService",
        "regions": [
            "us-east-1",
            "us-east-2",
            "us-west-2",
            "ap-northeast-1",
            "ap-northeast-2",
            "ap-south-1",
            "ap-southeast-1",
            "ap-southeast-2",
            "ca-central-1",
            "eu-central-1",
            "eu-north-1",
            "eu-west-1",
            "eu-west-2",
            "eu-west-3"
        ],
        "linkUrl": "https://aws.amazon.com/lightsail/",
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/lightsailManagedDatabases/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/lightsailManagedDatabases/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "lightsailmanageddatabases"
        ],
        "parentServiceCode": "amazonLightsail"
    },
    "lightsailObjectStorage": {
        "name": "Lightsail Object Storage",
        "serviceCode": "lightsailObjectStorage",
        "searchKeywords": [
            "Storage",
            "Simple Storage Service",
            "bucket",
            "file storage",
            "cloud storage",
            "static website hosting",
            "object storage",
            "store objects",
            "store files",
            "data migration",
            "ongoing data ingestion",
            "backup and recovery",
            "big data analytics",
            "nearline archive",
            "disaster recovery",
            "content distribution",
            "cloud storage"
        ],
        "type": "AWSService",
        "regions": [
            "ap-south-1",
            "ap-northeast-2",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-northeast-1",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "eu-west-3",
            "eu-north-1",
            "us-east-2",
            "us-east-1",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/lightsail/",
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/lightsailObjectStorage/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/lightsailObjectStorage/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "lightsailobjectstorage"
        ],
        "parentServiceCode": "amazonLightsail"
    },
    "lightsailVirtualServers": {
        "name": "Lightsail Virtual Servers",
        "serviceCode": "lightsailVirtualServers",
        "searchKeywords": [
            "Storage",
            "Simple Storage Service",
            "bucket",
            "file storage",
            "cloud storage",
            "static website hosting",
            "object storage",
            "store objects",
            "store files",
            "data migration",
            "ongoing data ingestion",
            "backup and recovery",
            "big data analytics",
            "nearline archive",
            "disaster recovery",
            "content distribution",
            "cloud storage"
        ],
        "type": "AWSService",
        "regions": [
            "us-east-1",
            "us-east-2",
            "us-west-2",
            "ap-northeast-1",
            "ap-northeast-2",
            "ap-south-1",
            "ap-southeast-1",
            "ap-southeast-2",
            "ca-central-1",
            "eu-central-1",
            "eu-north-1",
            "eu-west-1",
            "eu-west-2",
            "eu-west-3"
        ],
        "linkUrl": "https://aws.amazon.com/lightsail/",
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/lightsailVirtualServers/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/lightsailVirtualServers/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "lightsailvirtualservers"
        ],
        "parentServiceCode": "amazonLightsail"
    },
    "awsIoTCoreLoRaWan": {
        "name": "LoRaWAN",
        "serviceCode": "awsIoTCoreLoRaWan",
        "description": "AWS IoT Core is a managed cloud service that lets connected devices easily and securely interact with cloud applications and other devices.",
        "searchKeywords": [
            "iot",
            "device",
            "messages",
            "shadow",
            "registry",
            "rules",
            "device shadow",
            "rules engine",
            "basic ingest",
            "mqtt",
            "LoRaWAN"
        ],
        "type": "AWSService",
        "regions": [
            "us-east-1",
            "eu-west-1"
        ],
        "linkUrl": "https://aws.amazon.com/iot-core/",
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/awsIoTCoreLoRaWan/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "bulkImportEnabled": false,
        "serviceDefinitionUrlPath": "/data/awsIoTCoreLoRaWan/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "iotcorelorawan",
            "lorawan"
        ],
        "parentServiceCode": "awsIoTCore"
    },
    "locationServiceMaps": {
        "name": "Maps",
        "serviceCode": "locationServiceMaps",
        "description": "Amazon Location Service provides affordable data, tracking and geofencing capabilities, and native integrations with AWS services, so you can create sophisticated location-enabled applications quickly, without the high cost of custom development.",
        "searchKeywords": [
            "Location Service",
            "compromising data security",
            "user privacy",
            "asset tracking",
            "location-based marketing",
            "maps",
            "places",
            "routing",
            "tracking",
            "geofencing",
            "Service Resources"
        ],
        "type": "AWSService",
        "regions": [
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-northeast-1",
            "eu-central-1",
            "eu-west-1",
            "eu-north-1",
            "us-east-1",
            "us-east-2",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/location/",
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/locationServiceMaps/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/locationServiceMaps/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "locationservicemaps",
            "maps"
        ],
        "parentServiceCode": "locationService"
    },
    "mediaLiveAudioAddOns": {
        "name": "MediaLive Add Ons",
        "serviceCode": "mediaLiveAudioAddOns",
        "description": "Elemental Media Live Audio Add Ons",
        "searchKeywords": [
            "streaming",
            "media",
            "elemental media live"
        ],
        "type": "AWSService",
        "regions": [
            "us-east-1",
            "eu-west-2",
            "eu-central-1",
            "ap-southeast-1",
            "sa-east-1",
            "us-east-2",
            "ap-northeast-2",
            "eu-north-1",
            "ap-northeast-1",
            "ap-south-1",
            "eu-west-1",
            "us-west-2",
            "ap-southeast-2",
            "eu-west-3"
        ],
        "linkUrl": "https://aws.amazon.com/medialive/",
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/mediaLiveAudioAddOns/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "bulkImportEnabled": false,
        "serviceDefinitionUrlPath": "/data/mediaLiveAudioAddOns/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "medialiveaddons",
            "medialiveaudioaddons"
        ],
        "parentServiceCode": "awsElementalMediaLive"
    },
    "mediaLiveInput1": {
        "name": "MediaLive Inputs",
        "serviceCode": "mediaLiveInput1",
        "description": "EML input 1",
        "searchKeywords": [
            "streaming",
            "media",
            "elemental media live"
        ],
        "type": "AWSService",
        "regions": [
            "us-east-1",
            "eu-west-2",
            "eu-central-1",
            "ap-southeast-1",
            "sa-east-1",
            "us-east-2",
            "ap-northeast-2",
            "eu-north-1",
            "ap-northeast-1",
            "ap-south-1",
            "eu-west-1",
            "us-west-2",
            "ap-southeast-2",
            "eu-west-3"
        ],
        "linkUrl": "https://aws.amazon.com/medialive/",
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/mediaLiveInput1/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/mediaLiveInput1/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "medialiveinput1",
            "medialiveinputs"
        ],
        "parentServiceCode": "awsElementalMediaLive"
    },
    "mediaLiveOutput1": {
        "name": "MediaLive Outputs",
        "serviceCode": "mediaLiveOutput1",
        "description": "EML Output 1",
        "searchKeywords": [
            "streaming",
            "media",
            "elemental media live"
        ],
        "type": "AWSService",
        "regions": [
            "us-east-1",
            "eu-west-2",
            "eu-central-1",
            "ap-southeast-1",
            "sa-east-1",
            "us-east-2",
            "ap-northeast-2",
            "eu-north-1",
            "ap-northeast-1",
            "ap-south-1",
            "eu-west-1",
            "us-west-2",
            "ap-southeast-2",
            "eu-west-3"
        ],
        "linkUrl": "https://aws.amazon.com/medialive/",
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/mediaLiveOutput1/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/mediaLiveOutput1/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "medialiveoutput1",
            "medialiveoutputs"
        ],
        "parentServiceCode": "awsElementalMediaLive"
    },
    "medicalIcd10CmOntologyLinkingApi": {
        "name": "Medical ICD-10-CM Ontology Linking API",
        "serviceCode": "medicalIcd10CmOntologyLinkingApi",
        "description": "",
        "searchKeywords": [
            "Comprehend",
            "NLP",
            "Natural language processing",
            "Sentiment analysis",
            "Text analytics",
            "Entity extraction",
            "Named entity recognition",
            "NER",
            "Key phrase extraction",
            "Topic modeling",
            "Unsupervised clustering",
            "Supervised machine learning",
            "Custom entity recognition",
            "Custom classification",
            "Document classifier",
            "Personally identifiable information",
            "PII",
            "Redaction",
            "Language detection",
            "Free form text analytics"
        ],
        "type": "AWSService",
        "regions": [
            "ap-southeast-2",
            "ca-central-1",
            "eu-west-1",
            "eu-west-2",
            "us-east-1",
            "us-gov-west-1",
            "us-east-2",
            "us-west-2"
        ],
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/medicalIcd10CmOntologyLinkingApi/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/medicalIcd10CmOntologyLinkingApi/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "medicalicd10cmontologylinkingapi"
        ],
        "parentServiceCode": "amazonComprehendMedical"
    },
    "medicalNamedEntityAndRelationshipExtractionNeReApi": {
        "name": "Medical Named Entity and Relationship Extraction (NERe) API",
        "serviceCode": "medicalNamedEntityAndRelationshipExtractionNeReApi",
        "description": "",
        "searchKeywords": [
            "Comprehend",
            "NLP",
            "Natural language processing",
            "Sentiment analysis",
            "Text analytics",
            "Entity extraction",
            "Named entity recognition",
            "NER",
            "Key phrase extraction",
            "Topic modeling",
            "Unsupervised clustering",
            "Supervised machine learning",
            "Custom entity recognition",
            "Custom classification",
            "Document classifier",
            "Personally identifiable information",
            "PII",
            "Redaction",
            "Language detection",
            "Free form text analytics"
        ],
        "type": "AWSService",
        "regions": [
            "ap-southeast-2",
            "ca-central-1",
            "eu-west-1",
            "eu-west-2",
            "us-east-1",
            "us-east-2",
            "us-gov-west-1",
            "us-west-2"
        ],
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/medicalNamedEntityAndRelationshipExtractionNeReApi/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/medicalNamedEntityAndRelationshipExtractionNeReApi/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "medicalnamedentityandrelationshipextractionnereapi",
            "medicalnamedentityrelationshipextractionnereapi",
            "nere"
        ],
        "parentServiceCode": "amazonComprehendMedical"
    },
    "medicalProtectedHealthInformationDataExtractionAndIdentificationPhIdApi": {
        "name": "Medical Protected Health Information Data Extraction and Identification (PHId) API",
        "serviceCode": "medicalProtectedHealthInformationDataExtractionAndIdentificationPhIdApi",
        "description": "",
        "searchKeywords": [
            "Comprehend",
            "NLP",
            "Natural language processing",
            "Sentiment analysis",
            "Text analytics",
            "Entity extraction",
            "Named entity recognition",
            "NER",
            "Key phrase extraction",
            "Topic modeling",
            "Unsupervised clustering",
            "Supervised machine learning",
            "Custom entity recognition",
            "Custom classification",
            "Document classifier",
            "Personally identifiable information",
            "PII",
            "Redaction",
            "Language detection",
            "Free form text analytics"
        ],
        "type": "AWSService",
        "regions": [
            "ap-southeast-2",
            "ca-central-1",
            "eu-west-1",
            "eu-west-2",
            "us-east-1",
            "us-gov-west-1",
            "us-east-2",
            "us-west-2"
        ],
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/medicalProtectedHealthInformationDataExtractionAndIdentificationPhIdApi/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/medicalProtectedHealthInformationDataExtractionAndIdentificationPhIdApi/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "medicalprotectedhealthinformationdataextractionandidentificationphidapi",
            "medicalprotectedhealthinformationdataextractionidentificationphidapi",
            "phid"
        ],
        "parentServiceCode": "amazonComprehendMedical"
    },
    "medicalRxNormOntologyLinkingApi": {
        "name": "Medical RxNORM Ontology Linking API",
        "serviceCode": "medicalRxNormOntologyLinkingApi",
        "description": "",
        "searchKeywords": [
            "Comprehend",
            "NLP",
            "Natural language processing",
            "Sentiment analysis",
            "Text analytics",
            "Entity extraction",
            "Named entity recognition",
            "NER",
            "Key phrase extraction",
            "Topic modeling",
            "Unsupervised clustering",
            "Supervised machine learning",
            "Custom entity recognition",
            "Custom classification",
            "Document classifier",
            "Personally identifiable information",
            "PII",
            "Redaction",
            "Language detection",
            "Free form text analytics"
        ],
        "type": "AWSService",
        "regions": [
            "ap-southeast-2",
            "ca-central-1",
            "eu-west-1",
            "eu-west-2",
            "us-east-1",
            "us-gov-west-1",
            "us-east-2",
            "us-west-2"
        ],
        "isActive": "true",
        "subType": "subService",
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/medicalRxNormOntologyLinkingApi/en_US.json",
        "c2e": false,
        "mvpSupport": false,
        "comparableTerms": [
            "medicalrxnormontologylinkingapi"
        ],
        "parentServiceCode": "amazonComprehendMedical"
    },
    "medicalSystematizedNomenclatureOfMedicineClinicalTermsSnomedCtApi": {
        "name": "Medical Systematized Nomenclature of Medicine Clinical Terms (SNOMED CT) API",
        "serviceCode": "medicalSystematizedNomenclatureOfMedicineClinicalTermsSnomedCtApi",
        "description": "",
        "searchKeywords": [
            "Comprehend",
            "NLP",
            "Natural language processing",
            "Sentiment analysis",
            "Text analytics",
            "Entity extraction",
            "Named entity recognition",
            "NER",
            "Key phrase extraction",
            "Topic modeling",
            "Unsupervised clustering",
            "Supervised machine learning",
            "Custom entity recognition",
            "Custom classification",
            "Document classifier",
            "Personally identifiable information",
            "PII",
            "Redaction",
            "Language detection",
            "Free form text analytics"
        ],
        "type": "AWSService",
        "regions": [
            "ap-southeast-2",
            "ca-central-1",
            "eu-west-1",
            "eu-west-2",
            "us-east-1",
            "us-east-2",
            "us-gov-west-1",
            "us-west-2"
        ],
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/medicalSystematizedNomenclatureOfMedicineClinicalTermsSnomedCtApi/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/medicalSystematizedNomenclatureOfMedicineClinicalTermsSnomedCtApi/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "medicalsystematizednomenclaturemedicineclinicaltermssnomedctapi",
            "medicalsystematizednomenclatureofmedicineclinicaltermssnomedctapi",
            "snomedct"
        ],
        "parentServiceCode": "amazonComprehendMedical"
    },
    "chimeSdkMessaging": {
        "name": "Messaging",
        "serviceCode": "chimeSdkMessaging",
        "description": "TBD",
        "searchKeywords": [],
        "type": "AWSService",
        "regions": [
            "eu-central-1",
            "us-east-1"
        ],
        "linkUrl": "https://aws.amazon.com/chime/chime-sdk",
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/chimeSdkMessaging/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/chimeSdkMessaging/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "chimesdkmessaging",
            "messaging"
        ],
        "parentServiceCode": "amazonChimeSdk"
    },
    "mainframeMicroFocus": {
        "name": "Micro Focus replatforming",
        "serviceCode": "mainframeMicroFocus",
        "description": "For AWS M2 Blu Age managed runtime, you can choose on-demand instances and pay for the runtime by the hour with no long-term commitments or upfront fees, or choose committed plans for additional savings.",
        "searchKeywords": [],
        "type": "AWSService",
        "regions": [
            "ap-southeast-2",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "sa-east-1",
            "us-east-1",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/mainframe-modernization/pricing/",
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/mainframeMicroFocus/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/mainframeMicroFocus/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "mainframemicrofocus",
            "microfocusreplatforming"
        ],
        "parentServiceCode": "amazonMainframeModernization"
    },
    "awsIoTCoreMqtt": {
        "name": "MQTT",
        "serviceCode": "awsIoTCoreMqtt",
        "description": "AWS IoT Core is a managed cloud service that lets connected devices easily and securely interact with cloud applications and other devices.",
        "searchKeywords": [
            "iot",
            "device",
            "messages",
            "shadow",
            "registry",
            "rules",
            "device shadow",
            "rules engine",
            "basic ingest",
            "mqtt",
            "LoRaWAN"
        ],
        "type": "AWSService",
        "regions": [
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2",
            "ap-east-1",
            "ap-south-1",
            "ap-northeast-2",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-northeast-1",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "eu-west-3",
            "eu-north-1",
            "me-south-1",
            "sa-east-1",
            "us-gov-east-1",
            "us-gov-west-1"
        ],
        "linkUrl": "https://aws.amazon.com/iot-core/",
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/awsIoTCoreMqtt/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "bulkImportEnabled": false,
        "serviceDefinitionUrlPath": "/data/awsIoTCoreMqtt/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "iotcoremqtt",
            "mqtt"
        ],
        "parentServiceCode": "awsIoTCore"
    },
    "amazonNeptuneBackup": {
        "name": "Neptune",
        "serviceCode": "amazonNeptuneBackup",
        "description": "AWS Backup for Neptune",
        "searchKeywords": [],
        "type": "AWSService",
        "regions": [
            "us-gov-west-1",
            "us-gov-east-1",
            "af-south-1",
            "ap-east-1",
            "ap-south-1",
            "ap-northeast-3",
            "ap-northeast-2",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-southeast-3",
            "ap-northeast-1",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "eu-south-1",
            "eu-west-3",
            "eu-north-1",
            "me-south-1",
            "me-central-1",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/backup/",
        "isActive": "true",
        "hasDataTransfer": true,
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonNeptuneBackup/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/amazonNeptuneBackup/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "backupneptune",
            "neptunebackup"
        ],
        "parentServiceCode": "awsBackup"
    },
    "networkAccessAnalyzerVpc": {
        "name": "Network Access Analyzer",
        "serviceCode": "networkAccessAnalyzerVpc",
        "description": "WS Virtual Private Network solutions establish secure connections between your on-premises networks, remote offices, client devices, and the AWS global network. AWS VPN is comprised of two services: AWS Site-to-Site VPN and AWS Client VPN. Each service provides a highly-available, managed, and elastic cloud VPN solution to protect your network traffic.",
        "searchKeywords": [
            "access control",
            "ACL",
            "AWS Privatelink",
            "Cloud connectivity",
            "corporate network",
            "elastic IP",
            "Gateway load balancer",
            "home network VPN",
            "IPAM",
            "NAT",
            "NAT gateway",
            "Network Access Analyzer",
            "Network Address Translation",
            "Networking Content Delivery",
            "PrivateLink",
            "Reachability Analyzer",
            "security",
            "single tenant hardware",
            "static ip",
            "subnets",
            "Traffic mirroring",
            "Transit Gateway",
            "Virtual Private Cloud",
            "VPN"
        ],
        "type": "AWSService",
        "regions": [
            "af-south-1",
            "ap-east-1",
            "ap-northeast-1",
            "ap-northeast-2",
            "ap-south-1",
            "ap-southeast-1",
            "ap-southeast-2",
            "ca-central-1",
            "eu-central-1",
            "eu-north-1",
            "eu-south-1",
            "eu-west-1",
            "eu-west-2",
            "eu-west-3",
            "me-south-1",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2"
        ],
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/networkAccessAnalyzerVpc/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/networkAccessAnalyzerVpc/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "networkaccessanalyzer",
            "networkaccessanalyzervpc"
        ],
        "parentServiceCode": "amazonVirtualPrivateCloud"
    },
    "networkAddressTranslationNatGatewayVpc": {
        "name": "Network Address Translation (NAT) Gateway",
        "serviceCode": "networkAddressTranslationNatGatewayVpc",
        "description": "WS Virtual Private Network solutions establish secure connections between your on-premises networks, remote offices, client devices, and the AWS global network. AWS VPN is comprised of two services: AWS Site-to-Site VPN and AWS Client VPN. Each service provides a highly-available, managed, and elastic cloud VPN solution to protect your network traffic.",
        "searchKeywords": [
            "access control",
            "ACL",
            "AWS Privatelink",
            "Cloud connectivity",
            "corporate network",
            "elastic IP",
            "Gateway load balancer",
            "home network VPN",
            "IPAM",
            "NAT",
            "NAT gateway",
            "Network Access Analyzer",
            "Network Address Translation",
            "Networking Content Delivery",
            "PrivateLink",
            "Reachability Analyzer",
            "security",
            "single tenant hardware",
            "static ip",
            "subnets",
            "Traffic mirroring",
            "Transit Gateway",
            "Virtual Private Cloud",
            "VPN"
        ],
        "type": "AWSService",
        "regions": [
            "af-south-1",
            "ap-east-1",
            "ap-northeast-1",
            "ap-northeast-2",
            "ap-northeast-3",
            "ap-south-1",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-southeast-3",
            "ca-central-1",
            "eu-central-1",
            "eu-north-1",
            "eu-south-1",
            "eu-west-1",
            "eu-west-2",
            "eu-west-3",
            "me-south-1",
            "me-central-1",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2",
            "us-gov-east-1",
            "us-gov-west-1"
        ],
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/networkAddressTranslationNatGatewayVpc/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/networkAddressTranslationNatGatewayVpc/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "nat",
            "networkaddresstranslationnatgateway",
            "networkaddresstranslationnatgatewayvpc"
        ],
        "parentServiceCode": "amazonVirtualPrivateCloud"
    },
    "networkLoadBalancer": {
        "name": "Network Load Balancer",
        "serviceCode": "networkLoadBalancer",
        "description": "Elastic Load Balancing automatically distributes incoming application traffic across multiple targets, such as Amazon EC2 instances, containers, IP addresses, and Lambda functions.",
        "searchKeywords": [
            "ELB",
            "Elastic Load Balancer",
            "Load Balancer",
            "Application Load Balancer",
            "Network Load Balancer",
            "Classic Load Balancer"
        ],
        "type": "AWSService",
        "regions": [
            "af-south-1",
            "ap-east-1",
            "ap-northeast-1",
            "ap-northeast-2",
            "ap-northeast-3",
            "ap-south-1",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-southeast-3",
            "ca-central-1",
            "eu-central-1",
            "eu-north-1",
            "eu-south-1",
            "eu-west-1",
            "eu-west-2",
            "eu-west-3",
            "me-south-1",
            "me-central-1",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-gov-east-1",
            "us-gov-west-1",
            "us-west-1",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/elasticloadbalancing/",
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/networkLoadBalancer/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/networkLoadBalancer/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "networkloadbalancer"
        ],
        "parentServiceCode": "elasticLoadBalancing"
    },
    "neuralTextToSpeech": {
        "name": "Neural Text-to-Speech",
        "serviceCode": "neuralTextToSpeech",
        "description": "Amazon Polly is a service that turns text into lifelike speech, allowing you to create applications that talk, and build entirely new categories of speech-enabled products.",
        "searchKeywords": [
            "polly",
            "NLP",
            "speech",
            "Neural Text-to-Speech"
        ],
        "type": "AWSService",
        "regions": [
            "us-gov-west-1",
            "ap-northeast-2",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-northeast-1",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "us-east-1",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/polly/",
        "isActive": "true",
        "subType": "subService",
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/neuralTextToSpeech/en_US.json",
        "c2e": false,
        "comparableTerms": [
            "neuraltexttospeech"
        ],
        "parentServiceCode": "amazonPolly"
    },
    "awsSystemsManagerOnPremisesInstanceManagement": {
        "name": "On-Premises Instance Management",
        "serviceCode": "awsSystemsManagerOnPremisesInstanceManagement",
        "description": "AWS Systems Manager On-Premises Instance Management feature",
        "searchKeywords": [
            "Systems Manager",
            "On-Premises Instance Management",
            "On-Prem",
            "Session Manager"
        ],
        "type": "AWSService",
        "regions": [
            "us-gov-west-1",
            "us-gov-east-1",
            "af-south-1",
            "ap-east-1",
            "ap-south-1",
            "ap-northeast-2",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-southeast-3",
            "ap-northeast-1",
            "ap-northeast-3",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "eu-south-1",
            "eu-west-3",
            "eu-north-1",
            "me-south-1",
            "me-central-1",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/systems-manager/",
        "isActive": "true",
        "hasDataTransfer": false,
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/awsSystemsManagerOnPremisesInstanceManagement/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/awsSystemsManagerOnPremisesInstanceManagement/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "onpremisesinstancemanagement",
            "systemsmanageronpremisesinstancemanagement"
        ],
        "parentServiceCode": "awsSystemsManager"
    },
    "awsSystemsManagerOpsCenter": {
        "name": "OpsCenter",
        "serviceCode": "awsSystemsManagerOpsCenter",
        "description": "AWS Systems Manager OpsCenter feature",
        "searchKeywords": [
            "System Manager",
            "OpsCenter",
            "operational issues",
            "OpsItems"
        ],
        "type": "AWSService",
        "regions": [
            "ap-east-1",
            "ap-south-1",
            "ap-northeast-2",
            "ap-northeast-3",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-southeast-3",
            "ap-northeast-1",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "eu-west-3",
            "eu-north-1",
            "me-south-1",
            "me-central-1",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2",
            "us-gov-west-1",
            "us-gov-east-1",
            "eu-south-1",
            "af-south-1"
        ],
        "linkUrl": "https://aws.amazon.com/systems-manager/",
        "isActive": "true",
        "hasDataTransfer": false,
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/awsSystemsManagerOpsCenter/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/awsSystemsManagerOpsCenter/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "opscenter",
            "systemsmanageropscenter"
        ],
        "parentServiceCode": "awsSystemsManager"
    },
    "awsSystemsManagerParameterStore": {
        "name": "Parameter Store",
        "serviceCode": "awsSystemsManagerParameterStore",
        "description": "AWS Systems Manager Parameter Store feature",
        "searchKeywords": [
            "System Manager",
            "Parameter Store",
            "API",
            "parameter"
        ],
        "type": "AWSService",
        "regions": [
            "us-gov-west-1",
            "us-gov-east-1",
            "af-south-1",
            "ap-east-1",
            "ap-south-1",
            "ap-northeast-3",
            "ap-northeast-2",
            "ap-southeast-2",
            "ap-southeast-3",
            "ap-northeast-1",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "eu-south-1",
            "eu-west-3",
            "eu-north-1",
            "me-south-1",
            "me-central-1",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/systems-manager/",
        "isActive": "true",
        "hasDataTransfer": false,
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/awsSystemsManagerParameterStore/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/awsSystemsManagerParameterStore/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "parameterstore",
            "systemsmanagerparameterstore"
        ],
        "parentServiceCode": "awsSystemsManager"
    },
    "locationServicePlaces": {
        "name": "Places",
        "serviceCode": "locationServicePlaces",
        "description": "Amazon Location Service provides affordable data, tracking and geofencing capabilities, and native integrations with AWS services, so you can create sophisticated location-enabled applications quickly, without the high cost of custom development.",
        "searchKeywords": [
            "Location Service",
            "compromising data security",
            "user privacy",
            "asset tracking",
            "location-based marketing",
            "maps",
            "places",
            "routing",
            "tracking",
            "geofencing",
            "Service Resources"
        ],
        "type": "AWSService",
        "regions": [
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-northeast-1",
            "eu-central-1",
            "eu-west-1",
            "eu-north-1",
            "us-east-1",
            "us-east-2",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/location/",
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/locationServicePlaces/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/locationServicePlaces/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "locationserviceplaces",
            "places"
        ],
        "parentServiceCode": "locationService"
    },
    "proServeYear1Cost": {
        "name": "ProServe Year 1 Price",
        "serviceCode": "proServeYear1Cost",
        "description": "AWS Professional Services Year 1 Price",
        "searchKeywords": [
            "ProServe",
            "professional",
            "services"
        ],
        "type": "AWSService",
        "regions": [
            "us-east-1",
            "us-gov-west-1"
        ],
        "linkUrl": "https://aws.amazon.com/professional-services/",
        "isActive": "true",
        "hasDataTransfer": false,
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/proServeYear1Cost/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": true,
        "bulkImportEnabled": false,
        "serviceDefinitionUrlPath": "/data/proServeYear1Cost/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "proserveyear1cost",
            "proserveyear1price"
        ],
        "parentServiceCode": "awsProfessionalServices"
    },
    "proServeYear2Cost": {
        "name": "ProServe Year 2 Price",
        "serviceCode": "proServeYear2Cost",
        "description": "AWS Professional Services Year 2 Price",
        "searchKeywords": [
            "ProServe",
            "professional",
            "services"
        ],
        "type": "AWSService",
        "regions": [
            "us-east-1",
            "us-gov-west-1"
        ],
        "linkUrl": "https://aws.amazon.com/professional-services/",
        "isActive": "true",
        "hasDataTransfer": false,
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/proServeYear2Cost/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": true,
        "bulkImportEnabled": false,
        "serviceDefinitionUrlPath": "/data/proServeYear2Cost/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "proserveyear2cost",
            "proserveyear2price"
        ],
        "parentServiceCode": "awsProfessionalServices"
    },
    "proServeYear3Cost": {
        "name": "ProServe Year 3 Price",
        "serviceCode": "proServeYear3Cost",
        "description": "AWS Professional Services Year 3 Price",
        "searchKeywords": [
            "ProServe",
            "professional",
            "services"
        ],
        "type": "AWSService",
        "regions": [
            "us-east-1",
            "us-gov-west-1"
        ],
        "linkUrl": "https://aws.amazon.com/professional-services/",
        "isActive": "true",
        "hasDataTransfer": false,
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/proServeYear3Cost/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": true,
        "bulkImportEnabled": false,
        "serviceDefinitionUrlPath": "/data/proServeYear3Cost/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "proserveyear3cost",
            "proserveyear3price"
        ],
        "parentServiceCode": "awsProfessionalServices"
    },
    "proServeYear4Cost": {
        "name": "ProServe Year 4 Price",
        "serviceCode": "proServeYear4Cost",
        "description": "AWS Professional Services Year 4 Price",
        "searchKeywords": [
            "ProServe",
            "professional",
            "services"
        ],
        "type": "AWSService",
        "regions": [
            "us-east-1",
            "us-gov-west-1"
        ],
        "linkUrl": "https://aws.amazon.com/professional-services/",
        "isActive": "true",
        "hasDataTransfer": false,
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/proServeYear4Cost/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": true,
        "bulkImportEnabled": false,
        "serviceDefinitionUrlPath": "/data/proServeYear4Cost/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "proserveyear4cost",
            "proserveyear4price"
        ],
        "parentServiceCode": "awsProfessionalServices"
    },
    "proServeYear5Cost": {
        "name": "ProServe Year 5 Price",
        "serviceCode": "proServeYear5Cost",
        "description": "AWS Professional Services Year 5 Price",
        "searchKeywords": [
            "ProServe",
            "professional",
            "services"
        ],
        "type": "AWSService",
        "regions": [
            "us-east-1",
            "us-gov-west-1"
        ],
        "linkUrl": "https://aws.amazon.com/professional-services/",
        "isActive": "true",
        "hasDataTransfer": false,
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/proServeYear5Cost/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": true,
        "bulkImportEnabled": false,
        "serviceDefinitionUrlPath": "/data/proServeYear5Cost/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "proserveyear5cost",
            "proserveyear5price"
        ],
        "parentServiceCode": "awsProfessionalServices"
    },
    "proxyPhoneSession": {
        "name": "Proxy Phone Session",
        "serviceCode": "proxyPhoneSession",
        "description": "Amazon Chime lets you meet, chat, and collaborate with the security of AWS. You can work seamlessly on your devices, and meet from your desk or on the go - ensuring you always stay connected.",
        "searchKeywords": [],
        "type": "AWSService",
        "regions": [
            "us-east-1",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/chime/chime-sdk",
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/proxyPhoneSession/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/proxyPhoneSession/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "proxyphonesession"
        ],
        "parentServiceCode": "amazonChimeSdk"
    },
    "ptsnAudio": {
        "name": "PSTN Audio",
        "serviceCode": "ptsnAudio",
        "description": "Amazon Chime lets you meet, chat, and collaborate with the security of AWS. You can work seamlessly on your devices, and meet from your desk or on the go - ensuring you always stay connected.",
        "searchKeywords": [],
        "type": "AWSService",
        "regions": [
            "us-east-1",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/chime/chime-sdk",
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/ptsnAudio/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "bulkImportEnabled": false,
        "serviceDefinitionUrlPath": "/data/ptsnAudio/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "pstnaudio",
            "ptsnaudio"
        ],
        "parentServiceCode": "amazonChimeSdk"
    },
    "amazonRdsBackup": {
        "name": "RDS",
        "serviceCode": "amazonRdsBackup",
        "description": "AWS Backup for RDS",
        "searchKeywords": [],
        "type": "AWSService",
        "regions": [
            "us-gov-west-1",
            "us-gov-east-1",
            "af-south-1",
            "ap-east-1",
            "ap-south-1",
            "ap-northeast-3",
            "ap-northeast-2",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-southeast-3",
            "ap-northeast-1",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "eu-south-1",
            "eu-west-3",
            "eu-north-1",
            "me-south-1",
            "me-central-1",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/backup/",
        "isActive": "true",
        "hasDataTransfer": true,
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonRdsBackup/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/amazonRdsBackup/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "backuprds",
            "rdsbackup"
        ],
        "parentServiceCode": "awsBackup"
    },
    "reachabilityAnalyzerVpc": {
        "name": "Reachability Analyzer",
        "serviceCode": "reachabilityAnalyzerVpc",
        "description": "WS Virtual Private Network solutions establish secure connections between your on-premises networks, remote offices, client devices, and the AWS global network. AWS VPN is comprised of two services: AWS Site-to-Site VPN and AWS Client VPN. Each service provides a highly-available, managed, and elastic cloud VPN solution to protect your network traffic.",
        "searchKeywords": [
            "access control",
            "ACL",
            "AWS Privatelink",
            "Cloud connectivity",
            "corporate network",
            "elastic IP",
            "Gateway load balancer",
            "home network VPN",
            "IPAM",
            "NAT",
            "NAT gateway",
            "Network Access Analyzer",
            "Network Address Translation",
            "Networking Content Delivery",
            "PrivateLink",
            "Reachability Analyzer",
            "security",
            "single tenant hardware",
            "static ip",
            "subnets",
            "Traffic mirroring",
            "Transit Gateway",
            "Virtual Private Cloud",
            "VPN"
        ],
        "type": "AWSService",
        "regions": [
            "af-south-1",
            "ap-east-1",
            "ap-northeast-1",
            "ap-northeast-2",
            "ap-south-1",
            "ap-southeast-1",
            "ap-southeast-2",
            "ca-central-1",
            "eu-central-1",
            "eu-north-1",
            "eu-south-1",
            "eu-west-1",
            "eu-west-2",
            "eu-west-3",
            "me-south-1",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2"
        ],
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/reachabilityAnalyzerVpc/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/reachabilityAnalyzerVpc/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "reachabilityanalyzer",
            "reachabilityanalyzervpc"
        ],
        "parentServiceCode": "amazonVirtualPrivateCloud"
    },
    "rekognitionCustomLabels": {
        "name": "Rekognition Custom Labels",
        "serviceCode": "rekognitionCustomLabels",
        "searchKeywords": [],
        "type": "AWSService",
        "regions": [
            "ap-northeast-2",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-northeast-1",
            "eu-west-1",
            "us-east-1",
            "us-east-2",
            "us-west-2"
        ],
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/rekognitionCustomLabels/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/rekognitionCustomLabels/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "rekognitioncustomlabels"
        ],
        "parentServiceCode": "amazonRekognition"
    },
    "rekognitionImage": {
        "name": "Rekognition Image",
        "serviceCode": "rekognitionImage",
        "searchKeywords": [],
        "type": "AWSService",
        "regions": [
            "us-gov-west-1",
            "ap-south-1",
            "ap-northeast-2",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-northeast-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2"
        ],
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/rekognitionImage/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "bulkImportEnabled": false,
        "serviceDefinitionUrlPath": "/data/rekognitionImage/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "rekognitionimage"
        ],
        "parentServiceCode": "amazonRekognition"
    },
    "rekognitionVideo": {
        "name": "Rekognition Stored Video",
        "serviceCode": "rekognitionVideo",
        "searchKeywords": [],
        "type": "AWSService",
        "regions": [
            "us-gov-west-1",
            "ap-south-1",
            "ap-northeast-2",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-northeast-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2"
        ],
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/rekognitionVideo/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/rekognitionVideo/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "rekognitionstoredvideo",
            "rekognitionvideo"
        ],
        "parentServiceCode": "amazonRekognition"
    },
    "rekognitionStreamingVideoEvents": {
        "name": "Rekognition Streaming Video Events",
        "serviceCode": "rekognitionStreamingVideoEvents",
        "searchKeywords": [],
        "type": "AWSService",
        "regions": [
            "ap-south-1",
            "ap-northeast-1",
            "eu-central-1",
            "eu-west-1",
            "us-east-1",
            "us-east-2",
            "us-west-2"
        ],
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/rekognitionStreamingVideoEvents/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/rekognitionStreamingVideoEvents/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "rekognitionstreamingvideoevents"
        ],
        "parentServiceCode": "amazonRekognition"
    },
    "locationServiceRouting": {
        "name": "Routing",
        "serviceCode": "locationServiceRouting",
        "description": "Amazon Location Service provides affordable data, tracking and geofencing capabilities, and native integrations with AWS services, so you can create sophisticated location-enabled applications quickly, without the high cost of custom development.",
        "searchKeywords": [
            "Location Service",
            "compromising data security",
            "user privacy",
            "asset tracking",
            "location-based marketing",
            "maps",
            "places",
            "routing",
            "tracking",
            "geofencing",
            "Service Resources"
        ],
        "type": "AWSService",
        "regions": [
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-northeast-1",
            "eu-central-1",
            "eu-west-1",
            "eu-north-1",
            "us-east-1",
            "us-east-2",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/location/",
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/locationServiceRouting/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/locationServiceRouting/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "locationservicerouting",
            "routing"
        ],
        "parentServiceCode": "locationService"
    },
    "sageMakerRStudioOnSageMaker": {
        "name": "RStudio on SageMaker",
        "serviceCode": "sageMakerRStudioOnSageMaker",
        "description": "With Amazon SageMaker, you pay only for what you use. Building, training, and deploying ML models is billed by the second, with no minimum fees and no upfront commitments.",
        "searchKeywords": [
            "Sagemaker",
            "Model",
            "ML",
            "Machine Learning",
            "EI",
            "data scientist"
        ],
        "type": "AWSService",
        "regions": [
            "ap-south-1",
            "ap-northeast-2",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-northeast-1",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "eu-west-3",
            "eu-north-1",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/sagemaker/",
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/sageMakerRStudioOnSageMaker/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/sageMakerRStudioOnSageMaker/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "rstudiosagemaker",
            "sagemakerrstudioonsagemaker"
        ],
        "parentServiceCode": "amazonSageMaker"
    },
    "amazonS3Backup": {
        "name": "S3",
        "serviceCode": "amazonS3Backup",
        "description": "AWS Backup for S3",
        "searchKeywords": [],
        "type": "AWSService",
        "regions": [
            "us-gov-west-1",
            "us-gov-east-1",
            "af-south-1",
            "ap-east-1",
            "ap-south-1",
            "ap-northeast-3",
            "ap-northeast-2",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-southeast-3",
            "ap-northeast-1",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "eu-south-1",
            "eu-west-3",
            "eu-north-1",
            "me-south-1",
            "me-central-1",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/backup/",
        "isActive": "true",
        "hasDataTransfer": true,
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonS3Backup/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/amazonS3Backup/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "backups3",
            "s3backup"
        ],
        "parentServiceCode": "awsBackup"
    },
    "amazonS3GlacierDeepArhive": {
        "name": "S3 Glacier Deep Archive",
        "serviceCode": "amazonS3GlacierDeepArhive",
        "description": "Amazon Simple Storage Service (Amazon S3) is storage for the internet. You can use Amazon S3 to store and retrieve any amount of data at any time, from anywhere on the web.",
        "searchKeywords": [
            "Storage",
            "Simple Storage Service",
            "bucket",
            "file storage",
            "cloud storage",
            "static website hosting",
            "object storage",
            "store objects",
            "store files",
            "data migration",
            "ongoing data ingestion",
            "backup and recovery",
            "big data analytics",
            "nearline archive",
            "disaster recovery",
            "content distribution",
            "cloud storage"
        ],
        "type": "AWSService",
        "regions": [
            "af-south-1",
            "ap-east-1",
            "ap-south-1",
            "ap-northeast-3",
            "ap-northeast-2",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-southeast-3",
            "ap-northeast-1",
            "us-gov-west-1",
            "us-gov-east-1",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "eu-west-3",
            "eu-north-1",
            "eu-south-1",
            "me-south-1",
            "me-central-1",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/s3/",
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonS3GlacierDeepArhive/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "mvpSupport": false,
        "comparableTerms": [
            "s3glacierdeeparchive",
            "s3glacierdeeparhive"
        ],
        "parentServiceCode": "amazonSimpleStorageServiceGroup"
    },
    "amazonS3Glacier": {
        "name": "S3 Glacier Flexible Retrieval",
        "serviceCode": "amazonS3Glacier",
        "description": "Amazon Simple Storage Service (Amazon S3) is storage for the internet. You can use Amazon S3 to store and retrieve any amount of data at any time, from anywhere on the web.",
        "searchKeywords": [
            "Storage",
            "Simple Storage Service",
            "bucket",
            "file storage",
            "cloud storage",
            "static website hosting",
            "object storage",
            "store objects",
            "store files",
            "data migration",
            "ongoing data ingestion",
            "backup and recovery",
            "big data analytics",
            "nearline archive",
            "disaster recovery",
            "content distribution",
            "cloud storage"
        ],
        "type": "AWSService",
        "regions": [
            "af-south-1",
            "ap-east-1",
            "ap-south-1",
            "ap-northeast-3",
            "ap-northeast-2",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-southeast-3",
            "ap-northeast-1",
            "us-gov-west-1",
            "us-gov-east-1",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "eu-west-3",
            "eu-north-1",
            "eu-south-1",
            "me-south-1",
            "me-central-1",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/s3",
        "isActive": "true",
        "subType": "TCOCalculator",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonS3Glacier/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "bulkImportEnabled": false,
        "serviceDefinitionUrlPath": "/data/amazonS3Glacier/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "s3glacier",
            "s3glacierflexibleretrieval"
        ],
        "parentServiceCode": "amazonSimpleStorageServiceGroup"
    },
    "s3GlacierInstantRetrieval": {
        "name": "S3 Glacier Instant Retrieval",
        "serviceCode": "s3GlacierInstantRetrieval",
        "description": "Amazon Simple Storage Service (Amazon S3) is storage for the internet. You can use Amazon S3 to store and retrieve any amount of data at any time, from anywhere on the web.",
        "searchKeywords": [
            "Storage",
            "Simple Storage Service",
            "bucket",
            "file storage",
            "cloud storage",
            "static website hosting",
            "object storage",
            "store objects",
            "store files",
            "data migration",
            "ongoing data ingestion",
            "backup and recovery",
            "big data analytics",
            "nearline archive",
            "disaster recovery",
            "content distribution",
            "cloud storage"
        ],
        "type": "AWSService",
        "regions": [
            "af-south-1",
            "ap-east-1",
            "ap-south-1",
            "ap-northeast-3",
            "ap-northeast-2",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-southeast-3",
            "ap-northeast-1",
            "us-gov-west-1",
            "us-gov-east-1",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "eu-west-3",
            "eu-north-1",
            "eu-south-1",
            "me-south-1",
            "me-central-1",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/s3/",
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/s3GlacierInstantRetrieval/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/s3GlacierInstantRetrieval/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "s3glacierinstantretrieval"
        ],
        "parentServiceCode": "amazonSimpleStorageServiceGroup"
    },
    "amazonS3IntelligentTiering": {
        "name": "S3 Intelligent - Tiering",
        "serviceCode": "amazonS3IntelligentTiering",
        "description": "Amazon Simple Storage Service (Amazon S3) is storage for the internet. You can use Amazon S3 to store and retrieve any amount of data at any time, from anywhere on the web.",
        "searchKeywords": [
            "Storage",
            "Simple Storage Service",
            "bucket",
            "file storage",
            "cloud storage",
            "static website hosting",
            "object storage",
            "store objects",
            "store files",
            "data migration",
            "ongoing data ingestion",
            "backup and recovery",
            "big data analytics",
            "nearline archive",
            "disaster recovery",
            "content distribution",
            "cloud storage"
        ],
        "type": "AWSService",
        "regions": [
            "af-south-1",
            "ap-east-1",
            "ap-south-1",
            "ap-northeast-3",
            "ap-northeast-2",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-southeast-3",
            "ap-northeast-1",
            "us-gov-west-1",
            "us-gov-east-1",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "eu-west-3",
            "eu-north-1",
            "eu-south-1",
            "me-south-1",
            "me-central-1",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/s3/",
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonS3IntelligentTiering/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/amazonS3IntelligentTiering/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "s3intelligenttiering"
        ],
        "parentServiceCode": "amazonSimpleStorageServiceGroup"
    },
    "amazonS3StorageManagement": {
        "name": "S3 Management and Analytics",
        "serviceCode": "amazonS3StorageManagement",
        "description": "S3 Storage Management and Analytics is priced per feature (Amazon S3 Inventory, S3 Storage Class Analysis, S3 Storage Lens, and S3 Object Tagging) that is enabled on your account’s bucket.",
        "searchKeywords": [
            "Storage",
            "Simple Storage Service",
            "bucket",
            "file storage",
            "cloud storage",
            "static website hosting",
            "object storage",
            "store objects",
            "store files",
            "data migration",
            "ongoing data ingestion",
            "backup and recovery",
            "big data analytics",
            "nearline archive",
            "disaster recovery",
            "content distribution",
            "cloud storage"
        ],
        "type": "AWSService",
        "regions": [
            "af-south-1",
            "ap-east-1",
            "ap-south-1",
            "ap-northeast-3",
            "ap-northeast-2",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-southeast-3",
            "ap-northeast-1",
            "us-gov-west-1",
            "us-gov-east-1",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "eu-west-3",
            "eu-north-1",
            "eu-south-1",
            "me-south-1",
            "me-central-1",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/s3/",
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonS3StorageManagement/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/amazonS3StorageManagement/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "s3managementanalytics",
            "s3storagemanagement"
        ],
        "parentServiceCode": "amazonSimpleStorageServiceGroup"
    },
    "s3ObjectLambda": {
        "name": "S3 Object Lambda",
        "serviceCode": "s3ObjectLambda",
        "description": "Amazon Simple Storage Service (Amazon S3) is storage for the internet. You can use Amazon S3 to store and retrieve any amount of data at any time, from anywhere on the web.",
        "searchKeywords": [
            "Storage",
            "Simple Storage Service",
            "bucket",
            "file storage",
            "cloud storage",
            "static website hosting",
            "object storage",
            "store objects",
            "store files",
            "data migration",
            "ongoing data ingestion",
            "backup and recovery",
            "big data analytics",
            "nearline archive",
            "disaster recovery",
            "content distribution",
            "cloud storage",
            "S3",
            "s3"
        ],
        "type": "AWSService",
        "regions": [
            "af-south-1",
            "ap-east-1",
            "ap-south-1",
            "ap-northeast-2",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-southeast-3",
            "ap-northeast-1",
            "us-gov-west-1",
            "us-gov-east-1",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "eu-west-3",
            "eu-north-1",
            "eu-south-1",
            "me-south-1",
            "me-central-1",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/s3",
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/s3ObjectLambda/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "mvpSupport": false,
        "comparableTerms": [
            "s3objectlambda"
        ],
        "parentServiceCode": "amazonSimpleStorageServiceGroup"
    },
    "s3OneZoneInfrequentAccess": {
        "name": "S3 One Zone - Infrequent Access",
        "serviceCode": "s3OneZoneInfrequentAccess",
        "description": "Amazon Simple Storage Service (Amazon S3) is storage for the internet. You can use Amazon S3 to store and retrieve any amount of data at any time, from anywhere on the web.",
        "searchKeywords": [
            "Storage",
            "Simple Storage Service",
            "bucket",
            "file storage",
            "cloud storage",
            "static website hosting",
            "object storage",
            "store objects",
            "store files",
            "data migration",
            "ongoing data ingestion",
            "backup and recovery",
            "big data analytics",
            "nearline archive",
            "disaster recovery",
            "content distribution",
            "cloud storage"
        ],
        "type": "AWSService",
        "regions": [
            "af-south-1",
            "ap-east-1",
            "ap-south-1",
            "ap-northeast-3",
            "ap-northeast-2",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-southeast-3",
            "ap-northeast-1",
            "us-gov-west-1",
            "us-gov-east-1",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "eu-west-3",
            "eu-north-1",
            "eu-south-1",
            "me-south-1",
            "me-central-1",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/s3/",
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/s3OneZoneInfrequentAccess/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "bulkImportEnabled": false,
        "serviceDefinitionUrlPath": "/data/s3OneZoneInfrequentAccess/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "s3onezoneinfrequentaccess"
        ],
        "parentServiceCode": "amazonSimpleStorageServiceGroup"
    },
    "amazonS3Standard": {
        "name": "S3 Standard",
        "serviceCode": "amazonS3Standard",
        "description": "Amazon Simple Storage Service (Amazon S3) is storage for the internet. You can use Amazon S3 to store and retrieve any amount of data at any time, from anywhere on the web.",
        "searchKeywords": [
            "Storage",
            "Simple Storage Service",
            "bucket",
            "file storage",
            "cloud storage",
            "static website hosting",
            "object storage",
            "store objects",
            "store files",
            "data migration",
            "ongoing data ingestion",
            "backup and recovery",
            "big data analytics",
            "nearline archive",
            "disaster recovery",
            "content distribution",
            "cloud storage",
            "S3",
            "s3"
        ],
        "type": "AWSService",
        "regions": [
            "af-south-1",
            "ap-east-1",
            "ap-south-1",
            "ap-northeast-3",
            "ap-northeast-2",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-southeast-3",
            "ap-northeast-1",
            "us-gov-west-1",
            "us-gov-east-1",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "eu-west-3",
            "eu-north-1",
            "eu-south-1",
            "me-south-1",
            "me-central-1",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/s3",
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonS3Standard/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "bulkImportEnabled": false,
        "serviceDefinitionUrlPath": "/data/amazonS3Standard/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "s3standard"
        ],
        "parentServiceCode": "amazonSimpleStorageServiceGroup"
    },
    "amazonS3StandardInfrequentAccess": {
        "name": "S3 Standard - Infrequent Access",
        "serviceCode": "amazonS3StandardInfrequentAccess",
        "description": "Amazon Simple Storage Service (Amazon S3) is storage for the internet. You can use Amazon S3 to store and retrieve any amount of data at any time, from anywhere on the web.",
        "searchKeywords": [
            "Storage",
            "Simple Storage Service",
            "bucket",
            "file storage",
            "cloud storage",
            "static website hosting",
            "object storage",
            "store objects",
            "store files",
            "data migration",
            "ongoing data ingestion",
            "backup and recovery",
            "big data analytics",
            "nearline archive",
            "disaster recovery",
            "content distribution",
            "cloud storage"
        ],
        "type": "AWSService",
        "regions": [
            "af-south-1",
            "ap-east-1",
            "ap-south-1",
            "ap-northeast-3",
            "ap-northeast-2",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-southeast-3",
            "ap-northeast-1",
            "us-gov-west-1",
            "us-gov-east-1",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "eu-west-3",
            "eu-north-1",
            "eu-south-1",
            "me-south-1",
            "me-central-1",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/s3/",
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonS3StandardInfrequentAccess/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "bulkImportEnabled": false,
        "serviceDefinitionUrlPath": "/data/amazonS3StandardInfrequentAccess/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "s3standardinfrequentaccess"
        ],
        "parentServiceCode": "amazonSimpleStorageServiceGroup"
    },
    "sageMakerAsynchronousInference": {
        "name": "SageMaker Asynchronous Inference",
        "serviceCode": "sageMakerAsynchronousInference",
        "description": "With Amazon SageMaker, you pay only for what you use. Building, training, and deploying ML models is billed by the second, with no minimum fees and no upfront commitments.",
        "searchKeywords": [
            "Sagemaker",
            "Model",
            "ML",
            "Machine Learning",
            "EI",
            "data scientist"
        ],
        "type": "AWSService",
        "regions": [
            "ap-east-1",
            "ap-south-1",
            "ap-northeast-2",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-northeast-1",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "eu-north-1",
            "me-south-1",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/sagemaker/",
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/sageMakerAsynchronousInference/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/sageMakerAsynchronousInference/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "sagemakerasynchronousinference"
        ],
        "parentServiceCode": "amazonSageMaker"
    },
    "sageMakerAutopilot": {
        "name": "SageMaker Autopilot",
        "serviceCode": "sageMakerAutopilot",
        "description": "With Amazon SageMaker, you pay only for what you use. Building, training, and deploying ML models is billed by the second, with no minimum fees and no upfront commitments.",
        "searchKeywords": [
            "Sagemaker",
            "Model",
            "ML",
            "Machine Learning",
            "EI",
            "data scientist",
            "Auto ML",
            "AML",
            "Autopilot"
        ],
        "type": "AWSService",
        "regions": [],
        "linkUrl": "https://aws.amazon.com/sagemaker/autopilot/?sagemaker-data-wrangler-whats-new.sort-by=item.additionalFields.postDateTime&sagemaker-data-wrangler-whats-new.sort-order=desc",
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/sageMakerAutopilot/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/sageMakerAutopilot/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "sagemakerautopilot"
        ],
        "parentServiceCode": "amazonSageMaker"
    },
    "sageMakerBatchTransform": {
        "name": "SageMaker Batch Transform",
        "serviceCode": "sageMakerBatchTransform",
        "description": "With Amazon SageMaker, you pay only for what you use. Building, training, and deploying ML models is billed by the second, with no minimum fees and no upfront commitments.",
        "searchKeywords": [
            "Sagemaker",
            "Model",
            "ML",
            "Machine Learning",
            "EI",
            "data scientist"
        ],
        "type": "AWSService",
        "regions": [
            "us-east-1",
            "eu-west-1",
            "us-west-1",
            "ap-southeast-1",
            "ap-northeast-1",
            "us-gov-west-1",
            "us-west-2",
            "sa-east-1",
            "ap-southeast-2",
            "eu-central-1",
            "ap-northeast-2",
            "ap-northeast-3",
            "ap-south-1",
            "us-east-2",
            "ca-central-1",
            "eu-west-2",
            "eu-west-3",
            "eu-north-1",
            "ap-east-1",
            "me-south-1",
            "eu-south-1",
            "af-south-1"
        ],
        "linkUrl": "https://aws.amazon.com/sagemaker/",
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/sageMakerBatchTransform/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/sageMakerBatchTransform/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "sagemakerbatchtransform"
        ],
        "parentServiceCode": "amazonSageMaker"
    },
    "sageMakerDataWrangler": {
        "name": "SageMaker Data Wrangler",
        "serviceCode": "sageMakerDataWrangler",
        "description": "With Amazon SageMaker, you pay only for what you use. Building, training, and deploying ML models is billed by the second, with no minimum fees and no upfront commitments.",
        "searchKeywords": [
            "Sagemaker",
            "Model",
            "ML",
            "Machine Learning",
            "EI",
            "data scientist"
        ],
        "type": "AWSService",
        "regions": [
            "af-south-1",
            "ap-east-1",
            "ap-south-1",
            "ap-northeast-2",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-northeast-1",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "eu-south-1",
            "eu-west-3",
            "eu-north-1",
            "me-south-1",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/sagemaker/",
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/sageMakerDataWrangler/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/sageMakerDataWrangler/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "sagemakerdatawrangler"
        ],
        "parentServiceCode": "amazonSageMaker"
    },
    "amazonSageMakerEdgeManager": {
        "name": "SageMaker Edge Manager",
        "serviceCode": "amazonSageMakerEdgeManager",
        "description": "Amazon SageMaker Edge Manager makes it easy for ML developers to optimize, secure, monitor, and maintain ML models on fleets of edge devices.",
        "searchKeywords": [
            "Sagemaker",
            "Model",
            "ML",
            "Machine Learning",
            "EI",
            "data scientist",
            "Edge Manager"
        ],
        "type": "AWSService",
        "regions": [
            "ap-northeast-1",
            "eu-central-1",
            "eu-west-1",
            "us-east-1",
            "us-east-2",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/sagemaker/edge-manager/pricing/",
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonSageMakerEdgeManager/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/amazonSageMakerEdgeManager/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "sagemakeredgemanager"
        ],
        "parentServiceCode": "amazonSageMaker"
    },
    "sageMakerFeatureStore": {
        "name": "SageMaker Feature Store",
        "serviceCode": "sageMakerFeatureStore",
        "description": "With Amazon SageMaker, you pay only for what you use. Building, training, and deploying ML models is billed by the second, with no minimum fees and no upfront commitments.",
        "searchKeywords": [
            "Sagemaker",
            "Model",
            "ML",
            "Machine Learning",
            "EI",
            "data scientist"
        ],
        "type": "AWSService",
        "regions": [
            "us-east-1",
            "eu-west-1",
            "us-west-1",
            "ap-southeast-1",
            "ap-northeast-1",
            "us-west-2",
            "sa-east-1",
            "ap-southeast-2",
            "eu-central-1",
            "ap-northeast-2",
            "ap-south-1",
            "us-east-2",
            "ca-central-1",
            "eu-west-2",
            "eu-west-3",
            "eu-north-1",
            "ap-east-1",
            "me-south-1",
            "eu-south-1",
            "af-south-1"
        ],
        "linkUrl": "https://aws.amazon.com/sagemaker/",
        "isActive": "true",
        "hasDataTransfer": true,
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/sageMakerFeatureStore/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/sageMakerFeatureStore/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "sagemakerfeaturestore"
        ],
        "parentServiceCode": "amazonSageMaker"
    },
    "sageMakerOnDemandNotebookInstances": {
        "name": "SageMaker On-Demand Notebook Instances",
        "serviceCode": "sageMakerOnDemandNotebookInstances",
        "description": "With Amazon SageMaker, you pay only for what you use. Building, training, and deploying ML models is billed by the second, with no minimum fees and no upfront commitments.",
        "searchKeywords": [
            "Sagemaker",
            "Model",
            "ML",
            "Machine Learning",
            "EI",
            "data scientist"
        ],
        "type": "AWSService",
        "regions": [
            "us-east-1",
            "eu-west-1",
            "us-west-1",
            "ap-southeast-1",
            "ap-northeast-1",
            "us-gov-west-1",
            "us-west-2",
            "sa-east-1",
            "ap-southeast-2",
            "eu-central-1",
            "ap-northeast-2",
            "ap-northeast-3",
            "ap-south-1",
            "us-east-2",
            "ca-central-1",
            "eu-west-2",
            "eu-west-3",
            "eu-north-1",
            "ap-east-1",
            "me-south-1",
            "eu-south-1",
            "af-south-1"
        ],
        "linkUrl": "https://aws.amazon.com/sagemaker/",
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/sageMakerOnDemandNotebookInstances/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/sageMakerOnDemandNotebookInstances/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "sagemakerdemandnotebookinstances",
            "sagemakerondemandnotebookinstances"
        ],
        "parentServiceCode": "amazonSageMaker"
    },
    "sageMakerProcessing": {
        "name": "SageMaker Processing",
        "serviceCode": "sageMakerProcessing",
        "description": "With Amazon SageMaker, you pay only for what you use. Building, training, and deploying ML models is billed by the second, with no minimum fees and no upfront commitments.",
        "searchKeywords": [
            "Sagemaker",
            "Model",
            "ML",
            "Machine Learning",
            "EI",
            "data scientist"
        ],
        "type": "AWSService",
        "regions": [
            "us-east-1",
            "eu-west-1",
            "us-west-1",
            "ap-southeast-1",
            "ap-northeast-1",
            "us-gov-west-1",
            "us-west-2",
            "sa-east-1",
            "ap-southeast-2",
            "eu-central-1",
            "ap-northeast-2",
            "ap-northeast-3",
            "ap-south-1",
            "us-east-2",
            "ca-central-1",
            "eu-west-2",
            "eu-west-3",
            "eu-north-1",
            "ap-east-1",
            "me-south-1",
            "eu-south-1",
            "af-south-1"
        ],
        "linkUrl": "https://aws.amazon.com/sagemaker/",
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/sageMakerProcessing/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/sageMakerProcessing/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "sagemakerprocessing"
        ],
        "parentServiceCode": "amazonSageMaker"
    },
    "sageMakerRealTimeInference": {
        "name": "SageMaker Real-Time Inference",
        "serviceCode": "sageMakerRealTimeInference",
        "description": "With Amazon SageMaker, you pay only for what you use. Building, training, and deploying ML models is billed by the second, with no minimum fees and no upfront commitments.",
        "searchKeywords": [
            "Sagemaker",
            "Model",
            "ML",
            "Machine Learning",
            "EI",
            "data scientist"
        ],
        "type": "AWSService",
        "regions": [
            "us-east-1",
            "eu-west-1",
            "us-west-1",
            "ap-southeast-1",
            "ap-northeast-1",
            "us-gov-west-1",
            "us-west-2",
            "sa-east-1",
            "ap-southeast-2",
            "eu-central-1",
            "ap-northeast-2",
            "ap-northeast-3",
            "ap-south-1",
            "us-east-2",
            "ca-central-1",
            "eu-west-2",
            "eu-west-3",
            "eu-north-1",
            "ap-east-1",
            "me-south-1",
            "eu-south-1",
            "af-south-1"
        ],
        "linkUrl": "https://aws.amazon.com/sagemaker/",
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/sageMakerRealTimeInference/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/sageMakerRealTimeInference/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "sagemakerrealtimeinference"
        ],
        "parentServiceCode": "amazonSageMaker"
    },
    "sageMakerServerlessInference": {
        "name": "SageMaker Serverless Inference",
        "serviceCode": "sageMakerServerlessInference",
        "description": "With Amazon SageMaker, you pay only for what you use. Building, training, and deploying ML models is billed by the second, with no minimum fees and no upfront commitments.",
        "searchKeywords": [
            "Sagemaker",
            "Model",
            "ML",
            "Machine Learning",
            "EI",
            "data scientist",
            "Serverless",
            "Serverless Inference"
        ],
        "type": "AWSService",
        "regions": [
            "af-south-1",
            "ap-east-1",
            "ap-northeast-1",
            "ap-northeast-2",
            "ap-northeast-3",
            "ap-south-1",
            "ap-southeast-1",
            "ap-southeast-2",
            "ca-central-1",
            "eu-central-1",
            "eu-north-1",
            "eu-south-1",
            "eu-west-1",
            "eu-west-2",
            "eu-west-3",
            "me-south-1",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/sagemaker/",
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/sageMakerServerlessInference/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/sageMakerServerlessInference/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "sagemakerserverlessinference"
        ],
        "parentServiceCode": "amazonSageMaker"
    },
    "sageMakerStudioNotebooks": {
        "name": "SageMaker Studio Notebooks",
        "serviceCode": "sageMakerStudioNotebooks",
        "description": "With Amazon SageMaker, you pay only for what you use. Building, training, and deploying ML models is billed by the second, with no minimum fees and no upfront commitments.",
        "searchKeywords": [
            "Sagemaker",
            "Model",
            "ML",
            "Machine Learning",
            "EI",
            "data scientist"
        ],
        "type": "AWSService",
        "regions": [
            "af-south-1",
            "ap-east-1",
            "ap-south-1",
            "ap-northeast-1",
            "ap-northeast-2",
            "ap-northeast-3",
            "ap-southeast-1",
            "ap-southeast-2",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "eu-south-1",
            "eu-west-3",
            "eu-north-1",
            "me-south-1",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/sagemaker/",
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/sageMakerStudioNotebooks/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/sageMakerStudioNotebooks/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "sagemakerstudionotebooks"
        ],
        "parentServiceCode": "amazonSageMaker"
    },
    "sageMakerTraining": {
        "name": "SageMaker Training",
        "serviceCode": "sageMakerTraining",
        "description": "With Amazon SageMaker, you pay only for what you use. Building, training, and deploying ML models is billed by the second, with no minimum fees and no upfront commitments.",
        "searchKeywords": [
            "Sagemaker",
            "Model",
            "ML",
            "Machine Learning",
            "EI",
            "data scientist"
        ],
        "type": "AWSService",
        "regions": [
            "us-east-1",
            "eu-west-1",
            "us-west-1",
            "ap-southeast-1",
            "ap-northeast-1",
            "us-gov-west-1",
            "us-west-2",
            "sa-east-1",
            "ap-southeast-2",
            "eu-central-1",
            "ap-northeast-2",
            "ap-northeast-3",
            "ap-south-1",
            "us-east-2",
            "ca-central-1",
            "eu-west-2",
            "eu-west-3",
            "eu-north-1",
            "ap-east-1",
            "me-south-1",
            "eu-south-1",
            "af-south-1"
        ],
        "linkUrl": "https://aws.amazon.com/sagemaker/",
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/sageMakerTraining/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/sageMakerTraining/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "sagemakertraining"
        ],
        "parentServiceCode": "amazonSageMaker"
    },
    "sentimentAnalysis": {
        "name": "Sentiment Analysis",
        "serviceCode": "sentimentAnalysis",
        "description": "With Amazon Comprehend, you only pay for what you use. You are charged based on the amount of text processed on a monthly basis. Amazon Comprehend provides natural language processing, topic modeling, and Custom Classification capabilities, enabling a broad range of applications that can analyze text.",
        "searchKeywords": [
            "Comprehend",
            "NLP",
            "Natural language processing",
            "Sentiment analysis",
            "Text analytics",
            "Entity extraction",
            "Named entity recognition",
            "NER",
            "Key phrase extraction",
            "Topic modeling",
            "Unsupervised clustering",
            "Supervised machine learning",
            "Custom entity recognition",
            "Custom classification",
            "Document classifier",
            "Personally identifiable information",
            "PII",
            "Redaction",
            "Language detection",
            "Free form text analytics"
        ],
        "type": "AWSService",
        "regions": [
            "us-gov-west-1",
            "ap-south-1",
            "ap-northeast-2",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-northeast-1",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "us-east-1",
            "us-east-2",
            "us-west-2"
        ],
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/sentimentAnalysis/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/sentimentAnalysis/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "sentimentanalysis"
        ],
        "parentServiceCode": "amazonComprehend"
    },
    "locationServiceServiceResources": {
        "name": "Service Resources",
        "serviceCode": "locationServiceServiceResources",
        "description": "Amazon Location Service provides affordable data, tracking and geofencing capabilities, and native integrations with AWS services, so you can create sophisticated location-enabled applications quickly, without the high cost of custom development.",
        "searchKeywords": [
            "Location Service",
            "compromising data security",
            "user privacy",
            "asset tracking",
            "location-based marketing",
            "maps",
            "places",
            "routing",
            "tracking",
            "geofencing",
            "Service Resources"
        ],
        "type": "AWSService",
        "regions": [
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-northeast-1",
            "eu-central-1",
            "eu-west-1",
            "eu-north-1",
            "us-east-1",
            "us-east-2",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/location/",
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/locationServiceServiceResources/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/locationServiceServiceResources/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "locationserviceserviceresources",
            "serviceresources"
        ],
        "parentServiceCode": "locationService"
    },
    "sftp": {
        "name": "SFTP",
        "serviceCode": "sftp",
        "searchKeywords": [
            "sftp",
            "FTPS",
            "as2",
            "amazon s3",
            "s3",
            "winscp",
            "filezilla",
            "cyberduck",
            "ssh",
            "transfer",
            "ftp",
            "ftp/s",
            "openssh",
            "file transfer",
            "secure file transfer",
            "ssh ftp",
            "secure shell file transfer protocol",
            "file transfer protocol"
        ],
        "type": "AWSService",
        "regions": [
            "ap-east-1",
            "ap-northeast-1",
            "ap-northeast-2",
            "ap-south-1",
            "ap-southeast-1",
            "ap-southeast-2",
            "ca-central-1",
            "eu-central-1",
            "eu-north-1",
            "eu-west-1",
            "eu-west-2",
            "eu-west-3",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2",
            "us-gov-west-1",
            "us-gov-east-1"
        ],
        "linkUrl": "https://aws.amazon.com/aws-transfer-family/",
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/sftp/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "bulkImportEnabled": false,
        "serviceDefinitionUrlPath": "/data/sftp/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "sftp"
        ],
        "parentServiceCode": "aWSTransferForSFTP"
    },
    "sipTrunking": {
        "name": "SIP Trunking",
        "serviceCode": "sipTrunking",
        "description": "Amazon Chime lets you meet, chat, and collaborate with the security of AWS. You can work seamlessly on your devices, and meet from your desk or on the go - ensuring you always stay connected.",
        "searchKeywords": [],
        "type": "AWSService",
        "regions": [
            "us-east-1",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/chime/chime-sdk",
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/sipTrunking/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/sipTrunking/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "siptrunking"
        ],
        "parentServiceCode": "amazonChimeSdk"
    },
    "snowballEdgeComputeOptimizedGpuWithEc2ComputeInstances": {
        "name": "Snowball Edge Compute Optimized GPU with EC2 Compute Instances",
        "serviceCode": "snowballEdgeComputeOptimizedGpuWithEc2ComputeInstances",
        "description": "AWS Snowball, a part of the AWS Snow Family, is an edge computing, data migration, and edge storage device that comes in two options.",
        "searchKeywords": [
            "Snow",
            "Snowball",
            "Snowball Edge",
            "Disconnected Data Transfer",
            "Edge Computing",
            "Data Export"
        ],
        "type": "AWSService",
        "regions": [
            "ap-east-1",
            "ap-south-1",
            "ap-northeast-3",
            "ap-northeast-2",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-northeast-1",
            "af-south-1",
            "us-gov-east-1",
            "us-gov-west-1",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "eu-south-1",
            "eu-west-3",
            "eu-north-1",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/snowball/",
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/snowballEdgeComputeOptimizedGpuWithEc2ComputeInstances/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/snowballEdgeComputeOptimizedGpuWithEc2ComputeInstances/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "snowballedgecomputeoptimizedgpuwithec2computeinstances"
        ],
        "parentServiceCode": "awsSnowball"
    },
    "snowballEdgeComputeOptimizedWithEc2ComputeInstances": {
        "name": "Snowball Edge Compute Optimized with EC2 Compute Instances",
        "serviceCode": "snowballEdgeComputeOptimizedWithEc2ComputeInstances",
        "description": "AWS Snowball, a part of the AWS Snow Family, is an edge computing, data migration, and edge storage device that comes in two options.",
        "searchKeywords": [
            "Snow",
            "Snowball",
            "Snowball Edge",
            "Disconnected Data Transfer",
            "Edge Computing",
            "Data Export"
        ],
        "type": "AWSService",
        "regions": [
            "ap-east-1",
            "ap-south-1",
            "ap-northeast-3",
            "ap-northeast-2",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-northeast-1",
            "af-south-1",
            "us-gov-east-1",
            "us-gov-west-1",
            "ca-central-1",
            "eu-west-1",
            "eu-west-2",
            "eu-south-1",
            "eu-west-3",
            "eu-north-1",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/snowball/",
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/snowballEdgeComputeOptimizedWithEc2ComputeInstances/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/snowballEdgeComputeOptimizedWithEc2ComputeInstances/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "snowballedgecomputeoptimizedwithec2computeinstances"
        ],
        "parentServiceCode": "awsSnowball"
    },
    "snowballEdgeStorageOptimizedDataTransferOnly": {
        "name": "Snowball Edge Storage Optimized Data Transfer Only",
        "serviceCode": "snowballEdgeStorageOptimizedDataTransferOnly",
        "description": "AWS Snowball, a part of the AWS Snow Family, is an edge computing, data migration, and edge storage device that comes in two options.",
        "searchKeywords": [
            "Snow",
            "Snowball",
            "Snowball Edge",
            "Disconnected Data Transfer",
            "Edge Computing",
            "Data Export"
        ],
        "type": "AWSService",
        "regions": [
            "ap-east-1",
            "ap-south-1",
            "ap-northeast-3",
            "ap-northeast-2",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-northeast-1",
            "af-south-1",
            "us-gov-east-1",
            "us-gov-west-1",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "eu-south-1",
            "eu-west-3",
            "eu-north-1",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/snowball/",
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/snowballEdgeStorageOptimizedDataTransferOnly/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/snowballEdgeStorageOptimizedDataTransferOnly/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "snowballedgestorageoptimizeddatatransferonly"
        ],
        "parentServiceCode": "awsSnowball"
    },
    "snowballEdgeStorageOptimizedWithEc2ComputeInstances": {
        "name": "Snowball Edge Storage Optimized with EC2 Compute Instances",
        "serviceCode": "snowballEdgeStorageOptimizedWithEc2ComputeInstances",
        "description": "AWS Snowball, a part of the AWS Snow Family, is an edge computing, data migration, and edge storage device that comes in two options.",
        "searchKeywords": [
            "Snow",
            "Snowball",
            "Snowball Edge",
            "Disconnected Data Transfer",
            "Edge Computing",
            "Data Export"
        ],
        "type": "AWSService",
        "regions": [
            "ap-east-1",
            "ap-south-1",
            "ap-northeast-3",
            "ap-northeast-2",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-northeast-1",
            "af-south-1",
            "us-gov-east-1",
            "us-gov-west-1",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "eu-south-1",
            "eu-west-3",
            "eu-north-1",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/snowball/",
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/snowballEdgeStorageOptimizedWithEc2ComputeInstances/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/snowballEdgeStorageOptimizedWithEc2ComputeInstances/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "snowballedgestorageoptimizedwithec2computeinstances"
        ],
        "parentServiceCode": "awsSnowball"
    },
    "standardBatchTranslation": {
        "name": "Standard Batch Translation",
        "serviceCode": "standardBatchTranslation",
        "description": "Amazon Translate is a neural machine translation service that delivers fast, high-quality, and affordable language translation. Neural machine translation is a form of language translation automation that uses deep learning models to deliver more accurate and more natural sounding translation than traditional statistical and rule-based translation algorithms.",
        "searchKeywords": [
            "NLP",
            "Natural language processing",
            "language transalation",
            "Text analytics",
            "Language translation",
            "Amazon translate",
            "Translate"
        ],
        "type": "AWSService",
        "regions": [
            "us-east-1",
            "eu-west-1",
            "us-west-2",
            "eu-central-1",
            "ap-northeast-2",
            "us-east-2",
            "eu-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/translate/",
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/standardBatchTranslation/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/standardBatchTranslation/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "standardbatchtranslation"
        ],
        "parentServiceCode": "amazonTranslate"
    },
    "standardRealTimeTranslation": {
        "name": "Standard Real-Time Translation",
        "serviceCode": "standardRealTimeTranslation",
        "description": "Amazon Translate is a neural machine translation service that delivers fast, high-quality, and affordable language translation. Neural machine translation is a form of language translation automation that uses deep learning models to deliver more accurate and more natural sounding translation than traditional statistical and rule-based translation algorithms.",
        "searchKeywords": [
            "NLP",
            "Natural language processing",
            "language transalation",
            "Text analytics",
            "Language translation",
            "Amazon translate",
            "Translate"
        ],
        "type": "AWSService",
        "regions": [
            "us-east-1",
            "eu-west-1",
            "us-west-1",
            "ap-southeast-1",
            "ap-northeast-1",
            "us-gov-west-1",
            "us-west-2",
            "ap-southeast-2",
            "eu-central-1",
            "ap-northeast-2",
            "ap-south-1",
            "us-east-2",
            "ca-central-1",
            "eu-west-2",
            "eu-west-3",
            "eu-north-1",
            "ap-east-1"
        ],
        "linkUrl": "https://aws.amazon.com/translate/",
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/standardRealTimeTranslation/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/standardRealTimeTranslation/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "standardrealtimetranslation"
        ],
        "parentServiceCode": "amazonTranslate"
    },
    "standardTextToSpeechTts": {
        "name": "Standard Text-to-Speech",
        "serviceCode": "standardTextToSpeechTts",
        "description": "Amazon Polly is a service that turns text into lifelike speech, allowing you to create applications that talk, and build entirely new categories of speech-enabled products.",
        "searchKeywords": [
            "polly",
            "NLP",
            "speech"
        ],
        "type": "AWSService",
        "regions": [
            "us-gov-west-1",
            "ap-east-1",
            "ap-south-1",
            "ap-northeast-2",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-northeast-1",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "eu-west-3",
            "eu-north-1",
            "me-south-1",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/polly/",
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/standardTextToSpeechTts/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/standardTextToSpeechTts/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "standardtexttospeech",
            "standardtexttospeechtts"
        ],
        "parentServiceCode": "amazonPolly"
    },
    "standardTopics": {
        "name": "Standard topics",
        "serviceCode": "standardTopics",
        "description": "Amazon Simple Notification Service (SNS) is a highly available, durable, secure, fully managed pub/sub messaging service that enables you to decouple microservices, distributed systems, and serverless applications",
        "searchKeywords": [
            "Messaging",
            "SNS",
            "notification topic",
            "publish message",
            "subscription",
            "text message",
            "sms",
            "topics",
            "push notifications",
            "push notification service queuing"
        ],
        "type": "AWSService",
        "regions": [
            "af-south-1",
            "ap-east-1",
            "ap-northeast-1",
            "ap-northeast-2",
            "ap-northeast-3",
            "ap-south-1",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-southeast-3",
            "ca-central-1",
            "eu-central-1",
            "eu-north-1",
            "eu-south-1",
            "eu-west-1",
            "eu-west-2",
            "eu-west-3",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-gov-east-1",
            "us-gov-west-1",
            "us-west-1",
            "us-west-2",
            "me-south-1",
            "me-central-1"
        ],
        "linkUrl": "https://aws.amazon.com/sns/pricing/",
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/standardTopics/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "bulkImportEnabled": false,
        "serviceDefinitionUrlPath": "/data/standardTopics/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "standardtopics"
        ],
        "parentServiceCode": "amazonSimpleNotificationService"
    },
    "stepFunctionExpress": {
        "name": "Step Functions - Express Workflows",
        "serviceCode": "stepFunctionExpress",
        "description": "AWS Step Functions is a serverless function orchestrator that makes it easy to sequence AWS Lambda functions and multiple AWS services into business-critical applications.",
        "searchKeywords": [
            "workflows",
            " workflow",
            " orchestrator",
            " orchestration",
            " serverless",
            " state machine",
            " State Machines",
            " States",
            " State",
            " Microservices",
            " application integration",
            " Amazon States Language",
            " ASL",
            " Data Science SDK",
            " data processing",
            " API orchestration",
            " DAG",
            " DAGs",
            " Step Functions",
            " Step Function",
            " Step",
            " media processing",
            " application orchestration",
            " serverless orchestration",
            " serverless workflow",
            " lambda orchestration",
            " serverless state machine",
            " asynchronous",
            " synchronous",
            " event-driven data processing",
            " event-driven",
            " event orchestration",
            " standard workflows",
            " standard workflow",
            " express workflow",
            " express workflows",
            " standard workflows",
            " error handling",
            " service integrations",
            " state management",
            " visual workflow",
            " visual monitoring",
            " high volume orchestration",
            " function",
            " functions",
            " machine learning workflow",
            " machine learning workflows",
            " JSON",
            " serverless workflows",
            " serverless workflow",
            " Business logic",
            " complex workflows",
            " data pipeline",
            " data processing",
            " decoupling",
            " decouple applications",
            " abstraction",
            " abstraction layer",
            " automation",
            " It automation",
            " connecting aws services",
            " integration of aws services",
            " coordinating AWS services",
            " managed workflows",
            " call back patterns",
            " callback pattern",
            " callback patterns",
            " call back pattern",
            " human approval",
            " manual approval",
            " human intervention",
            " EKS orchestration",
            " container orchestration",
            " short duration workflows",
            " long duration workflows",
            " short-duration workflows",
            " short-duration workflow",
            " long-running workflow",
            " long-running workflows",
            " machine-learning workflows",
            " ML workflows",
            " ML workflow",
            " API orchestration",
            " function",
            " functions",
            " compute function",
            " compute functions",
            " Lambda retry",
            " Lambda retries",
            " serverless compute",
            " parallel processing",
            " Lambda chaining",
            " error-handling",
            " retries",
            " saga pattern",
            " nested",
            " branching",
            " nesting",
            " nested pattern",
            " branching pattern",
            " nesting pattern",
            " serverless patterns",
            " event-driven patterns",
            " coordinating workflows"
        ],
        "type": "AWSService",
        "regions": [
            "us-gov-west-1",
            "us-gov-east-1",
            "af-south-1",
            "ap-east-1",
            "ap-south-1",
            "ap-northeast-2",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-southeast-3",
            "ap-northeast-1",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "eu-south-1",
            "eu-west-3",
            "eu-north-1",
            "me-south-1",
            "me-central-1",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2"
        ],
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/stepFunctionExpress/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/stepFunctionExpress/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "stepfunctionexpress",
            "stepfunctionsexpressworkflows"
        ],
        "parentServiceCode": "awsStepFunctions"
    },
    "stepFunctionStandard": {
        "name": "Step Functions - Standard Workflows",
        "serviceCode": "stepFunctionStandard",
        "description": "AWS Step Functions is a serverless function orchestrator that makes it easy to sequence AWS Lambda functions and multiple AWS services into business-critical applications.",
        "searchKeywords": [
            "workflows",
            " workflow",
            " orchestrator",
            " orchestration",
            " serverless",
            " state machine",
            " State Machines",
            " States",
            " State",
            " Microservices",
            " application integration",
            " Amazon States Language",
            " ASL",
            " Data Science SDK",
            " data processing",
            " API orchestration",
            " DAG",
            " DAGs",
            " Step Functions",
            " Step Function",
            " Step",
            " media processing",
            " application orchestration",
            " serverless orchestration",
            " serverless workflow",
            " lambda orchestration",
            " serverless state machine",
            " asynchronous",
            " synchronous",
            " event-driven data processing",
            " event-driven",
            " event orchestration",
            " standard workflows",
            " standard workflow",
            " express workflow",
            " express workflows",
            " standard workflows",
            " error handling",
            " service integrations",
            " state management",
            " visual workflow",
            " visual monitoring",
            " high volume orchestration",
            " function",
            " functions",
            " machine learning workflow",
            " machine learning workflows",
            " JSON",
            " serverless workflows",
            " serverless workflow",
            " Business logic",
            " complex workflows",
            " data pipeline",
            " data processing",
            " decoupling",
            " decouple applications",
            " abstraction",
            " abstraction layer",
            " automation",
            " It automation",
            " connecting aws services",
            " integration of aws services",
            " coordinating AWS services",
            " managed workflows",
            " call back patterns",
            " callback pattern",
            " callback patterns",
            " call back pattern",
            " human approval",
            " manual approval",
            " human intervention",
            " EKS orchestration",
            " container orchestration",
            " short duration workflows",
            " long duration workflows",
            " short-duration workflows",
            " short-duration workflow",
            " long-running workflow",
            " long-running workflows",
            " machine-learning workflows",
            " ML workflows",
            " ML workflow",
            " API orchestration",
            " function",
            " functions",
            " compute function",
            " compute functions",
            " Lambda retry",
            " Lambda retries",
            " serverless compute",
            " parallel processing",
            " Lambda chaining",
            " error-handling",
            " retries",
            " saga pattern",
            " nested",
            " branching",
            " nesting",
            " nested pattern",
            " branching pattern",
            " nesting pattern",
            " serverless patterns",
            " event-driven patterns",
            " coordinating workflows"
        ],
        "type": "AWSService",
        "regions": [
            "us-gov-west-1",
            "us-gov-east-1",
            "af-south-1",
            "ap-east-1",
            "ap-south-1",
            "ap-northeast-2",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-southeast-3",
            "ap-northeast-1",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "eu-south-1",
            "eu-west-3",
            "eu-north-1",
            "me-south-1",
            "me-central-1",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2"
        ],
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/stepFunctionStandard/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/stepFunctionStandard/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "stepfunctionsstandardworkflows",
            "stepfunctionstandard"
        ],
        "parentServiceCode": "awsStepFunctions"
    },
    "amazonStorageGatewayBackup": {
        "name": "Storage Gateway",
        "serviceCode": "amazonStorageGatewayBackup",
        "description": "AWS Backup for Storage Gateway",
        "searchKeywords": [],
        "type": "AWSService",
        "regions": [
            "us-gov-west-1",
            "us-gov-east-1",
            "af-south-1",
            "ap-east-1",
            "ap-south-1",
            "ap-northeast-3",
            "ap-northeast-2",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-southeast-3",
            "ap-northeast-1",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "eu-south-1",
            "eu-west-3",
            "eu-north-1",
            "me-south-1",
            "me-central-1",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/backup/",
        "isActive": "true",
        "hasDataTransfer": true,
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonStorageGatewayBackup/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/amazonStorageGatewayBackup/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "backupstoragegateway",
            "storagegatewaybackup"
        ],
        "parentServiceCode": "awsBackup"
    },
    "syntaxAnalysis": {
        "name": "Syntax Analysis",
        "serviceCode": "syntaxAnalysis",
        "description": "With Amazon Comprehend, you only pay for what you use. You are charged based on the amount of text processed on a monthly basis. Amazon Comprehend provides natural language processing, topic modeling, and Custom Classification capabilities, enabling a broad range of applications that can analyze text.",
        "searchKeywords": [
            "Comprehend",
            "NLP",
            "Natural language processing",
            "Sentiment analysis",
            "Text analytics",
            "Entity extraction",
            "Named entity recognition",
            "NER",
            "Key phrase extraction",
            "Topic modeling",
            "Unsupervised clustering",
            "Supervised machine learning",
            "Custom entity recognition",
            "Custom classification",
            "Document classifier",
            "Personally identifiable information",
            "PII",
            "Redaction",
            "Language detection",
            "Free form text analytics"
        ],
        "type": "AWSService",
        "regions": [
            "us-gov-west-1",
            "ap-south-1",
            "ap-northeast-2",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-northeast-1",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "us-east-1",
            "us-east-2",
            "us-west-2"
        ],
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/syntaxAnalysis/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/syntaxAnalysis/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "syntaxanalysis"
        ],
        "parentServiceCode": "amazonComprehend"
    },
    "targetedSentiment": {
        "name": "Targeted Sentiment",
        "serviceCode": "targetedSentiment",
        "description": "With Amazon Comprehend, you only pay for what you use. You are charged based on the amount of text processed on a monthly basis. Amazon Comprehend provides natural language processing, topic modeling, and Custom Classification capabilities, enabling a broad range of applications that can analyze text.",
        "searchKeywords": [
            "Comprehend",
            "NLP",
            "Natural language processing",
            "Sentiment analysis",
            "Text analytics",
            "Entity extraction",
            "Named entity recognition",
            "NER",
            "Key phrase extraction",
            "Topic modeling",
            "Unsupervised clustering",
            "Supervised machine learning",
            "Custom entity recognition",
            "Custom classification",
            "Document classifier",
            "Personally identifiable information",
            "PII",
            "Redaction",
            "Language detection",
            "Free form text analytics",
            "Targeted Sentiment"
        ],
        "type": "AWSService",
        "regions": [
            "us-gov-west-1",
            "ap-south-1",
            "ap-northeast-2",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-northeast-1",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "us-east-1",
            "us-east-2",
            "us-west-2"
        ],
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/targetedSentiment/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/targetedSentiment/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "targetedsentiment"
        ],
        "parentServiceCode": "amazonComprehend"
    },
    "comprehendTopicModeling": {
        "name": "Topic Modeling",
        "serviceCode": "comprehendTopicModeling",
        "description": "With Amazon Comprehend, you only pay for what you use. You are charged based on the amount of text processed on a monthly basis. Amazon Comprehend provides natural language processing, topic modeling, and Custom Classification capabilities, enabling a broad range of applications that can analyze text.",
        "searchKeywords": [
            "Comprehend",
            "NLP",
            "Natural language processing",
            "Sentiment analysis",
            "Text analytics",
            "Entity extraction",
            "Named entity recognition",
            "NER",
            "Key phrase extraction",
            "Topic modeling",
            "Unsupervised clustering",
            "Supervised machine learning",
            "Custom entity recognition",
            "Custom classification",
            "Document classifier",
            "Personally identifiable information",
            "PII",
            "Redaction",
            "Language detection",
            "Free form text analytics"
        ],
        "type": "AWSService",
        "regions": [
            "us-gov-west-1",
            "ap-south-1",
            "ap-northeast-2",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-northeast-1",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "us-east-1",
            "us-east-2",
            "us-west-2"
        ],
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/comprehendTopicModeling/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/comprehendTopicModeling/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "comprehendtopicmodeling",
            "topicmodeling"
        ],
        "parentServiceCode": "amazonComprehend"
    },
    "locationServiceTracking": {
        "name": "Tracking",
        "serviceCode": "locationServiceTracking",
        "description": "Amazon Location Service provides affordable data, tracking and geofencing capabilities, and native integrations with AWS services, so you can create sophisticated location-enabled applications quickly, without the high cost of custom development.",
        "searchKeywords": [
            "Location Service",
            "compromising data security",
            "user privacy",
            "asset tracking",
            "location-based marketing",
            "maps",
            "places",
            "routing",
            "tracking",
            "geofencing",
            "Service Resources"
        ],
        "type": "AWSService",
        "regions": [
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-northeast-1",
            "eu-central-1",
            "eu-west-1",
            "eu-north-1",
            "us-east-1",
            "us-east-2",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/location/",
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/locationServiceTracking/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/locationServiceTracking/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "locationservicetracking",
            "tracking"
        ],
        "parentServiceCode": "locationService"
    },
    "trafficMirroringVpc": {
        "name": "Traffic Mirroring",
        "serviceCode": "trafficMirroringVpc",
        "description": "WS Virtual Private Network solutions establish secure connections between your on-premises networks, remote offices, client devices, and the AWS global network. AWS VPN is comprised of two services: AWS Site-to-Site VPN and AWS Client VPN. Each service provides a highly-available, managed, and elastic cloud VPN solution to protect your network traffic.",
        "searchKeywords": [
            "access control",
            "ACL",
            "AWS Privatelink",
            "Cloud connectivity",
            "corporate network",
            "elastic IP",
            "Gateway load balancer",
            "home network VPN",
            "IPAM",
            "NAT",
            "NAT gateway",
            "Network Access Analyzer",
            "Network Address Translation",
            "Networking Content Delivery",
            "PrivateLink",
            "Reachability Analyzer",
            "security",
            "single tenant hardware",
            "static ip",
            "subnets",
            "Traffic mirroring",
            "Transit Gateway",
            "Virtual Private Cloud",
            "VPN"
        ],
        "type": "AWSService",
        "regions": [
            "ap-east-1",
            "ap-northeast-1",
            "ap-northeast-2",
            "ap-south-1",
            "ap-southeast-1",
            "ap-southeast-2",
            "ca-central-1",
            "eu-central-1",
            "eu-north-1",
            "eu-west-1",
            "eu-west-2",
            "eu-west-3",
            "me-south-1",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2",
            "us-gov-east-1",
            "us-gov-west-1"
        ],
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/trafficMirroringVpc/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/trafficMirroringVpc/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "trafficmirroring",
            "trafficmirroringvpc"
        ],
        "parentServiceCode": "amazonVirtualPrivateCloud"
    },
    "transitGatewayVpc": {
        "name": "Transit Gateway",
        "serviceCode": "transitGatewayVpc",
        "description": "AWS Transit Gateway connects VPCs and on-premises networks through a central hub. This simplifies your network and puts an end to complex peering relationships. It acts as a cloud router – each new connection is only made once.",
        "searchKeywords": [
            "Transit Gateway"
        ],
        "type": "AWSService",
        "regions": [
            "af-south-1",
            "ap-east-1",
            "ap-northeast-1",
            "ap-northeast-2",
            "ap-northeast-3",
            "ap-south-1",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-southeast-3",
            "ca-central-1",
            "eu-central-1",
            "eu-north-1",
            "eu-south-1",
            "eu-west-1",
            "eu-west-2",
            "eu-west-3",
            "me-south-1",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2",
            "us-gov-east-1",
            "us-gov-west-1"
        ],
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/transitGatewayVpc/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/transitGatewayVpc/en_US.json",
        "slug": "transitgatewayvpc",
        "mvpSupport": false,
        "comparableTerms": [
            "transitgateway",
            "transitgatewayvpc"
        ],
        "parentServiceCode": "amazonVirtualPrivateCloud"
    },
    "amazonVMwareBackup": {
        "name": "VMware",
        "serviceCode": "amazonVMwareBackup",
        "description": "AWS Backup for VMware",
        "searchKeywords": [],
        "type": "AWSService",
        "regions": [
            "us-gov-west-1",
            "us-gov-east-1",
            "af-south-1",
            "ap-east-1",
            "ap-south-1",
            "ap-northeast-3",
            "ap-northeast-2",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-southeast-3",
            "ap-northeast-1",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "eu-south-1",
            "eu-west-3",
            "eu-north-1",
            "me-south-1",
            "me-central-1",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/backup/",
        "isActive": "true",
        "hasDataTransfer": true,
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonVMwareBackup/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/amazonVMwareBackup/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "backupvmware",
            "vmwarebackup"
        ],
        "parentServiceCode": "awsBackup"
    },
    "vpnConnectionVpc": {
        "name": "VPN Connection",
        "serviceCode": "vpnConnectionVpc",
        "description": "WS Virtual Private Network solutions establish secure connections between your on-premises networks, remote offices, client devices, and the AWS global network. AWS VPN is comprised of two services: AWS Site-to-Site VPN and AWS Client VPN. Each service provides a highly-available, managed, and elastic cloud VPN solution to protect your network traffic.",
        "searchKeywords": [
            "access control",
            "ACL",
            "AWS Privatelink",
            "Cloud connectivity",
            "corporate network",
            "elastic IP",
            "Gateway load balancer",
            "home network VPN",
            "IPAM",
            "NAT",
            "NAT gateway",
            "Network Access Analyzer",
            "Network Address Translation",
            "Networking Content Delivery",
            "PrivateLink",
            "Reachability Analyzer",
            "security",
            "single tenant hardware",
            "static ip",
            "subnets",
            "Traffic mirroring",
            "Transit Gateway",
            "Virtual Private Cloud",
            "VPN"
        ],
        "type": "AWSService",
        "regions": [
            "af-south-1",
            "ap-east-1",
            "ap-northeast-1",
            "ap-northeast-2",
            "ap-northeast-3",
            "ap-south-1",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-southeast-3",
            "ca-central-1",
            "eu-central-1",
            "eu-north-1",
            "eu-south-1",
            "eu-west-1",
            "eu-west-2",
            "eu-west-3",
            "me-south-1",
            "me-central-1",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2",
            "us-gov-east-1",
            "us-gov-west-1"
        ],
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/vpnConnectionVpc/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/vpnConnectionVpc/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "vpnconnection",
            "vpnconnectionvpc"
        ],
        "parentServiceCode": "amazonVirtualPrivateCloud"
    },
    "webRtcMedia": {
        "name": "WebRTC Media",
        "serviceCode": "webRtcMedia",
        "description": "Amazon Chime lets you meet, chat, and collaborate with the security of AWS. You can work seamlessly on your devices, and meet from your desk or on the go - ensuring you always stay connected.",
        "searchKeywords": [],
        "type": "AWSService",
        "regions": [
            "ap-southeast-1",
            "us-gov-east-1",
            "us-gov-west-1",
            "eu-central-1",
            "us-east-1",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/chime/chime-sdk",
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/webRtcMedia/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/webRtcMedia/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "webrtcmedia"
        ],
        "parentServiceCode": "amazonChimeSdk"
    },
    "windowsWorkloads": {
        "name": "Windows Server and SQL Server on Amazon EC2",
        "serviceCode": "windowsWorkloads",
        "description": "The Windows Server and SQL Server on Amazon EC2 calculator provides a pricing estimate for specific workloads. It recommends suitable cloud deployment options and cost-saving pricing models based on licensing and infrastructure inputs.",
        "searchKeywords": [
            "EC2",
            "Windows",
            "SQL",
            "Microsoft",
            "Compute",
            "VM",
            "Database",
            "migration",
            "msft",
            "olap",
            "oltp",
            "Win",
            "DB",
            "MS",
            "DW",
            "Data Warehouse",
            "SSIS",
            "SSAS",
            "SSRS",
            "ODS"
        ],
        "type": "AWSService",
        "regions": [
            "af-south-1",
            "ap-east-1",
            "ap-northeast-1",
            "ap-northeast-2",
            "ap-northeast-3",
            "ap-south-1",
            "ap-southeast-1",
            "ap-southeast-2",
            "ca-central-1",
            "eu-central-1",
            "eu-north-1",
            "eu-south-1",
            "eu-west-1",
            "eu-west-2",
            "eu-west-3",
            "me-south-1",
            "sa-east-1",
            "us-east-1-bos-1",
            "us-east-1-iah-1",
            "us-east-1-mia-1",
            "us-east-1",
            "us-east-2",
            "us-gov-east-1",
            "us-gov-west-1",
            "us-west-1",
            "us-west-2",
            "us-west-2-lax-1",
            "us-east-1-wl1-atl1",
            "us-east-1-wl1-dfw1",
            "us-east-1-wl1-mia1",
            "us-east-1-wl1-nyc1",
            "us-east-1-wl1-was1",
            "us-west-2-wl1",
            "us-west-2-wl1-las1",
            "us-east-1-wl1"
        ],
        "linkUrl": "https://aws.amazon.com/windows/",
        "isActive": "true",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/windowsWorkloads/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "bulkImportEnabled": false,
        "serviceDefinitionUrlPath": "/data/windowsWorkloads/en_US.json",
        "slug": "EC2WinSQL",
        "mvpSupport": false,
        "comparableTerms": [
            "ec2winsql",
            "windows",
            "windowsserversqlserveronec2",
            "windowsworkloads"
        ]
    }
};
exports.PRICING_SLUGS = [
    "appmigrationsvc",
    "APIGateway",
    "Appflow",
    "AppStream",
    "Athena",
    "AuroraMySQL",
    "AuroraPostgreSQL",
    "Braket",
    "CarrierIP",
    "Chime",
    "ChimeSDK",
    "CloudFront",
    "CloudWatch",
    "CodeGuruReviewer",
    "CodeGuruReviewerv2",
    "Cognito",
    "Comprehend",
    "ComprehendMedical",
    "detective",
    "DevOpsGuru",
    "DocumentDB",
    "DynamoDB",
    "EC2",
    "ec2-enhancement",
    "EC2DedicatedHosts",
    "EKS",
    "EBS",
    "ECR",
    "EFS",
    "ElasticGraphics",
    "ElasticIP",
    "ElasticTranscoder",
    "ElastiCache",
    "EMR",
    "eventbridge",
    "filecache",
    "FinSpace",
    "forecast",
    "frauddetector",
    "FSxForLustre",
    "FSxForNetAppOntap",
    "FSxForOpenZFS",
    "FSx",
    "GameLift",
    "guardduty",
    "HealthLake",
    "Inspector",
    "Kendra",
    "KinesisDataAnalytics",
    "KinesisDataFirehose",
    "KinesisDataStreams",
    "KinesisVideoStreams",
    "lex",
    "Lightsail",
    "LookoutForMetrics",
    "LookoutVision",
    "Macie",
    "ManagedBlockchain",
    "Prometheus",
    "MSK",
    "MWAA",
    "memorydb",
    "MQ",
    "neptune",
    "OpenSearchService",
    "personalize",
    "Pinpoint",
    "polly",
    "QuickSight",
    "RDSCustomForOracle",
    "RDSCustomForSQLServer",
    "RDSMariaDB",
    "RDSMySQL",
    "amazonRDSOracle",
    "RDSPostgreSQL",
    "RDSSQLServer",
    "RDSOutposts",
    "Redshift",
    "Rekognition",
    "Route53",
    "S3Glacier",
    "SageMaker",
    "SageMakerGroundTruth",
    "SES",
    "SNS",
    "SQS",
    "S3",
    "SWF",
    "Textract",
    "Transcribe",
    "TranscribeMedical",
    "Translate",
    "VPC",
    "WorkDocs",
    "WorkMail",
    "WorkSpaces",
    "Amplify",
    "apprunner",
    "appSync",
    "Backup",
    "budgets",
    "CloudFormation",
    "CloudHSM",
    "CloudTrail",
    "CodeArtifact",
    "codebuild",
    "CodeDeploy",
    "CodePipeline",
    "Config",
    "cost-explorer",
    "datapipeline",
    "DataTransfer",
    "DMS",
    "DataSync",
    "DeepRacer",
    "DeviceFarm",
    "DirectConnect",
    "DirectoryService",
    "ElasticDisasterRecovery",
    "ElementalMediaTailor",
    "ElementalMediaConnect",
    "ElementalMediaLive",
    "ElementalMediaPackage",
    "Fargate",
    "Glue",
    "iot-analytics",
    "IoTCore",
    "IoTDeviceDefender",
    "IoTDeviceManagement",
    "iot-events",
    "greengrass",
    "IoTThingsGraph",
    "KMS",
    "LakeFormation",
    "Lambda",
    "LocationService",
    "mainframeModernization",
    "migration-hub",
    "MDC",
    "networkfirewall",
    "Outposts",
    "certificateManager",
    "SecretsManager",
    "securityHub",
    "shield",
    "simspaceweaver",
    "Snowball",
    "Snowmobile",
    "StepFunctions",
    "StorageGateway",
    "SystemsManager",
    "TransferFamily",
    "WAF",
    "wickr",
    "xray",
    "cloudwan",
    "ElasticLoadBalancing",
    "transitgatewayvpc",
    "EC2WinSQL"
];
//# sourceMappingURL=data:application/json;base64,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